/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.internal.cq.CqService;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.BaseCQCommand;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;

public class MonitorCQ
extends BaseCQCommand {
    private static final MonitorCQ singleton = new MonitorCQ();

    public static Command getCommand() {
        return singleton;
    }

    private MonitorCQ() {
    }

    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        int op = msg.getPart(0).getInt();
        if (op < 1) {
            String err = LocalizedStrings.MonitorCQ__0_THE_MONITORCQ_OPERATION_IS_INVALID.toLocalizedString(new Object[]{servConn.getName()});
            MonitorCQ.sendCqResponse((int)47, (String)err, (int)msg.getTransactionId(), null, (ServerConnection)servConn);
            return;
        }
        String regionName = null;
        if (msg.getNumberOfParts() == 2 && (regionName = msg.getPart(1).getString()) == null) {
            String err = LocalizedStrings.MonitorCQ__0_A_NULL_REGION_NAME_WAS_PASSED_FOR_MONITORCQ_OPERATION.toLocalizedString(new Object[]{servConn.getName()});
            MonitorCQ.sendCqResponse((int)47, (String)err, (int)msg.getTransactionId(), null, (ServerConnection)servConn);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received MonitorCq request from {} op: {}{}", new Object[]{servConn.getName(), servConn.getSocketString(), op, regionName != null ? " RegionName: " + regionName : ""});
        }
        try {
            CqService cqService = crHelper.getCache().getCqService();
            cqService.start();
            throw new CqException(LocalizedStrings.CqService_INVALID_CQ_MONITOR_REQUEST_RECEIVED.toLocalizedString());
        }
        catch (CqException cqe) {
            MonitorCQ.sendCqResponse((int)50, (String)"", (int)msg.getTransactionId(), (Throwable)cqe, (ServerConnection)servConn);
            return;
        }
        catch (Exception e) {
            String err = LocalizedStrings.MonitorCQ_EXCEPTION_WHILE_HANDLING_THE_MONITOR_REQUEST_OP_IS_0.toLocalizedString(new Object[]{op});
            MonitorCQ.sendCqResponse((int)50, (String)err, (int)msg.getTransactionId(), (Throwable)e, (ServerConnection)servConn);
            return;
        }
    }
}

