/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.rest.internal.web.util;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.rest.internal.web.util.JsonWriter;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.springframework.hateoas.Link;
import org.springframework.util.Assert;

public abstract class JSONUtils {
    private static AtomicReference<ObjectMapper> objectMapper = new AtomicReference<Object>(null);

    public static void setObjectMapper(ObjectMapper objectMapper) {
        JSONUtils.objectMapper.compareAndSet(null, objectMapper);
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper localObjectMapper = objectMapper.get();
        Assert.state((localObjectMapper != null ? 1 : 0) != 0, (String)"The ObjectMapper reference must not be null!");
        return localObjectMapper;
    }

    public static JsonGenerator enableDisableJSONGeneratorFeature(JsonGenerator generator) {
        generator.enable(JsonGenerator.Feature.ESCAPE_NON_ASCII);
        generator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        return generator;
    }

    public static String formulateJsonForListFunctionsCall(Set<String> functionIds) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature(JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            generator.writeStartObject();
            generator.writeFieldName("functions");
            JsonWriter.writeCollectionAsJson(generator, functionIds);
            generator.writeEndObject();
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String formulateJsonForListCall(Map<String, Link> LinksByName, String keyName, String fieldName) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature(JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            JsonWriter.writeListAsJson(generator, LinksByName, keyName, fieldName);
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String formulateJsonForListKeys(Object[] keys, String fieldName) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature(JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            generator.writeStartObject();
            generator.writeFieldName(fieldName);
            JsonWriter.writeObjectArrayAsJson(generator, keys, null);
            generator.writeEndObject();
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String formulateJsonForListRegions(Set<Region<?, ?>> regions, String fieldName) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature(JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            generator.writeStartObject();
            generator.writeFieldName(fieldName);
            JsonWriter.writeRegionSetAsJson(generator, regions);
            generator.writeEndObject();
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String formulateJsonForGetOnKey(Object value) throws JSONException {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature(JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            JsonWriter.writeValueAsJson(generator, value, "GET_ON_KEY_RESPONSE");
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String formulateJsonForGetOnMultipleKey(Collection<Object> collection, String regionName) throws JSONException {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature(JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            generator.writeStartObject();
            generator.writeFieldName(regionName);
            JsonWriter.writeCollectionAsJson(generator, collection);
            generator.writeEndObject();
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String formulateJsonForListQueriesCall(Region<String, String> queryRegion) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature(JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            JsonWriter.writeQueryListAsJson(generator, "queries", queryRegion);
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String formulateJsonForExistingQuery(String queryId, String oql) {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature(JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            JsonWriter.writeQueryAsJson(generator, queryId, oql);
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String convertCollectionToJson(Collection<Object> collection) throws JSONException {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature(JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            JsonWriter.writeCollectionAsJson(generator, collection);
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String convertMapToJson(Map<?, ?> map) throws JSONException {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature(JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            JsonWriter.writeMapAsJson(generator, map, null);
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }

    public static String convertStructToJson(StructImpl structSet) throws JSONException {
        try (HeapDataOutputStream outputStream = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator generator = JSONUtils.enableDisableJSONGeneratorFeature(JSONUtils.getObjectMapper().getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8));
            JsonWriter.writeStructAsJson(generator, structSet);
            generator.close();
            String string = new String(outputStream.toByteArray());
            return string;
        }
    }
}

