/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.rest.internal.web.http.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.Assert;

public class CustomMappingJackson2HttpMessageConverter
extends MappingJackson2HttpMessageConverter {
    protected static final int INITIAL_BYTE_ARRAY_BUFFER_SIZE = 8192;

    protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        BufferingHttpOutputMessageWrapper outputMessageWrapper = new BufferingHttpOutputMessageWrapper(outputMessage);
        super.writeInternal(object, (HttpOutputMessage)outputMessageWrapper);
        outputMessageWrapper.flush();
    }

    protected static final class ByteCountingOutputStream
    extends OutputStream {
        private AtomicLong byteCount = new AtomicLong(0L);
        private final OutputStream outputStream;

        protected ByteCountingOutputStream(OutputStream outputStream) {
            Assert.notNull((Object)outputStream, (String)"The OutputStream to wrap must not be null!");
            this.outputStream = outputStream;
        }

        protected long getByteCount() {
            return this.byteCount.get();
        }

        @Override
        public void write(int byteData) throws IOException {
            this.outputStream.write(byteData);
            this.byteCount.incrementAndGet();
        }
    }

    protected static interface HttpOutputMessageWrapper
    extends HttpOutputMessage {
        public long getContentLength();

        public void flush() throws IOException;
    }

    protected static class ContentLengthAccessibleHttpOutputMessageWrapper
    implements HttpOutputMessageWrapper {
        private final ByteCountingOutputStream outputStream;
        private final HttpOutputMessage httpOutputMessage;

        protected ContentLengthAccessibleHttpOutputMessageWrapper(HttpOutputMessage httpOutputMessage) throws IOException {
            Assert.notNull((Object)httpOutputMessage, (String)"The HttpOutputMessage instance to wrap must not be null!");
            this.httpOutputMessage = httpOutputMessage;
            this.outputStream = new ByteCountingOutputStream(this.httpOutputMessage.getBody());
        }

        public OutputStream getBody() throws IOException {
            return this.outputStream;
        }

        @Override
        public long getContentLength() {
            return this.outputStream.getByteCount();
        }

        public HttpHeaders getHeaders() {
            return this.httpOutputMessage.getHeaders();
        }

        @Override
        public void flush() throws IOException {
            this.getHeaders().setContentLength(this.getContentLength());
        }
    }

    protected static final class BufferingHttpOutputMessageWrapper
    implements HttpOutputMessageWrapper {
        private final ByteArrayOutputStream outputStream;
        private final HttpOutputMessage httpOutputMessage;

        protected BufferingHttpOutputMessageWrapper(HttpOutputMessage httpOutputMessage) {
            Assert.notNull((Object)httpOutputMessage, (String)"The HttpOutputMessage instance to wrap must not be null!");
            this.httpOutputMessage = httpOutputMessage;
            this.outputStream = new ByteArrayOutputStream(8192);
        }

        public OutputStream getBody() throws IOException {
            return this.outputStream;
        }

        @Override
        public long getContentLength() {
            return this.outputStream.size();
        }

        public HttpHeaders getHeaders() {
            return this.httpOutputMessage.getHeaders();
        }

        @Override
        public void flush() throws IOException {
            this.getHeaders().setContentLength(this.getContentLength());
            this.outputStream.writeTo(this.httpOutputMessage.getBody());
            this.outputStream.reset();
        }
    }
}

