/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.rest.internal.web.controllers.support;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gemstone.gemfire.pdx.JSONFormatter;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.rest.internal.web.util.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@XmlRootElement(name="region")
@XmlType(name="org.gopivotal.app.web.controllers.support.RegionData")
public class RegionData<T>
implements Iterable<T>,
JsonSerializable {
    private final List<T> data = new ArrayList<T>();
    private String regionNamePath;

    public RegionData() {
    }

    public RegionData(String regionNamePath) {
        this.setRegionNamePath(regionNamePath);
    }

    public String getRegionNamePath() {
        Assert.state((boolean)StringUtils.hasText((String)this.regionNamePath), (String)"The Region name/path was not properly initialized!");
        return this.regionNamePath;
    }

    public final void setRegionNamePath(String regionNamePath) {
        Assert.hasText((String)regionNamePath, (String)"The name or path of the Region must be specified!");
        this.regionNamePath = regionNamePath;
    }

    public RegionData<T> add(T data) {
        this.data.add(data);
        return this;
    }

    public RegionData<T> add(T ... data) {
        for (T element : data) {
            if (element == null) continue;
            this.add(element);
        }
        return this;
    }

    public RegionData<T> add(Iterable<T> data) {
        for (T element : data) {
            this.add(element);
        }
        return this;
    }

    public T get(int index) {
        return this.list().get(index);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list().iterator();
    }

    public List<T> list() {
        return Collections.unmodifiableList(this.data);
    }

    public int size() {
        return this.data.size();
    }

    protected String convertToJson(PdxInstance pdxObj) {
        return pdxObj != null ? JSONFormatter.toJSON((PdxInstance)pdxObj) : null;
    }

    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeArrayFieldStart(this.getRegionNamePath());
        for (T element : this) {
            JsonWriter.writeValueAsJson(jsonGenerator, element, null);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(jsonGenerator, serializerProvider);
    }
}

