/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.rest.internal.web.controllers;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryExecutionLowMemoryException;
import com.gemstone.gemfire.cache.query.QueryExecutionTimeoutException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.rest.internal.web.controllers.AbstractBaseController;
import com.gemstone.gemfire.rest.internal.web.exception.GemfireRestException;
import com.gemstone.gemfire.rest.internal.web.exception.ResourceNotFoundException;
import com.gemstone.gemfire.rest.internal.web.util.JSONUtils;
import com.gemstone.gemfire.rest.internal.web.util.ValidationUtils;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller(value="queryController")
@Api(value="queries", description="Rest api for gemfire query execution", produces="application/json")
@RequestMapping(value={"/v1/queries"})
public class QueryAccessController
extends AbstractBaseController {
    private static final Logger logger = LogService.getLogger();
    protected static final String PARAMETERIZED_QUERIES_REGION = "__ParameterizedQueries__";
    private final ConcurrentHashMap<String, DefaultQuery> compiledQueries = new ConcurrentHashMap();
    protected static final String REST_API_VERSION = "/v1";

    @Override
    protected String getRestApiVersion() {
        return REST_API_VERSION;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="list all parameterized queries", notes="List all parameterized queries by id/name", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=500, message="if GemFire throws an error or exception")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<?> list() {
        if (logger.isDebugEnabled()) {
            logger.debug("Listing all parameterized Queries in GemFire...");
        }
        Region<String, String> parameterizedQueryRegion = this.getQueryStore(PARAMETERIZED_QUERIES_REGION);
        String queryListAsJson = JSONUtils.formulateJsonForListQueriesCall(parameterizedQueryRegion);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri("queries"));
        return new ResponseEntity((Object)queryListAsJson, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ApiOperation(value="create a parameterized Query", notes="Prepare the specified parameterized query and assign the corresponding ID for lookup", response=void.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Successfully created."), @ApiResponse(code=409, message="QueryId already assigned to other query."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    public ResponseEntity<?> create(@RequestParam(value="id") String queryId, @RequestParam(value="q", required=false) String oqlInUrl, @RequestBody(required=false) String oqlInBody) {
        String oqlStatement = this.validateQuery(oqlInUrl, oqlInBody);
        if (logger.isDebugEnabled()) {
            logger.debug("Creating a named, parameterized Query ({}) with ID ({})...", new Object[]{oqlStatement, queryId});
        }
        String existingOql = (String)this.createNamedQuery(PARAMETERIZED_QUERIES_REGION, queryId, oqlStatement);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri("queries", queryId));
        if (existingOql != null) {
            headers.setContentType(MediaType.APPLICATION_JSON);
            return new ResponseEntity((Object)JSONUtils.formulateJsonForExistingQuery(queryId, existingOql), (MultiValueMap)headers, HttpStatus.CONFLICT);
        }
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/adhoc"}, produces={"application/json"})
    @ApiOperation(value="run an adhoc query", notes="Run an unnamed (unidentified), ad-hoc query passed as a URL parameter", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=500, message="GemFire throws an error or exception")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<String> runAdhocQuery(@RequestParam(value="q") String oql) {
        if (logger.isDebugEnabled()) {
            logger.debug("Running an adhoc Query ({})...", new Object[]{oql});
        }
        oql = this.decode(oql);
        Query query = this.getQueryService().newQuery(oql);
        try {
            Object queryResult = query.execute();
            return this.processQueryResponse(queryResult, "adhoc?q=" + oql);
        }
        catch (FunctionDomainException fde) {
            throw new GemfireRestException("A function was applied to a parameter that is improper for that function!", fde);
        }
        catch (TypeMismatchException tme) {
            throw new GemfireRestException("Bind parameter is not of the expected type!", tme);
        }
        catch (NameResolutionException nre) {
            throw new GemfireRestException("Name in the query cannot be resolved!", nre);
        }
        catch (IllegalArgumentException iae) {
            throw new GemfireRestException(" The number of bound parameters does not match the number of placeholders!", iae);
        }
        catch (IllegalStateException ise) {
            throw new GemfireRestException("Query is not permitted on this type of region!", ise);
        }
        catch (QueryExecutionTimeoutException qete) {
            throw new GemfireRestException("Query execution time is exceeded max query execution time (gemfire.Cache.MAX_QUERY_EXECUTION_TIME) configured! ", qete);
        }
        catch (QueryInvocationTargetException qite) {
            throw new GemfireRestException("Data referenced in from clause is not available for querying!", qite);
        }
        catch (QueryExecutionLowMemoryException qelme) {
            throw new GemfireRestException("Query execution gets canceled due to low memory conditions and the resource manager critical heap percentage has been set!", qelme);
        }
        catch (Exception e) {
            throw new GemfireRestException("Server has encountered while executing Adhoc query!", e);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{query}"}, produces={"application/json"})
    @ApiOperation(value="run parameterized query", notes="run the specified named query passing in scalar values for query parameters in the GemFire cluster", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Query successfully executed."), @ApiResponse(code=400, message="Query bind params specified as JSON document in the request body is invalid"), @ApiResponse(code=500, message="GemFire throws an error or exception")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<String> runNamedQuery(@PathVariable(value="query") String queryId, @RequestBody String arguments) {
        if (logger.isDebugEnabled()) {
            logger.debug("Running named Query with ID ({})...", new Object[]{queryId});
        }
        queryId = this.decode(queryId);
        if (arguments != null) {
            Object[] args = this.jsonToObjectArray(arguments);
            Query compiledQuery = (Query)this.compiledQueries.get(queryId);
            if (compiledQuery == null) {
                String oql = (String)this.getValue(PARAMETERIZED_QUERIES_REGION, queryId);
                ValidationUtils.returnValueThrowOnNull(oql, new ResourceNotFoundException(String.format("No Query with ID (%1$s) was found!", queryId)));
                try {
                    compiledQuery = this.getQueryService().newQuery(oql);
                }
                catch (QueryInvalidException qie) {
                    throw new GemfireRestException("Syntax of the OQL queryString is invalid!", qie);
                }
                this.compiledQueries.putIfAbsent(queryId, (DefaultQuery)compiledQuery);
            }
            try {
                Object queryResult = compiledQuery.execute(args);
                return this.processQueryResponse(queryResult, queryId);
            }
            catch (FunctionDomainException fde) {
                throw new GemfireRestException("A function was applied to a parameter that is improper for that function!", fde);
            }
            catch (TypeMismatchException tme) {
                throw new GemfireRestException("Bind parameter is not of the expected type!", tme);
            }
            catch (NameResolutionException nre) {
                throw new GemfireRestException("Name in the query cannot be resolved!", nre);
            }
            catch (IllegalArgumentException iae) {
                throw new GemfireRestException(" The number of bound parameters does not match the number of placeholders!", iae);
            }
            catch (IllegalStateException ise) {
                throw new GemfireRestException("Query is not permitted on this type of region!", ise);
            }
            catch (QueryExecutionTimeoutException qete) {
                throw new GemfireRestException("Query execution time is exceeded  max query execution time (gemfire.Cache.MAX_QUERY_EXECUTION_TIME) configured!", qete);
            }
            catch (QueryInvocationTargetException qite) {
                throw new GemfireRestException("Data referenced in from clause is not available for querying!", qite);
            }
            catch (QueryExecutionLowMemoryException qelme) {
                throw new GemfireRestException("Query gets canceled due to low memory conditions and the resource manager critical heap percentage has been set!", qelme);
            }
            catch (Exception e) {
                throw new GemfireRestException("Error encountered while executing named query!", e);
            }
        }
        throw new GemfireRestException(" Bind params either not specified or not processed properly by the server!");
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{query}"})
    @ApiOperation(value="update parameterized query", notes="Update named, parameterized query by ID", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Updated successfully."), @ApiResponse(code=404, message="queryId does not exist."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    public ResponseEntity<?> update(@PathVariable(value="query") String queryId, @RequestParam(value="q", required=false) String oqlInUrl, @RequestBody(required=false) String oqlInBody) {
        String oqlStatement = this.validateQuery(oqlInUrl, oqlInBody);
        if (logger.isDebugEnabled()) {
            logger.debug("Updating a named, parameterized Query ({}) with ID ({})...", new Object[]{oqlStatement, queryId});
        }
        this.checkForQueryIdExist(PARAMETERIZED_QUERIES_REGION, queryId);
        this.updateNamedQuery(PARAMETERIZED_QUERIES_REGION, queryId, oqlStatement);
        this.compiledQueries.remove(queryId);
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{query}"})
    @ApiOperation(value="delete parameterized query", notes="delete named, parameterized query by ID", response=void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Deleted successfully."), @ApiResponse(code=404, message="queryId does not exist."), @ApiResponse(code=500, message="GemFire throws an error or exception")})
    public ResponseEntity<?> delete(@PathVariable(value="query") String queryId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting a named, parameterized Query with ID ({}).", new Object[]{queryId});
        }
        this.deleteNamedQuery(PARAMETERIZED_QUERIES_REGION, queryId);
        this.compiledQueries.remove(queryId);
        return new ResponseEntity(HttpStatus.OK);
    }
}

