/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.PriorityQueue;

final class MinShouldMatchSumScorer
extends Scorer {
    final int minShouldMatch;
    final float[] coord;
    DisiWrapper<Scorer> lead;
    int doc;
    int freq;
    final DisiPriorityQueue<Scorer> head;
    final DisiWrapper<Scorer>[] tail;
    int tailSize;
    final Collection<Scorer.ChildScorer> childScorers;
    final long cost;

    private static long cost(Collection<Scorer> scorers, int minShouldMatch) {
        PriorityQueue<Scorer> pq = new PriorityQueue<Scorer>(scorers.size() - minShouldMatch + 1){

            @Override
            protected boolean lessThan(Scorer a, Scorer b) {
                return a.cost() > b.cost();
            }
        };
        for (Scorer scorer : scorers) {
            pq.insertWithOverflow(scorer);
        }
        long cost = 0L;
        Scorer scorer = (Scorer)pq.pop();
        while (scorer != null) {
            cost += scorer.cost();
            scorer = (Scorer)pq.pop();
        }
        return cost;
    }

    MinShouldMatchSumScorer(Weight weight, Collection<Scorer> scorers, int minShouldMatch, float[] coord) {
        super(weight);
        if (minShouldMatch > scorers.size()) {
            throw new IllegalArgumentException("minShouldMatch should be <= the number of scorers");
        }
        if (minShouldMatch < 1) {
            throw new IllegalArgumentException("minShouldMatch should be >= 1");
        }
        this.minShouldMatch = minShouldMatch;
        this.coord = coord;
        this.doc = -1;
        this.head = new DisiPriorityQueue(scorers.size() - minShouldMatch + 1);
        this.tail = new DisiWrapper[minShouldMatch - 1];
        for (Scorer scorer : scorers) {
            this.addLead(new DisiWrapper<Scorer>(scorer));
        }
        ArrayList<Scorer.ChildScorer> children = new ArrayList<Scorer.ChildScorer>();
        for (Scorer scorer : scorers) {
            children.add(new Scorer.ChildScorer(scorer, "SHOULD"));
        }
        this.childScorers = Collections.unmodifiableCollection(children);
        this.cost = MinShouldMatchSumScorer.cost(scorers, minShouldMatch);
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Override
    public final Collection<Scorer.ChildScorer> getChildren() {
        return this.childScorers;
    }

    @Override
    public int nextDoc() throws IOException {
        DisiWrapper<Scorer> s = this.lead;
        while (s != null) {
            DisiWrapper<Scorer> evicted = this.insertTailWithOverFlow(s);
            if (evicted != null) {
                evicted.doc = evicted.doc == this.doc ? ((Scorer)evicted.iterator).nextDoc() : ((Scorer)evicted.iterator).advance(this.doc + 1);
                this.head.add(evicted);
            }
            s = s.next;
        }
        this.setDocAndFreq();
        return this.doNext();
    }

    @Override
    public int advance(int target) throws IOException {
        DisiWrapper<Scorer> evicted;
        DisiWrapper<Scorer> s = this.lead;
        while (s != null) {
            evicted = this.insertTailWithOverFlow(s);
            if (evicted != null) {
                evicted.doc = ((Scorer)evicted.iterator).advance(target);
                this.head.add(evicted);
            }
            s = s.next;
        }
        DisiWrapper<Scorer> headTop = this.head.top();
        while (headTop.doc < target) {
            evicted = this.insertTailWithOverFlow(headTop);
            evicted.doc = ((Scorer)evicted.iterator).advance(target);
            headTop = this.head.updateTop(evicted);
        }
        this.setDocAndFreq();
        return this.doNext();
    }

    private void addLead(DisiWrapper<Scorer> lead) {
        lead.next = this.lead;
        this.lead = lead;
        ++this.freq;
    }

    private void pushBackLeads() throws IOException {
        DisiWrapper<Scorer> s = this.lead;
        while (s != null) {
            this.addTail(s);
            s = s.next;
        }
    }

    private void advanceTail(DisiWrapper<Scorer> top) throws IOException {
        top.doc = ((Scorer)top.iterator).advance(this.doc);
        if (top.doc == this.doc) {
            this.addLead(top);
        } else {
            this.head.add(top);
        }
    }

    private void advanceTail() throws IOException {
        DisiWrapper<Scorer> top = this.popTail();
        this.advanceTail(top);
    }

    private void setDocAndFreq() {
        assert (this.head.size() > 0);
        this.lead = this.head.pop();
        this.lead.next = null;
        this.freq = 1;
        this.doc = this.lead.doc;
        while (this.head.size() > 0 && this.head.top().doc == this.doc) {
            this.addLead(this.head.pop());
        }
    }

    private int doNext() throws IOException {
        while (this.freq < this.minShouldMatch) {
            assert (this.freq > 0);
            if (this.freq + this.tailSize >= this.minShouldMatch) {
                this.advanceTail();
                continue;
            }
            this.pushBackLeads();
            this.setDocAndFreq();
        }
        return this.doc;
    }

    private void updateFreq() throws IOException {
        assert (this.freq >= this.minShouldMatch);
        for (int i = this.tailSize - 1; i >= 0; --i) {
            this.advanceTail(this.tail[i]);
        }
        this.tailSize = 0;
    }

    @Override
    public int freq() throws IOException {
        this.updateFreq();
        return this.freq;
    }

    @Override
    public float score() throws IOException {
        this.updateFreq();
        double score = 0.0;
        DisiWrapper<Scorer> s = this.lead;
        while (s != null) {
            score += (double)((Scorer)s.iterator).score();
            s = s.next;
        }
        return this.coord[this.freq] * (float)score;
    }

    @Override
    public int docID() {
        assert (this.doc == this.lead.doc);
        return this.doc;
    }

    private DisiWrapper<Scorer> insertTailWithOverFlow(DisiWrapper<Scorer> s) {
        if (this.tailSize < this.tail.length) {
            this.addTail(s);
            return null;
        }
        if (this.tail.length >= 1) {
            DisiWrapper<Scorer> top = this.tail[0];
            if (top.cost < s.cost) {
                this.tail[0] = s;
                MinShouldMatchSumScorer.downHeapCost(this.tail, this.tailSize);
                return top;
            }
        }
        return s;
    }

    private void addTail(DisiWrapper<Scorer> s) {
        this.tail[this.tailSize] = s;
        MinShouldMatchSumScorer.upHeapCost(this.tail, this.tailSize);
        ++this.tailSize;
    }

    private DisiWrapper<Scorer> popTail() {
        assert (this.tailSize > 0);
        DisiWrapper<Scorer> result = this.tail[0];
        this.tail[0] = this.tail[--this.tailSize];
        MinShouldMatchSumScorer.downHeapCost(this.tail, this.tailSize);
        return result;
    }

    private static void upHeapCost(DisiWrapper<Scorer>[] heap, int i) {
        DisiWrapper<Scorer> node = heap[i];
        long nodeCost = node.cost;
        int j = DisiPriorityQueue.parentNode(i);
        while (j >= 0 && nodeCost < heap[j].cost) {
            heap[i] = heap[j];
            i = j;
            j = DisiPriorityQueue.parentNode(j);
        }
        heap[i] = node;
    }

    private static void downHeapCost(DisiWrapper<Scorer>[] heap, int size) {
        int i = 0;
        DisiWrapper<Scorer> node = heap[0];
        int j = DisiPriorityQueue.leftNode(i);
        if (j < size) {
            int k = DisiPriorityQueue.rightNode(j);
            if (k < size && heap[k].cost < heap[j].cost) {
                j = k;
            }
            if (heap[j].cost < node.cost) {
                do {
                    heap[i] = heap[j];
                    i = j;
                    k = DisiPriorityQueue.rightNode(j = DisiPriorityQueue.leftNode(i));
                    if (k >= size || heap[k].cost >= heap[j].cost) continue;
                    j = k;
                } while (j < size && heap[j].cost < node.cost);
                heap[i] = node;
            }
        }
    }
}

