/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.xml;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.lucene.internal.LuceneServiceImpl;
import com.gemstone.gemfire.cache.lucene.internal.xml.LuceneIndexCreation;
import com.gemstone.gemfire.internal.cache.extension.Extension;
import com.gemstone.gemfire.internal.cache.xmlcache.AbstractXmlParser;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionCreation;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuceneXmlParser
extends AbstractXmlParser {
    public String getNamspaceUri() {
        return "http://geode.apache.org/schema/lucene";
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!"http://geode.apache.org/schema/lucene".equals(uri)) {
            return;
        }
        if ("index".equals(localName)) {
            this.startIndex(atts);
        }
        if ("field".equals(localName)) {
            this.startField(atts);
        }
    }

    private void startField(Attributes atts) {
        if (this.stack.peek() instanceof StringBuffer) {
            this.stack.pop();
        }
        LuceneIndexCreation creation = (LuceneIndexCreation)this.stack.peek();
        String name = atts.getValue("name");
        creation.addField(name);
    }

    private void startIndex(Attributes atts) {
        RegionCreation region = (RegionCreation)this.stack.peek();
        RegionAttributesCreation rac = (RegionAttributesCreation)region.getAttributes();
        String name = atts.getValue("name");
        rac.addAsyncEventQueueId(LuceneServiceImpl.getUniqueIndexName(name, region.getFullPath()));
        LuceneIndexCreation indexCreation = new LuceneIndexCreation();
        indexCreation.setName(name);
        indexCreation.setRegion((Region)region);
        region.getExtensionPoint().addExtension((Extension)indexCreation);
        this.stack.push(indexCreation);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!"http://geode.apache.org/schema/lucene".equals(uri)) {
            return;
        }
        if ("index".equals(localName)) {
            this.endIndex();
        }
    }

    private void endIndex() {
        if (this.stack.peek() instanceof StringBuffer) {
            this.stack.pop();
        }
        this.stack.pop();
    }
}

