/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.xml;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.lucene.LuceneIndex;
import com.gemstone.gemfire.cache.lucene.LuceneServiceProvider;
import com.gemstone.gemfire.cache.lucene.internal.LuceneServiceImpl;
import com.gemstone.gemfire.cache.lucene.internal.xml.LuceneIndexXmlGenerator;
import com.gemstone.gemfire.internal.cache.extension.Extensible;
import com.gemstone.gemfire.internal.cache.extension.Extension;
import com.gemstone.gemfire.internal.cache.xmlcache.XmlGenerator;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneIndexCreation
implements LuceneIndex,
Extension<Region<?, ?>> {
    private Region region;
    private String name;
    private Set<String> fieldNames = new LinkedHashSet<String>();
    private Map<String, Analyzer> fieldFieldAnalyzerMap;

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Analyzer> getFieldFieldAnalyzerMap() {
        return this.fieldFieldAnalyzerMap;
    }

    public void setFieldFieldAnalyzerMap(Map<String, Analyzer> fieldFieldAnalyzerMap) {
        this.fieldFieldAnalyzerMap = fieldFieldAnalyzerMap;
    }

    @Override
    public Map<String, Analyzer> getFieldAnalyzerMap() {
        return this.fieldFieldAnalyzerMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames.toArray(new String[this.fieldNames.size()]);
    }

    @Override
    public String getRegionPath() {
        return this.region.getFullPath();
    }

    public XmlGenerator<Region<?, ?>> getXmlGenerator() {
        return new LuceneIndexXmlGenerator(this);
    }

    public void onCreate(Extensible<Region<?, ?>> source, Extensible<Region<?, ?>> target) {
        target.getExtensionPoint().addExtension((Extension)this);
        Cache cache = ((Region)target.getExtensionPoint().getTarget()).getCache();
        LuceneServiceImpl service = (LuceneServiceImpl)LuceneServiceProvider.get(cache);
        Region region = (Region)target.getExtensionPoint().getTarget();
        String aeqId = LuceneServiceImpl.getUniqueIndexName(this.getName(), this.getRegionPath());
        region.getAttributesMutator().addAsyncEventQueueId(aeqId);
        service.afterDataRegionCreated(this.getName(), (Analyzer)new StandardAnalyzer(), this.getRegionPath(), this.getFieldNames());
    }

    public void addField(String name) {
        this.fieldNames.add(name);
    }

    public void addFieldNames(String[] fieldNames) {
        this.fieldNames.addAll(Arrays.asList(fieldNames));
    }
}

