/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.repository.serializer;

import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.LuceneSerializer;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.SerializerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.lucene.document.Document;

class ReflectionLuceneSerializer
implements LuceneSerializer {
    private Field[] fields;

    public ReflectionLuceneSerializer(Class<? extends Object> clazz, String[] indexedFields) {
        HashSet<String> fieldSet = new HashSet<String>();
        fieldSet.addAll(Arrays.asList(indexedFields));
        ArrayList<Field> foundFields = new ArrayList<Field>();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                Class<?> type = field.getType();
                if (!fieldSet.contains(field.getName()) || !SerializerUtil.isSupported(type)) continue;
                field.setAccessible(true);
                foundFields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        this.fields = foundFields.toArray(new Field[foundFields.size()]);
    }

    @Override
    public void toDocument(Object value, Document doc) {
        for (Field field : this.fields) {
            try {
                Object fieldValue = field.get(value);
                SerializerUtil.addField(doc, field.getName(), fieldValue);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }
}

