/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.repository.serializer;

import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.LuceneSerializer;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.SerializerUtil;
import com.gemstone.gemfire.pdx.PdxInstance;
import org.apache.lucene.document.Document;

class PdxLuceneSerializer
implements LuceneSerializer {
    private String[] indexedFields;

    public PdxLuceneSerializer(String[] indexedFields) {
        this.indexedFields = indexedFields;
    }

    @Override
    public void toDocument(Object value, Document doc) {
        PdxInstance pdx = (PdxInstance)value;
        for (String field : this.indexedFields) {
            if (!pdx.hasField(field)) continue;
            Object fieldValue = pdx.getField(field);
            SerializerUtil.addField(doc, field, fieldValue);
        }
    }
}

