/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.repository.serializer;

import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.LuceneSerializer;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.PdxLuceneSerializer;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.ReflectionLuceneSerializer;
import com.gemstone.gemfire.internal.util.concurrent.CopyOnWriteWeakHashMap;
import com.gemstone.gemfire.pdx.PdxInstance;
import java.util.Map;
import org.apache.lucene.document.Document;

public class HeterogenousLuceneSerializer
implements LuceneSerializer {
    private String[] indexedFields;
    private LuceneSerializer pdxMapper;
    private Map<Class<?>, LuceneSerializer> mappers = new CopyOnWriteWeakHashMap();

    public HeterogenousLuceneSerializer(String[] indexedFields) {
        this.indexedFields = indexedFields;
        this.pdxMapper = new PdxLuceneSerializer(indexedFields);
    }

    @Override
    public void toDocument(Object value, Document doc) {
        LuceneSerializer mapper = this.getFieldMapper(value);
        mapper.toDocument(value, doc);
    }

    private LuceneSerializer getFieldMapper(Object value) {
        if (value instanceof PdxInstance) {
            return this.pdxMapper;
        }
        Class<?> clazz = value.getClass();
        LuceneSerializer mapper = this.mappers.get(clazz);
        if (mapper == null) {
            mapper = new ReflectionLuceneSerializer(clazz, this.indexedFields);
            this.mappers.put(clazz, mapper);
        }
        return mapper;
    }
}

