/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.distributed;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.lucene.internal.distributed.CollectorManager;
import com.gemstone.gemfire.cache.lucene.internal.distributed.EntryScore;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntries;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesCollector;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexResultCollector;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.logging.log4j.Logger;

public class TopEntriesCollectorManager
implements CollectorManager<TopEntriesCollector>,
DataSerializableFixedID {
    private static final Logger logger = LogService.getLogger();
    private int limit;
    private String id;

    public TopEntriesCollectorManager() {
        this(null, 0);
    }

    public TopEntriesCollectorManager(String id) {
        this(id, 0);
    }

    public TopEntriesCollectorManager(String id, int resultLimit) {
        this.limit = resultLimit <= 0 ? 100 : resultLimit;
        this.id = id == null ? String.valueOf(this.hashCode()) : id;
        logger.debug("Max count of entries to be produced by {} is {}", new Object[]{id, this.limit});
    }

    @Override
    public TopEntriesCollector newCollector(String name) {
        return new TopEntriesCollector(name, this.limit);
    }

    @Override
    public TopEntriesCollector reduce(Collection<TopEntriesCollector> collectors) throws IOException {
        TopEntriesCollector mergedResult = new TopEntriesCollector(this.id, this.limit);
        if (collectors.isEmpty()) {
            return mergedResult;
        }
        final TopEntries.EntryScoreComparator scoreComparator = new TopEntries().new TopEntries.EntryScoreComparator();
        Comparator<ListScanner> entryListComparator = new Comparator<ListScanner>(){

            @Override
            public int compare(ListScanner l1, ListScanner l2) {
                EntryScore o1 = l1.peek();
                EntryScore o2 = l2.peek();
                return scoreComparator.compare(o1, o2);
            }
        };
        PriorityQueue<ListScanner> entryListsPriorityQueue = new PriorityQueue<ListScanner>(collectors.size(), Collections.reverseOrder(entryListComparator));
        for (IndexResultCollector indexResultCollector : collectors) {
            logger.debug("Number of entries found in collector {} is {}", new Object[]{indexResultCollector.getName(), indexResultCollector.size()});
            if (indexResultCollector.size() <= 0) continue;
            entryListsPriorityQueue.add(new ListScanner(((TopEntriesCollector)indexResultCollector).getEntries().getHits()));
        }
        logger.debug("Only {} count of entries will be reduced. Other entries will be ignored", new Object[]{this.limit});
        while (entryListsPriorityQueue.size() > 0 && this.limit > mergedResult.size()) {
            ListScanner scanner = (ListScanner)entryListsPriorityQueue.remove();
            EntryScore entryScore = scanner.next();
            mergedResult.collect(entryScore);
            if (!scanner.hasNext()) continue;
            entryListsPriorityQueue.add(scanner);
        }
        logger.debug("Reduced size of {} is {}", new Object[]{mergedResult.getName(), mergedResult.size()});
        return mergedResult;
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return 2173;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.id, (DataOutput)out);
        out.writeInt(this.limit);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = DataSerializer.readString((DataInput)in);
        this.limit = in.readInt();
    }

    public String getId() {
        return this.id;
    }

    public int getLimit() {
        return this.limit;
    }

    static class ListScanner {
        private List<EntryScore> hits;
        private int index = 0;

        ListScanner(List<EntryScore> hits) {
            this.hits = hits;
        }

        boolean hasNext() {
            return this.index < this.hits.size();
        }

        EntryScore peek() {
            return this.hits.get(this.index);
        }

        EntryScore next() {
            return this.hits.get(this.index++);
        }
    }
}

