/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.distributed;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.lucene.LuceneQueryProvider;
import com.gemstone.gemfire.cache.lucene.internal.distributed.CollectorManager;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexResultCollector;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LuceneFunctionContext<C extends IndexResultCollector>
implements DataSerializableFixedID {
    private CollectorManager<C> manager;
    private int limit;
    private LuceneQueryProvider queryProvider;
    private String indexName;

    public LuceneFunctionContext() {
        this(null, null, null);
    }

    public LuceneFunctionContext(LuceneQueryProvider provider, String indexName) {
        this(provider, indexName, null);
    }

    public LuceneFunctionContext(LuceneQueryProvider provider, String indexName, CollectorManager<C> manager) {
        this(provider, indexName, manager, 100);
    }

    public LuceneFunctionContext(LuceneQueryProvider provider, String indexName, CollectorManager<C> manager, int limit) {
        this.queryProvider = provider;
        this.indexName = indexName;
        this.manager = manager;
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public CollectorManager<C> getCollectorManager() {
        return this.manager;
    }

    public LuceneQueryProvider getQueryProvider() {
        return this.queryProvider;
    }

    public int getDSFID() {
        return 2171;
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.limit);
        DataSerializer.writeObject((Object)this.queryProvider, (DataOutput)out);
        DataSerializer.writeObject(this.manager, (DataOutput)out);
        DataSerializer.writeString((String)this.indexName, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.limit = in.readInt();
        this.queryProvider = (LuceneQueryProvider)DataSerializer.readObject((DataInput)in);
        this.manager = (CollectorManager)DataSerializer.readObject((DataInput)in);
        this.indexName = DataSerializer.readString((DataInput)in);
    }

    public Version[] getSerializationVersions() {
        return null;
    }
}

