/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.directory;

import com.gemstone.gemfire.cache.lucene.internal.directory.FileIndexInput;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.ChunkKey;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.File;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.FileSystem;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.store.SingleInstanceLockFactory;

public class RegionDirectory
extends BaseDirectory {
    private final FileSystem fs;

    public RegionDirectory(ConcurrentMap<String, File> fileRegion, ConcurrentMap<ChunkKey, byte[]> chunkRegion) {
        super((LockFactory)new SingleInstanceLockFactory());
        this.fs = new FileSystem(fileRegion, chunkRegion);
    }

    public String[] listAll() throws IOException {
        this.ensureOpen();
        return this.fs.listFileNames().toArray(new String[0]);
    }

    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        this.fs.deleteFile(name);
    }

    public long fileLength(String name) throws IOException {
        this.ensureOpen();
        return this.fs.getFile(name).getLength();
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        File file = this.fs.createFile(name);
        OutputStream out = file.getOutputStream();
        return new OutputStreamIndexOutput(name, out, 1000);
    }

    public void sync(Collection<String> names) throws IOException {
        this.ensureOpen();
    }

    public void renameFile(String source, String dest) throws IOException {
        this.ensureOpen();
        this.fs.renameFile(source, dest);
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        File file = this.fs.getFile(name);
        return new FileIndexInput(name, file);
    }

    public void close() throws IOException {
        this.isOpen = false;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }
}

