/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.lucene.LuceneIndex;
import com.gemstone.gemfire.cache.lucene.LuceneQueryProvider;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;

public class StringQueryProvider
implements LuceneQueryProvider,
DataSerializableFixedID {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();
    private String query;
    private transient Query luceneQuery;

    public StringQueryProvider() {
        this(null);
    }

    public StringQueryProvider(String query) {
        this.query = query;
    }

    @Override
    public synchronized Query getQuery(LuceneIndex index) throws QueryException {
        if (this.luceneQuery == null) {
            String[] fields = index.getFieldNames();
            MultiFieldQueryParser parser = new MultiFieldQueryParser(fields, (Analyzer)new StandardAnalyzer());
            try {
                this.luceneQuery = parser.parse(this.query);
            }
            catch (ParseException e) {
                logger.debug("Malformed lucene query: " + this.query, (Throwable)e);
                throw new QueryException((Throwable)e);
            }
        }
        return this.luceneQuery;
    }

    public String getQueryString() {
        return this.query;
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return 2172;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.query, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.query = DataSerializer.readString((DataInput)in);
    }
}

