/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.lucene.LuceneIndex;
import com.gemstone.gemfire.cache.lucene.LuceneQueryFactory;
import com.gemstone.gemfire.cache.lucene.internal.InternalLuceneService;
import com.gemstone.gemfire.cache.lucene.internal.LuceneIndexForPartitionedRegion;
import com.gemstone.gemfire.cache.lucene.internal.LuceneIndexForReplicatedRegion;
import com.gemstone.gemfire.cache.lucene.internal.LuceneIndexImpl;
import com.gemstone.gemfire.cache.lucene.internal.LuceneQueryFactoryImpl;
import com.gemstone.gemfire.cache.lucene.internal.StringQueryProvider;
import com.gemstone.gemfire.cache.lucene.internal.distributed.EntryScore;
import com.gemstone.gemfire.cache.lucene.internal.distributed.LuceneFunction;
import com.gemstone.gemfire.cache.lucene.internal.distributed.LuceneFunctionContext;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntries;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesCollector;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesCollectorManager;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.ChunkKey;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.File;
import com.gemstone.gemfire.cache.lucene.internal.xml.LuceneServiceXmlGenerator;
import com.gemstone.gemfire.internal.DSFIDFactory;
import com.gemstone.gemfire.internal.cache.CacheService;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionListener;
import com.gemstone.gemfire.internal.cache.extension.Extensible;
import com.gemstone.gemfire.internal.cache.xmlcache.XmlGenerator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneServiceImpl
implements InternalLuceneService {
    private static final Logger logger = LogService.getLogger();
    private GemFireCacheImpl cache;
    private final HashMap<String, LuceneIndex> indexMap = new HashMap();

    public void init(Cache cache) {
        if (cache == null) {
            throw new IllegalStateException(LocalizedStrings.CqService_CACHE_IS_NULL.toLocalizedString());
        }
        GemFireCacheImpl gfc = (GemFireCacheImpl)cache;
        gfc.getCancelCriterion().checkCancelInProgress(null);
        this.cache = gfc;
        FunctionService.registerFunction((Function)new LuceneFunction());
        LuceneServiceImpl.registerDataSerializables();
    }

    public Class<? extends CacheService> getInterface() {
        return InternalLuceneService.class;
    }

    public static String getUniqueIndexName(String indexName, String regionPath) {
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        String name = indexName + "#" + regionPath.replace('/', '_');
        return name;
    }

    @Override
    public void createIndex(String indexName, String regionPath, String ... fields) {
        StandardAnalyzer analyzer = new StandardAnalyzer();
        this.createIndex(indexName, regionPath, (Analyzer)analyzer, fields);
    }

    @Override
    public void createIndex(String indexName, String regionPath, Map<String, Analyzer> analyzerPerField) {
        PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(), analyzerPerField);
        String[] fields = analyzerPerField.keySet().toArray(new String[analyzerPerField.keySet().size()]);
        this.createIndex(indexName, regionPath, (Analyzer)analyzer, fields);
    }

    private void createIndex(final String indexName, String regionPath, final Analyzer analyzer, final String ... fields) {
        Region region;
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        if ((region = this.cache.getRegion(regionPath)) != null) {
            throw new IllegalStateException("The lucene index must be created before region");
        }
        final String dataRegionPath = regionPath;
        this.cache.addRegionListener(new RegionListener(){

            public RegionAttributes beforeCreate(Region parent, String regionName, RegionAttributes attrs, InternalRegionArguments internalRegionArgs) {
                String path;
                String string = path = parent == null ? "/" + regionName : parent.getFullPath() + "/" + regionName;
                if (path.equals(dataRegionPath)) {
                    String aeqId = LuceneServiceImpl.getUniqueIndexName(indexName, dataRegionPath);
                    AttributesFactory af = new AttributesFactory(attrs);
                    af.addAsyncEventQueueId(aeqId);
                    return af.create();
                }
                return attrs;
            }

            public void afterCreate(Region region) {
                if (region.getFullPath().equals(dataRegionPath)) {
                    LuceneServiceImpl.this.afterDataRegionCreated(indexName, analyzer, dataRegionPath, fields);
                    LuceneServiceImpl.this.cache.removeRegionListener((RegionListener)this);
                }
            }
        });
    }

    public void afterDataRegionCreated(String indexName, Analyzer analyzer, String dataRegionPath, String ... fields) {
        LuceneIndexImpl index = this.createIndexRegions(indexName, dataRegionPath);
        index.setSearchableFields(fields);
        index.setAnalyzer(analyzer);
        index.initialize();
        this.registerIndex(index);
    }

    private LuceneIndexImpl createIndexRegions(String indexName, String regionPath) {
        Region dataregion = this.cache.getRegion(regionPath);
        if (dataregion == null) {
            logger.info("Data region " + regionPath + " not found");
            return null;
        }
        regionPath = dataregion.getFullPath();
        LuceneIndexImpl index = null;
        index = dataregion instanceof PartitionedRegion ? new LuceneIndexForPartitionedRegion(indexName, regionPath, (Cache)this.cache) : new LuceneIndexForReplicatedRegion(indexName, regionPath, (Cache)this.cache);
        return index;
    }

    @Override
    public LuceneIndex getIndex(String indexName, String regionPath) {
        Region region = this.cache.getRegion(regionPath);
        if (region == null) {
            return null;
        }
        return this.indexMap.get(LuceneServiceImpl.getUniqueIndexName(indexName, region.getFullPath()));
    }

    @Override
    public Collection<LuceneIndex> getAllIndexes() {
        return this.indexMap.values();
    }

    @Override
    public void destroyIndex(LuceneIndex index) {
        LuceneIndexImpl indexImpl = (LuceneIndexImpl)index;
        this.indexMap.remove(LuceneServiceImpl.getUniqueIndexName(index.getName(), index.getRegionPath()));
    }

    @Override
    public LuceneQueryFactory createLuceneQueryFactory() {
        return new LuceneQueryFactoryImpl((Cache)this.cache);
    }

    public XmlGenerator<Cache> getXmlGenerator() {
        return new LuceneServiceXmlGenerator();
    }

    public void onCreate(Extensible<Cache> source, Extensible<Cache> target) {
    }

    public void registerIndex(LuceneIndex index) {
        String regionAndIndex = LuceneServiceImpl.getUniqueIndexName(index.getName(), index.getRegionPath());
        if (!this.indexMap.containsKey(regionAndIndex)) {
            this.indexMap.put(regionAndIndex, index);
        }
    }

    public void unregisterIndex(String region) {
        if (this.indexMap.containsKey(region)) {
            this.indexMap.remove(region);
        }
    }

    public static void registerDataSerializables() {
        DSFIDFactory.registerDSFID((int)2169, ChunkKey.class);
        DSFIDFactory.registerDSFID((int)2170, File.class);
        DSFIDFactory.registerDSFID((int)2171, LuceneFunctionContext.class);
        DSFIDFactory.registerDSFID((int)2172, StringQueryProvider.class);
        DSFIDFactory.registerDSFID((int)2173, TopEntriesCollectorManager.class);
        DSFIDFactory.registerDSFID((int)2174, EntryScore.class);
        DSFIDFactory.registerDSFID((int)2175, TopEntries.class);
        DSFIDFactory.registerDSFID((int)2176, TopEntriesCollector.class);
    }
}

