/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.lucene.LuceneQuery;
import com.gemstone.gemfire.cache.lucene.LuceneQueryProvider;
import com.gemstone.gemfire.cache.lucene.LuceneQueryResults;
import com.gemstone.gemfire.cache.lucene.internal.LuceneQueryResultsImpl;
import com.gemstone.gemfire.cache.lucene.internal.distributed.LuceneFunction;
import com.gemstone.gemfire.cache.lucene.internal.distributed.LuceneFunctionContext;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntries;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesCollector;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesCollectorManager;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesFunctionCollector;

public class LuceneQueryImpl<K, V>
implements LuceneQuery<K, V> {
    private int limit = 100;
    private int pageSize = 0;
    private String indexName;
    private String[] projectedFieldNames;
    private LuceneQueryProvider query;
    private Region<K, V> region;

    public LuceneQueryImpl(String indexName, Region<K, V> region, LuceneQueryProvider provider, String[] projectionFields, int limit, int pageSize) {
        this.indexName = indexName;
        this.region = region;
        this.limit = limit;
        this.pageSize = pageSize;
        this.projectedFieldNames = projectionFields;
        this.query = provider;
    }

    @Override
    public LuceneQueryResults<K, V> search() {
        TopEntriesCollectorManager manager = new TopEntriesCollectorManager(null, this.limit);
        LuceneFunctionContext<TopEntriesCollector> context = new LuceneFunctionContext<TopEntriesCollector>(this.query, this.indexName, manager, this.limit);
        TopEntriesFunctionCollector collector = new TopEntriesFunctionCollector(context);
        ResultCollector rc = FunctionService.onRegion(this.region).withArgs(context).withCollector((ResultCollector)collector).execute(LuceneFunction.ID);
        TopEntries entries = (TopEntries)rc.getResult();
        return new LuceneQueryResultsImpl<K, V>(entries.getHits(), this.region, this.pageSize);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public String[] getProjectedFieldNames() {
        return this.projectedFieldNames;
    }
}

