/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.lucene.LuceneQuery;
import com.gemstone.gemfire.cache.lucene.LuceneQueryFactory;
import com.gemstone.gemfire.cache.lucene.LuceneQueryProvider;
import com.gemstone.gemfire.cache.lucene.internal.LuceneQueryImpl;
import com.gemstone.gemfire.cache.lucene.internal.StringQueryProvider;

public class LuceneQueryFactoryImpl
implements LuceneQueryFactory {
    private int limit = 100;
    private int pageSize = 0;
    private String[] projectionFields = null;
    private Cache cache;

    LuceneQueryFactoryImpl(Cache cache) {
        this.cache = cache;
    }

    @Override
    public LuceneQueryFactory setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public LuceneQueryFactory setResultLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public <K, V> LuceneQuery<K, V> create(String indexName, String regionName, String queryString) {
        return this.create(indexName, regionName, new StringQueryProvider(queryString));
    }

    @Override
    public <K, V> LuceneQuery<K, V> create(String indexName, String regionName, LuceneQueryProvider provider) {
        Region region = this.cache.getRegion(regionName);
        LuceneQueryImpl luceneQuery = new LuceneQueryImpl(indexName, region, provider, this.projectionFields, this.limit, this.pageSize);
        return luceneQuery;
    }

    @Override
    public LuceneQueryFactory setProjectionFields(String ... fieldNames) {
        this.projectionFields = (String[])fieldNames.clone();
        return this;
    }
}

