static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2011 Mukund Sivaraman <muks@banu.com>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"    description (_(\"Target path and filename, use '-' for stdout\"))         \n"
"                                                                              \n"
"property_int    (quality, _(\"Quality\"), 90)                                 \n"
"    description (_(\"JPEG compression quality (between 1 and 100)\"))         \n"
"    value_range (1, 100)                                                      \n"
"                                                                              \n"
"property_int    (smoothing, _(\"Smoothing\"), 0)                              \n"
"    description(_(\"Smoothing factor from 1 to 100; 0 disables smoothing\"))  \n"
"    value_range (0, 100)                                                      \n"
"                                                                              \n"
"property_boolean (optimize, _(\"Optimize\"), TRUE)                            \n"
"    description  (_(\"Use optimized huffman tables\"))                        \n"
"property_boolean (progressive, _(\"Progressive\"), TRUE)                      \n"
"    description  (_(\"Create progressive JPEG images\"))                      \n"
"property_boolean (grayscale, _(\"Grayscale\"), FALSE)                         \n"
"    description  (_(\"Create a grayscale (monochrome) image\"))               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_C_SOURCE jpg-save.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <jpeglib.h>                                                          \n"
"                                                                              \n"
"static gint                                                                   \n"
"gegl_buffer_export_jpg (GeglBuffer  *gegl_buffer,                             \n"
"                        const gchar *path,                                    \n"
"                        gint         quality,                                 \n"
"                        gint         smoothing,                               \n"
"                        gboolean     optimize,                                \n"
"                        gboolean     progressive,                             \n"
"                        gboolean     grayscale,                               \n"
"                        gint         src_x,                                   \n"
"                        gint         src_y,                                   \n"
"                        gint         width,                                   \n"
"                        gint         height)                                  \n"
"{                                                                             \n"
"  FILE *fp;                                                                   \n"
"  struct jpeg_compress_struct cinfo;                                          \n"
"  struct jpeg_error_mgr jerr;                                                 \n"
"  JSAMPROW row_pointer[1];                                                    \n"
"  const Babl *format;                                                         \n"
"                                                                              \n"
"  if (!strcmp (path, \"-\"))                                                  \n"
"    {                                                                         \n"
"      fp = stdout;                                                            \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      fp = fopen (path, \"wb\");                                              \n"
"    }                                                                         \n"
"  if (!fp)                                                                    \n"
"    {                                                                         \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  cinfo.err = jpeg_std_error (&jerr);                                         \n"
"  jpeg_create_compress (&cinfo);                                              \n"
"                                                                              \n"
"  jpeg_stdio_dest (&cinfo, fp);                                               \n"
"                                                                              \n"
"  cinfo.image_width = width;                                                  \n"
"  cinfo.image_height = height;                                                \n"
"                                                                              \n"
"  if (!grayscale)                                                             \n"
"    {                                                                         \n"
"      cinfo.input_components = 3;                                             \n"
"      cinfo.in_color_space = JCS_RGB;                                         \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      cinfo.input_components = 1;                                             \n"
"      cinfo.in_color_space = JCS_GRAYSCALE;                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  jpeg_set_defaults (&cinfo);                                                 \n"
"  jpeg_set_quality (&cinfo, quality, TRUE);                                   \n"
"  cinfo.smoothing_factor = smoothing;                                         \n"
"  cinfo.optimize_coding = optimize;                                           \n"
"  if (progressive)                                                            \n"
"    jpeg_simple_progression (&cinfo);                                         \n"
"                                                                              \n"
"  /* Use 1x1,1x1,1x1 MCUs and no subsampling */                               \n"
"  cinfo.comp_info[0].h_samp_factor = 1;                                       \n"
"  cinfo.comp_info[0].v_samp_factor = 1;                                       \n"
"                                                                              \n"
"  if (!grayscale)                                                             \n"
"    {                                                                         \n"
"      cinfo.comp_info[1].h_samp_factor = 1;                                   \n"
"      cinfo.comp_info[1].v_samp_factor = 1;                                   \n"
"      cinfo.comp_info[2].h_samp_factor = 1;                                   \n"
"      cinfo.comp_info[2].v_samp_factor = 1;                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* No restart markers */                                                    \n"
"  cinfo.restart_interval = 0;                                                 \n"
"  cinfo.restart_in_rows = 0;                                                  \n"
"                                                                              \n"
"  jpeg_start_compress (&cinfo, TRUE);                                         \n"
"                                                                              \n"
"  if (!grayscale)                                                             \n"
"    {                                                                         \n"
"      format = babl_format (\"R'G'B' u8\");                                   \n"
"      row_pointer[0] = g_malloc (width * 3);                                  \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      format = babl_format (\"Y' u8\");                                       \n"
"      row_pointer[0] = g_malloc (width);                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  while (cinfo.next_scanline < cinfo.image_height) {                          \n"
"    GeglRectangle rect;                                                       \n"
"                                                                              \n"
"    rect.x = src_x;                                                           \n"
"    rect.y = src_y + cinfo.next_scanline;                                     \n"
"    rect.width = width;                                                       \n"
"    rect.height = 1;                                                          \n"
"                                                                              \n"
"    gegl_buffer_get (gegl_buffer, &rect, 1.0, format,                         \n"
"                     row_pointer[0], GEGL_AUTO_ROWSTRIDE,                     \n"
"                     GEGL_ABYSS_NONE);                                        \n"
"                                                                              \n"
"    jpeg_write_scanlines (&cinfo, row_pointer, 1);                            \n"
"  }                                                                           \n"
"                                                                              \n"
"  jpeg_finish_compress (&cinfo);                                              \n"
"  jpeg_destroy_compress (&cinfo);                                             \n"
"                                                                              \n"
"  g_free (row_pointer[0]);                                                    \n"
"                                                                              \n"
"  if (stdout != fp)                                                           \n"
"    fclose (fp);                                                              \n"
"                                                                              \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gegl_jpg_save_process (GeglOperation       *operation,                        \n"
"                       GeglBuffer          *input,                            \n"
"                       const GeglRectangle *result,                           \n"
"                       int                  level)                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  gegl_buffer_export_jpg (input, o->path, o->quality, o->smoothing,           \n"
"                          o->optimize, o->progressive, o->grayscale,          \n"
"                          result->x, result->y,                               \n"
"                          result->width, result->height);                     \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process    = gegl_jpg_save_process;                             \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:jpg-save\",                                      \n"
"    \"title\",        _(\"JPEG File Saver\"),                                 \n"
"    \"categories\", \"output\",                                               \n"
"    \"description\",                                                          \n"
"    _(\"JPEG image saver, using libjpeg\"),                                   \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_operation_handlers_register_saver (                                    \n"
"    \".jpeg\", \"gegl:jpg-save\");                                            \n"
"  gegl_operation_handlers_register_saver (                                    \n"
"    \".jpg\", \"gegl:jpg-save\");                                             \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
