static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1996 Federico Mena Quintero <federico@nuclecu.unam.mx>           \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_boolean (keep_colors, _(\"Keep colors\"), TRUE)                      \n"
"    description(_(\"Impact each channel with the same amount\"))              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE stretch-contrast.c                                   \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"buffer_get_min_max (GeglBuffer *buffer,                                       \n"
"                    gfloat     *min,                                          \n"
"                    gfloat     *max)                                          \n"
"{                                                                             \n"
"  GeglBufferIterator *gi;                                                     \n"
"  gint c;                                                                     \n"
"  gi = gegl_buffer_iterator_new (buffer, NULL, 0, babl_format (\"RGB float\"),\n"
"                                 GEGL_ACCESS_READ, GEGL_ABYSS_NONE);          \n"
"  for (c = 0; c < 3; c++)                                                     \n"
"    {                                                                         \n"
"      min[c] =  G_MAXFLOAT;                                                   \n"
"      max[c] = -G_MAXFLOAT;                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (gi))                                      \n"
"    {                                                                         \n"
"      gfloat *buf = gi->data[0];                                              \n"
"                                                                              \n"
"      gint i;                                                                 \n"
"      for (i = 0; i < gi->length; i++)                                        \n"
"        {                                                                     \n"
"          for (c = 0; c < 3; c++)                                             \n"
"            {                                                                 \n"
"              min[c] = MIN (buf [i * 3 + c], min[c]);                         \n"
"              max[c] = MAX (buf [i * 3 + c], max[c]);                         \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"reduce_min_max_global (gfloat *min,                                           \n"
"                       gfloat *max)                                           \n"
"{                                                                             \n"
"  gfloat vmin, vmax;                                                          \n"
"  gint   c;                                                                   \n"
"                                                                              \n"
"  vmin= min[0];                                                               \n"
"  vmax= max[0];                                                               \n"
"                                                                              \n"
"  for (c = 1; c < 3; c++)                                                     \n"
"    {                                                                         \n"
"      vmin = MIN (min[c], vmin);                                              \n"
"      vmax = MAX (max[c], vmax);                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  for (c = 0; c < 3; c++)                                                     \n"
"    {                                                                         \n"
"      min[c] = vmin;                                                          \n"
"      max[c] = vmax;                                                          \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  /* Don't request an infinite plane */                                       \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"gegl-buffer-cl-iterator.h\"                                        \n"
"#include \"opencl/stretch-contrast.cl.h\"                                     \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_build_kernels (void)                                                       \n"
"{                                                                             \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"two_stages_local_min_max_reduce\",       \n"
"                                   \"global_min_max_reduce\",                 \n"
"                                   \"cl_stretch_contrast\",                   \n"
"                                   \"init_stretch\",                          \n"
"                                   NULL};                                     \n"
"      cl_data = gegl_cl_compile_and_build (stretch_contrast_cl_source, kernel_name);\n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_buffer_get_min_max (cl_mem               in_tex,                           \n"
"                       size_t               global_worksize,                  \n"
"                       const GeglRectangle *roi,                              \n"
"                       gfloat              min[4],                            \n"
"                       gfloat              max[4])                            \n"
"{                                                                             \n"
"  cl_int   cl_err      = 0;                                                   \n"
"  size_t   local_ws, max_local_ws;                                            \n"
"  size_t   work_groups;                                                       \n"
"  size_t   global_ws;                                                         \n"
"  cl_mem   cl_aux_min  = NULL;                                                \n"
"  cl_mem   cl_aux_max  = NULL;                                                \n"
"  cl_mem   cl_min_max  = NULL;                                                \n"
"  cl_int   n_pixels    = (cl_int)global_worksize;                             \n"
"  cl_float4 min_max_buf[2];                                                   \n"
"                                                                              \n"
"  if (global_worksize < 1)                                                    \n"
"    {                                                                         \n"
"      min[0] = min[1] = min[2] = min[3] =  G_MAXFLOAT;                        \n"
"      max[0] = max[1] = max[2] = max[3] = -G_MAXFLOAT;                        \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  cl_err = gegl_clGetDeviceInfo (gegl_cl_get_device (),                       \n"
"                                 CL_DEVICE_MAX_WORK_GROUP_SIZE,               \n"
"                                 sizeof (size_t), &max_local_ws, NULL);       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  max_local_ws = MIN (max_local_ws,                                           \n"
"                      MIN (cl_data->work_group_size[0],                       \n"
"                           cl_data->work_group_size[1]));                     \n"
"                                                                              \n"
"  /* Needs to be a power of two */                                            \n"
"  local_ws = 256;                                                             \n"
"  while (local_ws > max_local_ws)                                             \n"
"    local_ws /= 2;                                                            \n"
"                                                                              \n"
"  work_groups = MIN ((global_worksize + local_ws - 1) / local_ws, local_ws);  \n"
"  global_ws = work_groups * local_ws;                                         \n"
"                                                                              \n"
"                                                                              \n"
"  cl_aux_min = gegl_clCreateBuffer (gegl_cl_get_context (),                   \n"
"                                    CL_MEM_READ_WRITE,                        \n"
"                                    local_ws * sizeof(cl_float4),             \n"
"                                    NULL, &cl_err);                           \n"
"  CL_CHECK;                                                                   \n"
"  cl_aux_max = gegl_clCreateBuffer (gegl_cl_get_context (),                   \n"
"                                    CL_MEM_READ_WRITE,                        \n"
"                                    local_ws * sizeof(cl_float4),             \n"
"                                    NULL, &cl_err);                           \n"
"  CL_CHECK;                                                                   \n"
"  cl_min_max = gegl_clCreateBuffer (gegl_cl_get_context (),                   \n"
"                                    CL_MEM_WRITE_ONLY,                        \n"
"                                    2 * sizeof(cl_float4),                    \n"
"                                    NULL, &cl_err);                           \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  /* The full initialization is done in the two_stages_local_min_max_reduce   \n"
"     kernel */                                                                \n"
"#if 0                                                                         \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[3], 0, sizeof(cl_mem),         \n"
"                               (void*)&cl_aux_min);                           \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[3], 1, sizeof(cl_mem),         \n"
"                               (void*)&cl_aux_max);                           \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                       cl_data->kernel[3], 1,                 \n"
"                                       NULL, &local_ws, &local_ws,            \n"
"                                       0, NULL, NULL);                        \n"
"  CL_CHECK;                                                                   \n"
"#endif                                                                        \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem),         \n"
"                               (void*)&in_tex);                               \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_mem),         \n"
"                               (void*)&cl_aux_min);                           \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_mem),         \n"
"                               (void*)&cl_aux_max);                           \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3,                         \n"
"                               sizeof(cl_float4) * local_ws, NULL);           \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 4,                         \n"
"                               sizeof(cl_float4) * local_ws, NULL);           \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 5, sizeof(cl_int),         \n"
"                               (void*)&n_pixels);                             \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                       cl_data->kernel[0], 1,                 \n"
"                                       NULL, &global_ws, &local_ws,           \n"
"                                       0, NULL, NULL);                        \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[1], 0, sizeof(cl_mem),         \n"
"                               (void*)&cl_aux_min);                           \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[1], 1, sizeof(cl_mem),         \n"
"                               (void*)&cl_aux_max);                           \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[1], 2, sizeof(cl_mem),         \n"
"                               (void*)&cl_min_max);                           \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  /* Only one work group */                                                   \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[1], 1,                \n"
"                                        NULL, &local_ws, &local_ws,           \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  /* Read the memory buffer, probably better to keep it in GPU memory */      \n"
"  cl_err = gegl_clEnqueueReadBuffer (gegl_cl_get_command_queue (),            \n"
"                                     cl_min_max, CL_TRUE, 0,                  \n"
"                                     2 * sizeof (cl_float4), &min_max_buf, 0, \n"
"                                     NULL, NULL);                             \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  min[0] = min_max_buf[0].x;                                                  \n"
"  min[1] = min_max_buf[0].y;                                                  \n"
"  min[2] = min_max_buf[0].z;                                                  \n"
"  min[3] = min_max_buf[0].w;                                                  \n"
"                                                                              \n"
"  max[0] = min_max_buf[1].x;                                                  \n"
"  max[1] = min_max_buf[1].y;                                                  \n"
"  max[2] = min_max_buf[1].z;                                                  \n"
"  max[3] = min_max_buf[1].w;                                                  \n"
"                                                                              \n"
"  cl_err = gegl_clReleaseMemObject (cl_aux_min);                              \n"
"  CL_CHECK_ONLY (cl_err);                                                     \n"
"                                                                              \n"
"  cl_err = gegl_clReleaseMemObject (cl_aux_max);                              \n"
"  CL_CHECK_ONLY (cl_err);                                                     \n"
"                                                                              \n"
"  cl_err = gegl_clReleaseMemObject (cl_min_max);                              \n"
"  CL_CHECK_ONLY (cl_err);                                                     \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  if (cl_aux_min)                                                             \n"
"    gegl_clReleaseMemObject (cl_aux_min);                                     \n"
"  if (cl_aux_max)                                                             \n"
"    gegl_clReleaseMemObject (cl_aux_max);                                     \n"
"  if (cl_min_max)                                                             \n"
"    gegl_clReleaseMemObject (cl_min_max);                                     \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_stretch_contrast (cl_mem               in_tex,                             \n"
"                     cl_mem               out_tex,                            \n"
"                     size_t               global_worksize,                    \n"
"                     const GeglRectangle *roi,                                \n"
"                     cl_float4            min,                                \n"
"                     cl_float4            diff)                               \n"
"{                                                                             \n"
"  cl_int cl_err  = 0;                                                         \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[2], 0, sizeof(cl_mem),         \n"
"                               (void*)&in_tex);                               \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[2], 1, sizeof(cl_mem),         \n"
"                               (void*)&out_tex);                              \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[2], 2, sizeof(cl_float4),      \n"
"                               (void*)&min);                                  \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[2], 3, sizeof(cl_float4),      \n"
"                               (void*)&diff);                                 \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                       cl_data->kernel[2], 1,                 \n"
"                                       NULL, &global_worksize, NULL,          \n"
"                                       0, NULL, NULL);                        \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
" error:                                                                       \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result)                                      \n"
"{                                                                             \n"
"  const Babl *in_format  = gegl_operation_get_format (operation, \"input\");  \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"                                                                              \n"
"  gfloat    min[] = {1.0f, 1.0f, 1.0f, 1.0f};                                 \n"
"  gfloat    max[] = {0.0f, 0.0f, 0.0f, 0.0f};                                 \n"
"  gfloat    i_min[4], i_max[4], diff[4];                                      \n"
"  cl_int    err = 0;                                                          \n"
"  gint      read, c;                                                          \n"
"  GeglBufferClIterator *i;                                                    \n"
"  GeglProperties           *o;                                                \n"
"  cl_float4 cl_min, cl_diff;                                                  \n"
"                                                                              \n"
"  o = GEGL_PROPERTIES (operation);                                            \n"
"                                                                              \n"
"  if (cl_build_kernels ())                                                    \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  i = gegl_buffer_cl_iterator_new (input,                                     \n"
"                                   result,                                    \n"
"                                   in_format,                                 \n"
"                                   GEGL_CL_BUFFER_READ);                      \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err) && !err)                      \n"
"    {                                                                         \n"
"      err = cl_buffer_get_min_max (i->tex[0],                                 \n"
"                                   i->size[0],                                \n"
"                                   &i->roi[0],                                \n"
"                                   i_min,                                     \n"
"                                   i_max);                                    \n"
"      if (err)                                                                \n"
"        {                                                                     \n"
"          gegl_buffer_cl_iterator_stop (i);                                   \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      for (c = 0; c < 3; c++)                                                 \n"
"        {                                                                     \n"
"          if (i_min[c] < min[c])                                              \n"
"            min[c] = i_min[c];                                                \n"
"          if (i_max[c] > max[c])                                              \n"
"            max[c] = i_max[c];                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (err)                                                                    \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  if (o->keep_colors)                                                         \n"
"    reduce_min_max_global (min, max);                                         \n"
"                                                                              \n"
"  for (c = 0; c < 3; c ++)                                                    \n"
"    {                                                                         \n"
"      diff[c] = max[c] - min[c];                                              \n"
"                                                                              \n"
"      /* Avoid a divide by zero error if the image is a solid color */        \n"
"      if (diff[c] < 1e-3)                                                     \n"
"        {                                                                     \n"
"          min[c]  = 0.0;                                                      \n"
"          diff[c] = 1.0;                                                      \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  cl_diff.x = diff[0];                                                        \n"
"  cl_diff.y = diff[1];                                                        \n"
"  cl_diff.z = diff[2];                                                        \n"
"  cl_diff.w = 1.0;                                                            \n"
"                                                                              \n"
"  cl_min.x = min[0];                                                          \n"
"  cl_min.y = min[1];                                                          \n"
"  cl_min.z = min[2];                                                          \n"
"  cl_min.w = 0.0;                                                             \n"
"                                                                              \n"
"  i = gegl_buffer_cl_iterator_new (output,                                    \n"
"                                   result,                                    \n"
"                                   out_format,                                \n"
"                                   GEGL_CL_BUFFER_WRITE);                     \n"
"                                                                              \n"
"  read = gegl_buffer_cl_iterator_add_2 (i,                                    \n"
"                                        input,                                \n"
"                                        result,                               \n"
"                                        in_format,                            \n"
"                                        GEGL_CL_BUFFER_READ,                  \n"
"                                        0,                                    \n"
"                                        0,                                    \n"
"                                        0,                                    \n"
"                                        0,                                    \n"
"                                        GEGL_ABYSS_NONE);                     \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err) && !err)                      \n"
"    {                                                                         \n"
"      err = cl_stretch_contrast (i->tex[read],                                \n"
"                                 i->tex[0],                                   \n"
"                                 i->size[0],                                  \n"
"                                 &i->roi[0],                                  \n"
"                                 cl_min,                                      \n"
"                                 cl_diff);                                    \n"
"                                                                              \n"
"      if (err)                                                                \n"
"        {                                                                     \n"
"          gegl_buffer_cl_iterator_stop (i);                                   \n"
"          break;                                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return !err;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  gfloat  min[3], max[3], diff[3];                                            \n"
"  GeglBufferIterator *gi;                                                     \n"
"  GeglProperties         *o;                                                  \n"
"  gint                c;                                                      \n"
"                                                                              \n"
"  if (gegl_cl_is_accelerated ())                                              \n"
"    if (cl_process (operation, input, output, result))                        \n"
"      return TRUE;                                                            \n"
"                                                                              \n"
"  o = GEGL_PROPERTIES (operation);                                            \n"
"                                                                              \n"
"  buffer_get_min_max (input, min, max);                                       \n"
"                                                                              \n"
"  if (o->keep_colors)                                                         \n"
"    reduce_min_max_global (min, max);                                         \n"
"                                                                              \n"
"  for (c = 0; c < 3; c++)                                                     \n"
"    {                                                                         \n"
"      diff[c] = max[c] - min[c];                                              \n"
"                                                                              \n"
"      /* Avoid a divide by zero error if the image is a solid color */        \n"
"      if (diff[c] < 1e-3)                                                     \n"
"        {                                                                     \n"
"          min[c]  = 0.0;                                                      \n"
"          diff[c] = 1.0;                                                      \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gi = gegl_buffer_iterator_new (input, result, 0, babl_format (\"RGBA float\"),\n"
"                                 GEGL_ACCESS_READ, GEGL_ABYSS_NONE);          \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (gi, output, result, 0, babl_format (\"RGBA float\"),\n"
"                            GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);              \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (gi))                                      \n"
"    {                                                                         \n"
"      gfloat *in  = gi->data[0];                                              \n"
"      gfloat *out = gi->data[1];                                              \n"
"                                                                              \n"
"      gint o;                                                                 \n"
"      for (o = 0; o < gi->length; o++)                                        \n"
"        {                                                                     \n"
"          for (c = 0; c < 3; c++)                                             \n"
"            out[c] = (in[c] - min[c]) / diff[c];                              \n"
"                                                                              \n"
"          out[3] = in[3];                                                     \n"
"                                                                              \n"
"          in  += 4;                                                           \n"
"          out += 4;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"/* Pass-through when trying to perform a reduction on an infinite plane       \n"
" */                                                                           \n"
"static gboolean                                                               \n"
"operation_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_prop,                         \n"
"                   const GeglRectangle  *result,                              \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglOperationClass  *operation_class;                                       \n"
"                                                                              \n"
"  const GeglRectangle *in_rect =                                              \n"
"    gegl_operation_source_get_bounding_box (operation, \"input\");            \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (gegl_op_parent_class);              \n"
"                                                                              \n"
"  if (in_rect && gegl_rectangle_is_infinite_plane (in_rect))                  \n"
"    {                                                                         \n"
"      gpointer in = gegl_operation_context_get_object (context, \"input\");   \n"
"      gegl_operation_context_take_object (context, \"output\",                \n"
"                                          g_object_ref (G_OBJECT (in)));      \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* chain up, which will create the needed buffers for our actual            \n"
"   * process function                                                         \n"
"   */                                                                         \n"
"  return operation_class->process (operation, context, output_prop, result,   \n"
"                                   gegl_operation_context_get_level (context));\n"
"}                                                                             \n"
"                                                                              \n"
"/* This is called at the end of the gobject class_init function.              \n"
" *                                                                            \n"
" * Here we override the standard passthrough options for the rect             \n"
" * computations.                                                              \n"
" */                                                                           \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->process = operation_process;                               \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:stretch-contrast\",                               \n"
"    \"title\",       _(\"Stretch Contrast\"),                                 \n"
"    \"categories\" , \"color:enhance\",                                       \n"
"    \"description\",                                                          \n"
"        _(\"Scales the components of the buffer to be in the 0.0-1.0 range. \"\n"
"          \"This improves images that make poor use of the available contrast \"\n"
"          \"(little contrast, very dark, or very bright images).\"),          \n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
