static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"  description (_(\"Path of file to load\"))                                   \n"
"property_uri (uri, _(\"URI\"), \"\")                                          \n"
"  description (_(\"URI of file to load\"))                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE jpg-load.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <jpeglib.h>                                                          \n"
"#include <gegl-gio-private.h>                                                 \n"
"                                                                              \n"
"static const gchar *                                                          \n"
"jpeg_colorspace_name(J_COLOR_SPACE space)                                     \n"
"{                                                                             \n"
"    static const gchar * const names[] = {                                    \n"
"        \"Unknown\",                                                          \n"
"        \"Grayscale\",                                                        \n"
"        \"RGB\",                                                              \n"
"        \"YCbCr\",                                                            \n"
"        \"CMYK\",                                                             \n"
"        \"YCCK\"                                                              \n"
"    };                                                                        \n"
"    const gint n_valid_names = G_N_ELEMENTS(names);                           \n"
"    const gint idx = (space > 0 && space < n_valid_names) ? (gint)space : 0;  \n"
"    return names[idx];                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static const Babl *                                                           \n"
"babl_from_jpeg_colorspace(J_COLOR_SPACE space)                                \n"
"{                                                                             \n"
"    // XXX: assumes bitdepth == 8                                             \n"
"  const Babl *format = NULL;                                                  \n"
"  if (space == JCS_GRAYSCALE)                                                 \n"
"    format = babl_format (\"Y' u8\");                                         \n"
"  else if (space == JCS_RGB)                                                  \n"
"    format = babl_format (\"R'G'B' u8\");                                     \n"
"  else if (space == JCS_CMYK) {                                               \n"
"    format = babl_format(\"CMYK u8\");                                        \n"
"  }                                                                           \n"
"                                                                              \n"
"  return format;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"typedef struct {                                                              \n"
"    GInputStream *stream;                                                     \n"
"    gchar *buffer;                                                            \n"
"    gsize buffer_size;                                                        \n"
"} GioSource;                                                                  \n"
"                                                                              \n"
"static boolean                                                                \n"
"gio_source_fill(j_decompress_ptr cinfo)                                       \n"
"{                                                                             \n"
"    struct jpeg_source_mgr* src = cinfo->src;                                 \n"
"    GioSource *self = (GioSource *)cinfo->client_data;                        \n"
"    GError *err = NULL;                                                       \n"
"                                                                              \n"
"    const gssize bytes_read = g_input_stream_read(self->stream, self->buffer, \n"
"                                                  self->buffer_size, NULL, &err);\n"
"    if (!err)                                                                 \n"
"      {                                                                       \n"
"        src->next_input_byte = (JOCTET*)self->buffer;                         \n"
"        src->bytes_in_buffer = bytes_read;                                    \n"
"      }                                                                       \n"
"    else                                                                      \n"
"      {                                                                       \n"
"        g_print(\"%s: %s\\n\", __PRETTY_FUNCTION__, err->message);            \n"
"      }                                                                       \n"
"                                                                              \n"
"                                                                              \n"
"    /* FIXME: needed for EOF?                                                 \n"
"    static const JOCTET EOI_BUFFER[ 2 ] = { (JOCTET)0xFF, (JOCTET)JPEG_EOI }; \n"
"    src->next_input_byte = EOI_BUFFER;                                        \n"
"    src->bytes_in_buffer = sizeof( EOI_BUFFER );                              \n"
"    */                                                                        \n"
"                                                                              \n"
"    return TRUE;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gio_source_skip(j_decompress_ptr cinfo, long num_bytes)                       \n"
"{                                                                             \n"
"    struct jpeg_source_mgr* src = (struct jpeg_source_mgr*)cinfo->src;        \n"
"    GioSource *self = (GioSource *)cinfo->client_data;                        \n"
"                                                                              \n"
"    if (num_bytes < src->bytes_in_buffer)                                     \n"
"      {                                                                       \n"
"        // just skip inside buffer                                            \n"
"        src->next_input_byte += (size_t)num_bytes;                            \n"
"        src->bytes_in_buffer -= (size_t)num_bytes;                            \n"
"      }                                                                       \n"
"    else                                                                      \n"
"      {                                                                       \n"
"        // skip in stream, discard whole buffer                               \n"
"        GError *err = NULL;                                                   \n"
"        const gssize bytes_to_skip = num_bytes-src->bytes_in_buffer;          \n"
"        const gssize skipped = g_input_stream_skip(self->stream, bytes_to_skip, NULL, &err);\n"
"        if (err)                                                              \n"
"          {                                                                   \n"
"            g_printerr(\"%s: skipped=%ld, err=%s\\n\", __PRETTY_FUNCTION__, skipped, err->message);\n"
"            g_error_free(err);                                                \n"
"          }                                                                   \n"
"        src->bytes_in_buffer = 0;                                             \n"
"        src->next_input_byte = NULL;                                          \n"
"      }                                                                       \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gio_source_init(j_decompress_ptr cinfo)                                       \n"
"{                                                                             \n"
"    GioSource *self = (GioSource *)cinfo->client_data;                        \n"
"    self->buffer = g_new(gchar, self->buffer_size);                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gio_source_destroy(j_decompress_ptr cinfo)                                    \n"
"{                                                                             \n"
"    GioSource *self = (GioSource *)cinfo->client_data;                        \n"
"    g_free(self->buffer);                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gio_source_enable(j_decompress_ptr cinfo, struct jpeg_source_mgr* src, GioSource *data)\n"
"{                                                                             \n"
"    src->resync_to_restart = jpeg_resync_to_restart;                          \n"
"                                                                              \n"
"    src->init_source = gio_source_init;                                       \n"
"    src->fill_input_buffer = gio_source_fill;                                 \n"
"    src->skip_input_data = gio_source_skip;                                   \n"
"    src->term_source = gio_source_destroy;                                    \n"
"                                                                              \n"
"    // force fill at once                                                     \n"
"    src->bytes_in_buffer = 0;                                                 \n"
"    src->next_input_byte = (JOCTET*)NULL;                                     \n"
"                                                                              \n"
"    //g_assert(!cinfo->client_data);                                          \n"
"    cinfo->client_data = data;                                                \n"
"    cinfo->src = src;                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gint                                                                   \n"
"gegl_jpg_load_query_jpg (GInputStream *stream,                                \n"
"                         gint        *width,                                  \n"
"                         gint        *height,                                 \n"
"                         const Babl  **out_format)                            \n"
"{                                                                             \n"
"  struct jpeg_decompress_struct  cinfo;                                       \n"
"  struct jpeg_error_mgr          jerr;                                        \n"
"  struct jpeg_source_mgr         src;                                         \n"
"  gint                           status = 0;                                  \n"
"  const Babl *format = NULL;                                                  \n"
"  GioSource gio_source = { stream, NULL, 1024 };                              \n"
"                                                                              \n"
"  cinfo.err = jpeg_std_error (&jerr);                                         \n"
"  jpeg_create_decompress (&cinfo);                                            \n"
"                                                                              \n"
"  gio_source_enable(&cinfo, &src, &gio_source);                               \n"
"                                                                              \n"
"  (void) jpeg_read_header (&cinfo, TRUE);                                     \n"
"                                                                              \n"
"  format = babl_from_jpeg_colorspace(cinfo.out_color_space);                  \n"
"  if (width)                                                                  \n"
"    *width = cinfo.image_width;                                               \n"
"  if (height)                                                                 \n"
"    *height = cinfo.image_height;                                             \n"
"  if (out_format)                                                             \n"
"    *out_format = format;                                                     \n"
"  if (!format)                                                                \n"
"    {                                                                         \n"
"      g_warning (\"attempted to load JPEG with unsupported color space: '%s'\",\n"
"                 jpeg_colorspace_name(cinfo.out_color_space));                \n"
"      status = -1;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  jpeg_destroy_decompress (&cinfo);                                           \n"
"                                                                              \n"
"  return status;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gint                                                                   \n"
"gegl_jpg_load_buffer_import_jpg (GeglBuffer  *gegl_buffer,                    \n"
"                                 GInputStream *stream,                        \n"
"                                 gint         dest_x,                         \n"
"                                 gint         dest_y)                         \n"
"{                                                                             \n"
"  gint row_stride;                                                            \n"
"  struct jpeg_decompress_struct  cinfo;                                       \n"
"  struct jpeg_error_mgr          jerr;                                        \n"
"  struct jpeg_source_mgr         src;                                         \n"
"  JSAMPARRAY                     buffer;                                      \n"
"  const Babl                    *format;                                      \n"
"  GeglRectangle                  write_rect;                                  \n"
"  gboolean                       is_inverted_cmyk = FALSE;                    \n"
"  GioSource gio_source = { stream, NULL, 1024 };                              \n"
"                                                                              \n"
"  cinfo.err = jpeg_std_error (&jerr);                                         \n"
"  jpeg_create_decompress (&cinfo);                                            \n"
"                                                                              \n"
"  gio_source_enable(&cinfo, &src, &gio_source);                               \n"
"                                                                              \n"
"  (void) jpeg_read_header (&cinfo, TRUE);                                     \n"
"                                                                              \n"
"  /* This is the most accurate method and could be the fastest too. But       \n"
"   * the results may vary on different platforms due to different             \n"
"   * rounding behavior and precision.                                         \n"
"   */                                                                         \n"
"  cinfo.dct_method = JDCT_FLOAT;                                              \n"
"                                                                              \n"
"  (void) jpeg_start_decompress (&cinfo);                                      \n"
"                                                                              \n"
"  format = babl_from_jpeg_colorspace(cinfo.out_color_space);                  \n"
"  if (!format)                                                                \n"
"    {                                                                         \n"
"      g_warning (\"attempted to load JPEG with unsupported color space: '%s'\",\n"
"                 jpeg_colorspace_name(cinfo.out_color_space));                \n"
"      jpeg_destroy_decompress (&cinfo);                                       \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  row_stride = cinfo.output_width * cinfo.output_components;                  \n"
"                                                                              \n"
"  if ((row_stride) % 2)                                                       \n"
"    (row_stride)++;                                                           \n"
"                                                                              \n"
"  /* allocated with the jpeg library, and freed with the decompress context */\n"
"  buffer = (*cinfo.mem->alloc_sarray)                                         \n"
"    ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);                      \n"
"                                                                              \n"
"  write_rect.x = dest_x;                                                      \n"
"  write_rect.y = dest_y;                                                      \n"
"  write_rect.width  = cinfo.output_width;                                     \n"
"  write_rect.height = 1;                                                      \n"
"                                                                              \n"
"  // Most CMYK JPEG files are produced by Adobe Photoshop. Each component is stored where 0 means 100% ink\n"
"  // However this might not be case for all. Gory details: https://bugzilla.mozilla.org/show_bug.cgi?id=674619\n"
"  is_inverted_cmyk = (format == babl_format(\"CMYK u8\"));                    \n"
"                                                                              \n"
"  while (cinfo.output_scanline < cinfo.output_height)                         \n"
"    {                                                                         \n"
"      jpeg_read_scanlines (&cinfo, buffer, 1);                                \n"
"                                                                              \n"
"      if (is_inverted_cmyk) {                                                 \n"
"        for (int i=0; i<row_stride; i++) {                                    \n"
"            buffer[0][i] = 255-buffer[0][i];                                  \n"
"        }                                                                     \n"
"      }                                                                       \n"
"                                                                              \n"
"      gegl_buffer_set (gegl_buffer, &write_rect, 0,                           \n"
"                       format, buffer[0],                                     \n"
"                       GEGL_AUTO_ROWSTRIDE);                                  \n"
"                                                                              \n"
"      write_rect.y += 1;                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  jpeg_destroy_decompress (&cinfo);                                           \n"
"                                                                              \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"gegl_jpg_load_get_bounding_box (GeglOperation *operation)                     \n"
"{                                                                             \n"
"  gint width, height;                                                         \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  const Babl *format = NULL;                                                  \n"
"  GFile *file = NULL;                                                         \n"
"  GError *err = NULL;                                                         \n"
"  gint status = -1;                                                           \n"
"                                                                              \n"
"  GInputStream *stream = gegl_gio_open_input_stream(o->uri, o->path, &file, &err);\n"
"  if (!stream)                                                                \n"
"    return (GeglRectangle) {0, 0, 0, 0};                                      \n"
"  status = gegl_jpg_load_query_jpg (stream, &width, &height, &format);        \n"
"  g_input_stream_close(stream, NULL, NULL);                                   \n"
"                                                                              \n"
"  if (format)                                                                 \n"
"    gegl_operation_set_format (operation, \"output\", format);                \n"
"                                                                              \n"
"  g_object_unref(stream);                                                     \n"
"  if (file) g_object_unref(file);                                             \n"
"  if (err || status)                                                          \n"
"    return (GeglRectangle) {0, 0, 0, 0};                                      \n"
"  else                                                                        \n"
"    return (GeglRectangle) {0, 0, width, height};                             \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gegl_jpg_load_process (GeglOperation       *operation,                        \n"
"                       GeglBuffer          *output,                           \n"
"                       const GeglRectangle *result,                           \n"
"                       gint                 level)                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GFile *file = NULL;                                                         \n"
"  GError *err = NULL;                                                         \n"
"  gint status = -1;                                                           \n"
"  GInputStream *stream = gegl_gio_open_input_stream(o->uri, o->path, &file, &err);\n"
"  if (!stream)                                                                \n"
"    return FALSE;                                                             \n"
"  status = gegl_jpg_load_buffer_import_jpg(output, stream, 0, 0);             \n"
"  g_input_stream_close(stream, NULL, NULL);                                   \n"
"                                                                              \n"
"  if (err)                                                                    \n"
"    {                                                                         \n"
"      g_warning (\"%s failed to open file %s for reading: %s\",               \n"
"        G_OBJECT_TYPE_NAME (operation), o->path, err->message);               \n"
"      g_object_unref(stream);                                                 \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_object_unref(stream);                                                     \n"
"  return status != 1;                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"gegl_jpg_load_get_cached_region (GeglOperation       *operation,              \n"
"                                 const GeglRectangle *roi)                    \n"
"{                                                                             \n"
"  return gegl_jpg_load_get_bounding_box (operation);                          \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = gegl_jpg_load_process;                              \n"
"  operation_class->get_bounding_box = gegl_jpg_load_get_bounding_box;         \n"
"  operation_class->get_cached_region = gegl_jpg_load_get_cached_region;       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:jpg-load\",                                       \n"
"    \"title\",       _(\"JPEG File Loader\"),                                 \n"
"    \"categories\",  \"hidden\",                                              \n"
"    \"description\", _(\"JPEG image loader using libjpeg\"),                  \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"/*  static gboolean done=FALSE;                                               \n"
"    if (done)                                                                 \n"
"      return; */                                                              \n"
"  gegl_extension_handler_register_loader (\".jpg\", \"gegl:jpg-load\");       \n"
"  gegl_extension_handler_register_loader (\".jpeg\", \"gegl:jpg-load\");      \n"
"/*  done = TRUE; */                                                           \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
