//$Id: PhysicsFrame.java,v 1.6 2004/10/15 02:38:51 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// 2000 October 4 Hajime Yoshida GPE-1.3.1
// 2001 Dec Panel 
// 2002 May Web Start remove rho0 from getCPP
// 1999 August
//        Sei, Yoshida    Naruto University of Education
//        Kurasige        Kobe University

package GPE;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;
import javax.swing.filechooser.*;

//import ExampleFileFilter;

import GPE.ExampleFileFilter;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;


public class PhysicsFrame extends AbstractGPEFrame implements ActionListener {

  Date today = new Date();
  public EMParticlesTable emParTable;
  public HadParticlesTable hadParTable;
  public ProcessesTable proTable; 
  public HadronProcessesTable hadronproTable; 
  public PhysicsEMTable phyEMTable;
  public PhysicsHadTable phyHadTable;
  public SourceFrame source, include;

  GPETableModel emDataModel, hadDataModel;
  public JTextField physicsClassName;
  public String  workdirpath = ".";

  JTextField cutValue;
  JComboBox lengthCombo;

  String emNames[] = {"Particle", "Process", "AtRest", "AlongStep", "PostStep"};

  String hadNames[] = {"Particle", "Process", "Model", "Generator", "Transport", "AtRest","AlongStep", "PostStep"};

  String allBosons[] = {"\u03B3", "geantino", "chargedgeantino"};

  String allLeptons[] = {"e-", "\u03BC-", "\u03C4-", "anti-\u03BDe",
                         "anti-\u03BD\u03BC", "anti-\u03BD\u03C4", "e+", 
                         "\u03BC+", "\u03C4+", "\u03BDe", "\u03BD\u03BC", 
                         "\u03BD\u03C4"}; 

    /*  originally include rho0 \u03C10 but removed 2002 May 21
  String allEMMesons[] = {"\u03C0+", "\u03C0-", "\u03C00", "\u03B7", 
                        "\u03B7\u0374", "\u03C10", "K+", "K-", "K0", "K0S", 
                        "K0L", "anti-K0", "D+", "D-", "D0", "anti-D0", "Ds+",
                        "Ds-", "B+", "B-", "B0", "Bs0", "anti-B0", "anti-Bs0",
                        "\u03A8"};
    */
  String allEMMesons[] = {"\u03C0+", "\u03C0-", "\u03C00", "\u03B7", 
                        "\u03B7\u0374", "K+", "K-", "K0", "K0S", 
                        "K0L", "anti-K0", "D+", "D-", "D0", "anti-D0", "Ds+",
                        "Ds-", "B+", "B-", "B0", "Bs0", "anti-B0", "anti-Bs0",
                        "\u03A8"};


  String allHadMesons[] = {"\u03C0+", "\u03C0-", "K+", "K-", "K0", "K0S", 
                        "K0L", "anti-K0"};


  String allEMBaryons[] = {"p", "n", "anti-p", "anti-n", "\u039B", "\u03A3+",
                         "\u03A30", "\u03A3-", "\u039E0", "\u039E-",
                         "\u03A9-", "anti-\u039B", "anti-\u03A3+", 
                         "anti-\u03A30", "anti-\u03A3-", "anti-\u039E0",
                         "anti-\u039E-", "anti-\u03A9-", "\u039Bc+",
                         "\u03A3c++", "\u03A3c+", "\u03A3c0", "\u039Ec+",
                         "\u039Ec0", "\u03A9c0", "anti-\u039Bc+",
                         "anti-\u03A3c++", "anti-\u03A3c+", "anti-\u03A3c0",
                         "anti-\u039Ec+", "anti-\u039Ec0", "anti-\u03A9c0"};


  String allHadBaryons[] = {"p", "n", "anti-p", "anti-n", "\u039B", "\u03A3+",
                         "\u03A30", "\u03A3-", "\u039E0", "\u039E-",
                         "\u03A9-", "anti-\u039B", "anti-\u03A3+",
                         "anti-\u03A30", "anti-\u03A3-", "anti-\u039E0",
                         "anti-\u039E-", "anti-\u03A9-"};


  String allIons[] = {"\u03B1", "d", "He3", "triton", "GenericIon"}; 

  //String allShortlived[] = {"all shortlived"};

  JLabel label;

  private JMenuItem load, save, append, clear, exit, particleOpen, 
          particleClose, cpp, chh, processOpen, processClose;

  private JFileChooser saveData, loadData;

  private String fileName, createFile, newFile;

  static String fileDir;

  /* For OptionPane */
  private JFrame appendParticleMessage, insertEMParticleMessage,

                 insertHadParticleMessage, chooseParticleMessage,

                 deleteRowMessage, chooseProcessMessage, changeProcessMessage;

//MOMO moved here from the constructor
//    EMParticlesTable emParTable = new EMParticlesTable(this);
//    ProcessesTable proTable = new ProcessesTable(this);


  public PhysicsFrame() {
    super("Geant4 Physics Editor");

    emParTable = new EMParticlesTable(this);
    hadParTable = new HadParticlesTable(this);
    proTable = new ProcessesTable(this);
    hadronproTable = new HadronProcessesTable(this);
    phyEMTable = new PhysicsEMTable(emDataModel = 
                                    new GPETableModel(emNames,0), this);

    phyHadTable = new PhysicsHadTable(hadDataModel =
                                      new GPETableModel(hadNames,0), this);

    source = new SourceFrame();    
    include = new SourceFrame();

    //add(new BorderLayout());
    // 2001 PANEL order changed
    //    setJMenuBar( createMenubar() );
    setLayout(new FlowLayout(FlowLayout.LEFT, 15, 2));
    add(createMenubar());   //, "North");
    add(makePhysicsClassNamePanel());    //, "North");

    add(makeTablePanel());      //, "Center");
    //setSize(770,580);
    // PANEL
    //   pack();
    setVisible(true);
  }

  private JPanel makeTablePanel(){
    JPanel makeTablePanel = new JPanel();
//MOMO inner tabbed pane of EM particles and processes
   JTabbedPane parprocTabbedPane = new JTabbedPane();
        ImageIcon icon = new ImageIcon("yellow-ball.gif");
//	parprocTabbedPane.addChangeListener(this);
        parprocTabbedPane.addTab("EM Particles", icon, emParTable);
        parprocTabbedPane.addTab("EM Processes", icon, proTable);
//MOMO test color
        parprocTabbedPane.setForegroundAt(0, Color.blue);
        parprocTabbedPane.setForegroundAt(1, Color.blue);
// MOMO added
    makeTablePanel.setLayout(new BorderLayout());
    JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, true,
    phyEMTable.makeEMPanel(), parprocTabbedPane);           
//MOMO Had is displaced     phyEMTable.makeEMPanel(), phyHadTable.makeHadPanel());           

    makeTablePanel.add(splitPane, "Center");
    return makeTablePanel;
  }

  private JMenuBar createMenubar(){

    JMenu file, particle, make, process;
    JMenuBar mb = new JMenuBar();
    file = new JMenu("File");
    file.setForeground(Color.blue);
       file.add(load = new JMenuItem("Load  Physics File"));
       file.addSeparator();
       file.add(save = new JMenuItem("Save Physics Table"));
       file.addSeparator();
       file.add(clear = new JMenuItem("Clear Physics Table"));
       //MOMO removed       file.add(exit = new JMenuItem("Exit"));
    load.addActionListener(this);
    save.addActionListener(this);
    clear.addActionListener(this);
    //MOMO deactiveted    exit.addActionListener(this);
    mb.add(file);

    make = new JMenu("Make");
    make.setForeground(Color.blue);
      make.add(cpp = new JMenuItem("Make C++ Source"));
      make.add(chh = new JMenuItem("Make Header file"));

    cpp.addActionListener(this);
    chh.addActionListener(this);

    mb.add(make);
    return mb;
  }

  public JPanel makePhysicsClassNamePanel(){
    String[] lengthName = {"mm", "cm", "m"};    
    JLabel textFieldTitle = new JLabel("Enter PhysicsClassName", JLabel.CENTER);
      textFieldTitle.setFont(new Font("Serif", Font.BOLD, 12));
      Dimension titlesize = textFieldTitle.getPreferredSize();
      textFieldTitle.setSize(titlesize);
    JLabel  defaultCutValue = new JLabel("Enter defaultCutValue", JLabel.CENTER);
      //textFieldTitle.setFont(new Font("Serif", Font.BOLD, 12));
      defaultCutValue.setFont(new Font("Serif", Font.BOLD, 12));
      //    Dimension cutValuesize = textFieldTitle.getPreferredSize();
      Dimension cutValuesize = defaultCutValue.getPreferredSize();
      //    textFieldTitle.setSize(cutValuesize);
      defaultCutValue.setSize(cutValuesize);    

    JPanel textFieldPanel = new JPanel();
      textFieldPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 15, 2));
      textFieldPanel.add(textFieldTitle);
      physicsClassName = new JTextField(20);

    textFieldPanel.add(physicsClassName);
    textFieldPanel.add(defaultCutValue);
    cutValue = new JTextField(7);
    textFieldPanel.add(cutValue);
    lengthCombo = new JComboBox(lengthName);
    lengthCombo.setSelectedItem(lengthName[0]);
    textFieldPanel.add(lengthCombo);
    return textFieldPanel;
  }

  public String getPhysicsClassName(){
    String myName = physicsClassName.getText();
    return  myName;
  }

  public void actionPerformed(ActionEvent ae){
    Object o = ae.getSource();
    if( o == load ){ PhysicsfileLoad(); }
    if( o == save ){ PhysicsfileSave(); }
    if( o == clear ){ PhysicsfileClear(); }
    //REMOVED    if( o == exit ){ System.exit(0); }
    if( o == cpp && (getCPP() != "") ){               //Aug 12
      source.setVisible(true);
      source.editor.setText(getCPP());
    }if( o == chh  && (getCHH() != "") ){            // Aug 12
      include.setVisible(true);
      include.editor.setText(getCHH());
    }
  }

  private synchronized void resume(){
    notify();
  }

    // PANELize these methods are not necessary
  //open EMProcess table

  public void openProc(){
    proTable.setVisible(true);
  }

  //open HadronicProcess table

  public void openHProc(){
    hadronproTable.setVisible(true);
  }

//Append

  void PhysicsfileAppend(){
    JFileChooser loadData = new JFileChooser(workdirpath);
      loadData.cancelSelection();
      loadData.resetChoosableFileFilters();

    ExampleFileFilter mtFile = new ExampleFileFilter("g4ph","PhysicsSource");
     loadData.setFileFilter(mtFile);
      loadData.setDialogTitle("Load Physics");
      loadData.setMultiSelectionEnabled(true);

    if (loadData.showOpenDialog(this)!= JFileChooser.APPROVE_OPTION ) return;
    File fml = loadData.getSelectedFile();
    fileName = fml.getPath();
    if (fml.isFile()) {
      resume();
      try{
        FileInputStream filein = new FileInputStream(fileName);
        ObjectInputStream objin =new ObjectInputStream(filein);
        Vector mtData = (Vector)objin.readObject();
        Vector emData =  (Vector)mtData.firstElement();
        if(emDataModel.getRowCount()==0 && emData.size()==0){
             //--patern 1--
        }else{
             //--patern 2--
          for(int i=0; i<emData.size(); i++){
	    Vector em = (Vector)emData.elementAt(i);
	    emDataModel.addRow(em);
	  }
          repaint();
	}
        objin.close();
        repaint();
      }catch(Exception e){
	System.out.println(e.toString());
      }
    }else{
      System.out.println("error="+fml.toString()+"isNotaFile");
    }
    return;
  }

// Load

  void PhysicsfileLoad(){
    JFileChooser loadData = new JFileChooser(workdirpath);
      loadData.cancelSelection();
      loadData.resetChoosableFileFilters();
    ExampleFileFilter mtFile = new ExampleFileFilter("g4ph","PhysicsSource");
      loadData.setFileFilter(mtFile);
      loadData.setDialogTitle("Load Physics");
    if (loadData.showOpenDialog(this) != JFileChooser.APPROVE_OPTION ) return;
      loadData.setMultiSelectionEnabled(true);
      File fml = loadData.getSelectedFile();
      fileName = fml.getPath();
    if (fml.isFile()) {
      resume();
      try{
        FileInputStream filein = new FileInputStream(fileName);
        ObjectInputStream objin =new ObjectInputStream(filein);
        Vector mtData = (Vector)objin.readObject();
        //Vector emData = (Vector)mtData.firstElement();
        Vector emData = (Vector)mtData.elementAt(0);
        Vector hadData = (Vector)mtData.elementAt(1);
        Object physicsClassNameObject = (Object)mtData.elementAt(2);
        String physicsClassNameString = physicsClassNameObject.toString();
        Object cutValueObject = (Object)mtData.elementAt(3);
        String cutValueString = cutValueObject.toString();
        Object lengthComboObject = (Object)mtData.elementAt(4);
        if(emDataModel.getRowCount()==0 && emData.size()==0){

             //--patern 1--

        }else{

             //--patern 2--

	  phyEMTable.setModel(emDataModel = new GPETableModel(emNames,0));

          for(int i=0; i<emData.size(); i++){

	    Vector em = (Vector)emData.elementAt(i);

	    emDataModel.addRow(em);
	  }
          repaint();
	}
        if(hadDataModel.getRowCount()==0 && hadData.size()==0){
             //--patern 3--

        }else{
             //--patern 4--
          phyHadTable.setModel(hadDataModel = new GPETableModel(hadNames,0));
          for(int i=0; i<hadData.size(); i++){
            Vector had = (Vector)hadData.elementAt(i);
            hadDataModel.addRow(had);
	  }
          repaint();
	}

        physicsClassName.setText(physicsClassNameString);

        repaint();       
        cutValue.setText(cutValueString);
        repaint();
        lengthCombo.setSelectedItem(lengthComboObject);        
        repaint();
        objin.close();
        repaint();
      }catch(Exception e){
	System.out.println(e.toString());
      }
    }else{
      System.out.println("error="+fml.toString()+"isNotaFile");
    }
   return;
  }

/* --Save-------------------------------- */

  void PhysicsfileSave(){
    JFileChooser saveData = new JFileChooser(workdirpath);
    ExampleFileFilter mtFile = new ExampleFileFilter("g4ph","PhysicsSource");
      saveData.setFileFilter(mtFile);
      saveData.setDialogTitle("Save Physics");
    if ( saveData.showSaveDialog(this)!= JFileChooser.APPROVE_OPTION ) return;
    File fms = saveData.getSelectedFile();
    fileName = fms.getPath();
    if (fileName != null){
      try{
        FileOutputStream fileout = new FileOutputStream(fileName);
        ObjectOutputStream objout = new ObjectOutputStream(fileout);
        Vector mtVector = new Vector();
        mtVector.addElement((Object)emDataModel.getDataVector());
        mtVector.addElement((Object)hadDataModel.getDataVector());//test
        mtVector.addElement((Object)physicsClassName.getText());
        mtVector.addElement((Object)cutValue.getText());
        mtVector.addElement((Object)lengthCombo.getSelectedItem());
        objout.writeObject(mtVector);
        objout.flush();
        fileout.close();
      }catch(IOException e){ System.out.println(e.getMessage()); }
        return;
    }
    if ( fileName == null){
      return;
    }
  }

//Clear
  void PhysicsfileClear(){
    phyEMTable.setModel(emDataModel = new GPETableModel(emNames,0));
    phyHadTable.setModel(hadDataModel = new GPETableModel(hadNames, 0));
    //physicsClassName.setText("");
    //cutValue.setText("");
  }

//----------------Start the Append(emParticle)

  public void appendEMParticle(){
    ParticleItem[] eis = emParTable.getSelectedElements();
    Object tmp[] = new Object[5];   
    tmp[1] = "Null";
    tmp[2] = "";
    tmp[3] = "";
    tmp[4] = "";
    //tmp[5] = "";
    if (eis == null){
      appendParticleMessage = new JFrame();
      JOptionPane.showMessageDialog(appendParticleMessage, 
				   "Choose a Particle or allParticles from the Table",

				   "Warning Dialog", JOptionPane.WARNING_MESSAGE);
      return;
    }else {
      if(eis[0].symbol == "all bosons"){
        for(int i = 0; i < allBosons.length; i++){
          tmp[0] = allBosons[i];
          emDataModel.addRow(tmp); 
	}
      }else if(eis[0].symbol == ("all leptons")){
        for(int i = 0; i < allLeptons.length; i++){
          tmp[0] = allLeptons[i];
          emDataModel.addRow(tmp);
        }
      }else if(eis[0].symbol == ("all mesons")){
        for(int i = 0; i < allEMMesons.length; i++){
          tmp[0] = allEMMesons[i];
          emDataModel.addRow(tmp);
	}
      }else if(eis[0].symbol == ("all baryons")){
        for(int i = 0; i < allEMBaryons.length; i++){
          tmp[0] = allEMBaryons[i];
          emDataModel.addRow(tmp);
        }
      }else if(eis[0].symbol == ("all ions")){
        for(int i = 0; i < allIons.length; i++){
          tmp[0] = allIons[i];
          emDataModel.addRow(tmp);
        }
      }else if(eis[0].symbol == ("all shortlived")){
        tmp[0] = "all shortlived";
        emDataModel.addRow(tmp);
      }else{
        tmp[0] = new String(eis[0].symbol);
        emDataModel.addRow(tmp);
      }
    }
  }  

//----------------Start the Append(hadParticle)
  public void appendHadParticle(){
    ParticleItem[] eis = hadParTable.getSelectedElements();
      Object tmp[] = new Object[5];   
      tmp[1] = "Null";
      tmp[2] = "";
      tmp[3] = "";
      tmp[4] = "";
      //tmp[5] = "";
      if (eis == null){
        appendParticleMessage = new JFrame();
        JOptionPane.showMessageDialog(appendParticleMessage, 
				   "Choose a Particle or allParticles from the Table",

				   "Warning Dialog", JOptionPane.WARNING_MESSAGE);
        return;
      }else {
        if(eis[0].symbol == "all bosons"){
          for(int i = 0; i < allBosons.length; i++){
            tmp[0] = allBosons[i];
            hadDataModel.addRow(tmp); 
          }
        }else if(eis[0].symbol == ("all mesons")){
          for(int i = 0; i < allHadMesons.length; i++){
            tmp[0] = allHadMesons[i];
            hadDataModel.addRow(tmp);
	  }
        }else if(eis[0].symbol == ("all baryons")){
          for(int i = 0; i < allHadBaryons.length; i++){
            tmp[0] = allHadBaryons[i];
            hadDataModel.addRow(tmp);
          }
        }else if(eis[0].symbol == ("all ions")){
          for(int i = 0; i < allIons.length; i++){
            tmp[0] = allIons[i];
            hadDataModel.addRow(tmp);
          }
        }else if(eis[0].symbol == ("all shortlived")){
          tmp[0] = "all shortlived";
          hadDataModel.addRow(tmp);
        }else{
          tmp[0] = new String(eis[0].symbol);
          hadDataModel.addRow(tmp);
	}
     }
  }  

// ------------ Start the Insert(emParticle)
  public void insertEMParticle(){
    ParticleItem[] eis = emParTable.getSelectedElements();
    Object tmp[] = new Object[5];
    tmp[1] = "Null";
    tmp[2] = "";
    tmp[3] = "";
    tmp[4] = "";
    //tmp[5] = "";
    int emRow, emCol;
    emRow = phyEMTable.getSelectedRow();
    emCol = phyEMTable.getSelectedColumn();
    boolean emCel;
    emCel = phyEMTable.isCellSelected(emRow, emCol);
    if (eis == null){
      insertEMParticleMessage = new JFrame();
      JOptionPane.showMessageDialog(insertEMParticleMessage, 

				    "Choose a Particle or allParticles from the Table",

		        	    "Warning Dialog", JOptionPane.WARNING_MESSAGE);
      return;
    }else{
      if(emCel){
        if(eis[0].symbol == ("all bosons")){
	  for(int i = 0; i < allBosons.length; i++){
            tmp[0] = allBosons[i];
            int emRowCount = phyEMTable.getSelectedRow()+1;
            emDataModel.insertRow(emRowCount+i,tmp);
	  }
        }else if(eis[0].symbol == ("all leptons")){
          for(int i = 0; i < allLeptons.length; i++){
            tmp[0] = allLeptons[i];
            int emRowCount = phyEMTable.getSelectedRow()+1;
            emDataModel.insertRow(emRowCount+i,tmp);
          }
        }else if(eis[0].symbol == ("all mesons")){
	  for(int i = 0; i < allEMMesons.length; i++){
            tmp[0] = allEMMesons[i];

            int emRowCount = phyEMTable.getSelectedRow()+1;

            emDataModel.insertRow(emRowCount+i,tmp);

	  }

        }else if(eis[0].symbol == ("all baryons")){

	  for(int i = 0; i < allEMBaryons.length; i++){

            tmp[0] = allEMBaryons[i];

            int emRowCount = phyEMTable.getSelectedRow()+1;

            emDataModel.insertRow(emRowCount+i,tmp);

          }

        }else if(eis[0].symbol == ("all ions")){

          for(int i = 0; i < allIons.length; i++){

            tmp[0] = allIons[i];

            int emRowCount = phyEMTable.getSelectedRow()+1;

            emDataModel.insertRow(emRowCount+i,tmp);

          }

        }else if(eis[0].symbol == ("all shortlived")){

          tmp[0] = "all shortlived";

          int emRowCount = phyEMTable.getSelectedRow()+1;

          emDataModel.insertRow(emRowCount,tmp);

        }else{

          tmp[0] = new String(eis[0].symbol);

          int emRowCount = phyEMTable.getSelectedRow()+1;

          emDataModel.insertRow(emRowCount,tmp);

	}

      }else if(!emCel){

        chooseParticleMessage = new JFrame();

        JOptionPane.showMessageDialog(chooseParticleMessage, 
	        		      "Choose a Particle's Name",
	                              "Warning Dialog", JOptionPane.WARNING_MESSAGE);
        return; 
      }
    }
  }

// ------------ Start the Insert(hadParticle)
  public void insertHadParticle(){
    ParticleItem[] eis = hadParTable.getSelectedElements();
    Object tmp[] = new Object[5];
    tmp[1] = "Null";
    tmp[2] = "";
    tmp[3] = "";
    tmp[4] = "";
    //tmp[5] = "";

    int hadRow, hadCol;
    hadRow = phyHadTable.getSelectedRow();
    hadCol = phyHadTable.getSelectedColumn();
    boolean hadCel;
    hadCel = phyHadTable.isCellSelected(hadRow, hadCol);
    if (eis == null){
      insertHadParticleMessage = new JFrame();
      JOptionPane.showMessageDialog(insertHadParticleMessage, 
				    "Choose a Particle or allParticles from the Table",
		        	    "Warning Dialog", JOptionPane.WARNING_MESSAGE);
      return;
    }else{
      if(hadCel){
        if(eis[0].symbol == ("all bosons")){
          for(int i = 0; i < allBosons.length; i++){
            tmp[0] = allBosons[i];
            int hadRowCount = phyHadTable.getSelectedRow()+1;
            hadDataModel.insertRow(hadRowCount+i,tmp);
          }
        }else if(eis[0].symbol == ("all mesons")){
          for(int i = 0; i < allHadMesons.length; i++){
            tmp[0] = allHadMesons[i];
            int hadRowCount = phyHadTable.getSelectedRow()+1;
            hadDataModel.insertRow(hadRowCount+i,tmp);
          }
        }else if(eis[0].symbol == ("all baryons")){
	  for(int i = 0; i < allHadBaryons.length; i++){
            tmp[0] = allHadBaryons[i];
            int hadRowCount = phyHadTable.getSelectedRow()+1;
            hadDataModel.insertRow(hadRowCount+i,tmp);
          }
        }else if(eis[0].symbol == ("all ions")){
          for(int i = 0; i < allIons.length; i++){
            tmp[0] = allIons[i];
            int hadRowCount = phyHadTable.getSelectedRow()+1;
            hadDataModel.insertRow(hadRowCount+i,tmp);
          }
        }else if(eis[0].symbol == ("all shortlived")){
          tmp[0] = "all shortlived";
          int hadRowCount = phyHadTable.getSelectedRow()+1;
          hadDataModel.insertRow(hadRowCount,tmp);
        }else{
          tmp[0] = new String(eis[0].symbol);
          int hadRowCount = phyHadTable.getSelectedRow()+1;
          hadDataModel.insertRow(hadRowCount,tmp);
        }
      }else if(!hadCel){
        chooseParticleMessage = new JFrame();
        JOptionPane.showMessageDialog(chooseParticleMessage,
                                      "Choose a Particle's Name",
                                      "Warning Dialog", JOptionPane.WARNING_MESSAGE);
        return;
      }
    }
  }

// ------------ Start the Delete

  public void deleteRow(){
    int emRow, emCol, hadRow, hadCol;
    emRow = phyEMTable.getSelectedRow();
    emCol = phyEMTable.getSelectedColumn();
    hadRow = phyHadTable.getSelectedRow();
    hadCol = phyHadTable.getSelectedColumn();

    boolean emCel, hadCel;

    emCel = phyEMTable.isCellSelected(emRow, emCol);
    hadCel = phyHadTable.isCellSelected(hadRow, hadCol);

    if(emCel){
      emDataModel.removeRow(phyEMTable.getSelectedRow());
      // delete immediately 1999 Aug 13
      //delPhysicsDialog = new DelPhysicsDialog(this);
      //phyTable.delMatCloseAct();      

      repaint();
    }if(hadCel){
      hadDataModel.removeRow(phyHadTable.getSelectedRow());
      repaint();
    }if(!emCel && !hadCel){
      deleteRowMessage = new JFrame();
      JOptionPane.showMessageDialog(deleteRowMessage,
                                    "Choose a Particle's Name",
                                    "Warning Dialog", JOptionPane.WARNING_MESSAGE);
    }
  }

// ------------ changeParticle ----------------------

  /*void changeParticle(){
      ParticleItem[] eis = emParTable.getSelectedElements();
      if (eis == null){
        frame9 = new JFrame();
        JOptionPane.showMessageDialog(frame9, 
	                              "Choose a Particle from the Table",
                                      "Warning Dialog", JOptionPane.WARNING_MESSAGE);
        return;
      }else{
        Object tmp[] = new Object[5];
        tmp[0] = new String(eis[0].symbol);
        tmp[1] = "";
        tmp[2] = "";
        tmp[3] = "";
        tmp[4] = "";
        //tmp[5] = "";
        if(phyEMTable.getSelectedRow()==-1){
        }else{
          emDataModel.setValueAt(tmp[0], phyEMTable.getSelectedRow(), 0);
        }
      }
  }
  */


// ------------ changeProcess ----------------------

  public void changeProcess(){
    int phyEMTablerow;
    ProcessItem[] pis = proTable.getSelectedProcess();
    int emRow, emCol;
    emRow = phyEMTable.getSelectedRow();
    emCol = phyEMTable.getSelectedColumn();
    boolean emCel;

    emCel = phyEMTable.isCellSelected(emRow, emCol);
    if (pis == null){
      chooseProcessMessage = new JFrame();
      JOptionPane.showMessageDialog(chooseProcessMessage, 
        			    "Choose a EM Process from the Table",
                                    "Warning Dialog", JOptionPane.WARNING_MESSAGE);
      return;
    }else{
      if(emCel){
        Object tmp[] = new Object[5];
        tmp[0] = new String(pis[0].name);
        tmp[1] = new String(pis[0].At);
        tmp[2] = new String(pis[0].Along);
        tmp[3] = new String(pis[0].Post);
        phyEMTablerow = phyEMTable.getSelectedRow();
        if(phyEMTablerow == -1){
        }else{
          emDataModel.setValueAt(tmp[0], phyEMTablerow, 1);
          emDataModel.setValueAt(tmp[1], phyEMTablerow, 2);
          emDataModel.setValueAt(tmp[2], phyEMTablerow, 3);
          emDataModel.setValueAt(tmp[3], phyEMTablerow, 4);
          repaint();
        }
      }else if(!emCel){
      changeProcessMessage = new JFrame();
      JOptionPane.showMessageDialog(changeProcessMessage,
                                    "Choose a Particle's Name",
                                    "Warning Dialog", JOptionPane.WARNING_MESSAGE);
      return;
      }
    }
  }

// ------------ changeHadronProcess  Aug 27----------------------

  public void changeHadronProcess(){
    int phyHadTablerow;
    ProcessItem[] pis = hadronproTable.getSelectedProcess();
    int hadRow, hadCol;

    hadRow = phyHadTable.getSelectedRow();
    hadCol = phyHadTable.getSelectedColumn();
    boolean hadCel;
    hadCel = phyHadTable.isCellSelected(hadRow, hadCol);
    if (pis == null){
      chooseProcessMessage = new JFrame();
      JOptionPane.showMessageDialog(chooseProcessMessage, 
				    "Choose a Hadronic Process from the Table",
                                    "Warning Dialog", JOptionPane.WARNING_MESSAGE);
      return;
    }else{
      if(hadCel){
        Object tmp[] = new Object[4];
        tmp[0] = new String(pis[0].name);
        tmp[1] = new String(pis[0].At);
        tmp[2] = new String(pis[0].Along);
        tmp[3] = new String(pis[0].Post);

       phyHadTablerow = phyHadTable.getSelectedRow();
        if(phyHadTablerow == -1){
        }else{
          hadDataModel.setValueAt(tmp[0], phyHadTablerow, 1);
          hadDataModel.setValueAt(tmp[1], phyHadTablerow, 5);
          hadDataModel.setValueAt(tmp[2], phyHadTablerow, 6);
          hadDataModel.setValueAt(tmp[3], phyHadTablerow, 7);
          repaint();
        }
      }else if(!hadCel){
        changeProcessMessage = new JFrame();
        JOptionPane.showMessageDialog(changeProcessMessage,
                                      "Choose a Particle's Name",
                                      "Warning Dialog", JOptionPane.WARNING_MESSAGE);
        return;
      }
    }
  }

//Data Load Method
  void setLoadData(Vector materialData){
    GPEItem item;
  }

  void phyEMTableSelected(){
    phyHadTable.stopEditing();
  }

  void phyHadTableSelected(){
    phyEMTable.stopEditing();
  }

  public void windowIconified(WindowEvent event){
    emParTable.setVisible(false);
    hadParTable.setVisible(false); 
    phyEMTable.stopEditing();
    phyHadTable.stopEditing();
  }

  public void windowDeiconified(WindowEvent event){
    emParTable.setVisible(true);
    hadParTable.setVisible(true);
  }

//-------- Header File code generation ----------------------

String getCHH(){
   String myName = physicsClassName.getText();
   StringTokenizer st = new StringTokenizer(myName);

      if (!st.hasMoreTokens()){
          JFrame noNameMessage = new JFrame();
          JOptionPane.showMessageDialog(noNameMessage, 
					"Type in your ClassName",
                                        "Warning Dialog", JOptionPane.WARNING_MESSAGE);
          return "";
      }

   StringBuffer physchh = new StringBuffer("\n// Physics List Header File \n");
	physchh.append("//   " + myName + ".hh generated by Geant4 Physics Editor at " + today.toString() + "  \n\n");
	physchh.append("\n #ifndef  " + myName + "_h\n");
	physchh.append("#define  " + myName + "_h  1\n\n");
	physchh.append("#include \"G4VUserPhysicsList.hh\"\n");
	//	physchh.append("#include \"globals.hh\"\n\n");
	physchh.append("class  " + myName + ":  public G4VUserPhysicsList\n");
	physchh.append("   {");
	physchh.append("      public:\n");
	physchh.append("      " + myName + "();\n");
	physchh.append("      virtual ~" + myName + "();\n\n");
	physchh.append("  protected:\n");
	physchh.append("    virtual void ConstructParticle();\n");
	physchh.append("    virtual void ConstructProcess();\n");
	//physchh.append("    virtual void SetCuts(G4double);\n");
	physchh.append("    virtual void SetCuts();\n");
	physchh.append("  protected:\n");
	physchh.append("    virtual void ConstructBosons();\n");
	physchh.append("    virtual void ConstructLeptons();\n");
	physchh.append("    virtual void ConstructMesons();\n");
	physchh.append("    virtual void ConstructBaryons();\n");
	physchh.append("  protected:\n");
	physchh.append("    virtual void ConstructGeneral();\n");
	physchh.append("    virtual void ConstructEM();\n");
	physchh.append("    virtual void ConstructAllShortLiveds();\n");
	physchh.append("  };\n");
	physchh.append("#endif\n");

   return physchh.toString();
}

//------- C++ source code ------------------------------------

  String getCPP(){
	String myName = physicsClassName.getText();
	String myCutValue = cutValue.getText();
	StringTokenizer stName = new StringTokenizer(myName);
	StringTokenizer stCut = new StringTokenizer(myCutValue);

      if ( (!stName.hasMoreTokens()) || (!stCut.hasMoreTokens()) ){
          JFrame noNameMessage = new JFrame();
          JOptionPane.showMessageDialog(noNameMessage, 
					"Type in your ClassName AND CutValue",
                                        "Warning Dialog", JOptionPane.WARNING_MESSAGE);
          return "";
      }

    StringBuffer physcpp = new StringBuffer("\n// " + myName + ".cc \n\n");  
    Vector data = emDataModel.getDataVector();
    Vector rowData;
    physcpp.append("//  generated by Geant4 Physics Editor at   " + today.toString() + "\n\n");
    physcpp.append("#include \"" + myName + ".hh\"\n\n");
    physcpp.append("#include \"globals.hh\"\n");
    physcpp.append("#include \"G4ParticleDefinition.hh\"\n");
    physcpp.append("#include \"G4ParticleWithCuts.hh\"\n");
    physcpp.append("#include \"G4ProcessManager.hh\"\n");
    physcpp.append("#include \"G4ProcessVector.hh\"\n");
    physcpp.append("#include \"G4ParticleTypes.hh\"\n");
    physcpp.append("#include \"G4ParticleTable.hh\"\n");
    physcpp.append("#include \"G4ShortLivedConstructor.hh\"\n");
    physcpp.append("#include \"G4Material.hh\"\n");
    physcpp.append("#include \"G4MaterialTable.hh\"\n\n");
    physcpp.append("#include \"G4ios.hh\"\n\n");

    physcpp.append(myName + "::" + myName + "():  G4VUserPhysicsList()\n{\n");
    physcpp.append("// Here used the default cut value you have typed in\n\n");

    physcpp.append("  defaultCutValue = " + myCutValue + "*" + (String)lengthCombo.getSelectedItem() + ";\n");    

    //physcpp.append("  cutForGamma     = defaultCutValue;\n");
    //physcpp.append("  cutForElectrn   = defaultCutValue;\n");
    //physcpp.append("  cutForProton    = defaultCutValue;\n\n");

    physcpp.append("  SetVerboseLevel(1);\n}\n\n");    
    physcpp.append(myName + "::~" + myName + "()\n{}\n\n");
    physcpp.append("void " + myName + "::ConstructParticle()\n{\n");
    physcpp.append("// Here are constructed all particles you have chosen\n\n");
    physcpp.append("  ConstructBosons();\n"); 
    physcpp.append("  ConstructLeptons();\n");
    physcpp.append("  ConstructMesons();\n");
    physcpp.append("  ConstructBaryons();\n");
    physcpp.append("  ConstructAllShortLiveds();\n}\n\n");

//------- Bosons ------------------------------------

    physcpp.append("// In this method, static member functions should be called for ALL particles to be used.\n\n");
    physcpp.append("void " + myName + "::ConstructBosons()\n{\n");

//--------gamma, geantino, chargedgeantino

    boolean bosonsBoolean[] = {false, false, false};
    String bosonsDefinition[] = {"  G4Geantino::GeantinoDefinition();", 
                                 "  G4ChargedGeantino::ChargedGeantinoDefinition();",
                                 "  G4Gamma::GammaDefinition();"}; 

    for (int i=0; i<data.size(); i++){
      rowData = (Vector)data.elementAt(i);
      String myParticle = rowData.elementAt(0).toString();

      for (int ii = 0; ii < allBosons.length; ii++) {
        if(myParticle.equals(allBosons[ii]) && bosonsBoolean[ii] == false){
          physcpp.append(bosonsDefinition[ii]);
          physcpp.append("\n");
          bosonsBoolean[ii] = true;
        }
      }
    }
    physcpp.append("}\n");      

//------- Leptons ------------------------------------


    physcpp.append("void " + myName + "::ConstructLeptons()\n{\n");

//--------eminus, muminus, tauminus, antinue, antinumu, antinutau,
//--------eplus, muplus, tauplus, nue, numu, nutau,

    boolean leptonsBoolean[] = {false, false, false, false, false, false, 
                                false, false, false, false, false, false};

    String leptonsDefinition[] = {"  G4Electron::ElectronDefinition();",
                                  "  G4MuonMinus::MuonMinusDefinition();",
                                  "  G4TauMinus::TauMinusDefinition();",
                                  "  G4AntiNeutrinoE::AntiNeutrinoEDefinition();",
                                  "  G4AntiNeutrinoMu::AntiNeutrinoMuDefinition();",
                                  "  G4AntiNeutrinoTau::AntiNeutrinoTauDefinition();",                                  
                                  "  G4Positron::PositronDefinition();",
                                  "  G4MuonPlus::MuonPlusDefinition();",
                                  "  G4TauPlus::TauPlusDefinition();",
                                  "  G4NeutrinoE::NeutrinoEDefinition();", 
                                  "  G4NeutrinoMu::NeutrinoMuDefinition();", 
                                  "  G4NeutrinoTau::NeutrinoTauDefinition();"};

    for (int i=0; i<data.size(); i++){
      rowData = (Vector)data.elementAt(i);
	String myParticle = rowData.elementAt(0).toString();
      for (int ii = 0; ii < allLeptons.length; ii++) {
        if(myParticle.equals(allLeptons[ii]) && leptonsBoolean[ii] == false){
          physcpp.append(leptonsDefinition[ii]);
          physcpp.append("\n");
          leptonsBoolean[ii] = true;
        }
      }
    }
    physcpp.append("}\n");      

//------- Mesons ------------------------------------

    physcpp.append("void " + myName + "::ConstructMesons()\n{\n");

//--------kaonminus, jpsi, kaon0l, eta, kaonplus, piplus, bplus, dplus, 
//--------dsplus, piminus, bminus, dminus, dsminus, pi0, b0, bs0, d0, rho0, 
//--------antib0, antibs0, antid0, kaon0, antikaon0, kaon0s, etaprime;

    boolean mesonsBoolean[] = {false, false, false, false, false, false,
                               false, false, false, false, false, false,
                               false, false, false, false, false, false,
                               false, false, false, false, false, false,
                               false};


    String mesonsDefinition[] = {"  G4PionPlus::PionPlusDefinition();",
                                 "  G4PionMinus::PionMinusDefinition();",
                                 "  G4PionZero::PionZeroDefinition();",
                                 "  G4Eta::EtaDefinition();",
                                 "  G4EtaPrime::EtaPrimeDefinition();",
                                 "  G4RhoZero::RhoZeroDefinition();",
                                 "  G4KaonPlus::KaonPlusDefinition();",
                                 "  G4KaonMinus::KaonMinusDefinition();",
                                 "  G4KaonZero::KaonZeroDefinition();",
                                 "  G4KaonZeroShort::KaonZeroShortDefinition();",
                                "  G4KaonZeroLong::KaonZeroLongDefinition();",
                                 "  G4AntiKaonZero::AntiKaonZeroDefinition();",
                                 "  G4DMesonPlus::DMesonPlusDefinition();",
                                 "  G4DMesonMinus::DMesonMinusDefinition();",
                                 "  G4DMesonZero::DMesonZeroDefinition();",
                                 "  G4AntiDMesonZero::AntiDMesonZeroDefinition();",
                                 "  G4DsMesonPlus::DsMesonPlusDefinition();",
                                 "  G4DsMesonMinus::DsMesonMinusDefinition();",
                                 "  G4BMesonPlus::BMesonPlusDefinition();",
                                 "  G4BMesonMinus::BMesonMinusDefinition();",
                                 "  G4BMesonZero::BMesonZeroDefinition();",
                                 "  G4BsMesonZero::BsMesonZeroDefinition();",
                                 "  G4AntiBMesonZero::AntiBMesonZeroDefinition();",
                                 "  G4AntiBsMesonZero::AntiBsMesonZeroDefinition();",
				 "  G4JPsi::JPsiDefinition();"};

    for (int i=0; i<data.size(); i++){
      rowData = (Vector)data.elementAt(i);
	String myParticle = rowData.elementAt(0).toString();
      for (int ii = 0; ii < allEMMesons.length; ii++) {
	  if(myParticle.equals(allEMMesons[ii]) && mesonsBoolean[ii] == false){
	      // remove rho0, i.e., 5-th Definition
	      if(ii == 5) continue;
          physcpp.append(mesonsDefinition[ii]);
          physcpp.append("\n");
          mesonsBoolean[ii] = true;
	  }
      }
    }
    physcpp.append("}\n");      

//------- Baryons ------------------------------------

    physcpp.append("void " + myName + "::ConstructBaryons()\n{\n");

//--------antineutron, antiproton, omegaminus, proton, antiximinus, 
//--------antiomegaminus, antisigmaminus, neutron, sigmaminus, xicplus, 
//--------antisigmaplus, sigmaplus, antixicplus, sigmacplus, sigmacplusplus, 
//--------lambda, antisigmacplus, antisigmacplusplus, ximinus, 
//--------antilambdacplus, antilambda, xi0, antiomegac0, lambdacplus, 
//--------antisigmac0, antixi0, omegac0, antisigma0, sigma0, antixic0, 
//--------sigmac0, xic0;

    boolean baryonsBoolean[] = {false, false, false, false, false, false,
                                false, false, false, false, false, false,
                                false, false, false, false, false, false,
                                false, false, false, false, false, false,
                                false, false, false, false, false, false,
                                false, false};

    String baryonsDefinition[] = {"  G4Proton::ProtonDefinition();",
                                 "  G4Neutron::NeutronDefinition();",
                                 "  G4AntiProton::AntiProtonDefinition();",
                                 "  G4AntiNeutron::AntiNeutronDefinition();",
                                 "  G4Lambda::LambdaDefinition();",
                                 "  G4SigmaPlus::SigmaPlusDefinition();",
                                 "  G4SigmaZero::SigmaZeroDefinition();",
                                 "  G4SigmaMinus::SigmaMinusDefinition();",
                                 "  G4XiZero::XiZeroDefinition();",
                                 "  G4XiMinus::XiMinusDefinition();",
                                 "  G4OmegaMinus::OmegaMinusDefinition();",
                                 "  G4AntiLambda::AntiLambdaDefinition();",
                                 "  G4AntiSigmaPlus::AntiSigmaPlusDefinition();",
                                 "  G4AntiSigmaZero::AntiSigmaZeroDefinition();",
                                 "  G4AntiSigmaMinus::AntiSigmaMinusDefinition();",
                                 "  G4AntiXiZero::AntiXiZeroDefinition();",
                                 "  G4AntiXiMinus::AntiXiMinusDefinition();",
                                 "  G4AntiOmegaMinus::AntiOmegaMinusDefinition();",
                                 "  G4LambdacPlus::LambdacPlusDefinition();",
                                 "  G4SigmacPlusPlus::SigmacPlusPlusDefinition();",
                                 "  G4SigmacPlus::SigmacPlusDefinition();",
                                 "  G4SigmacZero::SigmacZeroDefinition();",
                                 "  G4XicPlus::XicPlusDefinition();",
                                 "  G4XicZero::XicZeroDefinition();",
                                 "  G4OmegacZero::OmegacZeroDefinition();",
                                 "  G4AntiLambdacPlus::AntiLambdacPlusDefinition();",
                                 "  G4AntiSigmacPlusPlus::AntiSigmacPlusPlusDefinition();",
                                 "  G4AntiSigmacPlus::AntiSigmacPlusDefinition();",
                                 "  G4AntiSigmacZero::AntiSigmacZeroDefinition();",
                                 "  G4AntiXicPlus::AntiXicPlusDefinition();",
                                 "  G4AntiXicZero::AntiXicZeroDefinition();",
                                 "  G4AntiOmegacZero::AntiOmegacZeroDefinition();"};


    for (int i=0; i<data.size(); i++){
      rowData = (Vector)data.elementAt(i);
	String myParticle = rowData.elementAt(0).toString();

	for (int ii = 0; ii < allEMBaryons.length; ii++) {
	  if(myParticle.equals(allEMBaryons[ii]) && baryonsBoolean[ii] == false){
            physcpp.append(baryonsDefinition[ii]);
            physcpp.append("\n");
            baryonsBoolean[ii] = true;
	  }
	}
    }
    physcpp.append("}\n");      

//------- all shortliveds ------------------------------------

    physcpp.append("void " + myName + "::ConstructAllShortLiveds()\n{\n");
    physcpp.append("// Here are contructed all short liveds\n\n");
    boolean allshortlived;
    allshortlived = false;

    for (int i=0; i<data.size(); i++){
      rowData = (Vector)data.elementAt(i);
        String myParticle = rowData.elementAt(0).toString();
      if((myParticle.equals("all shortlived") && allshortlived == false)){
          physcpp.append("  G4ShortLivedConstructor pConstructor;\n");
          physcpp.append("  pConstructor.ConstructParticle();\n");  
          allshortlived = true;
      }
    }    	 
    physcpp.append("}\n");

//------- Process ------------------------------------

    physcpp.append("void " + myName + "::ConstructProcess()\n{\n");
    physcpp.append("// Transportation, electromagnetic and general processes \n\n");
    physcpp.append("  AddTransportation();\n");
    physcpp.append("  ConstructEM();\n");
    physcpp.append("  ConstructGeneral();\n}\n");

    String allProcesses[] = {//-----Standard EM----- 
                             "Compton", "PolarizedCompton", "GammaConv", 
                             "PhotoElectric", "eIonisation", "eBrems", 
                             "e+Annihilation", "SynchrotronRad", 
                             "eIonisationPlus", "eBremsPlus", "hIonisation", 
                             "ionIonisation", "IeIonisation", "IeBrems", 
                             "Ie+Annihilation", "IMultipleScatt", 
                             "IhIonisation", "MultipleScatt", 

                            //-----Muon EM-----

                             "MuIonisation", "MuBrems", "MuPairProd", 
                             "IMuIonisation", "IMuBrems", "IMuPairProd",
                             //-----X Rays-----
                             "Cerenkov", "Scintillation",
                             //-----Low energy EM-----
                             "LECompton", "LEGammaConv", "LEPhotoElec",
                             "LERayleigh", "LEIonisation", "LEBrems",
                             "hLEIonisation"}; 


    boolean processesBoolean[] = {false, false, false, false, false, false,
                                  false, false, false, false, false, false,    
                                  false, false, false, false, false, false,    
                                  false, false, false, false, false, false,    
                                  false, false, false, false, false, false,    
                                  false, false, false};

    String processesDefinition[] = {//-----Standard EM-----
                                    "#include \"G4ComptonScattering.hh\"",
                                    "#include \"G4PolarizedComptonScattering.hh\"",
                                    "#include \"G4GammaConversion.hh\"",
                                    "#include \"G4PhotoElectricEffect.hh\"",
                                    "#include \"G4eIonisation.hh\"",
                                    "#include \"G4eBremsstrahlung.hh\"",
                                    "#include \"G4eplusAnnihilation.hh\"",
                                    "#include \"G4SynchrotronRadiation.hh\"",
                                    "#include \"G4eIonisationPlus.hh\"",
                                    "#include \"G4eBremsstrahlungPlus.hh\"",
                                    "#include \"G4hIonisation.hh\"",
                                    "#include \"G4ionIonisation.hh\"",
                                    "#include \"G4IeIonisation.hh\"", 
                                    "#include \"G4IeBremsstrahlung.hh\"",
                                    "#include \"G4IeplusAnnihilation.hh\"",
                                    "#include \"G4IMultipleScattering.hh\"",
                                    "#include \"G4IhIonisation.hh\"",
                                    "#include \"G4MultipleScattering.hh\"",
                                    //-----Muon EM-----
                                    "#include \"G4MuIonisation.hh\"",
                                    "#include \"G4MuBremsstrahlung.hh\"",
                                    "#include \"G4MuPairProduction.hh\"",
                                    "#include \"G4IMuIonisation.hh\"",
                                    "#include \"G4IMuBremsstrahlung.hh\"",
                                    "#include \"G4IMuPairProduction.hh\"",
                                    //-----X Rays-----
                                    "#include \"G4Cerenkov.hh\"",
                                    "#include \"G4Scintillation.hh\"",
                                    //-----Low energy EM-----
                                    "#include \"G4LowEnergyCompton.hh\"",
                                    "#include \"G4LowEnergyGammaConversion.hh\"",
                                    "#include \"G4LowEnergyPhotoElectric.hh\"",
                                    "#include \"G4LowEnergyRayleigh.hh\"",
                                    "#include \"G4LowEnergyIonisation.hh\"",
                                    "#include \"G4LowEnergyBremsstrahlung.hh\"",
                                    "#include \"G4hLowEnergyIonisation.hh\""};

    physcpp.append("// Here are respective header files for chosen processes\n\n");
    for (int i=0; i<data.size(); i++){
      rowData = (Vector)data.elementAt(i);
	String myParticle = rowData.elementAt(0).toString();

//          physcpp.append("//       Processes\n");

        for (int ii = 0; ii < allProcesses.length; ii++) {
	    if(rowData.elementAt(1).equals(allProcesses[ii]) && processesBoolean[ii] == false){
            physcpp.append(processesDefinition[ii]);
            physcpp.append("\n");
            processesBoolean[ii] = true;
	    }
        }
    }

    physcpp.append("\n");

// the next line is always here
    physcpp.append("// The next two processes are always included.\n\n");
    physcpp.append("#include \"G4hIonisation.hh\"\n");
    physcpp.append("#include \"G4MultipleScattering.hh\"\n");
    physcpp.append("void " + myName + "::ConstructEM()\n{\n");
    physcpp.append("  theParticleIterator->reset();\n");
    physcpp.append("  while( (*theParticleIterator)() ){\n");
    physcpp.append("    G4ParticleDefinition* particle = theParticleIterator->value();\n");    
    physcpp.append("    G4ProcessManager* pmanager = particle->GetProcessManager();\n");
    physcpp.append("    G4String particleName = particle->GetParticleName();\n\n");
//the next line are always here
    physcpp.append("// The next processes are always added.\n\n");
	physcpp.append("    if ((!particle->IsShortLived()) &&\n");
	physcpp.append("         (particle->GetPDGCharge() != 0.0 )&&\n");
 	physcpp.append("           (particle->GetParticleName() != \"e-\") &&\n");
 	physcpp.append("           (particle->GetParticleName() != \"e+\") &&\n");
 	physcpp.append("           (particle->GetParticleName() != \"mu-\") &&\n");
 	physcpp.append("           (particle->GetParticleName() != \"mu+\") &&\n");
 	physcpp.append("           (particle->GetParticleName() != \"chargedgeantino\")){\n");

	physcpp.append("      pmanager->AddProcess(new G4MultipleScattering(), -1, 1, 1);\n");
	physcpp.append("      pmanager->AddProcess(new G4hIonisation(), -1, 2, 2);\n");
	physcpp.append("    }\n");

// examine all combinations of a particle with a process in the JTable

    physcpp.append("// Each if clause corresponds to a row in the PhysicsTable\n\n");

    for (int i=0; i<data.size(); i++){
      rowData = (Vector)data.elementAt(i);

      //DEBUG
      //          if(!(rowData.elementAt(2).equals(""))){ continue; 

          if(rowData.elementAt(2).equals("")){ continue; 
	  }

      String myParticle = rowData.elementAt(0).toString();
      ParticleItem pari[] = emParTable.makeParticle();
      for(int ii = 0; ii < pari.length; ii++){
          if(myParticle.equals(pari[ii].symbol) && (!rowData.elementAt(1).equals("Null"))){
              physcpp.append("    if (particleName == \"" + pari[ii].name + "\") {\n");
          }
      }
      //physcpp.append("\") {\n");

      ProcessItem proi[] = proTable.makeProcess();
      for(int iii = 0; iii < proi.length; iii++){
          if(rowData.elementAt(1).equals("Null")){
	  }
          else if(rowData.elementAt(1).equals(proi[iii].name)){
      physcpp.append("      pmanager->AddProcess(new " + proi[iii].G4name +"()," + rowData.elementAt(2) + "," + rowData.elementAt(3) + "," + rowData.elementAt(4) + ");\n    }\n");
	  }      
      }
    }
      physcpp.append("  }\n");
      physcpp.append("}\n");     
      physcpp.append("\n");

      physcpp.append("#include \"G4Decay.hh\"\n\n");

//------- General ------------------------------------    

      physcpp.append("void " + myName + "::ConstructGeneral()\n{\n");
      physcpp.append("  G4Decay* theDecayProcess = new G4Decay();\n");
      physcpp.append("  theParticleIterator->reset();\n");
      physcpp.append("  while( (*theParticleIterator)() ){\n");
      physcpp.append("    G4ParticleDefinition* particle = theParticleIterator->value();\n");
      physcpp.append("    G4ProcessManager* pmanager = particle->GetProcessManager();\n");
      physcpp.append("    if (theDecayProcess->IsApplicable(*particle)) {\n");
      physcpp.append("      pmanager ->AddProcess(theDecayProcess);\n");
      physcpp.append("      pmanager ->SetProcessOrdering(theDecayProcess, idxPostStep);\n");
      physcpp.append("      pmanager ->SetProcessOrdering(theDecayProcess, idxAtRest);\n");
      physcpp.append("    }\n  }\n}\n\n");
      physcpp.append("void " + myName + "::SetCuts()\n{\n");
    physcpp.append("// defaultCutValue you have typed in is used\n\n");
      physcpp.append("  if (verboseLevel >1){\n");
      physcpp.append("    G4cout << \"" + myName + "::SetCuts:\";\n  }\n");
      physcpp.append("  SetCutsWithDefault();\n");
      physcpp.append("}\n");

    //StringBuffer elecpp = new StringBuffer("// Particles\n");
      //elecpp.append(physcpp.toString());
      return physcpp.toString();
  }
}
