//$Id: GAG.java,v 1.6 2004/10/18 05:57:33 suzuki Exp $
// GAG (Geant4 Adaptive GUI)
// Runs on JDK 1.6
// 1999 first created on March 30
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//

package GAG;

import GAG.ExampleFileFilter;

import javax.swing.*;
import javax.swing.filechooser.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import java.util.Vector.*;
import javax.swing.border.*;

//public class GAG extends JFrame implements TreeSelectionListener, ActionListener {
public class GAG extends JPanel implements TreeSelectionListener, ActionListener {
  static final String    gagVer = "J1.0a";
  private String         g4Ver, command;
  private GAGpipe        geant4;
  private ErrStream      errStream;
  private Hashtable      paramsHash;
  private Vector         disableCommands;
  private  ParamPanel     paramPanel;
  private JPanel         geantPanel, mainPanel, northPanel;
  private JSplitPane     splitPane, spane;
  private JFileChooser   geant4Chooser, historyChooser, logChooser;
  private JMenuItem      execG4, contG4, exitG4, killG4, exitGAG, 
                         clearOneHist, clearAllHist, saveHist, htmlHelp, about;
  private JCheckBox      logTerm, logFile, startJAS;
  private JTextField     directField;
  private JLabel         promptLabel;
  private String         fileName, g4Binary;
  public  String         workdirpath =".";
  private CardLayout     cardLayout;
  private boolean        executingG4, executingACommand, endGAG,
                         logtofile, logtoterm, JASisrunning;
  private JPanel         p1;
  private PrintWriter    outLog;

  private ExampleFileFilter exeFilter, outFilter, g4hFilter,
		            logFilter, g4histFilter, txtFilter, histFilter;
    // 2001 TEST
    DTreeFrame dTreePanel;

    // 2004 TEST
    private GAGConsole console;

  public GAG(){
    //super("GAG");

    mainPanel = new JPanel();
    mainPanel.setLayout(cardLayout = new CardLayout());
    northPanel = new JPanel();
    northPanel.setLayout(new BorderLayout());
    
    geantPanel = new JPanel(new BorderLayout());
    JMenu geantMenu = new JMenu("Geant4");

    //2004 TEST
    console = new GAGConsole();


// Menu items
    //geantMenu.setBackground(Color.green);
	geantMenu.setFont(new Font("Serif", Font.BOLD, 14));

 	     execG4 = new JMenuItem("Start_Geant4");
	     contG4 = new JMenuItem("Continue");
	     exitG4 = new JMenuItem("Exit_Geant4");
	     killG4 = new JMenuItem("Kill_Geant4");
	     exitGAG = new JMenuItem("Exit_GAG");

	     execG4.setBackground(Color.green);
	     contG4.setBackground(Color.green);
	     exitG4.setBackground(Color.green);
	     killG4.setBackground(Color.green);
	     exitGAG.setBackground(Color.green);


	     execG4.setFont(new Font("Serif", Font.BOLD, 12));
	     contG4.setFont(new Font("Serif", Font.BOLD, 12));
	     exitG4.setFont(new Font("Serif", Font.BOLD, 12));
	     killG4.setFont(new Font("Serif", Font.BOLD, 12));
	     exitGAG.setFont(new Font("Serif", Font.BOLD, 12));

	  geantMenu.add(execG4);
	  geantMenu.add(contG4);
	  geantMenu.add(exitG4);
	  geantMenu.add(killG4);
	  //geantMenu.addSeparator();
	  //geantMenu.add(exitGAG);


	logFile = new JCheckBox("Log_to_File", false);
	logTerm = new JCheckBox("to_Terminal", true);    // 2001 May set default
	startJAS = new JCheckBox("JAS", false);

	logFile.setFont(new Font("Serif", Font.BOLD, 12));
	logTerm.setFont(new Font("Serif", Font.BOLD, 12));
	startJAS.setFont(new Font("Helvetica", Font.BOLD, 12));
	
	JASisrunning = false;
	logtofile = false;
	logtoterm = false;              //default not used



    JMenu histMenu = new JMenu("History");

	histMenu.setFont(new Font("Serif", Font.BOLD, 14));
	clearOneHist = new JMenuItem("Clear One");
	clearAllHist = new JMenuItem("Clear All");
	saveHist = new JMenuItem("Save History");

	clearOneHist.setBackground(Color.yellow);
	clearAllHist.setBackground(Color.yellow);
	saveHist.setBackground(Color.yellow);

	clearOneHist.setFont(new Font("Serif", Font.BOLD, 12));
	clearAllHist.setFont(new Font("Serif", Font.BOLD, 12));
	saveHist.setFont(new Font("Serif", Font.BOLD, 12));


	histMenu.add(clearOneHist);
	histMenu.add(clearAllHist);
	histMenu.add(saveHist);

    JMenu helpMenu = new JMenu("Help");

	helpMenu.setFont(new Font("Serif", Font.BOLD, 14));
	helpMenu.add(htmlHelp = new JMenuItem("Help"));
	helpMenu.add(about = new JMenuItem("About"));


      execG4.addActionListener(this);
      contG4.addActionListener(this);
      exitG4.addActionListener(this);
      killG4.addActionListener(this);
      exitGAG.addActionListener(this);
      clearOneHist.addActionListener(this);
      clearAllHist.addActionListener(this);
      saveHist.addActionListener(this);
      htmlHelp.addActionListener(this);
      about.addActionListener(this);;

      logFile.addActionListener(this);
      logTerm.addActionListener(this);
      //      startJAS.addActionListener(this);;

      // Menu bar is at the top and contains all menu items and check boxes
    JMenuBar mb = new JMenuBar();
        mb.setBorder(new BevelBorder(BevelBorder.RAISED));
        mb.add(geantMenu);
	mb.add(histMenu);
	mb.add(helpMenu);

	//setJMenuBar(mb);
	//add(mb);

	//add mnemonics
	for (int i=0; i<mb.getMenuCount(); i++) {
	    JMenu menu = mb.getMenu(i);
 	    String text = menu.getText();
	    menu.setMnemonic(text.charAt(0));
	}

	// after adding mnemonic, add checkboxes (otherwise runtime err)
	mb.add(logFile);
	mb.add(logTerm);    //  always to xterm or selectable?
	//mb.add(startJAS);

	// Toolbar is shown when G4 is started. this prevents JAS invoked
	// without G4 running

	//	JToolBar toolbar = new JToolBar();
	//toolbar.setMargin(new Insets(1, 3, 1, 3));
	//toolbar.add(startJAS);
	//geantPanel.add(toolbar, BorderLayout.NORTH);


//  For the transparency with G4UIterminal,  direct input field

    directField = new JTextField();
	directField.setFont(new Font("Serif", Font.BOLD, 12));
	directField.addActionListener(this);

    p1 = new JPanel(new BorderLayout());

    promptLabel = new JLabel("****** PROMPT ******", JLabel.CENTER);
        promptLabel.setForeground(Color.black);
	promptLabel.setFont(new Font("Serif", Font.BOLD, 12));

	p1.add("Center", directField);
	p1.add("West", promptLabel);

        geantPanel.add("South", p1);

     JLabel idleLabel =new JLabel("Welcome to Geant4 Adaptive GUI",JLabel.CENTER);
	idleLabel.setFont(new Font("Serif", Font.BOLD, 18));

    mainPanel.add("idle", idleLabel);
	JLabel treeLabel = new JLabel("Making command tree");
	treeLabel.setFont(new Font("Serif", Font.BOLD, 18));

	mainPanel.add("tree", treeLabel);
	mainPanel.add("geant",geantPanel);

     northPanel.add("North", mb);
     northPanel.add("Center", mainPanel);
	//getContentPane().setLayout( new BorderLayout() );
	setLayout( new BorderLayout() );
	spane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,true,
			northPanel, console );
	spane.setDividerLocation(400);
	spane.setContinuousLayout(true);
	spane.setOneTouchExpandable(true);

	console.addComponentListener(
          new ComponentAdapter() {
            public void componentResized(ComponentEvent e) {
	      //spane.setDividerLocation(spane.getDividerLocation());
	      int x     = e.getComponent().getX();
	      int y     = e.getComponent().getY();
              int width = e.getComponent().getWidth();
              int height = e.getComponent().getHeight();

              int mainX = mainPanel.getX(); int mainY = mainPanel.getY();
              int mainWidth = mainPanel.getWidth();
              int mainHeight = mainPanel.getHeight();

              int spaneX = spane.getX(); int spaneY = spane.getY();
              int spaneWidth = spane.getWidth();
              int spaneHeight = spane.getHeight();

	      //spane.setResizeWeight(0.0);
              /*if( spaneHeight == 400 ){
		mainPanel.setBounds( mainX, mainY, mainWidth, mainHeight );
		//console.setBounds( conX, conY, conWidth, conHeight + 20);
	        spane.setBounds( spaneX, spaneY,
					 spaneWidth, spaneHeight + 100 );
	         spane.setDividerLocation(spane.getDividerLocation());
	      }else{
		mainPanel.setBounds( mainX, mainY, mainWidth, mainHeight );
		//console.setBounds( conX, conY, conWidth, 0 );
	        spane.setBounds( spaneX, spaneY,
			 spaneWidth, spaneHeight - 100 );
	        spane.setDividerLocation(spane.getDividerLocation());
	      }*/
              //spane.validate();
            }
        });
	//getContentPane().add( spane, "Center" );
	add( spane, "Center" );

    cardLayout.show(mainPanel, "idle");
        setSize(800,600);
	setVisible(true);

	//find G4 binary in the canonical directory 
    EnvVariable ev = new EnvVariable();
    String G4BINARY = ev.get("G4WORKDIR")+"";
    // 2001 June if G4BINDIR is not setenv, look for another path
    if (G4BINARY.equals("null")) {
        G4BINARY = workdirpath;
	//G4BINARY = ev.get("G4INSTALL") + "/bin/" + ev.get("G4SYSTEM");
    }
    geant4Chooser = new JFileChooser(G4BINARY);
    geant4Chooser.setDialogTitle("GEANT4 Executable File");

    historyChooser = new JFileChooser();
        historyChooser.setDialogTitle("Save Command History");
        g4hFilter = new ExampleFileFilter("g4h", "Geant4 History");
	txtFilter = new ExampleFileFilter("txt", "Geant4 History");
        histFilter = new ExampleFileFilter("his", "Geant4 History");

	historyChooser.addChoosableFileFilter(g4hFilter);
	historyChooser.addChoosableFileFilter(txtFilter);
	historyChooser.addChoosableFileFilter(histFilter);



    logChooser = new JFileChooser();
        logChooser.setDialogTitle("Specify a Log File");
        logFilter = new ExampleFileFilter("log", "Geant4 Log");

	logChooser.addChoosableFileFilter(logFilter);

    executingG4 = false;
    executingG4Menu();


    endGAG = true;
  } //end of GAG constructor


//////////////// executing Geant4 Menus ////////////////////////////////////
  private void executingG4Menu(){
      if(executingG4){
	  execG4.setEnabled(true);        //2000 inverted multiple G4
	  contG4.setEnabled(true);     // cont enebled 
	  exitG4.setEnabled(true);
	  killG4.setEnabled(true);
	  exitGAG.setEnabled(false);     //TEST 2000 Aug
    //      clearOneHist.setEnabled(b);
    //      clearAllHist.setEnabled(b);
    //      saveHist.setEnabled(b);
       }else{
	  execG4.setEnabled(true);        //2000 inverted
	  contG4.setEnabled(false);     // cont enebled 
	  exitG4.setEnabled(false);
	  killG4.setEnabled(false);
	  exitGAG.setEnabled(true);     //TEST 2000 Aug
       }
      repaint();
  }

//////////  MAIN LOOP/////////////////////////////////////////////
  //public void mainLoop(String args[]){
  public void mainLoop(){
    endGAG = false;
    /*if (args.length > 0) {   
	fileName = args[0];
	g4Binary = fileName;         // %java gag exampleN03
	geantStart(args);
    }*/
    String[] fn = new String[1];
    while(true){
	waiting();                  // waiting execG4 menu has been invoked
	//	if (endGAG) return;
	fn[0] = fileName;
	geantStart(fn);
    }
  }

    ////////////////////////////////////////////////////////////////
  private synchronized void waiting(){
    try{
      wait();
    }catch(InterruptedException e){
    }
  }

  private synchronized void resume(){
      //                notify();
      notifyAll();        //2000 wakeup all waiting threads
  }


    ///////////////////////////////////////////////////////////////////
  private void geantStart(String[] args){
    String line, prompt = "G4";
    geant4 = new GAGpipe(args);
    boolean paramChanged = false;
    executingG4 = false;                           //2000 IMPORTANT

    if (geant4.isError()){
	JOptionPane.showMessageDialog(this, geant4.getErrorMsg(),
				    "Warning", JOptionPane.WARNING_MESSAGE);
	geant4 = null;
	executingG4 = false;       // not a binary etc.
	executingG4Menu();
	return;
    }

    geant4.start();                              //2000 ?? not necessary?
    executingG4 = true;                           //2000 IMPORTANT
    executingG4Menu();

    Log("Start execution of " + args[0]);

    errStream = new ErrStream(geant4);
    errStream.start();

    geant4.writeLine("@@GAGmodeJAVA");
// notify Java GAG to the G4UIGAG session

    //    	System.out.println("DTREE DEBUG Start");           ////DEBUG

    while ((line = geant4.readStdLine()) != null){
	//		System.out.println("DEBUG " + line);           ////DEBUG

	// GAG protocole line is extracted
      if (line.startsWith("@@")){

// Yes G4UIGAG session   make Command Tree
	if (line.equals("@@JTreeBegin")){
	  if (makeCommandTree()) break;
	  continue;
	}
	// 2001 June 04 DTREE
	if (line.equals("@@DTREEBegin")){
	  if (makeDTREE()) break;
	  continue;
	}
	if (line.equals("@@JParamBegin")){
	  if (receiveParams()) break;
	  paramChanged = true;
	  continue;
	}
	if (line.equals("@@JDirGuideBegin")){
	  if (receiveCascade()) break;
	  continue;
	}
	if (line.equals("@@DisableListBegin")){
	  if (receiveDisables()) break;
	  paramChanged = true;
	  continue;
	}
	if (line.equals("@@Ready")){
// effective even if paramPanel is null. But PROMPT case is enough.
	    // deliucate problem is here?
	    //	p1.setVisible(true);
	    //	p1.setBackground(Color.green); repaint();
	    //	setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));  //2000
	  if (paramPanel != null) {
	    paramPanel.toReady();
	    // why paramPanel is null on gthis stage?
	    //System.out.println("ParamPanel toReady so that OK must be visible");
	    if (paramChanged && !command.equals("")) setParamPanel(command);
	  }
	  paramChanged = false;

	  Log(g4Binary + " : " + prompt + ">");
	  //	  exitG4.setEnabled(true);                   // NOTICE now can exit G4
	  //	  executingACommand = false;
	  //	  executingACommandMenu();
	  repaint();                                   //2000
	  continue;
	}
	if (line.startsWith("@@PROMPT")){
	  prompt = line.substring(line.indexOf("\"")+1, line.lastIndexOf("\""));
	  promptLabel.setText(g4Binary + " in " + prompt);
// effective even if paramPanel is null
	  //	p1.setVisible(true);   // ???????Memory leak?
	  // p1.setBackground(Color.green); repaint();           //2000
	  //	setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR)); //2000
	  //repaint();   // to refresh the prompt ???? Memory leak

	  continue;
	}
	if (line.startsWith("@@State")){
	  continue;
	}
// direct interaction with users with cin !! (yet to be improved withe better UI definition)
	if (line.startsWith("@@Ask")){
	String answer = JOptionPane.showInputDialog(this,line);
	geant4.writeLine(answer); 
	continue;
	}

	if (line.startsWith("@@CurrentValue")){
	  paramPanel.loadCurrentValues(line);

	  Log(line.substring(line.indexOf(" ")+1));
	  continue;
	}
	if (line.startsWith("@@Version")){
	  StringTokenizer st = new StringTokenizer( line );
	  st.nextToken();
	  g4Ver = st.nextToken();
	  continue;
	}
	if (line.startsWith("@@ErrResult")){
	  JOptionPane.showMessageDialog(this, 
		line.substring(line.indexOf("\"")+1, line.lastIndexOf("\"")),
		"Warning", JOptionPane.WARNING_MESSAGE);
	  continue;
	}
      }
      Log(line);    ///Not DEBUG no G4 output
    }
    geantTerminate();                         //2000 necessary?
  }

    //////////////////////////////////////////////////////////////////
    private void geantTerminate(){
	//    executingG4Menu(false);     //2000 ERROR
    if (geant4 != null){
      geant4.processKill();
      geant4 = null;
    }
    paramsHash = null;
    if (errStream != null){
	//      errStream.close();      // kept open like LOG window
      errStream = null;
    }
    cardLayout.show(mainPanel, "idle");
    paramPanel = null;
    executingG4 = false;                //2000 true after G4 termination
    executingG4Menu();                //2000 true after G4 termination
  }


    ///////////////////////////////////////////////////////////////////
  private boolean makeCommandTree() {
    String pLine, label;
    command = "";
    DefaultMutableTreeNode topTree, nowTree, childTree;
    boolean found;
    cardLayout.show(mainPanel, "tree");
    if (splitPane != null) geantPanel.remove(splitPane);
    int lastIndex = fileName.lastIndexOf("/");
    topTree = new DefaultMutableTreeNode( (lastIndex<0) ? fileName :  fileName.substring(lastIndex+1) );
    while( !(pLine = geant4.readStdLine()).equals("@@JTreeEnd") ){
      if (pLine == null){ return true;}
      nowTree = topTree; childTree = null; found = true;
      StringTokenizer stCo = new StringTokenizer(pLine,"/");
      while(stCo.hasMoreTokens()){
	label = stCo.nextToken();
	if (found){
	  found = false;
	  for (int i=0; i<nowTree.getChildCount(); i++){
	    childTree = (DefaultMutableTreeNode)nowTree.getChildAt(i);
	    if (label.equals( (String)childTree.getUserObject() )){
	      found = true;
	      break;
	    }
	  }
	}
	if (found == false) nowTree.add(childTree = new DefaultMutableTreeNode(label));
	nowTree = childTree;
      }
    }
    JTree tree = new JTree(topTree);
    tree.addTreeSelectionListener(this);
    paramPanel = new ParamPanel(this);
    splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, new JScrollPane(tree), paramPanel );

// keep space for JTree commands

    splitPane.setDividerLocation(350);
    repaint();
    geantPanel.add("Center", splitPane);
    cardLayout.show(mainPanel, "geant");
    paramsHash = new Hashtable();
    disableCommands = new Vector();
    return false;
  }
    //////////////////////////////////////////////////////////////////

    ///////////DTREE DTREE
  private boolean makeDTREE() {
    String pLine, label, eLine;
    command = "";
    DefaultMutableTreeNode topDTree, nowDTree, childDTree;
    boolean found;
    //cardLayout.show(mainPanel, "tree");
    //if (splitPane != null) geantPanel.remove(splitPane);
    int lastIndex = fileName.lastIndexOf("/");
    topDTree = new DefaultMutableTreeNode( (lastIndex<0) ? fileName :  fileName.substring(lastIndex+1) );
    while( !(pLine = geant4.readStdLine()).equals("@@DTREEEnd") ){
      if (pLine == null){ return true;}
      // DEBUG
      //      System.out.println("DTREE DEBUG line = " + pLine);

      // preceeding white chars must be eliminated
      eLine = pLine.trim();
      nowDTree = topDTree; childDTree = null; found = true;
      StringTokenizer stCo = new StringTokenizer(eLine,"/");
      while(stCo.hasMoreTokens()){
	label = stCo.nextToken();
	if (found){
	  found = false;
	  for (int i=0; i<nowDTree.getChildCount(); i++){
	    childDTree = (DefaultMutableTreeNode)nowDTree.getChildAt(i);
	    if (label.equals( (String)childDTree.getUserObject() )){
	      found = true;
	      break;
	    }
	  }
	}
	if (found == false) nowDTree.add(childDTree = new DefaultMutableTreeNode(label));
	nowDTree = childDTree;
      }
    }

    JTree dtree = new JTree(topDTree);

    dtree.addTreeSelectionListener(this);

    dTreePanel = new DTreeFrame(dtree);
    dTreePanel.setSize(320,420);
        dTreePanel.setLocation(120,120);
    dTreePanel.validate();
    
    repaint();
    return false;
  }

    /////////////////////////////////////////////////////////////////////
    ////////// DTREE END
    //////////////////////////////////////////////////////////////////////
  private boolean receiveParams() {
    String lines, name, guide[], range;
    int guideEnts, paramEnts;
    name = geant4.readStdLine();
    lines = geant4.readStdLine();
    try{
      guideEnts = Integer.parseInt(lines);
    }catch(NumberFormatException e){
      return true;
    }
    guide = new String[guideEnts];
    for (int i=0; i<guideEnts; i++){
      guide[i] = geant4.readStdLine();
    }
    range = geant4.readStdLine();
    if (geant4.isError()) return true;
    lines = geant4.readStdLine();
    try{
      paramEnts = Integer.parseInt(lines);
    }catch(NumberFormatException e){
      return true;
    }
    GAGcommandItem ci = new GAGcommandItem(name, guide, range, paramEnts);
    for (int i=0; i<ci.getParamEntries(); i++){
      for (int j=0; j<ci.MAX; j++){
	lines = geant4.readStdLine();
	if (lines == null) return true;
	ci.params[i][j]=lines;
      }
    }
    if ( !(geant4.readStdLine()).equals("@@JParamEnd") ) return true;
    paramsHash.put(name, ci);
    return false;
  }


    //////////////////////////////////////////////////////////////////////
  private boolean receiveCascade() {
    String name, guide;
    name = geant4.readStdLine();
    guide = geant4.readStdLine();
    // System.out.println("CASCADE: "+name+"  "+guide);
    if ( !(geant4.readStdLine()).equals("@@JDirGuideEnd") ) return true;
    paramsHash.put(name, guide);
    return false;
  }

    //////////////////////////////////////////////////////////////////////
  private boolean receiveDisables(){
    String line;
    disableCommands.removeAllElements();
    while(!(line = geant4.readStdLine()).equals("@@DisableListEnd")){
      if (line == null) return true;
      disableCommands.addElement(line);
    }
    return false;
  }

    //////////////////////////////////////////////////////////////////////
  void reqCurrent(String cmd){
    sendCommand("?"+cmd);
    return;
  }


    //////////////////////////////////////////////////////////////////////
  void sendCommand(String com){

    Log(com);
    geant4.writeLine(com);
    //    exitG4.setEnabled(false);           //2000
// cursor
    //	setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    //	p1.setBackground(Color.red); repaint();
    //	p1.setVisible(true);
    //	executingG4Menu(true);                 //2000 activate
    //	killG4.setEnabled(true);                //2000 during execution kill is allowed
// too much?
    //    executingACommand = true;
    //    executingACommandMenu();           //2000 maybe too much, since busy at @@

    //    System.out.println("DEBUG: sendCommand= ( " + com + " )");        //debug
  }


    //////////////////////////////////////////////////////////////////////
  boolean setParamPanel(String key){
    GAGcommandItem ci = (GAGcommandItem)paramsHash.get(key);
    if (ci == null) return false;
    command = key;
    paramPanel.setParamBox(ci, isEnableCommand(key));
    return true;
  }

    //////////////////////////////////////////////////////////////////////
  public void valueChanged(TreeSelectionEvent te){
    if ( te.isAddedPath() == false ) return;
    String dirHelp, tempPath;
    StringBuffer com = new StringBuffer();
    Object path[] = te.getPath().getPath();
    if (path.length > 1) {
      for (int i=1; i<path.length; i++) com.append(("/"+path[i]));
      command = com.toString();
    }else{
      command = "";
    }

    DefaultMutableTreeNode nowNode = (DefaultMutableTreeNode)path[path.length-1];
    int childCount = nowNode.getChildCount();
    if ( childCount > 0 ){
      DefaultMutableTreeNode tempNode;
      if (path.length > 1) {
	dirHelp = (String)paramsHash.get(command+"/");
      }else{
	dirHelp = new String(path[0].toString());
      }
      JLabel[][] helpLabel = new JLabel[2][childCount];
      for (int i=0; childCount > i; i++){
	tempNode = (DefaultMutableTreeNode)nowNode.getChildAt(i);
	tempPath = command + "/" + tempNode;
	if (tempNode.getChildCount() == 0){          // isLeaf()
	  helpLabel[0][i] = new JLabel(tempNode+" ");
	  helpLabel[0][i].setForeground(isEnableCommand(tempPath) ? Color.red : Color.lightGray);
	  helpLabel[1][i] = new JLabel(((GAGcommandItem)(paramsHash.get(tempPath))).getTitle());
	}else{
	  helpLabel[0][i] = new JLabel(tempNode+"/ ");
	  helpLabel[0][i].setForeground(isEnableCommand(tempPath+"/") ? Color.blue : Color.lightGray);
	  helpLabel[1][i] = new JLabel((String)paramsHash.get(tempPath +"/"));
	}
      }
      paramPanel.setTreeHelp(dirHelp, helpLabel);
    }else{
      GAGcommandItem ci = (GAGcommandItem)paramsHash.get(command);
      if (ci == null) return;
      paramPanel.setParamBox(ci, isEnableCommand(command));
    }
    return;
  }

    ////////////////////////////////////////// Log 
    void Log(String line){
	if (logtofile){ outLog.println(line); }
	//if (logTerm.isSelected()){ System.out.println(line);} // always
	if (logTerm.isSelected()){ console.setLine(line);} // always
	// System.out.println(line);
    }



    //////////////////////////////////////////////////////////////////////
  boolean isEnableCommand(String command){
    return !disableCommands.contains(command);
  }

  ////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////

  public void actionPerformed(ActionEvent ae){

    Object o = ae.getSource();

    if ( o == directField){
	sendCommand(directField.getText());
	paramPanel.addHistory(directField.getText());
	directField.setText("");
	return;
    }
    if (o == exitGAG){
	if (geant4 != null) {
	    if(JOptionPane.showConfirmDialog(this, "Kill GEANT4 automatically.", 
					     "Exit GAG", JOptionPane.YES_NO_OPTION) == 1) { return; }
	    
	    geantTerminate();
	}
	if(logtofile){ outLog.close(); outLog=null; }                // close LOg file
	System.exit(0);
    }
  
    if (o == exitG4){
      sendCommand("exit");
      //      geantTerminate();                  //2000
      if (outLog != null) {outLog.flush(); outLog.close(); outLog=null; logtofile=false;} // yet last ending messages
      executingG4 = false;                   //2000
      executingG4Menu();           //2000
      return;
    }
    if (o == contG4){
      sendCommand("continue");
      executingG4 = true;                   //2000
      executingG4Menu();           //2000
      return;
    }
    if (o == execG4){

      geant4Chooser.setCurrentDirectory(new File(workdirpath));
      if (geant4Chooser.showOpenDialog(this) != JFileChooser.APPROVE_OPTION )return;
      File f = geant4Chooser.getSelectedFile();
      if (f.isFile()) {
	fileName = f.getPath();
	g4Binary = f.getName();
	resume();
      }
      executingG4 = true;                    //2000
      executingG4Menu();           //2000
      return;
    }
    if (o == killG4){
	    if (outLog != null) {outLog.flush(); outLog.close(); outLog=null;}
      geantTerminate();
            executingG4 = false;                          //2000
            executingG4Menu();                   //2000
      return;
    }

    if (o == startJAS){
	if(JASisrunning)return;
	EnvVariable evJ = new EnvVariable();
	String JASpath = evJ.get("JASROOT") + "/jas";
	try {
	    Process pJAS = Runtime.getRuntime().exec(JASpath);
	}catch (IOException e){
	    String errMsg = e.getMessage();
	    return;
	}
	JASisrunning = true;
    }
    if (o == htmlHelp){
      return;
    }
    if (o == about){
      //new AboutDialog(this, gagVer, g4Ver);
      return;
    }
    if (o == clearAllHist){
      paramPanel.clearAllHistory();
      return;
    }
    if (o == clearOneHist){
      paramPanel.clearOneHistory();
      return;
    }

    //    if ( o == logTerm){
    //	logtoterm = true;   
    //    }

    if (o == logFile){
	if(!logFile.isSelected()) {
	    logtofile = false;
	    if (outLog != null) {outLog.flush();}
	    return;
	}
      logChooser.setCurrentDirectory( new File(workdirpath) );
      if (logChooser.showOpenDialog(this) != JFileChooser.APPROVE_OPTION ) return;
      logtofile = true;
      try{
      File logFileName = logChooser.getSelectedFile();
      outLog = new PrintWriter(new BufferedWriter(new FileWriter(logFileName)));
      }catch (IOException e){System.out.println(e);}
    
    }
    if (o == saveHist){
      historyChooser.setCurrentDirectory( new File(workdirpath) );
      if (historyChooser.showSaveDialog(this) != JFileChooser.APPROVE_OPTION ) return;
      try{
	FileOutputStream fo = new FileOutputStream(historyChooser.getSelectedFile());
	PrintWriter outf = new PrintWriter(new DataOutputStream(fo));
	Vector items;             // use Vector instead of array
	items = paramPanel.getHistoryItems();

	for (int i=0; i<items.size(); i++) outf.println(items.elementAt(i));
	outf.close(); outf = null;
      }catch(IOException e){ Log(e.getMessage()); }
      return;
    }
  }
}

    //////////////////////////////////////////////////////////////////////
class ErrStream extends Thread implements ActionListener {
  private GAGpipe geant4;
  private JFrame errFrame; 
  private JTextArea errArea;
  private JButton close;

  ErrStream(GAGpipe geant4){
    this.geant4 = geant4;
    errFrame = new JFrame("Geant4 Error Messages");
    // errFrame.setResizable(true);             // this is default
    //    errFrame.getContentPane().setLayout(new BorderLayout());
    errArea = new JTextArea();
    Dimension tdim = new Dimension(300,100);
    errArea.setPreferredSize(tdim);
    errArea.setBackground(Color.orange);
    errFrame.getContentPane().setLayout(new BorderLayout());
    errFrame.getContentPane().add("Center", errArea);
    errFrame.getContentPane().add("South", close = new JButton("Close"));
    //    errFrame.setSize(400, 250);     
    errFrame.setLocation(100,500);      //// 2001JUne
    errFrame.pack();
    //errFrame.setVisible(true);
    errFrame.validate();                 ////2001June
    close.addActionListener(this);

  }
  
  public void run(){
    String line;
    //    errFrame.setSize(300, 100); 

    while((line=geant4.readErrLine())!=null){

      if (!errFrame.isVisible()){ errFrame.setVisible(true);  // pop-up at the first err
    errFrame.setSize(400, 200);
    errFrame.setLocation(100,400);
    errFrame.validate();
      }
      ////////////////////////////////////////////
      errArea.append(line+"\n");
//  G4UIterminal session  (for transparency only)

	if (line.startsWith("command </@@GAGmode")){
 	   JOptionPane.showMessageDialog(errFrame,
	      "This program must run in the terminal mode.\n GAG can't go ahead.\n ! ATTENTION\n GAG requires programs compiled with the G4UIGAG.", 
		  "GAG is stopped", JOptionPane.WARNING_MESSAGE);
		      geant4.processKill();
		      geant4 = null;
		      close();
		      return;
		}
      ///////////////////////////////////////////

    }
  }

  public void actionPerformed(ActionEvent ae){
      //    errFrame.setSize(300, 100);
    errFrame.setVisible(false);
    errArea.setText("");
  }

  void close(){
    errFrame.dispose();
    errFrame = null;                // JVM garbage collection
    //    stop();                   //2000
  }
}  // end ErrStream

    //////////////////////////////////////////////////////////////////////
class AboutDialog extends Dialog implements ActionListener {
  Button ok;
  public AboutDialog(Frame parent, String ver1, String ver2){
    super(parent, "About GAG", true);
    setForeground(Color.black);
    Panel center = new Panel(new GridLayout(0,1));
    center.add(new Label("GAG Protocol Version "+ ver1));
    //    center.add(new Label("G4UIJAG Protocol Version "+ ver2));
    //    center.add(new Label("G4UIJAG modified from G4UIGAG in September 2000"));
    center.add(new Label("Toshiaki Kodama, Hajime Yoshida, Geant4 GUI Group at Naruto"));
    add("Center", center);

    JPanel p = new JPanel();
    ok = new Button("Ok");
    ok.addActionListener(this);
    p.add(ok);
    add("South",p);
    pack();
    setVisible(true);
  }

  public void actionPerformed(ActionEvent event) {
    if (event.getSource() == ok)
      dispose();
  }
}










