//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: pydemo_wp.cc,v 1.3 2006-06-29 15:28:40 gunter Exp $
// $Name: not supported by cvs2svn $
// ====================================================================
//   pydemo_wp.cc
//
//   python wrapper for user application
//                                         2005 Q
// ====================================================================
#include <boost/python.hpp>
#include "MyMaterials.hh"
#include "MyDetectorConstruction.hh"
#include "G4VSensitiveDetector.hh"

using namespace boost::python;

// ====================================================================
//   Expose to Python
// ====================================================================

BOOST_PYTHON_MODULE(demo_wp) {
  class_<MyMaterials>("MyMaterials", "my material")
    .def("Construct", &MyMaterials::Construct)
    ;

  class_<MyDetectorConstruction, MyDetectorConstruction*,
    bases<G4VUserDetectorConstruction> >
    ("MyDetectorConstruction", "my detector")
    .def("SetSDtoScoreVoxel", &MyDetectorConstruction::SetSDtoScoreVoxel)
    ;
}

