//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// neutron_hp -- source file
// J.P. Wellisch, Nov-1996
// A prototype of the low energy neutron transport model.
#include "G4NeutronHPFastLegendre.hh"

  G4double G4NeutronHPFastLegendre::l0[201] = {1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1}; G4double
  G4NeutronHPFastLegendre::i0[201] = {0, 0.01, 0.02, 0.03, 0.04, 0.05,
  0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 0.13, 0.14, 0.15, 0.16,
  0.17, 0.18, 0.19, 0.2, 0.21, 0.22, 0.23, 0.24, 0.25, 0.26, 0.27,
  0.28, 0.29, 0.3, 0.31, 0.32, 0.33, 0.34, 0.35, 0.36, 0.37, 0.38,
  0.39, 0.4, 0.41, 0.42, 0.43, 0.44, 0.45, 0.46, 0.47, 0.48, 0.49,
  0.5, 0.51, 0.52, 0.53, 0.54, 0.55, 0.56, 0.57, 0.58, 0.59, 0.6,
  0.61, 0.62, 0.63, 0.64, 0.65, 0.66, 0.67, 0.68, 0.69, 0.7, 0.71,
  0.72, 0.73, 0.74, 0.75, 0.76, 0.77, 0.78, 0.79, 0.8, 0.81, 0.82,
  0.83, 0.84, 0.85, 0.86, 0.87, 0.88, 0.89, 0.9, 0.91, 0.92, 0.93,
  0.94, 0.95, 0.96, 0.97, 0.98, 0.99, 1, 1.01, 1.02, 1.03, 1.04, 1.05,
  1.06, 1.07, 1.08, 1.09, 1.1, 1.11, 1.12, 1.13, 1.14, 1.15, 1.16,
  1.17, 1.18, 1.19, 1.2, 1.21, 1.22, 1.23, 1.24, 1.25, 1.26, 1.27,
  1.28, 1.29, 1.3, 1.31, 1.32, 1.33, 1.34, 1.35, 1.36, 1.37, 1.38,
  1.39, 1.4, 1.41, 1.42, 1.43, 1.44, 1.45, 1.46, 1.47, 1.48, 1.49,
  1.5, 1.51, 1.52, 1.53, 1.54, 1.55, 1.56, 1.57, 1.58, 1.59, 1.6,
  1.61, 1.62, 1.63, 1.64, 1.65, 1.66, 1.67, 1.68, 1.69, 1.7, 1.71,
  1.72, 1.73, 1.74, 1.75, 1.76, 1.77, 1.78, 1.79, 1.8, 1.81, 1.82,
  1.83, 1.84, 1.85, 1.86, 1.87, 1.88, 1.89, 1.9, 1.91, 1.92, 1.93,
  1.94, 1.95, 1.96, 1.97, 1.98, 1.99, 2}; G4double
  G4NeutronHPFastLegendre::l1[401] = {-1, -0.995, -0.99, -0.985,
  -0.98, -0.975, -0.97, -0.965, -0.96, -0.955, -0.95, -0.945, -0.94,
  -0.935, -0.93, -0.925, -0.92, -0.915, -0.91, -0.905, -0.9, -0.895,
  -0.89, -0.885, -0.88, -0.875, -0.87, -0.865, -0.86, -0.855, -0.85,
  -0.845, -0.84, -0.835, -0.83, -0.825, -0.82, -0.815, -0.81, -0.805,
  -0.8, -0.795, -0.79, -0.785, -0.78, -0.775, -0.77, -0.765, -0.76,
  -0.755, -0.75, -0.745, -0.74, -0.735, -0.73, -0.725, -0.72, -0.715,
  -0.71, -0.705, -0.7, -0.695, -0.69, -0.685, -0.68, -0.675, -0.67,
  -0.665, -0.66, -0.655, -0.65, -0.645, -0.64, -0.635, -0.63, -0.625,
  -0.62, -0.615, -0.61, -0.605, -0.6, -0.595, -0.59, -0.585, -0.58,
  -0.575, -0.57, -0.565, -0.56, -0.555, -0.55, -0.545, -0.54, -0.535,
  -0.53, -0.525, -0.52, -0.515, -0.51, -0.505, -0.5, -0.495, -0.49,
  -0.485, -0.48, -0.475, -0.47, -0.465, -0.46, -0.455, -0.45, -0.445,
  -0.44, -0.435, -0.43, -0.425, -0.42, -0.415, -0.41, -0.405, -0.4,
  -0.395, -0.39, -0.385, -0.38, -0.375, -0.37, -0.365, -0.36, -0.355,
  -0.35, -0.345, -0.34, -0.335, -0.33, -0.325, -0.32, -0.315, -0.31,
  -0.305, -0.3, -0.295, -0.29, -0.285, -0.28, -0.275, -0.27, -0.265,
  -0.26, -0.255, -0.25, -0.245, -0.24, -0.235, -0.23, -0.225, -0.22,
  -0.215, -0.21, -0.205, -0.2, -0.195, -0.19, -0.185, -0.18, -0.175,
  -0.17, -0.165, -0.16, -0.155, -0.15, -0.145, -0.14, -0.135, -0.13,
  -0.125, -0.12, -0.115, -0.11, -0.105, -0.1, -0.095, -0.09, -0.085,
  -0.08, -0.075, -0.07, -0.065, -0.06, -0.055, -0.05, -0.045, -0.04,
  -0.035, -0.03, -0.025, -0.02, -0.015, -0.01, -0.005, 0, 0.005, 0.01,
  0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05, 0.055, 0.06,
  0.065, 0.07, 0.075, 0.08, 0.085, 0.09, 0.095, 0.1, 0.105, 0.11,
  0.115, 0.12, 0.125, 0.13, 0.135, 0.14, 0.145, 0.15, 0.155, 0.16,
  0.165, 0.17, 0.175, 0.18, 0.185, 0.19, 0.195, 0.2, 0.205, 0.21,
  0.215, 0.22, 0.225, 0.23, 0.235, 0.24, 0.245, 0.25, 0.255, 0.26,
  0.265, 0.27, 0.275, 0.28, 0.285, 0.29, 0.295, 0.3, 0.305, 0.31,
  0.315, 0.32, 0.325, 0.33, 0.335, 0.34, 0.345, 0.35, 0.355, 0.36,
  0.365, 0.37, 0.375, 0.38, 0.385, 0.39, 0.395, 0.4, 0.405, 0.41,
  0.415, 0.42, 0.425, 0.43, 0.435, 0.44, 0.445, 0.45, 0.455, 0.46,
  0.465, 0.47, 0.475, 0.48, 0.485, 0.49, 0.495, 0.5, 0.505, 0.51,
  0.515, 0.52, 0.525, 0.53, 0.535, 0.54, 0.545, 0.55, 0.555, 0.56,
  0.565, 0.57, 0.575, 0.58, 0.585, 0.59, 0.595, 0.6, 0.605, 0.61,
  0.615, 0.62, 0.625, 0.63, 0.635, 0.64, 0.645, 0.65, 0.655, 0.66,
  0.665, 0.67, 0.675, 0.68, 0.685, 0.69, 0.695, 0.7, 0.705, 0.71,
  0.715, 0.72, 0.725, 0.73, 0.735, 0.74, 0.745, 0.75, 0.755, 0.76,
  0.765, 0.77, 0.775, 0.78, 0.785, 0.79, 0.795, 0.8, 0.805, 0.81,
  0.815, 0.82, 0.825, 0.83, 0.835, 0.84, 0.845, 0.85, 0.855, 0.86,
  0.865, 0.87, 0.875, 0.88, 0.885, 0.89, 0.895, 0.9, 0.905, 0.91,
  0.915, 0.92, 0.925, 0.93, 0.935, 0.94, 0.945, 0.95, 0.955, 0.96,
  0.965, 0.97, 0.975, 0.98, 0.985, 0.99, 0.995, 1}; G4double
  G4NeutronHPFastLegendre::i1[401] = {0, -0.0049875, -0.00995,
  -0.0148875, -0.0198, -0.0246875, -0.02955, -0.0343875, -0.0392,
  -0.0439875, -0.04875, -0.0534875, -0.0582, -0.0628875, -0.06755,
  -0.0721875, -0.0768, -0.0813875, -0.08595, -0.0904875, -0.095,
  -0.0994875, -0.10395, -0.108387, -0.1128, -0.117187, -0.12155,
  -0.125887, -0.1302, -0.134487, -0.13875, -0.142987, -0.1472,
  -0.151387, -0.15555, -0.159687, -0.1638, -0.167887, -0.17195,
  -0.175987, -0.18, -0.183987, -0.18795, -0.191887, -0.1958,
  -0.199687, -0.20355, -0.207387, -0.2112, -0.214987, -0.21875,
  -0.222487, -0.2262, -0.229887, -0.23355, -0.237187, -0.2408,
  -0.244387, -0.24795, -0.251488, -0.255, -0.258487, -0.26195,
  -0.265387, -0.2688, -0.272187, -0.27555, -0.278887, -0.2822,
  -0.285487, -0.28875, -0.291987, -0.2952, -0.298387, -0.30155,
  -0.304687, -0.3078, -0.310887, -0.31395, -0.316987, -0.32,
  -0.322987, -0.32595, -0.328887, -0.3318, -0.334687, -0.33755,
  -0.340387, -0.3432, -0.345987, -0.34875, -0.351487, -0.3542,
  -0.356887, -0.35955, -0.362187, -0.3648, -0.367387, -0.36995,
  -0.372487, -0.375, -0.377487, -0.37995, -0.382387, -0.3848,
  -0.387187, -0.38955, -0.391887, -0.3942, -0.396487, -0.39875,
  -0.400987, -0.4032, -0.405387, -0.40755, -0.409687, -0.4118,
  -0.413887, -0.41595, -0.417987, -0.42, -0.421987, -0.42395,
  -0.425887, -0.4278, -0.429687, -0.43155, -0.433387, -0.4352,
  -0.436987, -0.43875, -0.440487, -0.4422, -0.443887, -0.44555,
  -0.447187, -0.4488, -0.450387, -0.45195, -0.453487, -0.455,
  -0.456487, -0.45795, -0.459387, -0.4608, -0.462187, -0.46355,
  -0.464887, -0.4662, -0.467487, -0.46875, -0.469987, -0.4712,
  -0.472387, -0.47355, -0.474687, -0.4758, -0.476887, -0.47795,
  -0.478987, -0.48, -0.480987, -0.48195, -0.482887, -0.4838,
  -0.484687, -0.48555, -0.486387, -0.4872, -0.487987, -0.48875,
  -0.489487, -0.4902, -0.490887, -0.49155, -0.492187, -0.4928,
  -0.493387, -0.49395, -0.494487, -0.495, -0.495488, -0.49595,
  -0.496387, -0.4968, -0.497188, -0.49755, -0.497887, -0.4982,
  -0.498487, -0.49875, -0.498987, -0.4992, -0.499387, -0.49955,
  -0.499687, -0.4998, -0.499887, -0.49995, -0.499987, -0.5, -0.499987,
  -0.49995, -0.499887, -0.4998, -0.499687, -0.49955, -0.499387,
  -0.4992, -0.498987, -0.49875, -0.498487, -0.4982, -0.497887,
  -0.49755, -0.497187, -0.4968, -0.496387, -0.49595, -0.495487,
  -0.495, -0.494487, -0.49395, -0.493387, -0.4928, -0.492187,
  -0.49155, -0.490887, -0.4902, -0.489487, -0.48875, -0.487987,
  -0.4872, -0.486387, -0.48555, -0.484687, -0.4838, -0.482887,
  -0.48195, -0.480987, -0.48, -0.478987, -0.47795, -0.476887, -0.4758,
  -0.474687, -0.47355, -0.472387, -0.4712, -0.469987, -0.46875,
  -0.467487, -0.4662, -0.464887, -0.46355, -0.462187, -0.4608,
  -0.459387, -0.45795, -0.456487, -0.455, -0.453487, -0.45195,
  -0.450387, -0.4488, -0.447187, -0.44555, -0.443887, -0.4422,
  -0.440487, -0.43875, -0.436987, -0.4352, -0.433387, -0.43155,
  -0.429687, -0.4278, -0.425887, -0.42395, -0.421987, -0.42,
  -0.417987, -0.41595, -0.413887, -0.4118, -0.409687, -0.40755,
  -0.405387, -0.4032, -0.400987, -0.39875, -0.396487, -0.3942,
  -0.391887, -0.38955, -0.387187, -0.3848, -0.382387, -0.37995,
  -0.377487, -0.375, -0.372487, -0.36995, -0.367387, -0.3648,
  -0.362187, -0.35955, -0.356887, -0.3542, -0.351487, -0.34875,
  -0.345987, -0.3432, -0.340387, -0.33755, -0.334687, -0.3318,
  -0.328887, -0.32595, -0.322987, -0.32, -0.316987, -0.31395,
  -0.310887, -0.3078, -0.304687, -0.30155, -0.298387, -0.2952,
  -0.291987, -0.28875, -0.285487, -0.2822, -0.278887, -0.27555,
  -0.272187, -0.2688, -0.265387, -0.26195, -0.258487, -0.255,
  -0.251487, -0.24795, -0.244387, -0.2408, -0.237187, -0.23355,
  -0.229887, -0.2262, -0.222487, -0.21875, -0.214987, -0.2112,
  -0.207387, -0.20355, -0.199687, -0.1958, -0.191887, -0.18795,
  -0.183987, -0.18, -0.175987, -0.17195, -0.167887, -0.1638,
  -0.159687, -0.15555, -0.151387, -0.1472, -0.142987, -0.13875,
  -0.134487, -0.1302, -0.125887, -0.12155, -0.117187, -0.1128,
  -0.108387, -0.10395, -0.0994875, -0.095, -0.0904875, -0.08595,
  -0.0813875, -0.0768, -0.0721875, -0.06755, -0.0628875, -0.0582,
  -0.0534875, -0.04875, -0.0439875, -0.0392, -0.0343875, -0.02955,
  -0.0246875, -0.0198, -0.0148875, -0.00995, -0.0049875, 3.23092e-17};
  G4double G4NeutronHPFastLegendre::l2[601] = {1, 0.990017, 0.980067,
  0.97015, 0.960267, 0.950417, 0.9406, 0.930817, 0.921067, 0.91135,
  0.901667, 0.892017, 0.8824, 0.872817, 0.863267, 0.85375, 0.844267,
  0.834817, 0.8254, 0.816017, 0.806667, 0.79735, 0.788067, 0.778817,
  0.7696, 0.760417, 0.751267, 0.74215, 0.733067, 0.724017, 0.715,
  0.706017, 0.697067, 0.68815, 0.679267, 0.670417, 0.6616, 0.652817,
  0.644067, 0.63535, 0.626667, 0.618017, 0.6094, 0.600817, 0.592267,
  0.58375, 0.575267, 0.566817, 0.5584, 0.550017, 0.541667, 0.53335,
  0.525067, 0.516817, 0.5086, 0.500417, 0.492267, 0.48415, 0.476067,
  0.468017, 0.46, 0.452017, 0.444067, 0.43615, 0.428267, 0.420417,
  0.4126, 0.404817, 0.397067, 0.38935, 0.381667, 0.374017, 0.3664,
  0.358817, 0.351267, 0.34375, 0.336267, 0.328817, 0.3214, 0.314017,
  0.306667, 0.29935, 0.292067, 0.284817, 0.2776, 0.270417, 0.263267,
  0.25615, 0.249067, 0.242017, 0.235, 0.228017, 0.221067, 0.21415,
  0.207267, 0.200417, 0.1936, 0.186817, 0.180067, 0.17335, 0.166667,
  0.160017, 0.1534, 0.146817, 0.140267, 0.13375, 0.127267, 0.120817,
  0.1144, 0.108017, 0.101667, 0.09535, 0.0890667, 0.0828167, 0.0766,
  0.0704167, 0.0642667, 0.05815, 0.0520667, 0.0460167, 0.04,
  0.0340167, 0.0280667, 0.02215, 0.0162667, 0.0104167, 0.0046,
  -0.00118333, -0.00693333, -0.01265, -0.0183333, -0.0239833, -0.0296,
  -0.0351833, -0.0407333, -0.04625, -0.0517333, -0.0571833, -0.0626,
  -0.0679833, -0.0733333, -0.07865, -0.0839333, -0.0891833, -0.0944,
  -0.0995833, -0.104733, -0.10985, -0.114933, -0.119983, -0.125,
  -0.129983, -0.134933, -0.13985, -0.144733, -0.149583, -0.1544,
  -0.159183, -0.163933, -0.16865, -0.173333, -0.177983, -0.1826,
  -0.187183, -0.191733, -0.19625, -0.200733, -0.205183, -0.2096,
  -0.213983, -0.218333, -0.22265, -0.226933, -0.231183, -0.2354,
  -0.239583, -0.243733, -0.24785, -0.251933, -0.255983, -0.26,
  -0.263983, -0.267933, -0.27185, -0.275733, -0.279583, -0.2834,
  -0.287183, -0.290933, -0.29465, -0.298333, -0.301983, -0.3056,
  -0.309183, -0.312733, -0.31625, -0.319733, -0.323183, -0.3266,
  -0.329983, -0.333333, -0.33665, -0.339933, -0.343183, -0.3464,
  -0.349583, -0.352733, -0.35585, -0.358933, -0.361983, -0.365,
  -0.367983, -0.370933, -0.37385, -0.376733, -0.379583, -0.3824,
  -0.385183, -0.387933, -0.39065, -0.393333, -0.395983, -0.3986,
  -0.401183, -0.403733, -0.40625, -0.408733, -0.411183, -0.4136,
  -0.415983, -0.418333, -0.42065, -0.422933, -0.425183, -0.4274,
  -0.429583, -0.431733, -0.43385, -0.435933, -0.437983, -0.44,
  -0.441983, -0.443933, -0.44585, -0.447733, -0.449583, -0.4514,
  -0.453183, -0.454933, -0.45665, -0.458333, -0.459983, -0.4616,
  -0.463183, -0.464733, -0.46625, -0.467733, -0.469183, -0.4706,
  -0.471983, -0.473333, -0.47465, -0.475933, -0.477183, -0.4784,
  -0.479583, -0.480733, -0.48185, -0.482933, -0.483983, -0.485,
  -0.485983, -0.486933, -0.48785, -0.488733, -0.489583, -0.4904,
  -0.491183, -0.491933, -0.49265, -0.493333, -0.493983, -0.4946,
  -0.495183, -0.495733, -0.49625, -0.496733, -0.497183, -0.4976,
  -0.497983, -0.498333, -0.49865, -0.498933, -0.499183, -0.4994,
  -0.499583, -0.499733, -0.49985, -0.499933, -0.499983, -0.5,
  -0.499983, -0.499933, -0.49985, -0.499733, -0.499583, -0.4994,
  -0.499183, -0.498933, -0.49865, -0.498333, -0.497983, -0.4976,
  -0.497183, -0.496733, -0.49625, -0.495733, -0.495183, -0.4946,
  -0.493983, -0.493333, -0.49265, -0.491933, -0.491183, -0.4904,
  -0.489583, -0.488733, -0.48785, -0.486933, -0.485983, -0.485,
  -0.483983, -0.482933, -0.48185, -0.480733, -0.479583, -0.4784,
  -0.477183, -0.475933, -0.47465, -0.473333, -0.471983, -0.4706,
  -0.469183, -0.467733, -0.46625, -0.464733, -0.463183, -0.4616,
  -0.459983, -0.458333, -0.45665, -0.454933, -0.453183, -0.4514,
  -0.449583, -0.447733, -0.44585, -0.443933, -0.441983, -0.44,
  -0.437983, -0.435933, -0.43385, -0.431733, -0.429583, -0.4274,
  -0.425183, -0.422933, -0.42065, -0.418333, -0.415983, -0.4136,
  -0.411183, -0.408733, -0.40625, -0.403733, -0.401183, -0.3986,
  -0.395983, -0.393333, -0.39065, -0.387933, -0.385183, -0.3824,
  -0.379583, -0.376733, -0.37385, -0.370933, -0.367983, -0.365,
  -0.361983, -0.358933, -0.35585, -0.352733, -0.349583, -0.3464,
  -0.343183, -0.339933, -0.33665, -0.333333, -0.329983, -0.3266,
  -0.323183, -0.319733, -0.31625, -0.312733, -0.309183, -0.3056,
  -0.301983, -0.298333, -0.29465, -0.290933, -0.287183, -0.2834,
  -0.279583, -0.275733, -0.27185, -0.267933, -0.263983, -0.26,
  -0.255983, -0.251933, -0.24785, -0.243733, -0.239583, -0.2354,
  -0.231183, -0.226933, -0.22265, -0.218333, -0.213983, -0.2096,
  -0.205183, -0.200733, -0.19625, -0.191733, -0.187183, -0.1826,
  -0.177983, -0.173333, -0.16865, -0.163933, -0.159183, -0.1544,
  -0.149583, -0.144733, -0.13985, -0.134933, -0.129983, -0.125,
  -0.119983, -0.114933, -0.10985, -0.104733, -0.0995833, -0.0944,
  -0.0891833, -0.0839333, -0.07865, -0.0733333, -0.0679833, -0.0626,
  -0.0571833, -0.0517333, -0.04625, -0.0407333, -0.0351833, -0.0296,
  -0.0239833, -0.0183333, -0.01265, -0.00693333, -0.00118333, 0.0046,
  0.0104167, 0.0162667, 0.02215, 0.0280667, 0.0340167, 0.04,
  0.0460167, 0.0520667, 0.05815, 0.0642667, 0.0704167, 0.0766,
  0.0828167, 0.0890667, 0.09535, 0.101667, 0.108017, 0.1144, 0.120817,
  0.127267, 0.13375, 0.140267, 0.146817, 0.1534, 0.160017, 0.166667,
  0.17335, 0.180067, 0.186817, 0.1936, 0.200417, 0.207267, 0.21415,
  0.221067, 0.228017, 0.235, 0.242017, 0.249067, 0.25615, 0.263267,
  0.270417, 0.2776, 0.284817, 0.292067, 0.29935, 0.306667, 0.314017,
  0.3214, 0.328817, 0.336267, 0.34375, 0.351267, 0.358817, 0.3664,
  0.374017, 0.381667, 0.38935, 0.397067, 0.404817, 0.4126, 0.420417,
  0.428267, 0.43615, 0.444067, 0.452017, 0.46, 0.468017, 0.476067,
  0.48415, 0.492267, 0.500417, 0.5086, 0.516817, 0.525067, 0.53335,
  0.541667, 0.550017, 0.5584, 0.566817, 0.575267, 0.58375, 0.592267,
  0.600817, 0.6094, 0.618017, 0.626667, 0.63535, 0.644067, 0.652817,
  0.6616, 0.670417, 0.679267, 0.68815, 0.697067, 0.706017, 0.715,
  0.724017, 0.733067, 0.74215, 0.751267, 0.760417, 0.7696, 0.778817,
  0.788067, 0.79735, 0.806667, 0.816017, 0.8254, 0.834817, 0.844267,
  0.85375, 0.863267, 0.872817, 0.8824, 0.892017, 0.901667, 0.91135,
  0.921067, 0.930817, 0.9406, 0.950417, 0.960267, 0.97015, 0.980067,
  0.990017, 1}; G4double G4NeutronHPFastLegendre::i2[601] = {0,
  0.00331668, 0.00660015, 0.0098505, 0.0130679, 0.0162523, 0.019404,
  0.022523, 0.0256095, 0.0286635, 0.0316852, 0.0346746, 0.037632,
  0.0405573, 0.0434508, 0.0463125, 0.0491425, 0.051941, 0.054708,
  0.0574437, 0.0601481, 0.0628215, 0.0654638, 0.0680753, 0.070656,
  0.073206, 0.0757255, 0.0782145, 0.0806732, 0.0831016, 0.0855,
  0.0878683, 0.0902068, 0.0925155, 0.0947945, 0.097044, 0.099264,
  0.101455, 0.103616, 0.105748, 0.107852, 0.109926, 0.111972,
  0.113989, 0.115977, 0.117937, 0.119869, 0.121773, 0.123648,
  0.125495, 0.127315, 0.129106, 0.130871, 0.132607, 0.134316,
  0.135998, 0.137652, 0.139279, 0.14088, 0.142453, 0.144, 0.14552,
  0.147013, 0.14848, 0.149921, 0.151336, 0.152724, 0.154086, 0.155423,
  0.156733, 0.158018, 0.159278, 0.160512, 0.161721, 0.162904,
  0.164062, 0.165196, 0.166304, 0.167388, 0.168447, 0.169481,
  0.170491, 0.171477, 0.172439, 0.173376, 0.174289, 0.175179,
  0.176044, 0.176886, 0.177705, 0.1785, 0.179272, 0.18002, 0.180745,
  0.181448, 0.182127, 0.182784, 0.183418, 0.184029, 0.184618,
  0.185185, 0.18573, 0.186252, 0.186752, 0.187231, 0.187687, 0.188122,
  0.188536, 0.188928, 0.189299, 0.189648, 0.189976, 0.190284, 0.19057,
  0.190836, 0.191081, 0.191305, 0.191509, 0.191693, 0.191857, 0.192,
  0.192123, 0.192227, 0.19231, 0.192374, 0.192419, 0.192444, 0.19245,
  0.192436, 0.192403, 0.192352, 0.192281, 0.192192, 0.192084,
  0.191957, 0.191812, 0.191649, 0.191468, 0.191268, 0.19105, 0.190815,
  0.190561, 0.19029, 0.190002, 0.189696, 0.189373, 0.189032, 0.188674,
  0.1883, 0.187908, 0.1875, 0.187075, 0.186633, 0.186175, 0.185701,
  0.185211, 0.184704, 0.184181, 0.183643, 0.183088, 0.182518,
  0.181933, 0.181332, 0.180716, 0.180084, 0.179437, 0.178776,
  0.178099, 0.177408, 0.176702, 0.175981, 0.175246, 0.174497,
  0.173734, 0.172956, 0.172164, 0.171359, 0.170539, 0.169706, 0.16886,
  0.168, 0.167127, 0.16624, 0.16534, 0.164428, 0.163502, 0.162564,
  0.161613, 0.160649, 0.159673, 0.158685, 0.157685, 0.156672,
  0.155647, 0.154611, 0.153562, 0.152502, 0.151431, 0.150348,
  0.149254, 0.148148, 0.147031, 0.145904, 0.144765, 0.143616,
  0.142456, 0.141285, 0.140104, 0.138913, 0.137712, 0.1365, 0.135278,
  0.134047, 0.132805, 0.131554, 0.130294, 0.129024, 0.127745,
  0.126456, 0.125158, 0.123852, 0.122536, 0.121212, 0.119879,
  0.118537, 0.117187, 0.115829, 0.114463, 0.113088, 0.111705,
  0.110315, 0.108916, 0.10751, 0.106097, 0.104676, 0.103248, 0.101812,
  0.100369, 0.0989198, 0.0974632, 0.0959999, 0.0945299, 0.0930534,
  0.0915704, 0.0900811, 0.0885856, 0.0870839, 0.0855763, 0.0840627,
  0.0825434, 0.0810184, 0.0794879, 0.0779519, 0.0764106, 0.0748641,
  0.0733124, 0.0717558, 0.0701942, 0.0686279, 0.0670569, 0.0654814,
  0.0639014, 0.0623171, 0.0607286, 0.0591359, 0.0575393, 0.0559387,
  0.0543344, 0.0527264, 0.0511149, 0.0494999, 0.0478816, 0.0462601,
  0.0446354, 0.0430078, 0.0413772, 0.0397439, 0.0381079, 0.0364694,
  0.0348284, 0.0331851, 0.0315396, 0.0298919, 0.0282423, 0.0265907,
  0.0249374, 0.0232824, 0.0216259, 0.0199679, 0.0183086, 0.0166481,
  0.0149864, 0.0133238, 0.0116602, 0.00999591, 0.00833093, 0.0066654,
  0.00499941, 0.0033331, 0.00166656, -8.68056e-08, -0.00166674,
  -0.00333327, -0.00499959, -0.00666557, -0.00833111, -0.00999609,
  -0.0116604, -0.0133239, -0.0149866, -0.0166482, -0.0183088,
  -0.0199681, -0.0216261, -0.0232826, -0.0249376, -0.0265909,
  -0.0282424, -0.0298921, -0.0315397, -0.0331853, -0.0348286,
  -0.0364696, -0.0381081, -0.0397441, -0.0413774, -0.0430079,
  -0.0446356, -0.0462602, -0.0478818, -0.0495001, -0.0511151,
  -0.0527266, -0.0543346, -0.0559389, -0.0575394, -0.0591361,
  -0.0607287, -0.0623173, -0.0639016, -0.0654816, -0.0670571,
  -0.0686281, -0.0701944, -0.071756, -0.0733126, -0.0748642,
  -0.0764108, -0.0779521, -0.0794881, -0.0810186, -0.0825436,
  -0.0840629, -0.0855765, -0.0870841, -0.0885858, -0.0900813,
  -0.0915706, -0.0930536, -0.0945301, -0.0960001, -0.0974634,
  -0.09892, -0.10037, -0.101812, -0.103248, -0.104676, -0.106097,
  -0.107511, -0.108917, -0.110315, -0.111705, -0.113088, -0.114463,
  -0.115829, -0.117188, -0.118538, -0.119879, -0.121212, -0.122536,
  -0.123852, -0.125159, -0.126456, -0.127745, -0.129024, -0.130294,
  -0.131555, -0.132806, -0.134047, -0.135278, -0.1365, -0.137712,
  -0.138913, -0.140105, -0.141286, -0.142456, -0.143616, -0.144765,
  -0.145904, -0.147032, -0.148148, -0.149254, -0.150348, -0.151431,
  -0.152503, -0.153563, -0.154611, -0.155647, -0.156672, -0.157685,
  -0.158685, -0.159674, -0.16065, -0.161613, -0.162564, -0.163502,
  -0.164428, -0.165341, -0.16624, -0.167127, -0.168, -0.16886,
  -0.169707, -0.17054, -0.171359, -0.172164, -0.172956, -0.173734,
  -0.174497, -0.175247, -0.175982, -0.176702, -0.177408, -0.178099,
  -0.178776, -0.179438, -0.180084, -0.180716, -0.181332, -0.181933,
  -0.182519, -0.183089, -0.183643, -0.184181, -0.184704, -0.185211,
  -0.185701, -0.186176, -0.186634, -0.187075, -0.1875, -0.187908,
  -0.1883, -0.188675, -0.189032, -0.189373, -0.189696, -0.190002,
  -0.190291, -0.190562, -0.190815, -0.19105, -0.191268, -0.191468,
  -0.191649, -0.191813, -0.191958, -0.192084, -0.192192, -0.192281,
  -0.192352, -0.192404, -0.192436, -0.19245, -0.192444, -0.192419,
  -0.192375, -0.192311, -0.192227, -0.192123, -0.192, -0.191857,
  -0.191693, -0.19151, -0.191306, -0.191081, -0.190836, -0.19057,
  -0.190284, -0.189977, -0.189648, -0.189299, -0.188928, -0.188536,
  -0.188123, -0.187688, -0.187231, -0.186752, -0.186252, -0.18573,
  -0.185185, -0.184619, -0.18403, -0.183418, -0.182784, -0.182127,
  -0.181448, -0.180746, -0.18002, -0.179272, -0.1785, -0.177705,
  -0.176887, -0.176045, -0.175179, -0.17429, -0.173376, -0.172439,
  -0.171477, -0.170492, -0.169482, -0.168447, -0.167388, -0.166304,
  -0.165196, -0.164063, -0.162904, -0.161721, -0.160512, -0.159278,
  -0.158019, -0.156734, -0.155423, -0.154087, -0.152724, -0.151336,
  -0.149921, -0.148481, -0.147014, -0.14552, -0.144, -0.142453,
  -0.14088, -0.13928, -0.137652, -0.135998, -0.134316, -0.132607,
  -0.130871, -0.129107, -0.127315, -0.125496, -0.123648, -0.121773,
  -0.119869, -0.117938, -0.115978, -0.113989, -0.111972, -0.109926,
  -0.107852, -0.105749, -0.103616, -0.101455, -0.0992642, -0.0970441,
  -0.0947947, -0.0925157, -0.090207, -0.0878685, -0.0855002,
  -0.0831018, -0.0806734, -0.0782147, -0.0757256, -0.0732062,
  -0.0706562, -0.0680755, -0.065464, -0.0628217, -0.0601483,
  -0.0574439, -0.0547082, -0.0519412, -0.0491427, -0.0463127,
  -0.043451, -0.0405575, -0.0376322, -0.0346748, -0.0316854,
  -0.0286637, -0.0256097, -0.0225232, -0.0194042, -0.0162525,
  -0.013068, -0.00985067, -0.00660032, -0.00331686, -1.73611e-07};
  G4double G4NeutronHPFastLegendre::l3[801] = {-1, -0.985047,
  -0.970187, -0.955421, -0.940747, -0.926167, -0.911679, -0.897283,
  -0.88298, -0.868768, -0.854648, -0.84062, -0.826682, -0.812836,
  -0.79908, -0.785415, -0.77184, -0.758355, -0.74496, -0.731654,
  -0.718437, -0.70531, -0.692272, -0.679322, -0.66646, -0.653687,
  -0.641001, -0.628403, -0.615893, -0.603469, -0.591133, -0.578883,
  -0.56672, -0.554643, -0.542652, -0.530747, -0.518928, -0.507193,
  -0.495544, -0.48398, -0.4725, -0.461105, -0.449793, -0.438566,
  -0.427423, -0.416362, -0.405385, -0.394491, -0.38368, -0.372951,
  -0.362305, -0.35174, -0.341257, -0.330856, -0.320537, -0.310298,
  -0.30014, -0.290063, -0.280066, -0.270149, -0.260313, -0.250555,
  -0.240878, -0.231279, -0.22176, -0.212319, -0.202957, -0.193673,
  -0.184467, -0.175339, -0.166289, -0.157316, -0.14842, -0.139601,
  -0.130858, -0.122192, -0.113603, -0.105089, -0.0966503, -0.0882875,
  -0.08, -0.0717875, -0.0636497, -0.0555864, -0.0475975, -0.0396826,
  -0.0318416, -0.0240741, -0.01638, -0.00875902, -0.00121094,
  0.00626449, 0.0136675, 0.0209983, 0.0282572, 0.0354443, 0.04256,
  0.0496044, 0.0565778, 0.0634804, 0.0703125, 0.0770743, 0.0837659,
  0.0903878, 0.09694, 0.103423, 0.109837, 0.116181, 0.122457,
  0.128665, 0.134805, 0.140876, 0.14688, 0.152816, 0.158685, 0.164487,
  0.170223, 0.175891, 0.181493, 0.18703, 0.1925, 0.197905, 0.203244,
  0.208518, 0.213728, 0.218872, 0.223952, 0.228968, 0.23392, 0.238808,
  0.243633, 0.248394, 0.253092, 0.257728, 0.262301, 0.266812, 0.27126,
  0.275647, 0.279972, 0.284235, 0.288437, 0.292579, 0.29666, 0.30068,
  0.30464, 0.30854, 0.31238, 0.316161, 0.319882, 0.323545, 0.327148,
  0.330693, 0.33418, 0.337608, 0.340979, 0.344292, 0.347547, 0.350746,
  0.353887, 0.356972, 0.36, 0.362972, 0.365888, 0.368748, 0.371552,
  0.374302, 0.376996, 0.379635, 0.38222, 0.38475, 0.387227, 0.389649,
  0.392017, 0.394333, 0.396595, 0.398804, 0.40096, 0.403064, 0.405115,
  0.407115, 0.409062, 0.410959, 0.412803, 0.414597, 0.41634, 0.418032,
  0.419674, 0.421266, 0.422808, 0.4243, 0.425742, 0.427136, 0.42848,
  0.429776, 0.431023, 0.432222, 0.433372, 0.434476, 0.435531,
  0.436539, 0.4375, 0.438414, 0.439282, 0.440103, 0.440878, 0.441606,
  0.44229, 0.442927, 0.44352, 0.444068, 0.44457, 0.445029, 0.445442,
  0.445812, 0.446138, 0.446421, 0.44666, 0.446856, 0.447009, 0.447119,
  0.447187, 0.447213, 0.447197, 0.447139, 0.44704, 0.446899, 0.446718,
  0.446495, 0.446232, 0.445929, 0.445586, 0.445203, 0.44478, 0.444318,
  0.443817, 0.443276, 0.442697, 0.44208, 0.441425, 0.440731, 0.44,
  0.439231, 0.438425, 0.437582, 0.436702, 0.435786, 0.434833,
  0.433845, 0.43282, 0.43176, 0.430664, 0.429533, 0.428368, 0.427167,
  0.425932, 0.424663, 0.42336, 0.422023, 0.420653, 0.419249, 0.417812,
  0.416343, 0.414841, 0.413307, 0.41174, 0.410142, 0.408512, 0.40685,
  0.405158, 0.403434, 0.40168, 0.399895, 0.39808, 0.396235, 0.39436,
  0.392456, 0.390522, 0.38856, 0.386568, 0.384548, 0.3825, 0.380423,
  0.378319, 0.376187, 0.374027, 0.371841, 0.369627, 0.367387, 0.36512,
  0.362827, 0.360508, 0.358163, 0.355793, 0.353397, 0.350976, 0.34853,
  0.34606, 0.343565, 0.341047, 0.338504, 0.335938, 0.333348, 0.330735,
  0.328099, 0.32544, 0.322759, 0.320055, 0.31733, 0.314582, 0.311814,
  0.309023, 0.306212, 0.30338, 0.300527, 0.297654, 0.294761, 0.291847,
  0.288915, 0.285962, 0.282991, 0.28, 0.276991, 0.273963, 0.270917,
  0.267852, 0.264771, 0.261671, 0.258554, 0.25542, 0.252269, 0.249102,
  0.245918, 0.242718, 0.239501, 0.23627, 0.233022, 0.22976, 0.226483,
  0.22319, 0.219884, 0.216562, 0.213227, 0.209878, 0.206516, 0.20314,
  0.199751, 0.196349, 0.192934, 0.189507, 0.186068, 0.182617,
  0.179154, 0.17568, 0.172194, 0.168698, 0.16519, 0.161672, 0.158144,
  0.154606, 0.151058, 0.1475, 0.143933, 0.140357, 0.136771, 0.133177,
  0.129575, 0.125965, 0.122346, 0.11872, 0.115086, 0.111445, 0.107797,
  0.104142, 0.100481, 0.0968134, 0.0931396, 0.08946, 0.0857747,
  0.0820841, 0.0783882, 0.0746875, 0.0709821, 0.0672722, 0.0635581,
  0.05984, 0.0561182, 0.0523928, 0.0486642, 0.0449325, 0.041198,
  0.0374609, 0.0337215, 0.02998, 0.0262366, 0.0224916, 0.0187451,
  0.0149975, 0.0112489, 0.00749969, 0.00374996, -0, -0.00374996,
  -0.00749969, -0.0112489, -0.0149975, -0.0187451, -0.0224916,
  -0.0262366, -0.02998, -0.0337215, -0.0374609, -0.041198, -0.0449325,
  -0.0486642, -0.0523928, -0.0561182, -0.05984, -0.0635581,
  -0.0672722, -0.0709821, -0.0746875, -0.0783882, -0.0820841,
  -0.0857747, -0.08946, -0.0931396, -0.0968134, -0.100481, -0.104142,
  -0.107797, -0.111445, -0.115086, -0.11872, -0.122346, -0.125965,
  -0.129575, -0.133177, -0.136771, -0.140357, -0.143933, -0.1475,
  -0.151058, -0.154606, -0.158144, -0.161672, -0.16519, -0.168698,
  -0.172194, -0.17568, -0.179154, -0.182617, -0.186068, -0.189507,
  -0.192934, -0.196349, -0.199751, -0.20314, -0.206516, -0.209878,
  -0.213227, -0.216562, -0.219884, -0.22319, -0.226483, -0.22976,
  -0.233022, -0.23627, -0.239501, -0.242718, -0.245918, -0.249102,
  -0.252269, -0.25542, -0.258554, -0.261671, -0.264771, -0.267852,
  -0.270917, -0.273963, -0.276991, -0.28, -0.282991, -0.285962,
  -0.288915, -0.291847, -0.294761, -0.297654, -0.300527, -0.30338,
  -0.306212, -0.309023, -0.311814, -0.314582, -0.31733, -0.320055,
  -0.322759, -0.32544, -0.328099, -0.330735, -0.333348, -0.335938,
  -0.338504, -0.341047, -0.343565, -0.34606, -0.34853, -0.350976,
  -0.353397, -0.355793, -0.358163, -0.360508, -0.362827, -0.36512,
  -0.367387, -0.369627, -0.371841, -0.374027, -0.376187, -0.378319,
  -0.380423, -0.3825, -0.384548, -0.386568, -0.38856, -0.390522,
  -0.392456, -0.39436, -0.396235, -0.39808, -0.399895, -0.40168,
  -0.403434, -0.405158, -0.40685, -0.408512, -0.410142, -0.41174,
  -0.413307, -0.414841, -0.416343, -0.417812, -0.419249, -0.420653,
  -0.422023, -0.42336, -0.424663, -0.425932, -0.427167, -0.428368,
  -0.429533, -0.430664, -0.43176, -0.43282, -0.433845, -0.434833,
  -0.435786, -0.436702, -0.437582, -0.438425, -0.439231, -0.44,
  -0.440731, -0.441425, -0.44208, -0.442697, -0.443276, -0.443817,
  -0.444318, -0.44478, -0.445203, -0.445586, -0.445929, -0.446232,
  -0.446495, -0.446718, -0.446899, -0.44704, -0.447139, -0.447197,
  -0.447213, -0.447187, -0.447119, -0.447009, -0.446856, -0.44666,
  -0.446421, -0.446138, -0.445812, -0.445442, -0.445029, -0.44457,
  -0.444068, -0.44352, -0.442927, -0.44229, -0.441606, -0.440878,
  -0.440103, -0.439282, -0.438414, -0.4375, -0.436539, -0.435531,
  -0.434476, -0.433372, -0.432222, -0.431023, -0.429776, -0.42848,
  -0.427136, -0.425742, -0.4243, -0.422808, -0.421266, -0.419674,
  -0.418032, -0.41634, -0.414597, -0.412803, -0.410959, -0.409062,
  -0.407115, -0.405115, -0.403064, -0.40096, -0.398804, -0.396595,
  -0.394333, -0.392017, -0.389649, -0.387227, -0.38475, -0.38222,
  -0.379635, -0.376996, -0.374302, -0.371552, -0.368748, -0.365888,
  -0.362972, -0.36, -0.356972, -0.353887, -0.350746, -0.347547,
  -0.344292, -0.340979, -0.337608, -0.33418, -0.330693, -0.327148,
  -0.323545, -0.319882, -0.316161, -0.31238, -0.30854, -0.30464,
  -0.30068, -0.29666, -0.292579, -0.288437, -0.284235, -0.279972,
  -0.275647, -0.27126, -0.266812, -0.262301, -0.257728, -0.253092,
  -0.248394, -0.243633, -0.238808, -0.23392, -0.228968, -0.223952,
  -0.218872, -0.213728, -0.208518, -0.203244, -0.197905, -0.1925,
  -0.18703, -0.181493, -0.175891, -0.170223, -0.164487, -0.158685,
  -0.152816, -0.14688, -0.140876, -0.134805, -0.128665, -0.122457,
  -0.116181, -0.109837, -0.103423, -0.09694, -0.0903878, -0.0837659,
  -0.0770743, -0.0703125, -0.0634804, -0.0565778, -0.0496044,
  -0.04256, -0.0354443, -0.0282572, -0.0209983, -0.0136675,
  -0.00626449, 0.00121094, 0.00875902, 0.01638, 0.0240741, 0.0318416,
  0.0396826, 0.0475975, 0.0555864, 0.0636497, 0.0717875, 0.08,
  0.0882875, 0.0966503, 0.105089, 0.113603, 0.122192, 0.130858,
  0.139601, 0.14842, 0.157316, 0.166289, 0.175339, 0.184467, 0.193673,
  0.202957, 0.212319, 0.22176, 0.231279, 0.240878, 0.250555, 0.260313,
  0.270149, 0.280066, 0.290063, 0.30014, 0.310298, 0.320537, 0.330856,
  0.341257, 0.35174, 0.362305, 0.372951, 0.38368, 0.394491, 0.405385,
  0.416362, 0.427423, 0.438566, 0.449793, 0.461105, 0.4725, 0.48398,
  0.495544, 0.507193, 0.518928, 0.530747, 0.542652, 0.554643, 0.56672,
  0.578883, 0.591133, 0.603469, 0.615893, 0.628403, 0.641001,
  0.653687, 0.66646, 0.679322, 0.692272, 0.70531, 0.718437, 0.731654,
  0.74496, 0.758355, 0.77184, 0.785415, 0.79908, 0.812836, 0.826682,
  0.84062, 0.854648, 0.868768, 0.88298, 0.897283, 0.911679, 0.926167,
  0.940747, 0.955421, 0.970187, 0.985047, 1}; G4double
  G4NeutronHPFastLegendre::i3[801] = {0, -0.00248129, -0.00492531,
  -0.0073323, -0.00970249, -0.0120361, -0.0143334, -0.0165946,
  -0.0188199, -0.0210096, -0.0231638, -0.0252829, -0.027367,
  -0.0294164, -0.0314312, -0.0334118, -0.0353584, -0.0372711,
  -0.0391502, -0.040996, -0.0428086, -0.0445882, -0.0463352,
  -0.0480497, -0.0497319, -0.0513821, -0.0530004, -0.0545871,
  -0.0561425, -0.0576667, -0.0591599, -0.0606224, -0.0620544,
  -0.0634561, -0.0648277, -0.0661694, -0.0674815, -0.0687641,
  -0.0700175, -0.0712419, -0.0724375, -0.0736045, -0.0747431,
  -0.0758535, -0.076936, -0.0779907, -0.0790178, -0.0800177,
  -0.0809904, -0.0819361, -0.0828552, -0.0837477, -0.084614,
  -0.0854541, -0.0862683, -0.0870568, -0.0878199, -0.0885576,
  -0.0892702, -0.089958, -0.0906211, -0.0912596, -0.0918739,
  -0.0924641, -0.0930304, -0.0935729, -0.094092, -0.0945878,
  -0.0950605, -0.0955102, -0.0959372, -0.0963417, -0.0967239,
  -0.0970839, -0.0974219, -0.0977382, -0.098033, -0.0983063,
  -0.0985585, -0.0987896, -0.099, -0.0991897, -0.099359, -0.099508,
  -0.0996369, -0.099746, -0.0998354, -0.0999053, -0.0999559,
  -0.0999873, -0.0999997, -0.0999934, -0.0999684, -0.0999251,
  -0.0998635, -0.0997839, -0.0996863, -0.0995711, -0.0994384,
  -0.0992883, -0.099121, -0.0989368, -0.0987357, -0.098518,
  -0.0982838, -0.0980334, -0.0977668, -0.0974843, -0.0971859,
  -0.096872, -0.0965427, -0.0961981, -0.0958383, -0.0954637,
  -0.0950743, -0.0946703, -0.0942519, -0.0938193, -0.0933725,
  -0.0929119, -0.0924374, -0.0919494, -0.091448, -0.0909333,
  -0.0904054, -0.0898647, -0.0893111, -0.088745, -0.0881663,
  -0.0875754, -0.0869723, -0.0863573, -0.0857304, -0.0850919,
  -0.0844418, -0.0837804, -0.0831078, -0.0824242, -0.0817296,
  -0.0810244, -0.0803085, -0.0795822, -0.0788457, -0.078099,
  -0.0773423, -0.0765758, -0.0757997, -0.075014, -0.0742189,
  -0.0734146, -0.0726012, -0.0717789, -0.0709478, -0.0701081,
  -0.0692598, -0.0684032, -0.0675384, -0.0666655, -0.0657847,
  -0.0648961, -0.0639999, -0.0630962, -0.0621851, -0.0612668,
  -0.0603414, -0.0594091, -0.05847, -0.0575241, -0.0565718,
  -0.0556131, -0.0546481, -0.053677, -0.0526999, -0.051717,
  -0.0507283, -0.049734, -0.0487343, -0.0477293, -0.046719,
  -0.0457037, -0.0446835, -0.0436585, -0.0426288, -0.0415945,
  -0.0405558, -0.0395128, -0.0384657, -0.0374145, -0.0363594,
  -0.0353005, -0.0342379, -0.0331718, -0.0321023, -0.0310295,
  -0.0299535, -0.0288744, -0.0277924, -0.0267076, -0.0256201,
  -0.02453, -0.0234374, -0.0223425, -0.0212454, -0.0201461,
  -0.0190449, -0.0179418, -0.0168369, -0.0157304, -0.0146223,
  -0.0135128, -0.012402, -0.01129, -0.0101769, -0.00906282,
  -0.00794787, -0.00683216, -0.0057158, -0.0045989, -0.00348156,
  -0.00236389, -0.001246, -0.000127986, 0.000990036, 0.00210797,
  0.0032257, 0.00434313, 0.00546016, 0.00657669, 0.00769261,
  0.00880782, 0.00992222, 0.0110357, 0.0121482, 0.0132596, 0.0143698,
  0.0154786, 0.0165861, 0.0176921, 0.0187965, 0.0198992, 0.0210001,
  0.0220991, 0.0231962, 0.0242912, 0.0253841, 0.0264747, 0.027563,
  0.0286489, 0.0297322, 0.0308129, 0.031891, 0.0329662, 0.0340386,
  0.035108, 0.0361744, 0.0372377, 0.0382977, 0.0393544, 0.0404078,
  0.0414577, 0.042504, 0.0435467, 0.0445857, 0.0456209, 0.0466522,
  0.0476796, 0.0487029, 0.0497221, 0.0507371, 0.0517479, 0.0527543,
  0.0537562, 0.0547537, 0.0557466, 0.0567349, 0.0577184, 0.0586971,
  0.059671, 0.0606399, 0.0616038, 0.0625626, 0.0635163, 0.0644647,
  0.0654078, 0.0663456, 0.067278, 0.0682048, 0.0691261, 0.0700417,
  0.0709517, 0.0718558, 0.0727542, 0.0736466, 0.0745331, 0.0754136,
  0.076288, 0.0771562, 0.0780183, 0.078874, 0.0797235, 0.0805665,
  0.0814031, 0.0822332, 0.0830568, 0.0838737, 0.084684, 0.0854875,
  0.0862842, 0.0870741, 0.0878571, 0.0886332, 0.0894022, 0.0901642,
  0.0909191, 0.0916668, 0.0924074, 0.0931406, 0.0938666, 0.0945852,
  0.0952964, 0.0960001, 0.0966964, 0.0973851, 0.0980662, 0.0987396,
  0.0994054, 0.100063, 0.100714, 0.101356, 0.101991, 0.102618,
  0.103236, 0.103847, 0.10445, 0.105045, 0.105631, 0.10621, 0.10678,
  0.107342, 0.107896, 0.108442, 0.108979, 0.109508, 0.110028, 0.11054,
  0.111044, 0.111539, 0.112026, 0.112504, 0.112973, 0.113434,
  0.113886, 0.11433, 0.114765, 0.115191, 0.115608, 0.116017, 0.116416,
  0.116807, 0.117189, 0.117563, 0.117927, 0.118282, 0.118629,
  0.118966, 0.119295, 0.119614, 0.119924, 0.120226, 0.120518,
  0.120801, 0.121075, 0.12134, 0.121596, 0.121843, 0.12208, 0.122308,
  0.122527, 0.122737, 0.122938, 0.123129, 0.123311, 0.123484,
  0.123647, 0.123802, 0.123947, 0.124082, 0.124209, 0.124326,
  0.124433, 0.124532, 0.124621, 0.1247, 0.12477, 0.124831, 0.124883,
  0.124925, 0.124958, 0.124981, 0.124995, 0.125, 0.124995, 0.124981,
  0.124958, 0.124925, 0.124883, 0.124831, 0.12477, 0.1247, 0.124621,
  0.124532, 0.124433, 0.124326, 0.124209, 0.124082, 0.123947,
  0.123802, 0.123647, 0.123484, 0.123311, 0.123129, 0.122938,
  0.122737, 0.122527, 0.122308, 0.12208, 0.121843, 0.121596, 0.12134,
  0.121075, 0.120801, 0.120518, 0.120226, 0.119924, 0.119614,
  0.119295, 0.118966, 0.118629, 0.118282, 0.117927, 0.117563,
  0.117189, 0.116807, 0.116416, 0.116017, 0.115608, 0.115191,
  0.114765, 0.11433, 0.113886, 0.113434, 0.112973, 0.112504, 0.112026,
  0.111539, 0.111044, 0.11054, 0.110028, 0.109508, 0.108979, 0.108442,
  0.107896, 0.107342, 0.10678, 0.10621, 0.105631, 0.105045, 0.10445,
  0.103847, 0.103236, 0.102618, 0.101991, 0.101356, 0.100714,
  0.100063, 0.0994054, 0.0987396, 0.0980662, 0.0973851, 0.0966964,
  0.0960001, 0.0952964, 0.0945852, 0.0938666, 0.0931406, 0.0924074,
  0.0916668, 0.0909191, 0.0901642, 0.0894022, 0.0886332, 0.0878571,
  0.0870741, 0.0862842, 0.0854875, 0.084684, 0.0838737, 0.0830568,
  0.0822332, 0.0814031, 0.0805665, 0.0797235, 0.078874, 0.0780183,
  0.0771562, 0.076288, 0.0754136, 0.0745331, 0.0736466, 0.0727542,
  0.0718558, 0.0709517, 0.0700417, 0.0691261, 0.0682048, 0.067278,
  0.0663456, 0.0654078, 0.0644647, 0.0635163, 0.0625626, 0.0616038,
  0.0606399, 0.059671, 0.0586971, 0.0577184, 0.0567349, 0.0557466,
  0.0547537, 0.0537562, 0.0527543, 0.0517479, 0.0507371, 0.0497221,
  0.0487029, 0.0476796, 0.0466522, 0.0456209, 0.0445857, 0.0435467,
  0.042504, 0.0414577, 0.0404078, 0.0393544, 0.0382977, 0.0372377,
  0.0361744, 0.035108, 0.0340386, 0.0329662, 0.031891, 0.0308129,
  0.0297322, 0.0286489, 0.027563, 0.0264747, 0.0253841, 0.0242912,
  0.0231962, 0.0220991, 0.0210001, 0.0198992, 0.0187965, 0.0176921,
  0.0165861, 0.0154786, 0.0143698, 0.0132596, 0.0121482, 0.0110357,
  0.00992222, 0.00880782, 0.00769261, 0.00657669, 0.00546016,
  0.00434313, 0.0032257, 0.00210797, 0.000990036, -0.000127986,
  -0.001246, -0.00236389, -0.00348156, -0.0045989, -0.0057158,
  -0.00683216, -0.00794787, -0.00906282, -0.0101769, -0.01129,
  -0.012402, -0.0135128, -0.0146223, -0.0157304, -0.0168369,
  -0.0179418, -0.0190449, -0.0201461, -0.0212454, -0.0223425,
  -0.0234374, -0.02453, -0.0256201, -0.0267076, -0.0277924,
  -0.0288744, -0.0299535, -0.0310295, -0.0321023, -0.0331718,
  -0.0342379, -0.0353005, -0.0363594, -0.0374145, -0.0384657,
  -0.0395128, -0.0405558, -0.0415945, -0.0426288, -0.0436585,
  -0.0446835, -0.0457037, -0.046719, -0.0477293, -0.0487343,
  -0.049734, -0.0507283, -0.051717, -0.0526999, -0.053677, -0.0546481,
  -0.0556131, -0.0565718, -0.0575241, -0.05847, -0.0594091,
  -0.0603414, -0.0612668, -0.0621851, -0.0630962, -0.0639999,
  -0.0648961, -0.0657847, -0.0666655, -0.0675384, -0.0684032,
  -0.0692598, -0.0701081, -0.0709478, -0.0717789, -0.0726012,
  -0.0734146, -0.0742189, -0.075014, -0.0757997, -0.0765758,
  -0.0773423, -0.078099, -0.0788457, -0.0795822, -0.0803085,
  -0.0810244, -0.0817296, -0.0824242, -0.0831078, -0.0837804,
  -0.0844418, -0.0850919, -0.0857304, -0.0863573, -0.0869723,
  -0.0875754, -0.0881663, -0.088745, -0.0893111, -0.0898647,
  -0.0904054, -0.0909333, -0.091448, -0.0919494, -0.0924374,
  -0.0929119, -0.0933725, -0.0938193, -0.0942519, -0.0946703,
  -0.0950743, -0.0954637, -0.0958383, -0.0961981, -0.0965427,
  -0.096872, -0.0971859, -0.0974843, -0.0977668, -0.0980334,
  -0.0982838, -0.098518, -0.0987357, -0.0989368, -0.099121,
  -0.0992883, -0.0994384, -0.0995711, -0.0996863, -0.0997839,
  -0.0998635, -0.0999251, -0.0999684, -0.0999934, -0.0999997,
  -0.0999873, -0.0999559, -0.0999053, -0.0998354, -0.099746,
  -0.0996369, -0.099508, -0.099359, -0.0991897, -0.099, -0.0987896,
  -0.0985585, -0.0983063, -0.098033, -0.0977382, -0.0974219,
  -0.0970839, -0.0967239, -0.0963417, -0.0959372, -0.0955102,
  -0.0950605, -0.0945878, -0.094092, -0.0935729, -0.0930304,
  -0.0924641, -0.0918739, -0.0912596, -0.0906211, -0.089958,
  -0.0892702, -0.0885576, -0.0878199, -0.0870568, -0.0862683,
  -0.0854541, -0.084614, -0.0837477, -0.0828552, -0.0819361,
  -0.0809904, -0.0800177, -0.0790178, -0.0779907, -0.076936,
  -0.0758535, -0.0747431, -0.0736045, -0.0724375, -0.0712419,
  -0.0700175, -0.0687641, -0.0674815, -0.0661694, -0.0648277,
  -0.0634561, -0.0620544, -0.0606224, -0.0591599, -0.0576667,
  -0.0561425, -0.0545871, -0.0530004, -0.0513821, -0.0497319,
  -0.0480497, -0.0463352, -0.0445882, -0.0428086, -0.040996,
  -0.0391502, -0.0372711, -0.0353584, -0.0334118, -0.0314312,
  -0.0294164, -0.027367, -0.0252829, -0.0231638, -0.0210096,
  -0.0188199, -0.0165946, -0.0143334, -0.0120361, -0.00970249,
  -0.0073323, -0.00492531, -0.00248129, 2.63353e-16}; G4double
  G4NeutronHPFastLegendre::l4[1001] = {1, 0.98009, 0.960359, 0.940806,
  0.921431, 0.902233, 0.88321, 0.864362, 0.845689, 0.827188, 0.808861,
  0.790705, 0.77272, 0.754904, 0.737259, 0.719781, 0.702471, 0.685328,
  0.668351, 0.651539, 0.634891, 0.618407, 0.602086, 0.585926,
  0.569928, 0.55409, 0.538411, 0.522892, 0.50753, 0.492325, 0.477277,
  0.462384, 0.447646, 0.433062, 0.418631, 0.404353, 0.390226, 0.37625,
  0.362424, 0.348747, 0.335219, 0.321839, 0.308605, 0.295518,
  0.282577, 0.26978, 0.257126, 0.244616, 0.232249, 0.220023, 0.207937,
  0.195992, 0.184187, 0.17252, 0.16099, 0.149598, 0.138342, 0.127222,
  0.116236, 0.105385, 0.0946672, 0.0840819, 0.0736284, 0.0633061,
  0.0531142, 0.043052, 0.0331188, 0.0233138, 0.0136362, 0.00408544,
  -0.0053393, -0.0146387, -0.0238136, -0.0328645, -0.0417923,
  -0.0505977, -0.0592813, -0.0678439, -0.0762862, -0.084609,
  -0.0928128, -0.100898, -0.108867, -0.116718, -0.124453, -0.132073,
  -0.139579, -0.14697, -0.154248, -0.161414, -0.168467, -0.17541,
  -0.182242, -0.188964, -0.195577, -0.202081, -0.208478, -0.214767,
  -0.22095, -0.227028, -0.233, -0.238868, -0.244632, -0.250293,
  -0.255852, -0.261309, -0.266665, -0.27192, -0.277076, -0.282133,
  -0.287091, -0.291952, -0.296715, -0.301382, -0.305953, -0.310429,
  -0.314811, -0.319099, -0.323293, -0.327395, -0.331405, -0.335323,
  -0.339151, -0.342889, -0.346538, -0.350098, -0.353569, -0.356953,
  -0.360251, -0.363462, -0.366587, -0.369628, -0.372584, -0.375456,
  -0.378245, -0.380952, -0.383577, -0.38612, -0.388583, -0.390966,
  -0.393269, -0.395493, -0.397639, -0.399708, -0.401699, -0.403614,
  -0.405453, -0.407217, -0.408906, -0.410521, -0.412062, -0.413531,
  -0.414927, -0.416252, -0.417506, -0.418688, -0.419801, -0.420845,
  -0.42182, -0.422726, -0.423565, -0.424336, -0.425042, -0.425681,
  -0.426255, -0.426763, -0.427208, -0.427589, -0.427907, -0.428162,
  -0.428355, -0.428487, -0.428558, -0.428568, -0.428519, -0.42841,
  -0.428243, -0.428017, -0.427734, -0.427394, -0.426997, -0.426544,
  -0.426036, -0.425472, -0.424855, -0.424183, -0.423458, -0.42268,
  -0.42185, -0.420968, -0.420035, -0.419052, -0.418018, -0.416934,
  -0.415801, -0.414619, -0.41339, -0.412113, -0.410788, -0.409417,
  -0.408, -0.406537, -0.405029, -0.403477, -0.401881, -0.40024,
  -0.398557, -0.396831, -0.395064, -0.393254, -0.391403, -0.389512,
  -0.387581, -0.385609, -0.383599, -0.38155, -0.379463, -0.377338,
  -0.375175, -0.372976, -0.370741, -0.36847, -0.366163, -0.363821,
  -0.361445, -0.359035, -0.356592, -0.354115, -0.351606, -0.349064,
  -0.346491, -0.343887, -0.341252, -0.338586, -0.335891, -0.333166,
  -0.330413, -0.32763, -0.32482, -0.321982, -0.319117, -0.316225,
  -0.313306, -0.310362, -0.307392, -0.304397, -0.301378, -0.298334,
  -0.295267, -0.292176, -0.289062, -0.285926, -0.282768, -0.279588,
  -0.276387, -0.273165, -0.269923, -0.26666, -0.263378, -0.260077,
  -0.256757, -0.253418, -0.250062, -0.246688, -0.243297, -0.239889,
  -0.236465, -0.233024, -0.229568, -0.226097, -0.222611, -0.219111,
  -0.215596, -0.212068, -0.208527, -0.204973, -0.201406, -0.197827,
  -0.194236, -0.190634, -0.187021, -0.183397, -0.179763, -0.176119,
  -0.172465, -0.168802, -0.165131, -0.161451, -0.157763, -0.154067,
  -0.150363, -0.146653, -0.142936, -0.139212, -0.135483, -0.131748,
  -0.128008, -0.124262, -0.120512, -0.116758, -0.113, -0.109238,
  -0.105473, -0.101705, -0.0979348, -0.094162, -0.0903872, -0.0866108,
  -0.0828332, -0.0790546, -0.0752753, -0.0714957, -0.0677161,
  -0.0639368, -0.0601582, -0.0563805, -0.052604, -0.0488291,
  -0.045056, -0.0412852, -0.0375168, -0.0337512, -0.0299887,
  -0.0262296, -0.0224741, -0.0187227, -0.0149755, -0.0112328,
  -0.00749509, -0.00376247, -3.53e-05, 0.00368615, 0.00740159,
  0.0111107, 0.0148133, 0.018509, 0.0221976, 0.0258788, 0.0295523,
  0.0332179, 0.0368752, 0.040524, 0.0441641, 0.0477951, 0.0514169,
  0.055029, 0.0586314, 0.0622237, 0.0658056, 0.069377, 0.0729375,
  0.0764869, 0.080025, 0.0835514, 0.087066, 0.0905685, 0.0940587,
  0.0975363, 0.101001, 0.104453, 0.107891, 0.111316, 0.114727,
  0.118124, 0.121507, 0.124876, 0.128229, 0.131568, 0.134892, 0.1382,
  0.141493, 0.14477, 0.14803, 0.151275, 0.154503, 0.157715, 0.160909,
  0.164087, 0.167247, 0.17039, 0.173515, 0.176622, 0.179711, 0.182782,
  0.185834, 0.188868, 0.191883, 0.194878, 0.197855, 0.200811,
  0.203749, 0.206666, 0.209563, 0.212441, 0.215297, 0.218134,
  0.220949, 0.223744, 0.226517, 0.229269, 0.232, 0.234709, 0.237397,
  0.240062, 0.242705, 0.245327, 0.247925, 0.250501, 0.253055,
  0.255585, 0.258093, 0.260577, 0.263038, 0.265475, 0.267889,
  0.270279, 0.272645, 0.274987, 0.277305, 0.279598, 0.281867,
  0.284112, 0.286331, 0.288526, 0.290695, 0.29284, 0.294959, 0.297053,
  0.299121, 0.301164, 0.303181, 0.305172, 0.307137, 0.309076,
  0.310988, 0.312875, 0.314734, 0.316568, 0.318374, 0.320154,
  0.321907, 0.323633, 0.325332, 0.327004, 0.328648, 0.330266,
  0.331855, 0.333417, 0.334952, 0.336459, 0.337938, 0.339389,
  0.340812, 0.342207, 0.343573, 0.344912, 0.346222, 0.347504,
  0.348758, 0.349983, 0.351179, 0.352347, 0.353486, 0.354596,
  0.355678, 0.35673, 0.357754, 0.358748, 0.359713, 0.36065, 0.361557,
  0.362435, 0.363283, 0.364102, 0.364892, 0.365652, 0.366383,
  0.367085, 0.367756, 0.368399, 0.369011, 0.369594, 0.370147,
  0.370671, 0.371165, 0.371629, 0.372063, 0.372467, 0.372841,
  0.373186, 0.373501, 0.373785, 0.37404, 0.374265, 0.37446, 0.374625,
  0.37476, 0.374865, 0.37494, 0.374985, 0.375, 0.374985, 0.37494,
  0.374865, 0.37476, 0.374625, 0.37446, 0.374265, 0.37404, 0.373785,
  0.373501, 0.373186, 0.372841, 0.372467, 0.372063, 0.371629,
  0.371165, 0.370671, 0.370147, 0.369594, 0.369011, 0.368399,
  0.367756, 0.367085, 0.366383, 0.365652, 0.364892, 0.364102,
  0.363283, 0.362435, 0.361557, 0.36065, 0.359713, 0.358748, 0.357754,
  0.35673, 0.355678, 0.354596, 0.353486, 0.352347, 0.351179, 0.349983,
  0.348758, 0.347504, 0.346222, 0.344912, 0.343573, 0.342207,
  0.340812, 0.339389, 0.337938, 0.336459, 0.334952, 0.333417,
  0.331855, 0.330266, 0.328648, 0.327004, 0.325332, 0.323633,
  0.321907, 0.320154, 0.318374, 0.316568, 0.314734, 0.312875,
  0.310988, 0.309076, 0.307137, 0.305172, 0.303181, 0.301164,
  0.299121, 0.297053, 0.294959, 0.29284, 0.290695, 0.288526, 0.286331,
  0.284112, 0.281867, 0.279598, 0.277305, 0.274987, 0.272645,
  0.270279, 0.267889, 0.265475, 0.263038, 0.260577, 0.258093,
  0.255585, 0.253055, 0.250501, 0.247925, 0.245327, 0.242705,
  0.240062, 0.237397, 0.234709, 0.232, 0.229269, 0.226517, 0.223744,
  0.220949, 0.218134, 0.215297, 0.212441, 0.209563, 0.206666,
  0.203749, 0.200811, 0.197855, 0.194878, 0.191883, 0.188868,
  0.185834, 0.182782, 0.179711, 0.176622, 0.173515, 0.17039, 0.167247,
  0.164087, 0.160909, 0.157715, 0.154503, 0.151275, 0.14803, 0.14477,
  0.141493, 0.1382, 0.134892, 0.131568, 0.128229, 0.124876, 0.121507,
  0.118124, 0.114727, 0.111316, 0.107891, 0.104453, 0.101001,
  0.0975363, 0.0940587, 0.0905685, 0.087066, 0.0835514, 0.080025,
  0.0764869, 0.0729375, 0.069377, 0.0658056, 0.0622237, 0.0586314,
  0.055029, 0.0514169, 0.0477951, 0.0441641, 0.040524, 0.0368752,
  0.0332179, 0.0295523, 0.0258788, 0.0221976, 0.018509, 0.0148133,
  0.0111107, 0.00740159, 0.00368615, -3.53e-05, -0.00376247,
  -0.00749509, -0.0112328, -0.0149755, -0.0187227, -0.0224741,
  -0.0262296, -0.0299887, -0.0337512, -0.0375168, -0.0412852,
  -0.045056, -0.0488291, -0.052604, -0.0563805, -0.0601582,
  -0.0639368, -0.0677161, -0.0714957, -0.0752753, -0.0790546,
  -0.0828332, -0.0866108, -0.0903872, -0.094162, -0.0979348,
  -0.101705, -0.105473, -0.109238, -0.113, -0.116758, -0.120512,
  -0.124262, -0.128008, -0.131748, -0.135483, -0.139212, -0.142936,
  -0.146653, -0.150363, -0.154067, -0.157763, -0.161451, -0.165131,
  -0.168802, -0.172465, -0.176119, -0.179763, -0.183397, -0.187021,
  -0.190634, -0.194236, -0.197827, -0.201406, -0.204973, -0.208527,
  -0.212068, -0.215596, -0.219111, -0.222611, -0.226097, -0.229568,
  -0.233024, -0.236465, -0.239889, -0.243297, -0.246688, -0.250062,
  -0.253418, -0.256757, -0.260077, -0.263378, -0.26666, -0.269923,
  -0.273165, -0.276387, -0.279588, -0.282768, -0.285926, -0.289062,
  -0.292176, -0.295267, -0.298334, -0.301378, -0.304397, -0.307392,
  -0.310362, -0.313306, -0.316225, -0.319117, -0.321982, -0.32482,
  -0.32763, -0.330413, -0.333166, -0.335891, -0.338586, -0.341252,
  -0.343887, -0.346491, -0.349064, -0.351606, -0.354115, -0.356592,
  -0.359035, -0.361445, -0.363821, -0.366163, -0.36847, -0.370741,
  -0.372976, -0.375175, -0.377338, -0.379463, -0.38155, -0.383599,
  -0.385609, -0.387581, -0.389512, -0.391403, -0.393254, -0.395064,
  -0.396831, -0.398557, -0.40024, -0.401881, -0.403477, -0.405029,
  -0.406537, -0.408, -0.409417, -0.410788, -0.412113, -0.41339,
  -0.414619, -0.415801, -0.416934, -0.418018, -0.419052, -0.420035,
  -0.420968, -0.42185, -0.42268, -0.423458, -0.424183, -0.424855,
  -0.425472, -0.426036, -0.426544, -0.426997, -0.427394, -0.427734,
  -0.428017, -0.428243, -0.42841, -0.428519, -0.428568, -0.428558,
  -0.428487, -0.428355, -0.428162, -0.427907, -0.427589, -0.427208,
  -0.426763, -0.426255, -0.425681, -0.425042, -0.424336, -0.423565,
  -0.422726, -0.42182, -0.420845, -0.419801, -0.418688, -0.417506,
  -0.416252, -0.414927, -0.413531, -0.412062, -0.410521, -0.408906,
  -0.407217, -0.405453, -0.403614, -0.401699, -0.399708, -0.397639,
  -0.395493, -0.393269, -0.390966, -0.388583, -0.38612, -0.383577,
  -0.380952, -0.378245, -0.375456, -0.372584, -0.369628, -0.366587,
  -0.363462, -0.360251, -0.356953, -0.353569, -0.350098, -0.346538,
  -0.342889, -0.339151, -0.335323, -0.331405, -0.327395, -0.323293,
  -0.319099, -0.314811, -0.310429, -0.305953, -0.301382, -0.296715,
  -0.291952, -0.287091, -0.282133, -0.277076, -0.27192, -0.266665,
  -0.261309, -0.255852, -0.250293, -0.244632, -0.238868, -0.233,
  -0.227028, -0.22095, -0.214767, -0.208478, -0.202081, -0.195577,
  -0.188964, -0.182242, -0.17541, -0.168467, -0.161414, -0.154248,
  -0.14697, -0.139579, -0.132073, -0.124453, -0.116718, -0.108867,
  -0.100898, -0.0928128, -0.084609, -0.0762862, -0.0678439,
  -0.0592813, -0.0505977, -0.0417923, -0.0328645, -0.0238136,
  -0.0146387, -0.0053393, 0.00408544, 0.0136362, 0.0233138, 0.0331188,
  0.043052, 0.0531142, 0.0633061, 0.0736284, 0.0840819, 0.0946672,
  0.105385, 0.116236, 0.127222, 0.138342, 0.149598, 0.16099, 0.17252,
  0.184187, 0.195992, 0.207937, 0.220023, 0.232249, 0.244616,
  0.257126, 0.26978, 0.282577, 0.295518, 0.308605, 0.321839, 0.335219,
  0.348747, 0.362424, 0.37625, 0.390226, 0.404353, 0.418631, 0.433062,
  0.447646, 0.462384, 0.477277, 0.492325, 0.50753, 0.522892, 0.538411,
  0.55409, 0.569928, 0.585926, 0.602086, 0.618407, 0.634891, 0.651539,
  0.668351, 0.685328, 0.702471, 0.719781, 0.737259, 0.754904, 0.77272,
  0.790705, 0.808861, 0.827188, 0.845689, 0.864362, 0.88321, 0.902233,
  0.921431, 0.940806, 0.960359, 0.98009, 1}; G4double
  G4NeutronHPFastLegendre::i4[1001] = {0, 0.00198006, 0.00392048,
  0.00582161, 0.00768382, 0.00950745, 0.0112929, 0.0130404, 0.0147504,
  0.0164233, 0.0180593, 0.0196588, 0.0212222, 0.0227498, 0.024242,
  0.025699, 0.0271212, 0.028509, 0.0298626, 0.0311825, 0.0324689,
  0.0337221, 0.0349426, 0.0361306, 0.0372864, 0.0384104, 0.0395029,
  0.0405642, 0.0415946, 0.0425944, 0.043564, 0.0445036, 0.0454136,
  0.0462943, 0.0471459, 0.0479689, 0.0487634, 0.0495299, 0.0502685,
  0.0509797, 0.0516636, 0.0523207, 0.0529511, 0.0535552, 0.0541333,
  0.0546856, 0.0552125, 0.0557142, 0.056191, 0.0566433, 0.0570712,
  0.0574751, 0.0578553, 0.058212, 0.0585454, 0.058856, 0.0591439,
  0.0594095, 0.0596529, 0.0598745, 0.0600745, 0.0602533, 0.0604109,
  0.0605479, 0.0606642, 0.0607604, 0.0608365, 0.060893, 0.0609299,
  0.0609476, 0.0609463, 0.0609263, 0.0608878, 0.0608311, 0.0607565,
  0.060664, 0.0605541, 0.060427, 0.0602828, 0.0601219, 0.0599445,
  0.0597508, 0.059541, 0.0593154, 0.0590742, 0.0588176, 0.058546,
  0.0582594, 0.0579582, 0.0576425, 0.0573126, 0.0569687, 0.056611,
  0.0562398, 0.0558552, 0.0554575, 0.055047, 0.0546237, 0.054188,
  0.05374, 0.0532799, 0.052808, 0.0523245, 0.0518296, 0.0513234,
  0.0508062, 0.0502782, 0.0497396, 0.0491906, 0.0486314, 0.0480622,
  0.0474831, 0.0468944, 0.0462963, 0.045689, 0.0450726, 0.0444473,
  0.0438134, 0.043171, 0.0425203, 0.0418614, 0.0411947, 0.0405202,
  0.0398382, 0.0391487, 0.0384521, 0.0377484, 0.0370378, 0.0363206,
  0.0355969, 0.0348668, 0.0341306, 0.0333884, 0.0326403, 0.0318866,
  0.0311274, 0.0303629, 0.0295931, 0.0288184, 0.0280389, 0.0272546,
  0.0264658, 0.0256727, 0.0248753, 0.0240739, 0.0232686, 0.0224595,
  0.0216468, 0.0208307, 0.0200112, 0.0191887, 0.018363, 0.0175346,
  0.0167034, 0.0158696, 0.0150334, 0.0141949, 0.0133542, 0.0125116,
  0.011667, 0.0108207, 0.0099728, 0.00912341, 0.00827268, 0.00742073,
  0.0065677, 0.00571372, 0.00485891, 0.0040034, 0.00314732, 0.0022908,
  0.00143394, 0.000576888, -0.000280248, -0.00113735, -0.00199428,
  -0.00285095, -0.00370722, -0.00456298, -0.00541812, -0.00627252,
  -0.00712607, -0.00797866, -0.00883017, -0.00968051, -0.0105296,
  -0.0113772, -0.0122234, -0.0130679, -0.0139107, -0.0147517,
  -0.0155908, -0.0164279, -0.0172629, -0.0180956, -0.018926,
  -0.0197541, -0.0205796, -0.0214025, -0.0222227, -0.0230401,
  -0.0238547, -0.0246662, -0.0254747, -0.0262801, -0.0270822,
  -0.027881, -0.0286764, -0.0294683, -0.0302567, -0.0310413,
  -0.0318223, -0.0325994, -0.0333725, -0.0341418, -0.0349069,
  -0.0356679, -0.0364247, -0.0371773, -0.0379254, -0.0386691,
  -0.0394084, -0.040143, -0.040873, -0.0415983, -0.0423187,
  -0.0430344, -0.0437451, -0.0444508, -0.0451515, -0.0458471,
  -0.0465374, -0.0472226, -0.0479024, -0.0485769, -0.049246,
  -0.0499096, -0.0505676, -0.0512201, -0.0518669, -0.052508,
  -0.0531433, -0.0537729, -0.0543965, -0.0550143, -0.0556261,
  -0.0562319, -0.0568316, -0.0574252, -0.0580126, -0.0585939,
  -0.0591689, -0.0597376, -0.0602999, -0.0608559, -0.0614055,
  -0.0619485, -0.0624851, -0.0630152, -0.0635386, -0.0640555,
  -0.0645656, -0.0650691, -0.0655659, -0.0660559, -0.0665391,
  -0.0670154, -0.0674849, -0.0679475, -0.0684032, -0.0688519,
  -0.0692936, -0.0697283, -0.070156, -0.0705766, -0.0709901,
  -0.0713965, -0.0717957, -0.0721878, -0.0725726, -0.0729503,
  -0.0733207, -0.0736839, -0.0740398, -0.0743883, -0.0747296,
  -0.0750635, -0.0753901, -0.0757093, -0.0760212, -0.0763256,
  -0.0766226, -0.0769122, -0.0771944, -0.0774691, -0.0777363,
  -0.077996, -0.0782483, -0.0784931, -0.0787304, -0.0789601,
  -0.0791824, -0.0793971, -0.0796043, -0.0798039, -0.079996,
  -0.0801805, -0.0803575, -0.080527, -0.0806889, -0.0808432, -0.08099,
  -0.0811292, -0.0812608, -0.0813849, -0.0815015, -0.0816105,
  -0.0817119, -0.0818058, -0.0818921, -0.0819709, -0.0820422,
  -0.0821059, -0.0821621, -0.0822108, -0.082252, -0.0822857,
  -0.0823119, -0.0823307, -0.0823419, -0.0823457, -0.0823421,
  -0.082331, -0.0823125, -0.0822865, -0.0822532, -0.0822125,
  -0.0821644, -0.082109, -0.0820462, -0.0819761, -0.0818987,
  -0.081814, -0.0817221, -0.0816229, -0.0815164, -0.0814028,
  -0.0812819, -0.0811539, -0.0810187, -0.0808764, -0.0807269,
  -0.0805704, -0.0804069, -0.0802362, -0.0800586, -0.079874,
  -0.0796824, -0.0794838, -0.0792784, -0.079066, -0.0788468,
  -0.0786208, -0.0783879, -0.0781483, -0.0779019, -0.0776488,
  -0.077389, -0.0771225, -0.0768494, -0.0765697, -0.0762835,
  -0.0759907, -0.0756914, -0.0753856, -0.0750734, -0.0747547,
  -0.0744297, -0.0740984, -0.0737608, -0.0734168, -0.0730667,
  -0.0727104, -0.0723479, -0.0719793, -0.0716045, -0.0712238,
  -0.070837, -0.0704443, -0.0700456, -0.0696411, -0.0692306,
  -0.0688144, -0.0683924, -0.0679647, -0.0675312, -0.0670921,
  -0.0666474, -0.0661972, -0.0657414, -0.0652801, -0.0648134,
  -0.0643413, -0.0638638, -0.0633811, -0.062893, -0.0623998,
  -0.0619013, -0.0613978, -0.0608891, -0.0603755, -0.0598568,
  -0.0593332, -0.0588046, -0.0582713, -0.0577331, -0.0571902,
  -0.0566425, -0.0560902, -0.0555333, -0.0549719, -0.0544059,
  -0.0538354, -0.0532606, -0.0526814, -0.0520978, -0.05151, -0.050918,
  -0.0503218, -0.0497215, -0.0491172, -0.0485088, -0.0478965,
  -0.0472803, -0.0466602, -0.0460364, -0.0454087, -0.0447774,
  -0.0441425, -0.043504, -0.0428619, -0.0422163, -0.0415674,
  -0.040915, -0.0402594, -0.0396005, -0.0389383, -0.0382731,
  -0.0376047, -0.0369333, -0.0362589, -0.0355815, -0.0349013,
  -0.0342183, -0.0335325, -0.032844, -0.0321529, -0.0314592,
  -0.0307629, -0.0300641, -0.029363, -0.0286594, -0.0279536,
  -0.0272455, -0.0265352, -0.0258228, -0.0251083, -0.0243918,
  -0.0236734, -0.022953, -0.0222308, -0.0215068, -0.0207811,
  -0.0200537, -0.0193247, -0.0185941, -0.0178621, -0.0171286,
  -0.0163938, -0.0156576, -0.0149202, -0.0141816, -0.0134418,
  -0.012701, -0.0119592, -0.0112164, -0.0104727, -0.00972815,
  -0.00898283, -0.0082368, -0.00749011, -0.00674282, -0.00599499,
  -0.00524668, -0.00449795, -0.00374886, -0.00299946, -0.00224983,
  -0.00150002, -0.000750094, -1.04167e-07, 0.000749886, 0.00149982,
  0.00224963, 0.00299926, 0.00374865, 0.00449774, 0.00524647,
  0.00599478, 0.00674261, 0.0074899, 0.00823659, 0.00898262,
  0.00972794, 0.0104725, 0.0112162, 0.011959, 0.0127008, 0.0134416,
  0.0141814, 0.01492, 0.0156574, 0.0163936, 0.0171284, 0.0178619,
  0.0185939, 0.0193245, 0.0200535, 0.0207809, 0.0215066, 0.0222306,
  0.0229528, 0.0236732, 0.0243916, 0.0251081, 0.0258226, 0.026535,
  0.0272453, 0.0279534, 0.0286592, 0.0293628, 0.0300639, 0.0307627,
  0.0314589, 0.0321527, 0.0328438, 0.0335323, 0.0342181, 0.0349011,
  0.0355813, 0.0362587, 0.0369331, 0.0376045, 0.0382728, 0.0389381,
  0.0396002, 0.0402592, 0.0409148, 0.0415672, 0.0422161, 0.0428617,
  0.0435037, 0.0441423, 0.0447772, 0.0454085, 0.0460361, 0.04666,
  0.0472801, 0.0478963, 0.0485086, 0.049117, 0.0497213, 0.0503216,
  0.0509178, 0.0515098, 0.0520976, 0.0526811, 0.0532604, 0.0538352,
  0.0544057, 0.0549717, 0.0555331, 0.05609, 0.0566423, 0.05719,
  0.0577329, 0.0582711, 0.0588044, 0.059333, 0.0598566, 0.0603752,
  0.0608889, 0.0613976, 0.0619011, 0.0623996, 0.0628928, 0.0633809,
  0.0638636, 0.0643411, 0.0648132, 0.0652799, 0.0657412, 0.066197,
  0.0666472, 0.0670919, 0.067531, 0.0679645, 0.0683922, 0.0688142,
  0.0692304, 0.0696409, 0.0700454, 0.0704441, 0.0708368, 0.0712236,
  0.0716043, 0.071979, 0.0723477, 0.0727102, 0.0730665, 0.0734166,
  0.0737606, 0.0740982, 0.0744295, 0.0747545, 0.0750732, 0.0753854,
  0.0756912, 0.0759905, 0.0762833, 0.0765695, 0.0768492, 0.0771223,
  0.0773888, 0.0776486, 0.0779017, 0.0781481, 0.0783877, 0.0786206,
  0.0788466, 0.0790658, 0.0792782, 0.0794836, 0.0796822, 0.0798738,
  0.0800584, 0.080236, 0.0804066, 0.0805702, 0.0807267, 0.0808762,
  0.0810185, 0.0811537, 0.0812817, 0.0814026, 0.0815162, 0.0816227,
  0.0817219, 0.0818138, 0.0818985, 0.0819759, 0.082046, 0.0821088,
  0.0821642, 0.0822123, 0.082253, 0.0822863, 0.0823123, 0.0823308,
  0.0823419, 0.0823455, 0.0823417, 0.0823305, 0.0823117, 0.0822855,
  0.0822518, 0.0822106, 0.0821619, 0.0821057, 0.082042, 0.0819707,
  0.0818919, 0.0818056, 0.0817117, 0.0816102, 0.0815013, 0.0813847,
  0.0812606, 0.081129, 0.0809898, 0.080843, 0.0806887, 0.0805268,
  0.0803573, 0.0801803, 0.0799958, 0.0798037, 0.079604, 0.0793969,
  0.0791822, 0.0789599, 0.0787302, 0.0784929, 0.0782481, 0.0779958,
  0.0777361, 0.0774689, 0.0771942, 0.076912, 0.0766224, 0.0763254,
  0.076021, 0.0757091, 0.0753899, 0.0750633, 0.0747294, 0.0743881,
  0.0740395, 0.0736837, 0.0733205, 0.0729501, 0.0725724, 0.0721876,
  0.0717955, 0.0713963, 0.0709899, 0.0705764, 0.0701558, 0.0697281,
  0.0692934, 0.0688517, 0.068403, 0.0679473, 0.0674847, 0.0670152,
  0.0665389, 0.0660557, 0.0655657, 0.0650689, 0.0645654, 0.0640553,
  0.0635384, 0.063015, 0.0624849, 0.0619483, 0.0614052, 0.0608557,
  0.0602997, 0.0597374, 0.0591687, 0.0585937, 0.0580124, 0.057425,
  0.0568314, 0.0562317, 0.0556259, 0.0550141, 0.0543963, 0.0537726,
  0.0531431, 0.0525078, 0.0518667, 0.0512199, 0.0505674, 0.0499093,
  0.0492458, 0.0485767, 0.0479022, 0.0472224, 0.0465372, 0.0458468,
  0.0451513, 0.0444506, 0.0437449, 0.0430342, 0.0423185, 0.0415981,
  0.0408728, 0.0401428, 0.0394082, 0.0386689, 0.0379252, 0.0371771,
  0.0364245, 0.0356677, 0.0349067, 0.0341416, 0.0333723, 0.0325991,
  0.031822, 0.0310411, 0.0302565, 0.0294681, 0.0286762, 0.0278808,
  0.027082, 0.0262799, 0.0254745, 0.024666, 0.0238544, 0.0230399,
  0.0222225, 0.0214023, 0.0205794, 0.0197538, 0.0189258, 0.0180954,
  0.0172627, 0.0164277, 0.0155906, 0.0147515, 0.0139105, 0.0130677,
  0.0122231, 0.011377, 0.0105293, 0.0096803, 0.00882996, 0.00797845,
  0.00712586, 0.00627231, 0.00541791, 0.00456277, 0.00370701,
  0.00285074, 0.00199408, 0.00113714, 0.00028004, -0.000577097,
  -0.00143415, -0.002291, -0.00314753, -0.00400361, -0.00485912,
  -0.00571393, -0.00656791, -0.00742094, -0.00827289, -0.00912362,
  -0.00997301, -0.0108209, -0.0116672, -0.0125118, -0.0133545,
  -0.0141951, -0.0150336, -0.0158698, -0.0167036, -0.0175348,
  -0.0183633, -0.0191889, -0.0200115, -0.0208309, -0.021647,
  -0.0224597, -0.0232688, -0.0240741, -0.0248755, -0.0256729,
  -0.026466, -0.0272548, -0.0280391, -0.0288186, -0.0295934,
  -0.0303631, -0.0311276, -0.0318868, -0.0326405, -0.0333886,
  -0.0341308, -0.034867, -0.0355971, -0.0363208, -0.0370381,
  -0.0377486, -0.0384523, -0.0391489, -0.0398384, -0.0405204,
  -0.0411949, -0.0418617, -0.0425205, -0.0431712, -0.0438136,
  -0.0444475, -0.0450728, -0.0456892, -0.0462965, -0.0468946,
  -0.0474833, -0.0480624, -0.0486316, -0.0491908, -0.0497399,
  -0.0502785, -0.0508064, -0.0513236, -0.0518298, -0.0523247,
  -0.0528082, -0.0532801, -0.0537402, -0.0541882, -0.0546239,
  -0.0550472, -0.0554578, -0.0558554, -0.05624, -0.0566112,
  -0.0569689, -0.0573128, -0.0576427, -0.0579584, -0.0582596,
  -0.0585462, -0.0588178, -0.0590744, -0.0593156, -0.0595412,
  -0.059751, -0.0599447, -0.0601221, -0.0602831, -0.0604272,
  -0.0605544, -0.0606643, -0.0607567, -0.0608313, -0.060888,
  -0.0609265, -0.0609465, -0.0609478, -0.0609301, -0.0608932,
  -0.0608367, -0.0607606, -0.0606645, -0.0605481, -0.0604111,
  -0.0602535, -0.0600747, -0.0598747, -0.0596531, -0.0594097,
  -0.0591441, -0.0588562, -0.0585456, -0.0582122, -0.0578555,
  -0.0574753, -0.0570714, -0.0566435, -0.0561912, -0.0557144,
  -0.0552127, -0.0546858, -0.0541335, -0.0535554, -0.0529513,
  -0.0523209, -0.0516638, -0.0509799, -0.0502688, -0.0495301,
  -0.0487637, -0.0479691, -0.0471461, -0.0462945, -0.0454138,
  -0.0445038, -0.0435642, -0.0425946, -0.0415948, -0.0405644,
  -0.0395031, -0.0384106, -0.0372866, -0.0361308, -0.0349428,
  -0.0337224, -0.0324691, -0.0311827, -0.0298628, -0.0285092,
  -0.0271214, -0.0256992, -0.0242422, -0.02275, -0.0212224, -0.019659,
  -0.0180595, -0.0164235, -0.0147506, -0.0130406, -0.0112931,
  -0.00950766, -0.00768403, -0.00582182, -0.00392069, -0.00198027,
  -2.08333e-07}; G4double G4NeutronHPFastLegendre::l5[1201] = {-1,
  -0.975146, -0.950581, -0.926304, -0.902313, -0.878606, -0.85518,
  -0.832035, -0.809169, -0.786578, -0.764262, -0.742219, -0.720446,
  -0.698942, -0.677706, -0.656734, -0.636026, -0.615579, -0.595392,
  -0.575462, -0.555789, -0.53637, -0.517203, -0.498287, -0.47962,
  -0.4612, -0.443025, -0.425094, -0.407404, -0.389955, -0.372744,
  -0.355769, -0.339029, -0.322523, -0.306247, -0.290202, -0.274384,
  -0.258793, -0.243426, -0.228282, -0.21336, -0.198657, -0.184172,
  -0.169903, -0.155849, -0.142008, -0.128379, -0.114959, -0.101747,
  -0.0887417, -0.0759413, -0.0633442, -0.0509488, -0.0387536,
  -0.0267569, -0.0149572, -0.00335288, 0.00805757, 0.0192757,
  0.0303031, 0.0411413, 0.0517917, 0.062256, 0.0725357, 0.0826322,
  0.0925471, 0.102282, 0.111838, 0.121217, 0.13042, 0.13945, 0.148306,
  0.156991, 0.165506, 0.173853, 0.182034, 0.190048, 0.197899,
  0.205586, 0.213113, 0.22048, 0.227688, 0.23474, 0.241636, 0.248377,
  0.254966, 0.261403, 0.26769, 0.273829, 0.27982, 0.285664, 0.291365,
  0.296921, 0.302336, 0.30761, 0.312745, 0.317741, 0.322601, 0.327325,
  0.331915, 0.336372, 0.340697, 0.344892, 0.348958, 0.352895,
  0.356707, 0.360393, 0.363955, 0.367394, 0.370711, 0.373908,
  0.376986, 0.379946, 0.382789, 0.385516, 0.388129, 0.390629,
  0.393017, 0.395294, 0.397461, 0.39952, 0.401472, 0.403317, 0.405057,
  0.406694, 0.408227, 0.409659, 0.410991, 0.412223, 0.413357,
  0.414394, 0.415334, 0.41618, 0.416932, 0.417591, 0.418159, 0.418635,
  0.419023, 0.419321, 0.419532, 0.419657, 0.419697, 0.419652,
  0.419524, 0.419314, 0.419022, 0.418651, 0.4182, 0.417671, 0.417064,
  0.416382, 0.415624, 0.414792, 0.413887, 0.41291, 0.411861, 0.410742,
  0.409554, 0.408297, 0.406973, 0.405582, 0.404126, 0.402605, 0.40102,
  0.399373, 0.397663, 0.395893, 0.394062, 0.392172, 0.390224,
  0.388219, 0.386157, 0.384039, 0.381867, 0.379641, 0.377361, 0.37503,
  0.372647, 0.370214, 0.367731, 0.365199, 0.362619, 0.359992,
  0.357319, 0.3546, 0.351836, 0.349029, 0.346179, 0.343286, 0.340351,
  0.337376, 0.334361, 0.331307, 0.328215, 0.325085, 0.321918,
  0.318714, 0.315476, 0.312203, 0.308896, 0.305556, 0.302183,
  0.298779, 0.295344, 0.291878, 0.288383, 0.284859, 0.281307,
  0.277728, 0.274122, 0.27049, 0.266832, 0.26315, 0.259444, 0.255715,
  0.251962, 0.248188, 0.244393, 0.240577, 0.23674, 0.232885, 0.22901,
  0.225117, 0.221207, 0.21728, 0.213337, 0.209378, 0.205404, 0.201415,
  0.197413, 0.193397, 0.189369, 0.185329, 0.181277, 0.177214,
  0.173141, 0.169058, 0.164966, 0.160865, 0.156756, 0.15264, 0.148517,
  0.144387, 0.140251, 0.13611, 0.131964, 0.127813, 0.123659, 0.119502,
  0.115341, 0.111179, 0.107015, 0.102849, 0.0986827, 0.094516,
  0.0903496, 0.0861838, 0.0820192, 0.0778563, 0.0736954, 0.0695371,
  0.0653818, 0.06123, 0.0570822, 0.0529387, 0.0488001, 0.0446668,
  0.0405391, 0.0364176, 0.0323027, 0.0281948, 0.0240943, 0.0200016,
  0.0159172, 0.0118415, 0.00777478, 0.00371754, -0.000329831,
  -0.00436695, -0.00839343, -0.0124089, -0.0164129, -0.0204052,
  -0.0243853, -0.0283529, -0.0323076, -0.036249, -0.0401768,
  -0.0440907, -0.0479902, -0.0518751, -0.0557449, -0.0595995,
  -0.0634383, -0.0672611, -0.0710676, -0.0748574, -0.0786303,
  -0.0823858, -0.0861237, -0.0898438, -0.0935455, -0.0972288,
  -0.100893, -0.104538, -0.108164, -0.111771, -0.115357, -0.118923,
  -0.122468, -0.125993, -0.129496, -0.132978, -0.136439, -0.139877,
  -0.143294, -0.146688, -0.150059, -0.153408, -0.156733, -0.160036,
  -0.163314, -0.166569, -0.169799, -0.173006, -0.176188, -0.179345,
  -0.182477, -0.185584, -0.188666, -0.191722, -0.194753, -0.197757,
  -0.200735, -0.203687, -0.206613, -0.209512, -0.212383, -0.215228,
  -0.218046, -0.220836, -0.223598, -0.226333, -0.22904, -0.231718,
  -0.234369, -0.236991, -0.239585, -0.242149, -0.244685, -0.247192,
  -0.24967, -0.252119, -0.254538, -0.256928, -0.259288, -0.261619,
  -0.263919, -0.266189, -0.26843, -0.27064, -0.27282, -0.274969,
  -0.277088, -0.279176, -0.281234, -0.28326, -0.285256, -0.287221,
  -0.289154, -0.291057, -0.292928, -0.294768, -0.296576, -0.298353,
  -0.300098, -0.301812, -0.303494, -0.305145, -0.306763, -0.30835,
  -0.309905, -0.311427, -0.312918, -0.314377, -0.315804, -0.317198,
  -0.318561, -0.319891, -0.321189, -0.322455, -0.323688, -0.324889,
  -0.326058, -0.327195, -0.328299, -0.32937, -0.33041, -0.331417,
  -0.332391, -0.333333, -0.334243, -0.33512, -0.335965, -0.336778,
  -0.337558, -0.338306, -0.339021, -0.339704, -0.340355, -0.340973,
  -0.341559, -0.342113, -0.342635, -0.343124, -0.343581, -0.344007,
  -0.3444, -0.34476, -0.345089, -0.345386, -0.345651, -0.345884,
  -0.346086, -0.346255, -0.346393, -0.346499, -0.346573, -0.346616,
  -0.346627, -0.346607, -0.346556, -0.346473, -0.346359, -0.346214,
  -0.346038, -0.345831, -0.345593, -0.345324, -0.345024, -0.344693,
  -0.344332, -0.343941, -0.343519, -0.343067, -0.342584, -0.342071,
  -0.341529, -0.340956, -0.340354, -0.339722, -0.33906, -0.338369,
  -0.337648, -0.336898, -0.336119, -0.335311, -0.334473, -0.333607,
  -0.332713, -0.331789, -0.330838, -0.329857, -0.328849, -0.327813,
  -0.326748, -0.325656, -0.324536, -0.323388, -0.322214, -0.321011,
  -0.319782, -0.318526, -0.317242, -0.315932, -0.314596, -0.313233,
  -0.311844, -0.310428, -0.308987, -0.30752, -0.306027, -0.304509,
  -0.302965, -0.301396, -0.299802, -0.298184, -0.29654, -0.294872,
  -0.29318, -0.291463, -0.289723, -0.287958, -0.28617, -0.284358,
  -0.282523, -0.280665, -0.278783, -0.276879, -0.274953, -0.273003,
  -0.271032, -0.269038, -0.267023, -0.264986, -0.262927, -0.260847,
  -0.258746, -0.256623, -0.25448, -0.252317, -0.250133, -0.247929,
  -0.245704, -0.24346, -0.241197, -0.238914, -0.236611, -0.23429,
  -0.23195, -0.229591, -0.227214, -0.224819, -0.222405, -0.219974,
  -0.217525, -0.215059, -0.212576, -0.210076, -0.207559, -0.205026,
  -0.202476, -0.19991, -0.197328, -0.194731, -0.192118, -0.189489,
  -0.186846, -0.184188, -0.181516, -0.178829, -0.176128, -0.173413,
  -0.170684, -0.167942, -0.165186, -0.162418, -0.159636, -0.156843,
  -0.154036, -0.151218, -0.148388, -0.145546, -0.142692, -0.139828,
  -0.136952, -0.134066, -0.131169, -0.128262, -0.125345, -0.122418,
  -0.119481, -0.116535, -0.11358, -0.110616, -0.107643, -0.104662,
  -0.101673, -0.098676, -0.0956711, -0.0926587, -0.0896391,
  -0.0866125, -0.0835791, -0.0805392, -0.077493, -0.0744408,
  -0.0713828, -0.0683192, -0.0652503, -0.0621763, -0.0590974,
  -0.0560139, -0.0529261, -0.0498342, -0.0467384, -0.0436389,
  -0.040536, -0.03743, -0.0343211, -0.0312095, -0.0280955, -0.0249793,
  -0.0218611, -0.0187413, -0.0156199, -0.0124974, -0.00937391,
  -0.00624968, -0.00312496, 0, 0.00312496, 0.00624968, 0.00937391,
  0.0124974, 0.0156199, 0.0187413, 0.0218611, 0.0249793, 0.0280955,
  0.0312095, 0.0343211, 0.03743, 0.040536, 0.0436389, 0.0467384,
  0.0498342, 0.0529261, 0.0560139, 0.0590974, 0.0621763, 0.0652503,
  0.0683192, 0.0713828, 0.0744408, 0.077493, 0.0805392, 0.0835791,
  0.0866125, 0.0896391, 0.0926587, 0.0956711, 0.098676, 0.101673,
  0.104662, 0.107643, 0.110616, 0.11358, 0.116535, 0.119481, 0.122418,
  0.125345, 0.128262, 0.131169, 0.134066, 0.136952, 0.139828,
  0.142692, 0.145546, 0.148388, 0.151218, 0.154036, 0.156843,
  0.159636, 0.162418, 0.165186, 0.167942, 0.170684, 0.173413,
  0.176128, 0.178829, 0.181516, 0.184188, 0.186846, 0.189489,
  0.192118, 0.194731, 0.197328, 0.19991, 0.202476, 0.205026, 0.207559,
  0.210076, 0.212576, 0.215059, 0.217525, 0.219974, 0.222405,
  0.224819, 0.227214, 0.229591, 0.23195, 0.23429, 0.236611, 0.238914,
  0.241197, 0.24346, 0.245704, 0.247929, 0.250133, 0.252317, 0.25448,
  0.256623, 0.258746, 0.260847, 0.262927, 0.264986, 0.267023,
  0.269038, 0.271032, 0.273003, 0.274953, 0.276879, 0.278783,
  0.280665, 0.282523, 0.284358, 0.28617, 0.287958, 0.289723, 0.291463,
  0.29318, 0.294872, 0.29654, 0.298184, 0.299802, 0.301396, 0.302965,
  0.304509, 0.306027, 0.30752, 0.308987, 0.310428, 0.311844, 0.313233,
  0.314596, 0.315932, 0.317242, 0.318526, 0.319782, 0.321011,
  0.322214, 0.323388, 0.324536, 0.325656, 0.326748, 0.327813,
  0.328849, 0.329857, 0.330838, 0.331789, 0.332713, 0.333607,
  0.334473, 0.335311, 0.336119, 0.336898, 0.337648, 0.338369, 0.33906,
  0.339722, 0.340354, 0.340956, 0.341529, 0.342071, 0.342584,
  0.343067, 0.343519, 0.343941, 0.344332, 0.344693, 0.345024,
  0.345324, 0.345593, 0.345831, 0.346038, 0.346214, 0.346359,
  0.346473, 0.346556, 0.346607, 0.346627, 0.346616, 0.346573,
  0.346499, 0.346393, 0.346255, 0.346086, 0.345884, 0.345651,
  0.345386, 0.345089, 0.34476, 0.3444, 0.344007, 0.343581, 0.343124,
  0.342635, 0.342113, 0.341559, 0.340973, 0.340355, 0.339704,
  0.339021, 0.338306, 0.337558, 0.336778, 0.335965, 0.33512, 0.334243,
  0.333333, 0.332391, 0.331417, 0.33041, 0.32937, 0.328299, 0.327195,
  0.326058, 0.324889, 0.323688, 0.322455, 0.321189, 0.319891,
  0.318561, 0.317198, 0.315804, 0.314377, 0.312918, 0.311427,
  0.309905, 0.30835, 0.306763, 0.305145, 0.303494, 0.301812, 0.300098,
  0.298353, 0.296576, 0.294768, 0.292928, 0.291057, 0.289154,
  0.287221, 0.285256, 0.28326, 0.281234, 0.279176, 0.277088, 0.274969,
  0.27282, 0.27064, 0.26843, 0.266189, 0.263919, 0.261619, 0.259288,
  0.256928, 0.254538, 0.252119, 0.24967, 0.247192, 0.244685, 0.242149,
  0.239585, 0.236991, 0.234369, 0.231718, 0.22904, 0.226333, 0.223598,
  0.220836, 0.218046, 0.215228, 0.212383, 0.209512, 0.206613,
  0.203687, 0.200735, 0.197757, 0.194753, 0.191722, 0.188666,
  0.185584, 0.182477, 0.179345, 0.176188, 0.173006, 0.169799,
  0.166569, 0.163314, 0.160036, 0.156733, 0.153408, 0.150059,
  0.146688, 0.143294, 0.139877, 0.136439, 0.132978, 0.129496,
  0.125993, 0.122468, 0.118923, 0.115357, 0.111771, 0.108164,
  0.104538, 0.100893, 0.0972288, 0.0935455, 0.0898438, 0.0861237,
  0.0823858, 0.0786303, 0.0748574, 0.0710676, 0.0672611, 0.0634383,
  0.0595995, 0.0557449, 0.0518751, 0.0479902, 0.0440907, 0.0401768,
  0.036249, 0.0323076, 0.0283529, 0.0243853, 0.0204052, 0.0164129,
  0.0124089, 0.00839343, 0.00436695, 0.000329831, -0.00371754,
  -0.00777478, -0.0118415, -0.0159172, -0.0200016, -0.0240943,
  -0.0281948, -0.0323027, -0.0364176, -0.0405391, -0.0446668,
  -0.0488001, -0.0529387, -0.0570822, -0.06123, -0.0653818,
  -0.0695371, -0.0736954, -0.0778563, -0.0820192, -0.0861838,
  -0.0903496, -0.094516, -0.0986827, -0.102849, -0.107015, -0.111179,
  -0.115341, -0.119502, -0.123659, -0.127813, -0.131964, -0.13611,
  -0.140251, -0.144387, -0.148517, -0.15264, -0.156756, -0.160865,
  -0.164966, -0.169058, -0.173141, -0.177214, -0.181277, -0.185329,
  -0.189369, -0.193397, -0.197413, -0.201415, -0.205404, -0.209378,
  -0.213337, -0.21728, -0.221207, -0.225117, -0.22901, -0.232885,
  -0.23674, -0.240577, -0.244393, -0.248188, -0.251962, -0.255715,
  -0.259444, -0.26315, -0.266832, -0.27049, -0.274122, -0.277728,
  -0.281307, -0.284859, -0.288383, -0.291878, -0.295344, -0.298779,
  -0.302183, -0.305556, -0.308896, -0.312203, -0.315476, -0.318714,
  -0.321918, -0.325085, -0.328215, -0.331307, -0.334361, -0.337376,
  -0.340351, -0.343286, -0.346179, -0.349029, -0.351836, -0.3546,
  -0.357319, -0.359992, -0.362619, -0.365199, -0.367731, -0.370214,
  -0.372647, -0.37503, -0.377361, -0.379641, -0.381867, -0.384039,
  -0.386157, -0.388219, -0.390224, -0.392172, -0.394062, -0.395893,
  -0.397663, -0.399373, -0.40102, -0.402605, -0.404126, -0.405582,
  -0.406973, -0.408297, -0.409554, -0.410742, -0.411861, -0.41291,
  -0.413887, -0.414792, -0.415624, -0.416382, -0.417064, -0.417671,
  -0.4182, -0.418651, -0.419022, -0.419314, -0.419524, -0.419652,
  -0.419697, -0.419657, -0.419532, -0.419321, -0.419023, -0.418635,
  -0.418159, -0.417591, -0.416932, -0.41618, -0.415334, -0.414394,
  -0.413357, -0.412223, -0.410991, -0.409659, -0.408227, -0.406694,
  -0.405057, -0.403317, -0.401472, -0.39952, -0.397461, -0.395294,
  -0.393017, -0.390629, -0.388129, -0.385516, -0.382789, -0.379946,
  -0.376986, -0.373908, -0.370711, -0.367394, -0.363955, -0.360393,
  -0.356707, -0.352895, -0.348958, -0.344892, -0.340697, -0.336372,
  -0.331915, -0.327325, -0.322601, -0.317741, -0.312745, -0.30761,
  -0.302336, -0.296921, -0.291365, -0.285664, -0.27982, -0.273829,
  -0.26769, -0.261403, -0.254966, -0.248377, -0.241636, -0.23474,
  -0.227688, -0.22048, -0.213113, -0.205586, -0.197899, -0.190048,
  -0.182034, -0.173853, -0.165506, -0.156991, -0.148306, -0.13945,
  -0.13042, -0.121217, -0.111838, -0.102282, -0.0925471, -0.0826322,
  -0.0725357, -0.062256, -0.0517917, -0.0411413, -0.0303031,
  -0.0192757, -0.00805757, 0.00335288, 0.0149572, 0.0267569,
  0.0387536, 0.0509488, 0.0633442, 0.0759413, 0.0887417, 0.101747,
  0.114959, 0.128379, 0.142008, 0.155849, 0.169903, 0.184172,
  0.198657, 0.21336, 0.228282, 0.243426, 0.258793, 0.274384, 0.290202,
  0.306247, 0.322523, 0.339029, 0.355769, 0.372744, 0.389955,
  0.407404, 0.425094, 0.443025, 0.4612, 0.47962, 0.498287, 0.517203,
  0.53637, 0.555789, 0.575462, 0.595392, 0.615579, 0.636026, 0.656734,
  0.677706, 0.698942, 0.720446, 0.742219, 0.764262, 0.786578,
  0.809169, 0.832035, 0.85518, 0.878606, 0.902313, 0.926304, 0.950581,
  0.975146, 1}; G4double G4NeutronHPFastLegendre::i5[1201] = {0,
  -0.00164591, -0.00325064, -0.00481467, -0.00633848, -0.00782254,
  -0.00926732, -0.0106733, -0.0120409, -0.0133707, -0.014663,
  -0.0159184, -0.0171372, -0.01832, -0.0194672, -0.0205792,
  -0.0216564, -0.0226994, -0.0237085, -0.0246842, -0.0256268,
  -0.0265369, -0.0274149, -0.0282611, -0.029076, -0.02986, -0.0306134,
  -0.0313368, -0.0320306, -0.032695, -0.0333305, -0.0339376,
  -0.0345166, -0.0350678, -0.0355918, -0.0360888, -0.0365592,
  -0.0370035, -0.037422, -0.037815, -0.0381831, -0.0385264,
  -0.0388454, -0.0391404, -0.0394118, -0.03966, -0.0398853,
  -0.0400881, -0.0402686, -0.0404273, -0.0405645, -0.0406806,
  -0.0407758, -0.0408505, -0.0409051, -0.0409398, -0.040955,
  -0.0409511, -0.0409283, -0.0408869, -0.0408274, -0.0407499,
  -0.0406548, -0.0405425, -0.0404132, -0.0402671, -0.0401048,
  -0.0399263, -0.0397321, -0.0395223, -0.0392974, -0.0390576,
  -0.0388032, -0.0385344, -0.0382516, -0.037955, -0.0376449,
  -0.0373216, -0.0369853, -0.0366364, -0.036275, -0.0359015,
  -0.0355161, -0.0351191, -0.0347108, -0.0342913, -0.033861, -0.03342,
  -0.0329688, -0.0325074, -0.0320361, -0.0315552, -0.031065,
  -0.0305656, -0.0300573, -0.0295403, -0.0290148, -0.0284812,
  -0.0279396, -0.0273902, -0.0268333, -0.026269, -0.0256977,
  -0.0251195, -0.0245346, -0.0239432, -0.0233456, -0.022742,
  -0.0221325, -0.0215174, -0.0208969, -0.0202711, -0.0196403,
  -0.0190047, -0.0183644, -0.0177197, -0.0170707, -0.0164177,
  -0.0157607, -0.0151001, -0.0144359, -0.0137684, -0.0130977,
  -0.0124241, -0.0117476, -0.0110685, -0.0103869, -0.00970299,
  -0.00901697, -0.00832897, -0.00763917, -0.00694771, -0.00625477,
  -0.0055605, -0.00486505, -0.00416858, -0.00347123, -0.00277317,
  -0.00207454, -0.00137548, -0.000676146, 2.33278e-05, 0.000722797,
  0.00142212, 0.00212117, 0.00281979, 0.00351786, 0.00421525,
  0.00491182, 0.00560744, 0.00630199, 0.00699534, 0.00768736,
  0.00837794, 0.00906695, 0.00975427, 0.0104398, 0.0111234, 0.0118049,
  0.0124843, 0.0131615, 0.0138362, 0.0145085, 0.0151782, 0.0158452,
  0.0165094, 0.0171707, 0.017829, 0.0184842, 0.0191362, 0.0197849,
  0.0204303, 0.0210721, 0.0217104, 0.022345, 0.0229758, 0.0236028,
  0.0242259, 0.0248449, 0.0254599, 0.0260707, 0.0266772, 0.0272794,
  0.0278772, 0.0284704, 0.0290591, 0.0296432, 0.0302225, 0.0307971,
  0.0313668, 0.0319316, 0.0324914, 0.0330461, 0.0335957, 0.0341401,
  0.0346793, 0.0352132, 0.0357417, 0.0362647, 0.0367823, 0.0372944,
  0.0378008, 0.0383016, 0.0387967, 0.0392861, 0.0397696, 0.0402473,
  0.0407192, 0.041185, 0.0416449, 0.0420987, 0.0425465, 0.0429882,
  0.0434237, 0.043853, 0.044276, 0.0446928, 0.0451033, 0.0455075,
  0.0459052, 0.0462966, 0.0466815, 0.04706, 0.0474319, 0.0477973,
  0.0481561, 0.0485084, 0.0488541, 0.0491931, 0.0495254, 0.0498511,
  0.0501701, 0.0504823, 0.0507879, 0.0510866, 0.0513786, 0.0516637,
  0.0519421, 0.0522136, 0.0524783, 0.0527361, 0.0529871, 0.0532312,
  0.0534684, 0.0536987, 0.0539221, 0.0541386, 0.0543481, 0.0545508,
  0.0547465, 0.0549352, 0.055117, 0.0552919, 0.0554599, 0.0556209,
  0.0557749, 0.055922, 0.0560622, 0.0561954, 0.0563217, 0.0564411,
  0.0565535, 0.056659, 0.0567576, 0.0568493, 0.0569341, 0.057012,
  0.057083, 0.0571471, 0.0572044, 0.0572548, 0.0572984, 0.0573351,
  0.057365, 0.0573882, 0.0574045, 0.0574141, 0.0574169, 0.057413,
  0.0574024, 0.057385, 0.057361, 0.0573303, 0.057293, 0.0572491,
  0.0571985, 0.0571414, 0.0570777, 0.0570075, 0.0569307, 0.0568475,
  0.0567578, 0.0566617, 0.0565591, 0.0564502, 0.056335, 0.0562133,
  0.0560854, 0.0559513, 0.0558108, 0.0556642, 0.0555114, 0.0553524,
  0.0551873, 0.0550161, 0.0548388, 0.0546555, 0.0544663, 0.054271,
  0.0540699, 0.0538628, 0.0536499, 0.0534312, 0.0532067, 0.0529764,
  0.0527404, 0.0524988, 0.0522515, 0.0519986, 0.0517401, 0.0514761,
  0.0512067, 0.0509318, 0.0506515, 0.0503658, 0.0500748, 0.0497785,
  0.049477, 0.0491703, 0.0488584, 0.0485414, 0.0482193, 0.0478922,
  0.0475602, 0.0472231, 0.0468812, 0.0465344, 0.0461829, 0.0458265,
  0.0454654, 0.0450997, 0.0447293, 0.0443544, 0.0439749, 0.0435909,
  0.0432025, 0.0428097, 0.0424126, 0.0420111, 0.0416054, 0.0411955,
  0.0407815, 0.0403633, 0.0399411, 0.0395149, 0.0390847, 0.0386506,
  0.0382126, 0.0377709, 0.0373253, 0.0368761, 0.0364232, 0.0359667,
  0.0355067, 0.0350431, 0.0345761, 0.0341057, 0.0336319, 0.0331549,
  0.0326745, 0.032191, 0.0317044, 0.0312146, 0.0307218, 0.0302261,
  0.0297273, 0.0292257, 0.0287213, 0.0282141, 0.0277042, 0.0271916,
  0.0266764, 0.0261586, 0.0256383, 0.0251155, 0.0245904, 0.0240629,
  0.0235331, 0.023001, 0.0224668, 0.0219304, 0.021392, 0.0208515,
  0.020309, 0.0197646, 0.0192184, 0.0186703, 0.0181205, 0.017569,
  0.0170158, 0.016461, 0.0159047, 0.0153469, 0.0147876, 0.014227,
  0.0136651, 0.0131019, 0.0125374, 0.0119718, 0.0114051, 0.0108373,
  0.0102685, 0.00969879, 0.00912816, 0.00855669, 0.00798443,
  0.00741143, 0.00683776, 0.00626345, 0.00568857, 0.00511317,
  0.0045373, 0.00396102, 0.00338437, 0.00280742, 0.00223021,
  0.00165279, 0.00107523, 0.000497566, -8.01415e-05, -0.000657842,
  -0.00123548, -0.00181301, -0.00239038, -0.00296752, -0.00354441,
  -0.00412097, -0.00469716, -0.00527293, -0.00584822, -0.00642299,
  -0.00699718, -0.00757075, -0.00814363, -0.00871579, -0.00928717,
  -0.00985772, -0.0104274, -0.0109961, -0.0115639, -0.0121306,
  -0.0126963, -0.0132608, -0.0138242, -0.0143863, -0.0149471,
  -0.0155067, -0.0160648, -0.0166216, -0.0171768, -0.0177306,
  -0.0182828, -0.0188334, -0.0193823, -0.0199295, -0.020475,
  -0.0210187, -0.0215605, -0.0221004, -0.0226384, -0.0231745,
  -0.0237085, -0.0242404, -0.0247702, -0.0252979, -0.0258233,
  -0.0263465, -0.0268674, -0.027386, -0.0279021, -0.0284159,
  -0.0289272, -0.029436, -0.0299422, -0.0304458, -0.0309468,
  -0.0314452, -0.0319408, -0.0324336, -0.0329237, -0.0334109,
  -0.0338952, -0.0343766, -0.0348551, -0.0353305, -0.0358029,
  -0.0362722, -0.0367384, -0.0372015, -0.0376614, -0.038118,
  -0.0385714, -0.0390214, -0.0394681, -0.0399115, -0.0403514,
  -0.0407879, -0.0412209, -0.0416504, -0.0420763, -0.0424986,
  -0.0429173, -0.0433324, -0.0437438, -0.0441514, -0.0445553,
  -0.0449554, -0.0453516, -0.0457441, -0.0461326, -0.0465172,
  -0.0468979, -0.0472746, -0.0476473, -0.0480159, -0.0483805,
  -0.048741, -0.0490974, -0.0494496, -0.0497976, -0.0501414,
  -0.050481, -0.0508163, -0.0511474, -0.0514741, -0.0517965,
  -0.0521145, -0.0524281, -0.0527373, -0.0530421, -0.0533423,
  -0.0536381, -0.0539294, -0.0542162, -0.0544984, -0.054776,
  -0.055049, -0.0553174, -0.0555811, -0.0558402, -0.0560945,
  -0.0563442, -0.0565892, -0.0568294, -0.0570648, -0.0572954,
  -0.0575213, -0.0577423, -0.0579585, -0.0581699, -0.0583763,
  -0.0585779, -0.0587746, -0.0589664, -0.0591532, -0.0593351,
  -0.059512, -0.0596839, -0.0598509, -0.0600129, -0.0601698,
  -0.0603217, -0.0604686, -0.0606104, -0.0607472, -0.0608789,
  -0.0610055, -0.061127, -0.0612434, -0.0613547, -0.0614609,
  -0.061562, -0.0616579, -0.0617487, -0.0618343, -0.0619148,
  -0.0619901, -0.0620603, -0.0621253, -0.062185, -0.0622397,
  -0.0622891, -0.0623333, -0.0623723, -0.0624062, -0.0624348,
  -0.0624582, -0.0624765, -0.0624895, -0.0624973, -0.0624999,
  -0.0624973, -0.0624895, -0.0624765, -0.0624582, -0.0624348,
  -0.0624062, -0.0623723, -0.0623333, -0.0622891, -0.0622397,
  -0.062185, -0.0621253, -0.0620603, -0.0619901, -0.0619148,
  -0.0618343, -0.0617487, -0.0616579, -0.061562, -0.0614609,
  -0.0613547, -0.0612434, -0.061127, -0.0610055, -0.0608789,
  -0.0607472, -0.0606104, -0.0604686, -0.0603217, -0.0601698,
  -0.0600129, -0.0598509, -0.0596839, -0.059512, -0.0593351,
  -0.0591532, -0.0589664, -0.0587746, -0.0585779, -0.0583763,
  -0.0581699, -0.0579585, -0.0577423, -0.0575213, -0.0572954,
  -0.0570648, -0.0568294, -0.0565892, -0.0563442, -0.0560945,
  -0.0558402, -0.0555811, -0.0553174, -0.055049, -0.054776,
  -0.0544984, -0.0542162, -0.0539294, -0.0536381, -0.0533423,
  -0.0530421, -0.0527373, -0.0524281, -0.0521145, -0.0517965,
  -0.0514741, -0.0511474, -0.0508163, -0.050481, -0.0501414,
  -0.0497976, -0.0494496, -0.0490974, -0.048741, -0.0483805,
  -0.0480159, -0.0476473, -0.0472746, -0.0468979, -0.0465172,
  -0.0461326, -0.0457441, -0.0453516, -0.0449554, -0.0445553,
  -0.0441514, -0.0437438, -0.0433324, -0.0429173, -0.0424986,
  -0.0420763, -0.0416504, -0.0412209, -0.0407879, -0.0403514,
  -0.0399115, -0.0394681, -0.0390214, -0.0385714, -0.038118,
  -0.0376614, -0.0372015, -0.0367384, -0.0362722, -0.0358029,
  -0.0353305, -0.0348551, -0.0343766, -0.0338952, -0.0334109,
  -0.0329237, -0.0324336, -0.0319408, -0.0314452, -0.0309468,
  -0.0304458, -0.0299422, -0.029436, -0.0289272, -0.0284159,
  -0.0279021, -0.027386, -0.0268674, -0.0263465, -0.0258233,
  -0.0252979, -0.0247702, -0.0242404, -0.0237085, -0.0231745,
  -0.0226384, -0.0221004, -0.0215605, -0.0210187, -0.020475,
  -0.0199295, -0.0193823, -0.0188334, -0.0182828, -0.0177306,
  -0.0171768, -0.0166216, -0.0160648, -0.0155067, -0.0149471,
  -0.0143863, -0.0138242, -0.0132608, -0.0126963, -0.0121306,
  -0.0115639, -0.0109961, -0.0104274, -0.00985772, -0.00928717,
  -0.00871579, -0.00814363, -0.00757075, -0.00699718, -0.00642299,
  -0.00584822, -0.00527293, -0.00469716, -0.00412097, -0.00354441,
  -0.00296752, -0.00239038, -0.00181301, -0.00123548, -0.000657842,
  -8.01415e-05, 0.000497566, 0.00107523, 0.00165279, 0.00223021,
  0.00280742, 0.00338437, 0.00396102, 0.0045373, 0.00511317,
  0.00568857, 0.00626345, 0.00683776, 0.00741143, 0.00798443,
  0.00855669, 0.00912816, 0.00969879, 0.0102685, 0.0108373, 0.0114051,
  0.0119718, 0.0125374, 0.0131019, 0.0136651, 0.014227, 0.0147876,
  0.0153469, 0.0159047, 0.016461, 0.0170158, 0.017569, 0.0181205,
  0.0186703, 0.0192184, 0.0197646, 0.020309, 0.0208515, 0.021392,
  0.0219304, 0.0224668, 0.023001, 0.0235331, 0.0240629, 0.0245904,
  0.0251155, 0.0256383, 0.0261586, 0.0266764, 0.0271916, 0.0277042,
  0.0282141, 0.0287213, 0.0292257, 0.0297273, 0.0302261, 0.0307218,
  0.0312146, 0.0317044, 0.032191, 0.0326745, 0.0331549, 0.0336319,
  0.0341057, 0.0345761, 0.0350431, 0.0355067, 0.0359667, 0.0364232,
  0.0368761, 0.0373253, 0.0377709, 0.0382126, 0.0386506, 0.0390847,
  0.0395149, 0.0399411, 0.0403633, 0.0407815, 0.0411955, 0.0416054,
  0.0420111, 0.0424126, 0.0428097, 0.0432025, 0.0435909, 0.0439749,
  0.0443544, 0.0447293, 0.0450997, 0.0454654, 0.0458265, 0.0461829,
  0.0465344, 0.0468812, 0.0472231, 0.0475602, 0.0478922, 0.0482193,
  0.0485414, 0.0488584, 0.0491703, 0.049477, 0.0497785, 0.0500748,
  0.0503658, 0.0506515, 0.0509318, 0.0512067, 0.0514761, 0.0517401,
  0.0519986, 0.0522515, 0.0524988, 0.0527404, 0.0529764, 0.0532067,
  0.0534312, 0.0536499, 0.0538628, 0.0540699, 0.054271, 0.0544663,
  0.0546555, 0.0548388, 0.0550161, 0.0551873, 0.0553524, 0.0555114,
  0.0556642, 0.0558108, 0.0559513, 0.0560854, 0.0562133, 0.056335,
  0.0564502, 0.0565591, 0.0566617, 0.0567578, 0.0568475, 0.0569307,
  0.0570075, 0.0570777, 0.0571414, 0.0571985, 0.0572491, 0.057293,
  0.0573303, 0.057361, 0.057385, 0.0574024, 0.057413, 0.0574169,
  0.0574141, 0.0574045, 0.0573882, 0.057365, 0.0573351, 0.0572984,
  0.0572548, 0.0572044, 0.0571471, 0.057083, 0.057012, 0.0569341,
  0.0568493, 0.0567576, 0.056659, 0.0565535, 0.0564411, 0.0563217,
  0.0561954, 0.0560622, 0.055922, 0.0557749, 0.0556209, 0.0554599,
  0.0552919, 0.055117, 0.0549352, 0.0547465, 0.0545508, 0.0543481,
  0.0541386, 0.0539221, 0.0536987, 0.0534684, 0.0532312, 0.0529871,
  0.0527361, 0.0524783, 0.0522136, 0.0519421, 0.0516637, 0.0513786,
  0.0510866, 0.0507879, 0.0504823, 0.0501701, 0.0498511, 0.0495254,
  0.0491931, 0.0488541, 0.0485084, 0.0481561, 0.0477973, 0.0474319,
  0.04706, 0.0466815, 0.0462966, 0.0459052, 0.0455075, 0.0451033,
  0.0446928, 0.044276, 0.043853, 0.0434237, 0.0429882, 0.0425465,
  0.0420987, 0.0416449, 0.041185, 0.0407192, 0.0402473, 0.0397696,
  0.0392861, 0.0387967, 0.0383016, 0.0378008, 0.0372944, 0.0367823,
  0.0362647, 0.0357417, 0.0352132, 0.0346793, 0.0341401, 0.0335957,
  0.0330461, 0.0324914, 0.0319316, 0.0313668, 0.0307971, 0.0302225,
  0.0296432, 0.0290591, 0.0284704, 0.0278772, 0.0272794, 0.0266772,
  0.0260707, 0.0254599, 0.0248449, 0.0242259, 0.0236028, 0.0229758,
  0.022345, 0.0217104, 0.0210721, 0.0204303, 0.0197849, 0.0191362,
  0.0184842, 0.017829, 0.0171707, 0.0165094, 0.0158452, 0.0151782,
  0.0145085, 0.0138362, 0.0131615, 0.0124843, 0.0118049, 0.0111234,
  0.0104398, 0.00975427, 0.00906695, 0.00837794, 0.00768736,
  0.00699534, 0.00630199, 0.00560744, 0.00491182, 0.00421525,
  0.00351786, 0.00281979, 0.00212117, 0.00142212, 0.000722797,
  2.33278e-05, -0.000676146, -0.00137548, -0.00207454, -0.00277317,
  -0.00347123, -0.00416858, -0.00486505, -0.0055605, -0.00625477,
  -0.00694771, -0.00763917, -0.00832897, -0.00901697, -0.00970299,
  -0.0103869, -0.0110685, -0.0117476, -0.0124241, -0.0130977,
  -0.0137684, -0.0144359, -0.0151001, -0.0157607, -0.0164177,
  -0.0170707, -0.0177197, -0.0183644, -0.0190047, -0.0196403,
  -0.0202711, -0.0208969, -0.0215174, -0.0221325, -0.022742,
  -0.0233456, -0.0239432, -0.0245346, -0.0251195, -0.0256977,
  -0.026269, -0.0268333, -0.0273902, -0.0279396, -0.0284812,
  -0.0290148, -0.0295403, -0.0300573, -0.0305656, -0.031065,
  -0.0315552, -0.0320361, -0.0325074, -0.0329688, -0.03342, -0.033861,
  -0.0342913, -0.0347108, -0.0351191, -0.0355161, -0.0359015,
  -0.036275, -0.0366364, -0.0369853, -0.0373216, -0.0376449,
  -0.037955, -0.0382516, -0.0385344, -0.0388032, -0.0390576,
  -0.0392974, -0.0395223, -0.0397321, -0.0399263, -0.0401048,
  -0.0402671, -0.0404132, -0.0405425, -0.0406548, -0.0407499,
  -0.0408274, -0.0408869, -0.0409283, -0.0409511, -0.040955,
  -0.0409398, -0.0409051, -0.0408505, -0.0407758, -0.0406806,
  -0.0405645, -0.0404273, -0.0402686, -0.0400881, -0.0398853,
  -0.03966, -0.0394118, -0.0391404, -0.0388454, -0.0385264,
  -0.0381831, -0.037815, -0.037422, -0.0370035, -0.0365592,
  -0.0360888, -0.0355918, -0.0350678, -0.0345166, -0.0339376,
  -0.0333305, -0.032695, -0.0320306, -0.0313368, -0.0306134, -0.02986,
  -0.029076, -0.0282611, -0.0274149, -0.0265369, -0.0256268,
  -0.0246842, -0.0237085, -0.0226994, -0.0216564, -0.0205792,
  -0.0194672, -0.01832, -0.0171372, -0.0159184, -0.014663, -0.0133707,
  -0.0120409, -0.0106733, -0.00926732, -0.00782254, -0.00633848,
  -0.00481467, -0.00325064, -0.00164591, -3.37187e-17}; G4double
  G4NeutronHPFastLegendre::l6[1401] = {1, 0.970214, 0.940852,
  0.911912, 0.88339, 0.855281, 0.827583, 0.800292, 0.773404, 0.746916,
  0.720824, 0.695126, 0.669816, 0.644892, 0.620351, 0.596189,
  0.572403, 0.548988, 0.525943, 0.503263, 0.480946, 0.458987,
  0.437385, 0.416134, 0.395233, 0.374678, 0.354465, 0.334592,
  0.315055, 0.295852, 0.276978, 0.258432, 0.240209, 0.222307,
  0.204723, 0.187454, 0.170496, 0.153846, 0.137503, 0.121462, 0.10572,
  0.0902757, 0.0751248, 0.0602649, 0.0456929, 0.0314061, 0.0174015,
  0.00367635, -0.00977218, -0.0229469, -0.0358507, -0.0484862,
  -0.0608562, -0.0729635, -0.0848107, -0.0964007, -0.107736,
  -0.118819, -0.129654, -0.140241, -0.150585, -0.160687, -0.17055,
  -0.180177, -0.18957, -0.198732, -0.207666, -0.216373, -0.224857,
  -0.23312, -0.241164, -0.248992, -0.256606, -0.264009, -0.271203,
  -0.278191, -0.284974, -0.291555, -0.297937, -0.304122, -0.310112,
  -0.315909, -0.321516, -0.326935, -0.332168, -0.337218, -0.342087,
  -0.346776, -0.351289, -0.355627, -0.359792, -0.363787, -0.367614,
  -0.371274, -0.374771, -0.378106, -0.38128, -0.384297, -0.387159,
  -0.389866, -0.392422, -0.394828, -0.397087, -0.399199, -0.401168,
  -0.402996, -0.404683, -0.406232, -0.407646, -0.408925, -0.410072,
  -0.411089, -0.411977, -0.412739, -0.413375, -0.413889, -0.414281,
  -0.414554, -0.41471, -0.414749, -0.414674, -0.414487, -0.41419,
  -0.413783, -0.413269, -0.412649, -0.411926, -0.4111, -0.410174,
  -0.409149, -0.408026, -0.406808, -0.405495, -0.404091, -0.402595,
  -0.401009, -0.399336, -0.397577, -0.395733, -0.393805, -0.391796,
  -0.389707, -0.387538, -0.385293, -0.382971, -0.380575, -0.378106,
  -0.375566, -0.372955, -0.370276, -0.367529, -0.364716, -0.361839,
  -0.358898, -0.355895, -0.352831, -0.349709, -0.346528, -0.343291,
  -0.339998, -0.336651, -0.333251, -0.329799, -0.326297, -0.322746,
  -0.319147, -0.315501, -0.311809, -0.308073, -0.304294, -0.300473,
  -0.296611, -0.292709, -0.288769, -0.284791, -0.280777, -0.276728,
  -0.272644, -0.268527, -0.264379, -0.260199, -0.255989, -0.251751,
  -0.247485, -0.243192, -0.238873, -0.234529, -0.230162, -0.225772,
  -0.22136, -0.216927, -0.212474, -0.208002, -0.203512, -0.199005,
  -0.194482, -0.189944, -0.185391, -0.180824, -0.176245, -0.171655,
  -0.167053, -0.162441, -0.157821, -0.153191, -0.148555, -0.143911,
  -0.139262, -0.134607, -0.129949, -0.125286, -0.120621, -0.115954,
  -0.111286, -0.106617, -0.101948, -0.0972807, -0.0926147, -0.0879512,
  -0.0832907, -0.0786341, -0.0739819, -0.0693349, -0.0646938,
  -0.0600591, -0.0554316, -0.050812, -0.0462007, -0.0415986,
  -0.0370061, -0.032424, -0.0278528, -0.0232931, -0.0187456,
  -0.0142107, -0.00968914, -0.00518141, -0.000688097, 0.00379025,
  0.00825309, 0.0126999, 0.0171301, 0.0215432, 0.0259386, 0.030316,
  0.0346747, 0.0390143, 0.0433342, 0.047634, 0.0519133, 0.0561715,
  0.0604083, 0.064623, 0.0688154, 0.0729849, 0.0771312, 0.0812538,
  0.0853522, 0.0894261, 0.0934751, 0.0974988, 0.101497, 0.105469,
  0.109414, 0.113332, 0.117224, 0.121087, 0.124923, 0.12873, 0.132509,
  0.136259, 0.13998, 0.143671, 0.147332, 0.150963, 0.154563, 0.158132,
  0.161671, 0.165177, 0.168653, 0.172096, 0.175507, 0.178886,
  0.182231, 0.185544, 0.188824, 0.19207, 0.195282, 0.198461, 0.201605,
  0.204715, 0.20779, 0.210831, 0.213836, 0.216807, 0.219742, 0.222641,
  0.225505, 0.228332, 0.231124, 0.233879, 0.236599, 0.239281,
  0.241927, 0.244536, 0.247108, 0.249642, 0.25214, 0.2546, 0.257023,
  0.259408, 0.261756, 0.264065, 0.266337, 0.268571, 0.270766,
  0.272924, 0.275043, 0.277124, 0.279166, 0.28117, 0.283136, 0.285062,
  0.286951, 0.2888, 0.290611, 0.292383, 0.294116, 0.29581, 0.297466,
  0.299082, 0.30066, 0.302199, 0.303698, 0.305159, 0.306581, 0.307964,
  0.309308, 0.310613, 0.311879, 0.313106, 0.314294, 0.315443,
  0.316554, 0.317625, 0.318658, 0.319652, 0.320608, 0.321524,
  0.322403, 0.323242, 0.324043, 0.324806, 0.32553, 0.326216, 0.326864,
  0.327473, 0.328045, 0.328578, 0.329073, 0.329531, 0.329951,
  0.330333, 0.330678, 0.330985, 0.331254, 0.331487, 0.331682, 0.33184,
  0.331962, 0.332046, 0.332094, 0.332105, 0.33208, 0.332018, 0.33192,
  0.331786, 0.331617, 0.331411, 0.33117, 0.330893, 0.330581, 0.330233,
  0.329851, 0.329433, 0.328981, 0.328495, 0.327973, 0.327418,
  0.326828, 0.326205, 0.325548, 0.324857, 0.324132, 0.323375,
  0.322584, 0.321761, 0.320904, 0.320016, 0.319094, 0.318141,
  0.317156, 0.316139, 0.315091, 0.314011, 0.3129, 0.311758, 0.310585,
  0.309382, 0.308148, 0.306884, 0.305591, 0.304267, 0.302914,
  0.301532, 0.300121, 0.298681, 0.297212, 0.295715, 0.294189,
  0.292636, 0.291055, 0.289446, 0.287811, 0.286148, 0.284458,
  0.282742, 0.280999, 0.279231, 0.277436, 0.275616, 0.273771, 0.2719,
  0.270004, 0.268084, 0.26614, 0.264171, 0.262178, 0.260162, 0.258122,
  0.256059, 0.253973, 0.251865, 0.249734, 0.247581, 0.245406, 0.24321,
  0.240992, 0.238753, 0.236493, 0.234213, 0.231912, 0.229591, 0.22725,
  0.22489, 0.222511, 0.220112, 0.217695, 0.215259, 0.212805, 0.210333,
  0.207844, 0.205337, 0.202813, 0.200272, 0.197714, 0.19514, 0.192551,
  0.189945, 0.187324, 0.184687, 0.182036, 0.17937, 0.176689, 0.173994,
  0.171286, 0.168564, 0.165828, 0.16308, 0.160319, 0.157545, 0.154759,
  0.151961, 0.149151, 0.14633, 0.143498, 0.140656, 0.137802, 0.134938,
  0.132065, 0.129181, 0.126288, 0.123386, 0.120475, 0.117556,
  0.114628, 0.111692, 0.108748, 0.105797, 0.102838, 0.0998728,
  0.0969007, 0.0939221, 0.0909374, 0.0879469, 0.0849508, 0.0819493,
  0.0789429, 0.0759317, 0.072916, 0.069896, 0.0668722, 0.0638447,
  0.0608138, 0.0577797, 0.0547428, 0.0517034, 0.0486616, 0.0456178,
  0.0425723, 0.0395252, 0.0364769, 0.0334276, 0.0303777, 0.0273273,
  0.0242767, 0.0212263, 0.0181762, 0.0151268, 0.0120782, 0.00903087,
  0.00598492, 0.00294065, -0.000101671, -0.00314178, -0.00617943,
  -0.00921435, -0.0122463, -0.015275, -0.0183002, -0.0213216,
  -0.0243391, -0.0273522, -0.0303609, -0.0333648, -0.0363636,
  -0.0393572, -0.0423453, -0.0453276, -0.0483039, -0.0512739,
  -0.0542374, -0.0571942, -0.0601439, -0.0630865, -0.0660215,
  -0.0689488, -0.0718681, -0.0747793, -0.077682, -0.080576,
  -0.0834611, -0.0863371, -0.0892036, -0.0920606, -0.0949077,
  -0.0977447, -0.100571, -0.103388, -0.106193, -0.108988, -0.111771,
  -0.114543, -0.117303, -0.120051, -0.122787, -0.125511, -0.128223,
  -0.130921, -0.133607, -0.136279, -0.138938, -0.141584, -0.144216,
  -0.146833, -0.149437, -0.152026, -0.154601, -0.15716, -0.159705,
  -0.162234, -0.164748, -0.167247, -0.169729, -0.172196, -0.174646,
  -0.17708, -0.179497, -0.181898, -0.184282, -0.186648, -0.188998,
  -0.191329, -0.193644, -0.19594, -0.198218, -0.200478, -0.20272,
  -0.204943, -0.207147, -0.209332, -0.211499, -0.213646, -0.215774,
  -0.217882, -0.219971, -0.222039, -0.224088, -0.226116, -0.228125,
  -0.230112, -0.232079, -0.234025, -0.235951, -0.237855, -0.239738,
  -0.241599, -0.243439, -0.245258, -0.247055, -0.248829, -0.250582,
  -0.252313, -0.254021, -0.255706, -0.25737, -0.25901, -0.260628,
  -0.262223, -0.263794, -0.265343, -0.266868, -0.26837, -0.269848,
  -0.271303, -0.272734, -0.274141, -0.275524, -0.276883, -0.278218,
  -0.279528, -0.280815, -0.282077, -0.283314, -0.284527, -0.285715,
  -0.286878, -0.288016, -0.289129, -0.290218, -0.291281, -0.292319,
  -0.293331, -0.294319, -0.29528, -0.296217, -0.297127, -0.298012,
  -0.298872, -0.299705, -0.300513, -0.301295, -0.30205, -0.30278,
  -0.303484, -0.304161, -0.304813, -0.305438, -0.306037, -0.30661,
  -0.307156, -0.307676, -0.308169, -0.308636, -0.309077, -0.309491,
  -0.309878, -0.310239, -0.310573, -0.310881, -0.311162, -0.311416,
  -0.311643, -0.311844, -0.312018, -0.312165, -0.312286, -0.312379,
  -0.312446, -0.312487, -0.3125, -0.312487, -0.312446, -0.312379,
  -0.312286, -0.312165, -0.312018, -0.311844, -0.311643, -0.311416,
  -0.311162, -0.310881, -0.310573, -0.310239, -0.309878, -0.309491,
  -0.309077, -0.308636, -0.308169, -0.307676, -0.307156, -0.30661,
  -0.306037, -0.305438, -0.304813, -0.304161, -0.303484, -0.30278,
  -0.30205, -0.301295, -0.300513, -0.299705, -0.298872, -0.298012,
  -0.297127, -0.296217, -0.29528, -0.294319, -0.293331, -0.292319,
  -0.291281, -0.290218, -0.289129, -0.288016, -0.286878, -0.285715,
  -0.284527, -0.283314, -0.282077, -0.280815, -0.279528, -0.278218,
  -0.276883, -0.275524, -0.274141, -0.272734, -0.271303, -0.269848,
  -0.26837, -0.266868, -0.265343, -0.263794, -0.262223, -0.260628,
  -0.25901, -0.25737, -0.255706, -0.254021, -0.252313, -0.250582,
  -0.248829, -0.247055, -0.245258, -0.243439, -0.241599, -0.239738,
  -0.237855, -0.235951, -0.234025, -0.232079, -0.230112, -0.228125,
  -0.226116, -0.224088, -0.222039, -0.219971, -0.217882, -0.215774,
  -0.213646, -0.211499, -0.209332, -0.207147, -0.204943, -0.20272,
  -0.200478, -0.198218, -0.19594, -0.193644, -0.191329, -0.188998,
  -0.186648, -0.184282, -0.181898, -0.179497, -0.17708, -0.174646,
  -0.172196, -0.169729, -0.167247, -0.164748, -0.162234, -0.159705,
  -0.15716, -0.154601, -0.152026, -0.149437, -0.146833, -0.144216,
  -0.141584, -0.138938, -0.136279, -0.133607, -0.130921, -0.128223,
  -0.125511, -0.122787, -0.120051, -0.117303, -0.114543, -0.111771,
  -0.108988, -0.106193, -0.103388, -0.100571, -0.0977447, -0.0949077,
  -0.0920606, -0.0892036, -0.0863371, -0.0834611, -0.080576,
  -0.077682, -0.0747793, -0.0718681, -0.0689488, -0.0660215,
  -0.0630865, -0.0601439, -0.0571942, -0.0542374, -0.0512739,
  -0.0483039, -0.0453276, -0.0423453, -0.0393572, -0.0363636,
  -0.0333648, -0.0303609, -0.0273522, -0.0243391, -0.0213216,
  -0.0183002, -0.015275, -0.0122463, -0.00921435, -0.00617943,
  -0.00314178, -0.000101671, 0.00294065, 0.00598492, 0.00903087,
  0.0120782, 0.0151268, 0.0181762, 0.0212263, 0.0242767, 0.0273273,
  0.0303777, 0.0334276, 0.0364769, 0.0395252, 0.0425723, 0.0456178,
  0.0486616, 0.0517034, 0.0547428, 0.0577797, 0.0608138, 0.0638447,
  0.0668722, 0.069896, 0.072916, 0.0759317, 0.0789429, 0.0819493,
  0.0849508, 0.0879469, 0.0909374, 0.0939221, 0.0969007, 0.0998728,
  0.102838, 0.105797, 0.108748, 0.111692, 0.114628, 0.117556,
  0.120475, 0.123386, 0.126288, 0.129181, 0.132065, 0.134938,
  0.137802, 0.140656, 0.143498, 0.14633, 0.149151, 0.151961, 0.154759,
  0.157545, 0.160319, 0.16308, 0.165828, 0.168564, 0.171286, 0.173994,
  0.176689, 0.17937, 0.182036, 0.184687, 0.187324, 0.189945, 0.192551,
  0.19514, 0.197714, 0.200272, 0.202813, 0.205337, 0.207844, 0.210333,
  0.212805, 0.215259, 0.217695, 0.220112, 0.222511, 0.22489, 0.22725,
  0.229591, 0.231912, 0.234213, 0.236493, 0.238753, 0.240992, 0.24321,
  0.245406, 0.247581, 0.249734, 0.251865, 0.253973, 0.256059,
  0.258122, 0.260162, 0.262178, 0.264171, 0.26614, 0.268084, 0.270004,
  0.2719, 0.273771, 0.275616, 0.277436, 0.279231, 0.280999, 0.282742,
  0.284458, 0.286148, 0.287811, 0.289446, 0.291055, 0.292636,
  0.294189, 0.295715, 0.297212, 0.298681, 0.300121, 0.301532,
  0.302914, 0.304267, 0.305591, 0.306884, 0.308148, 0.309382,
  0.310585, 0.311758, 0.3129, 0.314011, 0.315091, 0.316139, 0.317156,
  0.318141, 0.319094, 0.320016, 0.320904, 0.321761, 0.322584,
  0.323375, 0.324132, 0.324857, 0.325548, 0.326205, 0.326828,
  0.327418, 0.327973, 0.328495, 0.328981, 0.329433, 0.329851,
  0.330233, 0.330581, 0.330893, 0.33117, 0.331411, 0.331617, 0.331786,
  0.33192, 0.332018, 0.33208, 0.332105, 0.332094, 0.332046, 0.331962,
  0.33184, 0.331682, 0.331487, 0.331254, 0.330985, 0.330678, 0.330333,
  0.329951, 0.329531, 0.329073, 0.328578, 0.328045, 0.327473,
  0.326864, 0.326216, 0.32553, 0.324806, 0.324043, 0.323242, 0.322403,
  0.321524, 0.320608, 0.319652, 0.318658, 0.317625, 0.316554,
  0.315443, 0.314294, 0.313106, 0.311879, 0.310613, 0.309308,
  0.307964, 0.306581, 0.305159, 0.303698, 0.302199, 0.30066, 0.299082,
  0.297466, 0.29581, 0.294116, 0.292383, 0.290611, 0.2888, 0.286951,
  0.285062, 0.283136, 0.28117, 0.279166, 0.277124, 0.275043, 0.272924,
  0.270766, 0.268571, 0.266337, 0.264065, 0.261756, 0.259408,
  0.257023, 0.2546, 0.25214, 0.249642, 0.247108, 0.244536, 0.241927,
  0.239281, 0.236599, 0.233879, 0.231124, 0.228332, 0.225505,
  0.222641, 0.219742, 0.216807, 0.213836, 0.210831, 0.20779, 0.204715,
  0.201605, 0.198461, 0.195282, 0.19207, 0.188824, 0.185544, 0.182231,
  0.178886, 0.175507, 0.172096, 0.168653, 0.165177, 0.161671,
  0.158132, 0.154563, 0.150963, 0.147332, 0.143671, 0.13998, 0.136259,
  0.132509, 0.12873, 0.124923, 0.121087, 0.117224, 0.113332, 0.109414,
  0.105469, 0.101497, 0.0974988, 0.0934751, 0.0894261, 0.0853522,
  0.0812538, 0.0771312, 0.0729849, 0.0688154, 0.064623, 0.0604083,
  0.0561715, 0.0519133, 0.047634, 0.0433342, 0.0390143, 0.0346747,
  0.030316, 0.0259386, 0.0215432, 0.0171301, 0.0126999, 0.00825309,
  0.00379025, -0.000688097, -0.00518141, -0.00968914, -0.0142107,
  -0.0187456, -0.0232931, -0.0278528, -0.032424, -0.0370061,
  -0.0415986, -0.0462007, -0.050812, -0.0554316, -0.0600591,
  -0.0646938, -0.0693349, -0.0739819, -0.0786341, -0.0832907,
  -0.0879512, -0.0926147, -0.0972807, -0.101948, -0.106617, -0.111286,
  -0.115954, -0.120621, -0.125286, -0.129949, -0.134607, -0.139262,
  -0.143911, -0.148555, -0.153191, -0.157821, -0.162441, -0.167053,
  -0.171655, -0.176245, -0.180824, -0.185391, -0.189944, -0.194482,
  -0.199005, -0.203512, -0.208002, -0.212474, -0.216927, -0.22136,
  -0.225772, -0.230162, -0.234529, -0.238873, -0.243192, -0.247485,
  -0.251751, -0.255989, -0.260199, -0.264379, -0.268527, -0.272644,
  -0.276728, -0.280777, -0.284791, -0.288769, -0.292709, -0.296611,
  -0.300473, -0.304294, -0.308073, -0.311809, -0.315501, -0.319147,
  -0.322746, -0.326297, -0.329799, -0.333251, -0.336651, -0.339998,
  -0.343291, -0.346528, -0.349709, -0.352831, -0.355895, -0.358898,
  -0.361839, -0.364716, -0.367529, -0.370276, -0.372955, -0.375566,
  -0.378106, -0.380575, -0.382971, -0.385293, -0.387538, -0.389707,
  -0.391796, -0.393805, -0.395733, -0.397577, -0.399336, -0.401009,
  -0.402595, -0.404091, -0.405495, -0.406808, -0.408026, -0.409149,
  -0.410174, -0.4111, -0.411926, -0.412649, -0.413269, -0.413783,
  -0.41419, -0.414487, -0.414674, -0.414749, -0.41471, -0.414554,
  -0.414281, -0.413889, -0.413375, -0.412739, -0.411977, -0.411089,
  -0.410072, -0.408925, -0.407646, -0.406232, -0.404683, -0.402996,
  -0.401168, -0.399199, -0.397087, -0.394828, -0.392422, -0.389866,
  -0.387159, -0.384297, -0.38128, -0.378106, -0.374771, -0.371274,
  -0.367614, -0.363787, -0.359792, -0.355627, -0.351289, -0.346776,
  -0.342087, -0.337218, -0.332168, -0.326935, -0.321516, -0.315909,
  -0.310112, -0.304122, -0.297937, -0.291555, -0.284974, -0.278191,
  -0.271203, -0.264009, -0.256606, -0.248992, -0.241164, -0.23312,
  -0.224857, -0.216373, -0.207666, -0.198732, -0.18957, -0.180177,
  -0.17055, -0.160687, -0.150585, -0.140241, -0.129654, -0.118819,
  -0.107736, -0.0964007, -0.0848107, -0.0729635, -0.0608562,
  -0.0484862, -0.0358507, -0.0229469, -0.00977218, 0.00367635,
  0.0174015, 0.0314061, 0.0456929, 0.0602649, 0.0751248, 0.0902757,
  0.10572, 0.121462, 0.137503, 0.153846, 0.170496, 0.187454, 0.204723,
  0.222307, 0.240209, 0.258432, 0.276978, 0.295852, 0.315055,
  0.334592, 0.354465, 0.374678, 0.395233, 0.416134, 0.437385,
  0.458987, 0.480946, 0.503263, 0.525943, 0.548988, 0.572403,
  0.596189, 0.620351, 0.644892, 0.669816, 0.695126, 0.720824,
  0.746916, 0.773404, 0.800292, 0.827583, 0.855281, 0.88339, 0.911912,
  0.940852, 0.970214, 1}; G4double G4NeutronHPFastLegendre::i6[1401] =
  {0, 0.00140724, 0.00277224, 0.00409559, 0.0053779, 0.00661975,
  0.00782175, 0.00898447, 0.0101085, 0.0111944, 0.0122427, 0.0132541,
  0.014229, 0.015168, 0.0160717, 0.0169406, 0.0177753, 0.0185762,
  0.019344, 0.0200791, 0.0207821, 0.0214534, 0.0220936, 0.0227032,
  0.0232827, 0.0238326, 0.0243534, 0.0248455, 0.0253095, 0.0257459,
  0.026155, 0.0265374, 0.0268935, 0.0272238, 0.0275288, 0.0278089,
  0.0280645, 0.0282962, 0.0285043, 0.0286892, 0.0288514, 0.0289914,
  0.0291095, 0.0292062, 0.0292818, 0.0293369, 0.0293717, 0.0293867,
  0.0293823, 0.0293589, 0.0293169, 0.0292566, 0.0291785, 0.0290829,
  0.0289701, 0.0288407, 0.0286948, 0.028533, 0.0283554, 0.0281626,
  0.0279549, 0.0277325, 0.0274959, 0.0272453, 0.0269812, 0.0267038,
  0.0264135, 0.0261106, 0.0257954, 0.0254682, 0.0251294, 0.0247793,
  0.0244181, 0.0240462, 0.0236639, 0.0232715, 0.0228692, 0.0224574,
  0.0220363, 0.0216062, 0.0211674, 0.0207203, 0.0202649, 0.0198017,
  0.0193309, 0.0188528, 0.0183675, 0.0178754, 0.0173768, 0.0168718,
  0.0163608, 0.015844, 0.0153215, 0.0147937, 0.0142608, 0.013723,
  0.0131806, 0.0126337, 0.0120826, 0.0115276, 0.0109688, 0.0104065,
  0.0098408, 0.00927201, 0.0087003, 0.00812588, 0.00754895,
  0.00696971, 0.00638835, 0.00580507, 0.00522005, 0.00463349,
  0.00404557, 0.00345648, 0.00286638, 0.00227546, 0.0016839,
  0.00109186, 0.000499512, -9.29727e-05, -0.000685432, -0.0012777,
  -0.00186963, -0.00246105, -0.00305182, -0.00364177, -0.00423076,
  -0.00481865, -0.00540529, -0.00599053, -0.00657424, -0.00715628,
  -0.0077365, -0.00831479, -0.00889101, -0.00946502, -0.0100367,
  -0.0106059, -0.0111726, -0.0117366, -0.0122977, -0.0128559,
  -0.0134111, -0.0139632, -0.0145119, -0.0150573, -0.0155993,
  -0.0161376, -0.0166723, -0.0172032, -0.0177302, -0.0182532,
  -0.0187722, -0.019287, -0.0197976, -0.0203038, -0.0208056,
  -0.021303, -0.0217957, -0.0222838, -0.0227671, -0.0232456,
  -0.0237192, -0.0241879, -0.0246515, -0.02511, -0.0255633,
  -0.0260114, -0.0264541, -0.0268916, -0.0273235, -0.02775, -0.028171,
  -0.0285863, -0.028996, -0.0294, -0.0297982, -0.0301906, -0.0305772,
  -0.0309578, -0.0313325, -0.0317012, -0.0320639, -0.0324205,
  -0.032771, -0.0331153, -0.0334535, -0.0337854, -0.0341111,
  -0.0344305, -0.0347435, -0.0350503, -0.0353506, -0.0356445,
  -0.035932, -0.0362131, -0.0364877, -0.0367558, -0.0370174,
  -0.0372724, -0.0375209, -0.0377629, -0.0379982, -0.038227,
  -0.0384491, -0.0386647, -0.0388736, -0.0390758, -0.0392715,
  -0.0394604, -0.0396427, -0.0398184, -0.0399874, -0.0401497,
  -0.0403053, -0.0404543, -0.0405966, -0.0407323, -0.0408612,
  -0.0409835, -0.0410992, -0.0412082, -0.0413106, -0.0414063,
  -0.0414954, -0.0415779, -0.0416538, -0.0417231, -0.0417858,
  -0.041842, -0.0418916, -0.0419346, -0.0419711, -0.0420012,
  -0.0420247, -0.0420418, -0.0420524, -0.0420566, -0.0420544,
  -0.0420458, -0.0420308, -0.0420095, -0.0419819, -0.0419479,
  -0.0419078, -0.0418613, -0.0418087, -0.0417499, -0.0416849,
  -0.0416138, -0.0415366, -0.0414533, -0.041364, -0.0412687,
  -0.0411674, -0.0410602, -0.040947, -0.040828, -0.0407032,
  -0.0405725, -0.0404361, -0.040294, -0.0401461, -0.0399926,
  -0.0398335, -0.0396689, -0.0394986, -0.0393229, -0.0391417,
  -0.0389551, -0.0387631, -0.0385658, -0.0383632, -0.0381553,
  -0.0379423, -0.037724, -0.0375007, -0.0372722, -0.0370388,
  -0.0368003, -0.0365569, -0.0363086, -0.0360555, -0.0357975,
  -0.0355348, -0.0352674, -0.0349954, -0.0347187, -0.0344374,
  -0.0341517, -0.0338614, -0.0335668, -0.0332678, -0.0329644,
  -0.0326568, -0.032345, -0.032029, -0.0317089, -0.0313847,
  -0.0310565, -0.0307244, -0.0303883, -0.0300484, -0.0297047,
  -0.0293572, -0.029006, -0.0286512, -0.0282928, -0.0279308,
  -0.0275654, -0.0271965, -0.0268242, -0.0264486, -0.0260698,
  -0.0256877, -0.0253024, -0.0249141, -0.0245227, -0.0241283,
  -0.0237309, -0.0233307, -0.0229276, -0.0225217, -0.0221131,
  -0.0217019, -0.021288, -0.0208716, -0.0204527, -0.0200313,
  -0.0196075, -0.0191814, -0.018753, -0.0183224, -0.0178896,
  -0.0174547, -0.0170177, -0.0165788, -0.0161378, -0.015695,
  -0.0152504, -0.014804, -0.0143558, -0.013906, -0.0134546,
  -0.0130016, -0.0125471, -0.0120912, -0.0116338, -0.0111752,
  -0.0107152, -0.010254, -0.00979167, -0.0093282, -0.00886367,
  -0.00839813, -0.00793164, -0.00746425, -0.00699602, -0.006527,
  -0.00605725, -0.00558681, -0.00511575, -0.00464411, -0.00417196,
  -0.00369933, -0.0032263, -0.00275291, -0.00227921, -0.00180526,
  -0.00133112, -0.00085682, -0.00038243, 9.20029e-05, 0.000566425,
  0.00104079, 0.00151503, 0.00198911, 0.00246298, 0.00293657,
  0.00340985, 0.00388275, 0.00435524, 0.00482725, 0.00529875,
  0.00576967, 0.00623997, 0.0067096, 0.00717851, 0.00764665,
  0.00811397, 0.00858043, 0.00904597, 0.00951055, 0.00997412,
  0.0104366, 0.010898, 0.0113583, 0.0118173, 0.0122751, 0.0127316,
  0.0131868, 0.0136406, 0.014093, 0.0145438, 0.0149932, 0.015441,
  0.0158872, 0.0163317, 0.0167746, 0.0172157, 0.017655, 0.0180925,
  0.0185281, 0.0189618, 0.0193935, 0.0198233, 0.020251, 0.0206766,
  0.0211002, 0.0215215, 0.0219407, 0.0223576, 0.0227723, 0.0231846,
  0.0235946, 0.0240021, 0.0244073, 0.02481, 0.0252101, 0.0256078,
  0.0260028, 0.0263952, 0.026785, 0.0271721, 0.0275564, 0.027938,
  0.0283168, 0.0286928, 0.0290659, 0.0294361, 0.0298034, 0.0301677,
  0.030529, 0.0308873, 0.0312425, 0.0315946, 0.0319437, 0.0322895,
  0.0326322, 0.0329717, 0.0333079, 0.0336408, 0.0339705, 0.0342968,
  0.0346198, 0.0349393, 0.0352555, 0.0355682, 0.0358775, 0.0361832,
  0.0364855, 0.0367842, 0.0370793, 0.0373708, 0.0376588, 0.037943,
  0.0382236, 0.0385006, 0.0387738, 0.0390433, 0.039309, 0.0395709,
  0.0398291, 0.0400834, 0.0403339, 0.0405805, 0.0408233, 0.0410621,
  0.0412971, 0.0415281, 0.0417551, 0.0419782, 0.0421973, 0.0424124,
  0.0426234, 0.0428304, 0.0430334, 0.0432323, 0.0434271, 0.0436179,
  0.0438045, 0.0439869, 0.0441653, 0.0443395, 0.0445095, 0.0446753,
  0.044837, 0.0449944, 0.0451477, 0.0452967, 0.0454415, 0.0455821,
  0.0457184, 0.0458504, 0.0459782, 0.0461017, 0.0462209, 0.0463358,
  0.0464465, 0.0465528, 0.0466548, 0.0467525, 0.0468458, 0.0469349,
  0.0470196, 0.0471, 0.047176, 0.0472477, 0.047315, 0.047378,
  0.0474367, 0.047491, 0.0475409, 0.0475865, 0.0476277, 0.0476645,
  0.047697, 0.0477252, 0.047749, 0.0477684, 0.0477835, 0.0477942,
  0.0478006, 0.0478026, 0.0478003, 0.0477936, 0.0477826, 0.0477673,
  0.0477477, 0.0477237, 0.0476954, 0.0476628, 0.0476258, 0.0475846,
  0.0475391, 0.0474893, 0.0474352, 0.0473768, 0.0473142, 0.0472473,
  0.0471762, 0.0471008, 0.0470212, 0.0469374, 0.0468494, 0.0467572,
  0.0466608, 0.0465602, 0.0464554, 0.0463465, 0.0462335, 0.0461163,
  0.045995, 0.0458697, 0.0457402, 0.0456066, 0.045469, 0.0453274,
  0.0451817, 0.045032, 0.0448783, 0.0447206, 0.0445589, 0.0443933,
  0.0442238, 0.0440503, 0.043873, 0.0436917, 0.0435066, 0.0433177,
  0.0431249, 0.0429283, 0.0427279, 0.0425238, 0.0423159, 0.0421043,
  0.0418889, 0.0416699, 0.0414472, 0.0412209, 0.0409909, 0.0407574,
  0.0405202, 0.0402795, 0.0400353, 0.0397876, 0.0395363, 0.0392816,
  0.0390235, 0.0387619, 0.038497, 0.0382287, 0.037957, 0.037682,
  0.0374037, 0.0371222, 0.0368374, 0.0365494, 0.0362582, 0.0359639,
  0.0356664, 0.0353658, 0.0350621, 0.0347554, 0.0344456, 0.0341329,
  0.0338171, 0.0334985, 0.0331769, 0.0328524, 0.0325251, 0.032195,
  0.031862, 0.0315263, 0.0311879, 0.0308468, 0.030503, 0.0301565,
  0.0298074, 0.0294558, 0.0291016, 0.0287448, 0.0283856, 0.028024,
  0.0276599, 0.0272934, 0.0269245, 0.0265534, 0.0261799, 0.0258042,
  0.0254262, 0.0250461, 0.0246637, 0.0242793, 0.0238928, 0.0235042,
  0.0231135, 0.0227209, 0.0223263, 0.0219298, 0.0215314, 0.0211312,
  0.0207291, 0.0203253, 0.0199197, 0.0195123, 0.0191033, 0.0186927,
  0.0182804, 0.0178666, 0.0174513, 0.0170344, 0.0166161, 0.0161963,
  0.0157752, 0.0153527, 0.0149289, 0.0145038, 0.0140774, 0.0136499,
  0.0132211, 0.0127913, 0.0123603, 0.0119283, 0.0114952, 0.0110612,
  0.0106262, 0.0101903, 0.00975353, 0.00931592, 0.00887752,
  0.00843835, 0.00799845, 0.00755788, 0.00711665, 0.00667481,
  0.0062324, 0.00578946, 0.00534602, 0.00490212, 0.0044578, 0.0040131,
  0.00356805, 0.0031227, 0.00267708, 0.00223123, 0.00178519, 0.001339,
  0.000892695, 0.000446311, -1.11607e-07, -0.000446534, -0.000892918,
  -0.00133923, -0.00178542, -0.00223146, -0.00267731, -0.00312293,
  -0.00356828, -0.00401332, -0.00445802, -0.00490234, -0.00534624,
  -0.00578968, -0.00623263, -0.00667504, -0.00711687, -0.0075581,
  -0.00799868, -0.00843857, -0.00887774, -0.00931615, -0.00975375,
  -0.0101905, -0.0106264, -0.0110614, -0.0114954, -0.0119285,
  -0.0123605, -0.0127915, -0.0132213, -0.0136501, -0.0140776,
  -0.014504, -0.0149291, -0.0153529, -0.0157754, -0.0161966,
  -0.0166163, -0.0170346, -0.0174515, -0.0178668, -0.0182807,
  -0.0186929, -0.0191036, -0.0195126, -0.0199199, -0.0203255,
  -0.0207293, -0.0211314, -0.0215317, -0.02193, -0.0223265,
  -0.0227211, -0.0231137, -0.0235044, -0.023893, -0.0242795,
  -0.024664, -0.0250463, -0.0254264, -0.0258044, -0.0261801,
  -0.0265536, -0.0269248, -0.0272936, -0.0276601, -0.0280242,
  -0.0283858, -0.0287451, -0.0291018, -0.029456, -0.0298076,
  -0.0301567, -0.0305032, -0.030847, -0.0311881, -0.0315266,
  -0.0318623, -0.0321952, -0.0325253, -0.0328527, -0.0331771,
  -0.0334987, -0.0338174, -0.0341331, -0.0344458, -0.0347556,
  -0.0350623, -0.035366, -0.0356666, -0.0359641, -0.0362584,
  -0.0365496, -0.0368376, -0.0371224, -0.037404, -0.0376822,
  -0.0379572, -0.0382289, -0.0384972, -0.0387622, -0.0390237,
  -0.0392819, -0.0395366, -0.0397878, -0.0400355, -0.0402798,
  -0.0405205, -0.0407576, -0.0409912, -0.0412211, -0.0414475,
  -0.0416701, -0.0418892, -0.0421045, -0.0423161, -0.042524,
  -0.0427282, -0.0429285, -0.0431251, -0.0433179, -0.0435069,
  -0.043692, -0.0438732, -0.0440506, -0.044224, -0.0443936,
  -0.0445592, -0.0447208, -0.0448785, -0.0450322, -0.0451819,
  -0.0453276, -0.0454692, -0.0456069, -0.0457404, -0.0458699,
  -0.0459953, -0.0461166, -0.0462337, -0.0463468, -0.0464557,
  -0.0465604, -0.046661, -0.0467574, -0.0468496, -0.0469377,
  -0.0470215, -0.0471011, -0.0471764, -0.0472476, -0.0473144,
  -0.0473771, -0.0474354, -0.0474895, -0.0475393, -0.0475848,
  -0.0476261, -0.047663, -0.0476956, -0.0477239, -0.0477479,
  -0.0477675, -0.0477829, -0.0477939, -0.0478005, -0.0478028,
  -0.0478008, -0.0477944, -0.0477837, -0.0477686, -0.0477492,
  -0.0477254, -0.0476973, -0.0476648, -0.0476279, -0.0475867,
  -0.0475411, -0.0474912, -0.0474369, -0.0473783, -0.0473153,
  -0.0472479, -0.0471762, -0.0471002, -0.0470198, -0.0469351,
  -0.0468461, -0.0467527, -0.046655, -0.046553, -0.0464467,
  -0.0463361, -0.0462211, -0.0461019, -0.0459784, -0.0458506,
  -0.0457186, -0.0455823, -0.0454417, -0.0452969, -0.0451479,
  -0.0449947, -0.0448372, -0.0446756, -0.0445097, -0.0443397,
  -0.0441655, -0.0439872, -0.0438047, -0.0436181, -0.0434274,
  -0.0432325, -0.0430336, -0.0428307, -0.0426236, -0.0424126,
  -0.0421975, -0.0419784, -0.0417553, -0.0415283, -0.0412973,
  -0.0410624, -0.0408235, -0.0405808, -0.0403341, -0.0400836,
  -0.0398293, -0.0395712, -0.0393092, -0.0390435, -0.038774,
  -0.0385008, -0.0382239, -0.0379433, -0.037659, -0.0373711,
  -0.0370795, -0.0367844, -0.0364857, -0.0361834, -0.0358777,
  -0.0355684, -0.0352557, -0.0349395, -0.03462, -0.034297, -0.0339707,
  -0.033641, -0.0333081, -0.0329719, -0.0326324, -0.0322897,
  -0.0319439, -0.0315949, -0.0312427, -0.0308875, -0.0305292,
  -0.0301679, -0.0298036, -0.0294363, -0.0290661, -0.028693,
  -0.028317, -0.0279382, -0.0275566, -0.0271723, -0.0267852,
  -0.0263954, -0.026003, -0.025608, -0.0252104, -0.0248102,
  -0.0244075, -0.0240024, -0.0235948, -0.0231848, -0.0227725,
  -0.0223578, -0.0219409, -0.0215218, -0.0211004, -0.0206769,
  -0.0202512, -0.0198235, -0.0193938, -0.018962, -0.0185283,
  -0.0180927, -0.0176552, -0.0172159, -0.0167748, -0.0163319,
  -0.0158874, -0.0154412, -0.0149934, -0.0145441, -0.0140932,
  -0.0136408, -0.013187, -0.0127319, -0.0122754, -0.0118176,
  -0.0113585, -0.0108983, -0.0104368, -0.00997434, -0.00951077,
  -0.00904619, -0.00858065, -0.0081142, -0.00764687, -0.00717873,
  -0.00670982, -0.00624019, -0.00576989, -0.00529897, -0.00482748,
  -0.00435546, -0.00388298, -0.00341007, -0.0029368, -0.0024632,
  -0.00198934, -0.00151525, -0.00104101, -0.000566648, -9.22261e-05,
  0.000382206, 0.000856597, 0.00133089, 0.00180504, 0.00227899,
  0.00275269, 0.00322608, 0.00369911, 0.00417173, 0.00464389,
  0.00511552, 0.00558659, 0.00605702, 0.00652678, 0.0069958,
  0.00746403, 0.00793142, 0.00839791, 0.00886345, 0.00932798,
  0.00979145, 0.0102538, 0.010715, 0.0111749, 0.0116336, 0.0120909,
  0.0125469, 0.0130014, 0.0134544, 0.0139058, 0.0143556, 0.0148038,
  0.0152502, 0.0156948, 0.0161376, 0.0165785, 0.0170175, 0.0174545,
  0.0178894, 0.0183222, 0.0187528, 0.0191812, 0.0196073, 0.020031,
  0.0204524, 0.0208714, 0.0212878, 0.0217017, 0.0221129, 0.0225215,
  0.0229274, 0.0233304, 0.0237307, 0.024128, 0.0245224, 0.0249139,
  0.0253022, 0.0256875, 0.0260695, 0.0264484, 0.026824, 0.0271963,
  0.0275651, 0.0279306, 0.0282926, 0.028651, 0.0290058, 0.029357,
  0.0297045, 0.0300482, 0.0303881, 0.0307242, 0.0310563, 0.0313845,
  0.0317087, 0.0320288, 0.0323448, 0.0326566, 0.0329642, 0.0332675,
  0.0335666, 0.0338612, 0.0341514, 0.0344372, 0.0347185, 0.0349951,
  0.0352672, 0.0355346, 0.0357973, 0.0360553, 0.0363084, 0.0365567,
  0.0368001, 0.0370386, 0.037272, 0.0375005, 0.0377238, 0.037942,
  0.0381551, 0.038363, 0.0385656, 0.0387629, 0.0389549, 0.0391415,
  0.0393227, 0.0394984, 0.0396686, 0.0398333, 0.0399924, 0.0401459,
  0.0402937, 0.0404359, 0.0405723, 0.0407029, 0.0408278, 0.0409468,
  0.0410599, 0.0411672, 0.0412685, 0.0413638, 0.0414531, 0.0415364,
  0.0416136, 0.0416847, 0.0417496, 0.0418085, 0.0418611, 0.0419075,
  0.0419477, 0.0419816, 0.0420093, 0.0420306, 0.0420455, 0.0420541,
  0.0420564, 0.0420522, 0.0420415, 0.0420245, 0.0420009, 0.0419709,
  0.0419344, 0.0418913, 0.0418417, 0.0417856, 0.0417229, 0.0416536,
  0.0415777, 0.0414952, 0.0414061, 0.0413104, 0.041208, 0.041099,
  0.0409833, 0.040861, 0.040732, 0.0405964, 0.0404541, 0.0403051,
  0.0401495, 0.0399872, 0.0398182, 0.0396425, 0.0394602, 0.0392712,
  0.0390756, 0.0388734, 0.0386645, 0.0384489, 0.0382268, 0.037998,
  0.0377627, 0.0375207, 0.0372722, 0.0370172, 0.0367556, 0.0364875,
  0.0362129, 0.0359318, 0.0356443, 0.0353504, 0.03505, 0.0347433,
  0.0344302, 0.0341109, 0.0337852, 0.0334533, 0.0331151, 0.0327708,
  0.0324203, 0.0320637, 0.031701, 0.0313323, 0.0309576, 0.030577,
  0.0301904, 0.029798, 0.0293998, 0.0289958, 0.0285861, 0.0281708,
  0.0277498, 0.0273233, 0.0268913, 0.0264539, 0.0260111, 0.0255631,
  0.0251097, 0.0246512, 0.0241876, 0.023719, 0.0232454, 0.0227669,
  0.0222835, 0.0217955, 0.0213027, 0.0208054, 0.0203036, 0.0197973,
  0.0192868, 0.018772, 0.018253, 0.0177299, 0.0172029, 0.016672,
  0.0161374, 0.015599, 0.0150571, 0.0145117, 0.0139629, 0.0134109,
  0.0128557, 0.0122975, 0.0117363, 0.0111724, 0.0106057, 0.0100365,
  0.0094648, 0.00889078, 0.00831457, 0.00773628, 0.00715605,
  0.00657402, 0.00599031, 0.00540507, 0.00481843, 0.00423054,
  0.00364155, 0.00305159, 0.00246083, 0.00186941, 0.00127748,
  0.000685209, 9.27494e-05, -0.000499735, -0.00109208, -0.00168412,
  -0.00227569, -0.0028666, -0.0034567, -0.0040458, -0.00463372,
  -0.00522028, -0.00580529, -0.00638857, -0.00696993, -0.00754917,
  -0.0081261, -0.00870052, -0.00927223, -0.00984103, -0.0104067,
  -0.010969, -0.0115278, -0.0120829, -0.0126339, -0.0131808,
  -0.0137232, -0.014261, -0.0147939, -0.0153217, -0.0158442,
  -0.016361, -0.0168721, -0.017377, -0.0178757, -0.0183677, -0.018853,
  -0.0193311, -0.0198019, -0.0202651, -0.0207205, -0.0211677,
  -0.0216064, -0.0220365, -0.0224576, -0.0228694, -0.0232717,
  -0.0236641, -0.0240465, -0.0244184, -0.0247795, -0.0251297,
  -0.0254685, -0.0257956, -0.0261108, -0.0264137, -0.026704,
  -0.0269814, -0.0272456, -0.0274961, -0.0277327, -0.0279551,
  -0.0281629, -0.0283557, -0.0285332, -0.028695, -0.0288409,
  -0.0289703, -0.0290831, -0.0291787, -0.0292568, -0.0293171,
  -0.0293591, -0.0293825, -0.0293869, -0.0293719, -0.0293371,
  -0.029282, -0.0292064, -0.0291097, -0.0289916, -0.0288516,
  -0.0286894, -0.0285045, -0.0282964, -0.0280648, -0.0278091,
  -0.027529, -0.0272241, -0.0268937, -0.0265376, -0.0261552,
  -0.0257461, -0.0253098, -0.0248458, -0.0243536, -0.0238328,
  -0.023283, -0.0227034, -0.0220938, -0.0214536, -0.0207823,
  -0.0200793, -0.0193442, -0.0185764, -0.0177755, -0.0169408,
  -0.0160719, -0.0151682, -0.0142292, -0.0132543, -0.0122429,
  -0.0111946, -0.0101087, -0.00898469, -0.00782197, -0.00661998,
  -0.00537812, -0.00409581, -0.00277246, -0.00140747, -2.23214e-07};
  G4double G4NeutronHPFastLegendre::l7[1601] = {-1, -0.965294,
  -0.931173, -0.89763, -0.86466, -0.832256, -0.800412, -0.769123,
  -0.738382, -0.708184, -0.678523, -0.649394, -0.620789, -0.592705,
  -0.565134, -0.538073, -0.511514, -0.485453, -0.459883, -0.4348,
  -0.410199, -0.386073, -0.362418, -0.339227, -0.316497, -0.294222,
  -0.272396, -0.251014, -0.230072, -0.209564, -0.189485, -0.169831,
  -0.150596, -0.131775, -0.113363, -0.0953569, -0.0777502, -0.0605385,
  -0.0437173, -0.0272817, -0.0112272, 0.00445093, 0.0197573,
  0.0346963, 0.0492727, 0.0634908, 0.0773551, 0.09087, 0.10404,
  0.116869, 0.129362, 0.141523, 0.153356, 0.164866, 0.176056,
  0.186931, 0.197494, 0.207751, 0.217705, 0.227359, 0.236719,
  0.245788, 0.254569, 0.263068, 0.271286, 0.27923, 0.286901, 0.294305,
  0.301445, 0.308323, 0.314945, 0.321314, 0.327433, 0.333307,
  0.338937, 0.344329, 0.349485, 0.35441, 0.359105, 0.363576, 0.367825,
  0.371855, 0.375671, 0.379274, 0.382669, 0.385859, 0.388847,
  0.391636, 0.394229, 0.396629, 0.39884, 0.400864, 0.402705, 0.404366,
  0.405849, 0.407157, 0.408294, 0.409263, 0.410065, 0.410705,
  0.411185, 0.411507, 0.411675, 0.411692, 0.411559, 0.41128, 0.410858,
  0.410294, 0.409592, 0.408755, 0.407784, 0.406682, 0.405453,
  0.404098, 0.40262, 0.401021, 0.399304, 0.397471, 0.395525, 0.393468,
  0.391302, 0.38903, 0.386654, 0.384175, 0.381598, 0.378922, 0.376152,
  0.373289, 0.370335, 0.367292, 0.364163, 0.360949, 0.357653,
  0.354276, 0.350821, 0.34729, 0.343685, 0.340007, 0.336258, 0.332441,
  0.328558, 0.32461, 0.320599, 0.316527, 0.312395, 0.308207, 0.303962,
  0.299664, 0.295314, 0.290913, 0.286464, 0.281967, 0.277425, 0.27284,
  0.268212, 0.263544, 0.258837, 0.254093, 0.249313, 0.244498,
  0.239651, 0.234773, 0.229865, 0.224928, 0.219965, 0.214977,
  0.209964, 0.204929, 0.199872, 0.194796, 0.189701, 0.184588, 0.17946,
  0.174317, 0.169161, 0.163993, 0.158813, 0.153624, 0.148427,
  0.143222, 0.138011, 0.132796, 0.127576, 0.122354, 0.11713, 0.111906,
  0.106682, 0.10146, 0.0962409, 0.0910254, 0.0858147, 0.0806097,
  0.0754115, 0.070221, 0.0650393, 0.0598672, 0.0547056, 0.0495556,
  0.044418, 0.0392937, 0.0341835, 0.0290884, 0.0240091, 0.0189466,
  0.0139016, 0.00887494, 0.00386742, -0.00112018, -0.00608708,
  -0.0110325, -0.0159558, -0.0208562, -0.0257329, -0.0305853,
  -0.0354127, -0.0402143, -0.0449896, -0.0497378, -0.0544584,
  -0.0591506, -0.063814, -0.0684478, -0.0730515, -0.0776244,
  -0.0821661, -0.086676, -0.0911534, -0.0955979, -0.100009, -0.104386,
  -0.108729, -0.113036, -0.117309, -0.121545, -0.125745, -0.129908,
  -0.134033, -0.138122, -0.142171, -0.146183, -0.150155, -0.154088,
  -0.157982, -0.161835, -0.165648, -0.16942, -0.173151, -0.176841,
  -0.180489, -0.184094, -0.187658, -0.191178, -0.194656, -0.19809,
  -0.201481, -0.204828, -0.208132, -0.211391, -0.214605, -0.217775,
  -0.220899, -0.223979, -0.227013, -0.230002, -0.232945, -0.235843,
  -0.238694, -0.241499, -0.244258, -0.24697, -0.249636, -0.252255,
  -0.254827, -0.257352, -0.25983, -0.262261, -0.264645, -0.266981,
  -0.26927, -0.271512, -0.273706, -0.275852, -0.277951, -0.280002,
  -0.282006, -0.283961, -0.285869, -0.287729, -0.289542, -0.291307,
  -0.293024, -0.294693, -0.296314, -0.297888, -0.299414, -0.300893,
  -0.302324, -0.303707, -0.305043, -0.306332, -0.307573, -0.308766,
  -0.309913, -0.311013, -0.312065, -0.313071, -0.314029, -0.314941,
  -0.315807, -0.316625, -0.317398, -0.318124, -0.318804, -0.319438,
  -0.320026, -0.320568, -0.321065, -0.321516, -0.321922, -0.322283,
  -0.322598, -0.322869, -0.323096, -0.323278, -0.323416, -0.323509,
  -0.323559, -0.323565, -0.323528, -0.323447, -0.323323, -0.323157,
  -0.322947, -0.322696, -0.322402, -0.322066, -0.321688, -0.321269,
  -0.320808, -0.320306, -0.319764, -0.319181, -0.318557, -0.317894,
  -0.31719, -0.316447, -0.315665, -0.314844, -0.313984, -0.313085,
  -0.312148, -0.311173, -0.31016, -0.30911, -0.308023, -0.306899,
  -0.305738, -0.304541, -0.303308, -0.302039, -0.300735, -0.299396,
  -0.298022, -0.296613, -0.295171, -0.293694, -0.292184, -0.29064,
  -0.289063, -0.287454, -0.285812, -0.284139, -0.282433, -0.280697,
  -0.278929, -0.27713, -0.275301, -0.273442, -0.271553, -0.269635,
  -0.267687, -0.265711, -0.263706, -0.261674, -0.259613, -0.257525,
  -0.25541, -0.253268, -0.2511, -0.248905, -0.246685, -0.24444,
  -0.242169, -0.239874, -0.237554, -0.235211, -0.232843, -0.230453,
  -0.228039, -0.225603, -0.223145, -0.220664, -0.218162, -0.215639,
  -0.213095, -0.21053, -0.207946, -0.205341, -0.202717, -0.200074,
  -0.197412, -0.194732, -0.192034, -0.189318, -0.186585, -0.183835,
  -0.181068, -0.178285, -0.175486, -0.172671, -0.169842, -0.166997,
  -0.164138, -0.161265, -0.158378, -0.155478, -0.152564, -0.149638,
  -0.1467, -0.143749, -0.140787, -0.137813, -0.134829, -0.131834,
  -0.128829, -0.125813, -0.122789, -0.119755, -0.116712, -0.113661,
  -0.110601, -0.107534, -0.104459, -0.101377, -0.0982885, -0.0951934,
  -0.0920922, -0.0889853, -0.085873, -0.0827556, -0.0796334,
  -0.0765069, -0.0733763, -0.070242, -0.0671043, -0.0639636,
  -0.0608201, -0.0576743, -0.0545264, -0.0513768, -0.0482258,
  -0.0450737, -0.041921, -0.0387678, -0.0356145, -0.0324614,
  -0.0293089, -0.0261573, -0.0230069, -0.019858, -0.0167109,
  -0.013566, -0.0104235, -0.00728382, -0.00414721, -0.001014,
  0.00211551, 0.005241, 0.00836219, 0.0114788, 0.0145904, 0.0176968,
  0.0207977, 0.0238928, 0.0269818, 0.0300644, 0.0331402, 0.0362091,
  0.0392707, 0.0423247, 0.0453709, 0.0484089, 0.0514385, 0.0544594,
  0.0574713, 0.060474, 0.0634671, 0.0664505, 0.0694237, 0.0723866,
  0.0753389, 0.0782803, 0.0812105, 0.0841293, 0.0870365, 0.0899317,
  0.0928147, 0.0956853, 0.0985432, 0.101388, 0.10422, 0.107038,
  0.109843, 0.112633, 0.11541, 0.118172, 0.120919, 0.123652, 0.126369,
  0.129071, 0.131758, 0.134428, 0.137083, 0.139722, 0.142343,
  0.144949, 0.147537, 0.150108, 0.152662, 0.155198, 0.157717,
  0.160217, 0.1627, 0.165164, 0.167609, 0.170036, 0.172443, 0.174832,
  0.177201, 0.179551, 0.181881, 0.184191, 0.186481, 0.188751, 0.191,
  0.193229, 0.195436, 0.197623, 0.199789, 0.201934, 0.204057,
  0.206158, 0.208238, 0.210296, 0.212331, 0.214345, 0.216336,
  0.218304, 0.22025, 0.222173, 0.224073, 0.22595, 0.227804, 0.229634,
  0.231441, 0.233224, 0.234983, 0.236719, 0.23843, 0.240118, 0.241781,
  0.24342, 0.245034, 0.246624, 0.248189, 0.249729, 0.251245, 0.252735,
  0.2542, 0.25564, 0.257055, 0.258445, 0.259809, 0.261147, 0.26246,
  0.263747, 0.265008, 0.266244, 0.267453, 0.268637, 0.269794,
  0.270925, 0.27203, 0.273109, 0.274161, 0.275187, 0.276187, 0.277159,
  0.278106, 0.279026, 0.279919, 0.280785, 0.281625, 0.282437,
  0.283223, 0.283983, 0.284715, 0.28542, 0.286098, 0.28675, 0.287374,
  0.287971, 0.288542, 0.289085, 0.289601, 0.29009, 0.290552, 0.290986,
  0.291394, 0.291775, 0.292128, 0.292454, 0.292753, 0.293025, 0.29327,
  0.293488, 0.293679, 0.293843, 0.293979, 0.294089, 0.294171,
  0.294227, 0.294255, 0.294257, 0.294232, 0.29418, 0.294101, 0.293995,
  0.293862, 0.293703, 0.293517, 0.293304, 0.293065, 0.292799,
  0.292507, 0.292188, 0.291843, 0.291471, 0.291073, 0.290649,
  0.290199, 0.289723, 0.289221, 0.288692, 0.288138, 0.287558,
  0.286953, 0.286321, 0.285664, 0.284982, 0.284274, 0.283541,
  0.282782, 0.281999, 0.28119, 0.280356, 0.279498, 0.278615, 0.277707,
  0.276774, 0.275817, 0.274835, 0.27383, 0.2728, 0.271746, 0.270668,
  0.269566, 0.268441, 0.267291, 0.266119, 0.264923, 0.263704,
  0.262461, 0.261196, 0.259908, 0.258597, 0.257263, 0.255907,
  0.254529, 0.253128, 0.251705, 0.250261, 0.248794, 0.247306,
  0.245796, 0.244265, 0.242713, 0.24114, 0.239545, 0.23793, 0.236294,
  0.234638, 0.232962, 0.231265, 0.229548, 0.227812, 0.226055,
  0.224279, 0.222484, 0.22067, 0.218837, 0.216984, 0.215113, 0.213224,
  0.211316, 0.20939, 0.207446, 0.205484, 0.203504, 0.201507, 0.199493,
  0.197461, 0.195413, 0.193348, 0.191266, 0.189168, 0.187054,
  0.184923, 0.182777, 0.180615, 0.178438, 0.176246, 0.174038,
  0.171816, 0.169579, 0.167327, 0.165061, 0.162781, 0.160488, 0.15818,
  0.155859, 0.153525, 0.151178, 0.148818, 0.146445, 0.144059,
  0.141662, 0.139252, 0.136831, 0.134398, 0.131953, 0.129498,
  0.127031, 0.124554, 0.122066, 0.119567, 0.117059, 0.11454, 0.112012,
  0.109475, 0.106928, 0.104372, 0.101807, 0.0992333, 0.0966515,
  0.0940614, 0.0914634, 0.0888577, 0.0862444, 0.0836239, 0.0809963,
  0.0783618, 0.0757207, 0.0730732, 0.0704195, 0.0677599, 0.0650945,
  0.0624236, 0.0597475, 0.0570663, 0.0543803, 0.0516897, 0.0489947,
  0.0462956, 0.0435926, 0.0408859, 0.0381758, 0.0354624, 0.0327461,
  0.030027, 0.0273053, 0.0245814, 0.0218553, 0.0191274, 0.0163979,
  0.0136671, 0.010935, 0.00820209, 0.00546844, 0.00273434, -0,
  -0.00273434, -0.00546844, -0.00820209, -0.010935, -0.0136671,
  -0.0163979, -0.0191274, -0.0218553, -0.0245814, -0.0273053,
  -0.030027, -0.0327461, -0.0354624, -0.0381758, -0.0408859,
  -0.0435926, -0.0462956, -0.0489947, -0.0516897, -0.0543803,
  -0.0570663, -0.0597475, -0.0624236, -0.0650945, -0.0677599,
  -0.0704195, -0.0730732, -0.0757207, -0.0783618, -0.0809963,
  -0.0836239, -0.0862444, -0.0888577, -0.0914634, -0.0940614,
  -0.0966515, -0.0992333, -0.101807, -0.104372, -0.106928, -0.109475,
  -0.112012, -0.11454, -0.117059, -0.119567, -0.122066, -0.124554,
  -0.127031, -0.129498, -0.131953, -0.134398, -0.136831, -0.139252,
  -0.141662, -0.144059, -0.146445, -0.148818, -0.151178, -0.153525,
  -0.155859, -0.15818, -0.160488, -0.162781, -0.165061, -0.167327,
  -0.169579, -0.171816, -0.174038, -0.176246, -0.178438, -0.180615,
  -0.182777, -0.184923, -0.187054, -0.189168, -0.191266, -0.193348,
  -0.195413, -0.197461, -0.199493, -0.201507, -0.203504, -0.205484,
  -0.207446, -0.20939, -0.211316, -0.213224, -0.215113, -0.216984,
  -0.218837, -0.22067, -0.222484, -0.224279, -0.226055, -0.227812,
  -0.229548, -0.231265, -0.232962, -0.234638, -0.236294, -0.23793,
  -0.239545, -0.24114, -0.242713, -0.244265, -0.245796, -0.247306,
  -0.248794, -0.250261, -0.251705, -0.253128, -0.254529, -0.255907,
  -0.257263, -0.258597, -0.259908, -0.261196, -0.262461, -0.263704,
  -0.264923, -0.266119, -0.267291, -0.268441, -0.269566, -0.270668,
  -0.271746, -0.2728, -0.27383, -0.274835, -0.275817, -0.276774,
  -0.277707, -0.278615, -0.279498, -0.280356, -0.28119, -0.281999,
  -0.282782, -0.283541, -0.284274, -0.284982, -0.285664, -0.286321,
  -0.286953, -0.287558, -0.288138, -0.288692, -0.289221, -0.289723,
  -0.290199, -0.290649, -0.291073, -0.291471, -0.291843, -0.292188,
  -0.292507, -0.292799, -0.293065, -0.293304, -0.293517, -0.293703,
  -0.293862, -0.293995, -0.294101, -0.29418, -0.294232, -0.294257,
  -0.294255, -0.294227, -0.294171, -0.294089, -0.293979, -0.293843,
  -0.293679, -0.293488, -0.29327, -0.293025, -0.292753, -0.292454,
  -0.292128, -0.291775, -0.291394, -0.290986, -0.290552, -0.29009,
  -0.289601, -0.289085, -0.288542, -0.287971, -0.287374, -0.28675,
  -0.286098, -0.28542, -0.284715, -0.283983, -0.283223, -0.282437,
  -0.281625, -0.280785, -0.279919, -0.279026, -0.278106, -0.277159,
  -0.276187, -0.275187, -0.274161, -0.273109, -0.27203, -0.270925,
  -0.269794, -0.268637, -0.267453, -0.266244, -0.265008, -0.263747,
  -0.26246, -0.261147, -0.259809, -0.258445, -0.257055, -0.25564,
  -0.2542, -0.252735, -0.251245, -0.249729, -0.248189, -0.246624,
  -0.245034, -0.24342, -0.241781, -0.240118, -0.23843, -0.236719,
  -0.234983, -0.233224, -0.231441, -0.229634, -0.227804, -0.22595,
  -0.224073, -0.222173, -0.22025, -0.218304, -0.216336, -0.214345,
  -0.212331, -0.210296, -0.208238, -0.206158, -0.204057, -0.201934,
  -0.199789, -0.197623, -0.195436, -0.193229, -0.191, -0.188751,
  -0.186481, -0.184191, -0.181881, -0.179551, -0.177201, -0.174832,
  -0.172443, -0.170036, -0.167609, -0.165164, -0.1627, -0.160217,
  -0.157717, -0.155198, -0.152662, -0.150108, -0.147537, -0.144949,
  -0.142343, -0.139722, -0.137083, -0.134428, -0.131758, -0.129071,
  -0.126369, -0.123652, -0.120919, -0.118172, -0.11541, -0.112633,
  -0.109843, -0.107038, -0.10422, -0.101388, -0.0985432, -0.0956853,
  -0.0928147, -0.0899317, -0.0870365, -0.0841293, -0.0812105,
  -0.0782803, -0.0753389, -0.0723866, -0.0694237, -0.0664505,
  -0.0634671, -0.060474, -0.0574713, -0.0544594, -0.0514385,
  -0.0484089, -0.0453709, -0.0423247, -0.0392707, -0.0362091,
  -0.0331402, -0.0300644, -0.0269818, -0.0238928, -0.0207977,
  -0.0176968, -0.0145904, -0.0114788, -0.00836219, -0.005241,
  -0.00211551, 0.001014, 0.00414721, 0.00728382, 0.0104235, 0.013566,
  0.0167109, 0.019858, 0.0230069, 0.0261573, 0.0293089, 0.0324614,
  0.0356145, 0.0387678, 0.041921, 0.0450737, 0.0482258, 0.0513768,
  0.0545264, 0.0576743, 0.0608201, 0.0639636, 0.0671043, 0.070242,
  0.0733763, 0.0765069, 0.0796334, 0.0827556, 0.085873, 0.0889853,
  0.0920922, 0.0951934, 0.0982885, 0.101377, 0.104459, 0.107534,
  0.110601, 0.113661, 0.116712, 0.119755, 0.122789, 0.125813,
  0.128829, 0.131834, 0.134829, 0.137813, 0.140787, 0.143749, 0.1467,
  0.149638, 0.152564, 0.155478, 0.158378, 0.161265, 0.164138,
  0.166997, 0.169842, 0.172671, 0.175486, 0.178285, 0.181068,
  0.183835, 0.186585, 0.189318, 0.192034, 0.194732, 0.197412,
  0.200074, 0.202717, 0.205341, 0.207946, 0.21053, 0.213095, 0.215639,
  0.218162, 0.220664, 0.223145, 0.225603, 0.228039, 0.230453,
  0.232843, 0.235211, 0.237554, 0.239874, 0.242169, 0.24444, 0.246685,
  0.248905, 0.2511, 0.253268, 0.25541, 0.257525, 0.259613, 0.261674,
  0.263706, 0.265711, 0.267687, 0.269635, 0.271553, 0.273442,
  0.275301, 0.27713, 0.278929, 0.280697, 0.282433, 0.284139, 0.285812,
  0.287454, 0.289063, 0.29064, 0.292184, 0.293694, 0.295171, 0.296613,
  0.298022, 0.299396, 0.300735, 0.302039, 0.303308, 0.304541,
  0.305738, 0.306899, 0.308023, 0.30911, 0.31016, 0.311173, 0.312148,
  0.313085, 0.313984, 0.314844, 0.315665, 0.316447, 0.31719, 0.317894,
  0.318557, 0.319181, 0.319764, 0.320306, 0.320808, 0.321269,
  0.321688, 0.322066, 0.322402, 0.322696, 0.322947, 0.323157,
  0.323323, 0.323447, 0.323528, 0.323565, 0.323559, 0.323509,
  0.323416, 0.323278, 0.323096, 0.322869, 0.322598, 0.322283,
  0.321922, 0.321516, 0.321065, 0.320568, 0.320026, 0.319438,
  0.318804, 0.318124, 0.317398, 0.316625, 0.315807, 0.314941,
  0.314029, 0.313071, 0.312065, 0.311013, 0.309913, 0.308766,
  0.307573, 0.306332, 0.305043, 0.303707, 0.302324, 0.300893,
  0.299414, 0.297888, 0.296314, 0.294693, 0.293024, 0.291307,
  0.289542, 0.287729, 0.285869, 0.283961, 0.282006, 0.280002,
  0.277951, 0.275852, 0.273706, 0.271512, 0.26927, 0.266981, 0.264645,
  0.262261, 0.25983, 0.257352, 0.254827, 0.252255, 0.249636, 0.24697,
  0.244258, 0.241499, 0.238694, 0.235843, 0.232945, 0.230002,
  0.227013, 0.223979, 0.220899, 0.217775, 0.214605, 0.211391,
  0.208132, 0.204828, 0.201481, 0.19809, 0.194656, 0.191178, 0.187658,
  0.184094, 0.180489, 0.176841, 0.173151, 0.16942, 0.165648, 0.161835,
  0.157982, 0.154088, 0.150155, 0.146183, 0.142171, 0.138122,
  0.134033, 0.129908, 0.125745, 0.121545, 0.117309, 0.113036,
  0.108729, 0.104386, 0.100009, 0.0955979, 0.0911534, 0.086676,
  0.0821661, 0.0776244, 0.0730515, 0.0684478, 0.063814, 0.0591506,
  0.0544584, 0.0497378, 0.0449896, 0.0402143, 0.0354127, 0.0305853,
  0.0257329, 0.0208562, 0.0159558, 0.0110325, 0.00608708, 0.00112018,
  -0.00386742, -0.00887494, -0.0139016, -0.0189466, -0.0240091,
  -0.0290884, -0.0341835, -0.0392937, -0.044418, -0.0495556,
  -0.0547056, -0.0598672, -0.0650393, -0.070221, -0.0754115,
  -0.0806097, -0.0858147, -0.0910254, -0.0962409, -0.10146, -0.106682,
  -0.111906, -0.11713, -0.122354, -0.127576, -0.132796, -0.138011,
  -0.143222, -0.148427, -0.153624, -0.158813, -0.163993, -0.169161,
  -0.174317, -0.17946, -0.184588, -0.189701, -0.194796, -0.199872,
  -0.204929, -0.209964, -0.214977, -0.219965, -0.224928, -0.229865,
  -0.234773, -0.239651, -0.244498, -0.249313, -0.254093, -0.258837,
  -0.263544, -0.268212, -0.27284, -0.277425, -0.281967, -0.286464,
  -0.290913, -0.295314, -0.299664, -0.303962, -0.308207, -0.312395,
  -0.316527, -0.320599, -0.32461, -0.328558, -0.332441, -0.336258,
  -0.340007, -0.343685, -0.34729, -0.350821, -0.354276, -0.357653,
  -0.360949, -0.364163, -0.367292, -0.370335, -0.373289, -0.376152,
  -0.378922, -0.381598, -0.384175, -0.386654, -0.38903, -0.391302,
  -0.393468, -0.395525, -0.397471, -0.399304, -0.401021, -0.40262,
  -0.404098, -0.405453, -0.406682, -0.407784, -0.408755, -0.409592,
  -0.410294, -0.410858, -0.41128, -0.411559, -0.411692, -0.411675,
  -0.411507, -0.411185, -0.410705, -0.410065, -0.409263, -0.408294,
  -0.407157, -0.405849, -0.404366, -0.402705, -0.400864, -0.39884,
  -0.396629, -0.394229, -0.391636, -0.388847, -0.385859, -0.382669,
  -0.379274, -0.375671, -0.371855, -0.367825, -0.363576, -0.359105,
  -0.35441, -0.349485, -0.344329, -0.338937, -0.333307, -0.327433,
  -0.321314, -0.314945, -0.308323, -0.301445, -0.294305, -0.286901,
  -0.27923, -0.271286, -0.263068, -0.254569, -0.245788, -0.236719,
  -0.227359, -0.217705, -0.207751, -0.197494, -0.186931, -0.176056,
  -0.164866, -0.153356, -0.141523, -0.129362, -0.116869, -0.10404,
  -0.09087, -0.0773551, -0.0634908, -0.0492727, -0.0346963,
  -0.0197573, -0.00445093, 0.0112272, 0.0272817, 0.0437173, 0.0605385,
  0.0777502, 0.0953569, 0.113363, 0.131775, 0.150596, 0.169831,
  0.189485, 0.209564, 0.230072, 0.251014, 0.272396, 0.294222,
  0.316497, 0.339227, 0.362418, 0.386073, 0.410199, 0.4348, 0.459883,
  0.485453, 0.511514, 0.538073, 0.565134, 0.592705, 0.620789,
  0.649394, 0.678523, 0.708184, 0.738382, 0.769123, 0.800412,
  0.832256, 0.86466, 0.89763, 0.931173, 0.965294, 1}; G4double
  G4NeutronHPFastLegendre::i7[1601] = {0, -0.00122825, -0.00241348,
  -0.00355642, -0.00465779, -0.0057183, -0.00673866, -0.00771956,
  -0.00866169, -0.00956573, -0.0104324, -0.0112623, -0.0120561,
  -0.0128144, -0.013538, -0.0142275, -0.0148834, -0.0155065,
  -0.0160973, -0.0166564, -0.0171845, -0.0176821, -0.0181498,
  -0.0185883, -0.0189981, -0.0193797, -0.0197338, -0.0200609,
  -0.0203615, -0.0206363, -0.0208856, -0.0211102, -0.0213104,
  -0.0214868, -0.02164, -0.0217704, -0.0218785, -0.0219649, -0.02203,
  -0.0220744, -0.0220984, -0.0221026, -0.0220874, -0.0220534,
  -0.0220008, -0.0219303, -0.0218423, -0.0217371, -0.0216152,
  -0.0214771, -0.0213232, -0.0211539, -0.0209695, -0.0207706,
  -0.0205575, -0.0203306, -0.0200903, -0.019837, -0.019571,
  -0.0192928, -0.0190028, -0.0187012, -0.0183884, -0.0180648,
  -0.0177308, -0.0173867, -0.0170329, -0.0166696, -0.0162972,
  -0.0159161, -0.0155265, -0.0151288, -0.0147233, -0.0143104,
  -0.0138902, -0.0134631, -0.0130295, -0.0125895, -0.0121435,
  -0.0116918, -0.0112347, -0.0107723, -0.0103051, -0.00983326,
  -0.00935702, -0.00887667, -0.00839246, -0.00790463, -0.00741345,
  -0.00691914, -0.00642195, -0.00592212, -0.00541987, -0.00491543,
  -0.00440903, -0.00390088, -0.0033912, -0.00288021, -0.00236812,
  -0.00185512, -0.00134142, -0.000827218, -0.000312713, 0.000201908,
  0.000716456, 0.00123075, 0.0017446, 0.00225783, 0.00277028,
  0.00328176, 0.00379211, 0.00430116, 0.00480876, 0.00531474,
  0.00581896, 0.00632124, 0.00682146, 0.00731946, 0.00781509,
  0.00830822, 0.00879872, 0.00928644, 0.00977125, 0.010253, 0.0107316,
  0.011207, 0.0116789, 0.0121473, 0.0126121, 0.0130731, 0.0135303,
  0.0139835, 0.0144326, 0.0148776, 0.0153183, 0.0157546, 0.0161865,
  0.0166138, 0.0170365, 0.0174544, 0.0178675, 0.0182758, 0.018679,
  0.0190773, 0.0194703, 0.0198582, 0.0202408, 0.0206181, 0.02099,
  0.0213564, 0.0217172, 0.0220725, 0.0224221, 0.0227661, 0.0231042,
  0.0234366, 0.0237631, 0.0240836, 0.0243983, 0.0247069, 0.0250095,
  0.025306, 0.0255964, 0.0258807, 0.0261587, 0.0264306, 0.0266962,
  0.0269555, 0.0272085, 0.0274552, 0.0276955, 0.0279294, 0.0281569,
  0.028378, 0.0285927, 0.0288009, 0.0290027, 0.029198, 0.0293868,
  0.029569, 0.0297448, 0.0299141, 0.0300768, 0.030233, 0.0303827,
  0.0305258, 0.0306624, 0.0307925, 0.0309161, 0.0310331, 0.0311437,
  0.0312477, 0.0313452, 0.0314362, 0.0315207, 0.0315988, 0.0316704,
  0.0317356, 0.0317943, 0.0318466, 0.0318925, 0.0319321, 0.0319653,
  0.0319921, 0.0320127, 0.0320269, 0.0320348, 0.0320366, 0.0320321,
  0.0320214, 0.0320045, 0.0319815, 0.0319524, 0.0319171, 0.0318759,
  0.0318286, 0.0317754, 0.0317162, 0.031651, 0.03158, 0.0315032,
  0.0314205, 0.0313321, 0.0312379, 0.031138, 0.0310325, 0.0309213,
  0.0308046, 0.0306824, 0.0305546, 0.0304214, 0.0302828, 0.0301388,
  0.0299895, 0.029835, 0.0296752, 0.0295102, 0.0293401, 0.0291649,
  0.0289847, 0.0287995, 0.0286093, 0.0284143, 0.0282144, 0.0280097,
  0.0278003, 0.0275862, 0.0273674, 0.0271441, 0.0269162, 0.0266839,
  0.0264471, 0.026206, 0.0259605, 0.0257108, 0.0254568, 0.0251987,
  0.0249365, 0.0246702, 0.0244, 0.0241258, 0.0238478, 0.0235659,
  0.0232803, 0.0229909, 0.0226979, 0.0224013, 0.0221012, 0.0217976,
  0.0214906, 0.0211802, 0.0208665, 0.0205496, 0.0202295, 0.0199062,
  0.0195799, 0.0192506, 0.0189183, 0.0185831, 0.0182451, 0.0179044,
  0.0175609, 0.0172148, 0.016866, 0.0165148, 0.016161, 0.0158049,
  0.0154464, 0.0150856, 0.0147226, 0.0143573, 0.01399, 0.0136206,
  0.0132493, 0.0128759, 0.0125007, 0.0121237, 0.0117449, 0.0113645,
  0.0109824, 0.0105987, 0.0102134, 0.00982677, 0.00943868, 0.00904926,
  0.00865854, 0.0082666, 0.00787349, 0.00747926, 0.00708399,
  0.00668772, 0.00629051, 0.00589243, 0.00549352, 0.00509385,
  0.00469348, 0.00429245, 0.00389084, 0.00348868, 0.00308605,
  0.00268299, 0.00227957, 0.00187584, 0.00147185, 0.00106766,
  0.00066333, 0.000258907, -0.00014555, -0.000549988, -0.000954352,
  -0.00135859, -0.00176264, -0.00216646, -0.00256999, -0.00297318,
  -0.00337598, -0.00377833, -0.00418018, -0.00458149, -0.00498219,
  -0.00538224, -0.00578158, -0.00618017, -0.00657796, -0.00697489,
  -0.00737092, -0.00776599, -0.00816006, -0.00855309, -0.00894501,
  -0.00933578, -0.00972536, -0.0101137, -0.0105007, -0.0108865,
  -0.0112708, -0.0116537, -0.0120351, -0.012415, -0.0127934,
  -0.0131701, -0.0135452, -0.0139186, -0.0142902, -0.0146601,
  -0.0150282, -0.0153943, -0.0157586, -0.0161209, -0.0164812,
  -0.0168395, -0.0171958, -0.0175499, -0.0179018, -0.0182516,
  -0.0185991, -0.0189444, -0.0192874, -0.019628, -0.0199663,
  -0.0203021, -0.0206355, -0.0209663, -0.0212947, -0.0216205,
  -0.0219437, -0.0222643, -0.0225822, -0.0228975, -0.02321,
  -0.0235197, -0.0238267, -0.0241308, -0.0244321, -0.0247305,
  -0.025026, -0.0253185, -0.0256081, -0.0258946, -0.0261782,
  -0.0264586, -0.026736, -0.0270103, -0.0272814, -0.0275494,
  -0.0278141, -0.0280757, -0.028334, -0.028589, -0.0288408,
  -0.0290892, -0.0293343, -0.029576, -0.0298144, -0.0300493,
  -0.0302808, -0.0305089, -0.0307335, -0.0309546, -0.0311722,
  -0.0313863, -0.0315968, -0.0318038, -0.0320072, -0.0322069,
  -0.0324031, -0.0325956, -0.0327845, -0.0329697, -0.0331512,
  -0.0333291, -0.0335032, -0.0336736, -0.0338403, -0.0340032,
  -0.0341623, -0.0343177, -0.0344693, -0.0346171, -0.0347611,
  -0.0349012, -0.0350376, -0.0351701, -0.0352987, -0.0354235,
  -0.0355444, -0.0356615, -0.0357747, -0.035884, -0.0359894,
  -0.0360908, -0.0361884, -0.0362821, -0.0363719, -0.0364577,
  -0.0365396, -0.0366176, -0.0366917, -0.0367618, -0.036828,
  -0.0368903, -0.0369486, -0.0370029, -0.0370534, -0.0370999,
  -0.0371424, -0.037181, -0.0372157, -0.0372464, -0.0372732,
  -0.037296, -0.037315, -0.03733, -0.037341, -0.0373482, -0.0373514,
  -0.0373507, -0.0373461, -0.0373376, -0.0373252, -0.0373089,
  -0.0372887, -0.0372647, -0.0372367, -0.0372049, -0.0371693,
  -0.0371298, -0.0370864, -0.0370393, -0.0369883, -0.0369335,
  -0.0368748, -0.0368124, -0.0367463, -0.0366763, -0.0366026,
  -0.0365251, -0.0364439, -0.036359, -0.0362704, -0.036178, -0.036082,
  -0.0359823, -0.035879, -0.035772, -0.0356614, -0.0355472,
  -0.0354294, -0.035308, -0.035183, -0.0350545, -0.0349225,
  -0.0347869, -0.0346479, -0.0345054, -0.0343594, -0.0342099,
  -0.0340571, -0.0339008, -0.0337412, -0.0335781, -0.0334118,
  -0.0332421, -0.0330691, -0.0328928, -0.0327132, -0.0325304,
  -0.0323444, -0.0321551, -0.0319627, -0.0317672, -0.0315684,
  -0.0313666, -0.0311617, -0.0309537, -0.0307427, -0.0305286,
  -0.0303116, -0.0300916, -0.0298686, -0.0296427, -0.0294139,
  -0.0291822, -0.0289477, -0.0287104, -0.0284702, -0.0282273,
  -0.0279816, -0.0277332, -0.0274822, -0.0272284, -0.026972,
  -0.026713, -0.0264514, -0.0261873, -0.0259206, -0.0256515,
  -0.0253798, -0.0251057, -0.0248292, -0.0245503, -0.024269,
  -0.0239854, -0.0236995, -0.0234113, -0.0231209, -0.0228283,
  -0.0225335, -0.0222365, -0.0219374, -0.0216362, -0.021333,
  -0.0210277, -0.0207204, -0.0204111, -0.0200999, -0.0197868,
  -0.0194718, -0.019155, -0.0188363, -0.0185159, -0.0181937,
  -0.0178698, -0.0175442, -0.0172169, -0.0168881, -0.0165576,
  -0.0162255, -0.015892, -0.0155569, -0.0152204, -0.0148824,
  -0.0145431, -0.0142024, -0.0138603, -0.013517, -0.0131724,
  -0.0128265, -0.0124795, -0.0121313, -0.0117819, -0.0114315,
  -0.01108, -0.0107274, -0.0103739, -0.0100194, -0.00966396,
  -0.00930762, -0.00895042, -0.00859239, -0.00823356, -0.00787396,
  -0.00751364, -0.00715262, -0.00679094, -0.00642863, -0.00606573,
  -0.00570226, -0.00533827, -0.00497379, -0.00460885, -0.00424348,
  -0.00387772, -0.00351161, -0.00314517, -0.00277844, -0.00241146,
  -0.00204426, -0.00167686, -0.00130932, -0.000941653, -0.000573901,
  -0.000206097, 0.000161726, 0.000529535, 0.000897295, 0.00126497,
  0.00163254, 0.00199995, 0.00236718, 0.00273419, 0.00310096,
  0.00346744, 0.00383361, 0.00419943, 0.00456487, 0.00492989,
  0.00529446, 0.00565856, 0.00602214, 0.00638517, 0.00674762,
  0.00710947, 0.00747066, 0.00783119, 0.008191, 0.00855007,
  0.00890837, 0.00926586, 0.00962252, 0.00997831, 0.0103332,
  0.0106871, 0.0110401, 0.0113921, 0.0117431, 0.012093, 0.0124418,
  0.0127895, 0.0131361, 0.0134815, 0.0138256, 0.0141685, 0.0145102,
  0.0148505, 0.0151895, 0.0155272, 0.0158635, 0.0161983, 0.0165317,
  0.0168636, 0.017194, 0.0175228, 0.0178501, 0.0181758, 0.0184999,
  0.0188223, 0.019143, 0.019462, 0.0197793, 0.0200949, 0.0204086,
  0.0207205, 0.0210306, 0.0213388, 0.021645, 0.0219494, 0.0222518,
  0.0225523, 0.0228507, 0.0231471, 0.0234414, 0.0237337, 0.0240238,
  0.0243118, 0.0245977, 0.0248813, 0.0251628, 0.025442, 0.025719,
  0.0259937, 0.0262661, 0.0265361, 0.0268039, 0.0270692, 0.0273321,
  0.0275927, 0.0278507, 0.0281064, 0.0283595, 0.0286101, 0.0288582,
  0.0291038, 0.0293467, 0.0295871, 0.0298249, 0.03006, 0.0302925,
  0.0305223, 0.0307495, 0.0309739, 0.0311956, 0.0314145, 0.0316306,
  0.031844, 0.0320546, 0.0322623, 0.0324672, 0.0326693, 0.0328685,
  0.0330647, 0.0332581, 0.0334485, 0.033636, 0.0338206, 0.0340021,
  0.0341807, 0.0343563, 0.0345288, 0.0346984, 0.0348648, 0.0350282,
  0.0351886, 0.0353458, 0.0355, 0.035651, 0.0357989, 0.0359436,
  0.0360852, 0.0362236, 0.0363589, 0.036491, 0.0366198, 0.0367455,
  0.0368679, 0.0369871, 0.0371031, 0.0372158, 0.0373252, 0.0374314,
  0.0375342, 0.0376338, 0.0377302, 0.0378231, 0.0379128, 0.0379992,
  0.0380822, 0.0381619, 0.0382383, 0.0383113, 0.0383809, 0.0384472,
  0.0385102, 0.0385697, 0.0386259, 0.0386787, 0.0387281, 0.0387741,
  0.0388168, 0.038856, 0.0388918, 0.0389243, 0.0389533, 0.0389789,
  0.0390011, 0.0390199, 0.0390353, 0.0390472, 0.0390558, 0.0390609,
  0.0390626, 0.0390609, 0.0390558, 0.0390472, 0.0390353, 0.0390199,
  0.0390011, 0.0389789, 0.0389533, 0.0389243, 0.0388918, 0.038856,
  0.0388168, 0.0387741, 0.0387281, 0.0386787, 0.0386259, 0.0385697,
  0.0385102, 0.0384472, 0.0383809, 0.0383113, 0.0382383, 0.0381619,
  0.0380822, 0.0379992, 0.0379128, 0.0378231, 0.0377302, 0.0376338,
  0.0375342, 0.0374314, 0.0373252, 0.0372158, 0.0371031, 0.0369871,
  0.0368679, 0.0367455, 0.0366198, 0.036491, 0.0363589, 0.0362236,
  0.0360852, 0.0359436, 0.0357989, 0.035651, 0.0355, 0.0353458,
  0.0351886, 0.0350282, 0.0348648, 0.0346984, 0.0345288, 0.0343563,
  0.0341807, 0.0340021, 0.0338206, 0.033636, 0.0334485, 0.0332581,
  0.0330647, 0.0328685, 0.0326693, 0.0324672, 0.0322623, 0.0320546,
  0.031844, 0.0316306, 0.0314145, 0.0311956, 0.0309739, 0.0307495,
  0.0305223, 0.0302925, 0.03006, 0.0298249, 0.0295871, 0.0293467,
  0.0291038, 0.0288582, 0.0286101, 0.0283595, 0.0281064, 0.0278507,
  0.0275927, 0.0273321, 0.0270692, 0.0268039, 0.0265361, 0.0262661,
  0.0259937, 0.025719, 0.025442, 0.0251628, 0.0248813, 0.0245977,
  0.0243118, 0.0240238, 0.0237337, 0.0234414, 0.0231471, 0.0228507,
  0.0225523, 0.0222518, 0.0219494, 0.021645, 0.0213388, 0.0210306,
  0.0207205, 0.0204086, 0.0200949, 0.0197793, 0.019462, 0.019143,
  0.0188223, 0.0184999, 0.0181758, 0.0178501, 0.0175228, 0.017194,
  0.0168636, 0.0165317, 0.0161983, 0.0158635, 0.0155272, 0.0151895,
  0.0148505, 0.0145102, 0.0141685, 0.0138256, 0.0134815, 0.0131361,
  0.0127895, 0.0124418, 0.012093, 0.0117431, 0.0113921, 0.0110401,
  0.0106871, 0.0103332, 0.00997831, 0.00962252, 0.00926586,
  0.00890837, 0.00855007, 0.008191, 0.00783119, 0.00747066,
  0.00710947, 0.00674762, 0.00638517, 0.00602214, 0.00565856,
  0.00529446, 0.00492989, 0.00456487, 0.00419943, 0.00383361,
  0.00346744, 0.00310096, 0.00273419, 0.00236718, 0.00199995,
  0.00163254, 0.00126497, 0.000897295, 0.000529535, 0.000161726,
  -0.000206097, -0.000573901, -0.000941653, -0.00130932, -0.00167686,
  -0.00204426, -0.00241146, -0.00277844, -0.00314517, -0.00351161,
  -0.00387772, -0.00424348, -0.00460885, -0.00497379, -0.00533827,
  -0.00570226, -0.00606573, -0.00642863, -0.00679094, -0.00715262,
  -0.00751364, -0.00787396, -0.00823356, -0.00859239, -0.00895042,
  -0.00930762, -0.00966396, -0.0100194, -0.0103739, -0.0107274,
  -0.01108, -0.0114315, -0.0117819, -0.0121313, -0.0124795,
  -0.0128265, -0.0131724, -0.013517, -0.0138603, -0.0142024,
  -0.0145431, -0.0148824, -0.0152204, -0.0155569, -0.015892,
  -0.0162255, -0.0165576, -0.0168881, -0.0172169, -0.0175442,
  -0.0178698, -0.0181937, -0.0185159, -0.0188363, -0.019155,
  -0.0194718, -0.0197868, -0.0200999, -0.0204111, -0.0207204,
  -0.0210277, -0.021333, -0.0216362, -0.0219374, -0.0222365,
  -0.0225335, -0.0228283, -0.0231209, -0.0234113, -0.0236995,
  -0.0239854, -0.024269, -0.0245503, -0.0248292, -0.0251057,
  -0.0253798, -0.0256515, -0.0259206, -0.0261873, -0.0264514,
  -0.026713, -0.026972, -0.0272284, -0.0274822, -0.0277332,
  -0.0279816, -0.0282273, -0.0284702, -0.0287104, -0.0289477,
  -0.0291822, -0.0294139, -0.0296427, -0.0298686, -0.0300916,
  -0.0303116, -0.0305286, -0.0307427, -0.0309537, -0.0311617,
  -0.0313666, -0.0315684, -0.0317672, -0.0319627, -0.0321551,
  -0.0323444, -0.0325304, -0.0327132, -0.0328928, -0.0330691,
  -0.0332421, -0.0334118, -0.0335781, -0.0337412, -0.0339008,
  -0.0340571, -0.0342099, -0.0343594, -0.0345054, -0.0346479,
  -0.0347869, -0.0349225, -0.0350545, -0.035183, -0.035308,
  -0.0354294, -0.0355472, -0.0356614, -0.035772, -0.035879,
  -0.0359823, -0.036082, -0.036178, -0.0362704, -0.036359, -0.0364439,
  -0.0365251, -0.0366026, -0.0366763, -0.0367463, -0.0368124,
  -0.0368748, -0.0369335, -0.0369883, -0.0370393, -0.0370864,
  -0.0371298, -0.0371693, -0.0372049, -0.0372367, -0.0372647,
  -0.0372887, -0.0373089, -0.0373252, -0.0373376, -0.0373461,
  -0.0373507, -0.0373514, -0.0373482, -0.037341, -0.03733, -0.037315,
  -0.037296, -0.0372732, -0.0372464, -0.0372157, -0.037181,
  -0.0371424, -0.0370999, -0.0370534, -0.0370029, -0.0369486,
  -0.0368903, -0.036828, -0.0367618, -0.0366917, -0.0366176,
  -0.0365396, -0.0364577, -0.0363719, -0.0362821, -0.0361884,
  -0.0360908, -0.0359894, -0.035884, -0.0357747, -0.0356615,
  -0.0355444, -0.0354235, -0.0352987, -0.0351701, -0.0350376,
  -0.0349012, -0.0347611, -0.0346171, -0.0344693, -0.0343177,
  -0.0341623, -0.0340032, -0.0338403, -0.0336736, -0.0335032,
  -0.0333291, -0.0331512, -0.0329697, -0.0327845, -0.0325956,
  -0.0324031, -0.0322069, -0.0320072, -0.0318038, -0.0315968,
  -0.0313863, -0.0311722, -0.0309546, -0.0307335, -0.0305089,
  -0.0302808, -0.0300493, -0.0298144, -0.029576, -0.0293343,
  -0.0290892, -0.0288408, -0.028589, -0.028334, -0.0280757,
  -0.0278141, -0.0275494, -0.0272814, -0.0270103, -0.026736,
  -0.0264586, -0.0261782, -0.0258946, -0.0256081, -0.0253185,
  -0.025026, -0.0247305, -0.0244321, -0.0241308, -0.0238267,
  -0.0235197, -0.02321, -0.0228975, -0.0225822, -0.0222643,
  -0.0219437, -0.0216205, -0.0212947, -0.0209663, -0.0206355,
  -0.0203021, -0.0199663, -0.019628, -0.0192874, -0.0189444,
  -0.0185991, -0.0182516, -0.0179018, -0.0175499, -0.0171958,
  -0.0168395, -0.0164812, -0.0161209, -0.0157586, -0.0153943,
  -0.0150282, -0.0146601, -0.0142902, -0.0139186, -0.0135452,
  -0.0131701, -0.0127934, -0.012415, -0.0120351, -0.0116537,
  -0.0112708, -0.0108865, -0.0105007, -0.0101137, -0.00972536,
  -0.00933578, -0.00894501, -0.00855309, -0.00816006, -0.00776599,
  -0.00737092, -0.00697489, -0.00657796, -0.00618017, -0.00578158,
  -0.00538224, -0.00498219, -0.00458149, -0.00418018, -0.00377833,
  -0.00337598, -0.00297318, -0.00256999, -0.00216646, -0.00176264,
  -0.00135859, -0.000954352, -0.000549988, -0.00014555, 0.000258907,
  0.00066333, 0.00106766, 0.00147185, 0.00187584, 0.00227957,
  0.00268299, 0.00308605, 0.00348868, 0.00389084, 0.00429245,
  0.00469348, 0.00509385, 0.00549352, 0.00589243, 0.00629051,
  0.00668772, 0.00708399, 0.00747926, 0.00787349, 0.0082666,
  0.00865854, 0.00904926, 0.00943868, 0.00982677, 0.0102134,
  0.0105987, 0.0109824, 0.0113645, 0.0117449, 0.0121237, 0.0125007,
  0.0128759, 0.0132493, 0.0136206, 0.01399, 0.0143573, 0.0147226,
  0.0150856, 0.0154464, 0.0158049, 0.016161, 0.0165148, 0.016866,
  0.0172148, 0.0175609, 0.0179044, 0.0182451, 0.0185831, 0.0189183,
  0.0192506, 0.0195799, 0.0199062, 0.0202295, 0.0205496, 0.0208665,
  0.0211802, 0.0214906, 0.0217976, 0.0221012, 0.0224013, 0.0226979,
  0.0229909, 0.0232803, 0.0235659, 0.0238478, 0.0241258, 0.0244,
  0.0246702, 0.0249365, 0.0251987, 0.0254568, 0.0257108, 0.0259605,
  0.026206, 0.0264471, 0.0266839, 0.0269162, 0.0271441, 0.0273674,
  0.0275862, 0.0278003, 0.0280097, 0.0282144, 0.0284143, 0.0286093,
  0.0287995, 0.0289847, 0.0291649, 0.0293401, 0.0295102, 0.0296752,
  0.029835, 0.0299895, 0.0301388, 0.0302828, 0.0304214, 0.0305546,
  0.0306824, 0.0308046, 0.0309213, 0.0310325, 0.031138, 0.0312379,
  0.0313321, 0.0314205, 0.0315032, 0.03158, 0.031651, 0.0317162,
  0.0317754, 0.0318286, 0.0318759, 0.0319171, 0.0319524, 0.0319815,
  0.0320045, 0.0320214, 0.0320321, 0.0320366, 0.0320348, 0.0320269,
  0.0320127, 0.0319921, 0.0319653, 0.0319321, 0.0318925, 0.0318466,
  0.0317943, 0.0317356, 0.0316704, 0.0315988, 0.0315207, 0.0314362,
  0.0313452, 0.0312477, 0.0311437, 0.0310331, 0.0309161, 0.0307925,
  0.0306624, 0.0305258, 0.0303827, 0.030233, 0.0300768, 0.0299141,
  0.0297448, 0.029569, 0.0293868, 0.029198, 0.0290027, 0.0288009,
  0.0285927, 0.028378, 0.0281569, 0.0279294, 0.0276955, 0.0274552,
  0.0272085, 0.0269555, 0.0266962, 0.0264306, 0.0261587, 0.0258807,
  0.0255964, 0.025306, 0.0250095, 0.0247069, 0.0243983, 0.0240836,
  0.0237631, 0.0234366, 0.0231042, 0.0227661, 0.0224221, 0.0220725,
  0.0217172, 0.0213564, 0.02099, 0.0206181, 0.0202408, 0.0198582,
  0.0194703, 0.0190773, 0.018679, 0.0182758, 0.0178675, 0.0174544,
  0.0170365, 0.0166138, 0.0161865, 0.0157546, 0.0153183, 0.0148776,
  0.0144326, 0.0139835, 0.0135303, 0.0130731, 0.0126121, 0.0121473,
  0.0116789, 0.011207, 0.0107316, 0.010253, 0.00977125, 0.00928644,
  0.00879872, 0.00830822, 0.00781509, 0.00731946, 0.00682146,
  0.00632124, 0.00581896, 0.00531474, 0.00480876, 0.00430116,
  0.00379211, 0.00328176, 0.00277028, 0.00225783, 0.0017446,
  0.00123075, 0.000716456, 0.000201908, -0.000312713, -0.000827218,
  -0.00134142, -0.00185512, -0.00236812, -0.00288021, -0.0033912,
  -0.00390088, -0.00440903, -0.00491543, -0.00541987, -0.00592212,
  -0.00642195, -0.00691914, -0.00741345, -0.00790463, -0.00839246,
  -0.00887667, -0.00935702, -0.00983326, -0.0103051, -0.0107723,
  -0.0112347, -0.0116918, -0.0121435, -0.0125895, -0.0130295,
  -0.0134631, -0.0138902, -0.0143104, -0.0147233, -0.0151288,
  -0.0155265, -0.0159161, -0.0162972, -0.0166696, -0.0170329,
  -0.0173867, -0.0177308, -0.0180648, -0.0183884, -0.0187012,
  -0.0190028, -0.0192928, -0.019571, -0.019837, -0.0200903,
  -0.0203306, -0.0205575, -0.0207706, -0.0209695, -0.0211539,
  -0.0213232, -0.0214771, -0.0216152, -0.0217371, -0.0218423,
  -0.0219303, -0.0220008, -0.0220534, -0.0220874, -0.0221026,
  -0.0220984, -0.0220744, -0.02203, -0.0219649, -0.0218785,
  -0.0217704, -0.02164, -0.0214868, -0.0213104, -0.0211102,
  -0.0208856, -0.0206363, -0.0203615, -0.0200609, -0.0197338,
  -0.0193797, -0.0189981, -0.0185883, -0.0181498, -0.0176821,
  -0.0171845, -0.0166564, -0.0160973, -0.0155065, -0.0148834,
  -0.0142275, -0.013538, -0.0128144, -0.0120561, -0.0112623,
  -0.0104324, -0.00956573, -0.00866169, -0.00771956, -0.00673866,
  -0.0057183, -0.00465779, -0.00355642, -0.00241348, -0.00122825,
  6.94974e-17}; G4double G4NeutronHPFastLegendre::l8[1801] = {1,
  0.960387, 0.921543, 0.883457, 0.846122, 0.809526, 0.773662, 0.73852,
  0.704091, 0.670366, 0.637337, 0.604994, 0.57333, 0.542334, 0.512,
  0.482317, 0.453278, 0.424875, 0.397099, 0.369943, 0.343397,
  0.317454, 0.292106, 0.267345, 0.243163, 0.219553, 0.196506,
  0.174015, 0.152073, 0.130672, 0.109805, 0.0894638, 0.0696416,
  0.0503311, 0.0315252, 0.0132167, -0.00460131, -0.0219359,
  -0.0387939, -0.0551822, -0.0711076, -0.0865768, -0.101596,
  -0.116173, -0.130313, -0.144023, -0.15731, -0.17018, -0.182638,
  -0.194692, -0.206347, -0.21761, -0.228487, -0.238983, -0.249105,
  -0.258858, -0.268248, -0.277282, -0.285964, -0.294301, -0.302297,
  -0.30996, -0.317293, -0.324302, -0.330994, -0.337373, -0.343444,
  -0.349212, -0.354684, -0.359864, -0.364756, -0.369367, -0.3737,
  -0.377761, -0.381556, -0.385087, -0.388361, -0.391382, -0.394155,
  -0.396684, -0.398973, -0.401028, -0.402853, -0.404452, -0.40583,
  -0.406991, -0.407939, -0.408678, -0.409213, -0.409547, -0.409686,
  -0.409632, -0.409391, -0.408965, -0.408359, -0.407576, -0.406621,
  -0.405497, -0.404208, -0.402758, -0.401151, -0.399389, -0.397477,
  -0.395417, -0.393215, -0.390872, -0.388393, -0.38578, -0.383038,
  -0.380169, -0.377177, -0.374064, -0.370835, -0.367492, -0.364038,
  -0.360476, -0.35681, -0.353042, -0.349175, -0.345213, -0.341157,
  -0.337012, -0.332779, -0.328461, -0.324062, -0.319584, -0.315029,
  -0.3104, -0.3057, -0.300932, -0.296097, -0.291199, -0.286239,
  -0.281221, -0.276146, -0.271017, -0.265836, -0.260606, -0.255329,
  -0.250007, -0.244642, -0.239236, -0.233792, -0.228312, -0.222797,
  -0.217251, -0.211674, -0.206069, -0.200437, -0.194782, -0.189104,
  -0.183405, -0.177688, -0.171954, -0.166204, -0.160442, -0.154668,
  -0.148884, -0.143091, -0.137292, -0.131489, -0.125682, -0.119873,
  -0.114064, -0.108256, -0.102451, -0.0966501, -0.0908551, -0.0850672,
  -0.0792879, -0.0735186, -0.0677604, -0.0620149, -0.0562833,
  -0.0505668, -0.0448668, -0.0391844, -0.0335209, -0.0278774,
  -0.0222552, -0.0166553, -0.0110789, -0.00552709, -9.39012e-07,
  0.0054985, 0.0109702, 0.0164131, 0.0218263, 0.0272087, 0.0325595,
  0.0378777, 0.0431623, 0.0484125, 0.0536274, 0.0588062, 0.063948,
  0.069052, 0.0741175, 0.0791436, 0.0841295, 0.0890746, 0.0939781,
  0.0988393, 0.103658, 0.108432, 0.113162, 0.117848, 0.122488,
  0.127081, 0.131628, 0.136128, 0.14058, 0.144983, 0.149338, 0.153643,
  0.157898, 0.162103, 0.166257, 0.170359, 0.17441, 0.178409, 0.182356,
  0.186249, 0.19009, 0.193877, 0.197609, 0.201288, 0.204912, 0.208481,
  0.211995, 0.215453, 0.218856, 0.222203, 0.225494, 0.228728,
  0.231906, 0.235027, 0.23809, 0.241097, 0.244047, 0.246939, 0.249773,
  0.25255, 0.255269, 0.25793, 0.260533, 0.263078, 0.265565, 0.267993,
  0.270364, 0.272676, 0.274929, 0.277125, 0.279262, 0.281341,
  0.283361, 0.285323, 0.287227, 0.289072, 0.29086, 0.292589, 0.29426,
  0.295873, 0.297429, 0.298926, 0.300366, 0.301748, 0.303073,
  0.304341, 0.305551, 0.306704, 0.307801, 0.30884, 0.309824, 0.31075,
  0.311621, 0.312435, 0.313194, 0.313897, 0.314545, 0.315138,
  0.315675, 0.316158, 0.316586, 0.31696, 0.317281, 0.317547, 0.31776,
  0.31792, 0.318026, 0.31808, 0.318082, 0.318032, 0.317929, 0.317776,
  0.317571, 0.317315, 0.317009, 0.316652, 0.316246, 0.31579, 0.315285,
  0.314731, 0.314128, 0.313477, 0.312778, 0.312032, 0.311239,
  0.310398, 0.309512, 0.308579, 0.307601, 0.306577, 0.305509,
  0.304396, 0.303239, 0.302038, 0.300794, 0.299506, 0.298177,
  0.296805, 0.295392, 0.293937, 0.292441, 0.290905, 0.289329,
  0.287713, 0.286058, 0.284365, 0.282632, 0.280862, 0.279055, 0.27721,
  0.275329, 0.273412, 0.271459, 0.26947, 0.267447, 0.26539, 0.263298,
  0.261173, 0.259015, 0.256824, 0.254601, 0.252347, 0.250061,
  0.247745, 0.245398, 0.243021, 0.240615, 0.23818, 0.235716, 0.233225,
  0.230706, 0.22816, 0.225587, 0.222988, 0.220363, 0.217713, 0.215038,
  0.212339, 0.209616, 0.20687, 0.204101, 0.201309, 0.198496, 0.195661,
  0.192804, 0.189928, 0.187031, 0.184114, 0.181178, 0.178224,
  0.175251, 0.172261, 0.169253, 0.166228, 0.163187, 0.16013, 0.157057,
  0.15397, 0.150867, 0.147751, 0.144621, 0.141478, 0.138322, 0.135154,
  0.131973, 0.128782, 0.125579, 0.122367, 0.119143, 0.115911,
  0.112669, 0.109419, 0.10616, 0.102893, 0.0996191, 0.0963381,
  0.0930506, 0.089757, 0.0864578, 0.0831533, 0.079844, 0.0765304,
  0.0732129, 0.0698918, 0.0665676, 0.0632408, 0.0599117, 0.0565808,
  0.0532484, 0.0499151, 0.0465811, 0.043247, 0.0399131, 0.0365798,
  0.0332476, 0.0299168, 0.0265878, 0.023261, 0.0199368, 0.0166157,
  0.013298, 0.009984, 0.00667422, 0.00336899, 6.86935e-05,
  -0.00322629, -0.00651558, -0.00979881, -0.0130756, -0.0163456,
  -0.0196085, -0.0228638, -0.0261112, -0.0293504, -0.0325809,
  -0.0358026, -0.0390149, -0.0422175, -0.0454102, -0.0485925,
  -0.0517642, -0.0549248, -0.0580741, -0.0612118, -0.0643374,
  -0.0674506, -0.0705513, -0.0736389, -0.0767133, -0.079774,
  -0.0828209, -0.0858535, -0.0888715, -0.0918748, -0.0948629,
  -0.0978356, -0.100793, -0.103733, -0.106658, -0.109566, -0.112457,
  -0.115331, -0.118188, -0.121027, -0.123848, -0.12665, -0.129435,
  -0.1322, -0.134946, -0.137674, -0.140381, -0.143069, -0.145737,
  -0.148384, -0.151012, -0.153618, -0.156203, -0.158767, -0.16131,
  -0.163831, -0.16633, -0.168808, -0.171262, -0.173695, -0.176104,
  -0.178491, -0.180854, -0.183195, -0.185511, -0.187804, -0.190073,
  -0.192318, -0.194539, -0.196735, -0.198907, -0.201054, -0.203175,
  -0.205272, -0.207344, -0.20939, -0.21141, -0.213404, -0.215373,
  -0.217316, -0.219232, -0.221122, -0.222985, -0.224822, -0.226632,
  -0.228415, -0.230171, -0.2319, -0.233602, -0.235277, -0.236923,
  -0.238543, -0.240134, -0.241698, -0.243234, -0.244742, -0.246221,
  -0.247673, -0.249096, -0.250491, -0.251857, -0.253195, -0.254504,
  -0.255785, -0.257037, -0.25826, -0.259454, -0.260619, -0.261755,
  -0.262862, -0.26394, -0.264989, -0.266009, -0.266999, -0.26796,
  -0.268892, -0.269795, -0.270668, -0.271511, -0.272325, -0.27311,
  -0.273865, -0.274591, -0.275287, -0.275954, -0.276591, -0.277199,
  -0.277777, -0.278326, -0.278845, -0.279334, -0.279794, -0.280225,
  -0.280625, -0.280997, -0.281339, -0.281652, -0.281935, -0.282189,
  -0.282413, -0.282608, -0.282774, -0.282911, -0.283018, -0.283097,
  -0.283146, -0.283166, -0.283157, -0.283119, -0.283053, -0.282957,
  -0.282833, -0.28268, -0.282498, -0.282288, -0.282049, -0.281782,
  -0.281487, -0.281163, -0.280811, -0.280431, -0.280023, -0.279587,
  -0.279123, -0.278632, -0.278113, -0.277566, -0.276992, -0.27639,
  -0.275762, -0.275106, -0.274423, -0.273713, -0.272977, -0.272213,
  -0.271424, -0.270608, -0.269765, -0.268896, -0.268002, -0.267081,
  -0.266134, -0.265162, -0.264165, -0.263142, -0.262093, -0.26102,
  -0.259921, -0.258798, -0.25765, -0.256478, -0.255281, -0.25406,
  -0.252815, -0.251546, -0.250253, -0.248937, -0.247597, -0.246234,
  -0.244847, -0.243438, -0.242006, -0.240552, -0.239075, -0.237575,
  -0.236054, -0.234511, -0.232946, -0.231359, -0.229751, -0.228122,
  -0.226472, -0.224801, -0.223109, -0.221397, -0.219665, -0.217913,
  -0.216141, -0.214349, -0.212537, -0.210707, -0.208857, -0.206988,
  -0.205101, -0.203195, -0.201271, -0.199329, -0.197369, -0.195391,
  -0.193396, -0.191384, -0.189354, -0.187308, -0.185245, -0.183165,
  -0.18107, -0.178958, -0.176831, -0.174688, -0.17253, -0.170357,
  -0.168169, -0.165966, -0.163749, -0.161518, -0.159272, -0.157013,
  -0.15474, -0.152454, -0.150155, -0.147843, -0.145518, -0.143181,
  -0.140832, -0.13847, -0.136098, -0.133713, -0.131317, -0.128911,
  -0.126493, -0.124065, -0.121627, -0.119178, -0.11672, -0.114252,
  -0.111774, -0.109288, -0.106792, -0.104288, -0.101776, -0.0992549,
  -0.0967262, -0.0941897, -0.0916458, -0.0890946, -0.0865365,
  -0.0839715, -0.0814, -0.0788223, -0.0762385, -0.0736488, -0.0710537,
  -0.0684532, -0.0658476, -0.0632371, -0.0606221, -0.0580027,
  -0.0553791, -0.0527517, -0.0501206, -0.0474862, -0.0448486,
  -0.042208, -0.0395648, -0.0369191, -0.0342713, -0.0316215,
  -0.0289699, -0.0263169, -0.0236627, -0.0210074, -0.0183514,
  -0.0156949, -0.013038, -0.0103812, -0.00772449, -0.00506824,
  -0.00241267, 0.000242005, 0.00289554, 0.00554769, 0.00819823,
  0.0108469, 0.0134935, 0.0161378, 0.0187796, 0.0214185, 0.0240544,
  0.0266871, 0.0293163, 0.0319418, 0.0345634, 0.0371807, 0.0397937,
  0.042402, 0.0450055, 0.0476039, 0.050197, 0.0527845, 0.0553663,
  0.057942, 0.0605116, 0.0630747, 0.0656311, 0.0681807, 0.0707232,
  0.0732583, 0.0757859, 0.0783058, 0.0808176, 0.0833213, 0.0858165,
  0.0883032, 0.090781, 0.0932497, 0.0957092, 0.0981592, 0.100599,
  0.10303, 0.10545, 0.10786, 0.11026, 0.112649, 0.115026, 0.117393,
  0.119748, 0.122092, 0.124425, 0.126745, 0.129053, 0.131349,
  0.133632, 0.135902, 0.13816, 0.140405, 0.142636, 0.144854, 0.147058,
  0.149248, 0.151425, 0.153587, 0.155735, 0.157868, 0.159986, 0.16209,
  0.164178, 0.166251, 0.168309, 0.170351, 0.172377, 0.174387,
  0.176382, 0.178359, 0.180321, 0.182265, 0.184193, 0.186104,
  0.187998, 0.189875, 0.191734, 0.193576, 0.1954, 0.197206, 0.198994,
  0.200763, 0.202515, 0.204248, 0.205962, 0.207658, 0.209334,
  0.210992, 0.212631, 0.21425, 0.215849, 0.21743, 0.21899, 0.220531,
  0.222051, 0.223552, 0.225032, 0.226492, 0.227932, 0.22935, 0.230749,
  0.232126, 0.233483, 0.234818, 0.236132, 0.237426, 0.238697,
  0.239948, 0.241176, 0.242383, 0.243569, 0.244732, 0.245873,
  0.246993, 0.24809, 0.249165, 0.250218, 0.251248, 0.252256, 0.253241,
  0.254204, 0.255143, 0.25606, 0.256955, 0.257826, 0.258674, 0.259499,
  0.260301, 0.261079, 0.261835, 0.262567, 0.263275, 0.26396, 0.264622,
  0.26526, 0.265874, 0.266465, 0.267032, 0.267575, 0.268094, 0.26859,
  0.269061, 0.269509, 0.269932, 0.270332, 0.270707, 0.271059,
  0.271386, 0.271689, 0.271968, 0.272223, 0.272454, 0.27266, 0.272842,
  0.273, 0.273134, 0.273243, 0.273328, 0.273389, 0.273425, 0.273438,
  0.273425, 0.273389, 0.273328, 0.273243, 0.273134, 0.273, 0.272842,
  0.27266, 0.272454, 0.272223, 0.271968, 0.271689, 0.271386, 0.271059,
  0.270707, 0.270332, 0.269932, 0.269509, 0.269061, 0.26859, 0.268094,
  0.267575, 0.267032, 0.266465, 0.265874, 0.26526, 0.264622, 0.26396,
  0.263275, 0.262567, 0.261835, 0.261079, 0.260301, 0.259499,
  0.258674, 0.257826, 0.256955, 0.25606, 0.255143, 0.254204, 0.253241,
  0.252256, 0.251248, 0.250218, 0.249165, 0.24809, 0.246993, 0.245873,
  0.244732, 0.243569, 0.242383, 0.241176, 0.239948, 0.238697,
  0.237426, 0.236132, 0.234818, 0.233483, 0.232126, 0.230749, 0.22935,
  0.227932, 0.226492, 0.225032, 0.223552, 0.222051, 0.220531, 0.21899,
  0.21743, 0.215849, 0.21425, 0.212631, 0.210992, 0.209334, 0.207658,
  0.205962, 0.204248, 0.202515, 0.200763, 0.198994, 0.197206, 0.1954,
  0.193576, 0.191734, 0.189875, 0.187998, 0.186104, 0.184193,
  0.182265, 0.180321, 0.178359, 0.176382, 0.174387, 0.172377,
  0.170351, 0.168309, 0.166251, 0.164178, 0.16209, 0.159986, 0.157868,
  0.155735, 0.153587, 0.151425, 0.149248, 0.147058, 0.144854,
  0.142636, 0.140405, 0.13816, 0.135902, 0.133632, 0.131349, 0.129053,
  0.126745, 0.124425, 0.122092, 0.119748, 0.117393, 0.115026,
  0.112649, 0.11026, 0.10786, 0.10545, 0.10303, 0.100599, 0.0981592,
  0.0957092, 0.0932497, 0.090781, 0.0883032, 0.0858165, 0.0833213,
  0.0808176, 0.0783058, 0.0757859, 0.0732583, 0.0707232, 0.0681807,
  0.0656311, 0.0630747, 0.0605116, 0.057942, 0.0553663, 0.0527845,
  0.050197, 0.0476039, 0.0450055, 0.042402, 0.0397937, 0.0371807,
  0.0345634, 0.0319418, 0.0293163, 0.0266871, 0.0240544, 0.0214185,
  0.0187796, 0.0161378, 0.0134935, 0.0108469, 0.00819823, 0.00554769,
  0.00289554, 0.000242005, -0.00241267, -0.00506824, -0.00772449,
  -0.0103812, -0.013038, -0.0156949, -0.0183514, -0.0210074,
  -0.0236627, -0.0263169, -0.0289699, -0.0316215, -0.0342713,
  -0.0369191, -0.0395648, -0.042208, -0.0448486, -0.0474862,
  -0.0501206, -0.0527517, -0.0553791, -0.0580027, -0.0606221,
  -0.0632371, -0.0658476, -0.0684532, -0.0710537, -0.0736488,
  -0.0762385, -0.0788223, -0.0814, -0.0839715, -0.0865365, -0.0890946,
  -0.0916458, -0.0941897, -0.0967262, -0.0992549, -0.101776,
  -0.104288, -0.106792, -0.109288, -0.111774, -0.114252, -0.11672,
  -0.119178, -0.121627, -0.124065, -0.126493, -0.128911, -0.131317,
  -0.133713, -0.136098, -0.13847, -0.140832, -0.143181, -0.145518,
  -0.147843, -0.150155, -0.152454, -0.15474, -0.157013, -0.159272,
  -0.161518, -0.163749, -0.165966, -0.168169, -0.170357, -0.17253,
  -0.174688, -0.176831, -0.178958, -0.18107, -0.183165, -0.185245,
  -0.187308, -0.189354, -0.191384, -0.193396, -0.195391, -0.197369,
  -0.199329, -0.201271, -0.203195, -0.205101, -0.206988, -0.208857,
  -0.210707, -0.212537, -0.214349, -0.216141, -0.217913, -0.219665,
  -0.221397, -0.223109, -0.224801, -0.226472, -0.228122, -0.229751,
  -0.231359, -0.232946, -0.234511, -0.236054, -0.237575, -0.239075,
  -0.240552, -0.242006, -0.243438, -0.244847, -0.246234, -0.247597,
  -0.248937, -0.250253, -0.251546, -0.252815, -0.25406, -0.255281,
  -0.256478, -0.25765, -0.258798, -0.259921, -0.26102, -0.262093,
  -0.263142, -0.264165, -0.265162, -0.266134, -0.267081, -0.268002,
  -0.268896, -0.269765, -0.270608, -0.271424, -0.272213, -0.272977,
  -0.273713, -0.274423, -0.275106, -0.275762, -0.27639, -0.276992,
  -0.277566, -0.278113, -0.278632, -0.279123, -0.279587, -0.280023,
  -0.280431, -0.280811, -0.281163, -0.281487, -0.281782, -0.282049,
  -0.282288, -0.282498, -0.28268, -0.282833, -0.282957, -0.283053,
  -0.283119, -0.283157, -0.283166, -0.283146, -0.283097, -0.283018,
  -0.282911, -0.282774, -0.282608, -0.282413, -0.282189, -0.281935,
  -0.281652, -0.281339, -0.280997, -0.280625, -0.280225, -0.279794,
  -0.279334, -0.278845, -0.278326, -0.277777, -0.277199, -0.276591,
  -0.275954, -0.275287, -0.274591, -0.273865, -0.27311, -0.272325,
  -0.271511, -0.270668, -0.269795, -0.268892, -0.26796, -0.266999,
  -0.266009, -0.264989, -0.26394, -0.262862, -0.261755, -0.260619,
  -0.259454, -0.25826, -0.257037, -0.255785, -0.254504, -0.253195,
  -0.251857, -0.250491, -0.249096, -0.247673, -0.246221, -0.244742,
  -0.243234, -0.241698, -0.240134, -0.238543, -0.236923, -0.235277,
  -0.233602, -0.2319, -0.230171, -0.228415, -0.226632, -0.224822,
  -0.222985, -0.221122, -0.219232, -0.217316, -0.215373, -0.213404,
  -0.21141, -0.20939, -0.207344, -0.205272, -0.203175, -0.201054,
  -0.198907, -0.196735, -0.194539, -0.192318, -0.190073, -0.187804,
  -0.185511, -0.183195, -0.180854, -0.178491, -0.176104, -0.173695,
  -0.171262, -0.168808, -0.16633, -0.163831, -0.16131, -0.158767,
  -0.156203, -0.153618, -0.151012, -0.148384, -0.145737, -0.143069,
  -0.140381, -0.137674, -0.134946, -0.1322, -0.129435, -0.12665,
  -0.123848, -0.121027, -0.118188, -0.115331, -0.112457, -0.109566,
  -0.106658, -0.103733, -0.100793, -0.0978356, -0.0948629, -0.0918748,
  -0.0888715, -0.0858535, -0.0828209, -0.079774, -0.0767133,
  -0.0736389, -0.0705513, -0.0674506, -0.0643374, -0.0612118,
  -0.0580741, -0.0549248, -0.0517642, -0.0485925, -0.0454102,
  -0.0422175, -0.0390149, -0.0358026, -0.0325809, -0.0293504,
  -0.0261112, -0.0228638, -0.0196085, -0.0163456, -0.0130756,
  -0.00979881, -0.00651558, -0.00322629, 6.86935e-05, 0.00336899,
  0.00667422, 0.009984, 0.013298, 0.0166157, 0.0199368, 0.023261,
  0.0265878, 0.0299168, 0.0332476, 0.0365798, 0.0399131, 0.043247,
  0.0465811, 0.0499151, 0.0532484, 0.0565808, 0.0599117, 0.0632408,
  0.0665676, 0.0698918, 0.0732129, 0.0765304, 0.079844, 0.0831533,
  0.0864578, 0.089757, 0.0930506, 0.0963381, 0.0996191, 0.102893,
  0.10616, 0.109419, 0.112669, 0.115911, 0.119143, 0.122367, 0.125579,
  0.128782, 0.131973, 0.135154, 0.138322, 0.141478, 0.144621,
  0.147751, 0.150867, 0.15397, 0.157057, 0.16013, 0.163187, 0.166228,
  0.169253, 0.172261, 0.175251, 0.178224, 0.181178, 0.184114,
  0.187031, 0.189928, 0.192804, 0.195661, 0.198496, 0.201309,
  0.204101, 0.20687, 0.209616, 0.212339, 0.215038, 0.217713, 0.220363,
  0.222988, 0.225587, 0.22816, 0.230706, 0.233225, 0.235716, 0.23818,
  0.240615, 0.243021, 0.245398, 0.247745, 0.250061, 0.252347,
  0.254601, 0.256824, 0.259015, 0.261173, 0.263298, 0.26539, 0.267447,
  0.26947, 0.271459, 0.273412, 0.275329, 0.27721, 0.279055, 0.280862,
  0.282632, 0.284365, 0.286058, 0.287713, 0.289329, 0.290905,
  0.292441, 0.293937, 0.295392, 0.296805, 0.298177, 0.299506,
  0.300794, 0.302038, 0.303239, 0.304396, 0.305509, 0.306577,
  0.307601, 0.308579, 0.309512, 0.310398, 0.311239, 0.312032,
  0.312778, 0.313477, 0.314128, 0.314731, 0.315285, 0.31579, 0.316246,
  0.316652, 0.317009, 0.317315, 0.317571, 0.317776, 0.317929,
  0.318032, 0.318082, 0.31808, 0.318026, 0.31792, 0.31776, 0.317547,
  0.317281, 0.31696, 0.316586, 0.316158, 0.315675, 0.315138, 0.314545,
  0.313897, 0.313194, 0.312435, 0.311621, 0.31075, 0.309824, 0.30884,
  0.307801, 0.306704, 0.305551, 0.304341, 0.303073, 0.301748,
  0.300366, 0.298926, 0.297429, 0.295873, 0.29426, 0.292589, 0.29086,
  0.289072, 0.287227, 0.285323, 0.283361, 0.281341, 0.279262,
  0.277125, 0.274929, 0.272676, 0.270364, 0.267993, 0.265565,
  0.263078, 0.260533, 0.25793, 0.255269, 0.25255, 0.249773, 0.246939,
  0.244047, 0.241097, 0.23809, 0.235027, 0.231906, 0.228728, 0.225494,
  0.222203, 0.218856, 0.215453, 0.211995, 0.208481, 0.204912,
  0.201288, 0.197609, 0.193877, 0.19009, 0.186249, 0.182356, 0.178409,
  0.17441, 0.170359, 0.166257, 0.162103, 0.157898, 0.153643, 0.149338,
  0.144983, 0.14058, 0.136128, 0.131628, 0.127081, 0.122488, 0.117848,
  0.113162, 0.108432, 0.103658, 0.0988393, 0.0939781, 0.0890746,
  0.0841295, 0.0791436, 0.0741175, 0.069052, 0.063948, 0.0588062,
  0.0536274, 0.0484125, 0.0431623, 0.0378777, 0.0325595, 0.0272087,
  0.0218263, 0.0164131, 0.0109702, 0.0054985, -9.39012e-07,
  -0.00552709, -0.0110789, -0.0166553, -0.0222552, -0.0278774,
  -0.0335209, -0.0391844, -0.0448668, -0.0505668, -0.0562833,
  -0.0620149, -0.0677604, -0.0735186, -0.0792879, -0.0850672,
  -0.0908551, -0.0966501, -0.102451, -0.108256, -0.114064, -0.119873,
  -0.125682, -0.131489, -0.137292, -0.143091, -0.148884, -0.154668,
  -0.160442, -0.166204, -0.171954, -0.177688, -0.183405, -0.189104,
  -0.194782, -0.200437, -0.206069, -0.211674, -0.217251, -0.222797,
  -0.228312, -0.233792, -0.239236, -0.244642, -0.250007, -0.255329,
  -0.260606, -0.265836, -0.271017, -0.276146, -0.281221, -0.286239,
  -0.291199, -0.296097, -0.300932, -0.3057, -0.3104, -0.315029,
  -0.319584, -0.324062, -0.328461, -0.332779, -0.337012, -0.341157,
  -0.345213, -0.349175, -0.353042, -0.35681, -0.360476, -0.364038,
  -0.367492, -0.370835, -0.374064, -0.377177, -0.380169, -0.383038,
  -0.38578, -0.388393, -0.390872, -0.393215, -0.395417, -0.397477,
  -0.399389, -0.401151, -0.402758, -0.404208, -0.405497, -0.406621,
  -0.407576, -0.408359, -0.408965, -0.409391, -0.409632, -0.409686,
  -0.409547, -0.409213, -0.408678, -0.407939, -0.406991, -0.40583,
  -0.404452, -0.402853, -0.401028, -0.398973, -0.396684, -0.394155,
  -0.391382, -0.388361, -0.385087, -0.381556, -0.377761, -0.3737,
  -0.369367, -0.364756, -0.359864, -0.354684, -0.349212, -0.343444,
  -0.337373, -0.330994, -0.324302, -0.317293, -0.30996, -0.302297,
  -0.294301, -0.285964, -0.277282, -0.268248, -0.258858, -0.249105,
  -0.238983, -0.228487, -0.21761, -0.206347, -0.194692, -0.182638,
  -0.17018, -0.15731, -0.144023, -0.130313, -0.116173, -0.101596,
  -0.0865768, -0.0711076, -0.0551822, -0.0387939, -0.0219359,
  -0.00460131, 0.0132167, 0.0315252, 0.0503311, 0.0696416, 0.0894638,
  0.109805, 0.130672, 0.152073, 0.174015, 0.196506, 0.219553,
  0.243163, 0.267345, 0.292106, 0.317454, 0.343397, 0.369943,
  0.397099, 0.424875, 0.453278, 0.482317, 0.512, 0.542334, 0.57333,
  0.604994, 0.637337, 0.670366, 0.704091, 0.73852, 0.773662, 0.809526,
  0.846122, 0.883457, 0.921543, 0.960387, 1}; G4double
  G4NeutronHPFastLegendre::i8[1801] = {0, 0.00108903, 0.00213447,
  0.00313718, 0.00409799, 0.00501772, 0.0058972, 0.00673723,
  0.00753862, 0.00830214, 0.00902857, 0.00971869, 0.0103733, 0.010993,
  0.0115787, 0.012131, 0.0126507, 0.0131385, 0.0135951, 0.0140212,
  0.0144174, 0.0147845, 0.0151231, 0.0154339, 0.0157174, 0.0159744,
  0.0162055, 0.0164113, 0.0165924, 0.0167495, 0.016883, 0.0169937,
  0.017082, 0.0171486, 0.017194, 0.0172188, 0.0172236, 0.0172088,
  0.017175, 0.0171228, 0.0170525, 0.0169649, 0.0168603, 0.0167393,
  0.0166023, 0.0164499, 0.0162824, 0.0161004, 0.0159044, 0.0156947,
  0.0154719, 0.0152363, 0.0149885, 0.0147287, 0.0144575, 0.0141753,
  0.0138824, 0.0135793, 0.0132664, 0.012944, 0.0126125, 0.0122723,
  0.0119238, 0.0115673, 0.0112032, 0.0108319, 0.0104536, 0.0100688,
  0.00967772, 0.00928072, 0.00887812, 0.00847025, 0.00805741,
  0.00763991, 0.00721804, 0.0067921, 0.00636238, 0.00592917,
  0.00549274, 0.00505336, 0.0046113, 0.00416684, 0.00372021,
  0.00327169, 0.00282151, 0.00236992, 0.00191716, 0.00146347,
  0.00100906, 0.000554179, 9.9031e-05, -0.000356164, -0.000811194,
  -0.00126585, -0.00171994, -0.00217325, -0.0026256, -0.00307679,
  -0.00352665, -0.00397498, -0.00442161, -0.00486637, -0.00530908,
  -0.00574959, -0.00618774, -0.00662335, -0.00705629, -0.0074864,
  -0.00791353, -0.00833755, -0.00875831, -0.00917568, -0.00958952,
  -0.00999971, -0.0104061, -0.0108086, -0.0112071, -0.0116015,
  -0.0119917, -0.0123774, -0.0127588, -0.0131355, -0.0135076,
  -0.013875, -0.0142375, -0.0145951, -0.0149477, -0.0152952,
  -0.0156374, -0.0159745, -0.0163061, -0.0166324, -0.0169532,
  -0.0172685, -0.0175781, -0.0178821, -0.0181804, -0.0184729,
  -0.0187595, -0.0190402, -0.0193151, -0.0195839, -0.0198467,
  -0.0201034, -0.020354, -0.0205985, -0.0208368, -0.0210689,
  -0.0212947, -0.0215143, -0.0217275, -0.0219345, -0.0221351,
  -0.0223294, -0.0225172, -0.0226987, -0.0228738, -0.0230424,
  -0.0232046, -0.0233604, -0.0235097, -0.0236526, -0.023789,
  -0.023919, -0.0240425, -0.0241595, -0.0242701, -0.0243743,
  -0.024472, -0.0245633, -0.0246482, -0.0247267, -0.0247988,
  -0.0248645, -0.0249239, -0.0249769, -0.0250236, -0.025064,
  -0.0250981, -0.025126, -0.0251476, -0.025163, -0.0251722,
  -0.0251753, -0.0251722, -0.0251631, -0.0251478, -0.0251266,
  -0.0250994, -0.0250661, -0.025027, -0.024982, -0.0249311,
  -0.0248744, -0.0248119, -0.0247437, -0.0246699, -0.0245903,
  -0.0245052, -0.0244145, -0.0243182, -0.0242165, -0.0241094,
  -0.0239969, -0.0238791, -0.023756, -0.0236276, -0.0234941,
  -0.0233554, -0.0232117, -0.0230629, -0.0229092, -0.0227506,
  -0.022587, -0.0224187, -0.0222456, -0.0220679, -0.0218854,
  -0.0216984, -0.0215069, -0.0213109, -0.0211104, -0.0209056,
  -0.0206966, -0.0204832, -0.0202657, -0.0200441, -0.0198184,
  -0.0195888, -0.0193552, -0.0191177, -0.0188764, -0.0186314,
  -0.0183826, -0.0181303, -0.0178744, -0.017615, -0.0173521,
  -0.0170859, -0.0168164, -0.0165436, -0.0162676, -0.0159886,
  -0.0157064, -0.0154213, -0.0151333, -0.0148424, -0.0145487,
  -0.0142523, -0.0139532, -0.0136515, -0.0133472, -0.0130405,
  -0.0127314, -0.01242, -0.0121063, -0.0117903, -0.0114722,
  -0.0111521, -0.0108299, -0.0105057, -0.0101797, -0.00985183,
  -0.00952221, -0.0091909, -0.00885795, -0.00852344, -0.00818742,
  -0.00784996, -0.00751113, -0.00717098, -0.00682958, -0.006487,
  -0.00614329, -0.00579852, -0.00545276, -0.00510605, -0.00475847,
  -0.00441009, -0.00406095, -0.00371112, -0.00336066, -0.00300964,
  -0.00265811, -0.00230613, -0.00195377, -0.00160108, -0.00124813,
  -0.000894969, -0.00054166, -0.000188263, 0.000165166, 0.000518567,
  0.000871884, 0.00122506, 0.00157803, 0.00193075, 0.00228316,
  0.0026352, 0.00298681, 0.00333795, 0.00368855, 0.00403857,
  0.00438794, 0.00473661, 0.00508453, 0.00543166, 0.00577792,
  0.00612328, 0.00646768, 0.00681107, 0.00715339, 0.00749461,
  0.00783466, 0.0081735, 0.00851108, 0.00884735, 0.00918226,
  0.00951576, 0.00984781, 0.0101784, 0.0105074, 0.0108348, 0.0111605,
  0.0114846, 0.011807, 0.0121276, 0.0124463, 0.0127632, 0.0130782,
  0.0133913, 0.0137024, 0.0140114, 0.0143184, 0.0146232, 0.0149259,
  0.0152265, 0.0155248, 0.0158208, 0.0161145, 0.0164059, 0.0166949,
  0.0169814, 0.0172656, 0.0175472, 0.0178263, 0.0181029, 0.0183769,
  0.0186482, 0.0189169, 0.0191829, 0.0194462, 0.0197067, 0.0199645,
  0.0202194, 0.0204715, 0.0207207, 0.020967, 0.0212104, 0.0214508,
  0.0216882, 0.0219226, 0.022154, 0.0223823, 0.0226076, 0.0228297,
  0.0230487, 0.0232645, 0.0234771, 0.0236865, 0.0238927, 0.0240957,
  0.0242953, 0.0244917, 0.0246848, 0.0248745, 0.0250609, 0.0252439,
  0.0254235, 0.0255997, 0.0257725, 0.0259419, 0.0261078, 0.0262702,
  0.0264292, 0.0265846, 0.0267365, 0.0268849, 0.0270298, 0.0271711,
  0.0273089, 0.027443, 0.0275736, 0.0277006, 0.027824, 0.0279438,
  0.0280599, 0.0281724, 0.0282813, 0.0283865, 0.0284881, 0.028586,
  0.0286802, 0.0287707, 0.0288576, 0.0289408, 0.0290203, 0.0290961,
  0.0291682, 0.0292367, 0.0293014, 0.0293624, 0.0294197, 0.0294733,
  0.0295232, 0.0295694, 0.0296119, 0.0296507, 0.0296858, 0.0297172,
  0.0297449, 0.0297689, 0.0297892, 0.0298058, 0.0298187, 0.029828,
  0.0298336, 0.0298355, 0.0298337, 0.0298283, 0.0298193, 0.0298065,
  0.0297902, 0.0297702, 0.0297466, 0.0297194, 0.0296886, 0.0296542,
  0.0296162, 0.0295746, 0.0295295, 0.0294808, 0.0294286, 0.0293728,
  0.0293136, 0.0292508, 0.0291845, 0.0291148, 0.0290416, 0.0289649,
  0.0288848, 0.0288013, 0.0287143, 0.028624, 0.0285303, 0.0284332,
  0.0283328, 0.028229, 0.028122, 0.0280116, 0.027898, 0.0277811,
  0.027661, 0.0275376, 0.0274111, 0.0272814, 0.0271485, 0.0270124,
  0.0268733, 0.026731, 0.0265856, 0.0264372, 0.0262858, 0.0261313,
  0.0259738, 0.0258134, 0.0256499, 0.0254836, 0.0253144, 0.0251422,
  0.0249673, 0.0247894, 0.0246088, 0.0244254, 0.0242392, 0.0240503,
  0.0238586, 0.0236643, 0.0234673, 0.0232676, 0.0230654, 0.0228606,
  0.0226532, 0.0224432, 0.0222308, 0.0220159, 0.0217985, 0.0215787,
  0.0213565, 0.0211319, 0.020905, 0.0206757, 0.0204442, 0.0202104,
  0.0199744, 0.0197362, 0.0194958, 0.0192533, 0.0190087, 0.0187619,
  0.0185132, 0.0182623, 0.0180095, 0.0177548, 0.0174981, 0.0172394,
  0.0169789, 0.0167166, 0.0164525, 0.0161865, 0.0159188, 0.0156494,
  0.0153783, 0.0151056, 0.0148312, 0.0145552, 0.0142776, 0.0139986,
  0.013718, 0.0134359, 0.0131524, 0.0128675, 0.0125812, 0.0122936,
  0.0120047, 0.0117145, 0.011423, 0.0111303, 0.0108365, 0.0105415,
  0.0102454, 0.00994816, 0.00964991, 0.00935064, 0.00905038,
  0.00874916, 0.00844703, 0.00814401, 0.00784013, 0.00753543,
  0.00722994, 0.00692369, 0.00661672, 0.00630905, 0.00600073,
  0.00569178, 0.00538224, 0.00507214, 0.00476151, 0.00445038,
  0.0041388, 0.00382678, 0.00351437, 0.00320159, 0.00288849,
  0.00257508, 0.00226141, 0.00194751, 0.0016334, 0.00131913,
  0.00100472, 0.000690214, 0.000375632, 6.10113e-05, -0.000253615,
  -0.000568216, -0.000882759, -0.00119721, -0.00151154, -0.00182572,
  -0.00213971, -0.00245348, -0.00276701, -0.00308025, -0.00339318,
  -0.00370576, -0.00401797, -0.00432978, -0.00464114, -0.00495204,
  -0.00526244, -0.0055723, -0.00588161, -0.00619032, -0.00649841,
  -0.00680585, -0.0071126, -0.00741864, -0.00772394, -0.00802846,
  -0.00833218, -0.00863507, -0.00893709, -0.00923822, -0.00953843,
  -0.00983769, -0.010136, -0.0104332, -0.0107295, -0.0110246,
  -0.0113187, -0.0116117, -0.0119035, -0.0121941, -0.0124835,
  -0.0127717, -0.0130586, -0.0133442, -0.0136285, -0.0139115,
  -0.0141931, -0.0144733, -0.0147521, -0.0150294, -0.0153053,
  -0.0155796, -0.0158524, -0.0161237, -0.0163934, -0.0166615,
  -0.016928, -0.0171928, -0.0174559, -0.0177173, -0.017977, -0.018235,
  -0.0184912, -0.0187455, -0.0189981, -0.0192488, -0.0194976,
  -0.0197446, -0.0199896, -0.0202327, -0.0204739, -0.020713,
  -0.0209502, -0.0211853, -0.0214184, -0.0216494, -0.0218784,
  -0.0221052, -0.0223299, -0.0225525, -0.0227729, -0.0229911,
  -0.0232071, -0.0234208, -0.0236324, -0.0238416, -0.0240486,
  -0.0242533, -0.0244556, -0.0246556, -0.0248533, -0.0250486,
  -0.0252415, -0.025432, -0.0256201, -0.0258057, -0.0259889,
  -0.0261696, -0.0263478, -0.0265235, -0.0266967, -0.0268674,
  -0.0270355, -0.027201, -0.027364, -0.0275244, -0.0276822,
  -0.0278374, -0.0279899, -0.0281398, -0.028287, -0.0284316,
  -0.0285735, -0.0287127, -0.0288492, -0.028983, -0.029114,
  -0.0292423, -0.0293679, -0.0294907, -0.0296108, -0.029728,
  -0.0298425, -0.0299542, -0.0300631, -0.0301692, -0.0302724,
  -0.0303728, -0.0304704, -0.0305651, -0.030657, -0.030746,
  -0.0308321, -0.0309154, -0.0309958, -0.0310733, -0.0311479,
  -0.0312196, -0.0312884, -0.0313544, -0.0314173, -0.0314774,
  -0.0315346, -0.0315888, -0.0316401, -0.0316885, -0.0317339,
  -0.0317764, -0.0318159, -0.0318525, -0.0318862, -0.0319169,
  -0.0319447, -0.0319695, -0.0319914, -0.0320103, -0.0320262,
  -0.0320392, -0.0320493, -0.0320564, -0.0320606, -0.0320618,
  -0.03206, -0.0320553, -0.0320477, -0.0320371, -0.0320236,
  -0.0320071, -0.0319877, -0.0319654, -0.0319401, -0.031912,
  -0.0318808, -0.0318468, -0.0318099, -0.03177, -0.0317272,
  -0.0316816, -0.031633, -0.0315816, -0.0315272, -0.03147, -0.0314099,
  -0.031347, -0.0312812, -0.0312125, -0.031141, -0.0310667,
  -0.0309895, -0.0309095, -0.0308267, -0.0307411, -0.0306527,
  -0.0305615, -0.0304675, -0.0303708, -0.0302713, -0.0301691,
  -0.0300641, -0.0299564, -0.029846, -0.0297328, -0.029617,
  -0.0294985, -0.0293773, -0.0292535, -0.029127, -0.0289979,
  -0.0288661, -0.0287318, -0.0285948, -0.0284553, -0.0283132,
  -0.0281685, -0.0280213, -0.0278715, -0.0277193, -0.0275645,
  -0.0274073, -0.0272476, -0.0270854, -0.0269208, -0.0267537,
  -0.0265843, -0.0264124, -0.0262382, -0.0260616, -0.0258827,
  -0.0257014, -0.0255179, -0.025332, -0.0251438, -0.0249534,
  -0.0247608, -0.0245659, -0.0243688, -0.0241696, -0.0239681,
  -0.0237645, -0.0235588, -0.023351, -0.023141, -0.022929, -0.022715,
  -0.0224989, -0.0222808, -0.0220607, -0.0218386, -0.0216145,
  -0.0213885, -0.0211606, -0.0209309, -0.0206992, -0.0204657,
  -0.0202303, -0.0199932, -0.0197542, -0.0195135, -0.019271,
  -0.0190269, -0.018781, -0.0185334, -0.0182842, -0.0180334,
  -0.0177809, -0.0175269, -0.0172712, -0.0170141, -0.0167554,
  -0.0164952, -0.0162336, -0.0159705, -0.015706, -0.0154401,
  -0.0151728, -0.0149041, -0.0146342, -0.0143629, -0.0140903,
  -0.0138165, -0.0135415, -0.0132652, -0.0129878, -0.0127092,
  -0.0124295, -0.0121486, -0.0118667, -0.0115837, -0.0112997,
  -0.0110147, -0.0107287, -0.0104418, -0.0101539, -0.00986512,
  -0.00957546, -0.00928495, -0.00899362, -0.00870148, -0.00840857,
  -0.00811491, -0.00782053, -0.00752545, -0.00722971, -0.00693332,
  -0.00663631, -0.00633872, -0.00604056, -0.00574186, -0.00544265,
  -0.00514296, -0.00484281, -0.00454223, -0.00424125, -0.00393989,
  -0.00363818, -0.00333614, -0.00303381, -0.00273121, -0.00242837,
  -0.00212531, -0.00182206, -0.00151865, -0.00121511, -0.000911453,
  -0.000607719, -0.000303931, -1.15741e-07, 0.000303699, 0.000607487,
  0.000911221, 0.00121487, 0.00151842, 0.00182183, 0.00212508,
  0.00242814, 0.00273098, 0.00303358, 0.00333591, 0.00363795,
  0.00393966, 0.00424102, 0.004542, 0.00484258, 0.00514273,
  0.00544242, 0.00574163, 0.00604032, 0.00633848, 0.00663608,
  0.00693309, 0.00722948, 0.00752522, 0.0078203, 0.00811468,
  0.00840834, 0.00870125, 0.00899339, 0.00928472, 0.00957523,
  0.00986489, 0.0101537, 0.0104415, 0.0107285, 0.0110145, 0.0112995,
  0.0115835, 0.0118665, 0.0121484, 0.0124292, 0.0127089, 0.0129875,
  0.013265, 0.0135412, 0.0138163, 0.0140901, 0.0143627, 0.0146339,
  0.0149039, 0.0151726, 0.0154399, 0.0157058, 0.0159703, 0.0162334,
  0.016495, 0.0167552, 0.0170139, 0.017271, 0.0175266, 0.0177807,
  0.0180331, 0.018284, 0.0185332, 0.0187808, 0.0190266, 0.0192708,
  0.0195133, 0.019754, 0.0199929, 0.0202301, 0.0204654, 0.020699,
  0.0209306, 0.0211604, 0.0213883, 0.0216143, 0.0218383, 0.0220604,
  0.0222805, 0.0224986, 0.0227147, 0.0229288, 0.0231408, 0.0233507,
  0.0235586, 0.0237643, 0.0239679, 0.0241693, 0.0243686, 0.0245657,
  0.0247606, 0.0249532, 0.0251436, 0.0253318, 0.0255176, 0.0257012,
  0.0258825, 0.0260614, 0.026238, 0.0264122, 0.0265841, 0.0267535,
  0.0269205, 0.0270852, 0.0272473, 0.0274071, 0.0275643, 0.0277191,
  0.0278713, 0.0280211, 0.0281683, 0.0283129, 0.0284551, 0.0285946,
  0.0287315, 0.0288659, 0.0289977, 0.0291268, 0.0292533, 0.0293771,
  0.0294983, 0.0296168, 0.0297326, 0.0298457, 0.0299562, 0.0300639,
  0.0301688, 0.0302711, 0.0303706, 0.0304673, 0.0305613, 0.0306525,
  0.0307409, 0.0308265, 0.0309093, 0.0309893, 0.0310664, 0.0311408,
  0.0312123, 0.0312809, 0.0313468, 0.0314097, 0.0314698, 0.031527,
  0.0315813, 0.0316328, 0.0316813, 0.031727, 0.0317698, 0.0318096,
  0.0318466, 0.0318806, 0.0319117, 0.0319399, 0.0319652, 0.0319875,
  0.0320069, 0.0320234, 0.0320369, 0.0320475, 0.0320551, 0.0320598,
  0.0320615, 0.0320603, 0.0320562, 0.0320491, 0.032039, 0.032026,
  0.03201, 0.0319911, 0.0319693, 0.0319444, 0.0319167, 0.031886,
  0.0318523, 0.0318157, 0.0317761, 0.0317337, 0.0316882, 0.0316399,
  0.0315886, 0.0315343, 0.0314772, 0.0314171, 0.0313541, 0.0312882,
  0.0312194, 0.0311477, 0.0310731, 0.0309956, 0.0309152, 0.0308319,
  0.0307458, 0.0306568, 0.0305649, 0.0304702, 0.0303726, 0.0302722,
  0.0301689, 0.0300629, 0.029954, 0.0298423, 0.0297278, 0.0296105,
  0.0294905, 0.0293677, 0.0292421, 0.0291138, 0.0289827, 0.028849,
  0.0287125, 0.0285733, 0.0284314, 0.0282868, 0.0281396, 0.0279897,
  0.0278371, 0.027682, 0.0275242, 0.0273638, 0.0272008, 0.0270352,
  0.0268671, 0.0266965, 0.0265233, 0.0263476, 0.0261693, 0.0259886,
  0.0258055, 0.0256198, 0.0254318, 0.0252413, 0.0250484, 0.0248531,
  0.0246554, 0.0244554, 0.024253, 0.0240484, 0.0238414, 0.0236321,
  0.0234206, 0.0232068, 0.0229908, 0.0227726, 0.0225522, 0.0223297,
  0.022105, 0.0218782, 0.0216492, 0.0214182, 0.0211851, 0.02095,
  0.0207128, 0.0204736, 0.0202325, 0.0199894, 0.0197444, 0.0194974,
  0.0192486, 0.0189979, 0.0187453, 0.0184909, 0.0182347, 0.0179768,
  0.0177171, 0.0174557, 0.0171925, 0.0169277, 0.0166613, 0.0163932,
  0.0161235, 0.0158522, 0.0155794, 0.015305, 0.0150292, 0.0147519,
  0.0144731, 0.0141929, 0.0139113, 0.0136283, 0.013344, 0.0130584,
  0.0127714, 0.0124833, 0.0121939, 0.0119032, 0.0116114, 0.0113185,
  0.0110244, 0.0107292, 0.010433, 0.0101357, 0.00983746, 0.0095382,
  0.00923799, 0.00893686, 0.00863484, 0.00833195, 0.00802823,
  0.00772371, 0.00741841, 0.00711237, 0.00680562, 0.00649818,
  0.00619009, 0.00588138, 0.00557207, 0.00526221, 0.00495181,
  0.00464091, 0.00432955, 0.00401774, 0.00370553, 0.00339295,
  0.00308002, 0.00276677, 0.00245325, 0.00213948, 0.00182549,
  0.00151131, 0.00119698, 0.000882528, 0.000567985, 0.000253384,
  -6.12427e-05, -0.000375863, -0.000690445, -0.00100496, -0.00131936,
  -0.00163364, -0.00194774, -0.00226164, -0.00257531, -0.00288872,
  -0.00320183, -0.0035146, -0.00382701, -0.00413903, -0.00445061,
  -0.00476174, -0.00507237, -0.00538247, -0.00569201, -0.00600096,
  -0.00630928, -0.00661695, -0.00692392, -0.00723017, -0.00753566,
  -0.00784036, -0.00814424, -0.00844726, -0.0087494, -0.00905061,
  -0.00935087, -0.00965014, -0.0099484, -0.0102456, -0.0105417,
  -0.0108367, -0.0111306, -0.0114232, -0.0117147, -0.0120049,
  -0.0122938, -0.0125815, -0.0128677, -0.0131526, -0.0134361,
  -0.0137182, -0.0139988, -0.0142779, -0.0145554, -0.0148314,
  -0.0151058, -0.0153786, -0.0156497, -0.0159191, -0.0161868,
  -0.0164527, -0.0167168, -0.0169792, -0.0172397, -0.0174983,
  -0.017755, -0.0180098, -0.0182626, -0.0185134, -0.0187622,
  -0.0190089, -0.0192535, -0.0194961, -0.0197365, -0.0199747,
  -0.0202107, -0.0204445, -0.020676, -0.0209052, -0.0211321,
  -0.0213567, -0.0215789, -0.0217987, -0.0220161, -0.022231,
  -0.0224434, -0.0226534, -0.0228608, -0.0230656, -0.0232679,
  -0.0234675, -0.0236645, -0.0238588, -0.0240505, -0.0242394,
  -0.0244256, -0.024609, -0.0247897, -0.0249675, -0.0251425,
  -0.0253146, -0.0254838, -0.0256502, -0.0258136, -0.025974,
  -0.0261315, -0.026286, -0.0264374, -0.0265859, -0.0267312,
  -0.0268735, -0.0270126, -0.0271487, -0.0272816, -0.0274113,
  -0.0275379, -0.0276612, -0.0277814, -0.0278982, -0.0280119,
  -0.0281222, -0.0282293, -0.028333, -0.0284334, -0.0285305,
  -0.0286242, -0.0287145, -0.0288015, -0.028885, -0.0289651,
  -0.0290418, -0.029115, -0.0291848, -0.029251, -0.0293138,
  -0.0293731, -0.0294288, -0.0294811, -0.0295297, -0.0295749,
  -0.0296164, -0.0296544, -0.0296888, -0.0297196, -0.0297469,
  -0.0297705, -0.0297904, -0.0298068, -0.0298195, -0.0298285,
  -0.029834, -0.0298357, -0.0298338, -0.0298282, -0.029819, -0.029806,
  -0.0297894, -0.0297691, -0.0297451, -0.0297174, -0.029686,
  -0.0296509, -0.0296121, -0.0295697, -0.0295234, -0.0294735,
  -0.0294199, -0.0293626, -0.0293016, -0.0292369, -0.0291685,
  -0.0290964, -0.0290205, -0.028941, -0.0288578, -0.028771,
  -0.0286804, -0.0285862, -0.0284883, -0.0283867, -0.0282815,
  -0.0281727, -0.0280601, -0.027944, -0.0278242, -0.0277009,
  -0.0275739, -0.0274433, -0.0273091, -0.0271714, -0.02703,
  -0.0268852, -0.0267368, -0.0265848, -0.0264294, -0.0262704,
  -0.026108, -0.0259421, -0.0257728, -0.0256, -0.0254238, -0.0252441,
  -0.0250611, -0.0248747, -0.024685, -0.0244919, -0.0242956,
  -0.0240959, -0.023893, -0.0236868, -0.0234773, -0.0232647,
  -0.0230489, -0.0228299, -0.0226078, -0.0223826, -0.0221542,
  -0.0219229, -0.0216884, -0.021451, -0.0212106, -0.0209672,
  -0.0207209, -0.0204717, -0.0202196, -0.0199647, -0.0197069,
  -0.0194464, -0.0191831, -0.0189171, -0.0186484, -0.0183771,
  -0.0181031, -0.0178266, -0.0175474, -0.0172658, -0.0169817,
  -0.0166951, -0.0164061, -0.0161147, -0.015821, -0.015525,
  -0.0152267, -0.0149262, -0.0146235, -0.0143186, -0.0140116,
  -0.0137026, -0.0133915, -0.0130785, -0.0127635, -0.0124466,
  -0.0121278, -0.0118072, -0.0114849, -0.0111608, -0.010835,
  -0.0105076, -0.0101786, -0.00984804, -0.00951599, -0.00918249,
  -0.00884758, -0.00851131, -0.00817373, -0.00783489, -0.00749484,
  -0.00715362, -0.0068113, -0.00646791, -0.00612351, -0.00577815,
  -0.00543189, -0.00508477, -0.00473684, -0.00438817, -0.0040388,
  -0.00368878, -0.00333818, -0.00298705, -0.00263543, -0.00228339,
  -0.00193098, -0.00157827, -0.00122529, -0.000872115, -0.000518799,
  -0.000165397, 0.000188031, 0.000541429, 0.000894737, 0.0012479,
  0.00160085, 0.00195354, 0.0023059, 0.00265787, 0.0030094,
  0.00336043, 0.00371088, 0.00406071, 0.00440985, 0.00475824,
  0.00510582, 0.00545252, 0.00579829, 0.00614306, 0.00648677,
  0.00682935, 0.00717075, 0.0075109, 0.00784973, 0.00818719,
  0.0085232, 0.00885772, 0.00919066, 0.00952198, 0.0098516, 0.0101795,
  0.0105055, 0.0108296, 0.0111518, 0.011472, 0.0117901, 0.012106,
  0.0124197, 0.0127312, 0.0130403, 0.013347, 0.0136512, 0.0139529,
  0.014252, 0.0145485, 0.0148422, 0.0151331, 0.0154211, 0.0157062,
  0.0159883, 0.0162674, 0.0165434, 0.0168161, 0.0170857, 0.0173519,
  0.0176147, 0.0178742, 0.0181301, 0.0183824, 0.0186311, 0.0188762,
  0.0191175, 0.0193549, 0.0195885, 0.0198182, 0.0200439, 0.0202655,
  0.020483, 0.0206963, 0.0209054, 0.0211102, 0.0213106, 0.0215066,
  0.0216982, 0.0218852, 0.0220676, 0.0222454, 0.0224185, 0.0225868,
  0.0227503, 0.022909, 0.0230627, 0.0232115, 0.0233552, 0.0234939,
  0.0236274, 0.0237557, 0.0238788, 0.0239967, 0.0241092, 0.0242163,
  0.024318, 0.0244142, 0.0245049, 0.0245901, 0.0246696, 0.0247435,
  0.0248117, 0.0248742, 0.0249309, 0.0249818, 0.0250268, 0.0250659,
  0.0250991, 0.0251264, 0.0251476, 0.0251628, 0.025172, 0.025175,
  0.025172, 0.0251627, 0.0251473, 0.0251257, 0.0250979, 0.0250638,
  0.0250234, 0.0249767, 0.0249237, 0.0248643, 0.0247986, 0.0247265,
  0.024648, 0.0245631, 0.0244718, 0.0243741, 0.0242699, 0.0241593,
  0.0240422, 0.0239187, 0.0237888, 0.0236523, 0.0235095, 0.0233601,
  0.0232044, 0.0230422, 0.0228735, 0.0226985, 0.022517, 0.0223291,
  0.0221349, 0.0219343, 0.0217273, 0.021514, 0.0212945, 0.0210686,
  0.0208366, 0.0205983, 0.0203538, 0.0201032, 0.0198464, 0.0195836,
  0.0193148, 0.01904, 0.0187593, 0.0184726, 0.0181802, 0.0178819,
  0.0175779, 0.0172683, 0.016953, 0.0166322, 0.0163059, 0.0159742,
  0.0156372, 0.0152949, 0.0149475, 0.0145949, 0.0142373, 0.0138748,
  0.0135074, 0.0131353, 0.0127585, 0.0123772, 0.0119914, 0.0116013,
  0.0112069, 0.0108084, 0.0104059, 0.00999948, 0.00958929, 0.00917544,
  0.00875808, 0.00833732, 0.0079133, 0.00748617, 0.00705606,
  0.00662312, 0.0061875, 0.00574936, 0.00530885, 0.00486613,
  0.00442137, 0.00397474, 0.00352641, 0.00307656, 0.00262537,
  0.00217302, 0.00171971, 0.00126562, 0.000810963, 0.000355932,
  -9.92625e-05, -0.000554411, -0.0010093, -0.0014637, -0.0019174,
  -0.00237015, -0.00282174, -0.00327192, -0.00372044, -0.00416707,
  -0.00461153, -0.00505359, -0.00549297, -0.0059294, -0.00636261,
  -0.00679233, -0.00721827, -0.00764014, -0.00805764, -0.00847048,
  -0.00887836, -0.00928095, -0.00967795, -0.010069, -0.0104539,
  -0.0108321, -0.0112035, -0.0115676, -0.011924, -0.0122725,
  -0.0126127, -0.0129442, -0.0132666, -0.0135795, -0.0138826,
  -0.0141755, -0.0144577, -0.0147289, -0.0149887, -0.0152366,
  -0.0154721, -0.015695, -0.0159046, -0.0161007, -0.0162827,
  -0.0164501, -0.0166025, -0.0167395, -0.0168606, -0.0169651,
  -0.0170528, -0.017123, -0.0171752, -0.017209, -0.0172238,
  -0.0172191, -0.0171943, -0.0171488, -0.0170822, -0.0169939,
  -0.0168832, -0.0167497, -0.0165927, -0.0164115, -0.0162058,
  -0.0159747, -0.0157177, -0.0154341, -0.0151233, -0.0147848,
  -0.0144177, -0.0140214, -0.0135954, -0.0131388, -0.012651,
  -0.0121312, -0.0115789, -0.0109932, -0.0103735, -0.00971892,
  -0.0090288, -0.00830237, -0.00753885, -0.00673746, -0.00589743,
  -0.00501795, -0.00409822, -0.00313741, -0.00213471, -0.00108926,
  -2.31481e-07}; G4double G4NeutronHPFastLegendre::l9[2001] = {-1,
  -0.955493, -0.911962, -0.869393, -0.827774, -0.78709, -0.747328,
  -0.708476, -0.67052, -0.633447, -0.597246, -0.561902, -0.527403,
  -0.493738, -0.460893, -0.428858, -0.397619, -0.367165, -0.337484,
  -0.308565, -0.280396, -0.252966, -0.226262, -0.200275, -0.174993,
  -0.150405, -0.126501, -0.103269, -0.0806992, -0.058781, -0.037504,
  -0.0168579, 0.0031675, 0.0225821, 0.041396, 0.0596189, 0.0772607,
  0.0943308, 0.110839, 0.126794, 0.142206, 0.157084, 0.171437,
  0.185274, 0.198604, 0.211436, 0.223778, 0.235639, 0.247028,
  0.257953, 0.268422, 0.278444, 0.288026, 0.297177, 0.305905,
  0.314218, 0.322123, 0.329628, 0.336741, 0.343469, 0.349819, 0.3558,
  0.361417, 0.36668, 0.371593, 0.376165, 0.380402, 0.384312, 0.3879,
  0.391174, 0.394141, 0.396805, 0.399175, 0.401257, 0.403056,
  0.404579, 0.405832, 0.406821, 0.407552, 0.408031, 0.408264,
  0.408256, 0.408014, 0.407542, 0.406846, 0.405932, 0.404805, 0.40347,
  0.401933, 0.400198, 0.398271, 0.396158, 0.393862, 0.391389,
  0.388743, 0.38593, 0.382953, 0.379819, 0.376531, 0.373093, 0.36951,
  0.365788, 0.361929, 0.357938, 0.353819, 0.349578, 0.345216,
  0.340739, 0.336151, 0.331455, 0.326656, 0.321757, 0.316761,
  0.311673, 0.306497, 0.301235, 0.295891, 0.290469, 0.284972,
  0.279403, 0.273766, 0.268064, 0.262301, 0.256479, 0.250601,
  0.244671, 0.238691, 0.232665, 0.226595, 0.220484, 0.214335,
  0.208152, 0.201935, 0.195689, 0.189416, 0.183117, 0.176797,
  0.170457, 0.1641, 0.157729, 0.151345, 0.14495, 0.138548, 0.13214,
  0.125729, 0.119317, 0.112905, 0.106497, 0.100093, 0.0936961,
  0.0873082, 0.0809311, 0.0745666, 0.0682166, 0.0618828, 0.0555672,
  0.0492713, 0.0429969, 0.0367456, 0.030519, 0.0243187, 0.0181464,
  0.0120034, 0.00589121, -0.000188626, -0.00623474, -0.0122457,
  -0.0182203, -0.0241571, -0.0300548, -0.0359123, -0.0417281,
  -0.0475013, -0.0532306, -0.0589149, -0.064553, -0.070144,
  -0.0756867, -0.0811801, -0.0866233, -0.0920153, -0.0973551,
  -0.102642, -0.107875, -0.113053, -0.118175, -0.123242, -0.12825,
  -0.133201, -0.138094, -0.142927, -0.1477, -0.152412, -0.157063,
  -0.161652, -0.166179, -0.170642, -0.175042, -0.179378, -0.183649,
  -0.187855, -0.191996, -0.196071, -0.200079, -0.204021, -0.207895,
  -0.211702, -0.215442, -0.219113, -0.222716, -0.22625, -0.229716,
  -0.233112, -0.236439, -0.239696, -0.242884, -0.246002, -0.24905,
  -0.252028, -0.254935, -0.257772, -0.260539, -0.263235, -0.265861,
  -0.268416, -0.270901, -0.273315, -0.275659, -0.277932, -0.280135,
  -0.282267, -0.284329, -0.286321, -0.288242, -0.290094, -0.291875,
  -0.293587, -0.295229, -0.296802, -0.298305, -0.29974, -0.301105,
  -0.302402, -0.30363, -0.30479, -0.305882, -0.306907, -0.307863,
  -0.308753, -0.309576, -0.310332, -0.311022, -0.311645, -0.312203,
  -0.312696, -0.313124, -0.313487, -0.313786, -0.314021, -0.314192,
  -0.3143, -0.314345, -0.314328, -0.314249, -0.314109, -0.313907,
  -0.313645, -0.313322, -0.31294, -0.312498, -0.311997, -0.311438,
  -0.310821, -0.310146, -0.309414, -0.308626, -0.307781, -0.306881,
  -0.305926, -0.304917, -0.303853, -0.302736, -0.301566, -0.300343,
  -0.299069, -0.297743, -0.296366, -0.294939, -0.293462, -0.291936,
  -0.290361, -0.288738, -0.287068, -0.28535, -0.283586, -0.281776,
  -0.279921, -0.278022, -0.276078, -0.27409, -0.27206, -0.269987,
  -0.267873, -0.265717, -0.26352, -0.261284, -0.259008, -0.256694,
  -0.254341, -0.25195, -0.249523, -0.247059, -0.244559, -0.242024,
  -0.239454, -0.236851, -0.234214, -0.231544, -0.228842, -0.226109,
  -0.223344, -0.220549, -0.217725, -0.214871, -0.211989, -0.209078,
  -0.206141, -0.203177, -0.200186, -0.197171, -0.19413, -0.191065,
  -0.187976, -0.184864, -0.18173, -0.178574, -0.175397, -0.172199,
  -0.168981, -0.165743, -0.162487, -0.159212, -0.15592, -0.152611,
  -0.149285, -0.145943, -0.142586, -0.139214, -0.135828, -0.132428,
  -0.129016, -0.125591, -0.122154, -0.118706, -0.115247, -0.111778,
  -0.1083, -0.104812, -0.101316, -0.0978125, -0.0943014, -0.0907836,
  -0.0872596, -0.0837299, -0.0801952, -0.0766558, -0.0731125,
  -0.0695656, -0.0660158, -0.0624636, -0.0589095, -0.055354,
  -0.0517977, -0.0482411, -0.0446847, -0.0411289, -0.0375744,
  -0.0340216, -0.0304711, -0.0269232, -0.0233786, -0.0198377,
  -0.0163011, -0.0127691, -0.00924226, -0.0057211, -0.00220608,
  0.00130234, 0.00480369, 0.0082975, 0.0117833, 0.0152607, 0.0187291,
  0.0221882, 0.0256375, 0.0290766, 0.032505, 0.0359222, 0.0393279,
  0.0427217, 0.046103, 0.0494716, 0.0528269, 0.0561686, 0.0594962,
  0.0628094, 0.0661078, 0.0693909, 0.0726584, 0.0759099, 0.079145,
  0.0823633, 0.0855645, 0.0887482, 0.091914, 0.0950616, 0.0981906,
  0.101301, 0.104391, 0.107462, 0.110514, 0.113545, 0.116555,
  0.119544, 0.122512, 0.125458, 0.128383, 0.131285, 0.134165,
  0.137022, 0.139856, 0.142666, 0.145453, 0.148215, 0.150954,
  0.153668, 0.156357, 0.159021, 0.16166, 0.164273, 0.16686, 0.169421,
  0.171956, 0.174465, 0.176946, 0.179401, 0.181828, 0.184228, 0.1866,
  0.188944, 0.19126, 0.193548, 0.195807, 0.198038, 0.20024, 0.202412,
  0.204556, 0.20667, 0.208754, 0.210809, 0.212833, 0.214828, 0.216792,
  0.218726, 0.220629, 0.222502, 0.224343, 0.226154, 0.227934,
  0.229682, 0.231399, 0.233085, 0.234739, 0.236361, 0.237952,
  0.239511, 0.241037, 0.242532, 0.243994, 0.245424, 0.246822,
  0.248188, 0.24952, 0.250821, 0.252088, 0.253324, 0.254526, 0.255695,
  0.256832, 0.257936, 0.259007, 0.260045, 0.26105, 0.262021, 0.26296,
  0.263866, 0.264739, 0.265578, 0.266385, 0.267158, 0.267899,
  0.268606, 0.26928, 0.269921, 0.270529, 0.271103, 0.271645, 0.272154,
  0.27263, 0.273072, 0.273482, 0.273859, 0.274203, 0.274515, 0.274793,
  0.275039, 0.275252, 0.275432, 0.27558, 0.275696, 0.275779, 0.27583,
  0.275848, 0.275835, 0.275789, 0.275711, 0.275601, 0.27546, 0.275287,
  0.275082, 0.274845, 0.274577, 0.274278, 0.273948, 0.273586,
  0.273193, 0.27277, 0.272315, 0.271831, 0.271315, 0.270769, 0.270193,
  0.269587, 0.268951, 0.268285, 0.267589, 0.266864, 0.266109,
  0.265325, 0.264512, 0.26367, 0.262799, 0.2619, 0.260972, 0.260016,
  0.259032, 0.258019, 0.256979, 0.255912, 0.254817, 0.253694,
  0.252545, 0.251369, 0.250165, 0.248936, 0.24768, 0.246398, 0.24509,
  0.243756, 0.242397, 0.241013, 0.239603, 0.238168, 0.236709,
  0.235225, 0.233717, 0.232185, 0.230629, 0.229049, 0.227445,
  0.225819, 0.22417, 0.222497, 0.220802, 0.219085, 0.217346, 0.215585,
  0.213802, 0.211998, 0.210172, 0.208326, 0.206459, 0.204572,
  0.202664, 0.200736, 0.198789, 0.196822, 0.194835, 0.19283, 0.190806,
  0.188764, 0.186703, 0.184624, 0.182527, 0.180413, 0.178282,
  0.176133, 0.173968, 0.171787, 0.169589, 0.167375, 0.165145, 0.1629,
  0.16064, 0.158365, 0.156075, 0.153771, 0.151452, 0.14912, 0.146774,
  0.144415, 0.142042, 0.139657, 0.137259, 0.134849, 0.132427,
  0.129993, 0.127548, 0.125092, 0.122624, 0.120146, 0.117658,
  0.115159, 0.11265, 0.110132, 0.107605, 0.105069, 0.102523,
  0.0999696, 0.0974077, 0.0948378, 0.0922603, 0.0896753, 0.0870832,
  0.0844843, 0.0818787, 0.0792669, 0.076649, 0.0740254, 0.0713962,
  0.0687618, 0.0661225, 0.0634785, 0.0608301, 0.0581776, 0.0555212,
  0.0528613, 0.050198, 0.0475316, 0.0448625, 0.0421908, 0.039517,
  0.0368411, 0.0341636, 0.0314846, 0.0288045, 0.0261234, 0.0234418,
  0.0207597, 0.0180776, 0.0153957, 0.0127141, 0.0100333, 0.00735342,
  0.00467476, 0.00199759, -0.000677837, -0.00335126, -0.00602242,
  -0.00869106, -0.0113569, -0.0140197, -0.0166793, -0.0193352,
  -0.0219874, -0.0246355, -0.0272793, -0.0299185, -0.0325529,
  -0.0351823, -0.0378063, -0.0404248, -0.0430375, -0.0456441,
  -0.0482444, -0.0508382, -0.0534251, -0.0560051, -0.0585778,
  -0.061143, -0.0637004, -0.0662498, -0.0687911, -0.0713238,
  -0.0738479, -0.0763631, -0.0788691, -0.0813657, -0.0838527,
  -0.0863299, -0.0887971, -0.0912539, -0.0937003, -0.0961359,
  -0.0985605, -0.100974, -0.103376, -0.105767, -0.108145, -0.110512,
  -0.112866, -0.115208, -0.117538, -0.119854, -0.122158, -0.124448,
  -0.126724, -0.128987, -0.131236, -0.133471, -0.135692, -0.137898,
  -0.14009, -0.142267, -0.144429, -0.146575, -0.148706, -0.150822,
  -0.152922, -0.155005, -0.157073, -0.159124, -0.161159, -0.163178,
  -0.165179, -0.167163, -0.169131, -0.17108, -0.173013, -0.174928,
  -0.176824, -0.178703, -0.180564, -0.182407, -0.184231, -0.186036,
  -0.187823, -0.189591, -0.191339, -0.193069, -0.194779, -0.19647,
  -0.198141, -0.199793, -0.201424, -0.203036, -0.204627, -0.206198,
  -0.207749, -0.209279, -0.210789, -0.212278, -0.213745, -0.215192,
  -0.216618, -0.218023, -0.219406, -0.220768, -0.222108, -0.223427,
  -0.224724, -0.225999, -0.227252, -0.228483, -0.229692, -0.230879,
  -0.232044, -0.233186, -0.234305, -0.235402, -0.236476, -0.237528,
  -0.238557, -0.239563, -0.240545, -0.241505, -0.242442, -0.243356,
  -0.244246, -0.245113, -0.245957, -0.246777, -0.247574, -0.248348,
  -0.249098, -0.249824, -0.250526, -0.251205, -0.25186, -0.252492,
  -0.253099, -0.253683, -0.254243, -0.254778, -0.25529, -0.255778,
  -0.256242, -0.256681, -0.257097, -0.257489, -0.257856, -0.2582,
  -0.258519, -0.258814, -0.259085, -0.259332, -0.259555, -0.259753,
  -0.259927, -0.260078, -0.260204, -0.260305, -0.260383, -0.260437,
  -0.260466, -0.260471, -0.260453, -0.26041, -0.260343, -0.260252,
  -0.260137, -0.259998, -0.259835, -0.259648, -0.259438, -0.259203,
  -0.258945, -0.258663, -0.258357, -0.258027, -0.257674, -0.257297,
  -0.256896, -0.256472, -0.256025, -0.255554, -0.25506, -0.254542,
  -0.254002, -0.253438, -0.252851, -0.252241, -0.251608, -0.250952,
  -0.250273, -0.249571, -0.248847, -0.2481, -0.247331, -0.246539,
  -0.245725, -0.244889, -0.24403, -0.24315, -0.242247, -0.241322,
  -0.240376, -0.239408, -0.238418, -0.237406, -0.236374, -0.23532,
  -0.234244, -0.233148, -0.23203, -0.230892, -0.229733, -0.228553,
  -0.227352, -0.226132, -0.22489, -0.223629, -0.222348, -0.221046,
  -0.219725, -0.218384, -0.217023, -0.215643, -0.214244, -0.212825,
  -0.211388, -0.209931, -0.208456, -0.206962, -0.205449, -0.203918,
  -0.202369, -0.200802, -0.199217, -0.197614, -0.195994, -0.194356,
  -0.1927, -0.191028, -0.189338, -0.187632, -0.185909, -0.184169,
  -0.182413, -0.18064, -0.178852, -0.177048, -0.175228, -0.173392,
  -0.171541, -0.169675, -0.167793, -0.165897, -0.163986, -0.16206,
  -0.16012, -0.158166, -0.156198, -0.154216, -0.15222, -0.150211,
  -0.148189, -0.146153, -0.144104, -0.142043, -0.139969, -0.137883,
  -0.135784, -0.133673, -0.131551, -0.129417, -0.127272, -0.125115,
  -0.122947, -0.120768, -0.118579, -0.116379, -0.114169, -0.111949,
  -0.109719, -0.107479, -0.10523, -0.102971, -0.100704, -0.0984271,
  -0.0961419, -0.0938482, -0.0915462, -0.0892362, -0.0869183,
  -0.0845927, -0.0822596, -0.0799193, -0.077572, -0.0752178,
  -0.072857, -0.0704898, -0.0681163, -0.0657369, -0.0633517,
  -0.0609608, -0.0585647, -0.0561633, -0.053757, -0.051346,
  -0.0489305, -0.0465106, -0.0440866, -0.0416588, -0.0392273,
  -0.0367924, -0.0343542, -0.0319129, -0.0294689, -0.0270223,
  -0.0245733, -0.0221221, -0.019669, -0.0172142, -0.0147578,
  -0.0123002, -0.00984144, -0.00738184, -0.00492159, -0.0024609, 0,
  0.0024609, 0.00492159, 0.00738184, 0.00984144, 0.0123002, 0.0147578,
  0.0172142, 0.019669, 0.0221221, 0.0245733, 0.0270223, 0.0294689,
  0.0319129, 0.0343542, 0.0367924, 0.0392273, 0.0416588, 0.0440866,
  0.0465106, 0.0489305, 0.051346, 0.053757, 0.0561633, 0.0585647,
  0.0609608, 0.0633517, 0.0657369, 0.0681163, 0.0704898, 0.072857,
  0.0752178, 0.077572, 0.0799193, 0.0822596, 0.0845927, 0.0869183,
  0.0892362, 0.0915462, 0.0938482, 0.0961419, 0.0984271, 0.100704,
  0.102971, 0.10523, 0.107479, 0.109719, 0.111949, 0.114169, 0.116379,
  0.118579, 0.120768, 0.122947, 0.125115, 0.127272, 0.129417,
  0.131551, 0.133673, 0.135784, 0.137883, 0.139969, 0.142043,
  0.144104, 0.146153, 0.148189, 0.150211, 0.15222, 0.154216, 0.156198,
  0.158166, 0.16012, 0.16206, 0.163986, 0.165897, 0.167793, 0.169675,
  0.171541, 0.173392, 0.175228, 0.177048, 0.178852, 0.18064, 0.182413,
  0.184169, 0.185909, 0.187632, 0.189338, 0.191028, 0.1927, 0.194356,
  0.195994, 0.197614, 0.199217, 0.200802, 0.202369, 0.203918,
  0.205449, 0.206962, 0.208456, 0.209931, 0.211388, 0.212825,
  0.214244, 0.215643, 0.217023, 0.218384, 0.219725, 0.221046,
  0.222348, 0.223629, 0.22489, 0.226132, 0.227352, 0.228553, 0.229733,
  0.230892, 0.23203, 0.233148, 0.234244, 0.23532, 0.236374, 0.237406,
  0.238418, 0.239408, 0.240376, 0.241322, 0.242247, 0.24315, 0.24403,
  0.244889, 0.245725, 0.246539, 0.247331, 0.2481, 0.248847, 0.249571,
  0.250273, 0.250952, 0.251608, 0.252241, 0.252851, 0.253438,
  0.254002, 0.254542, 0.25506, 0.255554, 0.256025, 0.256472, 0.256896,
  0.257297, 0.257674, 0.258027, 0.258357, 0.258663, 0.258945,
  0.259203, 0.259438, 0.259648, 0.259835, 0.259998, 0.260137,
  0.260252, 0.260343, 0.26041, 0.260453, 0.260471, 0.260466, 0.260437,
  0.260383, 0.260305, 0.260204, 0.260078, 0.259927, 0.259753,
  0.259555, 0.259332, 0.259085, 0.258814, 0.258519, 0.2582, 0.257856,
  0.257489, 0.257097, 0.256681, 0.256242, 0.255778, 0.25529, 0.254778,
  0.254243, 0.253683, 0.253099, 0.252492, 0.25186, 0.251205, 0.250526,
  0.249824, 0.249098, 0.248348, 0.247574, 0.246777, 0.245957,
  0.245113, 0.244246, 0.243356, 0.242442, 0.241505, 0.240545,
  0.239563, 0.238557, 0.237528, 0.236476, 0.235402, 0.234305,
  0.233186, 0.232044, 0.230879, 0.229692, 0.228483, 0.227252,
  0.225999, 0.224724, 0.223427, 0.222108, 0.220768, 0.219406,
  0.218023, 0.216618, 0.215192, 0.213745, 0.212278, 0.210789,
  0.209279, 0.207749, 0.206198, 0.204627, 0.203036, 0.201424,
  0.199793, 0.198141, 0.19647, 0.194779, 0.193069, 0.191339, 0.189591,
  0.187823, 0.186036, 0.184231, 0.182407, 0.180564, 0.178703,
  0.176824, 0.174928, 0.173013, 0.17108, 0.169131, 0.167163, 0.165179,
  0.163178, 0.161159, 0.159124, 0.157073, 0.155005, 0.152922,
  0.150822, 0.148706, 0.146575, 0.144429, 0.142267, 0.14009, 0.137898,
  0.135692, 0.133471, 0.131236, 0.128987, 0.126724, 0.124448,
  0.122158, 0.119854, 0.117538, 0.115208, 0.112866, 0.110512,
  0.108145, 0.105767, 0.103376, 0.100974, 0.0985605, 0.0961359,
  0.0937003, 0.0912539, 0.0887971, 0.0863299, 0.0838527, 0.0813657,
  0.0788691, 0.0763631, 0.0738479, 0.0713238, 0.0687911, 0.0662498,
  0.0637004, 0.061143, 0.0585778, 0.0560051, 0.0534251, 0.0508382,
  0.0482444, 0.0456441, 0.0430375, 0.0404248, 0.0378063, 0.0351823,
  0.0325529, 0.0299185, 0.0272793, 0.0246355, 0.0219874, 0.0193352,
  0.0166793, 0.0140197, 0.0113569, 0.00869106, 0.00602242, 0.00335126,
  0.000677837, -0.00199759, -0.00467476, -0.00735342, -0.0100333,
  -0.0127141, -0.0153957, -0.0180776, -0.0207597, -0.0234418,
  -0.0261234, -0.0288045, -0.0314846, -0.0341636, -0.0368411,
  -0.039517, -0.0421908, -0.0448625, -0.0475316, -0.050198,
  -0.0528613, -0.0555212, -0.0581776, -0.0608301, -0.0634785,
  -0.0661225, -0.0687618, -0.0713962, -0.0740254, -0.076649,
  -0.0792669, -0.0818787, -0.0844843, -0.0870832, -0.0896753,
  -0.0922603, -0.0948378, -0.0974077, -0.0999696, -0.102523,
  -0.105069, -0.107605, -0.110132, -0.11265, -0.115159, -0.117658,
  -0.120146, -0.122624, -0.125092, -0.127548, -0.129993, -0.132427,
  -0.134849, -0.137259, -0.139657, -0.142042, -0.144415, -0.146774,
  -0.14912, -0.151452, -0.153771, -0.156075, -0.158365, -0.16064,
  -0.1629, -0.165145, -0.167375, -0.169589, -0.171787, -0.173968,
  -0.176133, -0.178282, -0.180413, -0.182527, -0.184624, -0.186703,
  -0.188764, -0.190806, -0.19283, -0.194835, -0.196822, -0.198789,
  -0.200736, -0.202664, -0.204572, -0.206459, -0.208326, -0.210172,
  -0.211998, -0.213802, -0.215585, -0.217346, -0.219085, -0.220802,
  -0.222497, -0.22417, -0.225819, -0.227445, -0.229049, -0.230629,
  -0.232185, -0.233717, -0.235225, -0.236709, -0.238168, -0.239603,
  -0.241013, -0.242397, -0.243756, -0.24509, -0.246398, -0.24768,
  -0.248936, -0.250165, -0.251369, -0.252545, -0.253694, -0.254817,
  -0.255912, -0.256979, -0.258019, -0.259032, -0.260016, -0.260972,
  -0.2619, -0.262799, -0.26367, -0.264512, -0.265325, -0.266109,
  -0.266864, -0.267589, -0.268285, -0.268951, -0.269587, -0.270193,
  -0.270769, -0.271315, -0.271831, -0.272315, -0.27277, -0.273193,
  -0.273586, -0.273948, -0.274278, -0.274577, -0.274845, -0.275082,
  -0.275287, -0.27546, -0.275601, -0.275711, -0.275789, -0.275835,
  -0.275848, -0.27583, -0.275779, -0.275696, -0.27558, -0.275432,
  -0.275252, -0.275039, -0.274793, -0.274515, -0.274203, -0.273859,
  -0.273482, -0.273072, -0.27263, -0.272154, -0.271645, -0.271103,
  -0.270529, -0.269921, -0.26928, -0.268606, -0.267899, -0.267158,
  -0.266385, -0.265578, -0.264739, -0.263866, -0.26296, -0.262021,
  -0.26105, -0.260045, -0.259007, -0.257936, -0.256832, -0.255695,
  -0.254526, -0.253324, -0.252088, -0.250821, -0.24952, -0.248188,
  -0.246822, -0.245424, -0.243994, -0.242532, -0.241037, -0.239511,
  -0.237952, -0.236361, -0.234739, -0.233085, -0.231399, -0.229682,
  -0.227934, -0.226154, -0.224343, -0.222502, -0.220629, -0.218726,
  -0.216792, -0.214828, -0.212833, -0.210809, -0.208754, -0.20667,
  -0.204556, -0.202412, -0.20024, -0.198038, -0.195807, -0.193548,
  -0.19126, -0.188944, -0.1866, -0.184228, -0.181828, -0.179401,
  -0.176946, -0.174465, -0.171956, -0.169421, -0.16686, -0.164273,
  -0.16166, -0.159021, -0.156357, -0.153668, -0.150954, -0.148215,
  -0.145453, -0.142666, -0.139856, -0.137022, -0.134165, -0.131285,
  -0.128383, -0.125458, -0.122512, -0.119544, -0.116555, -0.113545,
  -0.110514, -0.107462, -0.104391, -0.101301, -0.0981906, -0.0950616,
  -0.091914, -0.0887482, -0.0855645, -0.0823633, -0.079145,
  -0.0759099, -0.0726584, -0.0693909, -0.0661078, -0.0628094,
  -0.0594962, -0.0561686, -0.0528269, -0.0494716, -0.046103,
  -0.0427217, -0.0393279, -0.0359222, -0.032505, -0.0290766,
  -0.0256375, -0.0221882, -0.0187291, -0.0152607, -0.0117833,
  -0.0082975, -0.00480369, -0.00130234, 0.00220608, 0.0057211,
  0.00924226, 0.0127691, 0.0163011, 0.0198377, 0.0233786, 0.0269232,
  0.0304711, 0.0340216, 0.0375744, 0.0411289, 0.0446847, 0.0482411,
  0.0517977, 0.055354, 0.0589095, 0.0624636, 0.0660158, 0.0695656,
  0.0731125, 0.0766558, 0.0801952, 0.0837299, 0.0872596, 0.0907836,
  0.0943014, 0.0978125, 0.101316, 0.104812, 0.1083, 0.111778,
  0.115247, 0.118706, 0.122154, 0.125591, 0.129016, 0.132428,
  0.135828, 0.139214, 0.142586, 0.145943, 0.149285, 0.152611, 0.15592,
  0.159212, 0.162487, 0.165743, 0.168981, 0.172199, 0.175397,
  0.178574, 0.18173, 0.184864, 0.187976, 0.191065, 0.19413, 0.197171,
  0.200186, 0.203177, 0.206141, 0.209078, 0.211989, 0.214871,
  0.217725, 0.220549, 0.223344, 0.226109, 0.228842, 0.231544,
  0.234214, 0.236851, 0.239454, 0.242024, 0.244559, 0.247059,
  0.249523, 0.25195, 0.254341, 0.256694, 0.259008, 0.261284, 0.26352,
  0.265717, 0.267873, 0.269987, 0.27206, 0.27409, 0.276078, 0.278022,
  0.279921, 0.281776, 0.283586, 0.28535, 0.287068, 0.288738, 0.290361,
  0.291936, 0.293462, 0.294939, 0.296366, 0.297743, 0.299069,
  0.300343, 0.301566, 0.302736, 0.303853, 0.304917, 0.305926,
  0.306881, 0.307781, 0.308626, 0.309414, 0.310146, 0.310821,
  0.311438, 0.311997, 0.312498, 0.31294, 0.313322, 0.313645, 0.313907,
  0.314109, 0.314249, 0.314328, 0.314345, 0.3143, 0.314192, 0.314021,
  0.313786, 0.313487, 0.313124, 0.312696, 0.312203, 0.311645,
  0.311022, 0.310332, 0.309576, 0.308753, 0.307863, 0.306907,
  0.305882, 0.30479, 0.30363, 0.302402, 0.301105, 0.29974, 0.298305,
  0.296802, 0.295229, 0.293587, 0.291875, 0.290094, 0.288242,
  0.286321, 0.284329, 0.282267, 0.280135, 0.277932, 0.275659,
  0.273315, 0.270901, 0.268416, 0.265861, 0.263235, 0.260539,
  0.257772, 0.254935, 0.252028, 0.24905, 0.246002, 0.242884, 0.239696,
  0.236439, 0.233112, 0.229716, 0.22625, 0.222716, 0.219113, 0.215442,
  0.211702, 0.207895, 0.204021, 0.200079, 0.196071, 0.191996,
  0.187855, 0.183649, 0.179378, 0.175042, 0.170642, 0.166179,
  0.161652, 0.157063, 0.152412, 0.1477, 0.142927, 0.138094, 0.133201,
  0.12825, 0.123242, 0.118175, 0.113053, 0.107875, 0.102642,
  0.0973551, 0.0920153, 0.0866233, 0.0811801, 0.0756867, 0.070144,
  0.064553, 0.0589149, 0.0532306, 0.0475013, 0.0417281, 0.0359123,
  0.0300548, 0.0241571, 0.0182203, 0.0122457, 0.00623474, 0.000188626,
  -0.00589121, -0.0120034, -0.0181464, -0.0243187, -0.030519,
  -0.0367456, -0.0429969, -0.0492713, -0.0555672, -0.0618828,
  -0.0682166, -0.0745666, -0.0809311, -0.0873082, -0.0936961,
  -0.100093, -0.106497, -0.112905, -0.119317, -0.125729, -0.13214,
  -0.138548, -0.14495, -0.151345, -0.157729, -0.1641, -0.170457,
  -0.176797, -0.183117, -0.189416, -0.195689, -0.201935, -0.208152,
  -0.214335, -0.220484, -0.226595, -0.232665, -0.238691, -0.244671,
  -0.250601, -0.256479, -0.262301, -0.268064, -0.273766, -0.279403,
  -0.284972, -0.290469, -0.295891, -0.301235, -0.306497, -0.311673,
  -0.316761, -0.321757, -0.326656, -0.331455, -0.336151, -0.340739,
  -0.345216, -0.349578, -0.353819, -0.357938, -0.361929, -0.365788,
  -0.36951, -0.373093, -0.376531, -0.379819, -0.382953, -0.38593,
  -0.388743, -0.391389, -0.393862, -0.396158, -0.398271, -0.400198,
  -0.401933, -0.40347, -0.404805, -0.405932, -0.406846, -0.407542,
  -0.408014, -0.408256, -0.408264, -0.408031, -0.407552, -0.406821,
  -0.405832, -0.404579, -0.403056, -0.401257, -0.399175, -0.396805,
  -0.394141, -0.391174, -0.3879, -0.384312, -0.380402, -0.376165,
  -0.371593, -0.36668, -0.361417, -0.3558, -0.349819, -0.343469,
  -0.336741, -0.329628, -0.322123, -0.314218, -0.305905, -0.297177,
  -0.288026, -0.278444, -0.268422, -0.257953, -0.247028, -0.235639,
  -0.223778, -0.211436, -0.198604, -0.185274, -0.171437, -0.157084,
  -0.142206, -0.126794, -0.110839, -0.0943308, -0.0772607, -0.0596189,
  -0.041396, -0.0225821, -0.0031675, 0.0168579, 0.037504, 0.058781,
  0.0806992, 0.103269, 0.126501, 0.150405, 0.174993, 0.200275,
  0.226262, 0.252966, 0.280396, 0.308565, 0.337484, 0.367165,
  0.397619, 0.428858, 0.460893, 0.493738, 0.527403, 0.561902,
  0.597246, 0.633447, 0.67052, 0.708476, 0.747328, 0.78709, 0.827774,
  0.869393, 0.911962, 0.955493, 1}; G4double
  G4NeutronHPFastLegendre::i9[2001] = {0, -0.000977662, -0.00191131,
  -0.0028019, -0.0036504, -0.00445776, -0.00522489, -0.00595271,
  -0.00664213, -0.00729404, -0.00790931, -0.00848881, -0.00903339,
  -0.00954389, -0.0100211, -0.0104659, -0.0108791, -0.0112614,
  -0.0116137, -0.0119367, -0.0122311, -0.0124977, -0.0127372,
  -0.0129505, -0.013138, -0.0133007, -0.0134391, -0.0135539,
  -0.0136458, -0.0137155, -0.0137636, -0.0137907, -0.0137975,
  -0.0137846, -0.0137525, -0.013702, -0.0136335, -0.0135477,
  -0.013445, -0.0133262, -0.0131916, -0.0130419, -0.0128776,
  -0.0126992, -0.0125072, -0.0123022, -0.0120845, -0.0118548,
  -0.0116134, -0.0113609, -0.0110976, -0.0108242, -0.0105409,
  -0.0102483, -0.00994668, -0.00963658, -0.00931838, -0.00899247,
  -0.00865925, -0.00831911, -0.00797244, -0.0076196, -0.00726096,
  -0.00689688, -0.00652771, -0.0061538, -0.00577549, -0.00539311,
  -0.00500697, -0.00461741, -0.00422473, -0.00382923, -0.00343121,
  -0.00303097, -0.00262879, -0.00222495, -0.00181972, -0.00141337,
  -0.00100616, -0.000598349, -0.00019018, 0.000218101, 0.000626256,
  0.00103405, 0.00144127, 0.00184767, 0.00225306, 0.00265721,
  0.00305993, 0.00346101, 0.00386027, 0.0042575, 0.00465252,
  0.00504516, 0.00543524, 0.00582259, 0.00620705, 0.00658845,
  0.00696664, 0.00734146, 0.00771277, 0.00808043, 0.0084443,
  0.00880425, 0.00916014, 0.00951185, 0.00985925, 0.0102022,
  0.0105407, 0.0108745, 0.0112036, 0.0115278, 0.0118471, 0.0121613,
  0.0124704, 0.0127742, 0.0130728, 0.013366, 0.0136537, 0.0139359,
  0.0142125, 0.0144834, 0.0147486, 0.015008, 0.0152616, 0.0155092,
  0.0157509, 0.0159866, 0.0162162, 0.0164397, 0.0166572, 0.0168684,
  0.0170734, 0.0172723, 0.0174648, 0.0176511, 0.017831, 0.0180047,
  0.018172, 0.0183329, 0.0184874, 0.0186356, 0.0187773, 0.0189126,
  0.0190416, 0.0191641, 0.0192802, 0.0193899, 0.0194932, 0.0195901,
  0.0196806, 0.0197647, 0.0198425, 0.0199139, 0.0199789, 0.0200376,
  0.0200901, 0.0201362, 0.0201761, 0.0202097, 0.0202371, 0.0202583,
  0.0202734, 0.0202823, 0.0202852, 0.020282, 0.0202727, 0.0202575,
  0.0202363, 0.0202092, 0.0201762, 0.0201374, 0.0200928, 0.0200424,
  0.0199863, 0.0199246, 0.0198572, 0.0197843, 0.0197059, 0.019622,
  0.0195326, 0.019438, 0.019338, 0.0192327, 0.0191222, 0.0190066,
  0.0188859, 0.0187601, 0.0186294, 0.0184938, 0.0183532, 0.0182079,
  0.0180579, 0.0179031, 0.0177438, 0.0175798, 0.0174114, 0.0172386,
  0.0170614, 0.0168798, 0.0166941, 0.0165041, 0.0163101, 0.016112,
  0.01591, 0.015704, 0.0154942, 0.0152806, 0.0150633, 0.0148424,
  0.0146179, 0.0143899, 0.0141585, 0.0139237, 0.0136857, 0.0134444,
  0.0131999, 0.0129524, 0.0127019, 0.0124484, 0.012192, 0.0119328,
  0.0116709, 0.0114064, 0.0111392, 0.0108696, 0.0105975, 0.010323,
  0.0100462, 0.00976714, 0.00948593, 0.00920262, 0.00891729,
  0.00863001, 0.00834083, 0.00804984, 0.0077571, 0.00746269,
  0.00716667, 0.00686911, 0.00657008, 0.00626965, 0.00596789,
  0.00566487, 0.00536065, 0.00505531, 0.00474891, 0.00444152,
  0.00413321, 0.00382404, 0.00351408, 0.00320339, 0.00289206,
  0.00258013, 0.00226767, 0.00195475, 0.00164144, 0.0013278,
  0.00101389, 0.000699781, 0.00038553, 7.12019e-05, -0.00024314,
  -0.000557434, -0.000871619, -0.00118563, -0.00149941, -0.0018129,
  -0.00212604, -0.00243876, -0.00275101, -0.00306274, -0.00337387,
  -0.00368436, -0.00399414, -0.00430317, -0.00461138, -0.00491871,
  -0.00522512, -0.00553055, -0.00583494, -0.00613824, -0.00644039,
  -0.00674135, -0.00704106, -0.00733947, -0.00763653, -0.00793219,
  -0.00822639, -0.0085191, -0.00881025, -0.0090998, -0.00938771,
  -0.00967392, -0.00995839, -0.0102411, -0.0105219, -0.0108009,
  -0.011078, -0.011353, -0.0116261, -0.0118972, -0.0121661,
  -0.0124329, -0.0126975, -0.0129599, -0.0132201, -0.0134779,
  -0.0137334, -0.0139866, -0.0142373, -0.0144856, -0.0147314,
  -0.0149747, -0.0152155, -0.0154536, -0.0156892, -0.015922,
  -0.0161522, -0.0163797, -0.0166044, -0.0168264, -0.0170455,
  -0.0172618, -0.0174753, -0.0176858, -0.0178934, -0.0180981,
  -0.0182998, -0.0184984, -0.0186941, -0.0188867, -0.0190762,
  -0.0192626, -0.0194459, -0.0196261, -0.0198031, -0.0199769,
  -0.0201475, -0.0203148, -0.0204789, -0.0206398, -0.0207974,
  -0.0209516, -0.0211026, -0.0212502, -0.0213945, -0.0215354,
  -0.0216729, -0.021807, -0.0219377, -0.022065, -0.0221889,
  -0.0223093, -0.0224263, -0.0225398, -0.0226499, -0.0227564,
  -0.0228595, -0.0229591, -0.0230551, -0.0231477, -0.0232367,
  -0.0233222, -0.0234041, -0.0234826, -0.0235575, -0.0236288,
  -0.0236966, -0.0237608, -0.0238215, -0.0238786, -0.0239322,
  -0.0239822, -0.0240287, -0.0240716, -0.024111, -0.0241468,
  -0.024179, -0.0242077, -0.0242328, -0.0242545, -0.0242725,
  -0.0242871, -0.0242981, -0.0243055, -0.0243095, -0.02431,
  -0.0243069, -0.0243004, -0.0242903, -0.0242768, -0.0242598,
  -0.0242393, -0.0242154, -0.0241881, -0.0241573, -0.0241231,
  -0.0240854, -0.0240444, -0.024, -0.0239522, -0.0239011, -0.0238466,
  -0.0237887, -0.0237276, -0.0236631, -0.0235954, -0.0235243,
  -0.02345, -0.0233725, -0.0232918, -0.0232078, -0.0231206,
  -0.0230303, -0.0229368, -0.0228402, -0.0227404, -0.0226376,
  -0.0225317, -0.0224227, -0.0223106, -0.0221956, -0.0220775,
  -0.0219565, -0.0218325, -0.0217056, -0.0215758, -0.021443,
  -0.0213074, -0.021169, -0.0210277, -0.0208837, -0.0207368,
  -0.0205873, -0.0204349, -0.0202799, -0.0201222, -0.0199619,
  -0.0197989, -0.0196334, -0.0194652, -0.0192945, -0.0191213,
  -0.0189456, -0.0187674, -0.0185868, -0.0184038, -0.0182184,
  -0.0180306, -0.0178405, -0.0176481, -0.0174534, -0.0172565,
  -0.0170573, -0.016856, -0.0166525, -0.0164469, -0.0162392,
  -0.0160294, -0.0158176, -0.0156038, -0.0153879, -0.0151702,
  -0.0149505, -0.0147289, -0.0145055, -0.0142803, -0.0140532,
  -0.0138244, -0.0135939, -0.0133616, -0.0131277, -0.0128921,
  -0.012655, -0.0124162, -0.012176, -0.0119342, -0.0116909,
  -0.0114462, -0.0112001, -0.0109526, -0.0107037, -0.0104535,
  -0.0102021, -0.00994937, -0.00969544, -0.00944033, -0.00918407,
  -0.00892668, -0.0086682, -0.00840868, -0.00814813, -0.00788659,
  -0.00762409, -0.00736068, -0.00709637, -0.00683121, -0.00656523,
  -0.00629845, -0.00603092, -0.00576267, -0.00549372, -0.00522412,
  -0.00495389, -0.00468307, -0.00441169, -0.00413979, -0.0038674,
  -0.00359454, -0.00332126, -0.00304759, -0.00277356, -0.00249919,
  -0.00222454, -0.00194962, -0.00167447, -0.00139912, -0.00112362,
  -0.000847975, -0.000572234, -0.000296427, -2.05853e-05, 0.000255259,
  0.000531074, 0.000806826, 0.00108249, 0.00135802, 0.00163339,
  0.00190858, 0.00218355, 0.00245826, 0.00273269, 0.00300681,
  0.00328058, 0.00355397, 0.00382695, 0.0040995, 0.00437157,
  0.00464315, 0.00491419, 0.00518468, 0.00545457, 0.00572384,
  0.00599246, 0.0062604, 0.00652763, 0.00679412, 0.00705984,
  0.00732476, 0.00758886, 0.00785209, 0.00811445, 0.00837588,
  0.00863638, 0.00889591, 0.00915443, 0.00941194, 0.00966838,
  0.00992375, 0.010178, 0.0104311, 0.0106831, 0.0109339, 0.0111834,
  0.0114317, 0.0116788, 0.0119245, 0.0121689, 0.012412, 0.0126537,
  0.012894, 0.0131329, 0.0133704, 0.0136063, 0.0138408, 0.0140738,
  0.0143052, 0.014535, 0.0147633, 0.0149899, 0.0152149, 0.0154382,
  0.0156599, 0.0158798, 0.016098, 0.0163145, 0.0165292, 0.0167421,
  0.0169532, 0.0171624, 0.0173698, 0.0175753, 0.017779, 0.0179807,
  0.0181804, 0.0183782, 0.0185741, 0.0187679, 0.0189597, 0.0191495,
  0.0193372, 0.0195229, 0.0197065, 0.019888, 0.0200673, 0.0202445,
  0.0204196, 0.0205924, 0.0207631, 0.0209316, 0.0210979, 0.0212619,
  0.0214237, 0.0215832, 0.0217404, 0.0218953, 0.0220479, 0.0221982,
  0.0223462, 0.0224918, 0.022635, 0.0227758, 0.0229143, 0.0230504,
  0.023184, 0.0233152, 0.023444, 0.0235703, 0.0236942, 0.0238156,
  0.0239345, 0.0240509, 0.0241648, 0.0242762, 0.024385, 0.0244914,
  0.0245952, 0.0246964, 0.0247951, 0.0248912, 0.0249848, 0.0250757,
  0.0251641, 0.0252499, 0.0253331, 0.0254137, 0.0254916, 0.025567,
  0.0256397, 0.0257098, 0.0257772, 0.025842, 0.0259041, 0.0259637,
  0.0260205, 0.0260747, 0.0261262, 0.0261751, 0.0262213, 0.0262648,
  0.0263057, 0.0263438, 0.0263793, 0.0264122, 0.0264423, 0.0264698,
  0.0264946, 0.0265167, 0.0265361, 0.0265528, 0.0265669, 0.0265782,
  0.0265869, 0.026593, 0.0265963, 0.026597, 0.0265949, 0.0265903,
  0.0265829, 0.0265729, 0.0265602, 0.0265448, 0.0265268, 0.0265062,
  0.0264828, 0.0264569, 0.0264283, 0.0263971, 0.0263632, 0.0263267,
  0.0262876, 0.0262458, 0.0262015, 0.0261546, 0.026105, 0.0260529,
  0.0259982, 0.0259409, 0.025881, 0.0258186, 0.0257536, 0.0256861,
  0.025616, 0.0255435, 0.0254683, 0.0253907, 0.0253106, 0.025228,
  0.0251429, 0.0250553, 0.0249653, 0.0248728, 0.0247779, 0.0246806,
  0.0245808, 0.0244786, 0.0243741, 0.0242671, 0.0241578, 0.0240461,
  0.023932, 0.0238157, 0.023697, 0.023576, 0.0234527, 0.0233271,
  0.0231992, 0.0230691, 0.0229367, 0.0228022, 0.0226654, 0.0225264,
  0.0223852, 0.0222418, 0.0220963, 0.0219487, 0.0217989, 0.0216471,
  0.0214931, 0.0213371, 0.021179, 0.0210188, 0.0208566, 0.0206925,
  0.0205263, 0.0203581, 0.020188, 0.020016, 0.019842, 0.0196661,
  0.0194884, 0.0193087, 0.0191272, 0.0189439, 0.0187588, 0.0185719,
  0.0183832, 0.0181927, 0.0180005, 0.0178066, 0.0176109, 0.0174136,
  0.0172147, 0.017014, 0.0168118, 0.016608, 0.0164026, 0.0161956,
  0.0159871, 0.015777, 0.0155655, 0.0153525, 0.015138, 0.0149221,
  0.0147048, 0.0144861, 0.014266, 0.0140445, 0.0138218, 0.0135977,
  0.0133723, 0.0131457, 0.0129178, 0.0126887, 0.0124585, 0.012227,
  0.0119944, 0.0117606, 0.0115258, 0.0112898, 0.0110528, 0.0108148,
  0.0105757, 0.0103357, 0.0100946, 0.00985266, 0.00960976, 0.00936596,
  0.00912128, 0.00887574, 0.00862937, 0.00838219, 0.00813423,
  0.00788551, 0.00763604, 0.00738587, 0.007135, 0.00688346,
  0.00663129, 0.00637849, 0.0061251, 0.00587113, 0.00561662,
  0.00536158, 0.00510605, 0.00485003, 0.00459357, 0.00433668,
  0.00407938, 0.00382171, 0.00356368, 0.00330532, 0.00304665,
  0.0027877, 0.00252849, 0.00226904, 0.00200939, 0.00174954,
  0.00148954, 0.0012294, 0.000969139, 0.000708793, 0.000448381,
  0.000187927, -7.25435e-05, -0.000333008, -0.000593441, -0.00085382,
  -0.00111412, -0.00137432, -0.00163439, -0.0018943, -0.00215405,
  -0.00241359, -0.00267292, -0.00293199, -0.0031908, -0.00344931,
  -0.0037075, -0.00396535, -0.00422284, -0.00447994, -0.00473663,
  -0.00499288, -0.00524867, -0.00550398, -0.00575878, -0.00601306,
  -0.00626678, -0.00651992, -0.00677247, -0.0070244, -0.00727568,
  -0.00752629, -0.00777622, -0.00802543, -0.0082739, -0.00852162,
  -0.00876856, -0.00901469, -0.00926, -0.00950446, -0.00974806,
  -0.00999076, -0.0102325, -0.0104734, -0.0107133, -0.0109522,
  -0.0111901, -0.011427, -0.0116629, -0.0118976, -0.0121313,
  -0.0123639, -0.0125954, -0.0128257, -0.0130548, -0.0132828,
  -0.0135095, -0.0137351, -0.0139593, -0.0141823, -0.014404,
  -0.0146244, -0.0148435, -0.0150612, -0.0152775, -0.0154924,
  -0.015706, -0.0159181, -0.0161287, -0.0163379, -0.0165456,
  -0.0167519, -0.0169565, -0.0171597, -0.0173613, -0.0175613,
  -0.0177597, -0.0179565, -0.0181517, -0.0183452, -0.0185371,
  -0.0187273, -0.0189157, -0.0191025, -0.0192876, -0.0194709,
  -0.0196524, -0.0198321, -0.0200101, -0.0201862, -0.0203605,
  -0.020533, -0.0207036, -0.0208723, -0.0210392, -0.0212041,
  -0.0213672, -0.0215282, -0.0216874, -0.0218446, -0.0219998,
  -0.022153, -0.0223042, -0.0224534, -0.0226006, -0.0227457,
  -0.0228888, -0.0230298, -0.0231687, -0.0233056, -0.0234403,
  -0.0235729, -0.0237034, -0.0238317, -0.0239579, -0.024082,
  -0.0242038, -0.0243235, -0.024441, -0.0245563, -0.0246693,
  -0.0247801, -0.0248887, -0.0249951, -0.0250992, -0.025201,
  -0.0253006, -0.0253979, -0.0254929, -0.0255856, -0.025676,
  -0.0257641, -0.0258498, -0.0259332, -0.0260143, -0.0260931,
  -0.0261695, -0.0262435, -0.0263152, -0.0263845, -0.0264514,
  -0.026516, -0.0265781, -0.0266379, -0.0266952, -0.0267502,
  -0.0268028, -0.0268529, -0.0269006, -0.0269459, -0.0269888,
  -0.0270292, -0.0270672, -0.0271028, -0.0271359, -0.0271666,
  -0.0271949, -0.0272207, -0.027244, -0.0272649, -0.0272834,
  -0.0272994, -0.0273129, -0.027324, -0.0273326, -0.0273387,
  -0.0273424, -0.0273436, -0.0273424, -0.0273387, -0.0273326,
  -0.027324, -0.0273129, -0.0272994, -0.0272834, -0.0272649,
  -0.027244, -0.0272207, -0.0271949, -0.0271666, -0.0271359,
  -0.0271028, -0.0270672, -0.0270292, -0.0269888, -0.0269459,
  -0.0269006, -0.0268529, -0.0268028, -0.0267502, -0.0266952,
  -0.0266379, -0.0265781, -0.026516, -0.0264514, -0.0263845,
  -0.0263152, -0.0262435, -0.0261695, -0.0260931, -0.0260143,
  -0.0259332, -0.0258498, -0.0257641, -0.025676, -0.0255856,
  -0.0254929, -0.0253979, -0.0253006, -0.025201, -0.0250992,
  -0.0249951, -0.0248887, -0.0247801, -0.0246693, -0.0245563,
  -0.024441, -0.0243235, -0.0242038, -0.024082, -0.0239579,
  -0.0238317, -0.0237034, -0.0235729, -0.0234403, -0.0233056,
  -0.0231687, -0.0230298, -0.0228888, -0.0227457, -0.0226006,
  -0.0224534, -0.0223042, -0.022153, -0.0219998, -0.0218446,
  -0.0216874, -0.0215282, -0.0213672, -0.0212041, -0.0210392,
  -0.0208723, -0.0207036, -0.020533, -0.0203605, -0.0201862,
  -0.0200101, -0.0198321, -0.0196524, -0.0194709, -0.0192876,
  -0.0191025, -0.0189157, -0.0187273, -0.0185371, -0.0183452,
  -0.0181517, -0.0179565, -0.0177597, -0.0175613, -0.0173613,
  -0.0171597, -0.0169565, -0.0167519, -0.0165456, -0.0163379,
  -0.0161287, -0.0159181, -0.015706, -0.0154924, -0.0152775,
  -0.0150612, -0.0148435, -0.0146244, -0.014404, -0.0141823,
  -0.0139593, -0.0137351, -0.0135095, -0.0132828, -0.0130548,
  -0.0128257, -0.0125954, -0.0123639, -0.0121313, -0.0118976,
  -0.0116629, -0.011427, -0.0111901, -0.0109522, -0.0107133,
  -0.0104734, -0.0102325, -0.00999076, -0.00974806, -0.00950446,
  -0.00926, -0.00901469, -0.00876856, -0.00852162, -0.0082739,
  -0.00802543, -0.00777622, -0.00752629, -0.00727568, -0.0070244,
  -0.00677247, -0.00651992, -0.00626678, -0.00601306, -0.00575878,
  -0.00550398, -0.00524867, -0.00499288, -0.00473663, -0.00447994,
  -0.00422284, -0.00396535, -0.0037075, -0.00344931, -0.0031908,
  -0.00293199, -0.00267292, -0.00241359, -0.00215405, -0.0018943,
  -0.00163439, -0.00137432, -0.00111412, -0.00085382, -0.000593441,
  -0.000333008, -7.25435e-05, 0.000187927, 0.000448381, 0.000708793,
  0.000969139, 0.0012294, 0.00148954, 0.00174954, 0.00200939,
  0.00226904, 0.00252849, 0.0027877, 0.00304665, 0.00330532,
  0.00356368, 0.00382171, 0.00407938, 0.00433668, 0.00459357,
  0.00485003, 0.00510605, 0.00536158, 0.00561662, 0.00587113,
  0.0061251, 0.00637849, 0.00663129, 0.00688346, 0.007135, 0.00738587,
  0.00763604, 0.00788551, 0.00813423, 0.00838219, 0.00862937,
  0.00887574, 0.00912128, 0.00936596, 0.00960976, 0.00985266,
  0.0100946, 0.0103357, 0.0105757, 0.0108148, 0.0110528, 0.0112898,
  0.0115258, 0.0117606, 0.0119944, 0.012227, 0.0124585, 0.0126887,
  0.0129178, 0.0131457, 0.0133723, 0.0135977, 0.0138218, 0.0140445,
  0.014266, 0.0144861, 0.0147048, 0.0149221, 0.015138, 0.0153525,
  0.0155655, 0.015777, 0.0159871, 0.0161956, 0.0164026, 0.016608,
  0.0168118, 0.017014, 0.0172147, 0.0174136, 0.0176109, 0.0178066,
  0.0180005, 0.0181927, 0.0183832, 0.0185719, 0.0187588, 0.0189439,
  0.0191272, 0.0193087, 0.0194884, 0.0196661, 0.019842, 0.020016,
  0.020188, 0.0203581, 0.0205263, 0.0206925, 0.0208566, 0.0210188,
  0.021179, 0.0213371, 0.0214931, 0.0216471, 0.0217989, 0.0219487,
  0.0220963, 0.0222418, 0.0223852, 0.0225264, 0.0226654, 0.0228022,
  0.0229367, 0.0230691, 0.0231992, 0.0233271, 0.0234527, 0.023576,
  0.023697, 0.0238157, 0.023932, 0.0240461, 0.0241578, 0.0242671,
  0.0243741, 0.0244786, 0.0245808, 0.0246806, 0.0247779, 0.0248728,
  0.0249653, 0.0250553, 0.0251429, 0.025228, 0.0253106, 0.0253907,
  0.0254683, 0.0255435, 0.025616, 0.0256861, 0.0257536, 0.0258186,
  0.025881, 0.0259409, 0.0259982, 0.0260529, 0.026105, 0.0261546,
  0.0262015, 0.0262458, 0.0262876, 0.0263267, 0.0263632, 0.0263971,
  0.0264283, 0.0264569, 0.0264828, 0.0265062, 0.0265268, 0.0265448,
  0.0265602, 0.0265729, 0.0265829, 0.0265903, 0.0265949, 0.026597,
  0.0265963, 0.026593, 0.0265869, 0.0265782, 0.0265669, 0.0265528,
  0.0265361, 0.0265167, 0.0264946, 0.0264698, 0.0264423, 0.0264122,
  0.0263793, 0.0263438, 0.0263057, 0.0262648, 0.0262213, 0.0261751,
  0.0261262, 0.0260747, 0.0260205, 0.0259637, 0.0259041, 0.025842,
  0.0257772, 0.0257098, 0.0256397, 0.025567, 0.0254916, 0.0254137,
  0.0253331, 0.0252499, 0.0251641, 0.0250757, 0.0249848, 0.0248912,
  0.0247951, 0.0246964, 0.0245952, 0.0244914, 0.024385, 0.0242762,
  0.0241648, 0.0240509, 0.0239345, 0.0238156, 0.0236942, 0.0235703,
  0.023444, 0.0233152, 0.023184, 0.0230504, 0.0229143, 0.0227758,
  0.022635, 0.0224918, 0.0223462, 0.0221982, 0.0220479, 0.0218953,
  0.0217404, 0.0215832, 0.0214237, 0.0212619, 0.0210979, 0.0209316,
  0.0207631, 0.0205924, 0.0204196, 0.0202445, 0.0200673, 0.019888,
  0.0197065, 0.0195229, 0.0193372, 0.0191495, 0.0189597, 0.0187679,
  0.0185741, 0.0183782, 0.0181804, 0.0179807, 0.017779, 0.0175753,
  0.0173698, 0.0171624, 0.0169532, 0.0167421, 0.0165292, 0.0163145,
  0.016098, 0.0158798, 0.0156599, 0.0154382, 0.0152149, 0.0149899,
  0.0147633, 0.014535, 0.0143052, 0.0140738, 0.0138408, 0.0136063,
  0.0133704, 0.0131329, 0.012894, 0.0126537, 0.012412, 0.0121689,
  0.0119245, 0.0116788, 0.0114317, 0.0111834, 0.0109339, 0.0106831,
  0.0104311, 0.010178, 0.00992375, 0.00966838, 0.00941194, 0.00915443,
  0.00889591, 0.00863638, 0.00837588, 0.00811445, 0.00785209,
  0.00758886, 0.00732476, 0.00705984, 0.00679412, 0.00652763,
  0.0062604, 0.00599246, 0.00572384, 0.00545457, 0.00518468,
  0.00491419, 0.00464315, 0.00437157, 0.0040995, 0.00382695,
  0.00355397, 0.00328058, 0.00300681, 0.00273269, 0.00245826,
  0.00218355, 0.00190858, 0.00163339, 0.00135802, 0.00108249,
  0.000806826, 0.000531074, 0.000255259, -2.05853e-05, -0.000296427,
  -0.000572234, -0.000847975, -0.00112362, -0.00139912, -0.00167447,
  -0.00194962, -0.00222454, -0.00249919, -0.00277356, -0.00304759,
  -0.00332126, -0.00359454, -0.0038674, -0.00413979, -0.00441169,
  -0.00468307, -0.00495389, -0.00522412, -0.00549372, -0.00576267,
  -0.00603092, -0.00629845, -0.00656523, -0.00683121, -0.00709637,
  -0.00736068, -0.00762409, -0.00788659, -0.00814813, -0.00840868,
  -0.0086682, -0.00892668, -0.00918407, -0.00944033, -0.00969544,
  -0.00994937, -0.0102021, -0.0104535, -0.0107037, -0.0109526,
  -0.0112001, -0.0114462, -0.0116909, -0.0119342, -0.012176,
  -0.0124162, -0.012655, -0.0128921, -0.0131277, -0.0133616,
  -0.0135939, -0.0138244, -0.0140532, -0.0142803, -0.0145055,
  -0.0147289, -0.0149505, -0.0151702, -0.0153879, -0.0156038,
  -0.0158176, -0.0160294, -0.0162392, -0.0164469, -0.0166525,
  -0.016856, -0.0170573, -0.0172565, -0.0174534, -0.0176481,
  -0.0178405, -0.0180306, -0.0182184, -0.0184038, -0.0185868,
  -0.0187674, -0.0189456, -0.0191213, -0.0192945, -0.0194652,
  -0.0196334, -0.0197989, -0.0199619, -0.0201222, -0.0202799,
  -0.0204349, -0.0205873, -0.0207368, -0.0208837, -0.0210277,
  -0.021169, -0.0213074, -0.021443, -0.0215758, -0.0217056,
  -0.0218325, -0.0219565, -0.0220775, -0.0221956, -0.0223106,
  -0.0224227, -0.0225317, -0.0226376, -0.0227404, -0.0228402,
  -0.0229368, -0.0230303, -0.0231206, -0.0232078, -0.0232918,
  -0.0233725, -0.02345, -0.0235243, -0.0235954, -0.0236631,
  -0.0237276, -0.0237887, -0.0238466, -0.0239011, -0.0239522, -0.024,
  -0.0240444, -0.0240854, -0.0241231, -0.0241573, -0.0241881,
  -0.0242154, -0.0242393, -0.0242598, -0.0242768, -0.0242903,
  -0.0243004, -0.0243069, -0.02431, -0.0243095, -0.0243055,
  -0.0242981, -0.0242871, -0.0242725, -0.0242545, -0.0242328,
  -0.0242077, -0.024179, -0.0241468, -0.024111, -0.0240716,
  -0.0240287, -0.0239822, -0.0239322, -0.0238786, -0.0238215,
  -0.0237608, -0.0236966, -0.0236288, -0.0235575, -0.0234826,
  -0.0234041, -0.0233222, -0.0232367, -0.0231477, -0.0230551,
  -0.0229591, -0.0228595, -0.0227564, -0.0226499, -0.0225398,
  -0.0224263, -0.0223093, -0.0221889, -0.022065, -0.0219377,
  -0.021807, -0.0216729, -0.0215354, -0.0213945, -0.0212502,
  -0.0211026, -0.0209516, -0.0207974, -0.0206398, -0.0204789,
  -0.0203148, -0.0201475, -0.0199769, -0.0198031, -0.0196261,
  -0.0194459, -0.0192626, -0.0190762, -0.0188867, -0.0186941,
  -0.0184984, -0.0182998, -0.0180981, -0.0178934, -0.0176858,
  -0.0174753, -0.0172618, -0.0170455, -0.0168264, -0.0166044,
  -0.0163797, -0.0161522, -0.015922, -0.0156892, -0.0154536,
  -0.0152155, -0.0149747, -0.0147314, -0.0144856, -0.0142373,
  -0.0139866, -0.0137334, -0.0134779, -0.0132201, -0.0129599,
  -0.0126975, -0.0124329, -0.0121661, -0.0118972, -0.0116261,
  -0.011353, -0.011078, -0.0108009, -0.0105219, -0.0102411,
  -0.00995839, -0.00967392, -0.00938771, -0.0090998, -0.00881025,
  -0.0085191, -0.00822639, -0.00793219, -0.00763653, -0.00733947,
  -0.00704106, -0.00674135, -0.00644039, -0.00613824, -0.00583494,
  -0.00553055, -0.00522512, -0.00491871, -0.00461138, -0.00430317,
  -0.00399414, -0.00368436, -0.00337387, -0.00306274, -0.00275101,
  -0.00243876, -0.00212604, -0.0018129, -0.00149941, -0.00118563,
  -0.000871619, -0.000557434, -0.00024314, 7.12019e-05, 0.00038553,
  0.000699781, 0.00101389, 0.0013278, 0.00164144, 0.00195475,
  0.00226767, 0.00258013, 0.00289206, 0.00320339, 0.00351408,
  0.00382404, 0.00413321, 0.00444152, 0.00474891, 0.00505531,
  0.00536065, 0.00566487, 0.00596789, 0.00626965, 0.00657008,
  0.00686911, 0.00716667, 0.00746269, 0.0077571, 0.00804984,
  0.00834083, 0.00863001, 0.00891729, 0.00920262, 0.00948593,
  0.00976714, 0.0100462, 0.010323, 0.0105975, 0.0108696, 0.0111392,
  0.0114064, 0.0116709, 0.0119328, 0.012192, 0.0124484, 0.0127019,
  0.0129524, 0.0131999, 0.0134444, 0.0136857, 0.0139237, 0.0141585,
  0.0143899, 0.0146179, 0.0148424, 0.0150633, 0.0152806, 0.0154942,
  0.015704, 0.01591, 0.016112, 0.0163101, 0.0165041, 0.0166941,
  0.0168798, 0.0170614, 0.0172386, 0.0174114, 0.0175798, 0.0177438,
  0.0179031, 0.0180579, 0.0182079, 0.0183532, 0.0184938, 0.0186294,
  0.0187601, 0.0188859, 0.0190066, 0.0191222, 0.0192327, 0.019338,
  0.019438, 0.0195326, 0.019622, 0.0197059, 0.0197843, 0.0198572,
  0.0199246, 0.0199863, 0.0200424, 0.0200928, 0.0201374, 0.0201762,
  0.0202092, 0.0202363, 0.0202575, 0.0202727, 0.020282, 0.0202852,
  0.0202823, 0.0202734, 0.0202583, 0.0202371, 0.0202097, 0.0201761,
  0.0201362, 0.0200901, 0.0200376, 0.0199789, 0.0199139, 0.0198425,
  0.0197647, 0.0196806, 0.0195901, 0.0194932, 0.0193899, 0.0192802,
  0.0191641, 0.0190416, 0.0189126, 0.0187773, 0.0186356, 0.0184874,
  0.0183329, 0.018172, 0.0180047, 0.017831, 0.0176511, 0.0174648,
  0.0172723, 0.0170734, 0.0168684, 0.0166572, 0.0164397, 0.0162162,
  0.0159866, 0.0157509, 0.0155092, 0.0152616, 0.015008, 0.0147486,
  0.0144834, 0.0142125, 0.0139359, 0.0136537, 0.013366, 0.0130728,
  0.0127742, 0.0124704, 0.0121613, 0.0118471, 0.0115278, 0.0112036,
  0.0108745, 0.0105407, 0.0102022, 0.00985925, 0.00951185, 0.00916014,
  0.00880425, 0.0084443, 0.00808043, 0.00771277, 0.00734146,
  0.00696664, 0.00658845, 0.00620705, 0.00582259, 0.00543524,
  0.00504516, 0.00465252, 0.0042575, 0.00386027, 0.00346101,
  0.00305993, 0.00265721, 0.00225306, 0.00184767, 0.00144127,
  0.00103405, 0.000626256, 0.000218101, -0.00019018, -0.000598349,
  -0.00100616, -0.00141337, -0.00181972, -0.00222495, -0.00262879,
  -0.00303097, -0.00343121, -0.00382923, -0.00422473, -0.00461741,
  -0.00500697, -0.00539311, -0.00577549, -0.0061538, -0.00652771,
  -0.00689688, -0.00726096, -0.0076196, -0.00797244, -0.00831911,
  -0.00865925, -0.00899247, -0.00931838, -0.00963658, -0.00994668,
  -0.0102483, -0.0105409, -0.0108242, -0.0110976, -0.0113609,
  -0.0116134, -0.0118548, -0.0120845, -0.0123022, -0.0125072,
  -0.0126992, -0.0128776, -0.0130419, -0.0131916, -0.0133262,
  -0.013445, -0.0135477, -0.0136335, -0.013702, -0.0137525,
  -0.0137846, -0.0137975, -0.0137907, -0.0137636, -0.0137155,
  -0.0136458, -0.0135539, -0.0134391, -0.0133007, -0.013138,
  -0.0129505, -0.0127372, -0.0124977, -0.0122311, -0.0119367,
  -0.0116137, -0.0112614, -0.0108791, -0.0104659, -0.0100211,
  -0.00954389, -0.00903339, -0.00848881, -0.00790931, -0.00729404,
  -0.00664213, -0.00595271, -0.00522489, -0.00445776, -0.0036504,
  -0.0028019, -0.00191131, -0.000977662, -2.27682e-18}; G4double
  G4NeutronHPFastLegendre::l10[2201] = {1, 0.95061, 0.902429,
  0.855436, 0.809614, 0.764944, 0.721406, 0.678984, 0.637659,
  0.597413, 0.558229, 0.520089, 0.482977, 0.446874, 0.411765,
  0.377633, 0.344462, 0.312235, 0.280936, 0.250549, 0.221059,
  0.192451, 0.164708, 0.137816, 0.111761, 0.0865266, 0.062099,
  0.0384637, 0.0156065, -0.00648672, -0.0278297, -0.0484363,
  -0.0683199, -0.087494, -0.105972, -0.123766, -0.14089, -0.157357,
  -0.173178, -0.188367, -0.202935, -0.216895, -0.230258, -0.243037,
  -0.255243, -0.266888, -0.277982, -0.288538, -0.298566, -0.308077,
  -0.317081, -0.325591, -0.333615, -0.341164, -0.34825, -0.35488,
  -0.361067, -0.366818, -0.372145, -0.377057, -0.381562, -0.385671,
  -0.389393, -0.392736, -0.395709, -0.398322, -0.400583, -0.4025,
  -0.404082, -0.405337, -0.406274, -0.4069, -0.407224, -0.407253,
  -0.406995, -0.406457, -0.405648, -0.404574, -0.403243, -0.401662,
  -0.399838, -0.397779, -0.39549, -0.392978, -0.390251, -0.387315,
  -0.384176, -0.380841, -0.377316, -0.373607, -0.36972, -0.365661,
  -0.361436, -0.35705, -0.352511, -0.347822, -0.34299, -0.338019,
  -0.332916, -0.327686, -0.322333, -0.316863, -0.31128, -0.30559,
  -0.299797, -0.293907, -0.287923, -0.281851, -0.275694, -0.269458,
  -0.263146, -0.256762, -0.250312, -0.243799, -0.237227, -0.230599,
  -0.223921, -0.217195, -0.210426, -0.203617, -0.196771, -0.189893,
  -0.182985, -0.176051, -0.169095, -0.162119, -0.155127, -0.148121,
  -0.141106, -0.134084, -0.127057, -0.120029, -0.113003, -0.105981,
  -0.0989658, -0.0919603, -0.0849669, -0.0779883, -0.0710268,
  -0.0640849, -0.0571648, -0.0502689, -0.0433995, -0.0365586,
  -0.0297485, -0.0229712, -0.0162288, -0.00952319, -0.00285633,
  0.00376989, 0.0103537, 0.0168932, 0.0233867, 0.0298326, 0.0362291,
  0.0425748, 0.048868, 0.0551073, 0.0612911, 0.0674181, 0.0734869,
  0.0794961, 0.0854445, 0.0913308, 0.0971538, 0.102912, 0.108605,
  0.114231, 0.11979, 0.12528, 0.1307, 0.136049, 0.141327, 0.146532,
  0.151664, 0.156722, 0.161705, 0.166612, 0.171444, 0.176198,
  0.180874, 0.185473, 0.189993, 0.194433, 0.198794, 0.203074,
  0.207274, 0.211392, 0.215429, 0.219384, 0.223256, 0.227047,
  0.230754, 0.234378, 0.237919, 0.241376, 0.24475, 0.248039, 0.251245,
  0.254367, 0.257404, 0.260357, 0.263226, 0.266011, 0.268711,
  0.271327, 0.273858, 0.276306, 0.278669, 0.280949, 0.283144,
  0.285256, 0.287285, 0.289229, 0.291091, 0.29287, 0.294566, 0.29618,
  0.297712, 0.299162, 0.30053, 0.301817, 0.303023, 0.304148, 0.305193,
  0.306159, 0.307045, 0.307852, 0.30858, 0.30923, 0.309803, 0.310298,
  0.310716, 0.311058, 0.311325, 0.311516, 0.311632, 0.311674,
  0.311642, 0.311537, 0.31136, 0.31111, 0.310789, 0.310397, 0.309935,
  0.309404, 0.308803, 0.308134, 0.307397, 0.306593, 0.305722,
  0.304786, 0.303784, 0.302718, 0.301588, 0.300395, 0.299139,
  0.297822, 0.296444, 0.295005, 0.293507, 0.29195, 0.290334, 0.288662,
  0.286932, 0.285146, 0.283305, 0.28141, 0.279461, 0.277459, 0.275404,
  0.273298, 0.271141, 0.268935, 0.266679, 0.264375, 0.262022,
  0.259624, 0.257178, 0.254688, 0.252153, 0.249574, 0.246952,
  0.244288, 0.241583, 0.238837, 0.236051, 0.233226, 0.230362,
  0.227461, 0.224524, 0.22155, 0.218541, 0.215498, 0.212421, 0.209312,
  0.20617, 0.202998, 0.199794, 0.196562, 0.1933, 0.19001, 0.186693,
  0.183349, 0.179979, 0.176585, 0.173166, 0.169724, 0.166259,
  0.162772, 0.159264, 0.155735, 0.152187, 0.14862, 0.145035, 0.141433,
  0.137813, 0.134178, 0.130528, 0.126863, 0.123185, 0.119493, 0.11579,
  0.112074, 0.108349, 0.104612, 0.100867, 0.097113, 0.0933509,
  0.0895816, 0.0858058, 0.0820241, 0.0782372, 0.0744458, 0.0706506,
  0.0668523, 0.0630515, 0.0592489, 0.0554452, 0.051641, 0.0478369,
  0.0440337, 0.040232, 0.0364323, 0.0326354, 0.0288419, 0.0250523,
  0.0212674, 0.0174876, 0.0137137, 0.00994626, 0.00618582, 0.002433,
  -0.00131161, -0.00504743, -0.00877387, -0.0124904, -0.0161964,
  -0.0198913, -0.0235746, -0.0272458, -0.0309042, -0.0345494,
  -0.0381808, -0.0417979, -0.0454002, -0.0489871, -0.0525582,
  -0.0561129, -0.0596507, -0.0631712, -0.0666739, -0.0701583,
  -0.0736238, -0.0770701, -0.0804967, -0.0839031, -0.0872889,
  -0.0906536, -0.0939968, -0.0973181, -0.100617, -0.103893, -0.107146,
  -0.110375, -0.113581, -0.116761, -0.119917, -0.123048, -0.126154,
  -0.129233, -0.132286, -0.135312, -0.138312, -0.141284, -0.144228,
  -0.147144, -0.150032, -0.152891, -0.155721, -0.158522, -0.161293,
  -0.164034, -0.166745, -0.169426, -0.172076, -0.174694, -0.177282,
  -0.179837, -0.182361, -0.184853, -0.187312, -0.189739, -0.192133,
  -0.194494, -0.196821, -0.199115, -0.201375, -0.203602, -0.205794,
  -0.207952, -0.210076, -0.212165, -0.214219, -0.216238, -0.218221,
  -0.22017, -0.222083, -0.22396, -0.225802, -0.227607, -0.229377,
  -0.23111, -0.232807, -0.234468, -0.236092, -0.23768, -0.239231,
  -0.240745, -0.242222, -0.243663, -0.245066, -0.246432, -0.247761,
  -0.249053, -0.250307, -0.251525, -0.252704, -0.253847, -0.254952,
  -0.256019, -0.257049, -0.258042, -0.258997, -0.259914, -0.260794,
  -0.261636, -0.262441, -0.263208, -0.263938, -0.264631, -0.265285,
  -0.265903, -0.266483, -0.267026, -0.267531, -0.268, -0.268431,
  -0.268825, -0.269181, -0.269501, -0.269784, -0.27003, -0.27024,
  -0.270412, -0.270548, -0.270648, -0.270711, -0.270738, -0.270729,
  -0.270683, -0.270602, -0.270484, -0.270331, -0.270143, -0.269919,
  -0.269659, -0.269365, -0.269035, -0.268671, -0.268271, -0.267837,
  -0.267369, -0.266866, -0.266329, -0.265759, -0.265154, -0.264516,
  -0.263844, -0.263139, -0.262401, -0.26163, -0.260827, -0.259991,
  -0.259122, -0.258222, -0.257289, -0.256325, -0.255329, -0.254302,
  -0.253245, -0.252156, -0.251036, -0.249886, -0.248706, -0.247496,
  -0.246257, -0.244987, -0.243689, -0.242361, -0.241005, -0.23962,
  -0.238207, -0.236766, -0.235297, -0.233801, -0.232277, -0.230727,
  -0.229149, -0.227545, -0.225915, -0.224259, -0.222577, -0.22087,
  -0.219138, -0.21738, -0.215599, -0.213792, -0.211962, -0.210108,
  -0.208231, -0.20633, -0.204407, -0.202461, -0.200492, -0.198501,
  -0.196489, -0.194456, -0.192401, -0.190325, -0.188229, -0.186112,
  -0.183976, -0.181819, -0.179644, -0.177449, -0.175236, -0.173004,
  -0.170754, -0.168486, -0.166201, -0.163899, -0.161579, -0.159243,
  -0.156891, -0.154523, -0.152139, -0.14974, -0.147326, -0.144897,
  -0.142454, -0.139996, -0.137525, -0.135041, -0.132543, -0.130032,
  -0.12751, -0.124974, -0.122427, -0.119869, -0.117299, -0.114719,
  -0.112128, -0.109526, -0.106915, -0.104294, -0.101664, -0.099025,
  -0.0963772, -0.0937212, -0.0910571, -0.0883853, -0.0857062,
  -0.0830201, -0.0803272, -0.0776279, -0.0749226, -0.0722115,
  -0.0694949, -0.0667732, -0.0640467, -0.0613157, -0.0585805,
  -0.0558414, -0.0530988, -0.050353, -0.0476042, -0.0448528,
  -0.0420992, -0.0393435, -0.0365862, -0.0338275, -0.0310678,
  -0.0283073, -0.0255464, -0.0227854, -0.0200245, -0.0172641,
  -0.0145045, -0.011746, -0.00898884, -0.00623341, -0.00347997,
  -0.000728816, 0.00201975, 0.00476542, 0.00750792, 0.0102469,
  0.0129822, 0.0157134, 0.0184402, 0.0211624, 0.0238797, 0.0265918,
  0.0292983, 0.0319991, 0.0346938, 0.0373822, 0.0400639, 0.0427387,
  0.0454064, 0.0480666, 0.050719, 0.0533635, 0.0559997, 0.0586273,
  0.0612461, 0.0638559, 0.0664563, 0.0690471, 0.0716281, 0.0741989,
  0.0767594, 0.0793092, 0.0818481, 0.0843759, 0.0868923, 0.0893971,
  0.0918899, 0.0943707, 0.0968391, 0.0992948, 0.101738, 0.104168,
  0.106584, 0.108987, 0.111376, 0.113751, 0.116112, 0.118459, 0.12079,
  0.123107, 0.125409, 0.127695, 0.129966, 0.132221, 0.13446, 0.136683,
  0.138889, 0.141079, 0.143252, 0.145408, 0.147547, 0.149669,
  0.151773, 0.153859, 0.155927, 0.157977, 0.160008, 0.162021,
  0.164016, 0.165991, 0.167948, 0.169885, 0.171803, 0.173701,
  0.175579, 0.177438, 0.179277, 0.181095, 0.182893, 0.184671,
  0.186427, 0.188163, 0.189878, 0.191572, 0.193245, 0.194896,
  0.196526, 0.198134, 0.19972, 0.201284, 0.202827, 0.204347, 0.205845,
  0.20732, 0.208773, 0.210203, 0.21161, 0.212995, 0.214356, 0.215695,
  0.21701, 0.218302, 0.219571, 0.220816, 0.222037, 0.223235, 0.224409,
  0.225559, 0.226686, 0.227788, 0.228866, 0.22992, 0.23095, 0.231956,
  0.232937, 0.233894, 0.234826, 0.235734, 0.236617, 0.237475,
  0.238309, 0.239118, 0.239902, 0.240661, 0.241395, 0.242105,
  0.242789, 0.243448, 0.244083, 0.244692, 0.245276, 0.245835,
  0.246368, 0.246877, 0.24736, 0.247819, 0.248251, 0.248659, 0.249041,
  0.249399, 0.249731, 0.250037, 0.250318, 0.250575, 0.250805,
  0.251011, 0.251191, 0.251346, 0.251476, 0.251581, 0.251661,
  0.251715, 0.251744, 0.251748, 0.251728, 0.251682, 0.251611,
  0.251515, 0.251394, 0.251248, 0.251078, 0.250882, 0.250662,
  0.250417, 0.250148, 0.249854, 0.249535, 0.249192, 0.248824,
  0.248432, 0.248016, 0.247576, 0.247111, 0.246623, 0.24611, 0.245573,
  0.245013, 0.244428, 0.24382, 0.243189, 0.242534, 0.241855, 0.241153,
  0.240428, 0.23968, 0.238908, 0.238114, 0.237297, 0.236457, 0.235594,
  0.234709, 0.233801, 0.232871, 0.231919, 0.230945, 0.229948, 0.22893,
  0.22789, 0.226829, 0.225745, 0.224641, 0.223515, 0.222368, 0.2212,
  0.220011, 0.218802, 0.217572, 0.216321, 0.21505, 0.213759, 0.212448,
  0.211116, 0.209765, 0.208395, 0.207005, 0.205596, 0.204167, 0.20272,
  0.201253, 0.199768, 0.198264, 0.196742, 0.195202, 0.193644,
  0.192068, 0.190474, 0.188862, 0.187233, 0.185587, 0.183924,
  0.182244, 0.180547, 0.178833, 0.177103, 0.175357, 0.173595,
  0.171817, 0.170024, 0.168215, 0.166391, 0.164551, 0.162697,
  0.160828, 0.158944, 0.157046, 0.155134, 0.153207, 0.151267,
  0.149314, 0.147347, 0.145367, 0.143373, 0.141367, 0.139348,
  0.137317, 0.135274, 0.133218, 0.131151, 0.129072, 0.126982, 0.12488,
  0.122767, 0.120644, 0.11851, 0.116365, 0.114211, 0.112046, 0.109872,
  0.107688, 0.105494, 0.103292, 0.10108, 0.0988598, 0.096631,
  0.0943939, 0.0921487, 0.0898955, 0.0876347, 0.0853665, 0.083091,
  0.0808085, 0.0785191, 0.0762231, 0.0739208, 0.0716123, 0.0692978,
  0.0669776, 0.0646519, 0.0623208, 0.0599847, 0.0576437, 0.0552981,
  0.0529481, 0.0505938, 0.0482355, 0.0458735, 0.0435079, 0.041139,
  0.0387669, 0.036392, 0.0340144, 0.0316343, 0.029252, 0.0268677,
  0.0244816, 0.0220939, 0.0197048, 0.0173147, 0.0149235, 0.0125317,
  0.0101394, 0.00774685, 0.00535425, 0.00296181, 0.000569768,
  -0.00182167, -0.00421227, -0.00660183, -0.00899013, -0.0113769,
  -0.0137621, -0.0161453, -0.0185263, -0.0209051, -0.0232812,
  -0.0256546, -0.0280251, -0.0303923, -0.032756, -0.0351162,
  -0.0374725, -0.0398248, -0.0421727, -0.0445163, -0.0468551,
  -0.049189, -0.0515178, -0.0538413, -0.0561593, -0.0584715,
  -0.0607778, -0.0630779, -0.0653717, -0.0676589, -0.0699394,
  -0.0722129, -0.0744793, -0.0767382, -0.0789896, -0.0812332,
  -0.0834689, -0.0856964, -0.0879155, -0.090126, -0.0923278,
  -0.0945206, -0.0967043, -0.0988786, -0.101043, -0.103198, -0.105344,
  -0.107479, -0.109603, -0.111718, -0.113821, -0.115914, -0.117996,
  -0.120066, -0.122125, -0.124172, -0.126208, -0.128232, -0.130243,
  -0.132243, -0.134229, -0.136204, -0.138165, -0.140113, -0.142048,
  -0.14397, -0.145878, -0.147773, -0.149654, -0.151521, -0.153373,
  -0.155211, -0.157035, -0.158844, -0.160639, -0.162418, -0.164182,
  -0.165931, -0.167664, -0.169382, -0.171084, -0.172771, -0.174441,
  -0.176095, -0.177733, -0.179354, -0.180959, -0.182547, -0.184118,
  -0.185672, -0.187209, -0.188729, -0.190231, -0.191715, -0.193182,
  -0.194632, -0.196063, -0.197476, -0.198871, -0.200248, -0.201606,
  -0.202946, -0.204267, -0.205569, -0.206853, -0.208118, -0.209363,
  -0.210589, -0.211796, -0.212984, -0.214152, -0.2153, -0.216428,
  -0.217537, -0.218626, -0.219695, -0.220744, -0.221773, -0.222781,
  -0.223769, -0.224736, -0.225683, -0.22661, -0.227515, -0.2284,
  -0.229264, -0.230108, -0.23093, -0.231731, -0.232511, -0.233269,
  -0.234007, -0.234723, -0.235418, -0.236091, -0.236743, -0.237373,
  -0.237982, -0.238569, -0.239134, -0.239677, -0.240199, -0.240698,
  -0.241176, -0.241632, -0.242066, -0.242478, -0.242868, -0.243235,
  -0.243581, -0.243904, -0.244206, -0.244485, -0.244741, -0.244976,
  -0.245188, -0.245378, -0.245546, -0.245691, -0.245814, -0.245915,
  -0.245993, -0.246049, -0.246083, -0.246094, -0.246083, -0.246049,
  -0.245993, -0.245915, -0.245814, -0.245691, -0.245546, -0.245378,
  -0.245188, -0.244976, -0.244741, -0.244485, -0.244206, -0.243904,
  -0.243581, -0.243235, -0.242868, -0.242478, -0.242066, -0.241632,
  -0.241176, -0.240698, -0.240199, -0.239677, -0.239134, -0.238569,
  -0.237982, -0.237373, -0.236743, -0.236091, -0.235418, -0.234723,
  -0.234007, -0.233269, -0.232511, -0.231731, -0.23093, -0.230108,
  -0.229264, -0.2284, -0.227515, -0.22661, -0.225683, -0.224736,
  -0.223769, -0.222781, -0.221773, -0.220744, -0.219695, -0.218626,
  -0.217537, -0.216428, -0.2153, -0.214152, -0.212984, -0.211796,
  -0.210589, -0.209363, -0.208118, -0.206853, -0.205569, -0.204267,
  -0.202946, -0.201606, -0.200248, -0.198871, -0.197476, -0.196063,
  -0.194632, -0.193182, -0.191715, -0.190231, -0.188729, -0.187209,
  -0.185672, -0.184118, -0.182547, -0.180959, -0.179354, -0.177733,
  -0.176095, -0.174441, -0.172771, -0.171084, -0.169382, -0.167664,
  -0.165931, -0.164182, -0.162418, -0.160639, -0.158844, -0.157035,
  -0.155211, -0.153373, -0.151521, -0.149654, -0.147773, -0.145878,
  -0.14397, -0.142048, -0.140113, -0.138165, -0.136204, -0.134229,
  -0.132243, -0.130243, -0.128232, -0.126208, -0.124172, -0.122125,
  -0.120066, -0.117996, -0.115914, -0.113821, -0.111718, -0.109603,
  -0.107479, -0.105344, -0.103198, -0.101043, -0.0988786, -0.0967043,
  -0.0945206, -0.0923278, -0.090126, -0.0879155, -0.0856964,
  -0.0834689, -0.0812332, -0.0789896, -0.0767382, -0.0744793,
  -0.0722129, -0.0699394, -0.0676589, -0.0653717, -0.0630779,
  -0.0607778, -0.0584715, -0.0561593, -0.0538413, -0.0515178,
  -0.049189, -0.0468551, -0.0445163, -0.0421727, -0.0398248,
  -0.0374725, -0.0351162, -0.032756, -0.0303923, -0.0280251,
  -0.0256546, -0.0232812, -0.0209051, -0.0185263, -0.0161453,
  -0.0137621, -0.0113769, -0.00899013, -0.00660183, -0.00421227,
  -0.00182167, 0.000569768, 0.00296181, 0.00535425, 0.00774685,
  0.0101394, 0.0125317, 0.0149235, 0.0173147, 0.0197048, 0.0220939,
  0.0244816, 0.0268677, 0.029252, 0.0316343, 0.0340144, 0.036392,
  0.0387669, 0.041139, 0.0435079, 0.0458735, 0.0482355, 0.0505938,
  0.0529481, 0.0552981, 0.0576437, 0.0599847, 0.0623208, 0.0646519,
  0.0669776, 0.0692978, 0.0716123, 0.0739208, 0.0762231, 0.0785191,
  0.0808085, 0.083091, 0.0853665, 0.0876347, 0.0898955, 0.0921487,
  0.0943939, 0.096631, 0.0988598, 0.10108, 0.103292, 0.105494,
  0.107688, 0.109872, 0.112046, 0.114211, 0.116365, 0.11851, 0.120644,
  0.122767, 0.12488, 0.126982, 0.129072, 0.131151, 0.133218, 0.135274,
  0.137317, 0.139348, 0.141367, 0.143373, 0.145367, 0.147347,
  0.149314, 0.151267, 0.153207, 0.155134, 0.157046, 0.158944,
  0.160828, 0.162697, 0.164551, 0.166391, 0.168215, 0.170024,
  0.171817, 0.173595, 0.175357, 0.177103, 0.178833, 0.180547,
  0.182244, 0.183924, 0.185587, 0.187233, 0.188862, 0.190474,
  0.192068, 0.193644, 0.195202, 0.196742, 0.198264, 0.199768,
  0.201253, 0.20272, 0.204167, 0.205596, 0.207005, 0.208395, 0.209765,
  0.211116, 0.212448, 0.213759, 0.21505, 0.216321, 0.217572, 0.218802,
  0.220011, 0.2212, 0.222368, 0.223515, 0.224641, 0.225745, 0.226829,
  0.22789, 0.22893, 0.229948, 0.230945, 0.231919, 0.232871, 0.233801,
  0.234709, 0.235594, 0.236457, 0.237297, 0.238114, 0.238908, 0.23968,
  0.240428, 0.241153, 0.241855, 0.242534, 0.243189, 0.24382, 0.244428,
  0.245013, 0.245573, 0.24611, 0.246623, 0.247111, 0.247576, 0.248016,
  0.248432, 0.248824, 0.249192, 0.249535, 0.249854, 0.250148,
  0.250417, 0.250662, 0.250882, 0.251078, 0.251248, 0.251394,
  0.251515, 0.251611, 0.251682, 0.251728, 0.251748, 0.251744,
  0.251715, 0.251661, 0.251581, 0.251476, 0.251346, 0.251191,
  0.251011, 0.250805, 0.250575, 0.250318, 0.250037, 0.249731,
  0.249399, 0.249041, 0.248659, 0.248251, 0.247819, 0.24736, 0.246877,
  0.246368, 0.245835, 0.245276, 0.244692, 0.244083, 0.243448,
  0.242789, 0.242105, 0.241395, 0.240661, 0.239902, 0.239118,
  0.238309, 0.237475, 0.236617, 0.235734, 0.234826, 0.233894,
  0.232937, 0.231956, 0.23095, 0.22992, 0.228866, 0.227788, 0.226686,
  0.225559, 0.224409, 0.223235, 0.222037, 0.220816, 0.219571,
  0.218302, 0.21701, 0.215695, 0.214356, 0.212995, 0.21161, 0.210203,
  0.208773, 0.20732, 0.205845, 0.204347, 0.202827, 0.201284, 0.19972,
  0.198134, 0.196526, 0.194896, 0.193245, 0.191572, 0.189878,
  0.188163, 0.186427, 0.184671, 0.182893, 0.181095, 0.179277,
  0.177438, 0.175579, 0.173701, 0.171803, 0.169885, 0.167948,
  0.165991, 0.164016, 0.162021, 0.160008, 0.157977, 0.155927,
  0.153859, 0.151773, 0.149669, 0.147547, 0.145408, 0.143252,
  0.141079, 0.138889, 0.136683, 0.13446, 0.132221, 0.129966, 0.127695,
  0.125409, 0.123107, 0.12079, 0.118459, 0.116112, 0.113751, 0.111376,
  0.108987, 0.106584, 0.104168, 0.101738, 0.0992948, 0.0968391,
  0.0943707, 0.0918899, 0.0893971, 0.0868923, 0.0843759, 0.0818481,
  0.0793092, 0.0767594, 0.0741989, 0.0716281, 0.0690471, 0.0664563,
  0.0638559, 0.0612461, 0.0586273, 0.0559997, 0.0533635, 0.050719,
  0.0480666, 0.0454064, 0.0427387, 0.0400639, 0.0373822, 0.0346938,
  0.0319991, 0.0292983, 0.0265918, 0.0238797, 0.0211624, 0.0184402,
  0.0157134, 0.0129822, 0.0102469, 0.00750792, 0.00476542, 0.00201975,
  -0.000728816, -0.00347997, -0.00623341, -0.00898884, -0.011746,
  -0.0145045, -0.0172641, -0.0200245, -0.0227854, -0.0255464,
  -0.0283073, -0.0310678, -0.0338275, -0.0365862, -0.0393435,
  -0.0420992, -0.0448528, -0.0476042, -0.050353, -0.0530988,
  -0.0558414, -0.0585805, -0.0613157, -0.0640467, -0.0667732,
  -0.0694949, -0.0722115, -0.0749226, -0.0776279, -0.0803272,
  -0.0830201, -0.0857062, -0.0883853, -0.0910571, -0.0937212,
  -0.0963772, -0.099025, -0.101664, -0.104294, -0.106915, -0.109526,
  -0.112128, -0.114719, -0.117299, -0.119869, -0.122427, -0.124974,
  -0.12751, -0.130032, -0.132543, -0.135041, -0.137525, -0.139996,
  -0.142454, -0.144897, -0.147326, -0.14974, -0.152139, -0.154523,
  -0.156891, -0.159243, -0.161579, -0.163899, -0.166201, -0.168486,
  -0.170754, -0.173004, -0.175236, -0.177449, -0.179644, -0.181819,
  -0.183976, -0.186112, -0.188229, -0.190325, -0.192401, -0.194456,
  -0.196489, -0.198501, -0.200492, -0.202461, -0.204407, -0.20633,
  -0.208231, -0.210108, -0.211962, -0.213792, -0.215599, -0.21738,
  -0.219138, -0.22087, -0.222577, -0.224259, -0.225915, -0.227545,
  -0.229149, -0.230727, -0.232277, -0.233801, -0.235297, -0.236766,
  -0.238207, -0.23962, -0.241005, -0.242361, -0.243689, -0.244987,
  -0.246257, -0.247496, -0.248706, -0.249886, -0.251036, -0.252156,
  -0.253245, -0.254302, -0.255329, -0.256325, -0.257289, -0.258222,
  -0.259122, -0.259991, -0.260827, -0.26163, -0.262401, -0.263139,
  -0.263844, -0.264516, -0.265154, -0.265759, -0.266329, -0.266866,
  -0.267369, -0.267837, -0.268271, -0.268671, -0.269035, -0.269365,
  -0.269659, -0.269919, -0.270143, -0.270331, -0.270484, -0.270602,
  -0.270683, -0.270729, -0.270738, -0.270711, -0.270648, -0.270548,
  -0.270412, -0.27024, -0.27003, -0.269784, -0.269501, -0.269181,
  -0.268825, -0.268431, -0.268, -0.267531, -0.267026, -0.266483,
  -0.265903, -0.265285, -0.264631, -0.263938, -0.263208, -0.262441,
  -0.261636, -0.260794, -0.259914, -0.258997, -0.258042, -0.257049,
  -0.256019, -0.254952, -0.253847, -0.252704, -0.251525, -0.250307,
  -0.249053, -0.247761, -0.246432, -0.245066, -0.243663, -0.242222,
  -0.240745, -0.239231, -0.23768, -0.236092, -0.234468, -0.232807,
  -0.23111, -0.229377, -0.227607, -0.225802, -0.22396, -0.222083,
  -0.22017, -0.218221, -0.216238, -0.214219, -0.212165, -0.210076,
  -0.207952, -0.205794, -0.203602, -0.201375, -0.199115, -0.196821,
  -0.194494, -0.192133, -0.189739, -0.187312, -0.184853, -0.182361,
  -0.179837, -0.177282, -0.174694, -0.172076, -0.169426, -0.166745,
  -0.164034, -0.161293, -0.158522, -0.155721, -0.152891, -0.150032,
  -0.147144, -0.144228, -0.141284, -0.138312, -0.135312, -0.132286,
  -0.129233, -0.126154, -0.123048, -0.119917, -0.116761, -0.113581,
  -0.110375, -0.107146, -0.103893, -0.100617, -0.0973181, -0.0939968,
  -0.0906536, -0.0872889, -0.0839031, -0.0804967, -0.0770701,
  -0.0736238, -0.0701583, -0.0666739, -0.0631712, -0.0596507,
  -0.0561129, -0.0525582, -0.0489871, -0.0454002, -0.0417979,
  -0.0381808, -0.0345494, -0.0309042, -0.0272458, -0.0235746,
  -0.0198913, -0.0161964, -0.0124904, -0.00877387, -0.00504743,
  -0.00131161, 0.002433, 0.00618582, 0.00994626, 0.0137137, 0.0174876,
  0.0212674, 0.0250523, 0.0288419, 0.0326354, 0.0364323, 0.040232,
  0.0440337, 0.0478369, 0.051641, 0.0554452, 0.0592489, 0.0630515,
  0.0668523, 0.0706506, 0.0744458, 0.0782372, 0.0820241, 0.0858058,
  0.0895816, 0.0933509, 0.097113, 0.100867, 0.104612, 0.108349,
  0.112074, 0.11579, 0.119493, 0.123185, 0.126863, 0.130528, 0.134178,
  0.137813, 0.141433, 0.145035, 0.14862, 0.152187, 0.155735, 0.159264,
  0.162772, 0.166259, 0.169724, 0.173166, 0.176585, 0.179979,
  0.183349, 0.186693, 0.19001, 0.1933, 0.196562, 0.199794, 0.202998,
  0.20617, 0.209312, 0.212421, 0.215498, 0.218541, 0.22155, 0.224524,
  0.227461, 0.230362, 0.233226, 0.236051, 0.238837, 0.241583,
  0.244288, 0.246952, 0.249574, 0.252153, 0.254688, 0.257178,
  0.259624, 0.262022, 0.264375, 0.266679, 0.268935, 0.271141,
  0.273298, 0.275404, 0.277459, 0.279461, 0.28141, 0.283305, 0.285146,
  0.286932, 0.288662, 0.290334, 0.29195, 0.293507, 0.295005, 0.296444,
  0.297822, 0.299139, 0.300395, 0.301588, 0.302718, 0.303784,
  0.304786, 0.305722, 0.306593, 0.307397, 0.308134, 0.308803,
  0.309404, 0.309935, 0.310397, 0.310789, 0.31111, 0.31136, 0.311537,
  0.311642, 0.311674, 0.311632, 0.311516, 0.311325, 0.311058,
  0.310716, 0.310298, 0.309803, 0.30923, 0.30858, 0.307852, 0.307045,
  0.306159, 0.305193, 0.304148, 0.303023, 0.301817, 0.30053, 0.299162,
  0.297712, 0.29618, 0.294566, 0.29287, 0.291091, 0.289229, 0.287285,
  0.285256, 0.283144, 0.280949, 0.278669, 0.276306, 0.273858,
  0.271327, 0.268711, 0.266011, 0.263226, 0.260357, 0.257404,
  0.254367, 0.251245, 0.248039, 0.24475, 0.241376, 0.237919, 0.234378,
  0.230754, 0.227047, 0.223256, 0.219384, 0.215429, 0.211392,
  0.207274, 0.203074, 0.198794, 0.194433, 0.189993, 0.185473,
  0.180874, 0.176198, 0.171444, 0.166612, 0.161705, 0.156722,
  0.151664, 0.146532, 0.141327, 0.136049, 0.1307, 0.12528, 0.11979,
  0.114231, 0.108605, 0.102912, 0.0971538, 0.0913308, 0.0854445,
  0.0794961, 0.0734869, 0.0674181, 0.0612911, 0.0551073, 0.048868,
  0.0425748, 0.0362291, 0.0298326, 0.0233867, 0.0168932, 0.0103537,
  0.00376989, -0.00285633, -0.00952319, -0.0162288, -0.0229712,
  -0.0297485, -0.0365586, -0.0433995, -0.0502689, -0.0571648,
  -0.0640849, -0.0710268, -0.0779883, -0.0849669, -0.0919603,
  -0.0989658, -0.105981, -0.113003, -0.120029, -0.127057, -0.134084,
  -0.141106, -0.148121, -0.155127, -0.162119, -0.169095, -0.176051,
  -0.182985, -0.189893, -0.196771, -0.203617, -0.210426, -0.217195,
  -0.223921, -0.230599, -0.237227, -0.243799, -0.250312, -0.256762,
  -0.263146, -0.269458, -0.275694, -0.281851, -0.287923, -0.293907,
  -0.299797, -0.30559, -0.31128, -0.316863, -0.322333, -0.327686,
  -0.332916, -0.338019, -0.34299, -0.347822, -0.352511, -0.35705,
  -0.361436, -0.365661, -0.36972, -0.373607, -0.377316, -0.380841,
  -0.384176, -0.387315, -0.390251, -0.392978, -0.39549, -0.397779,
  -0.399838, -0.401662, -0.403243, -0.404574, -0.405648, -0.406457,
  -0.406995, -0.407253, -0.407224, -0.4069, -0.406274, -0.405337,
  -0.404082, -0.4025, -0.400583, -0.398322, -0.395709, -0.392736,
  -0.389393, -0.385671, -0.381562, -0.377057, -0.372145, -0.366818,
  -0.361067, -0.35488, -0.34825, -0.341164, -0.333615, -0.325591,
  -0.317081, -0.308077, -0.298566, -0.288538, -0.277982, -0.266888,
  -0.255243, -0.243037, -0.230258, -0.216895, -0.202935, -0.188367,
  -0.173178, -0.157357, -0.14089, -0.123766, -0.105972, -0.087494,
  -0.0683199, -0.0484363, -0.0278297, -0.00648672, 0.0156065,
  0.0384637, 0.062099, 0.0865266, 0.111761, 0.137816, 0.164708,
  0.192451, 0.221059, 0.250549, 0.280936, 0.312235, 0.344462,
  0.377633, 0.411765, 0.446874, 0.482977, 0.520089, 0.558229,
  0.597413, 0.637659, 0.678984, 0.721406, 0.764944, 0.809614,
  0.855436, 0.902429, 0.95061, 1}; G4double
  G4NeutronHPFastLegendre::i10[2201] = {0, 0.000886546, 0.00172874,
  0.00252768, 0.00328443, 0.00400005, 0.00467558, 0.00531203,
  0.00591042, 0.00647173, 0.00699694, 0.007487, 0.00794286,
  0.00836545, 0.00875566, 0.0091144, 0.00944255, 0.00974098,
  0.0100105, 0.010252, 0.0104663, 0.0106542, 0.0108165, 0.010954,
  0.0110673, 0.0111574, 0.0112249, 0.0112705, 0.0112951, 0.0112991,
  0.0112835, 0.0112488, 0.0111956, 0.0111248, 0.0110368, 0.0109323,
  0.0108119, 0.0106763, 0.010526, 0.0103616, 0.0101837, 0.00999285,
  0.00978955, 0.00957437, 0.00934783, 0.00911046, 0.00886275,
  0.0086052, 0.00833829, 0.0080625, 0.0077783, 0.00748614, 0.00718646,
  0.00687971, 0.0065663, 0.00624666, 0.0059212, 0.00559031,
  0.00525438, 0.00491381, 0.00456895, 0.00422017, 0.00386784,
  0.0035123, 0.00315389, 0.00279294, 0.00242977, 0.00206471,
  0.00169805, 0.00133011, 0.000961169, 0.000591521, 0.000221441,
  -0.000148799, -0.000518934, -0.000888706, -0.00125787, -0.00162617,
  -0.00199338, -0.00235926, -0.0027236, -0.00308617, -0.00344677,
  -0.00380518, -0.00416121, -0.00451466, -0.00486536, -0.00521311,
  -0.00555774, -0.00589908, -0.00623697, -0.00657125, -0.00690176,
  -0.00722835, -0.00755089, -0.00786924, -0.00818326, -0.00849282,
  -0.0087978, -0.00909808, -0.00939355, -0.0096841, -0.00996963,
  -0.01025, -0.0105252, -0.0107951, -0.0110596, -0.0113186, -0.011572,
  -0.0118198, -0.0120619, -0.0122982, -0.0125287, -0.0127533,
  -0.012972, -0.0131846, -0.0133912, -0.0135917, -0.0137861,
  -0.0139743, -0.0141563, -0.0143321, -0.0145016, -0.0146648,
  -0.0148217, -0.0149722, -0.0151164, -0.0152543, -0.0153857,
  -0.0155108, -0.0156295, -0.0157418, -0.0158477, -0.0159473,
  -0.0160404, -0.0161272, -0.0162076, -0.0162817, -0.0163494,
  -0.0164109, -0.016466, -0.0165148, -0.0165574, -0.0165937,
  -0.0166239, -0.0166478, -0.0166656, -0.0166773, -0.016683,
  -0.0166825, -0.0166761, -0.0166637, -0.0166454, -0.0166212,
  -0.0165912, -0.0165554, -0.0165138, -0.0164665, -0.0164136,
  -0.0163551, -0.0162911, -0.0162215, -0.0161465, -0.0160662,
  -0.0159805, -0.0158896, -0.0157934, -0.0156921, -0.0155857,
  -0.0154743, -0.015358, -0.0152367, -0.0151106, -0.0149798,
  -0.0148442, -0.0147041, -0.0145593, -0.0144101, -0.0142564,
  -0.0140984, -0.0139361, -0.0137695, -0.0135989, -0.0134241,
  -0.0132454, -0.0130627, -0.0128762, -0.0126859, -0.0124918,
  -0.0122942, -0.012093, -0.0118883, -0.0116802, -0.0114688,
  -0.0112541, -0.0110362, -0.0108152, -0.0105912, -0.0103643,
  -0.0101345, -0.00990183, -0.00966647, -0.00942848, -0.00918791,
  -0.00894484, -0.00869937, -0.00845155, -0.00820147, -0.0079492,
  -0.00769482, -0.00743841, -0.00718004, -0.00691979, -0.00665773,
  -0.00639394, -0.0061285, -0.00586147, -0.00559294, -0.00532299,
  -0.00505167, -0.00477908, -0.00450528, -0.00423035, -0.00395435,
  -0.00367737, -0.00339948, -0.00312075, -0.00284124, -0.00256104,
  -0.00228021, -0.00199883, -0.00171696, -0.00143467, -0.00115204,
  -0.000869133, -0.000586018, -0.000302763, -1.94362e-05, 0.000263895,
  0.000547164, 0.000830305, 0.00111325, 0.00139594, 0.0016783,
  0.00196028, 0.0022418, 0.00252281, 0.00280324, 0.00308303,
  0.00336212, 0.00364045, 0.00391796, 0.00419459, 0.00447028,
  0.00474497, 0.0050186, 0.00529112, 0.00556247, 0.0058326,
  0.00610144, 0.00636895, 0.00663507, 0.00689975, 0.00716294,
  0.00742457, 0.00768461, 0.00794301, 0.0081997, 0.00845464,
  0.00870779, 0.0089591, 0.00920851, 0.00945599, 0.00970148,
  0.00994495, 0.0101863, 0.0104256, 0.0106627, 0.0108976, 0.0111303,
  0.0113607, 0.0115888, 0.0118145, 0.0120378, 0.0122586, 0.012477,
  0.0126928, 0.0129062, 0.0131169, 0.013325, 0.0135304, 0.0137332,
  0.0139332, 0.0141305, 0.014325, 0.0145167, 0.0147056, 0.0148916,
  0.0150747, 0.0152548, 0.0154321, 0.0156063, 0.0157775, 0.0159457,
  0.0161109, 0.016273, 0.0164319, 0.0165878, 0.0167405, 0.0168901,
  0.0170365, 0.0171796, 0.0173196, 0.0174563, 0.0175898, 0.01772,
  0.017847, 0.0179706, 0.0180909, 0.0182079, 0.0183216, 0.0184319,
  0.0185388, 0.0186424, 0.0187426, 0.0188394, 0.0189328, 0.0190228,
  0.0191094, 0.0191925, 0.0192722, 0.0193485, 0.0194214, 0.0194908,
  0.0195567, 0.0196192, 0.0196783, 0.0197339, 0.019786, 0.0198347,
  0.0198799, 0.0199217, 0.01996, 0.0199948, 0.0200262, 0.0200541,
  0.0200786, 0.0200997, 0.0201173, 0.0201315, 0.0201422, 0.0201496,
  0.0201535, 0.020154, 0.0201511, 0.0201448, 0.0201352, 0.0201221,
  0.0201057, 0.020086, 0.0200629, 0.0200364, 0.0200067, 0.0199736,
  0.0199373, 0.0198976, 0.0198547, 0.0198086, 0.0197592, 0.0197065,
  0.0196507, 0.0195917, 0.0195295, 0.0194641, 0.0193956, 0.019324,
  0.0192493, 0.0191715, 0.0190906, 0.0190067, 0.0189197, 0.0188297,
  0.0187368, 0.0186408, 0.018542, 0.0184402, 0.0183354, 0.0182279,
  0.0181174, 0.0180041, 0.0178881, 0.0177692, 0.0176475, 0.0175232,
  0.0173961, 0.0172663, 0.0171339, 0.0169988, 0.0168611, 0.0167208,
  0.016578, 0.0164326, 0.0162847, 0.0161344, 0.0159815, 0.0158263,
  0.0156687, 0.0155087, 0.0153464, 0.0151817, 0.0150148, 0.0148456,
  0.0146743, 0.0145007, 0.0143249, 0.0141471, 0.0139671, 0.013785,
  0.013601, 0.0134149, 0.0132268, 0.0130368, 0.0128449, 0.012651,
  0.0124554, 0.0122579, 0.0120586, 0.0118576, 0.0116548, 0.0114504,
  0.0112443, 0.0110366, 0.0108273, 0.0106164, 0.010404, 0.0101901,
  0.00997474, 0.00975796, 0.00953979, 0.00932025, 0.00909939,
  0.00887724, 0.00865383, 0.00842919, 0.00820337, 0.00797638,
  0.00774827, 0.00751908, 0.00728882, 0.00705755, 0.00682529,
  0.00659207, 0.00635793, 0.00612291, 0.00588704, 0.00565035,
  0.00541288, 0.00517466, 0.00493573, 0.00469611, 0.00445585,
  0.00421498, 0.00397353, 0.00373153, 0.00348902, 0.00324604,
  0.00300261, 0.00275878, 0.00251457, 0.00227002, 0.00202516,
  0.00178003, 0.00153465, 0.00128907, 0.00104332, 0.000797425,
  0.000551424, 0.000305349, 5.92325e-05, -0.000186891, -0.00043299,
  -0.000679032, -0.000924983, -0.00117081, -0.00141648, -0.00166197,
  -0.00190723, -0.00215225, -0.00239698, -0.00264139, -0.00288546,
  -0.00312915, -0.00337243, -0.00361526, -0.00385763, -0.00409949,
  -0.00434081, -0.00458158, -0.00482174, -0.00506128, -0.00530017,
  -0.00553837, -0.00577585, -0.00601259, -0.00624855, -0.00648371,
  -0.00671803, -0.0069515, -0.00718407, -0.00741572, -0.00764643,
  -0.00787616, -0.00810488, -0.00833258, -0.00855921, -0.00878476,
  -0.0090092, -0.00923249, -0.00945462, -0.00967556, -0.00989527,
  -0.0101137, -0.0103309, -0.0105468, -0.0107614, -0.0109746,
  -0.0111865, -0.011397, -0.011606, -0.0118136, -0.0120197,
  -0.0122243, -0.0124274, -0.012629, -0.012829, -0.0130274,
  -0.0132242, -0.0134194, -0.0136129, -0.0138048, -0.013995,
  -0.0141834, -0.0143701, -0.014555, -0.0147382, -0.0149196,
  -0.0150991, -0.0152768, -0.0154527, -0.0156266, -0.0157987,
  -0.0159688, -0.0161371, -0.0163033, -0.0164676, -0.01663,
  -0.0167903, -0.0169486, -0.0171048, -0.017259, -0.0174112,
  -0.0175612, -0.0177091, -0.017855, -0.0179987, -0.0181402,
  -0.0182796, -0.0184168, -0.0185519, -0.0186847, -0.0188153,
  -0.0189437, -0.0190699, -0.0191937, -0.0193154, -0.0194347,
  -0.0195518, -0.0196666, -0.019779, -0.0198892, -0.019997,
  -0.0201024, -0.0202055, -0.0203063, -0.0204047, -0.0205007,
  -0.0205943, -0.0206855, -0.0207743, -0.0208607, -0.0209447,
  -0.0210263, -0.0211054, -0.0211821, -0.0212564, -0.0213282,
  -0.0213975, -0.0214644, -0.0215288, -0.0215908, -0.0216502,
  -0.0217072, -0.0217617, -0.0218137, -0.0218632, -0.0219103,
  -0.0219548, -0.0219968, -0.0220363, -0.0220733, -0.0221079,
  -0.0221399, -0.0221694, -0.0221964, -0.0222208, -0.0222428,
  -0.0222623, -0.0222792, -0.0222936, -0.0223056, -0.022315,
  -0.0223219, -0.0223263, -0.0223283, -0.0223277, -0.0223246,
  -0.022319, -0.0223109, -0.0223004, -0.0222873, -0.0222718,
  -0.0222538, -0.0222333, -0.0222104, -0.022185, -0.0221571,
  -0.0221268, -0.022094, -0.0220588, -0.0220212, -0.0219811,
  -0.0219386, -0.0218937, -0.0218464, -0.0217967, -0.0217446,
  -0.0216901, -0.0216333, -0.021574, -0.0215124, -0.0214485,
  -0.0213822, -0.0213136, -0.0212426, -0.0211694, -0.0210938,
  -0.021016, -0.0209359, -0.0208534, -0.0207688, -0.0206819,
  -0.0205927, -0.0205013, -0.0204077, -0.0203119, -0.020214,
  -0.0201138, -0.0200115, -0.019907, -0.0198003, -0.0196916,
  -0.0195807, -0.0194678, -0.0193527, -0.0192356, -0.0191164,
  -0.0189952, -0.018872, -0.0187467, -0.0186194, -0.0184902,
  -0.018359, -0.0182258, -0.0180907, -0.0179537, -0.0178148,
  -0.017674, -0.0175313, -0.0173867, -0.0172404, -0.0170922,
  -0.0169422, -0.0167904, -0.0166368, -0.0164815, -0.0163244,
  -0.0161657, -0.0160052, -0.0158431, -0.0156793, -0.0155138,
  -0.0153467, -0.015178, -0.0150078, -0.0148359, -0.0146626,
  -0.0144876, -0.0143112, -0.0141333, -0.0139539, -0.013773,
  -0.0135908, -0.0134071, -0.013222, -0.0130355, -0.0128477,
  -0.0126586, -0.0124682, -0.0122764, -0.0120834, -0.0118892,
  -0.0116937, -0.011497, -0.0112991, -0.0111001, -0.0108999,
  -0.0106986, -0.0104962, -0.0102927, -0.0100882, -0.00988265,
  -0.00967607, -0.0094685, -0.00925995, -0.00905047, -0.00884005,
  -0.00862873, -0.00841654, -0.00820348, -0.00798959, -0.00777488,
  -0.00755938, -0.00734312, -0.0071261, -0.00690836, -0.00668992,
  -0.00647081, -0.00625103, -0.00603062, -0.0058096, -0.005588,
  -0.00536583, -0.00514311, -0.00491988, -0.00469615, -0.00447194,
  -0.00424729, -0.0040222, -0.00379672, -0.00357084, -0.00334462,
  -0.00311805, -0.00289117, -0.002664, -0.00243657, -0.00220888,
  -0.00198098, -0.00175288, -0.00152461, -0.00129618, -0.00106762,
  -0.000838956, -0.000610208, -0.000381399, -0.000152552, 7.63103e-05,
  0.000305165, 0.000533989, 0.00076276, 0.000991456, 0.00122005,
  0.00144853, 0.00167686, 0.00190503, 0.002133, 0.00236077, 0.0025883,
  0.00281557, 0.00304257, 0.00326927, 0.00349564, 0.00372167,
  0.00394733, 0.0041726, 0.00439746, 0.00462188, 0.00484586,
  0.00506935, 0.00529234, 0.00551482, 0.00573675, 0.00595812,
  0.00617891, 0.00639909, 0.00661864, 0.00683754, 0.00705577,
  0.00727331, 0.00749014, 0.00770624, 0.00792159, 0.00813616,
  0.00834993, 0.00856289, 0.00877502, 0.00898629, 0.00919668,
  0.00940618, 0.00961477, 0.00982241, 0.0100291, 0.0102348, 0.0104395,
  0.0106433, 0.0108459, 0.0110476, 0.0112481, 0.0114476, 0.0116459,
  0.0118431, 0.0120392, 0.0122341, 0.0124279, 0.0126204, 0.0128117,
  0.0130018, 0.0131906, 0.0133782, 0.0135644, 0.0137494, 0.013933,
  0.0141153, 0.0142962, 0.0144757, 0.0146539, 0.0148307, 0.015006,
  0.0151799, 0.0153523, 0.0155232, 0.0156927, 0.0158607, 0.0160271,
  0.016192, 0.0163554, 0.0165172, 0.0166774, 0.016836, 0.016993,
  0.0171484, 0.0173021, 0.0174542, 0.0176047, 0.0177534, 0.0179005,
  0.0180458, 0.0181894, 0.0183313, 0.0184715, 0.0186099, 0.0187465,
  0.0188814, 0.0190144, 0.0191457, 0.0192751, 0.0194027, 0.0195285,
  0.0196524, 0.0197744, 0.0198946, 0.0200129, 0.0201292, 0.0202437,
  0.0203563, 0.0204669, 0.0205757, 0.0206824, 0.0207872, 0.0208901,
  0.0209909, 0.0210898, 0.0211867, 0.0212816, 0.0213745, 0.0214654,
  0.0215543, 0.0216411, 0.0217259, 0.0218086, 0.0218893, 0.021968,
  0.0220446, 0.0221191, 0.0221915, 0.0222618, 0.0223301, 0.0223962,
  0.0224603, 0.0225222, 0.022582, 0.0226398, 0.0226953, 0.0227488,
  0.0228002, 0.0228494, 0.0228964, 0.0229413, 0.0229841, 0.0230247,
  0.0230632, 0.0230995, 0.0231337, 0.0231657, 0.0231956, 0.0232232,
  0.0232487, 0.0232721, 0.0232932, 0.0233122, 0.0233291, 0.0233437,
  0.0233562, 0.0233665, 0.0233746, 0.0233806, 0.0233844, 0.023386,
  0.0233854, 0.0233827, 0.0233778, 0.0233707, 0.0233614, 0.02335,
  0.0233364, 0.0233206, 0.0233027, 0.0232826, 0.0232604, 0.023236,
  0.0232094, 0.0231807, 0.0231499, 0.0231169, 0.0230817, 0.0230445,
  0.0230051, 0.0229635, 0.0229199, 0.0228741, 0.0228262, 0.0227762,
  0.0227241, 0.0226699, 0.0226136, 0.0225552, 0.0224947, 0.0224322,
  0.0223676, 0.0223009, 0.0222322, 0.0221614, 0.0220885, 0.0220137,
  0.0219368, 0.0218579, 0.0217769, 0.021694, 0.0216091, 0.0215222,
  0.0214333, 0.0213424, 0.0212495, 0.0211548, 0.021058, 0.0209593,
  0.0208587, 0.0207562, 0.0206518, 0.0205455, 0.0204373, 0.0203272,
  0.0202152, 0.0201014, 0.0199858, 0.0198683, 0.0197489, 0.0196278,
  0.0195049, 0.0193802, 0.0192537, 0.0191254, 0.0189954, 0.0188637,
  0.0187302, 0.018595, 0.0184581, 0.0183195, 0.0181792, 0.0180373,
  0.0178937, 0.0177485, 0.0176017, 0.0174532, 0.0173032, 0.0171515,
  0.0169983, 0.0168436, 0.0166873, 0.0165294, 0.0163701, 0.0162093,
  0.016047, 0.0158832, 0.0157179, 0.0155513, 0.0153832, 0.0152137,
  0.0150428, 0.0148706, 0.0146969, 0.014522, 0.0143457, 0.0141681,
  0.0139892, 0.0138091, 0.0136277, 0.013445, 0.0132611, 0.013076,
  0.0128897, 0.0127023, 0.0125136, 0.0123239, 0.012133, 0.011941,
  0.0117479, 0.0115537, 0.0113585, 0.0111623, 0.010965, 0.0107668,
  0.0105675, 0.0103673, 0.0101662, 0.00996412, 0.00976115, 0.00955728,
  0.00935254, 0.00914695, 0.00894053, 0.00873329, 0.00852526,
  0.00831645, 0.00810689, 0.00789659, 0.00768557, 0.00747385,
  0.00726145, 0.00704839, 0.00683469, 0.00662036, 0.00640544,
  0.00618993, 0.00597385, 0.00575724, 0.0055401, 0.00532246,
  0.00510433, 0.00488574, 0.0046667, 0.00444724, 0.00422738,
  0.00400713, 0.00378652, 0.00356556, 0.00334428, 0.00312269,
  0.00290082, 0.00267869, 0.00245631, 0.00223371, 0.00201091,
  0.00178792, 0.00156477, 0.00134148, 0.00111807, 0.000894551,
  0.000670955, 0.000447298, 0.0002236, -1.18371e-07, -0.000223837,
  -0.000447535, -0.000671192, -0.000894788, -0.0011183, -0.00134172,
  -0.00156501, -0.00178816, -0.00201114, -0.00223395, -0.00245655,
  -0.00267892, -0.00290106, -0.00312293, -0.00334451, -0.0035658,
  -0.00378675, -0.00400737, -0.00422762, -0.00444748, -0.00466694,
  -0.00488598, -0.00510457, -0.00532269, -0.00554034, -0.00575748,
  -0.00597409, -0.00619016, -0.00640567, -0.0066206, -0.00683492,
  -0.00704862, -0.00726169, -0.00747409, -0.00768581, -0.00789683,
  -0.00810713, -0.00831669, -0.0085255, -0.00873353, -0.00894077,
  -0.00914719, -0.00935278, -0.00955751, -0.00976138, -0.00996436,
  -0.0101664, -0.0103676, -0.0105678, -0.010767, -0.0109653,
  -0.0111625, -0.0113588, -0.011554, -0.0117481, -0.0119412,
  -0.0121332, -0.0123241, -0.0125139, -0.0127025, -0.01289,
  -0.0130762, -0.0132613, -0.0134452, -0.0136279, -0.0138093,
  -0.0139895, -0.0141684, -0.014346, -0.0145222, -0.0146972,
  -0.0148708, -0.0150431, -0.0152139, -0.0153834, -0.0155515,
  -0.0157182, -0.0158834, -0.0160472, -0.0162095, -0.0163703,
  -0.0165297, -0.0166875, -0.0168438, -0.0169986, -0.0171518,
  -0.0173034, -0.0174535, -0.0176019, -0.0177488, -0.017894,
  -0.0180376, -0.0181795, -0.0183198, -0.0184583, -0.0185952,
  -0.0187304, -0.0188639, -0.0189957, -0.0191257, -0.0192539,
  -0.0193804, -0.0195051, -0.0196281, -0.0197492, -0.0198685,
  -0.019986, -0.0201016, -0.0202155, -0.0203274, -0.0204375,
  -0.0205457, -0.020652, -0.0207565, -0.020859, -0.0209596,
  -0.0210583, -0.021155, -0.0212498, -0.0213426, -0.0214335,
  -0.0215224, -0.0216093, -0.0216942, -0.0217772, -0.0218581,
  -0.021937, -0.0220139, -0.0220888, -0.0221616, -0.0222324,
  -0.0223011, -0.0223678, -0.0224324, -0.022495, -0.0225554,
  -0.0226138, -0.0226701, -0.0227243, -0.0227764, -0.0228264,
  -0.0228743, -0.0229201, -0.0229638, -0.0230053, -0.0230447,
  -0.023082, -0.0231171, -0.0231501, -0.023181, -0.0232097,
  -0.0232362, -0.0232606, -0.0232829, -0.0233029, -0.0233209,
  -0.0233366, -0.0233502, -0.0233616, -0.0233709, -0.023378,
  -0.0233829, -0.0233857, -0.0233862, -0.0233846, -0.0233808,
  -0.0233749, -0.0233667, -0.0233564, -0.023344, -0.0233293,
  -0.0233125, -0.0232935, -0.0232723, -0.023249, -0.0232235,
  -0.0231958, -0.0231659, -0.0231339, -0.0230998, -0.0230635,
  -0.023025, -0.0229844, -0.0229416, -0.0228967, -0.0228496,
  -0.0228004, -0.0227491, -0.0226956, -0.02264, -0.0225823,
  -0.0225224, -0.0224605, -0.0223964, -0.0223303, -0.022262,
  -0.0221917, -0.0221193, -0.0220448, -0.0219682, -0.0218896,
  -0.0218089, -0.0217261, -0.0216413, -0.0215545, -0.0214657,
  -0.0213748, -0.0212819, -0.021187, -0.0210901, -0.0209912,
  -0.0208903, -0.0207875, -0.0206826, -0.0205759, -0.0204672,
  -0.0203565, -0.020244, -0.0201295, -0.0200131, -0.0198948,
  -0.0197746, -0.0196526, -0.0195287, -0.0194029, -0.0192753,
  -0.0191459, -0.0190147, -0.0188816, -0.0187468, -0.0186101,
  -0.0184717, -0.0183316, -0.0181897, -0.018046, -0.0179007,
  -0.0177536, -0.0176049, -0.0174545, -0.0173024, -0.0171486,
  -0.0169932, -0.0168362, -0.0166776, -0.0165174, -0.0163556,
  -0.0161923, -0.0160273, -0.0158609, -0.0156929, -0.0155235,
  -0.0153525, -0.0151801, -0.0150062, -0.0148309, -0.0146541,
  -0.014476, -0.0142964, -0.0141155, -0.0139332, -0.0137496,
  -0.0135646, -0.0133784, -0.0131908, -0.013002, -0.012812,
  -0.0126206, -0.0124281, -0.0122344, -0.0120395, -0.0118434,
  -0.0116462, -0.0114478, -0.0112483, -0.0110478, -0.0108462,
  -0.0106435, -0.0104398, -0.0102351, -0.0100293, -0.00982265,
  -0.009615, -0.00940642, -0.00919692, -0.00898653, -0.00877526,
  -0.00856313, -0.00835017, -0.00813639, -0.00792182, -0.00770648,
  -0.00749038, -0.00727355, -0.00705601, -0.00683778, -0.00661887,
  -0.00639932, -0.00617914, -0.00595836, -0.00573699, -0.00551506,
  -0.00529258, -0.00506959, -0.00484609, -0.00462212, -0.00439769,
  -0.00417283, -0.00394756, -0.0037219, -0.00349588, -0.0032695,
  -0.00304281, -0.00281581, -0.00258854, -0.002361, -0.00213324,
  -0.00190526, -0.0016771, -0.00144876, -0.00122029, -0.000991692,
  -0.000762997, -0.000534226, -0.000305402, -7.6547e-05, 0.000152315,
  0.000381162, 0.000609971, 0.00083872, 0.00106738, 0.00129594,
  0.00152437, 0.00175265, 0.00198075, 0.00220865, 0.00243633,
  0.00266377, 0.00289093, 0.00311781, 0.00334438, 0.00357061,
  0.00379648, 0.00402197, 0.00424705, 0.00447171, 0.00469591,
  0.00491964, 0.00514287, 0.00536559, 0.00558776, 0.00580937,
  0.00603039, 0.00625079, 0.00647057, 0.00668969, 0.00690813,
  0.00712587, 0.00734288, 0.00755915, 0.00777464, 0.00798935,
  0.00820324, 0.0084163, 0.0086285, 0.00883981, 0.00905023,
  0.00925972, 0.00946826, 0.00967583, 0.00988241, 0.010088, 0.0102925,
  0.010496, 0.0106984, 0.0108997, 0.0110999, 0.0112989, 0.0114968,
  0.0116935, 0.0118889, 0.0120832, 0.0122762, 0.0124679, 0.0126584,
  0.0128475, 0.0130353, 0.0132218, 0.0134068, 0.0135905, 0.0137728,
  0.0139537, 0.014133, 0.014311, 0.0144874, 0.0146623, 0.0148357,
  0.0150075, 0.0151778, 0.0153465, 0.0155136, 0.015679, 0.0158428,
  0.016005, 0.0161654, 0.0163242, 0.0164813, 0.0166366, 0.0167901,
  0.0169419, 0.0170919, 0.0172401, 0.0173865, 0.017531, 0.0176737,
  0.0178145, 0.0179535, 0.0180905, 0.0182256, 0.0183587, 0.01849,
  0.0186192, 0.0187465, 0.0188717, 0.018995, 0.0191162, 0.0192354,
  0.0193525, 0.0194675, 0.0195805, 0.0196914, 0.0198001, 0.0199067,
  0.0200112, 0.0201136, 0.0202137, 0.0203117, 0.0204075, 0.0205011,
  0.0205925, 0.0206816, 0.0207685, 0.0208532, 0.0209356, 0.0210157,
  0.0210936, 0.0211692, 0.0212424, 0.0213134, 0.021382, 0.0214483,
  0.0215122, 0.0215738, 0.021633, 0.0216899, 0.0217444, 0.0217965,
  0.0218462, 0.0218935, 0.0219384, 0.0219809, 0.022021, 0.0220586,
  0.0220938, 0.0221266, 0.0221569, 0.0221847, 0.0222102, 0.0222331,
  0.0222536, 0.0222716, 0.0222871, 0.0223001, 0.0223107, 0.0223188,
  0.0223243, 0.0223274, 0.022328, 0.0223261, 0.0223217, 0.0223148,
  0.0223053, 0.0222934, 0.022279, 0.022262, 0.0222426, 0.0222206,
  0.0221961, 0.0221691, 0.0221396, 0.0221076, 0.0220731, 0.0220361,
  0.0219966, 0.0219545, 0.02191, 0.021863, 0.0218135, 0.0217615,
  0.021707, 0.02165, 0.0215905, 0.0215286, 0.0214642, 0.0213973,
  0.0213279, 0.0212561, 0.0211819, 0.0211052, 0.0210261, 0.0209445,
  0.0208605, 0.0207741, 0.0206853, 0.0205941, 0.0205004, 0.0204044,
  0.0203061, 0.0202053, 0.0201022, 0.0199967, 0.0198889, 0.0197788,
  0.0196663, 0.0195516, 0.0194345, 0.0193151, 0.0191935, 0.0190696,
  0.0189435, 0.0188151, 0.0186845, 0.0185516, 0.0184166, 0.0182794,
  0.01814, 0.0179984, 0.0178547, 0.0177089, 0.017561, 0.0174109,
  0.0172588, 0.0171046, 0.0169483, 0.01679, 0.0166297, 0.0164674,
  0.0163031, 0.0161368, 0.0159686, 0.0157985, 0.0156264, 0.0154524,
  0.0152766, 0.0150989, 0.0149193, 0.014738, 0.0145548, 0.0143699,
  0.0141832, 0.0139947, 0.0138046, 0.0136127, 0.0134192, 0.013224,
  0.0130272, 0.0128288, 0.0126288, 0.0124272, 0.0122241, 0.0120195,
  0.0118133, 0.0116058, 0.0113967, 0.0111863, 0.0109744, 0.0107612,
  0.0105466, 0.0103307, 0.0101135, 0.00989503, 0.00967532, 0.00945438,
  0.00923226, 0.00900896, 0.00878453, 0.00855898, 0.00833234,
  0.00810465, 0.00787592, 0.00764619, 0.00741549, 0.00718383,
  0.00695126, 0.0067178, 0.00648347, 0.00624831, 0.00601235,
  0.00577561, 0.00553813, 0.00529993, 0.00506105, 0.00482151,
  0.00458134, 0.00434058, 0.00409925, 0.00385739, 0.00361503,
  0.00337219, 0.00312891, 0.00288522, 0.00264116, 0.00239674,
  0.00215201, 0.001907, 0.00166173, 0.00141625, 0.00117057,
  0.000924746, 0.000678795, 0.000432754, 0.000186655, -5.94693e-05,
  -0.000305585, -0.00055166, -0.000797661, -0.00104356, -0.00128931,
  -0.00153489, -0.00178026, -0.0020254, -0.00227025, -0.00251481,
  -0.00275901, -0.00300285, -0.00324628, -0.00348926, -0.00373177,
  -0.00397376, -0.00421522, -0.00445609, -0.00469635, -0.00493597,
  -0.0051749, -0.00541312, -0.00565059, -0.00588728, -0.00612315,
  -0.00635817, -0.00659231, -0.00682552, -0.00705778, -0.00728906,
  -0.00751931, -0.00774851, -0.00797662, -0.0082036, -0.00842943,
  -0.00865407, -0.00887748, -0.00909963, -0.00932049, -0.00954002,
  -0.0097582, -0.00997498, -0.0101903, -0.0104042, -0.0106166,
  -0.0108275, -0.0110368, -0.0112445, -0.0114506, -0.0116551,
  -0.0118578, -0.0120589, -0.0122581, -0.0124556, -0.0126513,
  -0.0128451, -0.013037, -0.013227, -0.0134151, -0.0136012,
  -0.0137853, -0.0139673, -0.0141473, -0.0143252, -0.0145009,
  -0.0146745, -0.0148459, -0.015015, -0.015182, -0.0153466,
  -0.0155089, -0.0156689, -0.0158265, -0.0159818, -0.0161346,
  -0.0162849, -0.0164328, -0.0165782, -0.016721, -0.0168613,
  -0.016999, -0.0171341, -0.0172665, -0.0173963, -0.0175234,
  -0.0176478, -0.0177694, -0.0178883, -0.0180044, -0.0181177,
  -0.0182281, -0.0183357, -0.0184404, -0.0185422, -0.0186411,
  -0.018737, -0.01883, -0.0189199, -0.0190069, -0.0190908, -0.0191717,
  -0.0192495, -0.0193243, -0.0193959, -0.0194644, -0.0195297,
  -0.0195919, -0.0196509, -0.0197068, -0.0197594, -0.0198088,
  -0.019855, -0.0198979, -0.0199375, -0.0199739, -0.0200069,
  -0.0200367, -0.0200631, -0.0200862, -0.020106, -0.0201224,
  -0.0201354, -0.0201451, -0.0201514, -0.0201542, -0.0201537,
  -0.0201498, -0.0201425, -0.0201317, -0.0201175, -0.0200999,
  -0.0200789, -0.0200544, -0.0200264, -0.019995, -0.0199602,
  -0.0199219, -0.0198801, -0.0198349, -0.0197862, -0.0197341,
  -0.0196785, -0.0196195, -0.019557, -0.019491, -0.0194216,
  -0.0193488, -0.0192725, -0.0191928, -0.0191096, -0.019023,
  -0.018933, -0.0188396, -0.0187428, -0.0186426, -0.0185391,
  -0.0184321, -0.0183218, -0.0182082, -0.0180912, -0.0179708,
  -0.0178472, -0.0177203, -0.0175901, -0.0174566, -0.0173198,
  -0.0171799, -0.0170367, -0.0168903, -0.0167407, -0.016588,
  -0.0164322, -0.0162732, -0.0161111, -0.015946, -0.0157778,
  -0.0156065, -0.0154323, -0.0152551, -0.0150749, -0.0148918,
  -0.0147058, -0.014517, -0.0143253, -0.0141308, -0.0139335,
  -0.0137334, -0.0135307, -0.0133252, -0.0131171, -0.0129064,
  -0.0126931, -0.0124772, -0.0122588, -0.012038, -0.0118147,
  -0.011589, -0.0113609, -0.0111305, -0.0108979, -0.010663,
  -0.0104259, -0.0101866, -0.00994518, -0.00970172, -0.00945623,
  -0.00920875, -0.00895934, -0.00870803, -0.00845488, -0.00819994,
  -0.00794324, -0.00768485, -0.00742481, -0.00716317, -0.00689999,
  -0.00663531, -0.00636919, -0.00610168, -0.00583283, -0.00556271,
  -0.00529136, -0.00501884, -0.0047452, -0.00447051, -0.00419482,
  -0.0039182, -0.00364069, -0.00336236, -0.00308327, -0.00280348,
  -0.00252304, -0.00224204, -0.00196051, -0.00167854, -0.00139618,
  -0.00111349, -0.000830541, -0.000547401, -0.000264132, 1.91995e-05,
  0.000302526, 0.000585781, 0.000868896, 0.0011518, 0.00143443,
  0.00171672, 0.00199859, 0.00227997, 0.0025608, 0.00284101,
  0.00312051, 0.00339924, 0.00367714, 0.00395412, 0.00423011,
  0.00450504, 0.00477884, 0.00505144, 0.00532275, 0.00559271,
  0.00586124, 0.00612826, 0.0063937, 0.00665749, 0.00691955,
  0.0071798, 0.00743817, 0.00769458, 0.00794896, 0.00820123,
  0.00845131, 0.00869913, 0.00894461, 0.00918767, 0.00942824,
  0.00966624, 0.00990159, 0.0101342, 0.0103641, 0.010591, 0.010815,
  0.011036, 0.0112538, 0.0114685, 0.01168, 0.0118881, 0.0120928,
  0.012294, 0.0124916, 0.0126856, 0.0128759, 0.0130625, 0.0132451,
  0.0134239, 0.0135986, 0.0137693, 0.0139358, 0.0140981, 0.0142562,
  0.0144098, 0.0145591, 0.0147038, 0.014844, 0.0149795, 0.0151104,
  0.0152365, 0.0153577, 0.0154741, 0.0155855, 0.0156919, 0.0157932,
  0.0158893, 0.0159803, 0.0160659, 0.0161463, 0.0162213, 0.0162908,
  0.0163549, 0.0164134, 0.0164663, 0.0165136, 0.0165551, 0.016591,
  0.016621, 0.0166452, 0.0166635, 0.0166759, 0.0166823, 0.0166827,
  0.0166771, 0.0166654, 0.0166476, 0.0166236, 0.0165935, 0.0165571,
  0.0165146, 0.0164657, 0.0164106, 0.0163492, 0.0162815, 0.0162074,
  0.016127, 0.0160402, 0.015947, 0.0158475, 0.0157416, 0.0156293,
  0.0155106, 0.0153855, 0.015254, 0.0151162, 0.014972, 0.0148214,
  0.0146645, 0.0145013, 0.0143318, 0.0141561, 0.0139741, 0.0137859,
  0.0135915, 0.013391, 0.0131844, 0.0129717, 0.0127531, 0.0125285,
  0.012298, 0.0120617, 0.0118196, 0.0115718, 0.0113183, 0.0110593,
  0.0107949, 0.010525, 0.0102498, 0.0099694, 0.00968387, 0.00939332,
  0.00909784, 0.00879756, 0.00849258, 0.00818302, 0.007869,
  0.00755066, 0.00722812, 0.00690152, 0.00657101, 0.00623673,
  0.00589884, 0.0055575, 0.00521287, 0.00486512, 0.00451443,
  0.00416097, 0.00380494, 0.00344653, 0.00308594, 0.00272336,
  0.00235903, 0.00199314, 0.00162593, 0.00125763, 0.000888469,
  0.000518697, 0.000148562, -0.000221677, -0.000591757, -0.000961406,
  -0.00133035, -0.00169829, -0.00206494, -0.00243001, -0.00279317,
  -0.00315412, -0.00351254, -0.00386808, -0.00422041, -0.00456918,
  -0.00491404, -0.00525462, -0.00559055, -0.00592144, -0.0062469,
  -0.00656654, -0.00687995, -0.0071867, -0.00748638, -0.00777854,
  -0.00806274, -0.00833853, -0.00860543, -0.00886298, -0.0091107,
  -0.00934807, -0.00957461, -0.00978979, -0.00999308, -0.010184,
  -0.0103619, -0.0105263, -0.0106766, -0.0108122, -0.0109325,
  -0.011037, -0.011125, -0.0111959, -0.011249, -0.0112837, -0.0112994,
  -0.0112953, -0.0112708, -0.0112251, -0.0111576, -0.0110676,
  -0.0109542, -0.0108167, -0.0106545, -0.0104666, -0.0102523,
  -0.0100108, -0.00974121, -0.00944279, -0.00911464, -0.0087559,
  -0.00836568, -0.0079431, -0.00748724, -0.00699718, -0.00647197,
  -0.00591066, -0.00531227, -0.00467581, -0.00400029, -0.00328467,
  -0.00252792, -0.00172898, -0.000886783, -2.36742e-07}; G4double
  G4NeutronHPFastLegendre::l11[2401] = {-1, -0.94574, -0.892945,
  -0.841587, -0.791642, -0.743085, -0.695891, -0.650037, -0.605497,
  -0.562248, -0.520268, -0.479532, -0.440018, -0.401703, -0.364566,
  -0.328583, -0.293735, -0.259998, -0.227353, -0.195778, -0.165253,
  -0.135757, -0.107271, -0.0797744, -0.0532483, -0.0276733,
  -0.00303044, 0.020699, 0.0435333, 0.0654908, 0.0865894, 0.106847,
  0.12628, 0.144907, 0.162745, 0.179809, 0.196118, 0.211686, 0.22653,
  0.240665, 0.254108, 0.266874, 0.278977, 0.290434, 0.301257,
  0.311463, 0.321065, 0.330077, 0.338513, 0.346387, 0.353712,
  0.360502, 0.366769, 0.372527, 0.377788, 0.382564, 0.386869,
  0.390713, 0.394109, 0.397069, 0.399604, 0.401725, 0.403445,
  0.404772, 0.40572, 0.406297, 0.406516, 0.406385, 0.405916, 0.405117,
  0.404, 0.402573, 0.400847, 0.39883, 0.396532, 0.393961, 0.391127,
  0.388039, 0.384704, 0.381132, 0.377331, 0.373309, 0.369073,
  0.364632, 0.359994, 0.355165, 0.350154, 0.344968, 0.339614,
  0.334099, 0.32843, 0.322614, 0.316657, 0.310567, 0.304348, 0.298009,
  0.291554, 0.284991, 0.278324, 0.27156, 0.264705, 0.257763, 0.250741,
  0.243645, 0.236478, 0.229246, 0.221955, 0.21461, 0.207215, 0.199774,
  0.192293, 0.184777, 0.177228, 0.169653, 0.162055, 0.154438,
  0.146807, 0.139165, 0.131516, 0.123864, 0.116213, 0.108567,
  0.100928, 0.0933001, 0.085687, 0.0780919, 0.0705179, 0.0629681,
  0.0554455, 0.0479531, 0.0404937, 0.0330702, 0.0256853, 0.0183415,
  0.0110416, 0.00378795, -0.00341698, -0.0105708, -0.0176713,
  -0.0247162, -0.0317033, -0.0386306, -0.0454961, -0.0522977,
  -0.0590336, -0.0657019, -0.0723009, -0.0788289, -0.0852841,
  -0.0916651, -0.0979703, -0.104198, -0.110347, -0.116416, -0.122404,
  -0.128309, -0.13413, -0.139866, -0.145516, -0.151078, -0.156553,
  -0.161938, -0.167233, -0.172438, -0.17755, -0.18257, -0.187497,
  -0.192329, -0.197068, -0.201711, -0.206258, -0.210709, -0.215063,
  -0.21932, -0.22348, -0.227541, -0.231504, -0.235369, -0.239135,
  -0.242802, -0.24637, -0.249838, -0.253207, -0.256476, -0.259646,
  -0.262716, -0.265687, -0.268558, -0.27133, -0.274002, -0.276575,
  -0.279049, -0.281424, -0.2837, -0.285878, -0.287958, -0.28994,
  -0.291824, -0.293611, -0.295301, -0.296895, -0.298392, -0.299794,
  -0.301101, -0.302313, -0.30343, -0.304454, -0.305385, -0.306223,
  -0.306969, -0.307623, -0.308187, -0.30866, -0.309043, -0.309338,
  -0.309544, -0.309663, -0.309694, -0.30964, -0.309499, -0.309274,
  -0.308965, -0.308573, -0.308098, -0.307542, -0.306905, -0.306187,
  -0.305391, -0.304515, -0.303563, -0.302533, -0.301428, -0.300248,
  -0.298993, -0.297666, -0.296266, -0.294795, -0.293253, -0.291641,
  -0.289961, -0.288213, -0.286399, -0.284518, -0.282573, -0.280564,
  -0.278491, -0.276357, -0.274162, -0.271906, -0.269592, -0.267219,
  -0.26479, -0.262304, -0.259763, -0.257167, -0.254519, -0.251818,
  -0.249067, -0.246265, -0.243414, -0.240514, -0.237568, -0.234575,
  -0.231537, -0.228455, -0.22533, -0.222162, -0.218954, -0.215705,
  -0.212417, -0.209091, -0.205728, -0.202329, -0.198894, -0.195425,
  -0.191923, -0.188389, -0.184823, -0.181228, -0.177603, -0.17395,
  -0.170269, -0.166562, -0.16283, -0.159073, -0.155293, -0.15149,
  -0.147666, -0.143821, -0.139957, -0.136074, -0.132173, -0.128255,
  -0.124321, -0.120373, -0.11641, -0.112434, -0.108446, -0.104446,
  -0.100436, -0.0964164, -0.092388, -0.0883518, -0.0843087,
  -0.0802594, -0.0762049, -0.0721461, -0.0680837, -0.0640186,
  -0.0599517, -0.0558838, -0.0518156, -0.047748, -0.0436819,
  -0.0396179, -0.035557, -0.0314998, -0.0274473, -0.0234, -0.0193589,
  -0.0153247, -0.011298, -0.00727978, -0.00327061, 0.000728742,
  0.00471754, 0.00869509, 0.0126607, 0.0166136, 0.0205531, 0.0244787,
  0.0283895, 0.0322849, 0.0361643, 0.040027, 0.0438724, 0.0476998,
  0.0515087, 0.0552983, 0.0590681, 0.0628175, 0.0665458, 0.0702525,
  0.0739371, 0.0775989, 0.0812374, 0.084852, 0.0884422, 0.0920074,
  0.0955472, 0.0990609, 0.102548, 0.106008, 0.109441, 0.112846,
  0.116222, 0.119569, 0.122887, 0.126175, 0.129433, 0.132659,
  0.135855, 0.139019, 0.142151, 0.145251, 0.148318, 0.151351,
  0.154351, 0.157317, 0.160249, 0.163146, 0.166008, 0.168834,
  0.171625, 0.17438, 0.177099, 0.17978, 0.182425, 0.185033, 0.187603,
  0.190135, 0.19263, 0.195086, 0.197503, 0.199882, 0.202221, 0.204521,
  0.206782, 0.209003, 0.211184, 0.213325, 0.215426, 0.217486,
  0.219505, 0.221484, 0.223422, 0.225318, 0.227174, 0.228988, 0.23076,
  0.232491, 0.234179, 0.235826, 0.237431, 0.238994, 0.240515,
  0.241994, 0.24343, 0.244824, 0.246175, 0.247484, 0.24875, 0.249974,
  0.251155, 0.252294, 0.25339, 0.254443, 0.255454, 0.256422, 0.257347,
  0.25823, 0.25907, 0.259868, 0.260623, 0.261335, 0.262005, 0.262633,
  0.263218, 0.263761, 0.264262, 0.264721, 0.265137, 0.265512,
  0.265845, 0.266136, 0.266385, 0.266593, 0.26676, 0.266885, 0.266969,
  0.267011, 0.267013, 0.266975, 0.266895, 0.266775, 0.266615,
  0.266415, 0.266175, 0.265895, 0.265575, 0.265216, 0.264818, 0.26438,
  0.263904, 0.263389, 0.262835, 0.262244, 0.261614, 0.260947,
  0.260242, 0.259499, 0.25872, 0.257903, 0.25705, 0.256161, 0.255235,
  0.254274, 0.253277, 0.252244, 0.251177, 0.250074, 0.248937,
  0.247765, 0.24656, 0.245321, 0.244048, 0.242742, 0.241403, 0.240032,
  0.238628, 0.237193, 0.235725, 0.234227, 0.232697, 0.231136,
  0.229545, 0.227924, 0.226273, 0.224592, 0.222882, 0.221143,
  0.219376, 0.217581, 0.215758, 0.213907, 0.212029, 0.210124,
  0.208193, 0.206235, 0.204252, 0.202243, 0.200209, 0.19815, 0.196067,
  0.19396, 0.191829, 0.189675, 0.187498, 0.185298, 0.183076, 0.180832,
  0.178566, 0.17628, 0.173972, 0.171644, 0.169296, 0.166929, 0.164542,
  0.162136, 0.159711, 0.157268, 0.154808, 0.15233, 0.149835, 0.147323,
  0.144795, 0.142251, 0.139691, 0.137116, 0.134527, 0.131923,
  0.129305, 0.126673, 0.124028, 0.12137, 0.1187, 0.116017, 0.113323,
  0.110617, 0.107901, 0.105174, 0.102436, 0.0996887, 0.0969319,
  0.094166, 0.0913914, 0.0886085, 0.0858176, 0.0830191, 0.0802134,
  0.077401, 0.074582, 0.071757, 0.0689263, 0.0660903, 0.0632494,
  0.0604039, 0.0575541, 0.0547006, 0.0518436, 0.0489835, 0.0461207,
  0.0432555, 0.0403883, 0.0375196, 0.0346495, 0.0317786, 0.0289071,
  0.0260355, 0.023164, 0.0202931, 0.0174231, 0.0145544, 0.0116872,
  0.00882202, 0.00595914, 0.00309892, 0.0002417, -0.00261216,
  -0.00546233, -0.00830846, -0.0111502, -0.0139872, -0.0168192,
  -0.0196458, -0.0224666, -0.0252814, -0.0280899, -0.0308916,
  -0.0336862, -0.0364735, -0.0392531, -0.0420247, -0.044788,
  -0.0475426, -0.0502883, -0.0530246, -0.0557515, -0.0584684,
  -0.0611751, -0.0638714, -0.0665568, -0.0692312, -0.0718941,
  -0.0745454, -0.0771847, -0.0798118, -0.0824262, -0.0850279,
  -0.0876164, -0.0901915, -0.0927529, -0.0953004, -0.0978337,
  -0.100352, -0.102856, -0.105345, -0.107819, -0.110277, -0.11272,
  -0.115146, -0.117556, -0.119949, -0.122326, -0.124685, -0.127027,
  -0.129352, -0.131659, -0.133948, -0.136219, -0.138471, -0.140704,
  -0.142919, -0.145115, -0.147291, -0.149447, -0.151584, -0.153701,
  -0.155798, -0.157874, -0.15993, -0.161965, -0.163979, -0.165972,
  -0.167943, -0.169893, -0.171821, -0.173728, -0.175612, -0.177474,
  -0.179314, -0.181131, -0.182925, -0.184697, -0.186445, -0.18817,
  -0.189872, -0.19155, -0.193205, -0.194836, -0.196442, -0.198025,
  -0.199584, -0.201118, -0.202628, -0.204113, -0.205573, -0.207009,
  -0.20842, -0.209805, -0.211166, -0.212501, -0.213811, -0.215095,
  -0.216354, -0.217587, -0.218794, -0.219975, -0.221131, -0.22226,
  -0.223363, -0.224441, -0.225491, -0.226516, -0.227514, -0.228486,
  -0.229431, -0.23035, -0.231242, -0.232107, -0.232946, -0.233758,
  -0.234543, -0.235301, -0.236032, -0.236737, -0.237414, -0.238064,
  -0.238688, -0.239284, -0.239853, -0.240396, -0.240911, -0.241399,
  -0.24186, -0.242294, -0.2427, -0.24308, -0.243432, -0.243758,
  -0.244056, -0.244327, -0.244572, -0.244789, -0.244979, -0.245142,
  -0.245278, -0.245387, -0.245469, -0.245525, -0.245553, -0.245555,
  -0.24553, -0.245478, -0.245399, -0.245294, -0.245163, -0.245004,
  -0.24482, -0.244609, -0.244371, -0.244108, -0.243818, -0.243502,
  -0.24316, -0.242792, -0.242398, -0.241978, -0.241533, -0.241062,
  -0.240565, -0.240043, -0.239496, -0.238923, -0.238325, -0.237702,
  -0.237054, -0.236381, -0.235683, -0.234961, -0.234214, -0.233443,
  -0.232647, -0.231827, -0.230984, -0.230116, -0.229224, -0.228309,
  -0.22737, -0.226408, -0.225422, -0.224413, -0.223381, -0.222326,
  -0.221249, -0.220149, -0.219026, -0.217881, -0.216714, -0.215525,
  -0.214314, -0.213082, -0.211828, -0.210552, -0.209255, -0.207937,
  -0.206599, -0.205239, -0.203859, -0.202459, -0.201038, -0.199598,
  -0.198137, -0.196657, -0.195157, -0.193638, -0.192099, -0.190542,
  -0.188966, -0.187371, -0.185758, -0.184127, -0.182478, -0.180811,
  -0.179126, -0.177423, -0.175704, -0.173967, -0.172213, -0.170443,
  -0.168657, -0.166854, -0.165035, -0.1632, -0.161349, -0.159483,
  -0.157602, -0.155706, -0.153794, -0.151869, -0.149929, -0.147974,
  -0.146006, -0.144024, -0.142028, -0.140019, -0.137997, -0.135963,
  -0.133915, -0.131855, -0.129783, -0.127699, -0.125603, -0.123495,
  -0.121376, -0.119246, -0.117105, -0.114954, -0.112792, -0.110619,
  -0.108437, -0.106245, -0.104044, -0.101833, -0.0996135, -0.0973849,
  -0.0951478, -0.0929023, -0.0906486, -0.0883871, -0.0861179,
  -0.0838413, -0.0815575, -0.0792667, -0.0769693, -0.0746653,
  -0.072355, -0.0700388, -0.0677168, -0.0653892, -0.0630563,
  -0.0607183, -0.0583755, -0.0560281, -0.0536763, -0.0513204,
  -0.0489606, -0.0465971, -0.0442302, -0.0418601, -0.0394871,
  -0.0371113, -0.0347331, -0.0323526, -0.0299701, -0.0275858, -0.0252,
  -0.0228129, -0.0204247, -0.0180357, -0.0156461, -0.0132561,
  -0.010866, -0.00847599, -0.00608631, -0.0036972, -0.00130888,
  0.0010784, 0.00346443, 0.00584896, 0.00823178, 0.0106126, 0.0129913,
  0.0153676, 0.0177412, 0.020112, 0.0224797, 0.024844, 0.0272048,
  0.0295618, 0.0319149, 0.0342637, 0.0366081, 0.0389478, 0.0412826,
  0.0436123, 0.0459367, 0.0482556, 0.0505687, 0.0528757, 0.0551766,
  0.0574711, 0.059759, 0.06204, 0.0643139, 0.0665806, 0.0688398,
  0.0710913, 0.0733349, 0.0755703, 0.0777975, 0.0800162, 0.0822261,
  0.084427, 0.0866189, 0.0888014, 0.0909743, 0.0931376, 0.0952908,
  0.097434, 0.0995668, 0.101689, 0.103801, 0.105901, 0.107991,
  0.110069, 0.112136, 0.114191, 0.116234, 0.118265, 0.120284,
  0.122291, 0.124285, 0.126266, 0.128234, 0.130189, 0.132131, 0.13406,
  0.135974, 0.137875, 0.139762, 0.141635, 0.143493, 0.145337,
  0.147167, 0.148981, 0.150781, 0.152565, 0.154334, 0.156088,
  0.157826, 0.159548, 0.161254, 0.162945, 0.164619, 0.166277,
  0.167918, 0.169543, 0.17115, 0.172741, 0.174315, 0.175872, 0.177411,
  0.178933, 0.180438, 0.181924, 0.183393, 0.184844, 0.186277,
  0.187691, 0.189088, 0.190465, 0.191825, 0.193165, 0.194487, 0.19579,
  0.197073, 0.198338, 0.199583, 0.200809, 0.202016, 0.203203,
  0.204371, 0.205518, 0.206646, 0.207754, 0.208842, 0.20991, 0.210957,
  0.211985, 0.212992, 0.213978, 0.214944, 0.21589, 0.216815, 0.217719,
  0.218602, 0.219464, 0.220306, 0.221126, 0.221925, 0.222703, 0.22346,
  0.224196, 0.22491, 0.225603, 0.226275, 0.226925, 0.227553, 0.22816,
  0.228745, 0.229309, 0.229851, 0.230371, 0.230869, 0.231346,
  0.231801, 0.232234, 0.232645, 0.233034, 0.233401, 0.233746,
  0.234069, 0.23437, 0.234649, 0.234906, 0.235141, 0.235354, 0.235545,
  0.235713, 0.23586, 0.235984, 0.236087, 0.236167, 0.236225, 0.236261,
  0.236275, 0.236267, 0.236237, 0.236185, 0.236111, 0.236015,
  0.235897, 0.235757, 0.235594, 0.23541, 0.235204, 0.234977, 0.234727,
  0.234456, 0.234162, 0.233847, 0.233511, 0.233152, 0.232772,
  0.232371, 0.231948, 0.231503, 0.231037, 0.23055, 0.230041, 0.229511,
  0.22896, 0.228387, 0.227794, 0.227179, 0.226544, 0.225888, 0.22521,
  0.224512, 0.223794, 0.223054, 0.222294, 0.221514, 0.220713,
  0.219892, 0.219051, 0.21819, 0.217308, 0.216407, 0.215485, 0.214544,
  0.213583, 0.212603, 0.211603, 0.210584, 0.209545, 0.208487, 0.20741,
  0.206314, 0.205199, 0.204065, 0.202913, 0.201742, 0.200552,
  0.199344, 0.198118, 0.196874, 0.195612, 0.194332, 0.193034,
  0.191719, 0.190386, 0.189035, 0.187668, 0.186283, 0.184881,
  0.183463, 0.182027, 0.180576, 0.179107, 0.177622, 0.176122,
  0.174605, 0.173072, 0.171523, 0.169959, 0.168379, 0.166784,
  0.165174, 0.163549, 0.161909, 0.160254, 0.158584, 0.156901,
  0.155202, 0.15349, 0.151764, 0.150024, 0.148271, 0.146504, 0.144723,
  0.14293, 0.141123, 0.139304, 0.137472, 0.135628, 0.133771, 0.131903,
  0.130022, 0.128129, 0.126225, 0.12431, 0.122383, 0.120445, 0.118496,
  0.116536, 0.114566, 0.112586, 0.110595, 0.108594, 0.106584,
  0.104563, 0.102534, 0.100495, 0.0984467, 0.0963897, 0.094324,
  0.0922498, 0.0901672, 0.0880765, 0.0859778, 0.0838714, 0.0817573,
  0.0796359, 0.0775072, 0.0753716, 0.0732291, 0.07108, 0.0689245,
  0.0667628, 0.064595, 0.0624214, 0.0602421, 0.0580575, 0.0558675,
  0.0536725, 0.0514727, 0.0492682, 0.0470593, 0.0448461, 0.0426289,
  0.0404078, 0.0381831, 0.0359549, 0.0337234, 0.031489, 0.0292517,
  0.0270117, 0.0247693, 0.0225247, 0.020278, 0.0180295, 0.0157794,
  0.0135278, 0.0112751, 0.00902127, 0.00676666, 0.00451145,
  0.00225583, -0, -0.00225583, -0.00451145, -0.00676666, -0.00902127,
  -0.0112751, -0.0135278, -0.0157794, -0.0180295, -0.020278,
  -0.0225247, -0.0247693, -0.0270117, -0.0292517, -0.031489,
  -0.0337234, -0.0359549, -0.0381831, -0.0404078, -0.0426289,
  -0.0448461, -0.0470593, -0.0492682, -0.0514727, -0.0536725,
  -0.0558675, -0.0580575, -0.0602421, -0.0624214, -0.064595,
  -0.0667628, -0.0689245, -0.07108, -0.0732291, -0.0753716,
  -0.0775072, -0.0796359, -0.0817573, -0.0838714, -0.0859778,
  -0.0880765, -0.0901672, -0.0922498, -0.094324, -0.0963897,
  -0.0984467, -0.100495, -0.102534, -0.104563, -0.106584, -0.108594,
  -0.110595, -0.112586, -0.114566, -0.116536, -0.118496, -0.120445,
  -0.122383, -0.12431, -0.126225, -0.128129, -0.130022, -0.131903,
  -0.133771, -0.135628, -0.137472, -0.139304, -0.141123, -0.14293,
  -0.144723, -0.146504, -0.148271, -0.150024, -0.151764, -0.15349,
  -0.155202, -0.156901, -0.158584, -0.160254, -0.161909, -0.163549,
  -0.165174, -0.166784, -0.168379, -0.169959, -0.171523, -0.173072,
  -0.174605, -0.176122, -0.177622, -0.179107, -0.180576, -0.182027,
  -0.183463, -0.184881, -0.186283, -0.187668, -0.189035, -0.190386,
  -0.191719, -0.193034, -0.194332, -0.195612, -0.196874, -0.198118,
  -0.199344, -0.200552, -0.201742, -0.202913, -0.204065, -0.205199,
  -0.206314, -0.20741, -0.208487, -0.209545, -0.210584, -0.211603,
  -0.212603, -0.213583, -0.214544, -0.215485, -0.216407, -0.217308,
  -0.21819, -0.219051, -0.219892, -0.220713, -0.221514, -0.222294,
  -0.223054, -0.223794, -0.224512, -0.22521, -0.225888, -0.226544,
  -0.227179, -0.227794, -0.228387, -0.22896, -0.229511, -0.230041,
  -0.23055, -0.231037, -0.231503, -0.231948, -0.232371, -0.232772,
  -0.233152, -0.233511, -0.233847, -0.234162, -0.234456, -0.234727,
  -0.234977, -0.235204, -0.23541, -0.235594, -0.235757, -0.235897,
  -0.236015, -0.236111, -0.236185, -0.236237, -0.236267, -0.236275,
  -0.236261, -0.236225, -0.236167, -0.236087, -0.235984, -0.23586,
  -0.235713, -0.235545, -0.235354, -0.235141, -0.234906, -0.234649,
  -0.23437, -0.234069, -0.233746, -0.233401, -0.233034, -0.232645,
  -0.232234, -0.231801, -0.231346, -0.230869, -0.230371, -0.229851,
  -0.229309, -0.228745, -0.22816, -0.227553, -0.226925, -0.226275,
  -0.225603, -0.22491, -0.224196, -0.22346, -0.222703, -0.221925,
  -0.221126, -0.220306, -0.219464, -0.218602, -0.217719, -0.216815,
  -0.21589, -0.214944, -0.213978, -0.212992, -0.211985, -0.210957,
  -0.20991, -0.208842, -0.207754, -0.206646, -0.205518, -0.204371,
  -0.203203, -0.202016, -0.200809, -0.199583, -0.198338, -0.197073,
  -0.19579, -0.194487, -0.193165, -0.191825, -0.190465, -0.189088,
  -0.187691, -0.186277, -0.184844, -0.183393, -0.181924, -0.180438,
  -0.178933, -0.177411, -0.175872, -0.174315, -0.172741, -0.17115,
  -0.169543, -0.167918, -0.166277, -0.164619, -0.162945, -0.161254,
  -0.159548, -0.157826, -0.156088, -0.154334, -0.152565, -0.150781,
  -0.148981, -0.147167, -0.145337, -0.143493, -0.141635, -0.139762,
  -0.137875, -0.135974, -0.13406, -0.132131, -0.130189, -0.128234,
  -0.126266, -0.124285, -0.122291, -0.120284, -0.118265, -0.116234,
  -0.114191, -0.112136, -0.110069, -0.107991, -0.105901, -0.103801,
  -0.101689, -0.0995668, -0.097434, -0.0952908, -0.0931376,
  -0.0909743, -0.0888014, -0.0866189, -0.084427, -0.0822261,
  -0.0800162, -0.0777975, -0.0755703, -0.0733349, -0.0710913,
  -0.0688398, -0.0665806, -0.0643139, -0.06204, -0.059759, -0.0574711,
  -0.0551766, -0.0528757, -0.0505687, -0.0482556, -0.0459367,
  -0.0436123, -0.0412826, -0.0389478, -0.0366081, -0.0342637,
  -0.0319149, -0.0295618, -0.0272048, -0.024844, -0.0224797,
  -0.020112, -0.0177412, -0.0153676, -0.0129913, -0.0106126,
  -0.00823178, -0.00584896, -0.00346443, -0.0010784, 0.00130888,
  0.0036972, 0.00608631, 0.00847599, 0.010866, 0.0132561, 0.0156461,
  0.0180357, 0.0204247, 0.0228129, 0.0252, 0.0275858, 0.0299701,
  0.0323526, 0.0347331, 0.0371113, 0.0394871, 0.0418601, 0.0442302,
  0.0465971, 0.0489606, 0.0513204, 0.0536763, 0.0560281, 0.0583755,
  0.0607183, 0.0630563, 0.0653892, 0.0677168, 0.0700388, 0.072355,
  0.0746653, 0.0769693, 0.0792667, 0.0815575, 0.0838413, 0.0861179,
  0.0883871, 0.0906486, 0.0929023, 0.0951478, 0.0973849, 0.0996135,
  0.101833, 0.104044, 0.106245, 0.108437, 0.110619, 0.112792,
  0.114954, 0.117105, 0.119246, 0.121376, 0.123495, 0.125603,
  0.127699, 0.129783, 0.131855, 0.133915, 0.135963, 0.137997,
  0.140019, 0.142028, 0.144024, 0.146006, 0.147974, 0.149929,
  0.151869, 0.153794, 0.155706, 0.157602, 0.159483, 0.161349, 0.1632,
  0.165035, 0.166854, 0.168657, 0.170443, 0.172213, 0.173967,
  0.175704, 0.177423, 0.179126, 0.180811, 0.182478, 0.184127,
  0.185758, 0.187371, 0.188966, 0.190542, 0.192099, 0.193638,
  0.195157, 0.196657, 0.198137, 0.199598, 0.201038, 0.202459,
  0.203859, 0.205239, 0.206599, 0.207937, 0.209255, 0.210552,
  0.211828, 0.213082, 0.214314, 0.215525, 0.216714, 0.217881,
  0.219026, 0.220149, 0.221249, 0.222326, 0.223381, 0.224413,
  0.225422, 0.226408, 0.22737, 0.228309, 0.229224, 0.230116, 0.230984,
  0.231827, 0.232647, 0.233443, 0.234214, 0.234961, 0.235683,
  0.236381, 0.237054, 0.237702, 0.238325, 0.238923, 0.239496,
  0.240043, 0.240565, 0.241062, 0.241533, 0.241978, 0.242398,
  0.242792, 0.24316, 0.243502, 0.243818, 0.244108, 0.244371, 0.244609,
  0.24482, 0.245004, 0.245163, 0.245294, 0.245399, 0.245478, 0.24553,
  0.245555, 0.245553, 0.245525, 0.245469, 0.245387, 0.245278,
  0.245142, 0.244979, 0.244789, 0.244572, 0.244327, 0.244056,
  0.243758, 0.243432, 0.24308, 0.2427, 0.242294, 0.24186, 0.241399,
  0.240911, 0.240396, 0.239853, 0.239284, 0.238688, 0.238064,
  0.237414, 0.236737, 0.236032, 0.235301, 0.234543, 0.233758,
  0.232946, 0.232107, 0.231242, 0.23035, 0.229431, 0.228486, 0.227514,
  0.226516, 0.225491, 0.224441, 0.223363, 0.22226, 0.221131, 0.219975,
  0.218794, 0.217587, 0.216354, 0.215095, 0.213811, 0.212501,
  0.211166, 0.209805, 0.20842, 0.207009, 0.205573, 0.204113, 0.202628,
  0.201118, 0.199584, 0.198025, 0.196442, 0.194836, 0.193205, 0.19155,
  0.189872, 0.18817, 0.186445, 0.184697, 0.182925, 0.181131, 0.179314,
  0.177474, 0.175612, 0.173728, 0.171821, 0.169893, 0.167943,
  0.165972, 0.163979, 0.161965, 0.15993, 0.157874, 0.155798, 0.153701,
  0.151584, 0.149447, 0.147291, 0.145115, 0.142919, 0.140704,
  0.138471, 0.136219, 0.133948, 0.131659, 0.129352, 0.127027,
  0.124685, 0.122326, 0.119949, 0.117556, 0.115146, 0.11272, 0.110277,
  0.107819, 0.105345, 0.102856, 0.100352, 0.0978337, 0.0953004,
  0.0927529, 0.0901915, 0.0876164, 0.0850279, 0.0824262, 0.0798118,
  0.0771847, 0.0745454, 0.0718941, 0.0692312, 0.0665568, 0.0638714,
  0.0611751, 0.0584684, 0.0557515, 0.0530246, 0.0502883, 0.0475426,
  0.044788, 0.0420247, 0.0392531, 0.0364735, 0.0336862, 0.0308916,
  0.0280899, 0.0252814, 0.0224666, 0.0196458, 0.0168192, 0.0139872,
  0.0111502, 0.00830846, 0.00546233, 0.00261216, -0.0002417,
  -0.00309892, -0.00595914, -0.00882202, -0.0116872, -0.0145544,
  -0.0174231, -0.0202931, -0.023164, -0.0260355, -0.0289071,
  -0.0317786, -0.0346495, -0.0375196, -0.0403883, -0.0432555,
  -0.0461207, -0.0489835, -0.0518436, -0.0547006, -0.0575541,
  -0.0604039, -0.0632494, -0.0660903, -0.0689263, -0.071757,
  -0.074582, -0.077401, -0.0802134, -0.0830191, -0.0858176,
  -0.0886085, -0.0913914, -0.094166, -0.0969319, -0.0996887,
  -0.102436, -0.105174, -0.107901, -0.110617, -0.113323, -0.116017,
  -0.1187, -0.12137, -0.124028, -0.126673, -0.129305, -0.131923,
  -0.134527, -0.137116, -0.139691, -0.142251, -0.144795, -0.147323,
  -0.149835, -0.15233, -0.154808, -0.157268, -0.159711, -0.162136,
  -0.164542, -0.166929, -0.169296, -0.171644, -0.173972, -0.17628,
  -0.178566, -0.180832, -0.183076, -0.185298, -0.187498, -0.189675,
  -0.191829, -0.19396, -0.196067, -0.19815, -0.200209, -0.202243,
  -0.204252, -0.206235, -0.208193, -0.210124, -0.212029, -0.213907,
  -0.215758, -0.217581, -0.219376, -0.221143, -0.222882, -0.224592,
  -0.226273, -0.227924, -0.229545, -0.231136, -0.232697, -0.234227,
  -0.235725, -0.237193, -0.238628, -0.240032, -0.241403, -0.242742,
  -0.244048, -0.245321, -0.24656, -0.247765, -0.248937, -0.250074,
  -0.251177, -0.252244, -0.253277, -0.254274, -0.255235, -0.256161,
  -0.25705, -0.257903, -0.25872, -0.259499, -0.260242, -0.260947,
  -0.261614, -0.262244, -0.262835, -0.263389, -0.263904, -0.26438,
  -0.264818, -0.265216, -0.265575, -0.265895, -0.266175, -0.266415,
  -0.266615, -0.266775, -0.266895, -0.266975, -0.267013, -0.267011,
  -0.266969, -0.266885, -0.26676, -0.266593, -0.266385, -0.266136,
  -0.265845, -0.265512, -0.265137, -0.264721, -0.264262, -0.263761,
  -0.263218, -0.262633, -0.262005, -0.261335, -0.260623, -0.259868,
  -0.25907, -0.25823, -0.257347, -0.256422, -0.255454, -0.254443,
  -0.25339, -0.252294, -0.251155, -0.249974, -0.24875, -0.247484,
  -0.246175, -0.244824, -0.24343, -0.241994, -0.240515, -0.238994,
  -0.237431, -0.235826, -0.234179, -0.232491, -0.23076, -0.228988,
  -0.227174, -0.225318, -0.223422, -0.221484, -0.219505, -0.217486,
  -0.215426, -0.213325, -0.211184, -0.209003, -0.206782, -0.204521,
  -0.202221, -0.199882, -0.197503, -0.195086, -0.19263, -0.190135,
  -0.187603, -0.185033, -0.182425, -0.17978, -0.177099, -0.17438,
  -0.171625, -0.168834, -0.166008, -0.163146, -0.160249, -0.157317,
  -0.154351, -0.151351, -0.148318, -0.145251, -0.142151, -0.139019,
  -0.135855, -0.132659, -0.129433, -0.126175, -0.122887, -0.119569,
  -0.116222, -0.112846, -0.109441, -0.106008, -0.102548, -0.0990609,
  -0.0955472, -0.0920074, -0.0884422, -0.084852, -0.0812374,
  -0.0775989, -0.0739371, -0.0702525, -0.0665458, -0.0628175,
  -0.0590681, -0.0552983, -0.0515087, -0.0476998, -0.0438724,
  -0.040027, -0.0361643, -0.0322849, -0.0283895, -0.0244787,
  -0.0205531, -0.0166136, -0.0126607, -0.00869509, -0.00471754,
  -0.000728742, 0.00327061, 0.00727978, 0.011298, 0.0153247,
  0.0193589, 0.0234, 0.0274473, 0.0314998, 0.035557, 0.0396179,
  0.0436819, 0.047748, 0.0518156, 0.0558838, 0.0599517, 0.0640186,
  0.0680837, 0.0721461, 0.0762049, 0.0802594, 0.0843087, 0.0883518,
  0.092388, 0.0964164, 0.100436, 0.104446, 0.108446, 0.112434,
  0.11641, 0.120373, 0.124321, 0.128255, 0.132173, 0.136074, 0.139957,
  0.143821, 0.147666, 0.15149, 0.155293, 0.159073, 0.16283, 0.166562,
  0.170269, 0.17395, 0.177603, 0.181228, 0.184823, 0.188389, 0.191923,
  0.195425, 0.198894, 0.202329, 0.205728, 0.209091, 0.212417,
  0.215705, 0.218954, 0.222162, 0.22533, 0.228455, 0.231537, 0.234575,
  0.237568, 0.240514, 0.243414, 0.246265, 0.249067, 0.251818,
  0.254519, 0.257167, 0.259763, 0.262304, 0.26479, 0.267219, 0.269592,
  0.271906, 0.274162, 0.276357, 0.278491, 0.280564, 0.282573,
  0.284518, 0.286399, 0.288213, 0.289961, 0.291641, 0.293253,
  0.294795, 0.296266, 0.297666, 0.298993, 0.300248, 0.301428,
  0.302533, 0.303563, 0.304515, 0.305391, 0.306187, 0.306905,
  0.307542, 0.308098, 0.308573, 0.308965, 0.309274, 0.309499, 0.30964,
  0.309694, 0.309663, 0.309544, 0.309338, 0.309043, 0.30866, 0.308187,
  0.307623, 0.306969, 0.306223, 0.305385, 0.304454, 0.30343, 0.302313,
  0.301101, 0.299794, 0.298392, 0.296895, 0.295301, 0.293611,
  0.291824, 0.28994, 0.287958, 0.285878, 0.2837, 0.281424, 0.279049,
  0.276575, 0.274002, 0.27133, 0.268558, 0.265687, 0.262716, 0.259646,
  0.256476, 0.253207, 0.249838, 0.24637, 0.242802, 0.239135, 0.235369,
  0.231504, 0.227541, 0.22348, 0.21932, 0.215063, 0.210709, 0.206258,
  0.201711, 0.197068, 0.192329, 0.187497, 0.18257, 0.17755, 0.172438,
  0.167233, 0.161938, 0.156553, 0.151078, 0.145516, 0.139866, 0.13413,
  0.128309, 0.122404, 0.116416, 0.110347, 0.104198, 0.0979703,
  0.0916651, 0.0852841, 0.0788289, 0.0723009, 0.0657019, 0.0590336,
  0.0522977, 0.0454961, 0.0386306, 0.0317033, 0.0247162, 0.0176713,
  0.0105708, 0.00341698, -0.00378795, -0.0110416, -0.0183415,
  -0.0256853, -0.0330702, -0.0404937, -0.0479531, -0.0554455,
  -0.0629681, -0.0705179, -0.0780919, -0.085687, -0.0933001,
  -0.100928, -0.108567, -0.116213, -0.123864, -0.131516, -0.139165,
  -0.146807, -0.154438, -0.162055, -0.169653, -0.177228, -0.184777,
  -0.192293, -0.199774, -0.207215, -0.21461, -0.221955, -0.229246,
  -0.236478, -0.243645, -0.250741, -0.257763, -0.264705, -0.27156,
  -0.278324, -0.284991, -0.291554, -0.298009, -0.304348, -0.310567,
  -0.316657, -0.322614, -0.32843, -0.334099, -0.339614, -0.344968,
  -0.350154, -0.355165, -0.359994, -0.364632, -0.369073, -0.373309,
  -0.377331, -0.381132, -0.384704, -0.388039, -0.391127, -0.393961,
  -0.396532, -0.39883, -0.400847, -0.402573, -0.404, -0.405117,
  -0.405916, -0.406385, -0.406516, -0.406297, -0.40572, -0.404772,
  -0.403445, -0.401725, -0.399604, -0.397069, -0.394109, -0.390713,
  -0.386869, -0.382564, -0.377788, -0.372527, -0.366769, -0.360502,
  -0.353712, -0.346387, -0.338513, -0.330077, -0.321065, -0.311463,
  -0.301257, -0.290434, -0.278977, -0.266874, -0.254108, -0.240665,
  -0.22653, -0.211686, -0.196118, -0.179809, -0.162745, -0.144907,
  -0.12628, -0.106847, -0.0865894, -0.0654908, -0.0435333, -0.020699,
  0.00303044, 0.0276733, 0.0532483, 0.0797744, 0.107271, 0.135757,
  0.165253, 0.195778, 0.227353, 0.259998, 0.293735, 0.328583,
  0.364566, 0.401703, 0.440018, 0.479532, 0.520268, 0.562248,
  0.605497, 0.650037, 0.695891, 0.743085, 0.791642, 0.841587,
  0.892945, 0.94574, 1}; G4double G4NeutronHPFastLegendre::i11[2401] =
  {0, -0.000810619, -0.00157663, -0.00229925, -0.00297967,
  -0.00361904, -0.00421851, -0.00477922, -0.00530227, -0.00578874,
  -0.0062397, -0.00665619, -0.00703925, -0.00738988, -0.00770908,
  -0.00799781, -0.00825703, -0.00848767, -0.00869065, -0.00886688,
  -0.00901724, -0.00914259, -0.00924378, -0.00932164, -0.009377,
  -0.00941065, -0.00942338, -0.00941595, -0.00938912, -0.00934363,
  -0.00928021, -0.00919955, -0.00910235, -0.0089893, -0.00886106,
  -0.00871827, -0.00856158, -0.00839161, -0.00820897, -0.00801426,
  -0.00780805, -0.00759093, -0.00736344, -0.00712614, -0.00687956,
  -0.00662421, -0.00636062, -0.00608927, -0.00581065, -0.00552523,
  -0.00523349, -0.00493586, -0.00463279, -0.00432472, -0.00401205,
  -0.0036952, -0.00337457, -0.00305055, -0.00272351, -0.00239382,
  -0.00206184, -0.00172792, -0.00139241, -0.00105562, -0.000717892,
  -0.000379526, -4.08283e-05, 0.000297905, 0.000636387, 0.000974341,
  0.0013115, 0.00164759, 0.00198237, 0.00231559, 0.00264701,
  0.0029764, 0.00330354, 0.00362821, 0.0039502, 0.00426932,
  0.00458536, 0.00489814, 0.00520748, 0.00551321, 0.00581515,
  0.00611315, 0.00640704, 0.00669669, 0.00698194, 0.00726267,
  0.00753873, 0.00781001, 0.00807638, 0.00833774, 0.00859396,
  0.00884495, 0.00909061, 0.00933085, 0.00956557, 0.00979469,
  0.0100181, 0.0102358, 0.0104477, 0.0106537, 0.0108538, 0.0110478,
  0.0112358, 0.0114177, 0.0115935, 0.0117631, 0.0119265, 0.0120836,
  0.0122344, 0.0123789, 0.0125172, 0.012649, 0.0127746, 0.0128937,
  0.0130065, 0.0131129, 0.0132129, 0.0133066, 0.0133939, 0.0134748,
  0.0135494, 0.0136176, 0.0136795, 0.0137352, 0.0137845, 0.0138276,
  0.0138644, 0.0138951, 0.0139196, 0.0139379, 0.0139501, 0.0139563,
  0.0139565, 0.0139506, 0.0139389, 0.0139212, 0.0138977, 0.0138684,
  0.0138333, 0.0137926, 0.0137462, 0.0136942, 0.0136367, 0.0135737,
  0.0135053, 0.0134316, 0.0133526, 0.0132683, 0.0131789, 0.0130844,
  0.0129849, 0.0128805, 0.0127711, 0.0126569, 0.012538, 0.0124144,
  0.0122862, 0.0121535, 0.0120164, 0.0118748, 0.011729, 0.0115789,
  0.0114247, 0.0112665, 0.0111042, 0.010938, 0.0107681, 0.0105943,
  0.0104169, 0.0102359, 0.0100514, 0.00986346, 0.00967219, 0.00947765,
  0.00927993, 0.00907912, 0.00887529, 0.00866853, 0.00845892,
  0.00824654, 0.00803149, 0.00781383, 0.00759365, 0.00737104,
  0.00714608, 0.00691885, 0.00668944, 0.00645792, 0.00622438,
  0.00598891, 0.00575158, 0.00551247, 0.00527167, 0.00502927,
  0.00478533, 0.00453994, 0.00429319, 0.00404514, 0.00379589,
  0.00354551, 0.00329408, 0.00304168, 0.00278839, 0.00253429,
  0.00227944, 0.00202394, 0.00176785, 0.00151126, 0.00125423,
  0.00099685, 0.000739185, 0.000481311, 0.000223302, -3.47693e-05,
  -0.000292831, -0.000550812, -0.00080864, -0.00106625, -0.00132356,
  -0.00158051, -0.00183703, -0.00209306, -0.00234852, -0.00260335,
  -0.00285748, -0.00311085, -0.0033634, -0.00361506, -0.00386576,
  -0.00411545, -0.00436406, -0.00461154, -0.00485782, -0.00510284,
  -0.00534656, -0.00558889, -0.00582981, -0.00606923, -0.00630712,
  -0.00654341, -0.00677806, -0.007011, -0.00724219, -0.00747158,
  -0.00769911, -0.00792474, -0.00814842, -0.00837009, -0.00858972,
  -0.00880725, -0.00902264, -0.00923585, -0.00944682, -0.00965553,
  -0.00986192, -0.010066, -0.0102676, -0.0104668, -0.0106635,
  -0.0108577, -0.0110494, -0.0112385, -0.011425, -0.0116088,
  -0.0117899, -0.0119683, -0.0121439, -0.0123167, -0.0124868,
  -0.0126539, -0.0128182, -0.0129796, -0.0131381, -0.0132936,
  -0.0134461, -0.0135956, -0.0137421, -0.0138855, -0.0140259,
  -0.0141631, -0.0142973, -0.0144283, -0.0145561, -0.0146807,
  -0.0148022, -0.0149204, -0.0150355, -0.0151472, -0.0152557,
  -0.015361, -0.0154629, -0.0155616, -0.0156569, -0.015749,
  -0.0158377, -0.0159231, -0.0160051, -0.0160837, -0.0161591,
  -0.016231, -0.0162996, -0.0163648, -0.0164266, -0.016485, -0.01654,
  -0.0165917, -0.01664, -0.0166848, -0.0167263, -0.0167644,
  -0.0167991, -0.0168305, -0.0168584, -0.016883, -0.0169041,
  -0.016922, -0.0169364, -0.0169475, -0.0169552, -0.0169596,
  -0.0169607, -0.0169584, -0.0169528, -0.0169439, -0.0169317,
  -0.0169162, -0.0168975, -0.0168755, -0.0168502, -0.0168216,
  -0.0167899, -0.0167549, -0.0167168, -0.0166754, -0.0166309,
  -0.0165833, -0.0165325, -0.0164786, -0.0164216, -0.0163615,
  -0.0162984, -0.0162322, -0.016163, -0.0160908, -0.0160156,
  -0.0159374, -0.0158564, -0.0157723, -0.0156854, -0.0155957,
  -0.0155031, -0.0154076, -0.0153094, -0.0152083, -0.0151046,
  -0.014998, -0.0148888, -0.014777, -0.0146624, -0.0145453,
  -0.0144255, -0.0143032, -0.0141783, -0.0140509, -0.0139211,
  -0.0137888, -0.013654, -0.0135169, -0.0133773, -0.0132355,
  -0.0130913, -0.0129449, -0.0127962, -0.0126452, -0.0124921,
  -0.0123369, -0.0121795, -0.01202, -0.0118584, -0.0116948,
  -0.0115293, -0.0113617, -0.0111922, -0.0110209, -0.0108476,
  -0.0106725, -0.0104956, -0.010317, -0.0101366, -0.00995453,
  -0.00977078, -0.0095854, -0.00939843, -0.00920988, -0.00901981,
  -0.00882825, -0.00863523, -0.00844078, -0.00824494, -0.00804774,
  -0.00784923, -0.00764943, -0.00744838, -0.00724612, -0.00704268,
  -0.00683809, -0.0066324, -0.00642563, -0.00621783, -0.00600902,
  -0.00579925, -0.00558854, -0.00537694, -0.00516448, -0.0049512,
  -0.00473712, -0.0045223, -0.00430675, -0.00409052, -0.00387365,
  -0.00365616, -0.0034381, -0.0032195, -0.00300039, -0.00278082,
  -0.0025608, -0.00234039, -0.00211961, -0.00189851, -0.0016771,
  -0.00145544, -0.00123356, -0.00101148, -0.000789246, -0.000566891,
  -0.00034445, -0.000121955, 0.000100558, 0.000323056, 0.000545505,
  0.000767871, 0.00099012, 0.00121222, 0.00143413, 0.00165583,
  0.00187728, 0.00209845, 0.0023193, 0.0025398, 0.00275992,
  0.00297963, 0.00319889, 0.00341768, 0.00363595, 0.00385369,
  0.00407085, 0.00428742, 0.00450334, 0.00471861, 0.00493317,
  0.00514701, 0.0053601, 0.0055724, 0.00578388, 0.00599451,
  0.00620427, 0.00641313, 0.00662105, 0.00682802, 0.00703399,
  0.00723894, 0.00744285, 0.00764568, 0.00784741, 0.00804801,
  0.00824745, 0.00844571, 0.00864277, 0.00883858, 0.00903313,
  0.0092264, 0.00941835, 0.00960897, 0.00979822, 0.00998608,
  0.0101725, 0.0103575, 0.0105411, 0.0107232, 0.0109037, 0.0110828,
  0.0112602, 0.0114361, 0.0116104, 0.0117831, 0.0119541, 0.0121235,
  0.0122912, 0.0124572, 0.0126215, 0.012784, 0.0129447, 0.0131037,
  0.0132608, 0.0134162, 0.0135697, 0.0137213, 0.013871, 0.0140189,
  0.0141648, 0.0143088, 0.0144509, 0.014591, 0.0147291, 0.0148652,
  0.0149993, 0.0151314, 0.0152614, 0.0153894, 0.0155153, 0.0156391,
  0.0157608, 0.0158805, 0.0159979, 0.0161133, 0.0162265, 0.0163375,
  0.0164463, 0.016553, 0.0166574, 0.0167597, 0.0168597, 0.0169575,
  0.0170531, 0.0171464, 0.0172374, 0.0173262, 0.0174127, 0.0174969,
  0.0175789, 0.0176585, 0.0177358, 0.0178108, 0.0178835, 0.0179538,
  0.0180218, 0.0180875, 0.0181508, 0.0182118, 0.0182704, 0.0183267,
  0.0183806, 0.0184321, 0.0184813, 0.018528, 0.0185724, 0.0186144,
  0.0186541, 0.0186913, 0.0187262, 0.0187586, 0.0187887, 0.0188164,
  0.0188417, 0.0188646, 0.0188851, 0.0189032, 0.0189189, 0.0189322,
  0.0189431, 0.0189517, 0.0189578, 0.0189616, 0.018963, 0.018962,
  0.0189586, 0.0189529, 0.0189448, 0.0189343, 0.0189215, 0.0189063,
  0.0188887, 0.0188689, 0.0188466, 0.018822, 0.0187951, 0.0187659,
  0.0187343, 0.0187005, 0.0186643, 0.0186258, 0.0185851, 0.018542,
  0.0184967, 0.0184491, 0.0183993, 0.0183472, 0.0182928, 0.0182362,
  0.0181774, 0.0181164, 0.0180532, 0.0179878, 0.0179202, 0.0178504,
  0.0177785, 0.0177044, 0.0176281, 0.0175498, 0.0174693, 0.0173867,
  0.0173021, 0.0172153, 0.0171265, 0.0170356, 0.0169427, 0.0168478,
  0.0167508, 0.0166518, 0.0165509, 0.016448, 0.0163431, 0.0162363,
  0.0161275, 0.0160168, 0.0159043, 0.0157898, 0.0156735, 0.0155553,
  0.0154353, 0.0153134, 0.0151898, 0.0150644, 0.0149372, 0.0148082,
  0.0146775, 0.0145451, 0.014411, 0.0142752, 0.0141377, 0.0139985,
  0.0138578, 0.0137154, 0.0135714, 0.0134259, 0.0132787, 0.0131301,
  0.0129799, 0.0128282, 0.012675, 0.0125204, 0.0123643, 0.0122068,
  0.0120478, 0.0118875, 0.0117258, 0.0115628, 0.0113984, 0.0112328,
  0.0110658, 0.0108976, 0.0107281, 0.0105574, 0.0103855, 0.0102124,
  0.0100381, 0.00986271, 0.00968618, 0.00950855, 0.00932984,
  0.00915007, 0.00896926, 0.00878743, 0.00860461, 0.00842081,
  0.00823606, 0.00805038, 0.0078638, 0.00767632, 0.00748798,
  0.0072988, 0.0071088, 0.006918, 0.00672642, 0.00653409, 0.00634103,
  0.00614725, 0.00595279, 0.00575766, 0.00556189, 0.0053655,
  0.00516851, 0.00497095, 0.00477283, 0.00457418, 0.00437503,
  0.00417538, 0.00397528, 0.00377473, 0.00357377, 0.00337241,
  0.00317068, 0.00296859, 0.00276618, 0.00256347, 0.00236047,
  0.00215721, 0.00195372, 0.00175001, 0.0015461, 0.00134203,
  0.00113781, 0.000933471, 0.000729025, 0.0005245, 0.000319917,
  0.0001153, -8.93306e-05, -0.000293951, -0.000498539, -0.000703073,
  -0.000907531, -0.00111189, -0.00131613, -0.00152022, -0.00172415,
  -0.0019279, -0.00213143, -0.00233474, -0.00253779, -0.00274057,
  -0.00294305, -0.00314521, -0.00334704, -0.0035485, -0.00374959,
  -0.00395027, -0.00415052, -0.00435033, -0.00454967, -0.00474853,
  -0.00494687, -0.00514469, -0.00534196, -0.00553865, -0.00573476,
  -0.00593025, -0.00612511, -0.00631931, -0.00651285, -0.00670569,
  -0.00689781, -0.00708921, -0.00727985, -0.00746971, -0.00765879,
  -0.00784705, -0.00803449, -0.00822107, -0.00840678, -0.00859161,
  -0.00877552, -0.00895851, -0.00914056, -0.00932164, -0.00950175,
  -0.00968085, -0.00985893, -0.010036, -0.010212, -0.0103869,
  -0.0105607, -0.0107334, -0.010905, -0.0110755, -0.0112448,
  -0.0114129, -0.0115799, -0.0117456, -0.0119101, -0.0120733,
  -0.0122353, -0.0123961, -0.0125555, -0.0127136, -0.0128704,
  -0.0130259, -0.01318, -0.0133328, -0.0134842, -0.0136341,
  -0.0137827, -0.0139298, -0.0140755, -0.0142198, -0.0143626,
  -0.0145038, -0.0146436, -0.0147819, -0.0149187, -0.0150539,
  -0.0151876, -0.0153197, -0.0154503, -0.0155792, -0.0157066,
  -0.0158323, -0.0159565, -0.016079, -0.0161998, -0.016319,
  -0.0164365, -0.0165524, -0.0166665, -0.016779, -0.0168897,
  -0.0169987, -0.017106, -0.0172115, -0.0173153, -0.0174174,
  -0.0175176, -0.0176161, -0.0177128, -0.0178077, -0.0179008,
  -0.0179921, -0.0180815, -0.0181691, -0.0182549, -0.0183388,
  -0.0184209, -0.0185012, -0.0185795, -0.018656, -0.0187306,
  -0.0188033, -0.0188741, -0.018943, -0.01901, -0.0190751, -0.0191383,
  -0.0191996, -0.0192589, -0.0193163, -0.0193718, -0.0194253,
  -0.0194769, -0.0195265, -0.0195742, -0.0196199, -0.0196636,
  -0.0197054, -0.0197452, -0.0197831, -0.0198189, -0.0198528,
  -0.0198847, -0.0199147, -0.0199426, -0.0199686, -0.0199926,
  -0.0200146, -0.0200346, -0.0200526, -0.0200686, -0.0200827,
  -0.0200947, -0.0201048, -0.0201128, -0.0201189, -0.020123,
  -0.020125, -0.0201251, -0.0201232, -0.0201194, -0.0201135,
  -0.0201056, -0.0200958, -0.020084, -0.0200702, -0.0200544,
  -0.0200367, -0.020017, -0.0199953, -0.0199716, -0.019946,
  -0.0199184, -0.0198889, -0.0198574, -0.019824, -0.0197886,
  -0.0197513, -0.0197121, -0.0196709, -0.0196278, -0.0195828,
  -0.0195358, -0.019487, -0.0194362, -0.0193836, -0.019329,
  -0.0192726, -0.0192143, -0.0191541, -0.0190921, -0.0190282,
  -0.0189624, -0.0188948, -0.0188254, -0.0187541, -0.018681,
  -0.0186061, -0.0185294, -0.0184509, -0.0183706, -0.0182885,
  -0.0182046, -0.018119, -0.0180316, -0.0179425, -0.0178517,
  -0.0177591, -0.0176648, -0.0175688, -0.017471, -0.0173716,
  -0.0172706, -0.0171678, -0.0170634, -0.0169574, -0.0168497,
  -0.0167404, -0.0166295, -0.016517, -0.0164029, -0.0162872,
  -0.0161699, -0.0160511, -0.0159308, -0.0158089, -0.0156855,
  -0.0155606, -0.0154342, -0.0153063, -0.015177, -0.0150462,
  -0.014914, -0.0147803, -0.0146452, -0.0145087, -0.0143709,
  -0.0142316, -0.014091, -0.013949, -0.0138057, -0.0136611,
  -0.0135152, -0.013368, -0.0132195, -0.0130698, -0.0129188,
  -0.0127666, -0.0126132, -0.0124585, -0.0123027, -0.0121457,
  -0.0119876, -0.0118283, -0.0116679, -0.0115063, -0.0113437,
  -0.01118, -0.0110153, -0.0108495, -0.0106826, -0.0105148, -0.010346,
  -0.0101761, -0.0100053, -0.00983361, -0.00966094, -0.00948736,
  -0.00931288, -0.00913752, -0.00896129, -0.00878421, -0.00860631,
  -0.00842759, -0.00824807, -0.00806778, -0.00788672, -0.00770492,
  -0.00752239, -0.00733915, -0.00715522, -0.00697061, -0.00678535,
  -0.00659945, -0.00641292, -0.00622579, -0.00603808, -0.00584979,
  -0.00566096, -0.00547159, -0.00528171, -0.00509133, -0.00490047,
  -0.00470916, -0.0045174, -0.00432521, -0.00413262, -0.00393964,
  -0.00374629, -0.00355259, -0.00335856, -0.00316421, -0.00296956,
  -0.00277464, -0.00257945, -0.00238403, -0.00218838, -0.00199252,
  -0.00179648, -0.00160027, -0.00140391, -0.00120742, -0.00101082,
  -0.000814122, -0.000617348, -0.000420516, -0.000223645,
  -2.67532e-05, 0.000170141, 0.00036702, 0.000563864, 0.000760656,
  0.000957376, 0.00115401, 0.00135053, 0.00154693, 0.00174318,
  0.00193927, 0.00213518, 0.0023309, 0.00252639, 0.00272165,
  0.00291665, 0.00311139, 0.00330583, 0.00349997, 0.00369378,
  0.00388725, 0.00408035, 0.00427308, 0.00446541, 0.00465732,
  0.00484881, 0.00503984, 0.0052304, 0.00542048, 0.00561005,
  0.0057991, 0.00598762, 0.00617558, 0.00636296, 0.00654976,
  0.00673595, 0.00692151, 0.00710643, 0.0072907, 0.00747428,
  0.00765718, 0.00783936, 0.00802082, 0.00820154, 0.00838149,
  0.00856067, 0.00873906, 0.00891664, 0.00909339, 0.00926931,
  0.00944436, 0.00961854, 0.00979183, 0.00996422, 0.0101357,
  0.0103062, 0.0104758, 0.0106444, 0.010812, 0.0109786, 0.0111443,
  0.0113088, 0.0114724, 0.0116349, 0.0117963, 0.0119566, 0.0121158,
  0.0122739, 0.0124308, 0.0125867, 0.0127413, 0.0128948, 0.0130471,
  0.0131982, 0.013348, 0.0134967, 0.0136441, 0.0137902, 0.0139351,
  0.0140786, 0.0142209, 0.0143619, 0.0145016, 0.0146399, 0.0147768,
  0.0149125, 0.0150467, 0.0151795, 0.015311, 0.015441, 0.0155697,
  0.0156968, 0.0158226, 0.0159469, 0.0160697, 0.0161911, 0.0163109,
  0.0164293, 0.0165461, 0.0166614, 0.0167752, 0.0168875, 0.0169982,
  0.0171073, 0.0172149, 0.0173209, 0.0174253, 0.017528, 0.0176292,
  0.0177288, 0.0178267, 0.017923, 0.0180177, 0.0181106, 0.018202,
  0.0182916, 0.0183796, 0.0184659, 0.0185505, 0.0186334, 0.0187146,
  0.018794, 0.0188718, 0.0189478, 0.0190221, 0.0190946, 0.0191653,
  0.0192344, 0.0193016, 0.0193671, 0.0194308, 0.0194927, 0.0195528,
  0.0196112, 0.0196677, 0.0197224, 0.0197754, 0.0198265, 0.0198758,
  0.0199232, 0.0199689, 0.0200127, 0.0200547, 0.0200948, 0.0201331,
  0.0201695, 0.0202041, 0.0202369, 0.0202678, 0.0202968, 0.020324,
  0.0203493, 0.0203727, 0.0203943, 0.020414, 0.0204318, 0.0204478,
  0.0204619, 0.0204741, 0.0204844, 0.0204929, 0.0204995, 0.0205042,
  0.020507, 0.0205079, 0.020507, 0.0205042, 0.0204995, 0.0204929,
  0.0204844, 0.0204741, 0.0204619, 0.0204478, 0.0204318, 0.020414,
  0.0203943, 0.0203727, 0.0203493, 0.020324, 0.0202968, 0.0202678,
  0.0202369, 0.0202041, 0.0201695, 0.0201331, 0.0200948, 0.0200547,
  0.0200127, 0.0199689, 0.0199232, 0.0198758, 0.0198265, 0.0197754,
  0.0197224, 0.0196677, 0.0196112, 0.0195528, 0.0194927, 0.0194308,
  0.0193671, 0.0193016, 0.0192344, 0.0191653, 0.0190946, 0.0190221,
  0.0189478, 0.0188718, 0.018794, 0.0187146, 0.0186334, 0.0185505,
  0.0184659, 0.0183796, 0.0182916, 0.018202, 0.0181106, 0.0180177,
  0.017923, 0.0178267, 0.0177288, 0.0176292, 0.017528, 0.0174253,
  0.0173209, 0.0172149, 0.0171073, 0.0169982, 0.0168875, 0.0167752,
  0.0166614, 0.0165461, 0.0164293, 0.0163109, 0.0161911, 0.0160697,
  0.0159469, 0.0158226, 0.0156968, 0.0155697, 0.015441, 0.015311,
  0.0151795, 0.0150467, 0.0149125, 0.0147768, 0.0146399, 0.0145016,
  0.0143619, 0.0142209, 0.0140786, 0.0139351, 0.0137902, 0.0136441,
  0.0134967, 0.013348, 0.0131982, 0.0130471, 0.0128948, 0.0127413,
  0.0125867, 0.0124308, 0.0122739, 0.0121158, 0.0119566, 0.0117963,
  0.0116349, 0.0114724, 0.0113088, 0.0111443, 0.0109786, 0.010812,
  0.0106444, 0.0104758, 0.0103062, 0.0101357, 0.00996422, 0.00979183,
  0.00961854, 0.00944436, 0.00926931, 0.00909339, 0.00891664,
  0.00873906, 0.00856067, 0.00838149, 0.00820154, 0.00802082,
  0.00783936, 0.00765718, 0.00747428, 0.0072907, 0.00710643,
  0.00692151, 0.00673595, 0.00654976, 0.00636296, 0.00617558,
  0.00598762, 0.0057991, 0.00561005, 0.00542048, 0.0052304,
  0.00503984, 0.00484881, 0.00465732, 0.00446541, 0.00427308,
  0.00408035, 0.00388725, 0.00369378, 0.00349997, 0.00330583,
  0.00311139, 0.00291665, 0.00272165, 0.00252639, 0.0023309,
  0.00213518, 0.00193927, 0.00174318, 0.00154693, 0.00135053,
  0.00115401, 0.000957376, 0.000760656, 0.000563864, 0.00036702,
  0.000170141, -2.67532e-05, -0.000223645, -0.000420516, -0.000617348,
  -0.000814122, -0.00101082, -0.00120742, -0.00140391, -0.00160027,
  -0.00179648, -0.00199252, -0.00218838, -0.00238403, -0.00257945,
  -0.00277464, -0.00296956, -0.00316421, -0.00335856, -0.00355259,
  -0.00374629, -0.00393964, -0.00413262, -0.00432521, -0.0045174,
  -0.00470916, -0.00490047, -0.00509133, -0.00528171, -0.00547159,
  -0.00566096, -0.00584979, -0.00603808, -0.00622579, -0.00641292,
  -0.00659945, -0.00678535, -0.00697061, -0.00715522, -0.00733915,
  -0.00752239, -0.00770492, -0.00788672, -0.00806778, -0.00824807,
  -0.00842759, -0.00860631, -0.00878421, -0.00896129, -0.00913752,
  -0.00931288, -0.00948736, -0.00966094, -0.00983361, -0.0100053,
  -0.0101761, -0.010346, -0.0105148, -0.0106826, -0.0108495,
  -0.0110153, -0.01118, -0.0113437, -0.0115063, -0.0116679,
  -0.0118283, -0.0119876, -0.0121457, -0.0123027, -0.0124585,
  -0.0126132, -0.0127666, -0.0129188, -0.0130698, -0.0132195,
  -0.013368, -0.0135152, -0.0136611, -0.0138057, -0.013949, -0.014091,
  -0.0142316, -0.0143709, -0.0145087, -0.0146452, -0.0147803,
  -0.014914, -0.0150462, -0.015177, -0.0153063, -0.0154342,
  -0.0155606, -0.0156855, -0.0158089, -0.0159308, -0.0160511,
  -0.0161699, -0.0162872, -0.0164029, -0.016517, -0.0166295,
  -0.0167404, -0.0168497, -0.0169574, -0.0170634, -0.0171678,
  -0.0172706, -0.0173716, -0.017471, -0.0175688, -0.0176648,
  -0.0177591, -0.0178517, -0.0179425, -0.0180316, -0.018119,
  -0.0182046, -0.0182885, -0.0183706, -0.0184509, -0.0185294,
  -0.0186061, -0.018681, -0.0187541, -0.0188254, -0.0188948,
  -0.0189624, -0.0190282, -0.0190921, -0.0191541, -0.0192143,
  -0.0192726, -0.019329, -0.0193836, -0.0194362, -0.019487,
  -0.0195358, -0.0195828, -0.0196278, -0.0196709, -0.0197121,
  -0.0197513, -0.0197886, -0.019824, -0.0198574, -0.0198889,
  -0.0199184, -0.019946, -0.0199716, -0.0199953, -0.020017,
  -0.0200367, -0.0200544, -0.0200702, -0.020084, -0.0200958,
  -0.0201056, -0.0201135, -0.0201194, -0.0201232, -0.0201251,
  -0.020125, -0.020123, -0.0201189, -0.0201128, -0.0201048,
  -0.0200947, -0.0200827, -0.0200686, -0.0200526, -0.0200346,
  -0.0200146, -0.0199926, -0.0199686, -0.0199426, -0.0199147,
  -0.0198847, -0.0198528, -0.0198189, -0.0197831, -0.0197452,
  -0.0197054, -0.0196636, -0.0196199, -0.0195742, -0.0195265,
  -0.0194769, -0.0194253, -0.0193718, -0.0193163, -0.0192589,
  -0.0191996, -0.0191383, -0.0190751, -0.01901, -0.018943, -0.0188741,
  -0.0188033, -0.0187306, -0.018656, -0.0185795, -0.0185012,
  -0.0184209, -0.0183388, -0.0182549, -0.0181691, -0.0180815,
  -0.0179921, -0.0179008, -0.0178077, -0.0177128, -0.0176161,
  -0.0175176, -0.0174174, -0.0173153, -0.0172115, -0.017106,
  -0.0169987, -0.0168897, -0.016779, -0.0166665, -0.0165524,
  -0.0164365, -0.016319, -0.0161998, -0.016079, -0.0159565,
  -0.0158323, -0.0157066, -0.0155792, -0.0154503, -0.0153197,
  -0.0151876, -0.0150539, -0.0149187, -0.0147819, -0.0146436,
  -0.0145038, -0.0143626, -0.0142198, -0.0140755, -0.0139298,
  -0.0137827, -0.0136341, -0.0134842, -0.0133328, -0.01318,
  -0.0130259, -0.0128704, -0.0127136, -0.0125555, -0.0123961,
  -0.0122353, -0.0120733, -0.0119101, -0.0117456, -0.0115799,
  -0.0114129, -0.0112448, -0.0110755, -0.010905, -0.0107334,
  -0.0105607, -0.0103869, -0.010212, -0.010036, -0.00985893,
  -0.00968085, -0.00950175, -0.00932164, -0.00914056, -0.00895851,
  -0.00877552, -0.00859161, -0.00840678, -0.00822107, -0.00803449,
  -0.00784705, -0.00765879, -0.00746971, -0.00727985, -0.00708921,
  -0.00689781, -0.00670569, -0.00651285, -0.00631931, -0.00612511,
  -0.00593025, -0.00573476, -0.00553865, -0.00534196, -0.00514469,
  -0.00494687, -0.00474853, -0.00454967, -0.00435033, -0.00415052,
  -0.00395027, -0.00374959, -0.0035485, -0.00334704, -0.00314521,
  -0.00294305, -0.00274057, -0.00253779, -0.00233474, -0.00213143,
  -0.0019279, -0.00172415, -0.00152022, -0.00131613, -0.00111189,
  -0.000907531, -0.000703073, -0.000498539, -0.000293951,
  -8.93306e-05, 0.0001153, 0.000319917, 0.0005245, 0.000729025,
  0.000933471, 0.00113781, 0.00134203, 0.0015461, 0.00175001,
  0.00195372, 0.00215721, 0.00236047, 0.00256347, 0.00276618,
  0.00296859, 0.00317068, 0.00337241, 0.00357377, 0.00377473,
  0.00397528, 0.00417538, 0.00437503, 0.00457418, 0.00477283,
  0.00497095, 0.00516851, 0.0053655, 0.00556189, 0.00575766,
  0.00595279, 0.00614725, 0.00634103, 0.00653409, 0.00672642,
  0.006918, 0.0071088, 0.0072988, 0.00748798, 0.00767632, 0.0078638,
  0.00805038, 0.00823606, 0.00842081, 0.00860461, 0.00878743,
  0.00896926, 0.00915007, 0.00932984, 0.00950855, 0.00968618,
  0.00986271, 0.0100381, 0.0102124, 0.0103855, 0.0105574, 0.0107281,
  0.0108976, 0.0110658, 0.0112328, 0.0113984, 0.0115628, 0.0117258,
  0.0118875, 0.0120478, 0.0122068, 0.0123643, 0.0125204, 0.012675,
  0.0128282, 0.0129799, 0.0131301, 0.0132787, 0.0134259, 0.0135714,
  0.0137154, 0.0138578, 0.0139985, 0.0141377, 0.0142752, 0.014411,
  0.0145451, 0.0146775, 0.0148082, 0.0149372, 0.0150644, 0.0151898,
  0.0153134, 0.0154353, 0.0155553, 0.0156735, 0.0157898, 0.0159043,
  0.0160168, 0.0161275, 0.0162363, 0.0163431, 0.016448, 0.0165509,
  0.0166518, 0.0167508, 0.0168478, 0.0169427, 0.0170356, 0.0171265,
  0.0172153, 0.0173021, 0.0173867, 0.0174693, 0.0175498, 0.0176281,
  0.0177044, 0.0177785, 0.0178504, 0.0179202, 0.0179878, 0.0180532,
  0.0181164, 0.0181774, 0.0182362, 0.0182928, 0.0183472, 0.0183993,
  0.0184491, 0.0184967, 0.018542, 0.0185851, 0.0186258, 0.0186643,
  0.0187005, 0.0187343, 0.0187659, 0.0187951, 0.018822, 0.0188466,
  0.0188689, 0.0188887, 0.0189063, 0.0189215, 0.0189343, 0.0189448,
  0.0189529, 0.0189586, 0.018962, 0.018963, 0.0189616, 0.0189578,
  0.0189517, 0.0189431, 0.0189322, 0.0189189, 0.0189032, 0.0188851,
  0.0188646, 0.0188417, 0.0188164, 0.0187887, 0.0187586, 0.0187262,
  0.0186913, 0.0186541, 0.0186144, 0.0185724, 0.018528, 0.0184813,
  0.0184321, 0.0183806, 0.0183267, 0.0182704, 0.0182118, 0.0181508,
  0.0180875, 0.0180218, 0.0179538, 0.0178835, 0.0178108, 0.0177358,
  0.0176585, 0.0175789, 0.0174969, 0.0174127, 0.0173262, 0.0172374,
  0.0171464, 0.0170531, 0.0169575, 0.0168597, 0.0167597, 0.0166574,
  0.016553, 0.0164463, 0.0163375, 0.0162265, 0.0161133, 0.0159979,
  0.0158805, 0.0157608, 0.0156391, 0.0155153, 0.0153894, 0.0152614,
  0.0151314, 0.0149993, 0.0148652, 0.0147291, 0.014591, 0.0144509,
  0.0143088, 0.0141648, 0.0140189, 0.013871, 0.0137213, 0.0135697,
  0.0134162, 0.0132608, 0.0131037, 0.0129447, 0.012784, 0.0126215,
  0.0124572, 0.0122912, 0.0121235, 0.0119541, 0.0117831, 0.0116104,
  0.0114361, 0.0112602, 0.0110828, 0.0109037, 0.0107232, 0.0105411,
  0.0103575, 0.0101725, 0.00998608, 0.00979822, 0.00960897,
  0.00941835, 0.0092264, 0.00903313, 0.00883858, 0.00864277,
  0.00844571, 0.00824745, 0.00804801, 0.00784741, 0.00764568,
  0.00744285, 0.00723894, 0.00703399, 0.00682802, 0.00662105,
  0.00641313, 0.00620427, 0.00599451, 0.00578388, 0.0055724,
  0.0053601, 0.00514701, 0.00493317, 0.00471861, 0.00450334,
  0.00428742, 0.00407085, 0.00385369, 0.00363595, 0.00341768,
  0.00319889, 0.00297963, 0.00275992, 0.0025398, 0.0023193,
  0.00209845, 0.00187728, 0.00165583, 0.00143413, 0.00121222,
  0.00099012, 0.000767871, 0.000545505, 0.000323056, 0.000100558,
  -0.000121955, -0.00034445, -0.000566891, -0.000789246, -0.00101148,
  -0.00123356, -0.00145544, -0.0016771, -0.00189851, -0.00211961,
  -0.00234039, -0.0025608, -0.00278082, -0.00300039, -0.0032195,
  -0.0034381, -0.00365616, -0.00387365, -0.00409052, -0.00430675,
  -0.0045223, -0.00473712, -0.0049512, -0.00516448, -0.00537694,
  -0.00558854, -0.00579925, -0.00600902, -0.00621783, -0.00642563,
  -0.0066324, -0.00683809, -0.00704268, -0.00724612, -0.00744838,
  -0.00764943, -0.00784923, -0.00804774, -0.00824494, -0.00844078,
  -0.00863523, -0.00882825, -0.00901981, -0.00920988, -0.00939843,
  -0.0095854, -0.00977078, -0.00995453, -0.0101366, -0.010317,
  -0.0104956, -0.0106725, -0.0108476, -0.0110209, -0.0111922,
  -0.0113617, -0.0115293, -0.0116948, -0.0118584, -0.01202,
  -0.0121795, -0.0123369, -0.0124921, -0.0126452, -0.0127962,
  -0.0129449, -0.0130913, -0.0132355, -0.0133773, -0.0135169,
  -0.013654, -0.0137888, -0.0139211, -0.0140509, -0.0141783,
  -0.0143032, -0.0144255, -0.0145453, -0.0146624, -0.014777,
  -0.0148888, -0.014998, -0.0151046, -0.0152083, -0.0153094,
  -0.0154076, -0.0155031, -0.0155957, -0.0156854, -0.0157723,
  -0.0158564, -0.0159374, -0.0160156, -0.0160908, -0.016163,
  -0.0162322, -0.0162984, -0.0163615, -0.0164216, -0.0164786,
  -0.0165325, -0.0165833, -0.0166309, -0.0166754, -0.0167168,
  -0.0167549, -0.0167899, -0.0168216, -0.0168502, -0.0168755,
  -0.0168975, -0.0169162, -0.0169317, -0.0169439, -0.0169528,
  -0.0169584, -0.0169607, -0.0169596, -0.0169552, -0.0169475,
  -0.0169364, -0.016922, -0.0169041, -0.016883, -0.0168584,
  -0.0168305, -0.0167991, -0.0167644, -0.0167263, -0.0166848,
  -0.01664, -0.0165917, -0.01654, -0.016485, -0.0164266, -0.0163648,
  -0.0162996, -0.016231, -0.0161591, -0.0160837, -0.0160051,
  -0.0159231, -0.0158377, -0.015749, -0.0156569, -0.0155616,
  -0.0154629, -0.015361, -0.0152557, -0.0151472, -0.0150355,
  -0.0149204, -0.0148022, -0.0146807, -0.0145561, -0.0144283,
  -0.0142973, -0.0141631, -0.0140259, -0.0138855, -0.0137421,
  -0.0135956, -0.0134461, -0.0132936, -0.0131381, -0.0129796,
  -0.0128182, -0.0126539, -0.0124868, -0.0123167, -0.0121439,
  -0.0119683, -0.0117899, -0.0116088, -0.011425, -0.0112385,
  -0.0110494, -0.0108577, -0.0106635, -0.0104668, -0.0102676,
  -0.010066, -0.00986192, -0.00965553, -0.00944682, -0.00923585,
  -0.00902264, -0.00880725, -0.00858972, -0.00837009, -0.00814842,
  -0.00792474, -0.00769911, -0.00747158, -0.00724219, -0.007011,
  -0.00677806, -0.00654341, -0.00630712, -0.00606923, -0.00582981,
  -0.00558889, -0.00534656, -0.00510284, -0.00485782, -0.00461154,
  -0.00436406, -0.00411545, -0.00386576, -0.00361506, -0.0033634,
  -0.00311085, -0.00285748, -0.00260335, -0.00234852, -0.00209306,
  -0.00183703, -0.00158051, -0.00132356, -0.00106625, -0.00080864,
  -0.000550812, -0.000292831, -3.47693e-05, 0.000223302, 0.000481311,
  0.000739185, 0.00099685, 0.00125423, 0.00151126, 0.00176785,
  0.00202394, 0.00227944, 0.00253429, 0.00278839, 0.00304168,
  0.00329408, 0.00354551, 0.00379589, 0.00404514, 0.00429319,
  0.00453994, 0.00478533, 0.00502927, 0.00527167, 0.00551247,
  0.00575158, 0.00598891, 0.00622438, 0.00645792, 0.00668944,
  0.00691885, 0.00714608, 0.00737104, 0.00759365, 0.00781383,
  0.00803149, 0.00824654, 0.00845892, 0.00866853, 0.00887529,
  0.00907912, 0.00927993, 0.00947765, 0.00967219, 0.00986346,
  0.0100514, 0.0102359, 0.0104169, 0.0105943, 0.0107681, 0.010938,
  0.0111042, 0.0112665, 0.0114247, 0.0115789, 0.011729, 0.0118748,
  0.0120164, 0.0121535, 0.0122862, 0.0124144, 0.012538, 0.0126569,
  0.0127711, 0.0128805, 0.0129849, 0.0130844, 0.0131789, 0.0132683,
  0.0133526, 0.0134316, 0.0135053, 0.0135737, 0.0136367, 0.0136942,
  0.0137462, 0.0137926, 0.0138333, 0.0138684, 0.0138977, 0.0139212,
  0.0139389, 0.0139506, 0.0139565, 0.0139563, 0.0139501, 0.0139379,
  0.0139196, 0.0138951, 0.0138644, 0.0138276, 0.0137845, 0.0137352,
  0.0136795, 0.0136176, 0.0135494, 0.0134748, 0.0133939, 0.0133066,
  0.0132129, 0.0131129, 0.0130065, 0.0128937, 0.0127746, 0.012649,
  0.0125172, 0.0123789, 0.0122344, 0.0120836, 0.0119265, 0.0117631,
  0.0115935, 0.0114177, 0.0112358, 0.0110478, 0.0108538, 0.0106537,
  0.0104477, 0.0102358, 0.0100181, 0.00979469, 0.00956557, 0.00933085,
  0.00909061, 0.00884495, 0.00859396, 0.00833774, 0.00807638,
  0.00781001, 0.00753873, 0.00726267, 0.00698194, 0.00669669,
  0.00640704, 0.00611315, 0.00581515, 0.00551321, 0.00520748,
  0.00489814, 0.00458536, 0.00426932, 0.0039502, 0.00362821,
  0.00330354, 0.0029764, 0.00264701, 0.00231559, 0.00198237,
  0.00164759, 0.0013115, 0.000974341, 0.000636387, 0.000297905,
  -4.08283e-05, -0.000379526, -0.000717892, -0.00105562, -0.00139241,
  -0.00172792, -0.00206184, -0.00239382, -0.00272351, -0.00305055,
  -0.00337457, -0.0036952, -0.00401205, -0.00432472, -0.00463279,
  -0.00493586, -0.00523349, -0.00552523, -0.00581065, -0.00608927,
  -0.00636062, -0.00662421, -0.00687956, -0.00712614, -0.00736344,
  -0.00759093, -0.00780805, -0.00801426, -0.00820897, -0.00839161,
  -0.00856158, -0.00871827, -0.00886106, -0.0089893, -0.00910235,
  -0.00919955, -0.00928021, -0.00934363, -0.00938912, -0.00941595,
  -0.00942338, -0.00941065, -0.009377, -0.00932164, -0.00924378,
  -0.00914259, -0.00901724, -0.00886688, -0.00869065, -0.00848767,
  -0.00825703, -0.00799781, -0.00770908, -0.00738988, -0.00703925,
  -0.00665619, -0.0062397, -0.00578874, -0.00530227, -0.00477922,
  -0.00421851, -0.00361904, -0.00297967, -0.00229925, -0.00157663,
  -0.000810619, -4.66207e-18}; G4double
  G4NeutronHPFastLegendre::l12[2601] = {1, 0.940883, 0.883509,
  0.827844, 0.773856, 0.721512, 0.67078, 0.621628, 0.574025, 0.52794,
  0.483344, 0.440206, 0.398496, 0.358186, 0.319246, 0.28165, 0.245368,
  0.210374, 0.17664, 0.14414, 0.112848, 0.082738, 0.053784, 0.0259613,
  -0.000754816, -0.0263887, -0.0509643, -0.0745053, -0.0970349,
  -0.118576, -0.139151, -0.158782, -0.177492, -0.195301, -0.212231,
  -0.228303, -0.243537, -0.257953, -0.271572, -0.284412, -0.296494,
  -0.307836, -0.318457, -0.328375, -0.337608, -0.346174, -0.35409,
  -0.361374, -0.368043, -0.374113, -0.3796, -0.384521, -0.388891,
  -0.392726, -0.396041, -0.398851, -0.401171, -0.403015, -0.404398,
  -0.405334, -0.405836, -0.405918, -0.405593, -0.404874, -0.403774,
  -0.402305, -0.400481, -0.398312, -0.395811, -0.392989, -0.389859,
  -0.38643, -0.382715, -0.378724, -0.374467, -0.369955, -0.365199,
  -0.360208, -0.354991, -0.34956, -0.343922, -0.338088, -0.332066,
  -0.325865, -0.319494, -0.312962, -0.306276, -0.299446, -0.292478,
  -0.285381, -0.278162, -0.270829, -0.263389, -0.25585, -0.248218,
  -0.2405, -0.232703, -0.224833, -0.216898, -0.208902, -0.200853,
  -0.192756, -0.184617, -0.176441, -0.168235, -0.160003, -0.151751,
  -0.143485, -0.135208, -0.126926, -0.118645, -0.110367, -0.102098,
  -0.0938429, -0.0856051, -0.077389, -0.0691987, -0.0610381,
  -0.0529111, -0.0448213, -0.0367724, -0.0287678, -0.0208111,
  -0.0129054, -0.00505392, 0.00274016, 0.0104739, 0.0181444,
  0.0257488, 0.0332844, 0.0407487, 0.0481391, 0.055453, 0.0626883,
  0.0698426, 0.0769137, 0.0838996, 0.0907982, 0.0976076, 0.104326,
  0.110951, 0.117482, 0.123917, 0.130254, 0.136491, 0.142628,
  0.148663, 0.154595, 0.160423, 0.166144, 0.171759, 0.177266,
  0.182665, 0.187954, 0.193133, 0.1982, 0.203156, 0.207999, 0.212729,
  0.217345, 0.221848, 0.226235, 0.230508, 0.234665, 0.238707,
  0.242632, 0.246442, 0.250136, 0.253713, 0.257174, 0.260518,
  0.263746, 0.266858, 0.269854, 0.272733, 0.275497, 0.278145,
  0.280678, 0.283096, 0.285399, 0.287587, 0.289662, 0.291623,
  0.293471, 0.295207, 0.29683, 0.298342, 0.299744, 0.301035, 0.302216,
  0.303288, 0.304252, 0.305109, 0.305859, 0.306503, 0.307041,
  0.307475, 0.307806, 0.308033, 0.308159, 0.308184, 0.308109,
  0.307935, 0.307663, 0.307293, 0.306827, 0.306266, 0.305611,
  0.304863, 0.304023, 0.303091, 0.30207, 0.30096, 0.299762, 0.298477,
  0.297107, 0.295652, 0.294114, 0.292494, 0.290793, 0.289012,
  0.287153, 0.285216, 0.283203, 0.281115, 0.278954, 0.276719,
  0.274413, 0.272038, 0.269593, 0.26708, 0.264501, 0.261857, 0.259149,
  0.256378, 0.253546, 0.250654, 0.247702, 0.244693, 0.241628,
  0.238507, 0.235333, 0.232106, 0.228827, 0.225498, 0.222121,
  0.218695, 0.215224, 0.211707, 0.208147, 0.204544, 0.200899,
  0.197214, 0.193491, 0.18973, 0.185932, 0.1821, 0.178233, 0.174334,
  0.170403, 0.166442, 0.162451, 0.158433, 0.154388, 0.150318,
  0.146224, 0.142106, 0.137966, 0.133806, 0.129626, 0.125427,
  0.121211, 0.116979, 0.112732, 0.108471, 0.104197, 0.0999112,
  0.0956151, 0.0913094, 0.0869953, 0.0826738, 0.0783461, 0.0740131,
  0.069676, 0.0653358, 0.0609935, 0.0566502, 0.0523068, 0.0479643,
  0.0436238, 0.0392863, 0.0349527, 0.030624, 0.0263011, 0.021985,
  0.0176767, 0.013377, 0.00908695, 0.00480736, 0.00053917,
  -0.00371674, -0.0079595, -0.0121882, -0.0164021, -0.0206002,
  -0.0247818, -0.028946, -0.0330919, -0.0372189, -0.0413261,
  -0.0454127, -0.049478, -0.0535211, -0.0575414, -0.0615381,
  -0.0655105, -0.0694579, -0.0733795, -0.0772746, -0.0811427,
  -0.084983, -0.0887948, -0.0925775, -0.0963305, -0.100053, -0.103745,
  -0.107405, -0.111033, -0.114628, -0.11819, -0.121718, -0.125211,
  -0.12867, -0.132093, -0.135479, -0.13883, -0.142143, -0.145419,
  -0.148657, -0.151857, -0.155017, -0.158139, -0.16122, -0.164262,
  -0.167263, -0.170222, -0.173141, -0.176018, -0.178853, -0.181645,
  -0.184394, -0.187101, -0.189764, -0.192383, -0.194958, -0.197489,
  -0.199975, -0.202417, -0.204813, -0.207164, -0.209469, -0.211729,
  -0.213942, -0.216109, -0.21823, -0.220304, -0.222331, -0.224311,
  -0.226244, -0.22813, -0.229968, -0.231759, -0.233502, -0.235197,
  -0.236844, -0.238444, -0.239995, -0.241498, -0.242953, -0.24436,
  -0.245718, -0.247028, -0.248289, -0.249503, -0.250667, -0.251784,
  -0.252852, -0.253871, -0.254843, -0.255765, -0.25664, -0.257466,
  -0.258245, -0.258975, -0.259657, -0.260291, -0.260877, -0.261415,
  -0.261906, -0.262349, -0.262744, -0.263093, -0.263394, -0.263648,
  -0.263855, -0.264015, -0.264129, -0.264196, -0.264217, -0.264192,
  -0.264121, -0.264004, -0.263842, -0.263635, -0.263382, -0.263085,
  -0.262743, -0.262356, -0.261926, -0.261451, -0.260933, -0.260371,
  -0.259766, -0.259119, -0.258428, -0.257696, -0.256921, -0.256104,
  -0.255246, -0.254347, -0.253407, -0.252427, -0.251406, -0.250345,
  -0.249244, -0.248105, -0.246926, -0.245709, -0.244453, -0.243159,
  -0.241828, -0.24046, -0.239054, -0.237613, -0.236135, -0.234621,
  -0.233071, -0.231487, -0.229868, -0.228215, -0.226527, -0.224807,
  -0.223053, -0.221266, -0.219447, -0.217596, -0.215713, -0.2138,
  -0.211855, -0.209881, -0.207876, -0.205842, -0.203779, -0.201687,
  -0.199567, -0.197419, -0.195244, -0.193041, -0.190813, -0.188558,
  -0.186277, -0.183971, -0.181641, -0.179286, -0.176907, -0.174505,
  -0.17208, -0.169632, -0.167162, -0.16467, -0.162157, -0.159623,
  -0.157069, -0.154495, -0.151902, -0.149289, -0.146659, -0.144009,
  -0.141343, -0.138659, -0.135958, -0.133242, -0.130509, -0.127761,
  -0.124998, -0.122221, -0.119429, -0.116624, -0.113807, -0.110976,
  -0.108133, -0.105279, -0.102413, -0.0995362, -0.0966492, -0.0937523,
  -0.090846, -0.0879306, -0.0850067, -0.0820747, -0.079135, -0.076188,
  -0.0732343, -0.0702743, -0.0673084, -0.0643371, -0.0613607,
  -0.0583798, -0.0553948, -0.0524061, -0.0494141, -0.0464194,
  -0.0434222, -0.0404232, -0.0374226, -0.0344209, -0.0314186,
  -0.028416, -0.0254136, -0.0224118, -0.0194111, -0.0164118,
  -0.0134144, -0.0104193, -0.00742685, -0.00443751, -0.00145169,
  0.00153022, 0.00450781, 0.00748068, 0.0104484, 0.0134107, 0.016367,
  0.019317, 0.0222603, 0.0251966, 0.0281254, 0.0310463, 0.033959,
  0.0368631, 0.0397583, 0.0426441, 0.0455201, 0.0483861, 0.0512417,
  0.0540864, 0.05692, 0.0597421, 0.0625523, 0.0653503, 0.0681357,
  0.0709082, 0.0736675, 0.0764132, 0.079145, 0.0818626, 0.0845655,
  0.0872536, 0.0899265, 0.0925838, 0.0952252, 0.0978506, 0.100459,
  0.103051, 0.105626, 0.108184, 0.110724, 0.113246, 0.11575, 0.118235,
  0.120701, 0.123149, 0.125577, 0.127985, 0.130373, 0.132742,
  0.135089, 0.137417, 0.139723, 0.142008, 0.144271, 0.146513,
  0.148733, 0.150931, 0.153106, 0.155259, 0.157389, 0.159496, 0.16158,
  0.16364, 0.165677, 0.167689, 0.169678, 0.171642, 0.173582, 0.175497,
  0.177387, 0.179252, 0.181092, 0.182906, 0.184695, 0.186458,
  0.188195, 0.189906, 0.191591, 0.19325, 0.194882, 0.196487, 0.198065,
  0.199617, 0.201141, 0.202638, 0.204108, 0.20555, 0.206965, 0.208352,
  0.209711, 0.211042, 0.212345, 0.21362, 0.214867, 0.216085, 0.217275,
  0.218437, 0.21957, 0.220674, 0.221749, 0.222796, 0.223813, 0.224802,
  0.225762, 0.226693, 0.227594, 0.228467, 0.22931, 0.230124, 0.230908,
  0.231663, 0.232389, 0.233086, 0.233753, 0.234391, 0.234999,
  0.235578, 0.236127, 0.236647, 0.237137, 0.237598, 0.238029,
  0.238431, 0.238803, 0.239146, 0.239459, 0.239743, 0.239998,
  0.240223, 0.240419, 0.240586, 0.240724, 0.240832, 0.240911,
  0.240961, 0.240981, 0.240973, 0.240936, 0.24087, 0.240775, 0.240651,
  0.240499, 0.240318, 0.240108, 0.23987, 0.239604, 0.239309, 0.238986,
  0.238635, 0.238256, 0.237849, 0.237414, 0.236951, 0.236461,
  0.235943, 0.235398, 0.234825, 0.234226, 0.233599, 0.232945,
  0.232265, 0.231558, 0.230824, 0.230064, 0.229277, 0.228465,
  0.227626, 0.226761, 0.225871, 0.224955, 0.224014, 0.223048,
  0.222056, 0.22104, 0.219998, 0.218932, 0.217842, 0.216727, 0.215588,
  0.214426, 0.213239, 0.212029, 0.210795, 0.209539, 0.208259,
  0.206956, 0.20563, 0.204282, 0.202912, 0.20152, 0.200105, 0.198669,
  0.197212, 0.195733, 0.194233, 0.192712, 0.19117, 0.189608, 0.188026,
  0.186423, 0.184801, 0.183159, 0.181497, 0.179816, 0.178117,
  0.176398, 0.174661, 0.172906, 0.171132, 0.169341, 0.167532,
  0.165705, 0.163861, 0.162001, 0.160123, 0.158229, 0.156319,
  0.154393, 0.152451, 0.150493, 0.148521, 0.146533, 0.14453, 0.142513,
  0.140481, 0.138435, 0.136376, 0.134303, 0.132216, 0.130117,
  0.128004, 0.125879, 0.123742, 0.121592, 0.119431, 0.117258,
  0.115074, 0.112878, 0.110672, 0.108456, 0.106229, 0.103991,
  0.101745, 0.0994882, 0.0972225, 0.0949479, 0.0926644, 0.0903725,
  0.0880723, 0.0857641, 0.0834483, 0.0811249, 0.0787944, 0.0764569,
  0.0741128, 0.0717623, 0.0694056, 0.067043, 0.0646748, 0.0623013,
  0.0599226, 0.0575391, 0.055151, 0.0527586, 0.0503622, 0.047962,
  0.0455582, 0.0431512, 0.0407411, 0.0383284, 0.0359131, 0.0334956,
  0.0310761, 0.028655, 0.0262324, 0.0238086, 0.0213838, 0.0189584,
  0.0165326, 0.0141067, 0.0116808, 0.00925529, 0.00683039, 0.00440637,
  0.00198347, -0.000438058, -0.00285795, -0.00527596, -0.00769184,
  -0.0101053, -0.0125162, -0.0149242, -0.017329, -0.0197304,
  -0.0221283, -0.0245222, -0.026912, -0.0292975, -0.0316783,
  -0.0340543, -0.0364252, -0.0387908, -0.0411507, -0.0435049,
  -0.045853, -0.0481948, -0.0505301, -0.0528586, -0.0551802,
  -0.0574945, -0.0598013, -0.0621005, -0.0643918, -0.0666749,
  -0.0689496, -0.0712157, -0.073473, -0.0757213, -0.0779603,
  -0.0801898, -0.0824097, -0.0846196, -0.0868193, -0.0890087,
  -0.0911876, -0.0933557, -0.0955127, -0.0976586, -0.0997931,
  -0.101916, -0.104027, -0.106126, -0.108213, -0.110287, -0.112349,
  -0.114398, -0.116434, -0.118457, -0.120467, -0.122462, -0.124444,
  -0.126413, -0.128367, -0.130306, -0.132231, -0.134142, -0.136037,
  -0.137918, -0.139783, -0.141633, -0.143468, -0.145287, -0.147089,
  -0.148876, -0.150647, -0.152401, -0.154139, -0.155859, -0.157564,
  -0.159251, -0.160921, -0.162573, -0.164208, -0.165826, -0.167426,
  -0.169007, -0.170571, -0.172117, -0.173644, -0.175153, -0.176644,
  -0.178115, -0.179568, -0.181002, -0.182417, -0.183813, -0.185189,
  -0.186546, -0.187883, -0.189201, -0.190498, -0.191776, -0.193034,
  -0.194272, -0.19549, -0.196687, -0.197864, -0.19902, -0.200156,
  -0.201271, -0.202365, -0.203439, -0.204491, -0.205522, -0.206533,
  -0.207522, -0.208489, -0.209436, -0.210361, -0.211264, -0.212146,
  -0.213006, -0.213845, -0.214662, -0.215456, -0.21623, -0.216981,
  -0.21771, -0.218417, -0.219102, -0.219764, -0.220405, -0.221023,
  -0.221619, -0.222193, -0.222744, -0.223273, -0.22378, -0.224264,
  -0.224726, -0.225165, -0.225582, -0.225976, -0.226347, -0.226696,
  -0.227022, -0.227326, -0.227607, -0.227866, -0.228102, -0.228315,
  -0.228505, -0.228673, -0.228819, -0.228941, -0.229041, -0.229119,
  -0.229173, -0.229206, -0.229215, -0.229202, -0.229167, -0.229109,
  -0.229028, -0.228926, -0.2288, -0.228652, -0.228482, -0.22829,
  -0.228075, -0.227838, -0.227578, -0.227297, -0.226993, -0.226668,
  -0.22632, -0.22595, -0.225558, -0.225145, -0.224709, -0.224252,
  -0.223773, -0.223273, -0.22275, -0.222207, -0.221642, -0.221055,
  -0.220447, -0.219818, -0.219168, -0.218497, -0.217805, -0.217091,
  -0.216357, -0.215603, -0.214827, -0.214031, -0.213215, -0.212378,
  -0.211521, -0.210643, -0.209746, -0.208828, -0.207891, -0.206934,
  -0.205957, -0.204961, -0.203945, -0.202909, -0.201855, -0.200781,
  -0.199689, -0.198577, -0.197447, -0.196298, -0.19513, -0.193944,
  -0.19274, -0.191517, -0.190277, -0.189018, -0.187742, -0.186448,
  -0.185137, -0.183808, -0.182462, -0.181099, -0.179719, -0.178322,
  -0.176909, -0.175479, -0.174032, -0.172569, -0.171091, -0.169596,
  -0.168085, -0.166559, -0.165017, -0.16346, -0.161888, -0.160301,
  -0.158699, -0.157082, -0.155451, -0.153805, -0.152146, -0.150472,
  -0.148784, -0.147082, -0.145367, -0.143639, -0.141897, -0.140143,
  -0.138375, -0.136595, -0.134802, -0.132997, -0.13118, -0.129351,
  -0.12751, -0.125657, -0.123793, -0.121918, -0.120031, -0.118134,
  -0.116226, -0.114307, -0.112379, -0.110439, -0.10849, -0.106532,
  -0.104563, -0.102585, -0.100598, -0.0986022, -0.0965973, -0.0945838,
  -0.0925618, -0.0905315, -0.0884932, -0.086447, -0.0843931,
  -0.0823318, -0.0802632, -0.0781874, -0.0761048, -0.0740155,
  -0.0719198, -0.0698177, -0.0677095, -0.0655954, -0.0634757,
  -0.0613504, -0.0592198, -0.0570842, -0.0549436, -0.0527984,
  -0.0506486, -0.0484946, -0.0463365, -0.0441745, -0.0420088,
  -0.0398396, -0.0376672, -0.0354917, -0.0333133, -0.0311323,
  -0.0289487, -0.026763, -0.0245752, -0.0223855, -0.0201942,
  -0.0180014, -0.0158074, -0.0136124, -0.0114165, -0.00922,
  -0.00702308, -0.00482594, -0.00262879, -0.000431817, 0.00176476,
  0.00396075, 0.00615594, 0.00835013, 0.0105431, 0.0127347, 0.0149247,
  0.0171129, 0.019299, 0.021483, 0.0236645, 0.0258434, 0.0280196,
  0.0301927, 0.0323626, 0.034529, 0.0366919, 0.038851, 0.041006,
  0.0431569, 0.0453033, 0.0474452, 0.0495822, 0.0517143, 0.0538412,
  0.0559627, 0.0580787, 0.0601888, 0.0622931, 0.0643911, 0.0664829,
  0.0685681, 0.0706466, 0.0727181, 0.0747826, 0.0768398, 0.0788895,
  0.0809316, 0.0829658, 0.084992, 0.0870099, 0.0890195, 0.0910205,
  0.0930127, 0.094996, 0.0969702, 0.0989351, 0.10089, 0.102836,
  0.104772, 0.106698, 0.108614, 0.110519, 0.112414, 0.114298,
  0.116171, 0.118034, 0.119885, 0.121724, 0.123553, 0.125369,
  0.127174, 0.128966, 0.130747, 0.132515, 0.13427, 0.136013, 0.137743,
  0.13946, 0.141164, 0.142855, 0.144532, 0.146195, 0.147845, 0.149481,
  0.151103, 0.152711, 0.154304, 0.155883, 0.157448, 0.158997,
  0.160532, 0.162052, 0.163556, 0.165046, 0.16652, 0.167978, 0.16942,
  0.170847, 0.172258, 0.173653, 0.175031, 0.176394, 0.177739,
  0.179069, 0.180381, 0.181677, 0.182956, 0.184218, 0.185462, 0.18669,
  0.1879, 0.189092, 0.190267, 0.191425, 0.192564, 0.193686, 0.19479,
  0.195875, 0.196943, 0.197992, 0.199023, 0.200035, 0.201029,
  0.202004, 0.20296, 0.203898, 0.204816, 0.205716, 0.206597, 0.207458,
  0.208301, 0.209124, 0.209927, 0.210711, 0.211476, 0.212221,
  0.212947, 0.213653, 0.214339, 0.215005, 0.215651, 0.216278,
  0.216884, 0.21747, 0.218037, 0.218583, 0.219109, 0.219614, 0.2201,
  0.220565, 0.221009, 0.221434, 0.221837, 0.222221, 0.222583,
  0.222926, 0.223247, 0.223548, 0.223829, 0.224088, 0.224327,
  0.224546, 0.224743, 0.22492, 0.225076, 0.225211, 0.225326, 0.225419,
  0.225492, 0.225544, 0.225576, 0.225586, 0.225576, 0.225544,
  0.225492, 0.225419, 0.225326, 0.225211, 0.225076, 0.22492, 0.224743,
  0.224546, 0.224327, 0.224088, 0.223829, 0.223548, 0.223247,
  0.222926, 0.222583, 0.222221, 0.221837, 0.221434, 0.221009,
  0.220565, 0.2201, 0.219614, 0.219109, 0.218583, 0.218037, 0.21747,
  0.216884, 0.216278, 0.215651, 0.215005, 0.214339, 0.213653,
  0.212947, 0.212221, 0.211476, 0.210711, 0.209927, 0.209124,
  0.208301, 0.207458, 0.206597, 0.205716, 0.204816, 0.203898, 0.20296,
  0.202004, 0.201029, 0.200035, 0.199023, 0.197992, 0.196943,
  0.195875, 0.19479, 0.193686, 0.192564, 0.191425, 0.190267, 0.189092,
  0.1879, 0.18669, 0.185462, 0.184218, 0.182956, 0.181677, 0.180381,
  0.179069, 0.177739, 0.176394, 0.175031, 0.173653, 0.172258,
  0.170847, 0.16942, 0.167978, 0.16652, 0.165046, 0.163556, 0.162052,
  0.160532, 0.158997, 0.157448, 0.155883, 0.154304, 0.152711,
  0.151103, 0.149481, 0.147845, 0.146195, 0.144532, 0.142855,
  0.141164, 0.13946, 0.137743, 0.136013, 0.13427, 0.132515, 0.130747,
  0.128966, 0.127174, 0.125369, 0.123553, 0.121724, 0.119885,
  0.118034, 0.116171, 0.114298, 0.112414, 0.110519, 0.108614,
  0.106698, 0.104772, 0.102836, 0.10089, 0.0989351, 0.0969702,
  0.094996, 0.0930127, 0.0910205, 0.0890195, 0.0870099, 0.084992,
  0.0829658, 0.0809316, 0.0788895, 0.0768398, 0.0747826, 0.0727181,
  0.0706466, 0.0685681, 0.0664829, 0.0643911, 0.0622931, 0.0601888,
  0.0580787, 0.0559627, 0.0538412, 0.0517143, 0.0495822, 0.0474452,
  0.0453033, 0.0431569, 0.041006, 0.038851, 0.0366919, 0.034529,
  0.0323626, 0.0301927, 0.0280196, 0.0258434, 0.0236645, 0.021483,
  0.019299, 0.0171129, 0.0149247, 0.0127347, 0.0105431, 0.00835013,
  0.00615594, 0.00396075, 0.00176476, -0.000431817, -0.00262879,
  -0.00482594, -0.00702308, -0.00922, -0.0114165, -0.0136124,
  -0.0158074, -0.0180014, -0.0201942, -0.0223855, -0.0245752,
  -0.026763, -0.0289487, -0.0311323, -0.0333133, -0.0354917,
  -0.0376672, -0.0398396, -0.0420088, -0.0441745, -0.0463365,
  -0.0484946, -0.0506486, -0.0527984, -0.0549436, -0.0570842,
  -0.0592198, -0.0613504, -0.0634757, -0.0655954, -0.0677095,
  -0.0698177, -0.0719198, -0.0740155, -0.0761048, -0.0781874,
  -0.0802632, -0.0823318, -0.0843931, -0.086447, -0.0884932,
  -0.0905315, -0.0925618, -0.0945838, -0.0965973, -0.0986022,
  -0.100598, -0.102585, -0.104563, -0.106532, -0.10849, -0.110439,
  -0.112379, -0.114307, -0.116226, -0.118134, -0.120031, -0.121918,
  -0.123793, -0.125657, -0.12751, -0.129351, -0.13118, -0.132997,
  -0.134802, -0.136595, -0.138375, -0.140143, -0.141897, -0.143639,
  -0.145367, -0.147082, -0.148784, -0.150472, -0.152146, -0.153805,
  -0.155451, -0.157082, -0.158699, -0.160301, -0.161888, -0.16346,
  -0.165017, -0.166559, -0.168085, -0.169596, -0.171091, -0.172569,
  -0.174032, -0.175479, -0.176909, -0.178322, -0.179719, -0.181099,
  -0.182462, -0.183808, -0.185137, -0.186448, -0.187742, -0.189018,
  -0.190277, -0.191517, -0.19274, -0.193944, -0.19513, -0.196298,
  -0.197447, -0.198577, -0.199689, -0.200781, -0.201855, -0.202909,
  -0.203945, -0.204961, -0.205957, -0.206934, -0.207891, -0.208828,
  -0.209746, -0.210643, -0.211521, -0.212378, -0.213215, -0.214031,
  -0.214827, -0.215603, -0.216357, -0.217091, -0.217805, -0.218497,
  -0.219168, -0.219818, -0.220447, -0.221055, -0.221642, -0.222207,
  -0.22275, -0.223273, -0.223773, -0.224252, -0.224709, -0.225145,
  -0.225558, -0.22595, -0.22632, -0.226668, -0.226993, -0.227297,
  -0.227578, -0.227838, -0.228075, -0.22829, -0.228482, -0.228652,
  -0.2288, -0.228926, -0.229028, -0.229109, -0.229167, -0.229202,
  -0.229215, -0.229206, -0.229173, -0.229119, -0.229041, -0.228941,
  -0.228819, -0.228673, -0.228505, -0.228315, -0.228102, -0.227866,
  -0.227607, -0.227326, -0.227022, -0.226696, -0.226347, -0.225976,
  -0.225582, -0.225165, -0.224726, -0.224264, -0.22378, -0.223273,
  -0.222744, -0.222193, -0.221619, -0.221023, -0.220405, -0.219764,
  -0.219102, -0.218417, -0.21771, -0.216981, -0.21623, -0.215456,
  -0.214662, -0.213845, -0.213006, -0.212146, -0.211264, -0.210361,
  -0.209436, -0.208489, -0.207522, -0.206533, -0.205522, -0.204491,
  -0.203439, -0.202365, -0.201271, -0.200156, -0.19902, -0.197864,
  -0.196687, -0.19549, -0.194272, -0.193034, -0.191776, -0.190498,
  -0.189201, -0.187883, -0.186546, -0.185189, -0.183813, -0.182417,
  -0.181002, -0.179568, -0.178115, -0.176644, -0.175153, -0.173644,
  -0.172117, -0.170571, -0.169007, -0.167426, -0.165826, -0.164208,
  -0.162573, -0.160921, -0.159251, -0.157564, -0.155859, -0.154139,
  -0.152401, -0.150647, -0.148876, -0.147089, -0.145287, -0.143468,
  -0.141633, -0.139783, -0.137918, -0.136037, -0.134142, -0.132231,
  -0.130306, -0.128367, -0.126413, -0.124444, -0.122462, -0.120467,
  -0.118457, -0.116434, -0.114398, -0.112349, -0.110287, -0.108213,
  -0.106126, -0.104027, -0.101916, -0.0997931, -0.0976586, -0.0955127,
  -0.0933557, -0.0911876, -0.0890087, -0.0868193, -0.0846196,
  -0.0824097, -0.0801898, -0.0779603, -0.0757213, -0.073473,
  -0.0712157, -0.0689496, -0.0666749, -0.0643918, -0.0621005,
  -0.0598013, -0.0574945, -0.0551802, -0.0528586, -0.0505301,
  -0.0481948, -0.045853, -0.0435049, -0.0411507, -0.0387908,
  -0.0364252, -0.0340543, -0.0316783, -0.0292975, -0.026912,
  -0.0245222, -0.0221283, -0.0197304, -0.017329, -0.0149242,
  -0.0125162, -0.0101053, -0.00769184, -0.00527596, -0.00285795,
  -0.000438058, 0.00198347, 0.00440637, 0.00683039, 0.00925529,
  0.0116808, 0.0141067, 0.0165326, 0.0189584, 0.0213838, 0.0238086,
  0.0262324, 0.028655, 0.0310761, 0.0334956, 0.0359131, 0.0383284,
  0.0407411, 0.0431512, 0.0455582, 0.047962, 0.0503622, 0.0527586,
  0.055151, 0.0575391, 0.0599226, 0.0623013, 0.0646748, 0.067043,
  0.0694056, 0.0717623, 0.0741128, 0.0764569, 0.0787944, 0.0811249,
  0.0834483, 0.0857641, 0.0880723, 0.0903725, 0.0926644, 0.0949479,
  0.0972225, 0.0994882, 0.101745, 0.103991, 0.106229, 0.108456,
  0.110672, 0.112878, 0.115074, 0.117258, 0.119431, 0.121592,
  0.123742, 0.125879, 0.128004, 0.130117, 0.132216, 0.134303,
  0.136376, 0.138435, 0.140481, 0.142513, 0.14453, 0.146533, 0.148521,
  0.150493, 0.152451, 0.154393, 0.156319, 0.158229, 0.160123,
  0.162001, 0.163861, 0.165705, 0.167532, 0.169341, 0.171132,
  0.172906, 0.174661, 0.176398, 0.178117, 0.179816, 0.181497,
  0.183159, 0.184801, 0.186423, 0.188026, 0.189608, 0.19117, 0.192712,
  0.194233, 0.195733, 0.197212, 0.198669, 0.200105, 0.20152, 0.202912,
  0.204282, 0.20563, 0.206956, 0.208259, 0.209539, 0.210795, 0.212029,
  0.213239, 0.214426, 0.215588, 0.216727, 0.217842, 0.218932,
  0.219998, 0.22104, 0.222056, 0.223048, 0.224014, 0.224955, 0.225871,
  0.226761, 0.227626, 0.228465, 0.229277, 0.230064, 0.230824,
  0.231558, 0.232265, 0.232945, 0.233599, 0.234226, 0.234825,
  0.235398, 0.235943, 0.236461, 0.236951, 0.237414, 0.237849,
  0.238256, 0.238635, 0.238986, 0.239309, 0.239604, 0.23987, 0.240108,
  0.240318, 0.240499, 0.240651, 0.240775, 0.24087, 0.240936, 0.240973,
  0.240981, 0.240961, 0.240911, 0.240832, 0.240724, 0.240586,
  0.240419, 0.240223, 0.239998, 0.239743, 0.239459, 0.239146,
  0.238803, 0.238431, 0.238029, 0.237598, 0.237137, 0.236647,
  0.236127, 0.235578, 0.234999, 0.234391, 0.233753, 0.233086,
  0.232389, 0.231663, 0.230908, 0.230124, 0.22931, 0.228467, 0.227594,
  0.226693, 0.225762, 0.224802, 0.223813, 0.222796, 0.221749,
  0.220674, 0.21957, 0.218437, 0.217275, 0.216085, 0.214867, 0.21362,
  0.212345, 0.211042, 0.209711, 0.208352, 0.206965, 0.20555, 0.204108,
  0.202638, 0.201141, 0.199617, 0.198065, 0.196487, 0.194882, 0.19325,
  0.191591, 0.189906, 0.188195, 0.186458, 0.184695, 0.182906,
  0.181092, 0.179252, 0.177387, 0.175497, 0.173582, 0.171642,
  0.169678, 0.167689, 0.165677, 0.16364, 0.16158, 0.159496, 0.157389,
  0.155259, 0.153106, 0.150931, 0.148733, 0.146513, 0.144271,
  0.142008, 0.139723, 0.137417, 0.135089, 0.132742, 0.130373,
  0.127985, 0.125577, 0.123149, 0.120701, 0.118235, 0.11575, 0.113246,
  0.110724, 0.108184, 0.105626, 0.103051, 0.100459, 0.0978506,
  0.0952252, 0.0925838, 0.0899265, 0.0872536, 0.0845655, 0.0818626,
  0.079145, 0.0764132, 0.0736675, 0.0709082, 0.0681357, 0.0653503,
  0.0625523, 0.0597421, 0.05692, 0.0540864, 0.0512417, 0.0483861,
  0.0455201, 0.0426441, 0.0397583, 0.0368631, 0.033959, 0.0310463,
  0.0281254, 0.0251966, 0.0222603, 0.019317, 0.016367, 0.0134107,
  0.0104484, 0.00748068, 0.00450781, 0.00153022, -0.00145169,
  -0.00443751, -0.00742685, -0.0104193, -0.0134144, -0.0164118,
  -0.0194111, -0.0224118, -0.0254136, -0.028416, -0.0314186,
  -0.0344209, -0.0374226, -0.0404232, -0.0434222, -0.0464194,
  -0.0494141, -0.0524061, -0.0553948, -0.0583798, -0.0613607,
  -0.0643371, -0.0673084, -0.0702743, -0.0732343, -0.076188,
  -0.079135, -0.0820747, -0.0850067, -0.0879306, -0.090846,
  -0.0937523, -0.0966492, -0.0995362, -0.102413, -0.105279, -0.108133,
  -0.110976, -0.113807, -0.116624, -0.119429, -0.122221, -0.124998,
  -0.127761, -0.130509, -0.133242, -0.135958, -0.138659, -0.141343,
  -0.144009, -0.146659, -0.149289, -0.151902, -0.154495, -0.157069,
  -0.159623, -0.162157, -0.16467, -0.167162, -0.169632, -0.17208,
  -0.174505, -0.176907, -0.179286, -0.181641, -0.183971, -0.186277,
  -0.188558, -0.190813, -0.193041, -0.195244, -0.197419, -0.199567,
  -0.201687, -0.203779, -0.205842, -0.207876, -0.209881, -0.211855,
  -0.2138, -0.215713, -0.217596, -0.219447, -0.221266, -0.223053,
  -0.224807, -0.226527, -0.228215, -0.229868, -0.231487, -0.233071,
  -0.234621, -0.236135, -0.237613, -0.239054, -0.24046, -0.241828,
  -0.243159, -0.244453, -0.245709, -0.246926, -0.248105, -0.249244,
  -0.250345, -0.251406, -0.252427, -0.253407, -0.254347, -0.255246,
  -0.256104, -0.256921, -0.257696, -0.258428, -0.259119, -0.259766,
  -0.260371, -0.260933, -0.261451, -0.261926, -0.262356, -0.262743,
  -0.263085, -0.263382, -0.263635, -0.263842, -0.264004, -0.264121,
  -0.264192, -0.264217, -0.264196, -0.264129, -0.264015, -0.263855,
  -0.263648, -0.263394, -0.263093, -0.262744, -0.262349, -0.261906,
  -0.261415, -0.260877, -0.260291, -0.259657, -0.258975, -0.258245,
  -0.257466, -0.25664, -0.255765, -0.254843, -0.253871, -0.252852,
  -0.251784, -0.250667, -0.249503, -0.248289, -0.247028, -0.245718,
  -0.24436, -0.242953, -0.241498, -0.239995, -0.238444, -0.236844,
  -0.235197, -0.233502, -0.231759, -0.229968, -0.22813, -0.226244,
  -0.224311, -0.222331, -0.220304, -0.21823, -0.216109, -0.213942,
  -0.211729, -0.209469, -0.207164, -0.204813, -0.202417, -0.199975,
  -0.197489, -0.194958, -0.192383, -0.189764, -0.187101, -0.184394,
  -0.181645, -0.178853, -0.176018, -0.173141, -0.170222, -0.167263,
  -0.164262, -0.16122, -0.158139, -0.155017, -0.151857, -0.148657,
  -0.145419, -0.142143, -0.13883, -0.135479, -0.132093, -0.12867,
  -0.125211, -0.121718, -0.11819, -0.114628, -0.111033, -0.107405,
  -0.103745, -0.100053, -0.0963305, -0.0925775, -0.0887948, -0.084983,
  -0.0811427, -0.0772746, -0.0733795, -0.0694579, -0.0655105,
  -0.0615381, -0.0575414, -0.0535211, -0.049478, -0.0454127,
  -0.0413261, -0.0372189, -0.0330919, -0.028946, -0.0247818,
  -0.0206002, -0.0164021, -0.0121882, -0.0079595, -0.00371674,
  0.00053917, 0.00480736, 0.00908695, 0.013377, 0.0176767, 0.021985,
  0.0263011, 0.030624, 0.0349527, 0.0392863, 0.0436238, 0.0479643,
  0.0523068, 0.0566502, 0.0609935, 0.0653358, 0.069676, 0.0740131,
  0.0783461, 0.0826738, 0.0869953, 0.0913094, 0.0956151, 0.0999112,
  0.104197, 0.108471, 0.112732, 0.116979, 0.121211, 0.125427,
  0.129626, 0.133806, 0.137966, 0.142106, 0.146224, 0.150318,
  0.154388, 0.158433, 0.162451, 0.166442, 0.170403, 0.174334,
  0.178233, 0.1821, 0.185932, 0.18973, 0.193491, 0.197214, 0.200899,
  0.204544, 0.208147, 0.211707, 0.215224, 0.218695, 0.222121,
  0.225498, 0.228827, 0.232106, 0.235333, 0.238507, 0.241628,
  0.244693, 0.247702, 0.250654, 0.253546, 0.256378, 0.259149,
  0.261857, 0.264501, 0.26708, 0.269593, 0.272038, 0.274413, 0.276719,
  0.278954, 0.281115, 0.283203, 0.285216, 0.287153, 0.289012,
  0.290793, 0.292494, 0.294114, 0.295652, 0.297107, 0.298477,
  0.299762, 0.30096, 0.30207, 0.303091, 0.304023, 0.304863, 0.305611,
  0.306266, 0.306827, 0.307293, 0.307663, 0.307935, 0.308109,
  0.308184, 0.308159, 0.308033, 0.307806, 0.307475, 0.307041,
  0.306503, 0.305859, 0.305109, 0.304252, 0.303288, 0.302216,
  0.301035, 0.299744, 0.298342, 0.29683, 0.295207, 0.293471, 0.291623,
  0.289662, 0.287587, 0.285399, 0.283096, 0.280678, 0.278145,
  0.275497, 0.272733, 0.269854, 0.266858, 0.263746, 0.260518,
  0.257174, 0.253713, 0.250136, 0.246442, 0.242632, 0.238707,
  0.234665, 0.230508, 0.226235, 0.221848, 0.217345, 0.212729,
  0.207999, 0.203156, 0.1982, 0.193133, 0.187954, 0.182665, 0.177266,
  0.171759, 0.166144, 0.160423, 0.154595, 0.148663, 0.142628,
  0.136491, 0.130254, 0.123917, 0.117482, 0.110951, 0.104326,
  0.0976076, 0.0907982, 0.0838996, 0.0769137, 0.0698426, 0.0626883,
  0.055453, 0.0481391, 0.0407487, 0.0332844, 0.0257488, 0.0181444,
  0.0104739, 0.00274016, -0.00505392, -0.0129054, -0.0208111,
  -0.0287678, -0.0367724, -0.0448213, -0.0529111, -0.0610381,
  -0.0691987, -0.077389, -0.0856051, -0.0938429, -0.102098, -0.110367,
  -0.118645, -0.126926, -0.135208, -0.143485, -0.151751, -0.160003,
  -0.168235, -0.176441, -0.184617, -0.192756, -0.200853, -0.208902,
  -0.216898, -0.224833, -0.232703, -0.2405, -0.248218, -0.25585,
  -0.263389, -0.270829, -0.278162, -0.285381, -0.292478, -0.299446,
  -0.306276, -0.312962, -0.319494, -0.325865, -0.332066, -0.338088,
  -0.343922, -0.34956, -0.354991, -0.360208, -0.365199, -0.369955,
  -0.374467, -0.378724, -0.382715, -0.38643, -0.389859, -0.392989,
  -0.395811, -0.398312, -0.400481, -0.402305, -0.403774, -0.404874,
  -0.405593, -0.405918, -0.405836, -0.405334, -0.404398, -0.403015,
  -0.401171, -0.398851, -0.396041, -0.392726, -0.388891, -0.384521,
  -0.3796, -0.374113, -0.368043, -0.361374, -0.35409, -0.346174,
  -0.337608, -0.328375, -0.318457, -0.307836, -0.296494, -0.284412,
  -0.271572, -0.257953, -0.243537, -0.228303, -0.212231, -0.195301,
  -0.177492, -0.158782, -0.139151, -0.118576, -0.0970349, -0.0745053,
  -0.0509643, -0.0263887, -0.000754816, 0.0259613, 0.053784, 0.082738,
  0.112848, 0.14414, 0.17664, 0.210374, 0.245368, 0.28165, 0.319246,
  0.358186, 0.398496, 0.440206, 0.483344, 0.52794, 0.574025, 0.621628,
  0.67078, 0.721512, 0.773856, 0.827844, 0.883509, 0.940883, 1};
  G4double G4NeutronHPFastLegendre::i12[2601] = {0, 0.000746377,
  0.00144795, 0.00210605, 0.00272198, 0.00329702, 0.00383241,
  0.00432938, 0.00478915, 0.00521288, 0.00560174, 0.00595686,
  0.00627934, 0.00657028, 0.00683074, 0.00706177, 0.00726438,
  0.00743958, 0.00758835, 0.00771165, 0.00781041, 0.00788556,
  0.00793799, 0.00796859, 0.00797821, 0.0079677, 0.00793788,
  0.00788955, 0.00782351, 0.00774052, 0.00764133, 0.00752668,
  0.00739728, 0.00725384, 0.00709704, 0.00692755, 0.00674602,
  0.00655308, 0.00634937, 0.00613548, 0.005912, 0.00567952,
  0.00543859, 0.00518976, 0.00493357, 0.00467053, 0.00440116,
  0.00412594, 0.00384535, 0.00355987, 0.00326994, 0.00297601,
  0.00267851, 0.00237786, 0.00207445, 0.00176869, 0.00146096,
  0.00115162, 0.00084105, 0.000529586, 0.000217569, -9.46712e-05,
  -0.000406817, -0.000718561, -0.0010296, -0.00133966, -0.00164844,
  -0.0019557, -0.00226115, -0.00256455, -0.00286567, -0.00316426,
  -0.0034601, -0.00375298, -0.00404269, -0.00432902, -0.00461179,
  -0.00489081, -0.0051659, -0.00543689, -0.00570363, -0.00596595,
  -0.00622372, -0.00647678, -0.00672501, -0.00696827, -0.00720645,
  -0.00743943, -0.0076671, -0.00788936, -0.00810611, -0.00831727,
  -0.00852275, -0.00872246, -0.00891634, -0.00910431, -0.00928632,
  -0.0094623, -0.0096322, -0.00979597, -0.00995357, -0.010105,
  -0.0102501, -0.010389, -0.0105216, -0.0106478, -0.0107677,
  -0.0108813, -0.0109884, -0.0110893, -0.0111837, -0.0112718,
  -0.0113535, -0.0114289, -0.0114979, -0.0115606, -0.011617,
  -0.011667, -0.0117109, -0.0117485, -0.0117798, -0.011805,
  -0.0118241, -0.0118371, -0.011844, -0.0118449, -0.0118398,
  -0.0118288, -0.0118119, -0.0117892, -0.0117607, -0.0117265,
  -0.0116867, -0.0116412, -0.0115902, -0.0115338, -0.0114719,
  -0.0114047, -0.0113323, -0.0112546, -0.0111718, -0.0110839,
  -0.0109911, -0.0108933, -0.0107907, -0.0106833, -0.0105713,
  -0.0104546, -0.0103335, -0.0102079, -0.0100779, -0.00994365,
  -0.00980521, -0.00966265, -0.00951608, -0.00936556, -0.00921118,
  -0.00905304, -0.00889121, -0.00872579, -0.00855686, -0.00838451,
  -0.00820884, -0.00802992, -0.00784784, -0.0076627, -0.00747459,
  -0.00728359, -0.0070898, -0.00689329, -0.00669417, -0.00649253,
  -0.00628844, -0.00608201, -0.00587331, -0.00566245, -0.0054495,
  -0.00523456, -0.00501772, -0.00479906, -0.00457867, -0.00435664,
  -0.00413306, -0.00390802, -0.0036816, -0.00345389, -0.00322497,
  -0.00299492, -0.00276385, -0.00253182, -0.00229893, -0.00206525,
  -0.00183088, -0.00159588, -0.00136035, -0.00112436, -0.000888006,
  -0.000651352, -0.000414484, -0.000177481, 5.95813e-05, 0.000296624,
  0.00053357, 0.000770345, 0.00100687, 0.00124308, 0.00147889,
  0.00171423, 0.00194904, 0.00218323, 0.00241674, 0.0026495,
  0.00288144, 0.0031125, 0.00334259, 0.00357167, 0.00379966,
  0.0040265, 0.00425212, 0.00447647, 0.00469947, 0.00492108,
  0.00514123, 0.00535986, 0.00557691, 0.00579232, 0.00600605,
  0.00621803, 0.00642821, 0.00663653, 0.00684295, 0.00704741,
  0.00724986, 0.00745025, 0.00764853, 0.00784466, 0.00803859,
  0.00823027, 0.00841965, 0.0086067, 0.00879137, 0.00897362,
  0.00915341, 0.0093307, 0.00950544, 0.0096776, 0.00984715, 0.010014,
  0.0101783, 0.0103397, 0.0104985, 0.0106544, 0.0108075, 0.0109578,
  0.0111052, 0.0112497, 0.0113912, 0.0115298, 0.0116654, 0.011798,
  0.0119276, 0.0120541, 0.0121775, 0.0122978, 0.012415, 0.0125291,
  0.01264, 0.0127477, 0.0128522, 0.0129535, 0.0130516, 0.0131465,
  0.0132381, 0.0133265, 0.0134116, 0.0134933, 0.0135719, 0.0136471,
  0.0137189, 0.0137875, 0.0138528, 0.0139147, 0.0139733, 0.0140286,
  0.0140805, 0.0141291, 0.0141743, 0.0142163, 0.0142548, 0.01429,
  0.0143219, 0.0143505, 0.0143757, 0.0143976, 0.0144162, 0.0144314,
  0.0144434, 0.014452, 0.0144574, 0.0144594, 0.0144582, 0.0144537,
  0.0144459, 0.0144349, 0.0144207, 0.0144033, 0.0143826, 0.0143587,
  0.0143317, 0.0143015, 0.0142681, 0.0142316, 0.014192, 0.0141493,
  0.0141035, 0.0140546, 0.0140027, 0.0139478, 0.0138898, 0.0138289,
  0.013765, 0.0136981, 0.0136284, 0.0135557, 0.0134802, 0.0134018,
  0.0133206, 0.0132366, 0.0131498, 0.0130602, 0.012968, 0.012873,
  0.0127753, 0.012675, 0.0125721, 0.0124666, 0.0123586, 0.0122479,
  0.0121348, 0.0120193, 0.0119012, 0.0117808, 0.0116579, 0.0115328,
  0.0114052, 0.0112754, 0.0111434, 0.0110091, 0.0108726, 0.0107339,
  0.0105931, 0.0104503, 0.0103053, 0.0101583, 0.0100093, 0.0098584,
  0.00970553, 0.00955076, 0.00939413, 0.00923567, 0.00907542,
  0.00891342, 0.0087497, 0.00858429, 0.00841724, 0.00824857,
  0.00807832, 0.00790653, 0.00773324, 0.00755847, 0.00738228,
  0.00720469, 0.00702574, 0.00684547, 0.00666391, 0.0064811,
  0.00629709, 0.00611189, 0.00592556, 0.00573813, 0.00554964,
  0.00536012, 0.00516961, 0.00497815, 0.00478577, 0.00459252,
  0.00439842, 0.00420352, 0.00400786, 0.00381147, 0.00361439,
  0.00341665, 0.0032183, 0.00301937, 0.00281989, 0.00261991,
  0.00241945, 0.00221857, 0.00201729, 0.00181565, 0.00161369,
  0.00141144, 0.00120894, 0.00100623, 0.000803341, 0.000600311,
  0.000397176, 0.000193971, -9.26817e-06, -0.000212505, -0.000415706,
  -0.000618834, -0.000821855, -0.00102473, -0.00122744, -0.00142993,
  -0.00163217, -0.00183413, -0.00203578, -0.00223708, -0.002438,
  -0.00263851, -0.00283856, -0.00303814, -0.0032372, -0.00343571,
  -0.00363364, -0.00383096, -0.00402764, -0.00422364, -0.00441893,
  -0.00461349, -0.00480727, -0.00500025, -0.00519241, -0.0053837,
  -0.0055741, -0.00576357, -0.0059521, -0.00613965, -0.00632618,
  -0.00651168, -0.00669611, -0.00687945, -0.00706166, -0.00724272,
  -0.0074226, -0.00760128, -0.00777873, -0.00795492, -0.00812982,
  -0.00830341, -0.00847567, -0.00864656, -0.00881607, -0.00898417,
  -0.00915082, -0.00931602, -0.00947974, -0.00964195, -0.00980263,
  -0.00996175, -0.0101193, -0.0102752, -0.0104296, -0.0105823,
  -0.0107333, -0.0108826, -0.0110303, -0.0111762, -0.0113204,
  -0.0114628, -0.0116034, -0.0117422, -0.0118792, -0.0120144,
  -0.0121477, -0.0122791, -0.0124086, -0.0125363, -0.012662,
  -0.0127857, -0.0129075, -0.0130274, -0.0131452, -0.0132611,
  -0.0133749, -0.0134867, -0.0135964, -0.0137041, -0.0138097,
  -0.0139133, -0.0140147, -0.0141141, -0.0142113, -0.0143064,
  -0.0143993, -0.0144901, -0.0145787, -0.0146652, -0.0147495,
  -0.0148315, -0.0149114, -0.0149891, -0.0150646, -0.0151378,
  -0.0152088, -0.0152775, -0.0153441, -0.0154083, -0.0154703,
  -0.0155301, -0.0155875, -0.0156427, -0.0156957, -0.0157463,
  -0.0157946, -0.0158407, -0.0158844, -0.0159259, -0.0159651,
  -0.0160019, -0.0160365, -0.0160687, -0.0160987, -0.0161263,
  -0.0161516, -0.0161746, -0.0161953, -0.0162137, -0.0162298,
  -0.0162436, -0.0162551, -0.0162642, -0.0162711, -0.0162757,
  -0.0162779, -0.0162779, -0.0162756, -0.016271, -0.0162641,
  -0.0162549, -0.0162434, -0.0162297, -0.0162137, -0.0161955,
  -0.016175, -0.0161522, -0.0161272, -0.0161, -0.0160705, -0.0160388,
  -0.0160049, -0.0159688, -0.0159304, -0.0158899, -0.0158472,
  -0.0158024, -0.0157553, -0.0157061, -0.0156548, -0.0156013,
  -0.0155457, -0.015488, -0.0154282, -0.0153662, -0.0153022,
  -0.0152361, -0.015168, -0.0150978, -0.0150256, -0.0149513,
  -0.014875, -0.0147967, -0.0147165, -0.0146342, -0.01455, -0.0144639,
  -0.0143758, -0.0142858, -0.0141939, -0.0141001, -0.0140045,
  -0.013907, -0.0138076, -0.0137064, -0.0136034, -0.0134986,
  -0.013392, -0.0132836, -0.0131735, -0.0130617, -0.0129481,
  -0.0128328, -0.0127159, -0.0125973, -0.012477, -0.0123552,
  -0.0122317, -0.0121066, -0.0119799, -0.0118517, -0.011722,
  -0.0115907, -0.0114579, -0.0113236, -0.0111879, -0.0110507,
  -0.0109121, -0.0107721, -0.0106308, -0.010488, -0.0103439,
  -0.0101985, -0.0100517, -0.00990372, -0.00975444, -0.00960391,
  -0.00945216, -0.0092992, -0.00914506, -0.00898976, -0.00883332,
  -0.00867576, -0.0085171, -0.00835736, -0.00819656, -0.00803473,
  -0.00787189, -0.00770805, -0.00754325, -0.0073775, -0.00721082,
  -0.00704323, -0.00687477, -0.00670544, -0.00653528, -0.0063643,
  -0.00619252, -0.00601998, -0.00584668, -0.00567266, -0.00549793,
  -0.00532252, -0.00514645, -0.00496974, -0.00479242, -0.00461451,
  -0.00443602, -0.00425699, -0.00407744, -0.00389738, -0.00371684,
  -0.00353585, -0.00335442, -0.00317259, -0.00299036, -0.00280777,
  -0.00262483, -0.00244158, -0.00225802, -0.00207419, -0.00189011,
  -0.0017058, -0.00152129, -0.00133658, -0.00115172, -0.000966714,
  -0.000781593, -0.000596378, -0.00041109, -0.000225753, -4.03888e-05,
  0.00014498, 0.000330332, 0.000515644, 0.000700894, 0.00088606,
  0.00107112, 0.00125605, 0.00144083, 0.00162544, 0.00180986,
  0.00199406, 0.00217802, 0.00236172, 0.00254514, 0.00272826,
  0.00291106, 0.00309351, 0.00327559, 0.00345729, 0.00363857,
  0.00381943, 0.00399984, 0.00417977, 0.00435921, 0.00453814,
  0.00471654, 0.00489438, 0.00507164, 0.00524831, 0.00542437,
  0.00559979, 0.00577456, 0.00594865, 0.00612204, 0.00629473,
  0.00646668, 0.00663787, 0.00680829, 0.00697793, 0.00714675,
  0.00731474, 0.00748188, 0.00764816, 0.00781355, 0.00797804,
  0.00814161, 0.00830423, 0.0084659, 0.00862659, 0.00878629,
  0.00894498, 0.00910264, 0.00925926, 0.00941481, 0.00956928,
  0.00972266, 0.00987492, 0.0100261, 0.010176, 0.0103249, 0.0104725,
  0.010619, 0.0107642, 0.0109082, 0.011051, 0.0111925, 0.0113328,
  0.0114718, 0.0116094, 0.0117458, 0.0118808, 0.0120145, 0.0121468,
  0.0122778, 0.0124073, 0.0125355, 0.0126623, 0.0127876, 0.0129115,
  0.0130339, 0.0131549, 0.0132744, 0.0133924, 0.013509, 0.013624,
  0.0137374, 0.0138494, 0.0139598, 0.0140686, 0.0141759, 0.0142816,
  0.0143857, 0.0144882, 0.0145891, 0.0146884, 0.0147861, 0.0148821,
  0.0149764, 0.0150691, 0.0151602, 0.0152495, 0.0153372, 0.0154232,
  0.0155075, 0.01559, 0.0156709, 0.01575, 0.0158274, 0.0159031,
  0.015977, 0.0160491, 0.0161195, 0.0161882, 0.016255, 0.0163201,
  0.0163834, 0.0164449, 0.0165046, 0.0165625, 0.0166186, 0.0166729,
  0.0167254, 0.0167761, 0.0168249, 0.0168719, 0.0169171, 0.0169605,
  0.017002, 0.0170416, 0.0170794, 0.0171154, 0.0171495, 0.0171818,
  0.0172122, 0.0172408, 0.0172675, 0.0172923, 0.0173153, 0.0173364,
  0.0173556, 0.017373, 0.0173885, 0.0174022, 0.017414, 0.0174239,
  0.0174319, 0.0174381, 0.0174424, 0.0174449, 0.0174455, 0.0174442,
  0.0174411, 0.0174361, 0.0174293, 0.0174206, 0.01741, 0.0173976,
  0.0173833, 0.0173672, 0.0173493, 0.0173295, 0.0173079, 0.0172844,
  0.0172592, 0.0172321, 0.0172031, 0.0171724, 0.0171398, 0.0171054,
  0.0170693, 0.0170313, 0.0169915, 0.01695, 0.0169066, 0.0168615,
  0.0168146, 0.016766, 0.0167156, 0.0166634, 0.0166095, 0.0165539,
  0.0164965, 0.0164374, 0.0163765, 0.016314, 0.0162498, 0.0161838,
  0.0161162, 0.0160469, 0.0159759, 0.0159033, 0.015829, 0.015753,
  0.0156754, 0.0155962, 0.0155154, 0.015433, 0.0153489, 0.0152633,
  0.0151761, 0.0150873, 0.014997, 0.0149051, 0.0148116, 0.0147167,
  0.0146202, 0.0145222, 0.0144227, 0.0143217, 0.0142193, 0.0141153,
  0.01401, 0.0139032, 0.0137949, 0.0136853, 0.0135742, 0.0134618,
  0.0133479, 0.0132327, 0.0131162, 0.0129983, 0.012879, 0.0127585,
  0.0126366, 0.0125135, 0.0123891, 0.0122634, 0.0121364, 0.0120083,
  0.0118789, 0.0117483, 0.0116165, 0.0114835, 0.0113493, 0.011214,
  0.0110776, 0.01094, 0.0108013, 0.0106615, 0.0105207, 0.0103788,
  0.0102358, 0.0100918, 0.00994673, 0.00980069, 0.00965366,
  0.00950565, 0.00935669, 0.00920678, 0.00905594, 0.00890419,
  0.00875154, 0.00859801, 0.00844361, 0.00828837, 0.00813229,
  0.00797539, 0.00781769, 0.00765921, 0.00749995, 0.00733995,
  0.00717921, 0.00701774, 0.00685558, 0.00669273, 0.00652921,
  0.00636503, 0.00620022, 0.00603479, 0.00586875, 0.00570213,
  0.00553494, 0.0053672, 0.00519892, 0.00503013, 0.00486083,
  0.00469105, 0.0045208, 0.0043501, 0.00417897, 0.00400742,
  0.00383548, 0.00366315, 0.00349046, 0.00331742, 0.00314406,
  0.00297038, 0.00279641, 0.00262216, 0.00244765, 0.0022729,
  0.00209793, 0.00192274, 0.00174737, 0.00157182, 0.00139612,
  0.00122028, 0.00104432, 0.000868258, 0.00069211, 0.000515893,
  0.000339625, 0.000163324, -1.29931e-05, -0.000189309, -0.000365606,
  -0.000541868, -0.000718076, -0.000894214, -0.00107026, -0.00124621,
  -0.00142203, -0.00159771, -0.00177324, -0.00194859, -0.00212375,
  -0.00229871, -0.00247344, -0.00264792, -0.00282215, -0.0029961,
  -0.00316976, -0.00334311, -0.00351613, -0.00368881, -0.00386113,
  -0.00403307, -0.00420462, -0.00437576, -0.00454647, -0.00471674,
  -0.00488655, -0.00505588, -0.00522473, -0.00539306, -0.00556087,
  -0.00572814, -0.00589485, -0.00606099, -0.00622654, -0.00639149,
  -0.00655582, -0.00671951, -0.00688255, -0.00704492, -0.00720661,
  -0.0073676, -0.00752788, -0.00768743, -0.00784623, -0.00800428,
  -0.00816155, -0.00831804, -0.00847372, -0.00862858, -0.0087826,
  -0.00893579, -0.0090881, -0.00923954, -0.00939009, -0.00953974,
  -0.00968847, -0.00983626, -0.0099831, -0.010129, -0.0102739,
  -0.0104178, -0.0105607, -0.0107026, -0.0108435, -0.0109833,
  -0.0111221, -0.0112598, -0.0113965, -0.011532, -0.0116664,
  -0.0117997, -0.0119319, -0.0120629, -0.0121928, -0.0123215,
  -0.0124491, -0.0125754, -0.0127005, -0.0128245, -0.0129472,
  -0.0130686, -0.0131888, -0.0133078, -0.0134254, -0.0135418,
  -0.0136569, -0.0137707, -0.0138832, -0.0139944, -0.0141042,
  -0.0142127, -0.0143198, -0.0144255, -0.0145299, -0.0146329,
  -0.0147345, -0.0148347, -0.0149335, -0.0150309, -0.0151268,
  -0.0152214, -0.0153144, -0.015406, -0.0154962, -0.0155848,
  -0.015672, -0.0157577, -0.0158419, -0.0159246, -0.0160058,
  -0.0160855, -0.0161636, -0.0162402, -0.0163153, -0.0163888,
  -0.0164608, -0.0165312, -0.0166001, -0.0166674, -0.0167331,
  -0.0167972, -0.0168598, -0.0169207, -0.01698, -0.0170378,
  -0.0170939, -0.0171484, -0.0172013, -0.0172526, -0.0173022,
  -0.0173503, -0.0173966, -0.0174414, -0.0174844, -0.0175259,
  -0.0175657, -0.0176038, -0.0176403, -0.0176751, -0.0177082,
  -0.0177397, -0.0177695, -0.0177977, -0.0178241, -0.0178489,
  -0.017872, -0.0178935, -0.0179132, -0.0179313, -0.0179476,
  -0.0179623, -0.0179753, -0.0179866, -0.0179963, -0.0180042,
  -0.0180105, -0.018015, -0.0180179, -0.0180191, -0.0180185,
  -0.0180163, -0.0180125, -0.0180069, -0.0179996, -0.0179907,
  -0.01798, -0.0179677, -0.0179537, -0.017938, -0.0179206, -0.0179016,
  -0.0178809, -0.0178585, -0.0178344, -0.0178087, -0.0177813,
  -0.0177523, -0.0177215, -0.0176892, -0.0176551, -0.0176195,
  -0.0175822, -0.0175432, -0.0175026, -0.0174604, -0.0174165,
  -0.017371, -0.0173239, -0.0172752, -0.0172248, -0.0171729,
  -0.0171194, -0.0170642, -0.0170075, -0.0169492, -0.0168893,
  -0.0168278, -0.0167648, -0.0167002, -0.016634, -0.0165663,
  -0.0164971, -0.0164263, -0.016354, -0.0162801, -0.0162048,
  -0.0161279, -0.0160496, -0.0159697, -0.0158884, -0.0158056,
  -0.0157213, -0.0156355, -0.0155483, -0.0154597, -0.0153696,
  -0.0152781, -0.0151852, -0.0150908, -0.0149951, -0.014898,
  -0.0147995, -0.0146996, -0.0145983, -0.0144957, -0.0143917,
  -0.0142865, -0.0141798, -0.0140719, -0.0139627, -0.0138521,
  -0.0137403, -0.0136272, -0.0135129, -0.0133973, -0.0132804,
  -0.0131623, -0.013043, -0.0129225, -0.0128008, -0.0126779,
  -0.0125538, -0.0124286, -0.0123022, -0.0121747, -0.012046,
  -0.0119162, -0.0117854, -0.0116534, -0.0115204, -0.0113863,
  -0.0112511, -0.0111149, -0.0109777, -0.0108394, -0.0107001,
  -0.0105599, -0.0104187, -0.0102765, -0.0101334, -0.00998928,
  -0.00984428, -0.00969838, -0.00955157, -0.00940388, -0.00925532,
  -0.00910591, -0.00895565, -0.00880457, -0.00865267, -0.00849997,
  -0.00834648, -0.00819223, -0.00803721, -0.00788146, -0.00772497,
  -0.00756777, -0.00740987, -0.00725129, -0.00709204, -0.00693213,
  -0.00677158, -0.0066104, -0.00644862, -0.00628624, -0.00612328,
  -0.00595975, -0.00579567, -0.00563106, -0.00546592, -0.00530029,
  -0.00513416, -0.00496756, -0.00480049, -0.00463299, -0.00446506,
  -0.00429671, -0.00412797, -0.00395885, -0.00378936, -0.00361953,
  -0.00344935, -0.00327886, -0.00310807, -0.00293699, -0.00276564,
  -0.00259403, -0.00242219, -0.00225012, -0.00207784, -0.00190537,
  -0.00173273, -0.00155992, -0.00138698, -0.0012139, -0.00104071,
  -0.000867425, -0.00069406, -0.000520631, -0.000347154, -0.000173645,
  -1.20192e-07, 0.000173405, 0.000346914, 0.000520391, 0.00069382,
  0.000867185, 0.00104047, 0.00121366, 0.00138673, 0.00155968,
  0.00173249, 0.00190513, 0.0020776, 0.00224988, 0.00242195,
  0.00259379, 0.0027654, 0.00293675, 0.00310783, 0.00327862,
  0.00344911, 0.00361929, 0.00378912, 0.00395861, 0.00412773,
  0.00429647, 0.00446482, 0.00463275, 0.00480025, 0.00496732,
  0.00513392, 0.00530004, 0.00546568, 0.00563082, 0.00579543,
  0.00595951, 0.00612304, 0.006286, 0.00644838, 0.00661016,
  0.00677134, 0.00693189, 0.0070918, 0.00725105, 0.00740963,
  0.00756753, 0.00772473, 0.00788121, 0.00803697, 0.00819199,
  0.00834624, 0.00849973, 0.00865243, 0.00880432, 0.00895541,
  0.00910567, 0.00925508, 0.00940364, 0.00955133, 0.00969814,
  0.00984404, 0.00998904, 0.0101331, 0.0102763, 0.0104184, 0.0105597,
  0.0106999, 0.0108392, 0.0109774, 0.0111146, 0.0112509, 0.011386,
  0.0115201, 0.0116532, 0.0117851, 0.011916, 0.0120458, 0.0121744,
  0.012302, 0.0124283, 0.0125536, 0.0126777, 0.0128005, 0.0129223,
  0.0130428, 0.0131621, 0.0132802, 0.013397, 0.0135126, 0.013627,
  0.0137401, 0.0138519, 0.0139624, 0.0140717, 0.0141796, 0.0142862,
  0.0143915, 0.0144955, 0.0145981, 0.0146993, 0.0147992, 0.0148977,
  0.0149949, 0.0150906, 0.0151849, 0.0152779, 0.0153694, 0.0154595,
  0.0155481, 0.0156353, 0.015721, 0.0158053, 0.0158881, 0.0159695,
  0.0160493, 0.0161277, 0.0162045, 0.0162799, 0.0163537, 0.016426,
  0.0164968, 0.0165661, 0.0166338, 0.0166999, 0.0167645, 0.0168276,
  0.016889, 0.0169489, 0.0170072, 0.017064, 0.0171191, 0.0171727,
  0.0172246, 0.0172749, 0.0173237, 0.0173708, 0.0174163, 0.0174601,
  0.0175024, 0.017543, 0.0175819, 0.0176192, 0.0176549, 0.0176889,
  0.0177213, 0.017752, 0.0177811, 0.0178085, 0.0178342, 0.0178583,
  0.0178806, 0.0179014, 0.0179204, 0.0179378, 0.0179534, 0.0179675,
  0.0179798, 0.0179904, 0.0179994, 0.0180066, 0.0180122, 0.0180161,
  0.0180183, 0.0180188, 0.0180176, 0.0180148, 0.0180102, 0.018004,
  0.017996, 0.0179864, 0.0179751, 0.0179621, 0.0179474, 0.017931,
  0.017913, 0.0178932, 0.0178718, 0.0178487, 0.0178239, 0.0177974,
  0.0177693, 0.0177395, 0.017708, 0.0176749, 0.01764, 0.0176036,
  0.0175654, 0.0175256, 0.0174842, 0.0174411, 0.0173964, 0.01735,
  0.017302, 0.0172524, 0.0172011, 0.0171482, 0.0170937, 0.0170375,
  0.0169798, 0.0169205, 0.0168595, 0.016797, 0.0167329, 0.0166672,
  0.0165999, 0.016531, 0.0164606, 0.0163886, 0.0163151, 0.01624,
  0.0161634, 0.0160852, 0.0160056, 0.0159244, 0.0158417, 0.0157575,
  0.0156718, 0.0155846, 0.0154959, 0.0154058, 0.0153142, 0.0152211,
  0.0151266, 0.0150307, 0.0149333, 0.0148345, 0.0147343, 0.0146327,
  0.0145297, 0.0144253, 0.0143195, 0.0142124, 0.0141039, 0.0139941,
  0.013883, 0.0137705, 0.0136567, 0.0135416, 0.0134252, 0.0133075,
  0.0131886, 0.0130684, 0.0129469, 0.0128242, 0.0127003, 0.0125752,
  0.0124488, 0.0123213, 0.0121926, 0.0120627, 0.0119317, 0.0117995,
  0.0116662, 0.0115318, 0.0113962, 0.0112596, 0.0111219, 0.0109831,
  0.0108433, 0.0107024, 0.0105605, 0.0104176, 0.0102737, 0.0101287,
  0.00998286, 0.00983602, 0.00968823, 0.0095395, 0.00938985,
  0.0092393, 0.00908786, 0.00893554, 0.00878236, 0.00862834,
  0.00847347, 0.0083178, 0.00816131, 0.00800404, 0.00784599,
  0.00768719, 0.00752764, 0.00736736, 0.00720637, 0.00704468,
  0.00688231, 0.00671927, 0.00655558, 0.00639125, 0.0062263,
  0.00606075, 0.00589461, 0.0057279, 0.00556063, 0.00539282,
  0.00522449, 0.00505564, 0.00488631, 0.0047165, 0.00454623,
  0.00437552, 0.00420438, 0.00403283, 0.00386089, 0.00368857,
  0.00351589, 0.00334287, 0.00316952, 0.00299586, 0.00282191,
  0.00264768, 0.0024732, 0.00229847, 0.00212351, 0.00194835, 0.001773,
  0.00159747, 0.00142179, 0.00124597, 0.00107002, 0.000893973,
  0.000717836, 0.000541628, 0.000365366, 0.000189069, 1.27527e-05,
  -0.000163565, -0.000339866, -0.000516133, -0.00069235, -0.000868499,
  -0.00104456, -0.00122052, -0.00139636, -0.00157206, -0.00174761,
  -0.00192298, -0.00209817, -0.00227314, -0.00244789, -0.0026224,
  -0.00279665, -0.00297062, -0.0031443, -0.00331767, -0.0034907,
  -0.00366339, -0.00383572, -0.00400766, -0.00417921, -0.00435034,
  -0.00452104, -0.00469129, -0.00486107, -0.00503037, -0.00519916,
  -0.00536744, -0.00553518, -0.00570237, -0.00586899, -0.00603503,
  -0.00620046, -0.00636527, -0.00652945, -0.00669297, -0.00685582,
  -0.00701798, -0.00717945, -0.00734019, -0.00750019, -0.00765945,
  -0.00781793, -0.00797563, -0.00813253, -0.00828861, -0.00844385,
  -0.00859825, -0.00875178, -0.00890443, -0.00905618, -0.00920702,
  -0.00935693, -0.00950589, -0.0096539, -0.00980093, -0.00994697,
  -0.010092, -0.010236, -0.010379, -0.0105209, -0.0106618, -0.0108016,
  -0.0109402, -0.0110778, -0.0112143, -0.0113496, -0.0114837,
  -0.0116167, -0.0117485, -0.0118791, -0.0120085, -0.0121367,
  -0.0122636, -0.0123893, -0.0125137, -0.0126369, -0.0127587,
  -0.0128793, -0.0129985, -0.0131164, -0.013233, -0.0133482,
  -0.013462, -0.0135745, -0.0136855, -0.0137952, -0.0139034,
  -0.0140102, -0.0141156, -0.0142195, -0.014322, -0.0144229,
  -0.0145224, -0.0146204, -0.0147169, -0.0148119, -0.0149053,
  -0.0149972, -0.0150875, -0.0151763, -0.0152635, -0.0153492,
  -0.0154332, -0.0155156, -0.0155965, -0.0156757, -0.0157533,
  -0.0158292, -0.0159035, -0.0159761, -0.0160471, -0.0161164,
  -0.0161841, -0.01625, -0.0163142, -0.0163768, -0.0164376,
  -0.0164967, -0.0165541, -0.0166098, -0.0166637, -0.0167158,
  -0.0167662, -0.0168149, -0.0168618, -0.0169069, -0.0169502,
  -0.0169918, -0.0170315, -0.0170695, -0.0171057, -0.0171401,
  -0.0171726, -0.0172034, -0.0172323, -0.0172594, -0.0172847,
  -0.0173081, -0.0173298, -0.0173495, -0.0173675, -0.0173836,
  -0.0173978, -0.0174102, -0.0174208, -0.0174295, -0.0174363,
  -0.0174413, -0.0174445, -0.0174457, -0.0174451, -0.0174427,
  -0.0174383, -0.0174322, -0.0174241, -0.0174142, -0.0174024,
  -0.0173888, -0.0173732, -0.0173559, -0.0173366, -0.0173155,
  -0.0172925, -0.0172677, -0.017241, -0.0172124, -0.017182,
  -0.0171498, -0.0171156, -0.0170797, -0.0170419, -0.0170022,
  -0.0169607, -0.0169174, -0.0168722, -0.0168252, -0.0167763,
  -0.0167257, -0.0166732, -0.0166189, -0.0165628, -0.0165049,
  -0.0164452, -0.0163836, -0.0163204, -0.0162553, -0.0161884,
  -0.0161198, -0.0160494, -0.0159772, -0.0159033, -0.0158276,
  -0.0157502, -0.0156711, -0.0155903, -0.0155077, -0.0154234,
  -0.0153374, -0.0152498, -0.0151604, -0.0150694, -0.0149767,
  -0.0148823, -0.0147863, -0.0146886, -0.0145894, -0.0144885,
  -0.014386, -0.0142819, -0.0141762, -0.0140689, -0.01396, -0.0138496,
  -0.0137377, -0.0136242, -0.0135092, -0.0133927, -0.0132747,
  -0.0131552, -0.0130342, -0.0129117, -0.0127878, -0.0126625,
  -0.0125357, -0.0124076, -0.012278, -0.0121471, -0.0120147,
  -0.011881, -0.011746, -0.0116097, -0.011472, -0.011333, -0.0111928,
  -0.0110513, -0.0109085, -0.0107645, -0.0106192, -0.0104728,
  -0.0103251, -0.0101763, -0.0100263, -0.00987516, -0.0097229,
  -0.00956952, -0.00941505, -0.0092595, -0.00910288, -0.00894522,
  -0.00878653, -0.00862683, -0.00846614, -0.00830447, -0.00814185,
  -0.00797828, -0.00781379, -0.0076484, -0.00748212, -0.00731498,
  -0.00714699, -0.00697817, -0.00680853, -0.00663811, -0.00646692,
  -0.00629497, -0.00612228, -0.00594889, -0.0057748, -0.00560003,
  -0.00542461, -0.00524855, -0.00507188, -0.00489462, -0.00471678,
  -0.00453838, -0.00435945, -0.00418001, -0.00400008, -0.00381967,
  -0.00363881, -0.00345753, -0.00327583, -0.00309375, -0.0029113,
  -0.0027285, -0.00254538, -0.00236196, -0.00217826, -0.0019943,
  -0.0018101, -0.00162568, -0.00144107, -0.00125629, -0.00107136,
  -0.0008863, -0.000701134, -0.000515884, -0.000330572, -0.000145221,
  4.01484e-05, 0.000225513, 0.00041085, 0.000596137, 0.000781353,
  0.000966474, 0.00115148, 0.00133634, 0.00152104, 0.00170556,
  0.00188987, 0.00207395, 0.00225778, 0.00244134, 0.00262459,
  0.00280753, 0.00299012, 0.00317235, 0.00335418, 0.00353561,
  0.0037166, 0.00389714, 0.0040772, 0.00425675, 0.00443578,
  0.00461427, 0.00479218, 0.0049695, 0.00514621, 0.00532228,
  0.00549769, 0.00567242, 0.00584644, 0.00601974, 0.00619228,
  0.00636406, 0.00653504, 0.0067052, 0.00687453, 0.00704299,
  0.00721058, 0.00737726, 0.00754301, 0.00770781, 0.00787165,
  0.00803449, 0.00819632, 0.00835712, 0.00851686, 0.00867552,
  0.00883308, 0.00898952, 0.00914482, 0.00929896, 0.00945192,
  0.00960367, 0.0097542, 0.00990348, 0.0100515, 0.0101982, 0.0103437,
  0.0104878, 0.0106305, 0.0107719, 0.0109119, 0.0110505, 0.0111877,
  0.0113234, 0.0114577, 0.0115904, 0.0117217, 0.0118515, 0.0119797,
  0.0121063, 0.0122314, 0.0123549, 0.0124768, 0.0125971, 0.0127157,
  0.0128326, 0.0129479, 0.0130614, 0.0131733, 0.0132834, 0.0133917,
  0.0134983, 0.0136031, 0.0137061, 0.0138073, 0.0139067, 0.0140042,
  0.0140999, 0.0141937, 0.0142856, 0.0143756, 0.0144637, 0.0145498,
  0.014634, 0.0147162, 0.0147965, 0.0148748, 0.0149511, 0.0150253,
  0.0150975, 0.0151677, 0.0152359, 0.015302, 0.015366, 0.0154279,
  0.0154877, 0.0155455, 0.0156011, 0.0156546, 0.0157059, 0.0157551,
  0.0158021, 0.015847, 0.0158897, 0.0159302, 0.0159685, 0.0160046,
  0.0160386, 0.0160703, 0.0160997, 0.016127, 0.016152, 0.0161747,
  0.0161952, 0.0162135, 0.0162295, 0.0162432, 0.0162547, 0.0162638,
  0.0162707, 0.0162753, 0.0162777, 0.0162777, 0.0162754, 0.0162709,
  0.016264, 0.0162548, 0.0162434, 0.0162296, 0.0162135, 0.0161951,
  0.0161744, 0.0161514, 0.0161261, 0.0160984, 0.0160685, 0.0160362,
  0.0160017, 0.0159648, 0.0159257, 0.0158842, 0.0158404, 0.0157944,
  0.015746, 0.0156954, 0.0156425, 0.0155873, 0.0155298, 0.0154701,
  0.0154081, 0.0153438, 0.0152773, 0.0152085, 0.0151375, 0.0150643,
  0.0149889, 0.0149112, 0.0148313, 0.0147492, 0.0146649, 0.0145785,
  0.0144899, 0.0143991, 0.0143061, 0.014211, 0.0141138, 0.0140145,
  0.013913, 0.0138095, 0.0137039, 0.0135962, 0.0134864, 0.0133746,
  0.0132608, 0.013145, 0.0130271, 0.0129073, 0.0127855, 0.0126617,
  0.012536, 0.0124084, 0.0122789, 0.0121474, 0.0120141, 0.011879,
  0.011742, 0.0116031, 0.0114625, 0.0113201, 0.0111759, 0.01103,
  0.0108824, 0.0107331, 0.010582, 0.0104293, 0.010275, 0.0101191,
  0.00996151, 0.00980239, 0.00964171, 0.0094795, 0.00931578,
  0.00915058, 0.00898392, 0.00881583, 0.00864632, 0.00847543,
  0.00830317, 0.00812958, 0.00795468, 0.00777849, 0.00760104,
  0.00742236, 0.00724248, 0.00706142, 0.00687921, 0.00669587,
  0.00651144, 0.00632594, 0.0061394, 0.00595186, 0.00576333,
  0.00557386, 0.00538346, 0.00519217, 0.00500001, 0.00480703,
  0.00461325, 0.00441869, 0.0042234, 0.0040274, 0.00383072, 0.0036334,
  0.00343547, 0.00323696, 0.0030379, 0.00283832, 0.00263827,
  0.00243776, 0.00223684, 0.00203554, 0.00183389, 0.00163193,
  0.00142968, 0.00122719, 0.00102449, 0.000821614, 0.000618594,
  0.000415465, 0.000212265, 9.02778e-06, -0.000194211, -0.000397416,
  -0.000600551, -0.000803581, -0.00100647, -0.00120918, -0.00141168,
  -0.00161393, -0.00181589, -0.00201753, -0.00221881, -0.00241969,
  -0.00262015, -0.00282013, -0.00301961, -0.00321854, -0.00341689,
  -0.00361463, -0.00381171, -0.0040081, -0.00420377, -0.00439866,
  -0.00459276, -0.00478601, -0.00497839, -0.00516985, -0.00536036,
  -0.00554988, -0.00573837, -0.0059258, -0.00611213, -0.00629733,
  -0.00648134, -0.00666415, -0.00684571, -0.00702598, -0.00720493,
  -0.00738252, -0.00755871, -0.00773348, -0.00790677, -0.00807856,
  -0.00824881, -0.00841748, -0.00858453, -0.00874994, -0.00891366,
  -0.00907566, -0.00923591, -0.00939437, -0.009551, -0.00970577,
  -0.00985864, -0.0100096, -0.0101586, -0.0103055, -0.0104505,
  -0.0105934, -0.0107342, -0.0108728, -0.0110093, -0.0111436,
  -0.0112757, -0.0114055, -0.011533, -0.0116582, -0.011781,
  -0.0119015, -0.0120195, -0.0121351, -0.0122482, -0.0123588,
  -0.0124669, -0.0125724, -0.0126753, -0.0127756, -0.0128732,
  -0.0129682, -0.0130605, -0.01315, -0.0132368, -0.0133208, -0.013402,
  -0.0134804, -0.013556, -0.0136286, -0.0136984, -0.0137652,
  -0.0138291, -0.0138901, -0.013948, -0.0140029, -0.0140549,
  -0.0141037, -0.0141495, -0.0141922, -0.0142319, -0.0142684,
  -0.0143017, -0.0143319, -0.014359, -0.0143828, -0.0144035,
  -0.014421, -0.0144352, -0.0144462, -0.0144539, -0.0144584,
  -0.0144596, -0.0144576, -0.0144522, -0.0144436, -0.0144317,
  -0.0144164, -0.0143978, -0.0143759, -0.0143507, -0.0143222,
  -0.0142903, -0.0142551, -0.0142165, -0.0141746, -0.0141293,
  -0.0140807, -0.0140288, -0.0139736, -0.013915, -0.013853,
  -0.0137878, -0.0137192, -0.0136473, -0.0135721, -0.0134936,
  -0.0134118, -0.0133267, -0.0132384, -0.0131467, -0.0130519,
  -0.0129538, -0.0128525, -0.0127479, -0.0126402, -0.0125293,
  -0.0124153, -0.0122981, -0.0121777, -0.0120543, -0.0119278,
  -0.0117983, -0.0116657, -0.0115301, -0.0113915, -0.0112499,
  -0.0111054, -0.010958, -0.0108078, -0.0106547, -0.0104987, -0.01034,
  -0.0101785, -0.0100143, -0.00984739, -0.00967784, -0.00950568,
  -0.00933094, -0.00915365, -0.00897386, -0.00879161, -0.00860694,
  -0.00841989, -0.00823051, -0.00803883, -0.0078449, -0.00764877,
  -0.00745049, -0.0072501, -0.00704765, -0.00684319, -0.00663677,
  -0.00642845, -0.00621827, -0.00600629, -0.00579256, -0.00557715,
  -0.0053601, -0.00514147, -0.00492132, -0.00469972, -0.00447671,
  -0.00425236, -0.00402674, -0.0037999, -0.00357191, -0.00334283,
  -0.00311274, -0.00288168, -0.00264974, -0.00241698, -0.00218347,
  -0.00194928, -0.00171447, -0.00147913, -0.00124332, -0.00100711,
  -0.000770585, -0.000533811, -0.000296864, -5.98216e-05, 0.00017724,
  0.000414244, 0.000651112, 0.000887765, 0.00112412, 0.00136011,
  0.00159564, 0.00183063, 0.00206501, 0.00229869, 0.00253158,
  0.00276361, 0.00299468, 0.00322472, 0.00345364, 0.00368136,
  0.00390778, 0.00413282, 0.0043564, 0.00457843, 0.00479882,
  0.00501748, 0.00523432, 0.00544926, 0.00566221, 0.00587307,
  0.00608177, 0.0062882, 0.00649229, 0.00669393, 0.00689305,
  0.00708956, 0.00728335, 0.00747435, 0.00766246, 0.0078476,
  0.00802968, 0.0082086, 0.00838427, 0.00855662, 0.00872555,
  0.00889097, 0.0090528, 0.00921094, 0.00936532, 0.00951584,
  0.00966241, 0.00980497, 0.00994341, 0.0100777, 0.0102076, 0.0103332,
  0.0104544, 0.010571, 0.0106831, 0.0107905, 0.0108931, 0.0109908,
  0.0110837, 0.0111715, 0.0112543, 0.011332, 0.0114045, 0.0114717,
  0.0115335, 0.01159, 0.011641, 0.0116864, 0.0117263, 0.0117605,
  0.0117889, 0.0118116, 0.0118285, 0.0118395, 0.0118446, 0.0118437,
  0.0118368, 0.0118239, 0.0118048, 0.0117796, 0.0117482, 0.0117106,
  0.0116668, 0.0116167, 0.0115603, 0.0114977, 0.0114286, 0.0113533,
  0.0112716, 0.0111835, 0.011089, 0.0109882, 0.010881, 0.0107675,
  0.0106476, 0.0105213, 0.0103887, 0.0102499, 0.0101047, 0.00995333,
  0.00979573, 0.00963196, 0.00946206, 0.00928608, 0.00910407,
  0.0089161, 0.00872222, 0.00852251, 0.00831703, 0.00810587,
  0.00788912, 0.00766686, 0.00743919, 0.00720621, 0.00696803,
  0.00672477, 0.00647654, 0.00622348, 0.00596571, 0.00570339,
  0.00543665, 0.00516566, 0.00489057, 0.00461155, 0.00432878,
  0.00404245, 0.00375274, 0.00345986, 0.00316402, 0.00286543,
  0.00256431, 0.00226091, 0.00195545, 0.0016482, 0.00133942,
  0.00102936, 0.00071832, 0.000406577, 9.44308e-05, -0.00021781,
  -0.000529826, -0.000841291, -0.00115186, -0.0014612, -0.00176893,
  -0.00207469, -0.0023781, -0.00267875, -0.00297625, -0.00327018,
  -0.00356011, -0.00384559, -0.00412618, -0.0044014, -0.00467077,
  -0.00493381, -0.00519, -0.00543883, -0.00567976, -0.00591224,
  -0.00613572, -0.00634961, -0.00655332, -0.00674626, -0.00692779,
  -0.00709728, -0.00725408, -0.00739752, -0.00752692, -0.00764157,
  -0.00774076, -0.00782375, -0.00788979, -0.00793812, -0.00796794,
  -0.00797845, -0.00796883, -0.00793823, -0.0078858, -0.00781065,
  -0.00771189, -0.00758859, -0.00743982, -0.00726462, -0.00706201,
  -0.00683098, -0.00657052, -0.00627958, -0.0059571, -0.00560198,
  -0.00521312, -0.00478939, -0.00432962, -0.00383265, -0.00329726,
  -0.00272222, -0.00210629, -0.00144819, -0.000746617, -2.40384e-07};
  G4double G4NeutronHPFastLegendre::l13[2801] = {-1, -0.936037,
  -0.874121, -0.814207, -0.756254, -0.700221, -0.646067, -0.59375,
  -0.543233, -0.494475, -0.447439, -0.402086, -0.35838, -0.316283,
  -0.27576, -0.236775, -0.199293, -0.163281, -0.128703, -0.0955272,
  -0.0637205, -0.0332507, -0.00408619, 0.0238043, 0.0504513, 0.075885,
  0.100135, 0.123231, 0.1452, 0.166073, 0.185875, 0.204634, 0.222378,
  0.239131, 0.254922, 0.269773, 0.283712, 0.296761, 0.308946, 0.32029,
  0.330817, 0.340548, 0.349507, 0.357715, 0.365195, 0.371968,
  0.378054, 0.383474, 0.388247, 0.392395, 0.395936, 0.398889,
  0.401273, 0.403106, 0.404406, 0.405191, 0.405478, 0.405284,
  0.404626, 0.403519, 0.401981, 0.400025, 0.397669, 0.394926,
  0.391812, 0.388341, 0.384527, 0.380384, 0.375926, 0.371165,
  0.366116, 0.360789, 0.355199, 0.349357, 0.343275, 0.336965,
  0.330438, 0.323705, 0.316778, 0.309666, 0.302381, 0.294932, 0.28733,
  0.279583, 0.271703, 0.263697, 0.255575, 0.247346, 0.239018, 0.2306,
  0.2221, 0.213526, 0.204886, 0.196187, 0.187437, 0.178643, 0.169811,
  0.16095, 0.152065, 0.143163, 0.13425, 0.125333, 0.116417, 0.107508,
  0.0986116, 0.0897334, 0.0808787, 0.0720525, 0.0632599, 0.0545056,
  0.0457944, 0.0371307, 0.028519, 0.0199635, 0.0114683, 0.00303742,
  -0.00532541, -0.0136165, -0.0218321, -0.029969, -0.0380238,
  -0.0459933, -0.0538745, -0.0616643, -0.06936, -0.0769589,
  -0.0844583, -0.0918557, -0.0991489, -0.106335, -0.113413, -0.12038,
  -0.127234, -0.133973, -0.140596, -0.147101, -0.153486, -0.15975,
  -0.165891, -0.171908, -0.177801, -0.183566, -0.189205, -0.194714,
  -0.200095, -0.205346, -0.210465, -0.215453, -0.220309, -0.225032,
  -0.229622, -0.234079, -0.238401, -0.24259, -0.246644, -0.250563,
  -0.254348, -0.257998, -0.261514, -0.264895, -0.268141, -0.271254,
  -0.274232, -0.277077, -0.279788, -0.282367, -0.284813, -0.287127,
  -0.28931, -0.291362, -0.293283, -0.295075, -0.296738, -0.298273,
  -0.299681, -0.300961, -0.302117, -0.303147, -0.304053, -0.304837,
  -0.305498, -0.306039, -0.306459, -0.306761, -0.306944, -0.307011,
  -0.306963, -0.3068, -0.306524, -0.306136, -0.305637, -0.305029,
  -0.304312, -0.303489, -0.30256, -0.301527, -0.300391, -0.299154,
  -0.297816, -0.29638, -0.294846, -0.293216, -0.291492, -0.289675,
  -0.287767, -0.285768, -0.283681, -0.281506, -0.279246, -0.276902,
  -0.274476, -0.271968, -0.269381, -0.266716, -0.263974, -0.261158,
  -0.258268, -0.255306, -0.252274, -0.249174, -0.246006, -0.242773,
  -0.239475, -0.236116, -0.232695, -0.229215, -0.225677, -0.222083,
  -0.218435, -0.214733, -0.21098, -0.207176, -0.203325, -0.199426,
  -0.195482, -0.191494, -0.187464, -0.183393, -0.179283, -0.175135,
  -0.17095, -0.166731, -0.162479, -0.158195, -0.15388, -0.149537,
  -0.145166, -0.140769, -0.136348, -0.131904, -0.127438, -0.122952,
  -0.118447, -0.113924, -0.109386, -0.104832, -0.100266, -0.0956876,
  -0.0910985, -0.0865002, -0.0818939, -0.077281, -0.0726627,
  -0.0680403, -0.0634151, -0.0587884, -0.0541614, -0.0495354,
  -0.0449115, -0.0402909, -0.035675, -0.0310648, -0.0264615,
  -0.0218663, -0.0172804, -0.0127048, -0.00814069, -0.00358915,
  0.000948713, 0.00547183, 0.00997914, 0.0144696, 0.0189422,
  0.0233958, 0.0278296, 0.0322424, 0.0366334, 0.0410015, 0.0453458,
  0.0496654, 0.0539594, 0.0582268, 0.0624667, 0.0666784, 0.0708609,
  0.0750134, 0.079135, 0.083225, 0.0872825, 0.0913067, 0.095297,
  0.0992524, 0.103172, 0.107056, 0.110903, 0.114712, 0.118483,
  0.122214, 0.125906, 0.129558, 0.133169, 0.136738, 0.140265, 0.14375,
  0.147191, 0.150588, 0.153941, 0.157249, 0.160512, 0.163729,
  0.166899, 0.170023, 0.173099, 0.176128, 0.179108, 0.18204, 0.184923,
  0.187756, 0.19054, 0.193274, 0.195957, 0.19859, 0.201171, 0.203702,
  0.20618, 0.208607, 0.210981, 0.213303, 0.215573, 0.217789, 0.219953,
  0.222063, 0.22412, 0.226123, 0.228072, 0.229968, 0.231809, 0.233596,
  0.235329, 0.237008, 0.238632, 0.240201, 0.241716, 0.243176,
  0.244581, 0.245932, 0.247228, 0.248469, 0.249655, 0.250787,
  0.251864, 0.252886, 0.253854, 0.254767, 0.255626, 0.25643, 0.25718,
  0.257876, 0.258517, 0.259105, 0.259638, 0.260118, 0.260545,
  0.260918, 0.261238, 0.261504, 0.261718, 0.261879, 0.261988,
  0.262044, 0.262049, 0.262001, 0.261902, 0.261752, 0.261551,
  0.261298, 0.260996, 0.260643, 0.26024, 0.259787, 0.259285, 0.258734,
  0.258134, 0.257485, 0.256789, 0.256045, 0.255253, 0.254414,
  0.253529, 0.252597, 0.251619, 0.250596, 0.249527, 0.248413,
  0.247255, 0.246053, 0.244808, 0.243519, 0.242187, 0.240813,
  0.239397, 0.237939, 0.23644, 0.2349, 0.233321, 0.231701, 0.230042,
  0.228344, 0.226608, 0.224834, 0.223022, 0.221173, 0.219288,
  0.217367, 0.21541, 0.213418, 0.211391, 0.209331, 0.207236, 0.205109,
  0.202949, 0.200757, 0.198533, 0.196278, 0.193993, 0.191678,
  0.189333, 0.186959, 0.184556, 0.182126, 0.179668, 0.177183,
  0.174672, 0.172135, 0.169573, 0.166985, 0.164374, 0.161739, 0.15908,
  0.156399, 0.153696, 0.150972, 0.148226, 0.14546, 0.142673, 0.139868,
  0.137043, 0.1342, 0.13134, 0.128462, 0.125568, 0.122657, 0.11973,
  0.116789, 0.113833, 0.110863, 0.10788, 0.104884, 0.101875,
  0.0988543, 0.0958225, 0.0927799, 0.089727, 0.0866645, 0.0835928,
  0.0805125, 0.0774241, 0.0743281, 0.071225, 0.0681155, 0.0649999,
  0.0618789, 0.0587529, 0.0556225, 0.0524882, 0.0493505, 0.0462099,
  0.043067, 0.0399221, 0.0367759, 0.0336289, 0.0304815, 0.0273343,
  0.0241877, 0.0210423, 0.0178985, 0.0147569, 0.0116178, 0.00848188,
  0.00534953, 0.00222124, -0.000902503, -0.00402123, -0.00713448,
  -0.0102418, -0.0133426, -0.0164366, -0.0195233, -0.0226022,
  -0.0256728, -0.0287347, -0.0317875, -0.0348307, -0.0378639,
  -0.0408867, -0.0438985, -0.0468991, -0.0498879, -0.0528645,
  -0.0558286, -0.0587797, -0.0617174, -0.0646413, -0.0675511,
  -0.0704462, -0.0733263, -0.076191, -0.07904, -0.0818728, -0.0846891,
  -0.0874885, -0.0902706, -0.0930351, -0.0957816, -0.0985097,
  -0.101219, -0.103909, -0.10658, -0.109232, -0.111863, -0.114474,
  -0.117064, -0.119632, -0.12218, -0.124706, -0.12721, -0.129691,
  -0.13215, -0.134586, -0.136999, -0.139389, -0.141754, -0.144096,
  -0.146413, -0.148706, -0.150974, -0.153216, -0.155434, -0.157625,
  -0.159791, -0.161931, -0.164044, -0.166131, -0.168191, -0.170224,
  -0.17223, -0.174208, -0.176159, -0.178082, -0.179976, -0.181843,
  -0.183681, -0.18549, -0.18727, -0.189022, -0.190744, -0.192437,
  -0.194101, -0.195735, -0.197339, -0.198913, -0.200457, -0.201971,
  -0.203454, -0.204907, -0.206329, -0.20772, -0.209081, -0.210411,
  -0.211709, -0.212977, -0.214213, -0.215417, -0.216591, -0.217732,
  -0.218843, -0.219921, -0.220968, -0.221982, -0.222965, -0.223916,
  -0.224835, -0.225722, -0.226577, -0.227399, -0.22819, -0.228948,
  -0.229674, -0.230368, -0.231029, -0.231659, -0.232255, -0.23282,
  -0.233353, -0.233853, -0.23432, -0.234756, -0.235159, -0.23553,
  -0.235869, -0.236176, -0.236451, -0.236693, -0.236903, -0.237082,
  -0.237228, -0.237343, -0.237425, -0.237476, -0.237495, -0.237483,
  -0.237439, -0.237363, -0.237256, -0.237118, -0.236948, -0.236748,
  -0.236516, -0.236253, -0.235959, -0.235635, -0.23528, -0.234894,
  -0.234478, -0.234032, -0.233555, -0.233049, -0.232512, -0.231946,
  -0.23135, -0.230725, -0.23007, -0.229386, -0.228673, -0.227931,
  -0.22716, -0.226361, -0.225533, -0.224677, -0.223793, -0.222881,
  -0.221941, -0.220974, -0.219979, -0.218957, -0.217908, -0.216833,
  -0.21573, -0.214601, -0.213446, -0.212265, -0.211058, -0.209825,
  -0.208567, -0.207284, -0.205976, -0.204642, -0.203285, -0.201903,
  -0.200496, -0.199066, -0.197612, -0.196135, -0.194635, -0.193111,
  -0.191565, -0.189996, -0.188405, -0.186792, -0.185157, -0.1835,
  -0.181822, -0.180123, -0.178404, -0.176663, -0.174903, -0.173122,
  -0.171322, -0.169502, -0.167663, -0.165804, -0.163927, -0.162032,
  -0.160118, -0.158186, -0.156237, -0.15427, -0.152286, -0.150286,
  -0.148268, -0.146235, -0.144185, -0.14212, -0.140039, -0.137942,
  -0.135831, -0.133706, -0.131566, -0.129412, -0.127244, -0.125062,
  -0.122868, -0.12066, -0.11844, -0.116208, -0.113963, -0.111707,
  -0.109439, -0.10716, -0.10487, -0.10257, -0.100259, -0.0979379,
  -0.0956074, -0.0932674, -0.0909183, -0.0885604, -0.0861939,
  -0.0838191, -0.0814365, -0.0790461, -0.0766484, -0.0742436,
  -0.0718321, -0.069414, -0.0669898, -0.0645597, -0.062124, -0.059683,
  -0.057237, -0.0547864, -0.0523312, -0.049872, -0.047409, -0.0449424,
  -0.0424726, -0.0399998, -0.0375244, -0.0350467, -0.0325669,
  -0.0300853, -0.0276022, -0.0251179, -0.0226327, -0.020147,
  -0.0176609, -0.0151747, -0.0126888, -0.0102035, -0.00771892,
  -0.00523549, -0.00275345, -0.000273094, 0.00220531, 0.00468147,
  0.00715512, 0.00962597, 0.0120937, 0.0145582, 0.0170189, 0.0194758,
  0.0219285, 0.0243767, 0.0268203, 0.0292588, 0.031692, 0.0341197,
  0.0365416, 0.0389575, 0.041367, 0.0437699, 0.0461659, 0.0485548,
  0.0509364, 0.0533103, 0.0556763, 0.0580341, 0.0603836, 0.0627244,
  0.0650563, 0.067379, 0.0696924, 0.0719961, 0.0742898, 0.0765735,
  0.0788468, 0.0811095, 0.0833613, 0.085602, 0.0878314, 0.0900492,
  0.0922553, 0.0944493, 0.0966311, 0.0988005, 0.100957, 0.103101,
  0.105231, 0.107349, 0.109452, 0.111542, 0.113618, 0.11568, 0.117727,
  0.11976, 0.121778, 0.123781, 0.125768, 0.12774, 0.129697, 0.131638,
  0.133563, 0.135471, 0.137363, 0.139239, 0.141098, 0.14294, 0.144765,
  0.146572, 0.148362, 0.150135, 0.15189, 0.153626, 0.155345, 0.157045,
  0.158727, 0.160391, 0.162035, 0.163661, 0.165267, 0.166854,
  0.168422, 0.169971, 0.1715, 0.173009, 0.174498, 0.175967, 0.177415,
  0.178844, 0.180252, 0.181639, 0.183006, 0.184352, 0.185677, 0.18698,
  0.188263, 0.189525, 0.190765, 0.191983, 0.19318, 0.194355, 0.195509,
  0.19664, 0.19775, 0.198837, 0.199902, 0.200945, 0.201966, 0.202964,
  0.20394, 0.204893, 0.205824, 0.206731, 0.207616, 0.208479, 0.209318,
  0.210134, 0.210927, 0.211697, 0.212444, 0.213168, 0.213869,
  0.214546, 0.2152, 0.21583, 0.216437, 0.217021, 0.217581, 0.218118,
  0.218631, 0.21912, 0.219586, 0.220028, 0.220447, 0.220842, 0.221213,
  0.221561, 0.221885, 0.222185, 0.222461, 0.222714, 0.222943,
  0.223149, 0.22333, 0.223488, 0.223623, 0.223733, 0.22382, 0.223884,
  0.223924, 0.22394, 0.223932, 0.223901, 0.223847, 0.223769, 0.223668,
  0.223543, 0.223395, 0.223223, 0.223029, 0.222811, 0.222569,
  0.222305, 0.222018, 0.221707, 0.221374, 0.221017, 0.220638,
  0.220236, 0.219811, 0.219364, 0.218894, 0.218401, 0.217887,
  0.217349, 0.21679, 0.216208, 0.215604, 0.214978, 0.21433, 0.21366,
  0.212968, 0.212255, 0.21152, 0.210764, 0.209986, 0.209187, 0.208367,
  0.207525, 0.206663, 0.20578, 0.204876, 0.203951, 0.203006, 0.202041,
  0.201055, 0.200049, 0.199023, 0.197977, 0.196911, 0.195825, 0.19472,
  0.193596, 0.192452, 0.191289, 0.190107, 0.188907, 0.187687,
  0.186449, 0.185193, 0.183918, 0.182625, 0.181314, 0.179985,
  0.178638, 0.177274, 0.175893, 0.174494, 0.173078, 0.171645,
  0.170195, 0.168729, 0.167246, 0.165747, 0.164232, 0.162701,
  0.161154, 0.159592, 0.158014, 0.15642, 0.154812, 0.153189, 0.151551,
  0.149898, 0.148231, 0.14655, 0.144854, 0.143145, 0.141422, 0.139686,
  0.137936, 0.136174, 0.134398, 0.132609, 0.130808, 0.128995,
  0.127169, 0.125332, 0.123482, 0.121621, 0.119749, 0.117865, 0.11597,
  0.114065, 0.112149, 0.110222, 0.108285, 0.106338, 0.104382,
  0.102416, 0.10044, 0.0984549, 0.096461, 0.0944582, 0.0924469,
  0.0904271, 0.0883991, 0.0863631, 0.0843194, 0.082268, 0.0802093,
  0.0781435, 0.0760706, 0.073991, 0.0719049, 0.0698125, 0.0677139,
  0.0656095, 0.0634993, 0.0613837, 0.0592627, 0.0571368, 0.0550059,
  0.0528705, 0.0507306, 0.0485865, 0.0464384, 0.0442865, 0.0421311,
  0.0399722, 0.0378103, 0.0356454, 0.0334778, 0.0313076, 0.0291352,
  0.0269607, 0.0247844, 0.0226064, 0.0204269, 0.0182462, 0.0160645,
  0.013882, 0.0116989, 0.00951546, 0.00733184, 0.00514825, 0.00296493,
  0.000782085, -0.00140008, -0.00358135, -0.00576152, -0.00794037,
  -0.0101177, -0.0122933, -0.0144669, -0.0166384, -0.0188076,
  -0.0209741, -0.0231379, -0.0252987, -0.0274563, -0.0296105,
  -0.0317611, -0.0339079, -0.0360507, -0.0381892, -0.0403234,
  -0.0424529, -0.0445776, -0.0466973, -0.0488117, -0.0509207,
  -0.0530241, -0.0551217, -0.0572132, -0.0592985, -0.0613774,
  -0.0634497, -0.0655151, -0.0675736, -0.0696249, -0.0716688,
  -0.0737051, -0.0757336, -0.0777542, -0.0797666, -0.0817707,
  -0.0837663, -0.0857531, -0.0877311, -0.0897, -0.0916596, -0.0936098,
  -0.0955503, -0.0974811, -0.0994019, -0.101312, -0.103213, -0.105103,
  -0.106982, -0.10885, -0.110707, -0.112553, -0.114388, -0.116211,
  -0.118022, -0.119822, -0.121609, -0.123384, -0.125147, -0.126898,
  -0.128635, -0.13036, -0.132072, -0.133771, -0.135456, -0.137128,
  -0.138786, -0.140431, -0.142061, -0.143678, -0.14528, -0.146868,
  -0.148442, -0.150001, -0.151545, -0.153074, -0.154588, -0.156087,
  -0.157571, -0.159039, -0.160492, -0.161929, -0.16335, -0.164755,
  -0.166144, -0.167517, -0.168873, -0.170213, -0.171537, -0.172843,
  -0.174133, -0.175406, -0.176662, -0.177901, -0.179123, -0.180327,
  -0.181513, -0.182683, -0.183834, -0.184968, -0.186084, -0.187182,
  -0.188262, -0.189323, -0.190367, -0.191392, -0.192398, -0.193387,
  -0.194356, -0.195307, -0.196239, -0.197152, -0.198047, -0.198922,
  -0.199779, -0.200616, -0.201434, -0.202232, -0.203012, -0.203772,
  -0.204512, -0.205233, -0.205934, -0.206616, -0.207278, -0.20792,
  -0.208543, -0.209145, -0.209728, -0.210291, -0.210833, -0.211356,
  -0.211859, -0.212341, -0.212803, -0.213245, -0.213667, -0.214069,
  -0.21445, -0.214811, -0.215152, -0.215472, -0.215772, -0.216051,
  -0.21631, -0.216549, -0.216767, -0.216964, -0.217141, -0.217298,
  -0.217434, -0.21755, -0.217645, -0.217719, -0.217773, -0.217807,
  -0.21782, -0.217812, -0.217785, -0.217736, -0.217667, -0.217578,
  -0.217468, -0.217338, -0.217187, -0.217016, -0.216824, -0.216613,
  -0.21638, -0.216128, -0.215855, -0.215562, -0.215249, -0.214916,
  -0.214563, -0.214189, -0.213796, -0.213382, -0.212949, -0.212495,
  -0.212022, -0.211529, -0.211016, -0.210484, -0.209932, -0.20936,
  -0.208768, -0.208158, -0.207527, -0.206878, -0.206209, -0.205521,
  -0.204814, -0.204087, -0.203342, -0.202578, -0.201795, -0.200993,
  -0.200172, -0.199333, -0.198475, -0.197599, -0.196704, -0.195791,
  -0.19486, -0.193911, -0.192944, -0.191959, -0.190956, -0.189935,
  -0.188897, -0.187841, -0.186768, -0.185677, -0.184569, -0.183444,
  -0.182302, -0.181143, -0.179968, -0.178776, -0.177567, -0.176341,
  -0.1751, -0.173842, -0.172568, -0.171278, -0.169972, -0.168651,
  -0.167314, -0.165961, -0.164593, -0.16321, -0.161812, -0.160398,
  -0.15897, -0.157528, -0.15607, -0.154599, -0.153113, -0.151613,
  -0.150098, -0.14857, -0.147029, -0.145474, -0.143905, -0.142323,
  -0.140728, -0.13912, -0.137499, -0.135865, -0.134219, -0.13256,
  -0.13089, -0.129207, -0.127512, -0.125806, -0.124088, -0.122358,
  -0.120617, -0.118866, -0.117103, -0.115329, -0.113545, -0.11175,
  -0.109945, -0.10813, -0.106305, -0.10447, -0.102626, -0.100772,
  -0.0989086, -0.0970363, -0.0951551, -0.0932651, -0.0913666,
  -0.0894596, -0.0875444, -0.0856212, -0.0836901, -0.0817513,
  -0.079805, -0.0778513, -0.0758905, -0.0739227, -0.0719481,
  -0.0699668, -0.0679792, -0.0659853, -0.0639853, -0.0619795,
  -0.059968, -0.0579509, -0.0559285, -0.053901, -0.0518685,
  -0.0498313, -0.0477895, -0.0457433, -0.0436929, -0.0416385,
  -0.0395802, -0.0375184, -0.035453, -0.0333844, -0.0313128,
  -0.0292383, -0.0271611, -0.0250813, -0.0229993, -0.0209152,
  -0.0188292, -0.0167414, -0.0146521, -0.0125614, -0.0104696,
  -0.00837685, -0.00628331, -0.0041892, -0.00209469, 0, 0.00209469,
  0.0041892, 0.00628331, 0.00837685, 0.0104696, 0.0125614, 0.0146521,
  0.0167414, 0.0188292, 0.0209152, 0.0229993, 0.0250813, 0.0271611,
  0.0292383, 0.0313128, 0.0333844, 0.035453, 0.0375184, 0.0395802,
  0.0416385, 0.0436929, 0.0457433, 0.0477895, 0.0498313, 0.0518685,
  0.053901, 0.0559285, 0.0579509, 0.059968, 0.0619795, 0.0639853,
  0.0659853, 0.0679792, 0.0699668, 0.0719481, 0.0739227, 0.0758905,
  0.0778513, 0.079805, 0.0817513, 0.0836901, 0.0856212, 0.0875444,
  0.0894596, 0.0913666, 0.0932651, 0.0951551, 0.0970363, 0.0989086,
  0.100772, 0.102626, 0.10447, 0.106305, 0.10813, 0.109945, 0.11175,
  0.113545, 0.115329, 0.117103, 0.118866, 0.120617, 0.122358,
  0.124088, 0.125806, 0.127512, 0.129207, 0.13089, 0.13256, 0.134219,
  0.135865, 0.137499, 0.13912, 0.140728, 0.142323, 0.143905, 0.145474,
  0.147029, 0.14857, 0.150098, 0.151613, 0.153113, 0.154599, 0.15607,
  0.157528, 0.15897, 0.160398, 0.161812, 0.16321, 0.164593, 0.165961,
  0.167314, 0.168651, 0.169972, 0.171278, 0.172568, 0.173842, 0.1751,
  0.176341, 0.177567, 0.178776, 0.179968, 0.181143, 0.182302,
  0.183444, 0.184569, 0.185677, 0.186768, 0.187841, 0.188897,
  0.189935, 0.190956, 0.191959, 0.192944, 0.193911, 0.19486, 0.195791,
  0.196704, 0.197599, 0.198475, 0.199333, 0.200172, 0.200993,
  0.201795, 0.202578, 0.203342, 0.204087, 0.204814, 0.205521,
  0.206209, 0.206878, 0.207527, 0.208158, 0.208768, 0.20936, 0.209932,
  0.210484, 0.211016, 0.211529, 0.212022, 0.212495, 0.212949,
  0.213382, 0.213796, 0.214189, 0.214563, 0.214916, 0.215249,
  0.215562, 0.215855, 0.216128, 0.21638, 0.216613, 0.216824, 0.217016,
  0.217187, 0.217338, 0.217468, 0.217578, 0.217667, 0.217736,
  0.217785, 0.217812, 0.21782, 0.217807, 0.217773, 0.217719, 0.217645,
  0.21755, 0.217434, 0.217298, 0.217141, 0.216964, 0.216767, 0.216549,
  0.21631, 0.216051, 0.215772, 0.215472, 0.215152, 0.214811, 0.21445,
  0.214069, 0.213667, 0.213245, 0.212803, 0.212341, 0.211859,
  0.211356, 0.210833, 0.210291, 0.209728, 0.209145, 0.208543, 0.20792,
  0.207278, 0.206616, 0.205934, 0.205233, 0.204512, 0.203772,
  0.203012, 0.202232, 0.201434, 0.200616, 0.199779, 0.198922,
  0.198047, 0.197152, 0.196239, 0.195307, 0.194356, 0.193387,
  0.192398, 0.191392, 0.190367, 0.189323, 0.188262, 0.187182,
  0.186084, 0.184968, 0.183834, 0.182683, 0.181513, 0.180327,
  0.179123, 0.177901, 0.176662, 0.175406, 0.174133, 0.172843,
  0.171537, 0.170213, 0.168873, 0.167517, 0.166144, 0.164755, 0.16335,
  0.161929, 0.160492, 0.159039, 0.157571, 0.156087, 0.154588,
  0.153074, 0.151545, 0.150001, 0.148442, 0.146868, 0.14528, 0.143678,
  0.142061, 0.140431, 0.138786, 0.137128, 0.135456, 0.133771,
  0.132072, 0.13036, 0.128635, 0.126898, 0.125147, 0.123384, 0.121609,
  0.119822, 0.118022, 0.116211, 0.114388, 0.112553, 0.110707, 0.10885,
  0.106982, 0.105103, 0.103213, 0.101312, 0.0994019, 0.0974811,
  0.0955503, 0.0936098, 0.0916596, 0.0897, 0.0877311, 0.0857531,
  0.0837663, 0.0817707, 0.0797666, 0.0777542, 0.0757336, 0.0737051,
  0.0716688, 0.0696249, 0.0675736, 0.0655151, 0.0634497, 0.0613774,
  0.0592985, 0.0572132, 0.0551217, 0.0530241, 0.0509207, 0.0488117,
  0.0466973, 0.0445776, 0.0424529, 0.0403234, 0.0381892, 0.0360507,
  0.0339079, 0.0317611, 0.0296105, 0.0274563, 0.0252987, 0.0231379,
  0.0209741, 0.0188076, 0.0166384, 0.0144669, 0.0122933, 0.0101177,
  0.00794037, 0.00576152, 0.00358135, 0.00140008, -0.000782085,
  -0.00296493, -0.00514825, -0.00733184, -0.00951546, -0.0116989,
  -0.013882, -0.0160645, -0.0182462, -0.0204269, -0.0226064,
  -0.0247844, -0.0269607, -0.0291352, -0.0313076, -0.0334778,
  -0.0356454, -0.0378103, -0.0399722, -0.0421311, -0.0442865,
  -0.0464384, -0.0485865, -0.0507306, -0.0528705, -0.0550059,
  -0.0571368, -0.0592627, -0.0613837, -0.0634993, -0.0656095,
  -0.0677139, -0.0698125, -0.0719049, -0.073991, -0.0760706,
  -0.0781435, -0.0802093, -0.082268, -0.0843194, -0.0863631,
  -0.0883991, -0.0904271, -0.0924469, -0.0944582, -0.096461,
  -0.0984549, -0.10044, -0.102416, -0.104382, -0.106338, -0.108285,
  -0.110222, -0.112149, -0.114065, -0.11597, -0.117865, -0.119749,
  -0.121621, -0.123482, -0.125332, -0.127169, -0.128995, -0.130808,
  -0.132609, -0.134398, -0.136174, -0.137936, -0.139686, -0.141422,
  -0.143145, -0.144854, -0.14655, -0.148231, -0.149898, -0.151551,
  -0.153189, -0.154812, -0.15642, -0.158014, -0.159592, -0.161154,
  -0.162701, -0.164232, -0.165747, -0.167246, -0.168729, -0.170195,
  -0.171645, -0.173078, -0.174494, -0.175893, -0.177274, -0.178638,
  -0.179985, -0.181314, -0.182625, -0.183918, -0.185193, -0.186449,
  -0.187687, -0.188907, -0.190107, -0.191289, -0.192452, -0.193596,
  -0.19472, -0.195825, -0.196911, -0.197977, -0.199023, -0.200049,
  -0.201055, -0.202041, -0.203006, -0.203951, -0.204876, -0.20578,
  -0.206663, -0.207525, -0.208367, -0.209187, -0.209986, -0.210764,
  -0.21152, -0.212255, -0.212968, -0.21366, -0.21433, -0.214978,
  -0.215604, -0.216208, -0.21679, -0.217349, -0.217887, -0.218401,
  -0.218894, -0.219364, -0.219811, -0.220236, -0.220638, -0.221017,
  -0.221374, -0.221707, -0.222018, -0.222305, -0.222569, -0.222811,
  -0.223029, -0.223223, -0.223395, -0.223543, -0.223668, -0.223769,
  -0.223847, -0.223901, -0.223932, -0.22394, -0.223924, -0.223884,
  -0.22382, -0.223733, -0.223623, -0.223488, -0.22333, -0.223149,
  -0.222943, -0.222714, -0.222461, -0.222185, -0.221885, -0.221561,
  -0.221213, -0.220842, -0.220447, -0.220028, -0.219586, -0.21912,
  -0.218631, -0.218118, -0.217581, -0.217021, -0.216437, -0.21583,
  -0.2152, -0.214546, -0.213869, -0.213168, -0.212444, -0.211697,
  -0.210927, -0.210134, -0.209318, -0.208479, -0.207616, -0.206731,
  -0.205824, -0.204893, -0.20394, -0.202964, -0.201966, -0.200945,
  -0.199902, -0.198837, -0.19775, -0.19664, -0.195509, -0.194355,
  -0.19318, -0.191983, -0.190765, -0.189525, -0.188263, -0.18698,
  -0.185677, -0.184352, -0.183006, -0.181639, -0.180252, -0.178844,
  -0.177415, -0.175967, -0.174498, -0.173009, -0.1715, -0.169971,
  -0.168422, -0.166854, -0.165267, -0.163661, -0.162035, -0.160391,
  -0.158727, -0.157045, -0.155345, -0.153626, -0.15189, -0.150135,
  -0.148362, -0.146572, -0.144765, -0.14294, -0.141098, -0.139239,
  -0.137363, -0.135471, -0.133563, -0.131638, -0.129697, -0.12774,
  -0.125768, -0.123781, -0.121778, -0.11976, -0.117727, -0.11568,
  -0.113618, -0.111542, -0.109452, -0.107349, -0.105231, -0.103101,
  -0.100957, -0.0988005, -0.0966311, -0.0944493, -0.0922553,
  -0.0900492, -0.0878314, -0.085602, -0.0833613, -0.0811095,
  -0.0788468, -0.0765735, -0.0742898, -0.0719961, -0.0696924,
  -0.067379, -0.0650563, -0.0627244, -0.0603836, -0.0580341,
  -0.0556763, -0.0533103, -0.0509364, -0.0485548, -0.0461659,
  -0.0437699, -0.041367, -0.0389575, -0.0365416, -0.0341197,
  -0.031692, -0.0292588, -0.0268203, -0.0243767, -0.0219285,
  -0.0194758, -0.0170189, -0.0145582, -0.0120937, -0.00962597,
  -0.00715512, -0.00468147, -0.00220531, 0.000273094, 0.00275345,
  0.00523549, 0.00771892, 0.0102035, 0.0126888, 0.0151747, 0.0176609,
  0.020147, 0.0226327, 0.0251179, 0.0276022, 0.0300853, 0.0325669,
  0.0350467, 0.0375244, 0.0399998, 0.0424726, 0.0449424, 0.047409,
  0.049872, 0.0523312, 0.0547864, 0.057237, 0.059683, 0.062124,
  0.0645597, 0.0669898, 0.069414, 0.0718321, 0.0742436, 0.0766484,
  0.0790461, 0.0814365, 0.0838191, 0.0861939, 0.0885604, 0.0909183,
  0.0932674, 0.0956074, 0.0979379, 0.100259, 0.10257, 0.10487,
  0.10716, 0.109439, 0.111707, 0.113963, 0.116208, 0.11844, 0.12066,
  0.122868, 0.125062, 0.127244, 0.129412, 0.131566, 0.133706,
  0.135831, 0.137942, 0.140039, 0.14212, 0.144185, 0.146235, 0.148268,
  0.150286, 0.152286, 0.15427, 0.156237, 0.158186, 0.160118, 0.162032,
  0.163927, 0.165804, 0.167663, 0.169502, 0.171322, 0.173122,
  0.174903, 0.176663, 0.178404, 0.180123, 0.181822, 0.1835, 0.185157,
  0.186792, 0.188405, 0.189996, 0.191565, 0.193111, 0.194635,
  0.196135, 0.197612, 0.199066, 0.200496, 0.201903, 0.203285,
  0.204642, 0.205976, 0.207284, 0.208567, 0.209825, 0.211058,
  0.212265, 0.213446, 0.214601, 0.21573, 0.216833, 0.217908, 0.218957,
  0.219979, 0.220974, 0.221941, 0.222881, 0.223793, 0.224677,
  0.225533, 0.226361, 0.22716, 0.227931, 0.228673, 0.229386, 0.23007,
  0.230725, 0.23135, 0.231946, 0.232512, 0.233049, 0.233555, 0.234032,
  0.234478, 0.234894, 0.23528, 0.235635, 0.235959, 0.236253, 0.236516,
  0.236748, 0.236948, 0.237118, 0.237256, 0.237363, 0.237439,
  0.237483, 0.237495, 0.237476, 0.237425, 0.237343, 0.237228,
  0.237082, 0.236903, 0.236693, 0.236451, 0.236176, 0.235869, 0.23553,
  0.235159, 0.234756, 0.23432, 0.233853, 0.233353, 0.23282, 0.232255,
  0.231659, 0.231029, 0.230368, 0.229674, 0.228948, 0.22819, 0.227399,
  0.226577, 0.225722, 0.224835, 0.223916, 0.222965, 0.221982,
  0.220968, 0.219921, 0.218843, 0.217732, 0.216591, 0.215417,
  0.214213, 0.212977, 0.211709, 0.210411, 0.209081, 0.20772, 0.206329,
  0.204907, 0.203454, 0.201971, 0.200457, 0.198913, 0.197339,
  0.195735, 0.194101, 0.192437, 0.190744, 0.189022, 0.18727, 0.18549,
  0.183681, 0.181843, 0.179976, 0.178082, 0.176159, 0.174208, 0.17223,
  0.170224, 0.168191, 0.166131, 0.164044, 0.161931, 0.159791,
  0.157625, 0.155434, 0.153216, 0.150974, 0.148706, 0.146413,
  0.144096, 0.141754, 0.139389, 0.136999, 0.134586, 0.13215, 0.129691,
  0.12721, 0.124706, 0.12218, 0.119632, 0.117064, 0.114474, 0.111863,
  0.109232, 0.10658, 0.103909, 0.101219, 0.0985097, 0.0957816,
  0.0930351, 0.0902706, 0.0874885, 0.0846891, 0.0818728, 0.07904,
  0.076191, 0.0733263, 0.0704462, 0.0675511, 0.0646413, 0.0617174,
  0.0587797, 0.0558286, 0.0528645, 0.0498879, 0.0468991, 0.0438985,
  0.0408867, 0.0378639, 0.0348307, 0.0317875, 0.0287347, 0.0256728,
  0.0226022, 0.0195233, 0.0164366, 0.0133426, 0.0102418, 0.00713448,
  0.00402123, 0.000902503, -0.00222124, -0.00534953, -0.00848188,
  -0.0116178, -0.0147569, -0.0178985, -0.0210423, -0.0241877,
  -0.0273343, -0.0304815, -0.0336289, -0.0367759, -0.0399221,
  -0.043067, -0.0462099, -0.0493505, -0.0524882, -0.0556225,
  -0.0587529, -0.0618789, -0.0649999, -0.0681155, -0.071225,
  -0.0743281, -0.0774241, -0.0805125, -0.0835928, -0.0866645,
  -0.089727, -0.0927799, -0.0958225, -0.0988543, -0.101875, -0.104884,
  -0.10788, -0.110863, -0.113833, -0.116789, -0.11973, -0.122657,
  -0.125568, -0.128462, -0.13134, -0.1342, -0.137043, -0.139868,
  -0.142673, -0.14546, -0.148226, -0.150972, -0.153696, -0.156399,
  -0.15908, -0.161739, -0.164374, -0.166985, -0.169573, -0.172135,
  -0.174672, -0.177183, -0.179668, -0.182126, -0.184556, -0.186959,
  -0.189333, -0.191678, -0.193993, -0.196278, -0.198533, -0.200757,
  -0.202949, -0.205109, -0.207236, -0.209331, -0.211391, -0.213418,
  -0.21541, -0.217367, -0.219288, -0.221173, -0.223022, -0.224834,
  -0.226608, -0.228344, -0.230042, -0.231701, -0.233321, -0.2349,
  -0.23644, -0.237939, -0.239397, -0.240813, -0.242187, -0.243519,
  -0.244808, -0.246053, -0.247255, -0.248413, -0.249527, -0.250596,
  -0.251619, -0.252597, -0.253529, -0.254414, -0.255253, -0.256045,
  -0.256789, -0.257485, -0.258134, -0.258734, -0.259285, -0.259787,
  -0.26024, -0.260643, -0.260996, -0.261298, -0.261551, -0.261752,
  -0.261902, -0.262001, -0.262049, -0.262044, -0.261988, -0.261879,
  -0.261718, -0.261504, -0.261238, -0.260918, -0.260545, -0.260118,
  -0.259638, -0.259105, -0.258517, -0.257876, -0.25718, -0.25643,
  -0.255626, -0.254767, -0.253854, -0.252886, -0.251864, -0.250787,
  -0.249655, -0.248469, -0.247228, -0.245932, -0.244581, -0.243176,
  -0.241716, -0.240201, -0.238632, -0.237008, -0.235329, -0.233596,
  -0.231809, -0.229968, -0.228072, -0.226123, -0.22412, -0.222063,
  -0.219953, -0.217789, -0.215573, -0.213303, -0.210981, -0.208607,
  -0.20618, -0.203702, -0.201171, -0.19859, -0.195957, -0.193274,
  -0.19054, -0.187756, -0.184923, -0.18204, -0.179108, -0.176128,
  -0.173099, -0.170023, -0.166899, -0.163729, -0.160512, -0.157249,
  -0.153941, -0.150588, -0.147191, -0.14375, -0.140265, -0.136738,
  -0.133169, -0.129558, -0.125906, -0.122214, -0.118483, -0.114712,
  -0.110903, -0.107056, -0.103172, -0.0992524, -0.095297, -0.0913067,
  -0.0872825, -0.083225, -0.079135, -0.0750134, -0.0708609,
  -0.0666784, -0.0624667, -0.0582268, -0.0539594, -0.0496654,
  -0.0453458, -0.0410015, -0.0366334, -0.0322424, -0.0278296,
  -0.0233958, -0.0189422, -0.0144696, -0.00997914, -0.00547183,
  -0.000948713, 0.00358915, 0.00814069, 0.0127048, 0.0172804,
  0.0218663, 0.0264615, 0.0310648, 0.035675, 0.0402909, 0.0449115,
  0.0495354, 0.0541614, 0.0587884, 0.0634151, 0.0680403, 0.0726627,
  0.077281, 0.0818939, 0.0865002, 0.0910985, 0.0956876, 0.100266,
  0.104832, 0.109386, 0.113924, 0.118447, 0.122952, 0.127438,
  0.131904, 0.136348, 0.140769, 0.145166, 0.149537, 0.15388, 0.158195,
  0.162479, 0.166731, 0.17095, 0.175135, 0.179283, 0.183393, 0.187464,
  0.191494, 0.195482, 0.199426, 0.203325, 0.207176, 0.21098, 0.214733,
  0.218435, 0.222083, 0.225677, 0.229215, 0.232695, 0.236116,
  0.239475, 0.242773, 0.246006, 0.249174, 0.252274, 0.255306,
  0.258268, 0.261158, 0.263974, 0.266716, 0.269381, 0.271968,
  0.274476, 0.276902, 0.279246, 0.281506, 0.283681, 0.285768,
  0.287767, 0.289675, 0.291492, 0.293216, 0.294846, 0.29638, 0.297816,
  0.299154, 0.300391, 0.301527, 0.30256, 0.303489, 0.304312, 0.305029,
  0.305637, 0.306136, 0.306524, 0.3068, 0.306963, 0.307011, 0.306944,
  0.306761, 0.306459, 0.306039, 0.305498, 0.304837, 0.304053,
  0.303147, 0.302117, 0.300961, 0.299681, 0.298273, 0.296738,
  0.295075, 0.293283, 0.291362, 0.28931, 0.287127, 0.284813, 0.282367,
  0.279788, 0.277077, 0.274232, 0.271254, 0.268141, 0.264895,
  0.261514, 0.257998, 0.254348, 0.250563, 0.246644, 0.24259, 0.238401,
  0.234079, 0.229622, 0.225032, 0.220309, 0.215453, 0.210465,
  0.205346, 0.200095, 0.194714, 0.189205, 0.183566, 0.177801,
  0.171908, 0.165891, 0.15975, 0.153486, 0.147101, 0.140596, 0.133973,
  0.127234, 0.12038, 0.113413, 0.106335, 0.0991489, 0.0918557,
  0.0844583, 0.0769589, 0.06936, 0.0616643, 0.0538745, 0.0459933,
  0.0380238, 0.029969, 0.0218321, 0.0136165, 0.00532541, -0.00303742,
  -0.0114683, -0.0199635, -0.028519, -0.0371307, -0.0457944,
  -0.0545056, -0.0632599, -0.0720525, -0.0808787, -0.0897334,
  -0.0986116, -0.107508, -0.116417, -0.125333, -0.13425, -0.143163,
  -0.152065, -0.16095, -0.169811, -0.178643, -0.187437, -0.196187,
  -0.204886, -0.213526, -0.2221, -0.2306, -0.239018, -0.247346,
  -0.255575, -0.263697, -0.271703, -0.279583, -0.28733, -0.294932,
  -0.302381, -0.309666, -0.316778, -0.323705, -0.330438, -0.336965,
  -0.343275, -0.349357, -0.355199, -0.360789, -0.366116, -0.371165,
  -0.375926, -0.380384, -0.384527, -0.388341, -0.391812, -0.394926,
  -0.397669, -0.400025, -0.401981, -0.403519, -0.404626, -0.405284,
  -0.405478, -0.405191, -0.404406, -0.403106, -0.401273, -0.398889,
  -0.395936, -0.392395, -0.388247, -0.383474, -0.378054, -0.371968,
  -0.365195, -0.357715, -0.349507, -0.340548, -0.330817, -0.32029,
  -0.308946, -0.296761, -0.283712, -0.269773, -0.254922, -0.239131,
  -0.222378, -0.204634, -0.185875, -0.166073, -0.1452, -0.123231,
  -0.100135, -0.075885, -0.0504513, -0.0238043, 0.00408619, 0.0332507,
  0.0637205, 0.0955272, 0.128703, 0.163281, 0.199293, 0.236775,
  0.27576, 0.316283, 0.35838, 0.402086, 0.447439, 0.494475, 0.543233,
  0.59375, 0.646067, 0.700221, 0.756254, 0.814207, 0.874121, 0.936037,
  1}; G4double G4NeutronHPFastLegendre::i13[2801] = {0, -0.000691315,
  -0.00133768, -0.00194053, -0.00250129, -0.00302134, -0.00350204,
  -0.00394472, -0.00435068, -0.00472118, -0.00505748, -0.00536078,
  -0.00563227, -0.00587313, -0.00608447, -0.00626743, -0.00642308,
  -0.00655248, -0.00665667, -0.00673667, -0.00679346, -0.00682801,
  -0.00684127, -0.00683415, -0.00680755, -0.00676236, -0.00669942,
  -0.00661958, -0.00652364, -0.00641241, -0.00628665, -0.00614711,
  -0.00599455, -0.00582966, -0.00565316, -0.00546571, -0.00526798,
  -0.00506062, -0.00484424, -0.00461946, -0.00438687, -0.00414705,
  -0.00390056, -0.00364793, -0.00338971, -0.00312639, -0.00285849,
  -0.00258647, -0.00231082, -0.00203198, -0.00175039, -0.00146649,
  -0.00118069, -0.000893375, -0.000604945, -0.000315772, -2.6217e-05,
  0.00026337, 0.000552652, 0.000841302, 0.00112901, 0.00141546,
  0.00170038, 0.00198347, 0.00226447, 0.00254312, 0.00281916,
  0.00309237, 0.00336249, 0.00362933, 0.00389266, 0.00415229,
  0.00440801, 0.00465966, 0.00490704, 0.00515, 0.00538837, 0.005622,
  0.00585076, 0.0060745, 0.0062931, 0.00650643, 0.00671439,
  0.00691687, 0.00711377, 0.00730499, 0.00749045, 0.00767007,
  0.00784378, 0.0080115, 0.00817319, 0.00832877, 0.00847821,
  0.00862145, 0.00875846, 0.00888921, 0.00901366, 0.00913179,
  0.00924358, 0.00934902, 0.0094481, 0.00954081, 0.00962715,
  0.00970712, 0.00978073, 0.009848, 0.00990893, 0.00996354, 0.0100119,
  0.0100539, 0.0100897, 0.0101194, 0.0101428, 0.0101601, 0.0101713,
  0.0101765, 0.0101757, 0.0101689, 0.0101563, 0.0101377, 0.0101135,
  0.0100834, 0.0100478, 0.0100065, 0.00995971, 0.00990744, 0.00984979,
  0.00978681, 0.00971859, 0.0096452, 0.00956671, 0.0094832,
  0.00939476, 0.00930147, 0.0092034, 0.00910064, 0.00899328,
  0.00888141, 0.0087651, 0.00864445, 0.00851954, 0.00839048,
  0.00825734, 0.00812021, 0.0079792, 0.00783439, 0.00768588,
  0.00753376, 0.00737812, 0.00721906, 0.00705668, 0.00689106,
  0.00672231, 0.00655052, 0.00637579, 0.0061982, 0.00601787,
  0.00583488, 0.00564933, 0.00546132, 0.00527094, 0.00507829,
  0.00488347, 0.00468657, 0.00448768, 0.0042869, 0.00408433,
  0.00388005, 0.00367418, 0.00346679, 0.00325798, 0.00304784,
  0.00283647, 0.00262396, 0.0024104, 0.00219587, 0.00198048,
  0.00176431, 0.00154744, 0.00132997, 0.00111199, 0.000893576,
  0.00067482, 0.000455805, 0.000236618, 1.73409e-05, -0.000201943,
  -0.000421151, -0.000640202, -0.000859016, -0.00107751, -0.00129561,
  -0.00151324, -0.00173032, -0.00194677, -0.00216253, -0.0023775,
  -0.00259163, -0.00280484, -0.00301706, -0.00322822, -0.00343825,
  -0.00364708, -0.00385464, -0.00406088, -0.00426572, -0.0044691,
  -0.00467095, -0.00487123, -0.00506986, -0.00526678, -0.00546195,
  -0.00565529, -0.00584676, -0.0060363, -0.00622385, -0.00640936,
  -0.00659278, -0.00677407, -0.00695316, -0.00713001, -0.00730458,
  -0.00747682, -0.00764668, -0.00781411, -0.00797908, -0.00814155,
  -0.00830147, -0.0084588, -0.0086135, -0.00876555, -0.00891489,
  -0.0090615, -0.00920534, -0.00934638, -0.00948459, -0.00961994,
  -0.00975239, -0.00988192, -0.0100085, -0.0101321, -0.0102527,
  -0.0103703, -0.0104848, -0.0105963, -0.0107046, -0.0108099,
  -0.010912, -0.011011, -0.0111068, -0.0111994, -0.0112888, -0.011375,
  -0.011458, -0.0115378, -0.0116143, -0.0116875, -0.0117575,
  -0.0118242, -0.0118877, -0.0119478, -0.0120047, -0.0120582,
  -0.0121085, -0.0121554, -0.0121991, -0.0122394, -0.0122764,
  -0.0123102, -0.0123406, -0.0123677, -0.0123916, -0.0124121,
  -0.0124294, -0.0124433, -0.012454, -0.0124615, -0.0124657,
  -0.0124666, -0.0124643, -0.0124588, -0.0124501, -0.0124381,
  -0.012423, -0.0124047, -0.0123833, -0.0123587, -0.0123309,
  -0.0123001, -0.0122662, -0.0122292, -0.0121891, -0.012146,
  -0.0120999, -0.0120507, -0.0119986, -0.0119436, -0.0118856,
  -0.0118247, -0.0117609, -0.0116943, -0.0116248, -0.0115525,
  -0.0114774, -0.0113996, -0.011319, -0.0112357, -0.0111497,
  -0.0110611, -0.0109699, -0.010876, -0.0107796, -0.0106807,
  -0.0105793, -0.0104754, -0.010369, -0.0102602, -0.0101491,
  -0.0100356, -0.00991981, -0.00980172, -0.00968139, -0.00955885,
  -0.00943412, -0.00930725, -0.00917826, -0.0090472, -0.0089141,
  -0.00877899, -0.00864191, -0.00850289, -0.00836198, -0.00821921,
  -0.00807461, -0.00792822, -0.00778008, -0.00763022, -0.00747869,
  -0.00732551, -0.00717074, -0.0070144, -0.00685653, -0.00669718,
  -0.00653637, -0.00637416, -0.00621057, -0.00604564, -0.00587942,
  -0.00571195, -0.00554325, -0.00537338, -0.00520236, -0.00503025,
  -0.00485707, -0.00468286, -0.00450768, -0.00433155, -0.00415451,
  -0.0039766, -0.00379787, -0.00361835, -0.00343808, -0.00325709,
  -0.00307544, -0.00289315, -0.00271027, -0.00252684, -0.00234289,
  -0.00215846, -0.00197359, -0.00178832, -0.00160269, -0.00141674,
  -0.0012305, -0.00104401, -0.000857312, -0.000670443, -0.000483441,
  -0.000296342, -0.000109184, 7.7995e-05, 0.000265159, 0.000452271,
  0.000639293, 0.00082619, 0.00101292, 0.00119946, 0.00138576,
  0.0015718, 0.00175752, 0.00194291, 0.00212792, 0.00231252,
  0.00249667, 0.00268034, 0.0028635, 0.00304611, 0.00322814,
  0.00340955, 0.00359031, 0.00377039, 0.00394975, 0.00412837,
  0.00430621, 0.00448324, 0.00465942, 0.00483473, 0.00500914,
  0.00518261, 0.00535511, 0.00552661, 0.00569709, 0.00586652,
  0.00603486, 0.00620208, 0.00636816, 0.00653307, 0.00669678,
  0.00685927, 0.0070205, 0.00718045, 0.0073391, 0.00749641,
  0.00765236, 0.00780692, 0.00796008, 0.0081118, 0.00826206,
  0.00841083, 0.0085581, 0.00870384, 0.00884802, 0.00899063,
  0.00913163, 0.00927102, 0.00940876, 0.00954483, 0.00967923,
  0.00981191, 0.00994287, 0.0100721, 0.0101995, 0.0103252, 0.0104491,
  0.0105711, 0.0106913, 0.0108096, 0.0109261, 0.0110407, 0.0111534,
  0.0112641, 0.0113729, 0.0114798, 0.0115847, 0.0116876, 0.0117885,
  0.0118874, 0.0119843, 0.0120791, 0.0121719, 0.0122626, 0.0123513,
  0.0124378, 0.0125223, 0.0126047, 0.0126849, 0.012763, 0.012839,
  0.0129129, 0.0129846, 0.0130541, 0.0131214, 0.0131866, 0.0132496,
  0.0133104, 0.013369, 0.0134255, 0.0134796, 0.0135316, 0.0135814,
  0.0136289, 0.0136743, 0.0137173, 0.0137582, 0.0137968, 0.0138332,
  0.0138673, 0.0138992, 0.0139288, 0.0139562, 0.0139814, 0.0140043,
  0.0140249, 0.0140433, 0.0140595, 0.0140734, 0.014085, 0.0140944,
  0.0141016, 0.0141066, 0.0141093, 0.0141097, 0.014108, 0.014104,
  0.0140978, 0.0140894, 0.0140787, 0.0140659, 0.0140508, 0.0140336,
  0.0140142, 0.0139926, 0.0139688, 0.0139428, 0.0139147, 0.0138844,
  0.013852, 0.0138174, 0.0137807, 0.0137419, 0.0137009, 0.0136579,
  0.0136128, 0.0135656, 0.0135163, 0.0134649, 0.0134115, 0.0133561,
  0.0132986, 0.0132391, 0.0131776, 0.0131142, 0.0130487, 0.0129813,
  0.0129119, 0.0128405, 0.0127673, 0.0126921, 0.012615, 0.012536,
  0.0124552, 0.0123725, 0.012288, 0.0122016, 0.0121134, 0.0120235,
  0.0119317, 0.0118382, 0.0117429, 0.0116459, 0.0115472, 0.0114468,
  0.0113447, 0.011241, 0.0111356, 0.0110285, 0.0109199, 0.0108097,
  0.0106979, 0.0105845, 0.0104696, 0.0103532, 0.0102353, 0.0101159,
  0.00999499, 0.00987268, 0.00974895, 0.00962382, 0.0094973,
  0.00936943, 0.0092402, 0.00910966, 0.00897781, 0.00884468,
  0.00871029, 0.00857465, 0.0084378, 0.00829975, 0.00816052,
  0.00802014, 0.00787862, 0.00773598, 0.00759226, 0.00744746,
  0.00730161, 0.00715474, 0.00700687, 0.00685801, 0.00670819,
  0.00655743, 0.00640575, 0.00625318, 0.00609974, 0.00594545,
  0.00579033, 0.00563441, 0.00547771, 0.00532025, 0.00516205,
  0.00500314, 0.00484353, 0.00468326, 0.00452235, 0.00436081,
  0.00419867, 0.00403596, 0.0038727, 0.0037089, 0.0035446, 0.00337981,
  0.00321456, 0.00304888, 0.00288278, 0.00271629, 0.00254943,
  0.00238222, 0.00221469, 0.00204686, 0.00187876, 0.0017104,
  0.00154181, 0.00137301, 0.00120403, 0.00103488, 0.000865602,
  0.000696203, 0.000526712, 0.00035715, 0.00018754, 1.79052e-05,
  -0.000151732, -0.000321349, -0.000490923, -0.000660432,
  -0.000829853, -0.000999164, -0.00116834, -0.00133737, -0.00150622,
  -0.00167486, -0.00184329, -0.00201148, -0.0021794, -0.00234703,
  -0.00251436, -0.00268136, -0.002848, -0.00301428, -0.00318016,
  -0.00334562, -0.00351065, -0.00367522, -0.00383932, -0.00400291,
  -0.00416598, -0.00432852, -0.00449049, -0.00465189, -0.00481268,
  -0.00497285, -0.00513237, -0.00529124, -0.00544943, -0.00560691,
  -0.00576368, -0.0059197, -0.00607497, -0.00622946, -0.00638315,
  -0.00653602, -0.00668807, -0.00683925, -0.00698957, -0.007139,
  -0.00728752, -0.00743511, -0.00758176, -0.00772745, -0.00787216,
  -0.00801588, -0.00815858, -0.00830026, -0.00844088, -0.00858044,
  -0.00871892, -0.00885631, -0.00899258, -0.00912773, -0.00926173,
  -0.00939457, -0.00952623, -0.00965671, -0.00978597, -0.00991402,
  -0.0100408, -0.0101664, -0.0102907, -0.0104137, -0.0105354,
  -0.0106558, -0.0107749, -0.0108927, -0.0110091, -0.0111242,
  -0.0112379, -0.0113502, -0.011461, -0.0115705, -0.0116786,
  -0.0117852, -0.0118904, -0.0119941, -0.0120964, -0.0121971,
  -0.0122964, -0.0123942, -0.0124905, -0.0125852, -0.0126784,
  -0.0127701, -0.0128602, -0.0129487, -0.0130357, -0.0131211,
  -0.0132049, -0.0132871, -0.0133677, -0.0134467, -0.0135241,
  -0.0135998, -0.0136739, -0.0137463, -0.0138171, -0.0138862,
  -0.0139537, -0.0140194, -0.0140835, -0.014146, -0.0142067,
  -0.0142657, -0.014323, -0.0143786, -0.0144325, -0.0144847,
  -0.0145351, -0.0145838, -0.0146308, -0.0146761, -0.0147196,
  -0.0147613, -0.0148013, -0.0148396, -0.0148761, -0.0149108,
  -0.0149438, -0.014975, -0.0150045, -0.0150322, -0.0150581,
  -0.0150823, -0.0151046, -0.0151252, -0.0151441, -0.0151611,
  -0.0151764, -0.0151899, -0.0152016, -0.0152116, -0.0152197,
  -0.0152262, -0.0152308, -0.0152336, -0.0152347, -0.015234,
  -0.0152316, -0.0152273, -0.0152213, -0.0152136, -0.0152041,
  -0.0151928, -0.0151798, -0.015165, -0.0151484, -0.0151301,
  -0.0151101, -0.0150883, -0.0150648, -0.0150396, -0.0150126,
  -0.014984, -0.0149535, -0.0149214, -0.0148876, -0.0148521,
  -0.0148148, -0.0147759, -0.0147353, -0.014693, -0.014649,
  -0.0146034, -0.0145561, -0.0145071, -0.0144565, -0.0144043,
  -0.0143504, -0.0142949, -0.0142378, -0.014179, -0.0141187,
  -0.0140568, -0.0139932, -0.0139281, -0.0138614, -0.0137932,
  -0.0137234, -0.013652, -0.0135792, -0.0135048, -0.0134288,
  -0.0133514, -0.0132725, -0.0131921, -0.0131102, -0.0130268,
  -0.012942, -0.0128557, -0.012768, -0.0126789, -0.0125884,
  -0.0124964, -0.0124031, -0.0123084, -0.0122123, -0.0121149,
  -0.0120161, -0.0119159, -0.0118145, -0.0117117, -0.0116077,
  -0.0115024, -0.0113958, -0.0112879, -0.0111788, -0.0110684,
  -0.0109569, -0.0108441, -0.0107301, -0.010615, -0.0104986,
  -0.0103812, -0.0102625, -0.0101428, -0.0100219, -0.00989999,
  -0.00977695, -0.00965284, -0.00952767, -0.00940146, -0.00927422,
  -0.00914597, -0.00901673, -0.00888649, -0.00875529, -0.00862314,
  -0.00849005, -0.00835603, -0.0082211, -0.00808529, -0.00794859,
  -0.00781103, -0.00767262, -0.00753338, -0.00739333, -0.00725248,
  -0.00711084, -0.00696843, -0.00682527, -0.00668137, -0.00653675,
  -0.00639142, -0.00624541, -0.00609873, -0.00595138, -0.0058034,
  -0.00565479, -0.00550558, -0.00535577, -0.00520539, -0.00505445,
  -0.00490297, -0.00475097, -0.00459845, -0.00444545, -0.00429196,
  -0.00413802, -0.00398364, -0.00382883, -0.00367362, -0.00351801,
  -0.00336203, -0.00320568, -0.003049, -0.002892, -0.00273468,
  -0.00257708, -0.0024192, -0.00226106, -0.00210269, -0.00194409,
  -0.00178529, -0.00162629, -0.00146713, -0.00130781, -0.00114835,
  -0.000988771, -0.000829087, -0.000669316, -0.000509473,
  -0.000349578, -0.000189645, -2.96921e-05, 0.000130264, 0.000290206,
  0.000450117, 0.000609982, 0.000769782, 0.000929502, 0.00108912,
  0.00124863, 0.00140801, 0.00156724, 0.0017263, 0.00188519,
  0.00204388, 0.00220235, 0.0023606, 0.0025186, 0.00267633,
  0.00283379, 0.00299095, 0.0031478, 0.00330432, 0.0034605,
  0.00361632, 0.00377176, 0.00392681, 0.00408145, 0.00423567,
  0.00438945, 0.00454278, 0.00469563, 0.004848, 0.00499987,
  0.00515122, 0.00530204, 0.00545231, 0.00560201, 0.00575114,
  0.00589967, 0.0060476, 0.0061949, 0.00634156, 0.00648758,
  0.00663292, 0.00677758, 0.00692154, 0.0070648, 0.00720732,
  0.00734911, 0.00749014, 0.00763041, 0.00776989, 0.00790857,
  0.00804645, 0.0081835, 0.00831971, 0.00845508, 0.00858958,
  0.0087232, 0.00885593, 0.00898775, 0.00911866, 0.00924864,
  0.00937768, 0.00950576, 0.00963287, 0.009759, 0.00988414, 0.0100083,
  0.0101314, 0.0102535, 0.0103745, 0.0104945, 0.0106134, 0.0107313,
  0.0108481, 0.0109637, 0.0110783, 0.0111917, 0.011304, 0.0114152,
  0.0115252, 0.011634, 0.0117417, 0.0118481, 0.0119534, 0.0120575,
  0.0121603, 0.012262, 0.0123624, 0.0124615, 0.0125594, 0.0126561,
  0.0127514, 0.0128455, 0.0129383, 0.0130298, 0.01312, 0.0132088,
  0.0132964, 0.0133826, 0.0134674, 0.0135509, 0.0136331, 0.0137139,
  0.0137933, 0.0138713, 0.013948, 0.0140232, 0.0140971, 0.0141696,
  0.0142406, 0.0143102, 0.0143784, 0.0144451, 0.0145105, 0.0145743,
  0.0146367, 0.0146977, 0.0147572, 0.0148152, 0.0148718, 0.0149268,
  0.0149804, 0.0150325, 0.0150832, 0.0151323, 0.0151799, 0.015226,
  0.0152706, 0.0153137, 0.0153553, 0.0153953, 0.0154338, 0.0154708,
  0.0155063, 0.0155403, 0.0155727, 0.0156035, 0.0156328, 0.0156606,
  0.0156869, 0.0157115, 0.0157347, 0.0157563, 0.0157763, 0.0157948,
  0.0158117, 0.0158271, 0.0158409, 0.0158531, 0.0158638, 0.015873,
  0.0158806, 0.0158866, 0.015891, 0.0158939, 0.0158953, 0.015895,
  0.0158933, 0.0158899, 0.015885, 0.0158786, 0.0158706, 0.015861,
  0.0158499, 0.0158373, 0.015823, 0.0158073, 0.01579, 0.0157711,
  0.0157508, 0.0157288, 0.0157054, 0.0156804, 0.0156539, 0.0156259,
  0.0155963, 0.0155652, 0.0155326, 0.0154985, 0.0154629, 0.0154258,
  0.0153871, 0.015347, 0.0153054, 0.0152623, 0.0152177, 0.0151717,
  0.0151241, 0.0150751, 0.0150247, 0.0149727, 0.0149194, 0.0148646,
  0.0148083, 0.0147506, 0.0146915, 0.0146309, 0.014569, 0.0145056,
  0.0144408, 0.0143747, 0.0143071, 0.0142382, 0.0141679, 0.0140962,
  0.0140231, 0.0139487, 0.013873, 0.0137959, 0.0137175, 0.0136378,
  0.0135567, 0.0134743, 0.0133907, 0.0133057, 0.0132195, 0.013132,
  0.0130433, 0.0129532, 0.012862, 0.0127695, 0.0126758, 0.0125808,
  0.0124847, 0.0123873, 0.0122888, 0.012189, 0.0120882, 0.0119861,
  0.0118829, 0.0117786, 0.0116731, 0.0115665, 0.0114588, 0.01135,
  0.0112401, 0.0111292, 0.0110172, 0.0109041, 0.01079, 0.0106748,
  0.0105586, 0.0104415, 0.0103233, 0.0102041, 0.010084, 0.00996287,
  0.00984082, 0.00971782, 0.0095939, 0.00946906, 0.00934332,
  0.00921669, 0.00908918, 0.00896081, 0.00883158, 0.00870151,
  0.00857061, 0.00843889, 0.00830637, 0.00817306, 0.00803897,
  0.00790412, 0.00776852, 0.00763217, 0.0074951, 0.00735732,
  0.00721884, 0.00707967, 0.00693984, 0.00679934, 0.00665819,
  0.00651642, 0.00637402, 0.00623102, 0.00608743, 0.00594327,
  0.00579854, 0.00565325, 0.00550744, 0.0053611, 0.00521425,
  0.00506691, 0.00491909, 0.0047708, 0.00462207, 0.00447289,
  0.00432329, 0.00417328, 0.00402288, 0.0038721, 0.00372095,
  0.00356945, 0.00341761, 0.00326545, 0.00311298, 0.00296021,
  0.00280717, 0.00265386, 0.0025003, 0.00234651, 0.00219249,
  0.00203827, 0.00188385, 0.00172926, 0.0015745, 0.0014196,
  0.00126456, 0.0011094, 0.000954136, 0.000798783, 0.000643355,
  0.000487867, 0.000332333, 0.000176767, 2.11847e-05, -0.0001344,
  -0.000289971, -0.000445516, -0.000601018, -0.000756464,
  -0.000911838, -0.00106713, -0.00122232, -0.00137739, -0.00153233,
  -0.00168713, -0.00184178, -0.00199624, -0.00215053, -0.0023046,
  -0.00245847, -0.0026121, -0.00276549, -0.00291861, -0.00307147,
  -0.00322403, -0.00337629, -0.00352824, -0.00367985, -0.00383112,
  -0.00398203, -0.00413257, -0.00428272, -0.00443247, -0.0045818,
  -0.0047307, -0.00487916, -0.00502717, -0.0051747, -0.00532175,
  -0.0054683, -0.00561433, -0.00575984, -0.00590482, -0.00604924,
  -0.00619309, -0.00633636, -0.00647905, -0.00662112, -0.00676258,
  -0.0069034, -0.00704358, -0.0071831, -0.00732195, -0.00746011,
  -0.00759758, -0.00773433, -0.00787037, -0.00800566, -0.00814022,
  -0.00827401, -0.00840702, -0.00853925, -0.00867069, -0.00880131,
  -0.00893112, -0.00906009, -0.00918821, -0.00931548, -0.00944187,
  -0.00956739, -0.00969201, -0.00981573, -0.00993853, -0.0100604,
  -0.0101813, -0.0103013, -0.0104204, -0.0105384, -0.0106555,
  -0.0107716, -0.0108866, -0.0110007, -0.0111137, -0.0112257,
  -0.0113367, -0.0114466, -0.0115554, -0.0116632, -0.0117699,
  -0.0118754, -0.0119799, -0.0120832, -0.0121855, -0.0122866,
  -0.0123865, -0.0124853, -0.0125829, -0.0126794, -0.0127747,
  -0.0128688, -0.0129616, -0.0130533, -0.0131438, -0.0132331,
  -0.0133211, -0.0134078, -0.0134934, -0.0135777, -0.0136607,
  -0.0137424, -0.0138229, -0.013902, -0.0139799, -0.0140565,
  -0.0141318, -0.0142058, -0.0142784, -0.0143497, -0.0144197,
  -0.0144883, -0.0145556, -0.0146216, -0.0146861, -0.0147494,
  -0.0148112, -0.0148717, -0.0149308, -0.0149885, -0.0150448,
  -0.0150997, -0.0151532, -0.0152053, -0.015256, -0.0153052,
  -0.0153531, -0.0153995, -0.0154445, -0.015488, -0.0155302,
  -0.0155708, -0.01561, -0.0156478, -0.0156841, -0.015719, -0.0157524,
  -0.0157844, -0.0158148, -0.0158438, -0.0158714, -0.0158974,
  -0.015922, -0.0159451, -0.0159668, -0.0159869, -0.0160056,
  -0.0160227, -0.0160384, -0.0160526, -0.0160653, -0.0160765,
  -0.0160862, -0.0160945, -0.0161012, -0.0161064, -0.0161102,
  -0.0161124, -0.0161132, -0.0161124, -0.0161102, -0.0161064,
  -0.0161012, -0.0160945, -0.0160862, -0.0160765, -0.0160653,
  -0.0160526, -0.0160384, -0.0160227, -0.0160056, -0.0159869,
  -0.0159668, -0.0159451, -0.015922, -0.0158974, -0.0158714,
  -0.0158438, -0.0158148, -0.0157844, -0.0157524, -0.015719,
  -0.0156841, -0.0156478, -0.01561, -0.0155708, -0.0155302, -0.015488,
  -0.0154445, -0.0153995, -0.0153531, -0.0153052, -0.015256,
  -0.0152053, -0.0151532, -0.0150997, -0.0150448, -0.0149885,
  -0.0149308, -0.0148717, -0.0148112, -0.0147494, -0.0146861,
  -0.0146216, -0.0145556, -0.0144883, -0.0144197, -0.0143497,
  -0.0142784, -0.0142058, -0.0141318, -0.0140565, -0.0139799,
  -0.013902, -0.0138229, -0.0137424, -0.0136607, -0.0135777,
  -0.0134934, -0.0134078, -0.0133211, -0.0132331, -0.0131438,
  -0.0130533, -0.0129616, -0.0128688, -0.0127747, -0.0126794,
  -0.0125829, -0.0124853, -0.0123865, -0.0122866, -0.0121855,
  -0.0120832, -0.0119799, -0.0118754, -0.0117699, -0.0116632,
  -0.0115554, -0.0114466, -0.0113367, -0.0112257, -0.0111137,
  -0.0110007, -0.0108866, -0.0107716, -0.0106555, -0.0105384,
  -0.0104204, -0.0103013, -0.0101813, -0.0100604, -0.00993853,
  -0.00981573, -0.00969201, -0.00956739, -0.00944187, -0.00931548,
  -0.00918821, -0.00906009, -0.00893112, -0.00880131, -0.00867069,
  -0.00853925, -0.00840702, -0.00827401, -0.00814022, -0.00800566,
  -0.00787037, -0.00773433, -0.00759758, -0.00746011, -0.00732195,
  -0.0071831, -0.00704358, -0.0069034, -0.00676258, -0.00662112,
  -0.00647905, -0.00633636, -0.00619309, -0.00604924, -0.00590482,
  -0.00575984, -0.00561433, -0.0054683, -0.00532175, -0.0051747,
  -0.00502717, -0.00487916, -0.0047307, -0.0045818, -0.00443247,
  -0.00428272, -0.00413257, -0.00398203, -0.00383112, -0.00367985,
  -0.00352824, -0.00337629, -0.00322403, -0.00307147, -0.00291861,
  -0.00276549, -0.0026121, -0.00245847, -0.0023046, -0.00215053,
  -0.00199624, -0.00184178, -0.00168713, -0.00153233, -0.00137739,
  -0.00122232, -0.00106713, -0.000911838, -0.000756464, -0.000601018,
  -0.000445516, -0.000289971, -0.0001344, 2.11847e-05, 0.000176767,
  0.000332333, 0.000487867, 0.000643355, 0.000798783, 0.000954136,
  0.0011094, 0.00126456, 0.0014196, 0.0015745, 0.00172926, 0.00188385,
  0.00203827, 0.00219249, 0.00234651, 0.0025003, 0.00265386,
  0.00280717, 0.00296021, 0.00311298, 0.00326545, 0.00341761,
  0.00356945, 0.00372095, 0.0038721, 0.00402288, 0.00417328,
  0.00432329, 0.00447289, 0.00462207, 0.0047708, 0.00491909,
  0.00506691, 0.00521425, 0.0053611, 0.00550744, 0.00565325,
  0.00579854, 0.00594327, 0.00608743, 0.00623102, 0.00637402,
  0.00651642, 0.00665819, 0.00679934, 0.00693984, 0.00707967,
  0.00721884, 0.00735732, 0.0074951, 0.00763217, 0.00776852,
  0.00790412, 0.00803897, 0.00817306, 0.00830637, 0.00843889,
  0.00857061, 0.00870151, 0.00883158, 0.00896081, 0.00908918,
  0.00921669, 0.00934332, 0.00946906, 0.0095939, 0.00971782,
  0.00984082, 0.00996287, 0.010084, 0.0102041, 0.0103233, 0.0104415,
  0.0105586, 0.0106748, 0.01079, 0.0109041, 0.0110172, 0.0111292,
  0.0112401, 0.01135, 0.0114588, 0.0115665, 0.0116731, 0.0117786,
  0.0118829, 0.0119861, 0.0120882, 0.012189, 0.0122888, 0.0123873,
  0.0124847, 0.0125808, 0.0126758, 0.0127695, 0.012862, 0.0129532,
  0.0130433, 0.013132, 0.0132195, 0.0133057, 0.0133907, 0.0134743,
  0.0135567, 0.0136378, 0.0137175, 0.0137959, 0.013873, 0.0139487,
  0.0140231, 0.0140962, 0.0141679, 0.0142382, 0.0143071, 0.0143747,
  0.0144408, 0.0145056, 0.014569, 0.0146309, 0.0146915, 0.0147506,
  0.0148083, 0.0148646, 0.0149194, 0.0149727, 0.0150247, 0.0150751,
  0.0151241, 0.0151717, 0.0152177, 0.0152623, 0.0153054, 0.015347,
  0.0153871, 0.0154258, 0.0154629, 0.0154985, 0.0155326, 0.0155652,
  0.0155963, 0.0156259, 0.0156539, 0.0156804, 0.0157054, 0.0157288,
  0.0157508, 0.0157711, 0.01579, 0.0158073, 0.015823, 0.0158373,
  0.0158499, 0.015861, 0.0158706, 0.0158786, 0.015885, 0.0158899,
  0.0158933, 0.015895, 0.0158953, 0.0158939, 0.015891, 0.0158866,
  0.0158806, 0.015873, 0.0158638, 0.0158531, 0.0158409, 0.0158271,
  0.0158117, 0.0157948, 0.0157763, 0.0157563, 0.0157347, 0.0157115,
  0.0156869, 0.0156606, 0.0156328, 0.0156035, 0.0155727, 0.0155403,
  0.0155063, 0.0154708, 0.0154338, 0.0153953, 0.0153553, 0.0153137,
  0.0152706, 0.015226, 0.0151799, 0.0151323, 0.0150832, 0.0150325,
  0.0149804, 0.0149268, 0.0148718, 0.0148152, 0.0147572, 0.0146977,
  0.0146367, 0.0145743, 0.0145105, 0.0144451, 0.0143784, 0.0143102,
  0.0142406, 0.0141696, 0.0140971, 0.0140232, 0.013948, 0.0138713,
  0.0137933, 0.0137139, 0.0136331, 0.0135509, 0.0134674, 0.0133826,
  0.0132964, 0.0132088, 0.01312, 0.0130298, 0.0129383, 0.0128455,
  0.0127514, 0.0126561, 0.0125594, 0.0124615, 0.0123624, 0.012262,
  0.0121603, 0.0120575, 0.0119534, 0.0118481, 0.0117417, 0.011634,
  0.0115252, 0.0114152, 0.011304, 0.0111917, 0.0110783, 0.0109637,
  0.0108481, 0.0107313, 0.0106134, 0.0104945, 0.0103745, 0.0102535,
  0.0101314, 0.0100083, 0.00988414, 0.009759, 0.00963287, 0.00950576,
  0.00937768, 0.00924864, 0.00911866, 0.00898775, 0.00885593,
  0.0087232, 0.00858958, 0.00845508, 0.00831971, 0.0081835,
  0.00804645, 0.00790857, 0.00776989, 0.00763041, 0.00749014,
  0.00734911, 0.00720732, 0.0070648, 0.00692154, 0.00677758,
  0.00663292, 0.00648758, 0.00634156, 0.0061949, 0.0060476,
  0.00589967, 0.00575114, 0.00560201, 0.00545231, 0.00530204,
  0.00515122, 0.00499987, 0.004848, 0.00469563, 0.00454278,
  0.00438945, 0.00423567, 0.00408145, 0.00392681, 0.00377176,
  0.00361632, 0.0034605, 0.00330432, 0.0031478, 0.00299095,
  0.00283379, 0.00267633, 0.0025186, 0.0023606, 0.00220235,
  0.00204388, 0.00188519, 0.0017263, 0.00156724, 0.00140801,
  0.00124863, 0.00108912, 0.000929502, 0.000769782, 0.000609982,
  0.000450117, 0.000290206, 0.000130264, -2.96921e-05, -0.000189645,
  -0.000349578, -0.000509473, -0.000669316, -0.000829087,
  -0.000988771, -0.00114835, -0.00130781, -0.00146713, -0.00162629,
  -0.00178529, -0.00194409, -0.00210269, -0.00226106, -0.0024192,
  -0.00257708, -0.00273468, -0.002892, -0.003049, -0.00320568,
  -0.00336203, -0.00351801, -0.00367362, -0.00382883, -0.00398364,
  -0.00413802, -0.00429196, -0.00444545, -0.00459845, -0.00475097,
  -0.00490297, -0.00505445, -0.00520539, -0.00535577, -0.00550558,
  -0.00565479, -0.0058034, -0.00595138, -0.00609873, -0.00624541,
  -0.00639142, -0.00653675, -0.00668137, -0.00682527, -0.00696843,
  -0.00711084, -0.00725248, -0.00739333, -0.00753338, -0.00767262,
  -0.00781103, -0.00794859, -0.00808529, -0.0082211, -0.00835603,
  -0.00849005, -0.00862314, -0.00875529, -0.00888649, -0.00901673,
  -0.00914597, -0.00927422, -0.00940146, -0.00952767, -0.00965284,
  -0.00977695, -0.00989999, -0.0100219, -0.0101428, -0.0102625,
  -0.0103812, -0.0104986, -0.010615, -0.0107301, -0.0108441,
  -0.0109569, -0.0110684, -0.0111788, -0.0112879, -0.0113958,
  -0.0115024, -0.0116077, -0.0117117, -0.0118145, -0.0119159,
  -0.0120161, -0.0121149, -0.0122123, -0.0123084, -0.0124031,
  -0.0124964, -0.0125884, -0.0126789, -0.012768, -0.0128557,
  -0.012942, -0.0130268, -0.0131102, -0.0131921, -0.0132725,
  -0.0133514, -0.0134288, -0.0135048, -0.0135792, -0.013652,
  -0.0137234, -0.0137932, -0.0138614, -0.0139281, -0.0139932,
  -0.0140568, -0.0141187, -0.014179, -0.0142378, -0.0142949,
  -0.0143504, -0.0144043, -0.0144565, -0.0145071, -0.0145561,
  -0.0146034, -0.014649, -0.014693, -0.0147353, -0.0147759,
  -0.0148148, -0.0148521, -0.0148876, -0.0149214, -0.0149535,
  -0.014984, -0.0150126, -0.0150396, -0.0150648, -0.0150883,
  -0.0151101, -0.0151301, -0.0151484, -0.015165, -0.0151798,
  -0.0151928, -0.0152041, -0.0152136, -0.0152213, -0.0152273,
  -0.0152316, -0.015234, -0.0152347, -0.0152336, -0.0152308,
  -0.0152262, -0.0152197, -0.0152116, -0.0152016, -0.0151899,
  -0.0151764, -0.0151611, -0.0151441, -0.0151252, -0.0151046,
  -0.0150823, -0.0150581, -0.0150322, -0.0150045, -0.014975,
  -0.0149438, -0.0149108, -0.0148761, -0.0148396, -0.0148013,
  -0.0147613, -0.0147196, -0.0146761, -0.0146308, -0.0145838,
  -0.0145351, -0.0144847, -0.0144325, -0.0143786, -0.014323,
  -0.0142657, -0.0142067, -0.014146, -0.0140835, -0.0140194,
  -0.0139537, -0.0138862, -0.0138171, -0.0137463, -0.0136739,
  -0.0135998, -0.0135241, -0.0134467, -0.0133677, -0.0132871,
  -0.0132049, -0.0131211, -0.0130357, -0.0129487, -0.0128602,
  -0.0127701, -0.0126784, -0.0125852, -0.0124905, -0.0123942,
  -0.0122964, -0.0121971, -0.0120964, -0.0119941, -0.0118904,
  -0.0117852, -0.0116786, -0.0115705, -0.011461, -0.0113502,
  -0.0112379, -0.0111242, -0.0110091, -0.0108927, -0.0107749,
  -0.0106558, -0.0105354, -0.0104137, -0.0102907, -0.0101664,
  -0.0100408, -0.00991402, -0.00978597, -0.00965671, -0.00952623,
  -0.00939457, -0.00926173, -0.00912773, -0.00899258, -0.00885631,
  -0.00871892, -0.00858044, -0.00844088, -0.00830026, -0.00815858,
  -0.00801588, -0.00787216, -0.00772745, -0.00758176, -0.00743511,
  -0.00728752, -0.007139, -0.00698957, -0.00683925, -0.00668807,
  -0.00653602, -0.00638315, -0.00622946, -0.00607497, -0.0059197,
  -0.00576368, -0.00560691, -0.00544943, -0.00529124, -0.00513237,
  -0.00497285, -0.00481268, -0.00465189, -0.00449049, -0.00432852,
  -0.00416598, -0.00400291, -0.00383932, -0.00367522, -0.00351065,
  -0.00334562, -0.00318016, -0.00301428, -0.002848, -0.00268136,
  -0.00251436, -0.00234703, -0.0021794, -0.00201148, -0.00184329,
  -0.00167486, -0.00150622, -0.00133737, -0.00116834, -0.000999164,
  -0.000829853, -0.000660432, -0.000490923, -0.000321349,
  -0.000151732, 1.79052e-05, 0.00018754, 0.00035715, 0.000526712,
  0.000696203, 0.000865602, 0.00103488, 0.00120403, 0.00137301,
  0.00154181, 0.0017104, 0.00187876, 0.00204686, 0.00221469,
  0.00238222, 0.00254943, 0.00271629, 0.00288278, 0.00304888,
  0.00321456, 0.00337981, 0.0035446, 0.0037089, 0.0038727, 0.00403596,
  0.00419867, 0.00436081, 0.00452235, 0.00468326, 0.00484353,
  0.00500314, 0.00516205, 0.00532025, 0.00547771, 0.00563441,
  0.00579033, 0.00594545, 0.00609974, 0.00625318, 0.00640575,
  0.00655743, 0.00670819, 0.00685801, 0.00700687, 0.00715474,
  0.00730161, 0.00744746, 0.00759226, 0.00773598, 0.00787862,
  0.00802014, 0.00816052, 0.00829975, 0.0084378, 0.00857465,
  0.00871029, 0.00884468, 0.00897781, 0.00910966, 0.0092402,
  0.00936943, 0.0094973, 0.00962382, 0.00974895, 0.00987268,
  0.00999499, 0.0101159, 0.0102353, 0.0103532, 0.0104696, 0.0105845,
  0.0106979, 0.0108097, 0.0109199, 0.0110285, 0.0111356, 0.011241,
  0.0113447, 0.0114468, 0.0115472, 0.0116459, 0.0117429, 0.0118382,
  0.0119317, 0.0120235, 0.0121134, 0.0122016, 0.012288, 0.0123725,
  0.0124552, 0.012536, 0.012615, 0.0126921, 0.0127673, 0.0128405,
  0.0129119, 0.0129813, 0.0130487, 0.0131142, 0.0131776, 0.0132391,
  0.0132986, 0.0133561, 0.0134115, 0.0134649, 0.0135163, 0.0135656,
  0.0136128, 0.0136579, 0.0137009, 0.0137419, 0.0137807, 0.0138174,
  0.013852, 0.0138844, 0.0139147, 0.0139428, 0.0139688, 0.0139926,
  0.0140142, 0.0140336, 0.0140508, 0.0140659, 0.0140787, 0.0140894,
  0.0140978, 0.014104, 0.014108, 0.0141097, 0.0141093, 0.0141066,
  0.0141016, 0.0140944, 0.014085, 0.0140734, 0.0140595, 0.0140433,
  0.0140249, 0.0140043, 0.0139814, 0.0139562, 0.0139288, 0.0138992,
  0.0138673, 0.0138332, 0.0137968, 0.0137582, 0.0137173, 0.0136743,
  0.0136289, 0.0135814, 0.0135316, 0.0134796, 0.0134255, 0.013369,
  0.0133104, 0.0132496, 0.0131866, 0.0131214, 0.0130541, 0.0129846,
  0.0129129, 0.012839, 0.012763, 0.0126849, 0.0126047, 0.0125223,
  0.0124378, 0.0123513, 0.0122626, 0.0121719, 0.0120791, 0.0119843,
  0.0118874, 0.0117885, 0.0116876, 0.0115847, 0.0114798, 0.0113729,
  0.0112641, 0.0111534, 0.0110407, 0.0109261, 0.0108096, 0.0106913,
  0.0105711, 0.0104491, 0.0103252, 0.0101995, 0.0100721, 0.00994287,
  0.00981191, 0.00967923, 0.00954483, 0.00940876, 0.00927102,
  0.00913163, 0.00899063, 0.00884802, 0.00870384, 0.0085581,
  0.00841083, 0.00826206, 0.0081118, 0.00796008, 0.00780692,
  0.00765236, 0.00749641, 0.0073391, 0.00718045, 0.0070205,
  0.00685927, 0.00669678, 0.00653307, 0.00636816, 0.00620208,
  0.00603486, 0.00586652, 0.00569709, 0.00552661, 0.00535511,
  0.00518261, 0.00500914, 0.00483473, 0.00465942, 0.00448324,
  0.00430621, 0.00412837, 0.00394975, 0.00377039, 0.00359031,
  0.00340955, 0.00322814, 0.00304611, 0.0028635, 0.00268034,
  0.00249667, 0.00231252, 0.00212792, 0.00194291, 0.00175752,
  0.0015718, 0.00138576, 0.00119946, 0.00101292, 0.00082619,
  0.000639293, 0.000452271, 0.000265159, 7.7995e-05, -0.000109184,
  -0.000296342, -0.000483441, -0.000670443, -0.000857312, -0.00104401,
  -0.0012305, -0.00141674, -0.00160269, -0.00178832, -0.00197359,
  -0.00215846, -0.00234289, -0.00252684, -0.00271027, -0.00289315,
  -0.00307544, -0.00325709, -0.00343808, -0.00361835, -0.00379787,
  -0.0039766, -0.00415451, -0.00433155, -0.00450768, -0.00468286,
  -0.00485707, -0.00503025, -0.00520236, -0.00537338, -0.00554325,
  -0.00571195, -0.00587942, -0.00604564, -0.00621057, -0.00637416,
  -0.00653637, -0.00669718, -0.00685653, -0.0070144, -0.00717074,
  -0.00732551, -0.00747869, -0.00763022, -0.00778008, -0.00792822,
  -0.00807461, -0.00821921, -0.00836198, -0.00850289, -0.00864191,
  -0.00877899, -0.0089141, -0.0090472, -0.00917826, -0.00930725,
  -0.00943412, -0.00955885, -0.00968139, -0.00980172, -0.00991981,
  -0.0100356, -0.0101491, -0.0102602, -0.010369, -0.0104754,
  -0.0105793, -0.0106807, -0.0107796, -0.010876, -0.0109699,
  -0.0110611, -0.0111497, -0.0112357, -0.011319, -0.0113996,
  -0.0114774, -0.0115525, -0.0116248, -0.0116943, -0.0117609,
  -0.0118247, -0.0118856, -0.0119436, -0.0119986, -0.0120507,
  -0.0120999, -0.012146, -0.0121891, -0.0122292, -0.0122662,
  -0.0123001, -0.0123309, -0.0123587, -0.0123833, -0.0124047,
  -0.012423, -0.0124381, -0.0124501, -0.0124588, -0.0124643,
  -0.0124666, -0.0124657, -0.0124615, -0.012454, -0.0124433,
  -0.0124294, -0.0124121, -0.0123916, -0.0123677, -0.0123406,
  -0.0123102, -0.0122764, -0.0122394, -0.0121991, -0.0121554,
  -0.0121085, -0.0120582, -0.0120047, -0.0119478, -0.0118877,
  -0.0118242, -0.0117575, -0.0116875, -0.0116143, -0.0115378,
  -0.011458, -0.011375, -0.0112888, -0.0111994, -0.0111068, -0.011011,
  -0.010912, -0.0108099, -0.0107046, -0.0105963, -0.0104848,
  -0.0103703, -0.0102527, -0.0101321, -0.0100085, -0.00988192,
  -0.00975239, -0.00961994, -0.00948459, -0.00934638, -0.00920534,
  -0.0090615, -0.00891489, -0.00876555, -0.0086135, -0.0084588,
  -0.00830147, -0.00814155, -0.00797908, -0.00781411, -0.00764668,
  -0.00747682, -0.00730458, -0.00713001, -0.00695316, -0.00677407,
  -0.00659278, -0.00640936, -0.00622385, -0.0060363, -0.00584676,
  -0.00565529, -0.00546195, -0.00526678, -0.00506986, -0.00487123,
  -0.00467095, -0.0044691, -0.00426572, -0.00406088, -0.00385464,
  -0.00364708, -0.00343825, -0.00322822, -0.00301706, -0.00280484,
  -0.00259163, -0.0023775, -0.00216253, -0.00194677, -0.00173032,
  -0.00151324, -0.00129561, -0.00107751, -0.000859016, -0.000640202,
  -0.000421151, -0.000201943, 1.73409e-05, 0.000236618, 0.000455805,
  0.00067482, 0.000893576, 0.00111199, 0.00132997, 0.00154744,
  0.00176431, 0.00198048, 0.00219587, 0.0024104, 0.00262396,
  0.00283647, 0.00304784, 0.00325798, 0.00346679, 0.00367418,
  0.00388005, 0.00408433, 0.0042869, 0.00448768, 0.00468657,
  0.00488347, 0.00507829, 0.00527094, 0.00546132, 0.00564933,
  0.00583488, 0.00601787, 0.0061982, 0.00637579, 0.00655052,
  0.00672231, 0.00689106, 0.00705668, 0.00721906, 0.00737812,
  0.00753376, 0.00768588, 0.00783439, 0.0079792, 0.00812021,
  0.00825734, 0.00839048, 0.00851954, 0.00864445, 0.0087651,
  0.00888141, 0.00899328, 0.00910064, 0.0092034, 0.00930147,
  0.00939476, 0.0094832, 0.00956671, 0.0096452, 0.00971859,
  0.00978681, 0.00984979, 0.00990744, 0.00995971, 0.0100065,
  0.0100478, 0.0100834, 0.0101135, 0.0101377, 0.0101563, 0.0101689,
  0.0101757, 0.0101765, 0.0101713, 0.0101601, 0.0101428, 0.0101194,
  0.0100897, 0.0100539, 0.0100119, 0.00996354, 0.00990893, 0.009848,
  0.00978073, 0.00970712, 0.00962715, 0.00954081, 0.0094481,
  0.00934902, 0.00924358, 0.00913179, 0.00901366, 0.00888921,
  0.00875846, 0.00862145, 0.00847821, 0.00832877, 0.00817319,
  0.0080115, 0.00784378, 0.00767007, 0.00749045, 0.00730499,
  0.00711377, 0.00691687, 0.00671439, 0.00650643, 0.0062931,
  0.0060745, 0.00585076, 0.005622, 0.00538837, 0.00515, 0.00490704,
  0.00465966, 0.00440801, 0.00415229, 0.00389266, 0.00362933,
  0.00336249, 0.00309237, 0.00281916, 0.00254312, 0.00226447,
  0.00198347, 0.00170038, 0.00141546, 0.00112901, 0.000841302,
  0.000552652, 0.00026337, -2.6217e-05, -0.000315772, -0.000604945,
  -0.000893375, -0.00118069, -0.00146649, -0.00175039, -0.00203198,
  -0.00231082, -0.00258647, -0.00285849, -0.00312639, -0.00338971,
  -0.00364793, -0.00390056, -0.00414705, -0.00438687, -0.00461946,
  -0.00484424, -0.00506062, -0.00526798, -0.00546571, -0.00565316,
  -0.00582966, -0.00599455, -0.00614711, -0.00628665, -0.00641241,
  -0.00652364, -0.00661958, -0.00669942, -0.00676236, -0.00680755,
  -0.00683415, -0.00684127, -0.00682801, -0.00679346, -0.00673667,
  -0.00665667, -0.00655248, -0.00642308, -0.00626743, -0.00608447,
  -0.00587313, -0.00563227, -0.00536078, -0.00505748, -0.00472118,
  -0.00435068, -0.00394472, -0.00350204, -0.00302134, -0.00250129,
  -0.00194053, -0.00133768, -0.000691315, 9.19946e-17}; 


G4double G4NeutronHPFastLegendre::regularEvaluate( int l , double x )
{
   double y_pre;
   double y;
   double y_post;

   y_pre=1;
   y=x;

   for ( int n = 1; n<l ; n++ )
   {
      y_post = 1.0*(2*n+1)/(n+1)*x*y-1.0*n/(n+1)*y_pre;
      y_pre=y;
      y=y_post;
   }
   //G4cout << l << " " << x << " " << y << G4endl;

   return y;
}

G4double G4NeutronHPFastLegendre::regularIntegrate( int l , double x )
{
   double y_pre;
   double y;
   double y_post;
   double ydx;

   y_pre=1;
   y=x;

   for ( int n = 1; n<l ; n++ )
   {
      y_post = 1.0*(2*n+1)/(n+1)*x*y-1.0*n/(n+1)*y_pre;
      y_pre=y;
      y=y_post;
   }
   //integerate from x to 1.
   ydx=1.0/(l+1)*(-x*y+y_pre);
   //std::cout << l << " " << x << " " << y << std::endl;

   return -ydx;
}
