//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id$
//
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#ifndef MicrobeamHistoManager_h
#define MicrobeamHistoManager_h 1

#include "globals.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

namespace AIDA {
 class IAnalysisFactory;
 class ITree;
 class ITuple;
}

const G4int MaxNtupl = 5;

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

class MicrobeamHistoManager
{
  public:

    MicrobeamHistoManager();
   ~MicrobeamHistoManager();

    void book();
    void save();   
    void FillNtuple(G4int id, G4int column, G4double value);
    void AddRowNtuple(G4int id);

  private:

    G4String                 fileName[2];
    G4String                 fileType;
    G4String                 fileOption;    
    AIDA::IAnalysisFactory*  af;
    AIDA::ITree*             tree;
    AIDA::ITuple*      	     ntupl0; // MicrobeamSteppingAction   
    AIDA::ITuple*      	     ntupl1; // MicrobeamSteppingAction   
    AIDA::ITuple*      	     ntupl2; // MicrobeamSteppingAction   
    AIDA::ITuple*      	     ntupl3; // MicrobeamEventAction   
    AIDA::ITuple*      	     ntupl4; // MicrobeamRunAction   
 
    G4bool                   factoryOn;
    
};

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#endif

