/*
 * Decompiled with CFR 0.152.
 */
import GAG.GAG;
import GGE.SourceFrame;
import GGE.VolumesFrame;
import GPE.PhysicsFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TabbedPaneFrame
extends JFrame
implements ChangeListener,
ActionListener {
    private JFileChooser fileChooser;
    private String fileName;
    JMenuBar mbar;
    JMenu fileJM;
    JMenu projectJM;
    JMenu helpJM;
    JMenuItem openMI;
    JMenuItem exitMI;
    JMenuItem makefileMI;
    JMenuItem compileMI;
    JMenuItem cleanMI;
    JMenuItem makeMainMI;
    JMenuItem aboutMOMO;
    JMenuItem aboutEnvMI;
    JMenuItem aboutGGEMI;
    JMenuItem aboutGPEMI;
    JMenuItem aboutGAGMI;
    JButton g4workdirBT;
    JTextField g4target;
    JTextField g4workdir;
    private MOMOpipe pipeMake;
    private MOMOpipe pipeClean;
    private ErrStream errStreamMake;
    private ErrStream errStreamClean;
    EnvPanel envPanel;
    EnvVariable envVars;
    String[] envName;
    String g4workdirpath;
    PhysicsFrame physicsFrame;
    VolumesFrame volumesFrame;
    SourceFrame momomake;
    SourceFrame mainprog;
    GAG gagPanel;

    public TabbedPaneFrame() {
        this.setTitle("Momo");
        this.mbar = new JMenuBar();
        this.mbar.setBorderPainted(true);
        this.setJMenuBar(this.mbar);
        Container container = this.getContentPane();
        BoxLayout containerlayout = new BoxLayout(container, 1);
        container.setLayout(containerlayout);
        JPanel g4targetbase = new JPanel();
        g4targetbase.setLayout(new BoxLayout(g4targetbase, 0));
        container.add(g4targetbase);
        this.fileJM = new JMenu("File");
        this.fileJM.setFont(new Font("Serif", 1, 14));
        this.fileJM.setBackground(Color.green);
        this.mbar.add(this.fileJM);
        this.openMI = new JMenuItem("Open");
        this.fileJM.add(this.openMI);
        this.fileJM.addSeparator();
        this.exitMI = new JMenuItem("exit");
        this.fileJM.add(this.exitMI);
        this.projectJM = new JMenu("Project");
        this.projectJM.setFont(new Font("Serif", 1, 14));
        this.mbar.add(this.projectJM);
        this.makeMainMI = new JMenuItem("Main Program");
        this.projectJM.add(this.makeMainMI);
        this.makefileMI = new JMenuItem("Makefile");
        this.projectJM.add(this.makefileMI);
        this.compileMI = new JMenuItem("Compile");
        this.projectJM.add(this.compileMI);
        this.cleanMI = new JMenuItem("make Clean");
        this.projectJM.add(this.cleanMI);
        this.helpJM = new JMenu("Help");
        this.helpJM.setFont(new Font("Serif", 1, 14));
        this.mbar.add(this.helpJM);
        this.aboutMOMO = new JMenuItem("About MOMO");
        this.helpJM.add(this.aboutMOMO);
        this.momomake = new SourceFrame();
        this.mainprog = new SourceFrame();
        this.openMI.addActionListener(this);
        this.exitMI.addActionListener(this);
        this.makeMainMI.addActionListener(this);
        this.makefileMI.addActionListener(this);
        this.compileMI.addActionListener(this);
        this.cleanMI.addActionListener(this);
        this.aboutMOMO.addActionListener(this);
        this.g4target = new JTextField();
        this.g4target.setColumns(30);
        g4targetbase.add(new JLabel("Typein G4TARGET name"));
        g4targetbase.add(this.g4target);
        g4targetbase.add(Box.createHorizontalGlue());
        this.g4workdirBT = new JButton("set GEANT4 WORKDIR");
        EnvVariable envVars = new EnvVariable();
        this.g4workdirpath = String.valueOf(envVars.get("G4WORKDIR"));
        this.g4workdir = new JTextField(this.g4workdirpath);
        this.g4workdirBT.addActionListener(this);
        this.g4workdir.addActionListener(this);
        g4targetbase.add(this.g4workdirBT);
        g4targetbase.add(this.g4workdir);
        this.setSize(900, 700);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JTabbedPane momotabbedPane = new JTabbedPane();
        momotabbedPane.addChangeListener(this);
        this.envPanel = new EnvPanel();
        this.physicsFrame = new PhysicsFrame();
        this.volumesFrame = new VolumesFrame();
        this.gagPanel = new GAG();
        ImageIcon icon = new ImageIcon("yellow-ball.gif");
        momotabbedPane.addTab("Env Vars", icon, this.envPanel);
        momotabbedPane.setForegroundAt(0, Color.red);
        momotabbedPane.addTab("Volumes", icon, this.volumesFrame);
        momotabbedPane.addTab("Materials", icon, this.volumesFrame.matFrame);
        momotabbedPane.setForegroundAt(1, Color.cyan);
        momotabbedPane.setForegroundAt(2, Color.magenta);
        momotabbedPane.addTab("GAG", icon, this.gagPanel);
        momotabbedPane.setForegroundAt(3, Color.darkGray);
        container.add((Component)momotabbedPane, "Center");
        this.setPath(this.g4workdirpath);
    }

    public void getPath() {
        JFrame frame = new JFrame("HIBMC HOME PATH");
        Container c = frame.getContentPane();
        JLabel label = new JLabel("Enter the Absolute Path of HIBMC");
        c.add(label);
        JTextField text = new JTextField("/home/");
        text.setColumns(20);
        c.add(text);
        JButton button = new JButton("...");
        button.addActionListener(this);
        JFileChooser dataPath = new JFileChooser(".");
        dataPath.setDialogTitle("HIBMC Data Directory");
        dataPath.setDialogType(2);
        dataPath.setFileSelectionMode(1);
        if (dataPath.showDialog(this, "choose") == 1) {
            return;
        }
        File fl = dataPath.getCurrentDirectory();
        text.setText(fl.getPath());
    }

    public void gagrun() {
        this.gagPanel.mainLoop();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JFrame noTframe;
        Object o = ae.getSource();
        if (o == this.aboutMOMO) {
            FileView fv = new FileView();
            fv.setVisible(true);
        }
        if (o == this.makefileMI) {
            if (this.g4target.getText().trim().equals("")) {
                noTframe = new JFrame();
                JOptionPane.showMessageDialog(noTframe, "Please Specify the Target Name or main program name", "Warning Dialog", 2);
                return;
            }
            try {
                StringBuffer gmake = new StringBuffer(this.getMakefile());
                this.momomake.setVisible(true);
                this.momomake.editor.setText(this.getMakefile());
                this.momomake.setPath(".");
                this.fileName = "GNUmakefile";
                FileOutputStream libfile = new FileOutputStream(this.fileName);
                PrintWriter liboutPut = new PrintWriter(new DataOutputStream(libfile));
                liboutPut.println(gmake.toString());
                liboutPut.close();
            }
            catch (IOException ie) {
                System.out.println(ie.toString());
            }
        }
        if (o == this.makeMainMI) {
            if (this.g4target.getText().trim().equals("")) {
                noTframe = new JFrame();
                JOptionPane.showMessageDialog(noTframe, "Please Specify the Target Name or main program name", "Warning Dialog", 2);
                return;
            }
            try {
                StringBuffer maincc = new StringBuffer(this.getMain());
                this.mainprog.setVisible(true);
                this.mainprog.editor.setText(this.getMain());
                this.mainprog.setPath(".");
                String mainfileName = this.g4target.getText() + ".cc";
                FileOutputStream mainfile = new FileOutputStream(mainfileName);
                PrintWriter mainoutPut = new PrintWriter(new DataOutputStream(mainfile));
                mainoutPut.println(maincc.toString());
                mainoutPut.close();
            }
            catch (IOException ie) {
                System.out.println(ie.toString());
            }
        } else if (o == this.compileMI) {
            String cmdMake = "make";
            this.pipeMake = new MOMOpipe(cmdMake);
            if (this.pipeMake == null) {
                System.out.println("MOMOpipe error");
            } else {
                this.errStreamMake = new ErrStream(this.pipeMake);
                this.errStreamMake.start();
            }
        } else if (o == this.cleanMI) {
            String cmdClean = "make clean";
            this.pipeClean = new MOMOpipe(cmdClean);
            if (this.pipeClean == null) {
                System.out.println("MOMOpipe error");
            } else {
                this.errStreamClean = new ErrStream(this.pipeClean);
                this.errStreamClean.start();
            }
        } else if (o != this.openMI) {
            if (o == this.exitMI) {
                System.exit(0);
            } else if (o == this.g4workdirBT) {
                this.loadPath();
                this.setPath(this.g4workdir.getText());
            } else if (o == this.g4workdir) {
                this.g4workdirpath = this.g4workdir.getText();
                this.setPath(this.g4workdirpath);
            }
        }
    }

    public void setPath(String path) {
        String currentDir;
        if (path.equals("null")) {
            path = ".";
        }
        this.volumesFrame.workdirpath = currentDir = ".";
        this.volumesFrame.sf.workdirpath = currentDir;
        this.volumesFrame.includesf.workdirpath = currentDir;
        this.volumesFrame.xmlf.workdirpath = currentDir;
        this.volumesFrame.matFrame.workdirpath = currentDir;
        this.physicsFrame.workdirpath = currentDir;
        this.physicsFrame.source.workdirpath = currentDir;
        this.physicsFrame.include.workdirpath = currentDir;
        this.gagPanel.workdirpath = path;
        this.momomake.workdirpath = currentDir;
        this.mainprog.workdirpath = currentDir;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        JTabbedPane pane = (JTabbedPane)event.getSource();
        if (pane.getSelectedComponent() == null) {
            int n = pane.getSelectedIndex();
            String title = pane.getTitleAt(n);
            ImageIcon planetIcon = new ImageIcon(title + ".gif");
            pane.setComponentAt(n, new JLabel(planetIcon));
            pane.setIconAt(n, new ImageIcon("red-ball.gif"));
        }
    }

    String getMakefile() {
        StringBuffer gmake = new StringBuffer("##### GNUmakefile #####\n");
        gmake.append("# ----------------------------------------------------------\n");
        gmake.append("# Script defining rules and paths for making binaries.\n");
        gmake.append("# ----------------------------------------------------------\n");
        gmake.append("# Automatic creation of GNUmakefile for Momo environment.\n");
        gmake.append("# with users selection of G4TARGET, UI and VIS variables\n");
        gmake.append("#  Momo is the name of legendary samurai who conquered the malicious geants. ----   H. Yoshida.\n");
        gmake.append("\n");
        gmake.append("name := " + this.g4target.getText() + "\n");
        gmake.append("G4TARGET := $(name)\n");
        gmake.append("G4EXLIB := true\n");
        gmake.append("\n");
        gmake.append("# Vis/GUI used\n");
        int i = 0;
        while (true) {
            if (i >= EnvPanel.visguiuseName.length) break;
            if (this.envPanel.checkU[i].isSelected()) {
                gmake.append(EnvPanel.visguiuseName[i] + " := 1\n");
            }
            ++i;
        }
        gmake.append("\n");
        gmake.append("# General Envs defined\n");
        i = 0;
        while (true) {
            if (i >= EnvPanel.envName.length) break;
            if (!this.envPanel.textF[i].getText().trim().equals("null")) {
                gmake.append(EnvPanel.envName[i] + ":=" + this.envPanel.textF[i].getText() + "\n");
            }
            ++i;
        }
        gmake.append("\n");
        gmake.append("ifndef G4INSTALL\n");
        gmake.append("   G4INSTALL = ../../..\n");
        gmake.append("endif\n");
        gmake.append("\n");
        gmake.append(".PHONY: all\n");
        gmake.append("all: lib bin\n");
        gmake.append("\n");
        gmake.append("  include $(G4INSTALL)/config/binmake.gmk\n");
        gmake.append("\n");
        return gmake.toString();
    }

    String getMain() {
        Date today = new Date();
        StringBuffer maincc = new StringBuffer("//##### MOMO Main program #####\n");
        maincc.append("//# ----------------------------------------------------------\n");
        maincc.append("//# Automatic creation of the main program for Momo environment.\n");
        maincc.append("// 2010 December, updated for  geant4.9.4\n");
        maincc.append("// --------------------------------------------------------------\n");
        maincc.append("//   " + this.g4target.getText() + ".cc generated by Geant4 Momo\n");
        maincc.append("//     at " + today.toString() + "  \n\n");
        maincc.append("\n");
        maincc.append("// This code implementation is the intellectual property of\n");
        maincc.append("// the  GEANT4 collaboration.\n");
        maincc.append("//\n");
        maincc.append("// By copying, distributing or modifying the Program (or any work\n");
        maincc.append("// based on the Program) you indicate your acceptance of this statement,\n");
        maincc.append("// and all its terms.\n");
        maincc.append("//\n");
        maincc.append("// \n");
        maincc.append("#include \"G4RunManager.hh\"\n");
        maincc.append("#include \"G4UImanager.hh\"\n");
        maincc.append("// Your choice of User Interface driver\n");
        maincc.append("#include \"G4UIGAG.hh\"\n");
        maincc.append("// Detector geometry generated by Momo's GGE\n");
        maincc.append("#include \"" + this.volumesFrame.classNameField.getText().trim() + ".hh\"\n");
        maincc.append("// temporary using a pre-tuned Physics List\n");
        maincc.append("#include \"QGSP_BERT.hh\"\n");
        maincc.append("// Momo's default PrimaryGeneratorAction\n");
        maincc.append("#include \"MomoPrimaryGeneratorAction.hh\"\n");
        maincc.append("#include \"MomoRunAction.hh\"\n");
        maincc.append("#include \"MomoEventAction.hh\"\n");
        maincc.append("#ifdef G4VIS_USE\n");
        maincc.append("#include \"G4VisExecutive.hh\"\n");
        maincc.append("#endif\n");
        maincc.append("int main()\n");
        maincc.append("{\n");
        maincc.append("  // Construct the default run manager\n");
        maincc.append("  G4RunManager* runManager = new G4RunManager;\n");
        maincc.append("  // set mandatory initialization classes\n");
        maincc.append("  runManager->SetUserInitialization(new " + this.volumesFrame.classNameField.getText().trim() + ");\n");
        maincc.append("  G4VUserPhysicsList* physics = new QGSP_BERT();\n");
        maincc.append("  runManager->SetUserInitialization(physics);\n");
        maincc.append("#ifdef G4VIS_USE\n");
        maincc.append("  // visualization manager\n");
        maincc.append("  G4VisManager* visManager = new G4VisExecutive;\n");
        maincc.append("  visManager->Initialize();\n");
        maincc.append("#endif\n");
        maincc.append("  // set mandatory user action class\n");
        maincc.append("  runManager->SetUserAction(new MomoPrimaryGeneratorAction);\n");
        maincc.append("  // set user action classes to visualise trajectories\n");
        maincc.append("  runManager->SetUserAction(new MomoRunAction);\n");
        maincc.append("  runManager->SetUserAction(new MomoEventAction);\n");
        maincc.append("  // Initialize G4 kernel\n");
        maincc.append("  runManager->Initialize();\n");
        maincc.append("  // get the pointer to the User Interface manager \n");
        maincc.append("  G4UImanager* UI = G4UImanager::GetUIpointer();\n");
        maincc.append("      G4UIsession * session = new G4UIGAG;\n");
        maincc.append("      session->SessionStart();\n");
        maincc.append("      delete session;\n");
        maincc.append("  // job termination\n");
        maincc.append("#ifdef G4VIS_USE\n");
        maincc.append("  delete visManager;\n");
        maincc.append("#endif\n");
        maincc.append("  delete runManager;\n");
        maincc.append("  return 0;\n");
        maincc.append("}\n");
        return maincc.toString();
    }

    public void loadPath() {
        if (this.g4workdirpath.equals("null")) {
            this.g4workdirpath = ".";
        }
        JFileChooser dataPath = new JFileChooser(this.g4workdirpath);
        dataPath.setDialogTitle("set GEANT4 WORKDIR");
        dataPath.setDialogType(2);
        dataPath.setFileSelectionMode(2);
        if (dataPath.showDialog(this, "choose") == 1) {
            return;
        }
        File fl = dataPath.getCurrentDirectory();
        this.g4workdir.setText(fl.getPath());
        this.g4workdirpath = fl.getPath();
    }
}

