//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id$
//
// 20100804  M. Kelsey -- Add name string to ctor
// 20110719  M. Kelsey -- Add initial state code to ctor
// 20110725  M. Kelsey -- Instantiate cross-section object for self-registration
// 20110916  M. Kelsey -- Drop self-registration due to platform inconsistencies

#include "G4CascadePiZeroPChannel.hh"
#include "G4CascadePiZeroNChannel.hh"
#include "G4InuclParticleNames.hh"
using namespace G4InuclParticleNames;

namespace {
  // pi0 p : Outgoing particle types of a given multiplicity
  static const G4int pizP2bfs[5][2] =
  {{pi0,pro}, {pip,neu}, {kpl,lam}, {kpl,s0}, {k0,sp}};

  static const G4int pizP3bfs[13][3] =
  {{pip,pro,pim}, {pi0,pro,pi0}, {pi0,neu,pip}, {pi0,lam,kpl}, 
    {pip,lam,k0},  {pi0,s0,kpl},   {pip,s0,k0},   {pi0,sp,k0},
    {pim,sp,kpl},   {pip,sm,kpl},   {kmi,pro,kpl},   {k0b,pro,k0},
    {k0b,neu,kpl}};

  static const G4int pizP4bfs[21][4] =
  {{pi0,pro,pim,pip}, {pi0,pro,pi0,pi0}, {pip,neu,pip,pim},
    {pi0,neu,pip,pi0}, {pip,lam,kpl,pim},  {pip,s0,kpl,pim}, 
    {pi0,lam,kpl,pi0},  {pi0,s0,kpl,pi0},   {pi0,sp,k0,pi0}, 
    {pi0,lam,k0,pip},  {pi0,s0,k0,pip},   {pip,sp,k0,pim}, 
    {pi0,sp,kpl,pim},   {pi0,sm,kpl,pip},   {pi0,pro,kpl,kmi}, 
    {pi0,pro,k0,k0b},  {pip,pro,k0,kmi},   {pim,pro,kpl,k0b}, 
    {pip,neu,kpl,kmi},   {pip,neu,k0,k0b},  {pi0,neu,kpl,k0b}}; 

  static const G4int pizP5bfs[30][5] =
  {{pip,pro,pip,pim,pim}, {pi0,pro,pip,pim,pi0}, {pi0,pro,pi0,pi0,pi0},
    {pi0,neu,pip,pip,pim}, {pi0,neu,pip,pi0,pi0}, {pi0,lam,kpl,pip,pim},
    {pi0,lam,kpl,pi0,pi0},  {pip,lam,k0,pip,pim},  {pi0,lam,k0,pip,pi0},  
    {pi0,s0,kpl,pip,pim},   {pi0,s0,kpl,pi0,pi0},   {pip,s0,k0,pip,pim},
    {pi0,s0,k0,pip,pi0},   {pi0,sp,k0,pip,pim},   {pi0,sp,k0,pi0,pi0},
    {pim,sp,kpl,pip,pim},   {pi0,sp,kpl,pim,pi0},   {pip,sm,kpl,pip,pim}, 
    {pi0,sm,kpl,pip,pi0},   {pi0,pro,kpl,kmi,pi0},   {pi0,pro,k0,k0b,pi0}, 
    {pi0,pro,kpl,k0b,pim},  {pi0,pro,k0,kmi,pip},   {pip,pro,kpl,kmi,pim},
    {pip,pro,k0,k0b,pim},  {pi0,neu,kpl,kmi,pip},   {pi0,neu,k0,k0b,pip},
    {pi0,neu,kpl,k0b,pi0},  {pip,neu,k0,kmi,pip},   {pip,neu,kpl,k0b,pim}};

  static const G4int pizP6bfs[6][6] =
  {{pi0,pro,pip,pip,pim,pim}, {pi0,pro,pip,pim,pi0,pi0},
    {pi0,pro,pi0,pi0,pi0,pi0}, {pip,neu,pip,pip,pim,pim},
    {pi0,neu,pip,pip,pim,pi0}, {pi0,neu,pip,pi0,pi0,pi0}};
 
  static const G4int pizP7bfs[7][7] =
  {{pip,pro,pip,pip,pim,pim,pim}, {pi0,pro,pip,pip,pim,pim,pi0},
    {pi0,pro,pip,pim,pi0,pi0,pi0}, {pi0,pro,pi0,pi0,pi0,pi0,pi0},
    {pi0,neu,pip,pip,pip,pim,pim}, {pi0,neu,pip,pip,pim,pi0,pi0},
    {pi0,neu,pip,pi0,pi0,pi0,pi0}};

  static const G4int pizP8bfs[8][8] =
  {{pi0,pro,pip,pip,pip,pim,pim,pim}, {pi0,pro,pip,pip,pim,pim,pi0,pi0},
    {pi0,pro,pip,pim,pi0,pi0,pi0,pi0}, {pi0,pro,pi0,pi0,pi0,pi0,pi0,pi0},
    {pip,neu,pip,pip,pip,pim,pim,pim}, {pi0,neu,pip,pip,pip,pim,pim,pi0},
    {pi0,neu,pip,pip,pim,pi0,pi0,pi0}, {pi0,neu,pip,pi0,pi0,pi0,pi0,pi0}};

  static const G4int pizP9bfs[9][9] =
  {{pip,pro,pip,pip,pip,pim,pim,pim,pim}, {pi0,pro,pip,pip,pip,pim,pim,pim,pi0},
    {pi0,pro,pip,pip,pim,pim,pi0,pi0,pi0}, {pi0,pro,pip,pim,pi0,pi0,pi0,pi0,pi0},
    {pi0,pro,pi0,pi0,pi0,pi0,pi0,pi0,pi0}, {pi0,neu,pip,pip,pip,pip,pim,pim,pim},
    {pi0,neu,pip,pip,pip,pim,pim,pi0,pi0}, {pi0,neu,pip,pip,pim,pi0,pi0,pi0,pi0},
    {pi0,neu,pip,pi0,pi0,pi0,pi0,pi0,pi0}};
}

namespace {
  // pi0 n : Outgoing particle types of a given multiplicity
  static const G4int pizN2bfs[5][2] =
   {{pi0,neu}, {pim,pro}, {k0,lam}, {k0,s0}, {kpl,sm}};

  static const G4int pizN3bfs[13][3] =
   {{pim,neu,pip}, {pi0,neu,pi0}, {pi0,pro,pim}, {pi0,lam,k0},
    {pim,lam,kpl},  {pi0,s0,k0},   {pim,s0,kpl},   {pi0,sm,kpl},  
    {pip,sm,k0},   {pim,sp,k0},   {k0b,neu,k0},  {kmi,neu,kpl},
    {kmi,pro,k0}};

  static const G4int pizN4bfs[21][4] =
   {{pi0,neu,pim,pip}, {pi0,neu,pi0,pi0}, {pim,pro,pip,pim},
    {pi0,pro,pim,pi0}, {pip,lam,k0,pim},  {pip,s0,k0,pim},
    {pi0,lam,k0,pi0},  {pi0,s0,k0,pi0},   {pi0,sm,kpl,pi0},
    {pi0,lam,kpl,pim},  {pi0,s0,kpl,pim},   {pip,sm,kpl,pim},
    {pi0,sm,k0,pip},   {pi0,sp,k0,pim},   {pi0,neu,k0,k0b},
    {pi0,neu,kpl,kmi},   {pim,neu,kpl,k0b},  {pip,neu,k0,kmi},
    {pim,pro,k0,k0b},  {pim,pro,kpl,kmi},   {pi0,pro,k0,kmi}};

  static const G4int pizN5bfs[30][5] =
  {{pim,neu,pip,pip,pim}, {pi0,neu,pip,pim,pi0}, {pi0,neu,pi0,pi0,pi0},
    {pi0,pro,pip,pim,pim}, {pi0,pro,pim,pi0,pi0}, {pi0,lam,k0,pip,pim},
    {pi0,lam,k0,pi0,pi0},  {pim,lam,kpl,pip,pim},  {pi0,lam,kpl,pim,pi0},
    {pi0,s0,k0,pip,pim},   {pi0,s0,k0,pi0,pi0},   {pim,s0,kpl,pip,pim},
    {pi0,s0,kpl,pim,pi0},   {pi0,sm,kpl,pip,pim},   {pi0,sm,kpl,pi0,pi0},
    {pip,sm,k0,pip,pim},   {pi0,sm,k0,pip,pi0},   {pim,sp,k0,pip,pim},
    {pi0,sp,k0,pim,pi0},   {pi0,neu,k0,k0b,pi0},  {pi0,neu,kpl,kmi,pi0},
    {pi0,neu,k0,kmi,pip},   {pi0,neu,kpl,k0b,pim},  {pim,neu,k0,k0b,pip},
    {pim,neu,kpl,kmi,pip},   {pi0,pro,k0,k0b,pim},  {pi0,pro,kpl,kmi,pim},
    {pi0,pro,k0,kmi,pi0},   {pim,pro,kpl,k0b,pim},  {pim,pro,k0,kmi,pip}};

  static const G4int pizN6bfs[6][6] =
   {{pi0,neu,pip,pip,pim,pim}, {pi0,neu,pip,pim,pi0,pi0},
    {pi0,neu,pi0,pi0,pi0,pi0}, {pim,pro,pip,pip,pim,pim},
    {pi0,pro,pip,pim,pim,pi0}, {pi0,pro,pim,pi0,pi0,pi0}};

  static const G4int pizN7bfs[7][7] =
   {{pim,neu,pip,pip,pip,pim,pim}, {pi0,neu,pip,pip,pim,pim,pi0},
    {pi0,neu,pip,pim,pi0,pi0,pi0}, {pi0,neu,pi0,pi0,pi0,pi0,pi0},
    {pi0,pro,pip,pip,pim,pim,pim}, {pi0,pro,pip,pim,pim,pi0,pi0},
    {pi0,pro,pim,pi0,pi0,pi0,pi0}};

  static const G4int pizN8bfs[8][8] =
   {{pi0,neu,pip,pip,pip,pim,pim,pim}, {pi0,neu,pip,pip,pim,pim,pi0,pi0},
    {pi0,neu,pip,pim,pi0,pi0,pi0,pi0}, {pi0,neu,pi0,pi0,pi0,pi0,pi0,pi0},
    {pim,pro,pip,pip,pip,pim,pim,pim}, {pi0,pro,pip,pip,pim,pim,pim,pi0},
    {pi0,pro,pip,pim,pim,pi0,pi0,pi0}, {pi0,pro,pim,pi0,pi0,pi0,pi0,pi0}};

  static const G4int pizN9bfs[9][9] =
   {{pim,neu,pip,pip,pip,pip,pim,pim,pim}, {pi0,neu,pip,pip,pip,pim,pim,pim,pi0},
    {pi0,neu,pip,pip,pim,pim,pi0,pi0,pi0}, {pi0,neu,pip,pim,pi0,pi0,pi0,pi0,pi0},
    {pi0,neu,pi0,pi0,pi0,pi0,pi0,pi0,pi0}, {pi0,pro,pip,pip,pip,pim,pim,pim,pim},
    {pi0,pro,pip,pip,pim,pim,pim,pi0,pi0}, {pi0,pro,pip,pim,pim,pi0,pi0,pi0,pi0},
    {pi0,pro,pim,pi0,pi0,pi0,pi0,pi0,pi0}};
}

namespace {
  // Total pi- p cross section as a function of kinetic energy
  static const G4double pizPtotXSec[30] =
   { 6.43,  7.18,  7.54,  8.01,  8.52,  9.13, 10.22, 14.37, 20.96, 34.73,
    61.07, 98.23, 61.97, 32.62, 28.07, 31.37, 35.15, 40.17, 37.27, 33.49,
    31.06, 29.52, 28.29, 26.91, 26.25, 25.25, 24.75, 24.35, 24.0,  23.9};

  // pi- p cross sections as functions of kinetic energy and multiplicity
  static const G4double pizPCrossSections[99][30] = {
  //
  // multiplicity 2 (5 channels)
  //
  // p pi0 (n pi0)
    //   { 0.0,   1.15, 1.85,  2.6,  3.25,  4.4,   5.5,   9.0,  16.7,  35.5,
    //    72.0, 107.0, 72.35, 33.1, 19.51, 17.02, 11.27, 19.11, 15.35, 11.0,
    //     8.83,  7.4,  6.4,   5.75, 5.2,   4.7,   4.25,  4.0,   3.8,   3.65},

  // p pi0 (n pi0)   go back to original for now
   { 1.73,  2.28,  2.44,   2.71,  3.02,   3.43,   3.92,   5.37,  9.96, 17.73,
   29.07, 50.23, 33.68,  16.69, 12.60,  11.89,  13.49,  15.24, 12.39,  9.59,
    7.92,  6.97,  6.13,   5.37,  4.82,   4.68,   4.54,   4.0,   3.8,   3.65},

  // n pi+ (p pi-)
   //   { 0.0,  2.4,  2.8,  3.3,   4.5,  5.7,  6.3,  9.0, 11.0, 17.0,
   //    30.0, 43.0, 30.0, 16.5,  11.0,  7.01, 4.31, 5.03, 2.05, 0.97,
   //     0.53, 0.3,  0.2,  0.11,  0.07, 0.05, 0.04, 0.03, 0.02, 0.01},

  // n pi+ (p pi-)  taken from pi- p -> pi0 n
   { 4.7,  4.9,  5.1,  5.3,  5.5,  5.7,  6.3,  9.0, 11.0, 17.0,
   32.0, 48.0, 28.0, 14.5, 11.04, 8.99, 4.79, 5.02, 2.08, 0.94,
   0.5,  0.25, 0.15, 0.09, 0.06, 0.05, 0.04, 0.02, 0.02, 0.01},

  // L K+ (L K0)
   { 0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
     0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.65, 0.29, 0.17,
     0.14, 0.1, 0.05, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0},

  // S0 K+ (S0 K0)
   { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
     0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.28, 0.18, 0.12,
     0.10, 0.06, 0.04, 0.03, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0},

  // S+ K0 (S- K+)
   { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
     0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.18, 0.43, 0.22,
     0.12, 0.06, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0},
  //
  // multiplicity 3 (13 channels)
  //
  // p pi+ pi- (n pi+ pi-)
   {0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0, 0.03, 0.19, 0.73, 3.4,  7.01, 8.35, 8.9,  5.69,
    4.01, 2.7, 2.0,  1.30, 0.9,  0.68, 0.48, 0.34, 0.27, 0.19},

  // p pi0 pi0 (n pi0 pi0)
   {0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.0,
    0.0,  0.0, 0.22, 0.74, 1.8,  2.7,  3.0, 2.52, 1.33, 0.69,
    0.44, 0.3, 0.2,  0.12, 0.07, 0.04, 0.0, 0.0,  0.0,  0.0},

  // n pi+ pi0 (p pi- pi0)
   {0.0,  0.0, 0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,
    0.0,  0.0, 0.04, 0.5,  1.75, 3.6, 5.21, 5.28, 6.34, 5.15,
    4.01, 3.1, 2.2,  1.42, 1.05, 0.8, 0.57, 0.33, 0.26, 0.19},

  // L K+ pi0 (L K0 pi0)
   {0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,   0.0,
    0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02,  0.13,
    0.14, 0.1, 0.08, 0.06, 0.04, 0.03, 0.02, 0.02, 0.01,  0.01},

  // L K0 pi+ (L K+ pi-)
   {0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.03, 0.16,
    0.15, 0.1, 0.07, 0.05, 0.04, 0.03, 0.02, 0.02, 0.01, 0.01},

  // S0 K+ pi0 (S0 K0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.09,
    0.11, 0.07, 0.05, 0.04, 0.03, 0.02, 0.01, 0.01, 0.01, 0.0},

  // S0 K0 pi+ (S0 K+ pi-)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.11,
    0.11, 0.07, 0.05, 0.04, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01},

  // S+ K0 pi0 (S- K+ pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.09,
    0.11, 0.07, 0.05, 0.04, 0.03, 0.02, 0.01, 0.01, 0.0, 0.0},

  // S+ K+ pi- (S- K0 pi+)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.09,
    0.11, 0.07, 0.05, 0.04, 0.03, 0.02, 0.01, 0.01, 0.01, 0.01},

  // S- K+ pi+ (S+ K0 pi-)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0, 0.0, 0.0, 0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0, 0.0, 0.0, 0.08,
    0.10, 0.05, 0.03, 0.02, 0.01, 0.0, 0.0, 0.0, 0.0, 0.0},

  // p K+ K- (n K0 K0b)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.11,
    0.12, 0.08, 0.07, 0.04, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01},

  // p K0 K0b (n K+ K-)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.11,
    0.12, 0.08, 0.07, 0.05, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01},

  // n K+ K0b (p K0 K-)
   {0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.0, 0.0,
    0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.0, 0.05,
    0.11, 0.22, 0.2, 0.09, 0.05, 0.02, 0.01, 0.0, 0.0, 0.0},
  //
  // multiplicity 4 (21 channels)
  //
  // p pi+ pi- pi0 (n pi+ pi- pi0)
   {0.0,  0.0,  0.0,  0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0, 0.0, 0.04, 0.14, 0.44, 1.11, 1.88,
    2.05, 2.07, 1.75, 1.5, 1.3, 1.1,  0.95, 0.80, 0.72, 0.66},

  // p pi0 pi0 pi0 (n pi0 pi0 pi0)
   {0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.0,
    0.0,  0.0, 0.0,  0.0,  0.1,  0.55, 1.0, 0.88, 0.72, 0.64,
    0.53, 0.4, 0.35, 0.29, 0.22, 0.14, 0.1, 0.06, 0.03, 0.0},

  // n pi+ pi+ pi- (p pi+ pi- pi-)
   {0.0,  0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0, 0.0, 0.0,  0.05, 0.17, 0.32, 0.77, 1.79, 2.25,
    1.82, 1.5, 1.3, 1.05, 0.9,  0.72, 0.63, 0.5,  0.43, 0.35},

  // n pi+ pi0 pi0 (p pi- pi0 pi0)  
   {0.0,  0.0,  0.0, 0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0, 0.0,  0.0, 0.03, 0.09, 0.28, 0.77, 1.32,
    1.54, 1.37, 1.2, 1.02, 0.9, 0.77, 0.69, 0.6,  0.54, 0.48},

  // L K+ pi+ pi- (L K0 pi+ pi-)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
    0.03, 0.06, 0.07, 0.06, 0.05, 0.04, 0.03, 0.03, 0.02, 0.02},

  // S0 K+ pi+ pi- (S0 K0 pi+ pi-)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01},

  // L K+ pi0 pi0 (L K0 pi0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
    0.03, 0.06, 0.07, 0.06, 0.05, 0.04, 0.03, 0.03, 0.02, 0.02},

  // S0 K+ pi0 pi0 (S0 K0 pi0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01},

  // S+ K0 pi0 pi0 (S- K+ pi0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.06, 0.05, 0.04, 0.04, 0.03, 0.03, 0.02, 0.01, 0.01},

  // L K0 pi+ pi0 (L K+ pi- pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
    0.04, 0.07, 0.07, 0.06, 0.05, 0.04, 0.04, 0.03, 0.02, 0.02},

  // S0 K0 pi+ pi0 (S0 K+ pi- pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01},

  // S+ K0 pi+ pi- (S- K+ pi+ pi-)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.06, 0.05, 0.04, 0.04, 0.03, 0.02, 0.02, 0.01, 0.01},

  // S+ K+ pi- pi0 (S- K0 pi+ pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.05, 0.08, 0.06, 0.04, 0.03, 0.02, 0.02, 0.01, 0.01},

  // S- K+ pi+ pi0 (S+ K0 pi- pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.03, 0.11, 0.11, 0.09, 0.07, 0.04, 0.03, 0.03, 0.02, 0.02},

  // p pi0 K+ K- (n pi0 K0 K0b)
   {0.0,  0.0, 0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0, 0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.01, 0.1, 0.11, 0.1, 0.08, 0.07, 0.07, 0.06, 0.05, 0.04},

  // p pi0 K0 K0b (n pi0 K+ K-)
   {0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.05, 0.11, 0.1, 0.09, 0.08, 0.07, 0.06, 0.05, 0.04},

  // p pi+ K0 K- (n pi- K+ K0b)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.05, 0.08, 0.07, 0.07, 0.06, 0.06, 0.05, 0.05, 0.04},

  // p pi- K+ K0b (n pi+ K0 K-)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.05, 0.08, 0.07, 0.07, 0.06, 0.06, 0.05, 0.05, 0.04},

  // n pi+ K+ K- (p pi- K0 K0b)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.05, 0.07, 0.06, 0.06, 0.05, 0.05, 0.04, 0.04, 0.04},

  // n pi+ K0 K0b (p pi- K+ K-)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.05, 0.07, 0.06, 0.06, 0.05, 0.05, 0.04, 0.04, 0.04},

  // n pi0 K+ K0b (p pi0 K0 K-)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.05, 0.07, 0.06, 0.06, 0.05, 0.05, 0.04, 0.04, 0.04},
  //
  // multiplicity 5 (30 channels)
  //
  // p pi+ pi+ pi- pi- (n pi+ pi+ pi- pi-)
   {0.0,  0.0, 0.0, 0.0, 0.0, 0.0,  0.0, 0.0,  0.0,  0.0,
    0.0,  0.0, 0.0, 0.0, 0.0, 0.0,  0.0, 0.04, 0.2,  1.45,
    2.41, 3.1, 2.7, 2.3, 2.0, 1.54, 1.3, 1.0,  0.83, 0.66},

// p pi+ pi- pi0 pi0 (n pi+ pi- pi0 pi0)
 { 0.0,  0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0,  0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.01, 0.07, 0.48,
   0.80, 1.1, 0.9, 0.76, 0.63, 0.51, 0.43, 0.33, 0.28, 0.22},

// p pi0 pi0 pi0 pi0 (n pi0 pi0 pi0 pi0)
 { 0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.03, 0.21,
   0.35, 0.5, 0.67, 0.55, 0.47, 0.38, 0.33, 0.23, 0.2,  0.17},

// n pi+ pi+ pi- pi0 (p pi+ pi- pi- pi0)
 { 0.0,  0.0, 0.0, 0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,
   0.0,  0.0, 0.0, 0.0,  0.0, 0.0,  0.1,  0.2,  0.41, 1.16,
   1.75, 1.8, 1.8, 1.38, 1.0, 0.76, 0.58, 0.42, 0.32, 0.24},

// n pi+ pi0 pi0 pi0 (p pi- pi0 pi0 pi0)
 { 0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.04, 0.21,
   0.42, 0.6, 0.72, 0.68, 0.57, 0.47, 0.38, 0.28, 0.24, 0.2},

// L K+ pi+ pi- pi0 (L K0 pi+ pi- pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.03, 0.04, 0.05, 0.04, 0.04, 0.03, 0.03, 0.02},

// L K+ pi0 pi0 pi0 (L K0 pi0 pi0 pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.03, 0.04, 0.05, 0.04, 0.04, 0.03, 0.03, 0.02},

//  L K0 pi+ pi+ pi- (L K+ pi+ pi- pi-)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.03, 0.04, 0.04, 0.03, 0.03, 0.03, 0.02, 0.02},

// L K0 pi+ pi0 pi0 (L K+ pi- pi0 pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.03, 0.04, 0.04, 0.03, 0.03, 0.03, 0.02, 0.02},

// S0 K+ pi+ pi- pi0 (S0 K0 pi+ pi- pi0)
 { 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01},

// S0 K+ pi0 pi0 pi0 (S0 K0 pi0 pi0 pi0)
 { 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01},

// S0 K0 pi+ pi+ pi- (S0 K+ pi+ pi- pi-)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.01, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

// S0 K0 pi+ pi0 pi0 (S0 K+ pi- pi0 pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.02, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01},

// S+ K0 pi+ pi- pi0 (S- K+ pi+ pi- pi0)
 { 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.01, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

// S+ K0 pi0 pi0 pi0 (S- K+ pi0 pi0 pi0)
 { 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.01, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

// S+ K+ pi+ pi- pi- (S- K0 pi+ pi+ pi-)
 { 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.01, 0.02, 0.03, 0.02, 0.02, 0.01, 0.01, 0.02},

// S+ K+ pi- pi0 pi0 (S- K0 pi+ pi0 pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.03, 0.05, 0.05, 0.03, 0.03, 0.02, 0.02, 0.02},

// S- K+ pi+ pi+ pi- (S+ K0 pi+ pi- pi-)
 { 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0, 0.01, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01},

// S- K+ pi+ pi0 pi0 (S+ K0 pi- pi0 pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.02, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01},

// p K+ K- pi0 pi0 (n K0 K0b pi0 pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.02, 0.06, 0.07, 0.06, 0.05, 0.05, 0.04, 0.04, 0.03},

// p K0 K0b pi0 pi0 (n K+ K- pi0 pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.03, 0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.02},

// p K+ K0b pi- pi0 (n K0 K- pi+ pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.03, 0.06, 0.06, 0.05, 0.05, 0.04, 0.04, 0.03},

// p K0 K- pi+ pi0 (n K+ K0b pi- pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.02, 0.03, 0.04, 0.03, 0.03, 0.02, 0.02, 0.03},

// p K+ K- pi+ pi- (n K0 K0b pi+ pi-)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.02, 0.06, 0.07, 0.06, 0.05, 0.05, 0.04, 0.04, 0.04},

// p K0 K0b pi+ pi- (n K+ K- pi+ pi-)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.03, 0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.02},

// n K+ K- pi+ pi0 (p K0 K0b pi- pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.02, 0.06, 0.05, 0.05, 0.04, 0.04, 0.03, 0.03, 0.03},

// n K0 K0b pi+ pi0 (p K+ K- pi- pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.04, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01},

// n K+ K0b pi0 pi0 (p K0 K- pi0 pi0)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.06, 0.05, 0.04, 0.03, 0.03, 0.03, 0.02, 0.02},

// n K0 K- pi+ pi+ (p K+ K0b pi- pi-)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.06, 0.04, 0.04, 0.03, 0.03, 0.03, 0.02, 0.02},

// n K+ K0b pi+ pi- (p K0 K- pi+ pi-)
 { 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
   0.0, 0.01, 0.06, 0.04, 0.04, 0.03, 0.03, 0.03, 0.02, 0.02},
  //
  // multiplicity 6 (6 channels)
  //
  // p pi+ pi+ pi- pi- pi0 (n pi+ pi+ pi- pi- pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.01, 0.02,
    0.04, 0.08, 0.12, 0.15, 0.2, 0.19, 0.17, 0.14, 0.12, 0.1},

  // p pi+ pi- pi0 pi0 pi0 (n pi+ pi- pi0 pi0 pi0)
   {0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.03,
    0.06, 0.1, 0.14, 0.16, 0.20, 0.19, 0.19, 0.16, 0.14, 0.13},

  // p pi0 pi0 pi0 pi0 pi0 (n pi0 pi0 pi0 pi0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02,
    0.03, 0.05, 0.07, 0.09, 0.11, 0.10, 0.10, 0.09, 0.08, 0.07},

  // n pi+ pi+ pi+ pi- pi- (p pi+ pi+ pi- pi- pi-)
   {0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.01, 0.02, 0.07,
    0.12, 0.21, 0.28, 0.36, 0.4, 0.42, 0.39, 0.36, 0.31, 0.28},

  // n pi+ pi+ pi- pi0 pi0 (p pi+ pi- pi- pi0 pi0)
   {0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.04,
    0.07, 0.15, 0.2, 0.24, 0.26, 0.29, 0.27, 0.24, 0.21, 0.18},

  // n pi+ pi0 pi0 pi0 pi0 (p pi- pi0 pi0 pi0 pi0)
   {0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.04,
    0.09, 0.15, 0.2, 0.25, 0.30, 0.29, 0.28, 0.25, 0.21, 0.19},
  //
  // multiplicity 7 (7 channels)
  //
  // p pi+ pi+ pi+ pi- pi- pi- (n pi+ pi+ pi+ pi- pi- pi-)
   {0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,
    0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.01, 0.02,
    0.03, 0.15, 0.4, 0.66, 0.85, 0.82, 0.75, 0.7, 0.65, 0.60},

  // p pi+ pi+ pi- pi- pi0 pi0 (n pi+ pi+ pi- pi- pi0 pi0)
   {0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,
    0.0,  0.0,  0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.01, 0.02,
    0.03, 0.15, 0.4, 0.66, 0.85, 0.82, 0.75, 0.7, 0.65, 0.60},

  // p pi+ pi- pi0 pi0 pi0 pi0 (n pi+ pi- pi0 pi0 pi0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.01, 0.07, 0.16, 0.28, 0.31, 0.29, 0.25, 0.20, 0.15, 0.10},

  // p pi0 pi0 pi0 pi0 pi0 pi0 (n pi0 pi0 pi0 pi0 pi0 pi0)
   {0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.02, 0.05, 0.10, 0.12, 0.12, 0.11, 0.10, 0.09, 0.08},

  // n pi+ pi+ pi+ pi- pi- pi0 (p pi+ pi+ pi- pi- pi- pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.0, 0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0,  0.0,  0.0, 0.0,
    0.01, 0.04, 0.08, 0.14, 0.27, 0.3, 0.27, 0.22, 0.2, 0.18},

  // n pi+ pi+ pi- pi0 pi0 pi0 (p pi+ pi- pi- pi0 pi0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
    0.01, 0.04, 0.08, 0.12, 0.16, 0.15, 0.13, 0.11, 0.09, 0.07},

  // n pi+ pi0 pi0 pi0 pi0 pi0 (p pi- pi0 pi0 pi0 pi0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.01, 0.03, 0.05, 0.08, 0.16, 0.19, 0.17, 0.16, 0.14, 0.13},
  //
  // multiplicity 8 (8 channels)
  //
  // p pi+ pi+ pi+ pi- pi- pi- pi0 (n pi+ pi+ pi+ pi- pi- pi- pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.01, 0.02, 0.04, 0.07, 0.11, 0.13, 0.14, 0.13, 0.12, 0.11},

  // p pi+ pi+ pi- pi- pi0 pi0 pi0 (n pi+ pi+ pi- pi- pi0 pi0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.01, 0.01, 0.03, 0.05, 0.08, 0.10, 0.10, 0.09, 0.09, 0.08},

  // p pi+ pi- pi0 pi0 pi0 pi0 pi0 (n pi+ pi- pi0 pi0 pi0 pi0 pi0)
   {0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.01, 0.02, 0.04, 0.06, 0.07, 0.07, 0.06, 0.06, 0.05},

  // p pi0 pi0 pi0 pi0 pi0 pi0 pi0 (n pi0 pi0 pi0 pi0 pi0 pi0 pi0)
   {0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.01, 0.01, 0.02, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04},

  // n pi+ pi+ pi+ pi+ pi- pi- pi- (p pi+ pi+ pi+ pi- pi- pi- pi-)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,   0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,   0.0,  0.0,  0.0,
    0.02, 0.04, 0.07, 0.12, 0.19, 0.26, 0.26, 0.24, 0.23, 0.21},

  // n pi+ pi+ pi+ pi- pi- pi0 pi0 (p pi+ pi+ pi- pi- pi- pi0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.02, 0.04, 0.07, 0.12, 0.19, 0.26, 0.25, 0.23, 0.23, 0.2},

  // n pi+ pi+ pi- pi0 pi0 pi0 pi0 (p pi+ pi- pi- pi0 pi0 pi0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.01, 0.03, 0.05, 0.08, 0.13, 0.13, 0.12, 0.11, 0.09, 0.08},

  // n pi+ pi0 pi0 pi0 pi0 pi0 pi0 (p pi- pi0 pi0 pi0 pi0 pi0 pi0)
   {0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.01, 0.02, 0.04, 0.06, 0.10, 0.13, 0.12, 0.11, 0.11, 0.1},

  //
  // multiplicity 9 (9 channels)
  //
  // p pi+ pi+ pi+ pi+ pi- pi- pi- pi- (n pi+ pi+ pi+ pi+ pi- pi- pi- pi-)
   {0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.01, 0.02, 0.05, 0.11, 0.16, 0.22, 0.27, 0.27, 0.27},

  // p pi+ pi+ pi+ pi- pi- pi- pi0 pi0 (n pi+ pi+ pi+ pi- pi- pi- pi0 pi0)
   {0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.01, 0.02, 0.03, 0.07, 0.10, 0.13, 0.18, 0.18, 0.18},

  // p pi+ pi+ pi- pi- pi0 pi0 pi0 pi0 (n pi+ pi+ pi- pi- pi0 pi0 pi0 pi0)
   {0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.01, 0.02, 0.04, 0.06, 0.09, 0.11, 0.11, 0.11},

  // p pi+ pi- pi0 pi0 pi0 pi0 pi0 pi0 (n pi+ pi- pi0 pi0 pi0 pi0 pi0 pi0)
   {0.0, 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.0, 0.01, 0.02, 0.04, 0.05, 0.07, 0.07, 0.07},

  // p pi0 pi0 pi0 pi0 pi0 pi0 pi0 pi0 (n pi0 pi0 pi0 pi0 pi0 pi0 pi0 pi0)
   {0.0, 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.0, 0.01, 0.02, 0.04, 0.05, 0.07, 0.07, 0.07},

  // n pi+ pi+ pi+ pi+ pi- pi- pi- pi0 (p pi+ pi+ pi+ pi- pi- pi- pi- pi0)
   {0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.01, 0.03, 0.06, 0.11, 0.14, 0.16, 0.16, 0.16},

  // n pi+ pi+ pi+ pi- pi- pi0 pi0 pi0 (p pi+ pi+ pi- pi- pi- pi0 pi0 pi0)
   {0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0, 0.0,
    0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0, 0.0, 0.0,
    0.0, 0.0, 0.01, 0.02, 0.05, 0.07, 0.08, 0.1, 0.1, 0.1},

  // n pi+ pi+ pi- pi0 pi0 pi0 pi0 pi0 (p pi+ pi- pi- pi0 pi0 pi0 pi0 pi0)
   {0.0, 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.0, 0.01, 0.02, 0.04, 0.06, 0.06, 0.06, 0.06},

  // n pi+ pi0 pi0 pi0 pi0 pi0 pi0 pi0 (p pi- pi0 pi0 pi0 pi0 pi0 pi0 pi0)
   {0.0, 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
    0.0, 0.0, 0.0, 0.01, 0.01, 0.02, 0.03, 0.04, 0.04, 0.04}};
}

// Initialize both |T Tz> = |1/2 1/2> channels, using pizP cross-section table

G4CascadePiZeroPChannelData::data_t
G4CascadePiZeroPChannelData::data(pizP2bfs, pizP3bfs, pizP4bfs,
				  pizP5bfs, pizP6bfs, pizP7bfs,
				  pizP8bfs, pizP9bfs, pizPCrossSections,
				  pizPtotXSec, pi0*pro, "PiZeroP");

G4CascadePiZeroNChannelData::data_t
G4CascadePiZeroNChannelData::data(pizN2bfs, pizN3bfs, pizN4bfs,
				  pizN5bfs, pizN6bfs, pizN7bfs,
				  pizN8bfs, pizN9bfs, pizPCrossSections,
				  pizPtotXSec, pi0*neu, "PiZeroN");
