// $Id: Doxymodules_eventgenerator.h 60059 2012-06-27 13:00:49Z gcosmo $
// The example class categories definitions for Doxygen

/// \file Doxymodules_eventgenerator.h
/// \brief The page that defines the extended/eventgenerator examples modules 


/** @defgroup extended_eventgenerator eventgenerator
 *  Extended examples eventgenerator classes
 *  @{
 */

/** @defgroup extended_eventgenerator_exgps exgps
 *  Eventgenerator example exgps
 *  @ingroup extended_eventgenerator
 *  @{
 */

  class exGPSAnalysisManager {};
  class exGPSAnalysisMessenger {};
  class exGPSEventAction {};
  class exGPSEventActionMessenger {};
  class exGPSGeometryConstruction {};
  class exGPSPhysicsList {};
  class exGPSPrimaryGeneratorAction {};
  class exGPSRunAction {};

/** @} */

/** @defgroup extended_eventgenerator_HepMC HepMC
 *  Extended examples eventgenerator/HepMC
 *  @ingroup extended_eventgenerator
 *  @{
 */


/** @defgroup extended_eventgenerator_HepMC_HepMCEx01 HepMCEx01
 *  Eventgenerator HepMC example HepMCEx01 
 *  @ingroup extended_eventgenerator_HepMC
 *  @{
 */

  class ExN04CalorimeterHit {};
  class ExN04CalorimeterParametrisation {};
  class ExN04CalorimeterROGeometry {};
  class ExN04CalorimeterSD {};
  class ExN04DetectorConstruction {};
  class ExN04DetectorParameterDef {};
  class ExN04DummySD {};
  class ExN04EventAction {};
  class ExN04Field {};
  class ExN04MuonHit {};
  class ExN04MuonSD {};
  class ExN04PrimaryGeneratorAction {};
  class ExN04PrimaryGeneratorMessenger {};
  class ExN04RunAction {};
  class ExN04StackingAction {};
  class ExN04StackingActionMessenger {};
  class ExN04SteppingAction {};
  class ExN04SteppingVerbose {};
  class ExN04TrackerHit {};
  class ExN04TrackerParametrisation {};
  class ExN04TrackerSD {};
  class ExN04TrackingAction {};
  class HepMCG4AsciiReader {};
  class HepMCG4AsciiReaderMessenger {};
  class HepMCG4Interface {};
  class HepMCG4PythiaInterface {};
  class HepMCG4PythiaMessenger {};

/** @} */

/** @defgroup extended_eventgenerator_HepMC_HepMCEx02 HepMCEx02
 *  Eventgenerator HepMC example HepMCEx02 
 *  @ingroup extended_eventgenerator_HepMC
 *  @{
 */

  class H02DetectorConstruction {};
  class H02EventAction {};
  class H02Field {};
  class H02MuonHit {};
  class H02MuonSD {};
  class H02PrimaryGeneratorAction {};
  class H02PrimaryGeneratorMessenger {};
  class H02SteppingAction {};
  class HepMCG4AsciiReader {};
  class HepMCG4AsciiReaderMessenger {};
  class HepMCG4Interface {};
  class HepMCG4PythiaInterface {};
  class HepMCG4PythiaMessenger {};

/** @} */

/** @defgroup extended_eventgenerator_HepMC_MCTruth MCTruth
 *  Eventgenerator HepMC example MCTruth 
 *  @ingroup extended_eventgenerator_HepMC
 *  @{
 */

  class MCTruthConfig {};
  class MCTruthEventAction {};
  class MCTruthManager {};
  class MCTruthTrackInformation {};
  class MCTruthTrackingAction {};

/** @} */

/** @} */

/** @defgroup extended_eventgenerator_particleGun particleGun
 *  Eventgenerator example particleGun has its 
 *  <a href="../html_particleGun/html/index.html">standalone documentation </a>
 *  @ingroup extended_eventgenerator
 *  @{
 */

/** @} */

/** @defgroup extended_eventgenerator_pythia_decayer6 pythia_decayer6
 *  Eventgenerator example pythia_decayer6
 *  @ingroup extended_eventgenerator
 *  @{
 */

  enum EDecayType {};
  class G4Pythia6Decayer {};
  class G4Pythia6DecayerMessenger {};
  class P6DExtDecayerPhysics {};
  class P6DPhysicsList {};
  class Pythia6 {};

/** @} */

/** @} */
