//$Id: MaterialFrame.java,v 1.10 2004/11/16 06:42:18 suzuki Exp $
// 2003 May XML test
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;


import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;
import javax.swing.filechooser.*;
import GPE.ExampleFileFilter;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.Serializable;

import javax.naming.spi.*;
import javax.xml.parsers.*;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.w3c.dom.*;


public class MaterialFrame extends AbstractGGEPanel implements ActionListener {

//public class MaterialFrame extends JPanel implements ActionListener, Serializable  {

  ElementsTable et;
  ElementItem eic[];
    //  DellCombiDialog dellCombi;
    //  DellScratchDialog dellScratch;
    //MOMO this is not seen in VolumesFrame  MaterialScratchTable msTable;
//MOMO public added
public  MaterialScratchTable msTable;
public   MaterialCombiTable mcTable;
    //MOMO test public instances
public  GGETableModel msDataModel, mcDataModel;
    // 2001 Jan 23 A and Z titles were inverted
  String msNames[] = {"Use","Name","Z","A","Density","Unit",
				"State","Temp"," Unit","Press","Unit "};
  String mcNames[] = {"Use","Name","Elements","Density","Unit",
				"State","Temp"," Unit","Press","Unit "};
  int msRow, msCol, mcRow, mcCol;
  boolean msCel, mcCel;

  JLabel label;
  private JMenuItem load, xmlload, save, xmlsave, append, clear, tOpen, tClose;
  private JFileChooser saveData, loadData;
  private String fileName, createFile, newFile;
  static String fileDir;

  public String workdirpath = ".";
  /* For OptionPane */
  //private JFrame frame1,frame2,frame3,frame4,frame5,frame6,frame7,frame8;

  public MaterialFrame() {
      super(); // JPanel
      et = new ElementsTable();

      //MOMO
      msDataModel = 	new GGETableModel(msNames,0);
    msTable = new MaterialScratchTable(msDataModel  , this);
     //				 = new GGETableModel(msNames,0)
    mcDataModel = 	new GGETableModel(mcNames,0);

    mcTable = new MaterialCombiTable(mcDataModel , this);
	     //		=	new GGETableModel(mcNames,0), this);
    //getContentPane().setLayout(new BorderLayout());
    //MOMO setModel here as a the empty table

    MaterialfileClear();

    setLayout(new BorderLayout());

    JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,true,
                 msTable.makeMaterialPanel(), mcTable.makeMaterialPanel());
    //MOMO
    add("North", createMenubar() );
    //getContentPane().add(splitPane, "Center");
    add(splitPane, "Center");
    //    setJMenuBar( createMenubar() );
    setSize(700,580);
    //pack();
    setVisible(true);

  }
  private JMenuBar createMenubar(){
      JMenu file, element;
      JMenuBar mb = new JMenuBar();

      file = new JMenu("File");
         file.add(load = new JMenuItem("Load a Material File"));
         file.add(xmlload = new JMenuItem("Load a Material XML File"));
         file.addSeparator();
         file.add(append = new JMenuItem("Append a Material File"));
         file.addSeparator();
         file.add(save = new JMenuItem("Save Material"));
         file.add(xmlsave = new JMenuItem("Save XML Material"));
         file.addSeparator();
         file.add(clear = new JMenuItem("Clear Material"));

      load.addActionListener(this);
      xmlload.addActionListener(this);
      append.addActionListener(this);
      save.addActionListener(this);
      xmlsave.addActionListener(this);
      clear.addActionListener(this);

      mb.add(file);

      element = new JMenu("Elements");
         element.add(tOpen = new JMenuItem("Open Periodic Table"));
         element.addSeparator();
         element.add(tClose = new JMenuItem("Close Periodic Table"));
      tOpen.addActionListener(this);
      tClose.addActionListener(this);

      mb.add(element);
      return mb;
  }

  public void actionPerformed(ActionEvent ae){
    Object o = ae.getSource();

    if( o == load ){MaterialfileLoad();}
    if( o == xmlload ){MaterialXMLfileLoad();}
    if( o == append ){MaterialfileAppend();}
    if( o == save ){MaterialfileSave();}
    if( o == xmlsave ){MaterialXMLfileSave();}
    if( o == clear ){MaterialfileClear();}
    if( o == tOpen ){
               et.setVisible(true);
    }
    if( o == tClose ){
               et.setVisible(false);
    }
  }

  private synchronized void resume(){
    notify();
  }

//DATA LOAD ,SAVE -------------------------------------------------
//Append
  void MaterialfileAppend(){
      JFileChooser loadData = new JFileChooser(workdirpath);
      loadData.cancelSelection();
      loadData.resetChoosableFileFilters();

     ExampleFileFilter mtFile = new ExampleFileFilter("g4mt","MaterialSource");
      loadData.setFileFilter(mtFile);
      loadData.setDialogTitle("Load Material");
      loadData.setMultiSelectionEnabled(true);
      if (loadData.showOpenDialog(this) != JFileChooser.APPROVE_OPTION ) return;
      File fml = loadData.getSelectedFile();
      fileName = fml.getPath();
      if (fml.isFile()) {
        resume();
        try{
          FileInputStream filein = new FileInputStream(fileName);
          ObjectInputStream objin =new ObjectInputStream(filein);
          Vector mtData = (Vector)objin.readObject();
          Vector msData =  (Vector)mtData.firstElement();
          Vector mcData =  (Vector)mtData.lastElement();

          if(msDataModel.getRowCount()==0 && msData.size()==0){
             //--patern 1--
          }else{
             //--patern 2--
             for(int i=0; i<msData.size(); i++){
               Vector ms = (Vector)msData.elementAt(i);
               msDataModel.addRow(ms);
             }
             repaint();
          }

          if(mcDataModel.getRowCount()==0 && mcData.size()==0){
              //--patern 3--
          }else{
              //--patern 4--
              for(int i=0; i<mcData.size(); i++){
               Vector mc = (Vector)mcData.elementAt(i);
               mcDataModel.addRow(mc);
              }
              repaint();
          }
          objin.close();
          repaint();
        }catch(Exception e){
          System.out.println(e.toString());
        }
      }else{
        System.out.println("error="+fml.toString()+"isNotaFile");
      }
      return;
  }


// Load
  void MaterialfileLoad(){
      JFileChooser loadData = new JFileChooser(workdirpath);
      loadData.cancelSelection();
      loadData.resetChoosableFileFilters();

     ExampleFileFilter mtFile = new ExampleFileFilter("g4mt","MaterialSource");
      loadData.setFileFilter(mtFile);
      loadData.setDialogTitle("Load Material");
      loadData.setMultiSelectionEnabled(true);
      if (loadData.showOpenDialog(this) != JFileChooser.APPROVE_OPTION) return;
      File fml = loadData.getSelectedFile();
      fileName = fml.getPath();
      if (fml.isFile()) {
        resume();
        try{
          FileInputStream filein = new FileInputStream(fileName);
          ObjectInputStream objin =new ObjectInputStream(filein);
          Vector mtData = (Vector)objin.readObject();
          Vector msData =  (Vector)mtData.firstElement();
          Vector mcData =  (Vector)mtData.lastElement();

          if(msDataModel.getRowCount()==0 && msData.size()==0){
             //--patern 1--
          }else{
             //--patern 2--
             msTable.setModel(msDataModel = new GGETableModel(msNames,0));
             for(int i=0; i<msData.size(); i++){
               Vector ms = (Vector)msData.elementAt(i);
               msDataModel.addRow(ms);
             }
             repaint();
          }

          if(mcDataModel.getRowCount()==0 && mcData.size()==0){
              //--patern 3--
          }else{
              //--patern 4--
              mcTable.setModel(mcDataModel = new GGETableModel(mcNames,0));
              for(int i=0; i<mcData.size(); i++){
               Vector mc = (Vector)mcData.elementAt(i);
               mcDataModel.addRow(mc);
              }
              repaint();
          }
          objin.close();
          repaint();
        }catch(Exception e){
          System.out.println(e.toString());
        }
      }else{
        System.out.println("error="+fml.toString()+"isNotaFile");
      }
      return;
  }

  void MaterialXMLfileLoad(){
    JFileChooser loadXML = new JFileChooser(workdirpath);
    ExampleFileFilter xmlFile = new ExampleFileFilter("xml", "XML Source");
    loadXML.setFileFilter(xmlFile);
    loadXML.setDialogTitle("Load XML");
    //loadXML.showOpenDialog(this);
    if(loadXML.showOpenDialog(this) != JFileChooser.APPROVE_OPTION) return;
    loadXML.setMultiSelectionEnabled(true);
    File fl = loadXML.getSelectedFile();
    //ElementItem el[] = et.makeElements();
    if (fl.isFile()){
      fileName = fl.getPath();
      workdirpath = fileName;
      try{
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        Document doc = builder.parse(new File(fileName));
        Element root = doc.getDocumentElement();
        NodeList nodelist = root.getChildNodes();
        Vector logStrData = new Vector();
        Vector logSldData = new Vector();
        Vector mtrScrData = new Vector();
        Vector mtrComData = new Vector();
        for(int i=0; i < nodelist.getLength(); i++ ){
          Node node = nodelist.item(i);
          NamedNodeMap attrs = node.getAttributes();
          if(attrs != null){
            if(node.getNodeName() == "materials"){
                                      NodeList mtrList = node.getChildNodes();
                        for(int j=0; j < mtrList.getLength(); j++){
                          Node mtrNode = mtrList.item(j);
                          String mtrName = mtrNode.getNodeName();
                          NamedNodeMap mtrAttrs = mtrNode.getAttributes();
                          if(mtrAttrs != null){
                           if( mtrName == "material"){
                //scratch materials
                            Node formulaNode = mtrAttrs.getNamedItem("formula");
                            if( formulaNode != null){
                              String dValue =""; String dUnit ="";
                              String aValue ="";
                              String tValue =""; String tUnit ="";
                              String pValue =""; String pUnit ="";
                              NodeList mtrCList = mtrNode.getChildNodes();
                              for(int k=0; k < mtrCList.getLength(); k++){
                                Node mtrCNode = mtrCList.item(k);
                                NamedNodeMap mtrCAttrs
                                                = mtrCNode.getAttributes();
                                if( mtrCAttrs != null){
                                  if(mtrCNode.getNodeName() == "D"){
                                    dValue = mtrCAttrs.getNamedItem("value")
                                                .getNodeValue();
                                    dUnit = mtrCAttrs.getNamedItem("unit")
                                                .getNodeValue();
                                  }else if(mtrCNode.getNodeName() =="atom"){
                                    aValue = mtrCAttrs.getNamedItem("value")
                                                .getNodeValue();
                                  }else if(mtrCNode.getNodeName() =="T"){
                                    tValue = mtrCAttrs.getNamedItem("value")
                                                .getNodeValue();
                                    tUnit = mtrCAttrs.getNamedItem("unit")
                                                .getNodeValue();
                                  }else if(mtrCNode.getNodeName() =="P"){
                                    pValue = mtrCAttrs.getNamedItem("value")
                                                .getNodeValue();
                                    pUnit = mtrCAttrs.getNamedItem("unit")
                                                .getNodeValue();
                                  }
                                }
                              }
                              Vector mtrData = new Vector();
                              String stateStr
                              = mtrAttrs.getNamedItem("state").getNodeValue();
                              String state ="";
                              if(stateStr=="unknown"){
                                state = MaterialItem.stateCode[0];
                              }else if(stateStr.equals("solid")){
                                state = MaterialItem.stateCode[1];
                              }else if(stateStr.equals("liquid")){
                                state = MaterialItem.stateCode[2];
                              }else if(stateStr.equals("gas")){
                                state = MaterialItem.stateCode[3];
                              }else{ state = MaterialItem.stateCode[0]; }

                              mtrData.addElement("Used");
                              mtrData.addElement(mtrAttrs.getNamedItem("name").getNodeValue());
                              mtrData.addElement(mtrAttrs.getNamedItem("Z").getNodeValue());
                              mtrData.addElement(aValue);
                              mtrData.addElement(dValue);
                              mtrData.addElement(dUnit);
                              mtrData.addElement(state);
                              mtrData.addElement(tValue);
                              mtrData.addElement(tUnit);
                              mtrData.addElement(pValue);
                              mtrData.addElement(pUnit);
                              mtrScrData.addElement(mtrData);
                            }else{
                //combination materials
                              String dValue =""; String dUnit ="";
                              String tValue =""; String tUnit ="";
                              String pValue =""; String pUnit ="";
                              Vector elemV = new Vector();
                              //et = new ElementsTable();
                              NodeList mtrCList = mtrNode.getChildNodes();
                              for(int k=0; k < mtrCList.getLength(); k++){
                                Node mtrCNode = mtrCList.item(k);
                                NamedNodeMap mtrCAttrs
                                                = mtrCNode.getAttributes();
                                if( mtrCAttrs != null){
                                  if(mtrCNode.getNodeName() == "D"){
                                    dValue = mtrCAttrs.getNamedItem("value")
                                                .getNodeValue();
                                    dUnit = mtrCAttrs.getNamedItem("unit")
                                                .getNodeValue();
                                  }else if(mtrCNode.getNodeName() =="T"){
                                    tValue = mtrCAttrs.getNamedItem("value")
                                                .getNodeValue();
                                    tUnit = mtrCAttrs.getNamedItem("unit")
                                                .getNodeValue();
                                  }else if(mtrCNode.getNodeName() =="P"){
                                    pValue = mtrCAttrs.getNamedItem("value")
                                                .getNodeValue();
                                    pUnit = mtrCAttrs.getNamedItem("unit")
                                                .getNodeValue();
                                  }else{
                                    Vector v = new Vector();
                                    v.addElement(mtrCNode.getNodeName());
                                    v.addElement(mtrCAttrs.getNamedItem("n").getNodeValue());
                                    v.addElement(mtrCAttrs.getNamedItem("ref").getNodeValue());
                                    elemV.addElement(v);
                                  }
                                }
                              }
                              RatioItem ratioItem;
                              int isfraction = 0;
                              int num = 0;
                              float ratioNum[] = new float[elemV.size()];
                              eic = new ElementItem[elemV.size()];
                              for(int k=0; k < elemV.size(); k++){
                                String fraction = ((Vector)elemV
                                        .elementAt(k)).elementAt(0).toString();
                                String elem = ((Vector)elemV
                                        .elementAt(k)).elementAt(2).toString();
                                String ratioStr = ((Vector)elemV
                                        .elementAt(k)).elementAt(1).toString();
                                ratioNum[k] = Float.valueOf(ratioStr)
                                                                .floatValue();
                                for(int l=0; l < 104; l++){
                                   if( et.getSymbol(l).equals(elem) ){
                                        eic[num] = et.getElement(l);
                                        num++;
                                   }
                                }
                                if(fraction=="fraction"){ isfraction=1; }
                                else if(fraction=="composite"){ isfraction=0; }
                              }
                              ratioItem = new RatioItem(eic);
                              //for(int a=0; a < ratioNum.length; a++){
                              //}
                              ratioItem.ratio = ratioNum;
                              ratioItem.isEmpty = false;
                              ratioItem.isFraction = isfraction;

                              Vector mtrData = new Vector();
                              mtrData.addElement("Used");
                              mtrData.addElement(mtrAttrs.getNamedItem("name").getNodeValue());
                              mtrData.addElement(ratioItem);
                              mtrData.addElement(dValue);
                              mtrData.addElement(dUnit);
                              mtrData.addElement("kStateUndefined");
                              mtrData.addElement(tValue);
                              mtrData.addElement(tUnit);
                              mtrData.addElement(pValue);
                              mtrData.addElement(pUnit);
                              mtrComData.addElement(mtrData);

                            }
                           }
                          }
                        }
                      }
                   }
                }
        //ScratchMaterials
                MaterialfileClear();
                for(int j=0; j < mtrScrData.size(); j++){
                  Vector scratch = (Vector)mtrScrData.elementAt(j);
                  msDataModel.addRow(scratch);
                }
        //CombiMaterials
                for(int j=0; j < mtrComData.size(); j++){
                  Vector combi = (Vector)mtrComData.elementAt(j);
                  mcDataModel.addRow(combi);
                }
      }catch(Exception e){ e.printStackTrace(); }
    }else{
        System.out.println("error="+fl.toString()+"isNotaFile");
    }
    return;
  }


/* --Save-------------------------------- */
  void MaterialfileSave(){
     JFileChooser saveData = new JFileChooser(workdirpath);
     ExampleFileFilter mtFile = new ExampleFileFilter("g4mt","MaterialSource");
     saveData.setFileFilter(mtFile);
     saveData.setDialogTitle("Save Material");
     if ( saveData.showSaveDialog(this) != JFileChooser.APPROVE_OPTION) return;
     File fms = saveData.getSelectedFile();
     fileName = fms.getPath();
     if (fileName != null){
       try{
         FileOutputStream fileout = new FileOutputStream(fileName);
         ObjectOutputStream objout = new ObjectOutputStream(fileout);
         Vector mtVector = new Vector();
         Vector msVector = new Vector();
//         Object mtsave[] = new Object[1];
//         mtsave[0] = "";
//         for (int i=0; i<msTable.getRowCount(); i++){
//          msTable.setValueAt(mtsave[0],i,0);
//         }
//         for (int i=0; i<mcTable.getRowCount(); i++){
//          mcTable.setValueAt(mtsave[0],i,0);
//         }
         mtVector.addElement((Object)msDataModel.getDataVector());
         mtVector.addElement((Object)mcDataModel.getDataVector());
         objout.writeObject(mtVector);
         objout.flush();
         fileout.close();
       }catch(IOException e){ System.out.println(e.getMessage()); }
         return;
     }
     if ( fileName == null){
       return;
    }
  }

//XMLSave
  void MaterialXMLfileSave(){
    JFileChooser saveXML = new JFileChooser(workdirpath);
    ExampleFileFilter xmlFile = new ExampleFileFilter("xml","XML Source");
    saveXML.setFileFilter(xmlFile);
    saveXML.setDialogTitle("Save XML");
    if(saveXML.showSaveDialog(this) != JFileChooser.APPROVE_OPTION) return;

    VolumesFrame volframe = new VolumesFrame();
    StringBuffer xml = new StringBuffer();
    xml.append(volframe.headerXML());
    xml.append(getXML());
    xml.append("</gdml>");

      File fs = saveXML.getSelectedFile();
      fileName = fs.getPath();
        if (fileName != null){
           try{
                FileOutputStream fileout = new FileOutputStream(fileName);
                PrintWriter outf = new PrintWriter(new DataOutputStream(fileout));
                outf.println(xml.toString());
                outf.close();
         }catch(IOException e){ System.out.println(e.getMessage());}
                return;
      }
      if (fileName == null){ return;}
   }





//Clear
  void MaterialfileClear(){
    msTable.setModel(msDataModel = new GGETableModel(msNames,0));
    mcTable.setModel(mcDataModel = new GGETableModel(mcNames,0));
  }

/* Material APPEND , INSERT , DELETE(START)------------------------- 8.10 */
//----------------Start the Append 8.10
  void appendMC(){     
   //ElementItem[] eic = et.getSelectedElements();
   eic = et.getSelectedElements();
   if (eic == null){
     //frame1 = new JFrame();
     //JOptionPane.showMessageDialog(frame1, "Choose Elements by Opening the PeriodicTable","Warning Dialog", JOptionPane.WARNING_MESSAGE);
     return;
   }else{
     Object tmp[] = new Object[10];
      tmp[0] = "Used";
      tmp[1] = "";
      tmp[2] = new RatioItem(eic);
      tmp[3] = "";
      tmp[4] = "g/cm3";
      tmp[5] = "kStateUndefined";
      tmp[6] = "273.15";
      tmp[7] = "kelvin";
      tmp[8] = "1.0";
      tmp[9] = "atmosphere";
     mcDataModel.addRow(tmp);
   }  
  }
  void appendMS(){
   ElementItem[] eis = et.getSelectedElements();
    if (eis == null){
     //frame2 = new JFrame();
     //JOptionPane.showMessageDialog(frame2, "Choose a Element by Opening the Periodic Table","Warning Dialog", JOptionPane.WARNING_MESSAGE);

       return;
    }else{
     Object tmp[] = new Object[11];
      tmp[0] = "Used";
      tmp[1] = new String(eis[0].name);
      tmp[2] = new Integer(eis[0].atomNum);
      tmp[3] = new Double(eis[0].massNum);
      tmp[4] = "";
      tmp[5] = "g/cm3";
      tmp[6] = "kStateUndefined";
      tmp[7] = "273.15";
      tmp[8] = "kelvin";
      tmp[9] = "1.0";
      tmp[10] = "atmosphere";
     msDataModel.addRow(tmp);
    }
  }

// ------------ Start the Insert Material 8.10 ---------
  void insertMS(){
   ElementItem[] eis = et.getSelectedElements();

   msRow = msTable.getSelectedRow();
   msCol = msTable.getSelectedColumn();
   msCel = msTable.isCellSelected(msRow, msCol);

   if (eis == null){
     //frame3 = new JFrame();
     //JOptionPane.showMessageDialog(frame3, "Choose a Element by Opening the Periodic Table","Warning Dialog", JOptionPane.WARNING_MESSAGE);

     return;
   }else{
     if(msCel){
       Object tmp[] = new Object[11];
        tmp[0] = "Used";
        tmp[1] = new String(eis[0].name);
        tmp[2] = new Integer(eis[0].atomNum);
        tmp[3] = new Double(eis[0].massNum);
        tmp[4] = "";
        tmp[5] = "g/cm3";
        tmp[6] = "kStateUndefined";
        tmp[7] = "273.15";
        tmp[8] = "kelvin";
        tmp[9] = "1.0";
        tmp[10] = "atmosphere";
        int msRowCount = msTable.getSelectedRow()+1;
        msDataModel.insertRow(msRowCount,tmp);
     }if(!msCel){
       JOptionPane opane = new JOptionPane();
       opane.showMessageDialog(this, "Choose the MaterialName","Warning Dialog", JOptionPane.WARNING_MESSAGE);
       JDialog dialog = opane.createDialog(this, "Warning Dialog");
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////
     }
   }
  }
  void insertMC(){
   ElementItem[] eic = et.getSelectedElements();
   mcRow = mcTable.getSelectedRow();
   mcCol = mcTable.getSelectedColumn();
   mcCel = mcTable.isCellSelected(mcRow, mcCol);

   if (eic == null){
     //frame5 = new JFrame();
     //JOptionPane.showMessageDialog(frame5, "Choose Elements by Opening the Periodic Table","Warning Dialog", JOptionPane.WARNING_MESSAGE);
     return;
   }else{
     if(mcCel){
       Object tmp[] = new Object[10];
        tmp[0] = "Used";
        tmp[1] = "";
        tmp[2] = new RatioItem(eic);
        tmp[3] = "";
        tmp[4] = "g/cm3";
        tmp[5] = "kStateUndefined";
        tmp[6] = "273.15";
        tmp[7] = "kelvin";
        tmp[8] = "1.0";
        tmp[9] = "atmosphere";
      int mcRowCount = mcTable.getSelectedRow()+1;
      mcDataModel.insertRow(mcRowCount,tmp);
     }if(!mcCel){
       JOptionPane opane = new JOptionPane();
       opane.showMessageDialog(this, "Choose the MaterialName","Warning Dialog", JOptionPane.WARNING_MESSAGE);
       JDialog dialog = opane.createDialog(this, "Warning Dialog");
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////
     }
   }
  }
//----------------------DELETE (Start DELL 8.10)------------------
  void dellMS(){
     msRow = msTable.getSelectedRow();
     msCol = msTable.getSelectedColumn();
     msCel = msTable.isCellSelected(msRow, msCol);


     if(!msCel){
       JOptionPane opane = new JOptionPane();
       opane.showMessageDialog(this, "Choose the MaterialName","Warning Dialog", JOptionPane.WARNING_MESSAGE);
       JDialog dialog = opane.createDialog(this, "Warning Dialog");
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////
      
       msTable.dellMatCloseAct();      
     }else if(msCel){
      msTable.stopEditing();
      //msDataModel.removeRow(msTable.getSelectedRow());
      msDataModel.removeRow(msRow);
      //dellScratch = new DellScratchDialog(this);
      msTable.dellMatCloseAct();      
      repaint();
      //dellScratch.setVisible(false);
     }   
  }
  void dellMC(){
     mcRow = mcTable.getSelectedRow();
     mcCol = mcTable.getSelectedColumn();
     mcCel = mcTable.isCellSelected(mcRow, mcCol);

     if(!mcCel){
       JOptionPane opane = new JOptionPane();
       opane.showMessageDialog(this, "Choose the MaterialName","Warning Dialog", JOptionPane.WARNING_MESSAGE);
       JDialog dialog = opane.createDialog(this, "Warning Dialog");
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////
      mcTable.dellMatCloseAct();
     }else if(mcCel){
      mcTable.stopEditing();
      //mcDataModel.removeRow(mcTable.getSelectedRow());
      mcDataModel.removeRow(mcRow);
      //dellCombi = new DellCombiDialog(this);
      mcTable.dellMatCloseAct();
      repaint();
      //dellCombi.setVisible(false);
     }
  } 
/* Material APPEND , INSERT , DELETE(END)--------------------------- 8.10 */

 public void stopEditing(){
   msTable.stopEditing();
   mcTable.stopEditing();
 }


//Data Load Method
  void setLoadData(Vector materialData){
    GGEItem item;
  }

  void scratchSelected(){
    mcTable.stopEditing();
  }
  void combiSelected(){
    msTable.stopEditing();
  }
  public void windowIconified(WindowEvent event){
    et.setVisible(false);
    msTable.stopEditing();
    mcTable.stopEditing();
  }
  public void windowDeiconified(WindowEvent event){
    et.setVisible(true);
  }

//------- C++ source code ------------------------------------
  public String getCPP(){
    StringBuffer smatcpp = new StringBuffer("\n// Materials from Scratch\n\n");
//MOMO make some action to the mat frame
   stopEditing();

   repaint(); msTable.repaint();mcTable.repaint();
    Vector data = msDataModel.getDataVector();
    Vector rowData;
    //DEBUG MOMO
    //System.out.println("##############getCPP mat data size");
    // System.out.println(data.size());  //????? why this is zero?

// Density must be checked before generating C++ code. 8.13 not yet!!

    for (int i=0; i<data.size(); i++){
      rowData = (Vector)data.elementAt(i);
      if(!rowData.elementAt(0).equals("Used")){
//MOMO
	  //System.out.println("##############Next un-used element");
//Use G4 Units
      }else if(rowData.elementAt(0).equals("Used")){
       smatcpp.append("G4Material* " + rowData.elementAt(1) 
		+ " = new G4Material(\"" + rowData.elementAt(1)
		+ "\", " +rowData.elementAt(2) 
		+ ", " + rowData.elementAt(3) + "*g/mole, " 
                + rowData.elementAt(4)+"*" +rowData.elementAt(5)+","
                +rowData.elementAt(6));
       if (!rowData.elementAt(7).toString().equals("")){
	    smatcpp.append(", "+ rowData.elementAt(7)
                    + "*" + rowData.elementAt(8));
	 if (!rowData.elementAt(9).toString().equals("")){
	    smatcpp.append(", "+rowData.elementAt(9)+"*"
                    +rowData.elementAt(10));
	 }
      }
      smatcpp.append(" );\n");
     }
    }
    StringBuffer cmatcpp = new StringBuffer("\n// Materials from Combination\n\n");
    data = mcDataModel.getDataVector();
    Vector elements = new Vector();

    for (int i=0; i<data.size(); i++){
      rowData = (Vector)data.elementAt(i);
      if(!rowData.elementAt(0).equals("Used")){
//       System.out.println("Next");
      }else if(rowData.elementAt(0).equals("Used")){
       RatioItem rate = (RatioItem)rowData.elementAt(2);
       String name = (String)rowData.elementAt(1);
       cmatcpp.append("G4Material* " + name + " = new G4Material(\"" + name 
		 + "\",  " + rowData.elementAt(3)
		 +"*"+rowData.elementAt(4)+", "+ rate.getLength() + ", " 
                 + rowData.elementAt(5));
       if (!rowData.elementAt(6).toString().equals("")){
	 cmatcpp.append(", "+rowData.elementAt(6)+"*"
                      +rowData.elementAt(7));
	 if (!rowData.elementAt(8).toString().equals("")){
	  cmatcpp.append(", "+rowData.elementAt(8)+"*"+rowData.elementAt(9));
	 }
       }
       cmatcpp.append(" );\n");
       cmatcpp.append(rate.getCPP(name));
       for (int j=0; j<rate.elems.length; j++){
	if (!elements.contains(rate.elems[j])) elements.addElement(rate.elems[j]);
      }
     }
    }
    StringBuffer elecpp = new StringBuffer("// Elements\n");
    for (int i=0; i<elements.size(); i++){
      elecpp.append(((ElementItem)elements.elementAt(i)).getCPP());
    }
    elecpp.append(cmatcpp.toString());
    elecpp.append(smatcpp.toString());
    return elecpp.toString();
  }


    // XML test
  String getXML(){
    stopEditing();
    StringBuffer smatxml = new StringBuffer("\n     <!--Materials from Scratch-->\n");
//MOMO make some action to the mat frame
   repaint(); msTable.repaint();mcTable.repaint();
    Vector data = msDataModel.getDataVector();
    Vector rowData;
    //DEBUG MOMO
    //   System.out.println("##############getXML mat data size");
    //   System.out.println(data.size());  //????? why this is zero?

// Density must be checked before generating XML code. 8.13 not yet!!

    //<!---Material from Combination--->
    StringBuffer cmatxml = new StringBuffer("\n     <!--Materials from Combination-->\n");
    data = mcDataModel.getDataVector();
    Vector msdata = msDataModel.getDataVector();
    Vector msrowData;
    Vector elements = new Vector();

    for (int i=0; i<data.size(); i++){
      rowData = (Vector)data.elementAt(i);
      if(!rowData.elementAt(0).equals("Used")){
      }else if(rowData.elementAt(0).equals("Used")){
       RatioItem rate = (RatioItem)rowData.elementAt(2);
       String name = (String)rowData.elementAt(1);
       cmatxml.append("     <material name=\"" + name + "\">\n"
                    + "         <D type=\"denstiy\""
                                +" value=\"" + rowData.elementAt(3) + "\" "
                                +"unit=\""+rowData.elementAt(4)+ "\"/>\n"
                    + "         <T type=\"temperature\""
                                +" value=\"" + rowData.elementAt(6) + "\""
                                +" unit=\"" +rowData.elementAt(7) + "\"/>\n"
                    + "         <P type=\"pascal\""
                                +" value=\"" + rowData.elementAt(8) + "\""
                                +" unit=\"" +rowData.elementAt(9) + "\"/>\n");

       cmatxml.append(rate.getXML(name));
       cmatxml.append("     </material>\n");
       for (int j=0; j<rate.elems.length; j++){
        if (!elements.contains(rate.elems[j])) elements.addElement(rate.elems[j]);
      }
     }
    }
    StringBuffer elexml = new StringBuffer("  <materials>\n");
    elexml.append("     <!--Elements-->\n");
    for (int i=0; i<elements.size(); i++){
      elexml.append(((ElementItem)elements.elementAt(i)).getXML());
    }

 for (int i=0; i<msdata.size(); i++){
      msrowData = (Vector)msdata.elementAt(i);
      String state = getState((msrowData.elementAt(6)));
      if(!msrowData.elementAt(0).equals("Used")){
         //System.out.println("##############Next un-used element");
      }else if(msrowData.elementAt(0).equals("Used")){
        smatxml.append("     <material name=\"" + msrowData.elementAt(1)
                + "\" formula=\"" + msrowData.elementAt(1)
                + "\" Z=\"" +msrowData.elementAt(2)
                + "\" N=\"" +msrowData.elementAt(3)
                + "\" state=\"" + state
                + "\">\n"
                +"      <D type=\"density\" value=\"" +msrowData.elementAt(4)
                +          "\" unit=\"" +msrowData.elementAt(5)+ "\"/>\n"
                +"      <atom type=\"A\" value=\"" + msrowData.elementAt(3)+ "\"/>\n"
                +"      <T type=\"temperature\""
                        +" value=\"" +msrowData.elementAt(7)+"\""
                        +" unit=\"" +msrowData.elementAt(8)+"\"/>\n"
                +"      <P type=\"pascal\""
                        +" value=\"" +msrowData.elementAt(9)+"\""
                        +" unit=\"" +msrowData.elementAt(10)+ "\"/>\n"
                +"     </material>\n");
        //elexml.append()
      }
  }

    elexml.append(cmatxml.toString());
    elexml.append(smatxml.toString());
    elexml.append("  </materials>\n");
    return elexml.toString();
 }

 String getState(Object o){
        String state =" ";
        String s = o.toString();
        if(s.equals(MaterialItem.stateCode[0])){state = "unknown";}
        else if(s.equals(MaterialItem.stateCode[1])){state = "solid";}
        else if(s.equals(MaterialItem.stateCode[2])){state = "liquid";}
        else if(s.equals(MaterialItem.stateCode[3])){state = "gas";}
        else{ state = "unknown";}
        return state;

  }
}
