//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// G4 Process: Low-energy Elastic scattering
// F.W. Jones, TRIUMF, 04-JUN-96
// 
// This is a prototype of a low-energy elastic scattering process.
// At present it just uses some GEANT3.21/GHEISHA code, translated
// to C++ methods, to calculate cross sections and scattering events.
// Eventually these methods will be replaced by ones that are more 
// accurate in the low-energy region (< 3GeV).

// Modified by FWJ 03-DEC-96: uses G4LCrossSectionData
// Modified by FWJ    FEB-97: adapted to new tracking design
// Modified by FWJ    MAR-97: newer new tracking design
//
// Modified by FWJ 27-MAR-97: first version for Alpha release
// 20-JUN-97 FWJ: added check for zero cross section
//
// 14-APR-98 FWJ: variant G4HadronElastic process for
// G4CrossSectionDataSet/DataStore class design.
// 29-JUN-98 FWJ: default data set G4HadronCrossSections
// design re-done JPW 2003.
// 01-SEP-2008 V.Ivanchenko: use methods from the base class


#include "G4HadronElasticProcess.hh"
#include "G4HadronElasticDataSet.hh"
#include <iostream>

 
G4HadronElasticProcess::G4HadronElasticProcess(const G4String& processName) : 
  G4HadronicProcess(processName)
{
  SetProcessSubType(fHadronElastic);
  AddDataSet(new G4HadronElasticDataSet());
}


G4HadronElasticProcess::~G4HadronElasticProcess()
{}

 
G4bool 
G4HadronElasticProcess::IsApplicable(const G4ParticleDefinition& aParticleType)
{
  return (aParticleType == *(G4PionPlus::PionPlus()) ||
          aParticleType == *(G4PionZero::PionZero()) ||
          aParticleType == *(G4PionMinus::PionMinus()) ||
          aParticleType == *(G4KaonPlus::KaonPlus()) ||
          aParticleType == *(G4KaonZeroShort::KaonZeroShort()) ||
          aParticleType == *(G4KaonZeroLong::KaonZeroLong()) ||
          aParticleType == *(G4KaonMinus::KaonMinus()) ||
          aParticleType == *(G4Proton::Proton()) ||
          aParticleType == *(G4AntiProton::AntiProton()) ||
          aParticleType == *(G4Neutron::Neutron()) ||
          aParticleType == *(G4AntiNeutron::AntiNeutron()) ||
          aParticleType == *(G4Lambda::Lambda()) ||
          aParticleType == *(G4AntiLambda::AntiLambda()) ||
          aParticleType == *(G4SigmaPlus::SigmaPlus()) ||
          aParticleType == *(G4SigmaZero::SigmaZero()) ||
          aParticleType == *(G4SigmaMinus::SigmaMinus()) ||
          aParticleType == *(G4AntiSigmaPlus::AntiSigmaPlus()) ||
          aParticleType == *(G4AntiSigmaZero::AntiSigmaZero()) ||
          aParticleType == *(G4AntiSigmaMinus::AntiSigmaMinus()) ||
          aParticleType == *(G4XiZero::XiZero()) ||
          aParticleType == *(G4XiMinus::XiMinus()) ||
          aParticleType == *(G4AntiXiZero::AntiXiZero()) ||
          aParticleType == *(G4AntiXiMinus::AntiXiMinus()) ||
          aParticleType == *(G4Deuteron::Deuteron()) ||
          aParticleType == *(G4Triton::Triton()) ||
          aParticleType == *(G4Alpha::Alpha()) ||
          aParticleType == *(G4OmegaMinus::OmegaMinus()) ||
          aParticleType == *(G4AntiOmegaMinus::AntiOmegaMinus()));
}


void G4HadronElasticProcess::ProcessDescription(std::ostream& outFile) const
{
  outFile << "This process handles the elastic scattering of hadrons by\n"
          << "invoking one or more hadronic models and one or more hadronic\n"
          << "cross sections.\n";
}
