//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: G4CascadeSigmaMinusPChannel.cc,v 1.6 2010-12-15 07:40:39 gunter Exp $
//
// 20100804  M. Kelsey -- Add name string to ctor
// 20110719  M. Kelsey -- Add initial state code to ctor
// 20110725  M. Kelsey -- Instantiate cross-section object for self-registration
// 20110916  M. Kelsey -- Drop self-registration due to platform inconsistencies

#include "G4CascadeSigmaMinusPChannel.hh"
#include "G4InuclParticleNames.hh"
using namespace G4InuclParticleNames;

namespace {
  // Outgoing particle types of a given multiplicity

  static const G4int smp2bfs[3][2] =
    {{1,27}, {2,21}, {2,25}};

  static const G4int smp3bfs[12][3] =
    {{1,2,13}, {2,2,17}, {2,7,21}, {1,5,21},  {2,5,23},  {2,7,25},
     {1,5,25}, {1,7,27}, {2,3,27}, {2,15,29}, {1,15,31}, {2,11,31}};  

  static const G4int smp4bfs[33][4] =
    {{1,1,5,13},   {1,2,7,13},   {1,2,5,17},   {2,2,3,13},   {2,2,7,17},   
     {1,5,7,21},   {2,7,7,21},   {2,3,5,21},   {1,13,15,21}, {2,11,13,21}, 
     {2,15,17,21}, {1,5,5,23},   {2,5,7,23},   {2,13,15,23}, {1,5,7,25},   
     {2,7,7,25},   {2,3,5,25},   {1,13,15,25}, {2,11,13,25}, {2,15,17,25}, 
     {1,7,7,27},   {1,3,5,27},   {2,3,7,27},   {1,15,17,27}, {1,11,13,27}, 
     {2,11,17,27}, {2,7,15,29},  {2,5,11,29},  {1,5,15,29},  {2,7,11,31},
     {2,3,15,31},  {1,5,11,31},  {1,7,15,31}};

  static const G4int smp5bfs[59][5] =
    {{1,1,5,7,13},   {1,1,5,5,17},   {1,2,7,7,13},   {1,2,3,5,13}, 
     {1,2,5,7,17},   {2,2,3,7,13},   {2,2,7,7,17},   {2,2,3,5,17}, 
     {1,5,7,7,21},   {1,3,5,5,21},   {2,7,7,7,21},   {2,3,5,7,21},
     {1,5,11,13,21}, {1,7,13,15,21}, {1,5,15,17,21}, {2,7,11,13,21}, 
     {2,5,11,17,21}, {2,3,13,15,21}, {2,7,15,17,21}, {1,5,5,7,23}, 
     {2,5,7,7,23},   {2,3,5,5,23},   {1,5,13,15,23}, {2,7,13,15,23},
     {2,5,15,17,23}, {2,5,11,13,23}, {1,5,7,7,25},   {1,3,5,5,25}, 
     {2,7,7,7,25},   {2,3,5,7,25},   {1,5,11,13,25}, {1,7,13,15,25}, 
     {1,5,15,17,25}, {2,7,11,13,25}, {2,5,11,17,25}, {2,3,13,15,25}, 
     {2,7,15,17,25}, {1,7,7,7,27},   {1,3,5,7,27},   {2,3,7,7,27}, 
     {2,3,3,5,27},   {1,7,11,13,27}, {1,5,11,17,27}, {1,7,15,17,27}, 
     {1,3,13,15,27}, {2,7,11,17,27}, {2,3,11,13,27}, {2,3,15,17,27}, 
     {2,7,7,15,29},  {2,3,5,15,29},  {2,5,7,11,29},  {1,5,7,15,29}, 
     {1,5,5,11,29},  {2,7,7,11,31},  {2,3,5,11,31},  {2,3,7,15,31}, 
     {1,7,7,15,31},  {1,3,5,15,31},  {1,5,7,11,31}};  

  static const G4int smp6bfs[30][6] =
    {{1,1,5,7,7,13}, {1,1,3,5,5,13}, {1,1,5,5,7,17},
     {1,2,7,7,7,13}, {1,2,3,5,7,13}, {1,2,5,7,7,17}, 
     {1,2,3,5,5,17}, {2,2,3,7,7,13}, {2,2,3,3,5,13}, 
     {2,2,7,7,7,17}, {2,2,3,5,7,17}, {1,5,7,7,7,21},
     {1,3,5,5,7,21}, {2,7,7,7,7,21}, {2,3,5,7,7,21},
     {2,3,3,5,5,21}, {1,5,5,7,7,23}, {1,3,5,5,5,23},
     {2,5,7,7,7,23}, {2,3,5,5,7,23}, {1,5,7,7,7,25},
     {1,3,5,5,7,25}, {2,7,7,7,7,25}, {2,3,5,7,7,25},
     {2,3,3,5,5,25}, {1,7,7,7,7,27}, {1,3,5,7,7,27},
     {1,3,3,5,5,27}, {2,3,7,7,7,27}, {2,3,3,5,7,27}}; 

  static const G4int smp7bfs[20][7] =
    {{1,1,5,7,7,7,13}, {1,1,3,5,5,7,13}, {1,1,5,5,7,7,17}, 
     {1,1,3,5,5,5,17}, {1,2,7,7,7,7,13}, {1,2,3,5,7,7,13}, 
     {1,2,3,3,5,5,13}, {1,2,5,7,7,7,17}, {1,2,3,5,5,7,17},
     {2,2,3,7,7,7,13}, {2,2,3,3,5,7,13}, {2,2,7,7,7,7,17},
     {2,2,3,5,7,7,17}, {2,2,3,3,5,5,17}, {1,5,7,7,7,7,21},
     {1,3,5,5,7,7,21}, {1,3,3,5,5,5,21}, {2,7,7,7,7,7,21},
     {2,3,5,7,7,7,21}, {2,3,3,5,5,7,21}};

  // Cross sections for S- p -> 2-7 body final states
  // 
  // first index:    0-2: channels for mult = 2
  //                3-14: channels for mult = 3 
  //               15-47: channels for mult = 4
  //              48-106: channels for mult = 5
  //             107-136: channels for mult = 6
  //             137-156: channels for mult = 7
  //
  // second index: kinetic energy
  // 
  static const G4double smpCrossSections[157][31] = {
    //
    // multiplicity 2 (3 channels)
    //
    // S- p
    {267., 84.5, 51.6, 43.7, 35.8, 27.9, 19.96,12.06, 9.90, 9.76,
     9.62, 8.66, 8.08, 7.50, 7.10, 6.60,  6.20, 5.80, 5.48, 5.32,
     5.16, 5.08, 4.92, 4.76, 4.58, 4.42,  4.26, 4.18, 4.16, 4.14, 3.94},

    // L n
    {170., 49.2, 31.0, 26.8, 22.6, 18.4, 14.27,10.09, 8.90, 8.76,  
     8.62, 7.32, 6.03, 4.70, 3.20, 1.60,  0.80, 0.60, 0.56, 0.54,
     0.52, 0.51, 0.49, 0.47, 0.46, 0.44,  0.42, 0.41, 0.41, 0.41, 0.38},
 
    // S0 n
    {500., 59.0, 32.0, 27.6, 23.3, 18.9, 14.51,10.14, 8.90, 8.76,
     8.62, 7.32, 6.03, 4.70, 3.20, 1.60,  0.80, 0.60, 0.56, 0.54,
     0.52, 0.51, 0.49, 0.47, 0.46, 0.44,  0.42, 0.41, 0.41, 0.41, 0.38},

    //
    //  multiplicity 3 (12 channels)
    //
    // p n K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.07, 0.27, 1.00, 1.20, 1.00, 0.85, 0.69, 0.64, 0.56,
      0.51, 0.46, 0.41, 0.36, 0.31, 0.26, 0.21, 0.16, 0.14, 0.13, 0.05},
 
    // n n K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.07, 0.27, 1.00, 1.20, 1.00, 0.85, 0.69, 0.64, 0.56,
      0.51, 0.46, 0.41, 0.36, 0.31, 0.26, 0.21, 0.16, 0.14, 0.13, 0.05},
 
    // L n pi0
    { 0.0,  0.0,  0.0,  0.4,  0.8,  1.1,  1.52, 1.90, 2.10, 2.24,
      2.38, 3.54, 3.46, 3.00, 2.60, 2.20, 1.80, 1.46, 1.33, 1.21,
      1.06, 0.95, 0.85, 0.75, 0.65, 0.54, 0.44, 0.33, 0.30, 0.28, 0.11},
 
    // L p pi-
    { 0.0,  0.0,  0.0,  0.4,  0.8,  1.1,  1.52, 1.90, 2.10, 2.24,
      2.38, 3.54, 3.46, 3.00, 2.60, 2.20, 1.80, 1.46, 1.33, 1.21,
      1.06, 0.95, 0.85, 0.75, 0.65, 0.54, 0.44, 0.33, 0.30, 0.28, 0.11},
 
    // S+ n pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.03, 0.06,
      0.10, 0.35, 0.65, 1.00, 0.90, 0.70, 0.60, 0.49, 0.44, 0.40,
      0.36, 0.33, 0.29, 0.25, 0.21, 0.17, 0.14, 0.11, 0.10, 0.09, 0.04},
 
    // S0 n pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.03, 0.06,
      0.10, 0.35, 0.65, 1.00, 0.90, 0.70, 0.60, 0.49, 0.44, 0.40,
      0.36, 0.33, 0.29, 0.25, 0.21, 0.17, 0.14, 0.11, 0.10, 0.09, 0.04},
 
    // S0 p pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.03, 0.06,
      0.10, 0.35, 0.65, 1.00, 0.90, 0.70, 0.60, 0.49, 0.44, 0.40,
      0.36, 0.33, 0.29, 0.25, 0.21, 0.17, 0.14, 0.11, 0.10, 0.09, 0.04},
  
    // S- p pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.03, 0.06,
      0.10, 0.35, 0.65, 1.00, 0.90, 0.70, 0.60, 0.49, 0.44, 0.40,
      0.36, 0.33, 0.29, 0.25, 0.21, 0.17, 0.14, 0.11, 0.10, 0.09, 0.04},
 
    // S- n pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.03, 0.06,
      0.10, 0.35, 0.65, 1.00, 0.90, 0.70, 0.60, 0.49, 0.44, 0.40,
      0.36, 0.33, 0.29, 0.25, 0.21, 0.17, 0.14, 0.11, 0.10, 0.09, 0.04},

    // X0 n K0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02,
      0.02, 0.01, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X- p K0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02,
      0.02, 0.01, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X- n K+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02,
      0.02, 0.01, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0},

    //
    //  multiplicity 4 (33 channels)
    //
    // p p K- pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.08, 0.11, 0.19, 0.32, 0.47, 0.49, 0.46, 0.44,
      0.43, 0.41, 0.40, 0.38, 0.37, 0.36, 0.35, 0.34, 0.34, 0.33, 0.29},
 
    // p n K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.08, 0.11, 0.19, 0.32, 0.47, 0.49, 0.46, 0.44,
      0.43, 0.41, 0.40, 0.38, 0.37, 0.36, 0.35, 0.34, 0.34, 0.33, 0.29},

    // p n K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.08, 0.11, 0.19, 0.32, 0.47, 0.49, 0.46, 0.44,
      0.43, 0.41, 0.40, 0.38, 0.37, 0.36, 0.35, 0.34, 0.34, 0.33, 0.29},
 
    // n n K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.08, 0.11, 0.19, 0.32, 0.47, 0.49, 0.46, 0.44,
      0.43, 0.41, 0.40, 0.38, 0.37, 0.36, 0.35, 0.34, 0.34, 0.33, 0.29},
 
    // n n K0bar pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.08, 0.11, 0.19, 0.32, 0.47, 0.49, 0.46, 0.44,
      0.43, 0.41, 0.40, 0.38, 0.37, 0.36, 0.35, 0.34, 0.34, 0.33, 0.29}, 

    // L p pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.03, 0.07,
      0.11, 0.44, 0.75, 1.07, 1.15, 1.85, 2.04, 2.14, 2.01, 1.87,
      1.80, 1.71, 1.68, 1.60, 1.55, 1.50, 1.44, 1.40, 1.38, 1.37, 1.22},
 
    // L n 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.04,
      0.07, 0.26, 0.45, 0.73, 1.76, 3.37, 3.40, 3.57, 3.36, 3.12,
      3.00, 2.85, 2.80, 2.66, 2.58, 2.50, 2.40, 2.33, 2.30, 2.28, 2.03},
 
    // L n pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.03, 0.07,
      0.11, 0.44, 0.75, 1.07, 1.57, 2.44, 3.24, 3.40, 3.20, 3.00,
      2.90, 2.76, 2.70, 2.57, 2.49, 2.42, 2.32, 2.25, 2.22, 2.20, 1.97},
 
    // L p K0 K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
      0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0},
 
    // L n K+ K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
      0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0},
 
    // L n K0 K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
      0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0},

    // S+ p 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.02, 0.07, 0.10, 0.20, 0.28, 0.29, 0.27, 0.25,
      0.24, 0.23, 0.23, 0.22, 0.21, 0.20, 0.19, 0.18, 0.18, 0.18, 0.16},
 
    // S+ n pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.04, 0.06, 0.12, 0.19, 0.20, 0.19, 0.18,
      0.17, 0.16, 0.16, 0.15, 0.15, 0.15, 0.14, 0.14, 0.14, 0.14, 0.12},
 
    // S+ n K- K0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0},
 
    // S0 p pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.03, 0.09, 0.13, 0.38, 0.53, 0.68, 0.71, 0.67, 0.63,
      0.61, 0.58, 0.57, 0.54, 0.52, 0.50, 0.48, 0.47, 0.47, 0.46, 0.41},
 
    // S0 n 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.02, 0.06, 0.13, 0.38, 0.88, 1.13, 1.17, 1.00, 0.94,
      0.91, 0.86, 0.84, 0.80, 0.78, 0.76, 0.73, 0.71, 0.70, 0.69, 0.62},
 
    // S0 n pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.03, 0.09, 0.13, 0.38, 0.69, 0.97, 1.02, 0.96, 0.90,
      0.87, 0.83, 0.81, 0.77, 0.75, 0.73, 0.70, 0.68, 0.68, 0.67, 0.60},
 
    // S0 p K0 K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01,
      0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0},
                          
    // S0 n K+ K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01,
      0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0},
 
    // S0 n K0 K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01,
      0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0},

    // S- p 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.08, 0.20, 0.24, 0.25, 0.23, 0.22,
      0.21, 0.20, 0.20, 0.19, 0.18, 0.17, 0.16, 0.16, 0.16, 0.16, 0.14},
 
    // S- p pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.08, 0.20, 0.24, 0.25, 0.23, 0.22,
      0.21, 0.20, 0.20, 0.19, 0.18, 0.17, 0.16, 0.16, 0.16, 0.16, 0.14},
 
    // S- n pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.08, 0.20, 0.24, 0.25, 0.23, 0.22,
      0.21, 0.20, 0.20, 0.19, 0.18, 0.17, 0.16, 0.16, 0.16, 0.16, 0.14},
  
    // S- p K0 K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01,
      0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0},
 
    // S- p K+ K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01,
      0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0},

    // S- n K+ K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01,
      0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0},

    // X0 n K0 pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},

    // X0 n K+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},

    // X0 p K0 pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X- n K+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X- n K0 pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X- p K+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},

    // X- p K0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    //
    //  multiplicity 5 (59 channels)
    // 
    // p p K- pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.06, 0.06, 0.09, 0.11,
      0.12, 0.13, 0.14, 0.15, 0.14, 0.14, 0.14, 0.13, 0.13, 0.13, 0.11},

    // p p K0bar 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.03, 0.05, 0.09, 0.11, 0.17, 0.22,
      0.23, 0.26, 0.28, 0.30, 0.28, 0.29, 0.28, 0.27, 0.27, 0.27, 0.24},

    // p n K- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.06, 0.06, 0.09, 0.11,
      0.12, 0.13, 0.14, 0.15, 0.14, 0.14, 0.14, 0.13, 0.13, 0.13, 0.11},

    // p n K- pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.03, 0.05, 0.09, 0.11, 0.17, 0.22,
      0.23, 0.26, 0.28, 0.30, 0.28, 0.29, 0.28, 0.27, 0.27, 0.27, 0.24},

    // p n K0bar pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.03, 0.05, 0.09, 0.11, 0.17, 0.22,
      0.23, 0.26, 0.28, 0.30, 0.28, 0.29, 0.28, 0.27, 0.27, 0.27, 0.24},

    // n n K- pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.03, 0.05, 0.09, 0.11, 0.17, 0.22,
      0.23, 0.26, 0.28, 0.30, 0.28, 0.29, 0.28, 0.27, 0.27, 0.27, 0.24},

    // n n K0bar 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.06, 0.06, 0.09, 0.11,
      0.12, 0.13, 0.14, 0.15, 0.14, 0.14, 0.14, 0.13, 0.13, 0.13, 0.11},

    // n n K0bar pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.03, 0.05, 0.09, 0.11, 0.17, 0.22,
      0.23, 0.26, 0.28, 0.30, 0.28, 0.29, 0.28, 0.27, 0.27, 0.27, 0.24},

    // L p pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.03, 0.03, 0.08, 0.13, 0.17, 0.18, 0.28, 0.40,
      0.42, 0.47, 0.50, 0.53, 0.52, 0.51, 0.50, 0.48, 0.48, 0.47, 0.42},

    // L p pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.03, 0.03, 0.14, 0.21, 0.29, 0.31, 0.48, 0.70,
      0.74, 0.82, 0.87, 0.92, 0.90, 0.89, 0.87, 0.84, 0.83, 0.82, 0.74},

    // L n 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.03, 0.03, 0.08, 0.13, 0.17, 0.18, 0.28, 0.40,
      0.42, 0.47, 0.50, 0.53, 0.52, 0.51, 0.50, 0.48, 0.48, 0.47, 0.42},

    // L n pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.03, 0.03, 0.14, 0.21, 0.29, 0.31, 0.48, 0.70,
      0.74, 0.82, 0.87, 0.92, 0.90, 0.89, 0.87, 0.84, 0.83, 0.82, 0.74},

    // L p K+ K- pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // L p K0 K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // L p K0 K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // L n K+ K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // L n K+ K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // L n K0 K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // L n K0 K0bar pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // S+ p 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // S+ n pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // S+ n pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // S+ p K0 K- pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // S+ n K0 K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // S+ n K0 K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // S+ n K+ K- pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // S0 p pi- 2pi0   
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.03, 0.05, 0.05, 0.06, 0.09, 0.11,
      0.12, 0.13, 0.14, 0.15, 0.14, 0.14, 0.14, 0.13, 0.13, 0.13, 0.11},

    // S0 p pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.04, 0.07, 0.08, 0.10, 0.15, 0.22,
      0.23, 0.26, 0.28, 0.30, 0.28, 0.29, 0.28, 0.27, 0.27, 0.27, 0.24},

    // S0 n 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.03, 0.05, 0.05, 0.06, 0.09, 0.11,
      0.12, 0.13, 0.14, 0.15, 0.14, 0.14, 0.14, 0.13, 0.13, 0.13, 0.11},

    // S0 n pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.04, 0.07, 0.08, 0.10, 0.15, 0.22,
      0.23, 0.26, 0.28, 0.30, 0.28, 0.29, 0.28, 0.27, 0.27, 0.27, 0.24},

    // S0 p K+ K- pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S0 p K0 K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S0 p K0 K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S0 n K+ K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S0 n K+ K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S0 n K0 K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S0 n K0 K0bar pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S- p 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // S- p pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.03, 0.03,
      0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04},

    // S- n pi+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // S- n 2pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02, 0.03, 0.03,
      0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04},

    // S- p K+ K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S- p K+ K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S- p K0 K0bar pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S- p K0 K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S- n K+ K0bar pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S- n K+ K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S- n K0 K0bar pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // X0 n K0 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.01, 0.01, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01},

    // X0 n K0 pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // X0 n K+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // X0 p K0 pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // X0 p K+ 2pi- 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // X- n K+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.01, 0.01, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01},

    // X- n K+ pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // X- n K0 pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // X- p K0 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.01, 0.01, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01},

    // X- p K0 pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // X- p K+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    //
    //  multiplicity 6 (30 channels)
    // 
    // p p K- pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
      0.07, 0.08, 0.09, 0.11, 0.13, 0.13, 0.14, 0.15, 0.15, 0.15, 0.13},

    // p p K- pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.06, 0.07, 0.09,
      0.10, 0.12, 0.14, 0.16, 0.19, 0.20, 0.21, 0.22, 0.22, 0.22, 0.20},

    // p p K0bar 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.04, 0.05, 0.06,
      0.07, 0.08, 0.09, 0.11, 0.13, 0.13, 0.14, 0.15, 0.15, 0.15, 0.13},

    // p n K- 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.04, 0.05, 0.06,
      0.07, 0.08, 0.09, 0.11, 0.13, 0.13, 0.14, 0.15, 0.15, 0.15, 0.13},

    // p n K- pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.06, 0.07, 0.09,
      0.10, 0.12, 0.14, 0.16, 0.19, 0.20, 0.21, 0.22, 0.22, 0.22, 0.20},

    // p n K0bar pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.04, 0.05, 0.06,
      0.07, 0.08, 0.09, 0.11, 0.13, 0.13, 0.14, 0.15, 0.15, 0.15, 0.13},

    // p n K0bar pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.06, 0.07, 0.09,
      0.10, 0.12, 0.14, 0.16, 0.19, 0.20, 0.21, 0.22, 0.22, 0.22, 0.20},

    // n n K- pi+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.04, 0.05, 0.06,
      0.07, 0.08, 0.09, 0.11, 0.13, 0.13, 0.14, 0.15, 0.15, 0.15, 0.13},

    // n n K- 2pi+ pi- 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.06, 0.07, 0.09,
      0.10, 0.12, 0.14, 0.16, 0.19, 0.20, 0.21, 0.22, 0.22, 0.22, 0.20},

    // n n K0bar 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.05, 0.06, 0.07,
      0.08, 0.09, 0.10, 0.12, 0.14, 0.14, 0.15, 0.16, 0.16, 0.16, 0.14},

    // n n K0bar pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.06, 0.07, 0.09,
      0.10, 0.12, 0.14, 0.16, 0.19, 0.20, 0.21, 0.22, 0.22, 0.22, 0.20},

    // L p pi- 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.03, 0.05, 0.06, 0.10, 0.12, 0.15,
      0.17, 0.20, 0.23, 0.27, 0.33, 0.34, 0.36, 0.38, 0.38, 0.37, 0.34},

    // L p pi+ 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.05, 0.08, 0.11, 0.16, 0.20, 0.25,
      0.29, 0.34, 0.39, 0.46, 0.56, 0.58, 0.61, 0.65, 0.65, 0.64, 0.58},

    // L n 4pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.06, 0.07, 0.09,
      0.10, 0.12, 0.14, 0.16, 0.19, 0.20, 0.21, 0.22, 0.22, 0.22, 0.20},

    // L n pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.03, 0.05, 0.06, 0.10, 0.12, 0.15,
      0.17, 0.20, 0.23, 0.27, 0.33, 0.34, 0.36, 0.38, 0.38, 0.37, 0.34},

    // L n 2pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.05, 0.08, 0.11, 0.16, 0.20, 0.25,
      0.29, 0.34, 0.39, 0.46, 0.56, 0.58, 0.61, 0.65, 0.65, 0.64, 0.58},

    // S+ p 2pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.01, 0.02, 0.02,
      0.02, 0.02, 0.03, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04},

    // S+ p pi+ 3pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02, 0.03, 0.03,
      0.03, 0.04, 0.04, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // S+ n pi- 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.02, 0.03, 0.03, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.05},

    // S+ n pi+ 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.02, 0.03,
      0.03, 0.04, 0.04, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // S0 p pi- 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.03, 0.01, 0.02, 0.02,
      0.02, 0.02, 0.03, 0.03, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.05},

    // S0 p pi+ 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.02, 0.04, 0.02, 0.03, 0.03,
      0.03, 0.04, 0.04, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // S0 n 4pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.02, 0.03,
      0.03, 0.04, 0.04, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // S0 n pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.03, 0.03, 0.04, 0.05,
      0.06, 0.07, 0.08, 0.09, 0.11, 0.11, 0.12, 0.13, 0.13, 0.13, 0.11},

    // S0 n 2pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.02, 0.04, 0.05, 0.06, 0.07,
      0.08, 0.09, 0.10, 0.12, 0.14, 0.14, 0.15, 0.16, 0.16, 0.16, 0.14},

    // S- p 4pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.03,
      0.03, 0.04, 0.04, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // S- p pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.04, 0.05,
      0.06, 0.07, 0.08, 0.09, 0.11, 0.11, 0.12, 0.13, 0.13, 0.13, 0.11},

    // S- p 2pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.05, 0.06, 0.07,
      0.08, 0.09, 0.10, 0.12, 0.14, 0.14, 0.15, 0.16, 0.16, 0.16, 0.14},

    // S- n pi+ 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04},

    // S- n 2pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03, 0.03,
      0.03, 0.04, 0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    //
    //  multiplicity 7 (20 channels)
    // 
    // p p K- pi- 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04,
      0.05, 0.06, 0.07, 0.09, 0.11, 0.13, 0.15, 0.17, 0.17, 0.17, 0.16},

    // p p K- pi+ 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.18, 0.21, 0.24, 0.27, 0.27, 0.27, 0.27},

    // p p K0bar 2pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04,
      0.05, 0.06, 0.07, 0.09, 0.11, 0.13, 0.15, 0.17, 0.17, 0.17, 0.16},

    // p p K0bar pi+ 3pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.18, 0.21, 0.24, 0.27, 0.27, 0.27, 0.27},

    // p n K- 4pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03,
      0.04, 0.05, 0.06, 0.08, 0.10, 0.12, 0.14, 0.16, 0.16, 0.16, 0.15},

    // p n K- pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04,
      0.05, 0.06, 0.07, 0.09, 0.11, 0.13, 0.15, 0.17, 0.17, 0.17, 0.16},

    // p n K- 2pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.18, 0.21, 0.24, 0.27, 0.27, 0.27, 0.27},

    // p n K0bar pi- 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04,
      0.05, 0.06, 0.07, 0.09, 0.11, 0.13, 0.15, 0.17, 0.17, 0.17, 0.16},

    // p n K0bar pi+ 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.18, 0.21, 0.24, 0.27, 0.27, 0.27, 0.27},

    // n n K- pi+ 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04,
      0.05, 0.06, 0.07, 0.09, 0.11, 0.13, 0.15, 0.17, 0.17, 0.17, 0.16},

    // n n K- 2pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.18, 0.21, 0.24, 0.27, 0.27, 0.27, 0.27},

    // n n K0bar 4pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03,
      0.04, 0.05, 0.06, 0.08, 0.10, 0.12, 0.14, 0.16, 0.16, 0.16, 0.15},

    // n n K0bar pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.02, 0.03, 0.04,
      0.05, 0.06, 0.07, 0.09, 0.11, 0.13, 0.15, 0.17, 0.17, 0.17, 0.16},

    // n n K0bar 2pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.18, 0.21, 0.24, 0.27, 0.27, 0.27, 0.27},

    // L p pi- 4pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03,
      0.04, 0.05, 0.06, 0.08, 0.10, 0.12, 0.14, 0.16, 0.16, 0.16, 0.15},

    // L p pi+ 2pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03, 0.04,
      0.05, 0.06, 0.07, 0.09, 0.11, 0.13, 0.15, 0.17, 0.17, 0.17, 0.16},

    // L p 2pi+ 3pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.02, 0.03, 0.03, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.18, 0.21, 0.24, 0.27, 0.27, 0.27, 0.27},

    // L n 5pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03,
      0.04, 0.05, 0.06, 0.08, 0.10, 0.12, 0.14, 0.16, 0.16, 0.16, 0.16},

    // L n pi+ pi- 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.04,
      0.05, 0.06, 0.07, 0.09, 0.11, 0.13, 0.15, 0.17, 0.17, 0.17, 0.16},

    // L n 2pi+ 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.18, 0.21, 0.24, 0.27, 0.27, 0.27, 0.27} };
}

G4CascadeSigmaMinusPChannelData::data_t
G4CascadeSigmaMinusPChannelData::data(smp2bfs, smp3bfs, smp4bfs,
				      smp5bfs, smp6bfs, smp7bfs,
				      smpCrossSections, sm*pro, "SigmaMinusP");
