//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// -------------------------------------------------------------------
//      GEANT 4 class implementation file 
//
//      CERN, Geneva, Switzerland
//
//      File name:     G4VNuclearField.cc
//
//      Author:        Alessandro Brunengo (Alessandro.Brunengo@ge.infn.it)
// 
//      Creation date: 5 June 2000
// -------------------------------------------------------------------
#include "G4VNuclearField.hh"
#include "globals.hh"

G4VNuclearField::G4VNuclearField(G4V3DNucleus * aNucleus) : 
theNucleus(aNucleus),
radius(aNucleus->GetOuterRadius() + 4*fermi)
{
}

G4VNuclearField::G4VNuclearField(const  G4VNuclearField &right) :
theNucleus(right.theNucleus),
radius(right.radius)
{
}

G4VNuclearField::~G4VNuclearField()
{
}

const G4VNuclearField & G4VNuclearField::operator=(const G4VNuclearField &)
{
  throw G4HadronicException(__FILE__, __LINE__, "G4VNuclearField::operator= meant not to be accessible");
  return *this;
}

G4int G4VNuclearField::operator==(const G4VNuclearField &) const
{
  throw G4HadronicException(__FILE__, __LINE__, "G4VNuclearField::operator== meant not to be accessible");
  return 0;
}

G4int G4VNuclearField::operator!=(const G4VNuclearField &) const
{
  throw G4HadronicException(__FILE__, __LINE__, "G4VNuclearField::operator!= meant not to be accessible");
  return 1;
}









