/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.SolidItem;
import java.util.Vector;

public class BREPItem
extends SolidItem {
    static final int PCONE = 0;
    static final int PGON = 1;
    static final String[] solidName = new String[]{"PolyConeSegment", "PolyGonSegment"};
    static final String[] brepName = new String[]{"PCone", "Polyhedra"};
    static final String[] solidConstr = new String[]{"PolyConeSegment", "PolyGonSegment"};
    static final String[][] paraName = new String[][]{{"StartPhiAngle", "DeltaPhiAngle", "Z of a Section", "OuterRadius", "InnerRadius"}, {"StartPhiAngle", "DeltaPhiAngle", "NumberOfSides", "Z of a Section", "OuterRadius", "InnerRadius"}};
    double[] phi;
    private double boundZ;
    private double boundRmax;
    private double boundBox;
    private double[] values;
    int nSides;
    int nZ;
    String sAngUnit;
    String dAngUnit;
    Vector zVector;
    String dzA;
    String rminA;
    String rmaxA;
    String sphi;
    String dphi;
    StringBuffer dz;
    StringBuffer rmin;
    StringBuffer rmax;

    public BREPItem(int solidType) {
        super(solidType);
        this.values = new double[paraName[solidType].length];
        this.phi = new double[2];
        this.zVector = new Vector();
        this.isEmpty = true;
    }

    public String toString() {
        return solidName[this.solidType];
    }

    int getParaCount() {
        return paraName[this.solidType].length;
    }

    double getValues(int pos) {
        return this.values[pos];
    }

    String getParaName(int pos) {
        return paraName[this.solidType][pos];
    }

    @Override
    String getCPP(String name) {
        this.nZ = this.zVector.size();
        this.dz = new StringBuffer("");
        this.rmin = new StringBuffer("");
        this.rmax = new StringBuffer("");
        for (int s = 0; s < this.zVector.size(); ++s) {
            if (s != this.zVector.size() - 1) {
                Vector array = (Vector)this.zVector.elementAt(s);
                this.dz.append(array.elementAt(0) + "*" + array.elementAt(3) + ", ");
                this.rmin.append(array.elementAt(2) + "*" + array.elementAt(3) + ", ");
                this.rmax.append(array.elementAt(1) + "*" + array.elementAt(3) + ", ");
                continue;
            }
            if (s != this.zVector.size() - 1) continue;
            Vector lastArray = (Vector)this.zVector.elementAt(s);
            this.dz.append(lastArray.elementAt(0) + "*" + lastArray.elementAt(3));
            this.rmin.append(lastArray.elementAt(2) + "*" + lastArray.elementAt(3));
            this.rmax.append(lastArray.elementAt(1) + "*" + lastArray.elementAt(3));
        }
        this.dzA = this.dz.toString();
        this.rminA = this.rmin.toString();
        this.rmaxA = this.rmax.toString();
        StringBuffer cpp = new StringBuffer("G4double DzArray" + name + "   [] = {" + this.dzA + "};\nG4double RminArray" + name + " [] = {" + this.rminA + "};\nG4double RmaxArray" + name + " [] = {" + this.rmaxA + "};\n\n");
        cpp.append("G4BREPSolid" + brepName[this.solidType] + " *solid" + name + " = new G4BREPSolid" + brepName[this.solidType] + "(\"solid" + name + "\", \t //its name\n");
        cpp.append("\t\t " + this.phi[0] + "*" + this.sAngUnit + ", \t\t //its start angle\n");
        cpp.append("\t\t " + this.phi[1] + "*" + this.dAngUnit + ",\t\t //its opening angle\n");
        if (this.solidType == 1) {
            cpp.append("\t\t " + this.nSides + ",\t\t //its sides\n");
        }
        cpp.append("\t\t " + this.nZ + ", \t\t //its nZ\n\t\t DzArray" + name + "[0], \t\t //z start \n\t\t DzArray" + name + ", \t\t //z value \n\t\t RminArray" + name + ", \t\t //rmin \n\t\t RmaxArray" + name + " ); \t\t //rmax\n");
        return cpp.toString();
    }

    @Override
    String getXML(String name, int defNum) {
        StringBuffer xml = new StringBuffer();
        return xml.toString();
    }

    public String getPrim() {
        this.boundZ = 0.0;
        this.boundRmax = 0.0;
        if (this.sAngUnit.equals("rad")) {
            this.sphi = Double.toString(this.phi[0]);
        } else if (this.sAngUnit.equals("mrad")) {
            this.sphi = Double.toString(this.phi[0] / 1000.0);
        } else if (this.sAngUnit.equals("deg")) {
            this.sphi = Double.toString(this.phi[0] * 2.0 * Math.PI / 360.0);
        }
        if (this.dAngUnit.equals("rad")) {
            this.dphi = Double.toString(this.phi[1]);
        } else if (this.dAngUnit.equals("mrad")) {
            this.dphi = Double.toString(this.phi[1] / 1000.0);
        } else if (this.dAngUnit.equals("deg")) {
            this.dphi = Double.toString(this.phi[1] * 2.0 * Math.PI / 360.0);
        }
        this.nZ = this.zVector.size();
        this.dz = new StringBuffer("");
        this.rmin = new StringBuffer("");
        this.rmax = new StringBuffer("");
        for (int s = 0; s < this.zVector.size(); ++s) {
            Vector array = (Vector)this.zVector.elementAt(s);
            if (array.elementAt(3).equals("km")) {
                try {
                    Double dzk = Double.valueOf(array.elementAt(0).toString());
                    double dk = dzk;
                    Double rMik = Double.valueOf(array.elementAt(2).toString());
                    double rmik = rMik;
                    Double rMak = Double.valueOf(array.elementAt(1).toString());
                    double rmak = rMak;
                    Double kM = Double.valueOf("1000000");
                    double km = kM;
                    this.dz.append(dk * km + " ");
                    this.boundZ += dk * km;
                    this.rmin.append(rmik * km + " ");
                    this.rmax.append(rmak * km + " ");
                    this.boundRmax = Math.max(this.boundRmax, rmak * km);
                }
                catch (NumberFormatException e) {
                    System.out.println("");
                }
                continue;
            }
            if (array.elementAt(3).equals("m")) {
                try {
                    Double dzm = Double.valueOf(array.elementAt(0).toString());
                    double dm = dzm;
                    Double rMim = Double.valueOf(array.elementAt(2).toString());
                    double rmim = rMim;
                    Double rMam = Double.valueOf(array.elementAt(1).toString());
                    double rmam = rMam;
                    double m = Double.valueOf("1000");
                    this.dz.append(dm * m + " ");
                    this.boundZ += dm * m;
                    this.rmin.append(rmim * m + " ");
                    this.rmax.append(rmam * m + " ");
                    this.boundRmax = Math.max(this.boundRmax, rmam * m);
                }
                catch (NumberFormatException e) {
                    System.out.println("");
                }
                continue;
            }
            if (array.elementAt(3).equals("cm")) {
                try {
                    Double dzc = Double.valueOf(array.elementAt(0).toString());
                    double dc = dzc;
                    Double rMic = Double.valueOf(array.elementAt(2).toString());
                    double rmic = rMic;
                    Double rMac = Double.valueOf(array.elementAt(1).toString());
                    double rmac = rMac;
                    double cm = Double.valueOf("10");
                    this.dz.append(dc * cm + " ");
                    this.boundZ += dc * cm;
                    this.rmin.append(rmic * cm + " ");
                    this.rmax.append(rmac * cm + " ");
                    this.boundRmax = Math.max(this.boundRmax, rmac * cm);
                }
                catch (NumberFormatException e) {
                    System.out.println("");
                }
                continue;
            }
            if (array.elementAt(3).equals("mm")) {
                try {
                    Double dzmm = Double.valueOf(array.elementAt(0).toString());
                    double dmm = dzmm;
                    Double rMimm = Double.valueOf(array.elementAt(2).toString());
                    double rmimm = rMimm;
                    Double rMamm = Double.valueOf(array.elementAt(1).toString());
                    double rmamm = rMamm;
                    this.dz.append(dmm + " ");
                    this.boundZ += dmm;
                    this.rmin.append(rmimm + " ");
                    this.rmax.append(rmamm + " ");
                    this.boundRmax = Math.max(this.boundRmax, rmamm);
                }
                catch (NumberFormatException e) {
                    System.out.println("");
                }
                continue;
            }
            if (array.elementAt(3).equals("micrometer")) {
                try {
                    Double dzz = Double.valueOf(array.elementAt(0).toString());
                    double d = dzz;
                    Double rMi = Double.valueOf(array.elementAt(2).toString());
                    double rmi = rMi;
                    Double rMa = Double.valueOf(array.elementAt(1).toString());
                    double rma = rMa;
                    double mic = Double.valueOf("1000");
                    this.dz.append(d / mic + " ");
                    this.boundZ += d / mic;
                    this.rmin.append(rmi / mic + " ");
                    this.rmax.append(rma / mic + " ");
                    this.boundRmax = Math.max(this.boundRmax, rma / mic);
                }
                catch (NumberFormatException e) {
                    System.out.println("");
                }
                continue;
            }
            if (array.elementAt(3).equals("namoometer")) {
                try {
                    Double dzn = Double.valueOf(array.elementAt(0).toString());
                    double dn = dzn;
                    Double rMina = Double.valueOf(array.elementAt(2).toString());
                    double rmina = rMina;
                    Double rMana = Double.valueOf(array.elementAt(1).toString());
                    double rmana = rMana;
                    double nan = Double.valueOf("1000000");
                    this.dz.append(dn / nan + " ");
                    this.boundZ += dn / nan;
                    this.rmin.append(rmina / nan + " ");
                    this.rmax.append(rmana / nan + " ");
                    this.boundRmax = Math.max(this.boundRmax, rmana / nan);
                }
                catch (NumberFormatException e) {
                    System.out.println("");
                }
                continue;
            }
            if (!array.elementAt(3).equals("fermi")) continue;
            try {
                Double dzf = Double.valueOf(array.elementAt(0).toString());
                double df = dzf;
                Double rMif = Double.valueOf(array.elementAt(2).toString());
                double rmif = rMif;
                Double rMaf = Double.valueOf(array.elementAt(1).toString());
                double rmaf = rMaf;
                double fer = Double.valueOf("1000000000");
                this.dz.append(df / fer + " ");
                this.boundZ += df / fer;
                this.rmin.append(rmif / fer + " ");
                this.rmax.append(rmaf / fer + " ");
                this.boundRmax = Math.max(this.boundRmax, rmaf / fer);
                continue;
            }
            catch (NumberFormatException e) {
                System.out.println("");
            }
        }
        this.boundBox = Math.sqrt(Math.pow(this.boundZ, 2.0) + Math.pow(this.boundRmax, 2.0)) * 2.0;
        this.dzA = this.dz.toString();
        this.rminA = this.rmin.toString();
        this.rmaxA = this.rmax.toString();
        StringBuffer prim = new StringBuffer("#################################\n");
        prim.append("###         GGESolid.prim      ###\n");
        prim.append("#################################\n");
        prim.append("#G4.PRIM-FORMAT-2.4\n\n");
        prim.append("/BoundingBox  -" + this.boundBox + " -" + this.boundBox + " -" + this.boundBox + " " + this.boundBox + " " + this.boundBox + " " + this.boundBox + "\n");
        prim.append("!SetCamera\n!OpenDevice\n!BeginModeling\n\n");
        prim.append("#" + solidName[this.solidType] + "\n");
        if (solidName[this.solidType].equals("PolyConeSegment")) {
            prim.append("/PolyCone    ");
        } else if (solidName[this.solidType].equals("PolyGonSegment")) {
            prim.append("/PolyGon    ");
        }
        prim.append(this.sphi + "  " + this.dphi + "  ");
        if (solidName[this.solidType].equals("PolyGonSegment")) {
            prim.append(this.nSides + "  ");
        }
        prim.append(this.nZ + "  " + this.dzA + "  " + this.rminA + "  " + this.rmaxA + "  ");
        prim.append("\n\n!EndModeling\n!DrawAll\n!CloseDevice");
        return prim.toString();
    }

    @Override
    String getDefine(String name, int defNum) {
        return "";
    }
}

