//$Id: MaterialAbstTable.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

abstract public class MaterialAbstTable extends JTable implements ActionListener {

  protected JButton append, ins, del;
  protected String tableTitle;
  MaterialFrame parent;
  protected GGETableModel model;

//MOMO

public  MaterialAbstTable(GGETableModel model, MaterialFrame parent){
    super(model);
    this.model = model;
    this.parent = parent;

    setAutoCreateColumnsFromModel(false);
    setColumnSelectionAllowed(false);
    setRowSelectionAllowed(true);
    getTableHeader().setReorderingAllowed(false);
    setSelectionMode(ListSelectionModel.SINGLE_SELECTION);


//Jccombobox items don't corresponds to the GEANT4 units.
//They shall be translated into correct ones in making C++ source codes

    JComboBox stateCombo = new JComboBox();
       stateCombo.addItem("kStateUndefined");
       stateCombo.addItem("kStateSolid");
       stateCombo.addItem("kStateLiquid");
       stateCombo.addItem("kStateGas");

//     stateCombo.addItem("Vaccum");  //deleted 8.13

    JComboBox pressUnitCombo = new JComboBox();
       pressUnitCombo.addItem("pascal");
       pressUnitCombo.addItem("bar");
       pressUnitCombo.addItem("atmosphere");

    JComboBox denl = new JComboBox();
       denl.addItem("mg/cm3");
       denl.addItem("g/cm3");
       denl.addItem("kg/m3");

    JComboBox kl = new JComboBox();
       kl.addItem("kelvin");

//Only used materials have C++ codes

    JComboBox use = new JComboBox();
      use.addItem("    ");
      use.addItem("Used");

    DefaultTableCellRenderer useCellRenderer = new DefaultTableCellRenderer();
      useCellRenderer.setForeground(Color.red);

    DefaultTableCellRenderer nameCellRenderer = new DefaultTableCellRenderer();
      nameCellRenderer.setBackground(Color.pink);

    TableColumn column = new TableColumn();
        column = getColumn("Use");
              column.setCellEditor(new DefaultCellEditor(use));
              column.setCellRenderer(useCellRenderer);
              column.setWidth(4);    

        column = getColumn("Name");
              column.setCellEditor(new NameCellEditor());
              column.setCellRenderer(nameCellRenderer);
              column.sizeWidthToFit();
              column.setResizable(true);

        column = getColumn("Density");
              column.setCellEditor( new DoubleCellEditor());
              column.sizeWidthToFit();
              column.setResizable(true);

        column = getColumn("Unit");
              column.setWidth(5);
              column.setCellEditor( new DefaultCellEditor(denl));

        column = getColumn("State");
              column.setCellEditor(new DefaultCellEditor(stateCombo));
              column.setWidth(8);
              column.setResizable(true);

        column = getColumn("Temp");
     	      column.setCellEditor(new DoubleCellEditor());
       	      column.sizeWidthToFit();
              column.setResizable(true);

	column = getColumn(" Unit");
	      column.setCellEditor(new DefaultCellEditor(kl));
              column.setWidth(6);

	column = getColumn("Press");
              column.setCellEditor(new DoubleCellEditor());
              column.sizeWidthToFit();
              column.setResizable(true);

        column = getColumn("Unit ");
              column.setCellEditor(new DefaultCellEditor(pressUnitCombo));
              column.setWidth(6);
  }

  public JPanel makeMaterialPanel(){

    JScrollPane scrollpane = new JScrollPane(this);
    	scrollpane.setPreferredSize(new Dimension(780, 250));
	scrollpane.setMinimumSize(new Dimension(150, 50));

    JPanel tab = new JPanel();
    	tab.setLayout(new BorderLayout(5,3));

	//JPanel buttonPanel = new JPanel(); // change to Box to use horizontalGlue 
	Box buttonPanel = Box.createHorizontalBox();
	//    buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
        JLabel mtitle = new JLabel(tableTitle);
                mtitle.setFont(new Font("Serif", Font.BOLD, 12));
                Dimension tsize = mtitle.getPreferredSize();
                mtitle.setSize(tsize);
      buttonPanel.add(mtitle);
        append = new JButton("Append");
	   buttonPanel.add(append);
        ins = new JButton("Insert");
	   buttonPanel.add(ins);
        del = new JButton("Delete");
	   buttonPanel.add(del);
	   //add horizontal glue
      buttonPanel.add(Box.createHorizontalGlue());

    tab.add(buttonPanel,"North");
    tab.add(scrollpane, "Center");

    append.addActionListener(this);
    ins.addActionListener(this);
    del.addActionListener(this);

    return tab;
  }

  public void actionPerformed(ActionEvent ae){

    Object o = ae.getSource();

    if (o == append) {
      create();
      append.setForeground(Color.red);
      return;
    }

    if (o == ins) {
      insert();
      ins.setForeground(Color.red);
      return;
    }
    if (o == del){
      delete();
      del.setForeground(Color.red);
      return;
    }
  }

  public void dellMatCloseAct(){

     del.setForeground(Color.black);
     del.repaint();
  }

  public void createMatCloseAct(){

     append.setForeground(Color.black);
     append.repaint();
  }


    //ABSTRACT must be implemented by MaterialTables
  abstract void create();
  abstract void insert();
  abstract void delete();



  void stopEditing(){
    if (isEditing()) cellEditor.stopCellEditing();
    clearSelection();
  }

  Object getSelectedName(){
    if (isEditing()) cellEditor.stopCellEditing();
    Vector data = model.getDataVector();

    int row = getSelectedRow();
    if (row < 0) return null;
    return ((Vector)data.elementAt(row)).elementAt(0);
  }

  public void valueChanged(ListSelectionEvent lse){
    super.valueChanged(lse);
    if (lse.getValueIsAdjusting()) {selected();}
    if (lse.getFirstIndex() < 0) return;
    if (lse.getLastIndex() < 0) return;
  }
  protected abstract void selected();
}

