// The example class categories definitions for Doxygen

/// \file Doxymodules_analysis.h
/// \brief The page that defines the extended/analysis examples modules


/** @defgroup extended_analysis analysis
 *  Extended examples analysis classes
 *  @{
 */

/** @defgroup extended_analysis_AnaEx01 AnaEx01
 *  Analysis AnaEx01 example has its 
 *  <a href="../html_AnaEx01/html/index.html">standalone documentation </a>
 *  @ingroup extended_analysis
 *  @{
 */

/** @} */

/** @defgroup extended_analysis_AnaEx02 AnaEx02
 *  Analysis AnaEx02 example has its 
 *  <a href="../html_AnaEx02/html/index.html">standalone documentation </a>
 *  @ingroup extended_analysis
 *  @{
 */

/** @} */

/** @defgroup extended_analysis_AnaEx03 AnaEx03
 *  Analysis AnaEx03 example has its 
 *  <a href="../html_AnaEx03/html/index.html">standalone documentation </a>
 *  @ingroup extended_analysis
 *  @{
 */

/** @} */

/** @defgroup extended_analysis_B1Con B1Con
 *  Analysis example B1Con 
 *  @ingroup extended_analysis
 *  @{
 */

  class B1ConActionInitialization{};
  class B1ConRunAction{};
  class B1ConRun{};
  class B1DetectorConstruction{};
  class B1EventAction{};
  class B1PrimaryGeneratorAction{};
  class B1Run{};
  class B1SteppingAction{};

/** @} */

/** @defgroup extended_analysis_B3aScoreWriter B3aScoreWriter
 *  Analysis example B3aScoreWriter
 *  @ingroup extended_analysis
 *  @{
 */

  class B3DetectorConstruction {};
  class B3PhysicsList {};
  class B3PrimaryGeneratorAction {};
  class B3StackingAction {};
  class B3aActionInitialization {};
  class B3aEventAction {};
  class B3aRunAction {};
  class G4ScoreNtupleWriter {};     
  class G4ScoreNtupleWriterMessenger {};

/** @} */

/** @defgroup extended_analysis_B4dScoreWriter B4dScoreWriter
 *  Analysis example B4dScoreWriter
 *  @ingroup extended_analysis
 *  @{
 */

  class B4Analysis {};
  class B4PrimaryGeneratorAction {};
  class B4RunAction {};
  class B4dActionInitialization {};
  class B4dDetectorConstruction {};
  class B4dEventAction {};
  class G4ScoreNtupleWriter {};      
  class G4ScoreNtupleWriterMessenger {};

/** @} */

/** @} */
