//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

import java.awt.*;
import java.io.*;
import java.io.Serializable;

class VisAtbItem extends GGEItem {
  String name, atbsValue[];
  boolean atbsIsValid[];
  static final String atbMethodName[] = {"Visibility", "LineStyle", "LineWidth", "ForceWireFrame", "ForceSolid" };
  Color color;
  VisAtbItem(){
    atbsValue = new String[atbMethodName.length];
    atbsIsValid = new boolean[atbMethodName.length];
  }
  public String toString(){
    return name;
  }

  String getCPP(){
    StringBuffer cpp = new StringBuffer("G4VisAttributes * ");
    cpp.append(name+"= new G4VisAttributes( G4colour(");
    cpp.append(color.getRed()+","+color.getGreen()+","+color.getBlue()+" ));\n");
    for (int i=0; i<atbsIsValid.length; i++){
      if (atbsIsValid[i]){
	cpp.append(name + "->Set"+atbMethodName[i]+"("+atbsValue[i]+");\n");
      }
    }
    return cpp.toString();
  }

}

