/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.DoubleCellEditor;
import GGE.GGETableModel;
import GGE.IntCellEditor;
import GGE.NameCellEditor;
import GGE.VolumesFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

class SlicingAxialFrame
extends JPanel
implements ActionListener,
MouseListener {
    private JButton create;
    private JButton ins;
    private JButton dell;
    private JFrame frame1;
    private JFrame frame2;
    private JMenuItem close;
    private JComboBox motherCombo;
    JTable slicingTable;
    GGETableModel slicingDataModel;
    VolumesFrame volFrame;
    private String pValue;
    private String mother;
    private String[] tableIdent = new String[]{"pName", "pLogic", "MomType", "pMother", "EAxis", "nReplicas", "Width", "WidthUnit", "Offset", "OffsetUnit"};
    private JComboBox matCombo;
    DefaultComboBoxModel matComboModel;

    SlicingAxialFrame(VolumesFrame parent) {
        this.volFrame = parent;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(2, 1));
        this.slicingDataModel = new GGETableModel(this.tableIdent, 0);
        this.slicingTable = new JTable(this.slicingDataModel);
        this.slicingTable.setAutoCreateColumnsFromModel(false);
        this.slicingTable.setColumnSelectionAllowed(false);
        this.slicingTable.setRowSelectionAllowed(true);
        this.slicingTable.getTableHeader().setReorderingAllowed(false);
        this.slicingTable.setSelectionMode(0);
        this.slicingTable.addMouseListener(this);
        JComboBox<String> motherCombo = new JComboBox<String>();
        motherCombo.addItem("logical");
        motherCombo.addItem("physical");
        JComboBox<String> eAxisCombo = new JComboBox<String>();
        eAxisCombo.addItem("kPhi");
        JComboBox<String> angleCombo = new JComboBox<String>();
        angleCombo.addItem("rad");
        angleCombo.addItem("mrad");
        angleCombo.addItem("deg");
        JComboBox<String> widCombo = new JComboBox<String>();
        widCombo.addItem("rad");
        widCombo.addItem("mrad");
        widCombo.addItem("deg");
        JComboBox<String> offsetCombo = new JComboBox<String>();
        offsetCombo.addItem("rad");
        offsetCombo.addItem("mrad");
        offsetCombo.addItem("deg");
        this.matCombo = new JComboBox();
        this.matCombo.setEditable(true);
        this.matComboModel = new DefaultComboBoxModel();
        this.matCombo.setModel(this.matComboModel);
        this.matComboModel.addElement("");
        TableColumn[] column = new TableColumn[this.tableIdent.length];
        for (int i = 0; i < this.tableIdent.length; ++i) {
            column[i] = this.slicingTable.getColumn(this.tableIdent[i]);
        }
        DefaultTableCellRenderer nameCellRenderer = new DefaultTableCellRenderer();
        nameCellRenderer.setBackground(Color.pink);
        column[0].setCellEditor(new NameCellEditor());
        column[0].setCellRenderer(nameCellRenderer);
        column[0].sizeWidthToFit();
        column[0].setResizable(true);
        column[1].setCellEditor(new DefaultCellEditor(this.matCombo));
        column[2].setCellEditor(new DefaultCellEditor(motherCombo));
        column[3].setCellEditor(new NameCellEditor());
        column[4].setCellEditor(new DefaultCellEditor(eAxisCombo));
        column[5].setCellEditor(new IntCellEditor());
        column[6].setCellEditor(new DoubleCellEditor());
        column[7].setCellEditor(new DefaultCellEditor(widCombo));
        column[8].setCellEditor(new DoubleCellEditor());
        column[9].setCellEditor(new DefaultCellEditor(offsetCombo));
        JScrollPane scrollpane = new JScrollPane(this.slicingTable);
        scrollpane.setPreferredSize(new Dimension(750, 180));
        scrollpane.setMinimumSize(new Dimension(50, 25));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(1, 3));
        this.create = new JButton(" Append ");
        panel2.add(this.create);
        this.ins = new JButton(" Insert ");
        panel2.add(this.ins);
        this.dell = new JButton(" Delete ");
        panel2.add(this.dell);
        panel.add("Center", scrollpane);
        panel.add("North", panel2);
        this.add((Component)panel, "Center");
        this.create.addActionListener(this);
        this.ins.addActionListener(this);
        this.dell.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.dell) {
            this.dellSlicing();
        } else if (o == this.create) {
            this.appendSlicing();
        } else if (o == this.ins) {
            this.insertSlicing();
        } else if (o == this.close) {
            this.setVisible(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        if (table.getSelectedColumn() == 1) {
            int i;
            String[] matStr = this.volFrame.getVolumesName();
            int modelSize = this.matComboModel.getSize();
            String[] modelStr = new String[modelSize];
            for (int i2 = 0; i2 < modelSize; ++i2) {
                modelStr[i2] = this.matComboModel.getElementAt(i2).toString();
            }
            boolean exist = false;
            for (i = 0; i < matStr.length; ++i) {
                for (int j = 0; j < modelSize; ++j) {
                    if (!modelStr[j].equals(matStr[i])) continue;
                    exist = true;
                }
                if (!exist) {
                    this.matComboModel.addElement(matStr[i]);
                }
                exist = false;
            }
            modelSize = this.matComboModel.getSize();
            modelStr = new String[modelSize];
            for (i = 0; i < modelSize; ++i) {
                modelStr[i] = this.matComboModel.getElementAt(i).toString();
            }
            exist = false;
            for (int j = 0; j < modelSize; ++j) {
                for (int i3 = 0; i3 < matStr.length; ++i3) {
                    if (!modelStr[j].equals(matStr[i3])) continue;
                    exist = true;
                }
                if (!exist && !modelStr[j].equals("")) {
                    this.matComboModel.removeElementAt(j);
                }
                exist = false;
            }
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void dellSlicingCloseAct() {
        this.dell.setForeground(Color.black);
        this.dell.repaint();
    }

    public void createSlicingCloseAct() {
        this.create.setForeground(Color.black);
        this.create.repaint();
    }

    public void insertSlicingCloseAct() {
        this.ins.setForeground(Color.black);
        this.ins.repaint();
    }

    public void slicingClear() {
        this.slicingDataModel = new GGETableModel(this.tableIdent, 0);
        this.slicingTable.setModel(this.slicingDataModel);
        this.repaint();
    }

    public void appendSlicing() {
        Object[] slicingTmp = new Object[]{"", "", "logical", "", "kRhi", "", "", "rad", "0.0", "deg"};
        this.slicingDataModel.addRow(slicingTmp);
    }

    public void insertSlicing() {
        Object[] tmp = new Object[]{"", "", "logical", "", "kRhi", "", "", "rad", "0.0", "deg"};
        if (this.slicingTable.getSelectedRow() == -1) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Choose the pName", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception e) {}
        } else {
            int slicingRowCount = this.slicingTable.getSelectedRow() + 1;
            this.slicingDataModel.insertRow(slicingRowCount, tmp);
        }
    }

    public void dellSlicing() {
        if (this.slicingTable.getSelectedRow() == -1) {
            JOptionPane opane = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Choose the pName", "Warning Dialog", 2);
            JDialog dialog = opane.createDialog(this, "Warning Dialog");
            try {
                Class<?> targetClass = dialog.getClass();
                Class[] parameters = new Class[]{Boolean.TYPE};
                Method method = targetClass.getDeclaredMethod("setAlwaysOnTop", parameters);
                Object targetInstance = targetClass.newInstance();
                Object[] params = new Object[]{new boolean[]{true}};
                if (System.getProperty("java.version").equals("1.5.0")) {
                    method.invoke(targetInstance, params);
                }
            }
            catch (Exception exception) {}
        } else {
            this.stopEditing();
            this.slicingDataModel.removeRow(this.slicingTable.getSelectedRow());
            this.dell.setForeground(Color.black);
            this.repaint();
        }
    }

    void stopEditing() {
        int row = 0;
        int column = 0;
        row = this.slicingTable.getEditingRow();
        if (row != -1 && (column = this.slicingTable.getEditingColumn()) != -1) {
            TableCellEditor cellEditor = this.slicingTable.getCellEditor(row, column);
            cellEditor.stopCellEditing();
        }
    }

    String getCPP() {
        StringBuffer cpp = new StringBuffer("\n// Slicing AxialSymmetric \n\n");
        if (this.slicingDataModel.getRowCount() == 0) {
            return cpp.toString();
        }
        for (int i = 0; i < this.slicingDataModel.getRowCount(); ++i) {
            String pMother = this.slicingDataModel.getValueAt(i, 3).toString();
            cpp.append("G4PVReplica *  " + this.slicingDataModel.getValueAt(i, 0) + "= new G4PVReplica(" + this.slicingDataModel.getValueAt(i, 0) + "\",  //name\n" + "\t\t" + this.slicingDataModel.getValueAt(i, 1) + ",  // its logical\n" + "\t\t" + pMother + ",  // its mother\n" + "\t\t" + this.slicingDataModel.getValueAt(i, 4) + ", // along Axis\n" + "\t\t" + this.slicingDataModel.getValueAt(i, 5) + ", // No of replicas\n" + "\t\t" + this.slicingDataModel.getValueAt(i, 6) + "*" + this.slicingDataModel.getValueAt(i, 7) + ", //  width\n" + "\t\t" + this.slicingDataModel.getValueAt(i, 8) + "*" + this.slicingDataModel.getValueAt(i, 9) + "); // offset\n\n");
        }
        return cpp.toString();
    }
}

