//$Id: ReplicasFrame.java,v 1.9 2004/11/16 06:42:18 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;
//1998 8 20
//GGE 
//Tetsuya Yamada
//2004 Feb 26 prefixes "logical" and "physical" are removed  H. Yoshida

import java.awt.*;
import java.awt.event.*;
import javax.swing.table.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;

class ReplicasFrame extends JPanel implements ActionListener,
						MouseListener{

  private JButton create, ins, dell;
  private JFrame frame1, frame2;
  private JMenuItem close;
  private JComboBox motherCombo;
  JTable repTable;
  GGETableModel repDataModel;
//  private CreateReplicaDialog createRepDialog;
//  private DellReplicaDialog dellRep;
//  private InsertReplicaDialog insertRepDialog;
  private String pValue;
  private String mother;
  private String tableIdent[] = { "pName", "pLogic", "MomType", "pMother", "EAxis", "nReplicas", "Width", "WidthUnit", "Offset", "OffsetUnit" };  

  VolumesFrame volFrame;
  private JComboBox matCombo;
  DefaultComboBoxModel matComboModel;

  ReplicasFrame(VolumesFrame parent){
      volFrame = parent;
      //    super("Slicing Translation ");
//    createRepDialog = new CreateReplicaDialog(this);
//    dellRep = new DellReplicaDialog(this);
//    insertRepDialog = new InsertReplicaDialog(this);

    JPanel panel = new JPanel();
//    phyPanel = new PhysicalPanel(parent);
    panel.setLayout(new BorderLayout(2, 1));
    repTable = new JTable(repDataModel = new GGETableModel(tableIdent,0));
    repTable.setAutoCreateColumnsFromModel(false);
    repTable.setColumnSelectionAllowed(false);
    repTable.setRowSelectionAllowed(true);
    repTable.getTableHeader().setReorderingAllowed(false);
    repTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    repTable.addMouseListener(this);
    JComboBox motherCombo = new JComboBox();
       motherCombo.addItem("logical");
       motherCombo.addItem("physical");
//       motherCombo.addItem("NULL");
//       motherCombo.addActionListener(this);
    JComboBox eAxisCombo = new JComboBox();
       eAxisCombo.addItem("kXAxis");
       eAxisCombo.addItem("kYAxis");
       eAxisCombo.addItem("kZAxis");
//       eAxisCombo.addItem("kRho");
//       eAxisCombo.addItem("kPhi");
    JComboBox angleCombo = new JComboBox();
       angleCombo.addItem("rad");
       angleCombo.addItem("mrad");
       angleCombo.addItem("deg");
    JComboBox widCombo = new JComboBox();
       widCombo.addItem("mm");
       widCombo.addItem("cm");
       widCombo.addItem("m");
       widCombo.addItem("km");
       widCombo.addItem("micrometer");
       widCombo.addItem("nanoometer");
    JComboBox offsetCombo = new JComboBox();
       offsetCombo.addItem("mm");
       offsetCombo.addItem("cm");
       offsetCombo.addItem("m");
       offsetCombo.addItem("km");
       offsetCombo.addItem("micrometer");
       offsetCombo.addItem("nanoometer");
    matCombo = new JComboBox();
       matCombo.setEditable(true);
      matComboModel = new DefaultComboBoxModel();
      matCombo.setModel(matComboModel);
      matComboModel.addElement("");

    TableColumn column[] = new TableColumn[tableIdent.length];
    for (int i=0; i<tableIdent.length; i++){
       column[i] = repTable.getColumn(tableIdent[i]);
    }

    DefaultTableCellRenderer nameCellRenderer = new DefaultTableCellRenderer();
      nameCellRenderer.setBackground(Color.pink);
              column[0].setCellEditor(new NameCellEditor());
              column[0].setCellRenderer(nameCellRenderer);
              column[0].sizeWidthToFit();
              column[0].setResizable(true);
              column[1].setCellEditor(new DefaultCellEditor(matCombo));
              column[2].setCellEditor( new DefaultCellEditor(motherCombo));
              column[3].setCellEditor(new NameCellEditor());
              column[4].setCellEditor( new DefaultCellEditor(eAxisCombo));
              column[5].setCellEditor(new IntCellEditor());
              column[6].setCellEditor( new DoubleCellEditor());
              column[7].setCellEditor( new DefaultCellEditor(widCombo));
              column[8].setCellEditor( new DoubleCellEditor());
              column[9].setCellEditor(new DefaultCellEditor(offsetCombo));

    JScrollPane scrollpane = new JScrollPane(repTable);
    scrollpane.setPreferredSize(new Dimension(750, 180));
    scrollpane.setMinimumSize(new Dimension(50, 25));
    JPanel panel2 = new JPanel();
      panel2.setLayout(new GridLayout(1,3));
      panel2.add(create = new JButton(" Append "));
      panel2.add(ins = new JButton(" Insert "));
      panel2.add(dell = new JButton(" Delete "));
    panel.add("Center",scrollpane);
    panel.add("North",panel2);
    add(panel, BorderLayout.CENTER);

    create.addActionListener(this);
    ins.addActionListener(this);
    dell.addActionListener(this);
    //    setJMenuBar(createMenubar());

    //    pack();

    //    setResizable(false);

//    setBackground(Color.green);

//    setVisible(false);

  }
    /*
  private JMenuBar createMenubar(){

    JMenu file;

    JMenuBar mb = new JMenuBar();

    file = new JMenu("File");

//    file.add(save = new JMenuItem("Save"));

    file.add(close = new JMenuItem("Close"));

    mb.add(file);

    close.addActionListener(this);

    return mb;

  }
    */


  public void actionPerformed(ActionEvent ae){

    Object o = ae.getSource();

    if(o==dell){
	dellRep();
//       dellRep.setVisible(true);

//       dell.setForeground(Color.red);

    }else if(o==create){

       appendRep();

//      createRepDialog.setVisible(true);

//      create.setForeground(Color.red);

    }else if(o==ins){
	insertRep();
//      insertRepDialog.setVisible(true);

//      ins.setForeground(Color.red);

    }else if(o==close){

      setVisible(false);

    }

  }

   public void mousePressed(MouseEvent e){
     JTable table = (JTable)e.getSource();
     if( table.getSelectedColumn() == 1){
       String matStr[] = volFrame.getVolumesName();

       //add
       int modelSize = matComboModel.getSize();
       String modelStr[] = new String[modelSize];
       for(int i=0; i < modelSize; i++){
             modelStr[i] = matComboModel.getElementAt(i).toString();
       }
       boolean exist = false;
       for(int i=0; i < matStr.length; i++){
          for(int j=0; j <  modelSize; j++){
            if( modelStr[j].equals(matStr[i])){
                exist = true;
            }
          }
          if(!exist){ matComboModel.addElement(matStr[i]); }
         exist = false;
       }
       //remove
       modelSize = matComboModel.getSize();
       modelStr = new String[modelSize];
       for(int i=0; i < modelSize; i++){
             modelStr[i] = matComboModel.getElementAt(i).toString();
       }
       exist = false;
       for(int j=0; j < modelSize; j++ ){
          for(int i=0; i < matStr.length; i++){
             if( modelStr[j].equals(matStr[i])){
               exist = true;
             }
          }
          if(!exist &&! modelStr[j].equals("") ){ matComboModel.removeElementAt(j);}
          exist = false;
       }
       repaint();
     }
   }
  public void mouseDragged(MouseEvent e){}
  public void mouseReleased(MouseEvent e){}
  public void mouseClicked(MouseEvent e){}
  public void mouseEntered(MouseEvent e){}
  public void mouseExited(MouseEvent e){}


  public void dellRepCloseAct(){

     dell.setForeground(Color.black);

     dell.repaint();

  }

  public void createRepCloseAct(){

     create.setForeground(Color.black);

     create.repaint();

  }

  public void insertRepCloseAct(){

     ins.setForeground(Color.black);

     ins.repaint();

  }

  public void replicasClear(){

     repTable.setModel(repDataModel =

                             new GGETableModel(tableIdent,0));

     repaint();

  } 

  public void appendRep(){

     Object repTmp[] = new Object[10];

      repTmp[0] = "";

      repTmp[1] = "";

      repTmp[2] = "logical";

      repTmp[3] = "";

      repTmp[4] = "kXAxis";

      repTmp[5] = "";

      repTmp[6] = "";

      repTmp[7] = "mm";

      repTmp[8] = "0.0";

      repTmp[9] = "mm";

     repDataModel.addRow(repTmp);

  }

  public void insertRep(){

     Object tmp[] = new Object[10];

      tmp[0] = "";

      tmp[1] = "";

      tmp[2] = "logical";

      tmp[3] = "";

      tmp[4] = "kXAxis";

      tmp[5] = "";

      tmp[6] = "";

      tmp[7] = "mm";

      tmp[8] = "0.0";

      tmp[9] = "mm";

     if(repTable.getSelectedRow()==-1){

       JOptionPane opane = new JOptionPane();

       opane.showMessageDialog(this, "Choose the pName","Warning Dialog", JOptionPane.WARNING_MESSAGE);

       JDialog dialog = opane.createDialog(this, "Warning Dialog");

      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////

     }else{

      int repRowCount = repTable.getSelectedRow()+1;

      repDataModel.insertRow(repRowCount,tmp);

     }

  }

  

  public void dellRep(){

     if(repTable.getSelectedRow()==-1){

       JOptionPane opane = new JOptionPane();

       opane.showMessageDialog(this, "Choose the pName","Warning Dialog", JOptionPane.WARNING_MESSAGE);

       JDialog dialog = opane.createDialog(this, "Warning Dialog");
 
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////


     }else{

      stopEditing();

      repDataModel.removeRow(repTable.getSelectedRow());

//      dellRep.setVisible(false);

      dell.setForeground(Color.black);

      repaint();

     }

  }
  void stopEditing(){
   int row =0, column =0;
   if(  (row = repTable.getEditingRow()) != -1 &&
          (column = repTable.getEditingColumn()) != -1 ){
         TableCellEditor cellEditor = repTable.getCellEditor(row,column);
         cellEditor.stopCellEditing();
    }

  }


//C++ source code

  String getCPP(){

    StringBuffer cpp = new StringBuffer("\n// Slicing Translation \n\n");

    if(repDataModel.getRowCount()==0){
      return cpp.toString();
    }else{
     for(int i=0;i<repDataModel.getRowCount();i++){
	 //       String pMother = (String)repDataModel.getValueAt(i,2)+
	 //                                   (String)repDataModel.getValueAt(i,3); //2004 Feb 26
	 String pMother = repDataModel.getValueAt(i,3).toString();

	 /*
      cpp.append( "G4PVReplica *  physical"+repDataModel.getValueAt(i,0)+
	  "= new G4PVReplica(\"physical"+repDataModel.getValueAt(i,0)+"\",  //name\n" 
	  +"\t\tlogical"+repDataModel.getValueAt(i,1)+",  // its logical\n"  
	 */
      cpp.append( "G4PVReplica *  "+repDataModel.getValueAt(i,0)+
	  "= new G4PVReplica("+repDataModel.getValueAt(i,0)+"\",  //name\n" 
	  +"\t\t"+repDataModel.getValueAt(i,1)+",  // its logical\n"  
	  + "\t\t" + pMother+",  // its mother\n"
	  + "\t\t" + repDataModel.getValueAt(i,4)+", // along Axis\n"
	  + "\t\t" + repDataModel.getValueAt(i,5)+", // No of replicas\n"
	  + "\t\t" + repDataModel.getValueAt(i,6)+"*"+repDataModel.getValueAt(i,7)+", //  width\n"
	  + "\t\t" + repDataModel.getValueAt(i,8)+"*"+repDataModel.getValueAt(i,9)+"); // offset\n\n");
    }
   }
   return cpp.toString();
  }

}























