//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: G4CascadeSigmaMinusNChannel.cc 67796 2013-03-08 06:18:39Z mkelsey $
//
// 20100804  M. Kelsey -- Add name string to ctor
// 20110719  M. Kelsey -- Add initial state code to ctor
// 20110725  M. Kelsey -- Instantiate cross-section object for self-registration
// 20110916  M. Kelsey -- Drop self-registration due to platform inconsistencies

#include "G4CascadeSigmaMinusNChannel.hh"
#include "G4InuclParticleNames.hh"
using namespace G4InuclParticleNames;

namespace {
  // Outgoing particle types of a given multiplicity

  static const G4int smn2bfs[1][2] =
    {{2,27}};

  static const G4int smn3bfs[6][3] =
    {{2,2,13}, {2,5,21}, {2,7,27}, {1,5,27},  {2,5,25},  {2,15,31}};

  static const G4int smn4bfs[20][4] =
    {{1,2,5,13},   {2,2,5,17}, {2,2,7,13},  {2,5,7,21},   {1,5,5,21},
     {2,13,15,21}, {2,5,5,23}, {2,5,7,25},  {1,5,5,25},   {2,7,7,27},
     {2,3,5,27},   {1,5,7,27}, {2,13,15,25},{2,15,17,27}, {2,11,13,27},
     {1,13,15,27}, {2,5,15,29},{2,5,11,31}, {2,7,15,31},  {1,5,15,31}};

  static const G4int smn5bfs[42][5] =
    {{2,2,5,7,17},   {2,2,3,5,13},   {2,2,7,7,13},   {1,2,5,7,13},
     {1,2,5,5,17},   {1,1,5,5,13},   {1,5,5,7,21},   {2,3,5,5,21},
     {2,5,7,7,21},   {2,7,13,15,21}, {2,5,11,13,21}, {2,5,15,17,21},
     {1,5,13,15,21}, {2,7,7,7,27},   {2,3,5,7,27},   {2,5,5,7,23},
     {2,3,5,5,25},   {1,5,7,7,27},   {1,5,5,5,23},   {1,3,5,5,27},
     {1,5,5,7,25},   {2,5,7,7,25},   {2,7,15,17,27}, {2,3,13,15,27},
     {2,5,11,17,27}, {2,7,11,13,27}, {2,7,13,15,25}, {2,5,11,13,25},
     {2,5,15,17,25}, {1,5,13,15,25}, {1,5,11,13,27}, {1,7,13,15,27}, 
     {2,5,13,15,23}, {1,5,15,17,27}, {2,7,7,15,31},  {2,5,7,11,31},
     {2,3,5,15,31},  {1,5,5,11,31},  {1,5,7,15,31},  {2,5,5,11,29},
     {2,5,7,15,29},  {1,5,5,15,29}};

  static const G4int smn6bfs[25][6] =
    {{2,2,7,7,7,13}, {2,2,3,5,7,13}, {2,2,5,7,7,17}, {2,2,3,5,5,17},
     {1,2,5,7,7,13}, {1,2,3,5,5,13}, {1,2,5,5,7,17}, {1,1,5,5,7,13}, 
     {1,1,5,5,5,17}, {1,5,5,7,7,21}, {1,3,5,5,5,21}, {2,5,7,7,7,21},
     {2,3,5,5,7,21}, {2,7,7,7,7,27}, {2,3,5,7,7,27}, {2,3,3,5,5,27}, 
     {1,5,7,7,7,27}, {1,3,5,5,7,27}, {1,5,5,7,7,25}, {1,3,5,5,5,25},
     {2,5,7,7,7,25}, {2,3,5,5,7,25}, {2,5,5,7,7,23}, {2,3,5,5,5,23},
     {1,5,5,5,7,23}};

  static const G4int smn7bfs[17][7] =
    {{2,2,7,7,7,7,13}, {2,2,3,5,7,7,13}, {2,2,3,3,5,5,13},
     {2,2,5,7,7,7,17}, {2,2,3,5,5,7,17}, {1,2,5,5,7,7,17}, 
     {1,2,3,5,5,5,17}, {1,2,5,7,7,7,13}, {1,2,3,5,5,7,13}, 
     {1,1,5,5,7,7,13}, {1,1,3,5,5,5,13}, {1,1,5,5,5,7,17}, 
     {2,5,7,7,7,7,21}, {2,3,5,5,7,7,21}, {2,3,3,5,5,5,21},
     {1,5,5,7,7,7,21}, {1,3,5,5,5,7,21}};

  // Cross sections for S+ p -> 2-7 body final states
  // 
  // first index:      0: channel for mult = 2
  //                 1-6: channels for mult = 3 
  //                7-26: channels for mult = 4
  //               27-68: channels for mult = 5
  //               69-93: channels for mult = 6
  //              94-110: channels for mult = 7
  //
  // second index: kinetic energy
  // 
  static const G4double smnCrossSections[111][31] = {
    //
    // multiplicity 2 (1 channel)
    //
    // S- n
    {150.0,130.0,110.0, 90.0, 80.0, 70.0, 60.0, 50.0, 40.0, 45.0,
     40.0, 23.30,20.14,16.90,11.80, 9.80, 7.80, 7.00, 6.60, 6.40,
     6.20, 6.10, 5.90, 5.70, 5.50, 5.30, 5.10, 5.00, 4.98, 4.96, 4.70},

    //
    //  multiplicity 3 (6 channels)
    //
    // n n K-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  1.00, 1.50, 1.80, 1.70, 1.50, 1.26, 1.02, 0.93, 0.84,
       0.76, 0.68, 0.61, 0.53, 0.45, 0.38, 0.31, 0.23, 0.21, 0.19, 0.09},

    // L n pi-
    {  0.0,  0.0,  0.0,  0.10, 0.20, 0.30, 0.50, 0.70, 1.00, 1.20,
       1.30, 2.50, 4.00, 4.50, 4.30, 4.00, 3.32, 2.68, 2.45, 2.20,
       1.98, 1.78, 1.60, 1.38, 1.18, 0.96, 0.77, 0.58, 0.53, 0.49, 0.22},
 
    // S- n pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.03,
       0.10, 0.90, 1.50, 1.80, 1.70, 1.50, 1.26, 1.02, 0.93, 0.84,
       0.76, 0.68, 0.61, 0.53, 0.45, 0.38, 0.31, 0.23, 0.21, 0.19, 0.09},
 
    // S- p pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.03,
       0.10, 0.90, 1.50, 1.80, 1.70, 1.50, 1.26, 1.02, 0.93, 0.84,
       0.76, 0.68, 0.61, 0.53, 0.45, 0.38, 0.31, 0.23, 0.21, 0.19, 0.09},
 
    // S0 n pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.03,
       0.10, 0.90, 1.50, 1.80, 1.70, 1.50, 1.26, 1.02, 0.93, 0.84,
       0.76, 0.68, 0.61, 0.53, 0.45, 0.38, 0.31, 0.23, 0.21, 0.19, 0.09},
 
    // X- n K0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.02, 0.03, 0.03, 0.04, 0.04, 0.03, 0.03,
       0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.0,  0.0},
 
    //
    //  multiplicity 4 (20 channels)
    //
    // p n K- pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.10, 0.25, 0.40, 0.60, 0.80, 1.00, 1.20, 1.40, 1.54,
       1.49, 1.41, 1.36, 1.29, 1.24, 1.21, 1.15, 1.11, 1.11, 1.10, 0.98},

    // n n K0bar pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.10, 0.25, 0.40, 0.60, 0.80, 1.00, 1.20, 1.40, 1.54,
       1.49, 1.41, 1.36, 1.29, 1.24, 1.21, 1.15, 1.11, 1.11, 1.10, 0.98},
 
    // n n K- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.10, 0.25, 0.40, 0.60, 0.80, 1.00, 1.20, 1.40, 1.54,
       1.49, 1.41, 1.36, 1.29, 1.24, 1.21, 1.15, 1.11, 1.11, 1.10, 0.98},
 
    // L n pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.03, 0.06,
       0.10, 0.25, 0.40, 0.50, 0.60, 0.75, 0.90, 1.05, 1.20, 1.32,
       1.28, 1.22, 1.18, 1.12, 1.08, 1.05, 1.00, 0.97, 0.97, 0.96, 0.85},
 
    // L p 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.03, 0.06,
       0.10, 0.25, 0.40, 0.50, 0.60, 0.75, 0.90, 1.05, 1.20, 1.32,
       1.28, 1.22, 1.18, 1.12, 1.08, 1.05, 1.00, 0.97, 0.97, 0.96, 0.85},

    // L n K0 K-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // S+ n 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.03, 0.07, 0.13, 0.25, 0.40, 0.60, 0.80, 1.00, 1.10,
       1.07, 1.02, 0.99, 0.94, 0.90, 0.88, 0.84, 0.81, 0.81, 0.80, 0.71},
 
    // S0 n pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.03, 0.07, 0.13, 0.25, 0.40, 0.60, 0.80, 1.00, 1.10,
       1.07, 1.02, 0.99, 0.94, 0.90, 0.88, 0.84, 0.81, 0.81, 0.80, 0.71},

    // S0 p 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.03, 0.07, 0.13, 0.25, 0.40, 0.60, 0.80, 1.00, 1.10,
       1.07, 1.02, 0.99, 0.94, 0.90, 0.88, 0.84, 0.81, 0.81, 0.80, 0.71},
 
    // S- n 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.03, 0.07, 0.13, 0.25, 0.40, 0.60, 0.80, 1.00, 1.10,
       1.07, 1.02, 0.99, 0.94, 0.90, 0.88, 0.84, 0.81, 0.81, 0.80, 0.71},
 
    // S- n pi+ pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.03, 0.07, 0.13, 0.25, 0.40, 0.60, 0.80, 1.00, 1.10,
       1.07, 1.02, 0.99, 0.94, 0.90, 0.88, 0.84, 0.81, 0.81, 0.80, 0.71},
 
    // S- p pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.03, 0.07, 0.13, 0.25, 0.40, 0.60, 0.80, 1.00, 1.10,
       1.07, 1.02, 0.99, 0.94, 0.90, 0.88, 0.84, 0.81, 0.81, 0.80, 0.71},
 
    // S0 n K0 K-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

    // S- n K0 K0bar
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // S- n K+ K-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // S- p K0 K-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // X0 n K0 pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

    // X- n K+ pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // X- n K0 pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
                                                       
    // X- p K0 pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

    //
    //  multiplicity 5 (42 channels)
    // 
    // 
    // n n K0bar pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.06, 0.07, 0.09, 0.13,
       0.15, 0.17, 0.18, 0.22, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.20},
 
    // n n K- pi+ pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.03, 0.06, 0.10, 0.11, 0.13, 0.20,
       0.23, 0.26, 0.28, 0.33, 0.32, 0.32, 0.32, 0.32, 0.32, 0.32, 0.30},
 
    // n n K- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.03, 0.06, 0.10, 0.11, 0.13, 0.20,
       0.23, 0.26, 0.28, 0.33, 0.32, 0.32, 0.32, 0.32, 0.32, 0.32, 0.30},

    // p n K- pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.03, 0.06, 0.10, 0.11, 0.13, 0.20,
       0.23, 0.26, 0.28, 0.33, 0.32, 0.32, 0.32, 0.32, 0.32, 0.32, 0.30},

    // p n K0bar 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.03, 0.06, 0.10, 0.11, 0.13, 0.20,
       0.23, 0.26, 0.28, 0.33, 0.32, 0.32, 0.32, 0.32, 0.32, 0.32, 0.30},

    // p p K- 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.03, 0.06, 0.10, 0.11, 0.13, 0.20,
       0.23, 0.26, 0.28, 0.33, 0.32, 0.32, 0.32, 0.32, 0.32, 0.32, 0.30},

    // L p 2pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.04, 0.04, 0.08, 0.12, 0.16, 0.17, 0.18, 0.23,
       0.26, 0.30, 0.32, 0.37, 0.36, 0.36, 0.36, 0.36, 0.35, 0.35, 0.33},
 
    // L n pi+ 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.04, 0.04, 0.14, 0.18, 0.24, 0.26, 0.28, 0.35,
       0.40, 0.45, 0.48, 0.56, 0.54, 0.54, 0.54, 0.53, 0.52, 0.51, 0.47},
 
    // L n pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.04, 0.04, 0.14, 0.18, 0.24, 0.26, 0.28, 0.35,
       0.40, 0.45, 0.48, 0.56, 0.54, 0.54, 0.54, 0.53, 0.52, 0.51, 0.47},

    // L n K0 K- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // L n K+ K- pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // L n K0 K0bar pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
   
    // L p K0 K- pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // S- n 3pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.03, 0.06, 0.07, 0.09, 0.13,
       0.15, 0.17, 0.18, 0.22, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.20},
 
    // S- n pi+ pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.05, 0.10, 0.11, 0.13, 0.20,
       0.23, 0.26, 0.28, 0.33, 0.32, 0.32, 0.32, 0.32, 0.32, 0.32, 0.30},

    // S+ n 2pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.03, 0.06, 0.07, 0.09, 0.13,
       0.15, 0.17, 0.18, 0.22, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.20},
 
    // S0 n pi+ 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.05, 0.10, 0.11, 0.13, 0.20,
       0.23, 0.26, 0.28, 0.33, 0.32, 0.32, 0.32, 0.32, 0.32, 0.32, 0.30},
 
    // S- p pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.03, 0.06, 0.07, 0.09, 0.13,
       0.15, 0.17, 0.18, 0.22, 0.21, 0.21, 0.21, 0.21, 0.21, 0.21, 0.20},
 
    // S+ p 3pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.05, 0.10, 0.11, 0.13, 0.20,
       0.23, 0.26, 0.28, 0.33, 0.32, 0.32, 0.32, 0.32, 0.32, 0.32, 0.30},
 
    // S- p pi+ 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.05, 0.10, 0.11, 0.13, 0.20,
       0.23, 0.26, 0.28, 0.33, 0.32, 0.32, 0.32, 0.32, 0.32, 0.32, 0.30},
 
    // S0 p 2pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.05, 0.10, 0.11, 0.13, 0.20,
       0.23, 0.26, 0.28, 0.33, 0.32, 0.32, 0.32, 0.32, 0.32, 0.32, 0.30},
 
    // S0 n pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.05, 0.10, 0.11, 0.13, 0.20,
       0.23, 0.26, 0.28, 0.33, 0.32, 0.32, 0.32, 0.32, 0.32, 0.32, 0.30},
 
    // S- n K0 K0bar pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // S- n K0 K- pi+
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // S- n K+ K0bar pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},

    // S- n K+ K- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // S0 n K0 K- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // S0 n K+ K- pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},

    // S0 n K0 K0bar pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // S0 p K0 K- pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // S- p K+ K- pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // S- p K0 K- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // S+ n K0 K- pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // S- p K0 K0bar pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // X- n K0 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // X- n K+ pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // X- n K0 pi+ pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // X- p K+ 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // X- p K0 pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // X0 n K+ 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // X0 n K0 pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    // X0 p K0 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
       0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},
 
    //
    //  multiplicity 6 (25 channels)
    // 
    // n n K- 3pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
       0.06, 0.07, 0.08, 0.10, 0.12, 0.12, 0.13, 0.13, 0.13, 0.13, 0.12},
 
    // n n K- pi+ pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 
       0.09, 0.11, 0.13, 0.15, 0.18, 0.18, 0.19, 0.20, 0.20, 0.20, 0.18},

    // n n K0bar pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
       0.06, 0.07, 0.08, 0.10, 0.12, 0.12, 0.13, 0.13, 0.13, 0.13, 0.12},
 
    // n n K0bar pi+ 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 
       0.09, 0.11, 0.13, 0.15, 0.18, 0.18, 0.19, 0.20, 0.20, 0.20, 0.18},

    // p n K- pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
       0.06, 0.07, 0.08, 0.10, 0.12, 0.12, 0.13, 0.13, 0.13, 0.13, 0.12},
 
    // p n K- pi+ 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 
       0.09, 0.11, 0.13, 0.15, 0.18, 0.18, 0.19, 0.20, 0.20, 0.20, 0.18},

    // p n K0bar 2pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
       0.06, 0.07, 0.08, 0.10, 0.12, 0.12, 0.13, 0.13, 0.13, 0.13, 0.12},
 
    // p p K- 2pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
       0.06, 0.07, 0.08, 0.10, 0.12, 0.12, 0.13, 0.13, 0.13, 0.13, 0.12},
                                                                            
    // p p K0bar 3pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
       0.06, 0.07, 0.08, 0.10, 0.12, 0.12, 0.13, 0.13, 0.13, 0.13, 0.12},
 
    // L p 2pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.03, 0.06, 0.08, 0.10, 0.12, 0.14,
       0.16, 0.20, 0.24, 0.28, 0.33, 0.34, 0.36, 0.38, 0.38, 0.38, 0.34},
        
    // L p pi+ 3pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.05, 0.10, 0.13, 0.15, 0.18, 0.22,
       0.25, 0.31, 0.36, 0.42, 0.50, 0.51, 0.54, 0.57, 0.58, 0.58, 0.52},
 
    // L n pi- 3pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.03, 0.06, 0.08, 0.10, 0.12, 0.14,
       0.16, 0.20, 0.24, 0.28, 0.33, 0.34, 0.36, 0.38, 0.38, 0.38, 0.34},
 
    // L n pi+ 2pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.05, 0.10, 0.13, 0.15, 0.18, 0.22,
       0.25, 0.31, 0.36, 0.42, 0.50, 0.51, 0.54, 0.57, 0.58, 0.58, 0.52},
 
    // S- n 4pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
       0.06, 0.07, 0.08, 0.10, 0.12, 0.12, 0.13, 0.13, 0.13, 0.13, 0.12},
 
    // S- n pi+ pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.03, 0.05, 0.06, 0.07, 0.08,
       0.09, 0.11, 0.13, 0.15, 0.18, 0.18, 0.19, 0.20, 0.20, 0.20, 0.18},
 
    // S- n 2pi+ 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 
       0.09, 0.11, 0.13, 0.15, 0.18, 0.18, 0.19, 0.20, 0.20, 0.20, 0.18},

    // S- p pi- 3pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
       0.06, 0.07, 0.08, 0.10, 0.12, 0.12, 0.13, 0.13, 0.13, 0.13, 0.12},
 
    // S- p pi+ 2pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 
       0.09, 0.11, 0.13, 0.15, 0.18, 0.18, 0.19, 0.20, 0.20, 0.20, 0.18},
 
    // S0 p 2pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
       0.06, 0.07, 0.08, 0.10, 0.12, 0.12, 0.13, 0.13, 0.13, 0.13, 0.12},
 
    // S0 p pi+ 3pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 
       0.09, 0.11, 0.13, 0.15, 0.18, 0.18, 0.19, 0.20, 0.20, 0.20, 0.18},

    // S0 n pi- 3pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
       0.06, 0.07, 0.08, 0.10, 0.12, 0.12, 0.13, 0.13, 0.13, 0.13, 0.12},
 
    // S0 n pi+ 2pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 
       0.09, 0.11, 0.13, 0.15, 0.18, 0.18, 0.19, 0.20, 0.20, 0.20, 0.18},
 
    // S+ n 2pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.06,
       0.06, 0.07, 0.08, 0.10, 0.12, 0.12, 0.13, 0.13, 0.13, 0.13, 0.12},
 
    // S+ n pi+ 3pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 
       0.09, 0.11, 0.13, 0.15, 0.18, 0.18, 0.19, 0.20, 0.20, 0.20, 0.18},
                               
    // S+ p 3pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 
       0.09, 0.11, 0.13, 0.15, 0.18, 0.18, 0.19, 0.20, 0.20, 0.20, 0.18},

    //
    //  multiplicity 7 (17 channels)
    // 
    // n n K- 4pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03,
       0.04, 0.04, 0.05, 0.07, 0.08, 0.09, 0.10, 0.12, 0.12, 0.12, 0.12},
 
    // n n K- pi+ pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03,
       0.04, 0.04, 0.05, 0.07, 0.08, 0.09, 0.10, 0.12, 0.12, 0.12, 0.12},

    // n n K- 2pi+ 2pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.04,
       0.05, 0.06, 0.08, 0.10, 0.12, 0.14, 0.16, 0.19, 0.19, 0.19, 0.19},
 
    // n n K0bar pi- 3pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03,
       0.04, 0.04, 0.05, 0.07, 0.08, 0.09, 0.10, 0.12, 0.12, 0.12, 0.12},
 
    // n n K0bar pi+ 2pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.04,
       0.05, 0.06, 0.08, 0.10, 0.12, 0.14, 0.16, 0.19, 0.19, 0.19, 0.19},
 
    // p n K0bar 2pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03,
       0.04, 0.04, 0.05, 0.07, 0.08, 0.09, 0.10, 0.12, 0.12, 0.12, 0.12},
 
    // p n K0bar pi+ 3pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.04,
       0.05, 0.06, 0.08, 0.10, 0.12, 0.14, 0.16, 0.19, 0.19, 0.19, 0.19},
  
    // p n K- pi- 3pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03,
       0.04, 0.04, 0.05, 0.07, 0.08, 0.09, 0.10, 0.12, 0.12, 0.12, 0.12},
 
    // p n K- pi+ 2pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.04,
       0.05, 0.06, 0.08, 0.10, 0.12, 0.14, 0.16, 0.19, 0.19, 0.19, 0.19},
 
    // p p K- 2pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03,
       0.04, 0.04, 0.05, 0.07, 0.08, 0.09, 0.10, 0.12, 0.12, 0.12, 0.12},
 
    // p p K- pi+ 3pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.04,
       0.05, 0.06, 0.08, 0.10, 0.12, 0.14, 0.16, 0.19, 0.19, 0.19, 0.19},

    // p p K0bar 3pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.04,
       0.05, 0.06, 0.08, 0.10, 0.12, 0.14, 0.16, 0.19, 0.19, 0.19, 0.19},
 
    // L n pi- 4pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.03, 0.04, 0.05, 0.06,
       0.08, 0.10, 0.13, 0.14, 0.17, 0.19, 0.22, 0.26, 0.26, 0.26, 0.26},
 
    // L n pi+ 2pi- 2pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.04, 0.06, 0.07, 0.08,
       0.11, 0.13, 0.17, 0.22, 0.26, 0.29, 0.33, 0.40, 0.40, 0.40, 0.40},
 
    // L n 2pi+ 3pi-
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.06, 0.09, 0.11, 0.12,
       0.16, 0.20, 0.26, 0.33, 0.40, 0.47, 0.55, 0.60, 0.60, 0.60, 0.60},
 
    // L p 2pi- 3pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.04, 0.06, 0.07, 0.08,
       0.11, 0.13, 0.17, 0.22, 0.26, 0.29, 0.33, 0.40, 0.40, 0.40, 0.40},
 
    // L p pi+ 3pi- pi0
    {  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.02, 0.04, 0.06, 0.09, 0.11, 0.12,
       0.16, 0.20, 0.26, 0.33, 0.40, 0.47, 0.55, 0.60, 0.60, 0.60, 0.60}};
}

const G4CascadeSigmaMinusNChannelData::data_t
G4CascadeSigmaMinusNChannelData::data(smn2bfs, smn3bfs, smn4bfs,
				      smn5bfs, smn6bfs, smn7bfs,
				      smnCrossSections, sm*neu, "SigmaMinusN");
