//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// neutron_hp -- source file
// J.P. Wellisch, Nov-1996
// A prototype of the low energy neutron transport model.
#include "G4NeutronHPFastLegendre.hh"

const G4double G4NeutronHPFastLegendre::l24[5001] = {1,
  0.883541, 0.773979, 0.671041, 0.574464, 0.483992, 0.399377,
  0.320376, 0.246757, 0.178293, 0.114763, 0.0559551, 0.00166246,
  -0.0483149, -0.0941707, -0.136093, -0.174262, -0.208856, -0.240043,
  -0.267988, -0.292851, -0.314786, -0.33394, -0.350459, -0.36448,
  -0.376138, -0.385563, -0.392879, -0.398207, -0.401663, -0.403359,
  -0.403404, -0.401901, -0.39895, -0.394648, -0.389088, -0.382359,
  -0.374547, -0.365734, -0.356, -0.34542, -0.334067, -0.322012,
  -0.309321, -0.296059, -0.282286, -0.268062, -0.253443, -0.238482,
  -0.223231, -0.207738, -0.192051, -0.176213, -0.160266, -0.14425,
  -0.128205, -0.112164, -0.0961638, -0.0802352, -0.0644092,
  -0.0487145, -0.0331782, -0.0178259, -0.00268135, 0.0122329,
  0.0268959, 0.0412881, 0.0553913, 0.0691886, 0.0826644, 0.0958044,
  0.108595, 0.121025, 0.133082, 0.144758, 0.156042, 0.166928,
  0.177407, 0.187475, 0.197125, 0.206353, 0.215156, 0.223531,
  0.231475, 0.238988, 0.246068, 0.252715, 0.25893, 0.264714, 0.270069,
  0.274996, 0.279498, 0.283578, 0.287241, 0.290489, 0.293328,
  0.295762, 0.297796, 0.299436, 0.300688, 0.301557, 0.302051,
  0.302175, 0.301936, 0.301343, 0.300402, 0.29912, 0.297506, 0.295568,
  0.293312, 0.290748, 0.287884, 0.284728, 0.281289, 0.277575,
  0.273596, 0.269359, 0.264873, 0.260147, 0.255191, 0.250013,
  0.244621, 0.239025, 0.233234, 0.227256, 0.2211, 0.214775, 0.20829,
  0.201653, 0.194874, 0.187959, 0.180919, 0.173762, 0.166495,
  0.159128, 0.151668, 0.144123, 0.136502, 0.128812, 0.121062,
  0.113258, 0.105409, 0.0975214, 0.0896032, 0.0816614, 0.0737031,
  0.0657352, 0.0577647, 0.0497981, 0.041842, 0.033903, 0.0259871,
  0.0181007, 0.0102497, 0.00243989, -0.0053229, -0.0130331,
  -0.0206853, -0.0282743, -0.0357948, -0.0432419, -0.0506107,
  -0.0578966, -0.065095, -0.0722014, -0.0792116, -0.0861215,
  -0.0929272, -0.0996247, -0.10621, -0.112681, -0.119033, -0.125262,
  -0.131367, -0.137344, -0.143189, -0.148902, -0.154478, -0.159915,
  -0.165212, -0.170366, -0.175374, -0.180236, -0.18495, -0.189513,
  -0.193924, -0.198182, -0.202286, -0.206234, -0.210025, -0.21366,
  -0.217135, -0.220453, -0.22361, -0.226608, -0.229445, -0.232122,
  -0.234638, -0.236994, -0.239189, -0.241224, -0.243098, -0.244813,
  -0.246369, -0.247765, -0.249004, -0.250085, -0.25101, -0.251779,
  -0.252393, -0.252854, -0.253162, -0.253318, -0.253325, -0.253182,
  -0.252893, -0.252457, -0.251877, -0.251155, -0.250291, -0.249288,
  -0.248148, -0.246871, -0.245461, -0.243919, -0.242247, -0.240447,
  -0.238521, -0.236471, -0.2343, -0.23201, -0.229602, -0.227079,
  -0.224444, -0.221699, -0.218845, -0.215886, -0.212824, -0.209662,
  -0.206401, -0.203045, -0.199595, -0.196055, -0.192426, -0.188712,
  -0.184915, -0.181038, -0.177083, -0.173053, -0.16895, -0.164777,
  -0.160537, -0.156233, -0.151866, -0.14744, -0.142957, -0.138419,
  -0.133831, -0.129193, -0.124509, -0.119782, -0.115013, -0.110206,
  -0.105364, -0.100487, -0.0955805, -0.0906454, -0.0856847,
  -0.0807009, -0.0756965, -0.070674, -0.0656359, -0.0605845,
  -0.0555224, -0.050452, -0.0453757, -0.0402958, -0.0352147,
  -0.0301346, -0.0250581, -0.0199872, -0.0149242, -0.00987146,
  -0.00483106, 0.000194793, 0.00520396, 0.0101943, 0.0151638,
  0.0201103, 0.0250318, 0.0299264, 0.034792, 0.0396268, 0.0444288,
  0.0491962, 0.053927, 0.0586196, 0.0632722, 0.0678829, 0.0724502,
  0.0769723, 0.0814477, 0.0858746, 0.0902516, 0.0945771, 0.0988496,
  0.103068, 0.10723, 0.111335, 0.115381, 0.119368, 0.123293, 0.127156,
  0.130955, 0.13469, 0.138359, 0.14196, 0.145494, 0.148958, 0.152352,
  0.155676, 0.158927, 0.162106, 0.165211, 0.168241, 0.171196,
  0.174076, 0.176878, 0.179604, 0.182251, 0.18482, 0.18731, 0.18972,
  0.19205, 0.194299, 0.196468, 0.198555, 0.200561, 0.202485, 0.204326,
  0.206085, 0.207761, 0.209354, 0.210865, 0.212292, 0.213635,
  0.214896, 0.216073, 0.217167, 0.218177, 0.219105, 0.219949, 0.22071,
  0.221389, 0.221984, 0.222498, 0.222929, 0.223278, 0.223546,
  0.223732, 0.223837, 0.223862, 0.223807, 0.223672, 0.223457,
  0.223164, 0.222793, 0.222344, 0.221817, 0.221214, 0.220535, 0.21978,
  0.218951, 0.218047, 0.21707, 0.21602, 0.214898, 0.213704, 0.212441,
  0.211107, 0.209704, 0.208233, 0.206695, 0.20509, 0.20342, 0.201684,
  0.199885, 0.198023, 0.196099, 0.194113, 0.192068, 0.189963, 0.1878,
  0.18558, 0.183303, 0.180971, 0.178585, 0.176146, 0.173655, 0.171112,
  0.16852, 0.165878, 0.163189, 0.160453, 0.157671, 0.154844, 0.151974,
  0.149061, 0.146108, 0.143114, 0.140081, 0.13701, 0.133902, 0.130759,
  0.127582, 0.124371, 0.121128, 0.117854, 0.11455, 0.111217, 0.107857,
  0.104471, 0.101059, 0.0976237, 0.0941653, 0.0906851, 0.0871845,
  0.0836644, 0.0801261, 0.0765708, 0.0729996, 0.0694136, 0.065814,
  0.062202, 0.0585787, 0.0549452, 0.0513026, 0.0476522, 0.0439949,
  0.0403321, 0.0366646, 0.0329938, 0.0293206, 0.0256462, 0.0219716,
  0.0182981, 0.0146265, 0.010958, 0.00729375, 0.00363468,
  -1.81187e-05, -0.0036636, -0.00730074, -0.0109285, -0.0145459,
  -0.0181519, -0.0217455, -0.0253258, -0.0288917, -0.0324422,
  -0.0359765, -0.0394936, -0.0429925, -0.0464723, -0.0499322,
  -0.0533711, -0.0567882, -0.0601826, -0.0635535, -0.0669, -0.0702212,
  -0.0735163, -0.0767845, -0.0800249, -0.0832368, -0.0864194,
  -0.089572, -0.0926936, -0.0957837, -0.0988414, -0.101866, -0.104857,
  -0.107813, -0.110735, -0.11362, -0.116469, -0.119281, -0.122055,
  -0.124791, -0.127488, -0.130145, -0.132762, -0.135338, -0.137873,
  -0.140367, -0.142818, -0.145226, -0.147591, -0.149912, -0.152189,
  -0.154422, -0.156609, -0.158751, -0.160846, -0.162896, -0.164899,
  -0.166854, -0.168763, -0.170623, -0.172436, -0.1742, -0.175915,
  -0.177582, -0.179199, -0.180767, -0.182285, -0.183753, -0.185171,
  -0.186539, -0.187856, -0.189123, -0.190339, -0.191503, -0.192617,
  -0.19368, -0.194691, -0.195651, -0.196559, -0.197416, -0.198221,
  -0.198975, -0.199677, -0.200328, -0.200927, -0.201474, -0.20197,
  -0.202414, -0.202807, -0.203149, -0.203439, -0.203678, -0.203866,
  -0.204003, -0.204089, -0.204125, -0.20411, -0.204044, -0.203928,
  -0.203763, -0.203547, -0.203282, -0.202968, -0.202604, -0.202192,
  -0.201731, -0.201221, -0.200664, -0.200058, -0.199405, -0.198705,
  -0.197958, -0.197165, -0.196325, -0.195439, -0.194508, -0.193531,
  -0.19251, -0.191445, -0.190335, -0.189182, -0.187985, -0.186746,
  -0.185464, -0.184141, -0.182775, -0.181369, -0.179922, -0.178436,
  -0.176909, -0.175343, -0.173738, -0.172096, -0.170415, -0.168697,
  -0.166943, -0.165152, -0.163326, -0.161464, -0.159568, -0.157638,
  -0.155674, -0.153677, -0.151648, -0.149587, -0.147495, -0.145372,
  -0.143218, -0.141035, -0.138824, -0.136583, -0.134315, -0.13202,
  -0.129698, -0.12735, -0.124976, -0.122578, -0.120155, -0.117709,
  -0.11524, -0.112748, -0.110235, -0.1077, -0.105145, -0.10257,
  -0.0999764, -0.0973636, -0.0947329, -0.0920848, -0.0894199,
  -0.086739, -0.0840426, -0.0813314, -0.0786059, -0.075867,
  -0.0731151, -0.070351, -0.0675752, -0.0647884, -0.0619912,
  -0.0591843, -0.0563684, -0.053544, -0.0507117, -0.0478723,
  -0.0450263, -0.0421744, -0.0393172, -0.0364554, -0.0335895,
  -0.0307202, -0.0278482, -0.024974, -0.0220982, -0.0192216,
  -0.0163446, -0.0134679, -0.0105922, -0.00771797, -0.00484589,
  -0.00197656, 0.000889438, 0.0037515, 0.00660902, 0.00946143,
  0.0123081, 0.0151485, 0.0179821, 0.0208082, 0.0236262, 0.0264357,
  0.029236, 0.0320266, 0.034807, 0.0375765, 0.0403346, 0.0430809,
  0.0458146, 0.0485354, 0.0512427, 0.0539359, 0.0566145, 0.0592781,
  0.0619261, 0.064558, 0.0671733, 0.0697715, 0.0723522, 0.0749147,
  0.0774588, 0.0799838, 0.0824893, 0.084975, 0.0874402, 0.0898845,
  0.0923076, 0.094709, 0.0970881, 0.0994447, 0.101778, 0.104089,
  0.106375, 0.108637, 0.110874, 0.113087, 0.115274, 0.117435,
  0.119571, 0.121679, 0.123761, 0.125816, 0.127843, 0.129842,
  0.131813, 0.133755, 0.135669, 0.137553, 0.139408, 0.141233,
  0.143028, 0.144793, 0.146527, 0.14823, 0.149902, 0.151543, 0.153152,
  0.154729, 0.156274, 0.157787, 0.159267, 0.160714, 0.162128, 0.16351,
  0.164857, 0.166172, 0.167452, 0.168699, 0.169911, 0.17109, 0.172233,
  0.173343, 0.174418, 0.175458, 0.176463, 0.177433, 0.178368,
  0.179268, 0.180132, 0.180961, 0.181755, 0.182513, 0.183235,
  0.183922, 0.184573, 0.185189, 0.185768, 0.186312, 0.18682, 0.187292,
  0.187728, 0.188128, 0.188493, 0.188821, 0.189114, 0.189371,
  0.189592, 0.189777, 0.189927, 0.190041, 0.190119, 0.190162,
  0.190169, 0.190141, 0.190078, 0.189979, 0.189846, 0.189677,
  0.189473, 0.189235, 0.188962, 0.188654, 0.188312, 0.187935,
  0.187524, 0.18708, 0.186601, 0.186089, 0.185543, 0.184964, 0.184351,
  0.183706, 0.183028, 0.182317, 0.181574, 0.180798, 0.179991,
  0.179151, 0.17828, 0.177378, 0.176444, 0.17548, 0.174485, 0.173459,
  0.172403, 0.171318, 0.170202, 0.169058, 0.167884, 0.166681,
  0.165449, 0.16419, 0.162902, 0.161586, 0.160243, 0.158873, 0.157476,
  0.156052, 0.154602, 0.153126, 0.151624, 0.150097, 0.148545,
  0.146968, 0.145367, 0.143742, 0.142093, 0.140421, 0.138725,
  0.137007, 0.135267, 0.133504, 0.13172, 0.129915, 0.128089, 0.126242,
  0.124375, 0.122488, 0.120582, 0.118656, 0.116712, 0.114749,
  0.112768, 0.11077, 0.108755, 0.106722, 0.104673, 0.102608, 0.100528,
  0.0984315, 0.0963205, 0.0941949, 0.0920552, 0.0899017, 0.0877348,
  0.085555, 0.0833626, 0.081158, 0.0789416, 0.0767139, 0.0744751,
  0.0722258, 0.0699662, 0.0676969, 0.0654183, 0.0631306, 0.0608344,
  0.0585299, 0.0562178, 0.0538982, 0.0515717, 0.0492387, 0.0468995,
  0.0445546, 0.0422043, 0.0398491, 0.0374893, 0.0351254, 0.0327578,
  0.0303868, 0.028013, 0.0256366, 0.023258, 0.0208778, 0.0184962,
  0.0161137, 0.0137307, 0.0113475, 0.00896462, 0.00658236, 0.00420115,
  0.00182138, -0.000556564, -0.00293229, -0.00530542, -0.00767555,
  -0.0100423, -0.0124053, -0.0147642, -0.0171185, -0.019468,
  -0.0218122, -0.0241507, -0.0264832, -0.0288094, -0.0311288,
  -0.033441, -0.0357458, -0.0380427, -0.0403314, -0.0426116,
  -0.0448828, -0.0471448, -0.0493971, -0.0516395, -0.0538715,
  -0.0560929, -0.0583033, -0.0605024, -0.0626897, -0.0648651,
  -0.0670282, -0.0691785, -0.0713159, -0.07344, -0.0755505, -0.077647,
  -0.0797293, -0.0817971, -0.0838499, -0.0858876, -0.0879099,
  -0.0899163, -0.0919067, -0.0938808, -0.0958383, -0.0977788,
  -0.0997021, -0.101608, -0.103496, -0.105366, -0.107218, -0.109051,
  -0.110866, -0.112661, -0.114437, -0.116194, -0.117931, -0.119647,
  -0.121344, -0.12302, -0.124675, -0.126309, -0.127922, -0.129514,
  -0.131084, -0.132632, -0.134159, -0.135662, -0.137144, -0.138603,
  -0.140039, -0.141452, -0.142842, -0.144208, -0.145551, -0.146871,
  -0.148166, -0.149437, -0.150685, -0.151907, -0.153106, -0.154279,
  -0.155428, -0.156552, -0.157651, -0.158725, -0.159773, -0.160796,
  -0.161793, -0.162765, -0.163711, -0.164631, -0.165525, -0.166393,
  -0.167235, -0.168051, -0.16884, -0.169603, -0.170339, -0.171049,
  -0.171732, -0.172388, -0.173018, -0.173621, -0.174197, -0.174746,
  -0.175268, -0.175764, -0.176232, -0.176673, -0.177087, -0.177474,
  -0.177834, -0.178167, -0.178472, -0.178751, -0.179002, -0.179226,
  -0.179424, -0.179594, -0.179737, -0.179852, -0.179941, -0.180003,
  -0.180038, -0.180045, -0.180026, -0.17998, -0.179908, -0.179808,
  -0.179682, -0.179529, -0.179349, -0.179143, -0.17891, -0.178651,
  -0.178366, -0.178054, -0.177717, -0.177353, -0.176963, -0.176547,
  -0.176106, -0.175639, -0.175146, -0.174628, -0.174084, -0.173516,
  -0.172922, -0.172303, -0.171659, -0.170991, -0.170298, -0.16958,
  -0.168839, -0.168073, -0.167283, -0.166469, -0.165631, -0.16477,
  -0.163885, -0.162977, -0.162046, -0.161092, -0.160116, -0.159116,
  -0.158095, -0.157051, -0.155985, -0.154897, -0.153788, -0.152657,
  -0.151505, -0.150331, -0.149137, -0.147922, -0.146687, -0.145431,
  -0.144155, -0.14286, -0.141545, -0.14021, -0.138856, -0.137483,
  -0.136092, -0.134681, -0.133253, -0.131806, -0.130342, -0.12886,
  -0.12736, -0.125843, -0.12431, -0.12276, -0.121193, -0.11961,
  -0.118011, -0.116397, -0.114767, -0.113122, -0.111461, -0.109787,
  -0.108097, -0.106394, -0.104677, -0.102946, -0.101201, -0.0994439,
  -0.0976736, -0.0958906, -0.0940954, -0.092288, -0.0904689,
  -0.0886382, -0.0867963, -0.0849435, -0.0830799, -0.0812059,
  -0.0793217, -0.0774277, -0.075524, -0.0736111, -0.071689,
  -0.0697583, -0.067819, -0.0658715, -0.0639162, -0.0619531,
  -0.0599828, -0.0580053, -0.056021, -0.0540303, -0.0520333,
  -0.0500304, -0.0480218, -0.0460079, -0.0439888, -0.041965,
  -0.0399367, -0.0379041, -0.0358676, -0.0338274, -0.0317838,
  -0.0297372, -0.0276877, -0.0256358, -0.0235816, -0.0215254,
  -0.0194676, -0.0174084, -0.0153481, -0.013287, -0.0112254,
  -0.0091635, -0.00710165, -0.00504011, -0.00297917, -0.000919097,
  0.00113982, 0.0031973, 0.00525307, 0.00730685, 0.00935837,
  0.0114073, 0.0134535, 0.0154966, 0.0175363, 0.0195724, 0.0216045,
  0.0236325, 0.0256561, 0.0276749, 0.0296888, 0.0316974, 0.0337005,
  0.0356978, 0.0376891, 0.0396741, 0.0416525, 0.0436241, 0.0455887,
  0.0475459, 0.0494955, 0.0514374, 0.0533711, 0.0552965, 0.0572133,
  0.0591213, 0.0610202, 0.0629098, 0.0647899, 0.0666602, 0.0685204,
  0.0703703, 0.0722098, 0.0740385, 0.0758563, 0.0776628, 0.079458,
  0.0812415, 0.0830131, 0.0847726, 0.0865198, 0.0882545, 0.0899764,
  0.0916854, 0.0933813, 0.0950637, 0.0967326, 0.0983876, 0.100029,
  0.101656, 0.103268, 0.104866, 0.106449, 0.108017, 0.10957, 0.111108,
  0.11263, 0.114137, 0.115627, 0.117102, 0.11856, 0.120002, 0.121427,
  0.122835, 0.124227, 0.125601, 0.126959, 0.128298, 0.129621,
  0.130925, 0.132212, 0.133481, 0.134731, 0.135963, 0.137177,
  0.138372, 0.139549, 0.140707, 0.141845, 0.142965, 0.144066,
  0.145147, 0.146208, 0.14725, 0.148273, 0.149275, 0.150258, 0.151221,
  0.152163, 0.153085, 0.153988, 0.154869, 0.15573, 0.156571, 0.157391,
  0.15819, 0.158968, 0.159726, 0.160462, 0.161177, 0.161872, 0.162545,
  0.163197, 0.163827, 0.164436, 0.165024, 0.16559, 0.166135, 0.166658,
  0.167159, 0.167639, 0.168097, 0.168534, 0.168949, 0.169341,
  0.169712, 0.170062, 0.170389, 0.170694, 0.170978, 0.17124, 0.171479,
  0.171697, 0.171893, 0.172067, 0.172219, 0.172349, 0.172457,
  0.172543, 0.172608, 0.17265, 0.17267, 0.172669, 0.172646, 0.172601,
  0.172534, 0.172446, 0.172336, 0.172204, 0.17205, 0.171875, 0.171679,
  0.17146, 0.171221, 0.17096, 0.170677, 0.170374, 0.170049, 0.169703,
  0.169336, 0.168948, 0.168538, 0.168108, 0.167657, 0.167186,
  0.166694, 0.166181, 0.165647, 0.165094, 0.164519, 0.163925,
  0.163311, 0.162676, 0.162022, 0.161347, 0.160653, 0.15994, 0.159207,
  0.158454, 0.157682, 0.156891, 0.156081, 0.155252, 0.154404,
  0.153537, 0.152652, 0.151748, 0.150826, 0.149886, 0.148928,
  0.147952, 0.146958, 0.145946, 0.144917, 0.14387, 0.142807, 0.141726,
  0.140628, 0.139514, 0.138383, 0.137235, 0.136071, 0.134891,
  0.133695, 0.132483, 0.131256, 0.130013, 0.128754, 0.127481,
  0.126192, 0.124889, 0.123571, 0.122239, 0.120892, 0.119531,
  0.118156, 0.116768, 0.115365, 0.11395, 0.112521, 0.111079, 0.109625,
  0.108157, 0.106677, 0.105185, 0.103681, 0.102165, 0.100637,
  0.0990982, 0.0975477, 0.095986, 0.0944135, 0.0928302, 0.0912365,
  0.0896324, 0.0880182, 0.0863941, 0.0847604, 0.0831171, 0.0814646,
  0.0798029, 0.0781325, 0.0764533, 0.0747657, 0.0730699, 0.071366,
  0.0696543, 0.0679351, 0.0662084, 0.0644745, 0.0627337, 0.0609862,
  0.059232, 0.0574716, 0.0557051, 0.0539327, 0.0521546, 0.0503711,
  0.0485823, 0.0467885, 0.0449899, 0.0431867, 0.0413792, 0.0395675,
  0.0377519, 0.0359326, 0.0341098, 0.0322837, 0.0304546, 0.0286227,
  0.0267881, 0.0249512, 0.0231121, 0.0212711, 0.0194283, 0.017584,
  0.0157384, 0.0138918, 0.0120443, 0.0101962, 0.00834765, 0.00649892,
  0.00465021, 0.00280175, 0.000953745, -0.000893581, -0.00274001,
  -0.00458533, -0.00642932, -0.00827177, -0.0101125, -0.0119512,
  -0.0137877, -0.0156218, -0.0174533, -0.019282, -0.0211077,
  -0.0229301, -0.024749, -0.0265643, -0.0283756, -0.0301829,
  -0.0319859, -0.0337844, -0.0355781, -0.037367, -0.0391507,
  -0.0409291, -0.042702, -0.0444691, -0.0462303, -0.0479854,
  -0.0497341, -0.0514763, -0.0532118, -0.0549403, -0.0566617,
  -0.0583758, -0.0600824, -0.0617813, -0.0634723, -0.0651552,
  -0.0668299, -0.0684961, -0.0701536, -0.0718023, -0.073442,
  -0.0750725, -0.0766936, -0.0783052, -0.079907, -0.0814989,
  -0.0830807, -0.0846523, -0.0862134, -0.0877639, -0.0893036,
  -0.0908324, -0.0923501, -0.0938565, -0.0953514, -0.0968347,
  -0.0983063, -0.0997659, -0.101213, -0.102649, -0.104072, -0.105482,
  -0.106879, -0.108264, -0.109636, -0.110994, -0.11234, -0.113672,
  -0.11499, -0.116294, -0.117585, -0.118862, -0.120124, -0.121372,
  -0.122606, -0.123826, -0.12503, -0.12622, -0.127395, -0.128555,
  -0.1297, -0.130829, -0.131943, -0.133042, -0.134125, -0.135192,
  -0.136243, -0.137279, -0.138298, -0.139301, -0.140288, -0.141259,
  -0.142213, -0.143151, -0.144072, -0.144976, -0.145863, -0.146734,
  -0.147587, -0.148423, -0.149243, -0.150045, -0.150829, -0.151596,
  -0.152346, -0.153078, -0.153793, -0.15449, -0.155169, -0.15583,
  -0.156474, -0.157099, -0.157707, -0.158296, -0.158868, -0.159421,
  -0.159956, -0.160473, -0.160971, -0.161451, -0.161913, -0.162356,
  -0.162781, -0.163188, -0.163576, -0.163945, -0.164296, -0.164628,
  -0.164941, -0.165236, -0.165512, -0.16577, -0.166009, -0.166229,
  -0.16643, -0.166613, -0.166777, -0.166922, -0.167048, -0.167156,
  -0.167245, -0.167315, -0.167367, -0.167399, -0.167413, -0.167409,
  -0.167385, -0.167343, -0.167282, -0.167203, -0.167105, -0.166988,
  -0.166853, -0.166699, -0.166527, -0.166336, -0.166127, -0.165899,
  -0.165653, -0.165389, -0.165106, -0.164805, -0.164486, -0.164149,
  -0.163793, -0.16342, -0.163028, -0.162619, -0.162192, -0.161747,
  -0.161284, -0.160803, -0.160305, -0.159789, -0.159256, -0.158705,
  -0.158137, -0.157551, -0.156949, -0.156329, -0.155692, -0.155038,
  -0.154368, -0.15368, -0.152976, -0.152255, -0.151518, -0.150764,
  -0.149994, -0.149207, -0.148405, -0.147586, -0.146752, -0.145901,
  -0.145035, -0.144153, -0.143255, -0.142343, -0.141414, -0.140471,
  -0.139512, -0.138539, -0.13755, -0.136547, -0.135529, -0.134497,
  -0.13345, -0.132389, -0.131314, -0.130225, -0.129122, -0.128005,
  -0.126875, -0.125731, -0.124574, -0.123403, -0.122219, -0.121023,
  -0.119813, -0.118591, -0.117356, -0.116109, -0.11485, -0.113579,
  -0.112295, -0.111, -0.109693, -0.108375, -0.107045, -0.105704,
  -0.104352, -0.102989, -0.101615, -0.100231, -0.0988358, -0.0974307,
  -0.0960154, -0.0945902, -0.0931551, -0.0917104, -0.0902562,
  -0.0887926, -0.0873199, -0.0858382, -0.0843476, -0.0828484,
  -0.0813406, -0.0798246, -0.0783003, -0.0767681, -0.075228,
  -0.0736803, -0.072125, -0.0705625, -0.0689928, -0.0674161,
  -0.0658327, -0.0642426, -0.062646, -0.0610432, -0.0594343,
  -0.0578195, -0.0561989, -0.0545727, -0.0529412, -0.0513044,
  -0.0496626, -0.048016, -0.0463647, -0.0447089, -0.0430487,
  -0.0413844, -0.0397162, -0.0380442, -0.0363686, -0.0346895,
  -0.0330073, -0.031322, -0.0296338, -0.0279429, -0.0262496,
  -0.0245539, -0.022856, -0.0211562, -0.0194546, -0.0177515,
  -0.0160469, -0.0143411, -0.0126342, -0.0109265, -0.00921806,
  -0.00750914, -0.0057999, -0.00409053, -0.0023812, -0.000672091,
  0.00103661, 0.00274472, 0.00445206, 0.00615845, 0.00786371,
  0.00956767, 0.0112701, 0.0129709, 0.0146699, 0.0163668, 0.0180615,
  0.0197538, 0.0214436, 0.0231306, 0.0248147, 0.0264957, 0.0281734,
  0.0298477, 0.0315184, 0.0331852, 0.0348481, 0.0365069, 0.0381613,
  0.0398113, 0.0414566, 0.0430971, 0.0447325, 0.0463628, 0.0479878,
  0.0496072, 0.051221, 0.0528289, 0.0544308, 0.0560265, 0.057616,
  0.0591988, 0.0607751, 0.0623445, 0.0639069, 0.0654622, 0.0670101,
  0.0685506, 0.0700834, 0.0716085, 0.0731257, 0.0746347, 0.0761355,
  0.0776279, 0.0791117, 0.0805868, 0.0820531, 0.0835104, 0.0849585,
  0.0863973, 0.0878267, 0.0892465, 0.0906565, 0.0920567, 0.0934468,
  0.0948268, 0.0961965, 0.0975558, 0.0989045, 0.100242, 0.10157,
  0.102886, 0.104191, 0.105485, 0.106767, 0.108038, 0.109297,
  0.110545, 0.111781, 0.113005, 0.114216, 0.115416, 0.116603,
  0.117777, 0.118939, 0.120088, 0.121225, 0.122348, 0.123459,
  0.124556, 0.12564, 0.126711, 0.127768, 0.128812, 0.129842, 0.130858,
  0.131861, 0.132849, 0.133824, 0.134784, 0.13573, 0.136661, 0.137579,
  0.138481, 0.139369, 0.140243, 0.141101, 0.141945, 0.142774,
  0.143588, 0.144386, 0.14517, 0.145938, 0.146691, 0.147429, 0.148151,
  0.148858, 0.149549, 0.150224, 0.150884, 0.151528, 0.152156,
  0.152768, 0.153364, 0.153945, 0.154509, 0.155057, 0.155589,
  0.156105, 0.156604, 0.157087, 0.157554, 0.158005, 0.158439,
  0.158857, 0.159258, 0.159643, 0.160011, 0.160362, 0.160697,
  0.161016, 0.161317, 0.161602, 0.16187, 0.162122, 0.162357, 0.162575,
  0.162776, 0.162961, 0.163128, 0.163279, 0.163413, 0.163531,
  0.163631, 0.163715, 0.163781, 0.163831, 0.163864, 0.163881, 0.16388,
  0.163863, 0.163829, 0.163778, 0.16371, 0.163625, 0.163524, 0.163406,
  0.163271, 0.16312, 0.162952, 0.162767, 0.162566, 0.162348, 0.162114,
  0.161863, 0.161595, 0.161311, 0.161011, 0.160694, 0.160361,
  0.160011, 0.159646, 0.159264, 0.158866, 0.158451, 0.158021,
  0.157575, 0.157112, 0.156634, 0.15614, 0.15563, 0.155104, 0.154563,
  0.154006, 0.153433, 0.152845, 0.152241, 0.151622, 0.150988,
  0.150339, 0.149674, 0.148994, 0.148299, 0.14759, 0.146865, 0.146126,
  0.145372, 0.144603, 0.14382, 0.143022, 0.14221, 0.141384, 0.140543,
  0.139689, 0.13882, 0.137938, 0.137041, 0.136131, 0.135208, 0.134271,
  0.13332, 0.132356, 0.131379, 0.130389, 0.129385, 0.128369, 0.12734,
  0.126299, 0.125244, 0.124178, 0.123099, 0.122007, 0.120904,
  0.119788, 0.118661, 0.117522, 0.116371, 0.115209, 0.114035, 0.11285,
  0.111654, 0.110447, 0.109228, 0.107999, 0.10676, 0.10551, 0.104249,
  0.102978, 0.101697, 0.100406, 0.0991053, 0.0977947, 0.0964744,
  0.0951447, 0.0938056, 0.0924574, 0.0911, 0.0897338, 0.0883587,
  0.086975, 0.0855829, 0.0841823, 0.0827736, 0.0813567, 0.079932,
  0.0784995, 0.0770593, 0.0756116, 0.0741567, 0.0726945, 0.0712253,
  0.0697491, 0.0682663, 0.0667768, 0.0652809, 0.0637788, 0.0622704,
  0.0607561, 0.059236, 0.0577102, 0.0561789, 0.0546422, 0.0531003,
  0.0515533, 0.0500014, 0.0484448, 0.0468836, 0.045318, 0.0437481,
  0.0421741, 0.0405961, 0.0390144, 0.037429, 0.0358401, 0.0342479,
  0.0326525, 0.0310542, 0.029453, 0.0278491, 0.0262427, 0.024634,
  0.023023, 0.02141, 0.0197952, 0.0181786, 0.0165605, 0.014941,
  0.0133203, 0.0116985, 0.0100757, 0.00845229, 0.00682826, 0.0052038,
  0.00357909, 0.00195428, 0.000329528, -0.001295, -0.00291913,
  -0.00454272, -0.0061656, -0.00778762, -0.0094086, -0.0110284,
  -0.0126468, -0.0142638, -0.015879, -0.0174924, -0.0191039,
  -0.0207132, -0.0223202, -0.0239247, -0.0255266, -0.0271257,
  -0.0287219, -0.0303149, -0.0319047, -0.0334912, -0.035074,
  -0.0366531, -0.0382284, -0.0397996, -0.0413666, -0.0429293,
  -0.0444875, -0.0460411, -0.0475898, -0.0491336, -0.0506723,
  -0.0522058, -0.0537338, -0.0552563, -0.0567731, -0.0582841,
  -0.0597891, -0.0612879, -0.0627804, -0.0642665, -0.065746,
  -0.0672188, -0.0686848, -0.0701437, -0.0715955, -0.07304, -0.074477,
  -0.0759065, -0.0773283, -0.0787422, -0.0801481, -0.081546,
  -0.0829355, -0.0843167, -0.0856894, -0.0870533, -0.0884085,
  -0.0897548, -0.0910921, -0.0924201, -0.0937388, -0.0950482,
  -0.0963479, -0.097638, -0.0989182, -0.100189, -0.101449, -0.102699,
  -0.103939, -0.105168, -0.106387, -0.107595, -0.108792, -0.109979,
  -0.111155, -0.112319, -0.113472, -0.114614, -0.115744, -0.116863,
  -0.117971, -0.119066, -0.12015, -0.121221, -0.122281, -0.123328,
  -0.124363, -0.125386, -0.126397, -0.127394, -0.128379, -0.129352,
  -0.130311, -0.131258, -0.132191, -0.133112, -0.134019, -0.134913,
  -0.135793, -0.136661, -0.137514, -0.138354, -0.139181, -0.139993,
  -0.140792, -0.141577, -0.142347, -0.143104, -0.143847, -0.144575,
  -0.145289, -0.145989, -0.146674, -0.147345, -0.148002, -0.148643,
  -0.14927, -0.149883, -0.150481, -0.151063, -0.151631, -0.152184,
  -0.152723, -0.153246, -0.153754, -0.154247, -0.154724, -0.155187,
  -0.155634, -0.156066, -0.156483, -0.156884, -0.15727, -0.15764,
  -0.157995, -0.158335, -0.158659, -0.158967, -0.15926, -0.159537,
  -0.159799, -0.160045, -0.160275, -0.16049, -0.160689, -0.160872,
  -0.161039, -0.161191, -0.161327, -0.161447, -0.161551, -0.16164,
  -0.161713, -0.16177, -0.161811, -0.161836, -0.161846, -0.16184,
  -0.161818, -0.16178, -0.161726, -0.161657, -0.161572, -0.161471,
  -0.161355, -0.161222, -0.161074, -0.160911, -0.160731, -0.160536,
  -0.160325, -0.160099, -0.159857, -0.1596, -0.159327, -0.159039,
  -0.158735, -0.158416, -0.158081, -0.157731, -0.157365, -0.156985,
  -0.156589, -0.156178, -0.155752, -0.15531, -0.154854, -0.154382,
  -0.153896, -0.153394, -0.152878, -0.152347, -0.151801, -0.151241,
  -0.150665, -0.150076, -0.149471, -0.148852, -0.148219, -0.147572,
  -0.14691, -0.146234, -0.145543, -0.144839, -0.144121, -0.143388,
  -0.142642, -0.141882, -0.141109, -0.140321, -0.139521, -0.138706,
  -0.137879, -0.137038, -0.136183, -0.135316, -0.134435, -0.133542,
  -0.132636, -0.131717, -0.130785, -0.12984, -0.128883, -0.127914,
  -0.126932, -0.125938, -0.124932, -0.123914, -0.122884, -0.121842,
  -0.120789, -0.119724, -0.118647, -0.117559, -0.116459, -0.115349,
  -0.114227, -0.113094, -0.111951, -0.110796, -0.109631, -0.108456,
  -0.10727, -0.106074, -0.104867, -0.103651, -0.102425, -0.101188,
  -0.0999423, -0.0986868, -0.0974218, -0.0961475, -0.094864,
  -0.0935713, -0.0922698, -0.0909593, -0.0896402, -0.0883125,
  -0.0869763, -0.0856319, -0.0842792, -0.0829185, -0.0815498,
  -0.0801734, -0.0787893, -0.0773977, -0.0759987, -0.0745924,
  -0.073179, -0.0717587, -0.0703315, -0.0688976, -0.0674571,
  -0.0660102, -0.0645571, -0.0630977, -0.0616324, -0.0601613,
  -0.0586844, -0.0572019, -0.055714, -0.0542208, -0.0527225,
  -0.0512191, -0.0497109, -0.0481981, -0.0466806, -0.0451587,
  -0.0436326, -0.0421023, -0.0405681, -0.0390301, -0.0374883,
  -0.0359431, -0.0343945, -0.0328426, -0.0312877, -0.0297298,
  -0.0281691, -0.0266059, -0.0250401, -0.023472, -0.0219018,
  -0.0203295, -0.0187553, -0.0171795, -0.015602, -0.0140231,
  -0.012443, -0.0108618, -0.00927954, -0.00769652, -0.00611285,
  -0.00452866, -0.00294412, -0.00135938, 0.000225405, 0.00181009,
  0.00339452, 0.00497854, 0.00656201, 0.00814476, 0.00972664,
  0.0113075, 0.0128872, 0.0144656, 0.0160425, 0.0176178, 0.0191913,
  0.0207629, 0.0223325, 0.0238998, 0.0254647, 0.0270271, 0.0285868,
  0.0301437, 0.0316976, 0.0332484, 0.034796, 0.0363401, 0.0378806,
  0.0394175, 0.0409504, 0.0424794, 0.0440042, 0.0455247, 0.0470408,
  0.0485522, 0.050059, 0.0515608, 0.0530576, 0.0545493, 0.0560357,
  0.0575166, 0.0589919, 0.0604615, 0.0619252, 0.0633828, 0.0648344,
  0.0662796, 0.0677184, 0.0691506, 0.0705762, 0.0719949, 0.0734066,
  0.0748112, 0.0762086, 0.0775985, 0.078981, 0.0803558, 0.0817229,
  0.083082, 0.0844331, 0.0857761, 0.0871107, 0.0884369, 0.0897546,
  0.0910636, 0.0923638, 0.0936551, 0.0949374, 0.0962105, 0.0974742,
  0.0987286, 0.0999735, 0.101209, 0.102434, 0.10365, 0.104855,
  0.106051, 0.107236, 0.108411, 0.109575, 0.110729, 0.111872,
  0.113005, 0.114126, 0.115237, 0.116336, 0.117424, 0.118501,
  0.119567, 0.120621, 0.121663, 0.122694, 0.123713, 0.12472, 0.125715,
  0.126698, 0.127668, 0.128627, 0.129572, 0.130506, 0.131427,
  0.132335, 0.133231, 0.134114, 0.134984, 0.13584, 0.136684, 0.137515,
  0.138332, 0.139137, 0.139927, 0.140705, 0.141468, 0.142219,
  0.142955, 0.143678, 0.144387, 0.145082, 0.145763, 0.14643, 0.147083,
  0.147722, 0.148347, 0.148958, 0.149554, 0.150136, 0.150703,
  0.151256, 0.151794, 0.152318, 0.152827, 0.153322, 0.153802,
  0.154267, 0.154717, 0.155152, 0.155573, 0.155978, 0.156369,
  0.156744, 0.157105, 0.15745, 0.15778, 0.158095, 0.158395, 0.15868,
  0.158949, 0.159204, 0.159443, 0.159666, 0.159875, 0.160067,
  0.160245, 0.160407, 0.160554, 0.160685, 0.160801, 0.160902,
  0.160987, 0.161056, 0.161111, 0.161149, 0.161173, 0.16118, 0.161173,
  0.161149, 0.161111, 0.161056, 0.160987, 0.160902, 0.160801,
  0.160685, 0.160554, 0.160407, 0.160245, 0.160067, 0.159875,
  0.159666, 0.159443, 0.159204, 0.158949, 0.15868, 0.158395, 0.158095,
  0.15778, 0.15745, 0.157105, 0.156744, 0.156369, 0.155978, 0.155573,
  0.155152, 0.154717, 0.154267, 0.153802, 0.153322, 0.152827,
  0.152318, 0.151794, 0.151256, 0.150703, 0.150136, 0.149554,
  0.148958, 0.148347, 0.147722, 0.147083, 0.14643, 0.145763, 0.145082,
  0.144387, 0.143678, 0.142955, 0.142219, 0.141468, 0.140705,
  0.139927, 0.139137, 0.138332, 0.137515, 0.136684, 0.13584, 0.134984,
  0.134114, 0.133231, 0.132335, 0.131427, 0.130506, 0.129572,
  0.128627, 0.127668, 0.126698, 0.125715, 0.12472, 0.123713, 0.122694,
  0.121663, 0.120621, 0.119567, 0.118501, 0.117424, 0.116336,
  0.115237, 0.114126, 0.113005, 0.111872, 0.110729, 0.109575,
  0.108411, 0.107236, 0.106051, 0.104855, 0.10365, 0.102434, 0.101209,
  0.0999735, 0.0987286, 0.0974742, 0.0962105, 0.0949374, 0.0936551,
  0.0923638, 0.0910636, 0.0897546, 0.0884369, 0.0871107, 0.0857761,
  0.0844331, 0.083082, 0.0817229, 0.0803558, 0.078981, 0.0775985,
  0.0762086, 0.0748112, 0.0734066, 0.0719949, 0.0705762, 0.0691506,
  0.0677184, 0.0662796, 0.0648344, 0.0633828, 0.0619252, 0.0604615,
  0.0589919, 0.0575166, 0.0560357, 0.0545493, 0.0530576, 0.0515608,
  0.050059, 0.0485522, 0.0470408, 0.0455247, 0.0440042, 0.0424794,
  0.0409504, 0.0394175, 0.0378806, 0.0363401, 0.034796, 0.0332484,
  0.0316976, 0.0301437, 0.0285868, 0.0270271, 0.0254647, 0.0238998,
  0.0223325, 0.0207629, 0.0191913, 0.0176178, 0.0160425, 0.0144656,
  0.0128872, 0.0113075, 0.00972664, 0.00814476, 0.00656201,
  0.00497854, 0.00339452, 0.00181009, 0.000225405, -0.00135938,
  -0.00294412, -0.00452866, -0.00611285, -0.00769652, -0.00927954,
  -0.0108618, -0.012443, -0.0140231, -0.015602, -0.0171795,
  -0.0187553, -0.0203295, -0.0219018, -0.023472, -0.0250401,
  -0.0266059, -0.0281691, -0.0297298, -0.0312877, -0.0328426,
  -0.0343945, -0.0359431, -0.0374883, -0.0390301, -0.0405681,
  -0.0421023, -0.0436326, -0.0451587, -0.0466806, -0.0481981,
  -0.0497109, -0.0512191, -0.0527225, -0.0542208, -0.055714,
  -0.0572019, -0.0586844, -0.0601613, -0.0616324, -0.0630977,
  -0.0645571, -0.0660102, -0.0674571, -0.0688976, -0.0703315,
  -0.0717587, -0.073179, -0.0745924, -0.0759987, -0.0773977,
  -0.0787893, -0.0801734, -0.0815498, -0.0829185, -0.0842792,
  -0.0856319, -0.0869763, -0.0883125, -0.0896402, -0.0909593,
  -0.0922698, -0.0935713, -0.094864, -0.0961475, -0.0974218,
  -0.0986868, -0.0999423, -0.101188, -0.102425, -0.103651, -0.104867,
  -0.106074, -0.10727, -0.108456, -0.109631, -0.110796, -0.111951,
  -0.113094, -0.114227, -0.115349, -0.116459, -0.117559, -0.118647,
  -0.119724, -0.120789, -0.121842, -0.122884, -0.123914, -0.124932,
  -0.125938, -0.126932, -0.127914, -0.128883, -0.12984, -0.130785,
  -0.131717, -0.132636, -0.133542, -0.134435, -0.135316, -0.136183,
  -0.137038, -0.137879, -0.138706, -0.139521, -0.140321, -0.141109,
  -0.141882, -0.142642, -0.143388, -0.144121, -0.144839, -0.145543,
  -0.146234, -0.14691, -0.147572, -0.148219, -0.148852, -0.149471,
  -0.150076, -0.150665, -0.151241, -0.151801, -0.152347, -0.152878,
  -0.153394, -0.153896, -0.154382, -0.154854, -0.15531, -0.155752,
  -0.156178, -0.156589, -0.156985, -0.157365, -0.157731, -0.158081,
  -0.158416, -0.158735, -0.159039, -0.159327, -0.1596, -0.159857,
  -0.160099, -0.160325, -0.160536, -0.160731, -0.160911, -0.161074,
  -0.161222, -0.161355, -0.161471, -0.161572, -0.161657, -0.161726,
  -0.16178, -0.161818, -0.16184, -0.161846, -0.161836, -0.161811,
  -0.16177, -0.161713, -0.16164, -0.161551, -0.161447, -0.161327,
  -0.161191, -0.161039, -0.160872, -0.160689, -0.16049, -0.160275,
  -0.160045, -0.159799, -0.159537, -0.15926, -0.158967, -0.158659,
  -0.158335, -0.157995, -0.15764, -0.15727, -0.156884, -0.156483,
  -0.156066, -0.155634, -0.155187, -0.154724, -0.154247, -0.153754,
  -0.153246, -0.152723, -0.152184, -0.151631, -0.151063, -0.150481,
  -0.149883, -0.14927, -0.148643, -0.148002, -0.147345, -0.146674,
  -0.145989, -0.145289, -0.144575, -0.143847, -0.143104, -0.142347,
  -0.141577, -0.140792, -0.139993, -0.139181, -0.138354, -0.137514,
  -0.136661, -0.135793, -0.134913, -0.134019, -0.133112, -0.132191,
  -0.131258, -0.130311, -0.129352, -0.128379, -0.127394, -0.126397,
  -0.125386, -0.124363, -0.123328, -0.122281, -0.121221, -0.12015,
  -0.119066, -0.117971, -0.116863, -0.115744, -0.114614, -0.113472,
  -0.112319, -0.111155, -0.109979, -0.108792, -0.107595, -0.106387,
  -0.105168, -0.103939, -0.102699, -0.101449, -0.100189, -0.0989182,
  -0.097638, -0.0963479, -0.0950482, -0.0937388, -0.0924201,
  -0.0910921, -0.0897548, -0.0884085, -0.0870533, -0.0856894,
  -0.0843167, -0.0829355, -0.081546, -0.0801481, -0.0787422,
  -0.0773283, -0.0759065, -0.074477, -0.07304, -0.0715955, -0.0701437,
  -0.0686848, -0.0672188, -0.065746, -0.0642665, -0.0627804,
  -0.0612879, -0.0597891, -0.0582841, -0.0567731, -0.0552563,
  -0.0537338, -0.0522058, -0.0506723, -0.0491336, -0.0475898,
  -0.0460411, -0.0444875, -0.0429293, -0.0413666, -0.0397996,
  -0.0382284, -0.0366531, -0.035074, -0.0334912, -0.0319047,
  -0.0303149, -0.0287219, -0.0271257, -0.0255266, -0.0239247,
  -0.0223202, -0.0207132, -0.0191039, -0.0174924, -0.015879,
  -0.0142638, -0.0126468, -0.0110284, -0.0094086, -0.00778762,
  -0.0061656, -0.00454272, -0.00291913, -0.001295, 0.000329528,
  0.00195428, 0.00357909, 0.0052038, 0.00682826, 0.00845229,
  0.0100757, 0.0116985, 0.0133203, 0.014941, 0.0165605, 0.0181786,
  0.0197952, 0.02141, 0.023023, 0.024634, 0.0262427, 0.0278491,
  0.029453, 0.0310542, 0.0326525, 0.0342479, 0.0358401, 0.037429,
  0.0390144, 0.0405961, 0.0421741, 0.0437481, 0.045318, 0.0468836,
  0.0484448, 0.0500014, 0.0515533, 0.0531003, 0.0546422, 0.0561789,
  0.0577102, 0.059236, 0.0607561, 0.0622704, 0.0637788, 0.0652809,
  0.0667768, 0.0682663, 0.0697491, 0.0712253, 0.0726945, 0.0741567,
  0.0756116, 0.0770593, 0.0784995, 0.079932, 0.0813567, 0.0827736,
  0.0841823, 0.0855829, 0.086975, 0.0883587, 0.0897338, 0.0911,
  0.0924574, 0.0938056, 0.0951447, 0.0964744, 0.0977947, 0.0991053,
  0.100406, 0.101697, 0.102978, 0.104249, 0.10551, 0.10676, 0.107999,
  0.109228, 0.110447, 0.111654, 0.11285, 0.114035, 0.115209, 0.116371,
  0.117522, 0.118661, 0.119788, 0.120904, 0.122007, 0.123099,
  0.124178, 0.125244, 0.126299, 0.12734, 0.128369, 0.129385, 0.130389,
  0.131379, 0.132356, 0.13332, 0.134271, 0.135208, 0.136131, 0.137041,
  0.137938, 0.13882, 0.139689, 0.140543, 0.141384, 0.14221, 0.143022,
  0.14382, 0.144603, 0.145372, 0.146126, 0.146865, 0.14759, 0.148299,
  0.148994, 0.149674, 0.150339, 0.150988, 0.151622, 0.152241,
  0.152845, 0.153433, 0.154006, 0.154563, 0.155104, 0.15563, 0.15614,
  0.156634, 0.157112, 0.157575, 0.158021, 0.158451, 0.158866,
  0.159264, 0.159646, 0.160011, 0.160361, 0.160694, 0.161011,
  0.161311, 0.161595, 0.161863, 0.162114, 0.162348, 0.162566,
  0.162767, 0.162952, 0.16312, 0.163271, 0.163406, 0.163524, 0.163625,
  0.16371, 0.163778, 0.163829, 0.163863, 0.16388, 0.163881, 0.163864,
  0.163831, 0.163781, 0.163715, 0.163631, 0.163531, 0.163413,
  0.163279, 0.163128, 0.162961, 0.162776, 0.162575, 0.162357,
  0.162122, 0.16187, 0.161602, 0.161317, 0.161016, 0.160697, 0.160362,
  0.160011, 0.159643, 0.159258, 0.158857, 0.158439, 0.158005,
  0.157554, 0.157087, 0.156604, 0.156105, 0.155589, 0.155057,
  0.154509, 0.153945, 0.153364, 0.152768, 0.152156, 0.151528,
  0.150884, 0.150224, 0.149549, 0.148858, 0.148151, 0.147429,
  0.146691, 0.145938, 0.14517, 0.144386, 0.143588, 0.142774, 0.141945,
  0.141101, 0.140243, 0.139369, 0.138481, 0.137579, 0.136661, 0.13573,
  0.134784, 0.133824, 0.132849, 0.131861, 0.130858, 0.129842,
  0.128812, 0.127768, 0.126711, 0.12564, 0.124556, 0.123459, 0.122348,
  0.121225, 0.120088, 0.118939, 0.117777, 0.116603, 0.115416,
  0.114216, 0.113005, 0.111781, 0.110545, 0.109297, 0.108038,
  0.106767, 0.105485, 0.104191, 0.102886, 0.10157, 0.100242,
  0.0989045, 0.0975558, 0.0961965, 0.0948268, 0.0934468, 0.0920567,
  0.0906565, 0.0892465, 0.0878267, 0.0863973, 0.0849585, 0.0835104,
  0.0820531, 0.0805868, 0.0791117, 0.0776279, 0.0761355, 0.0746347,
  0.0731257, 0.0716085, 0.0700834, 0.0685506, 0.0670101, 0.0654622,
  0.0639069, 0.0623445, 0.0607751, 0.0591988, 0.057616, 0.0560265,
  0.0544308, 0.0528289, 0.051221, 0.0496072, 0.0479878, 0.0463628,
  0.0447325, 0.0430971, 0.0414566, 0.0398113, 0.0381613, 0.0365069,
  0.0348481, 0.0331852, 0.0315184, 0.0298477, 0.0281734, 0.0264957,
  0.0248147, 0.0231306, 0.0214436, 0.0197538, 0.0180615, 0.0163668,
  0.0146699, 0.0129709, 0.0112701, 0.00956767, 0.00786371, 0.00615845,
  0.00445206, 0.00274472, 0.00103661, -0.000672091, -0.0023812,
  -0.00409053, -0.0057999, -0.00750914, -0.00921806, -0.0109265,
  -0.0126342, -0.0143411, -0.0160469, -0.0177515, -0.0194546,
  -0.0211562, -0.022856, -0.0245539, -0.0262496, -0.0279429,
  -0.0296338, -0.031322, -0.0330073, -0.0346895, -0.0363686,
  -0.0380442, -0.0397162, -0.0413844, -0.0430487, -0.0447089,
  -0.0463647, -0.048016, -0.0496626, -0.0513044, -0.0529412,
  -0.0545727, -0.0561989, -0.0578195, -0.0594343, -0.0610432,
  -0.062646, -0.0642426, -0.0658327, -0.0674161, -0.0689928,
  -0.0705625, -0.072125, -0.0736803, -0.075228, -0.0767681,
  -0.0783003, -0.0798246, -0.0813406, -0.0828484, -0.0843476,
  -0.0858382, -0.0873199, -0.0887926, -0.0902562, -0.0917104,
  -0.0931551, -0.0945902, -0.0960154, -0.0974307, -0.0988358,
  -0.100231, -0.101615, -0.102989, -0.104352, -0.105704, -0.107045,
  -0.108375, -0.109693, -0.111, -0.112295, -0.113579, -0.11485,
  -0.116109, -0.117356, -0.118591, -0.119813, -0.121023, -0.122219,
  -0.123403, -0.124574, -0.125731, -0.126875, -0.128005, -0.129122,
  -0.130225, -0.131314, -0.132389, -0.13345, -0.134497, -0.135529,
  -0.136547, -0.13755, -0.138539, -0.139512, -0.140471, -0.141414,
  -0.142343, -0.143255, -0.144153, -0.145035, -0.145901, -0.146752,
  -0.147586, -0.148405, -0.149207, -0.149994, -0.150764, -0.151518,
  -0.152255, -0.152976, -0.15368, -0.154368, -0.155038, -0.155692,
  -0.156329, -0.156949, -0.157551, -0.158137, -0.158705, -0.159256,
  -0.159789, -0.160305, -0.160803, -0.161284, -0.161747, -0.162192,
  -0.162619, -0.163028, -0.16342, -0.163793, -0.164149, -0.164486,
  -0.164805, -0.165106, -0.165389, -0.165653, -0.165899, -0.166127,
  -0.166336, -0.166527, -0.166699, -0.166853, -0.166988, -0.167105,
  -0.167203, -0.167282, -0.167343, -0.167385, -0.167409, -0.167413,
  -0.167399, -0.167367, -0.167315, -0.167245, -0.167156, -0.167048,
  -0.166922, -0.166777, -0.166613, -0.16643, -0.166229, -0.166009,
  -0.16577, -0.165512, -0.165236, -0.164941, -0.164628, -0.164296,
  -0.163945, -0.163576, -0.163188, -0.162781, -0.162356, -0.161913,
  -0.161451, -0.160971, -0.160473, -0.159956, -0.159421, -0.158868,
  -0.158296, -0.157707, -0.157099, -0.156474, -0.15583, -0.155169,
  -0.15449, -0.153793, -0.153078, -0.152346, -0.151596, -0.150829,
  -0.150045, -0.149243, -0.148423, -0.147587, -0.146734, -0.145863,
  -0.144976, -0.144072, -0.143151, -0.142213, -0.141259, -0.140288,
  -0.139301, -0.138298, -0.137279, -0.136243, -0.135192, -0.134125,
  -0.133042, -0.131943, -0.130829, -0.1297, -0.128555, -0.127395,
  -0.12622, -0.12503, -0.123826, -0.122606, -0.121372, -0.120124,
  -0.118862, -0.117585, -0.116294, -0.11499, -0.113672, -0.11234,
  -0.110994, -0.109636, -0.108264, -0.106879, -0.105482, -0.104072,
  -0.102649, -0.101213, -0.0997659, -0.0983063, -0.0968347,
  -0.0953514, -0.0938565, -0.0923501, -0.0908324, -0.0893036,
  -0.0877639, -0.0862134, -0.0846523, -0.0830807, -0.0814989,
  -0.079907, -0.0783052, -0.0766936, -0.0750725, -0.073442,
  -0.0718023, -0.0701536, -0.0684961, -0.0668299, -0.0651552,
  -0.0634723, -0.0617813, -0.0600824, -0.0583758, -0.0566617,
  -0.0549403, -0.0532118, -0.0514763, -0.0497341, -0.0479854,
  -0.0462303, -0.0444691, -0.042702, -0.0409291, -0.0391507,
  -0.037367, -0.0355781, -0.0337844, -0.0319859, -0.0301829,
  -0.0283756, -0.0265643, -0.024749, -0.0229301, -0.0211077,
  -0.019282, -0.0174533, -0.0156218, -0.0137877, -0.0119512,
  -0.0101125, -0.00827177, -0.00642932, -0.00458533, -0.00274001,
  -0.000893581, 0.000953745, 0.00280175, 0.00465021, 0.00649892,
  0.00834765, 0.0101962, 0.0120443, 0.0138918, 0.0157384, 0.017584,
  0.0194283, 0.0212711, 0.0231121, 0.0249512, 0.0267881, 0.0286227,
  0.0304546, 0.0322837, 0.0341098, 0.0359326, 0.0377519, 0.0395675,
  0.0413792, 0.0431867, 0.0449899, 0.0467885, 0.0485823, 0.0503711,
  0.0521546, 0.0539327, 0.0557051, 0.0574716, 0.059232, 0.0609862,
  0.0627337, 0.0644745, 0.0662084, 0.0679351, 0.0696543, 0.071366,
  0.0730699, 0.0747657, 0.0764533, 0.0781325, 0.0798029, 0.0814646,
  0.0831171, 0.0847604, 0.0863941, 0.0880182, 0.0896324, 0.0912365,
  0.0928302, 0.0944135, 0.095986, 0.0975477, 0.0990982, 0.100637,
  0.102165, 0.103681, 0.105185, 0.106677, 0.108157, 0.109625,
  0.111079, 0.112521, 0.11395, 0.115365, 0.116768, 0.118156, 0.119531,
  0.120892, 0.122239, 0.123571, 0.124889, 0.126192, 0.127481,
  0.128754, 0.130013, 0.131256, 0.132483, 0.133695, 0.134891,
  0.136071, 0.137235, 0.138383, 0.139514, 0.140628, 0.141726,
  0.142807, 0.14387, 0.144917, 0.145946, 0.146958, 0.147952, 0.148928,
  0.149886, 0.150826, 0.151748, 0.152652, 0.153537, 0.154404,
  0.155252, 0.156081, 0.156891, 0.157682, 0.158454, 0.159207, 0.15994,
  0.160653, 0.161347, 0.162022, 0.162676, 0.163311, 0.163925,
  0.164519, 0.165094, 0.165647, 0.166181, 0.166694, 0.167186,
  0.167657, 0.168108, 0.168538, 0.168948, 0.169336, 0.169703,
  0.170049, 0.170374, 0.170677, 0.17096, 0.171221, 0.17146, 0.171679,
  0.171875, 0.17205, 0.172204, 0.172336, 0.172446, 0.172534, 0.172601,
  0.172646, 0.172669, 0.17267, 0.17265, 0.172608, 0.172543, 0.172457,
  0.172349, 0.172219, 0.172067, 0.171893, 0.171697, 0.171479, 0.17124,
  0.170978, 0.170694, 0.170389, 0.170062, 0.169712, 0.169341,
  0.168949, 0.168534, 0.168097, 0.167639, 0.167159, 0.166658,
  0.166135, 0.16559, 0.165024, 0.164436, 0.163827, 0.163197, 0.162545,
  0.161872, 0.161177, 0.160462, 0.159726, 0.158968, 0.15819, 0.157391,
  0.156571, 0.15573, 0.154869, 0.153988, 0.153085, 0.152163, 0.151221,
  0.150258, 0.149275, 0.148273, 0.14725, 0.146208, 0.145147, 0.144066,
  0.142965, 0.141845, 0.140707, 0.139549, 0.138372, 0.137177,
  0.135963, 0.134731, 0.133481, 0.132212, 0.130925, 0.129621,
  0.128298, 0.126959, 0.125601, 0.124227, 0.122835, 0.121427,
  0.120002, 0.11856, 0.117102, 0.115627, 0.114137, 0.11263, 0.111108,
  0.10957, 0.108017, 0.106449, 0.104866, 0.103268, 0.101656, 0.100029,
  0.0983876, 0.0967326, 0.0950637, 0.0933813, 0.0916854, 0.0899764,
  0.0882545, 0.0865198, 0.0847726, 0.0830131, 0.0812415, 0.079458,
  0.0776628, 0.0758563, 0.0740385, 0.0722098, 0.0703703, 0.0685204,
  0.0666602, 0.0647899, 0.0629098, 0.0610202, 0.0591213, 0.0572133,
  0.0552965, 0.0533711, 0.0514374, 0.0494955, 0.0475459, 0.0455887,
  0.0436241, 0.0416525, 0.0396741, 0.0376891, 0.0356978, 0.0337005,
  0.0316974, 0.0296888, 0.0276749, 0.0256561, 0.0236325, 0.0216045,
  0.0195724, 0.0175363, 0.0154966, 0.0134535, 0.0114073, 0.00935837,
  0.00730685, 0.00525307, 0.0031973, 0.00113982, -0.000919097,
  -0.00297917, -0.00504011, -0.00710165, -0.0091635, -0.0112254,
  -0.013287, -0.0153481, -0.0174084, -0.0194676, -0.0215254,
  -0.0235816, -0.0256358, -0.0276877, -0.0297372, -0.0317838,
  -0.0338274, -0.0358676, -0.0379041, -0.0399367, -0.041965,
  -0.0439888, -0.0460079, -0.0480218, -0.0500304, -0.0520333,
  -0.0540303, -0.056021, -0.0580053, -0.0599828, -0.0619531,
  -0.0639162, -0.0658715, -0.067819, -0.0697583, -0.071689,
  -0.0736111, -0.075524, -0.0774277, -0.0793217, -0.0812059,
  -0.0830799, -0.0849435, -0.0867963, -0.0886382, -0.0904689,
  -0.092288, -0.0940954, -0.0958906, -0.0976736, -0.0994439,
  -0.101201, -0.102946, -0.104677, -0.106394, -0.108097, -0.109787,
  -0.111461, -0.113122, -0.114767, -0.116397, -0.118011, -0.11961,
  -0.121193, -0.12276, -0.12431, -0.125843, -0.12736, -0.12886,
  -0.130342, -0.131806, -0.133253, -0.134681, -0.136092, -0.137483,
  -0.138856, -0.14021, -0.141545, -0.14286, -0.144155, -0.145431,
  -0.146687, -0.147922, -0.149137, -0.150331, -0.151505, -0.152657,
  -0.153788, -0.154897, -0.155985, -0.157051, -0.158095, -0.159116,
  -0.160116, -0.161092, -0.162046, -0.162977, -0.163885, -0.16477,
  -0.165631, -0.166469, -0.167283, -0.168073, -0.168839, -0.16958,
  -0.170298, -0.170991, -0.171659, -0.172303, -0.172922, -0.173516,
  -0.174084, -0.174628, -0.175146, -0.175639, -0.176106, -0.176547,
  -0.176963, -0.177353, -0.177717, -0.178054, -0.178366, -0.178651,
  -0.17891, -0.179143, -0.179349, -0.179529, -0.179682, -0.179808,
  -0.179908, -0.17998, -0.180026, -0.180045, -0.180038, -0.180003,
  -0.179941, -0.179852, -0.179737, -0.179594, -0.179424, -0.179226,
  -0.179002, -0.178751, -0.178472, -0.178167, -0.177834, -0.177474,
  -0.177087, -0.176673, -0.176232, -0.175764, -0.175268, -0.174746,
  -0.174197, -0.173621, -0.173018, -0.172388, -0.171732, -0.171049,
  -0.170339, -0.169603, -0.16884, -0.168051, -0.167235, -0.166393,
  -0.165525, -0.164631, -0.163711, -0.162765, -0.161793, -0.160796,
  -0.159773, -0.158725, -0.157651, -0.156552, -0.155428, -0.154279,
  -0.153106, -0.151907, -0.150685, -0.149437, -0.148166, -0.146871,
  -0.145551, -0.144208, -0.142842, -0.141452, -0.140039, -0.138603,
  -0.137144, -0.135662, -0.134159, -0.132632, -0.131084, -0.129514,
  -0.127922, -0.126309, -0.124675, -0.12302, -0.121344, -0.119647,
  -0.117931, -0.116194, -0.114437, -0.112661, -0.110866, -0.109051,
  -0.107218, -0.105366, -0.103496, -0.101608, -0.0997021, -0.0977788,
  -0.0958383, -0.0938808, -0.0919067, -0.0899163, -0.0879099,
  -0.0858876, -0.0838499, -0.0817971, -0.0797293, -0.077647,
  -0.0755505, -0.07344, -0.0713159, -0.0691785, -0.0670282,
  -0.0648651, -0.0626897, -0.0605024, -0.0583033, -0.0560929,
  -0.0538715, -0.0516395, -0.0493971, -0.0471448, -0.0448828,
  -0.0426116, -0.0403314, -0.0380427, -0.0357458, -0.033441,
  -0.0311288, -0.0288094, -0.0264832, -0.0241507, -0.0218122,
  -0.019468, -0.0171185, -0.0147642, -0.0124053, -0.0100423,
  -0.00767555, -0.00530542, -0.00293229, -0.000556564, 0.00182138,
  0.00420115, 0.00658236, 0.00896462, 0.0113475, 0.0137307, 0.0161137,
  0.0184962, 0.0208778, 0.023258, 0.0256366, 0.028013, 0.0303868,
  0.0327578, 0.0351254, 0.0374893, 0.0398491, 0.0422043, 0.0445546,
  0.0468995, 0.0492387, 0.0515717, 0.0538982, 0.0562178, 0.0585299,
  0.0608344, 0.0631306, 0.0654183, 0.0676969, 0.0699662, 0.0722258,
  0.0744751, 0.0767139, 0.0789416, 0.081158, 0.0833626, 0.085555,
  0.0877348, 0.0899017, 0.0920552, 0.0941949, 0.0963205, 0.0984315,
  0.100528, 0.102608, 0.104673, 0.106722, 0.108755, 0.11077, 0.112768,
  0.114749, 0.116712, 0.118656, 0.120582, 0.122488, 0.124375,
  0.126242, 0.128089, 0.129915, 0.13172, 0.133504, 0.135267, 0.137007,
  0.138725, 0.140421, 0.142093, 0.143742, 0.145367, 0.146968,
  0.148545, 0.150097, 0.151624, 0.153126, 0.154602, 0.156052,
  0.157476, 0.158873, 0.160243, 0.161586, 0.162902, 0.16419, 0.165449,
  0.166681, 0.167884, 0.169058, 0.170202, 0.171318, 0.172403,
  0.173459, 0.174485, 0.17548, 0.176444, 0.177378, 0.17828, 0.179151,
  0.179991, 0.180798, 0.181574, 0.182317, 0.183028, 0.183706,
  0.184351, 0.184964, 0.185543, 0.186089, 0.186601, 0.18708, 0.187524,
  0.187935, 0.188312, 0.188654, 0.188962, 0.189235, 0.189473,
  0.189677, 0.189846, 0.189979, 0.190078, 0.190141, 0.190169,
  0.190162, 0.190119, 0.190041, 0.189927, 0.189777, 0.189592,
  0.189371, 0.189114, 0.188821, 0.188493, 0.188128, 0.187728,
  0.187292, 0.18682, 0.186312, 0.185768, 0.185189, 0.184573, 0.183922,
  0.183235, 0.182513, 0.181755, 0.180961, 0.180132, 0.179268,
  0.178368, 0.177433, 0.176463, 0.175458, 0.174418, 0.173343,
  0.172233, 0.17109, 0.169911, 0.168699, 0.167452, 0.166172, 0.164857,
  0.16351, 0.162128, 0.160714, 0.159267, 0.157787, 0.156274, 0.154729,
  0.153152, 0.151543, 0.149902, 0.14823, 0.146527, 0.144793, 0.143028,
  0.141233, 0.139408, 0.137553, 0.135669, 0.133755, 0.131813,
  0.129842, 0.127843, 0.125816, 0.123761, 0.121679, 0.119571,
  0.117435, 0.115274, 0.113087, 0.110874, 0.108637, 0.106375,
  0.104089, 0.101778, 0.0994447, 0.0970881, 0.094709, 0.0923076,
  0.0898845, 0.0874402, 0.084975, 0.0824893, 0.0799838, 0.0774588,
  0.0749147, 0.0723522, 0.0697715, 0.0671733, 0.064558, 0.0619261,
  0.0592781, 0.0566145, 0.0539359, 0.0512427, 0.0485354, 0.0458146,
  0.0430809, 0.0403346, 0.0375765, 0.034807, 0.0320266, 0.029236,
  0.0264357, 0.0236262, 0.0208082, 0.0179821, 0.0151485, 0.0123081,
  0.00946143, 0.00660902, 0.0037515, 0.000889438, -0.00197656,
  -0.00484589, -0.00771797, -0.0105922, -0.0134679, -0.0163446,
  -0.0192216, -0.0220982, -0.024974, -0.0278482, -0.0307202,
  -0.0335895, -0.0364554, -0.0393172, -0.0421744, -0.0450263,
  -0.0478723, -0.0507117, -0.053544, -0.0563684, -0.0591843,
  -0.0619912, -0.0647884, -0.0675752, -0.070351, -0.0731151,
  -0.075867, -0.0786059, -0.0813314, -0.0840426, -0.086739,
  -0.0894199, -0.0920848, -0.0947329, -0.0973636, -0.0999764,
  -0.10257, -0.105145, -0.1077, -0.110235, -0.112748, -0.11524,
  -0.117709, -0.120155, -0.122578, -0.124976, -0.12735, -0.129698,
  -0.13202, -0.134315, -0.136583, -0.138824, -0.141035, -0.143218,
  -0.145372, -0.147495, -0.149587, -0.151648, -0.153677, -0.155674,
  -0.157638, -0.159568, -0.161464, -0.163326, -0.165152, -0.166943,
  -0.168697, -0.170415, -0.172096, -0.173738, -0.175343, -0.176909,
  -0.178436, -0.179922, -0.181369, -0.182775, -0.184141, -0.185464,
  -0.186746, -0.187985, -0.189182, -0.190335, -0.191445, -0.19251,
  -0.193531, -0.194508, -0.195439, -0.196325, -0.197165, -0.197958,
  -0.198705, -0.199405, -0.200058, -0.200664, -0.201221, -0.201731,
  -0.202192, -0.202604, -0.202968, -0.203282, -0.203547, -0.203763,
  -0.203928, -0.204044, -0.20411, -0.204125, -0.204089, -0.204003,
  -0.203866, -0.203678, -0.203439, -0.203149, -0.202807, -0.202414,
  -0.20197, -0.201474, -0.200927, -0.200328, -0.199677, -0.198975,
  -0.198221, -0.197416, -0.196559, -0.195651, -0.194691, -0.19368,
  -0.192617, -0.191503, -0.190339, -0.189123, -0.187856, -0.186539,
  -0.185171, -0.183753, -0.182285, -0.180767, -0.179199, -0.177582,
  -0.175915, -0.1742, -0.172436, -0.170623, -0.168763, -0.166854,
  -0.164899, -0.162896, -0.160846, -0.158751, -0.156609, -0.154422,
  -0.152189, -0.149912, -0.147591, -0.145226, -0.142818, -0.140367,
  -0.137873, -0.135338, -0.132762, -0.130145, -0.127488, -0.124791,
  -0.122055, -0.119281, -0.116469, -0.11362, -0.110735, -0.107813,
  -0.104857, -0.101866, -0.0988414, -0.0957837, -0.0926936, -0.089572,
  -0.0864194, -0.0832368, -0.0800249, -0.0767845, -0.0735163,
  -0.0702212, -0.0669, -0.0635535, -0.0601826, -0.0567882, -0.0533711,
  -0.0499322, -0.0464723, -0.0429925, -0.0394936, -0.0359765,
  -0.0324422, -0.0288917, -0.0253258, -0.0217455, -0.0181519,
  -0.0145459, -0.0109285, -0.00730074, -0.0036636, -1.81187e-05,
  0.00363468, 0.00729375, 0.010958, 0.0146265, 0.0182981, 0.0219716,
  0.0256462, 0.0293206, 0.0329938, 0.0366646, 0.0403321, 0.0439949,
  0.0476522, 0.0513026, 0.0549452, 0.0585787, 0.062202, 0.065814,
  0.0694136, 0.0729996, 0.0765708, 0.0801261, 0.0836644, 0.0871845,
  0.0906851, 0.0941653, 0.0976237, 0.101059, 0.104471, 0.107857,
  0.111217, 0.11455, 0.117854, 0.121128, 0.124371, 0.127582, 0.130759,
  0.133902, 0.13701, 0.140081, 0.143114, 0.146108, 0.149061, 0.151974,
  0.154844, 0.157671, 0.160453, 0.163189, 0.165878, 0.16852, 0.171112,
  0.173655, 0.176146, 0.178585, 0.180971, 0.183303, 0.18558, 0.1878,
  0.189963, 0.192068, 0.194113, 0.196099, 0.198023, 0.199885,
  0.201684, 0.20342, 0.20509, 0.206695, 0.208233, 0.209704, 0.211107,
  0.212441, 0.213704, 0.214898, 0.21602, 0.21707, 0.218047, 0.218951,
  0.21978, 0.220535, 0.221214, 0.221817, 0.222344, 0.222793, 0.223164,
  0.223457, 0.223672, 0.223807, 0.223862, 0.223837, 0.223732,
  0.223546, 0.223278, 0.222929, 0.222498, 0.221984, 0.221389, 0.22071,
  0.219949, 0.219105, 0.218177, 0.217167, 0.216073, 0.214896,
  0.213635, 0.212292, 0.210865, 0.209354, 0.207761, 0.206085,
  0.204326, 0.202485, 0.200561, 0.198555, 0.196468, 0.194299, 0.19205,
  0.18972, 0.18731, 0.18482, 0.182251, 0.179604, 0.176878, 0.174076,
  0.171196, 0.168241, 0.165211, 0.162106, 0.158927, 0.155676,
  0.152352, 0.148958, 0.145494, 0.14196, 0.138359, 0.13469, 0.130955,
  0.127156, 0.123293, 0.119368, 0.115381, 0.111335, 0.10723, 0.103068,
  0.0988496, 0.0945771, 0.0902516, 0.0858746, 0.0814477, 0.0769723,
  0.0724502, 0.0678829, 0.0632722, 0.0586196, 0.053927, 0.0491962,
  0.0444288, 0.0396268, 0.034792, 0.0299264, 0.0250318, 0.0201103,
  0.0151638, 0.0101943, 0.00520396, 0.000194793, -0.00483106,
  -0.00987146, -0.0149242, -0.0199872, -0.0250581, -0.0301346,
  -0.0352147, -0.0402958, -0.0453757, -0.050452, -0.0555224,
  -0.0605845, -0.0656359, -0.070674, -0.0756965, -0.0807009,
  -0.0856847, -0.0906454, -0.0955805, -0.100487, -0.105364, -0.110206,
  -0.115013, -0.119782, -0.124509, -0.129193, -0.133831, -0.138419,
  -0.142957, -0.14744, -0.151866, -0.156233, -0.160537, -0.164777,
  -0.16895, -0.173053, -0.177083, -0.181038, -0.184915, -0.188712,
  -0.192426, -0.196055, -0.199595, -0.203045, -0.206401, -0.209662,
  -0.212824, -0.215886, -0.218845, -0.221699, -0.224444, -0.227079,
  -0.229602, -0.23201, -0.2343, -0.236471, -0.238521, -0.240447,
  -0.242247, -0.243919, -0.245461, -0.246871, -0.248148, -0.249288,
  -0.250291, -0.251155, -0.251877, -0.252457, -0.252893, -0.253182,
  -0.253325, -0.253318, -0.253162, -0.252854, -0.252393, -0.251779,
  -0.25101, -0.250085, -0.249004, -0.247765, -0.246369, -0.244813,
  -0.243098, -0.241224, -0.239189, -0.236994, -0.234638, -0.232122,
  -0.229445, -0.226608, -0.22361, -0.220453, -0.217135, -0.21366,
  -0.210025, -0.206234, -0.202286, -0.198182, -0.193924, -0.189513,
  -0.18495, -0.180236, -0.175374, -0.170366, -0.165212, -0.159915,
  -0.154478, -0.148902, -0.143189, -0.137344, -0.131367, -0.125262,
  -0.119033, -0.112681, -0.10621, -0.0996247, -0.0929272, -0.0861215,
  -0.0792116, -0.0722014, -0.065095, -0.0578966, -0.0506107,
  -0.0432419, -0.0357948, -0.0282743, -0.0206853, -0.0130331,
  -0.0053229, 0.00243989, 0.0102497, 0.0181007, 0.0259871, 0.033903,
  0.041842, 0.0497981, 0.0577647, 0.0657352, 0.0737031, 0.0816614,
  0.0896032, 0.0975214, 0.105409, 0.113258, 0.121062, 0.128812,
  0.136502, 0.144123, 0.151668, 0.159128, 0.166495, 0.173762,
  0.180919, 0.187959, 0.194874, 0.201653, 0.20829, 0.214775, 0.2211,
  0.227256, 0.233234, 0.239025, 0.244621, 0.250013, 0.255191,
  0.260147, 0.264873, 0.269359, 0.273596, 0.277575, 0.281289,
  0.284728, 0.287884, 0.290748, 0.293312, 0.295568, 0.297506, 0.29912,
  0.300402, 0.301343, 0.301936, 0.302175, 0.302051, 0.301557,
  0.300688, 0.299436, 0.297796, 0.295762, 0.293328, 0.290489,
  0.287241, 0.283578, 0.279498, 0.274996, 0.270069, 0.264714, 0.25893,
  0.252715, 0.246068, 0.238988, 0.231475, 0.223531, 0.215156,
  0.206353, 0.197125, 0.187475, 0.177407, 0.166928, 0.156042,
  0.144758, 0.133082, 0.121025, 0.108595, 0.0958044, 0.0826644,
  0.0691886, 0.0553913, 0.0412881, 0.0268959, 0.0122329, -0.00268135,
  -0.0178259, -0.0331782, -0.0487145, -0.0644092, -0.0802352,
  -0.0961638, -0.112164, -0.128205, -0.14425, -0.160266, -0.176213,
  -0.192051, -0.207738, -0.223231, -0.238482, -0.253443, -0.268062,
  -0.282286, -0.296059, -0.309321, -0.322012, -0.334067, -0.34542,
  -0.356, -0.365734, -0.374547, -0.382359, -0.389088, -0.394648,
  -0.39895, -0.401901, -0.403404, -0.403359, -0.401663, -0.398207,
  -0.392879, -0.385563, -0.376138, -0.36448, -0.350459, -0.33394,
  -0.314786, -0.292851, -0.267988, -0.240043, -0.208856, -0.174262,
  -0.136093, -0.0941707, -0.0483149, 0.00166246, 0.0559551, 0.114763,
  0.178293, 0.246757, 0.320376, 0.399377, 0.483992, 0.574464,
  0.671041, 0.773979, 0.883541, 1}; const G4double
  G4NeutronHPFastLegendre::i24[5001] = {0, 0.000376466, 0.000707738,
  0.000996519, 0.00124541, 0.00145689, 0.00163337, 0.00177713,
  0.00189038, 0.00197521, 0.00203366, 0.00206764, 0.00207901,
  0.00206954, 0.0020409, 0.00199472, 0.00193252, 0.00185578,
  0.00176588, 0.00166417, 0.0015519, 0.00143027, 0.00130043,
  0.00116347, 0.00102039, 0.000872192, 0.000719777, 0.000564018,
  0.000405734, 0.000245698, 8.46348e-05, -7.67728e-05, -0.000237885,
  -0.000398103, -0.000556868, -0.000713657, -0.000867985, -0.0010194,
  -0.00116749, -0.00131187, -0.00145218, -0.0015881, -0.00171934,
  -0.00184563, -0.00196672, -0.00208241, -0.00219249, -0.00229681,
  -0.0023952, -0.00248755, -0.00257376, -0.00265372, -0.00272738,
  -0.00279468, -0.00285558, -0.00291007, -0.00295814, -0.00299981,
  -0.00303509, -0.00306401, -0.00308663, -0.003103, -0.0031132,
  -0.00311729, -0.00311537, -0.00310754, -0.00309389, -0.00307454,
  -0.00304962, -0.00301924, -0.00298353, -0.00294264, -0.0028967,
  -0.00284587, -0.00279029, -0.00273011, -0.0026655, -0.00259662,
  -0.00252363, -0.0024467, -0.00236599, -0.00228167, -0.00219392,
  -0.0021029, -0.0020088, -0.00191177, -0.001812, -0.00170965,
  -0.00160491, -0.00149794, -0.00138891, -0.001278, -0.00116537,
  -0.00105119, -0.000935631, -0.000818853, -0.000701021, -0.000582296,
  -0.000462836, -0.000342798, -0.000222336, -0.000101601, 1.92562e-05,
  0.000140091, 0.000260759, 0.00038112, 0.000501036, 0.000620372,
  0.000738998, 0.000856785, 0.000973607, 0.00108934, 0.00120388,
  0.00131709, 0.00142887, 0.00153911, 0.00164771, 0.00175457,
  0.00185958, 0.00196266, 0.00206371, 0.00216264, 0.00225938,
  0.00235383, 0.00244594, 0.00253562, 0.0026228, 0.00270741,
  0.00278941, 0.00286872, 0.00294529, 0.00301907, 0.00309001,
  0.00315806, 0.00322319, 0.00328535, 0.00334452, 0.00340064,
  0.00345371, 0.00350368, 0.00355055, 0.00359429, 0.00363487,
  0.0036723, 0.00370655, 0.00373763, 0.00376551, 0.00379021,
  0.00381173, 0.00383005, 0.0038452, 0.00385718, 0.00386599,
  0.00387166, 0.0038742, 0.00387362, 0.00386995, 0.0038632,
  0.00385341, 0.00384059, 0.00382478, 0.00380601, 0.0037843,
  0.0037597, 0.00373224, 0.00370195, 0.00366888, 0.00363307,
  0.00359456, 0.00355339, 0.0035096, 0.00346326, 0.00341439,
  0.00336306, 0.00330932, 0.00325321, 0.00319478, 0.0031341,
  0.00307122, 0.00300619, 0.00293907, 0.00286992, 0.00279879,
  0.00272575, 0.00265085, 0.00257416, 0.00249573, 0.00241563,
  0.00233392, 0.00225066, 0.00216592, 0.00207976, 0.00199223,
  0.00190342, 0.00181337, 0.00172215, 0.00162983, 0.00153647,
  0.00144214, 0.0013469, 0.00125081, 0.00115394, 0.00105635,
  0.000958112, 0.00085928, 0.000759921, 0.000660098, 0.000559873,
  0.00045931, 0.00035847, 0.000257416, 0.000156208, 5.49064e-05,
  -4.64273e-05, -0.000147734, -0.000248954, -0.000350029,
  -0.000450901, -0.000551512, -0.000651806, -0.000751727,
  -0.000851219, -0.000950227, -0.0010487, -0.00114658, -0.00124382,
  -0.00134036, -0.00143616, -0.00153116, -0.00162532, -0.00171858,
  -0.00181091, -0.00190225, -0.00199256, -0.00208179, -0.0021699,
  -0.00225685, -0.0023426, -0.0024271, -0.00251032, -0.00259221,
  -0.00267274, -0.00275187, -0.00282957, -0.0029058, -0.00298053,
  -0.00305372, -0.00312535, -0.00319538, -0.00326378, -0.00333053,
  -0.0033956, -0.00345895, -0.00352057, -0.00358044, -0.00363852,
  -0.0036948, -0.00374925, -0.00380185, -0.0038526, -0.00390146,
  -0.00394842, -0.00399346, -0.00403658, -0.00407775, -0.00411696,
  -0.00415421, -0.00418948, -0.00422275, -0.00425403, -0.00428331,
  -0.00431057, -0.00433582, -0.00435904, -0.00438023, -0.0043994,
  -0.00441653, -0.00443163, -0.0044447, -0.00445574, -0.00446475,
  -0.00447173, -0.00447669, -0.00447963, -0.00448056, -0.00447948,
  -0.0044764, -0.00447133, -0.00446427, -0.00445524, -0.00444425,
  -0.0044313, -0.00441642, -0.00439961, -0.00438088, -0.00436025,
  -0.00433774, -0.00431336, -0.00428713, -0.00425906, -0.00422918,
  -0.00419749, -0.00416403, -0.0041288, -0.00409183, -0.00405314,
  -0.00401276, -0.0039707, -0.00392698, -0.00388164, -0.00383468,
  -0.00378615, -0.00373606, -0.00368443, -0.0036313, -0.00357669,
  -0.00352062, -0.00346313, -0.00340424, -0.00334397, -0.00328237,
  -0.00321944, -0.00315523, -0.00308977, -0.00302308, -0.00295519,
  -0.00288613, -0.00281593, -0.00274464, -0.00267226, -0.00259885,
  -0.00252442, -0.00244901, -0.00237265, -0.00229538, -0.00221722,
  -0.00213822, -0.00205839, -0.00197778, -0.00189641, -0.00181433,
  -0.00173155, -0.00164813, -0.00156408, -0.00147945, -0.00139426,
  -0.00130855, -0.00122235, -0.0011357, -0.00104863, -0.000961172,
  -0.000873359, -0.000785224, -0.000696801, -0.000608124,
  -0.000519225, -0.000430137, -0.000340892, -0.000251525,
  -0.000162066, -7.25498e-05, 1.69929e-05, 0.000106529, 0.000196028,
  0.000285457, 0.000374784, 0.000463978, 0.000553008, 0.000641842,
  0.000730451, 0.000818804, 0.000906869, 0.000994618, 0.00108202,
  0.00116905, 0.00125567, 0.00134185, 0.00142757, 0.00151281,
  0.00159752, 0.00168168, 0.00176527, 0.00184826, 0.00193062,
  0.00201232, 0.00209335, 0.00217366, 0.00225325, 0.00233207,
  0.00241012, 0.00248736, 0.00256376, 0.00263932, 0.002714,
  0.00278778, 0.00286063, 0.00293255, 0.00300349, 0.00307346,
  0.00314241, 0.00321034, 0.00327722, 0.00334304, 0.00340776,
  0.00347139, 0.0035339, 0.00359526, 0.00365547, 0.0037145,
  0.00377235, 0.00382899, 0.00388441, 0.00393859, 0.00399153,
  0.0040432, 0.00409359, 0.00414269, 0.00419049, 0.00423697,
  0.00428212, 0.00432594, 0.0043684, 0.00440951, 0.00444925,
  0.00448761, 0.00452458, 0.00456015, 0.00459432, 0.00462708,
  0.00465842, 0.00468834, 0.00471682, 0.00474387, 0.00476947,
  0.00479363, 0.00481633, 0.00483758, 0.00485737, 0.0048757,
  0.00489257, 0.00490797, 0.0049219, 0.00493436, 0.00494535,
  0.00495488, 0.00496293, 0.00496952, 0.00497463, 0.00497828,
  0.00498047, 0.00498119, 0.00498046, 0.00497826, 0.00497462,
  0.00496952, 0.00496298, 0.004955, 0.00494559, 0.00493474,
  0.00492248, 0.00490879, 0.0048937, 0.0048772, 0.0048593, 0.00484002,
  0.00481936, 0.00479733, 0.00477393, 0.00474919, 0.00472309,
  0.00469567, 0.00466692, 0.00463686, 0.0046055, 0.00457284,
  0.00453891, 0.00450371, 0.00446726, 0.00442956, 0.00439064,
  0.00435049, 0.00430915, 0.00426661, 0.0042229, 0.00417803,
  0.00413201, 0.00408486, 0.00403659, 0.00398722, 0.00393676,
  0.00388523, 0.00383265, 0.00377903, 0.00372439, 0.00366874,
  0.0036121, 0.00355449, 0.00349592, 0.00343642, 0.003376, 0.00331468,
  0.00325247, 0.00318939, 0.00312547, 0.00306072, 0.00299516,
  0.00292881, 0.00286169, 0.00279381, 0.00272519, 0.00265586,
  0.00258584, 0.00251514, 0.00244378, 0.00237179, 0.00229917,
  0.00222597, 0.00215218, 0.00207783, 0.00200295, 0.00192756,
  0.00185166, 0.00177529, 0.00169847, 0.00162121, 0.00154353,
  0.00146546, 0.00138702, 0.00130822, 0.00122909, 0.00114965,
  0.00106992, 0.000989913, 0.000909661, 0.000829179, 0.000748488,
  0.000667609, 0.000586563, 0.00050537, 0.000424051, 0.000342626,
  0.000261115, 0.000179539, 9.79191e-05, 1.62746e-05, -6.5374e-05,
  -0.000147006, -0.000228603, -0.000310143, -0.000391606,
  -0.000472974, -0.000554226, -0.000635342, -0.000716303,
  -0.000797089, -0.000877681, -0.000958059, -0.00103821, -0.0011181,
  -0.00119772, -0.00127706, -0.00135608, -0.00143478, -0.00151314,
  -0.00159113, -0.00166874, -0.00174595, -0.00182274, -0.0018991,
  -0.001975, -0.00205044, -0.00212539, -0.00219983, -0.00227375,
  -0.00234714, -0.00241997, -0.00249223, -0.0025639, -0.00263497,
  -0.00270542, -0.00277524, -0.00284441, -0.00291291, -0.00298073,
  -0.00304786, -0.00311428, -0.00317998, -0.00324494, -0.00330915,
  -0.00337259, -0.00343525, -0.00349712, -0.00355819, -0.00361844,
  -0.00367786, -0.00373643, -0.00379415, -0.003851, -0.00390697,
  -0.00396206, -0.00401624, -0.00406951, -0.00412185, -0.00417326,
  -0.00422373, -0.00427324, -0.00432178, -0.00436936, -0.00441595,
  -0.00446155, -0.00450614, -0.00454973, -0.0045923, -0.00463385,
  -0.00467436, -0.00471382, -0.00475224, -0.00478961, -0.00482591,
  -0.00486114, -0.0048953, -0.00492837, -0.00496036, -0.00499126,
  -0.00502105, -0.00504975, -0.00507733, -0.00510381, -0.00512916,
  -0.0051534, -0.00517651, -0.00519849, -0.00521934, -0.00523906,
  -0.00525764, -0.00527508, -0.00529138, -0.00530653, -0.00532054,
  -0.00533341, -0.00534512, -0.00535568, -0.0053651, -0.00537336,
  -0.00538048, -0.00538644, -0.00539125, -0.00539491, -0.00539742,
  -0.00539879, -0.00539901, -0.00539808, -0.00539601, -0.00539279,
  -0.00538844, -0.00538295, -0.00537632, -0.00536856, -0.00535967,
  -0.00534966, -0.00533853, -0.00532627, -0.00531291, -0.00529843,
  -0.00528285, -0.00526616, -0.00524838, -0.00522951, -0.00520956,
  -0.00518852, -0.00516641, -0.00514323, -0.00511899, -0.00509369,
  -0.00506735, -0.00503996, -0.00501153, -0.00498208, -0.0049516,
  -0.00492011, -0.00488762, -0.00485412, -0.00481964, -0.00478417,
  -0.00474773, -0.00471033, -0.00467197, -0.00463266, -0.00459242,
  -0.00455124, -0.00450915, -0.00446615, -0.00442224, -0.00437745,
  -0.00433178, -0.00428523, -0.00423783, -0.00418958, -0.00414049,
  -0.00409058, -0.00403984, -0.00398831, -0.00393597, -0.00388286,
  -0.00382897, -0.00377433, -0.00371894, -0.00366281, -0.00360595,
  -0.00354839, -0.00349012, -0.00343117, -0.00337154, -0.00331125,
  -0.00325031, -0.00318874, -0.00312653, -0.00306372, -0.00300031,
  -0.00293631, -0.00287174, -0.00280661, -0.00274094, -0.00267473,
  -0.00260801, -0.00254077, -0.00247305, -0.00240485, -0.00233618,
  -0.00226707, -0.00219751, -0.00212754, -0.00205715, -0.00198637,
  -0.00191521, -0.00184368, -0.0017718, -0.00169958, -0.00162704,
  -0.00155418, -0.00148103, -0.0014076, -0.0013339, -0.00125994,
  -0.00118575, -0.00111133, -0.00103671, -0.000961884, -0.000886878,
  -0.000811706, -0.00073638, -0.000660916, -0.000585328, -0.00050963,
  -0.000433836, -0.000357961, -0.000282019, -0.000206024,
  -0.000129991, -5.39333e-05, 2.21342e-05, 9.81976e-05, 0.000174243,
  0.000250255, 0.000326222, 0.000402127, 0.000477959, 0.000553702,
  0.000629342, 0.000704866, 0.000780261, 0.000855511, 0.000930604,
  0.00100553, 0.00108026, 0.0011548, 0.00122913, 0.00130323,
  0.0013771, 0.00145071, 0.00152406, 0.00159713, 0.00166991,
  0.00174238, 0.00181454, 0.00188637, 0.00195786, 0.00202899,
  0.00209976, 0.00217014, 0.00224014, 0.00230973, 0.0023789,
  0.00244764, 0.00251595, 0.0025838, 0.00265119, 0.00271811,
  0.00278453, 0.00285046, 0.00291588, 0.00298078, 0.00304515,
  0.00310897, 0.00317224, 0.00323495, 0.00329708, 0.00335862,
  0.00341958, 0.00347992, 0.00353965, 0.00359875, 0.00365722,
  0.00371504, 0.00377221, 0.00382871, 0.00388454, 0.00393969,
  0.00399415, 0.0040479, 0.00410095, 0.00415328, 0.00420488,
  0.00425574, 0.00430587, 0.00435524, 0.00440386, 0.00445171,
  0.00449878, 0.00454507, 0.00459058, 0.00463528, 0.00467919,
  0.00472229, 0.00476457, 0.00480602, 0.00484665, 0.00488644,
  0.00492539, 0.0049635, 0.00500075, 0.00503714, 0.00507267,
  0.00510733, 0.00514111, 0.00517401, 0.00520603, 0.00523717,
  0.0052674, 0.00529674, 0.00532518, 0.00535272, 0.00537934,
  0.00540505, 0.00542984, 0.00545372, 0.00547667, 0.00549869,
  0.00551978, 0.00553995, 0.00555917, 0.00557746, 0.00559482,
  0.00561123, 0.0056267, 0.00564122, 0.0056548, 0.00566742, 0.0056791,
  0.00568983, 0.00569961, 0.00570844, 0.00571632, 0.00572324,
  0.00572921, 0.00573422, 0.00573828, 0.00574139, 0.00574355,
  0.00574475, 0.00574501, 0.00574431, 0.00574266, 0.00574007,
  0.00573652, 0.00573203, 0.0057266, 0.00572022, 0.0057129,
  0.00570465, 0.00569546, 0.00568533, 0.00567427, 0.00566228,
  0.00564937, 0.00563553, 0.00562077, 0.0056051, 0.00558851,
  0.00557101, 0.0055526, 0.00553329, 0.00551309, 0.00549198,
  0.00546999, 0.00544711, 0.00542335, 0.00539871, 0.0053732,
  0.00534682, 0.00531958, 0.00529148, 0.00526253, 0.00523273,
  0.00520209, 0.00517061, 0.00513831, 0.00510518, 0.00507123,
  0.00503647, 0.0050009, 0.00496454, 0.00492738, 0.00488944,
  0.00485071, 0.00481121, 0.00477095, 0.00472993, 0.00468816,
  0.00464564, 0.00460239, 0.0045584, 0.0045137, 0.00446828,
  0.00442215, 0.00437532, 0.00432781, 0.00427961, 0.00423073,
  0.00418119, 0.004131, 0.00408015, 0.00402866, 0.00397654, 0.0039238,
  0.00387044, 0.00381647, 0.00376191, 0.00370676, 0.00365103,
  0.00359473, 0.00353787, 0.00348046, 0.00342251, 0.00336402,
  0.00330502, 0.00324549, 0.00318547, 0.00312495, 0.00306395,
  0.00300247, 0.00294053, 0.00287813, 0.00281529, 0.00275201,
  0.00268831, 0.0026242, 0.00255968, 0.00249477, 0.00242947,
  0.0023638, 0.00229777, 0.00223138, 0.00216466, 0.0020976,
  0.00203022, 0.00196253, 0.00189454, 0.00182626, 0.00175771,
  0.00168888, 0.0016198, 0.00155047, 0.00148091, 0.00141112,
  0.00134111, 0.00127091, 0.00120051, 0.00112992, 0.00105917,
  0.000988258, 0.000917195, 0.000845994, 0.000774665, 0.00070322,
  0.000631668, 0.000560022, 0.000488291, 0.000416486, 0.000344619,
  0.000272701, 0.000200741, 0.000128751, 5.67422e-05, -1.52754e-05,
  -8.72907e-05, -0.000159293, -0.000231271, -0.000303215,
  -0.000375114, -0.000446957, -0.000518734, -0.000590433,
  -0.000662044, -0.000733558, -0.000804962, -0.000876247,
  -0.000947402, -0.00101842, -0.00108928, -0.00115998, -0.00123051,
  -0.00130086, -0.00137102, -0.00144098, -0.00151072, -0.00158024,
  -0.00164953, -0.00171858, -0.00178737, -0.0018559, -0.00192416,
  -0.00199214, -0.00205982, -0.0021272, -0.00219428, -0.00226103,
  -0.00232745, -0.00239353, -0.00245926, -0.00252463, -0.00258964,
  -0.00265427, -0.00271851, -0.00278236, -0.0028458, -0.00290883,
  -0.00297144, -0.00303361, -0.00309535, -0.00315664, -0.00321747,
  -0.00327784, -0.00333774, -0.00339715, -0.00345607, -0.0035145,
  -0.00357241, -0.00362982, -0.0036867, -0.00374305, -0.00379887,
  -0.00385413, -0.00390885, -0.003963, -0.00401659, -0.0040696,
  -0.00412203, -0.00417388, -0.00422512, -0.00427576, -0.00432579,
  -0.00437521, -0.004424, -0.00447216, -0.00451968, -0.00456657,
  -0.0046128, -0.00465838, -0.00470329, -0.00474754, -0.00479112,
  -0.00483402, -0.00487624, -0.00491776, -0.00495859, -0.00499872,
  -0.00503814, -0.00507686, -0.00511485, -0.00515213, -0.00518868,
  -0.00522451, -0.00525959, -0.00529394, -0.00532755, -0.0053604,
  -0.00539251, -0.00542386, -0.00545445, -0.00548428, -0.00551334,
  -0.00554163, -0.00556914, -0.00559588, -0.00562184, -0.00564701,
  -0.0056714, -0.005695, -0.0057178, -0.00573981, -0.00576103,
  -0.00578144, -0.00580105, -0.00581986, -0.00583786, -0.00585505,
  -0.00587143, -0.005887, -0.00590175, -0.00591569, -0.00592881,
  -0.00594112, -0.0059526, -0.00596327, -0.00597311, -0.00598213,
  -0.00599033, -0.00599771, -0.00600426, -0.00600998, -0.00601489,
  -0.00601896, -0.00602222, -0.00602465, -0.00602625, -0.00602703,
  -0.00602699, -0.00602612, -0.00602443, -0.00602192, -0.00601858,
  -0.00601443, -0.00600946, -0.00600367, -0.00599706, -0.00598964,
  -0.0059814, -0.00597235, -0.0059625, -0.00595183, -0.00594036,
  -0.00592808, -0.005915, -0.00590112, -0.00588644, -0.00587097,
  -0.0058547, -0.00583765, -0.00581981, -0.00580118, -0.00578177,
  -0.00576158, -0.00574062, -0.00571889, -0.00569639, -0.00567312,
  -0.00564909, -0.0056243, -0.00559876, -0.00557247, -0.00554544,
  -0.00551766, -0.00548914, -0.00545989, -0.00542991, -0.00539921,
  -0.00536778, -0.00533564, -0.00530279, -0.00526923, -0.00523498,
  -0.00520002, -0.00516437, -0.00512804, -0.00509103, -0.00505334,
  -0.00501498, -0.00497595, -0.00493627, -0.00489593, -0.00485495,
  -0.00481332, -0.00477106, -0.00472816, -0.00468464, -0.00464051,
  -0.00459576, -0.00455041, -0.00450445, -0.00445791, -0.00441077,
  -0.00436306, -0.00431477, -0.00426592, -0.00421651, -0.00416654,
  -0.00411603, -0.00406498, -0.00401339, -0.00396128, -0.00390865,
  -0.00385552, -0.00380187, -0.00374773, -0.0036931, -0.00363799,
  -0.00358241, -0.00352636, -0.00346985, -0.00341288, -0.00335548,
  -0.00329763, -0.00323936, -0.00318067, -0.00312156, -0.00306205,
  -0.00300215, -0.00294185, -0.00288117, -0.00282012, -0.00275871,
  -0.00269694, -0.00263481, -0.00257235, -0.00250956, -0.00244644,
  -0.00238301, -0.00231927, -0.00225523, -0.0021909, -0.00212629,
  -0.00206141, -0.00199626, -0.00193086, -0.0018652, -0.00179931,
  -0.00173319, -0.00166684, -0.00160028, -0.00153352, -0.00146656,
  -0.00139941, -0.00133208, -0.00126458, -0.00119693, -0.00112911,
  -0.00106116, -0.000993067, -0.00092485, -0.000856515, -0.00078807,
  -0.000719526, -0.00065089, -0.000582171, -0.000513378, -0.00044452,
  -0.000375606, -0.000306644, -0.000237643, -0.000168613,
  -9.95603e-05, -3.04954e-05, 3.85732e-05, 0.000107637, 0.000176687,
  0.000245715, 0.000314712, 0.000383669, 0.000452578, 0.000521429,
  0.000590215, 0.000658926, 0.000727555, 0.000796092, 0.000864529,
  0.000932857, 0.00100107, 0.00106915, 0.0011371, 0.00120491,
  0.00127257, 0.00134007, 0.0014074, 0.00147455, 0.00154152,
  0.0016083, 0.00167487, 0.00174124, 0.00180739, 0.00187331, 0.001939,
  0.00200445, 0.00206965, 0.00213459, 0.00219926, 0.00226366,
  0.00232778, 0.00239161, 0.00245515, 0.00251837, 0.00258129,
  0.00264388, 0.00270615, 0.00276808, 0.00282967, 0.00289091,
  0.00295179, 0.00301231, 0.00307245, 0.00313221, 0.00319159,
  0.00325057, 0.00330915, 0.00336733, 0.00342508, 0.00348242,
  0.00353933, 0.0035958, 0.00365183, 0.00370741, 0.00376253,
  0.00381719, 0.00387139, 0.0039251, 0.00397834, 0.00403109,
  0.00408334, 0.0041351, 0.00418634, 0.00423708, 0.0042873,
  0.00433699, 0.00438615, 0.00443478, 0.00448286, 0.0045304,
  0.00457739, 0.00462381, 0.00466968, 0.00471497, 0.00475969,
  0.00480383, 0.00484739, 0.00489036, 0.00493273, 0.0049745,
  0.00501567, 0.00505623, 0.00509618, 0.00513551, 0.00517422,
  0.0052123, 0.00524975, 0.00528656, 0.00532274, 0.00535827,
  0.00539315, 0.00542738, 0.00546096, 0.00549387, 0.00552613,
  0.00555771, 0.00558863, 0.00561888, 0.00564844, 0.00567733,
  0.00570553, 0.00573305, 0.00575988, 0.00578602, 0.00581146,
  0.0058362, 0.00586025, 0.00588359, 0.00590622, 0.00592815,
  0.00594937, 0.00596988, 0.00598967, 0.00600874, 0.0060271,
  0.00604473, 0.00606165, 0.00607783, 0.0060933, 0.00610804,
  0.00612204, 0.00613532, 0.00614787, 0.00615969, 0.00617077,
  0.00618112, 0.00619073, 0.00619961, 0.00620775, 0.00621515,
  0.00622181, 0.00622774, 0.00623293, 0.00623737, 0.00624108,
  0.00624405, 0.00624628, 0.00624777, 0.00624852, 0.00624854,
  0.00624781, 0.00624634, 0.00624414, 0.0062412, 0.00623752,
  0.00623311, 0.00622796, 0.00622208, 0.00621547, 0.00620812,
  0.00620004, 0.00619123, 0.0061817, 0.00617143, 0.00616045,
  0.00614873, 0.0061363, 0.00612315, 0.00610927, 0.00609468,
  0.00607938, 0.00606336, 0.00604664, 0.0060292, 0.00601106,
  0.00599222, 0.00597268, 0.00595243, 0.0059315, 0.00590987,
  0.00588754, 0.00586454, 0.00584085, 0.00581647, 0.00579142,
  0.0057657, 0.0057393, 0.00571223, 0.0056845, 0.00565611, 0.00562706,
  0.00559736, 0.005567, 0.005536, 0.00550436, 0.00547208, 0.00543916,
  0.00540562, 0.00537144, 0.00533665, 0.00530123, 0.00526521,
  0.00522857, 0.00519133, 0.00515349, 0.00511505, 0.00507602,
  0.0050364, 0.00499621, 0.00495544, 0.00491409, 0.00487218,
  0.00482971, 0.00478668, 0.0047431, 0.00469897, 0.0046543, 0.0046091,
  0.00456337, 0.00451711, 0.00447033, 0.00442304, 0.00437525,
  0.00432695, 0.00427815, 0.00422886, 0.00417909, 0.00412884,
  0.00407812, 0.00402693, 0.00397528, 0.00392317, 0.00387062,
  0.00381762, 0.00376418, 0.00371032, 0.00365603, 0.00360133,
  0.00354621, 0.00349069, 0.00343477, 0.00337846, 0.00332177,
  0.00326469, 0.00320725, 0.00314944, 0.00309127, 0.00303275,
  0.00297389, 0.00291468, 0.00285515, 0.00279529, 0.00273512,
  0.00267463, 0.00261384, 0.00255276, 0.00249138, 0.00242972,
  0.00236779, 0.00230559, 0.00224313, 0.00218041, 0.00211745,
  0.00205425, 0.00199082, 0.00192716, 0.00186328, 0.0017992,
  0.00173491, 0.00167042, 0.00160575, 0.00154089, 0.00147587,
  0.00141067, 0.00134532, 0.00127981, 0.00121417, 0.00114838,
  0.00108247, 0.00101643, 0.000950279, 0.000884022, 0.000817665,
  0.000751217, 0.000684685, 0.000618075, 0.000551397, 0.000484656,
  0.000417862, 0.00035102, 0.000284139, 0.000217226, 0.000150289,
  8.33355e-05, 1.63723e-05, -5.05927e-05, -0.000117552, -0.000184498,
  -0.000251424, -0.000318322, -0.000385184, -0.000452003,
  -0.000518772, -0.000585483, -0.000652129, -0.000718702,
  -0.000785195, -0.000851601, -0.000917912, -0.000984121, -0.00105022,
  -0.0011162, -0.00118206, -0.00124779, -0.00131338, -0.00137882,
  -0.00144411, -0.00150924, -0.0015742, -0.00163899, -0.0017036,
  -0.00176802, -0.00183224, -0.00189626, -0.00196007, -0.00202366,
  -0.00208703, -0.00215017, -0.00221307, -0.00227573, -0.00233813,
  -0.00240028, -0.00246216, -0.00252377, -0.0025851, -0.00264615,
  -0.0027069, -0.00276736, -0.00282751, -0.00288735, -0.00294688,
  -0.00300608, -0.00306494, -0.00312347, -0.00318166, -0.0032395,
  -0.00329698, -0.0033541, -0.00341085, -0.00346723, -0.00352323,
  -0.00357884, -0.00363406, -0.00368888, -0.00374329, -0.0037973,
  -0.00385089, -0.00390406, -0.0039568, -0.00400911, -0.00406098,
  -0.0041124, -0.00416338, -0.0042139, -0.00426396, -0.00431356,
  -0.00436268, -0.00441133, -0.0044595, -0.00450718, -0.00455437,
  -0.00460106, -0.00464726, -0.00469294, -0.00473812, -0.00478278,
  -0.00482692, -0.00487053, -0.00491362, -0.00495617, -0.00499818,
  -0.00503965, -0.00508057, -0.00512094, -0.00516075, -0.0052,
  -0.00523869, -0.00527681, -0.00531436, -0.00535134, -0.00538773,
  -0.00542354, -0.00545876, -0.0054934, -0.00552743, -0.00556087,
  -0.00559371, -0.00562594, -0.00565757, -0.00568858, -0.00571898,
  -0.00574876, -0.00577793, -0.00580646, -0.00583438, -0.00586166,
  -0.00588831, -0.00591432, -0.0059397, -0.00596444, -0.00598853,
  -0.00601199, -0.00603479, -0.00605694, -0.00607845, -0.0060993,
  -0.00611949, -0.00613903, -0.0061579, -0.00617612, -0.00619367,
  -0.00621055, -0.00622678, -0.00624233, -0.00625721, -0.00627142,
  -0.00628496, -0.00629783, -0.00631002, -0.00632153, -0.00633237,
  -0.00634253, -0.00635202, -0.00636082, -0.00636894, -0.00637638,
  -0.00638314, -0.00638922, -0.00639461, -0.00639933, -0.00640335,
  -0.0064067, -0.00640936, -0.00641134, -0.00641263, -0.00641325,
  -0.00641317, -0.00641242, -0.00641098, -0.00640885, -0.00640605,
  -0.00640256, -0.0063984, -0.00639355, -0.00638802, -0.00638181,
  -0.00637493, -0.00636736, -0.00635912, -0.00635021, -0.00634062,
  -0.00633036, -0.00631942, -0.00630782, -0.00629555, -0.0062826,
  -0.006269, -0.00625473, -0.00623979, -0.0062242, -0.00620794,
  -0.00619103, -0.00617347, -0.00615525, -0.00613638, -0.00611686,
  -0.00609669, -0.00607588, -0.00605443, -0.00603234, -0.00600961,
  -0.00598625, -0.00596225, -0.00593763, -0.00591238, -0.0058865,
  -0.00586001, -0.0058329, -0.00580517, -0.00577683, -0.00574788,
  -0.00571833, -0.00568818, -0.00565742, -0.00562608, -0.00559414,
  -0.00556161, -0.00552849, -0.0054948, -0.00546053, -0.00542568,
  -0.00539027, -0.00535429, -0.00531774, -0.00528064, -0.00524299,
  -0.00520478, -0.00516603, -0.00512674, -0.00508691, -0.00504655,
  -0.00500566, -0.00496424, -0.00492231, -0.00487985, -0.00483689,
  -0.00479343, -0.00474946, -0.00470499, -0.00466003, -0.00461459,
  -0.00456866, -0.00452226, -0.00447538, -0.00442804, -0.00438023,
  -0.00433197, -0.00428325, -0.00423409, -0.00418449, -0.00413445,
  -0.00408398, -0.00403308, -0.00398176, -0.00393003, -0.00387789,
  -0.00382535, -0.00377241, -0.00371907, -0.00366535, -0.00361125,
  -0.00355677, -0.00350192, -0.00344671, -0.00339114, -0.00333521,
  -0.00327894, -0.00322233, -0.00316539, -0.00310812, -0.00305052,
  -0.00299261, -0.00293439, -0.00287586, -0.00281704, -0.00275792,
  -0.00269852, -0.00263884, -0.00257888, -0.00251866, -0.00245818,
  -0.00239744, -0.00233645, -0.00227523, -0.00221376, -0.00215207,
  -0.00209016, -0.00202803, -0.00196569, -0.00190315, -0.00184041,
  -0.00177748, -0.00171437, -0.00165108, -0.00158762, -0.00152399,
  -0.00146021, -0.00139628, -0.00133221, -0.00126799, -0.00120365,
  -0.00113918, -0.0010746, -0.00100991, -0.000945106, -0.00088021,
  -0.000815223, -0.000750152, -0.000685004, -0.000619786,
  -0.000554504, -0.000489164, -0.000423775, -0.000358342,
  -0.000292872, -0.000227373, -0.00016185, -9.631e-05, -3.07604e-05,
  3.47923e-05, 0.000100341, 0.00016588, 0.000231402, 0.0002969,
  0.000362368, 0.000427798, 0.000493185, 0.000558521, 0.0006238,
  0.000689015, 0.000754159, 0.000819226, 0.00088421, 0.000949103,
  0.0010139, 0.00107859, 0.00114317, 0.00120764, 0.00127198,
  0.00133619, 0.00140027, 0.0014642, 0.00152798, 0.00159161,
  0.00165507, 0.00171836, 0.00178148, 0.00184442, 0.00190717,
  0.00196973, 0.00203208, 0.00209423, 0.00215616, 0.00221788,
  0.00227937, 0.00234062, 0.00240164, 0.00246241, 0.00252294,
  0.0025832, 0.0026432, 0.00270294, 0.0027624, 0.00282158, 0.00288047,
  0.00293907, 0.00299737, 0.00305536, 0.00311305, 0.00317041,
  0.00322746, 0.00328418, 0.00334057, 0.00339661, 0.00345232,
  0.00350767, 0.00356266, 0.0036173, 0.00367157, 0.00372546,
  0.00377898, 0.00383212, 0.00388487, 0.00393722, 0.00398917,
  0.00404073, 0.00409187, 0.0041426, 0.00419291, 0.00424279,
  0.00429225, 0.00434127, 0.00438985, 0.00443799, 0.00448568,
  0.00453292, 0.0045797, 0.00462601, 0.00467186, 0.00471724,
  0.00476214, 0.00480656, 0.0048505, 0.00489394, 0.00493689,
  0.00497935, 0.0050213, 0.00506275, 0.00510368, 0.0051441,
  0.00518401, 0.00522339, 0.00526224, 0.00530056, 0.00533835,
  0.00537561, 0.00541232, 0.00544849, 0.0054841, 0.00551917,
  0.00555368, 0.00558764, 0.00562103, 0.00565385, 0.00568611,
  0.0057178, 0.00574891, 0.00577945, 0.0058094, 0.00583877,
  0.00586755, 0.00589575, 0.00592335, 0.00595036, 0.00597677,
  0.00600259, 0.0060278, 0.0060524, 0.0060764, 0.00609979, 0.00612257,
  0.00614473, 0.00616628, 0.00618721, 0.00620752, 0.00622721,
  0.00624628, 0.00626472, 0.00628253, 0.00629972, 0.00631627,
  0.00633219, 0.00634748, 0.00636214, 0.00637615, 0.00638953,
  0.00640227, 0.00641438, 0.00642584, 0.00643665, 0.00644683,
  0.00645636, 0.00646525, 0.00647349, 0.00648108, 0.00648803,
  0.00649433, 0.00649998, 0.00650499, 0.00650934, 0.00651305,
  0.00651611, 0.00651851, 0.00652027, 0.00652137, 0.00652183,
  0.00652164, 0.0065208, 0.0065193, 0.00651716, 0.00651437,
  0.00651093, 0.00650684, 0.00650211, 0.00649673, 0.0064907,
  0.00648402, 0.0064767, 0.00646874, 0.00646013, 0.00645089, 0.006441,
  0.00643046, 0.00641929, 0.00640749, 0.00639504, 0.00638196,
  0.00636825, 0.00635391, 0.00633893, 0.00632332, 0.00630709,
  0.00629023, 0.00627275, 0.00625464, 0.00623591, 0.00621657,
  0.00619661, 0.00617603, 0.00615484, 0.00613305, 0.00611064,
  0.00608763, 0.00606401, 0.0060398, 0.00601498, 0.00598957,
  0.00596357, 0.00593698, 0.0059098, 0.00588203, 0.00585368,
  0.00582476, 0.00579525, 0.00576518, 0.00573453, 0.00570331,
  0.00567154, 0.0056392, 0.0056063, 0.00557285, 0.00553885, 0.0055043,
  0.00546921, 0.00543357, 0.0053974, 0.0053607, 0.00532347,
  0.00528571, 0.00524743, 0.00520863, 0.00516932, 0.0051295,
  0.00508917, 0.00504834, 0.00500702, 0.00496519, 0.00492288,
  0.00488009, 0.00483681, 0.00479305, 0.00474883, 0.00470413,
  0.00465897, 0.00461335, 0.00456728, 0.00452076, 0.00447379,
  0.00442639, 0.00437854, 0.00433027, 0.00428157, 0.00423244,
  0.00418291, 0.00413296, 0.0040826, 0.00403184, 0.00398068,
  0.00392914, 0.0038772, 0.00382489, 0.0037722, 0.00371914,
  0.00366571, 0.00361193, 0.00355778, 0.00350329, 0.00344846,
  0.00339328, 0.00333778, 0.00328194, 0.00322578, 0.00316931,
  0.00311252, 0.00305543, 0.00299804, 0.00294036, 0.00288238,
  0.00282413, 0.00276559, 0.00270679, 0.00264772, 0.00258839,
  0.00252881, 0.00246898, 0.0024089, 0.00234859, 0.00228805,
  0.00222729, 0.00216631, 0.00210511, 0.00204371, 0.00198211,
  0.00192032, 0.00185834, 0.00179617, 0.00173383, 0.00167132,
  0.00160865, 0.00154582, 0.00148283, 0.00141971, 0.00135644,
  0.00129304, 0.00122951, 0.00116587, 0.00110211, 0.00103824,
  0.000974271, 0.000910207, 0.000846053, 0.000781817, 0.000717504,
  0.000653122, 0.000588675, 0.000524171, 0.000459616, 0.000395015,
  0.000330377, 0.000265705, 0.000201008, 0.000136292, 7.15617e-05,
  6.82475e-06, -5.79129e-05, -0.000122645, -0.000187365, -0.000252067,
  -0.000316744, -0.00038139, -0.000446, -0.000510565, -0.000575081,
  -0.000639541, -0.000703938, -0.000768267, -0.000832521,
  -0.000896694, -0.00096078, -0.00102477, -0.00108866, -0.00115245,
  -0.00121612, -0.00127968, -0.00134311, -0.00140641, -0.00146957,
  -0.00153259, -0.00159546, -0.00165818, -0.00172073, -0.00178312,
  -0.00184533, -0.00190736, -0.00196921, -0.00203087, -0.00209233,
  -0.00215358, -0.00221463, -0.00227546, -0.00233607, -0.00239645,
  -0.0024566, -0.00251651, -0.00257617, -0.00263559, -0.00269474,
  -0.00275364, -0.00281227, -0.00287063, -0.0029287, -0.0029865,
  -0.003044, -0.0031012, -0.00315811, -0.00321471, -0.003271,
  -0.00332696, -0.00338261, -0.00343793, -0.00349291, -0.00354756,
  -0.00360186, -0.00365581, -0.0037094, -0.00376264, -0.00381551,
  -0.00386801, -0.00392014, -0.00397188, -0.00402324, -0.00407421,
  -0.00412479, -0.00417496, -0.00422473, -0.00427409, -0.00432304,
  -0.00437156, -0.00441967, -0.00446734, -0.00451458, -0.00456139,
  -0.00460775, -0.00465366, -0.00469913, -0.00474414, -0.00478869,
  -0.00483277, -0.00487639, -0.00491954, -0.00496221, -0.00500439,
  -0.0050461, -0.00508731, -0.00512804, -0.00516826, -0.00520799,
  -0.00524721, -0.00528592, -0.00532413, -0.00536181, -0.00539898,
  -0.00543563, -0.00547175, -0.00550734, -0.0055424, -0.00557692,
  -0.0056109, -0.00564434, -0.00567724, -0.00570958, -0.00574137,
  -0.00577261, -0.00580329, -0.00583341, -0.00586296, -0.00589195,
  -0.00592037, -0.00594822, -0.00597549, -0.00600218, -0.0060283,
  -0.00605383, -0.00607877, -0.00610313, -0.0061269, -0.00615008,
  -0.00617266, -0.00619465, -0.00621604, -0.00623683, -0.00625701,
  -0.00627659, -0.00629557, -0.00631394, -0.0063317, -0.00634884,
  -0.00636538, -0.0063813, -0.0063966, -0.00641129, -0.00642536,
  -0.0064388, -0.00645163, -0.00646383, -0.00647541, -0.00648637,
  -0.0064967, -0.0065064, -0.00651547, -0.00652392, -0.00653174,
  -0.00653892, -0.00654548, -0.00655141, -0.0065567, -0.00656136,
  -0.00656539, -0.00656878, -0.00657155, -0.00657367, -0.00657517,
  -0.00657603, -0.00657626, -0.00657585, -0.00657481, -0.00657313,
  -0.00657083, -0.00656788, -0.00656431, -0.0065601, -0.00655526,
  -0.00654979, -0.00654369, -0.00653696, -0.0065296, -0.00652161,
  -0.00651299, -0.00650374, -0.00649387, -0.00648337, -0.00647225,
  -0.0064605, -0.00644813, -0.00643514, -0.00642153, -0.00640731,
  -0.00639246, -0.006377, -0.00636093, -0.00634424, -0.00632695,
  -0.00630904, -0.00629053, -0.00627141, -0.00625169, -0.00623136,
  -0.00621044, -0.00618892, -0.0061668, -0.00614409, -0.00612079,
  -0.0060969, -0.00607242, -0.00604736, -0.00602171, -0.00599549,
  -0.00596869, -0.00594132, -0.00591337, -0.00588486, -0.00585577,
  -0.00582613, -0.00579593, -0.00576517, -0.00573385, -0.00570198,
  -0.00566957, -0.0056366, -0.0056031, -0.00556906, -0.00553448,
  -0.00549937, -0.00546373, -0.00542757, -0.00539088, -0.00535368,
  -0.00531596, -0.00527773, -0.00523899, -0.00519975, -0.00516001,
  -0.00511977, -0.00507905, -0.00503783, -0.00499613, -0.00495395,
  -0.00491129, -0.00486816, -0.00482456, -0.0047805, -0.00473598,
  -0.004691, -0.00464558, -0.0045997, -0.00455339, -0.00450664,
  -0.00445945, -0.00441184, -0.0043638, -0.00431534, -0.00426647,
  -0.00421719, -0.0041675, -0.00411741, -0.00406693, -0.00401606,
  -0.0039648, -0.00391316, -0.00386114, -0.00380875, -0.003756,
  -0.00370289, -0.00364942, -0.0035956, -0.00354143, -0.00348693,
  -0.00343209, -0.00337692, -0.00332142, -0.00326561, -0.00320948,
  -0.00315305, -0.00309631, -0.00303927, -0.00298195, -0.00292433,
  -0.00286644, -0.00280827, -0.00274983, -0.00269113, -0.00263217,
  -0.00257295, -0.00251349, -0.00245379, -0.00239385, -0.00233368,
  -0.00227329, -0.00221268, -0.00215186, -0.00209083, -0.00202959,
  -0.00196817, -0.00190656, -0.00184476, -0.00178278, -0.00172064,
  -0.00165833, -0.00159586, -0.00153323, -0.00147046, -0.00140755,
  -0.00134451, -0.00128133, -0.00121803, -0.00115462, -0.00109109,
  -0.00102746, -0.000963729, -0.000899907, -0.000835998, -0.000772009,
  -0.000707946, -0.000643815, -0.000579622, -0.000515374,
  -0.000451076, -0.000386735, -0.000322357, -0.000257947,
  -0.000193514, -0.000129061, -6.45961e-05, -1.24999e-07, 6.43461e-05,
  0.000128811, 0.000193264, 0.000257697, 0.000322107, 0.000386485,
  0.000450826, 0.000515124, 0.000579372, 0.000643565, 0.000707696,
  0.000771759, 0.000835748, 0.000899657, 0.000963479, 0.00102721,
  0.00109084, 0.00115437, 0.00121778, 0.00128108, 0.00134426,
  0.0014073, 0.00147021, 0.00153298, 0.00159561, 0.00165808,
  0.00172039, 0.00178253, 0.00184451, 0.00190631, 0.00196792,
  0.00202934, 0.00209058, 0.00215161, 0.00221243, 0.00227304,
  0.00233343, 0.0023936, 0.00245354, 0.00251324, 0.0025727,
  0.00263192, 0.00269088, 0.00274958, 0.00280802, 0.00286619,
  0.00292408, 0.0029817, 0.00303902, 0.00309606, 0.0031528,
  0.00320923, 0.00326536, 0.00332117, 0.00337667, 0.00343184,
  0.00348668, 0.00354118, 0.00359535, 0.00364917, 0.00370264,
  0.00375575, 0.0038085, 0.00386089, 0.00391291, 0.00396455,
  0.00401581, 0.00406668, 0.00411716, 0.00416725, 0.00421694,
  0.00426622, 0.00431509, 0.00436355, 0.00441159, 0.0044592,
  0.00450639, 0.00455314, 0.00459945, 0.00464533, 0.00469075,
  0.00473573, 0.00478025, 0.00482431, 0.00486791, 0.00491104,
  0.0049537, 0.00499588, 0.00503758, 0.0050788, 0.00511952,
  0.00515976, 0.0051995, 0.00523874, 0.00527748, 0.00531571,
  0.00535343, 0.00539063, 0.00542732, 0.00546348, 0.00549912,
  0.00553423, 0.00556881, 0.00560285, 0.00563635, 0.00566932,
  0.00570173, 0.0057336, 0.00576492, 0.00579568, 0.00582588,
  0.00585552, 0.00588461, 0.00591312, 0.00594107, 0.00596844,
  0.00599524, 0.00602146, 0.00604711, 0.00607217, 0.00609665,
  0.00612054, 0.00614384, 0.00616655, 0.00618867, 0.00621019,
  0.00623111, 0.00625144, 0.00627116, 0.00629028, 0.00630879,
  0.0063267, 0.00634399, 0.00636068, 0.00637675, 0.00639221,
  0.00640706, 0.00642128, 0.00643489, 0.00644788, 0.00646025,
  0.006472, 0.00648312, 0.00649362, 0.00650349, 0.00651274,
  0.00652136, 0.00652935, 0.00653671, 0.00654344, 0.00654954,
  0.00655501, 0.00655985, 0.00656406, 0.00656763, 0.00657058,
  0.00657288, 0.00657456, 0.0065756, 0.00657601, 0.00657578,
  0.00657492, 0.00657342, 0.0065713, 0.00656853, 0.00656514,
  0.00656111, 0.00655645, 0.00655116, 0.00654523, 0.00653867,
  0.00653149, 0.00652367, 0.00651522, 0.00650615, 0.00649645,
  0.00648612, 0.00647516, 0.00646358, 0.00645138, 0.00643855,
  0.00642511, 0.00641104, 0.00639635, 0.00638105, 0.00636513,
  0.00634859, 0.00633145, 0.00631369, 0.00629532, 0.00627634,
  0.00625676, 0.00623658, 0.00621579, 0.0061944, 0.00617241,
  0.00614983, 0.00612665, 0.00610288, 0.00607852, 0.00605358,
  0.00602805, 0.00600193, 0.00597524, 0.00594797, 0.00592012,
  0.0058917, 0.00586271, 0.00583316, 0.00580304, 0.00577236,
  0.00574112, 0.00570933, 0.00567699, 0.00564409, 0.00561065,
  0.00557667, 0.00554215, 0.00550709, 0.0054715, 0.00543538,
  0.00539873, 0.00536156, 0.00532388, 0.00528567, 0.00524696,
  0.00520774, 0.00516801, 0.00512779, 0.00508706, 0.00504585,
  0.00500414, 0.00496196, 0.00491929, 0.00487614, 0.00483252,
  0.00478844, 0.00474389, 0.00469888, 0.00465341, 0.0046075,
  0.00456114, 0.00451433, 0.00446709, 0.00441942, 0.00437131,
  0.00432279, 0.00427384, 0.00422448, 0.00417471, 0.00412454,
  0.00407396, 0.00402299, 0.00397163, 0.00391989, 0.00386776,
  0.00381526, 0.00376239, 0.00370915, 0.00365556, 0.00360161,
  0.00354731, 0.00349266, 0.00343768, 0.00338236, 0.00332671,
  0.00327075, 0.00321446, 0.00315786, 0.00310095, 0.00304375,
  0.00298625, 0.00292845, 0.00287038, 0.00281202, 0.00275339,
  0.00269449, 0.00263534, 0.00257592, 0.00251626, 0.00245635,
  0.0023962, 0.00233582, 0.00227521, 0.00221438, 0.00215333,
  0.00209208, 0.00203062, 0.00196896, 0.00190711, 0.00184508,
  0.00178287, 0.00172048, 0.00165793, 0.00159521, 0.00153234,
  0.00146932, 0.00140616, 0.00134286, 0.00127943, 0.00121587,
  0.0011522, 0.00108841, 0.00102452, 0.00096053, 0.000896444,
  0.000832271, 0.000768017, 0.000703688, 0.000639291, 0.000574831,
  0.000510315, 0.00044575, 0.00038114, 0.000316494, 0.000251817,
  0.000187115, 0.000122395, 5.76629e-05, -7.07475e-06, -7.18117e-05,
  -0.000136542, -0.000201258, -0.000265955, -0.000330627,
  -0.000395265, -0.000459866, -0.000524421, -0.000588925,
  -0.000653372, -0.000717754, -0.000782067, -0.000846303,
  -0.000910457, -0.000974521, -0.00103849, -0.00110236, -0.00116612,
  -0.00122976, -0.00129329, -0.00135669, -0.00141996, -0.00148308,
  -0.00154607, -0.0016089, -0.00167157, -0.00173408, -0.00179642,
  -0.00185859, -0.00192057, -0.00198236, -0.00204396, -0.00210536,
  -0.00216656, -0.00222754, -0.0022883, -0.00234884, -0.00240915,
  -0.00246923, -0.00252906, -0.00258864, -0.00264797, -0.00270704,
  -0.00276584, -0.00282438, -0.00288263, -0.00294061, -0.00299829,
  -0.00305568, -0.00311277, -0.00316956, -0.00322603, -0.00328219,
  -0.00333803, -0.00339353, -0.00344871, -0.00350354, -0.00355803,
  -0.00361218, -0.00366596, -0.00371939, -0.00377245, -0.00382514,
  -0.00387745, -0.00392939, -0.00398093, -0.00403209, -0.00408285,
  -0.00413321, -0.00418316, -0.00423269, -0.00428182, -0.00433052,
  -0.00437879, -0.00442664, -0.00447404, -0.00452101, -0.00456753,
  -0.0046136, -0.00465922, -0.00470438, -0.00474908, -0.0047933,
  -0.00483706, -0.00488034, -0.00492313, -0.00496544, -0.00500727,
  -0.00504859, -0.00508942, -0.00512975, -0.00516957, -0.00520888,
  -0.00524768, -0.00528596, -0.00532372, -0.00536095, -0.00539765,
  -0.00543382, -0.00546946, -0.00550455, -0.0055391, -0.0055731,
  -0.00560655, -0.00563945, -0.00567179, -0.00570356, -0.00573478,
  -0.00576543, -0.0057955, -0.00582501, -0.00585393, -0.00588228,
  -0.00591005, -0.00593723, -0.00596382, -0.00598982, -0.00601523,
  -0.00604005, -0.00606426, -0.00608788, -0.00611089, -0.0061333,
  -0.00615509, -0.00617628, -0.00619686, -0.00621682, -0.00623616,
  -0.00625489, -0.006273, -0.00629048, -0.00630734, -0.00632357,
  -0.00633918, -0.00635416, -0.0063685, -0.00638221, -0.00639529,
  -0.00640774, -0.00641954, -0.00643071, -0.00644125, -0.00645114,
  -0.00646038, -0.00646899, -0.00647695, -0.00648427, -0.00649095,
  -0.00649698, -0.00650236, -0.00650709, -0.00651118, -0.00651462,
  -0.00651741, -0.00651955, -0.00652105, -0.00652189, -0.00652208,
  -0.00652162, -0.00652052, -0.00651876, -0.00651636, -0.0065133,
  -0.00650959, -0.00650524, -0.00650023, -0.00649458, -0.00648828,
  -0.00648133, -0.00647374, -0.0064655, -0.00645661, -0.00644708,
  -0.0064369, -0.00642609, -0.00641463, -0.00640252, -0.00638978,
  -0.0063764, -0.00636239, -0.00634773, -0.00633244, -0.00631652,
  -0.00629997, -0.00628278, -0.00626497, -0.00624653, -0.00622746,
  -0.00620777, -0.00618746, -0.00616653, -0.00614498, -0.00612282,
  -0.00610004, -0.00607665, -0.00605265, -0.00602805, -0.00600284,
  -0.00597702, -0.00595061, -0.0059236, -0.005896, -0.0058678,
  -0.00583902, -0.00580965, -0.0057797, -0.00574916, -0.00571805,
  -0.00568636, -0.0056541, -0.00562128, -0.00558789, -0.00555393,
  -0.00551942, -0.00548435, -0.00544874, -0.00541257, -0.00537586,
  -0.0053386, -0.00530081, -0.00526249, -0.00522364, -0.00518426,
  -0.00514435, -0.00510393, -0.005063, -0.00502155, -0.0049796,
  -0.00493714, -0.00489419, -0.00485075, -0.00480681, -0.00476239,
  -0.00471749, -0.00467211, -0.00462626, -0.00457995, -0.00453317,
  -0.00448593, -0.00443824, -0.0043901, -0.00434152, -0.0042925,
  -0.00424304, -0.00419316, -0.00414285, -0.00409212, -0.00404098,
  -0.00398942, -0.00393747, -0.00388512, -0.00383237, -0.00377923,
  -0.00372571, -0.00367182, -0.00361755, -0.00356291, -0.00350792,
  -0.00345257, -0.00339686, -0.00334082, -0.00328443, -0.00322771,
  -0.00317066, -0.0031133, -0.00305561, -0.00299762, -0.00293932,
  -0.00288072, -0.00282183, -0.00276265, -0.00270319, -0.00264345,
  -0.00258345, -0.00252319, -0.00246266, -0.00240189, -0.00234087,
  -0.00227962, -0.00221813, -0.00215641, -0.00209448, -0.00203233,
  -0.00196998, -0.00190742, -0.00184467, -0.00178173, -0.00171861,
  -0.00165532, -0.00159186, -0.00152823, -0.00146445, -0.00140052,
  -0.00133644, -0.00127223, -0.00120789, -0.00114342, -0.00107884,
  -0.00101415, -0.000949353, -0.00088446, -0.000819476, -0.000754409,
  -0.000689265, -0.00062405, -0.000558771, -0.000493435, -0.000428048,
  -0.000362618, -0.00029715, -0.000231652, -0.00016613, -0.000100591,
  -3.50423e-05, 3.05104e-05, 9.606e-05, 0.0001616, 0.000227123,
  0.000292622, 0.000358092, 0.000423525, 0.000488914, 0.000554254,
  0.000619536, 0.000684754, 0.000749902, 0.000814973, 0.00087996,
  0.000944856, 0.00100966, 0.00107435, 0.00113893, 0.0012034,
  0.00126774, 0.00133196, 0.00139603, 0.00145996, 0.00152374,
  0.00158737, 0.00165083, 0.00171412, 0.00177723, 0.00184016,
  0.0019029, 0.00196544, 0.00202778, 0.00208991, 0.00215182,
  0.00221351, 0.00227498, 0.0023362, 0.00239719, 0.00245793,
  0.00251841, 0.00257863, 0.00263859, 0.00269827, 0.00275767,
  0.00281679, 0.00287561, 0.00293414, 0.00299236, 0.00305027,
  0.00310787, 0.00316514, 0.00322208, 0.00327869, 0.00333496,
  0.00339089, 0.00344646, 0.00350167, 0.00355652, 0.003611, 0.0036651,
  0.00371882, 0.00377216, 0.0038251, 0.00387764, 0.00392978,
  0.00398151, 0.00403283, 0.00408373, 0.0041342, 0.00418424,
  0.00423384, 0.004283, 0.00433172, 0.00437998, 0.00442779,
  0.00447513, 0.00452201, 0.00456841, 0.00461434, 0.00465978,
  0.00470474, 0.00474921, 0.00479318, 0.00483664, 0.0048796,
  0.00492206, 0.00496399, 0.00500541, 0.0050463, 0.00508666,
  0.00512649, 0.00516578, 0.00520453, 0.00524274, 0.00528039,
  0.00531749, 0.00535404, 0.00539002, 0.00542543, 0.00546028,
  0.00549455, 0.00552824, 0.00556136, 0.00559389, 0.00562583,
  0.00565717, 0.00568793, 0.00571808, 0.00574763, 0.00577658,
  0.00580492, 0.00583265, 0.00585976, 0.00588625, 0.00591213,
  0.00593738, 0.005962, 0.005986, 0.00600936, 0.00603209, 0.00605418,
  0.00607563, 0.00609644, 0.00611661, 0.00613613, 0.006155,
  0.00617322, 0.00619078, 0.00620769, 0.00622395, 0.00623954,
  0.00625448, 0.00626875, 0.00628235, 0.0062953, 0.00630757,
  0.00631917, 0.00633011, 0.00634037, 0.00634996, 0.00635887,
  0.00636711, 0.00637468, 0.00638156, 0.00638777, 0.0063933,
  0.00639815, 0.00640231, 0.0064058, 0.0064086, 0.00641073,
  0.00641217, 0.00641292, 0.006413, 0.00641238, 0.00641109,
  0.00640911, 0.00640645, 0.0064031, 0.00639908, 0.00639436,
  0.00638897, 0.00638289, 0.00637613, 0.00636869, 0.00636057,
  0.00635177, 0.00634228, 0.00633212, 0.00632128, 0.00630977,
  0.00629758, 0.00628471, 0.00627117, 0.00625696, 0.00624208,
  0.00622653, 0.0062103, 0.00619342, 0.00617587, 0.00615765,
  0.00613878, 0.00611924, 0.00609905, 0.0060782, 0.00605669,
  0.00603454, 0.00601174, 0.00598828, 0.00596419, 0.00593945,
  0.00591407, 0.00588806, 0.00586141, 0.00583413, 0.00580621,
  0.00577768, 0.00574851, 0.00571873, 0.00568833, 0.00565732,
  0.00562569, 0.00559346, 0.00556062, 0.00552718, 0.00549315,
  0.00545851, 0.00542329, 0.00538748, 0.00535109, 0.00531411,
  0.00527656, 0.00523844, 0.00519975, 0.0051605, 0.00512069,
  0.00508032, 0.0050394, 0.00499793, 0.00495592, 0.00491337,
  0.00487028, 0.00482667, 0.00478253, 0.00473787, 0.00469269,
  0.00464701, 0.00460081, 0.00455412, 0.00450693, 0.00445925,
  0.00441108, 0.00436243, 0.00431331, 0.00426371, 0.00421365,
  0.00416313, 0.00411215, 0.00406073, 0.00400886, 0.00395655,
  0.00390381, 0.00385064, 0.00379705, 0.00374304, 0.00368863,
  0.00363381, 0.00357859, 0.00352298, 0.00346698, 0.0034106,
  0.00335385, 0.00329673, 0.00323925, 0.00318141, 0.00312322,
  0.00306469, 0.00300583, 0.00294663, 0.0028871, 0.00282726,
  0.00276711, 0.00270665, 0.0026459, 0.00258485, 0.00252352,
  0.00246191, 0.00240003, 0.00233788, 0.00227548, 0.00221282,
  0.00214992, 0.00208678, 0.00202341, 0.00195982, 0.00189601,
  0.00183199, 0.00176777, 0.00170335, 0.00163874, 0.00157395,
  0.00150899, 0.00144386, 0.00137857, 0.00131313, 0.00124754,
  0.00118181, 0.00111595, 0.00104997, 0.000983871, 0.000917662,
  0.000851351, 0.000784945, 0.000718452, 0.000651879, 0.000585233,
  0.000518522, 0.000451753, 0.000384934, 0.000318072, 0.000251174,
  0.000184248, 0.000117302, 5.03427e-05, -1.66223e-05, -8.35855e-05,
  -0.000150539, -0.000217476, -0.000284389, -0.00035127, -0.000418112,
  -0.000484906, -0.000551647, -0.000618325, -0.000684935,
  -0.000751467, -0.000817915, -0.000884272, -0.000950529, -0.00101668,
  -0.00108272, -0.00114863, -0.00121442, -0.00128006, -0.00134557,
  -0.00141092, -0.00147612, -0.00154114, -0.001606, -0.00167067,
  -0.00173516, -0.00179945, -0.00186353, -0.00192741, -0.00199107,
  -0.0020545, -0.0021177, -0.00218066, -0.00224338, -0.00230584,
  -0.00236804, -0.00242997, -0.00249163, -0.00255301, -0.00261409,
  -0.00267488, -0.00273537, -0.00279554, -0.0028554, -0.00291493,
  -0.00297414, -0.003033, -0.00309152, -0.00314969, -0.0032075,
  -0.00326494, -0.00332202, -0.00337871, -0.00343502, -0.00349094,
  -0.00354646, -0.00360158, -0.00365628, -0.00371057, -0.00376443,
  -0.00381787, -0.00387087, -0.00392342, -0.00397553, -0.00402718,
  -0.00407837, -0.00412909, -0.00417934, -0.00422911, -0.0042784,
  -0.0043272, -0.0043755, -0.00442329, -0.00447058, -0.00451736,
  -0.00456362, -0.00460935, -0.00465455, -0.00469922, -0.00474335,
  -0.00478693, -0.00482996, -0.00487243, -0.00491434, -0.00495569,
  -0.00499646, -0.00503665, -0.00507627, -0.0051153, -0.00515374,
  -0.00519158, -0.00522882, -0.00526546, -0.00530148, -0.0053369,
  -0.00537169, -0.00540587, -0.00543941, -0.00547233, -0.00550461,
  -0.00553625, -0.00556725, -0.00559761, -0.00562731, -0.00565636,
  -0.00568475, -0.00571248, -0.00573955, -0.00576595, -0.00579167,
  -0.00581672, -0.0058411, -0.00586479, -0.00588779, -0.00591012,
  -0.00593175, -0.00595268, -0.00597293, -0.00599247, -0.00601131,
  -0.00602945, -0.00604689, -0.00606361, -0.00607963, -0.00609493,
  -0.00610952, -0.0061234, -0.00613655, -0.00614898, -0.0061607,
  -0.00617168, -0.00618195, -0.00619148, -0.00620029, -0.00620837,
  -0.00621572, -0.00622233, -0.00622821, -0.00623336, -0.00623777,
  -0.00624145, -0.00624439, -0.00624659, -0.00624806, -0.00624879,
  -0.00624877, -0.00624802, -0.00624653, -0.0062443, -0.00624133,
  -0.00623762, -0.00623318, -0.00622799, -0.00622206, -0.0062154,
  -0.006208, -0.00619986, -0.00619098, -0.00618137, -0.00617102,
  -0.00615994, -0.00614812, -0.00613557, -0.00612229, -0.00610829,
  -0.00609355, -0.00607808, -0.0060619, -0.00604498, -0.00602735,
  -0.00600899, -0.00598992, -0.00597013, -0.00594962, -0.0059284,
  -0.00590647, -0.00588384, -0.0058605, -0.00583645, -0.00581171,
  -0.00578627, -0.00576013, -0.0057333, -0.00570578, -0.00567758,
  -0.00564869, -0.00561913, -0.00558888, -0.00555796, -0.00552638,
  -0.00549412, -0.00546121, -0.00542763, -0.0053934, -0.00535852,
  -0.00532299, -0.00528681, -0.00525, -0.00521255, -0.00517447,
  -0.00513576, -0.00509643, -0.00505648, -0.00501592, -0.00497475,
  -0.00493298, -0.00489061, -0.00484764, -0.00480408, -0.00475994,
  -0.00471522, -0.00466993, -0.00462406, -0.00457764, -0.00453065,
  -0.00448311, -0.00443503, -0.0043864, -0.00433724, -0.00428755,
  -0.00423733, -0.00418659, -0.00413535, -0.00408359, -0.00403134,
  -0.00397859, -0.00392535, -0.00387164, -0.00381744, -0.00376278,
  -0.00370766, -0.00365208, -0.00359605, -0.00353958, -0.00348267,
  -0.00342533, -0.00336758, -0.0033094, -0.00325082, -0.00319184,
  -0.00313246, -0.0030727, -0.00301256, -0.00295204, -0.00289116,
  -0.00282992, -0.00276833, -0.0027064, -0.00264413, -0.00258154,
  -0.00251862, -0.0024554, -0.00239186, -0.00232803, -0.00226391,
  -0.00219951, -0.00213484, -0.0020699, -0.0020047, -0.00193925,
  -0.00187356, -0.00180764, -0.00174149, -0.00167512, -0.00160855,
  -0.00154177, -0.0014748, -0.00140765, -0.00134032, -0.00127282,
  -0.00120516, -0.00113735, -0.0010694, -0.00100132, -0.000933107,
  -0.000864779, -0.000796342, -0.000727805, -0.000659176,
  -0.000590465, -0.000521679, -0.000452828, -0.000383919,
  -0.000314962, -0.000245965, -0.000176937, -0.000107887,
  -3.88232e-05, 3.02454e-05, 9.93103e-05, 0.000168363, 0.000237393,
  0.000306394, 0.000375356, 0.00044427, 0.000513128, 0.000581921,
  0.00065064, 0.000719276, 0.00078782, 0.000856265, 0.0009246,
  0.000992817, 0.00106091, 0.00112886, 0.00119668, 0.00126433,
  0.00133183, 0.00139916, 0.00146631, 0.00153327, 0.00160003,
  0.00166659, 0.00173294, 0.00179906, 0.00186495, 0.00193061,
  0.00199601, 0.00206116, 0.00212604, 0.00219065, 0.00225498,
  0.00231902, 0.00238276, 0.00244619, 0.00250931, 0.0025721,
  0.00263456, 0.00269669, 0.00275846, 0.00281987, 0.00288092,
  0.0029416, 0.0030019, 0.0030618, 0.00312131, 0.00318042, 0.00323911,
  0.00329738, 0.00335523, 0.00341263, 0.0034696, 0.00352611,
  0.00358216, 0.00363774, 0.00369285, 0.00374748, 0.00380162,
  0.00385527, 0.0039084, 0.00396103, 0.00401314, 0.00406473,
  0.00411578, 0.00416629, 0.00421626, 0.00426567, 0.00431452,
  0.00436281, 0.00441052, 0.00445766, 0.0045042, 0.00455016,
  0.00459551, 0.00464026, 0.00468439, 0.00472791, 0.00477081,
  0.00481307, 0.0048547, 0.00489568, 0.00493602, 0.0049757,
  0.00501473, 0.00505309, 0.00509078, 0.00512779, 0.00516412,
  0.00519977, 0.00523473, 0.00526898, 0.00530254, 0.00533539,
  0.00536753, 0.00539896, 0.00542966, 0.00545964, 0.00548889,
  0.00551741, 0.00554519, 0.00557222, 0.00559851, 0.00562405,
  0.00564884, 0.00567287, 0.00569614, 0.00571864, 0.00574037,
  0.00576133, 0.00578152, 0.00580093, 0.00581956, 0.0058374,
  0.00585445, 0.00587072, 0.00588619, 0.00590087, 0.00591475,
  0.00592783, 0.00594011, 0.00595158, 0.00596225, 0.0059721,
  0.00598115, 0.00598939, 0.00599681, 0.00600342, 0.00600921,
  0.00601418, 0.00601833, 0.00602167, 0.00602418, 0.00602587,
  0.00602674, 0.00602678, 0.006026, 0.0060244, 0.00602197, 0.00601871,
  0.00601464, 0.00600973, 0.00600401, 0.00599746, 0.00599008,
  0.00598188, 0.00597286, 0.00596302, 0.00595235, 0.00594087,
  0.00592856, 0.00591544, 0.0059015, 0.00588675, 0.00587118,
  0.0058548, 0.00583761, 0.00581961, 0.0058008, 0.00578119,
  0.00576078, 0.00573956, 0.00571755, 0.00569475, 0.00567115,
  0.00564676, 0.00562159, 0.00559563, 0.00556889, 0.00554138,
  0.00551309, 0.00548403, 0.0054542, 0.00542361, 0.00539226,
  0.00536015, 0.0053273, 0.00529369, 0.00525934, 0.00522426,
  0.00518843, 0.00515188, 0.0051146, 0.00507661, 0.00503789,
  0.00499847, 0.00495834, 0.00491751, 0.00487599, 0.00483377,
  0.00479087, 0.00474729, 0.00470304, 0.00465813, 0.00461255,
  0.00456632, 0.00451943, 0.00447191, 0.00442375, 0.00437496,
  0.00432554, 0.00427551, 0.00422487, 0.00417363, 0.00412178,
  0.00406935, 0.00401634, 0.00396275, 0.0039086, 0.00385388,
  0.00379862, 0.0037428, 0.00368645, 0.00362957, 0.00357216,
  0.00351425, 0.00345582, 0.0033969, 0.00333749, 0.00327759,
  0.00321722, 0.00315639, 0.0030951, 0.00303336, 0.00297119,
  0.00290858, 0.00284555, 0.00278211, 0.00271826, 0.00265402,
  0.00258939, 0.00252438, 0.00245901, 0.00239328, 0.0023272,
  0.00226078, 0.00219403, 0.00212695, 0.00205957, 0.00199189,
  0.00192391, 0.00185565, 0.00178712, 0.00171833, 0.00164928,
  0.00157999, 0.00151047, 0.00144073, 0.00137077, 0.00130061,
  0.00123026, 0.00115973, 0.00108903, 0.00101817, 0.000947152,
  0.000875997, 0.000804712, 0.000733308, 0.000661794, 0.000590183,
  0.000518484, 0.000446707, 0.000374864, 0.000302965, 0.000231021,
  0.000159043, 8.70407e-05, 1.50254e-05, -5.69922e-05, -0.000129001,
  -0.000200991, -0.000272951, -0.000344869, -0.000416736,
  -0.000488541, -0.000560272, -0.000631918, -0.00070347, -0.000774915,
  -0.000846244, -0.000917445, -0.000988508, -0.00105942, -0.00113017,
  -0.00120076, -0.00127116, -0.00134136, -0.00141137, -0.00148116,
  -0.00155072, -0.00162005, -0.00168913, -0.00175796, -0.00182651,
  -0.00189479, -0.00196278, -0.00203047, -0.00209785, -0.00216491,
  -0.00223163, -0.00229802, -0.00236405, -0.00242972, -0.00249502,
  -0.00255993, -0.00262445, -0.00268856, -0.00275226, -0.00281554,
  -0.00287838, -0.00294078, -0.00300272, -0.0030642, -0.0031252,
  -0.00318572, -0.00324574, -0.00330527, -0.00336427, -0.00342276,
  -0.00348071, -0.00353812, -0.00359498, -0.00365128, -0.00370701,
  -0.00376216, -0.00381672, -0.00387069, -0.00392405, -0.00397679,
  -0.00402891, -0.0040804, -0.00413125, -0.00418144, -0.00423098,
  -0.00427986, -0.00432806, -0.00437557, -0.0044224, -0.00446853,
  -0.00451395, -0.00455865, -0.00460264, -0.00464589, -0.00468841,
  -0.00473018, -0.0047712, -0.00481146, -0.00485096, -0.00488969,
  -0.00492763, -0.00496479, -0.00500115, -0.00503672, -0.00507148,
  -0.00510543, -0.00513856, -0.00517086, -0.00520234, -0.00523298,
  -0.00526278, -0.00529173, -0.00531983, -0.00534707, -0.00537345,
  -0.00539896, -0.0054236, -0.00544736, -0.00547024, -0.00549223,
  -0.00551334, -0.00553354, -0.00555285, -0.00557126, -0.00558876,
  -0.00560535, -0.00562102, -0.00563578, -0.00564962, -0.00566253,
  -0.00567452, -0.00568558, -0.00569571, -0.0057049, -0.00571315,
  -0.00572047, -0.00572685, -0.00573228, -0.00573677, -0.00574032,
  -0.00574291, -0.00574456, -0.00574526, -0.005745, -0.0057438,
  -0.00574164, -0.00573853, -0.00573447, -0.00572946, -0.00572349,
  -0.00571657, -0.00570869, -0.00569986, -0.00569008, -0.00567935,
  -0.00566767, -0.00565505, -0.00564147, -0.00562695, -0.00561148,
  -0.00559507, -0.00557771, -0.00555942, -0.0055402, -0.00552003,
  -0.00549894, -0.00547692, -0.00545397, -0.00543009, -0.0054053,
  -0.00537959, -0.00535297, -0.00532543, -0.00529699, -0.00526765,
  -0.00523742, -0.00520628, -0.00517426, -0.00514136, -0.00510758,
  -0.00507292, -0.00503739, -0.005001, -0.00496375, -0.00492564,
  -0.00488669, -0.0048469, -0.00480627, -0.00476482, -0.00472254,
  -0.00467944, -0.00463553, -0.00459083, -0.00454532, -0.00449903,
  -0.00445196, -0.00440411, -0.00435549, -0.00430612, -0.00425599,
  -0.00420513, -0.00415353, -0.0041012, -0.00404815, -0.0039944,
  -0.00393994, -0.00388479, -0.00382896, -0.00377246, -0.00371529,
  -0.00365747, -0.003599, -0.0035399, -0.00348017, -0.00341983,
  -0.00335887, -0.00329733, -0.0032352, -0.00317249, -0.00310922,
  -0.0030454, -0.00298103, -0.00291613, -0.00285071, -0.00278478,
  -0.00271836, -0.00265144, -0.00258405, -0.0025162, -0.00244789,
  -0.00237915, -0.00230998, -0.00224039, -0.00217039, -0.00210001,
  -0.00202924, -0.00195811, -0.00188662, -0.00181479, -0.00174263,
  -0.00167016, -0.00159738, -0.00152431, -0.00145096, -0.00137735,
  -0.00130348, -0.00122938, -0.00115505, -0.00108051, -0.00100578,
  -0.000930854, -0.000855761, -0.000780511, -0.000705116,
  -0.000629592, -0.000553952, -0.000478209, -0.000402377,
  -0.000326472, -0.000250505, -0.000174493, -9.84476e-05,
  -2.23842e-05, 5.36833e-05, 0.000129741, 0.000205774, 0.000281769,
  0.000357711, 0.000433586, 0.00050938, 0.000585078, 0.000660666,
  0.00073613, 0.000811456, 0.000886628, 0.000961634, 0.00103646,
  0.00111108, 0.0011855, 0.00125969, 0.00133365, 0.00140735,
  0.00148078, 0.00155393, 0.00162679, 0.00169933, 0.00177155,
  0.00184343, 0.00191496, 0.00198612, 0.0020569, 0.00212729,
  0.00219726, 0.00226682, 0.00233593, 0.0024046, 0.0024728,
  0.00254052, 0.00260776, 0.00267448, 0.00274069, 0.00280636,
  0.00287149, 0.00293606, 0.00300006, 0.00306347, 0.00312628,
  0.00318849, 0.00325006, 0.003311, 0.00337129, 0.00343092,
  0.00348987, 0.00354814, 0.0036057, 0.00366256, 0.00371869,
  0.00377408, 0.00382872, 0.00388261, 0.00393572, 0.00398806,
  0.00403959, 0.00409033, 0.00414024, 0.00418933, 0.00423758,
  0.00428498, 0.00433153, 0.0043772, 0.00442199, 0.0044659, 0.0045089,
  0.00455099, 0.00459217, 0.00463241, 0.00467172, 0.00471008,
  0.00474748, 0.00478392, 0.00481939, 0.00485387, 0.00488737,
  0.00491986, 0.00495135, 0.00498183, 0.00501128, 0.00503971,
  0.0050671, 0.00509344, 0.00511874, 0.00514298, 0.00516616,
  0.00518827, 0.00520931, 0.00522926, 0.00524813, 0.00526591,
  0.0052826, 0.00529818, 0.00531266, 0.00532602, 0.00533828,
  0.00534941, 0.00535942, 0.00536831, 0.00537607, 0.0053827,
  0.00538819, 0.00539254, 0.00539576, 0.00539783, 0.00539876,
  0.00539854, 0.00539717, 0.00539466, 0.005391, 0.00538619,
  0.00538023, 0.00537311, 0.00536485, 0.00535543, 0.00534487,
  0.00533316, 0.00532029, 0.00530628, 0.00529113, 0.00527483,
  0.00525739, 0.00523881, 0.00521909, 0.00519824, 0.00517626,
  0.00515315, 0.00512891, 0.00510356, 0.00507708, 0.0050495,
  0.0050208, 0.00499101, 0.00496011, 0.00492812, 0.00489505,
  0.00486089, 0.00482566, 0.00478936, 0.00475199, 0.00471357,
  0.00467411, 0.0046336, 0.00459205, 0.00454948, 0.00450589,
  0.0044613, 0.0044157, 0.00436911, 0.00432153, 0.00427299,
  0.00422348, 0.00417301, 0.0041216, 0.00406926, 0.00401599,
  0.00396181, 0.00390672, 0.00385075, 0.0037939, 0.00373618,
  0.00367761, 0.00361819, 0.00355794, 0.00349687, 0.003435,
  0.00337234, 0.0033089, 0.00324469, 0.00317973, 0.00311403,
  0.00304761, 0.00298048, 0.00291266, 0.00284416, 0.00277499,
  0.00270517, 0.00263472, 0.00256365, 0.00249198, 0.00241972,
  0.00234689, 0.0022735, 0.00219958, 0.00212514, 0.00205019,
  0.00197475, 0.00189885, 0.00182249, 0.0017457, 0.00166849,
  0.00159088, 0.00151289, 0.00143453, 0.00135583, 0.00127681,
  0.00119747, 0.00111785, 0.00103796, 0.000957809, 0.000877431,
  0.000796839, 0.000716053, 0.000635092, 0.000553976, 0.000472724,
  0.000391356, 0.000309893, 0.000228353, 0.000146756, 6.5124e-05,
  -1.65246e-05, -9.81691e-05, -0.000179789, -0.000261365,
  -0.000342876, -0.000424301, -0.00050562, -0.000586813, -0.000667859,
  -0.000748738, -0.000829429, -0.000909911, -0.000990163, -0.00107017,
  -0.0011499, -0.00122934, -0.00130847, -0.00138727, -0.00146571,
  -0.00154378, -0.00162146, -0.00169872, -0.00177554, -0.00185191,
  -0.00192781, -0.0020032, -0.00207808, -0.00215243, -0.00222622,
  -0.00229942, -0.00237204, -0.00244403, -0.00251539, -0.00258609,
  -0.00265611, -0.00272544, -0.00279406, -0.00286194, -0.00292906,
  -0.00299541, -0.00306097, -0.00312572, -0.00318964, -0.00325272,
  -0.00331493, -0.00337625, -0.00343667, -0.00349617, -0.00355474,
  -0.00361235, -0.00366899, -0.00372464, -0.00377928, -0.0038329,
  -0.00388548, -0.00393701, -0.00398747, -0.00403684, -0.00408511,
  -0.00413226, -0.00417828, -0.00422315, -0.00426686, -0.0043094,
  -0.00435074, -0.00439089, -0.00442981, -0.00446751, -0.00450396,
  -0.00453916, -0.00457309, -0.00460575, -0.00463711, -0.00466717,
  -0.00469592, -0.00472334, -0.00474944, -0.00477418, -0.00479758,
  -0.00481961, -0.00484027, -0.00485955, -0.00487745, -0.00489395,
  -0.00490904, -0.00492273, -0.00493499, -0.00494584, -0.00495525,
  -0.00496323, -0.00496977, -0.00497487, -0.00497851, -0.00498071,
  -0.00498144, -0.00498072, -0.00497853, -0.00497488, -0.00496977,
  -0.00496318, -0.00495513, -0.0049456, -0.00493461, -0.00492215,
  -0.00490822, -0.00489282, -0.00487595, -0.00485762, -0.00483783,
  -0.00481658, -0.00479388, -0.00476972, -0.00474412, -0.00471707,
  -0.00468859, -0.00465867, -0.00462733, -0.00459457, -0.0045604,
  -0.00452483, -0.00448786, -0.0044495, -0.00440976, -0.00436865,
  -0.00432619, -0.00428237, -0.00423722, -0.00419074, -0.00414294,
  -0.00409384, -0.00404345, -0.00399178, -0.00393884, -0.00388466,
  -0.00382924, -0.0037726, -0.00371475, -0.00365572, -0.00359551,
  -0.00353415, -0.00347164, -0.00340801, -0.00334329, -0.00327747,
  -0.00321059, -0.00314266, -0.00307371, -0.00300374, -0.0029328,
  -0.00286088, -0.00278803, -0.00271425, -0.00263957, -0.00256401,
  -0.00248761, -0.00241037, -0.00233232, -0.0022535, -0.00217391,
  -0.0020936, -0.00201257, -0.00193087, -0.00184851, -0.00176552,
  -0.00168193, -0.00159777, -0.00151306, -0.00142782, -0.0013421,
  -0.00125592, -0.0011693, -0.00108227, -0.000994868, -0.000907119,
  -0.000819054, -0.000730701, -0.000642092, -0.000553258,
  -0.000464228, -0.000375034, -0.000285707, -0.000196278,
  -0.000106779, -1.72429e-05, 7.22998e-05, 0.000161816, 0.000251275,
  0.000340642, 0.000429887, 0.000518975, 0.000607874, 0.000696551,
  0.000784974, 0.000873109, 0.000960922, 0.00104838, 0.00113545,
  0.0012221, 0.0013083, 0.00139401, 0.0014792, 0.00156383, 0.00164788,
  0.0017313, 0.00181408, 0.00189616, 0.00197753, 0.00205814,
  0.00213797, 0.00221697, 0.00229513, 0.0023724, 0.00244876,
  0.00252417, 0.0025986, 0.00267201, 0.00274439, 0.00281568,
  0.00288588, 0.00295494, 0.00302283, 0.00308952, 0.00315498,
  0.00321919, 0.00328212, 0.00334372, 0.00340399, 0.00346288,
  0.00352037, 0.00357644, 0.00363105, 0.00368418, 0.00373581,
  0.0037859, 0.00383443, 0.00388139, 0.00392673, 0.00397045,
  0.00401251, 0.00405289, 0.00409158, 0.00412855, 0.00416378,
  0.00419724, 0.00422893, 0.00425881, 0.00428688, 0.00431311,
  0.00433749, 0.00436, 0.00438063, 0.00439936, 0.00441617, 0.00443105,
  0.004444, 0.00445499, 0.00446402, 0.00447108, 0.00447615,
  0.00447923, 0.00448031, 0.00447938, 0.00447644, 0.00447148,
  0.0044645, 0.00445549, 0.00444445, 0.00443138, 0.00441628,
  0.00439915, 0.00437998, 0.00435879, 0.00433557, 0.00431032,
  0.00428306, 0.00425378, 0.0042225, 0.00418923, 0.00415396,
  0.00411671, 0.0040775, 0.00403633, 0.00399321, 0.00394817,
  0.00390121, 0.00385235, 0.0038016, 0.003749, 0.00369455, 0.00363827,
  0.00358019, 0.00352032, 0.0034587, 0.00339535, 0.00333028,
  0.00326353, 0.00319513, 0.0031251, 0.00305347, 0.00298028,
  0.00290555, 0.00282932, 0.00275162, 0.00267249, 0.00259196,
  0.00251007, 0.00242685, 0.00234235, 0.0022566, 0.00216965,
  0.00208154, 0.00199231, 0.001902, 0.00181066, 0.00171833,
  0.00162507, 0.00153091, 0.00143591, 0.00134011, 0.00124357,
  0.00114633, 0.00104845, 0.000949977, 0.000850969, 0.000751477,
  0.000651556, 0.000551262, 0.000450651, 0.000349779, 0.000248704,
  0.000147484, 4.61773e-05, -5.51564e-05, -0.000156458, -0.000257666,
  -0.00035872, -0.00045956, -0.000560123, -0.000660348, -0.000760171,
  -0.00085953, -0.000958362, -0.0010566, -0.00115419, -0.00125106,
  -0.00134715, -0.00144239, -0.00153672, -0.00163008, -0.0017224,
  -0.00181362, -0.00190367, -0.00199248, -0.00208001, -0.00216617,
  -0.00225091, -0.00233417, -0.00241588, -0.00249598, -0.00257441,
  -0.0026511, -0.002726, -0.00279904, -0.00287017, -0.00293932,
  -0.00300644, -0.00307147, -0.00313435, -0.00319503, -0.00325346,
  -0.00330957, -0.00336331, -0.00341464, -0.00346351, -0.00350985,
  -0.00355364, -0.00359481, -0.00363332, -0.00366913, -0.0037022,
  -0.00373249, -0.00375995, -0.00378455, -0.00380626, -0.00382503,
  -0.00384084, -0.00385366, -0.00386345, -0.0038702, -0.00387387,
  -0.00387445, -0.00387191, -0.00386624, -0.00385743, -0.00384545,
  -0.0038303, -0.00381198, -0.00379046, -0.00376576, -0.00373788,
  -0.0037068, -0.00367255, -0.00363512, -0.00359454, -0.0035508,
  -0.00350393, -0.00345396, -0.00340089, -0.00334477, -0.0032856,
  -0.00322344, -0.00315831, -0.00309026, -0.00301932, -0.00294554,
  -0.00286897, -0.00278966, -0.00270766, -0.00262305, -0.00253587,
  -0.00244619, -0.00235408, -0.00225963, -0.00216289, -0.00206396,
  -0.00196291, -0.00185983, -0.00175482, -0.00164796, -0.00153936,
  -0.00142912, -0.00131734, -0.00120413, -0.00108959, -0.000973857,
  -0.000857035, -0.000739248, -0.000620622, -0.000501286, -0.00038137,
  -0.000261009, -0.000140341, -1.95062e-05, 0.000101351, 0.000222086,
  0.000342548, 0.000462586, 0.000582046, 0.000700771, 0.000818603,
  0.000935381, 0.00105094, 0.00116512, 0.00127775, 0.00138866,
  0.00149769, 0.00160466, 0.0017094, 0.00181175, 0.00191152,
  0.00200855, 0.00210265, 0.00219367, 0.00228142, 0.00236574,
  0.00244645, 0.00252338, 0.00259637, 0.00266525, 0.00272986,
  0.00279004, 0.00284562, 0.00289645, 0.00294239, 0.00298328,
  0.00301899, 0.00304937, 0.00307429, 0.00309364, 0.00310729,
  0.00311512, 0.00311704, 0.00311295, 0.00310275, 0.00308638,
  0.00306376, 0.00303484, 0.00299956, 0.00295789, 0.00290982,
  0.00285533, 0.00279443, 0.00272713, 0.00265347, 0.00257351,
  0.0024873, 0.00239495, 0.00229656, 0.00219224, 0.00208216,
  0.00196647, 0.00184538, 0.00171909, 0.00158785, 0.00145193,
  0.00131162, 0.00116724, 0.00101915, 0.000867735, 0.000713407,
  0.000556618, 0.000397853, 0.000237635, 7.65228e-05, -8.48848e-05,
  -0.000245948, -0.000405984, -0.000564268, -0.000720027,
  -0.000872442, -0.00102064, -0.00116372, -0.00130068, -0.00143052,
  -0.00155215, -0.00166442, -0.00176613, -0.00185603, -0.00193277,
  -0.00199497, -0.00204115, -0.00206979, -0.00207926, -0.00206789,
  -0.00203391, -0.00197546, -0.00189063, -0.00177738, -0.00163362,
  -0.00145714, -0.00124566, -0.000996769, -0.000707988, -0.000376716,
  -2.49999e-07}; const G4double G4NeutronHPFastLegendre::l25[5201] = {-1,
  -0.878841, -0.765155, -0.658634, -0.558981, -0.465908, -0.379135,
  -0.298391, -0.223414, -0.153949, -0.0897523, -0.0305842, 0.0237851,
  0.0735784, 0.119011, 0.160292, 0.197622, 0.231196, 0.261201,
  0.28782, 0.311228, 0.331594, 0.349082, 0.363848, 0.376045, 0.38582,
  0.393312, 0.39866, 0.401992, 0.403436, 0.403111, 0.401136, 0.397622,
  0.392677, 0.386404, 0.378902, 0.370267, 0.36059, 0.349959, 0.338457,
  0.326165, 0.313159, 0.299514, 0.285299, 0.270581, 0.255425, 0.23989,
  0.224037, 0.207919, 0.191589, 0.175098, 0.158492, 0.141817,
  0.125115, 0.108427, 0.0917905, 0.0752415, 0.0588139, 0.0425395,
  0.0264481, 0.0105679, -0.00507506, -0.0204563, -0.0355531,
  -0.0503442, -0.0648101, -0.0789328, -0.0926956, -0.106083,
  -0.119082, -0.131679, -0.143864, -0.155625, -0.166954, -0.177844,
  -0.188286, -0.198276, -0.207809, -0.21688, -0.225487, -0.233628,
  -0.2413, -0.248504, -0.255239, -0.261507, -0.267309, -0.272646,
  -0.277523, -0.281941, -0.285905, -0.28942, -0.292489, -0.295119,
  -0.297315, -0.299083, -0.30043, -0.301362, -0.301888, -0.302013,
  -0.301747, -0.301097, -0.300071, -0.298679, -0.296928, -0.294828,
  -0.292388, -0.289616, -0.286524, -0.283119, -0.279412, -0.275412,
  -0.27113, -0.266574, -0.261755, -0.256683, -0.251368, -0.24582,
  -0.240048, -0.234063, -0.227875, -0.221493, -0.214928, -0.20819,
  -0.201287, -0.19423, -0.187029, -0.179693, -0.172231, -0.164654,
  -0.156969, -0.149188, -0.141317, -0.133367, -0.125347, -0.117264,
  -0.109129, -0.100948, -0.0927304, -0.0844846, -0.0762184,
  -0.0679396, -0.059656, -0.0513752, -0.0431045, -0.0348511,
  -0.0266223, -0.0184248, -0.0102656, -0.00215104, 0.00591232,
  0.0139182, 0.0218606, 0.0297336, 0.0375314, 0.0452484, 0.0528793,
  0.0604189, 0.0678619, 0.0752037, 0.0824394, 0.0895645, 0.0965747,
  0.103466, 0.110234, 0.116874, 0.123384, 0.12976, 0.135998, 0.142095,
  0.148049, 0.153855, 0.159512, 0.165017, 0.170367, 0.175561,
  0.180596, 0.18547, 0.190181, 0.194728, 0.19911, 0.203324, 0.20737,
  0.211246, 0.214952, 0.218487, 0.221849, 0.22504, 0.228057, 0.230901,
  0.233572, 0.23607, 0.238393, 0.240544, 0.242522, 0.244327, 0.245961,
  0.247422, 0.248713, 0.249835, 0.250787, 0.251571, 0.252188, 0.25264,
  0.252927, 0.253052, 0.253014, 0.252817, 0.252461, 0.251948,
  0.251281, 0.25046, 0.249488, 0.248367, 0.247098, 0.245684, 0.244127,
  0.24243, 0.240594, 0.238621, 0.236515, 0.234278, 0.231911, 0.229418,
  0.226801, 0.224062, 0.221205, 0.218232, 0.215145, 0.211948,
  0.208643, 0.205233, 0.20172, 0.198108, 0.194399, 0.190596, 0.186703,
  0.182721, 0.178654, 0.174505, 0.170277, 0.165972, 0.161594,
  0.157145, 0.152629, 0.148049, 0.143407, 0.138706, 0.133949, 0.12914,
  0.124281, 0.119374, 0.114424, 0.109433, 0.104404, 0.0993392,
  0.0942422, 0.0891156, 0.0839622, 0.078785, 0.0735866, 0.0683699,
  0.0631377, 0.0578926, 0.0526375, 0.0473749, 0.0421075, 0.036838,
  0.0315691, 0.0263032, 0.0210429, 0.0157908, 0.0105494, 0.00532104,
  0.000108272, -0.00508655, -0.010261, -0.0154129, -0.0205398,
  -0.0256395, -0.0307098, -0.0357484, -0.0407532, -0.0457222,
  -0.0506532, -0.0555441, -0.0603931, -0.0651981, -0.0699572,
  -0.0746685, -0.0793301, -0.0839404, -0.0884974, -0.0929996,
  -0.0974451, -0.101832, -0.10616, -0.110426, -0.114629, -0.118768,
  -0.122841, -0.126847, -0.130785, -0.134652, -0.138449, -0.142173,
  -0.145824, -0.1494, -0.152901, -0.156324, -0.15967, -0.162938,
  -0.166126, -0.169233, -0.172259, -0.175203, -0.178063, -0.180841,
  -0.183534, -0.186142, -0.188665, -0.191101, -0.193452, -0.195715,
  -0.197891, -0.199978, -0.201978, -0.20389, -0.205712, -0.207446,
  -0.20909, -0.210645, -0.212111, -0.213487, -0.214773, -0.21597,
  -0.217077, -0.218095, -0.219023, -0.219862, -0.220612, -0.221273,
  -0.221845, -0.222329, -0.222724, -0.223032, -0.223252, -0.223385,
  -0.223432, -0.223392, -0.223266, -0.223055, -0.222759, -0.22238,
  -0.221916, -0.22137, -0.220741, -0.220031, -0.219239, -0.218368,
  -0.217416, -0.216386, -0.215279, -0.214093, -0.212832, -0.211495,
  -0.210084, -0.208599, -0.207041, -0.205411, -0.20371, -0.201939,
  -0.2001, -0.198192, -0.196218, -0.194177, -0.192072, -0.189903,
  -0.187672, -0.185379, -0.183025, -0.180612, -0.178141, -0.175613,
  -0.173029, -0.170391, -0.167699, -0.164954, -0.162159, -0.159313,
  -0.156419, -0.153478, -0.15049, -0.147458, -0.144381, -0.141262,
  -0.138103, -0.134903, -0.131664, -0.128388, -0.125077, -0.12173,
  -0.11835, -0.114937, -0.111494, -0.108021, -0.10452, -0.100991,
  -0.0974373, -0.0938588, -0.0902571, -0.0866336, -0.0829895,
  -0.0793261, -0.0756447, -0.0719467, -0.0682332, -0.0645055,
  -0.060765, -0.0570129, -0.0532504, -0.0494789, -0.0456995,
  -0.0419136, -0.0381224, -0.034327, -0.0305288, -0.026729,
  -0.0229287, -0.0191293, -0.0153318, -0.0115375, -0.00774759,
  -0.00396321, -0.000185537, 0.00358427, 0.00734506, 0.0110957,
  0.0148351, 0.0185621, 0.0222755, 0.0259744, 0.0296577, 0.0333241,
  0.0369728, 0.0406026, 0.0442125, 0.0478015, 0.0513686, 0.0549128,
  0.0584331, 0.0619284, 0.065398, 0.0688408, 0.0722558, 0.0756422,
  0.0789991, 0.0823256, 0.0856207, 0.0888837, 0.0921137, 0.0953099,
  0.0984714, 0.101597, 0.104687, 0.10774, 0.110755, 0.113732,
  0.116669, 0.119566, 0.122423, 0.125239, 0.128012, 0.130743, 0.13343,
  0.136074, 0.138673, 0.141228, 0.143736, 0.146199, 0.148615,
  0.150983, 0.153304, 0.155577, 0.157801, 0.159976, 0.162101,
  0.164177, 0.166202, 0.168176, 0.170099, 0.171971, 0.173791,
  0.175559, 0.177274, 0.178937, 0.180546, 0.182103, 0.183605,
  0.185055, 0.18645, 0.187791, 0.189078, 0.19031, 0.191488, 0.192611,
  0.19368, 0.194693, 0.195651, 0.196554, 0.197403, 0.198195, 0.198933,
  0.199616, 0.200243, 0.200815, 0.201332, 0.201794, 0.202201,
  0.202553, 0.20285, 0.203093, 0.20328, 0.203414, 0.203493, 0.203517,
  0.203488, 0.203405, 0.203269, 0.203079, 0.202836, 0.20254, 0.202191,
  0.20179, 0.201337, 0.200832, 0.200276, 0.199668, 0.19901, 0.198301,
  0.197541, 0.196732, 0.195874, 0.194966, 0.19401, 0.193006, 0.191953,
  0.190853, 0.189707, 0.188513, 0.187274, 0.185989, 0.184658,
  0.183283, 0.181864, 0.180401, 0.178895, 0.177347, 0.175756,
  0.174123, 0.172449, 0.170735, 0.168981, 0.167188, 0.165355,
  0.163484, 0.161576, 0.15963, 0.157648, 0.15563, 0.153577, 0.151489,
  0.149367, 0.147212, 0.145023, 0.142803, 0.140551, 0.138268,
  0.135955, 0.133612, 0.13124, 0.12884, 0.126413, 0.123958, 0.121478,
  0.118971, 0.11644, 0.113884, 0.111305, 0.108703, 0.106079, 0.103433,
  0.100767, 0.0980804, 0.0953744, 0.0926498, 0.0899071, 0.0871472,
  0.0843707, 0.0815782, 0.0787706, 0.0759485, 0.0731125, 0.0702635,
  0.0674022, 0.0645291, 0.0616451, 0.0587508, 0.055847, 0.0529343,
  0.0500134, 0.0470851, 0.04415, 0.0412088, 0.0382623, 0.0353111,
  0.0323559, 0.0293974, 0.0264363, 0.0234733, 0.020509, 0.0175442,
  0.0145795, 0.0116156, 0.00865315, 0.00569284, 0.00273533,
  -0.000218714, -0.00316864, -0.0061138, -0.00905352, -0.0119872,
  -0.0149141, -0.0178337, -0.0207453, -0.0236483, -0.026542,
  -0.0294259, -0.0322992, -0.0351615, -0.0380121, -0.0408504,
  -0.0436757, -0.0464876, -0.0492854, -0.0520685, -0.0548364,
  -0.0575885, -0.0603242, -0.063043, -0.0657444, -0.0684277,
  -0.0710924, -0.073738, -0.076364, -0.0789699, -0.0815551,
  -0.0841191, -0.0866615, -0.0891817, -0.0916792, -0.0941536,
  -0.0966044, -0.0990311, -0.101433, -0.10381, -0.106162, -0.108488,
  -0.110787, -0.11306, -0.115306, -0.117524, -0.119714, -0.121876,
  -0.124009, -0.126112, -0.128187, -0.130231, -0.132245, -0.134229,
  -0.136182, -0.138103, -0.139993, -0.141851, -0.143677, -0.14547,
  -0.14723, -0.148958, -0.150652, -0.152312, -0.153938, -0.15553,
  -0.157088, -0.158611, -0.160099, -0.161553, -0.16297, -0.164353,
  -0.165699, -0.16701, -0.168284, -0.169522, -0.170724, -0.171889,
  -0.173017, -0.174109, -0.175163, -0.176181, -0.17716, -0.178103,
  -0.179008, -0.179876, -0.180705, -0.181497, -0.182252, -0.182968,
  -0.183646, -0.184287, -0.184889, -0.185453, -0.185979, -0.186467,
  -0.186917, -0.187329, -0.187703, -0.188038, -0.188336, -0.188595,
  -0.188816, -0.189, -0.189145, -0.189253, -0.189323, -0.189355,
  -0.189349, -0.189306, -0.189226, -0.189108, -0.188953, -0.18876,
  -0.188531, -0.188265, -0.187962, -0.187622, -0.187246, -0.186834,
  -0.186385, -0.185901, -0.18538, -0.184824, -0.184233, -0.183606,
  -0.182945, -0.182248, -0.181517, -0.180752, -0.179952, -0.179118,
  -0.178251, -0.17735, -0.176416, -0.175449, -0.174449, -0.173417,
  -0.172352, -0.171256, -0.170128, -0.168968, -0.167778, -0.166557,
  -0.165305, -0.164023, -0.162711, -0.16137, -0.16, -0.1586,
  -0.157172, -0.155716, -0.154232, -0.15272, -0.151181, -0.149615,
  -0.148023, -0.146404, -0.14476, -0.14309, -0.141395, -0.139675,
  -0.137931, -0.136163, -0.134371, -0.132556, -0.130718, -0.128858,
  -0.126976, -0.125072, -0.123147, -0.121201, -0.119234, -0.117248,
  -0.115242, -0.113216, -0.111172, -0.109109, -0.107029, -0.104931,
  -0.102815, -0.100683, -0.0985346, -0.0963703, -0.0941906,
  -0.0919958, -0.0897864, -0.0875628, -0.0853255, -0.0830749,
  -0.0808115, -0.0785356, -0.0762477, -0.0739482, -0.0716377,
  -0.0693164, -0.066985, -0.0646437, -0.062293, -0.0599335,
  -0.0575655, -0.0551894, -0.0528058, -0.050415, -0.0480174,
  -0.0456137, -0.0432041, -0.0407891, -0.0383692, -0.0359447,
  -0.0335162, -0.0310841, -0.0286488, -0.0262107, -0.0237704,
  -0.0213282, -0.0188845, -0.0164398, -0.0139946, -0.0115492,
  -0.00910411, -0.00665975, -0.00421654, -0.00177491, 0.000664717,
  0.00310191, 0.00553626, 0.00796733, 0.0103947, 0.012818, 0.0152367,
  0.0176506, 0.020059, 0.0224618, 0.0248583, 0.0272483, 0.0296313,
  0.0320069, 0.0343748, 0.0367345, 0.0390857, 0.0414279, 0.0437608,
  0.0460839, 0.048397, 0.0506996, 0.0529913, 0.0552718, 0.0575406,
  0.0597975, 0.0620421, 0.064274, 0.0664928, 0.0686982, 0.0708899,
  0.0730674, 0.0752305, 0.0773788, 0.0795119, 0.0816296, 0.0837315,
  0.0858172, 0.0878865, 0.089939, 0.0919744, 0.0939924, 0.0959927,
  0.097975, 0.0999389, 0.101884, 0.103811, 0.105718, 0.107605,
  0.109473, 0.111321, 0.113149, 0.114956, 0.116742, 0.118507, 0.12025,
  0.121972, 0.123672, 0.12535, 0.127005, 0.128638, 0.130248, 0.131835,
  0.133399, 0.134939, 0.136456, 0.137948, 0.139417, 0.140861, 0.14228,
  0.143675, 0.145045, 0.146389, 0.147709, 0.149003, 0.150271,
  0.151514, 0.15273, 0.153921, 0.155085, 0.156223, 0.157335, 0.158419,
  0.159477, 0.160508, 0.161512, 0.162489, 0.163438, 0.16436, 0.165255,
  0.166122, 0.166961, 0.167772, 0.168556, 0.169311, 0.170039,
  0.170738, 0.17141, 0.172053, 0.172668, 0.173254, 0.173812, 0.174342,
  0.174843, 0.175316, 0.17576, 0.176176, 0.176563, 0.176921, 0.177251,
  0.177552, 0.177825, 0.178069, 0.178284, 0.178471, 0.17863, 0.178759,
  0.178861, 0.178933, 0.178978, 0.178993, 0.178981, 0.17894, 0.178871,
  0.178774, 0.178648, 0.178494, 0.178313, 0.178103, 0.177866, 0.1776,
  0.177307, 0.176987, 0.176638, 0.176263, 0.17586, 0.17543, 0.174972,
  0.174488, 0.173977, 0.173439, 0.172874, 0.172283, 0.171666,
  0.171022, 0.170352, 0.169656, 0.168935, 0.168187, 0.167414,
  0.166616, 0.165793, 0.164945, 0.164071, 0.163174, 0.162251,
  0.161304, 0.160334, 0.159339, 0.15832, 0.157278, 0.156213, 0.155124,
  0.154012, 0.152878, 0.151721, 0.150541, 0.14934, 0.148116, 0.146871,
  0.145604, 0.144316, 0.143007, 0.141677, 0.140327, 0.138956,
  0.137565, 0.136155, 0.134724, 0.133275, 0.131806, 0.130318,
  0.128812, 0.127287, 0.125744, 0.124184, 0.122605, 0.12101, 0.119397,
  0.117768, 0.116122, 0.114459, 0.112781, 0.111087, 0.109378,
  0.107653, 0.105913, 0.104159, 0.102391, 0.100608, 0.0988123,
  0.0970026, 0.0951798, 0.0933441, 0.0914957, 0.0896351, 0.0877625,
  0.0858781, 0.0839823, 0.0820754, 0.0801577, 0.0782294, 0.0762909,
  0.0743425, 0.0723844, 0.070417, 0.0684406, 0.0664555, 0.0644619,
  0.0624603, 0.0604508, 0.0584339, 0.0564097, 0.0543786, 0.052341,
  0.0502971, 0.0482472, 0.0461917, 0.0441308, 0.0420649, 0.0399942,
  0.0379191, 0.0358399, 0.0337568, 0.0316703, 0.0295806, 0.027488,
  0.0253928, 0.0232953, 0.0211958, 0.0190947, 0.0169923, 0.0148888,
  0.0127845, 0.0106799, 0.00857505, 0.00647041, 0.00436624,
  0.00226284, 0.000160525, -0.00194041, -0.00403967, -0.00613696,
  -0.00823196, -0.0103244, -0.012414, -0.0145004, -0.0165833,
  -0.0186625, -0.0207376, -0.0228084, -0.0248746, -0.0269358,
  -0.0289919, -0.0310424, -0.0330872, -0.035126, -0.0371583,
  -0.0391841, -0.041203, -0.0432147, -0.0452189, -0.0472154,
  -0.0492039, -0.0511842, -0.0531559, -0.0551188, -0.0570726,
  -0.059017, -0.0609519, -0.0628769, -0.0647918, -0.0666963,
  -0.0685902, -0.0704732, -0.0723451, -0.0742055, -0.0760544,
  -0.0778913, -0.0797162, -0.0815287, -0.0833285, -0.0851156,
  -0.0868896, -0.0886503, -0.0903974, -0.0921308, -0.0938502,
  -0.0955555, -0.0972463, -0.0989224, -0.100584, -0.10223, -0.103861,
  -0.105476, -0.107076, -0.10866, -0.110228, -0.111779, -0.113314,
  -0.114833, -0.116334, -0.117819, -0.119286, -0.120736, -0.122168,
  -0.123582, -0.124979, -0.126357, -0.127717, -0.129059, -0.130382,
  -0.131686, -0.132971, -0.134237, -0.135484, -0.136712, -0.13792,
  -0.139109, -0.140277, -0.141426, -0.142555, -0.143663, -0.144751,
  -0.145819, -0.146866, -0.147892, -0.148898, -0.149882, -0.150846,
  -0.151788, -0.152709, -0.153609, -0.154488, -0.155345, -0.15618,
  -0.156994, -0.157785, -0.158555, -0.159303, -0.160029, -0.160733,
  -0.161415, -0.162074, -0.162711, -0.163326, -0.163918, -0.164488,
  -0.165036, -0.16556, -0.166063, -0.166542, -0.166999, -0.167433,
  -0.167844, -0.168233, -0.168599, -0.168942, -0.169262, -0.169559,
  -0.169833, -0.170085, -0.170313, -0.170519, -0.170701, -0.170861,
  -0.170998, -0.171112, -0.171203, -0.171271, -0.171317, -0.171339,
  -0.171339, -0.171316, -0.17127, -0.171201, -0.17111, -0.170996,
  -0.17086, -0.170701, -0.170519, -0.170315, -0.170088, -0.169839,
  -0.169568, -0.169275, -0.168959, -0.168621, -0.168261, -0.16788,
  -0.167476, -0.16705, -0.166603, -0.166134, -0.165643, -0.165131,
  -0.164598, -0.164043, -0.163467, -0.16287, -0.162252, -0.161613,
  -0.160953, -0.160272, -0.159571, -0.158849, -0.158107, -0.157345,
  -0.156563, -0.155761, -0.154938, -0.154096, -0.153235, -0.152354,
  -0.151453, -0.150534, -0.149595, -0.148637, -0.147661, -0.146666,
  -0.145652, -0.14462, -0.14357, -0.142502, -0.141416, -0.140313,
  -0.139191, -0.138053, -0.136897, -0.135724, -0.134534, -0.133328,
  -0.132104, -0.130865, -0.129609, -0.128338, -0.12705, -0.125747,
  -0.124428, -0.123094, -0.121745, -0.120381, -0.119002, -0.117609,
  -0.116202, -0.11478, -0.113344, -0.111895, -0.110431, -0.108955,
  -0.107466, -0.105963, -0.104448, -0.10292, -0.10138, -0.0998275,
  -0.0982633, -0.0966874, -0.0950999, -0.0935012, -0.0918914,
  -0.0902708, -0.0886395, -0.0869978, -0.0853459, -0.0836839,
  -0.0820123, -0.080331, -0.0786405, -0.0769408, -0.0752322,
  -0.073515, -0.0717894, -0.0700555, -0.0683137, -0.0665641,
  -0.064807, -0.0630426, -0.0612711, -0.0594927, -0.0577078,
  -0.0559164, -0.054119, -0.0523156, -0.0505065, -0.0486919,
  -0.0468721, -0.0450473, -0.0432178, -0.0413837, -0.0395454,
  -0.037703, -0.0358567, -0.0340069, -0.0321537, -0.0302973,
  -0.0284381, -0.0265762, -0.0247119, -0.0228454, -0.020977,
  -0.0191068, -0.0172351, -0.0153622, -0.0134882, -0.0116135,
  -0.00973821, -0.00786259, -0.00598688, -0.00411131, -0.00223611,
  -0.000361517, 0.00151224, 0.00338494, 0.00525634, 0.00712622,
  0.00899435, 0.0108605, 0.0127244, 0.0145859, 0.0164448, 0.0183007,
  0.0201535, 0.022003, 0.023849, 0.0256911, 0.0275292, 0.0293631,
  0.0311926, 0.0330174, 0.0348372, 0.036652, 0.0384615, 0.0402654,
  0.0420635, 0.0438557, 0.0456417, 0.0474213, 0.0491943, 0.0509604,
  0.0527196, 0.0544715, 0.0562159, 0.0579527, 0.0596817, 0.0614026,
  0.0631152, 0.0648194, 0.0665149, 0.0682015, 0.0698791, 0.0715475,
  0.0732064, 0.0748557, 0.0764951, 0.0781246, 0.0797438, 0.0813526,
  0.0829509, 0.0845384, 0.0861149, 0.0876803, 0.0892345, 0.0907771,
  0.0923081, 0.0938272, 0.0953344, 0.0968293, 0.098312, 0.0997821,
  0.10124, 0.102684, 0.104116, 0.105534, 0.106939, 0.108331, 0.109709,
  0.111073, 0.112423, 0.113759, 0.115081, 0.116389, 0.117682, 0.11896,
  0.120224, 0.121472, 0.122706, 0.123924, 0.125127, 0.126314,
  0.127486, 0.128642, 0.129783, 0.130907, 0.132015, 0.133107,
  0.134182, 0.135241, 0.136284, 0.13731, 0.138319, 0.139311, 0.140286,
  0.141244, 0.142185, 0.143109, 0.144015, 0.144904, 0.145775,
  0.146628, 0.147464, 0.148282, 0.149082, 0.149864, 0.150628,
  0.151374, 0.152102, 0.152811, 0.153502, 0.154174, 0.154828,
  0.155464, 0.156081, 0.156679, 0.157259, 0.157819, 0.158361,
  0.158884, 0.159388, 0.159873, 0.16034, 0.160787, 0.161215, 0.161624,
  0.162013, 0.162384, 0.162735, 0.163067, 0.16338, 0.163674, 0.163948,
  0.164203, 0.164439, 0.164655, 0.164852, 0.16503, 0.165188, 0.165327,
  0.165446, 0.165546, 0.165627, 0.165689, 0.165731, 0.165753,
  0.165757, 0.165741, 0.165706, 0.165651, 0.165578, 0.165485,
  0.165372, 0.165241, 0.165091, 0.164921, 0.164732, 0.164525,
  0.164298, 0.164052, 0.163788, 0.163504, 0.163202, 0.162881,
  0.162541, 0.162182, 0.161805, 0.161409, 0.160995, 0.160563,
  0.160112, 0.159642, 0.159155, 0.158649, 0.158125, 0.157583,
  0.157023, 0.156446, 0.15585, 0.155237, 0.154606, 0.153958, 0.153292,
  0.152609, 0.151908, 0.151191, 0.150456, 0.149704, 0.148936, 0.14815,
  0.147348, 0.146529, 0.145694, 0.144843, 0.143975, 0.143091,
  0.142191, 0.141275, 0.140343, 0.139395, 0.138432, 0.137454, 0.13646,
  0.135451, 0.134427, 0.133388, 0.132334, 0.131266, 0.130182,
  0.129085, 0.127973, 0.126847, 0.125707, 0.124553, 0.123385,
  0.122204, 0.121009, 0.119801, 0.11858, 0.117346, 0.116099, 0.114839,
  0.113567, 0.112282, 0.110985, 0.109676, 0.108355, 0.107022,
  0.105677, 0.104321, 0.102954, 0.101575, 0.100186, 0.0987857,
  0.0973748, 0.0959534, 0.0945216, 0.0930797, 0.0916278, 0.0901661,
  0.0886947, 0.0872139, 0.0857237, 0.0842245, 0.0827162, 0.0811992,
  0.0796736, 0.0781395, 0.0765972, 0.0750469, 0.0734886, 0.0719226,
  0.0703491, 0.0687682, 0.0671802, 0.0655851, 0.0639833, 0.0623748,
  0.0607599, 0.0591388, 0.0575115, 0.0558784, 0.0542396, 0.0525953,
  0.0509456, 0.0492909, 0.0476311, 0.0459666, 0.0442975, 0.0426241,
  0.0409464, 0.0392647, 0.0375792, 0.0358901, 0.0341976, 0.0325018,
  0.0308029, 0.0291012, 0.0273967, 0.0256898, 0.0239806, 0.0222693,
  0.0205561, 0.0188412, 0.0171247, 0.0154068, 0.0136879, 0.0119679,
  0.0102472, 0.00852592, 0.00680423, 0.00508235, 0.00336045,
  0.00163874, -8.26049e-05, -0.00180339, -0.00352343, -0.00524253,
  -0.0069605, -0.00867717, -0.0103923, -0.0121058, -0.0138174,
  -0.0155269, -0.0172342, -0.018939, -0.0206412, -0.0223406,
  -0.0240371, -0.0257303, -0.0274202, -0.0291065, -0.0307891,
  -0.0324678, -0.0341424, -0.0358127, -0.0374786, -0.0391399,
  -0.0407963, -0.0424478, -0.0440941, -0.045735, -0.0473704,
  -0.0490002, -0.050624, -0.0522419, -0.0538535, -0.0554587,
  -0.0570573, -0.0586493, -0.0602343, -0.0618123, -0.063383,
  -0.0649464, -0.0665021, -0.0680502, -0.0695903, -0.0711224,
  -0.0726462, -0.0741617, -0.0756687, -0.0771669, -0.0786563,
  -0.0801367, -0.0816079, -0.0830698, -0.0845222, -0.0859649,
  -0.0873979, -0.088821, -0.090234, -0.0916368, -0.0930292,
  -0.0944111, -0.0957823, -0.0971428, -0.0984923, -0.0998307,
  -0.101158, -0.102474, -0.103778, -0.105071, -0.106352, -0.107621,
  -0.108878, -0.110123, -0.111355, -0.112576, -0.113783, -0.114978,
  -0.116161, -0.11733, -0.118487, -0.11963, -0.12076, -0.121877,
  -0.12298, -0.124069, -0.125145, -0.126208, -0.127256, -0.12829,
  -0.12931, -0.130316, -0.131308, -0.132285, -0.133248, -0.134196,
  -0.135129, -0.136048, -0.136951, -0.13784, -0.138714, -0.139573,
  -0.140416, -0.141244, -0.142057, -0.142854, -0.143636, -0.144402,
  -0.145152, -0.145887, -0.146605, -0.147308, -0.147995, -0.148666,
  -0.149321, -0.14996, -0.150582, -0.151188, -0.151778, -0.152352,
  -0.152909, -0.153449, -0.153973, -0.154481, -0.154972, -0.155446,
  -0.155904, -0.156344, -0.156768, -0.157175, -0.157566, -0.157939,
  -0.158296, -0.158635, -0.158958, -0.159263, -0.159552, -0.159824,
  -0.160078, -0.160315, -0.160536, -0.160739, -0.160925, -0.161094,
  -0.161246, -0.16138, -0.161498, -0.161598, -0.161681, -0.161747,
  -0.161796, -0.161828, -0.161842, -0.16184, -0.16182, -0.161783,
  -0.161729, -0.161658, -0.16157, -0.161465, -0.161343, -0.161203,
  -0.161047, -0.160874, -0.160684, -0.160477, -0.160253, -0.160012,
  -0.159754, -0.15948, -0.159189, -0.158881, -0.158556, -0.158215,
  -0.157857, -0.157483, -0.157092, -0.156685, -0.156262, -0.155822,
  -0.155365, -0.154893, -0.154404, -0.1539, -0.153379, -0.152842,
  -0.15229, -0.151721, -0.151137, -0.150537, -0.149921, -0.14929,
  -0.148643, -0.147981, -0.147303, -0.146611, -0.145903, -0.14518,
  -0.144441, -0.143688, -0.14292, -0.142138, -0.14134, -0.140528,
  -0.139702, -0.138861, -0.138006, -0.137136, -0.136253, -0.135355,
  -0.134444, -0.133518, -0.132579, -0.131627, -0.130661, -0.129681,
  -0.128688, -0.127682, -0.126663, -0.125631, -0.124586, -0.123528,
  -0.122458, -0.121375, -0.12028, -0.119173, -0.118053, -0.116922,
  -0.115778, -0.114623, -0.113456, -0.112278, -0.111088, -0.109887,
  -0.108674, -0.107451, -0.106217, -0.104972, -0.103717, -0.102451,
  -0.101174, -0.0998878, -0.0985913, -0.0972848, -0.0959685,
  -0.0946425, -0.0933071, -0.0919623, -0.0906082, -0.0892451,
  -0.0878731, -0.0864923, -0.0851028, -0.0837048, -0.0822985,
  -0.080884, -0.0794614, -0.0780309, -0.0765927, -0.0751469,
  -0.0736937, -0.0722331, -0.0707654, -0.0692907, -0.0678092,
  -0.066321, -0.0648263, -0.0633253, -0.061818, -0.0603047,
  -0.0587855, -0.0572605, -0.05573, -0.0541941, -0.0526529,
  -0.0511066, -0.0495554, -0.0479995, -0.0464389, -0.0448738,
  -0.0433045, -0.0417311, -0.0401537, -0.0385725, -0.0369876,
  -0.0353993, -0.0338077, -0.0322129, -0.0306152, -0.0290147,
  -0.0274115, -0.0258058, -0.0241978, -0.0225877, -0.0209756,
  -0.0193616, -0.017746, -0.0161289, -0.0145105, -0.0128909,
  -0.0112704, -0.00964897, -0.00802692, -0.00640437, -0.00478149,
  -0.00315845, -0.00153541, 8.74621e-05, 0.00171, 0.00333204,
  0.00495342, 0.00657398, 0.00819354, 0.00981194, 0.011429, 0.0130446,
  0.0146586, 0.0162707, 0.0178809, 0.0194889, 0.0210946, 0.0226979,
  0.0242985, 0.0258963, 0.0274912, 0.029083, 0.0306715, 0.0322566,
  0.0338381, 0.0354159, 0.0369897, 0.0385595, 0.040125, 0.0416862,
  0.0432428, 0.0447948, 0.0463419, 0.047884, 0.0494209, 0.0509525,
  0.0524787, 0.0539992, 0.055514, 0.0570228, 0.0585256, 0.0600222,
  0.0615124, 0.062996, 0.064473, 0.0659432, 0.0674065, 0.0688626,
  0.0703115, 0.071753, 0.073187, 0.0746132, 0.0760317, 0.0774422,
  0.0788446, 0.0802388, 0.0816246, 0.0830019, 0.0843705, 0.0857304,
  0.0870813, 0.0884232, 0.0897559, 0.0910793, 0.0923933, 0.0936977,
  0.0949924, 0.0962772, 0.0975522, 0.098817, 0.100072, 0.101316,
  0.10255, 0.103773, 0.104986, 0.106188, 0.107378, 0.108558, 0.109727,
  0.110884, 0.112031, 0.113165, 0.114288, 0.115399, 0.116499,
  0.117586, 0.118662, 0.119725, 0.120777, 0.121815, 0.122842,
  0.123856, 0.124857, 0.125845, 0.126821, 0.127784, 0.128734, 0.12967,
  0.130594, 0.131504, 0.132401, 0.133284, 0.134154, 0.135011,
  0.135853, 0.136682, 0.137497, 0.138298, 0.139085, 0.139858,
  0.140617, 0.141361, 0.142092, 0.142807, 0.143509, 0.144196,
  0.144868, 0.145526, 0.146169, 0.146798, 0.147411, 0.14801, 0.148594,
  0.149163, 0.149717, 0.150255, 0.150779, 0.151288, 0.151781,
  0.152259, 0.152722, 0.153169, 0.153601, 0.154018, 0.154419,
  0.154805, 0.155175, 0.15553, 0.155869, 0.156192, 0.1565, 0.156792,
  0.157069, 0.157329, 0.157574, 0.157804, 0.158017, 0.158215,
  0.158397, 0.158563, 0.158713, 0.158847, 0.158966, 0.159069,
  0.159156, 0.159227, 0.159282, 0.159321, 0.159344, 0.159352,
  0.159344, 0.159319, 0.159279, 0.159224, 0.159152, 0.159064,
  0.158961, 0.158842, 0.158707, 0.158557, 0.15839, 0.158208, 0.158011,
  0.157797, 0.157568, 0.157323, 0.157063, 0.156787, 0.156496,
  0.156189, 0.155867, 0.155529, 0.155176, 0.154808, 0.154424,
  0.154025, 0.153611, 0.153182, 0.152737, 0.152278, 0.151803,
  0.151313, 0.150809, 0.15029, 0.149755, 0.149207, 0.148643, 0.148065,
  0.147472, 0.146864, 0.146243, 0.145606, 0.144956, 0.144291,
  0.143612, 0.142919, 0.142212, 0.141491, 0.140756, 0.140007,
  0.139245, 0.138469, 0.137679, 0.136876, 0.136059, 0.135229,
  0.134386, 0.133529, 0.13266, 0.131777, 0.130882, 0.129974, 0.129053,
  0.128119, 0.127173, 0.126215, 0.125244, 0.124261, 0.123266,
  0.122259, 0.12124, 0.120209, 0.119166, 0.118112, 0.117046, 0.115969,
  0.114881, 0.113781, 0.112671, 0.111549, 0.110416, 0.109273,
  0.108119, 0.106955, 0.10578, 0.104595, 0.1034, 0.102195, 0.10098,
  0.0997549, 0.0985204, 0.0972763, 0.0960228, 0.09476, 0.093488,
  0.092207, 0.0909171, 0.0896184, 0.088311, 0.0869951, 0.0856708,
  0.0843383, 0.0829976, 0.0816489, 0.0802924, 0.0789281, 0.0775562,
  0.0761769, 0.0747903, 0.0733964, 0.0719956, 0.0705878, 0.0691732,
  0.067752, 0.0663244, 0.0648904, 0.0634501, 0.0620039, 0.0605516,
  0.0590937, 0.05763, 0.0561609, 0.0546865, 0.0532068, 0.0517221,
  0.0502325, 0.0487381, 0.0472391, 0.0457357, 0.0442279, 0.0427159,
  0.0412, 0.0396801, 0.0381565, 0.0366294, 0.0350988, 0.033565,
  0.032028, 0.030488, 0.0289452, 0.0273998, 0.0258518, 0.0243014,
  0.0227489, 0.0211942, 0.0196377, 0.0180794, 0.0165194, 0.014958,
  0.0133953, 0.0118315, 0.0102666, 0.00870093, 0.00713453, 0.00556759,
  0.00400025, 0.00243268, 0.000865016, -0.00070258, -0.00226996,
  -0.00383696, -0.00540344, -0.00696925, -0.00853423, -0.0100982,
  -0.0116611, -0.0132227, -0.0147828, -0.0163414, -0.0178982,
  -0.0194531, -0.021006, -0.0225567, -0.0241051, -0.0256509,
  -0.0271942, -0.0287346, -0.0302721, -0.0318065, -0.0333377,
  -0.0348655, -0.0363897, -0.0379103, -0.0394271, -0.0409398,
  -0.0424485, -0.0439529, -0.0454529, -0.0469483, -0.048439,
  -0.0499249, -0.0514058, -0.0528815, -0.054352, -0.0558171,
  -0.0572766, -0.0587305, -0.0601784, -0.0616205, -0.0630564,
  -0.064486, -0.0659093, -0.067326, -0.0687361, -0.0701393,
  -0.0715357, -0.0729249, -0.074307, -0.0756817, -0.077049,
  -0.0784087, -0.0797606, -0.0811047, -0.0824408, -0.0837688,
  -0.0850885, -0.0863999, -0.0877028, -0.088997, -0.0902825,
  -0.0915592, -0.0928269, -0.0940854, -0.0953347, -0.0965747,
  -0.0978052, -0.0990261, -0.100237, -0.101439, -0.10263, -0.103812,
  -0.104983, -0.106144, -0.107294, -0.108435, -0.109564, -0.110683,
  -0.111791, -0.112888, -0.113974, -0.115049, -0.116113, -0.117165,
  -0.118206, -0.119235, -0.120253, -0.121259, -0.122253, -0.123236,
  -0.124206, -0.125164, -0.12611, -0.127044, -0.127965, -0.128874,
  -0.12977, -0.130654, -0.131525, -0.132383, -0.133229, -0.134061,
  -0.13488, -0.135687, -0.13648, -0.137259, -0.138026, -0.138779,
  -0.139519, -0.140245, -0.140957, -0.141656, -0.142341, -0.143012,
  -0.143669, -0.144312, -0.144942, -0.145557, -0.146158, -0.146745,
  -0.147318, -0.147876, -0.14842, -0.14895, -0.149466, -0.149966,
  -0.150453, -0.150924, -0.151382, -0.151824, -0.152252, -0.152665,
  -0.153063, -0.153446, -0.153815, -0.154169, -0.154508, -0.154831,
  -0.15514, -0.155434, -0.155713, -0.155977, -0.156225, -0.156459,
  -0.156677, -0.156881, -0.157069, -0.157242, -0.1574, -0.157542,
  -0.157669, -0.157782, -0.157878, -0.15796, -0.158026, -0.158078,
  -0.158113, -0.158134, -0.158139, -0.158129, -0.158104, -0.158064,
  -0.158008, -0.157937, -0.157851, -0.15775, -0.157633, -0.157501,
  -0.157354, -0.157192, -0.157015, -0.156822, -0.156614, -0.156392,
  -0.156154, -0.155901, -0.155633, -0.15535, -0.155053, -0.15474,
  -0.154412, -0.15407, -0.153712, -0.15334, -0.152953, -0.152551,
  -0.152135, -0.151704, -0.151258, -0.150798, -0.150323, -0.149834,
  -0.149331, -0.148813, -0.14828, -0.147734, -0.147173, -0.146598,
  -0.146009, -0.145406, -0.144789, -0.144158, -0.143513, -0.142854,
  -0.142182, -0.141496, -0.140796, -0.140083, -0.139356, -0.138616,
  -0.137862, -0.137096, -0.136316, -0.135523, -0.134717, -0.133898,
  -0.133066, -0.132221, -0.131364, -0.130494, -0.129611, -0.128717,
  -0.127809, -0.12689, -0.125958, -0.125014, -0.124058, -0.12309,
  -0.122111, -0.121119, -0.120116, -0.119102, -0.118076, -0.117038,
  -0.11599, -0.11493, -0.113859, -0.112778, -0.111685, -0.110582,
  -0.109468, -0.108344, -0.107209, -0.106064, -0.104909, -0.103743,
  -0.102568, -0.101383, -0.100188, -0.0989838, -0.0977698, -0.0965465,
  -0.0953139, -0.0940722, -0.0928214, -0.0915618, -0.0902933,
  -0.0890162, -0.0877305, -0.0864365, -0.0851341, -0.0838236,
  -0.082505, -0.0811785, -0.0798442, -0.0785023, -0.0771528,
  -0.0757959, -0.0744318, -0.0730605, -0.0716822, -0.0702971,
  -0.0689052, -0.0675066, -0.0661017, -0.0646903, -0.0632728,
  -0.0618492, -0.0604197, -0.0589843, -0.0575434, -0.0560969,
  -0.054645, -0.0531879, -0.0517257, -0.0502585, -0.0487865,
  -0.0473098, -0.0458286, -0.044343, -0.0428532, -0.0413592,
  -0.0398613, -0.0383595, -0.0368541, -0.0353451, -0.0338328,
  -0.0323172, -0.0307985, -0.0292769, -0.0277524, -0.0262253,
  -0.0246957, -0.0231637, -0.0216295, -0.0200932, -0.018555,
  -0.017015, -0.0154734, -0.0139302, -0.0123858, -0.0108402,
  -0.00929351, -0.00774596, -0.00619766, -0.00464876, -0.00309942,
  -0.00154979, 0, 0.00154979, 0.00309942, 0.00464876, 0.00619766,
  0.00774596, 0.00929351, 0.0108402, 0.0123858, 0.0139302, 0.0154734,
  0.017015, 0.018555, 0.0200932, 0.0216295, 0.0231637, 0.0246957,
  0.0262253, 0.0277524, 0.0292769, 0.0307985, 0.0323172, 0.0338328,
  0.0353451, 0.0368541, 0.0383595, 0.0398613, 0.0413592, 0.0428532,
  0.044343, 0.0458286, 0.0473098, 0.0487865, 0.0502585, 0.0517257,
  0.0531879, 0.054645, 0.0560969, 0.0575434, 0.0589843, 0.0604197,
  0.0618492, 0.0632728, 0.0646903, 0.0661017, 0.0675066, 0.0689052,
  0.0702971, 0.0716822, 0.0730605, 0.0744318, 0.0757959, 0.0771528,
  0.0785023, 0.0798442, 0.0811785, 0.082505, 0.0838236, 0.0851341,
  0.0864365, 0.0877305, 0.0890162, 0.0902933, 0.0915618, 0.0928214,
  0.0940722, 0.0953139, 0.0965465, 0.0977698, 0.0989838, 0.100188,
  0.101383, 0.102568, 0.103743, 0.104909, 0.106064, 0.107209,
  0.108344, 0.109468, 0.110582, 0.111685, 0.112778, 0.113859, 0.11493,
  0.11599, 0.117038, 0.118076, 0.119102, 0.120116, 0.121119, 0.122111,
  0.12309, 0.124058, 0.125014, 0.125958, 0.12689, 0.127809, 0.128717,
  0.129611, 0.130494, 0.131364, 0.132221, 0.133066, 0.133898,
  0.134717, 0.135523, 0.136316, 0.137096, 0.137862, 0.138616,
  0.139356, 0.140083, 0.140796, 0.141496, 0.142182, 0.142854,
  0.143513, 0.144158, 0.144789, 0.145406, 0.146009, 0.146598,
  0.147173, 0.147734, 0.14828, 0.148813, 0.149331, 0.149834, 0.150323,
  0.150798, 0.151258, 0.151704, 0.152135, 0.152551, 0.152953, 0.15334,
  0.153712, 0.15407, 0.154412, 0.15474, 0.155053, 0.15535, 0.155633,
  0.155901, 0.156154, 0.156392, 0.156614, 0.156822, 0.157015,
  0.157192, 0.157354, 0.157501, 0.157633, 0.15775, 0.157851, 0.157937,
  0.158008, 0.158064, 0.158104, 0.158129, 0.158139, 0.158134,
  0.158113, 0.158078, 0.158026, 0.15796, 0.157878, 0.157782, 0.157669,
  0.157542, 0.1574, 0.157242, 0.157069, 0.156881, 0.156677, 0.156459,
  0.156225, 0.155977, 0.155713, 0.155434, 0.15514, 0.154831, 0.154508,
  0.154169, 0.153815, 0.153446, 0.153063, 0.152665, 0.152252,
  0.151824, 0.151382, 0.150924, 0.150453, 0.149966, 0.149466, 0.14895,
  0.14842, 0.147876, 0.147318, 0.146745, 0.146158, 0.145557, 0.144942,
  0.144312, 0.143669, 0.143012, 0.142341, 0.141656, 0.140957,
  0.140245, 0.139519, 0.138779, 0.138026, 0.137259, 0.13648, 0.135687,
  0.13488, 0.134061, 0.133229, 0.132383, 0.131525, 0.130654, 0.12977,
  0.128874, 0.127965, 0.127044, 0.12611, 0.125164, 0.124206, 0.123236,
  0.122253, 0.121259, 0.120253, 0.119235, 0.118206, 0.117165,
  0.116113, 0.115049, 0.113974, 0.112888, 0.111791, 0.110683,
  0.109564, 0.108435, 0.107294, 0.106144, 0.104983, 0.103812, 0.10263,
  0.101439, 0.100237, 0.0990261, 0.0978052, 0.0965747, 0.0953347,
  0.0940854, 0.0928269, 0.0915592, 0.0902825, 0.088997, 0.0877028,
  0.0863999, 0.0850885, 0.0837688, 0.0824408, 0.0811047, 0.0797606,
  0.0784087, 0.077049, 0.0756817, 0.074307, 0.0729249, 0.0715357,
  0.0701393, 0.0687361, 0.067326, 0.0659093, 0.064486, 0.0630564,
  0.0616205, 0.0601784, 0.0587305, 0.0572766, 0.0558171, 0.054352,
  0.0528815, 0.0514058, 0.0499249, 0.048439, 0.0469483, 0.0454529,
  0.0439529, 0.0424485, 0.0409398, 0.0394271, 0.0379103, 0.0363897,
  0.0348655, 0.0333377, 0.0318065, 0.0302721, 0.0287346, 0.0271942,
  0.0256509, 0.0241051, 0.0225567, 0.021006, 0.0194531, 0.0178982,
  0.0163414, 0.0147828, 0.0132227, 0.0116611, 0.0100982, 0.00853423,
  0.00696925, 0.00540344, 0.00383696, 0.00226996, 0.00070258,
  -0.000865016, -0.00243268, -0.00400025, -0.00556759, -0.00713453,
  -0.00870093, -0.0102666, -0.0118315, -0.0133953, -0.014958,
  -0.0165194, -0.0180794, -0.0196377, -0.0211942, -0.0227489,
  -0.0243014, -0.0258518, -0.0273998, -0.0289452, -0.030488,
  -0.032028, -0.033565, -0.0350988, -0.0366294, -0.0381565,
  -0.0396801, -0.0412, -0.0427159, -0.0442279, -0.0457357, -0.0472391,
  -0.0487381, -0.0502325, -0.0517221, -0.0532068, -0.0546865,
  -0.0561609, -0.05763, -0.0590937, -0.0605516, -0.0620039,
  -0.0634501, -0.0648904, -0.0663244, -0.067752, -0.0691732,
  -0.0705878, -0.0719956, -0.0733964, -0.0747903, -0.0761769,
  -0.0775562, -0.0789281, -0.0802924, -0.0816489, -0.0829976,
  -0.0843383, -0.0856708, -0.0869951, -0.088311, -0.0896184,
  -0.0909171, -0.092207, -0.093488, -0.09476, -0.0960228, -0.0972763,
  -0.0985204, -0.0997549, -0.10098, -0.102195, -0.1034, -0.104595,
  -0.10578, -0.106955, -0.108119, -0.109273, -0.110416, -0.111549,
  -0.112671, -0.113781, -0.114881, -0.115969, -0.117046, -0.118112,
  -0.119166, -0.120209, -0.12124, -0.122259, -0.123266, -0.124261,
  -0.125244, -0.126215, -0.127173, -0.128119, -0.129053, -0.129974,
  -0.130882, -0.131777, -0.13266, -0.133529, -0.134386, -0.135229,
  -0.136059, -0.136876, -0.137679, -0.138469, -0.139245, -0.140007,
  -0.140756, -0.141491, -0.142212, -0.142919, -0.143612, -0.144291,
  -0.144956, -0.145606, -0.146243, -0.146864, -0.147472, -0.148065,
  -0.148643, -0.149207, -0.149755, -0.15029, -0.150809, -0.151313,
  -0.151803, -0.152278, -0.152737, -0.153182, -0.153611, -0.154025,
  -0.154424, -0.154808, -0.155176, -0.155529, -0.155867, -0.156189,
  -0.156496, -0.156787, -0.157063, -0.157323, -0.157568, -0.157797,
  -0.158011, -0.158208, -0.15839, -0.158557, -0.158707, -0.158842,
  -0.158961, -0.159064, -0.159152, -0.159224, -0.159279, -0.159319,
  -0.159344, -0.159352, -0.159344, -0.159321, -0.159282, -0.159227,
  -0.159156, -0.159069, -0.158966, -0.158847, -0.158713, -0.158563,
  -0.158397, -0.158215, -0.158017, -0.157804, -0.157574, -0.157329,
  -0.157069, -0.156792, -0.1565, -0.156192, -0.155869, -0.15553,
  -0.155175, -0.154805, -0.154419, -0.154018, -0.153601, -0.153169,
  -0.152722, -0.152259, -0.151781, -0.151288, -0.150779, -0.150255,
  -0.149717, -0.149163, -0.148594, -0.14801, -0.147411, -0.146798,
  -0.146169, -0.145526, -0.144868, -0.144196, -0.143509, -0.142807,
  -0.142092, -0.141361, -0.140617, -0.139858, -0.139085, -0.138298,
  -0.137497, -0.136682, -0.135853, -0.135011, -0.134154, -0.133284,
  -0.132401, -0.131504, -0.130594, -0.12967, -0.128734, -0.127784,
  -0.126821, -0.125845, -0.124857, -0.123856, -0.122842, -0.121815,
  -0.120777, -0.119725, -0.118662, -0.117586, -0.116499, -0.115399,
  -0.114288, -0.113165, -0.112031, -0.110884, -0.109727, -0.108558,
  -0.107378, -0.106188, -0.104986, -0.103773, -0.10255, -0.101316,
  -0.100072, -0.098817, -0.0975522, -0.0962772, -0.0949924,
  -0.0936977, -0.0923933, -0.0910793, -0.0897559, -0.0884232,
  -0.0870813, -0.0857304, -0.0843705, -0.0830019, -0.0816246,
  -0.0802388, -0.0788446, -0.0774422, -0.0760317, -0.0746132,
  -0.073187, -0.071753, -0.0703115, -0.0688626, -0.0674065,
  -0.0659432, -0.064473, -0.062996, -0.0615124, -0.0600222,
  -0.0585256, -0.0570228, -0.055514, -0.0539992, -0.0524787,
  -0.0509525, -0.0494209, -0.047884, -0.0463419, -0.0447948,
  -0.0432428, -0.0416862, -0.040125, -0.0385595, -0.0369897,
  -0.0354159, -0.0338381, -0.0322566, -0.0306715, -0.029083,
  -0.0274912, -0.0258963, -0.0242985, -0.0226979, -0.0210946,
  -0.0194889, -0.0178809, -0.0162707, -0.0146586, -0.0130446,
  -0.011429, -0.00981194, -0.00819354, -0.00657398, -0.00495342,
  -0.00333204, -0.00171, -8.74621e-05, 0.00153541, 0.00315845,
  0.00478149, 0.00640437, 0.00802692, 0.00964897, 0.0112704,
  0.0128909, 0.0145105, 0.0161289, 0.017746, 0.0193616, 0.0209756,
  0.0225877, 0.0241978, 0.0258058, 0.0274115, 0.0290147, 0.0306152,
  0.0322129, 0.0338077, 0.0353993, 0.0369876, 0.0385725, 0.0401537,
  0.0417311, 0.0433045, 0.0448738, 0.0464389, 0.0479995, 0.0495554,
  0.0511066, 0.0526529, 0.0541941, 0.05573, 0.0572605, 0.0587855,
  0.0603047, 0.061818, 0.0633253, 0.0648263, 0.066321, 0.0678092,
  0.0692907, 0.0707654, 0.0722331, 0.0736937, 0.0751469, 0.0765927,
  0.0780309, 0.0794614, 0.080884, 0.0822985, 0.0837048, 0.0851028,
  0.0864923, 0.0878731, 0.0892451, 0.0906082, 0.0919623, 0.0933071,
  0.0946425, 0.0959685, 0.0972848, 0.0985913, 0.0998878, 0.101174,
  0.102451, 0.103717, 0.104972, 0.106217, 0.107451, 0.108674,
  0.109887, 0.111088, 0.112278, 0.113456, 0.114623, 0.115778,
  0.116922, 0.118053, 0.119173, 0.12028, 0.121375, 0.122458, 0.123528,
  0.124586, 0.125631, 0.126663, 0.127682, 0.128688, 0.129681,
  0.130661, 0.131627, 0.132579, 0.133518, 0.134444, 0.135355,
  0.136253, 0.137136, 0.138006, 0.138861, 0.139702, 0.140528, 0.14134,
  0.142138, 0.14292, 0.143688, 0.144441, 0.14518, 0.145903, 0.146611,
  0.147303, 0.147981, 0.148643, 0.14929, 0.149921, 0.150537, 0.151137,
  0.151721, 0.15229, 0.152842, 0.153379, 0.1539, 0.154404, 0.154893,
  0.155365, 0.155822, 0.156262, 0.156685, 0.157092, 0.157483,
  0.157857, 0.158215, 0.158556, 0.158881, 0.159189, 0.15948, 0.159754,
  0.160012, 0.160253, 0.160477, 0.160684, 0.160874, 0.161047,
  0.161203, 0.161343, 0.161465, 0.16157, 0.161658, 0.161729, 0.161783,
  0.16182, 0.16184, 0.161842, 0.161828, 0.161796, 0.161747, 0.161681,
  0.161598, 0.161498, 0.16138, 0.161246, 0.161094, 0.160925, 0.160739,
  0.160536, 0.160315, 0.160078, 0.159824, 0.159552, 0.159263,
  0.158958, 0.158635, 0.158296, 0.157939, 0.157566, 0.157175,
  0.156768, 0.156344, 0.155904, 0.155446, 0.154972, 0.154481,
  0.153973, 0.153449, 0.152909, 0.152352, 0.151778, 0.151188,
  0.150582, 0.14996, 0.149321, 0.148666, 0.147995, 0.147308, 0.146605,
  0.145887, 0.145152, 0.144402, 0.143636, 0.142854, 0.142057,
  0.141244, 0.140416, 0.139573, 0.138714, 0.13784, 0.136951, 0.136048,
  0.135129, 0.134196, 0.133248, 0.132285, 0.131308, 0.130316, 0.12931,
  0.12829, 0.127256, 0.126208, 0.125145, 0.124069, 0.12298, 0.121877,
  0.12076, 0.11963, 0.118487, 0.11733, 0.116161, 0.114978, 0.113783,
  0.112576, 0.111355, 0.110123, 0.108878, 0.107621, 0.106352,
  0.105071, 0.103778, 0.102474, 0.101158, 0.0998307, 0.0984923,
  0.0971428, 0.0957823, 0.0944111, 0.0930292, 0.0916368, 0.090234,
  0.088821, 0.0873979, 0.0859649, 0.0845222, 0.0830698, 0.0816079,
  0.0801367, 0.0786563, 0.0771669, 0.0756687, 0.0741617, 0.0726462,
  0.0711224, 0.0695903, 0.0680502, 0.0665021, 0.0649464, 0.063383,
  0.0618123, 0.0602343, 0.0586493, 0.0570573, 0.0554587, 0.0538535,
  0.0522419, 0.050624, 0.0490002, 0.0473704, 0.045735, 0.0440941,
  0.0424478, 0.0407963, 0.0391399, 0.0374786, 0.0358127, 0.0341424,
  0.0324678, 0.0307891, 0.0291065, 0.0274202, 0.0257303, 0.0240371,
  0.0223406, 0.0206412, 0.018939, 0.0172342, 0.0155269, 0.0138174,
  0.0121058, 0.0103923, 0.00867717, 0.0069605, 0.00524253, 0.00352343,
  0.00180339, 8.26049e-05, -0.00163874, -0.00336045, -0.00508235,
  -0.00680423, -0.00852592, -0.0102472, -0.0119679, -0.0136879,
  -0.0154068, -0.0171247, -0.0188412, -0.0205561, -0.0222693,
  -0.0239806, -0.0256898, -0.0273967, -0.0291012, -0.0308029,
  -0.0325018, -0.0341976, -0.0358901, -0.0375792, -0.0392647,
  -0.0409464, -0.0426241, -0.0442975, -0.0459666, -0.0476311,
  -0.0492909, -0.0509456, -0.0525953, -0.0542396, -0.0558784,
  -0.0575115, -0.0591388, -0.0607599, -0.0623748, -0.0639833,
  -0.0655851, -0.0671802, -0.0687682, -0.0703491, -0.0719226,
  -0.0734886, -0.0750469, -0.0765972, -0.0781395, -0.0796736,
  -0.0811992, -0.0827162, -0.0842245, -0.0857237, -0.0872139,
  -0.0886947, -0.0901661, -0.0916278, -0.0930797, -0.0945216,
  -0.0959534, -0.0973748, -0.0987857, -0.100186, -0.101575, -0.102954,
  -0.104321, -0.105677, -0.107022, -0.108355, -0.109676, -0.110985,
  -0.112282, -0.113567, -0.114839, -0.116099, -0.117346, -0.11858,
  -0.119801, -0.121009, -0.122204, -0.123385, -0.124553, -0.125707,
  -0.126847, -0.127973, -0.129085, -0.130182, -0.131266, -0.132334,
  -0.133388, -0.134427, -0.135451, -0.13646, -0.137454, -0.138432,
  -0.139395, -0.140343, -0.141275, -0.142191, -0.143091, -0.143975,
  -0.144843, -0.145694, -0.146529, -0.147348, -0.14815, -0.148936,
  -0.149704, -0.150456, -0.151191, -0.151908, -0.152609, -0.153292,
  -0.153958, -0.154606, -0.155237, -0.15585, -0.156446, -0.157023,
  -0.157583, -0.158125, -0.158649, -0.159155, -0.159642, -0.160112,
  -0.160563, -0.160995, -0.161409, -0.161805, -0.162182, -0.162541,
  -0.162881, -0.163202, -0.163504, -0.163788, -0.164052, -0.164298,
  -0.164525, -0.164732, -0.164921, -0.165091, -0.165241, -0.165372,
  -0.165485, -0.165578, -0.165651, -0.165706, -0.165741, -0.165757,
  -0.165753, -0.165731, -0.165689, -0.165627, -0.165546, -0.165446,
  -0.165327, -0.165188, -0.16503, -0.164852, -0.164655, -0.164439,
  -0.164203, -0.163948, -0.163674, -0.16338, -0.163067, -0.162735,
  -0.162384, -0.162013, -0.161624, -0.161215, -0.160787, -0.16034,
  -0.159873, -0.159388, -0.158884, -0.158361, -0.157819, -0.157259,
  -0.156679, -0.156081, -0.155464, -0.154828, -0.154174, -0.153502,
  -0.152811, -0.152102, -0.151374, -0.150628, -0.149864, -0.149082,
  -0.148282, -0.147464, -0.146628, -0.145775, -0.144904, -0.144015,
  -0.143109, -0.142185, -0.141244, -0.140286, -0.139311, -0.138319,
  -0.13731, -0.136284, -0.135241, -0.134182, -0.133107, -0.132015,
  -0.130907, -0.129783, -0.128642, -0.127486, -0.126314, -0.125127,
  -0.123924, -0.122706, -0.121472, -0.120224, -0.11896, -0.117682,
  -0.116389, -0.115081, -0.113759, -0.112423, -0.111073, -0.109709,
  -0.108331, -0.106939, -0.105534, -0.104116, -0.102684, -0.10124,
  -0.0997821, -0.098312, -0.0968293, -0.0953344, -0.0938272,
  -0.0923081, -0.0907771, -0.0892345, -0.0876803, -0.0861149,
  -0.0845384, -0.0829509, -0.0813526, -0.0797438, -0.0781246,
  -0.0764951, -0.0748557, -0.0732064, -0.0715475, -0.0698791,
  -0.0682015, -0.0665149, -0.0648194, -0.0631152, -0.0614026,
  -0.0596817, -0.0579527, -0.0562159, -0.0544715, -0.0527196,
  -0.0509604, -0.0491943, -0.0474213, -0.0456417, -0.0438557,
  -0.0420635, -0.0402654, -0.0384615, -0.036652, -0.0348372,
  -0.0330174, -0.0311926, -0.0293631, -0.0275292, -0.0256911,
  -0.023849, -0.022003, -0.0201535, -0.0183007, -0.0164448,
  -0.0145859, -0.0127244, -0.0108605, -0.00899435, -0.00712622,
  -0.00525634, -0.00338494, -0.00151224, 0.000361517, 0.00223611,
  0.00411131, 0.00598688, 0.00786259, 0.00973821, 0.0116135,
  0.0134882, 0.0153622, 0.0172351, 0.0191068, 0.020977, 0.0228454,
  0.0247119, 0.0265762, 0.0284381, 0.0302973, 0.0321537, 0.0340069,
  0.0358567, 0.037703, 0.0395454, 0.0413837, 0.0432178, 0.0450473,
  0.0468721, 0.0486919, 0.0505065, 0.0523156, 0.054119, 0.0559164,
  0.0577078, 0.0594927, 0.0612711, 0.0630426, 0.064807, 0.0665641,
  0.0683137, 0.0700555, 0.0717894, 0.073515, 0.0752322, 0.0769408,
  0.0786405, 0.080331, 0.0820123, 0.0836839, 0.0853459, 0.0869978,
  0.0886395, 0.0902708, 0.0918914, 0.0935012, 0.0950999, 0.0966874,
  0.0982633, 0.0998275, 0.10138, 0.10292, 0.104448, 0.105963,
  0.107466, 0.108955, 0.110431, 0.111895, 0.113344, 0.11478, 0.116202,
  0.117609, 0.119002, 0.120381, 0.121745, 0.123094, 0.124428,
  0.125747, 0.12705, 0.128338, 0.129609, 0.130865, 0.132104, 0.133328,
  0.134534, 0.135724, 0.136897, 0.138053, 0.139191, 0.140313,
  0.141416, 0.142502, 0.14357, 0.14462, 0.145652, 0.146666, 0.147661,
  0.148637, 0.149595, 0.150534, 0.151453, 0.152354, 0.153235,
  0.154096, 0.154938, 0.155761, 0.156563, 0.157345, 0.158107,
  0.158849, 0.159571, 0.160272, 0.160953, 0.161613, 0.162252, 0.16287,
  0.163467, 0.164043, 0.164598, 0.165131, 0.165643, 0.166134,
  0.166603, 0.16705, 0.167476, 0.16788, 0.168261, 0.168621, 0.168959,
  0.169275, 0.169568, 0.169839, 0.170088, 0.170315, 0.170519,
  0.170701, 0.17086, 0.170996, 0.17111, 0.171201, 0.17127, 0.171316,
  0.171339, 0.171339, 0.171317, 0.171271, 0.171203, 0.171112,
  0.170998, 0.170861, 0.170701, 0.170519, 0.170313, 0.170085,
  0.169833, 0.169559, 0.169262, 0.168942, 0.168599, 0.168233,
  0.167844, 0.167433, 0.166999, 0.166542, 0.166063, 0.16556, 0.165036,
  0.164488, 0.163918, 0.163326, 0.162711, 0.162074, 0.161415,
  0.160733, 0.160029, 0.159303, 0.158555, 0.157785, 0.156994, 0.15618,
  0.155345, 0.154488, 0.153609, 0.152709, 0.151788, 0.150846,
  0.149882, 0.148898, 0.147892, 0.146866, 0.145819, 0.144751,
  0.143663, 0.142555, 0.141426, 0.140277, 0.139109, 0.13792, 0.136712,
  0.135484, 0.134237, 0.132971, 0.131686, 0.130382, 0.129059,
  0.127717, 0.126357, 0.124979, 0.123582, 0.122168, 0.120736,
  0.119286, 0.117819, 0.116334, 0.114833, 0.113314, 0.111779,
  0.110228, 0.10866, 0.107076, 0.105476, 0.103861, 0.10223, 0.100584,
  0.0989224, 0.0972463, 0.0955555, 0.0938502, 0.0921308, 0.0903974,
  0.0886503, 0.0868896, 0.0851156, 0.0833285, 0.0815287, 0.0797162,
  0.0778913, 0.0760544, 0.0742055, 0.0723451, 0.0704732, 0.0685902,
  0.0666963, 0.0647918, 0.0628769, 0.0609519, 0.059017, 0.0570726,
  0.0551188, 0.0531559, 0.0511842, 0.0492039, 0.0472154, 0.0452189,
  0.0432147, 0.041203, 0.0391841, 0.0371583, 0.035126, 0.0330872,
  0.0310424, 0.0289919, 0.0269358, 0.0248746, 0.0228084, 0.0207376,
  0.0186625, 0.0165833, 0.0145004, 0.012414, 0.0103244, 0.00823196,
  0.00613696, 0.00403967, 0.00194041, -0.000160525, -0.00226284,
  -0.00436624, -0.00647041, -0.00857505, -0.0106799, -0.0127845,
  -0.0148888, -0.0169923, -0.0190947, -0.0211958, -0.0232953,
  -0.0253928, -0.027488, -0.0295806, -0.0316703, -0.0337568,
  -0.0358399, -0.0379191, -0.0399942, -0.0420649, -0.0441308,
  -0.0461917, -0.0482472, -0.0502971, -0.052341, -0.0543786,
  -0.0564097, -0.0584339, -0.0604508, -0.0624603, -0.0644619,
  -0.0664555, -0.0684406, -0.070417, -0.0723844, -0.0743425,
  -0.0762909, -0.0782294, -0.0801577, -0.0820754, -0.0839823,
  -0.0858781, -0.0877625, -0.0896351, -0.0914957, -0.0933441,
  -0.0951798, -0.0970026, -0.0988123, -0.100608, -0.102391, -0.104159,
  -0.105913, -0.107653, -0.109378, -0.111087, -0.112781, -0.114459,
  -0.116122, -0.117768, -0.119397, -0.12101, -0.122605, -0.124184,
  -0.125744, -0.127287, -0.128812, -0.130318, -0.131806, -0.133275,
  -0.134724, -0.136155, -0.137565, -0.138956, -0.140327, -0.141677,
  -0.143007, -0.144316, -0.145604, -0.146871, -0.148116, -0.14934,
  -0.150541, -0.151721, -0.152878, -0.154012, -0.155124, -0.156213,
  -0.157278, -0.15832, -0.159339, -0.160334, -0.161304, -0.162251,
  -0.163174, -0.164071, -0.164945, -0.165793, -0.166616, -0.167414,
  -0.168187, -0.168935, -0.169656, -0.170352, -0.171022, -0.171666,
  -0.172283, -0.172874, -0.173439, -0.173977, -0.174488, -0.174972,
  -0.17543, -0.17586, -0.176263, -0.176638, -0.176987, -0.177307,
  -0.1776, -0.177866, -0.178103, -0.178313, -0.178494, -0.178648,
  -0.178774, -0.178871, -0.17894, -0.178981, -0.178993, -0.178978,
  -0.178933, -0.178861, -0.178759, -0.17863, -0.178471, -0.178284,
  -0.178069, -0.177825, -0.177552, -0.177251, -0.176921, -0.176563,
  -0.176176, -0.17576, -0.175316, -0.174843, -0.174342, -0.173812,
  -0.173254, -0.172668, -0.172053, -0.17141, -0.170738, -0.170039,
  -0.169311, -0.168556, -0.167772, -0.166961, -0.166122, -0.165255,
  -0.16436, -0.163438, -0.162489, -0.161512, -0.160508, -0.159477,
  -0.158419, -0.157335, -0.156223, -0.155085, -0.153921, -0.15273,
  -0.151514, -0.150271, -0.149003, -0.147709, -0.146389, -0.145045,
  -0.143675, -0.14228, -0.140861, -0.139417, -0.137948, -0.136456,
  -0.134939, -0.133399, -0.131835, -0.130248, -0.128638, -0.127005,
  -0.12535, -0.123672, -0.121972, -0.12025, -0.118507, -0.116742,
  -0.114956, -0.113149, -0.111321, -0.109473, -0.107605, -0.105718,
  -0.103811, -0.101884, -0.0999389, -0.097975, -0.0959927, -0.0939924,
  -0.0919744, -0.089939, -0.0878865, -0.0858172, -0.0837315,
  -0.0816296, -0.0795119, -0.0773788, -0.0752305, -0.0730674,
  -0.0708899, -0.0686982, -0.0664928, -0.064274, -0.0620421,
  -0.0597975, -0.0575406, -0.0552718, -0.0529913, -0.0506996,
  -0.048397, -0.0460839, -0.0437608, -0.0414279, -0.0390857,
  -0.0367345, -0.0343748, -0.0320069, -0.0296313, -0.0272483,
  -0.0248583, -0.0224618, -0.020059, -0.0176506, -0.0152367,
  -0.012818, -0.0103947, -0.00796733, -0.00553626, -0.00310191,
  -0.000664717, 0.00177491, 0.00421654, 0.00665975, 0.00910411,
  0.0115492, 0.0139946, 0.0164398, 0.0188845, 0.0213282, 0.0237704,
  0.0262107, 0.0286488, 0.0310841, 0.0335162, 0.0359447, 0.0383692,
  0.0407891, 0.0432041, 0.0456137, 0.0480174, 0.050415, 0.0528058,
  0.0551894, 0.0575655, 0.0599335, 0.062293, 0.0646437, 0.066985,
  0.0693164, 0.0716377, 0.0739482, 0.0762477, 0.0785356, 0.0808115,
  0.0830749, 0.0853255, 0.0875628, 0.0897864, 0.0919958, 0.0941906,
  0.0963703, 0.0985346, 0.100683, 0.102815, 0.104931, 0.107029,
  0.109109, 0.111172, 0.113216, 0.115242, 0.117248, 0.119234,
  0.121201, 0.123147, 0.125072, 0.126976, 0.128858, 0.130718,
  0.132556, 0.134371, 0.136163, 0.137931, 0.139675, 0.141395, 0.14309,
  0.14476, 0.146404, 0.148023, 0.149615, 0.151181, 0.15272, 0.154232,
  0.155716, 0.157172, 0.1586, 0.16, 0.16137, 0.162711, 0.164023,
  0.165305, 0.166557, 0.167778, 0.168968, 0.170128, 0.171256,
  0.172352, 0.173417, 0.174449, 0.175449, 0.176416, 0.17735, 0.178251,
  0.179118, 0.179952, 0.180752, 0.181517, 0.182248, 0.182945,
  0.183606, 0.184233, 0.184824, 0.18538, 0.185901, 0.186385, 0.186834,
  0.187246, 0.187622, 0.187962, 0.188265, 0.188531, 0.18876, 0.188953,
  0.189108, 0.189226, 0.189306, 0.189349, 0.189355, 0.189323,
  0.189253, 0.189145, 0.189, 0.188816, 0.188595, 0.188336, 0.188038,
  0.187703, 0.187329, 0.186917, 0.186467, 0.185979, 0.185453,
  0.184889, 0.184287, 0.183646, 0.182968, 0.182252, 0.181497,
  0.180705, 0.179876, 0.179008, 0.178103, 0.17716, 0.176181, 0.175163,
  0.174109, 0.173017, 0.171889, 0.170724, 0.169522, 0.168284, 0.16701,
  0.165699, 0.164353, 0.16297, 0.161553, 0.160099, 0.158611, 0.157088,
  0.15553, 0.153938, 0.152312, 0.150652, 0.148958, 0.14723, 0.14547,
  0.143677, 0.141851, 0.139993, 0.138103, 0.136182, 0.134229,
  0.132245, 0.130231, 0.128187, 0.126112, 0.124009, 0.121876,
  0.119714, 0.117524, 0.115306, 0.11306, 0.110787, 0.108488, 0.106162,
  0.10381, 0.101433, 0.0990311, 0.0966044, 0.0941536, 0.0916792,
  0.0891817, 0.0866615, 0.0841191, 0.0815551, 0.0789699, 0.076364,
  0.073738, 0.0710924, 0.0684277, 0.0657444, 0.063043, 0.0603242,
  0.0575885, 0.0548364, 0.0520685, 0.0492854, 0.0464876, 0.0436757,
  0.0408504, 0.0380121, 0.0351615, 0.0322992, 0.0294259, 0.026542,
  0.0236483, 0.0207453, 0.0178337, 0.0149141, 0.0119872, 0.00905352,
  0.0061138, 0.00316864, 0.000218714, -0.00273533, -0.00569284,
  -0.00865315, -0.0116156, -0.0145795, -0.0175442, -0.020509,
  -0.0234733, -0.0264363, -0.0293974, -0.0323559, -0.0353111,
  -0.0382623, -0.0412088, -0.04415, -0.0470851, -0.0500134,
  -0.0529343, -0.055847, -0.0587508, -0.0616451, -0.0645291,
  -0.0674022, -0.0702635, -0.0731125, -0.0759485, -0.0787706,
  -0.0815782, -0.0843707, -0.0871472, -0.0899071, -0.0926498,
  -0.0953744, -0.0980804, -0.100767, -0.103433, -0.106079, -0.108703,
  -0.111305, -0.113884, -0.11644, -0.118971, -0.121478, -0.123958,
  -0.126413, -0.12884, -0.13124, -0.133612, -0.135955, -0.138268,
  -0.140551, -0.142803, -0.145023, -0.147212, -0.149367, -0.151489,
  -0.153577, -0.15563, -0.157648, -0.15963, -0.161576, -0.163484,
  -0.165355, -0.167188, -0.168981, -0.170735, -0.172449, -0.174123,
  -0.175756, -0.177347, -0.178895, -0.180401, -0.181864, -0.183283,
  -0.184658, -0.185989, -0.187274, -0.188513, -0.189707, -0.190853,
  -0.191953, -0.193006, -0.19401, -0.194966, -0.195874, -0.196732,
  -0.197541, -0.198301, -0.19901, -0.199668, -0.200276, -0.200832,
  -0.201337, -0.20179, -0.202191, -0.20254, -0.202836, -0.203079,
  -0.203269, -0.203405, -0.203488, -0.203517, -0.203493, -0.203414,
  -0.20328, -0.203093, -0.20285, -0.202553, -0.202201, -0.201794,
  -0.201332, -0.200815, -0.200243, -0.199616, -0.198933, -0.198195,
  -0.197403, -0.196554, -0.195651, -0.194693, -0.19368, -0.192611,
  -0.191488, -0.19031, -0.189078, -0.187791, -0.18645, -0.185055,
  -0.183605, -0.182103, -0.180546, -0.178937, -0.177274, -0.175559,
  -0.173791, -0.171971, -0.170099, -0.168176, -0.166202, -0.164177,
  -0.162101, -0.159976, -0.157801, -0.155577, -0.153304, -0.150983,
  -0.148615, -0.146199, -0.143736, -0.141228, -0.138673, -0.136074,
  -0.13343, -0.130743, -0.128012, -0.125239, -0.122423, -0.119566,
  -0.116669, -0.113732, -0.110755, -0.10774, -0.104687, -0.101597,
  -0.0984714, -0.0953099, -0.0921137, -0.0888837, -0.0856207,
  -0.0823256, -0.0789991, -0.0756422, -0.0722558, -0.0688408,
  -0.065398, -0.0619284, -0.0584331, -0.0549128, -0.0513686,
  -0.0478015, -0.0442125, -0.0406026, -0.0369728, -0.0333241,
  -0.0296577, -0.0259744, -0.0222755, -0.0185621, -0.0148351,
  -0.0110957, -0.00734506, -0.00358427, 0.000185537, 0.00396321,
  0.00774759, 0.0115375, 0.0153318, 0.0191293, 0.0229287, 0.026729,
  0.0305288, 0.034327, 0.0381224, 0.0419136, 0.0456995, 0.0494789,
  0.0532504, 0.0570129, 0.060765, 0.0645055, 0.0682332, 0.0719467,
  0.0756447, 0.0793261, 0.0829895, 0.0866336, 0.0902571, 0.0938588,
  0.0974373, 0.100991, 0.10452, 0.108021, 0.111494, 0.114937, 0.11835,
  0.12173, 0.125077, 0.128388, 0.131664, 0.134903, 0.138103, 0.141262,
  0.144381, 0.147458, 0.15049, 0.153478, 0.156419, 0.159313, 0.162159,
  0.164954, 0.167699, 0.170391, 0.173029, 0.175613, 0.178141,
  0.180612, 0.183025, 0.185379, 0.187672, 0.189903, 0.192072,
  0.194177, 0.196218, 0.198192, 0.2001, 0.201939, 0.20371, 0.205411,
  0.207041, 0.208599, 0.210084, 0.211495, 0.212832, 0.214093,
  0.215279, 0.216386, 0.217416, 0.218368, 0.219239, 0.220031,
  0.220741, 0.22137, 0.221916, 0.22238, 0.222759, 0.223055, 0.223266,
  0.223392, 0.223432, 0.223385, 0.223252, 0.223032, 0.222724,
  0.222329, 0.221845, 0.221273, 0.220612, 0.219862, 0.219023,
  0.218095, 0.217077, 0.21597, 0.214773, 0.213487, 0.212111, 0.210645,
  0.20909, 0.207446, 0.205712, 0.20389, 0.201978, 0.199978, 0.197891,
  0.195715, 0.193452, 0.191101, 0.188665, 0.186142, 0.183534,
  0.180841, 0.178063, 0.175203, 0.172259, 0.169233, 0.166126,
  0.162938, 0.15967, 0.156324, 0.152901, 0.1494, 0.145824, 0.142173,
  0.138449, 0.134652, 0.130785, 0.126847, 0.122841, 0.118768,
  0.114629, 0.110426, 0.10616, 0.101832, 0.0974451, 0.0929996,
  0.0884974, 0.0839404, 0.0793301, 0.0746685, 0.0699572, 0.0651981,
  0.0603931, 0.0555441, 0.0506532, 0.0457222, 0.0407532, 0.0357484,
  0.0307098, 0.0256395, 0.0205398, 0.0154129, 0.010261, 0.00508655,
  -0.000108272, -0.00532104, -0.0105494, -0.0157908, -0.0210429,
  -0.0263032, -0.0315691, -0.036838, -0.0421075, -0.0473749,
  -0.0526375, -0.0578926, -0.0631377, -0.0683699, -0.0735866,
  -0.078785, -0.0839622, -0.0891156, -0.0942422, -0.0993392,
  -0.104404, -0.109433, -0.114424, -0.119374, -0.124281, -0.12914,
  -0.133949, -0.138706, -0.143407, -0.148049, -0.152629, -0.157145,
  -0.161594, -0.165972, -0.170277, -0.174505, -0.178654, -0.182721,
  -0.186703, -0.190596, -0.194399, -0.198108, -0.20172, -0.205233,
  -0.208643, -0.211948, -0.215145, -0.218232, -0.221205, -0.224062,
  -0.226801, -0.229418, -0.231911, -0.234278, -0.236515, -0.238621,
  -0.240594, -0.24243, -0.244127, -0.245684, -0.247098, -0.248367,
  -0.249488, -0.25046, -0.251281, -0.251948, -0.252461, -0.252817,
  -0.253014, -0.253052, -0.252927, -0.25264, -0.252188, -0.251571,
  -0.250787, -0.249835, -0.248713, -0.247422, -0.245961, -0.244327,
  -0.242522, -0.240544, -0.238393, -0.23607, -0.233572, -0.230901,
  -0.228057, -0.22504, -0.221849, -0.218487, -0.214952, -0.211246,
  -0.20737, -0.203324, -0.19911, -0.194728, -0.190181, -0.18547,
  -0.180596, -0.175561, -0.170367, -0.165017, -0.159512, -0.153855,
  -0.148049, -0.142095, -0.135998, -0.12976, -0.123384, -0.116874,
  -0.110234, -0.103466, -0.0965747, -0.0895645, -0.0824394,
  -0.0752037, -0.0678619, -0.0604189, -0.0528793, -0.0452484,
  -0.0375314, -0.0297336, -0.0218606, -0.0139182, -0.00591232,
  0.00215104, 0.0102656, 0.0184248, 0.0266223, 0.0348511, 0.0431045,
  0.0513752, 0.059656, 0.0679396, 0.0762184, 0.0844846, 0.0927304,
  0.100948, 0.109129, 0.117264, 0.125347, 0.133367, 0.141317,
  0.149188, 0.156969, 0.164654, 0.172231, 0.179693, 0.187029, 0.19423,
  0.201287, 0.20819, 0.214928, 0.221493, 0.227875, 0.234063, 0.240048,
  0.24582, 0.251368, 0.256683, 0.261755, 0.266574, 0.27113, 0.275412,
  0.279412, 0.283119, 0.286524, 0.289616, 0.292388, 0.294828,
  0.296928, 0.298679, 0.300071, 0.301097, 0.301747, 0.302013,
  0.301888, 0.301362, 0.30043, 0.299083, 0.297315, 0.295119, 0.292489,
  0.28942, 0.285905, 0.281941, 0.277523, 0.272646, 0.267309, 0.261507,
  0.255239, 0.248504, 0.2413, 0.233628, 0.225487, 0.21688, 0.207809,
  0.198276, 0.188286, 0.177844, 0.166954, 0.155625, 0.143864,
  0.131679, 0.119082, 0.106083, 0.0926956, 0.0789328, 0.0648101,
  0.0503442, 0.0355531, 0.0204563, 0.00507506, -0.0105679, -0.0264481,
  -0.0425395, -0.0588139, -0.0752415, -0.0917905, -0.108427,
  -0.125115, -0.141817, -0.158492, -0.175098, -0.191589, -0.207919,
  -0.224037, -0.23989, -0.255425, -0.270581, -0.285299, -0.299514,
  -0.313159, -0.326165, -0.338457, -0.349959, -0.36059, -0.370267,
  -0.378902, -0.386404, -0.392677, -0.397622, -0.401136, -0.403111,
  -0.403436, -0.401992, -0.39866, -0.393312, -0.38582, -0.376045,
  -0.363848, -0.349082, -0.331594, -0.311228, -0.28782, -0.261201,
  -0.231196, -0.197622, -0.160292, -0.119011, -0.0735784, -0.0237851,
  0.0305842, 0.0897523, 0.153949, 0.223414, 0.298391, 0.379135,
  0.465908, 0.558981, 0.658634, 0.765155, 0.878841, 1}; const G4double
  G4NeutronHPFastLegendre::i25[5201] = {0, -0.000361063, -0.000676975,
  -0.000950548, -0.00118448, -0.00138136, -0.00154367, -0.00167377,
  -0.00177393, -0.00184632, -0.00189302, -0.00191599, -0.00191715,
  -0.00189828, -0.0018611, -0.00180725, -0.0017383, -0.00165571,
  -0.0015609, -0.00145521, -0.00133991, -0.00121619, -0.0010852,
  -0.00094801, -0.00080564, -0.00065905, -0.000509144, -0.000356773,
  -0.000202737, -4.77865e-05, 0.000107375, 0.000262091, 0.000415747,
  0.000567774, 0.000717639, 0.000864852, 0.00100896, 0.00114954,
  0.00128622, 0.00141863, 0.00154647, 0.00166944, 0.00178728,
  0.00189976, 0.00200668, 0.00210784, 0.00220311, 0.00229233,
  0.00237541, 0.00245225, 0.00252277, 0.00258692, 0.00264467,
  0.00269601, 0.00274092, 0.00277942, 0.00281154, 0.00283731,
  0.0028568, 0.00287006, 0.00287717, 0.00287822, 0.0028733,
  0.00286252, 0.00284599, 0.00282383, 0.00279618, 0.00276316,
  0.00272492, 0.00268161, 0.00263337, 0.00258037, 0.00252276,
  0.00246071, 0.00239439, 0.00232397, 0.00224961, 0.0021715,
  0.00208982, 0.00200473, 0.00191642, 0.00182508, 0.00173087,
  0.00163398, 0.00153459, 0.00143288, 0.00132902, 0.00122321,
  0.0011156, 0.00100639, 0.000895733, 0.000783813, 0.000670797,
  0.000556853, 0.000442147, 0.000326842, 0.0002111, 9.50766e-05,
  -2.10712e-05, -0.000137192, -0.000253136, -0.000368757,
  -0.000483914, -0.000598465, -0.000712276, -0.000825213,
  -0.000937147, -0.00104795, -0.00115751, -0.0012657, -0.00137241,
  -0.00147752, -0.00158093, -0.00168254, -0.00178225, -0.00187996,
  -0.00197558, -0.00206903, -0.00216021, -0.00224905, -0.00233547,
  -0.0024194, -0.00250078, -0.00257953, -0.0026556, -0.00272892,
  -0.00279945, -0.00286713, -0.00293192, -0.00299377, -0.00305265,
  -0.00310852, -0.00316135, -0.0032111, -0.00325776, -0.0033013,
  -0.0033417, -0.00337895, -0.00341303, -0.00344393, -0.00347165,
  -0.00349619, -0.00351754, -0.00353571, -0.0035507, -0.00356252,
  -0.00357119, -0.0035767, -0.00357909, -0.00357836, -0.00357455,
  -0.00356767, -0.00355774, -0.0035448, -0.00352888, -0.00351001,
  -0.00348822, -0.00346354, -0.00343603, -0.00340571, -0.00337263,
  -0.00333683, -0.00329835, -0.00325725, -0.00321357, -0.00316737,
  -0.00311868, -0.00306757, -0.00301408, -0.00295828, -0.00290022,
  -0.00283995, -0.00277754, -0.00271303, -0.0026465, -0.00257801,
  -0.0025076, -0.00243536, -0.00236133, -0.00228559, -0.00220819,
  -0.00212921, -0.0020487, -0.00196673, -0.00188337, -0.00179869,
  -0.00171274, -0.0016256, -0.00153733, -0.00144801, -0.00135769,
  -0.00126644, -0.00117433, -0.00108142, -0.000987794, -0.000893502,
  -0.000798615, -0.000703199, -0.000607319, -0.00051104, -0.000414427,
  -0.000317545, -0.000220457, -0.000123227, -2.5918e-05, 7.14077e-05,
  0.000168688, 0.000265862, 0.000362869, 0.000459649, 0.000556143,
  0.000652291, 0.000748037, 0.000843324, 0.000938095, 0.00103229,
  0.00112587, 0.00121876, 0.00131092, 0.0014023, 0.00149284,
  0.0015825, 0.00167122, 0.00175896, 0.00184566, 0.0019313,
  0.00201581, 0.00209915, 0.00218129, 0.00226218, 0.00234177,
  0.00242003, 0.00249693, 0.00257241, 0.00264645, 0.00271901,
  0.00279006, 0.00285956, 0.00292748, 0.00299378, 0.00305845,
  0.00312144, 0.00318274, 0.00324232, 0.00330014, 0.00335619,
  0.00341045, 0.00346288, 0.00351348, 0.00356221, 0.00360907,
  0.00365404, 0.00369709, 0.00373821, 0.00377739, 0.00381462,
  0.00384988, 0.00388317, 0.00391447, 0.00394377, 0.00397107,
  0.00399636, 0.00401963, 0.00404089, 0.00406012, 0.00407733,
  0.00409251, 0.00410567, 0.0041168, 0.0041259, 0.00413299,
  0.00413805, 0.0041411, 0.00414215, 0.00414119, 0.00413824,
  0.0041333, 0.00412638, 0.0041175, 0.00410666, 0.00409388,
  0.00407917, 0.00406254, 0.004044, 0.00402358, 0.00400128,
  0.00397713, 0.00395114, 0.00392332, 0.0038937, 0.0038623,
  0.00382914, 0.00379424, 0.00375761, 0.00371929, 0.00367929,
  0.00363763, 0.00359435, 0.00354946, 0.003503, 0.00345498,
  0.00340543, 0.00335438, 0.00330186, 0.00324789, 0.00319251,
  0.00313573, 0.00307759, 0.00301813, 0.00295735, 0.00289531,
  0.00283203, 0.00276753, 0.00270186, 0.00263504, 0.0025671,
  0.00249808, 0.002428, 0.00235691, 0.00228483, 0.00221179,
  0.00213784, 0.00206299, 0.0019873, 0.00191078, 0.00183348,
  0.00175542, 0.00167665, 0.00159719, 0.00151709, 0.00143637,
  0.00135507, 0.00127322, 0.00119086, 0.00110802, 0.00102474,
  0.000941047, 0.000856983, 0.000772579, 0.000687869, 0.000602889,
  0.000517671, 0.00043225, 0.00034666, 0.000260934, 0.000175108,
  8.92131e-05, 3.28398e-06, -8.26464e-05, -0.000168545, -0.000254379,
  -0.000340115, -0.000425721, -0.000511166, -0.000596416, -0.00068144,
  -0.000766206, -0.000850684, -0.000934842, -0.00101865, -0.00110208,
  -0.00118509, -0.00126766, -0.00134977, -0.00143137, -0.00151245,
  -0.00159297, -0.0016729, -0.00175222, -0.0018309, -0.00190891,
  -0.00198623, -0.00206282, -0.00213867, -0.00221375, -0.00228803,
  -0.00236149, -0.0024341, -0.00250585, -0.0025767, -0.00264663,
  -0.00271562, -0.00278365, -0.0028507, -0.00291675, -0.00298176,
  -0.00304574, -0.00310865, -0.00317047, -0.00323119, -0.00329079,
  -0.00334924, -0.00340654, -0.00346267, -0.0035176, -0.00357132,
  -0.00362383, -0.00367509, -0.0037251, -0.00377385, -0.00382131,
  -0.00386748, -0.00391234, -0.00395589, -0.0039981, -0.00403898,
  -0.0040785, -0.00411666, -0.00415345, -0.00418886, -0.00422288,
  -0.0042555, -0.00428671, -0.00431651, -0.0043449, -0.00437186,
  -0.00439738, -0.00442147, -0.00444412, -0.00446533, -0.00448508,
  -0.00450339, -0.00452024, -0.00453563, -0.00454956, -0.00456203,
  -0.00457304, -0.00458259, -0.00459068, -0.00459731, -0.00460248,
  -0.00460618, -0.00460844, -0.00460923, -0.00460858, -0.00460648,
  -0.00460293, -0.00459794, -0.00459152, -0.00458367, -0.00457439,
  -0.00456369, -0.00455158, -0.00453806, -0.00452314, -0.00450683,
  -0.00448913, -0.00447006, -0.00444962, -0.00442782, -0.00440467,
  -0.00438019, -0.00435437, -0.00432724, -0.00429879, -0.00426905,
  -0.00423803, -0.00420573, -0.00417217, -0.00413736, -0.00410132,
  -0.00406405, -0.00402558, -0.00398591, -0.00394505, -0.00390303,
  -0.00385986, -0.00381555, -0.00377012, -0.00372358, -0.00367595,
  -0.00362725, -0.00357749, -0.00352668, -0.00347486, -0.00342202,
  -0.00336819, -0.00331339, -0.00325763, -0.00320093, -0.00314332,
  -0.0030848, -0.0030254, -0.00296513, -0.00290402, -0.00284208,
  -0.00277933, -0.00271579, -0.00265149, -0.00258643, -0.00252065,
  -0.00245416, -0.00238697, -0.00231912, -0.00225061, -0.00218148,
  -0.00211174, -0.00204141, -0.00197051, -0.00189907, -0.00182709,
  -0.00175462, -0.00168166, -0.00160823, -0.00153436, -0.00146008,
  -0.00138539, -0.00131032, -0.00123489, -0.00115913, -0.00108305,
  -0.00100668, -0.000930033, -0.000853136, -0.000776007, -0.000698669,
  -0.000621143, -0.00054345, -0.000465611, -0.000387647, -0.000309579,
  -0.000231429, -0.000153217, -7.49638e-05, 3.30916e-06, 8.15813e-05,
  0.000159832, 0.00023804, 0.000316186, 0.000394248, 0.000472207,
  0.000550041, 0.000627732, 0.000705258, 0.0007826, 0.000859738,
  0.000936652, 0.00101332, 0.00108973, 0.00116585, 0.00124168,
  0.00131718, 0.00139234, 0.00146715, 0.00154158, 0.00161561,
  0.00168923, 0.00176241, 0.00183515, 0.00190742, 0.0019792,
  0.00205048, 0.00212124, 0.00219146, 0.00226113, 0.00233023,
  0.00239874, 0.00246664, 0.00253393, 0.00260058, 0.00266658,
  0.00273191, 0.00279656, 0.00286051, 0.00292375, 0.00298626,
  0.00304803, 0.00310905, 0.0031693, 0.00322876, 0.00328743,
  0.00334529, 0.00340232, 0.00345852, 0.00351387, 0.00356837,
  0.00362199, 0.00367472, 0.00372656, 0.0037775, 0.00382751,
  0.0038766, 0.00392475, 0.00397195, 0.00401819, 0.00406346,
  0.00410776, 0.00415106, 0.00419337, 0.00423468, 0.00427497,
  0.00431424, 0.00435248, 0.00438969, 0.00442584, 0.00446095,
  0.004495, 0.00452799, 0.0045599, 0.00459074, 0.00462049, 0.00464916,
  0.00467673, 0.0047032, 0.00472858, 0.00475284, 0.00477599,
  0.00479803, 0.00481895, 0.00483875, 0.00485742, 0.00487497,
  0.00489138, 0.00490667, 0.00492082, 0.00493383, 0.0049457,
  0.00495644, 0.00496604, 0.0049745, 0.00498182, 0.00498799,
  0.00499303, 0.00499693, 0.00499969, 0.00500131, 0.00500179,
  0.00500114, 0.00499936, 0.00499644, 0.00499239, 0.00498722,
  0.00498092, 0.0049735, 0.00496496, 0.00495531, 0.00494455,
  0.00493268, 0.0049197, 0.00490563, 0.00489047, 0.00487421,
  0.00485687, 0.00483845, 0.00481896, 0.0047984, 0.00477678,
  0.0047541, 0.00473038, 0.00470561, 0.00467981, 0.00465298,
  0.00462512, 0.00459626, 0.00456639, 0.00453552, 0.00450365,
  0.00447081, 0.00443699, 0.00440221, 0.00436647, 0.00432979,
  0.00429217, 0.00425361, 0.00421414, 0.00417376, 0.00413248,
  0.00409031, 0.00404727, 0.00400335, 0.00395857, 0.00391295,
  0.00386649, 0.0038192, 0.0037711, 0.0037222, 0.0036725, 0.00362202,
  0.00357078, 0.00351877, 0.00346603, 0.00341254, 0.00335834,
  0.00330343, 0.00324783, 0.00319154, 0.00313458, 0.00307696,
  0.00301869, 0.0029598, 0.00290028, 0.00284016, 0.00277945,
  0.00271816, 0.0026563, 0.00259389, 0.00253095, 0.00246747,
  0.00240349, 0.00233901, 0.00227404, 0.00220861, 0.00214272,
  0.00207639, 0.00200964, 0.00194247, 0.0018749, 0.00180695,
  0.00173863, 0.00166995, 0.00160093, 0.00153159, 0.00146194,
  0.00139198, 0.00132175, 0.00125124, 0.00118049, 0.00110949,
  0.00103827, 0.000966837, 0.000895212, 0.000823406, 0.000751434,
  0.000679311, 0.000607052, 0.000534672, 0.000462184, 0.000389603,
  0.000316945, 0.000244223, 0.000171453, 9.8649e-05, 2.58251e-05,
  -4.70039e-05, -0.000119824, -0.000192619, -0.000265377,
  -0.000338082, -0.000410721, -0.000483278, -0.00055574, -0.000628092,
  -0.000700321, -0.000772413, -0.000844352, -0.000916126,
  -0.000987721, -0.00105912, -0.00113032, -0.00120129, -0.00127203,
  -0.00134252, -0.00141275, -0.00148271, -0.00155238, -0.00162174,
  -0.0016908, -0.00175952, -0.00182791, -0.00189594, -0.00196361,
  -0.0020309, -0.0020978, -0.00216429, -0.00223037, -0.00229602,
  -0.00236123, -0.00242599, -0.00249029, -0.00255411, -0.00261744,
  -0.00268028, -0.0027426, -0.00280441, -0.00286568, -0.0029264,
  -0.00298657, -0.00304618, -0.00310521, -0.00316365, -0.0032215,
  -0.00327874, -0.00333536, -0.00339135, -0.00344671, -0.00350142,
  -0.00355547, -0.00360886, -0.00366157, -0.0037136, -0.00376493,
  -0.00381556, -0.00386548, -0.00391468, -0.00396315, -0.00401089,
  -0.00405788, -0.00410411, -0.00414959, -0.0041943, -0.00423824,
  -0.00428139, -0.00432375, -0.00436532, -0.00440608, -0.00444603,
  -0.00448517, -0.00452348, -0.00456096, -0.00459761, -0.00463341,
  -0.00466837, -0.00470248, -0.00473573, -0.00476811, -0.00479963,
  -0.00483027, -0.00486004, -0.00488892, -0.00491692, -0.00494403,
  -0.00497024, -0.00499555, -0.00501996, -0.00504347, -0.00506607,
  -0.00508775, -0.00510852, -0.00512837, -0.0051473, -0.0051653,
  -0.00518238, -0.00519854, -0.00521376, -0.00522805, -0.00524141,
  -0.00525383, -0.00526532, -0.00527587, -0.00528548, -0.00529415,
  -0.00530189, -0.00530868, -0.00531453, -0.00531945, -0.00532342,
  -0.00532645, -0.00532854, -0.00532969, -0.00532991, -0.00532918,
  -0.00532752, -0.00532492, -0.00532139, -0.00531693, -0.00531153,
  -0.00530521, -0.00529796, -0.00528978, -0.00528068, -0.00527066,
  -0.00525972, -0.00524787, -0.0052351, -0.00522142, -0.00520684,
  -0.00519136, -0.00517498, -0.0051577, -0.00513953, -0.00512047,
  -0.00510053, -0.00507971, -0.00505802, -0.00503545, -0.00501202,
  -0.00498773, -0.00496258, -0.00493658, -0.00490974, -0.00488205,
  -0.00485353, -0.00482418, -0.00479401, -0.00476302, -0.00473122,
  -0.00469862, -0.00466521, -0.00463101, -0.00459603, -0.00456027,
  -0.00452373, -0.00448643, -0.00444837, -0.00440955, -0.00437,
  -0.0043297, -0.00428868, -0.00424693, -0.00420447, -0.0041613,
  -0.00411743, -0.00407288, -0.00402764, -0.00398172, -0.00393514,
  -0.0038879, -0.00384001, -0.00379148, -0.00374232, -0.00369253,
  -0.00364213, -0.00359112, -0.00353952, -0.00348732, -0.00343455,
  -0.00338121, -0.00332731, -0.00327286, -0.00321787, -0.00316235,
  -0.0031063, -0.00304974, -0.00299268, -0.00293513, -0.00287709,
  -0.00281858, -0.00275961, -0.00270018, -0.00264032, -0.00258002,
  -0.00251929, -0.00245816, -0.00239662, -0.00233469, -0.00227239,
  -0.00220971, -0.00214667, -0.00208328, -0.00201955, -0.0019555,
  -0.00189112, -0.00182644, -0.00176147, -0.00169621, -0.00163067,
  -0.00156487, -0.00149882, -0.00143253, -0.00136601, -0.00129926,
  -0.00123231, -0.00116516, -0.00109782, -0.0010303, -0.00096262,
  -0.000894785, -0.000826806, -0.000758695, -0.000690463, -0.00062212,
  -0.000553678, -0.000485148, -0.00041654, -0.000347866, -0.000279136,
  -0.000210362, -0.000141554, -7.27245e-05, -3.88297e-06, 6.49592e-05,
  0.000133791, 0.000202602, 0.000271381, 0.000340116, 0.000408798,
  0.000477416, 0.000545959, 0.000614415, 0.000682775, 0.000751027,
  0.000819161, 0.000887167, 0.000955034, 0.00102275, 0.00109031,
  0.00115769, 0.0012249, 0.00129191, 0.00135872, 0.00142532,
  0.0014917, 0.00155784, 0.00162375, 0.0016894, 0.00175478, 0.0018199,
  0.00188473, 0.00194927, 0.00201351, 0.00207743, 0.00214104,
  0.00220431, 0.00226724, 0.00232983, 0.00239205, 0.0024539,
  0.00251538, 0.00257647, 0.00263716, 0.00269745, 0.00275732,
  0.00281677, 0.00287579, 0.00293437, 0.00299249, 0.00305016,
  0.00310737, 0.0031641, 0.00322034, 0.0032761, 0.00333135, 0.0033861,
  0.00344033, 0.00349404, 0.00354722, 0.00359986, 0.00365195,
  0.00370349, 0.00375447, 0.00380488, 0.00385471, 0.00390396,
  0.00395262, 0.00400068, 0.00404814, 0.00409499, 0.00414123,
  0.00418684, 0.00423182, 0.00427616, 0.00431986, 0.00436291,
  0.00440531, 0.00444705, 0.00448812, 0.00452852, 0.00456824,
  0.00460728, 0.00464563, 0.00468328, 0.00472024, 0.0047565,
  0.00479204, 0.00482688, 0.00486099, 0.00489439, 0.00492705,
  0.00495899, 0.00499018, 0.00502064, 0.00505036, 0.00507933,
  0.00510755, 0.00513501, 0.00516171, 0.00518765, 0.00521283,
  0.00523724, 0.00526087, 0.00528374, 0.00530582, 0.00532713,
  0.00534765, 0.00536739, 0.00538634, 0.0054045, 0.00542187,
  0.00543845, 0.00545423, 0.00546921, 0.0054834, 0.00549678,
  0.00550936, 0.00552114, 0.00553212, 0.00554229, 0.00555165,
  0.00556021, 0.00556795, 0.00557489, 0.00558103, 0.00558635,
  0.00559086, 0.00559456, 0.00559746, 0.00559954, 0.00560081,
  0.00560128, 0.00560094, 0.00559979, 0.00559783, 0.00559507,
  0.0055915, 0.00558713, 0.00558195, 0.00557597, 0.00556919,
  0.00556162, 0.00555324, 0.00554407, 0.00553411, 0.00552335,
  0.00551181, 0.00549948, 0.00548636, 0.00547246, 0.00545778,
  0.00544232, 0.00542608, 0.00540907, 0.0053913, 0.00537276,
  0.00535345, 0.00533339, 0.00531256, 0.00529099, 0.00526866,
  0.00524559, 0.00522178, 0.00519723, 0.00517194, 0.00514592,
  0.00511918, 0.00509171, 0.00506353, 0.00503463, 0.00500503,
  0.00497472, 0.00494371, 0.00491201, 0.00487961, 0.00484653,
  0.00481278, 0.00477834, 0.00474324, 0.00470747, 0.00467105,
  0.00463397, 0.00459625, 0.00455788, 0.00451888, 0.00447924,
  0.00443899, 0.00439811, 0.00435662, 0.00431453, 0.00427183,
  0.00422854, 0.00418467, 0.00414021, 0.00409518, 0.00404959,
  0.00400343, 0.00395672, 0.00390945, 0.00386165, 0.00381332,
  0.00376446, 0.00371508, 0.00366519, 0.00361479, 0.00356389,
  0.0035125, 0.00346063, 0.00340829, 0.00335547, 0.0033022,
  0.00324847, 0.00319429, 0.00313968, 0.00308464, 0.00302917,
  0.0029733, 0.00291701, 0.00286032, 0.00280325, 0.00274579,
  0.00268796, 0.00262976, 0.0025712, 0.00251229, 0.00245304,
  0.00239346, 0.00233355, 0.00227332, 0.00221279, 0.00215195,
  0.00209082, 0.00202941, 0.00196773, 0.00190578, 0.00184357,
  0.00178111, 0.00171841, 0.00165547, 0.00159232, 0.00152895,
  0.00146537, 0.0014016, 0.00133763, 0.00127349, 0.00120917,
  0.0011447, 0.00108007, 0.00101529, 0.000950378, 0.000885338,
  0.000820179, 0.000754911, 0.000689541, 0.000624079, 0.000558534,
  0.000492914, 0.000427228, 0.000361485, 0.000295694, 0.000229864,
  0.000164002, 9.81194e-05, 3.22233e-05, -3.3677e-05, -9.95729e-05,
  -0.000165455, -0.000231316, -0.000297146, -0.000362936,
  -0.000428679, -0.000494364, -0.000559984, -0.00062553, -0.000690992,
  -0.000756364, -0.000821635, -0.000886798, -0.000951844, -0.00101676,
  -0.00108155, -0.00114619, -0.00121068, -0.00127502, -0.00133918,
  -0.00140317, -0.00146698, -0.00153059, -0.001594, -0.0016572,
  -0.00172018, -0.00178294, -0.00184546, -0.00190774, -0.00196978,
  -0.00203155, -0.00209306, -0.0021543, -0.00221525, -0.00227592,
  -0.00233628, -0.00239635, -0.0024561, -0.00251553, -0.00257463,
  -0.0026334, -0.00269182, -0.0027499, -0.00280761, -0.00286497,
  -0.00292195, -0.00297855, -0.00303477, -0.00309059, -0.00314601,
  -0.00320102, -0.00325562, -0.0033098, -0.00336356, -0.00341687,
  -0.00346975, -0.00352218, -0.00357415, -0.00362566, -0.00367671,
  -0.00372728, -0.00377737, -0.00382698, -0.00387609, -0.0039247,
  -0.00397281, -0.00402042, -0.0040675, -0.00411406, -0.0041601,
  -0.0042056, -0.00425057, -0.00429499, -0.00433886, -0.00438217,
  -0.00442493, -0.00446712, -0.00450874, -0.00454978, -0.00459025,
  -0.00463013, -0.00466941, -0.00470811, -0.0047462, -0.00478369,
  -0.00482058, -0.00485685, -0.0048925, -0.00492753, -0.00496194,
  -0.00499571, -0.00502886, -0.00506136, -0.00509323, -0.00512445,
  -0.00515502, -0.00518494, -0.0052142, -0.00524281, -0.00527075,
  -0.00529803, -0.00532464, -0.00535058, -0.00537584, -0.00540043,
  -0.00542434, -0.00544756, -0.0054701, -0.00549195, -0.00551311,
  -0.00553358, -0.00555335, -0.00557243, -0.00559081, -0.00560848,
  -0.00562546, -0.00564173, -0.00565729, -0.00567215, -0.00568629,
  -0.00569973, -0.00571245, -0.00572446, -0.00573576, -0.00574634,
  -0.0057562, -0.00576535, -0.00577377, -0.00578148, -0.00578847,
  -0.00579474, -0.00580029, -0.00580512, -0.00580922, -0.00581261,
  -0.00581527, -0.00581721, -0.00581843, -0.00581893, -0.00581871,
  -0.00581777, -0.00581611, -0.00581373, -0.00581063, -0.00580681,
  -0.00580227, -0.00579702, -0.00579105, -0.00578437, -0.00577697,
  -0.00576887, -0.00576005, -0.00575052, -0.00574029, -0.00572935,
  -0.0057177, -0.00570535, -0.0056923, -0.00567856, -0.00566411,
  -0.00564897, -0.00563314, -0.00561661, -0.0055994, -0.00558151,
  -0.00556293, -0.00554367, -0.00552373, -0.00550311, -0.00548183,
  -0.00545987, -0.00543725, -0.00541396, -0.00539002, -0.00536541,
  -0.00534016, -0.00531425, -0.0052877, -0.0052605, -0.00523266,
  -0.00520419, -0.00517508, -0.00514535, -0.00511499, -0.00508401,
  -0.00505241, -0.0050202, -0.00498738, -0.00495396, -0.00491994,
  -0.00488532, -0.00485011, -0.00481431, -0.00477793, -0.00474098,
  -0.00470345, -0.00466536, -0.0046267, -0.00458748, -0.00454771,
  -0.00450739, -0.00446653, -0.00442514, -0.0043832, -0.00434075,
  -0.00429776, -0.00425427, -0.00421026, -0.00416575, -0.00412073,
  -0.00407522, -0.00402923, -0.00398274, -0.00393579, -0.00388836,
  -0.00384046, -0.00379211, -0.0037433, -0.00369404, -0.00364435,
  -0.00359421, -0.00354365, -0.00349267, -0.00344126, -0.00338945,
  -0.00333723, -0.00328462, -0.00323161, -0.00317822, -0.00312445,
  -0.00307031, -0.0030158, -0.00296094, -0.00290572, -0.00285016,
  -0.00279426, -0.00273803, -0.00268147, -0.0026246, -0.00256741,
  -0.00250992, -0.00245213, -0.00239406, -0.00233569, -0.00227706,
  -0.00221815, -0.00215898, -0.00209956, -0.00203988, -0.00197997,
  -0.00191982, -0.00185945, -0.00179886, -0.00173805, -0.00167704,
  -0.00161584, -0.00155444, -0.00149286, -0.0014311, -0.00136918,
  -0.0013071, -0.00124486, -0.00118247, -0.00111995, -0.00105729,
  -0.000994514, -0.000931619, -0.000868614, -0.000805507,
  -0.000742306, -0.000679018, -0.000615651, -0.000552212,
  -0.000488707, -0.000425146, -0.000361535, -0.000297882,
  -0.000234195, -0.000170479, -0.000106744, -4.29966e-05, 2.0756e-05,
  8.45063e-05, 0.000148247, 0.00021197, 0.000275668, 0.000339335,
  0.000402962, 0.000466542, 0.000530068, 0.000593532, 0.000656928,
  0.000720247, 0.000783483, 0.000846628, 0.000909674, 0.000972616,
  0.00103544, 0.00109815, 0.00116073, 0.00122318, 0.00128549,
  0.00134765, 0.00140965, 0.00147149, 0.00153315, 0.00159465,
  0.00165595, 0.00171707, 0.00177799, 0.0018387, 0.0018992,
  0.00195949, 0.00201955, 0.00207937, 0.00213896, 0.0021983,
  0.00225738, 0.00231621, 0.00237477, 0.00243306, 0.00249107,
  0.00254879, 0.00260623, 0.00266336, 0.00272019, 0.0027767,
  0.0028329, 0.00288877, 0.00294431, 0.00299952, 0.00305438,
  0.00310889, 0.00316305, 0.00321685, 0.00327028, 0.00332333,
  0.00337601, 0.0034283, 0.0034802, 0.0035317, 0.0035828, 0.0036335,
  0.00368378, 0.00373364, 0.00378307, 0.00383207, 0.00388064,
  0.00392877, 0.00397645, 0.00402368, 0.00407045, 0.00411676,
  0.00416261, 0.00420798, 0.00425287, 0.00429728, 0.00434121,
  0.00438464, 0.00442758, 0.00447001, 0.00451194, 0.00455336,
  0.00459426, 0.00463465, 0.00467451, 0.00471384, 0.00475264,
  0.00479091, 0.00482863, 0.00486581, 0.00490244, 0.00493852,
  0.00497404, 0.005009, 0.00504339, 0.00507722, 0.00511048,
  0.00514316, 0.00517527, 0.00520679, 0.00523773, 0.00526808,
  0.00529783, 0.005327, 0.00535556, 0.00538353, 0.00541089,
  0.00543764, 0.00546378, 0.00548932, 0.00551423, 0.00553853,
  0.00556221, 0.00558527, 0.0056077, 0.00562951, 0.00565069,
  0.00567123, 0.00569114, 0.00571042, 0.00572906, 0.00574706,
  0.00576442, 0.00578113, 0.0057972, 0.00581263, 0.00582741,
  0.00584154, 0.00585501, 0.00586784, 0.00588002, 0.00589154,
  0.0059024, 0.00591261, 0.00592216, 0.00593106, 0.00593929,
  0.00594687, 0.00595378, 0.00596004, 0.00596564, 0.00597057,
  0.00597484, 0.00597845, 0.0059814, 0.00598369, 0.00598531,
  0.00598627, 0.00598657, 0.00598621, 0.00598518, 0.0059835,
  0.00598115, 0.00597814, 0.00597448, 0.00597015, 0.00596516,
  0.00595952, 0.00595322, 0.00594626, 0.00593865, 0.00593039,
  0.00592147, 0.0059119, 0.00590168, 0.00589081, 0.00587929,
  0.00586712, 0.00585431, 0.00584086, 0.00582676, 0.00581203,
  0.00579666, 0.00578065, 0.00576401, 0.00574673, 0.00572883,
  0.00571029, 0.00569113, 0.00567135, 0.00565095, 0.00562993,
  0.00560829, 0.00558604, 0.00556318, 0.0055397, 0.00551563,
  0.00549095, 0.00546567, 0.00543979, 0.00541333, 0.00538626,
  0.00535862, 0.00533038, 0.00530157, 0.00527218, 0.00524221,
  0.00521167, 0.00518057, 0.0051489, 0.00511667, 0.00508388,
  0.00505055, 0.00501666, 0.00498222, 0.00494725, 0.00491173,
  0.00487569, 0.00483911, 0.00480201, 0.00476439, 0.00472625,
  0.0046876, 0.00464844, 0.00460877, 0.00456861, 0.00452795,
  0.0044868, 0.00444517, 0.00440305, 0.00436046, 0.00431739,
  0.00427386, 0.00422987, 0.00418542, 0.00414052, 0.00409517,
  0.00404937, 0.00400315, 0.00395648, 0.0039094, 0.00386189,
  0.00381396, 0.00376562, 0.00371688, 0.00366774, 0.0036182,
  0.00356827, 0.00351795, 0.00346726, 0.0034162, 0.00336477,
  0.00331297, 0.00326082, 0.00320832, 0.00315548, 0.00310229,
  0.00304878, 0.00299493, 0.00294077, 0.00288629, 0.00283149,
  0.0027764, 0.00272101, 0.00266532, 0.00260935, 0.00255311,
  0.00249658, 0.00243979, 0.00238274, 0.00232544, 0.00226788,
  0.00221008, 0.00215205, 0.00209379, 0.0020353, 0.0019766,
  0.00191768, 0.00185856, 0.00179924, 0.00173973, 0.00168004,
  0.00162016, 0.00156011, 0.0014999, 0.00143952, 0.00137899,
  0.00131832, 0.00125751, 0.00119656, 0.00113548, 0.00107428,
  0.00101297, 0.000951553, 0.000890033, 0.000828419, 0.000766716,
  0.000704932, 0.000643073, 0.000581145, 0.000519157, 0.000457113,
  0.00039502, 0.000332886, 0.000270716, 0.000208518, 0.000146297,
  8.40612e-05, 2.18163e-05, -4.04308e-05, -0.000102674, -0.000164906,
  -0.00022712, -0.000289311, -0.00035147, -0.000413593, -0.000475672,
  -0.000537701, -0.000599672, -0.000661581, -0.000723419,
  -0.000785182, -0.000846861, -0.000908451, -0.000969945, -0.00103134,
  -0.00109262, -0.00115379, -0.00121483, -0.00127575, -0.00133654,
  -0.00139718, -0.00145767, -0.00151802, -0.0015782, -0.00163822,
  -0.00169806, -0.00175773, -0.00181721, -0.0018765, -0.00193559,
  -0.00199448, -0.00205316, -0.00211162, -0.00216986, -0.00222788,
  -0.00228566, -0.0023432, -0.0024005, -0.00245754, -0.00251433,
  -0.00257085, -0.0026271, -0.00268308, -0.00273878, -0.00279419,
  -0.0028493, -0.00290412, -0.00295864, -0.00301284, -0.00306673,
  -0.0031203, -0.00317355, -0.00322646, -0.00327904, -0.00333127,
  -0.00338315, -0.00343469, -0.00348586, -0.00353667, -0.00358711,
  -0.00363717, -0.00368686, -0.00373616, -0.00378508, -0.0038336,
  -0.00388171, -0.00392943, -0.00397673, -0.00402363, -0.0040701,
  -0.00411615, -0.00416177, -0.00420696, -0.00425171, -0.00429602,
  -0.00433988, -0.00438329, -0.00442624, -0.00446874, -0.00451077,
  -0.00455233, -0.00459342, -0.00463404, -0.00467417, -0.00471382,
  -0.00475298, -0.00479164, -0.00482981, -0.00486748, -0.00490464,
  -0.0049413, -0.00497745, -0.00501307, -0.00504818, -0.00508277,
  -0.00511683, -0.00515037, -0.00518336, -0.00521583, -0.00524775,
  -0.00527913, -0.00530997, -0.00534026, -0.00536999, -0.00539917,
  -0.0054278, -0.00545586, -0.00548336, -0.00551029, -0.00553666,
  -0.00556245, -0.00558767, -0.00561232, -0.00563639, -0.00565987,
  -0.00568277, -0.00570509, -0.00572682, -0.00574796, -0.00576851,
  -0.00578846, -0.00580782, -0.00582658, -0.00584474, -0.0058623,
  -0.00587926, -0.00589561, -0.00591136, -0.0059265, -0.00594103,
  -0.00595495, -0.00596826, -0.00598096, -0.00599304, -0.00600451,
  -0.00601536, -0.00602559, -0.00603521, -0.0060442, -0.00605258,
  -0.00606034, -0.00606748, -0.00607399, -0.00607988, -0.00608515,
  -0.0060898, -0.00609382, -0.00609722, -0.0061, -0.00610215,
  -0.00610367, -0.00610458, -0.00610485, -0.00610451, -0.00610354,
  -0.00610195, -0.00609973, -0.00609689, -0.00609343, -0.00608934,
  -0.00608463, -0.00607931, -0.00607336, -0.00606679, -0.00605961,
  -0.0060518, -0.00604338, -0.00603434, -0.00602469, -0.00601442,
  -0.00600354, -0.00599205, -0.00597995, -0.00596724, -0.00595392,
  -0.00594, -0.00592547, -0.00591033, -0.0058946, -0.00587827,
  -0.00586134, -0.00584381, -0.00582569, -0.00580698, -0.00578768,
  -0.00576779, -0.00574731, -0.00572625, -0.00570461, -0.00568239,
  -0.00565959, -0.00563622, -0.00561227, -0.00558776, -0.00556268,
  -0.00553703, -0.00551083, -0.00548406, -0.00545674, -0.00542887,
  -0.00540045, -0.00537147, -0.00534196, -0.00531191, -0.00528131,
  -0.00525018, -0.00521852, -0.00518634, -0.00515363, -0.00512039,
  -0.00508664, -0.00505238, -0.0050176, -0.00498232, -0.00494653,
  -0.00491024, -0.00487346, -0.00483618, -0.00479842, -0.00476017,
  -0.00472144, -0.00468224, -0.00464256, -0.00460241, -0.0045618,
  -0.00452073, -0.00447921, -0.00443723, -0.0043948, -0.00435193,
  -0.00430863, -0.00426488, -0.00422071, -0.00417612, -0.0041311,
  -0.00408567, -0.00403982, -0.00399357, -0.00394692, -0.00389987,
  -0.00385243, -0.0038046, -0.00375639, -0.0037078, -0.00365883,
  -0.0036095, -0.00355981, -0.00350976, -0.00345935, -0.0034086,
  -0.00335751, -0.00330608, -0.00325431, -0.00320222, -0.00314981,
  -0.00309709, -0.00304405, -0.0029907, -0.00293706, -0.00288312,
  -0.0028289, -0.00277439, -0.0027196, -0.00266454, -0.00260921,
  -0.00255362, -0.00249777, -0.00244168, -0.00238534, -0.00232876,
  -0.00227194, -0.00221491, -0.00215764, -0.00210017, -0.00204248,
  -0.00198459, -0.0019265, -0.00186821, -0.00180974, -0.00175109,
  -0.00169227, -0.00163327, -0.00157411, -0.0015148, -0.00145533,
  -0.00139572, -0.00133597, -0.00127608, -0.00121607, -0.00115594,
  -0.00109569, -0.00103533, -0.000974869, -0.000914311, -0.00085366,
  -0.000792925, -0.000732111, -0.000671223, -0.000610269,
  -0.000549254, -0.000488184, -0.000427066, -0.000365905,
  -0.000304707, -0.000243479, -0.000182227, -0.000120957,
  -5.96745e-05, 1.61377e-06, 6.29019e-05, 0.000124184, 0.000185453,
  0.000246704, 0.000307931, 0.000369127, 0.000430286, 0.000491403,
  0.000552471, 0.000613483, 0.000674435, 0.00073532, 0.000796132,
  0.000856865, 0.000917512, 0.000978069, 0.00103853, 0.00109888,
  0.00115913, 0.00121926, 0.00127928, 0.00133916, 0.00139891,
  0.00145852, 0.00151799, 0.00157731, 0.00163647, 0.00169547,
  0.0017543, 0.00181296, 0.00187144, 0.00192973, 0.00198783,
  0.00204573, 0.00210343, 0.00216093, 0.00221821, 0.00227527,
  0.0023321, 0.0023887, 0.00244507, 0.0025012, 0.00255708, 0.0026127,
  0.00266807, 0.00272317, 0.002778, 0.00283256, 0.00288684,
  0.00294083, 0.00299454, 0.00304794, 0.00310105, 0.00315385,
  0.00320634, 0.00325851, 0.00331036, 0.00336188, 0.00341307,
  0.00346392, 0.00351444, 0.0035646, 0.00361441, 0.00366387,
  0.00371297, 0.00376169, 0.00381005, 0.00385804, 0.00390564,
  0.00395285, 0.00399968, 0.00404611, 0.00409215, 0.00413778,
  0.004183, 0.00422781, 0.00427221, 0.00431618, 0.00435973,
  0.00440285, 0.00444554, 0.00448778, 0.00452959, 0.00457095,
  0.00461186, 0.00465232, 0.00469232, 0.00473186, 0.00477093,
  0.00480953, 0.00484766, 0.00488532, 0.00492249, 0.00495918,
  0.00499538, 0.00503109, 0.00506631, 0.00510103, 0.00513524,
  0.00516896, 0.00520216, 0.00523486, 0.00526704, 0.0052987,
  0.00532984, 0.00536046, 0.00539056, 0.00542012, 0.00544915,
  0.00547765, 0.00550561, 0.00553303, 0.00555991, 0.00558624,
  0.00561202, 0.00563726, 0.00566194, 0.00568606, 0.00570963,
  0.00573264, 0.00575509, 0.00577697, 0.00579829, 0.00581904,
  0.00583922, 0.00585882, 0.00587786, 0.00589631, 0.00591419,
  0.00593149, 0.00594821, 0.00596435, 0.00597991, 0.00599488,
  0.00600926, 0.00602305, 0.00603626, 0.00604887, 0.00606089,
  0.00607232, 0.00608316, 0.0060934, 0.00610304, 0.00611209,
  0.00612054, 0.00612839, 0.00613565, 0.0061423, 0.00614836,
  0.00615381, 0.00615866, 0.00616291, 0.00616656, 0.0061696,
  0.00617204, 0.00617388, 0.00617512, 0.00617576, 0.00617579,
  0.00617522, 0.00617404, 0.00617226, 0.00616988, 0.0061669,
  0.00616332, 0.00615914, 0.00615435, 0.00614896, 0.00614298,
  0.00613639, 0.00612921, 0.00612143, 0.00611305, 0.00610408,
  0.00609451, 0.00608435, 0.00607359, 0.00606224, 0.00605031,
  0.00603778, 0.00602466, 0.00601096, 0.00599667, 0.0059818,
  0.00596634, 0.00595031, 0.00593369, 0.0059165, 0.00589873,
  0.00588038, 0.00586147, 0.00584198, 0.00582193, 0.0058013,
  0.00578012, 0.00575837, 0.00573606, 0.00571319, 0.00568977,
  0.00566579, 0.00564126, 0.00561619, 0.00559057, 0.0055644,
  0.00553769, 0.00551045, 0.00548267, 0.00545435, 0.00542551,
  0.00539614, 0.00536624, 0.00533582, 0.00530489, 0.00527344,
  0.00524147, 0.005209, 0.00517602, 0.00514254, 0.00510856,
  0.00507408, 0.00503911, 0.00500365, 0.00496771, 0.00493128,
  0.00489437, 0.00485699, 0.00481914, 0.00478082, 0.00474204,
  0.00470279, 0.00466309, 0.00462294, 0.00458234, 0.00454129,
  0.0044998, 0.00445788, 0.00441552, 0.00437274, 0.00432953,
  0.0042859, 0.00424186, 0.00419741, 0.00415255, 0.00410728,
  0.00406162, 0.00401556, 0.00396912, 0.00392229, 0.00387508,
  0.00382749, 0.00377954, 0.00373121, 0.00368253, 0.00363349,
  0.0035841, 0.00353436, 0.00348428, 0.00343386, 0.0033831,
  0.00333202, 0.00328062, 0.0032289, 0.00317687, 0.00312453,
  0.00307189, 0.00301895, 0.00296572, 0.0029122, 0.0028584,
  0.00280432, 0.00274997, 0.00269535, 0.00264048, 0.00258535,
  0.00252996, 0.00247434, 0.00241847, 0.00236237, 0.00230605,
  0.00224949, 0.00219273, 0.00213575, 0.00207856, 0.00202117,
  0.00196359, 0.00190581, 0.00184786, 0.00178972, 0.00173141,
  0.00167293, 0.0016143, 0.0015555, 0.00149656, 0.00143747,
  0.00137824, 0.00131888, 0.00125939, 0.00119978, 0.00114005,
  0.00108022, 0.00102027, 0.000960235, 0.000900103, 0.000839884,
  0.000779584, 0.000719209, 0.000658764, 0.000598256, 0.000537689,
  0.000477071, 0.000416407, 0.000355703, 0.000294964, 0.000234197,
  0.000173407, 0.000112601, 5.17833e-05, -9.03903e-06, -6.98605e-05,
  -0.000130675, -0.000191477, -0.000252261, -0.00031302, -0.000373749,
  -0.000434442, -0.000495093, -0.000555696, -0.000616246,
  -0.000676736, -0.000737161, -0.000797514, -0.000857791,
  -0.000917985, -0.000978091, -0.0010381, -0.00109801, -0.00115782,
  -0.00121751, -0.00127709, -0.00133654, -0.00139586, -0.00145505,
  -0.0015141, -0.00157301, -0.00163176, -0.00169035, -0.00174878,
  -0.00180704, -0.00186513, -0.00192304, -0.00198076, -0.0020383,
  -0.00209563, -0.00215277, -0.00220969, -0.00226641, -0.0023229,
  -0.00237917, -0.00243521, -0.00249102, -0.00254659, -0.00260191,
  -0.00265698, -0.0027118, -0.00276635, -0.00282064, -0.00287465,
  -0.00292839, -0.00298185, -0.00303502, -0.00308789, -0.00314047,
  -0.00319275, -0.00324472, -0.00329638, -0.00334772, -0.00339873,
  -0.00344942, -0.00349978, -0.0035498, -0.00359948, -0.00364881,
  -0.00369779, -0.00374642, -0.00379468, -0.00384258, -0.00389011,
  -0.00393727, -0.00398404, -0.00403043, -0.00407644, -0.00412205,
  -0.00416726, -0.00421208, -0.00425648, -0.00430048, -0.00434407,
  -0.00438723, -0.00442998, -0.00447229, -0.00451418, -0.00455563,
  -0.00459665, -0.00463722, -0.00467735, -0.00471702, -0.00475624,
  -0.00479501, -0.00483331, -0.00487115, -0.00490852, -0.00494541,
  -0.00498183, -0.00501778, -0.00505323, -0.00508821, -0.00512269,
  -0.00515668, -0.00519017, -0.00522317, -0.00525566, -0.00528765,
  -0.00531912, -0.00535009, -0.00538054, -0.00541048, -0.00543989,
  -0.00546878, -0.00549714, -0.00552498, -0.00555228, -0.00557905,
  -0.00560529, -0.00563098, -0.00565613, -0.00568074, -0.0057048,
  -0.00572832, -0.00575128, -0.00577369, -0.00579554, -0.00581684,
  -0.00583758, -0.00585775, -0.00587736, -0.00589641, -0.00591489,
  -0.0059328, -0.00595014, -0.00596691, -0.00598311, -0.00599873,
  -0.00601377, -0.00602823, -0.00604212, -0.00605542, -0.00606814,
  -0.00608028, -0.00609183, -0.0061028, -0.00611318, -0.00612297,
  -0.00613218, -0.00614079, -0.00614882, -0.00615625, -0.00616309,
  -0.00616934, -0.00617499, -0.00618005, -0.00618452, -0.00618839,
  -0.00619167, -0.00619435, -0.00619643, -0.00619792, -0.00619882,
  -0.00619912, -0.00619882, -0.00619792, -0.00619643, -0.00619435,
  -0.00619167, -0.00618839, -0.00618452, -0.00618005, -0.00617499,
  -0.00616934, -0.00616309, -0.00615625, -0.00614882, -0.00614079,
  -0.00613218, -0.00612297, -0.00611318, -0.0061028, -0.00609183,
  -0.00608028, -0.00606814, -0.00605542, -0.00604212, -0.00602823,
  -0.00601377, -0.00599873, -0.00598311, -0.00596691, -0.00595014,
  -0.0059328, -0.00591489, -0.00589641, -0.00587736, -0.00585775,
  -0.00583758, -0.00581684, -0.00579554, -0.00577369, -0.00575128,
  -0.00572832, -0.0057048, -0.00568074, -0.00565613, -0.00563098,
  -0.00560529, -0.00557905, -0.00555228, -0.00552498, -0.00549714,
  -0.00546878, -0.00543989, -0.00541048, -0.00538054, -0.00535009,
  -0.00531912, -0.00528765, -0.00525566, -0.00522317, -0.00519017,
  -0.00515668, -0.00512269, -0.00508821, -0.00505323, -0.00501778,
  -0.00498183, -0.00494541, -0.00490852, -0.00487115, -0.00483331,
  -0.00479501, -0.00475624, -0.00471702, -0.00467735, -0.00463722,
  -0.00459665, -0.00455563, -0.00451418, -0.00447229, -0.00442998,
  -0.00438723, -0.00434407, -0.00430048, -0.00425648, -0.00421208,
  -0.00416726, -0.00412205, -0.00407644, -0.00403043, -0.00398404,
  -0.00393727, -0.00389011, -0.00384258, -0.00379468, -0.00374642,
  -0.00369779, -0.00364881, -0.00359948, -0.0035498, -0.00349978,
  -0.00344942, -0.00339873, -0.00334772, -0.00329638, -0.00324472,
  -0.00319275, -0.00314047, -0.00308789, -0.00303502, -0.00298185,
  -0.00292839, -0.00287465, -0.00282064, -0.00276635, -0.0027118,
  -0.00265698, -0.00260191, -0.00254659, -0.00249102, -0.00243521,
  -0.00237917, -0.0023229, -0.00226641, -0.00220969, -0.00215277,
  -0.00209563, -0.0020383, -0.00198076, -0.00192304, -0.00186513,
  -0.00180704, -0.00174878, -0.00169035, -0.00163176, -0.00157301,
  -0.0015141, -0.00145505, -0.00139586, -0.00133654, -0.00127709,
  -0.00121751, -0.00115782, -0.00109801, -0.0010381, -0.000978091,
  -0.000917985, -0.000857791, -0.000797514, -0.000737161,
  -0.000676736, -0.000616246, -0.000555696, -0.000495093,
  -0.000434442, -0.000373749, -0.00031302, -0.000252261, -0.000191477,
  -0.000130675, -6.98605e-05, -9.03903e-06, 5.17833e-05, 0.000112601,
  0.000173407, 0.000234197, 0.000294964, 0.000355703, 0.000416407,
  0.000477071, 0.000537689, 0.000598256, 0.000658764, 0.000719209,
  0.000779584, 0.000839884, 0.000900103, 0.000960235, 0.00102027,
  0.00108022, 0.00114005, 0.00119978, 0.00125939, 0.00131888,
  0.00137824, 0.00143747, 0.00149656, 0.0015555, 0.0016143,
  0.00167293, 0.00173141, 0.00178972, 0.00184786, 0.00190581,
  0.00196359, 0.00202117, 0.00207856, 0.00213575, 0.00219273,
  0.00224949, 0.00230605, 0.00236237, 0.00241847, 0.00247434,
  0.00252996, 0.00258535, 0.00264048, 0.00269535, 0.00274997,
  0.00280432, 0.0028584, 0.0029122, 0.00296572, 0.00301895,
  0.00307189, 0.00312453, 0.00317687, 0.0032289, 0.00328062,
  0.00333202, 0.0033831, 0.00343386, 0.00348428, 0.00353436,
  0.0035841, 0.00363349, 0.00368253, 0.00373121, 0.00377954,
  0.00382749, 0.00387508, 0.00392229, 0.00396912, 0.00401556,
  0.00406162, 0.00410728, 0.00415255, 0.00419741, 0.00424186,
  0.0042859, 0.00432953, 0.00437274, 0.00441552, 0.00445788,
  0.0044998, 0.00454129, 0.00458234, 0.00462294, 0.00466309,
  0.00470279, 0.00474204, 0.00478082, 0.00481914, 0.00485699,
  0.00489437, 0.00493128, 0.00496771, 0.00500365, 0.00503911,
  0.00507408, 0.00510856, 0.00514254, 0.00517602, 0.005209,
  0.00524147, 0.00527344, 0.00530489, 0.00533582, 0.00536624,
  0.00539614, 0.00542551, 0.00545435, 0.00548267, 0.00551045,
  0.00553769, 0.0055644, 0.00559057, 0.00561619, 0.00564126,
  0.00566579, 0.00568977, 0.00571319, 0.00573606, 0.00575837,
  0.00578012, 0.0058013, 0.00582193, 0.00584198, 0.00586147,
  0.00588038, 0.00589873, 0.0059165, 0.00593369, 0.00595031,
  0.00596634, 0.0059818, 0.00599667, 0.00601096, 0.00602466,
  0.00603778, 0.00605031, 0.00606224, 0.00607359, 0.00608435,
  0.00609451, 0.00610408, 0.00611305, 0.00612143, 0.00612921,
  0.00613639, 0.00614298, 0.00614896, 0.00615435, 0.00615914,
  0.00616332, 0.0061669, 0.00616988, 0.00617226, 0.00617404,
  0.00617522, 0.00617579, 0.00617576, 0.00617512, 0.00617388,
  0.00617204, 0.0061696, 0.00616656, 0.00616291, 0.00615866,
  0.00615381, 0.00614836, 0.0061423, 0.00613565, 0.00612839,
  0.00612054, 0.00611209, 0.00610304, 0.0060934, 0.00608316,
  0.00607232, 0.00606089, 0.00604887, 0.00603626, 0.00602305,
  0.00600926, 0.00599488, 0.00597991, 0.00596435, 0.00594821,
  0.00593149, 0.00591419, 0.00589631, 0.00587786, 0.00585882,
  0.00583922, 0.00581904, 0.00579829, 0.00577697, 0.00575509,
  0.00573264, 0.00570963, 0.00568606, 0.00566194, 0.00563726,
  0.00561202, 0.00558624, 0.00555991, 0.00553303, 0.00550561,
  0.00547765, 0.00544915, 0.00542012, 0.00539056, 0.00536046,
  0.00532984, 0.0052987, 0.00526704, 0.00523486, 0.00520216,
  0.00516896, 0.00513524, 0.00510103, 0.00506631, 0.00503109,
  0.00499538, 0.00495918, 0.00492249, 0.00488532, 0.00484766,
  0.00480953, 0.00477093, 0.00473186, 0.00469232, 0.00465232,
  0.00461186, 0.00457095, 0.00452959, 0.00448778, 0.00444554,
  0.00440285, 0.00435973, 0.00431618, 0.00427221, 0.00422781,
  0.004183, 0.00413778, 0.00409215, 0.00404611, 0.00399968,
  0.00395285, 0.00390564, 0.00385804, 0.00381005, 0.00376169,
  0.00371297, 0.00366387, 0.00361441, 0.0035646, 0.00351444,
  0.00346392, 0.00341307, 0.00336188, 0.00331036, 0.00325851,
  0.00320634, 0.00315385, 0.00310105, 0.00304794, 0.00299454,
  0.00294083, 0.00288684, 0.00283256, 0.002778, 0.00272317,
  0.00266807, 0.0026127, 0.00255708, 0.0025012, 0.00244507, 0.0023887,
  0.0023321, 0.00227527, 0.00221821, 0.00216093, 0.00210343,
  0.00204573, 0.00198783, 0.00192973, 0.00187144, 0.00181296,
  0.0017543, 0.00169547, 0.00163647, 0.00157731, 0.00151799,
  0.00145852, 0.00139891, 0.00133916, 0.00127928, 0.00121926,
  0.00115913, 0.00109888, 0.00103853, 0.000978069, 0.000917512,
  0.000856865, 0.000796132, 0.00073532, 0.000674435, 0.000613483,
  0.000552471, 0.000491403, 0.000430286, 0.000369127, 0.000307931,
  0.000246704, 0.000185453, 0.000124184, 6.29019e-05, 1.61377e-06,
  -5.96745e-05, -0.000120957, -0.000182227, -0.000243479,
  -0.000304707, -0.000365905, -0.000427066, -0.000488184,
  -0.000549254, -0.000610269, -0.000671223, -0.000732111,
  -0.000792925, -0.00085366, -0.000914311, -0.000974869, -0.00103533,
  -0.00109569, -0.00115594, -0.00121607, -0.00127608, -0.00133597,
  -0.00139572, -0.00145533, -0.0015148, -0.00157411, -0.00163327,
  -0.00169227, -0.00175109, -0.00180974, -0.00186821, -0.0019265,
  -0.00198459, -0.00204248, -0.00210017, -0.00215764, -0.00221491,
  -0.00227194, -0.00232876, -0.00238534, -0.00244168, -0.00249777,
  -0.00255362, -0.00260921, -0.00266454, -0.0027196, -0.00277439,
  -0.0028289, -0.00288312, -0.00293706, -0.0029907, -0.00304405,
  -0.00309709, -0.00314981, -0.00320222, -0.00325431, -0.00330608,
  -0.00335751, -0.0034086, -0.00345935, -0.00350976, -0.00355981,
  -0.0036095, -0.00365883, -0.0037078, -0.00375639, -0.0038046,
  -0.00385243, -0.00389987, -0.00394692, -0.00399357, -0.00403982,
  -0.00408567, -0.0041311, -0.00417612, -0.00422071, -0.00426488,
  -0.00430863, -0.00435193, -0.0043948, -0.00443723, -0.00447921,
  -0.00452073, -0.0045618, -0.00460241, -0.00464256, -0.00468224,
  -0.00472144, -0.00476017, -0.00479842, -0.00483618, -0.00487346,
  -0.00491024, -0.00494653, -0.00498232, -0.0050176, -0.00505238,
  -0.00508664, -0.00512039, -0.00515363, -0.00518634, -0.00521852,
  -0.00525018, -0.00528131, -0.00531191, -0.00534196, -0.00537147,
  -0.00540045, -0.00542887, -0.00545674, -0.00548406, -0.00551083,
  -0.00553703, -0.00556268, -0.00558776, -0.00561227, -0.00563622,
  -0.00565959, -0.00568239, -0.00570461, -0.00572625, -0.00574731,
  -0.00576779, -0.00578768, -0.00580698, -0.00582569, -0.00584381,
  -0.00586134, -0.00587827, -0.0058946, -0.00591033, -0.00592547,
  -0.00594, -0.00595392, -0.00596724, -0.00597995, -0.00599205,
  -0.00600354, -0.00601442, -0.00602469, -0.00603434, -0.00604338,
  -0.0060518, -0.00605961, -0.00606679, -0.00607336, -0.00607931,
  -0.00608463, -0.00608934, -0.00609343, -0.00609689, -0.00609973,
  -0.00610195, -0.00610354, -0.00610451, -0.00610485, -0.00610458,
  -0.00610367, -0.00610215, -0.0061, -0.00609722, -0.00609382,
  -0.0060898, -0.00608515, -0.00607988, -0.00607399, -0.00606748,
  -0.00606034, -0.00605258, -0.0060442, -0.00603521, -0.00602559,
  -0.00601536, -0.00600451, -0.00599304, -0.00598096, -0.00596826,
  -0.00595495, -0.00594103, -0.0059265, -0.00591136, -0.00589561,
  -0.00587926, -0.0058623, -0.00584474, -0.00582658, -0.00580782,
  -0.00578846, -0.00576851, -0.00574796, -0.00572682, -0.00570509,
  -0.00568277, -0.00565987, -0.00563639, -0.00561232, -0.00558767,
  -0.00556245, -0.00553666, -0.00551029, -0.00548336, -0.00545586,
  -0.0054278, -0.00539917, -0.00536999, -0.00534026, -0.00530997,
  -0.00527913, -0.00524775, -0.00521583, -0.00518336, -0.00515037,
  -0.00511683, -0.00508277, -0.00504818, -0.00501307, -0.00497745,
  -0.0049413, -0.00490464, -0.00486748, -0.00482981, -0.00479164,
  -0.00475298, -0.00471382, -0.00467417, -0.00463404, -0.00459342,
  -0.00455233, -0.00451077, -0.00446874, -0.00442624, -0.00438329,
  -0.00433988, -0.00429602, -0.00425171, -0.00420696, -0.00416177,
  -0.00411615, -0.0040701, -0.00402363, -0.00397673, -0.00392943,
  -0.00388171, -0.0038336, -0.00378508, -0.00373616, -0.00368686,
  -0.00363717, -0.00358711, -0.00353667, -0.00348586, -0.00343469,
  -0.00338315, -0.00333127, -0.00327904, -0.00322646, -0.00317355,
  -0.0031203, -0.00306673, -0.00301284, -0.00295864, -0.00290412,
  -0.0028493, -0.00279419, -0.00273878, -0.00268308, -0.0026271,
  -0.00257085, -0.00251433, -0.00245754, -0.0024005, -0.0023432,
  -0.00228566, -0.00222788, -0.00216986, -0.00211162, -0.00205316,
  -0.00199448, -0.00193559, -0.0018765, -0.00181721, -0.00175773,
  -0.00169806, -0.00163822, -0.0015782, -0.00151802, -0.00145767,
  -0.00139718, -0.00133654, -0.00127575, -0.00121483, -0.00115379,
  -0.00109262, -0.00103134, -0.000969945, -0.000908451, -0.000846861,
  -0.000785182, -0.000723419, -0.000661581, -0.000599672,
  -0.000537701, -0.000475672, -0.000413593, -0.00035147, -0.000289311,
  -0.00022712, -0.000164906, -0.000102674, -4.04308e-05, 2.18163e-05,
  8.40612e-05, 0.000146297, 0.000208518, 0.000270716, 0.000332886,
  0.00039502, 0.000457113, 0.000519157, 0.000581145, 0.000643073,
  0.000704932, 0.000766716, 0.000828419, 0.000890033, 0.000951553,
  0.00101297, 0.00107428, 0.00113548, 0.00119656, 0.00125751,
  0.00131832, 0.00137899, 0.00143952, 0.0014999, 0.00156011,
  0.00162016, 0.00168004, 0.00173973, 0.00179924, 0.00185856,
  0.00191768, 0.0019766, 0.0020353, 0.00209379, 0.00215205,
  0.00221008, 0.00226788, 0.00232544, 0.00238274, 0.00243979,
  0.00249658, 0.00255311, 0.00260935, 0.00266532, 0.00272101,
  0.0027764, 0.00283149, 0.00288629, 0.00294077, 0.00299493,
  0.00304878, 0.00310229, 0.00315548, 0.00320832, 0.00326082,
  0.00331297, 0.00336477, 0.0034162, 0.00346726, 0.00351795,
  0.00356827, 0.0036182, 0.00366774, 0.00371688, 0.00376562,
  0.00381396, 0.00386189, 0.0039094, 0.00395648, 0.00400315,
  0.00404937, 0.00409517, 0.00414052, 0.00418542, 0.00422987,
  0.00427386, 0.00431739, 0.00436046, 0.00440305, 0.00444517,
  0.0044868, 0.00452795, 0.00456861, 0.00460877, 0.00464844,
  0.0046876, 0.00472625, 0.00476439, 0.00480201, 0.00483911,
  0.00487569, 0.00491173, 0.00494725, 0.00498222, 0.00501666,
  0.00505055, 0.00508388, 0.00511667, 0.0051489, 0.00518057,
  0.00521167, 0.00524221, 0.00527218, 0.00530157, 0.00533038,
  0.00535862, 0.00538626, 0.00541333, 0.00543979, 0.00546567,
  0.00549095, 0.00551563, 0.0055397, 0.00556318, 0.00558604,
  0.00560829, 0.00562993, 0.00565095, 0.00567135, 0.00569113,
  0.00571029, 0.00572883, 0.00574673, 0.00576401, 0.00578065,
  0.00579666, 0.00581203, 0.00582676, 0.00584086, 0.00585431,
  0.00586712, 0.00587929, 0.00589081, 0.00590168, 0.0059119,
  0.00592147, 0.00593039, 0.00593865, 0.00594626, 0.00595322,
  0.00595952, 0.00596516, 0.00597015, 0.00597448, 0.00597814,
  0.00598115, 0.0059835, 0.00598518, 0.00598621, 0.00598657,
  0.00598627, 0.00598531, 0.00598369, 0.0059814, 0.00597845,
  0.00597484, 0.00597057, 0.00596564, 0.00596004, 0.00595378,
  0.00594687, 0.00593929, 0.00593106, 0.00592216, 0.00591261,
  0.0059024, 0.00589154, 0.00588002, 0.00586784, 0.00585501,
  0.00584154, 0.00582741, 0.00581263, 0.0057972, 0.00578113,
  0.00576442, 0.00574706, 0.00572906, 0.00571042, 0.00569114,
  0.00567123, 0.00565069, 0.00562951, 0.0056077, 0.00558527,
  0.00556221, 0.00553853, 0.00551423, 0.00548932, 0.00546378,
  0.00543764, 0.00541089, 0.00538353, 0.00535556, 0.005327,
  0.00529783, 0.00526808, 0.00523773, 0.00520679, 0.00517527,
  0.00514316, 0.00511048, 0.00507722, 0.00504339, 0.005009,
  0.00497404, 0.00493852, 0.00490244, 0.00486581, 0.00482863,
  0.00479091, 0.00475264, 0.00471384, 0.00467451, 0.00463465,
  0.00459426, 0.00455336, 0.00451194, 0.00447001, 0.00442758,
  0.00438464, 0.00434121, 0.00429728, 0.00425287, 0.00420798,
  0.00416261, 0.00411676, 0.00407045, 0.00402368, 0.00397645,
  0.00392877, 0.00388064, 0.00383207, 0.00378307, 0.00373364,
  0.00368378, 0.0036335, 0.0035828, 0.0035317, 0.0034802, 0.0034283,
  0.00337601, 0.00332333, 0.00327028, 0.00321685, 0.00316305,
  0.00310889, 0.00305438, 0.00299952, 0.00294431, 0.00288877,
  0.0028329, 0.0027767, 0.00272019, 0.00266336, 0.00260623,
  0.00254879, 0.00249107, 0.00243306, 0.00237477, 0.00231621,
  0.00225738, 0.0021983, 0.00213896, 0.00207937, 0.00201955,
  0.00195949, 0.0018992, 0.0018387, 0.00177799, 0.00171707,
  0.00165595, 0.00159465, 0.00153315, 0.00147149, 0.00140965,
  0.00134765, 0.00128549, 0.00122318, 0.00116073, 0.00109815,
  0.00103544, 0.000972616, 0.000909674, 0.000846628, 0.000783483,
  0.000720247, 0.000656928, 0.000593532, 0.000530068, 0.000466542,
  0.000402962, 0.000339335, 0.000275668, 0.00021197, 0.000148247,
  8.45063e-05, 2.0756e-05, -4.29966e-05, -0.000106744, -0.000170479,
  -0.000234195, -0.000297882, -0.000361535, -0.000425146,
  -0.000488707, -0.000552212, -0.000615651, -0.000679018,
  -0.000742306, -0.000805507, -0.000868614, -0.000931619,
  -0.000994514, -0.00105729, -0.00111995, -0.00118247, -0.00124486,
  -0.0013071, -0.00136918, -0.0014311, -0.00149286, -0.00155444,
  -0.00161584, -0.00167704, -0.00173805, -0.00179886, -0.00185945,
  -0.00191982, -0.00197997, -0.00203988, -0.00209956, -0.00215898,
  -0.00221815, -0.00227706, -0.00233569, -0.00239406, -0.00245213,
  -0.00250992, -0.00256741, -0.0026246, -0.00268147, -0.00273803,
  -0.00279426, -0.00285016, -0.00290572, -0.00296094, -0.0030158,
  -0.00307031, -0.00312445, -0.00317822, -0.00323161, -0.00328462,
  -0.00333723, -0.00338945, -0.00344126, -0.00349267, -0.00354365,
  -0.00359421, -0.00364435, -0.00369404, -0.0037433, -0.00379211,
  -0.00384046, -0.00388836, -0.00393579, -0.00398274, -0.00402923,
  -0.00407522, -0.00412073, -0.00416575, -0.00421026, -0.00425427,
  -0.00429776, -0.00434075, -0.0043832, -0.00442514, -0.00446653,
  -0.00450739, -0.00454771, -0.00458748, -0.0046267, -0.00466536,
  -0.00470345, -0.00474098, -0.00477793, -0.00481431, -0.00485011,
  -0.00488532, -0.00491994, -0.00495396, -0.00498738, -0.0050202,
  -0.00505241, -0.00508401, -0.00511499, -0.00514535, -0.00517508,
  -0.00520419, -0.00523266, -0.0052605, -0.0052877, -0.00531425,
  -0.00534016, -0.00536541, -0.00539002, -0.00541396, -0.00543725,
  -0.00545987, -0.00548183, -0.00550311, -0.00552373, -0.00554367,
  -0.00556293, -0.00558151, -0.0055994, -0.00561661, -0.00563314,
  -0.00564897, -0.00566411, -0.00567856, -0.0056923, -0.00570535,
  -0.0057177, -0.00572935, -0.00574029, -0.00575052, -0.00576005,
  -0.00576887, -0.00577697, -0.00578437, -0.00579105, -0.00579702,
  -0.00580227, -0.00580681, -0.00581063, -0.00581373, -0.00581611,
  -0.00581777, -0.00581871, -0.00581893, -0.00581843, -0.00581721,
  -0.00581527, -0.00581261, -0.00580922, -0.00580512, -0.00580029,
  -0.00579474, -0.00578847, -0.00578148, -0.00577377, -0.00576535,
  -0.0057562, -0.00574634, -0.00573576, -0.00572446, -0.00571245,
  -0.00569973, -0.00568629, -0.00567215, -0.00565729, -0.00564173,
  -0.00562546, -0.00560848, -0.00559081, -0.00557243, -0.00555335,
  -0.00553358, -0.00551311, -0.00549195, -0.0054701, -0.00544756,
  -0.00542434, -0.00540043, -0.00537584, -0.00535058, -0.00532464,
  -0.00529803, -0.00527075, -0.00524281, -0.0052142, -0.00518494,
  -0.00515502, -0.00512445, -0.00509323, -0.00506136, -0.00502886,
  -0.00499571, -0.00496194, -0.00492753, -0.0048925, -0.00485685,
  -0.00482058, -0.00478369, -0.0047462, -0.00470811, -0.00466941,
  -0.00463013, -0.00459025, -0.00454978, -0.00450874, -0.00446712,
  -0.00442493, -0.00438217, -0.00433886, -0.00429499, -0.00425057,
  -0.0042056, -0.0041601, -0.00411406, -0.0040675, -0.00402042,
  -0.00397281, -0.0039247, -0.00387609, -0.00382698, -0.00377737,
  -0.00372728, -0.00367671, -0.00362566, -0.00357415, -0.00352218,
  -0.00346975, -0.00341687, -0.00336356, -0.0033098, -0.00325562,
  -0.00320102, -0.00314601, -0.00309059, -0.00303477, -0.00297855,
  -0.00292195, -0.00286497, -0.00280761, -0.0027499, -0.00269182,
  -0.0026334, -0.00257463, -0.00251553, -0.0024561, -0.00239635,
  -0.00233628, -0.00227592, -0.00221525, -0.0021543, -0.00209306,
  -0.00203155, -0.00196978, -0.00190774, -0.00184546, -0.00178294,
  -0.00172018, -0.0016572, -0.001594, -0.00153059, -0.00146698,
  -0.00140317, -0.00133918, -0.00127502, -0.00121068, -0.00114619,
  -0.00108155, -0.00101676, -0.000951844, -0.000886798, -0.000821635,
  -0.000756364, -0.000690992, -0.00062553, -0.000559984, -0.000494364,
  -0.000428679, -0.000362936, -0.000297146, -0.000231316,
  -0.000165455, -9.95729e-05, -3.3677e-05, 3.22233e-05, 9.81194e-05,
  0.000164002, 0.000229864, 0.000295694, 0.000361485, 0.000427228,
  0.000492914, 0.000558534, 0.000624079, 0.000689541, 0.000754911,
  0.000820179, 0.000885338, 0.000950378, 0.00101529, 0.00108007,
  0.0011447, 0.00120917, 0.00127349, 0.00133763, 0.0014016,
  0.00146537, 0.00152895, 0.00159232, 0.00165547, 0.00171841,
  0.00178111, 0.00184357, 0.00190578, 0.00196773, 0.00202941,
  0.00209082, 0.00215195, 0.00221279, 0.00227332, 0.00233355,
  0.00239346, 0.00245304, 0.00251229, 0.0025712, 0.00262976,
  0.00268796, 0.00274579, 0.00280325, 0.00286032, 0.00291701,
  0.0029733, 0.00302917, 0.00308464, 0.00313968, 0.00319429,
  0.00324847, 0.0033022, 0.00335547, 0.00340829, 0.00346063,
  0.0035125, 0.00356389, 0.00361479, 0.00366519, 0.00371508,
  0.00376446, 0.00381332, 0.00386165, 0.00390945, 0.00395672,
  0.00400343, 0.00404959, 0.00409518, 0.00414021, 0.00418467,
  0.00422854, 0.00427183, 0.00431453, 0.00435662, 0.00439811,
  0.00443899, 0.00447924, 0.00451888, 0.00455788, 0.00459625,
  0.00463397, 0.00467105, 0.00470747, 0.00474324, 0.00477834,
  0.00481278, 0.00484653, 0.00487961, 0.00491201, 0.00494371,
  0.00497472, 0.00500503, 0.00503463, 0.00506353, 0.00509171,
  0.00511918, 0.00514592, 0.00517194, 0.00519723, 0.00522178,
  0.00524559, 0.00526866, 0.00529099, 0.00531256, 0.00533339,
  0.00535345, 0.00537276, 0.0053913, 0.00540907, 0.00542608,
  0.00544232, 0.00545778, 0.00547246, 0.00548636, 0.00549948,
  0.00551181, 0.00552335, 0.00553411, 0.00554407, 0.00555324,
  0.00556162, 0.00556919, 0.00557597, 0.00558195, 0.00558713,
  0.0055915, 0.00559507, 0.00559783, 0.00559979, 0.00560094,
  0.00560128, 0.00560081, 0.00559954, 0.00559746, 0.00559456,
  0.00559086, 0.00558635, 0.00558103, 0.00557489, 0.00556795,
  0.00556021, 0.00555165, 0.00554229, 0.00553212, 0.00552114,
  0.00550936, 0.00549678, 0.0054834, 0.00546921, 0.00545423,
  0.00543845, 0.00542187, 0.0054045, 0.00538634, 0.00536739,
  0.00534765, 0.00532713, 0.00530582, 0.00528374, 0.00526087,
  0.00523724, 0.00521283, 0.00518765, 0.00516171, 0.00513501,
  0.00510755, 0.00507933, 0.00505036, 0.00502064, 0.00499018,
  0.00495899, 0.00492705, 0.00489439, 0.00486099, 0.00482688,
  0.00479204, 0.0047565, 0.00472024, 0.00468328, 0.00464563,
  0.00460728, 0.00456824, 0.00452852, 0.00448812, 0.00444705,
  0.00440531, 0.00436291, 0.00431986, 0.00427616, 0.00423182,
  0.00418684, 0.00414123, 0.00409499, 0.00404814, 0.00400068,
  0.00395262, 0.00390396, 0.00385471, 0.00380488, 0.00375447,
  0.00370349, 0.00365195, 0.00359986, 0.00354722, 0.00349404,
  0.00344033, 0.0033861, 0.00333135, 0.0032761, 0.00322034, 0.0031641,
  0.00310737, 0.00305016, 0.00299249, 0.00293437, 0.00287579,
  0.00281677, 0.00275732, 0.00269745, 0.00263716, 0.00257647,
  0.00251538, 0.0024539, 0.00239205, 0.00232983, 0.00226724,
  0.00220431, 0.00214104, 0.00207743, 0.00201351, 0.00194927,
  0.00188473, 0.0018199, 0.00175478, 0.0016894, 0.00162375,
  0.00155784, 0.0014917, 0.00142532, 0.00135872, 0.00129191,
  0.0012249, 0.00115769, 0.00109031, 0.00102275, 0.000955034,
  0.000887167, 0.000819161, 0.000751027, 0.000682775, 0.000614415,
  0.000545959, 0.000477416, 0.000408798, 0.000340116, 0.000271381,
  0.000202602, 0.000133791, 6.49592e-05, -3.88297e-06, -7.27245e-05,
  -0.000141554, -0.000210362, -0.000279136, -0.000347866, -0.00041654,
  -0.000485148, -0.000553678, -0.00062212, -0.000690463, -0.000758695,
  -0.000826806, -0.000894785, -0.00096262, -0.0010303, -0.00109782,
  -0.00116516, -0.00123231, -0.00129926, -0.00136601, -0.00143253,
  -0.00149882, -0.00156487, -0.00163067, -0.00169621, -0.00176147,
  -0.00182644, -0.00189112, -0.0019555, -0.00201955, -0.00208328,
  -0.00214667, -0.00220971, -0.00227239, -0.00233469, -0.00239662,
  -0.00245816, -0.00251929, -0.00258002, -0.00264032, -0.00270018,
  -0.00275961, -0.00281858, -0.00287709, -0.00293513, -0.00299268,
  -0.00304974, -0.0031063, -0.00316235, -0.00321787, -0.00327286,
  -0.00332731, -0.00338121, -0.00343455, -0.00348732, -0.00353952,
  -0.00359112, -0.00364213, -0.00369253, -0.00374232, -0.00379148,
  -0.00384001, -0.0038879, -0.00393514, -0.00398172, -0.00402764,
  -0.00407288, -0.00411743, -0.0041613, -0.00420447, -0.00424693,
  -0.00428868, -0.0043297, -0.00437, -0.00440955, -0.00444837,
  -0.00448643, -0.00452373, -0.00456027, -0.00459603, -0.00463101,
  -0.00466521, -0.00469862, -0.00473122, -0.00476302, -0.00479401,
  -0.00482418, -0.00485353, -0.00488205, -0.00490974, -0.00493658,
  -0.00496258, -0.00498773, -0.00501202, -0.00503545, -0.00505802,
  -0.00507971, -0.00510053, -0.00512047, -0.00513953, -0.0051577,
  -0.00517498, -0.00519136, -0.00520684, -0.00522142, -0.0052351,
  -0.00524787, -0.00525972, -0.00527066, -0.00528068, -0.00528978,
  -0.00529796, -0.00530521, -0.00531153, -0.00531693, -0.00532139,
  -0.00532492, -0.00532752, -0.00532918, -0.00532991, -0.00532969,
  -0.00532854, -0.00532645, -0.00532342, -0.00531945, -0.00531453,
  -0.00530868, -0.00530189, -0.00529415, -0.00528548, -0.00527587,
  -0.00526532, -0.00525383, -0.00524141, -0.00522805, -0.00521376,
  -0.00519854, -0.00518238, -0.0051653, -0.0051473, -0.00512837,
  -0.00510852, -0.00508775, -0.00506607, -0.00504347, -0.00501996,
  -0.00499555, -0.00497024, -0.00494403, -0.00491692, -0.00488892,
  -0.00486004, -0.00483027, -0.00479963, -0.00476811, -0.00473573,
  -0.00470248, -0.00466837, -0.00463341, -0.00459761, -0.00456096,
  -0.00452348, -0.00448517, -0.00444603, -0.00440608, -0.00436532,
  -0.00432375, -0.00428139, -0.00423824, -0.0041943, -0.00414959,
  -0.00410411, -0.00405788, -0.00401089, -0.00396315, -0.00391468,
  -0.00386548, -0.00381556, -0.00376493, -0.0037136, -0.00366157,
  -0.00360886, -0.00355547, -0.00350142, -0.00344671, -0.00339135,
  -0.00333536, -0.00327874, -0.0032215, -0.00316365, -0.00310521,
  -0.00304618, -0.00298657, -0.0029264, -0.00286568, -0.00280441,
  -0.0027426, -0.00268028, -0.00261744, -0.00255411, -0.00249029,
  -0.00242599, -0.00236123, -0.00229602, -0.00223037, -0.00216429,
  -0.0020978, -0.0020309, -0.00196361, -0.00189594, -0.00182791,
  -0.00175952, -0.0016908, -0.00162174, -0.00155238, -0.00148271,
  -0.00141275, -0.00134252, -0.00127203, -0.00120129, -0.00113032,
  -0.00105912, -0.000987721, -0.000916126, -0.000844352, -0.000772413,
  -0.000700321, -0.000628092, -0.00055574, -0.000483278, -0.000410721,
  -0.000338082, -0.000265377, -0.000192619, -0.000119824,
  -4.70039e-05, 2.58251e-05, 9.8649e-05, 0.000171453, 0.000244223,
  0.000316945, 0.000389603, 0.000462184, 0.000534672, 0.000607052,
  0.000679311, 0.000751434, 0.000823406, 0.000895212, 0.000966837,
  0.00103827, 0.00110949, 0.00118049, 0.00125124, 0.00132175,
  0.00139198, 0.00146194, 0.00153159, 0.00160093, 0.00166995,
  0.00173863, 0.00180695, 0.0018749, 0.00194247, 0.00200964,
  0.00207639, 0.00214272, 0.00220861, 0.00227404, 0.00233901,
  0.00240349, 0.00246747, 0.00253095, 0.00259389, 0.0026563,
  0.00271816, 0.00277945, 0.00284016, 0.00290028, 0.0029598,
  0.00301869, 0.00307696, 0.00313458, 0.00319154, 0.00324783,
  0.00330343, 0.00335834, 0.00341254, 0.00346603, 0.00351877,
  0.00357078, 0.00362202, 0.0036725, 0.0037222, 0.0037711, 0.0038192,
  0.00386649, 0.00391295, 0.00395857, 0.00400335, 0.00404727,
  0.00409031, 0.00413248, 0.00417376, 0.00421414, 0.00425361,
  0.00429217, 0.00432979, 0.00436647, 0.00440221, 0.00443699,
  0.00447081, 0.00450365, 0.00453552, 0.00456639, 0.00459626,
  0.00462512, 0.00465298, 0.00467981, 0.00470561, 0.00473038,
  0.0047541, 0.00477678, 0.0047984, 0.00481896, 0.00483845,
  0.00485687, 0.00487421, 0.00489047, 0.00490563, 0.0049197,
  0.00493268, 0.00494455, 0.00495531, 0.00496496, 0.0049735,
  0.00498092, 0.00498722, 0.00499239, 0.00499644, 0.00499936,
  0.00500114, 0.00500179, 0.00500131, 0.00499969, 0.00499693,
  0.00499303, 0.00498799, 0.00498182, 0.0049745, 0.00496604,
  0.00495644, 0.0049457, 0.00493383, 0.00492082, 0.00490667,
  0.00489138, 0.00487497, 0.00485742, 0.00483875, 0.00481895,
  0.00479803, 0.00477599, 0.00475284, 0.00472858, 0.0047032,
  0.00467673, 0.00464916, 0.00462049, 0.00459074, 0.0045599,
  0.00452799, 0.004495, 0.00446095, 0.00442584, 0.00438969,
  0.00435248, 0.00431424, 0.00427497, 0.00423468, 0.00419337,
  0.00415106, 0.00410776, 0.00406346, 0.00401819, 0.00397195,
  0.00392475, 0.0038766, 0.00382751, 0.0037775, 0.00372656,
  0.00367472, 0.00362199, 0.00356837, 0.00351387, 0.00345852,
  0.00340232, 0.00334529, 0.00328743, 0.00322876, 0.0031693,
  0.00310905, 0.00304803, 0.00298626, 0.00292375, 0.00286051,
  0.00279656, 0.00273191, 0.00266658, 0.00260058, 0.00253393,
  0.00246664, 0.00239874, 0.00233023, 0.00226113, 0.00219146,
  0.00212124, 0.00205048, 0.0019792, 0.00190742, 0.00183515,
  0.00176241, 0.00168923, 0.00161561, 0.00154158, 0.00146715,
  0.00139234, 0.00131718, 0.00124168, 0.00116585, 0.00108973,
  0.00101332, 0.000936652, 0.000859738, 0.0007826, 0.000705258,
  0.000627732, 0.000550041, 0.000472207, 0.000394248, 0.000316186,
  0.00023804, 0.000159832, 8.15813e-05, 3.30916e-06, -7.49638e-05,
  -0.000153217, -0.000231429, -0.000309579, -0.000387647,
  -0.000465611, -0.00054345, -0.000621143, -0.000698669, -0.000776007,
  -0.000853136, -0.000930033, -0.00100668, -0.00108305, -0.00115913,
  -0.00123489, -0.00131032, -0.00138539, -0.00146008, -0.00153436,
  -0.00160823, -0.00168166, -0.00175462, -0.00182709, -0.00189907,
  -0.00197051, -0.00204141, -0.00211174, -0.00218148, -0.00225061,
  -0.00231912, -0.00238697, -0.00245416, -0.00252065, -0.00258643,
  -0.00265149, -0.00271579, -0.00277933, -0.00284208, -0.00290402,
  -0.00296513, -0.0030254, -0.0030848, -0.00314332, -0.00320093,
  -0.00325763, -0.00331339, -0.00336819, -0.00342202, -0.00347486,
  -0.00352668, -0.00357749, -0.00362725, -0.00367595, -0.00372358,
  -0.00377012, -0.00381555, -0.00385986, -0.00390303, -0.00394505,
  -0.00398591, -0.00402558, -0.00406405, -0.00410132, -0.00413736,
  -0.00417217, -0.00420573, -0.00423803, -0.00426905, -0.00429879,
  -0.00432724, -0.00435437, -0.00438019, -0.00440467, -0.00442782,
  -0.00444962, -0.00447006, -0.00448913, -0.00450683, -0.00452314,
  -0.00453806, -0.00455158, -0.00456369, -0.00457439, -0.00458367,
  -0.00459152, -0.00459794, -0.00460293, -0.00460648, -0.00460858,
  -0.00460923, -0.00460844, -0.00460618, -0.00460248, -0.00459731,
  -0.00459068, -0.00458259, -0.00457304, -0.00456203, -0.00454956,
  -0.00453563, -0.00452024, -0.00450339, -0.00448508, -0.00446533,
  -0.00444412, -0.00442147, -0.00439738, -0.00437186, -0.0043449,
  -0.00431651, -0.00428671, -0.0042555, -0.00422288, -0.00418886,
  -0.00415345, -0.00411666, -0.0040785, -0.00403898, -0.0039981,
  -0.00395589, -0.00391234, -0.00386748, -0.00382131, -0.00377385,
  -0.0037251, -0.00367509, -0.00362383, -0.00357132, -0.0035176,
  -0.00346267, -0.00340654, -0.00334924, -0.00329079, -0.00323119,
  -0.00317047, -0.00310865, -0.00304574, -0.00298176, -0.00291675,
  -0.0028507, -0.00278365, -0.00271562, -0.00264663, -0.0025767,
  -0.00250585, -0.0024341, -0.00236149, -0.00228803, -0.00221375,
  -0.00213867, -0.00206282, -0.00198623, -0.00190891, -0.0018309,
  -0.00175222, -0.0016729, -0.00159297, -0.00151245, -0.00143137,
  -0.00134977, -0.00126766, -0.00118509, -0.00110208, -0.00101865,
  -0.000934842, -0.000850684, -0.000766206, -0.00068144, -0.000596416,
  -0.000511166, -0.000425721, -0.000340115, -0.000254379,
  -0.000168545, -8.26464e-05, 3.28398e-06, 8.92131e-05, 0.000175108,
  0.000260934, 0.00034666, 0.00043225, 0.000517671, 0.000602889,
  0.000687869, 0.000772579, 0.000856983, 0.000941047, 0.00102474,
  0.00110802, 0.00119086, 0.00127322, 0.00135507, 0.00143637,
  0.00151709, 0.00159719, 0.00167665, 0.00175542, 0.00183348,
  0.00191078, 0.0019873, 0.00206299, 0.00213784, 0.00221179,
  0.00228483, 0.00235691, 0.002428, 0.00249808, 0.0025671, 0.00263504,
  0.00270186, 0.00276753, 0.00283203, 0.00289531, 0.00295735,
  0.00301813, 0.00307759, 0.00313573, 0.00319251, 0.00324789,
  0.00330186, 0.00335438, 0.00340543, 0.00345498, 0.003503,
  0.00354946, 0.00359435, 0.00363763, 0.00367929, 0.00371929,
  0.00375761, 0.00379424, 0.00382914, 0.0038623, 0.0038937,
  0.00392332, 0.00395114, 0.00397713, 0.00400128, 0.00402358,
  0.004044, 0.00406254, 0.00407917, 0.00409388, 0.00410666, 0.0041175,
  0.00412638, 0.0041333, 0.00413824, 0.00414119, 0.00414215,
  0.0041411, 0.00413805, 0.00413299, 0.0041259, 0.0041168, 0.00410567,
  0.00409251, 0.00407733, 0.00406012, 0.00404089, 0.00401963,
  0.00399636, 0.00397107, 0.00394377, 0.00391447, 0.00388317,
  0.00384988, 0.00381462, 0.00377739, 0.00373821, 0.00369709,
  0.00365404, 0.00360907, 0.00356221, 0.00351348, 0.00346288,
  0.00341045, 0.00335619, 0.00330014, 0.00324232, 0.00318274,
  0.00312144, 0.00305845, 0.00299378, 0.00292748, 0.00285956,
  0.00279006, 0.00271901, 0.00264645, 0.00257241, 0.00249693,
  0.00242003, 0.00234177, 0.00226218, 0.00218129, 0.00209915,
  0.00201581, 0.0019313, 0.00184566, 0.00175896, 0.00167122,
  0.0015825, 0.00149284, 0.0014023, 0.00131092, 0.00121876,
  0.00112587, 0.00103229, 0.000938095, 0.000843324, 0.000748037,
  0.000652291, 0.000556143, 0.000459649, 0.000362869, 0.000265862,
  0.000168688, 7.14077e-05, -2.5918e-05, -0.000123227, -0.000220457,
  -0.000317545, -0.000414427, -0.00051104, -0.000607319, -0.000703199,
  -0.000798615, -0.000893502, -0.000987794, -0.00108142, -0.00117433,
  -0.00126644, -0.00135769, -0.00144801, -0.00153733, -0.0016256,
  -0.00171274, -0.00179869, -0.00188337, -0.00196673, -0.0020487,
  -0.00212921, -0.00220819, -0.00228559, -0.00236133, -0.00243536,
  -0.0025076, -0.00257801, -0.0026465, -0.00271303, -0.00277754,
  -0.00283995, -0.00290022, -0.00295828, -0.00301408, -0.00306757,
  -0.00311868, -0.00316737, -0.00321357, -0.00325725, -0.00329835,
  -0.00333683, -0.00337263, -0.00340571, -0.00343603, -0.00346354,
  -0.00348822, -0.00351001, -0.00352888, -0.0035448, -0.00355774,
  -0.00356767, -0.00357455, -0.00357836, -0.00357909, -0.0035767,
  -0.00357119, -0.00356252, -0.0035507, -0.00353571, -0.00351754,
  -0.00349619, -0.00347165, -0.00344393, -0.00341303, -0.00337895,
  -0.0033417, -0.0033013, -0.00325776, -0.0032111, -0.00316135,
  -0.00310852, -0.00305265, -0.00299377, -0.00293192, -0.00286713,
  -0.00279945, -0.00272892, -0.0026556, -0.00257953, -0.00250078,
  -0.0024194, -0.00233547, -0.00224905, -0.00216021, -0.00206903,
  -0.00197558, -0.00187996, -0.00178225, -0.00168254, -0.00158093,
  -0.00147752, -0.00137241, -0.0012657, -0.00115751, -0.00104795,
  -0.000937147, -0.000825213, -0.000712276, -0.000598465,
  -0.000483914, -0.000368757, -0.000253136, -0.000137192,
  -2.10712e-05, 9.50766e-05, 0.0002111, 0.000326842, 0.000442147,
  0.000556853, 0.000670797, 0.000783813, 0.000895733, 0.00100639,
  0.0011156, 0.00122321, 0.00132902, 0.00143288, 0.00153459,
  0.00163398, 0.00173087, 0.00182508, 0.00191642, 0.00200473,
  0.00208982, 0.0021715, 0.00224961, 0.00232397, 0.00239439,
  0.00246071, 0.00252276, 0.00258037, 0.00263337, 0.00268161,
  0.00272492, 0.00276316, 0.00279618, 0.00282383, 0.00284599,
  0.00286252, 0.0028733, 0.00287822, 0.00287717, 0.00287006,
  0.0028568, 0.00283731, 0.00281154, 0.00277942, 0.00274092,
  0.00269601, 0.00264467, 0.00258692, 0.00252277, 0.00245225,
  0.00237541, 0.00229233, 0.00220311, 0.00210784, 0.00200668,
  0.00189976, 0.00178728, 0.00166944, 0.00154647, 0.00141863,
  0.00128622, 0.00114954, 0.00100896, 0.000864852, 0.000717639,
  0.000567774, 0.000415747, 0.000262091, 0.000107375, -4.77865e-05,
  -0.000202737, -0.000356773, -0.000509144, -0.00065905, -0.00080564,
  -0.00094801, -0.0010852, -0.00121619, -0.00133991, -0.00145521,
  -0.0015609, -0.00165571, -0.0017383, -0.00180725, -0.0018611,
  -0.00189828, -0.00191715, -0.00191599, -0.00189302, -0.00184632,
  -0.00177393, -0.00167377, -0.00154367, -0.00138136, -0.00118448,
  -0.000950548, -0.000676975, -0.000361063, -3.35696e-17}; 
