//##### MOMO Main program #####
//# ----------------------------------------------------------
//# Automatic creation of the main program for Momo environment.
// 2010 December, updated for  geant4.9.4
// --------------------------------------------------------------
//   Demonstration_of_Geometry_Editor.cc generated by Geant4 Momo
//     at Tue Nov 30 10:58:49 JST 2010  


// This code implementation is the intellectual property of
// the  GEANT4 collaboration.
//
// By copying, distributing or modifying the Program (or any work
// based on the Program) you indicate your acceptance of this statement,
// and all its terms.
//
// 
#include "G4RunManager.hh"
#include "G4UImanager.hh"
// Your choice of User Interface driver
#include "G4UIGAG.hh"
// Detector geometry generated by Momo's GGE
#include "Various_Solids_Copied.hh"
// temporary using a pre-tuned Physics List
#include "QGSP_BERT.hh"
// Momo's default PrimaryGeneratorAction
#include "MomoPrimaryGeneratorAction.hh"
#include "MomoRunAction.hh"
#include "MomoEventAction.hh"
#ifdef G4VIS_USE
#include "G4VisExecutive.hh"
#endif
int main()
{
  // Construct the default run manager
  G4RunManager* runManager = new G4RunManager;
  // set mandatory initialization classes
  runManager->SetUserInitialization(new Various_Solids_Copied);
  G4VUserPhysicsList* physics = new QGSP_BERT();
  runManager->SetUserInitialization(physics);
#ifdef G4VIS_USE
  // visualization manager
  G4VisManager* visManager = new G4VisExecutive;
  visManager->Initialize();
#endif
  // set mandatory user action class
  runManager->SetUserAction(new MomoPrimaryGeneratorAction);
  // set user action classes to visualise trajectories
  runManager->SetUserAction(new MomoRunAction);
  runManager->SetUserAction(new MomoEventAction);
  // Initialize G4 kernel
  runManager->Initialize();
  // get the pointer to the User Interface manager 
  G4UImanager* UI = G4UImanager::GetUIpointer();
      G4UIsession * session = new G4UIGAG;
      session->SessionStart();
      delete session;
  // job termination
#ifdef G4VIS_USE
  delete visManager;
#endif
  delete runManager;
  return 0;
}

