//$Id: RatioItem.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
// GGE (Geant4 Geometry Editor)
// Toshiaki Kodama
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

import java.io.Serializable;

class RatioItem extends Object implements Serializable {
  ElementItem elems[];
  float ratio[];
  int isFraction;
  boolean isEmpty;
//momo
public  RatioItem(ElementItem eis[]){
    elems = eis;
    ratio = new float[elems.length];
    isEmpty = true;
  }
  int getLength(){
    return elems.length;
  }
  String getEleName(int pos){
    return elems[pos].name;
  }
  public String toString(){
    StringBuffer stb = new StringBuffer();
    for (int i=0; i<elems.length; i++){
      stb.append(elems[i].symbol);
      if (!isEmpty) stb.append(":"+getRatioStr(i)+" "); else stb.append("  ");
    }
    return stb.toString();
  }
  String getRatioStr(int pos){
    if(isFraction==1){
      return ""+ratio[pos];
    }else{
      return ""+Math.round(ratio[pos]);
    }
  }
    //MOMO  public String getCPP(String name){

   String getCPP(String name){
    StringBuffer cpp = new StringBuffer();
    for (int i=0; i<elems.length; i++){
      cpp.append(name + "->AddElement( element" + elems[i].symbol + ", ");
      cpp.append(getRatioStr(i)+" );\n");
    }
    return cpp.toString();
  }
   
   String getXML(String name){
     StringBuffer xml = new StringBuffer();
     for (int i=0; i<elems.length; i++){
	if(isFraction==1){
           xml.append("         <franction n=\""+ getRatioStr(i)+"\" ");
	   xml.append("ref=\""+elems[i] +"\"/>\n");
	}else{
	   xml.append("         <composite n=\""+ getRatioStr(i)+"\" ");
           xml.append("ref=\""+elems[i] +"\"/>\n");
	}
     }
     return xml.toString();
   }
}

