//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: pymodG4global.cc 66892 2013-01-17 10:57:59Z gunter $
// ====================================================================
//   pymodG4global.cc [Geant4Py module]
//
//                                         2005 Q
// ====================================================================
#include <boost/python.hpp>

using namespace boost::python;

// ====================================================================
// module definition
// ====================================================================

void export_globals();
void export_geomdefs();
void export_G4StateManager();
void export_G4ApplicationState();
void export_G4String();
void export_G4ThreeVector();
void export_G4RotationMatrix();
void export_G4Transform3D();
void export_G4UnitsTable();
void export_Randomize();
void export_RandomEngines();
void export_G4RandomDirection();
void export_G4UserLimits();
void export_G4Timer();
void export_G4Version();
void export_G4Exception();
void export_G4ExceptionHandler();
void export_G4ExceptionSeverity();
void export_G4TwoVector();

BOOST_PYTHON_MODULE(G4global) 
{
  export_globals();
  export_geomdefs();
  export_G4StateManager();
  export_G4ApplicationState();
  export_G4String();
  export_G4ThreeVector();
  export_G4TwoVector();
  export_G4RotationMatrix();
  export_G4Transform3D();
  export_G4UnitsTable();
  export_Randomize();
  export_RandomEngines();
  export_G4RandomDirection();
  export_G4UserLimits();
  export_G4Timer();
  export_G4Version();
  export_G4Exception();
  export_G4ExceptionHandler();
  export_G4ExceptionSeverity();
}

