/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.CSGItem;
import GGE.RatioCellEditor;
import GGE.RatioItem;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

class RatioDialog
extends JDialog {
    private JTextField[] paramField;
    private JComboBox ratioType;
    private CSGItem solid;
    private RatioItem ratioItem;

    public RatioDialog(RatioCellEditor parent, RatioItem ratioItem) {
        this.ratioItem = ratioItem;
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        this.getContentPane().setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        JLabel lbl = new JLabel("Ratio");
        gbl.setConstraints(lbl, gbc);
        this.getContentPane().add(lbl);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.ratioType = new JComboBox();
        this.ratioType.addItem("Number");
        this.ratioType.addItem("Fraction");
        gbl.setConstraints(this.ratioType, gbc);
        this.getContentPane().add(this.ratioType);
        int paraCount = ratioItem.getLength();
        this.paramField = new JTextField[paraCount];
        for (int i = 0; i < paraCount; ++i) {
            gbc.gridx = 0;
            gbc.gridy = i + 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.anchor = 13;
            lbl = new JLabel(ratioItem.getEleName(i));
            gbl.setConstraints(lbl, gbc);
            this.getContentPane().add(lbl);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            this.paramField[i] = new JTextField(8);
            gbl.setConstraints(this.paramField[i], gbc);
            this.getContentPane().add(this.paramField[i]);
        }
        gbc.gridx = 0;
        gbc.gridy = paraCount + 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        JButton okButton = new JButton(" OK ");
        gbl.setConstraints(okButton, gbc);
        this.getContentPane().add(okButton);
        okButton.addActionListener(parent);
        this.setValues();
        this.pack();
        this.setVisible(true);
    }

    void editStop() {
        this.setVisible(false);
    }

    private void setValues() {
        if (this.ratioItem.isEmpty) {
            return;
        }
        this.ratioType.setSelectedIndex(this.ratioItem.isFraction);
        for (int i = 0; i < this.ratioItem.getLength(); ++i) {
            this.paramField[i].setText(this.ratioItem.getRatioStr(i));
        }
    }

    RatioItem getValues() {
        this.ratioItem.isFraction = this.ratioType.getSelectedIndex();
        for (int i = 0; i < this.ratioItem.getLength(); ++i) {
            try {
                this.ratioItem.ratio[i] = new Float(this.paramField[i].getText()).floatValue();
                continue;
            }
            catch (NumberFormatException e) {
                this.ratioItem.ratio[i] = 0.0f;
            }
        }
        this.ratioItem.isEmpty = false;
        this.dispose();
        return this.ratioItem;
    }
}

