/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.AngUnitCombo;
import GGE.CSGItem;
import GGE.DAWNSourceFrame;
import GGE.LenUnitCombo;
import GGE.SolidCellEditor;
import GGE.SolidDialog;
import GGE.SolidItem;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class CSGDialog
extends SolidDialog
implements ActionListener {
    private JTextField[] paramField;
    private JComboBox[] paramUnit;
    private CSGItem solid;
    private JButton viewButton;
    private JButton okButton;
    DAWNSourceFrame dawnSFrame;
    private String csgTitle;
    private Process p;

    public CSGDialog(SolidCellEditor parent, CSGItem solid) {
        this.solid = solid;
        this.dawnSFrame = new DAWNSourceFrame();
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        this.getContentPane().setLayout(gbl);
        GridBagLayout csgGBL = new GridBagLayout();
        GridBagConstraints csgGBC = new GridBagConstraints();
        JPanel csgPanel = new JPanel(csgGBL);
        gbc.gridx = 0;
        csgGBC.gridy = 0;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 10;
        JPanel csgButtonPanel = new JPanel();
        csgButtonPanel.setLayout(new GridLayout(1, 2));
        this.okButton = new JButton(" OK ");
        csgButtonPanel.add(this.okButton);
        this.viewButton = new JButton(" VIEW ");
        csgButtonPanel.add(this.viewButton);
        gbl.setConstraints(csgButtonPanel, gbc);
        this.getContentPane().add(csgButtonPanel);
        int paraCount = solid.getParaCount();
        this.paramField = new JTextField[paraCount];
        this.paramUnit = new JComboBox[paraCount];
        for (int i = 0; i < paraCount; ++i) {
            csgGBC.gridx = 0;
            csgGBC.gridy = i + 1;
            csgGBC.gridwidth = 1;
            csgGBC.gridheight = 1;
            csgGBC.weightx = 1.0;
            csgGBC.weighty = 1.0;
            csgGBC.fill = 0;
            csgGBC.anchor = 13;
            JLabel lbl = new JLabel(solid.getParaName(i));
            csgGBL.setConstraints(lbl, csgGBC);
            csgPanel.add(lbl);
            csgGBC.gridx = 1;
            csgGBC.weightx = 1.0;
            csgGBC.weighty = 1.0;
            csgGBC.fill = 2;
            this.paramField[i] = new JTextField(8);
            csgGBL.setConstraints(this.paramField[i], csgGBC);
            csgPanel.add(this.paramField[i]);
            csgGBC.gridx = 2;
            csgGBC.weightx = 1.0;
            csgGBC.weighty = 1.0;
            csgGBC.fill = 0;
            csgGBC.anchor = 17;
            this.paramUnit[i] = solid.isAngle(i) ? new AngUnitCombo() : new LenUnitCombo();
            csgGBL.setConstraints(this.paramUnit[i], csgGBC);
            csgPanel.add(this.paramUnit[i]);
        }
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 10;
        gbl.setConstraints(csgPanel, gbc);
        this.getContentPane().add(csgPanel);
        this.okButton.addActionListener(parent);
        this.viewButton.addActionListener(this);
        this.setValues();
        this.pack();
        this.setVisible(true);
        this.setResizable(false);
    }

    @Override
    public void editStop() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.viewButton) {
            this.getValues();
            this.getDAWN();
        }
    }

    private void getDAWN() {
        this.dawnSFrame.setVisible(true);
        this.dawnSFrame.dawnEditor.setText(this.solid.getPrim());
        try {
            FileOutputStream fileout = new FileOutputStream("GGESolid.prim");
            PrintWriter outf = new PrintWriter(new DataOutputStream(fileout));
            outf.println(this.solid.getPrim());
            outf.close();
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        try {
            String cmd = "dawn -v GGESolid.prim";
            Runtime r = Runtime.getRuntime();
            Process process = r.exec(cmd);
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    private void setValues() {
        if (this.solid.isEmpty) {
            return;
        }
        for (int i = 0; i < this.solid.getParaCount(); ++i) {
            this.paramField[i].setText(Double.toString(this.solid.getValues(i)));
            this.paramUnit[i].setSelectedItem(this.solid.getUnits(i));
        }
    }

    @Override
    public SolidItem getValues() {
        for (int i = 0; i < this.solid.getParaCount(); ++i) {
            double tmp;
            try {
                tmp = new Double(this.paramField[i].getText());
            }
            catch (NumberFormatException e) {
                tmp = 0.0;
            }
            this.solid.setValuesUnits(i, tmp, (String)this.paramUnit[i].getSelectedItem());
        }
        return this.solid;
    }
}

