//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// neutron_hp -- source file
// J.P. Wellisch, Nov-1996
// A prototype of the low energy neutron transport model.
#include "G4NeutronHPFastLegendre.hh"

const G4double
  G4NeutronHPFastLegendre::l28[5801] = {1, 0.864813, 0.738958,
  0.622005, 0.51354, 0.41316, 0.32048, 0.235125, 0.156738, 0.0849687,
  0.0194843, -0.0400381, -0.0939091, -0.142428, -0.185883, -0.224551,
  -0.258699, -0.288583, -0.31445, -0.336538, -0.355073, -0.370275,
  -0.382353, -0.391509, -0.397935, -0.401817, -0.403332, -0.402651,
  -0.399934, -0.395339, -0.389013, -0.381098, -0.371731, -0.36104,
  -0.349149, -0.336176, -0.322231, -0.307423, -0.291852, -0.275615,
  -0.258802, -0.2415, -0.223792, -0.205755, -0.187462, -0.168983,
  -0.150383, -0.131723, -0.113061, -0.094451, -0.0759447, -0.0575892,
  -0.0394289, -0.0215052, -0.0038565, 0.0134815, 0.0304758, 0.0470961,
  0.0633145, 0.0791055, 0.0944459, 0.109315, 0.123693, 0.137563,
  0.150911, 0.163723, 0.175988, 0.187696, 0.198839, 0.20941, 0.219403,
  0.228816, 0.237645, 0.245889, 0.253549, 0.260624, 0.267117,
  0.273031, 0.27837, 0.283139, 0.287343, 0.290989, 0.294084, 0.296635,
  0.298652, 0.300144, 0.301119, 0.301589, 0.301564, 0.301054,
  0.300072, 0.298629, 0.296737, 0.294409, 0.291658, 0.288496,
  0.284936, 0.280993, 0.276679, 0.272008, 0.266994, 0.26165, 0.255991,
  0.25003, 0.243781, 0.237258, 0.230476, 0.223447, 0.216186, 0.208707,
  0.201022, 0.193146, 0.185092, 0.176874, 0.168503, 0.159995, 0.15136,
  0.142613, 0.133765, 0.124829, 0.115816, 0.10674, 0.097611, 0.088441,
  0.0792412, 0.0700227, 0.0607961, 0.0515721, 0.0423608, 0.0331725,
  0.0240168, 0.0149033, 0.00584124, -0.00316032, -0.0120927,
  -0.0209473, -0.0297159, -0.0383907, -0.0469639, -0.055428,
  -0.063776, -0.0720009, -0.0800962, -0.0880554, -0.0958724,
  -0.103541, -0.111057, -0.118414, -0.125607, -0.132631, -0.139482,
  -0.146155, -0.152647, -0.158953, -0.165071, -0.170996, -0.176727,
  -0.182259, -0.18759, -0.192719, -0.197642, -0.202358, -0.206866,
  -0.211163, -0.215248, -0.219121, -0.222781, -0.226226, -0.229456,
  -0.232472, -0.235273, -0.237858, -0.240229, -0.242386, -0.244329,
  -0.246059, -0.247577, -0.248885, -0.249982, -0.250872, -0.251555,
  -0.252033, -0.252307, -0.25238, -0.252254, -0.251931, -0.251414,
  -0.250704, -0.249804, -0.248717, -0.247446, -0.245993, -0.244361,
  -0.242554, -0.240575, -0.238426, -0.23611, -0.233633, -0.230995,
  -0.228202, -0.225257, -0.222163, -0.218924, -0.215543, -0.212025,
  -0.208373, -0.204591, -0.200682, -0.196652, -0.192503, -0.188239,
  -0.183865, -0.179385, -0.174803, -0.170122, -0.165347, -0.160481,
  -0.155529, -0.150496, -0.145384, -0.140198, -0.134942, -0.12962,
  -0.124237, -0.118795, -0.1133, -0.107755, -0.102165, -0.096532,
  -0.0908615, -0.0851569, -0.0794222, -0.0736612, -0.0678778,
  -0.0620757, -0.0562587, -0.0504305, -0.0445947, -0.0387551,
  -0.0329152, -0.0270785, -0.0212487, -0.015429, -0.00962306,
  -0.00383411, 0.00193449, 0.00767948, 0.0133976, 0.0190858,
  0.0247409, 0.0303598, 0.0359395, 0.0414772, 0.0469699, 0.0524148,
  0.0578091, 0.0631501, 0.0684352, 0.0736618, 0.0788274, 0.0839295,
  0.0889657, 0.0939337, 0.0988311, 0.103656, 0.108406, 0.113079,
  0.117673, 0.122186, 0.126616, 0.130962, 0.135221, 0.139392,
  0.143474, 0.147464, 0.151362, 0.155165, 0.158873, 0.162484,
  0.165997, 0.16941, 0.172723, 0.175935, 0.179044, 0.18205, 0.184952,
  0.187748, 0.190439, 0.193024, 0.195501, 0.197871, 0.200132,
  0.202285, 0.20433, 0.206265, 0.20809, 0.209806, 0.211411, 0.212907,
  0.214293, 0.215569, 0.216735, 0.217791, 0.218737, 0.219574,
  0.220302, 0.220921, 0.221432, 0.221835, 0.22213, 0.222318, 0.222399,
  0.222375, 0.222245, 0.222011, 0.221673, 0.221232, 0.220689,
  0.220045, 0.2193, 0.218456, 0.217513, 0.216473, 0.215336, 0.214104,
  0.212777, 0.211357, 0.209846, 0.208244, 0.206552, 0.204772,
  0.202905, 0.200953, 0.198916, 0.196796, 0.194595, 0.192314,
  0.189954, 0.187518, 0.185005, 0.182419, 0.17976, 0.17703, 0.17423,
  0.171363, 0.16843, 0.165432, 0.16237, 0.159248, 0.156066, 0.152826,
  0.149529, 0.146178, 0.142774, 0.139319, 0.135815, 0.132262,
  0.128664, 0.125021, 0.121336, 0.11761, 0.113844, 0.110042, 0.106204,
  0.102332, 0.0984286, 0.0944945, 0.090532, 0.0865426, 0.0825283,
  0.0784907, 0.0744315, 0.0703526, 0.0662556, 0.0621423, 0.0580144,
  0.0538736, 0.0497216, 0.0455601, 0.0413908, 0.0372154, 0.0330356,
  0.0288529, 0.0246692, 0.0204859, 0.0163047, 0.0121273, 0.00795516,
  0.00378998, -0.000366719, -0.00451337, -0.00864843, -0.0127704,
  -0.0168777, -0.0209689, -0.0250425, -0.029097, -0.0331311,
  -0.0371432, -0.0411319, -0.045096, -0.0490339, -0.0529444,
  -0.0568261, -0.0606778, -0.064498, -0.0682856, -0.0720393,
  -0.0757578, -0.07944, -0.0830847, -0.0866906, -0.0902568,
  -0.0937819, -0.097265, -0.100705, -0.104101, -0.107451, -0.110756,
  -0.114013, -0.117222, -0.120382, -0.123491, -0.12655, -0.129557,
  -0.132512, -0.135413, -0.13826, -0.141051, -0.143787, -0.146467,
  -0.149089, -0.151654, -0.15416, -0.156607, -0.158994, -0.161321,
  -0.163587, -0.165792, -0.167934, -0.170015, -0.172032, -0.173987,
  -0.175878, -0.177704, -0.179467, -0.181164, -0.182797, -0.184364,
  -0.185866, -0.187302, -0.188672, -0.189975, -0.191212, -0.192383,
  -0.193487, -0.194525, -0.195495, -0.196399, -0.197235, -0.198005,
  -0.198708, -0.199344, -0.199913, -0.200416, -0.200851, -0.201221,
  -0.201523, -0.20176, -0.20193, -0.202035, -0.202074, -0.202048,
  -0.201957, -0.2018, -0.201579, -0.201294, -0.200945, -0.200533,
  -0.200057, -0.199519, -0.198918, -0.198256, -0.197531, -0.196746,
  -0.1959, -0.194994, -0.194029, -0.193005, -0.191922, -0.190781,
  -0.189583, -0.188328, -0.187016, -0.18565, -0.184228, -0.182752,
  -0.181222, -0.179639, -0.178004, -0.176318, -0.17458, -0.172792,
  -0.170955, -0.169069, -0.167135, -0.165154, -0.163126, -0.161052,
  -0.158934, -0.156772, -0.154566, -0.152317, -0.150027, -0.147697,
  -0.145326, -0.142916, -0.140468, -0.137982, -0.135459, -0.132901,
  -0.130308, -0.127682, -0.125022, -0.122329, -0.119606, -0.116852,
  -0.114069, -0.111257, -0.108418, -0.105552, -0.10266, -0.099743,
  -0.0968023, -0.0938385, -0.0908526, -0.0878456, -0.0848184,
  -0.0817718, -0.0787069, -0.0756246, -0.0725258, -0.0694115,
  -0.0662825, -0.0631399, -0.0599845, -0.0568173, -0.0536392,
  -0.0504512, -0.0472542, -0.0440491, -0.0408368, -0.0376183,
  -0.0343945, -0.0311662, -0.0279345, -0.0247002, -0.0214642,
  -0.0182274, -0.0149908, -0.0117551, -0.0085214, -0.00529047,
  -0.0020632, 0.00115952, 0.00437683, 0.00758787, 0.0107918,
  0.0139877, 0.0171748, 0.0203522, 0.0235191, 0.0266747, 0.0298181,
  0.0329486, 0.0360653, 0.0391675, 0.0422543, 0.045325, 0.0483788,
  0.0514149, 0.0544325, 0.057431, 0.0604096, 0.0633675, 0.0663041,
  0.0692186, 0.0721103, 0.0749785, 0.0778225, 0.0806416, 0.0834353,
  0.0862028, 0.0889434, 0.0916566, 0.0943417, 0.096998, 0.0996251,
  0.102222, 0.104789, 0.107324, 0.109828, 0.1123, 0.114739, 0.117145,
  0.119517, 0.121854, 0.124157, 0.126424, 0.128656, 0.130851, 0.13301,
  0.135132, 0.137216, 0.139262, 0.141269, 0.143238, 0.145167,
  0.147057, 0.148907, 0.150717, 0.152486, 0.154214, 0.1559, 0.157546,
  0.159149, 0.16071, 0.162228, 0.163704, 0.165137, 0.166527, 0.167873,
  0.169176, 0.170435, 0.17165, 0.17282, 0.173947, 0.175028, 0.176065,
  0.177057, 0.178005, 0.178907, 0.179764, 0.180576, 0.181343,
  0.182064, 0.18274, 0.18337, 0.183955, 0.184495, 0.184989, 0.185437,
  0.18584, 0.186198, 0.18651, 0.186776, 0.186998, 0.187174, 0.187304,
  0.18739, 0.187431, 0.187427, 0.187378, 0.187285, 0.187147, 0.186964,
  0.186738, 0.186467, 0.186153, 0.185795, 0.185393, 0.184948,
  0.184461, 0.18393, 0.183357, 0.182741, 0.182084, 0.181384, 0.180644,
  0.179861, 0.179038, 0.178174, 0.17727, 0.176326, 0.175342, 0.174318,
  0.173256, 0.172155, 0.171015, 0.169837, 0.168622, 0.167369, 0.16608,
  0.164754, 0.163392, 0.161994, 0.160561, 0.159093, 0.15759, 0.156053,
  0.154483, 0.15288, 0.151244, 0.149575, 0.147875, 0.146143, 0.144381,
  0.142588, 0.140765, 0.138912, 0.137031, 0.135121, 0.133183,
  0.131218, 0.129226, 0.127207, 0.125162, 0.123092, 0.120997,
  0.118877, 0.116734, 0.114567, 0.112377, 0.110165, 0.107932,
  0.105677, 0.103401, 0.101106, 0.0987907, 0.0964566, 0.0941041,
  0.0917337, 0.089346, 0.0869416, 0.0845209, 0.0820846, 0.0796333,
  0.0771674, 0.0746877, 0.0721945, 0.0696886, 0.0671705, 0.0646408,
  0.0620999, 0.0595486, 0.0569873, 0.0544167, 0.0518374, 0.0492498,
  0.0466546, 0.0440523, 0.0414435, 0.0388288, 0.0362088, 0.033584,
  0.030955, 0.0283224, 0.0256867, 0.0230485, 0.0204084, 0.0177668,
  0.0151245, 0.0124819, 0.00983963, 0.00719821, 0.00455819,
  0.00192014, -0.00071539, -0.00334786, -0.00597673, -0.00860145,
  -0.0112215, -0.0138363, -0.0164453, -0.0190481, -0.021644,
  -0.0242326, -0.0268134, -0.0293857, -0.0319492, -0.0345033,
  -0.0370474, -0.0395811, -0.0421039, -0.0446153, -0.0471148,
  -0.0496018, -0.052076, -0.0545369, -0.0569839, -0.0594166,
  -0.0618345, -0.0642372, -0.0666241, -0.068995, -0.0713492,
  -0.0736864, -0.0760061, -0.0783079, -0.0805914, -0.0828561,
  -0.0851015, -0.0873274, -0.0895333, -0.0917188, -0.0938835,
  -0.0960269, -0.0981488, -0.100249, -0.102326, -0.104381, -0.106413,
  -0.108421, -0.110406, -0.112366, -0.114302, -0.116213, -0.118099,
  -0.119959, -0.121794, -0.123603, -0.125385, -0.12714, -0.128869,
  -0.13057, -0.132243, -0.133889, -0.135507, -0.137096, -0.138657,
  -0.140189, -0.141691, -0.143164, -0.144608, -0.146022, -0.147406,
  -0.14876, -0.150083, -0.151375, -0.152637, -0.153868, -0.155068,
  -0.156236, -0.157372, -0.158477, -0.159551, -0.160592, -0.161601,
  -0.162578, -0.163522, -0.164434, -0.165313, -0.16616, -0.166974,
  -0.167755, -0.168503, -0.169217, -0.169899, -0.170548, -0.171163,
  -0.171745, -0.172293, -0.172808, -0.17329, -0.173738, -0.174153,
  -0.174534, -0.174882, -0.175196, -0.175477, -0.175724, -0.175938,
  -0.176118, -0.176265, -0.176378, -0.176458, -0.176505, -0.176519,
  -0.176499, -0.176446, -0.17636, -0.176241, -0.176089, -0.175905,
  -0.175688, -0.175438, -0.175155, -0.17484, -0.174493, -0.174114,
  -0.173703, -0.17326, -0.172785, -0.172279, -0.171741, -0.171171,
  -0.170571, -0.16994, -0.169278, -0.168585, -0.167862, -0.167109,
  -0.166325, -0.165512, -0.164669, -0.163797, -0.162895, -0.161965,
  -0.161005, -0.160018, -0.159001, -0.157957, -0.156885, -0.155785,
  -0.154658, -0.153504, -0.152323, -0.151115, -0.149881, -0.148621,
  -0.147335, -0.146024, -0.144687, -0.143326, -0.14194, -0.140529,
  -0.139095, -0.137637, -0.136155, -0.13465, -0.133122, -0.131572,
  -0.129999, -0.128405, -0.126789, -0.125152, -0.123494, -0.121815,
  -0.120116, -0.118397, -0.116659, -0.114901, -0.113125, -0.11133,
  -0.109516, -0.107685, -0.105836, -0.103971, -0.102088, -0.100189,
  -0.0982741, -0.0963434, -0.0943974, -0.0924364, -0.0904608,
  -0.088471, -0.0864673, -0.0844502, -0.08242, -0.0803771, -0.0783218,
  -0.0762545, -0.0741757, -0.0720856, -0.0699847, -0.0678734,
  -0.0657521, -0.063621, -0.0614807, -0.0593315, -0.0571737,
  -0.0550079, -0.0528342, -0.0506533, -0.0484654, -0.0462708,
  -0.0440702, -0.0418637, -0.0396518, -0.0374348, -0.0352133,
  -0.0329875, -0.0307578, -0.0285247, -0.0262885, -0.0240495,
  -0.0218083, -0.0195652, -0.0173205, -0.0150747, -0.0128281,
  -0.0105811, -0.00833411, -0.0060875, -0.00384165, -0.00159694,
  0.000646249, 0.00288755, 0.00512658, 0.00736296, 0.00959633,
  0.0118263, 0.0140525, 0.0162746, 0.0184922, 0.0207049, 0.0229124,
  0.0251143, 0.0273103, 0.0294999, 0.0316829, 0.0338589, 0.0360275,
  0.0381883, 0.0403411, 0.0424855, 0.0446211, 0.0467476, 0.0488647,
  0.050972, 0.0530691, 0.0551558, 0.0572317, 0.0592966, 0.0613499,
  0.0633916, 0.0654211, 0.0674383, 0.0694427, 0.0714341, 0.0734122,
  0.0753767, 0.0773272, 0.0792635, 0.0811853, 0.0830922, 0.084984,
  0.0868604, 0.0887212, 0.0905659, 0.0923944, 0.0942064, 0.0960016,
  0.0977797, 0.0995405, 0.101284, 0.103009, 0.104716, 0.106405,
  0.108076, 0.109727, 0.111359, 0.112973, 0.114566, 0.11614, 0.117694,
  0.119227, 0.12074, 0.122232, 0.123704, 0.125154, 0.126584, 0.127991,
  0.129377, 0.130741, 0.132084, 0.133403, 0.134701, 0.135976,
  0.137228, 0.138457, 0.139663, 0.140846, 0.142005, 0.143141,
  0.144253, 0.145341, 0.146406, 0.147446, 0.148462, 0.149453, 0.15042,
  0.151363, 0.15228, 0.153173, 0.154041, 0.154884, 0.155702, 0.156494,
  0.157261, 0.158003, 0.158719, 0.159409, 0.160074, 0.160713,
  0.161327, 0.161914, 0.162476, 0.163012, 0.163521, 0.164005,
  0.164463, 0.164894, 0.165299, 0.165678, 0.166031, 0.166358,
  0.166658, 0.166933, 0.16718, 0.167402, 0.167598, 0.167767, 0.16791,
  0.168026, 0.168117, 0.168181, 0.168219, 0.168231, 0.168217,
  0.168177, 0.168111, 0.168019, 0.167901, 0.167757, 0.167587,
  0.167392, 0.167171, 0.166924, 0.166652, 0.166354, 0.166031,
  0.165682, 0.165309, 0.16491, 0.164486, 0.164037, 0.163563, 0.163065,
  0.162542, 0.161995, 0.161423, 0.160827, 0.160206, 0.159562,
  0.158894, 0.158202, 0.157486, 0.156747, 0.155985, 0.155199,
  0.154391, 0.153559, 0.152705, 0.151828, 0.150929, 0.150007,
  0.149064, 0.148098, 0.147111, 0.146102, 0.145072, 0.144021,
  0.142948, 0.141855, 0.140741, 0.139607, 0.138453, 0.137278,
  0.136083, 0.134869, 0.133636, 0.132383, 0.131111, 0.129821,
  0.128512, 0.127184, 0.125839, 0.124475, 0.123094, 0.121695,
  0.120279, 0.118846, 0.117396, 0.11593, 0.114448, 0.112949, 0.111434,
  0.109904, 0.108359, 0.106799, 0.105223, 0.103634, 0.102029,
  0.100411, 0.0987792, 0.0971336, 0.0954746, 0.0938027, 0.092118,
  0.0904207, 0.0887112, 0.0869897, 0.0852565, 0.0835119, 0.081756,
  0.0799893, 0.0782119, 0.0764241, 0.0746263, 0.0728186, 0.0710014,
  0.0691749, 0.0673395, 0.0654953, 0.0636427, 0.0617819, 0.0599133,
  0.058037, 0.0561535, 0.0542629, 0.0523656, 0.0504618, 0.0485519,
  0.046636, 0.0447145, 0.0427877, 0.0408559, 0.0389193, 0.0369782,
  0.035033, 0.0330838, 0.031131, 0.0291749, 0.0272157, 0.0252538,
  0.0232894, 0.0213228, 0.0193543, 0.0173841, 0.0154127, 0.0134401,
  0.0114668, 0.00949304, 0.00751905, 0.00554513, 0.00357157,
  0.00159865, -0.000373351, -0.00234415, -0.00431347, -0.00628104,
  -0.00824656, -0.0102098, -0.0121704, -0.0141282, -0.0160828,
  -0.018034, -0.0199815, -0.0219251, -0.0238644, -0.0257993,
  -0.0277293, -0.0296544, -0.0315741, -0.0334883, -0.0353966,
  -0.0372989, -0.0391948, -0.041084, -0.0429664, -0.0448417,
  -0.0467096, -0.0485699, -0.0504223, -0.0522665, -0.0541023,
  -0.0559295, -0.0577478, -0.059557, -0.0613568, -0.063147,
  -0.0649273, -0.0666975, -0.0684574, -0.0702067, -0.0719453,
  -0.0736728, -0.0753891, -0.0770938, -0.0787869, -0.080468,
  -0.082137, -0.0837936, -0.0854377, -0.0870689, -0.0886871,
  -0.0902921, -0.0918837, -0.0934616, -0.0950257, -0.0965757,
  -0.0981116, -0.0996329, -0.10114, -0.102632, -0.104108, -0.10557,
  -0.107016, -0.108447, -0.109862, -0.111261, -0.112644, -0.114011,
  -0.115361, -0.116695, -0.118012, -0.119312, -0.120594, -0.12186,
  -0.123108, -0.124339, -0.125552, -0.126746, -0.127923, -0.129082,
  -0.130223, -0.131345, -0.132449, -0.133533, -0.134599, -0.135647,
  -0.136675, -0.137684, -0.138673, -0.139643, -0.140594, -0.141525,
  -0.142436, -0.143328, -0.144199, -0.14505, -0.145882, -0.146693,
  -0.147484, -0.148254, -0.149004, -0.149733, -0.150442, -0.15113,
  -0.151797, -0.152443, -0.153068, -0.153673, -0.154256, -0.154818,
  -0.155359, -0.155879, -0.156378, -0.156855, -0.157311, -0.157746,
  -0.158159, -0.158551, -0.158921, -0.15927, -0.159597, -0.159903,
  -0.160187, -0.160449, -0.16069, -0.160909, -0.161107, -0.161283,
  -0.161437, -0.16157, -0.161681, -0.161771, -0.161839, -0.161885,
  -0.16191, -0.161913, -0.161895, -0.161855, -0.161793, -0.16171,
  -0.161606, -0.161481, -0.161334, -0.161165, -0.160976, -0.160765,
  -0.160533, -0.16028, -0.160006, -0.15971, -0.159394, -0.159057,
  -0.158699, -0.158321, -0.157921, -0.157501, -0.157061, -0.1566,
  -0.156119, -0.155617, -0.155095, -0.154553, -0.153991, -0.153409,
  -0.152807, -0.152186, -0.151545, -0.150884, -0.150204, -0.149504,
  -0.148786, -0.148048, -0.147291, -0.146515, -0.145721, -0.144907,
  -0.144076, -0.143226, -0.142357, -0.141471, -0.140566, -0.139644,
  -0.138704, -0.137746, -0.136771, -0.135779, -0.134769, -0.133743,
  -0.132699, -0.131639, -0.130562, -0.129469, -0.12836, -0.127234,
  -0.126093, -0.124936, -0.123763, -0.122574, -0.121371, -0.120152,
  -0.118919, -0.11767, -0.116407, -0.11513, -0.113838, -0.112533,
  -0.111213, -0.10988, -0.108533, -0.107173, -0.1058, -0.104414,
  -0.103015, -0.101603, -0.10018, -0.0987435, -0.0972954, -0.0958356,
  -0.0943641, -0.0928813, -0.0913872, -0.0898822, -0.0883663,
  -0.0868398, -0.085303, -0.083756, -0.0821989, -0.0806321,
  -0.0790558, -0.07747, -0.0758751, -0.0742713, -0.0726588,
  -0.0710377, -0.0694083, -0.0677709, -0.0661256, -0.0644726,
  -0.0628121, -0.0611445, -0.0594698, -0.0577883, -0.0561003,
  -0.0544059, -0.0527054, -0.0509989, -0.0492868, -0.0475692,
  -0.0458463, -0.0441184, -0.0423857, -0.0406484, -0.0389067,
  -0.0371609, -0.0354112, -0.0336577, -0.0319008, -0.0301407,
  -0.0283775, -0.0266115, -0.0248429, -0.023072, -0.0212989,
  -0.019524, -0.0177473, -0.0159692, -0.0141899, -0.0124095,
  -0.0106283, -0.0088466, -0.00706453, -0.00528233, -0.00350023,
  -0.00171846, 6.27811e-05, 0.00184325, 0.00362274, 0.00540103,
  0.00717789, 0.0089531, 0.0107265, 0.0124977, 0.0142667, 0.0160331,
  0.0177969, 0.0195576, 0.0213152, 0.0230694, 0.0248201, 0.0265669,
  0.0283097, 0.0300482, 0.0317823, 0.0335118, 0.0352364, 0.0369559,
  0.0386701, 0.0403788, 0.0420819, 0.043779, 0.04547, 0.0471548,
  0.048833, 0.0505045, 0.0521691, 0.0538265, 0.0554767, 0.0571194,
  0.0587543, 0.0603814, 0.0620004, 0.0636111, 0.0652133, 0.0668068,
  0.0683916, 0.0699672, 0.0715337, 0.0730907, 0.0746382, 0.0761759,
  0.0777036, 0.0792212, 0.0807285, 0.0822254, 0.0837115, 0.0851869,
  0.0866512, 0.0881044, 0.0895462, 0.0909766, 0.0923952, 0.093802,
  0.0951969, 0.0965796, 0.0979499, 0.0993078, 0.100653, 0.101986,
  0.103305, 0.104612, 0.105905, 0.107185, 0.108451, 0.109704,
  0.110943, 0.112168, 0.113379, 0.114575, 0.115758, 0.116926,
  0.118079, 0.119217, 0.120341, 0.12145, 0.122543, 0.123622, 0.124685,
  0.125732, 0.126764, 0.12778, 0.128781, 0.129765, 0.130734, 0.131686,
  0.132623, 0.133543, 0.134446, 0.135333, 0.136203, 0.137057,
  0.137894, 0.138714, 0.139517, 0.140303, 0.141072, 0.141824,
  0.142558, 0.143275, 0.143975, 0.144657, 0.145321, 0.145968,
  0.146597, 0.147209, 0.147803, 0.148378, 0.148936, 0.149476,
  0.149998, 0.150502, 0.150987, 0.151455, 0.151904, 0.152335,
  0.152747, 0.153142, 0.153518, 0.153875, 0.154214, 0.154535,
  0.154837, 0.155121, 0.155386, 0.155633, 0.155861, 0.156071,
  0.156262, 0.156434, 0.156588, 0.156723, 0.15684, 0.156938, 0.157018,
  0.157078, 0.157121, 0.157144, 0.157149, 0.157136, 0.157104,
  0.157054, 0.156985, 0.156897, 0.156791, 0.156667, 0.156524,
  0.156363, 0.156184, 0.155986, 0.15577, 0.155536, 0.155283, 0.155013,
  0.154724, 0.154417, 0.154092, 0.153749, 0.153389, 0.15301, 0.152614,
  0.1522, 0.151768, 0.151319, 0.150852, 0.150368, 0.149866, 0.149347,
  0.148811, 0.148257, 0.147686, 0.147099, 0.146494, 0.145872,
  0.145234, 0.144579, 0.143907, 0.143219, 0.142514, 0.141793,
  0.141056, 0.140303, 0.139533, 0.138748, 0.137946, 0.137129,
  0.136297, 0.135449, 0.134585, 0.133706, 0.132812, 0.131902,
  0.130978, 0.130039, 0.129085, 0.128117, 0.127134, 0.126137,
  0.125125, 0.124099, 0.12306, 0.122006, 0.120939, 0.119858, 0.118763,
  0.117656, 0.116535, 0.115401, 0.114254, 0.113094, 0.111922,
  0.110737, 0.109539, 0.10833, 0.107109, 0.105875, 0.10463, 0.103373,
  0.102105, 0.100825, 0.0995346, 0.0982329, 0.0969203, 0.095597,
  0.0942632, 0.0929191, 0.0915647, 0.0902003, 0.088826, 0.0874419,
  0.0860484, 0.0846454, 0.0832332, 0.0818119, 0.0803817, 0.0789428,
  0.0774954, 0.0760396, 0.0745755, 0.0731034, 0.0716235, 0.0701358,
  0.0686407, 0.0671382, 0.0656285, 0.0641118, 0.0625883, 0.0610582,
  0.0595215, 0.0579787, 0.0564297, 0.0548747, 0.0533141, 0.0517479,
  0.0501762, 0.0485994, 0.0470176, 0.0454309, 0.0438396, 0.0422437,
  0.0406436, 0.0390394, 0.0374313, 0.0358194, 0.034204, 0.0325852,
  0.0309632, 0.0293382, 0.0277104, 0.02608, 0.0244471, 0.022812,
  0.0211748, 0.0195357, 0.0178949, 0.0162526, 0.0146089, 0.0129642,
  0.0113184, 0.00967188, 0.00802477, 0.00637726, 0.00472953,
  0.00308176, 0.00143415, -0.000213126, -0.00185988, -0.00350593,
  -0.00515108, -0.00679517, -0.00843799, -0.0100794, -0.0117191,
  -0.0133571, -0.0149931, -0.0166269, -0.0182583, -0.0198872,
  -0.0215134, -0.0231367, -0.0247569, -0.0263739, -0.0279875,
  -0.0295974, -0.0312036, -0.0328058, -0.0344038, -0.0359975,
  -0.0375868, -0.0391714, -0.0407511, -0.0423258, -0.0438954,
  -0.0454596, -0.0470182, -0.0485712, -0.0501183, -0.0516594,
  -0.0531942, -0.0547227, -0.0562447, -0.05776, -0.0592683,
  -0.0607697, -0.0622639, -0.0637507, -0.06523, -0.0667017,
  -0.0681655, -0.0696213, -0.071069, -0.0725084, -0.0739393,
  -0.0753616, -0.0767751, -0.0781798, -0.0795754, -0.0809617,
  -0.0823387, -0.0837062, -0.0850641, -0.0864121, -0.0877502,
  -0.0890782, -0.0903961, -0.0917035, -0.0930004, -0.0942867,
  -0.0955623, -0.0968269, -0.0980805, -0.0993229, -0.100554,
  -0.101774, -0.102982, -0.104178, -0.105363, -0.106535, -0.107696,
  -0.108845, -0.109981, -0.111104, -0.112216, -0.113314, -0.1144,
  -0.115473, -0.116533, -0.11758, -0.118613, -0.119634, -0.120641,
  -0.121634, -0.122614, -0.12358, -0.124532, -0.125471, -0.126395,
  -0.127305, -0.128201, -0.129083, -0.12995, -0.130803, -0.131642,
  -0.132466, -0.133275, -0.134069, -0.134848, -0.135613, -0.136362,
  -0.137097, -0.137816, -0.13852, -0.139209, -0.139882, -0.14054,
  -0.141182, -0.141809, -0.14242, -0.143016, -0.143596, -0.14416,
  -0.144708, -0.14524, -0.145756, -0.146257, -0.146741, -0.147209,
  -0.147661, -0.148097, -0.148517, -0.14892, -0.149308, -0.149678,
  -0.150033, -0.150371, -0.150693, -0.150998, -0.151287, -0.15156,
  -0.151816, -0.152055, -0.152278, -0.152484, -0.152674, -0.152847,
  -0.153004, -0.153144, -0.153268, -0.153374, -0.153465, -0.153538,
  -0.153595, -0.153636, -0.15366, -0.153667, -0.153658, -0.153632,
  -0.153589, -0.15353, -0.153455, -0.153363, -0.153254, -0.153129,
  -0.152987, -0.152829, -0.152655, -0.152464, -0.152257, -0.152033,
  -0.151794, -0.151538, -0.151265, -0.150977, -0.150672, -0.150352,
  -0.150015, -0.149662, -0.149293, -0.148909, -0.148508, -0.148091,
  -0.147659, -0.147211, -0.146748, -0.146268, -0.145774, -0.145263,
  -0.144738, -0.144197, -0.14364, -0.143069, -0.142482, -0.14188,
  -0.141263, -0.140631, -0.139984, -0.139323, -0.138646, -0.137956,
  -0.13725, -0.13653, -0.135796, -0.135047, -0.134284, -0.133507,
  -0.132716, -0.131911, -0.131092, -0.130259, -0.129413, -0.128553,
  -0.127679, -0.126792, -0.125892, -0.124979, -0.124052, -0.123113,
  -0.12216, -0.121195, -0.120218, -0.119227, -0.118225, -0.11721,
  -0.116182, -0.115143, -0.114092, -0.113028, -0.111953, -0.110867,
  -0.109769, -0.108659, -0.107539, -0.106407, -0.105264, -0.10411,
  -0.102945, -0.10177, -0.100584, -0.0993883, -0.098182, -0.0969655,
  -0.0957391, -0.0945028, -0.0932568, -0.0920012, -0.0907362,
  -0.0894618, -0.0881783, -0.0868858, -0.0855844, -0.0842742,
  -0.0829555, -0.0816282, -0.0802927, -0.078949, -0.0775972,
  -0.0762376, -0.0748702, -0.0734952, -0.0721128, -0.0707231,
  -0.0693263, -0.0679224, -0.0665117, -0.0650944, -0.0636704,
  -0.0622401, -0.0608036, -0.0593609, -0.0579124, -0.056458,
  -0.0549981, -0.0535326, -0.0520619, -0.050586, -0.0491051,
  -0.0476194, -0.046129, -0.0446341, -0.0431348, -0.0416313,
  -0.0401237, -0.0386123, -0.0370971, -0.0355784, -0.0340562,
  -0.0325308, -0.0310023, -0.0294709, -0.0279368, -0.0264, -0.0248607,
  -0.0233192, -0.0217756, -0.02023, -0.0186827, -0.0171337,
  -0.0155832, -0.0140314, -0.0124784, -0.0109245, -0.00936978,
  -0.00781437, -0.00625847, -0.00470223, -0.00314581, -0.00158939,
  -3.31145e-05, 0.00152285, 0.00307834, 0.00463319, 0.00618725,
  0.00774035, 0.00929233, 0.010843, 0.0123923, 0.01394, 0.0154859,
  0.0170298, 0.0185718, 0.0201114, 0.0216487, 0.0231834, 0.0247154,
  0.0262445, 0.0277706, 0.0292935, 0.0308131, 0.0323292, 0.0338416,
  0.0353502, 0.0368548, 0.0383554, 0.0398516, 0.0413434, 0.0428307,
  0.0443132, 0.0457908, 0.0472634, 0.0487309, 0.050193, 0.0516496,
  0.0531005, 0.0545458, 0.055985, 0.0574182, 0.0588452, 0.0602659,
  0.06168, 0.0630875, 0.0644882, 0.0658819, 0.0672686, 0.0686481,
  0.0700202, 0.0713848, 0.0727418, 0.074091, 0.0754323, 0.0767656,
  0.0780907, 0.0794075, 0.0807159, 0.0820157, 0.0833068, 0.084589,
  0.0858623, 0.0871266, 0.0883816, 0.0896272, 0.0908634, 0.0920901,
  0.093307, 0.094514, 0.0957112, 0.0968982, 0.0980751, 0.0992417,
  0.100398, 0.101543, 0.102678, 0.103803, 0.104916, 0.106018, 0.10711,
  0.10819, 0.109258, 0.110316, 0.111361, 0.112396, 0.113418, 0.114429,
  0.115427, 0.116414, 0.117389, 0.118351, 0.119301, 0.120239,
  0.121164, 0.122077, 0.122977, 0.123864, 0.124738, 0.1256, 0.126448,
  0.127283, 0.128105, 0.128914, 0.12971, 0.130492, 0.131261, 0.132016,
  0.132757, 0.133485, 0.134199, 0.134899, 0.135586, 0.136258,
  0.136916, 0.13756, 0.13819, 0.138806, 0.139408, 0.139995, 0.140568,
  0.141126, 0.14167, 0.142199, 0.142714, 0.143214, 0.1437, 0.14417,
  0.144626, 0.145067, 0.145494, 0.145905, 0.146302, 0.146683, 0.14705,
  0.147401, 0.147737, 0.148059, 0.148365, 0.148656, 0.148932,
  0.149193, 0.149438, 0.149669, 0.149884, 0.150083, 0.150268,
  0.150437, 0.150591, 0.150729, 0.150853, 0.150961, 0.151053, 0.15113,
  0.151192, 0.151239, 0.15127, 0.151286, 0.151286, 0.151272, 0.151241,
  0.151196, 0.151135, 0.151059, 0.150967, 0.150861, 0.150739,
  0.150602, 0.150449, 0.150282, 0.150099, 0.149901, 0.149688,
  0.149459, 0.149216, 0.148958, 0.148684, 0.148396, 0.148093,
  0.147774, 0.147441, 0.147093, 0.14673, 0.146353, 0.145961, 0.145554,
  0.145132, 0.144696, 0.144245, 0.14378, 0.1433, 0.142806, 0.142298,
  0.141775, 0.141238, 0.140687, 0.140122, 0.139543, 0.13895, 0.138343,
  0.137722, 0.137087, 0.136439, 0.135777, 0.135101, 0.134412,
  0.133709, 0.132993, 0.132264, 0.131522, 0.130766, 0.129998,
  0.129216, 0.128422, 0.127614, 0.126794, 0.125962, 0.125117,
  0.124259, 0.123389, 0.122507, 0.121613, 0.120706, 0.119788,
  0.118857, 0.117915, 0.116961, 0.115996, 0.115019, 0.11403, 0.113031,
  0.11202, 0.110998, 0.109965, 0.108921, 0.107866, 0.106801, 0.105725,
  0.104639, 0.103542, 0.102435, 0.101318, 0.100191, 0.0990546,
  0.0979079, 0.0967517, 0.0955859, 0.0944106, 0.0932261, 0.0920325,
  0.0908297, 0.0896181, 0.0883976, 0.0871685, 0.0859308, 0.0846847,
  0.0834303, 0.0821677, 0.0808971, 0.0796185, 0.0783322, 0.0770382,
  0.0757367, 0.0744278, 0.0731116, 0.0717883, 0.070458, 0.0691208,
  0.0677769, 0.0664265, 0.0650695, 0.0637063, 0.0623368, 0.0609613,
  0.05958, 0.0581928, 0.0568, 0.0554018, 0.0539981, 0.0525893,
  0.0511754, 0.0497566, 0.0483331, 0.0469048, 0.0454721, 0.0440351,
  0.0425938, 0.0411485, 0.0396992, 0.0382462, 0.0367895, 0.0353294,
  0.0338659, 0.0323993, 0.0309296, 0.029457, 0.0279816, 0.0265037,
  0.0250232, 0.0235405, 0.0220556, 0.0205687, 0.01908, 0.0175895,
  0.0160974, 0.014604, 0.0131092, 0.0116134, 0.0101165, 0.00861885,
  0.0071205, 0.00562162, 0.00412235, 0.00262286, 0.00112328,
  -0.000376242, -0.00187555, -0.00337449, -0.00487293, -0.00637071,
  -0.00786768, -0.0093637, -0.0108586, -0.0123523, -0.0138446,
  -0.0153353, -0.0168243, -0.0183116, -0.0197968, -0.0212799,
  -0.0227607, -0.0242391, -0.0257149, -0.027188, -0.0286583,
  -0.0301256, -0.0315897, -0.0330505, -0.0345079, -0.0359617,
  -0.0374118, -0.038858, -0.0403002, -0.0417383, -0.0431721,
  -0.0446015, -0.0460263, -0.0474464, -0.0488616, -0.0502719,
  -0.0516771, -0.053077, -0.0544714, -0.0558604, -0.0572437,
  -0.0586212, -0.0599927, -0.0613582, -0.0627175, -0.0640704,
  -0.0654169, -0.0667568, -0.0680899, -0.0694162, -0.0707355,
  -0.0720476, -0.0733526, -0.0746501, -0.0759402, -0.0772226,
  -0.0784973, -0.0797641, -0.0810229, -0.0822735, -0.083516,
  -0.0847501, -0.0859757, -0.0871927, -0.088401, -0.0896004,
  -0.090791, -0.0919724, -0.0931447, -0.0943076, -0.0954612,
  -0.0966052, -0.0977397, -0.0988643, -0.0999792, -0.101084,
  -0.102179, -0.103264, -0.104338, -0.105402, -0.106456, -0.107498,
  -0.108531, -0.109552, -0.110563, -0.111563, -0.112551, -0.113529,
  -0.114495, -0.11545, -0.116393, -0.117325, -0.118245, -0.119154,
  -0.12005, -0.120935, -0.121808, -0.122669, -0.123518, -0.124354,
  -0.125178, -0.12599, -0.12679, -0.127577, -0.128351, -0.129112,
  -0.129861, -0.130597, -0.13132, -0.132031, -0.132728, -0.133412,
  -0.134083, -0.134741, -0.135385, -0.136016, -0.136634, -0.137238,
  -0.137829, -0.138406, -0.13897, -0.13952, -0.140056, -0.140578,
  -0.141087, -0.141581, -0.142062, -0.142529, -0.142982, -0.143421,
  -0.143845, -0.144256, -0.144652, -0.145034, -0.145402, -0.145756,
  -0.146096, -0.146421, -0.146731, -0.147028, -0.147309, -0.147577,
  -0.14783, -0.148068, -0.148292, -0.148502, -0.148697, -0.148877,
  -0.149043, -0.149194, -0.149331, -0.149453, -0.14956, -0.149653,
  -0.149731, -0.149794, -0.149843, -0.149877, -0.149897, -0.149901,
  -0.149892, -0.149867, -0.149828, -0.149774, -0.149706, -0.149623,
  -0.149525, -0.149413, -0.149286, -0.149145, -0.148989, -0.148818,
  -0.148633, -0.148434, -0.14822, -0.147992, -0.147749, -0.147491,
  -0.14722, -0.146934, -0.146634, -0.146319, -0.14599, -0.145647,
  -0.14529, -0.144919, -0.144533, -0.144134, -0.14372, -0.143292,
  -0.142851, -0.142395, -0.141926, -0.141443, -0.140946, -0.140436,
  -0.139912, -0.139374, -0.138822, -0.138258, -0.137679, -0.137088,
  -0.136483, -0.135865, -0.135233, -0.134589, -0.133931, -0.13326,
  -0.132577, -0.13188, -0.131171, -0.130449, -0.129715, -0.128967,
  -0.128208, -0.127436, -0.126651, -0.125854, -0.125045, -0.124224,
  -0.123391, -0.122546, -0.121689, -0.12082, -0.11994, -0.119048,
  -0.118144, -0.117229, -0.116303, -0.115365, -0.114416, -0.113457,
  -0.112486, -0.111504, -0.110512, -0.109508, -0.108495, -0.10747,
  -0.106436, -0.105391, -0.104335, -0.10327, -0.102195, -0.10111,
  -0.100015, -0.0989106, -0.0977966, -0.0966731, -0.0955403,
  -0.0943982, -0.0932471, -0.0920869, -0.0909179, -0.0897401,
  -0.0885537, -0.0873587, -0.0861553, -0.0849436, -0.0837237,
  -0.0824957, -0.0812598, -0.0800161, -0.0787646, -0.0775056,
  -0.0762391, -0.0749653, -0.0736843, -0.0723962, -0.0711011,
  -0.0697992, -0.0684906, -0.0671754, -0.0658537, -0.0645257,
  -0.0631915, -0.0618513, -0.0605051, -0.0591531, -0.0577955,
  -0.0564323, -0.0550637, -0.0536898, -0.0523107, -0.0509267,
  -0.0495378, -0.0481441, -0.0467459, -0.0453431, -0.0439361,
  -0.0425248, -0.0411095, -0.0396903, -0.0382672, -0.0368406,
  -0.0354104, -0.0339768, -0.03254, -0.0311002, -0.0296573,
  -0.0282117, -0.0267634, -0.0253126, -0.0238593, -0.0224038,
  -0.0209462, -0.0194867, -0.0180253, -0.0165622, -0.0150976,
  -0.0136316, -0.0121643, -0.0106959, -0.00922648, -0.00775626,
  -0.00628535, -0.00481388, -0.00334201, -0.00186987, -0.000397602,
  0.00107465, 0.00254673, 0.00401852, 0.00548986, 0.00696062,
  0.00843064, 0.0098998, 0.0113679, 0.0128349, 0.0143006, 0.0157649,
  0.0172276, 0.0186885, 0.0201476, 0.0216047, 0.0230597, 0.0245124,
  0.0259626, 0.0274103, 0.0288553, 0.0302975, 0.0317366, 0.0331727,
  0.0346055, 0.0360349, 0.0374607, 0.0388829, 0.0403013, 0.0417158,
  0.0431262, 0.0445323, 0.0459341, 0.0473314, 0.0487241, 0.0501121,
  0.0514951, 0.0528731, 0.054246, 0.0556136, 0.0569758, 0.0583324,
  0.0596833, 0.0610284, 0.0623676, 0.0637008, 0.0650277, 0.0663483,
  0.0676624, 0.06897, 0.0702709, 0.0715649, 0.072852, 0.074132,
  0.0754048, 0.0766703, 0.0779284, 0.0791788, 0.0804216, 0.0816566,
  0.0828837, 0.0841027, 0.0853136, 0.0865162, 0.0877104, 0.0888961,
  0.0900731, 0.0912415, 0.092401, 0.0935515, 0.094693, 0.0958253,
  0.0969483, 0.098062, 0.0991661, 0.100261, 0.101345, 0.10242,
  0.103486, 0.104541, 0.105586, 0.10662, 0.107645, 0.108659, 0.109662,
  0.110655, 0.111637, 0.112608, 0.113569, 0.114518, 0.115457,
  0.116384, 0.1173, 0.118204, 0.119098, 0.119979, 0.120849, 0.121708,
  0.122554, 0.123389, 0.124212, 0.125022, 0.125821, 0.126608,
  0.127382, 0.128144, 0.128894, 0.129631, 0.130355, 0.131067,
  0.131767, 0.132453, 0.133127, 0.133788, 0.134436, 0.135071,
  0.135693, 0.136302, 0.136898, 0.13748, 0.138049, 0.138605, 0.139148,
  0.139677, 0.140192, 0.140694, 0.141183, 0.141657, 0.142118,
  0.142566, 0.142999, 0.143419, 0.143825, 0.144217, 0.144595,
  0.144959, 0.145309, 0.145646, 0.145968, 0.146276, 0.146569,
  0.146849, 0.147114, 0.147366, 0.147603, 0.147826, 0.148034,
  0.148228, 0.148408, 0.148574, 0.148725, 0.148862, 0.148984,
  0.149093, 0.149186, 0.149266, 0.149331, 0.149381, 0.149417,
  0.149439, 0.149446, 0.149439, 0.149417, 0.149381, 0.149331,
  0.149266, 0.149186, 0.149093, 0.148984, 0.148862, 0.148725,
  0.148574, 0.148408, 0.148228, 0.148034, 0.147826, 0.147603,
  0.147366, 0.147114, 0.146849, 0.146569, 0.146276, 0.145968,
  0.145646, 0.145309, 0.144959, 0.144595, 0.144217, 0.143825,
  0.143419, 0.142999, 0.142566, 0.142118, 0.141657, 0.141183,
  0.140694, 0.140192, 0.139677, 0.139148, 0.138605, 0.138049, 0.13748,
  0.136898, 0.136302, 0.135693, 0.135071, 0.134436, 0.133788,
  0.133127, 0.132453, 0.131767, 0.131067, 0.130355, 0.129631,
  0.128894, 0.128144, 0.127382, 0.126608, 0.125821, 0.125022,
  0.124212, 0.123389, 0.122554, 0.121708, 0.120849, 0.119979,
  0.119098, 0.118204, 0.1173, 0.116384, 0.115457, 0.114518, 0.113569,
  0.112608, 0.111637, 0.110655, 0.109662, 0.108659, 0.107645, 0.10662,
  0.105586, 0.104541, 0.103486, 0.10242, 0.101345, 0.100261,
  0.0991661, 0.098062, 0.0969483, 0.0958253, 0.094693, 0.0935515,
  0.092401, 0.0912415, 0.0900731, 0.0888961, 0.0877104, 0.0865162,
  0.0853136, 0.0841027, 0.0828837, 0.0816566, 0.0804216, 0.0791788,
  0.0779284, 0.0766703, 0.0754048, 0.074132, 0.072852, 0.0715649,
  0.0702709, 0.06897, 0.0676624, 0.0663483, 0.0650277, 0.0637008,
  0.0623676, 0.0610284, 0.0596833, 0.0583324, 0.0569758, 0.0556136,
  0.054246, 0.0528731, 0.0514951, 0.0501121, 0.0487241, 0.0473314,
  0.0459341, 0.0445323, 0.0431262, 0.0417158, 0.0403013, 0.0388829,
  0.0374607, 0.0360349, 0.0346055, 0.0331727, 0.0317366, 0.0302975,
  0.0288553, 0.0274103, 0.0259626, 0.0245124, 0.0230597, 0.0216047,
  0.0201476, 0.0186885, 0.0172276, 0.0157649, 0.0143006, 0.0128349,
  0.0113679, 0.0098998, 0.00843064, 0.00696062, 0.00548986,
  0.00401852, 0.00254673, 0.00107465, -0.000397602, -0.00186987,
  -0.00334201, -0.00481388, -0.00628535, -0.00775626, -0.00922648,
  -0.0106959, -0.0121643, -0.0136316, -0.0150976, -0.0165622,
  -0.0180253, -0.0194867, -0.0209462, -0.0224038, -0.0238593,
  -0.0253126, -0.0267634, -0.0282117, -0.0296573, -0.0311002,
  -0.03254, -0.0339768, -0.0354104, -0.0368406, -0.0382672,
  -0.0396903, -0.0411095, -0.0425248, -0.0439361, -0.0453431,
  -0.0467459, -0.0481441, -0.0495378, -0.0509267, -0.0523107,
  -0.0536898, -0.0550637, -0.0564323, -0.0577955, -0.0591531,
  -0.0605051, -0.0618513, -0.0631915, -0.0645257, -0.0658537,
  -0.0671754, -0.0684906, -0.0697992, -0.0711011, -0.0723962,
  -0.0736843, -0.0749653, -0.0762391, -0.0775056, -0.0787646,
  -0.0800161, -0.0812598, -0.0824957, -0.0837237, -0.0849436,
  -0.0861553, -0.0873587, -0.0885537, -0.0897401, -0.0909179,
  -0.0920869, -0.0932471, -0.0943982, -0.0955403, -0.0966731,
  -0.0977966, -0.0989106, -0.100015, -0.10111, -0.102195, -0.10327,
  -0.104335, -0.105391, -0.106436, -0.10747, -0.108495, -0.109508,
  -0.110512, -0.111504, -0.112486, -0.113457, -0.114416, -0.115365,
  -0.116303, -0.117229, -0.118144, -0.119048, -0.11994, -0.12082,
  -0.121689, -0.122546, -0.123391, -0.124224, -0.125045, -0.125854,
  -0.126651, -0.127436, -0.128208, -0.128967, -0.129715, -0.130449,
  -0.131171, -0.13188, -0.132577, -0.13326, -0.133931, -0.134589,
  -0.135233, -0.135865, -0.136483, -0.137088, -0.137679, -0.138258,
  -0.138822, -0.139374, -0.139912, -0.140436, -0.140946, -0.141443,
  -0.141926, -0.142395, -0.142851, -0.143292, -0.14372, -0.144134,
  -0.144533, -0.144919, -0.14529, -0.145647, -0.14599, -0.146319,
  -0.146634, -0.146934, -0.14722, -0.147491, -0.147749, -0.147992,
  -0.14822, -0.148434, -0.148633, -0.148818, -0.148989, -0.149145,
  -0.149286, -0.149413, -0.149525, -0.149623, -0.149706, -0.149774,
  -0.149828, -0.149867, -0.149892, -0.149901, -0.149897, -0.149877,
  -0.149843, -0.149794, -0.149731, -0.149653, -0.14956, -0.149453,
  -0.149331, -0.149194, -0.149043, -0.148877, -0.148697, -0.148502,
  -0.148292, -0.148068, -0.14783, -0.147577, -0.147309, -0.147028,
  -0.146731, -0.146421, -0.146096, -0.145756, -0.145402, -0.145034,
  -0.144652, -0.144256, -0.143845, -0.143421, -0.142982, -0.142529,
  -0.142062, -0.141581, -0.141087, -0.140578, -0.140056, -0.13952,
  -0.13897, -0.138406, -0.137829, -0.137238, -0.136634, -0.136016,
  -0.135385, -0.134741, -0.134083, -0.133412, -0.132728, -0.132031,
  -0.13132, -0.130597, -0.129861, -0.129112, -0.128351, -0.127577,
  -0.12679, -0.12599, -0.125178, -0.124354, -0.123518, -0.122669,
  -0.121808, -0.120935, -0.12005, -0.119154, -0.118245, -0.117325,
  -0.116393, -0.11545, -0.114495, -0.113529, -0.112551, -0.111563,
  -0.110563, -0.109552, -0.108531, -0.107498, -0.106456, -0.105402,
  -0.104338, -0.103264, -0.102179, -0.101084, -0.0999792, -0.0988643,
  -0.0977397, -0.0966052, -0.0954612, -0.0943076, -0.0931447,
  -0.0919724, -0.090791, -0.0896004, -0.088401, -0.0871927,
  -0.0859757, -0.0847501, -0.083516, -0.0822735, -0.0810229,
  -0.0797641, -0.0784973, -0.0772226, -0.0759402, -0.0746501,
  -0.0733526, -0.0720476, -0.0707355, -0.0694162, -0.0680899,
  -0.0667568, -0.0654169, -0.0640704, -0.0627175, -0.0613582,
  -0.0599927, -0.0586212, -0.0572437, -0.0558604, -0.0544714,
  -0.053077, -0.0516771, -0.0502719, -0.0488616, -0.0474464,
  -0.0460263, -0.0446015, -0.0431721, -0.0417383, -0.0403002,
  -0.038858, -0.0374118, -0.0359617, -0.0345079, -0.0330505,
  -0.0315897, -0.0301256, -0.0286583, -0.027188, -0.0257149,
  -0.0242391, -0.0227607, -0.0212799, -0.0197968, -0.0183116,
  -0.0168243, -0.0153353, -0.0138446, -0.0123523, -0.0108586,
  -0.0093637, -0.00786768, -0.00637071, -0.00487293, -0.00337449,
  -0.00187555, -0.000376242, 0.00112328, 0.00262286, 0.00412235,
  0.00562162, 0.0071205, 0.00861885, 0.0101165, 0.0116134, 0.0131092,
  0.014604, 0.0160974, 0.0175895, 0.01908, 0.0205687, 0.0220556,
  0.0235405, 0.0250232, 0.0265037, 0.0279816, 0.029457, 0.0309296,
  0.0323993, 0.0338659, 0.0353294, 0.0367895, 0.0382462, 0.0396992,
  0.0411485, 0.0425938, 0.0440351, 0.0454721, 0.0469048, 0.0483331,
  0.0497566, 0.0511754, 0.0525893, 0.0539981, 0.0554018, 0.0568,
  0.0581928, 0.05958, 0.0609613, 0.0623368, 0.0637063, 0.0650695,
  0.0664265, 0.0677769, 0.0691208, 0.070458, 0.0717883, 0.0731116,
  0.0744278, 0.0757367, 0.0770382, 0.0783322, 0.0796185, 0.0808971,
  0.0821677, 0.0834303, 0.0846847, 0.0859308, 0.0871685, 0.0883976,
  0.0896181, 0.0908297, 0.0920325, 0.0932261, 0.0944106, 0.0955859,
  0.0967517, 0.0979079, 0.0990546, 0.100191, 0.101318, 0.102435,
  0.103542, 0.104639, 0.105725, 0.106801, 0.107866, 0.108921,
  0.109965, 0.110998, 0.11202, 0.113031, 0.11403, 0.115019, 0.115996,
  0.116961, 0.117915, 0.118857, 0.119788, 0.120706, 0.121613,
  0.122507, 0.123389, 0.124259, 0.125117, 0.125962, 0.126794,
  0.127614, 0.128422, 0.129216, 0.129998, 0.130766, 0.131522,
  0.132264, 0.132993, 0.133709, 0.134412, 0.135101, 0.135777,
  0.136439, 0.137087, 0.137722, 0.138343, 0.13895, 0.139543, 0.140122,
  0.140687, 0.141238, 0.141775, 0.142298, 0.142806, 0.1433, 0.14378,
  0.144245, 0.144696, 0.145132, 0.145554, 0.145961, 0.146353, 0.14673,
  0.147093, 0.147441, 0.147774, 0.148093, 0.148396, 0.148684,
  0.148958, 0.149216, 0.149459, 0.149688, 0.149901, 0.150099,
  0.150282, 0.150449, 0.150602, 0.150739, 0.150861, 0.150967,
  0.151059, 0.151135, 0.151196, 0.151241, 0.151272, 0.151286,
  0.151286, 0.15127, 0.151239, 0.151192, 0.15113, 0.151053, 0.150961,
  0.150853, 0.150729, 0.150591, 0.150437, 0.150268, 0.150083,
  0.149884, 0.149669, 0.149438, 0.149193, 0.148932, 0.148656,
  0.148365, 0.148059, 0.147737, 0.147401, 0.14705, 0.146683, 0.146302,
  0.145905, 0.145494, 0.145067, 0.144626, 0.14417, 0.1437, 0.143214,
  0.142714, 0.142199, 0.14167, 0.141126, 0.140568, 0.139995, 0.139408,
  0.138806, 0.13819, 0.13756, 0.136916, 0.136258, 0.135586, 0.134899,
  0.134199, 0.133485, 0.132757, 0.132016, 0.131261, 0.130492, 0.12971,
  0.128914, 0.128105, 0.127283, 0.126448, 0.1256, 0.124738, 0.123864,
  0.122977, 0.122077, 0.121164, 0.120239, 0.119301, 0.118351,
  0.117389, 0.116414, 0.115427, 0.114429, 0.113418, 0.112396,
  0.111361, 0.110316, 0.109258, 0.10819, 0.10711, 0.106018, 0.104916,
  0.103803, 0.102678, 0.101543, 0.100398, 0.0992417, 0.0980751,
  0.0968982, 0.0957112, 0.094514, 0.093307, 0.0920901, 0.0908634,
  0.0896272, 0.0883816, 0.0871266, 0.0858623, 0.084589, 0.0833068,
  0.0820157, 0.0807159, 0.0794075, 0.0780907, 0.0767656, 0.0754323,
  0.074091, 0.0727418, 0.0713848, 0.0700202, 0.0686481, 0.0672686,
  0.0658819, 0.0644882, 0.0630875, 0.06168, 0.0602659, 0.0588452,
  0.0574182, 0.055985, 0.0545458, 0.0531005, 0.0516496, 0.050193,
  0.0487309, 0.0472634, 0.0457908, 0.0443132, 0.0428307, 0.0413434,
  0.0398516, 0.0383554, 0.0368548, 0.0353502, 0.0338416, 0.0323292,
  0.0308131, 0.0292935, 0.0277706, 0.0262445, 0.0247154, 0.0231834,
  0.0216487, 0.0201114, 0.0185718, 0.0170298, 0.0154859, 0.01394,
  0.0123923, 0.010843, 0.00929233, 0.00774035, 0.00618725, 0.00463319,
  0.00307834, 0.00152285, -3.31145e-05, -0.00158939, -0.00314581,
  -0.00470223, -0.00625847, -0.00781437, -0.00936978, -0.0109245,
  -0.0124784, -0.0140314, -0.0155832, -0.0171337, -0.0186827,
  -0.02023, -0.0217756, -0.0233192, -0.0248607, -0.0264, -0.0279368,
  -0.0294709, -0.0310023, -0.0325308, -0.0340562, -0.0355784,
  -0.0370971, -0.0386123, -0.0401237, -0.0416313, -0.0431348,
  -0.0446341, -0.046129, -0.0476194, -0.0491051, -0.050586,
  -0.0520619, -0.0535326, -0.0549981, -0.056458, -0.0579124,
  -0.0593609, -0.0608036, -0.0622401, -0.0636704, -0.0650944,
  -0.0665117, -0.0679224, -0.0693263, -0.0707231, -0.0721128,
  -0.0734952, -0.0748702, -0.0762376, -0.0775972, -0.078949,
  -0.0802927, -0.0816282, -0.0829555, -0.0842742, -0.0855844,
  -0.0868858, -0.0881783, -0.0894618, -0.0907362, -0.0920012,
  -0.0932568, -0.0945028, -0.0957391, -0.0969655, -0.098182,
  -0.0993883, -0.100584, -0.10177, -0.102945, -0.10411, -0.105264,
  -0.106407, -0.107539, -0.108659, -0.109769, -0.110867, -0.111953,
  -0.113028, -0.114092, -0.115143, -0.116182, -0.11721, -0.118225,
  -0.119227, -0.120218, -0.121195, -0.12216, -0.123113, -0.124052,
  -0.124979, -0.125892, -0.126792, -0.127679, -0.128553, -0.129413,
  -0.130259, -0.131092, -0.131911, -0.132716, -0.133507, -0.134284,
  -0.135047, -0.135796, -0.13653, -0.13725, -0.137956, -0.138646,
  -0.139323, -0.139984, -0.140631, -0.141263, -0.14188, -0.142482,
  -0.143069, -0.14364, -0.144197, -0.144738, -0.145263, -0.145774,
  -0.146268, -0.146748, -0.147211, -0.147659, -0.148091, -0.148508,
  -0.148909, -0.149293, -0.149662, -0.150015, -0.150352, -0.150672,
  -0.150977, -0.151265, -0.151538, -0.151794, -0.152033, -0.152257,
  -0.152464, -0.152655, -0.152829, -0.152987, -0.153129, -0.153254,
  -0.153363, -0.153455, -0.15353, -0.153589, -0.153632, -0.153658,
  -0.153667, -0.15366, -0.153636, -0.153595, -0.153538, -0.153465,
  -0.153374, -0.153268, -0.153144, -0.153004, -0.152847, -0.152674,
  -0.152484, -0.152278, -0.152055, -0.151816, -0.15156, -0.151287,
  -0.150998, -0.150693, -0.150371, -0.150033, -0.149678, -0.149308,
  -0.14892, -0.148517, -0.148097, -0.147661, -0.147209, -0.146741,
  -0.146257, -0.145756, -0.14524, -0.144708, -0.14416, -0.143596,
  -0.143016, -0.14242, -0.141809, -0.141182, -0.14054, -0.139882,
  -0.139209, -0.13852, -0.137816, -0.137097, -0.136362, -0.135613,
  -0.134848, -0.134069, -0.133275, -0.132466, -0.131642, -0.130803,
  -0.12995, -0.129083, -0.128201, -0.127305, -0.126395, -0.125471,
  -0.124532, -0.12358, -0.122614, -0.121634, -0.120641, -0.119634,
  -0.118613, -0.11758, -0.116533, -0.115473, -0.1144, -0.113314,
  -0.112216, -0.111104, -0.109981, -0.108845, -0.107696, -0.106535,
  -0.105363, -0.104178, -0.102982, -0.101774, -0.100554, -0.0993229,
  -0.0980805, -0.0968269, -0.0955623, -0.0942867, -0.0930004,
  -0.0917035, -0.0903961, -0.0890782, -0.0877502, -0.0864121,
  -0.0850641, -0.0837062, -0.0823387, -0.0809617, -0.0795754,
  -0.0781798, -0.0767751, -0.0753616, -0.0739393, -0.0725084,
  -0.071069, -0.0696213, -0.0681655, -0.0667017, -0.06523, -0.0637507,
  -0.0622639, -0.0607697, -0.0592683, -0.05776, -0.0562447,
  -0.0547227, -0.0531942, -0.0516594, -0.0501183, -0.0485712,
  -0.0470182, -0.0454596, -0.0438954, -0.0423258, -0.0407511,
  -0.0391714, -0.0375868, -0.0359975, -0.0344038, -0.0328058,
  -0.0312036, -0.0295974, -0.0279875, -0.0263739, -0.0247569,
  -0.0231367, -0.0215134, -0.0198872, -0.0182583, -0.0166269,
  -0.0149931, -0.0133571, -0.0117191, -0.0100794, -0.00843799,
  -0.00679517, -0.00515108, -0.00350593, -0.00185988, -0.000213126,
  0.00143415, 0.00308176, 0.00472953, 0.00637726, 0.00802477,
  0.00967188, 0.0113184, 0.0129642, 0.0146089, 0.0162526, 0.0178949,
  0.0195357, 0.0211748, 0.022812, 0.0244471, 0.02608, 0.0277104,
  0.0293382, 0.0309632, 0.0325852, 0.034204, 0.0358194, 0.0374313,
  0.0390394, 0.0406436, 0.0422437, 0.0438396, 0.0454309, 0.0470176,
  0.0485994, 0.0501762, 0.0517479, 0.0533141, 0.0548747, 0.0564297,
  0.0579787, 0.0595215, 0.0610582, 0.0625883, 0.0641118, 0.0656285,
  0.0671382, 0.0686407, 0.0701358, 0.0716235, 0.0731034, 0.0745755,
  0.0760396, 0.0774954, 0.0789428, 0.0803817, 0.0818119, 0.0832332,
  0.0846454, 0.0860484, 0.0874419, 0.088826, 0.0902003, 0.0915647,
  0.0929191, 0.0942632, 0.095597, 0.0969203, 0.0982329, 0.0995346,
  0.100825, 0.102105, 0.103373, 0.10463, 0.105875, 0.107109, 0.10833,
  0.109539, 0.110737, 0.111922, 0.113094, 0.114254, 0.115401,
  0.116535, 0.117656, 0.118763, 0.119858, 0.120939, 0.122006, 0.12306,
  0.124099, 0.125125, 0.126137, 0.127134, 0.128117, 0.129085,
  0.130039, 0.130978, 0.131902, 0.132812, 0.133706, 0.134585,
  0.135449, 0.136297, 0.137129, 0.137946, 0.138748, 0.139533,
  0.140303, 0.141056, 0.141793, 0.142514, 0.143219, 0.143907,
  0.144579, 0.145234, 0.145872, 0.146494, 0.147099, 0.147686,
  0.148257, 0.148811, 0.149347, 0.149866, 0.150368, 0.150852,
  0.151319, 0.151768, 0.1522, 0.152614, 0.15301, 0.153389, 0.153749,
  0.154092, 0.154417, 0.154724, 0.155013, 0.155283, 0.155536, 0.15577,
  0.155986, 0.156184, 0.156363, 0.156524, 0.156667, 0.156791,
  0.156897, 0.156985, 0.157054, 0.157104, 0.157136, 0.157149,
  0.157144, 0.157121, 0.157078, 0.157018, 0.156938, 0.15684, 0.156723,
  0.156588, 0.156434, 0.156262, 0.156071, 0.155861, 0.155633,
  0.155386, 0.155121, 0.154837, 0.154535, 0.154214, 0.153875,
  0.153518, 0.153142, 0.152747, 0.152335, 0.151904, 0.151455,
  0.150987, 0.150502, 0.149998, 0.149476, 0.148936, 0.148378,
  0.147803, 0.147209, 0.146597, 0.145968, 0.145321, 0.144657,
  0.143975, 0.143275, 0.142558, 0.141824, 0.141072, 0.140303,
  0.139517, 0.138714, 0.137894, 0.137057, 0.136203, 0.135333,
  0.134446, 0.133543, 0.132623, 0.131686, 0.130734, 0.129765,
  0.128781, 0.12778, 0.126764, 0.125732, 0.124685, 0.123622, 0.122543,
  0.12145, 0.120341, 0.119217, 0.118079, 0.116926, 0.115758, 0.114575,
  0.113379, 0.112168, 0.110943, 0.109704, 0.108451, 0.107185,
  0.105905, 0.104612, 0.103305, 0.101986, 0.100653, 0.0993078,
  0.0979499, 0.0965796, 0.0951969, 0.093802, 0.0923952, 0.0909766,
  0.0895462, 0.0881044, 0.0866512, 0.0851869, 0.0837115, 0.0822254,
  0.0807285, 0.0792212, 0.0777036, 0.0761759, 0.0746382, 0.0730907,
  0.0715337, 0.0699672, 0.0683916, 0.0668068, 0.0652133, 0.0636111,
  0.0620004, 0.0603814, 0.0587543, 0.0571194, 0.0554767, 0.0538265,
  0.0521691, 0.0505045, 0.048833, 0.0471548, 0.04547, 0.043779,
  0.0420819, 0.0403788, 0.0386701, 0.0369559, 0.0352364, 0.0335118,
  0.0317823, 0.0300482, 0.0283097, 0.0265669, 0.0248201, 0.0230694,
  0.0213152, 0.0195576, 0.0177969, 0.0160331, 0.0142667, 0.0124977,
  0.0107265, 0.0089531, 0.00717789, 0.00540103, 0.00362274,
  0.00184325, 6.27811e-05, -0.00171846, -0.00350023, -0.00528233,
  -0.00706453, -0.0088466, -0.0106283, -0.0124095, -0.0141899,
  -0.0159692, -0.0177473, -0.019524, -0.0212989, -0.023072,
  -0.0248429, -0.0266115, -0.0283775, -0.0301407, -0.0319008,
  -0.0336577, -0.0354112, -0.0371609, -0.0389067, -0.0406484,
  -0.0423857, -0.0441184, -0.0458463, -0.0475692, -0.0492868,
  -0.0509989, -0.0527054, -0.0544059, -0.0561003, -0.0577883,
  -0.0594698, -0.0611445, -0.0628121, -0.0644726, -0.0661256,
  -0.0677709, -0.0694083, -0.0710377, -0.0726588, -0.0742713,
  -0.0758751, -0.07747, -0.0790558, -0.0806321, -0.0821989, -0.083756,
  -0.085303, -0.0868398, -0.0883663, -0.0898822, -0.0913872,
  -0.0928813, -0.0943641, -0.0958356, -0.0972954, -0.0987435,
  -0.10018, -0.101603, -0.103015, -0.104414, -0.1058, -0.107173,
  -0.108533, -0.10988, -0.111213, -0.112533, -0.113838, -0.11513,
  -0.116407, -0.11767, -0.118919, -0.120152, -0.121371, -0.122574,
  -0.123763, -0.124936, -0.126093, -0.127234, -0.12836, -0.129469,
  -0.130562, -0.131639, -0.132699, -0.133743, -0.134769, -0.135779,
  -0.136771, -0.137746, -0.138704, -0.139644, -0.140566, -0.141471,
  -0.142357, -0.143226, -0.144076, -0.144907, -0.145721, -0.146515,
  -0.147291, -0.148048, -0.148786, -0.149504, -0.150204, -0.150884,
  -0.151545, -0.152186, -0.152807, -0.153409, -0.153991, -0.154553,
  -0.155095, -0.155617, -0.156119, -0.1566, -0.157061, -0.157501,
  -0.157921, -0.158321, -0.158699, -0.159057, -0.159394, -0.15971,
  -0.160006, -0.16028, -0.160533, -0.160765, -0.160976, -0.161165,
  -0.161334, -0.161481, -0.161606, -0.16171, -0.161793, -0.161855,
  -0.161895, -0.161913, -0.16191, -0.161885, -0.161839, -0.161771,
  -0.161681, -0.16157, -0.161437, -0.161283, -0.161107, -0.160909,
  -0.16069, -0.160449, -0.160187, -0.159903, -0.159597, -0.15927,
  -0.158921, -0.158551, -0.158159, -0.157746, -0.157311, -0.156855,
  -0.156378, -0.155879, -0.155359, -0.154818, -0.154256, -0.153673,
  -0.153068, -0.152443, -0.151797, -0.15113, -0.150442, -0.149733,
  -0.149004, -0.148254, -0.147484, -0.146693, -0.145882, -0.14505,
  -0.144199, -0.143328, -0.142436, -0.141525, -0.140594, -0.139643,
  -0.138673, -0.137684, -0.136675, -0.135647, -0.134599, -0.133533,
  -0.132449, -0.131345, -0.130223, -0.129082, -0.127923, -0.126746,
  -0.125552, -0.124339, -0.123108, -0.12186, -0.120594, -0.119312,
  -0.118012, -0.116695, -0.115361, -0.114011, -0.112644, -0.111261,
  -0.109862, -0.108447, -0.107016, -0.10557, -0.104108, -0.102632,
  -0.10114, -0.0996329, -0.0981116, -0.0965757, -0.0950257,
  -0.0934616, -0.0918837, -0.0902921, -0.0886871, -0.0870689,
  -0.0854377, -0.0837936, -0.082137, -0.080468, -0.0787869,
  -0.0770938, -0.0753891, -0.0736728, -0.0719453, -0.0702067,
  -0.0684574, -0.0666975, -0.0649273, -0.063147, -0.0613568,
  -0.059557, -0.0577478, -0.0559295, -0.0541023, -0.0522665,
  -0.0504223, -0.0485699, -0.0467096, -0.0448417, -0.0429664,
  -0.041084, -0.0391948, -0.0372989, -0.0353966, -0.0334883,
  -0.0315741, -0.0296544, -0.0277293, -0.0257993, -0.0238644,
  -0.0219251, -0.0199815, -0.018034, -0.0160828, -0.0141282,
  -0.0121704, -0.0102098, -0.00824656, -0.00628104, -0.00431347,
  -0.00234415, -0.000373351, 0.00159865, 0.00357157, 0.00554513,
  0.00751905, 0.00949304, 0.0114668, 0.0134401, 0.0154127, 0.0173841,
  0.0193543, 0.0213228, 0.0232894, 0.0252538, 0.0272157, 0.0291749,
  0.031131, 0.0330838, 0.035033, 0.0369782, 0.0389193, 0.0408559,
  0.0427877, 0.0447145, 0.046636, 0.0485519, 0.0504618, 0.0523656,
  0.0542629, 0.0561535, 0.058037, 0.0599133, 0.0617819, 0.0636427,
  0.0654953, 0.0673395, 0.0691749, 0.0710014, 0.0728186, 0.0746263,
  0.0764241, 0.0782119, 0.0799893, 0.081756, 0.0835119, 0.0852565,
  0.0869897, 0.0887112, 0.0904207, 0.092118, 0.0938027, 0.0954746,
  0.0971336, 0.0987792, 0.100411, 0.102029, 0.103634, 0.105223,
  0.106799, 0.108359, 0.109904, 0.111434, 0.112949, 0.114448, 0.11593,
  0.117396, 0.118846, 0.120279, 0.121695, 0.123094, 0.124475,
  0.125839, 0.127184, 0.128512, 0.129821, 0.131111, 0.132383,
  0.133636, 0.134869, 0.136083, 0.137278, 0.138453, 0.139607,
  0.140741, 0.141855, 0.142948, 0.144021, 0.145072, 0.146102,
  0.147111, 0.148098, 0.149064, 0.150007, 0.150929, 0.151828,
  0.152705, 0.153559, 0.154391, 0.155199, 0.155985, 0.156747,
  0.157486, 0.158202, 0.158894, 0.159562, 0.160206, 0.160827,
  0.161423, 0.161995, 0.162542, 0.163065, 0.163563, 0.164037,
  0.164486, 0.16491, 0.165309, 0.165682, 0.166031, 0.166354, 0.166652,
  0.166924, 0.167171, 0.167392, 0.167587, 0.167757, 0.167901,
  0.168019, 0.168111, 0.168177, 0.168217, 0.168231, 0.168219,
  0.168181, 0.168117, 0.168026, 0.16791, 0.167767, 0.167598, 0.167402,
  0.16718, 0.166933, 0.166658, 0.166358, 0.166031, 0.165678, 0.165299,
  0.164894, 0.164463, 0.164005, 0.163521, 0.163012, 0.162476,
  0.161914, 0.161327, 0.160713, 0.160074, 0.159409, 0.158719,
  0.158003, 0.157261, 0.156494, 0.155702, 0.154884, 0.154041,
  0.153173, 0.15228, 0.151363, 0.15042, 0.149453, 0.148462, 0.147446,
  0.146406, 0.145341, 0.144253, 0.143141, 0.142005, 0.140846,
  0.139663, 0.138457, 0.137228, 0.135976, 0.134701, 0.133403,
  0.132084, 0.130741, 0.129377, 0.127991, 0.126584, 0.125154,
  0.123704, 0.122232, 0.12074, 0.119227, 0.117694, 0.11614, 0.114566,
  0.112973, 0.111359, 0.109727, 0.108076, 0.106405, 0.104716,
  0.103009, 0.101284, 0.0995405, 0.0977797, 0.0960016, 0.0942064,
  0.0923944, 0.0905659, 0.0887212, 0.0868604, 0.084984, 0.0830922,
  0.0811853, 0.0792635, 0.0773272, 0.0753767, 0.0734122, 0.0714341,
  0.0694427, 0.0674383, 0.0654211, 0.0633916, 0.0613499, 0.0592966,
  0.0572317, 0.0551558, 0.0530691, 0.050972, 0.0488647, 0.0467476,
  0.0446211, 0.0424855, 0.0403411, 0.0381883, 0.0360275, 0.0338589,
  0.0316829, 0.0294999, 0.0273103, 0.0251143, 0.0229124, 0.0207049,
  0.0184922, 0.0162746, 0.0140525, 0.0118263, 0.00959633, 0.00736296,
  0.00512658, 0.00288755, 0.000646249, -0.00159694, -0.00384165,
  -0.0060875, -0.00833411, -0.0105811, -0.0128281, -0.0150747,
  -0.0173205, -0.0195652, -0.0218083, -0.0240495, -0.0262885,
  -0.0285247, -0.0307578, -0.0329875, -0.0352133, -0.0374348,
  -0.0396518, -0.0418637, -0.0440702, -0.0462708, -0.0484654,
  -0.0506533, -0.0528342, -0.0550079, -0.0571737, -0.0593315,
  -0.0614807, -0.063621, -0.0657521, -0.0678734, -0.0699847,
  -0.0720856, -0.0741757, -0.0762545, -0.0783218, -0.0803771,
  -0.08242, -0.0844502, -0.0864673, -0.088471, -0.0904608, -0.0924364,
  -0.0943974, -0.0963434, -0.0982741, -0.100189, -0.102088, -0.103971,
  -0.105836, -0.107685, -0.109516, -0.11133, -0.113125, -0.114901,
  -0.116659, -0.118397, -0.120116, -0.121815, -0.123494, -0.125152,
  -0.126789, -0.128405, -0.129999, -0.131572, -0.133122, -0.13465,
  -0.136155, -0.137637, -0.139095, -0.140529, -0.14194, -0.143326,
  -0.144687, -0.146024, -0.147335, -0.148621, -0.149881, -0.151115,
  -0.152323, -0.153504, -0.154658, -0.155785, -0.156885, -0.157957,
  -0.159001, -0.160018, -0.161005, -0.161965, -0.162895, -0.163797,
  -0.164669, -0.165512, -0.166325, -0.167109, -0.167862, -0.168585,
  -0.169278, -0.16994, -0.170571, -0.171171, -0.171741, -0.172279,
  -0.172785, -0.17326, -0.173703, -0.174114, -0.174493, -0.17484,
  -0.175155, -0.175438, -0.175688, -0.175905, -0.176089, -0.176241,
  -0.17636, -0.176446, -0.176499, -0.176519, -0.176505, -0.176458,
  -0.176378, -0.176265, -0.176118, -0.175938, -0.175724, -0.175477,
  -0.175196, -0.174882, -0.174534, -0.174153, -0.173738, -0.17329,
  -0.172808, -0.172293, -0.171745, -0.171163, -0.170548, -0.169899,
  -0.169217, -0.168503, -0.167755, -0.166974, -0.16616, -0.165313,
  -0.164434, -0.163522, -0.162578, -0.161601, -0.160592, -0.159551,
  -0.158477, -0.157372, -0.156236, -0.155068, -0.153868, -0.152637,
  -0.151375, -0.150083, -0.14876, -0.147406, -0.146022, -0.144608,
  -0.143164, -0.141691, -0.140189, -0.138657, -0.137096, -0.135507,
  -0.133889, -0.132243, -0.13057, -0.128869, -0.12714, -0.125385,
  -0.123603, -0.121794, -0.119959, -0.118099, -0.116213, -0.114302,
  -0.112366, -0.110406, -0.108421, -0.106413, -0.104381, -0.102326,
  -0.100249, -0.0981488, -0.0960269, -0.0938835, -0.0917188,
  -0.0895333, -0.0873274, -0.0851015, -0.0828561, -0.0805914,
  -0.0783079, -0.0760061, -0.0736864, -0.0713492, -0.068995,
  -0.0666241, -0.0642372, -0.0618345, -0.0594166, -0.0569839,
  -0.0545369, -0.052076, -0.0496018, -0.0471148, -0.0446153,
  -0.0421039, -0.0395811, -0.0370474, -0.0345033, -0.0319492,
  -0.0293857, -0.0268134, -0.0242326, -0.021644, -0.0190481,
  -0.0164453, -0.0138363, -0.0112215, -0.00860145, -0.00597673,
  -0.00334786, -0.00071539, 0.00192014, 0.00455819, 0.00719821,
  0.00983963, 0.0124819, 0.0151245, 0.0177668, 0.0204084, 0.0230485,
  0.0256867, 0.0283224, 0.030955, 0.033584, 0.0362088, 0.0388288,
  0.0414435, 0.0440523, 0.0466546, 0.0492498, 0.0518374, 0.0544167,
  0.0569873, 0.0595486, 0.0620999, 0.0646408, 0.0671705, 0.0696886,
  0.0721945, 0.0746877, 0.0771674, 0.0796333, 0.0820846, 0.0845209,
  0.0869416, 0.089346, 0.0917337, 0.0941041, 0.0964566, 0.0987907,
  0.101106, 0.103401, 0.105677, 0.107932, 0.110165, 0.112377,
  0.114567, 0.116734, 0.118877, 0.120997, 0.123092, 0.125162,
  0.127207, 0.129226, 0.131218, 0.133183, 0.135121, 0.137031,
  0.138912, 0.140765, 0.142588, 0.144381, 0.146143, 0.147875,
  0.149575, 0.151244, 0.15288, 0.154483, 0.156053, 0.15759, 0.159093,
  0.160561, 0.161994, 0.163392, 0.164754, 0.16608, 0.167369, 0.168622,
  0.169837, 0.171015, 0.172155, 0.173256, 0.174318, 0.175342,
  0.176326, 0.17727, 0.178174, 0.179038, 0.179861, 0.180644, 0.181384,
  0.182084, 0.182741, 0.183357, 0.18393, 0.184461, 0.184948, 0.185393,
  0.185795, 0.186153, 0.186467, 0.186738, 0.186964, 0.187147,
  0.187285, 0.187378, 0.187427, 0.187431, 0.18739, 0.187304, 0.187174,
  0.186998, 0.186776, 0.18651, 0.186198, 0.18584, 0.185437, 0.184989,
  0.184495, 0.183955, 0.18337, 0.18274, 0.182064, 0.181343, 0.180576,
  0.179764, 0.178907, 0.178005, 0.177057, 0.176065, 0.175028,
  0.173947, 0.17282, 0.17165, 0.170435, 0.169176, 0.167873, 0.166527,
  0.165137, 0.163704, 0.162228, 0.16071, 0.159149, 0.157546, 0.1559,
  0.154214, 0.152486, 0.150717, 0.148907, 0.147057, 0.145167,
  0.143238, 0.141269, 0.139262, 0.137216, 0.135132, 0.13301, 0.130851,
  0.128656, 0.126424, 0.124157, 0.121854, 0.119517, 0.117145,
  0.114739, 0.1123, 0.109828, 0.107324, 0.104789, 0.102222, 0.0996251,
  0.096998, 0.0943417, 0.0916566, 0.0889434, 0.0862028, 0.0834353,
  0.0806416, 0.0778225, 0.0749785, 0.0721103, 0.0692186, 0.0663041,
  0.0633675, 0.0604096, 0.057431, 0.0544325, 0.0514149, 0.0483788,
  0.045325, 0.0422543, 0.0391675, 0.0360653, 0.0329486, 0.0298181,
  0.0266747, 0.0235191, 0.0203522, 0.0171748, 0.0139877, 0.0107918,
  0.00758787, 0.00437683, 0.00115952, -0.0020632, -0.00529047,
  -0.0085214, -0.0117551, -0.0149908, -0.0182274, -0.0214642,
  -0.0247002, -0.0279345, -0.0311662, -0.0343945, -0.0376183,
  -0.0408368, -0.0440491, -0.0472542, -0.0504512, -0.0536392,
  -0.0568173, -0.0599845, -0.0631399, -0.0662825, -0.0694115,
  -0.0725258, -0.0756246, -0.0787069, -0.0817718, -0.0848184,
  -0.0878456, -0.0908526, -0.0938385, -0.0968023, -0.099743, -0.10266,
  -0.105552, -0.108418, -0.111257, -0.114069, -0.116852, -0.119606,
  -0.122329, -0.125022, -0.127682, -0.130308, -0.132901, -0.135459,
  -0.137982, -0.140468, -0.142916, -0.145326, -0.147697, -0.150027,
  -0.152317, -0.154566, -0.156772, -0.158934, -0.161052, -0.163126,
  -0.165154, -0.167135, -0.169069, -0.170955, -0.172792, -0.17458,
  -0.176318, -0.178004, -0.179639, -0.181222, -0.182752, -0.184228,
  -0.18565, -0.187016, -0.188328, -0.189583, -0.190781, -0.191922,
  -0.193005, -0.194029, -0.194994, -0.1959, -0.196746, -0.197531,
  -0.198256, -0.198918, -0.199519, -0.200057, -0.200533, -0.200945,
  -0.201294, -0.201579, -0.2018, -0.201957, -0.202048, -0.202074,
  -0.202035, -0.20193, -0.20176, -0.201523, -0.201221, -0.200851,
  -0.200416, -0.199913, -0.199344, -0.198708, -0.198005, -0.197235,
  -0.196399, -0.195495, -0.194525, -0.193487, -0.192383, -0.191212,
  -0.189975, -0.188672, -0.187302, -0.185866, -0.184364, -0.182797,
  -0.181164, -0.179467, -0.177704, -0.175878, -0.173987, -0.172032,
  -0.170015, -0.167934, -0.165792, -0.163587, -0.161321, -0.158994,
  -0.156607, -0.15416, -0.151654, -0.149089, -0.146467, -0.143787,
  -0.141051, -0.13826, -0.135413, -0.132512, -0.129557, -0.12655,
  -0.123491, -0.120382, -0.117222, -0.114013, -0.110756, -0.107451,
  -0.104101, -0.100705, -0.097265, -0.0937819, -0.0902568, -0.0866906,
  -0.0830847, -0.07944, -0.0757578, -0.0720393, -0.0682856, -0.064498,
  -0.0606778, -0.0568261, -0.0529444, -0.0490339, -0.045096,
  -0.0411319, -0.0371432, -0.0331311, -0.029097, -0.0250425,
  -0.0209689, -0.0168777, -0.0127704, -0.00864843, -0.00451337,
  -0.000366719, 0.00378998, 0.00795516, 0.0121273, 0.0163047,
  0.0204859, 0.0246692, 0.0288529, 0.0330356, 0.0372154, 0.0413908,
  0.0455601, 0.0497216, 0.0538736, 0.0580144, 0.0621423, 0.0662556,
  0.0703526, 0.0744315, 0.0784907, 0.0825283, 0.0865426, 0.090532,
  0.0944945, 0.0984286, 0.102332, 0.106204, 0.110042, 0.113844,
  0.11761, 0.121336, 0.125021, 0.128664, 0.132262, 0.135815, 0.139319,
  0.142774, 0.146178, 0.149529, 0.152826, 0.156066, 0.159248, 0.16237,
  0.165432, 0.16843, 0.171363, 0.17423, 0.17703, 0.17976, 0.182419,
  0.185005, 0.187518, 0.189954, 0.192314, 0.194595, 0.196796,
  0.198916, 0.200953, 0.202905, 0.204772, 0.206552, 0.208244,
  0.209846, 0.211357, 0.212777, 0.214104, 0.215336, 0.216473,
  0.217513, 0.218456, 0.2193, 0.220045, 0.220689, 0.221232, 0.221673,
  0.222011, 0.222245, 0.222375, 0.222399, 0.222318, 0.22213, 0.221835,
  0.221432, 0.220921, 0.220302, 0.219574, 0.218737, 0.217791,
  0.216735, 0.215569, 0.214293, 0.212907, 0.211411, 0.209806, 0.20809,
  0.206265, 0.20433, 0.202285, 0.200132, 0.197871, 0.195501, 0.193024,
  0.190439, 0.187748, 0.184952, 0.18205, 0.179044, 0.175935, 0.172723,
  0.16941, 0.165997, 0.162484, 0.158873, 0.155165, 0.151362, 0.147464,
  0.143474, 0.139392, 0.135221, 0.130962, 0.126616, 0.122186,
  0.117673, 0.113079, 0.108406, 0.103656, 0.0988311, 0.0939337,
  0.0889657, 0.0839295, 0.0788274, 0.0736618, 0.0684352, 0.0631501,
  0.0578091, 0.0524148, 0.0469699, 0.0414772, 0.0359395, 0.0303598,
  0.0247409, 0.0190858, 0.0133976, 0.00767948, 0.00193449,
  -0.00383411, -0.00962306, -0.015429, -0.0212487, -0.0270785,
  -0.0329152, -0.0387551, -0.0445947, -0.0504305, -0.0562587,
  -0.0620757, -0.0678778, -0.0736612, -0.0794222, -0.0851569,
  -0.0908615, -0.096532, -0.102165, -0.107755, -0.1133, -0.118795,
  -0.124237, -0.12962, -0.134942, -0.140198, -0.145384, -0.150496,
  -0.155529, -0.160481, -0.165347, -0.170122, -0.174803, -0.179385,
  -0.183865, -0.188239, -0.192503, -0.196652, -0.200682, -0.204591,
  -0.208373, -0.212025, -0.215543, -0.218924, -0.222163, -0.225257,
  -0.228202, -0.230995, -0.233633, -0.23611, -0.238426, -0.240575,
  -0.242554, -0.244361, -0.245993, -0.247446, -0.248717, -0.249804,
  -0.250704, -0.251414, -0.251931, -0.252254, -0.25238, -0.252307,
  -0.252033, -0.251555, -0.250872, -0.249982, -0.248885, -0.247577,
  -0.246059, -0.244329, -0.242386, -0.240229, -0.237858, -0.235273,
  -0.232472, -0.229456, -0.226226, -0.222781, -0.219121, -0.215248,
  -0.211163, -0.206866, -0.202358, -0.197642, -0.192719, -0.18759,
  -0.182259, -0.176727, -0.170996, -0.165071, -0.158953, -0.152647,
  -0.146155, -0.139482, -0.132631, -0.125607, -0.118414, -0.111057,
  -0.103541, -0.0958724, -0.0880554, -0.0800962, -0.0720009,
  -0.063776, -0.055428, -0.0469639, -0.0383907, -0.0297159,
  -0.0209473, -0.0120927, -0.00316032, 0.00584124, 0.0149033,
  0.0240168, 0.0331725, 0.0423608, 0.0515721, 0.0607961, 0.0700227,
  0.0792412, 0.088441, 0.097611, 0.10674, 0.115816, 0.124829,
  0.133765, 0.142613, 0.15136, 0.159995, 0.168503, 0.176874, 0.185092,
  0.193146, 0.201022, 0.208707, 0.216186, 0.223447, 0.230476,
  0.237258, 0.243781, 0.25003, 0.255991, 0.26165, 0.266994, 0.272008,
  0.276679, 0.280993, 0.284936, 0.288496, 0.291658, 0.294409,
  0.296737, 0.298629, 0.300072, 0.301054, 0.301564, 0.301589,
  0.301119, 0.300144, 0.298652, 0.296635, 0.294084, 0.290989,
  0.287343, 0.283139, 0.27837, 0.273031, 0.267117, 0.260624, 0.253549,
  0.245889, 0.237645, 0.228816, 0.219403, 0.20941, 0.198839, 0.187696,
  0.175988, 0.163723, 0.150911, 0.137563, 0.123693, 0.109315,
  0.0944459, 0.0791055, 0.0633145, 0.0470961, 0.0304758, 0.0134815,
  -0.0038565, -0.0215052, -0.0394289, -0.0575892, -0.0759447,
  -0.094451, -0.113061, -0.131723, -0.150383, -0.168983, -0.187462,
  -0.205755, -0.223792, -0.2415, -0.258802, -0.275615, -0.291852,
  -0.307423, -0.322231, -0.336176, -0.349149, -0.36104, -0.371731,
  -0.381098, -0.389013, -0.395339, -0.399934, -0.402651, -0.403332,
  -0.401817, -0.397935, -0.391509, -0.382353, -0.370275, -0.355073,
  -0.336538, -0.31445, -0.288583, -0.258699, -0.224551, -0.185883,
  -0.142428, -0.0939091, -0.0400381, 0.0194843, 0.0849687, 0.156738,
  0.235125, 0.32048, 0.41316, 0.51354, 0.622005, 0.738958, 0.864813,
  1}; const G4double G4NeutronHPFastLegendre::i28[5801] = {0, 0.000321236,
  0.000597479, 0.00083187, 0.00102741, 0.00118695, 0.00131322,
  0.0014088, 0.00147616, 0.00151764, 0.00153547, 0.00153176,
  0.0015085, 0.0014676, 0.00141084, 0.00133994, 0.00125649,
  0.00116201, 0.00105793, 0.000945577, 0.000826232, 0.000701076,
  0.000571223, 0.000437715, 0.000301526, 0.000163565, 2.46788e-05,
  -0.000114346, -0.000252781, -0.000389951, -0.000525233,
  -0.000658056, -0.000787895, -0.000914272, -0.00103675, -0.00115494,
  -0.00126849, -0.00137707, -0.00148042, -0.00157828, -0.00167043,
  -0.0017567, -0.00183694, -0.00191101, -0.00197881, -0.00204027,
  -0.00209534, -0.00214397, -0.00218618, -0.00222195, -0.00225133,
  -0.00227435, -0.00229107, -0.00230157, -0.00230593, -0.00230426,
  -0.00229667, -0.00228328, -0.00226424, -0.00223967, -0.00220973,
  -0.00217459, -0.0021344, -0.00208934, -0.00203959, -0.00198532,
  -0.00192674, -0.00186401, -0.00179735, -0.00172695, -0.001653,
  -0.0015757, -0.00149526, -0.00141187, -0.00132575, -0.00123708,
  -0.00114607, -0.00105293, -0.000957841, -0.000861012, -0.000762636,
  -0.000662908, -0.000562017, -0.000460153, -0.000357501,
  -0.000254245, -0.000150564, -4.66338e-05, 5.73725e-05, 0.000161286,
  0.000264943, 0.00036818, 0.000470843, 0.000572777, 0.000673836,
  0.000773874, 0.000872753, 0.000970339, 0.0010665, 0.00116111,
  0.00125405, 0.00134521, 0.00143447, 0.00152172, 0.00160687,
  0.00168981, 0.00177046, 0.00184873, 0.00192454, 0.0019978,
  0.00206845, 0.00213642, 0.00220164, 0.00226405, 0.0023236,
  0.00238024, 0.00243393, 0.00248462, 0.00253227, 0.00257686,
  0.00261835, 0.00265672, 0.00269196, 0.00272404, 0.00275295,
  0.00277868, 0.00280124, 0.00282061, 0.00283681, 0.00284983,
  0.00285969, 0.0028664, 0.00286997, 0.00287043, 0.0028678, 0.0028621,
  0.00285336, 0.00284162, 0.0028269, 0.00280924, 0.00278869,
  0.00276527, 0.00273904, 0.00271005, 0.00267833, 0.00264395,
  0.00260694, 0.00256737, 0.0025253, 0.00248077, 0.00243385,
  0.00238459, 0.00233307, 0.00227934, 0.00222347, 0.00216552,
  0.00210556, 0.00204366, 0.00197989, 0.00191431, 0.001847,
  0.00177803, 0.00170747, 0.00163539, 0.00156186, 0.00148697,
  0.00141077, 0.00133335, 0.00125478, 0.00117513, 0.00109448,
  0.00101289, 0.000930459, 0.000847244, 0.000763321, 0.000678765,
  0.000593649, 0.000508046, 0.000422028, 0.000335668, 0.000249036,
  0.000162205, 7.52436e-05, -1.17774e-05, -9.87893e-05, -0.000185724,
  -0.000272513, -0.000359091, -0.000445391, -0.000531348,
  -0.000616899, -0.00070198, -0.000786529, -0.000870485, -0.000953788,
  -0.00103638, -0.0011182, -0.0011992, -0.00127931, -0.00135849,
  -0.00143667, -0.00151382, -0.00158987, -0.00166478, -0.00173851,
  -0.00181099, -0.0018822, -0.00195208, -0.00202059, -0.00208768,
  -0.00215333, -0.00221749, -0.00228012, -0.00234119, -0.00240067,
  -0.00245851, -0.00251469, -0.00256918, -0.00262194, -0.00267296,
  -0.0027222, -0.00276964, -0.00281525, -0.00285902, -0.00290093,
  -0.00294095, -0.00297906, -0.00301525, -0.00304951, -0.00308182,
  -0.00311217, -0.00314055, -0.00316694, -0.00319135, -0.00321375,
  -0.00323416, -0.00325255, -0.00326894, -0.00328331, -0.00329566,
  -0.00330601, -0.00331434, -0.00332066, -0.00332498, -0.0033273,
  -0.00332763, -0.00332597, -0.00332233, -0.00331673, -0.00330918,
  -0.00329967, -0.00328824, -0.00327489, -0.00325964, -0.00324251,
  -0.0032235, -0.00320264, -0.00317995, -0.00315545, -0.00312916,
  -0.0031011, -0.00307128, -0.00303975, -0.00300651, -0.0029716,
  -0.00293503, -0.00289684, -0.00285706, -0.0028157, -0.0027728,
  -0.00272839, -0.00268249, -0.00263514, -0.00258637, -0.0025362,
  -0.00248468, -0.00243183, -0.00237768, -0.00232227, -0.00226563,
  -0.0022078, -0.00214881, -0.00208869, -0.00202749, -0.00196523,
  -0.00190195, -0.00183768, -0.00177248, -0.00170636, -0.00163937,
  -0.00157154, -0.00150292, -0.00143353, -0.00136342, -0.00129263,
  -0.00122119, -0.00114913, -0.0010765, -0.00100334, -0.000929684,
  -0.000855567, -0.000781028, -0.000706107, -0.00063084, -0.000555266,
  -0.000479422, -0.000403346, -0.000327075, -0.000250646,
  -0.000174097, -9.74655e-05, -2.0787e-05, 5.59013e-05, 0.000132563,
  0.000209162, 0.000285662, 0.000362029, 0.000438225, 0.000514217,
  0.000589969, 0.000665447, 0.000740617, 0.000815445, 0.000889897,
  0.000963941, 0.00103754, 0.00111067, 0.0011833, 0.00125538,
  0.0013269, 0.00139782, 0.00146812, 0.00153775, 0.00160669,
  0.00167492, 0.00174241, 0.00180912, 0.00187503, 0.00194011,
  0.00200434, 0.00206769, 0.00213014, 0.00219166, 0.00225222,
  0.00231181, 0.0023704, 0.00242796, 0.00248448, 0.00253993,
  0.0025943, 0.00264756, 0.00269969, 0.00275068, 0.0028005,
  0.00284913, 0.00289657, 0.00294279, 0.00298778, 0.00303152,
  0.003074, 0.0031152, 0.00315511, 0.00319371, 0.00323099, 0.00326695,
  0.00330156, 0.00333483, 0.00336673, 0.00339726, 0.00342641,
  0.00345417, 0.00348054, 0.0035055, 0.00352906, 0.00355119,
  0.00357191, 0.0035912, 0.00360906, 0.00362549, 0.00364048,
  0.00365404, 0.00366615, 0.00367682, 0.00368605, 0.00369383,
  0.00370018, 0.00370508, 0.00370854, 0.00371057, 0.00371116,
  0.00371031, 0.00370804, 0.00370435, 0.00369924, 0.00369271,
  0.00368478, 0.00367544, 0.00366471, 0.0036526, 0.0036391,
  0.00362423, 0.003608, 0.00359042, 0.00357149, 0.00355123,
  0.00352965, 0.00350676, 0.00348256, 0.00345708, 0.00343032,
  0.00340229, 0.00337302, 0.00334251, 0.00331078, 0.00327784,
  0.00324371, 0.00320839, 0.00317192, 0.00313429, 0.00309554,
  0.00305567, 0.0030147, 0.00297265, 0.00292954, 0.00288538,
  0.0028402, 0.002794, 0.00274682, 0.00269866, 0.00264955, 0.0025995,
  0.00254854, 0.00249669, 0.00244396, 0.00239038, 0.00233596,
  0.00228073, 0.00222471, 0.00216792, 0.00211038, 0.00205211,
  0.00199313, 0.00193347, 0.00187315, 0.00181219, 0.0017506,
  0.00168842, 0.00162567, 0.00156236, 0.00149853, 0.00143419,
  0.00136936, 0.00130408, 0.00123835, 0.00117222, 0.00110568,
  0.00103878, 0.000971536, 0.000903966, 0.000836096, 0.00076795,
  0.000699549, 0.000630917, 0.000562078, 0.000493054, 0.000423868,
  0.000354543, 0.000285102, 0.000215569, 0.000145965, 7.63138e-05,
  6.63785e-06, -6.30403e-05, -0.000132698, -0.000202313, -0.000271864,
  -0.000341326, -0.00041068, -0.000479902, -0.000548972, -0.000617866,
  -0.000686564, -0.000755044, -0.000823285, -0.000891265,
  -0.000958965, -0.00102636, -0.00109344, -0.00116017, -0.00122654,
  -0.00129252, -0.0013581, -0.00142326, -0.00148798, -0.00155223,
  -0.00161601, -0.00167928, -0.00174204, -0.00180425, -0.00186592,
  -0.00192701, -0.00198751, -0.00204741, -0.00210667, -0.0021653,
  -0.00222327, -0.00228056, -0.00233716, -0.00239305, -0.00244823,
  -0.00250266, -0.00255634, -0.00260925, -0.00266138, -0.00271271,
  -0.00276324, -0.00281293, -0.0028618, -0.0029098, -0.00295695,
  -0.00300322, -0.0030486, -0.00309309, -0.00313666, -0.0031793,
  -0.00322102, -0.00326179, -0.0033016, -0.00334045, -0.00337833,
  -0.00341522, -0.00345112, -0.00348602, -0.0035199, -0.00355277,
  -0.00358462, -0.00361543, -0.0036452, -0.00367392, -0.00370159,
  -0.0037282, -0.00375374, -0.00377822, -0.00380161, -0.00382393,
  -0.00384516, -0.00386529, -0.00388434, -0.00390229, -0.00391913,
  -0.00393487, -0.00394951, -0.00396304, -0.00397545, -0.00398676,
  -0.00399695, -0.00400602, -0.00401398, -0.00402082, -0.00402655,
  -0.00403116, -0.00403466, -0.00403704, -0.00403831, -0.00403846,
  -0.00403751, -0.00403545, -0.00403228, -0.004028, -0.00402263,
  -0.00401616, -0.0040086, -0.00399994, -0.0039902, -0.00397938,
  -0.00396748, -0.00395451, -0.00394047, -0.00392537, -0.00390921,
  -0.00389201, -0.00387376, -0.00385447, -0.00383415, -0.00381281,
  -0.00379045, -0.00376708, -0.00374272, -0.00371736, -0.00369101,
  -0.00366369, -0.0036354, -0.00360615, -0.00357595, -0.00354481,
  -0.00351274, -0.00347975, -0.00344585, -0.00341105, -0.00337536,
  -0.00333878, -0.00330134, -0.00326304, -0.0032239, -0.00318392,
  -0.00314311, -0.0031015, -0.00305908, -0.00301588, -0.00297189,
  -0.00292715, -0.00288166, -0.00283542, -0.00278847, -0.0027408,
  -0.00269243, -0.00264337, -0.00259365, -0.00254326, -0.00249223,
  -0.00244057, -0.0023883, -0.00233542, -0.00228195, -0.0022279,
  -0.0021733, -0.00211815, -0.00206247, -0.00200627, -0.00194957,
  -0.00189239, -0.00183473, -0.00177662, -0.00171807, -0.00165908,
  -0.00159969, -0.0015399, -0.00147973, -0.0014192, -0.00135831,
  -0.00129709, -0.00123556, -0.00117372, -0.00111159, -0.00104919,
  -0.000986528, -0.000923629, -0.000860506, -0.000797172,
  -0.000733645, -0.00066994, -0.000606072, -0.000542057, -0.000477911,
  -0.00041365, -0.000349289, -0.000284844, -0.00022033, -0.000155764,
  -9.11601e-05, -2.65344e-05, 3.80977e-05, 0.000102721, 0.000167319,
  0.000231877, 0.000296381, 0.000360813, 0.00042516, 0.000489406,
  0.000553537, 0.000617536, 0.000681389, 0.000745082, 0.000808598,
  0.000871925, 0.000935047, 0.000997949, 0.00106062, 0.00112304,
  0.00118519, 0.00124707, 0.00130866, 0.00136995, 0.00143091,
  0.00149155, 0.00155184, 0.00161176, 0.00167132, 0.00173049,
  0.00178926, 0.00184761, 0.00190554, 0.00196303, 0.00202008,
  0.00207665, 0.00213276, 0.00218837, 0.00224348, 0.00229809,
  0.00235216, 0.0024057, 0.0024587, 0.00251113, 0.002563, 0.00261429,
  0.00266498, 0.00271507, 0.00276455, 0.0028134, 0.00286163,
  0.0029092, 0.00295613, 0.00300239, 0.00304797, 0.00309288,
  0.00313709, 0.0031806, 0.00322341, 0.00326549, 0.00330685,
  0.00334747, 0.00338735, 0.00342648, 0.00346485, 0.00350246,
  0.00353929, 0.00357533, 0.0036106, 0.00364506, 0.00367872,
  0.00371158, 0.00374362, 0.00377484, 0.00380524, 0.0038348,
  0.00386353, 0.00389141, 0.00391844, 0.00394463, 0.00396995,
  0.00399441, 0.00401801, 0.00404074, 0.00406259, 0.00408356,
  0.00410366, 0.00412286, 0.00414118, 0.00415861, 0.00417515,
  0.00419079, 0.00420553, 0.00421937, 0.00423231, 0.00424434,
  0.00425547, 0.00426569, 0.004275, 0.0042834, 0.0042909, 0.00429748,
  0.00430315, 0.00430791, 0.00431176, 0.00431469, 0.00431672,
  0.00431784, 0.00431805, 0.00431735, 0.00431574, 0.00431322,
  0.00430981, 0.00430549, 0.00430026, 0.00429414, 0.00428713,
  0.00427922, 0.00427042, 0.00426073, 0.00425015, 0.00423869,
  0.00422636, 0.00421315, 0.00419906, 0.00418411, 0.00416829,
  0.00415162, 0.00413409, 0.00411571, 0.00409648, 0.00407641,
  0.0040555, 0.00403377, 0.0040112, 0.00398782, 0.00396362,
  0.00393861, 0.00391281, 0.0038862, 0.0038588, 0.00383062,
  0.00380166, 0.00377193, 0.00374144, 0.00371019, 0.00367819,
  0.00364544, 0.00361196, 0.00357776, 0.00354283, 0.00350719,
  0.00347084, 0.0034338, 0.00339607, 0.00335766, 0.00331858,
  0.00327884, 0.00323844, 0.00319739, 0.00315571, 0.0031134,
  0.00307047, 0.00302693, 0.00298279, 0.00293806, 0.00289275,
  0.00284686, 0.00280041, 0.00275341, 0.00270587, 0.00265779,
  0.00260919, 0.00256007, 0.00251046, 0.00246035, 0.00240976,
  0.00235869, 0.00230717, 0.00225519, 0.00220277, 0.00214993,
  0.00209666, 0.00204299, 0.00198892, 0.00193446, 0.00187962,
  0.00182443, 0.00176887, 0.00171298, 0.00165676, 0.00160021,
  0.00154336, 0.00148621, 0.00142877, 0.00137105, 0.00131308,
  0.00125485, 0.00119638, 0.00113768, 0.00107877, 0.00101964,
  0.000960324, 0.000900823, 0.00084115, 0.000781316, 0.000721334,
  0.000661214, 0.000600969, 0.00054061, 0.000480148, 0.000419595,
  0.000358963, 0.000298262, 0.000237506, 0.000176704, 0.000115869,
  5.50126e-05, -5.85454e-06, -6.67206e-05, -0.000127574, -0.000188404,
  -0.000249198, -0.000309946, -0.000370635, -0.000431256,
  -0.000491795, -0.000552243, -0.000612589, -0.000672819,
  -0.000732925, -0.000792895, -0.000852717, -0.000912381,
  -0.000971875, -0.00103119, -0.00109031, -0.00114924, -0.00120795,
  -0.00126643, -0.00132469, -0.00138269, -0.00144045, -0.00149794,
  -0.00155515, -0.00161208, -0.00166871, -0.00172504, -0.00178105,
  -0.00183674, -0.00189209, -0.00194709, -0.00200174, -0.00205602,
  -0.00210993, -0.00216346, -0.00221659, -0.00226932, -0.00232164,
  -0.00237354, -0.002425, -0.00247603, -0.00252661, -0.00257673,
  -0.00262639, -0.00267558, -0.00272428, -0.00277249, -0.0028202,
  -0.00286741, -0.0029141, -0.00296027, -0.00300591, -0.003051,
  -0.00309556, -0.00313956, -0.003183, -0.00322587, -0.00326816,
  -0.00330987, -0.003351, -0.00339153, -0.00343145, -0.00347077,
  -0.00350947, -0.00354754, -0.00358499, -0.00362181, -0.00365798,
  -0.00369351, -0.00372838, -0.0037626, -0.00379616, -0.00382904,
  -0.00386126, -0.00389279, -0.00392364, -0.00395381, -0.00398327,
  -0.00401205, -0.00404011, -0.00406748, -0.00409413, -0.00412006,
  -0.00414528, -0.00416978, -0.00419355, -0.00421659, -0.00423889,
  -0.00426046, -0.00428129, -0.00430138, -0.00432072, -0.00433931,
  -0.00435716, -0.00437425, -0.00439058, -0.00440616, -0.00442097,
  -0.00443503, -0.00444832, -0.00446084, -0.0044726, -0.00448359,
  -0.00449381, -0.00450327, -0.00451194, -0.00451985, -0.00452698,
  -0.00453334, -0.00453893, -0.00454374, -0.00454778, -0.00455104,
  -0.00455352, -0.00455524, -0.00455617, -0.00455634, -0.00455573,
  -0.00455435, -0.00455219, -0.00454927, -0.00454557, -0.00454111,
  -0.00453588, -0.00452989, -0.00452313, -0.00451561, -0.00450733,
  -0.00449829, -0.0044885, -0.00447795, -0.00446665, -0.0044546,
  -0.0044418, -0.00442826, -0.00441398, -0.00439896, -0.00438321,
  -0.00436672, -0.00434951, -0.00433157, -0.00431291, -0.00429353,
  -0.00427344, -0.00425264, -0.00423113, -0.00420892, -0.00418602,
  -0.00416242, -0.00413813, -0.00411315, -0.0040875, -0.00406117,
  -0.00403417, -0.00400651, -0.00397818, -0.0039492, -0.00391958,
  -0.0038893, -0.00385839, -0.00382685, -0.00379467, -0.00376188,
  -0.00372847, -0.00369444, -0.00365982, -0.0036246, -0.00358878,
  -0.00355238, -0.0035154, -0.00347785, -0.00343973, -0.00340105,
  -0.00336182, -0.00332204, -0.00328172, -0.00324088, -0.0031995,
  -0.00315761, -0.00311521, -0.0030723, -0.00302889, -0.002985,
  -0.00294063, -0.00289578, -0.00285046, -0.00280469, -0.00275846,
  -0.00271179, -0.00266469, -0.00261716, -0.0025692, -0.00252084,
  -0.00247207, -0.00242291, -0.00237336, -0.00232343, -0.00227312,
  -0.00222246, -0.00217144, -0.00212007, -0.00206837, -0.00201634,
  -0.00196399, -0.00191132, -0.00185835, -0.00180509, -0.00175154,
  -0.00169771, -0.00164361, -0.00158926, -0.00153465, -0.0014798,
  -0.00142472, -0.00136941, -0.00131388, -0.00125815, -0.00120222,
  -0.0011461, -0.0010898, -0.00103333, -0.000976696, -0.00091991,
  -0.000862979, -0.000805913, -0.000748721, -0.000691412,
  -0.000633995, -0.000576478, -0.000518872, -0.000461184,
  -0.000403425, -0.000345603, -0.000287727, -0.000229806,
  -0.000171849, -0.000113866, -5.58652e-05, 2.14433e-06, 6.01535e-05,
  0.000118153, 0.000176135, 0.000234089, 0.000292007, 0.00034988,
  0.000407699, 0.000465454, 0.000523138, 0.000580742, 0.000638256,
  0.000695671, 0.000752979, 0.000810172, 0.00086724, 0.000924175,
  0.000980968, 0.00103761, 0.00109409, 0.00115041, 0.00120655,
  0.00126251, 0.00131827, 0.00137383, 0.00142918, 0.00148431,
  0.00153922, 0.00159389, 0.00164832, 0.0017025, 0.00175642,
  0.00181008, 0.00186345, 0.00191655, 0.00196935, 0.00202186,
  0.00207406, 0.00212595, 0.00217751, 0.00222875, 0.00227965,
  0.0023302, 0.0023804, 0.00243025, 0.00247973, 0.00252883,
  0.00257755, 0.00262589, 0.00267383, 0.00272137, 0.00276851,
  0.00281522, 0.00286152, 0.00290738, 0.00295281, 0.0029978,
  0.00304234, 0.00308643, 0.00313005, 0.00317321, 0.0032159,
  0.0032581, 0.00329982, 0.00334105, 0.00338178, 0.00342201,
  0.00346173, 0.00350094, 0.00353963, 0.00357779, 0.00361542,
  0.00365252, 0.00368907, 0.00372508, 0.00376054, 0.00379545,
  0.00382979, 0.00386357, 0.00389678, 0.00392941, 0.00396147,
  0.00399294, 0.00402383, 0.00405412, 0.00408382, 0.00411292,
  0.00414141, 0.0041693, 0.00419658, 0.00422324, 0.00424928,
  0.0042747, 0.0042995, 0.00432367, 0.0043472, 0.00437011, 0.00439237,
  0.004414, 0.00443498, 0.00445532, 0.00447501, 0.00449404,
  0.00451243, 0.00453016, 0.00454723, 0.00456364, 0.00457939,
  0.00459448, 0.0046089, 0.00462265, 0.00463574, 0.00464815,
  0.0046599, 0.00467097, 0.00468137, 0.00469109, 0.00470014,
  0.00470851, 0.0047162, 0.00472321, 0.00472955, 0.0047352,
  0.00474018, 0.00474447, 0.00474808, 0.00475102, 0.00475327,
  0.00475484, 0.00475573, 0.00475594, 0.00475547, 0.00475433,
  0.0047525, 0.00475, 0.00474681, 0.00474295, 0.00473842, 0.00473321,
  0.00472733, 0.00472077, 0.00471355, 0.00470565, 0.00469709,
  0.00468786, 0.00467797, 0.00466741, 0.00465619, 0.00464432,
  0.00463178, 0.00461859, 0.00460475, 0.00459026, 0.00457512,
  0.00455934, 0.00454291, 0.00452584, 0.00450814, 0.0044898,
  0.00447082, 0.00445122, 0.004431, 0.00441015, 0.00438869, 0.0043666,
  0.00434391, 0.00432061, 0.0042967, 0.00427219, 0.00424708,
  0.00422138, 0.00419509, 0.00416822, 0.00414076, 0.00411272,
  0.00408411, 0.00405493, 0.00402519, 0.00399489, 0.00396403,
  0.00393262, 0.00390066, 0.00386816, 0.00383513, 0.00380156,
  0.00376747, 0.00373285, 0.00369772, 0.00366207, 0.00362592,
  0.00358927, 0.00355212, 0.00351448, 0.00347635, 0.00343775,
  0.00339867, 0.00335912, 0.00331911, 0.00327864, 0.00323773,
  0.00319636, 0.00315456, 0.00311232, 0.00306966, 0.00302657,
  0.00298307, 0.00293916, 0.00289485, 0.00285014, 0.00280505,
  0.00275956, 0.0027137, 0.00266747, 0.00262088, 0.00257393,
  0.00252662, 0.00247897, 0.00243099, 0.00238267, 0.00233403,
  0.00228507, 0.0022358, 0.00218623, 0.00213635, 0.00208619,
  0.00203575, 0.00198503, 0.00193404, 0.00188279, 0.00183128,
  0.00177952, 0.00172753, 0.0016753, 0.00162284, 0.00157017,
  0.00151728, 0.00146419, 0.0014109, 0.00135742, 0.00130376,
  0.00124992, 0.00119591, 0.00114175, 0.00108743, 0.00103296,
  0.000978353, 0.000923616, 0.000868755, 0.000813778, 0.000758691,
  0.000703502, 0.00064822, 0.00059285, 0.000537401, 0.000481881,
  0.000426296, 0.000370654, 0.000314962, 0.000259228, 0.00020346,
  0.000147665, 9.18497e-05, 3.60224e-05, -1.98097e-05, -7.56392e-05,
  -0.000131459, -0.000187261, -0.000243038, -0.000298783,
  -0.000354488, -0.000410146, -0.00046575, -0.000521292, -0.000576765,
  -0.000632162, -0.000687475, -0.000742698, -0.000797822, -0.00085284,
  -0.000907746, -0.000962533, -0.00101719, -0.00107172, -0.0011261,
  -0.00118034, -0.00123442, -0.00128833, -0.00134208, -0.00139565,
  -0.00144904, -0.00150224, -0.00155524, -0.00160804, -0.00166062,
  -0.00171299, -0.00176513, -0.00181705, -0.00186872, -0.00192015,
  -0.00197133, -0.00202225, -0.00207291, -0.00212329, -0.0021734,
  -0.00222323, -0.00227276, -0.002322, -0.00237094, -0.00241957,
  -0.00246788, -0.00251587, -0.00256353, -0.00261087, -0.00265786,
  -0.0027045, -0.0027508, -0.00279674, -0.00284231, -0.00288752,
  -0.00293236, -0.00297681, -0.00302088, -0.00306456, -0.00310784,
  -0.00315072, -0.00319319, -0.00323525, -0.00327689, -0.00331811,
  -0.0033589, -0.00339926, -0.00343918, -0.00347866, -0.00351769,
  -0.00355627, -0.00359439, -0.00363204, -0.00366923, -0.00370595,
  -0.0037422, -0.00377796, -0.00381324, -0.00384803, -0.00388233,
  -0.00391613, -0.00394943, -0.00398222, -0.00401451, -0.00404628,
  -0.00407753, -0.00410826, -0.00413847, -0.00416815, -0.0041973,
  -0.00422591, -0.00425399, -0.00428152, -0.00430851, -0.00433495,
  -0.00436084, -0.00438617, -0.00441094, -0.00443516, -0.00445881,
  -0.0044819, -0.00450441, -0.00452636, -0.00454773, -0.00456853,
  -0.00458874, -0.00460838, -0.00462743, -0.0046459, -0.00466378,
  -0.00468107, -0.00469777, -0.00471388, -0.00472939, -0.0047443,
  -0.00475862, -0.00477234, -0.00478545, -0.00479796, -0.00480987,
  -0.00482118, -0.00483187, -0.00484196, -0.00485144, -0.00486032,
  -0.00486858, -0.00487623, -0.00488327, -0.00488969, -0.0048955,
  -0.0049007, -0.00490529, -0.00490926, -0.00491262, -0.00491536,
  -0.00491749, -0.00491901, -0.00491991, -0.00492019, -0.00491986,
  -0.00491892, -0.00491736, -0.0049152, -0.00491241, -0.00490902,
  -0.00490502, -0.0049004, -0.00489518, -0.00488935, -0.00488291,
  -0.00487586, -0.00486821, -0.00485995, -0.00485109, -0.00484163,
  -0.00483157, -0.0048209, -0.00480965, -0.00479779, -0.00478535,
  -0.00477231, -0.00475868, -0.00474446, -0.00472966, -0.00471427,
  -0.0046983, -0.00468175, -0.00466462, -0.00464692, -0.00462864,
  -0.0046098, -0.00459038, -0.00457041, -0.00454987, -0.00452876,
  -0.00450711, -0.0044849, -0.00446213, -0.00443882, -0.00441497,
  -0.00439057, -0.00436564, -0.00434017, -0.00431416, -0.00428763,
  -0.00426057, -0.004233, -0.0042049, -0.00417629, -0.00414717,
  -0.00411754, -0.00408741, -0.00405678, -0.00402566, -0.00399404,
  -0.00396194, -0.00392935, -0.00389629, -0.00386275, -0.00382874,
  -0.00379426, -0.00375932, -0.00372393, -0.00368808, -0.00365178,
  -0.00361504, -0.00357786, -0.00354025, -0.00350221, -0.00346374,
  -0.00342485, -0.00338555, -0.00334583, -0.00330572, -0.0032652,
  -0.00322428, -0.00318298, -0.00314129, -0.00309922, -0.00305678,
  -0.00301397, -0.00297079, -0.00292726, -0.00288337, -0.00283914,
  -0.00279456, -0.00274964, -0.0027044, -0.00265883, -0.00261294,
  -0.00256673, -0.00252022, -0.0024734, -0.00242629, -0.00237888,
  -0.00233119, -0.00228322, -0.00223497, -0.00218646, -0.00213768,
  -0.00208865, -0.00203937, -0.00198984, -0.00194008, -0.00189008,
  -0.00183986, -0.00178942, -0.00173876, -0.00168789, -0.00163683,
  -0.00158557, -0.00153412, -0.00148248, -0.00143067, -0.00137869,
  -0.00132654, -0.00127424, -0.00122179, -0.00116918, -0.00111644,
  -0.00106357, -0.00101057, -0.000957452, -0.000904219, -0.000850879,
  -0.000797437, -0.0007439, -0.000690276, -0.000636569, -0.000582787,
  -0.000528936, -0.000475023, -0.000421053, -0.000367033, -0.00031297,
  -0.00025887, -0.000204739, -0.000150584, -9.64111e-05, -4.22269e-05,
  1.19622e-05, 6.615e-05, 0.00012033, 0.000174496, 0.000228641,
  0.000282759, 0.000336844, 0.000390889, 0.000444888, 0.000498834,
  0.000552722, 0.000606545, 0.000660297, 0.000713971, 0.000767561,
  0.00082106, 0.000874464, 0.000927764, 0.000980956, 0.00103403,
  0.00108699, 0.00113982, 0.00119251, 0.00124507, 0.00129747,
  0.00134973, 0.00140183, 0.00145376, 0.00150553, 0.00155712,
  0.00160853, 0.00165974, 0.00171077, 0.0017616, 0.00181222,
  0.00186262, 0.00191282, 0.00196278, 0.00201252, 0.00206203,
  0.00211129, 0.00216031, 0.00220908, 0.00225759, 0.00230584,
  0.00235382, 0.00240152, 0.00244895, 0.00249609, 0.00254295,
  0.00258951, 0.00263576, 0.00268171, 0.00272736, 0.00277268,
  0.00281768, 0.00286236, 0.00290671, 0.00295072, 0.00299438,
  0.0030377, 0.00308067, 0.00312329, 0.00316554, 0.00320743,
  0.00324895, 0.00329009, 0.00333085, 0.00337123, 0.00341122,
  0.00345081, 0.00349001, 0.00352881, 0.0035672, 0.00360518,
  0.00364274, 0.00367989, 0.00371661, 0.0037529, 0.00378876,
  0.00382419, 0.00385918, 0.00389373, 0.00392782, 0.00396147,
  0.00399466, 0.0040274, 0.00405967, 0.00409148, 0.00412282,
  0.00415369, 0.00418408, 0.00421399, 0.00424342, 0.00427236,
  0.00430082, 0.00432879, 0.00435626, 0.00438323, 0.0044097,
  0.00443567, 0.00446113, 0.00448608, 0.00451052, 0.00453445,
  0.00455786, 0.00458075, 0.00460312, 0.00462497, 0.00464629,
  0.00466708, 0.00468733, 0.00470706, 0.00472625, 0.0047449,
  0.00476302, 0.00478059, 0.00479762, 0.00481411, 0.00483005,
  0.00484544, 0.00486028, 0.00487457, 0.00488831, 0.0049015,
  0.00491413, 0.0049262, 0.00493771, 0.00494867, 0.00495907,
  0.0049689, 0.00497818, 0.00498689, 0.00499504, 0.00500262,
  0.00500964, 0.00501609, 0.00502198, 0.0050273, 0.00503206,
  0.00503624, 0.00503986, 0.00504291, 0.0050454, 0.00504731,
  0.00504866, 0.00504944, 0.00504965, 0.00504929, 0.00504837,
  0.00504687, 0.00504481, 0.00504219, 0.00503899, 0.00503524,
  0.00503091, 0.00502602, 0.00502057, 0.00501456, 0.00500798,
  0.00500084, 0.00499314, 0.00498489, 0.00497607, 0.0049667,
  0.00495677, 0.00494629, 0.00493525, 0.00492366, 0.00491152,
  0.00489884, 0.0048856, 0.00487182, 0.0048575, 0.00484263,
  0.00482723, 0.00481128, 0.0047948, 0.00477779, 0.00476024,
  0.00474216, 0.00472355, 0.00470442, 0.00468476, 0.00466459,
  0.00464389, 0.00462268, 0.00460095, 0.00457871, 0.00455596,
  0.00453271, 0.00450895, 0.0044847, 0.00445994, 0.00443469,
  0.00440895, 0.00438272, 0.004356, 0.0043288, 0.00430112, 0.00427297,
  0.00424434, 0.00421524, 0.00418568, 0.00415565, 0.00412516,
  0.00409422, 0.00406282, 0.00403097, 0.00399868, 0.00396595,
  0.00393278, 0.00389917, 0.00386514, 0.00383068, 0.00379579,
  0.00376049, 0.00372477, 0.00368864, 0.00365211, 0.00361517,
  0.00357784, 0.00354011, 0.00350199, 0.00346349, 0.0034246,
  0.00338534, 0.00334571, 0.0033057, 0.00326534, 0.00322462,
  0.00318354, 0.00314211, 0.00310034, 0.00305823, 0.00301578,
  0.002973, 0.0029299, 0.00288647, 0.00284273, 0.00279868, 0.00275432,
  0.00270966, 0.0026647, 0.00261945, 0.00257391, 0.00252809, 0.002482,
  0.00243564, 0.002389, 0.00234211, 0.00229496, 0.00224756,
  0.00219992, 0.00215203, 0.00210391, 0.00205557, 0.00200699,
  0.0019582, 0.00190919, 0.00185998, 0.00181056, 0.00176095,
  0.00171115, 0.00166115, 0.00161098, 0.00156063, 0.00151012,
  0.00145944, 0.0014086, 0.0013576, 0.00130646, 0.00125518,
  0.00120376, 0.00115221, 0.00110053, 0.00104874, 0.000996833,
  0.000944816, 0.000892698, 0.000840482, 0.000788175, 0.000735783,
  0.000683312, 0.000630766, 0.000578152, 0.000525475, 0.000472742,
  0.000419957, 0.000367127, 0.000314257, 0.000261353, 0.000208421,
  0.000155467, 0.000102495, 4.95127e-05, -3.47514e-06, -5.64626e-05,
  -0.000109444, -0.000162414, -0.000215366, -0.000268295,
  -0.000321195, -0.00037406, -0.000426885, -0.000479664, -0.000532392,
  -0.000585062, -0.000637669, -0.000690208, -0.000742672,
  -0.000795057, -0.000847356, -0.000899563, -0.000951675, -0.00100368,
  -0.00105558, -0.00110737, -0.00115904, -0.00121059, -0.001262,
  -0.00131328, -0.00136442, -0.00141541, -0.00146625, -0.00151693,
  -0.00156745, -0.00161781, -0.00166799, -0.00171799, -0.0017678,
  -0.00181743, -0.00186686, -0.0019161, -0.00196512, -0.00201394,
  -0.00206255, -0.00211093, -0.00215909, -0.00220701, -0.0022547,
  -0.00230215, -0.00234936, -0.00239631, -0.00244301, -0.00248944,
  -0.00253561, -0.00258152, -0.00262714, -0.00267249, -0.00271755,
  -0.00276232, -0.0028068, -0.00285097, -0.00289485, -0.00293842,
  -0.00298167, -0.00302461, -0.00306722, -0.00310951, -0.00315147,
  -0.00319309, -0.00323438, -0.00327532, -0.00331591, -0.00335615,
  -0.00339603, -0.00343556, -0.00347472, -0.00351351, -0.00355192,
  -0.00358996, -0.00362762, -0.0036649, -0.00370179, -0.00373828,
  -0.00377438, -0.00381008, -0.00384538, -0.00388027, -0.00391475,
  -0.00394881, -0.00398246, -0.00401568, -0.00404848, -0.00408085,
  -0.0041128, -0.0041443, -0.00417537, -0.004206, -0.00423618,
  -0.00426592, -0.00429521, -0.00432404, -0.00435242, -0.00438033,
  -0.00440779, -0.00443478, -0.0044613, -0.00448736, -0.00451294,
  -0.00453804, -0.00456267, -0.00458682, -0.00461048, -0.00463366,
  -0.00465635, -0.00467855, -0.00470026, -0.00472147, -0.00474219,
  -0.00476241, -0.00478213, -0.00480135, -0.00482006, -0.00483827,
  -0.00485596, -0.00487315, -0.00488983, -0.00490599, -0.00492164,
  -0.00493677, -0.00495139, -0.00496549, -0.00497906, -0.00499211,
  -0.00500464, -0.00501665, -0.00502813, -0.00503908, -0.00504951,
  -0.00505941, -0.00506878, -0.00507762, -0.00508592, -0.0050937,
  -0.00510094, -0.00510765, -0.00511382, -0.00511947, -0.00512457,
  -0.00512914, -0.00513318, -0.00513668, -0.00513964, -0.00514207,
  -0.00514396, -0.00514531, -0.00514612, -0.0051464, -0.00514615,
  -0.00514535, -0.00514402, -0.00514216, -0.00513976, -0.00513682,
  -0.00513335, -0.00512934, -0.0051248, -0.00511973, -0.00511412,
  -0.00510799, -0.00510132, -0.00509412, -0.00508639, -0.00507813,
  -0.00506934, -0.00506003, -0.00505019, -0.00503983, -0.00502894,
  -0.00501753, -0.0050056, -0.00499315, -0.00498018, -0.0049667,
  -0.0049527, -0.00493819, -0.00492316, -0.00490763, -0.00489158,
  -0.00487503, -0.00485798, -0.00484042, -0.00482236, -0.0048038,
  -0.00478474, -0.00476519, -0.00474514, -0.00472461, -0.00470358,
  -0.00468207, -0.00466007, -0.00463759, -0.00461464, -0.0045912,
  -0.00456729, -0.00454291, -0.00451806, -0.00449275, -0.00446697,
  -0.00444073, -0.00441403, -0.00438687, -0.00435926, -0.00433121,
  -0.0043027, -0.00427375, -0.00424437, -0.00421454, -0.00418428,
  -0.00415359, -0.00412247, -0.00409093, -0.00405896, -0.00402658,
  -0.00399378, -0.00396057, -0.00392695, -0.00389293, -0.00385851,
  -0.00382369, -0.00378848, -0.00375288, -0.0037169, -0.00368053,
  -0.00364378, -0.00360666, -0.00356917, -0.00353131, -0.00349309,
  -0.00345451, -0.00341558, -0.00337629, -0.00333666, -0.00329669,
  -0.00325638, -0.00321573, -0.00317476, -0.00313346, -0.00309184,
  -0.0030499, -0.00300765, -0.00296509, -0.00292223, -0.00287906,
  -0.00283561, -0.00279186, -0.00274783, -0.00270351, -0.00265892,
  -0.00261406, -0.00256893, -0.00252354, -0.00247789, -0.00243198,
  -0.00238583, -0.00233943, -0.0022928, -0.00224593, -0.00219883,
  -0.0021515, -0.00210396, -0.0020562, -0.00200823, -0.00196006,
  -0.00191169, -0.00186312, -0.00181436, -0.00176542, -0.00171629,
  -0.00166699, -0.00161753, -0.00156789, -0.0015181, -0.00146815,
  -0.00141805, -0.00136781, -0.00131743, -0.00126692, -0.00121627,
  -0.00116551, -0.00111462, -0.00106362, -0.00101251, -0.0009613,
  -0.000909992, -0.00085859, -0.000807102, -0.000755531, -0.000703884,
  -0.000652165, -0.00060038, -0.000548534, -0.000496632, -0.00044468,
  -0.000392682, -0.000340645, -0.000288573, -0.000236472,
  -0.000184347, -0.000132203, -8.0046e-05, -2.78807e-05, 2.42873e-05,
  7.6453e-05, 0.000128611, 0.000180756, 0.000232882, 0.000284985,
  0.000337059, 0.000389099, 0.000441099, 0.000493055, 0.000544961,
  0.000596811, 0.000648601, 0.000700326, 0.000751979, 0.000803557,
  0.000855053, 0.000906463, 0.000957781, 0.001009, 0.00106012,
  0.00111113, 0.00116203, 0.00121282, 0.00126348, 0.00131401,
  0.00136441, 0.00141467, 0.00146479, 0.00151476, 0.00156458,
  0.00161424, 0.00166373, 0.00171306, 0.00176222, 0.0018112,
  0.00185999, 0.0019086, 0.00195702, 0.00200523, 0.00205325,
  0.00210106, 0.00214866, 0.00219604, 0.0022432, 0.00229013,
  0.00233684, 0.00238331, 0.00242953, 0.00247552, 0.00252125,
  0.00256673, 0.00261195, 0.00265691, 0.00270161, 0.00274603,
  0.00279017, 0.00283404, 0.00287761, 0.0029209, 0.0029639, 0.0030066,
  0.003049, 0.00309109, 0.00313286, 0.00317433, 0.00321548, 0.0032563,
  0.0032968, 0.00333696, 0.00337679, 0.00341628, 0.00345543,
  0.00349423, 0.00353269, 0.00357078, 0.00360852, 0.0036459,
  0.00368291, 0.00371955, 0.00375582, 0.00379172, 0.00382723,
  0.00386236, 0.0038971, 0.00393146, 0.00396542, 0.00399898,
  0.00403214, 0.0040649, 0.00409725, 0.00412919, 0.00416072,
  0.00419183, 0.00422253, 0.0042528, 0.00428264, 0.00431206,
  0.00434104, 0.00436959, 0.00439771, 0.00442538, 0.00445262,
  0.00447941, 0.00450575, 0.00453164, 0.00455708, 0.00458206,
  0.00460658, 0.00463065, 0.00465425, 0.00467739, 0.00470006,
  0.00472227, 0.004744, 0.00476526, 0.00478604, 0.00480635,
  0.00482617, 0.00484552, 0.00486438, 0.00488276, 0.00490065,
  0.00491805, 0.00493496, 0.00495138, 0.00496731, 0.00498274,
  0.00499768, 0.00501212, 0.00502606, 0.00503949, 0.00505243,
  0.00506487, 0.0050768, 0.00508822, 0.00509914, 0.00510955,
  0.00511946, 0.00512885, 0.00513773, 0.00514611, 0.00515397,
  0.00516132, 0.00516815, 0.00517448, 0.00518028, 0.00518558,
  0.00519036, 0.00519462, 0.00519836, 0.0052016, 0.00520431,
  0.00520651, 0.00520819, 0.00520935, 0.00520999, 0.00521012,
  0.00520974, 0.00520883, 0.00520741, 0.00520547, 0.00520301,
  0.00520004, 0.00519656, 0.00519255, 0.00518804, 0.00518301,
  0.00517746, 0.0051714, 0.00516483, 0.00515775, 0.00515016,
  0.00514205, 0.00513344, 0.00512432, 0.00511469, 0.00510456,
  0.00509392, 0.00508277, 0.00507112, 0.00505897, 0.00504632,
  0.00503317, 0.00501952, 0.00500538, 0.00499074, 0.00497561,
  0.00495998, 0.00494386, 0.00492726, 0.00491017, 0.00489259,
  0.00487453, 0.00485599, 0.00483696, 0.00481746, 0.00479748,
  0.00477703, 0.00475611, 0.00473472, 0.00471286, 0.00469053,
  0.00466774, 0.00464449, 0.00462079, 0.00459662, 0.004572,
  0.00454693, 0.00452142, 0.00449545, 0.00446905, 0.0044422,
  0.00441491, 0.00438719, 0.00435903, 0.00433045, 0.00430144,
  0.004272, 0.00424214, 0.00421187, 0.00418118, 0.00415008,
  0.00411857, 0.00408665, 0.00405433, 0.00402161, 0.00398849,
  0.00395499, 0.00392109, 0.00388681, 0.00385214, 0.00381709,
  0.00378167, 0.00374588, 0.00370972, 0.00367319, 0.0036363,
  0.00359905, 0.00356145, 0.0035235, 0.0034852, 0.00344656,
  0.00340758, 0.00336827, 0.00332862, 0.00328865, 0.00324835,
  0.00320774, 0.00316681, 0.00312556, 0.00308401, 0.00304216,
  0.00300001, 0.00295756, 0.00291483, 0.0028718, 0.0028285,
  0.00278491, 0.00274106, 0.00269693, 0.00265254, 0.00260789,
  0.00256298, 0.00251782, 0.00247242, 0.00242677, 0.00238088,
  0.00233476, 0.00228841, 0.00224184, 0.00219505, 0.00214804,
  0.00210082, 0.00205339, 0.00200577, 0.00195794, 0.00190993,
  0.00186172, 0.00181334, 0.00176477, 0.00171604, 0.00166713,
  0.00161806, 0.00156884, 0.00151946, 0.00146993, 0.00142026,
  0.00137044, 0.0013205, 0.00127042, 0.00122022, 0.0011699,
  0.00111947, 0.00106892, 0.00101828, 0.000967527, 0.000916684,
  0.000865752, 0.000814734, 0.000763637, 0.000712465, 0.000661224,
  0.000609917, 0.000558551, 0.000507131, 0.000455661, 0.000404146,
  0.000352591, 0.000301003, 0.000249384, 0.000197742, 0.00014608,
  9.44034e-05, 4.27178e-05, -8.97192e-06, -6.06608e-05, -0.000112344,
  -0.000164016, -0.000215672, -0.000267307, -0.000318915,
  -0.000370493, -0.000422035, -0.000473535, -0.000524989,
  -0.000576392, -0.000627738, -0.000679023, -0.000730242, -0.00078139,
  -0.000832461, -0.000883451, -0.000934355, -0.000985168, -0.00103588,
  -0.0010865, -0.00113701, -0.00118741, -0.00123769, -0.00128785,
  -0.00133789, -0.0013878, -0.00143757, -0.0014872, -0.00153668,
  -0.00158602, -0.0016352, -0.00168422, -0.00173308, -0.00178176,
  -0.00183028, -0.00187862, -0.00192677, -0.00197473, -0.00202251,
  -0.00207008, -0.00211746, -0.00216462, -0.00221158, -0.00225832,
  -0.00230484, -0.00235114, -0.00239721, -0.00244304, -0.00248864,
  -0.00253399, -0.0025791, -0.00262396, -0.00266856, -0.0027129,
  -0.00275698, -0.00280078, -0.00284432, -0.00288758, -0.00293056,
  -0.00297325, -0.00301565, -0.00305776, -0.00309957, -0.00314109,
  -0.00318229, -0.00322319, -0.00326377, -0.00330403, -0.00334398,
  -0.00338359, -0.00342288, -0.00346184, -0.00350046, -0.00353874,
  -0.00357667, -0.00361426, -0.00365149, -0.00368837, -0.0037249,
  -0.00376106, -0.00379685, -0.00383228, -0.00386733, -0.00390201,
  -0.0039363, -0.00397022, -0.00400375, -0.00403689, -0.00406964,
  -0.00410199, -0.00413394, -0.0041655, -0.00419665, -0.00422739,
  -0.00425772, -0.00428763, -0.00431713, -0.00434621, -0.00437487,
  -0.00440311, -0.00443091, -0.00445829, -0.00448523, -0.00451174,
  -0.00453781, -0.00456344, -0.00458863, -0.00461337, -0.00463766,
  -0.0046615, -0.00468489, -0.00470783, -0.00473031, -0.00475233,
  -0.00477389, -0.00479499, -0.00481562, -0.00483578, -0.00485548,
  -0.0048747, -0.00489345, -0.00491173, -0.00492953, -0.00494685,
  -0.00496369, -0.00498005, -0.00499593, -0.00501132, -0.00502623,
  -0.00504065, -0.00505458, -0.00506802, -0.00508097, -0.00509343,
  -0.00510539, -0.00511686, -0.00512783, -0.00513831, -0.00514828,
  -0.00515776, -0.00516674, -0.00517522, -0.0051832, -0.00519067,
  -0.00519764, -0.00520411, -0.00521007, -0.00521553, -0.00522048,
  -0.00522493, -0.00522887, -0.00523231, -0.00523524, -0.00523766,
  -0.00523957, -0.00524098, -0.00524188, -0.00524227, -0.00524215,
  -0.00524152, -0.00524039, -0.00523875, -0.00523661, -0.00523395,
  -0.00523079, -0.00522713, -0.00522295, -0.00521827, -0.00521309,
  -0.0052074, -0.00520121, -0.00519451, -0.00518732, -0.00517961,
  -0.00517141, -0.00516271, -0.00515351, -0.00514381, -0.00513361,
  -0.00512291, -0.00511172, -0.00510003, -0.00508785, -0.00507518,
  -0.00506202, -0.00504837, -0.00503423, -0.0050196, -0.00500448,
  -0.00498889, -0.00497281, -0.00495625, -0.0049392, -0.00492169,
  -0.00490369, -0.00488522, -0.00486628, -0.00484687, -0.00482699,
  -0.00480664, -0.00478583, -0.00476455, -0.00474282, -0.00472062,
  -0.00469797, -0.00467486, -0.00465131, -0.0046273, -0.00460285,
  -0.00457795, -0.0045526, -0.00452682, -0.0045006, -0.00447395,
  -0.00444686, -0.00441934, -0.0043914, -0.00436303, -0.00433424,
  -0.00430503, -0.0042754, -0.00424536, -0.00421491, -0.00418405,
  -0.00415279, -0.00412113, -0.00408907, -0.00405661, -0.00402376,
  -0.00399053, -0.0039569, -0.0039229, -0.00388851, -0.00385375,
  -0.00381862, -0.00378312, -0.00374725, -0.00371103, -0.00367444,
  -0.00363749, -0.0036002, -0.00356256, -0.00352457, -0.00348625,
  -0.00344758, -0.00340859, -0.00336926, -0.00332961, -0.00328964,
  -0.00324935, -0.00320874, -0.00316783, -0.00312661, -0.00308508,
  -0.00304326, -0.00300115, -0.00295875, -0.00291606, -0.00287308,
  -0.00282983, -0.00278631, -0.00274252, -0.00269846, -0.00265415,
  -0.00260957, -0.00256475, -0.00251967, -0.00247436, -0.0024288,
  -0.00238301, -0.00233699, -0.00229075, -0.00224428, -0.00219759,
  -0.0021507, -0.00210359, -0.00205629, -0.00200878, -0.00196108,
  -0.00191319, -0.00186512, -0.00181687, -0.00176844, -0.00171984,
  -0.00167107, -0.00162214, -0.00157306, -0.00152383, -0.00147444,
  -0.00142492, -0.00137525, -0.00132546, -0.00127553, -0.00122549,
  -0.00117532, -0.00112504, -0.00107466, -0.00102417, -0.000973577,
  -0.000922893, -0.00087212, -0.000821263, -0.000770327, -0.000719316,
  -0.000668236, -0.000617091, -0.000565887, -0.000514628,
  -0.000463319, -0.000411966, -0.000360573, -0.000309145,
  -0.000257688, -0.000206205, -0.000154703, -0.000103185, -5.1658e-05,
  -1.25718e-07, 5.14066e-05, 0.000102934, 0.000154451, 0.000205954,
  0.000257436, 0.000308894, 0.000360322, 0.000411715, 0.000463068,
  0.000514377, 0.000565635, 0.00061684, 0.000667984, 0.000719064,
  0.000770075, 0.000821012, 0.000871869, 0.000922641, 0.000973325,
  0.00102392, 0.00107441, 0.00112479, 0.00117507, 0.00122524,
  0.00127528, 0.00132521, 0.001375, 0.00142467, 0.00147419,
  0.00152357, 0.00157281, 0.00162189, 0.00167082, 0.00171959,
  0.00176819, 0.00181662, 0.00186487, 0.00191294, 0.00196083,
  0.00200853, 0.00205604, 0.00210334, 0.00215045, 0.00219734,
  0.00224403, 0.00229049, 0.00233674, 0.00238276, 0.00242855,
  0.00247411, 0.00251942, 0.0025645, 0.00260932, 0.0026539,
  0.00269821, 0.00274227, 0.00278606, 0.00282958, 0.00287283,
  0.0029158, 0.00295849, 0.0030009, 0.00304301, 0.00308483,
  0.00312636, 0.00316758, 0.00320849, 0.0032491, 0.00328939,
  0.00332936, 0.00336901, 0.00340834, 0.00344733, 0.003486,
  0.00352432, 0.00356231, 0.00359995, 0.00363724, 0.00367419,
  0.00371077, 0.003747, 0.00378287, 0.00381837, 0.0038535, 0.00388826,
  0.00392265, 0.00395665, 0.00399028, 0.00402351, 0.00405636,
  0.00408882, 0.00412088, 0.00415254, 0.0041838, 0.00421466,
  0.00424511, 0.00427515, 0.00430477, 0.00433398, 0.00436277,
  0.00439114, 0.00441909, 0.00444661, 0.00447369, 0.00450035,
  0.00452657, 0.00455235, 0.00457769, 0.00460259, 0.00462705,
  0.00465106, 0.00467461, 0.00469772, 0.00472037, 0.00474256,
  0.0047643, 0.00478558, 0.00480639, 0.00482674, 0.00484662,
  0.00486603, 0.00488497, 0.00490344, 0.00492143, 0.00493895,
  0.00495599, 0.00497256, 0.00498864, 0.00500423, 0.00501935,
  0.00503398, 0.00504812, 0.00506177, 0.00507493, 0.0050876,
  0.00509978, 0.00511147, 0.00512266, 0.00513336, 0.00514355,
  0.00515326, 0.00516246, 0.00517116, 0.00517936, 0.00518706,
  0.00519426, 0.00520096, 0.00520715, 0.00521284, 0.00521802,
  0.0052227, 0.00522687, 0.00523054, 0.0052337, 0.00523636, 0.0052385,
  0.00524014, 0.00524127, 0.0052419, 0.00524201, 0.00524162,
  0.00524073, 0.00523932, 0.00523741, 0.00523498, 0.00523206,
  0.00522862, 0.00522468, 0.00522023, 0.00521528, 0.00520982,
  0.00520386, 0.00519739, 0.00519042, 0.00518294, 0.00517497,
  0.00516649, 0.00515751, 0.00514803, 0.00513805, 0.00512758,
  0.00511661, 0.00510514, 0.00509317, 0.00508072, 0.00506777,
  0.00505433, 0.0050404, 0.00502598, 0.00501107, 0.00499568,
  0.0049798, 0.00496344, 0.0049466, 0.00492927, 0.00491147, 0.0048932,
  0.00487445, 0.00485522, 0.00483553, 0.00481537, 0.00479473,
  0.00477364, 0.00475208, 0.00473006, 0.00470758, 0.00468464,
  0.00466125, 0.00463741, 0.00461312, 0.00458837, 0.00456319,
  0.00453756, 0.00451149, 0.00448498, 0.00445804, 0.00443066,
  0.00440285, 0.00437462, 0.00434596, 0.00431688, 0.00428738,
  0.00425746, 0.00422713, 0.00419639, 0.00416525, 0.00413369,
  0.00410174, 0.00406939, 0.00403664, 0.0040035, 0.00396997,
  0.00393605, 0.00390175, 0.00386708, 0.00383202, 0.0037966,
  0.0037608, 0.00372464, 0.00368812, 0.00365124, 0.00361401,
  0.00357642, 0.00353848, 0.00350021, 0.00346159, 0.00342263,
  0.00338334, 0.00334372, 0.00330378, 0.00326352, 0.00322293,
  0.00318204, 0.00314083, 0.00309932, 0.00305751, 0.0030154, 0.002973,
  0.0029303, 0.00288733, 0.00284407, 0.00280053, 0.00275672,
  0.00271265, 0.00266831, 0.00262371, 0.00257885, 0.00253374,
  0.00248839, 0.00244279, 0.00239696, 0.00235089, 0.00230459,
  0.00225807, 0.00221133, 0.00216437, 0.0021172, 0.00206983,
  0.00202226, 0.00197448, 0.00192652, 0.00187836, 0.00183003,
  0.00178151, 0.00173282, 0.00168397, 0.00163495, 0.00158577,
  0.00153643, 0.00148694, 0.00143731, 0.00138754, 0.00133764,
  0.0012876, 0.00123744, 0.00118716, 0.00113676, 0.00108625,
  0.00103563, 0.000984917, 0.000934104, 0.0008832, 0.00083221,
  0.000781139, 0.000729991, 0.000678772, 0.000627487, 0.00057614,
  0.000524737, 0.000473283, 0.000421783, 0.000370242, 0.000318664,
  0.000267055, 0.00021542, 0.000163764, 0.000112092, 6.04093e-05,
  8.72048e-06, -4.29692e-05, -9.46548e-05, -0.000146331, -0.000197993,
  -0.000249636, -0.000301254, -0.000352843, -0.000404397,
  -0.000455912, -0.000507382, -0.000558803, -0.000610169,
  -0.000661475, -0.000712717, -0.000763888, -0.000814986,
  -0.000866003, -0.000916936, -0.000967779, -0.00101853, -0.00106918,
  -0.00111972, -0.00117015, -0.00122047, -0.00127067, -0.00132075,
  -0.0013707, -0.00142051, -0.00147018, -0.00151971, -0.00156909,
  -0.00161832, -0.00166738, -0.00171629, -0.00176502, -0.00181359,
  -0.00186197, -0.00191018, -0.00195819, -0.00200602, -0.00205364,
  -0.00210107, -0.00214829, -0.0021953, -0.00224209, -0.00228867,
  -0.00233501, -0.00238114, -0.00242702, -0.00247267, -0.00251808,
  -0.00256323, -0.00260814, -0.00265279, -0.00269718, -0.00274131,
  -0.00278517, -0.00282875, -0.00287205, -0.00291508, -0.00295781,
  -0.00300026, -0.00304241, -0.00308426, -0.00312581, -0.00316706,
  -0.00320799, -0.0032486, -0.0032889, -0.00332887, -0.00336852,
  -0.00340783, -0.00344681, -0.00348545, -0.00352375, -0.0035617,
  -0.0035993, -0.00363655, -0.00367344, -0.00370997, -0.00374613,
  -0.00378192, -0.00381734, -0.00385239, -0.00388706, -0.00392134,
  -0.00395524, -0.00398875, -0.00402186, -0.00405458, -0.0040869,
  -0.00411882, -0.00415033, -0.00418143, -0.00421212, -0.0042424,
  -0.00427225, -0.00430169, -0.0043307, -0.00435928, -0.00438744,
  -0.00441516, -0.00444245, -0.0044693, -0.0044957, -0.00452167,
  -0.00454719, -0.00457226, -0.00459687, -0.00462104, -0.00464475,
  -0.004668, -0.00469078, -0.00471311, -0.00473497, -0.00475636,
  -0.00477729, -0.00479774, -0.00481771, -0.00483721, -0.00485624,
  -0.00487478, -0.00489284, -0.00491042, -0.00492751, -0.00494412,
  -0.00496023, -0.00497586, -0.00499099, -0.00500563, -0.00501978,
  -0.00503342, -0.00504657, -0.00505922, -0.00507137, -0.00508302,
  -0.00509417, -0.00510481, -0.00511494, -0.00512457, -0.00513369,
  -0.00514231, -0.00515041, -0.005158, -0.00516509, -0.00517166,
  -0.00517771, -0.00518326, -0.00518829, -0.00519281, -0.00519681,
  -0.00520029, -0.00520327, -0.00520572, -0.00520766, -0.00520908,
  -0.00520999, -0.00521037, -0.00521025, -0.0052096, -0.00520844,
  -0.00520676, -0.00520456, -0.00520185, -0.00519862, -0.00519487,
  -0.00519061, -0.00518583, -0.00518054, -0.00517473, -0.00516841,
  -0.00516157, -0.00515422, -0.00514636, -0.00513799, -0.0051291,
  -0.00511971, -0.0051098, -0.00509939, -0.00508847, -0.00507705,
  -0.00506512, -0.00505268, -0.00503975, -0.00502631, -0.00501237,
  -0.00499793, -0.00498299, -0.00496756, -0.00495163, -0.00493521,
  -0.0049183, -0.0049009, -0.00488301, -0.00486463, -0.00484577,
  -0.00482642, -0.0048066, -0.00478629, -0.00476551, -0.00474425,
  -0.00472252, -0.00470031, -0.00467764, -0.0046545, -0.0046309,
  -0.00460684, -0.00458231, -0.00455733, -0.00453189, -0.004506,
  -0.00447966, -0.00445287, -0.00442564, -0.00439796, -0.00436985,
  -0.00434129, -0.00431231, -0.00428289, -0.00425305, -0.00422278,
  -0.00419208, -0.00416097, -0.00412944, -0.0040975, -0.00406515,
  -0.00403239, -0.00399923, -0.00396567, -0.00393171, -0.00389736,
  -0.00386261, -0.00382748, -0.00379197, -0.00375608, -0.00371981,
  -0.00368316, -0.00364615, -0.00360877, -0.00357103, -0.00353294,
  -0.00349449, -0.00345568, -0.00341653, -0.00337704, -0.00333721,
  -0.00329705, -0.00325655, -0.00321573, -0.00317458, -0.00313312,
  -0.00309134, -0.00304925, -0.00300685, -0.00296415, -0.00292116,
  -0.00287787, -0.00283429, -0.00279042, -0.00274628, -0.00270186,
  -0.00265717, -0.00261221, -0.00256698, -0.0025215, -0.00247577,
  -0.00242978, -0.00238356, -0.00233709, -0.00229039, -0.00224345,
  -0.00219629, -0.00214891, -0.00210131, -0.0020535, -0.00200549,
  -0.00195727, -0.00190885, -0.00186024, -0.00181145, -0.00176247,
  -0.00171331, -0.00166398, -0.00161449, -0.00156483, -0.00151501,
  -0.00146504, -0.00141492, -0.00136466, -0.00131426, -0.00126373,
  -0.00121307, -0.00116228, -0.00111138, -0.00106037, -0.00100925,
  -0.000958032, -0.000906714, -0.000855305, -0.000803808,
  -0.000752231, -0.000700577, -0.000648853, -0.000597063,
  -0.000545212, -0.000493306, -0.000441351, -0.00038935, -0.00033731,
  -0.000285236, -0.000233134, -0.000181007, -0.000128862,
  -7.67044e-05, -2.45388e-05, 2.76293e-05, 7.97946e-05, 0.000131952,
  0.000184096, 0.000236221, 0.000288322, 0.000340393, 0.000392431,
  0.000444428, 0.00049638, 0.000548282, 0.000600128, 0.000651913,
  0.000703632, 0.00075528, 0.00080685, 0.000858339, 0.00090974,
  0.000961049, 0.00101226, 0.00106337, 0.00111437, 0.00116525,
  0.00121602, 0.00126667, 0.00131718, 0.00136756, 0.0014178,
  0.0014679, 0.00151785, 0.00156764, 0.00161727, 0.00166674,
  0.00171604, 0.00176516, 0.00181411, 0.00186287, 0.00191143,
  0.00195981, 0.00200798, 0.00205595, 0.00210371, 0.00215125,
  0.00219858, 0.00224567, 0.00229254, 0.00233918, 0.00238558,
  0.00243173, 0.00247763, 0.00252328, 0.00256868, 0.00261381,
  0.00265867, 0.00270326, 0.00274758, 0.00279161, 0.00283536,
  0.00287881, 0.00292197, 0.00296484, 0.0030074, 0.00304965,
  0.00309159, 0.00313321, 0.00317451, 0.00321548, 0.00325613,
  0.00329644, 0.00333641, 0.00337604, 0.00341533, 0.00345426,
  0.00349284, 0.00353106, 0.00356892, 0.00360641, 0.00364353,
  0.00368028, 0.00371665, 0.00375263, 0.00378823, 0.00382344,
  0.00385826, 0.00389268, 0.0039267, 0.00396032, 0.00399353,
  0.00402633, 0.00405871, 0.00409067, 0.00412222, 0.00415334,
  0.00418403, 0.00421429, 0.00424411, 0.0042735, 0.00430245,
  0.00433096, 0.00435901, 0.00438662, 0.00441378, 0.00444048,
  0.00446672, 0.0044925, 0.00451781, 0.00454266, 0.00456704,
  0.00459095, 0.00461439, 0.00463734, 0.00465982, 0.00468182,
  0.00470333, 0.00472435, 0.00474489, 0.00476494, 0.00478449,
  0.00480355, 0.00482211, 0.00484017, 0.00485773, 0.00487478,
  0.00489133, 0.00490738, 0.00492291, 0.00493794, 0.00495245,
  0.00496645, 0.00497993, 0.0049929, 0.00500535, 0.00501728,
  0.00502869, 0.00503957, 0.00504994, 0.00505978, 0.00506909,
  0.00507788, 0.00508613, 0.00509386, 0.00510106, 0.00510773,
  0.00511387, 0.00511948, 0.00512455, 0.00512909, 0.0051331,
  0.00513657, 0.00513951, 0.00514191, 0.00514377, 0.0051451,
  0.0051459, 0.00514615, 0.00514587, 0.00514506, 0.0051437,
  0.00514181, 0.00513939, 0.00513642, 0.00513293, 0.00512889,
  0.00512432, 0.00511921, 0.00511357, 0.0051074, 0.00510069,
  0.00509345, 0.00508567, 0.00507736, 0.00506853, 0.00505916,
  0.00504926, 0.00503883, 0.00502788, 0.0050164, 0.00500439,
  0.00499186, 0.00497881, 0.00496523, 0.00495114, 0.00493652,
  0.00492139, 0.00490574, 0.00488958, 0.0048729, 0.00485571,
  0.00483801, 0.00481981, 0.0048011, 0.00478188, 0.00476216,
  0.00474194, 0.00472122, 0.00470001, 0.0046783, 0.0046561,
  0.00463341, 0.00461023, 0.00458656, 0.00456242, 0.00453779,
  0.00451269, 0.00448711, 0.00446105, 0.00443453, 0.00440754,
  0.00438008, 0.00435216, 0.00432379, 0.00429495, 0.00426567,
  0.00423593, 0.00420575, 0.00417512, 0.00414405, 0.00411254,
  0.0040806, 0.00404823, 0.00401543, 0.0039822, 0.00394856,
  0.00391449, 0.00388002, 0.00384513, 0.00380983, 0.00377413,
  0.00373803, 0.00370154, 0.00366465, 0.00362737, 0.00358971,
  0.00355167, 0.00351325, 0.00347446, 0.00343531, 0.00339578,
  0.0033559, 0.00331566, 0.00327506, 0.00323412, 0.00319284,
  0.00315122, 0.00310926, 0.00306697, 0.00302435, 0.00298142,
  0.00293816, 0.0028946, 0.00285072, 0.00280654, 0.00276207,
  0.0027173, 0.00267223, 0.00262689, 0.00258126, 0.00253536,
  0.00248919, 0.00244275, 0.00239606, 0.0023491, 0.0023019,
  0.00225445, 0.00220676, 0.00215883, 0.00211068, 0.00206229,
  0.00201369, 0.00196487, 0.00191585, 0.00186661, 0.00181718,
  0.00176755, 0.00171773, 0.00166773, 0.00161755, 0.0015672,
  0.00151668, 0.001466, 0.00141516, 0.00136417, 0.00131303,
  0.00126175, 0.00121033, 0.00115879, 0.00110712, 0.00105533,
  0.00100343, 0.000951423, 0.000899312, 0.000847104, 0.000794805,
  0.000742421, 0.000689956, 0.000637418, 0.000584811, 0.00053214,
  0.000479413, 0.000426634, 0.000373809, 0.000320943, 0.000268043,
  0.000215114, 0.000162162, 0.000109193, 5.62112e-05, 3.22371e-06,
  -4.97641e-05, -0.000102747, -0.000155718, -0.000208673,
  -0.000261605, -0.000314509, -0.000367378, -0.000420208,
  -0.000472993, -0.000525727, -0.000578403, -0.000631017,
  -0.000683563, -0.000736035, -0.000788427, -0.000840733,
  -0.000892949, -0.000945068, -0.000997084, -0.00104899, -0.00110079,
  -0.00115246, -0.00120401, -0.00125543, -0.00130671, -0.00135785,
  -0.00140885, -0.00145969, -0.00151037, -0.00156089, -0.00161123,
  -0.00166141, -0.0017114, -0.0017612, -0.00181082, -0.00186023,
  -0.00190945, -0.00195845, -0.00200724, -0.00205582, -0.00210417,
  -0.00215229, -0.00220017, -0.00224781, -0.00229521, -0.00234236,
  -0.00238925, -0.00243589, -0.00248225, -0.00252835, -0.00257416,
  -0.0026197, -0.00266495, -0.00270991, -0.00275457, -0.00279893,
  -0.00284298, -0.00288672, -0.00293015, -0.00297325, -0.00301603,
  -0.00305848, -0.00310059, -0.00314236, -0.00318379, -0.00322487,
  -0.00326559, -0.00330596, -0.00334596, -0.00338559, -0.00342485,
  -0.00346374, -0.00350224, -0.00354036, -0.00357809, -0.00361542,
  -0.00365236, -0.00368889, -0.00372502, -0.00376074, -0.00379604,
  -0.00383093, -0.00386539, -0.00389943, -0.00393303, -0.0039662,
  -0.00399893, -0.00403123, -0.00406307, -0.00409447, -0.00412541,
  -0.0041559, -0.00418593, -0.00421549, -0.00424459, -0.00427322,
  -0.00430138, -0.00432906, -0.00435625, -0.00438297, -0.0044092,
  -0.00443494, -0.00446019, -0.00448495, -0.00450921, -0.00453296,
  -0.00455622, -0.00457896, -0.0046012, -0.00462293, -0.00464414,
  -0.00466484, -0.00468501, -0.00470467, -0.0047238, -0.00474241,
  -0.00476049, -0.00477804, -0.00479505, -0.00481153, -0.00482748,
  -0.00484288, -0.00485775, -0.00487207, -0.00488585, -0.00489909,
  -0.00491177, -0.00492391, -0.0049355, -0.00494654, -0.00495702,
  -0.00496695, -0.00497632, -0.00498514, -0.0049934, -0.00500109,
  -0.00500823, -0.00501481, -0.00502082, -0.00502628, -0.00503116,
  -0.00503549, -0.00503925, -0.00504244, -0.00504506, -0.00504712,
  -0.00504862, -0.00504954, -0.0050499, -0.00504969, -0.00504891,
  -0.00504756, -0.00504565, -0.00504317, -0.00504011, -0.0050365,
  -0.00503231, -0.00502755, -0.00502223, -0.00501635, -0.00500989,
  -0.00500287, -0.00499529, -0.00498714, -0.00497843, -0.00496915,
  -0.00495932, -0.00494892, -0.00493797, -0.00492645, -0.00491438,
  -0.00490175, -0.00488856, -0.00487482, -0.00486053, -0.00484569,
  -0.0048303, -0.00481436, -0.00479787, -0.00478084, -0.00476327,
  -0.00474516, -0.0047265, -0.00470731, -0.00468759, -0.00466733,
  -0.00464654, -0.00462522, -0.00460337, -0.004581, -0.00455811,
  -0.0045347, -0.00451078, -0.00448633, -0.00446138, -0.00443592,
  -0.00440995, -0.00438348, -0.00435651, -0.00432904, -0.00430107,
  -0.00427262, -0.00424367, -0.00421424, -0.00418433, -0.00415394,
  -0.00412307, -0.00409173, -0.00405992, -0.00402765, -0.00399492,
  -0.00396172, -0.00392807, -0.00389398, -0.00385943, -0.00382444,
  -0.00378902, -0.00375315, -0.00371686, -0.00368014, -0.00364299,
  -0.00360543, -0.00356745, -0.00352906, -0.00349026, -0.00345106,
  -0.00341147, -0.00337148, -0.0033311, -0.00329034, -0.0032492,
  -0.00320768, -0.00316579, -0.00312354, -0.00308093, -0.00303796,
  -0.00299463, -0.00295097, -0.00290696, -0.00286261, -0.00281793,
  -0.00277293, -0.00272761, -0.00268197, -0.00263601, -0.00258976,
  -0.0025432, -0.00249635, -0.0024492, -0.00240178, -0.00235407,
  -0.00230609, -0.00225784, -0.00220933, -0.00216056, -0.00211154,
  -0.00206228, -0.00201277, -0.00196303, -0.00191307, -0.00186288,
  -0.00181247, -0.00176185, -0.00171102, -0.00166, -0.00160878,
  -0.00155737, -0.00150578, -0.00145402, -0.00140208, -0.00134998,
  -0.00129773, -0.00124532, -0.00119276, -0.00114007, -0.00108724,
  -0.00103428, -0.000981208, -0.000928016, -0.000874715, -0.000821312,
  -0.000767812, -0.000714222, -0.000660548, -0.000606797,
  -0.000552974, -0.000499086, -0.000445139, -0.00039114, -0.000337095,
  -0.00028301, -0.000228892, -0.000174747, -0.000120581, -6.64014e-05,
  -1.22137e-05, 4.19755e-05, 9.61596e-05, 0.000150332, 0.000204487,
  0.000258618, 0.000312718, 0.000366782, 0.000420801, 0.000474771,
  0.000528685, 0.000582536, 0.000636318, 0.000690024, 0.000743649,
  0.000797185, 0.000850627, 0.000903968, 0.000957201, 0.00101032,
  0.00106332, 0.00111619, 0.00116893, 0.00122153, 0.00127399,
  0.00132629, 0.00137844, 0.00143042, 0.00148223, 0.00153386,
  0.00158532, 0.00163658, 0.00168764, 0.00173851, 0.00178916,
  0.00183961, 0.00188983, 0.00193983, 0.00198959, 0.00203912,
  0.0020884, 0.00213743, 0.00218621, 0.00223472, 0.00228297,
  0.00233094, 0.00237863, 0.00242603, 0.00247315, 0.00251997,
  0.00256648, 0.00261269, 0.00265858, 0.00270415, 0.00274939,
  0.00279431, 0.00283889, 0.00288312, 0.00292701, 0.00297054,
  0.00301372, 0.00305653, 0.00309897, 0.00314104, 0.00318273,
  0.00322403, 0.00326495, 0.00330546, 0.00334558, 0.0033853,
  0.0034246, 0.00346349, 0.00350195, 0.00354, 0.00357761, 0.00361479,
  0.00365153, 0.00368783, 0.00372367, 0.00375907, 0.00379401,
  0.00382848, 0.00386249, 0.00389603, 0.0039291, 0.00396169,
  0.00399379, 0.00402541, 0.00405653, 0.00408716, 0.00411729,
  0.00414692, 0.00417604, 0.00420465, 0.00423275, 0.00426032,
  0.00428738, 0.00431391, 0.00433991, 0.00436538, 0.00439032,
  0.00441472, 0.00443857, 0.00446188, 0.00448464, 0.00450686,
  0.00452851, 0.00454961, 0.00457015, 0.00459013, 0.00460955,
  0.00462839, 0.00464667, 0.00466437, 0.0046815, 0.00469805,
  0.00471402, 0.00472941, 0.00474421, 0.00475843, 0.00477206,
  0.0047851, 0.00479754, 0.0048094, 0.00482065, 0.00483131,
  0.00484138, 0.00485084, 0.0048597, 0.00486795, 0.00487561,
  0.00488265, 0.00488909, 0.00489493, 0.00490015, 0.00490477,
  0.00490877, 0.00491216, 0.00491494, 0.00491711, 0.00491867,
  0.00491961, 0.00491994, 0.00491965, 0.00491876, 0.00491724,
  0.00491511, 0.00491237, 0.00490901, 0.00490504, 0.00490045,
  0.00489525, 0.00488944, 0.00488301, 0.00487598, 0.00486832,
  0.00486006, 0.00485119, 0.00484171, 0.00483162, 0.00482092,
  0.00480962, 0.00479771, 0.0047852, 0.00477209, 0.00475837,
  0.00474405, 0.00472914, 0.00471363, 0.00469752, 0.00468082,
  0.00466353, 0.00464565, 0.00462718, 0.00460813, 0.00458849,
  0.00456828, 0.00454748, 0.00452611, 0.00450416, 0.00448165,
  0.00445856, 0.00443491, 0.00441069, 0.00438592, 0.00436058,
  0.0043347, 0.00430826, 0.00428127, 0.00425374, 0.00422566,
  0.00419705, 0.0041679, 0.00413822, 0.00410801, 0.00407728,
  0.00404603, 0.00401426, 0.00398197, 0.00394918, 0.00391588,
  0.00388208, 0.00384778, 0.00381299, 0.00377771, 0.00374195,
  0.0037057, 0.00366898, 0.00363179, 0.00359413, 0.00355601,
  0.00351744, 0.00347841, 0.00343893, 0.00339901, 0.00335865,
  0.00331786, 0.00327664, 0.003235, 0.00319294, 0.00315046,
  0.00310758, 0.0030643, 0.00302063, 0.00297656, 0.0029321,
  0.00288727, 0.00284206, 0.00279649, 0.00275055, 0.00270425,
  0.00265761, 0.00261061, 0.00256328, 0.00251562, 0.00246763,
  0.00241931, 0.00237069, 0.00232175, 0.00227251, 0.00222298,
  0.00217315, 0.00212304, 0.00207266, 0.002022, 0.00197108, 0.0019199,
  0.00186847, 0.0018168, 0.00176488, 0.00171274, 0.00166037,
  0.00160779, 0.00155499, 0.00150199, 0.00144879, 0.0013954,
  0.00134183, 0.00128808, 0.00123416, 0.00118008, 0.00112585,
  0.00107147, 0.00101694, 0.000962281, 0.000907495, 0.000852589,
  0.00079757, 0.000742446, 0.000687224, 0.000631911, 0.000576514,
  0.000521041, 0.000465499, 0.000409895, 0.000354237, 0.000298531,
  0.000242786, 0.000187009, 0.000131207, 7.53878e-05, 1.95583e-05,
  -3.62738e-05, -9.21011e-05, -0.000147916, -0.000203712, -0.00025948,
  -0.000315213, -0.000370905, -0.000426547, -0.000482132,
  -0.000537653, -0.000593102, -0.000648471, -0.000703754,
  -0.000758942, -0.000814029, -0.000869007, -0.000923868,
  -0.000978605, -0.00103321, -0.00108768, -0.001142, -0.00119617,
  -0.00125017, -0.00130401, -0.00135767, -0.00141115, -0.00146444,
  -0.00151753, -0.00157042, -0.0016231, -0.00167555, -0.00172778,
  -0.00177978, -0.00183153, -0.00188304, -0.00193429, -0.00198528,
  -0.002036, -0.00208644, -0.00213661, -0.00218648, -0.00223605,
  -0.00228532, -0.00233428, -0.00238292, -0.00243124, -0.00247923,
  -0.00252687, -0.00257418, -0.00262113, -0.00266773, -0.00271396,
  -0.00275982, -0.0028053, -0.0028504, -0.0028951, -0.00293942,
  -0.00298333, -0.00302683, -0.00306991, -0.00311257, -0.00315481,
  -0.00319661, -0.00323798, -0.0032789, -0.00331936, -0.00335937,
  -0.00339892, -0.003438, -0.0034766, -0.00351473, -0.00355237,
  -0.00358952, -0.00362617, -0.00366232, -0.00369797, -0.0037331,
  -0.00376772, -0.00380181, -0.00383538, -0.00386842, -0.00390091,
  -0.00393287, -0.00396428, -0.00399514, -0.00402544, -0.00405519,
  -0.00408436, -0.00411297, -0.00414101, -0.00416847, -0.00419534,
  -0.00422163, -0.00424733, -0.00427244, -0.00429695, -0.00432086,
  -0.00434416, -0.00436686, -0.00438894, -0.0044104, -0.00443125,
  -0.00445148, -0.00447108, -0.00449005, -0.00450839, -0.00452609,
  -0.00454316, -0.00455959, -0.00457537, -0.00459051, -0.004605,
  -0.00461885, -0.00463203, -0.00464457, -0.00465645, -0.00466766,
  -0.00467822, -0.00468811, -0.00469734, -0.00470591, -0.0047138,
  -0.00472103, -0.00472758, -0.00473346, -0.00473867, -0.00474321,
  -0.00474706, -0.00475025, -0.00475275, -0.00475458, -0.00475573,
  -0.00475619, -0.00475598, -0.00475509, -0.00475352, -0.00475127,
  -0.00474833, -0.00474472, -0.00474043, -0.00473545, -0.0047298,
  -0.00472346, -0.00471645, -0.00470876, -0.00470039, -0.00469134,
  -0.00468162, -0.00467122, -0.00466015, -0.00464841, -0.00463599,
  -0.0046229, -0.00460915, -0.00459473, -0.00457964, -0.00456389,
  -0.00454748, -0.00453041, -0.00451268, -0.00449429, -0.00447526,
  -0.00445557, -0.00443523, -0.00441425, -0.00439262, -0.00437036,
  -0.00434746, -0.00432392, -0.00429975, -0.00427495, -0.00424953,
  -0.00422349, -0.00419683, -0.00416955, -0.00414166, -0.00411317,
  -0.00408407, -0.00405437, -0.00402408, -0.00399319, -0.00396172,
  -0.00392966, -0.00389703, -0.00386382, -0.00383004, -0.0037957,
  -0.0037608, -0.00372534, -0.00368933, -0.00365277, -0.00361567,
  -0.00357804, -0.00353988, -0.00350119, -0.00346198, -0.00342226,
  -0.00338203, -0.0033413, -0.00330007, -0.00325835, -0.00321615,
  -0.00317346, -0.00313031, -0.00308668, -0.00304259, -0.00299805,
  -0.00295306, -0.00290763, -0.00286177, -0.00281547, -0.00276876,
  -0.00272162, -0.00267408, -0.00262614, -0.00257781, -0.00252908,
  -0.00247998, -0.0024305, -0.00238065, -0.00233045, -0.0022799,
  -0.002229, -0.00217776, -0.0021262, -0.00207431, -0.00202211,
  -0.00196961, -0.0019168, -0.0018637, -0.00181033, -0.00175667,
  -0.00170275, -0.00164857, -0.00159414, -0.00153947, -0.00148457,
  -0.00142943, -0.00137408, -0.00131852, -0.00126276, -0.0012068,
  -0.00115066, -0.00109435, -0.00103786, -0.00098122, -0.000924427,
  -0.000867492, -0.000810424, -0.000753231, -0.000695922,
  -0.000638507, -0.000580993, -0.00052339, -0.000465706, -0.00040795,
  -0.000350131, -0.000292259, -0.000234341, -0.000176386,
  -0.000118405, -6.04049e-05, -2.39576e-06, 5.56138e-05, 0.000113615,
  0.000171598, 0.000229554, 0.000287475, 0.000345351, 0.000403173,
  0.000460933, 0.00051862, 0.000576227, 0.000633743, 0.00069116,
  0.00074847, 0.000805662, 0.000862728, 0.000919658, 0.000976445,
  0.00103308, 0.00108955, 0.00114585, 0.00120197, 0.0012579,
  0.00131363, 0.00136915, 0.00142446, 0.00147955, 0.0015344,
  0.00158901, 0.00164336, 0.00169746, 0.00175129, 0.00180484,
  0.0018581, 0.00191107, 0.00196373, 0.00201609, 0.00206812,
  0.00211982, 0.00217119, 0.00222221, 0.00227287, 0.00232317,
  0.00237311, 0.00242266, 0.00247182, 0.00252059, 0.00256895,
  0.00261691, 0.00266444, 0.00271154, 0.00275821, 0.00280444,
  0.00285021, 0.00289553, 0.00294038, 0.00298475, 0.00302864,
  0.00307205, 0.00311495, 0.00315736, 0.00319925, 0.00324062,
  0.00328147, 0.00332179, 0.00336157, 0.0034008, 0.00343948,
  0.0034776, 0.00351515, 0.00355213, 0.00358853, 0.00362434,
  0.00365957, 0.00369419, 0.00372821, 0.00376163, 0.00379442,
  0.00382659, 0.00385814, 0.00388905, 0.00391932, 0.00394895,
  0.00397793, 0.00400626, 0.00403392, 0.00406092, 0.00408725,
  0.0041129, 0.00413788, 0.00416217, 0.00418577, 0.00420867,
  0.00423088, 0.00425239, 0.00427319, 0.00429328, 0.00431266,
  0.00433132, 0.00434926, 0.00436647, 0.00438296, 0.00439871,
  0.00441373, 0.00442801, 0.00444155, 0.00445435, 0.0044664,
  0.0044777, 0.00448824, 0.00449804, 0.00450708, 0.00451536,
  0.00452288, 0.00452964, 0.00453563, 0.00454086, 0.00454532,
  0.00454902, 0.00455194, 0.00455409, 0.00455548, 0.00455609,
  0.00455592, 0.00455498, 0.00455327, 0.00455079, 0.00454752,
  0.00454349, 0.00453868, 0.00453309, 0.00452673, 0.0045196,
  0.00451169, 0.00450301, 0.00449356, 0.00448334, 0.00447235,
  0.00446059, 0.00444807, 0.00443478, 0.00442072, 0.0044059,
  0.00439033, 0.00437399, 0.00435691, 0.00433906, 0.00432047,
  0.00430113, 0.00428104, 0.00426021, 0.00423864, 0.00421633,
  0.00419329, 0.00416953, 0.00414503, 0.00411981, 0.00409388,
  0.00406722, 0.00403986, 0.00401179, 0.00398302, 0.00395355,
  0.00392339, 0.00389254, 0.00386101, 0.00382879, 0.00379591,
  0.00376235, 0.00372813, 0.00369326, 0.00365773, 0.00362155,
  0.00358474, 0.00354729, 0.00350921, 0.00347051, 0.0034312,
  0.00339127, 0.00335075, 0.00330962, 0.00326791, 0.00322562,
  0.00318274, 0.00313931, 0.00309531, 0.00305075, 0.00300565,
  0.00296002, 0.00291385, 0.00286716, 0.00281995, 0.00277224,
  0.00272403, 0.00267532, 0.00262614, 0.00257648, 0.00252636,
  0.00247578, 0.00242475, 0.00237328, 0.00232139, 0.00226907,
  0.00221634, 0.00216321, 0.00210968, 0.00205577, 0.00200149,
  0.00194684, 0.00189184, 0.00183649, 0.0017808, 0.00172479,
  0.00166846, 0.00161183, 0.0015549, 0.00149769, 0.0014402,
  0.00138244, 0.00132443, 0.00126618, 0.00120769, 0.00114898,
  0.00109006, 0.00103094, 0.000971624, 0.000912129, 0.000852465,
  0.000792643, 0.000732674, 0.000672568, 0.000612337, 0.000551992,
  0.000491544, 0.000431004, 0.000370384, 0.000309694, 0.000248947,
  0.000188152, 0.000127323, 6.64691e-05, 5.6031e-06, -5.5264e-05,
  -0.000116121, -0.000176956, -0.000237757, -0.000298514,
  -0.000359214, -0.000419846, -0.000480399, -0.000540861,
  -0.000601221, -0.000661466, -0.000721585, -0.000781568,
  -0.000841401, -0.000901074, -0.000960576, -0.00101989, -0.00107902,
  -0.00113793, -0.00119663, -0.0012551, -0.00131333, -0.00137131,
  -0.00142902, -0.00148646, -0.00154361, -0.00160046, -0.00165701,
  -0.00171323, -0.00176913, -0.00182468, -0.00187988, -0.00193471,
  -0.00198917, -0.00204324, -0.00209691, -0.00215018, -0.00220302,
  -0.00225544, -0.00230742, -0.00235894, -0.00241001, -0.0024606,
  -0.00251071, -0.00256033, -0.00260944, -0.00265804, -0.00270612,
  -0.00275366, -0.00280066, -0.00284711, -0.002893, -0.00293831,
  -0.00298304, -0.00302718, -0.00307072, -0.00311365, -0.00315596,
  -0.00319765, -0.00323869, -0.00327909, -0.00331883, -0.00335792,
  -0.00339633, -0.00343406, -0.0034711, -0.00350744, -0.00354308,
  -0.00357801, -0.00361221, -0.00364569, -0.00367844, -0.00371044,
  -0.00374169, -0.00377218, -0.00380191, -0.00383087, -0.00385905,
  -0.00388645, -0.00391306, -0.00393887, -0.00396387, -0.00398807,
  -0.00401145, -0.00403402, -0.00405575, -0.00407666, -0.00409673,
  -0.00411596, -0.00413434, -0.00415187, -0.00416855, -0.00418436,
  -0.00419931, -0.0042134, -0.00422661, -0.00423895, -0.0042504,
  -0.00426098, -0.00427067, -0.00427947, -0.00428738, -0.0042944,
  -0.00430052, -0.00430574, -0.00431006, -0.00431348, -0.00431599,
  -0.0043176, -0.0043183, -0.00431809, -0.00431697, -0.00431495,
  -0.00431201, -0.00430816, -0.0043034, -0.00429773, -0.00429115,
  -0.00428365, -0.00427525, -0.00426594, -0.00425572, -0.00424459,
  -0.00423256, -0.00421962, -0.00420578, -0.00419104, -0.0041754,
  -0.00415887, -0.00414144, -0.00412312, -0.00410391, -0.00408382,
  -0.00406284, -0.00404099, -0.00401826, -0.00399467, -0.0039702,
  -0.00394488, -0.0039187, -0.00389166, -0.00386378, -0.00383505,
  -0.00380549, -0.00377509, -0.00374387, -0.00371183, -0.00367898,
  -0.00364531, -0.00361085, -0.00357559, -0.00353954, -0.00350271,
  -0.0034651, -0.00342673, -0.00338761, -0.00334773, -0.0033071,
  -0.00326574, -0.00322366, -0.00318086, -0.00313734, -0.00309313,
  -0.00304823, -0.00300264, -0.00295638, -0.00290945, -0.00286188,
  -0.00281366, -0.0027648, -0.00271532, -0.00266523, -0.00261454,
  -0.00256325, -0.00251139, -0.00245895, -0.00240596, -0.00235241,
  -0.00229834, -0.00224374, -0.00218862, -0.00213301, -0.00207691,
  -0.00202033, -0.00196329, -0.00190579, -0.00184786, -0.00178951,
  -0.00173074, -0.00167157, -0.00161202, -0.00155209, -0.0014918,
  -0.00143117, -0.0013702, -0.00130892, -0.00124733, -0.00118545,
  -0.00112329, -0.00106087, -0.0009982, -0.000935298, -0.000872177,
  -0.00080885, -0.000745333, -0.00068164, -0.000617787, -0.000553788,
  -0.000489658, -0.000425412, -0.000361065, -0.000296632,
  -0.000232129, -0.00016757, -0.000102972, -3.83491e-05, 2.62829e-05,
  9.09086e-05, 0.000155513, 0.000220079, 0.000284593, 0.000349038,
  0.000413399, 0.00047766, 0.000541806, 0.00060582, 0.000669688,
  0.000733394, 0.000796921, 0.000860254, 0.000923378, 0.000986277,
  0.00104893, 0.00111134, 0.00117346, 0.00123531, 0.00129684,
  0.00135806, 0.00141895, 0.00147948, 0.00153965, 0.00159944,
  0.00165883, 0.00171781, 0.00177637, 0.00183448, 0.00189214,
  0.00194932, 0.00200602, 0.00206222, 0.0021179, 0.00217305,
  0.00222765, 0.00228169, 0.00233516, 0.00238804, 0.00244032,
  0.00249198, 0.00254301, 0.0025934, 0.00264312, 0.00269218,
  0.00274055, 0.00278822, 0.00283517, 0.00288141, 0.0029269,
  0.00297164, 0.00301562, 0.00305883, 0.00310125, 0.00314286,
  0.00318367, 0.00322365, 0.00326279, 0.00330109, 0.00333853,
  0.00337511, 0.0034108, 0.0034456, 0.0034795, 0.00351249, 0.00354456,
  0.0035757, 0.0036059, 0.00363515, 0.00366344, 0.00369076, 0.0037171,
  0.00374247, 0.00376683, 0.0037902, 0.00381256, 0.0038339,
  0.00385422, 0.0038735, 0.00389175, 0.00390896, 0.00392512,
  0.00394022, 0.00395426, 0.00396723, 0.00397913, 0.00398995,
  0.00399969, 0.00400834, 0.00401591, 0.00402238, 0.00402775,
  0.00403203, 0.00403519, 0.00403726, 0.00403821, 0.00403806,
  0.00403679, 0.00403441, 0.00403091, 0.0040263, 0.00402057,
  0.00401373, 0.00400577, 0.0039967, 0.00398651, 0.0039752,
  0.00396279, 0.00394926, 0.00393462, 0.00391888, 0.00390203,
  0.00388409, 0.00386504, 0.0038449, 0.00382368, 0.00380136,
  0.00377797, 0.00375349, 0.00372795, 0.00370134, 0.00367367,
  0.00364495, 0.00361518, 0.00358437, 0.00355252, 0.00351965,
  0.00348577, 0.00345087, 0.00341497, 0.00337808, 0.0033402,
  0.00330135, 0.00326154, 0.00322077, 0.00317905, 0.0031364,
  0.00309283, 0.00304835, 0.00300297, 0.0029567, 0.00290955,
  0.00286154, 0.00281268, 0.00276299, 0.00271246, 0.00266113,
  0.002609, 0.00255609, 0.00250241, 0.00244797, 0.0023928, 0.00233691,
  0.00228031, 0.00222302, 0.00216505, 0.00210642, 0.00204715,
  0.00198726, 0.00192676, 0.00186567, 0.001804, 0.00174178,
  0.00167903, 0.00161575, 0.00155198, 0.00148773, 0.00142301,
  0.00135785, 0.00129227, 0.00122629, 0.00115992, 0.00109319,
  0.00102611, 0.000958713, 0.000891014, 0.000823033, 0.000754792,
  0.000686312, 0.000617614, 0.00054872, 0.000479651, 0.000410429,
  0.000341075, 0.000271612, 0.000202062, 0.000132447, 6.27889e-05,
  -6.88928e-06, -7.65653e-05, -0.000146216, -0.00021582, -0.000285354,
  -0.000354794, -0.000424119, -0.000493305, -0.000562329,
  -0.000631169, -0.0006998, -0.000768201, -0.000836348, -0.000904218,
  -0.000971788, -0.00103903, -0.00110594, -0.00117247, -0.00123861,
  -0.00130433, -0.00136962, -0.00143444, -0.00149878, -0.00156262,
  -0.00162592, -0.00168868, -0.00175086, -0.00181244, -0.0018734,
  -0.00193373, -0.00199339, -0.00205236, -0.00211063, -0.00216817,
  -0.00222496, -0.00228098, -0.00233621, -0.00239063, -0.00244421,
  -0.00249694, -0.00254879, -0.00259975, -0.0026498, -0.00269891,
  -0.00274707, -0.00279425, -0.00284045, -0.00288564, -0.00292979,
  -0.00297291, -0.00301495, -0.00305592, -0.00309579, -0.00313455,
  -0.00317217, -0.00320865, -0.00324396, -0.00327809, -0.00331103,
  -0.00334276, -0.00337327, -0.00340255, -0.00343057, -0.00345733,
  -0.00348281, -0.00350701, -0.0035299, -0.00355148, -0.00357174,
  -0.00359067, -0.00360825, -0.00362448, -0.00363935, -0.00365285,
  -0.00366497, -0.0036757, -0.00368503, -0.00369296, -0.00369949,
  -0.0037046, -0.0037083, -0.00371056, -0.00371141, -0.00371082,
  -0.00370879, -0.00370533, -0.00370043, -0.00369408, -0.0036863,
  -0.00367707, -0.0036664, -0.00365429, -0.00364074, -0.00362574,
  -0.00360932, -0.00359145, -0.00357216, -0.00355145, -0.00352931,
  -0.00350575, -0.00348079, -0.00345442, -0.00342666, -0.00339751,
  -0.00336698, -0.00333508, -0.00330181, -0.0032672, -0.00323124,
  -0.00319396, -0.00315536, -0.00311545, -0.00307425, -0.00303177,
  -0.00298803, -0.00294305, -0.00289682, -0.00284939, -0.00280075,
  -0.00275093, -0.00269994, -0.00264781, -0.00259455, -0.00254018,
  -0.00248473, -0.00242821, -0.00237065, -0.00231206, -0.00225247,
  -0.00219191, -0.00213039, -0.00206794, -0.00200459, -0.00194036,
  -0.00187528, -0.00180937, -0.00174266, -0.00167517, -0.00160695,
  -0.001538, -0.00146837, -0.00139808, -0.00132716, -0.00125564,
  -0.00118355, -0.00111093, -0.0010378, -0.000964193, -0.000890149,
  -0.000815696, -0.000740868, -0.000665698, -0.00059022, -0.000514468,
  -0.000438476, -0.00036228, -0.000285914, -0.000209413, -0.000132814,
  -5.61527e-05, 2.05356e-05, 9.7214e-05, 0.000173846, 0.000250395,
  0.000326823, 0.000403094, 0.00047917, 0.000555014, 0.000630589,
  0.000705855, 0.000780777, 0.000855315, 0.000929433, 0.00100309,
  0.00107625, 0.00114888, 0.00122093, 0.00129238, 0.00136317,
  0.00143328, 0.00150267, 0.00157129, 0.00163912, 0.00170611,
  0.00177223, 0.00183743, 0.0019017, 0.00196497, 0.00202724,
  0.00208844, 0.00214856, 0.00220755, 0.00226538, 0.00232202,
  0.00237743, 0.00243158, 0.00248443, 0.00253595, 0.00258612,
  0.00263489, 0.00268224, 0.00272814, 0.00277255, 0.00281545,
  0.0028568, 0.00289659, 0.00293478, 0.00297135, 0.00300626,
  0.0030395, 0.00307103, 0.00310084, 0.00312891, 0.0031552, 0.0031797,
  0.00320239, 0.00322325, 0.00324225, 0.00325939, 0.00327464,
  0.00328799, 0.00329942, 0.00330892, 0.00331648, 0.00332208,
  0.00332572, 0.00332738, 0.00332705, 0.00332473, 0.00332041,
  0.00331409, 0.00330575, 0.00329541, 0.00328305, 0.00326868,
  0.0032523, 0.00323391, 0.0032135, 0.0031911, 0.00316669, 0.0031403,
  0.00311192, 0.00308157, 0.00304926, 0.003015, 0.00297881,
  0.00294069, 0.00290068, 0.00285877, 0.002815, 0.00276939,
  0.00272195, 0.00267271, 0.00262169, 0.00256892, 0.00251444,
  0.00245826, 0.00240042, 0.00234094, 0.00227987, 0.00221724,
  0.00215308, 0.00208743, 0.00202033, 0.00195182, 0.00188195,
  0.00181074, 0.00173826, 0.00166453, 0.00158962, 0.00151357,
  0.00143642, 0.00135823, 0.00127906, 0.00119894, 0.00111795,
  0.00103613, 0.000953537, 0.000870234, 0.000786277, 0.000701728,
  0.000616647, 0.000531097, 0.000445139, 0.000358839, 0.000272262,
  0.000185472, 9.85378e-05, 1.1526e-05, -7.54951e-05, -0.000162456,
  -0.000249288, -0.000335919, -0.000422279, -0.000508297, -0.0005939,
  -0.000679016, -0.000763572, -0.000847495, -0.000930711, -0.00101315,
  -0.00109473, -0.00117538, -0.00125503, -0.0013336, -0.00141102,
  -0.00148722, -0.00156212, -0.00163564, -0.00170772, -0.00177828,
  -0.00184725, -0.00191456, -0.00198014, -0.00204391, -0.00210581,
  -0.00216577, -0.00222372, -0.00227959, -0.00233332, -0.00238485,
  -0.0024341, -0.00248102, -0.00252555, -0.00256763, -0.00260719,
  -0.0026442, -0.00267858, -0.0027103, -0.0027393, -0.00276552,
  -0.00278894, -0.00280949, -0.00282715, -0.00284187, -0.00285362,
  -0.00286235, -0.00286805, -0.00287068, -0.00287022, -0.00286665,
  -0.00285994, -0.00285008, -0.00283706, -0.00282086, -0.00280149,
  -0.00277894, -0.0027532, -0.00272429, -0.00269221, -0.00265697,
  -0.0026186, -0.00257711, -0.00253252, -0.00248487, -0.00243418,
  -0.00238049, -0.00232385, -0.0022643, -0.00220189, -0.00213667,
  -0.0020687, -0.00199805, -0.00192479, -0.00184899, -0.00177072,
  -0.00169006, -0.00160712, -0.00152197, -0.00143472, -0.00134546,
  -0.0012543, -0.00116136, -0.00106675, -0.00097059, -0.000873005,
  -0.000774126, -0.000674087, -0.000573029, -0.000471094,
  -0.000368432, -0.000265194, -0.000161538, -5.7624e-05, 4.63824e-05,
  0.000150312, 0.000253994, 0.00035725, 0.000459901, 0.000561765,
  0.000662656, 0.000762385, 0.00086076, 0.000957589, 0.00105268,
  0.00114582, 0.00123683, 0.0013255, 0.00141162, 0.00149501,
  0.00157545, 0.00165275, 0.0017267, 0.0017971, 0.00186376,
  0.00192648, 0.00198507, 0.00203933, 0.00208909, 0.00213415,
  0.00217433, 0.00220948, 0.00223942, 0.00226398, 0.00228303,
  0.00229642, 0.00230401, 0.00230568, 0.00230131, 0.00229082,
  0.00227409, 0.00225108, 0.0022217, 0.00218593, 0.00214372,
  0.00209508, 0.00204002, 0.00197856, 0.00191075, 0.00183669,
  0.00175645, 0.00167018, 0.00157802, 0.00148017, 0.00137682,
  0.00126824, 0.00115469, 0.0010365, 0.000914021, 0.000787643,
  0.000657804, 0.000524981, 0.000389699, 0.00025253, 0.000114095,
  -2.49302e-05, -0.000163817, -0.000301778, -0.000437967,
  -0.000571475, -0.000701328, -0.000826483, -0.000945829, -0.00105818,
  -0.00116226, -0.00125674, -0.00134019, -0.0014111, -0.00146785,
  -0.00150875, -0.00153201, -0.00153572, -0.00151789, -0.00147641,
  -0.00140905, -0.00131347, -0.0011872, -0.00102766, -0.000832121,
  -0.00059773, -0.000321488, -2.51435e-07}; const G4double
  G4NeutronHPFastLegendre::l29[6001] = {-1, -0.860161, -0.730317,
  -0.609992, -0.498724, -0.396072, -0.301606, -0.214915, -0.135603,
  -0.0632874, 0.00239972, 0.0618121, 0.11529, 0.163161, 0.20574,
  0.243329, 0.276219, 0.304689, 0.329006, 0.349427, 0.366198,
  0.379556, 0.389727, 0.396927, 0.401364, 0.403236, 0.402732,
  0.400035, 0.395317, 0.388743, 0.38047, 0.37065, 0.359425, 0.346932,
  0.333299, 0.31865, 0.303103, 0.286767, 0.269748, 0.252147, 0.234056,
  0.215565, 0.196758, 0.177715, 0.158509, 0.139211, 0.119887,
  0.100599, 0.0814039, 0.0623559, 0.0435053, 0.0248988, 0.0065796,
  -0.0114121, -0.0290395, -0.0462684, -0.0630679, -0.0794096,
  -0.0952678, -0.110619, -0.125443, -0.139721, -0.153436, -0.166574,
  -0.179123, -0.191073, -0.202415, -0.213142, -0.223249, -0.232732,
  -0.24159, -0.24982, -0.257424, -0.264403, -0.270761, -0.276501,
  -0.281628, -0.286148, -0.290068, -0.293396, -0.296141, -0.298311,
  -0.299918, -0.30097, -0.301481, -0.30146, -0.300921, -0.299877,
  -0.29834, -0.296324, -0.293844, -0.290912, -0.287543, -0.283753,
  -0.279556, -0.274966, -0.27, -0.264672, -0.258997, -0.252992,
  -0.246671, -0.24005, -0.233145, -0.22597, -0.218541, -0.210873,
  -0.202982, -0.194882, -0.186589, -0.178116, -0.169479, -0.160693,
  -0.151771, -0.142727, -0.133576, -0.12433, -0.115004, -0.10561,
  -0.0961622, -0.0866721, -0.0771525, -0.0676156, -0.0580731,
  -0.0485368, -0.0390179, -0.0295274, -0.0200761, -0.0106744,
  -0.00133242, 0.00793998, 0.0171333, 0.0262382, 0.0352459, 0.0441477,
  0.0529353, 0.0616007, 0.0701362, 0.0785344, 0.0867882, 0.0948908,
  0.102836, 0.110617, 0.118228, 0.125664, 0.132919, 0.139989,
  0.146869, 0.153553, 0.160039, 0.166322, 0.172398, 0.178265,
  0.183919, 0.189358, 0.194578, 0.199578, 0.204356, 0.20891, 0.213238,
  0.217339, 0.221212, 0.224857, 0.228272, 0.231457, 0.234412,
  0.237138, 0.239633, 0.2419, 0.243938, 0.245748, 0.247332, 0.24869,
  0.249824, 0.250735, 0.251426, 0.251897, 0.252152, 0.252192,
  0.252019, 0.251636, 0.251046, 0.250251, 0.249254, 0.248058,
  0.246666, 0.245082, 0.243308, 0.241348, 0.239206, 0.236884,
  0.234388, 0.231719, 0.228883, 0.225884, 0.222724, 0.219408,
  0.215941, 0.212326, 0.208567, 0.204669, 0.200636, 0.196473,
  0.192183, 0.187771, 0.183241, 0.178599, 0.173847, 0.168992,
  0.164037, 0.158986, 0.153845, 0.148617, 0.143308, 0.137921,
  0.132462, 0.126934, 0.121342, 0.115691, 0.109985, 0.104228,
  0.0984249, 0.09258, 0.0866975, 0.0807818, 0.0748371, 0.0688677,
  0.0628777, 0.0568712, 0.0508525, 0.0448255, 0.0387942, 0.0327628,
  0.026735, 0.0207147, 0.0147058, 0.00871196, 0.00273699, -0.00321549,
  -0.0091419, -0.0150387, -0.0209024, -0.0267296, -0.032517,
  -0.0382613, -0.0439592, -0.0496076, -0.0552035, -0.0607437,
  -0.0662255, -0.0716458, -0.0770018, -0.0822909, -0.0875104,
  -0.0926577, -0.0977302, -0.102726, -0.107641, -0.112475, -0.117225,
  -0.121888, -0.126464, -0.130948, -0.135341, -0.139639, -0.143842,
  -0.147947, -0.151952, -0.155857, -0.159659, -0.163358, -0.166951,
  -0.170438, -0.173818, -0.177089, -0.18025, -0.1833, -0.186239,
  -0.189065, -0.191778, -0.194377, -0.196861, -0.19923, -0.201484,
  -0.203621, -0.205642, -0.207546, -0.209333, -0.211003, -0.212556,
  -0.213991, -0.215309, -0.21651, -0.217594, -0.218561, -0.219411,
  -0.220145, -0.220762, -0.221265, -0.221652, -0.221925, -0.222083,
  -0.222129, -0.222062, -0.221882, -0.221592, -0.221192, -0.220682,
  -0.220064, -0.219338, -0.218506, -0.217568, -0.216527, -0.215382,
  -0.214135, -0.212787, -0.21134, -0.209795, -0.208152, -0.206415,
  -0.204583, -0.202659, -0.200643, -0.198538, -0.196344, -0.194064,
  -0.191699, -0.18925, -0.18672, -0.184109, -0.18142, -0.178655,
  -0.175814, -0.172899, -0.169914, -0.166858, -0.163734, -0.160545,
  -0.157291, -0.153974, -0.150597, -0.14716, -0.143667, -0.140119,
  -0.136518, -0.132865, -0.129163, -0.125413, -0.121618, -0.11778,
  -0.1139, -0.109979, -0.106022, -0.102028, -0.098, -0.0939402,
  -0.0898503, -0.0857323, -0.081588, -0.0774193, -0.0732283,
  -0.0690167, -0.0647866, -0.0605397, -0.0562781, -0.0520035,
  -0.0477178, -0.043423, -0.0391208, -0.0348132, -0.0305018,
  -0.0261886, -0.0218754, -0.0175639, -0.013256, -0.00895327,
  -0.00465761, -0.000370714, 0.00390571, 0.00816997, 0.0124204,
  0.0166553, 0.020873, 0.025072, 0.0292506, 0.0334072, 0.0375403,
  0.0416483, 0.0457297, 0.049783, 0.0538067, 0.0577994, 0.0617596,
  0.065686, 0.0695771, 0.0734315, 0.077248, 0.0810252, 0.0847618,
  0.0884565, 0.0921082, 0.0957156, 0.0992774, 0.102793, 0.10626,
  0.109679, 0.113047, 0.116364, 0.11963, 0.122842, 0.126, 0.129103,
  0.132151, 0.135141, 0.138074, 0.140948, 0.143762, 0.146517, 0.14921,
  0.151842, 0.154412, 0.156918, 0.159361, 0.161739, 0.164053,
  0.166301, 0.168483, 0.170599, 0.172647, 0.174628, 0.176541,
  0.178386, 0.180162, 0.181869, 0.183507, 0.185075, 0.186573,
  0.188001, 0.189359, 0.190646, 0.191862, 0.193008, 0.194083,
  0.195086, 0.196019, 0.19688, 0.19767, 0.198389, 0.199037, 0.199614,
  0.20012, 0.200555, 0.20092, 0.201214, 0.201437, 0.201591, 0.201675,
  0.201689, 0.201633, 0.201509, 0.201316, 0.201054, 0.200725,
  0.200327, 0.199863, 0.199331, 0.198734, 0.19807, 0.197341, 0.196547,
  0.195688, 0.194766, 0.19378, 0.192731, 0.191621, 0.190448, 0.189215,
  0.187922, 0.186568, 0.185156, 0.183686, 0.182158, 0.180573,
  0.178932, 0.177236, 0.175485, 0.173681, 0.171823, 0.169913,
  0.167951, 0.165939, 0.163877, 0.161767, 0.159608, 0.157402, 0.15515,
  0.152852, 0.150509, 0.148124, 0.145695, 0.143224, 0.140713,
  0.138162, 0.135572, 0.132944, 0.130278, 0.127577, 0.124841, 0.12207,
  0.119267, 0.116431, 0.113564, 0.110667, 0.10774, 0.104786, 0.101804,
  0.0987964, 0.0957636, 0.0927067, 0.0896266, 0.0865246, 0.0834015,
  0.0802583, 0.0770962, 0.0739162, 0.0707192, 0.0675063, 0.0642785,
  0.0610368, 0.0577823, 0.054516, 0.0512389, 0.047952, 0.0446563,
  0.0413529, 0.0380427, 0.0347268, 0.0314061, 0.0280817, 0.0247546,
  0.0214257, 0.0180961, 0.0147666, 0.0114384, 0.00811229, 0.00478934,
  0.00147048, -0.00184333, -0.00515115, -0.00845203, -0.011745,
  -0.0150292, -0.0183037, -0.0215676, -0.0248199, -0.0280597,
  -0.0312863, -0.0344986, -0.0376958, -0.0408771, -0.0440415,
  -0.0471883, -0.0503166, -0.0534256, -0.0565144, -0.0595822,
  -0.0626283, -0.0656518, -0.068652, -0.071628, -0.0745793,
  -0.0775048, -0.0804041, -0.0832762, -0.0861205, -0.0889364,
  -0.091723, -0.0944797, -0.0972059, -0.0999008, -0.102564, -0.105194,
  -0.107792, -0.110356, -0.112885, -0.115379, -0.117838, -0.120261,
  -0.122647, -0.124996, -0.127307, -0.12958, -0.131815, -0.13401,
  -0.136165, -0.13828, -0.140355, -0.142389, -0.144381, -0.146331,
  -0.148239, -0.150104, -0.151927, -0.153706, -0.155441, -0.157132,
  -0.158779, -0.160381, -0.161938, -0.163449, -0.164915, -0.166336,
  -0.16771, -0.169038, -0.17032, -0.171555, -0.172743, -0.173883,
  -0.174977, -0.176024, -0.177022, -0.177974, -0.178877, -0.179733,
  -0.18054, -0.1813, -0.182012, -0.182675, -0.183291, -0.183858,
  -0.184377, -0.184848, -0.18527, -0.185645, -0.185971, -0.18625,
  -0.18648, -0.186663, -0.186798, -0.186885, -0.186924, -0.186916,
  -0.18686, -0.186758, -0.186608, -0.186411, -0.186168, -0.185878,
  -0.185542, -0.18516, -0.184731, -0.184257, -0.183738, -0.183174,
  -0.182564, -0.18191, -0.181212, -0.180469, -0.179683, -0.178853,
  -0.177981, -0.177065, -0.176107, -0.175107, -0.174065, -0.172981,
  -0.171857, -0.170692, -0.169487, -0.168242, -0.166957, -0.165633,
  -0.164271, -0.162871, -0.161433, -0.159958, -0.158445, -0.156897,
  -0.155312, -0.153693, -0.152038, -0.150348, -0.148625, -0.146868,
  -0.145079, -0.143257, -0.141403, -0.139517, -0.137601, -0.135654,
  -0.133678, -0.131672, -0.129637, -0.127575, -0.125484, -0.123367,
  -0.121223, -0.119053, -0.116858, -0.114639, -0.112395, -0.110127,
  -0.107837, -0.105524, -0.103189, -0.100833, -0.0984562, -0.0960596,
  -0.0936436, -0.0912088, -0.0887558, -0.0862852, -0.0837976,
  -0.0812937, -0.0787741, -0.0762394, -0.0736901, -0.071127,
  -0.0685507, -0.0659617, -0.0633607, -0.0607483, -0.0581251,
  -0.0554918, -0.052849, -0.0501974, -0.0475374, -0.0448698,
  -0.0421952, -0.0395141, -0.0368273, -0.0341353, -0.0314388,
  -0.0287384, -0.0260347, -0.0233282, -0.0206197, -0.0179098,
  -0.015199, -0.0124879, -0.00977718, -0.00706744, -0.00435926,
  -0.00165325, 0.00105, 0.00374989, 0.00644583, 0.00913724, 0.0118235,
  0.0145041, 0.0171784, 0.0198459, 0.0225059, 0.0251579, 0.0278014,
  0.0304357, 0.0330604, 0.0356748, 0.0382784, 0.0408707, 0.0434512,
  0.0460192, 0.0485743, 0.051116, 0.0536437, 0.0561568, 0.058655,
  0.0611376, 0.0636042, 0.0660543, 0.0684873, 0.0709029, 0.0733005,
  0.0756796, 0.0780398, 0.0803806, 0.0827016, 0.0850022, 0.0872821,
  0.0895408, 0.0917778, 0.0939928, 0.0961853, 0.0983549, 0.100501,
  0.102624, 0.104722, 0.106796, 0.108845, 0.110869, 0.112867,
  0.114839, 0.116785, 0.118704, 0.120596, 0.12246, 0.124297, 0.126106,
  0.127886, 0.129637, 0.13136, 0.133053, 0.134717, 0.136351, 0.137954,
  0.139527, 0.14107, 0.142581, 0.144062, 0.145511, 0.146928, 0.148313,
  0.149666, 0.150987, 0.152275, 0.153531, 0.154754, 0.155943,
  0.157099, 0.158222, 0.159311, 0.160367, 0.161388, 0.162376,
  0.163329, 0.164248, 0.165133, 0.165983, 0.166798, 0.167579,
  0.168325, 0.169036, 0.169712, 0.170353, 0.170958, 0.171529,
  0.172065, 0.172565, 0.17303, 0.17346, 0.173854, 0.174213, 0.174537,
  0.174826, 0.175079, 0.175297, 0.175479, 0.175627, 0.175739,
  0.175816, 0.175859, 0.175866, 0.175838, 0.175775, 0.175678,
  0.175546, 0.175379, 0.175178, 0.174942, 0.174672, 0.174368, 0.17403,
  0.173658, 0.173252, 0.172812, 0.172339, 0.171833, 0.171294,
  0.170721, 0.170116, 0.169478, 0.168808, 0.168105, 0.167371,
  0.166604, 0.165806, 0.164977, 0.164116, 0.163225, 0.162302,
  0.161349, 0.160366, 0.159353, 0.15831, 0.157237, 0.156135, 0.155005,
  0.153845, 0.152657, 0.151441, 0.150197, 0.148926, 0.147627,
  0.146301, 0.144948, 0.143569, 0.142164, 0.140733, 0.139277,
  0.137796, 0.13629, 0.134759, 0.133204, 0.131626, 0.130024, 0.128399,
  0.126751, 0.125081, 0.123388, 0.121674, 0.119939, 0.118183,
  0.116406, 0.114608, 0.112791, 0.110955, 0.109099, 0.107225,
  0.105332, 0.103422, 0.101493, 0.0995481, 0.0975859, 0.0956073,
  0.0936127, 0.0916025, 0.0895771, 0.0875369, 0.0854823, 0.0834137,
  0.0813315, 0.0792361, 0.0771279, 0.0750074, 0.0728749, 0.0707309,
  0.0685758, 0.0664099, 0.0642338, 0.0620477, 0.0598522, 0.0576477,
  0.0554345, 0.0532131, 0.0509839, 0.0487474, 0.0465038, 0.0442538,
  0.0419976, 0.0397357, 0.0374686, 0.0351966, 0.0329201, 0.0306397,
  0.0283556, 0.0260684, 0.0237783, 0.021486, 0.0191917, 0.0168959,
  0.014599, 0.0123014, 0.0100035, 0.00770574, 0.00540855, 0.00311232,
  0.000817452, -0.00147564, -0.00376654, -0.00605486, -0.0083402,
  -0.0106221, -0.0129003, -0.0151742, -0.0174436, -0.019708,
  -0.021967, -0.0242203, -0.0264674, -0.0287079, -0.0309416,
  -0.0331679, -0.0353865, -0.0375971, -0.0397992, -0.0419925,
  -0.0441766, -0.0463511, -0.0485157, -0.0506701, -0.0528138,
  -0.0549465, -0.0570678, -0.0591774, -0.0612749, -0.06336,
  -0.0654324, -0.0674917, -0.0695376, -0.0715696, -0.0735876,
  -0.0755912, -0.07758, -0.0795537, -0.0815121, -0.0834548,
  -0.0853814, -0.0872917, -0.0891854, -0.0910622, -0.0929217,
  -0.0947637, -0.0965879, -0.0983941, -0.100182, -0.101951, -0.103701,
  -0.105432, -0.107144, -0.108835, -0.110507, -0.112159, -0.11379,
  -0.1154, -0.11699, -0.118558, -0.120104, -0.121629, -0.123133,
  -0.124614, -0.126072, -0.127508, -0.128922, -0.130312, -0.131679,
  -0.133023, -0.134343, -0.13564, -0.136912, -0.138161, -0.139385,
  -0.140585, -0.14176, -0.14291, -0.144036, -0.145136, -0.146211,
  -0.147261, -0.148285, -0.149284, -0.150257, -0.151203, -0.152124,
  -0.153019, -0.153888, -0.15473, -0.155546, -0.156335, -0.157098,
  -0.157834, -0.158543, -0.159225, -0.15988, -0.160509, -0.16111,
  -0.161684, -0.162231, -0.16275, -0.163243, -0.163708, -0.164145,
  -0.164556, -0.164938, -0.165294, -0.165622, -0.165922, -0.166195,
  -0.16644, -0.166658, -0.166848, -0.167011, -0.167147, -0.167255,
  -0.167335, -0.167389, -0.167414, -0.167413, -0.167384, -0.167328,
  -0.167244, -0.167134, -0.166996, -0.166832, -0.16664, -0.166422,
  -0.166176, -0.165904, -0.165605, -0.16528, -0.164928, -0.16455,
  -0.164145, -0.163715, -0.163258, -0.162775, -0.162266, -0.161732,
  -0.161172, -0.160586, -0.159975, -0.159339, -0.158678, -0.157992,
  -0.15728, -0.156545, -0.155784, -0.155, -0.154191, -0.153358,
  -0.152501, -0.151621, -0.150717, -0.149789, -0.148839, -0.147865,
  -0.146869, -0.14585, -0.144809, -0.143745, -0.142659, -0.141552,
  -0.140423, -0.139272, -0.1381, -0.136907, -0.135694, -0.13446,
  -0.133205, -0.13193, -0.130636, -0.129322, -0.127988, -0.126635,
  -0.125264, -0.123873, -0.122464, -0.121037, -0.119592, -0.118129,
  -0.116649, -0.115151, -0.113636, -0.112105, -0.110557, -0.108993,
  -0.107413, -0.105818, -0.104207, -0.102581, -0.10094, -0.0992846,
  -0.0976148, -0.095931, -0.0942334, -0.0925224, -0.0907981,
  -0.089061, -0.0873113, -0.0855492, -0.083775, -0.0819892,
  -0.0801918, -0.0783833, -0.0765638, -0.0747338, -0.0728935,
  -0.0710432, -0.0691832, -0.0673138, -0.0654352, -0.0635479,
  -0.061652, -0.0597479, -0.0578359, -0.0559163, -0.0539893,
  -0.0520554, -0.0501148, -0.0481677, -0.0462146, -0.0442557,
  -0.0422913, -0.0403217, -0.0383472, -0.0363681, -0.0343848,
  -0.0323975, -0.0304066, -0.0284123, -0.0264149, -0.0244148,
  -0.0224123, -0.0204077, -0.0184012, -0.0163932, -0.0143839,
  -0.0123738, -0.010363, -0.00835194, -0.00634085, -0.00433006,
  -0.00231986, -0.000310557, 0.00169756, 0.00370418, 0.00570901,
  0.00771175, 0.00971212, 0.0117098, 0.0137045, 0.015696, 0.0176838,
  0.0196679, 0.0216478, 0.0236232, 0.025594, 0.0275597, 0.0295202,
  0.031475, 0.0334241, 0.0353669, 0.0373034, 0.0392332, 0.041156,
  0.0430715, 0.0449795, 0.0468797, 0.0487719, 0.0506557, 0.0525309,
  0.0543972, 0.0562544, 0.0581022, 0.0599404, 0.0617686, 0.0635867,
  0.0653943, 0.0671912, 0.0689773, 0.0707521, 0.0725155, 0.0742673,
  0.0760071, 0.0777348, 0.0794501, 0.0811528, 0.0828426, 0.0845194,
  0.0861828, 0.0878327, 0.0894688, 0.0910909, 0.0926988, 0.0942922,
  0.0958711, 0.097435, 0.098984, 0.100518, 0.102036, 0.103538,
  0.105025, 0.106495, 0.10795, 0.109388, 0.110809, 0.112213, 0.1136,
  0.114971, 0.116323, 0.117659, 0.118976, 0.120276, 0.121557,
  0.122821, 0.124065, 0.125292, 0.1265, 0.127689, 0.128858, 0.130009,
  0.131141, 0.132253, 0.133345, 0.134418, 0.135471, 0.136504,
  0.137517, 0.13851, 0.139482, 0.140434, 0.141366, 0.142277, 0.143167,
  0.144036, 0.144884, 0.145711, 0.146517, 0.147302, 0.148066,
  0.148808, 0.149528, 0.150227, 0.150904, 0.15156, 0.152194, 0.152806,
  0.153396, 0.153964, 0.15451, 0.155034, 0.155535, 0.156015, 0.156472,
  0.156908, 0.15732, 0.157711, 0.158079, 0.158425, 0.158748, 0.159049,
  0.159327, 0.159583, 0.159816, 0.160027, 0.160216, 0.160382,
  0.160525, 0.160646, 0.160745, 0.160821, 0.160874, 0.160905,
  0.160914, 0.1609, 0.160864, 0.160805, 0.160725, 0.160621, 0.160496,
  0.160349, 0.160179, 0.159987, 0.159773, 0.159537, 0.159279,
  0.158999, 0.158698, 0.158374, 0.158029, 0.157663, 0.157274,
  0.156865, 0.156433, 0.155981, 0.155507, 0.155012, 0.154496,
  0.153959, 0.153402, 0.152823, 0.152224, 0.151604, 0.150964,
  0.150303, 0.149622, 0.148921, 0.1482, 0.147459, 0.146698, 0.145918,
  0.145118, 0.144298, 0.14346, 0.142602, 0.141725, 0.14083, 0.139915,
  0.138982, 0.138031, 0.137061, 0.136074, 0.135068, 0.134044,
  0.133003, 0.131944, 0.130868, 0.129775, 0.128664, 0.127537,
  0.126393, 0.125233, 0.124056, 0.122863, 0.121654, 0.12043, 0.119189,
  0.117934, 0.116663, 0.115376, 0.114075, 0.11276, 0.111429, 0.110085,
  0.108726, 0.107353, 0.105967, 0.104567, 0.103154, 0.101727,
  0.100288, 0.0988361, 0.0973715, 0.0958946, 0.0944057, 0.0929048,
  0.0913922, 0.0898682, 0.088333, 0.0867867, 0.0852295, 0.0836618,
  0.0820837, 0.0804954, 0.0788972, 0.0772892, 0.0756718, 0.074045,
  0.0724093, 0.0707646, 0.0691114, 0.0674498, 0.0657801, 0.0641024,
  0.0624171, 0.0607242, 0.0590242, 0.0573171, 0.0556033, 0.053883,
  0.0521563, 0.0504236, 0.048685, 0.0469409, 0.0451913, 0.0434367,
  0.0416771, 0.0399129, 0.0381443, 0.0363714, 0.0345946, 0.0328141,
  0.0310302, 0.0292429, 0.0274527, 0.0256597, 0.0238642, 0.0220663,
  0.0202664, 0.0184647, 0.0166614, 0.0148568, 0.013051, 0.0112444,
  0.00943715, 0.00762948, 0.00582165, 0.00401388, 0.00220641,
  0.000399479, -0.00140668, -0.00321183, -0.00501575, -0.00681819,
  -0.00861893, -0.0104177, -0.0122144, -0.0140086, -0.0158002,
  -0.017589, -0.0193746, -0.021157, -0.0229358, -0.0247108,
  -0.0264819, -0.0282487, -0.0300111, -0.0317688, -0.0335216,
  -0.0352694, -0.0370118, -0.0387486, -0.0404797, -0.0422048,
  -0.0439237, -0.0456361, -0.047342, -0.049041, -0.0507329,
  -0.0524176, -0.0540948, -0.0557643, -0.0574259, -0.0590794,
  -0.0607247, -0.0623614, -0.0639894, -0.0656085, -0.0672185,
  -0.0688192, -0.0704104, -0.0719919, -0.0735635, -0.075125,
  -0.0766763, -0.0782171, -0.0797472, -0.0812666, -0.0827749,
  -0.084272, -0.0857577, -0.0872319, -0.0886944, -0.0901449,
  -0.0915834, -0.0930096, -0.0944234, -0.0958246, -0.097213,
  -0.0985885, -0.0999509, -0.1013, -0.102636, -0.103958, -0.105266,
  -0.106561, -0.107842, -0.109108, -0.11036, -0.111598, -0.112821,
  -0.114029, -0.115222, -0.116401, -0.117564, -0.118712, -0.119844,
  -0.120961, -0.122062, -0.123147, -0.124217, -0.12527, -0.126307,
  -0.127328, -0.128333, -0.129321, -0.130292, -0.131247, -0.132184,
  -0.133105, -0.134009, -0.134895, -0.135765, -0.136617, -0.137451,
  -0.138269, -0.139068, -0.13985, -0.140614, -0.14136, -0.142088,
  -0.142798, -0.143491, -0.144165, -0.14482, -0.145458, -0.146077,
  -0.146678, -0.14726, -0.147824, -0.148369, -0.148895, -0.149403,
  -0.149892, -0.150362, -0.150814, -0.151246, -0.15166, -0.152055,
  -0.15243, -0.152787, -0.153125, -0.153443, -0.153743, -0.154024,
  -0.154285, -0.154527, -0.15475, -0.154954, -0.155139, -0.155304,
  -0.15545, -0.155577, -0.155685, -0.155774, -0.155844, -0.155894,
  -0.155925, -0.155937, -0.15593, -0.155904, -0.155858, -0.155794,
  -0.15571, -0.155608, -0.155486, -0.155345, -0.155186, -0.155007,
  -0.15481, -0.154594, -0.154358, -0.154105, -0.153832, -0.153541,
  -0.153231, -0.152903, -0.152556, -0.15219, -0.151807, -0.151404,
  -0.150984, -0.150545, -0.150089, -0.149614, -0.149121, -0.14861,
  -0.148081, -0.147535, -0.146971, -0.146389, -0.14579, -0.145173,
  -0.144539, -0.143888, -0.143219, -0.142533, -0.141831, -0.141111,
  -0.140375, -0.139622, -0.138852, -0.138066, -0.137264, -0.136445,
  -0.13561, -0.134759, -0.133892, -0.13301, -0.132111, -0.131197,
  -0.130268, -0.129323, -0.128363, -0.127388, -0.126398, -0.125394,
  -0.124374, -0.12334, -0.122292, -0.121229, -0.120152, -0.119061,
  -0.117956, -0.116838, -0.115705, -0.11456, -0.113401, -0.112229,
  -0.111044, -0.109846, -0.108635, -0.107412, -0.106177, -0.104929,
  -0.103669, -0.102398, -0.101114, -0.0998192, -0.0985127, -0.0971949,
  -0.095866, -0.0945262, -0.0931757, -0.0918145, -0.0904429,
  -0.089061, -0.087669, -0.0862671, -0.0848555, -0.0834343,
  -0.0820037, -0.0805638, -0.079115, -0.0776572, -0.0761908,
  -0.0747158, -0.0732325, -0.0717411, -0.0702417, -0.0687345,
  -0.0672197, -0.0656975, -0.0641681, -0.0626316, -0.0610883,
  -0.0595382, -0.0579817, -0.0564189, -0.05485, -0.0532751,
  -0.0516945, -0.0501084, -0.0485169, -0.0469203, -0.0453186,
  -0.0437122, -0.0421012, -0.0404858, -0.0388662, -0.0372426,
  -0.0356152, -0.0339841, -0.0323496, -0.0307119, -0.0290711,
  -0.0274275, -0.0257812, -0.0241324, -0.0224814, -0.0208283,
  -0.0191733, -0.0175167, -0.0158585, -0.014199, -0.0125385,
  -0.010877, -0.00921483, -0.00755213, -0.0058891, -0.00422593,
  -0.00256283, -0.000899984, 0.000762416, 0.00242418, 0.0040851,
  0.005745, 0.00740369, 0.00906096, 0.0107166, 0.0123705, 0.0140224,
  0.0156721, 0.0173195, 0.0189643, 0.0206064, 0.0222455, 0.0238815,
  0.0255143, 0.0271435, 0.028769, 0.0303907, 0.0320084, 0.0336218,
  0.0352308, 0.0368352, 0.0384348, 0.0400294, 0.0416189, 0.0432031,
  0.0447818, 0.0463548, 0.0479219, 0.049483, 0.0510379, 0.0525865,
  0.0541284, 0.0556636, 0.057192, 0.0587132, 0.0602272, 0.0617338,
  0.0632328, 0.064724, 0.0662073, 0.0676826, 0.0691496, 0.0706081,
  0.0720582, 0.0734994, 0.0749318, 0.0763552, 0.0777693, 0.0791741,
  0.0805693, 0.0819549, 0.0833307, 0.0846964, 0.0860521, 0.0873975,
  0.0887324, 0.0900568, 0.0913705, 0.0926733, 0.0939651, 0.0952458,
  0.0965152, 0.0977732, 0.0990197, 0.100254, 0.101477, 0.102688,
  0.103887, 0.105074, 0.106248, 0.10741, 0.10856, 0.109696, 0.11082,
  0.111931, 0.113029, 0.114113, 0.115184, 0.116242, 0.117287,
  0.118317, 0.119334, 0.120337, 0.121326, 0.122302, 0.123262,
  0.124209, 0.125141, 0.126059, 0.126963, 0.127851, 0.128725,
  0.129584, 0.130428, 0.131257, 0.132072, 0.13287, 0.133654, 0.134422,
  0.135175, 0.135913, 0.136635, 0.137341, 0.138031, 0.138706,
  0.139365, 0.140008, 0.140635, 0.141246, 0.141841, 0.14242, 0.142983,
  0.143529, 0.144059, 0.144573, 0.14507, 0.145551, 0.146015, 0.146463,
  0.146895, 0.147309, 0.147707, 0.148089, 0.148453, 0.148801,
  0.149132, 0.149447, 0.149744, 0.150025, 0.150288, 0.150535,
  0.150765, 0.150978, 0.151174, 0.151353, 0.151515, 0.151661,
  0.151789, 0.1519, 0.151994, 0.152071, 0.152132, 0.152175, 0.152201,
  0.15221, 0.152203, 0.152178, 0.152137, 0.152078, 0.152003, 0.15191,
  0.151801, 0.151675, 0.151532, 0.151373, 0.151196, 0.151003,
  0.150793, 0.150566, 0.150323, 0.150063, 0.149787, 0.149494,
  0.149184, 0.148858, 0.148516, 0.148157, 0.147782, 0.147391,
  0.146983, 0.14656, 0.14612, 0.145664, 0.145192, 0.144705, 0.144201,
  0.143682, 0.143147, 0.142596, 0.142029, 0.141448, 0.14085, 0.140237,
  0.139609, 0.138966, 0.138308, 0.137634, 0.136946, 0.136242,
  0.135524, 0.134791, 0.134044, 0.133282, 0.132505, 0.131714,
  0.130909, 0.13009, 0.129256, 0.128409, 0.127547, 0.126672, 0.125784,
  0.124881, 0.123965, 0.123036, 0.122094, 0.121138, 0.12017, 0.119188,
  0.118194, 0.117187, 0.116167, 0.115135, 0.114091, 0.113034,
  0.111966, 0.110885, 0.109793, 0.108689, 0.107573, 0.106446,
  0.105307, 0.104157, 0.102996, 0.101825, 0.100642, 0.0994486,
  0.0982448, 0.0970306, 0.0958061, 0.0945715, 0.0933269, 0.0920724,
  0.0908082, 0.0895345, 0.0882513, 0.0869589, 0.0856573, 0.0843467,
  0.0830273, 0.0816992, 0.0803626, 0.0790175, 0.0776642, 0.0763028,
  0.0749335, 0.0735564, 0.0721716, 0.0707794, 0.0693798, 0.067973,
  0.0665592, 0.0651386, 0.0637112, 0.0622773, 0.060837, 0.0593905,
  0.0579379, 0.0564793, 0.0550151, 0.0535452, 0.0520699, 0.0505893,
  0.0491036, 0.047613, 0.0461176, 0.0446176, 0.0431131, 0.0416043,
  0.0400914, 0.0385745, 0.0370539, 0.0355296, 0.0340018, 0.0324707,
  0.0309365, 0.0293994, 0.0278594, 0.0263168, 0.0247718, 0.0232244,
  0.0216749, 0.0201234, 0.0185702, 0.0170153, 0.0154589, 0.0139013,
  0.0123425, 0.0107828, 0.00922223, 0.00766107, 0.00609946,
  0.00453756, 0.00297553, 0.00141355, -0.00014822, -0.00170961,
  -0.00327046, -0.00483059, -0.00638985, -0.00794806, -0.00950506,
  -0.0110607, -0.0126148, -0.0141671, -0.0157176, -0.0172661,
  -0.0188124, -0.0203563, -0.0218976, -0.0234363, -0.0249721,
  -0.0265049, -0.0280346, -0.0295609, -0.0310836, -0.0326028,
  -0.0341181, -0.0356294, -0.0371366, -0.0386394, -0.0401379,
  -0.0416317, -0.0431207, -0.0446048, -0.0460838, -0.0475576,
  -0.049026, -0.0504889, -0.051946, -0.0533973, -0.0548426,
  -0.0562818, -0.0577146, -0.059141, -0.0605608, -0.0619738, -0.06338,
  -0.0647791, -0.066171, -0.0675556, -0.0689327, -0.0703022,
  -0.0716639, -0.0730178, -0.0743636, -0.0757012, -0.0770305,
  -0.0783513, -0.0796636, -0.0809672, -0.0822619, -0.0835476,
  -0.0848241, -0.0860915, -0.0873494, -0.0885978, -0.0898366,
  -0.0910656, -0.0922848, -0.0934939, -0.0946929, -0.0958816,
  -0.0970599, -0.0982278, -0.099385, -0.100531, -0.101667, -0.102792,
  -0.103905, -0.105008, -0.106099, -0.107178, -0.108247, -0.109303,
  -0.110348, -0.111381, -0.112402, -0.113411, -0.114407, -0.115392,
  -0.116364, -0.117324, -0.118271, -0.119206, -0.120127, -0.121036,
  -0.121932, -0.122816, -0.123686, -0.124542, -0.125386, -0.126216,
  -0.127033, -0.127836, -0.128626, -0.129402, -0.130165, -0.130913,
  -0.131648, -0.132368, -0.133075, -0.133768, -0.134446, -0.13511,
  -0.13576, -0.136396, -0.137017, -0.137624, -0.138216, -0.138794,
  -0.139357, -0.139905, -0.140439, -0.140958, -0.141461, -0.141951,
  -0.142425, -0.142884, -0.143328, -0.143757, -0.144171, -0.14457,
  -0.144954, -0.145322, -0.145676, -0.146014, -0.146336, -0.146644,
  -0.146936, -0.147213, -0.147474, -0.14772, -0.14795, -0.148165,
  -0.148365, -0.148549, -0.148717, -0.14887, -0.149008, -0.14913,
  -0.149237, -0.149327, -0.149403, -0.149463, -0.149507, -0.149536,
  -0.149549, -0.149547, -0.149529, -0.149496, -0.149447, -0.149382,
  -0.149303, -0.149207, -0.149096, -0.14897, -0.148829, -0.148672,
  -0.148499, -0.148311, -0.148108, -0.14789, -0.147656, -0.147407,
  -0.147143, -0.146864, -0.146569, -0.14626, -0.145935, -0.145595,
  -0.145241, -0.144871, -0.144486, -0.144087, -0.143673, -0.143244,
  -0.1428, -0.142341, -0.141868, -0.141381, -0.140879, -0.140362,
  -0.139831, -0.139286, -0.138727, -0.138153, -0.137565, -0.136963,
  -0.136347, -0.135717, -0.135073, -0.134416, -0.133744, -0.133059,
  -0.132361, -0.131649, -0.130923, -0.130184, -0.129432, -0.128667,
  -0.127889, -0.127097, -0.126293, -0.125476, -0.124646, -0.123803,
  -0.122948, -0.12208, -0.1212, -0.120308, -0.119403, -0.118486,
  -0.117558, -0.116617, -0.115665, -0.114701, -0.113725, -0.112738,
  -0.111739, -0.110729, -0.109708, -0.108676, -0.107633, -0.106579,
  -0.105514, -0.104439, -0.103353, -0.102257, -0.101151, -0.100034,
  -0.0989071, -0.0977704, -0.0966239, -0.0954677, -0.094302,
  -0.0931268, -0.0919422, -0.0907485, -0.0895457, -0.0883339,
  -0.0871133, -0.085884, -0.0846461, -0.0833998, -0.0821452,
  -0.0808824, -0.0796115, -0.0783328, -0.0770462, -0.075752,
  -0.0744503, -0.0731411, -0.0718248, -0.0705013, -0.0691708,
  -0.0678335, -0.0664896, -0.065139, -0.063782, -0.0624188,
  -0.0610494, -0.059674, -0.0582927, -0.0569058, -0.0555132,
  -0.0541152, -0.052712, -0.0513036, -0.0498902, -0.0484719,
  -0.047049, -0.0456214, -0.0441895, -0.0427533, -0.0413129,
  -0.0398686, -0.0384205, -0.0369687, -0.0355133, -0.0340546,
  -0.0325927, -0.0311276, -0.0296596, -0.0281889, -0.0267155,
  -0.0252396, -0.0237614, -0.0222809, -0.0207985, -0.0193142,
  -0.0178281, -0.0163404, -0.0148514, -0.013361, -0.0118695,
  -0.010377, -0.00888373, -0.00738976, -0.00589525, -0.00440037,
  -0.00290527, -0.00141009, 8.50043e-05, 0.00157987, 0.00307436,
  0.00456832, 0.0060616, 0.00755404, 0.00904551, 0.0105358, 0.0120249,
  0.0135125, 0.0149985, 0.0164828, 0.0179653, 0.0194457, 0.0209239,
  0.0223998, 0.0238732, 0.025344, 0.026812, 0.0282772, 0.0297392,
  0.0311981, 0.0326535, 0.0341055, 0.0355539, 0.0369984, 0.0384391,
  0.0398756, 0.0413079, 0.0427359, 0.0441593, 0.0455782, 0.0469922,
  0.0484013, 0.0498053, 0.0512041, 0.0525975, 0.0539855, 0.0553679,
  0.0567444, 0.0581151, 0.0594798, 0.0608383, 0.0621904, 0.0635362,
  0.0648753, 0.0662078, 0.0675334, 0.0688521, 0.0701636, 0.071468,
  0.072765, 0.0740544, 0.0753363, 0.0766105, 0.0778767, 0.079135,
  0.0803852, 0.0816272, 0.0828608, 0.0840859, 0.0853024, 0.0865102,
  0.0877091, 0.0888991, 0.0900801, 0.0912518, 0.0924142, 0.0935673,
  0.0947108, 0.0958446, 0.0969687, 0.098083, 0.0991872, 0.100281,
  0.101365, 0.102439, 0.103503, 0.104555, 0.105598, 0.106629, 0.10765,
  0.10866, 0.109658, 0.110646, 0.111623, 0.112588, 0.113542, 0.114484,
  0.115415, 0.116334, 0.117242, 0.118137, 0.119021, 0.119893,
  0.120752, 0.1216, 0.122435, 0.123258, 0.124068, 0.124866, 0.125652,
  0.126424, 0.127185, 0.127932, 0.128666, 0.129388, 0.130096,
  0.130792, 0.131474, 0.132143, 0.132799, 0.133442, 0.134071,
  0.134686, 0.135289, 0.135877, 0.136452, 0.137014, 0.137562,
  0.138095, 0.138616, 0.139122, 0.139614, 0.140093, 0.140557,
  0.141007, 0.141444, 0.141866, 0.142274, 0.142667, 0.143047,
  0.143412, 0.143763, 0.1441, 0.144422, 0.14473, 0.145024, 0.145303,
  0.145567, 0.145817, 0.146053, 0.146274, 0.14648, 0.146672, 0.146849,
  0.147012, 0.14716, 0.147293, 0.147412, 0.147516, 0.147606, 0.147681,
  0.147741, 0.147786, 0.147817, 0.147833, 0.147835, 0.147822,
  0.147794, 0.147752, 0.147694, 0.147623, 0.147536, 0.147435, 0.14732,
  0.14719, 0.147045, 0.146886, 0.146712, 0.146524, 0.146321, 0.146104,
  0.145872, 0.145626, 0.145365, 0.14509, 0.144801, 0.144498, 0.14418,
  0.143848, 0.143502, 0.143141, 0.142767, 0.142378, 0.141976,
  0.141559, 0.141129, 0.140684, 0.140226, 0.139754, 0.139268,
  0.138768, 0.138255, 0.137728, 0.137188, 0.136634, 0.136066,
  0.135486, 0.134892, 0.134284, 0.133664, 0.13303, 0.132383, 0.131724,
  0.131051, 0.130365, 0.129667, 0.128956, 0.128232, 0.127496,
  0.126747, 0.125986, 0.125213, 0.124427, 0.123629, 0.122818,
  0.121996, 0.121162, 0.120316, 0.119458, 0.118589, 0.117708,
  0.116815, 0.115911, 0.114996, 0.114069, 0.113132, 0.112183,
  0.111223, 0.110253, 0.109271, 0.108279, 0.107277, 0.106264, 0.10524,
  0.104207, 0.103163, 0.102109, 0.101045, 0.0999712, 0.0988878,
  0.0977947, 0.0966922, 0.0955802, 0.0944589, 0.0933284, 0.0921888,
  0.0910403, 0.0898829, 0.0887168, 0.0875421, 0.0863589, 0.0851673,
  0.0839674, 0.0827594, 0.0815433, 0.0803194, 0.0790877, 0.0778483,
  0.0766013, 0.075347, 0.0740854, 0.0728165, 0.0715407, 0.0702579,
  0.0689684, 0.0676722, 0.0663694, 0.0650603, 0.0637448, 0.0624233,
  0.0610957, 0.0597622, 0.058423, 0.0570781, 0.0557278, 0.0543721,
  0.0530112, 0.0516452, 0.0502742, 0.0488984, 0.047518, 0.046133,
  0.0447436, 0.0433499, 0.041952, 0.0405502, 0.0391445, 0.0377351,
  0.0363221, 0.0349056, 0.0334858, 0.0320629, 0.0306369, 0.0292081,
  0.0277765, 0.0263423, 0.0249056, 0.0234666, 0.0220253, 0.0205821,
  0.0191369, 0.01769, 0.0162415, 0.0147914, 0.0133401, 0.0118875,
  0.0104339, 0.00897932, 0.00752401, 0.00606807, 0.00461165,
  0.00315487, 0.0016979, 0.000240858, -0.0012161, -0.00267283,
  -0.0041292, -0.00558506, -0.00704028, -0.0084947, -0.00994819,
  -0.0114006, -0.0128518, -0.0143016, -0.01575, -0.0171967,
  -0.0186416, -0.0200846, -0.0215256, -0.0229643, -0.0244007,
  -0.0258347, -0.027266, -0.0286945, -0.0301202, -0.0315428,
  -0.0329622, -0.0343783, -0.035791, -0.0372001, -0.0386055,
  -0.040007, -0.0414045, -0.0427979, -0.044187, -0.0455717,
  -0.0469519, -0.0483274, -0.0496981, -0.0510639, -0.0524246,
  -0.0537801, -0.0551303, -0.056475, -0.0578142, -0.0591476,
  -0.0604751, -0.0617967, -0.0631122, -0.0644214, -0.0657243,
  -0.0670207, -0.0683105, -0.0695936, -0.0708698, -0.072139,
  -0.0734011, -0.074656, -0.0759035, -0.0771436, -0.078376,
  -0.0796008, -0.0808178, -0.0820268, -0.0832277, -0.0844205,
  -0.085605, -0.086781, -0.0879486, -0.0891075, -0.0902577,
  -0.0913991, -0.0925315, -0.0936548, -0.0947689, -0.0958737,
  -0.0969692, -0.0980551, -0.0991315, -0.100198, -0.101255, -0.102302,
  -0.103339, -0.104366, -0.105382, -0.106389, -0.107384, -0.10837,
  -0.109345, -0.110309, -0.111262, -0.112205, -0.113136, -0.114057,
  -0.114966, -0.115864, -0.116751, -0.117626, -0.11849, -0.119343,
  -0.120183, -0.121012, -0.12183, -0.122635, -0.123428, -0.12421,
  -0.124979, -0.125736, -0.126481, -0.127213, -0.127933, -0.128641,
  -0.129336, -0.130018, -0.130688, -0.131345, -0.131989, -0.132621,
  -0.133239, -0.133845, -0.134438, -0.135017, -0.135583, -0.136137,
  -0.136676, -0.137203, -0.137716, -0.138216, -0.138703, -0.139176,
  -0.139635, -0.140081, -0.140513, -0.140932, -0.141337, -0.141728,
  -0.142105, -0.142469, -0.142818, -0.143154, -0.143476, -0.143784,
  -0.144078, -0.144358, -0.144625, -0.144877, -0.145115, -0.145338,
  -0.145548, -0.145744, -0.145925, -0.146093, -0.146246, -0.146385,
  -0.14651, -0.14662, -0.146717, -0.146799, -0.146867, -0.14692,
  -0.14696, -0.146985, -0.146996, -0.146992, -0.146975, -0.146943,
  -0.146897, -0.146836, -0.146762, -0.146673, -0.14657, -0.146453,
  -0.146322, -0.146176, -0.146016, -0.145842, -0.145654, -0.145452,
  -0.145236, -0.145006, -0.144762, -0.144503, -0.144231, -0.143945,
  -0.143645, -0.14333, -0.143002, -0.142661, -0.142305, -0.141936,
  -0.141553, -0.141156, -0.140745, -0.140321, -0.139883, -0.139432,
  -0.138967, -0.138489, -0.137998, -0.137493, -0.136975, -0.136443,
  -0.135899, -0.135341, -0.13477, -0.134186, -0.133589, -0.132979,
  -0.132357, -0.131721, -0.131073, -0.130412, -0.129739, -0.129053,
  -0.128354, -0.127643, -0.12692, -0.126185, -0.125437, -0.124677,
  -0.123905, -0.123121, -0.122326, -0.121518, -0.120699, -0.119868,
  -0.119025, -0.118171, -0.117306, -0.116429, -0.115541, -0.114642,
  -0.113732, -0.11281, -0.111878, -0.110935, -0.109982, -0.109017,
  -0.108042, -0.107057, -0.106062, -0.105056, -0.10404, -0.103014,
  -0.101978, -0.100932, -0.0998765, -0.0988112, -0.0977365,
  -0.0966523, -0.0955588, -0.0944561, -0.0933442, -0.0922234,
  -0.0910936, -0.089955, -0.0888078, -0.087652, -0.0864877,
  -0.0853151, -0.0841342, -0.0829452, -0.0817482, -0.0805434,
  -0.0793307, -0.0781104, -0.0768826, -0.0756473, -0.0744048,
  -0.073155, -0.0718982, -0.0706345, -0.069364, -0.0680867,
  -0.0668029, -0.0655126, -0.0642161, -0.0629133, -0.0616044,
  -0.0602897, -0.0589691, -0.0576428, -0.0563109, -0.0549736,
  -0.053631, -0.0522833, -0.0509305, -0.0495727, -0.0482102,
  -0.0468431, -0.0454714, -0.0440954, -0.042715, -0.0413306,
  -0.0399422, -0.0385499, -0.0371539, -0.0357544, -0.0343513,
  -0.032945, -0.0315355, -0.0301229, -0.0287075, -0.0272892,
  -0.0258684, -0.024445, -0.0230193, -0.0215914, -0.0201614,
  -0.0187294, -0.0172956, -0.0158602, -0.0144232, -0.0129849,
  -0.0115453, -0.0101045, -0.00866285, -0.00722032, -0.00577709,
  -0.00433331, -0.0028891, -0.00144462, 0, 0.00144462, 0.0028891,
  0.00433331, 0.00577709, 0.00722032, 0.00866285, 0.0101045,
  0.0115453, 0.0129849, 0.0144232, 0.0158602, 0.0172956, 0.0187294,
  0.0201614, 0.0215914, 0.0230193, 0.024445, 0.0258684, 0.0272892,
  0.0287075, 0.0301229, 0.0315355, 0.032945, 0.0343513, 0.0357544,
  0.0371539, 0.0385499, 0.0399422, 0.0413306, 0.042715, 0.0440954,
  0.0454714, 0.0468431, 0.0482102, 0.0495727, 0.0509305, 0.0522833,
  0.053631, 0.0549736, 0.0563109, 0.0576428, 0.0589691, 0.0602897,
  0.0616044, 0.0629133, 0.0642161, 0.0655126, 0.0668029, 0.0680867,
  0.069364, 0.0706345, 0.0718982, 0.073155, 0.0744048, 0.0756473,
  0.0768826, 0.0781104, 0.0793307, 0.0805434, 0.0817482, 0.0829452,
  0.0841342, 0.0853151, 0.0864877, 0.087652, 0.0888078, 0.089955,
  0.0910936, 0.0922234, 0.0933442, 0.0944561, 0.0955588, 0.0966523,
  0.0977365, 0.0988112, 0.0998765, 0.100932, 0.101978, 0.103014,
  0.10404, 0.105056, 0.106062, 0.107057, 0.108042, 0.109017, 0.109982,
  0.110935, 0.111878, 0.11281, 0.113732, 0.114642, 0.115541, 0.116429,
  0.117306, 0.118171, 0.119025, 0.119868, 0.120699, 0.121518,
  0.122326, 0.123121, 0.123905, 0.124677, 0.125437, 0.126185, 0.12692,
  0.127643, 0.128354, 0.129053, 0.129739, 0.130412, 0.131073,
  0.131721, 0.132357, 0.132979, 0.133589, 0.134186, 0.13477, 0.135341,
  0.135899, 0.136443, 0.136975, 0.137493, 0.137998, 0.138489,
  0.138967, 0.139432, 0.139883, 0.140321, 0.140745, 0.141156,
  0.141553, 0.141936, 0.142305, 0.142661, 0.143002, 0.14333, 0.143645,
  0.143945, 0.144231, 0.144503, 0.144762, 0.145006, 0.145236,
  0.145452, 0.145654, 0.145842, 0.146016, 0.146176, 0.146322,
  0.146453, 0.14657, 0.146673, 0.146762, 0.146836, 0.146897, 0.146943,
  0.146975, 0.146992, 0.146996, 0.146985, 0.14696, 0.14692, 0.146867,
  0.146799, 0.146717, 0.14662, 0.14651, 0.146385, 0.146246, 0.146093,
  0.145925, 0.145744, 0.145548, 0.145338, 0.145115, 0.144877,
  0.144625, 0.144358, 0.144078, 0.143784, 0.143476, 0.143154,
  0.142818, 0.142469, 0.142105, 0.141728, 0.141337, 0.140932,
  0.140513, 0.140081, 0.139635, 0.139176, 0.138703, 0.138216,
  0.137716, 0.137203, 0.136676, 0.136137, 0.135583, 0.135017,
  0.134438, 0.133845, 0.133239, 0.132621, 0.131989, 0.131345,
  0.130688, 0.130018, 0.129336, 0.128641, 0.127933, 0.127213,
  0.126481, 0.125736, 0.124979, 0.12421, 0.123428, 0.122635, 0.12183,
  0.121012, 0.120183, 0.119343, 0.11849, 0.117626, 0.116751, 0.115864,
  0.114966, 0.114057, 0.113136, 0.112205, 0.111262, 0.110309,
  0.109345, 0.10837, 0.107384, 0.106389, 0.105382, 0.104366, 0.103339,
  0.102302, 0.101255, 0.100198, 0.0991315, 0.0980551, 0.0969692,
  0.0958737, 0.0947689, 0.0936548, 0.0925315, 0.0913991, 0.0902577,
  0.0891075, 0.0879486, 0.086781, 0.085605, 0.0844205, 0.0832277,
  0.0820268, 0.0808178, 0.0796008, 0.078376, 0.0771436, 0.0759035,
  0.074656, 0.0734011, 0.072139, 0.0708698, 0.0695936, 0.0683105,
  0.0670207, 0.0657243, 0.0644214, 0.0631122, 0.0617967, 0.0604751,
  0.0591476, 0.0578142, 0.056475, 0.0551303, 0.0537801, 0.0524246,
  0.0510639, 0.0496981, 0.0483274, 0.0469519, 0.0455717, 0.044187,
  0.0427979, 0.0414045, 0.040007, 0.0386055, 0.0372001, 0.035791,
  0.0343783, 0.0329622, 0.0315428, 0.0301202, 0.0286945, 0.027266,
  0.0258347, 0.0244007, 0.0229643, 0.0215256, 0.0200846, 0.0186416,
  0.0171967, 0.01575, 0.0143016, 0.0128518, 0.0114006, 0.00994819,
  0.0084947, 0.00704028, 0.00558506, 0.0041292, 0.00267283, 0.0012161,
  -0.000240858, -0.0016979, -0.00315487, -0.00461165, -0.00606807,
  -0.00752401, -0.00897932, -0.0104339, -0.0118875, -0.0133401,
  -0.0147914, -0.0162415, -0.01769, -0.0191369, -0.0205821,
  -0.0220253, -0.0234666, -0.0249056, -0.0263423, -0.0277765,
  -0.0292081, -0.0306369, -0.0320629, -0.0334858, -0.0349056,
  -0.0363221, -0.0377351, -0.0391445, -0.0405502, -0.041952,
  -0.0433499, -0.0447436, -0.046133, -0.047518, -0.0488984,
  -0.0502742, -0.0516452, -0.0530112, -0.0543721, -0.0557278,
  -0.0570781, -0.058423, -0.0597622, -0.0610957, -0.0624233,
  -0.0637448, -0.0650603, -0.0663694, -0.0676722, -0.0689684,
  -0.0702579, -0.0715407, -0.0728165, -0.0740854, -0.075347,
  -0.0766013, -0.0778483, -0.0790877, -0.0803194, -0.0815433,
  -0.0827594, -0.0839674, -0.0851673, -0.0863589, -0.0875421,
  -0.0887168, -0.0898829, -0.0910403, -0.0921888, -0.0933284,
  -0.0944589, -0.0955802, -0.0966922, -0.0977947, -0.0988878,
  -0.0999712, -0.101045, -0.102109, -0.103163, -0.104207, -0.10524,
  -0.106264, -0.107277, -0.108279, -0.109271, -0.110253, -0.111223,
  -0.112183, -0.113132, -0.114069, -0.114996, -0.115911, -0.116815,
  -0.117708, -0.118589, -0.119458, -0.120316, -0.121162, -0.121996,
  -0.122818, -0.123629, -0.124427, -0.125213, -0.125986, -0.126747,
  -0.127496, -0.128232, -0.128956, -0.129667, -0.130365, -0.131051,
  -0.131724, -0.132383, -0.13303, -0.133664, -0.134284, -0.134892,
  -0.135486, -0.136066, -0.136634, -0.137188, -0.137728, -0.138255,
  -0.138768, -0.139268, -0.139754, -0.140226, -0.140684, -0.141129,
  -0.141559, -0.141976, -0.142378, -0.142767, -0.143141, -0.143502,
  -0.143848, -0.14418, -0.144498, -0.144801, -0.14509, -0.145365,
  -0.145626, -0.145872, -0.146104, -0.146321, -0.146524, -0.146712,
  -0.146886, -0.147045, -0.14719, -0.14732, -0.147435, -0.147536,
  -0.147623, -0.147694, -0.147752, -0.147794, -0.147822, -0.147835,
  -0.147833, -0.147817, -0.147786, -0.147741, -0.147681, -0.147606,
  -0.147516, -0.147412, -0.147293, -0.14716, -0.147012, -0.146849,
  -0.146672, -0.14648, -0.146274, -0.146053, -0.145817, -0.145567,
  -0.145303, -0.145024, -0.14473, -0.144422, -0.1441, -0.143763,
  -0.143412, -0.143047, -0.142667, -0.142274, -0.141866, -0.141444,
  -0.141007, -0.140557, -0.140093, -0.139614, -0.139122, -0.138616,
  -0.138095, -0.137562, -0.137014, -0.136452, -0.135877, -0.135289,
  -0.134686, -0.134071, -0.133442, -0.132799, -0.132143, -0.131474,
  -0.130792, -0.130096, -0.129388, -0.128666, -0.127932, -0.127185,
  -0.126424, -0.125652, -0.124866, -0.124068, -0.123258, -0.122435,
  -0.1216, -0.120752, -0.119893, -0.119021, -0.118137, -0.117242,
  -0.116334, -0.115415, -0.114484, -0.113542, -0.112588, -0.111623,
  -0.110646, -0.109658, -0.10866, -0.10765, -0.106629, -0.105598,
  -0.104555, -0.103503, -0.102439, -0.101365, -0.100281, -0.0991872,
  -0.098083, -0.0969687, -0.0958446, -0.0947108, -0.0935673,
  -0.0924142, -0.0912518, -0.0900801, -0.0888991, -0.0877091,
  -0.0865102, -0.0853024, -0.0840859, -0.0828608, -0.0816272,
  -0.0803852, -0.079135, -0.0778767, -0.0766105, -0.0753363,
  -0.0740544, -0.072765, -0.071468, -0.0701636, -0.0688521,
  -0.0675334, -0.0662078, -0.0648753, -0.0635362, -0.0621904,
  -0.0608383, -0.0594798, -0.0581151, -0.0567444, -0.0553679,
  -0.0539855, -0.0525975, -0.0512041, -0.0498053, -0.0484013,
  -0.0469922, -0.0455782, -0.0441593, -0.0427359, -0.0413079,
  -0.0398756, -0.0384391, -0.0369984, -0.0355539, -0.0341055,
  -0.0326535, -0.0311981, -0.0297392, -0.0282772, -0.026812,
  -0.025344, -0.0238732, -0.0223998, -0.0209239, -0.0194457,
  -0.0179653, -0.0164828, -0.0149985, -0.0135125, -0.0120249,
  -0.0105358, -0.00904551, -0.00755404, -0.0060616, -0.00456832,
  -0.00307436, -0.00157987, -8.50043e-05, 0.00141009, 0.00290527,
  0.00440037, 0.00589525, 0.00738976, 0.00888373, 0.010377, 0.0118695,
  0.013361, 0.0148514, 0.0163404, 0.0178281, 0.0193142, 0.0207985,
  0.0222809, 0.0237614, 0.0252396, 0.0267155, 0.0281889, 0.0296596,
  0.0311276, 0.0325927, 0.0340546, 0.0355133, 0.0369687, 0.0384205,
  0.0398686, 0.0413129, 0.0427533, 0.0441895, 0.0456214, 0.047049,
  0.0484719, 0.0498902, 0.0513036, 0.052712, 0.0541152, 0.0555132,
  0.0569058, 0.0582927, 0.059674, 0.0610494, 0.0624188, 0.063782,
  0.065139, 0.0664896, 0.0678335, 0.0691708, 0.0705013, 0.0718248,
  0.0731411, 0.0744503, 0.075752, 0.0770462, 0.0783328, 0.0796115,
  0.0808824, 0.0821452, 0.0833998, 0.0846461, 0.085884, 0.0871133,
  0.0883339, 0.0895457, 0.0907485, 0.0919422, 0.0931268, 0.094302,
  0.0954677, 0.0966239, 0.0977704, 0.0989071, 0.100034, 0.101151,
  0.102257, 0.103353, 0.104439, 0.105514, 0.106579, 0.107633,
  0.108676, 0.109708, 0.110729, 0.111739, 0.112738, 0.113725,
  0.114701, 0.115665, 0.116617, 0.117558, 0.118486, 0.119403,
  0.120308, 0.1212, 0.12208, 0.122948, 0.123803, 0.124646, 0.125476,
  0.126293, 0.127097, 0.127889, 0.128667, 0.129432, 0.130184,
  0.130923, 0.131649, 0.132361, 0.133059, 0.133744, 0.134416,
  0.135073, 0.135717, 0.136347, 0.136963, 0.137565, 0.138153,
  0.138727, 0.139286, 0.139831, 0.140362, 0.140879, 0.141381,
  0.141868, 0.142341, 0.1428, 0.143244, 0.143673, 0.144087, 0.144486,
  0.144871, 0.145241, 0.145595, 0.145935, 0.14626, 0.146569, 0.146864,
  0.147143, 0.147407, 0.147656, 0.14789, 0.148108, 0.148311, 0.148499,
  0.148672, 0.148829, 0.14897, 0.149096, 0.149207, 0.149303, 0.149382,
  0.149447, 0.149496, 0.149529, 0.149547, 0.149549, 0.149536,
  0.149507, 0.149463, 0.149403, 0.149327, 0.149237, 0.14913, 0.149008,
  0.14887, 0.148717, 0.148549, 0.148365, 0.148165, 0.14795, 0.14772,
  0.147474, 0.147213, 0.146936, 0.146644, 0.146336, 0.146014,
  0.145676, 0.145322, 0.144954, 0.14457, 0.144171, 0.143757, 0.143328,
  0.142884, 0.142425, 0.141951, 0.141461, 0.140958, 0.140439,
  0.139905, 0.139357, 0.138794, 0.138216, 0.137624, 0.137017,
  0.136396, 0.13576, 0.13511, 0.134446, 0.133768, 0.133075, 0.132368,
  0.131648, 0.130913, 0.130165, 0.129402, 0.128626, 0.127836,
  0.127033, 0.126216, 0.125386, 0.124542, 0.123686, 0.122816,
  0.121932, 0.121036, 0.120127, 0.119206, 0.118271, 0.117324,
  0.116364, 0.115392, 0.114407, 0.113411, 0.112402, 0.111381,
  0.110348, 0.109303, 0.108247, 0.107178, 0.106099, 0.105008,
  0.103905, 0.102792, 0.101667, 0.100531, 0.099385, 0.0982278,
  0.0970599, 0.0958816, 0.0946929, 0.0934939, 0.0922848, 0.0910656,
  0.0898366, 0.0885978, 0.0873494, 0.0860915, 0.0848241, 0.0835476,
  0.0822619, 0.0809672, 0.0796636, 0.0783513, 0.0770305, 0.0757012,
  0.0743636, 0.0730178, 0.0716639, 0.0703022, 0.0689327, 0.0675556,
  0.066171, 0.0647791, 0.06338, 0.0619738, 0.0605608, 0.059141,
  0.0577146, 0.0562818, 0.0548426, 0.0533973, 0.051946, 0.0504889,
  0.049026, 0.0475576, 0.0460838, 0.0446048, 0.0431207, 0.0416317,
  0.0401379, 0.0386394, 0.0371366, 0.0356294, 0.0341181, 0.0326028,
  0.0310836, 0.0295609, 0.0280346, 0.0265049, 0.0249721, 0.0234363,
  0.0218976, 0.0203563, 0.0188124, 0.0172661, 0.0157176, 0.0141671,
  0.0126148, 0.0110607, 0.00950506, 0.00794806, 0.00638985,
  0.00483059, 0.00327046, 0.00170961, 0.00014822, -0.00141355,
  -0.00297553, -0.00453756, -0.00609946, -0.00766107, -0.00922223,
  -0.0107828, -0.0123425, -0.0139013, -0.0154589, -0.0170153,
  -0.0185702, -0.0201234, -0.0216749, -0.0232244, -0.0247718,
  -0.0263168, -0.0278594, -0.0293994, -0.0309365, -0.0324707,
  -0.0340018, -0.0355296, -0.0370539, -0.0385745, -0.0400914,
  -0.0416043, -0.0431131, -0.0446176, -0.0461176, -0.047613,
  -0.0491036, -0.0505893, -0.0520699, -0.0535452, -0.0550151,
  -0.0564793, -0.0579379, -0.0593905, -0.060837, -0.0622773,
  -0.0637112, -0.0651386, -0.0665592, -0.067973, -0.0693798,
  -0.0707794, -0.0721716, -0.0735564, -0.0749335, -0.0763028,
  -0.0776642, -0.0790175, -0.0803626, -0.0816992, -0.0830273,
  -0.0843467, -0.0856573, -0.0869589, -0.0882513, -0.0895345,
  -0.0908082, -0.0920724, -0.0933269, -0.0945715, -0.0958061,
  -0.0970306, -0.0982448, -0.0994486, -0.100642, -0.101825, -0.102996,
  -0.104157, -0.105307, -0.106446, -0.107573, -0.108689, -0.109793,
  -0.110885, -0.111966, -0.113034, -0.114091, -0.115135, -0.116167,
  -0.117187, -0.118194, -0.119188, -0.12017, -0.121138, -0.122094,
  -0.123036, -0.123965, -0.124881, -0.125784, -0.126672, -0.127547,
  -0.128409, -0.129256, -0.13009, -0.130909, -0.131714, -0.132505,
  -0.133282, -0.134044, -0.134791, -0.135524, -0.136242, -0.136946,
  -0.137634, -0.138308, -0.138966, -0.139609, -0.140237, -0.14085,
  -0.141448, -0.142029, -0.142596, -0.143147, -0.143682, -0.144201,
  -0.144705, -0.145192, -0.145664, -0.14612, -0.14656, -0.146983,
  -0.147391, -0.147782, -0.148157, -0.148516, -0.148858, -0.149184,
  -0.149494, -0.149787, -0.150063, -0.150323, -0.150566, -0.150793,
  -0.151003, -0.151196, -0.151373, -0.151532, -0.151675, -0.151801,
  -0.15191, -0.152003, -0.152078, -0.152137, -0.152178, -0.152203,
  -0.15221, -0.152201, -0.152175, -0.152132, -0.152071, -0.151994,
  -0.1519, -0.151789, -0.151661, -0.151515, -0.151353, -0.151174,
  -0.150978, -0.150765, -0.150535, -0.150288, -0.150025, -0.149744,
  -0.149447, -0.149132, -0.148801, -0.148453, -0.148089, -0.147707,
  -0.147309, -0.146895, -0.146463, -0.146015, -0.145551, -0.14507,
  -0.144573, -0.144059, -0.143529, -0.142983, -0.14242, -0.141841,
  -0.141246, -0.140635, -0.140008, -0.139365, -0.138706, -0.138031,
  -0.137341, -0.136635, -0.135913, -0.135175, -0.134422, -0.133654,
  -0.13287, -0.132072, -0.131257, -0.130428, -0.129584, -0.128725,
  -0.127851, -0.126963, -0.126059, -0.125141, -0.124209, -0.123262,
  -0.122302, -0.121326, -0.120337, -0.119334, -0.118317, -0.117287,
  -0.116242, -0.115184, -0.114113, -0.113029, -0.111931, -0.11082,
  -0.109696, -0.10856, -0.10741, -0.106248, -0.105074, -0.103887,
  -0.102688, -0.101477, -0.100254, -0.0990197, -0.0977732, -0.0965152,
  -0.0952458, -0.0939651, -0.0926733, -0.0913705, -0.0900568,
  -0.0887324, -0.0873975, -0.0860521, -0.0846964, -0.0833307,
  -0.0819549, -0.0805693, -0.0791741, -0.0777693, -0.0763552,
  -0.0749318, -0.0734994, -0.0720582, -0.0706081, -0.0691496,
  -0.0676826, -0.0662073, -0.064724, -0.0632328, -0.0617338,
  -0.0602272, -0.0587132, -0.057192, -0.0556636, -0.0541284,
  -0.0525865, -0.0510379, -0.049483, -0.0479219, -0.0463548,
  -0.0447818, -0.0432031, -0.0416189, -0.0400294, -0.0384348,
  -0.0368352, -0.0352308, -0.0336218, -0.0320084, -0.0303907,
  -0.028769, -0.0271435, -0.0255143, -0.0238815, -0.0222455,
  -0.0206064, -0.0189643, -0.0173195, -0.0156721, -0.0140224,
  -0.0123705, -0.0107166, -0.00906096, -0.00740369, -0.005745,
  -0.0040851, -0.00242418, -0.000762416, 0.000899984, 0.00256283,
  0.00422593, 0.0058891, 0.00755213, 0.00921483, 0.010877, 0.0125385,
  0.014199, 0.0158585, 0.0175167, 0.0191733, 0.0208283, 0.0224814,
  0.0241324, 0.0257812, 0.0274275, 0.0290711, 0.0307119, 0.0323496,
  0.0339841, 0.0356152, 0.0372426, 0.0388662, 0.0404858, 0.0421012,
  0.0437122, 0.0453186, 0.0469203, 0.0485169, 0.0501084, 0.0516945,
  0.0532751, 0.05485, 0.0564189, 0.0579817, 0.0595382, 0.0610883,
  0.0626316, 0.0641681, 0.0656975, 0.0672197, 0.0687345, 0.0702417,
  0.0717411, 0.0732325, 0.0747158, 0.0761908, 0.0776572, 0.079115,
  0.0805638, 0.0820037, 0.0834343, 0.0848555, 0.0862671, 0.087669,
  0.089061, 0.0904429, 0.0918145, 0.0931757, 0.0945262, 0.095866,
  0.0971949, 0.0985127, 0.0998192, 0.101114, 0.102398, 0.103669,
  0.104929, 0.106177, 0.107412, 0.108635, 0.109846, 0.111044,
  0.112229, 0.113401, 0.11456, 0.115705, 0.116838, 0.117956, 0.119061,
  0.120152, 0.121229, 0.122292, 0.12334, 0.124374, 0.125394, 0.126398,
  0.127388, 0.128363, 0.129323, 0.130268, 0.131197, 0.132111, 0.13301,
  0.133892, 0.134759, 0.13561, 0.136445, 0.137264, 0.138066, 0.138852,
  0.139622, 0.140375, 0.141111, 0.141831, 0.142533, 0.143219,
  0.143888, 0.144539, 0.145173, 0.14579, 0.146389, 0.146971, 0.147535,
  0.148081, 0.14861, 0.149121, 0.149614, 0.150089, 0.150545, 0.150984,
  0.151404, 0.151807, 0.15219, 0.152556, 0.152903, 0.153231, 0.153541,
  0.153832, 0.154105, 0.154358, 0.154594, 0.15481, 0.155007, 0.155186,
  0.155345, 0.155486, 0.155608, 0.15571, 0.155794, 0.155858, 0.155904,
  0.15593, 0.155937, 0.155925, 0.155894, 0.155844, 0.155774, 0.155685,
  0.155577, 0.15545, 0.155304, 0.155139, 0.154954, 0.15475, 0.154527,
  0.154285, 0.154024, 0.153743, 0.153443, 0.153125, 0.152787, 0.15243,
  0.152055, 0.15166, 0.151246, 0.150814, 0.150362, 0.149892, 0.149403,
  0.148895, 0.148369, 0.147824, 0.14726, 0.146678, 0.146077, 0.145458,
  0.14482, 0.144165, 0.143491, 0.142798, 0.142088, 0.14136, 0.140614,
  0.13985, 0.139068, 0.138269, 0.137451, 0.136617, 0.135765, 0.134895,
  0.134009, 0.133105, 0.132184, 0.131247, 0.130292, 0.129321,
  0.128333, 0.127328, 0.126307, 0.12527, 0.124217, 0.123147, 0.122062,
  0.120961, 0.119844, 0.118712, 0.117564, 0.116401, 0.115222,
  0.114029, 0.112821, 0.111598, 0.11036, 0.109108, 0.107842, 0.106561,
  0.105266, 0.103958, 0.102636, 0.1013, 0.0999509, 0.0985885,
  0.097213, 0.0958246, 0.0944234, 0.0930096, 0.0915834, 0.0901449,
  0.0886944, 0.0872319, 0.0857577, 0.084272, 0.0827749, 0.0812666,
  0.0797472, 0.0782171, 0.0766763, 0.075125, 0.0735635, 0.0719919,
  0.0704104, 0.0688192, 0.0672185, 0.0656085, 0.0639894, 0.0623614,
  0.0607247, 0.0590794, 0.0574259, 0.0557643, 0.0540948, 0.0524176,
  0.0507329, 0.049041, 0.047342, 0.0456361, 0.0439237, 0.0422048,
  0.0404797, 0.0387486, 0.0370118, 0.0352694, 0.0335216, 0.0317688,
  0.0300111, 0.0282487, 0.0264819, 0.0247108, 0.0229358, 0.021157,
  0.0193746, 0.017589, 0.0158002, 0.0140086, 0.0122144, 0.0104177,
  0.00861893, 0.00681819, 0.00501575, 0.00321183, 0.00140668,
  -0.000399479, -0.00220641, -0.00401388, -0.00582165, -0.00762948,
  -0.00943715, -0.0112444, -0.013051, -0.0148568, -0.0166614,
  -0.0184647, -0.0202664, -0.0220663, -0.0238642, -0.0256597,
  -0.0274527, -0.0292429, -0.0310302, -0.0328141, -0.0345946,
  -0.0363714, -0.0381443, -0.0399129, -0.0416771, -0.0434367,
  -0.0451913, -0.0469409, -0.048685, -0.0504236, -0.0521563,
  -0.053883, -0.0556033, -0.0573171, -0.0590242, -0.0607242,
  -0.0624171, -0.0641024, -0.0657801, -0.0674498, -0.0691114,
  -0.0707646, -0.0724093, -0.074045, -0.0756718, -0.0772892,
  -0.0788972, -0.0804954, -0.0820837, -0.0836618, -0.0852295,
  -0.0867867, -0.088333, -0.0898682, -0.0913922, -0.0929048,
  -0.0944057, -0.0958946, -0.0973715, -0.0988361, -0.100288,
  -0.101727, -0.103154, -0.104567, -0.105967, -0.107353, -0.108726,
  -0.110085, -0.111429, -0.11276, -0.114075, -0.115376, -0.116663,
  -0.117934, -0.119189, -0.12043, -0.121654, -0.122863, -0.124056,
  -0.125233, -0.126393, -0.127537, -0.128664, -0.129775, -0.130868,
  -0.131944, -0.133003, -0.134044, -0.135068, -0.136074, -0.137061,
  -0.138031, -0.138982, -0.139915, -0.14083, -0.141725, -0.142602,
  -0.14346, -0.144298, -0.145118, -0.145918, -0.146698, -0.147459,
  -0.1482, -0.148921, -0.149622, -0.150303, -0.150964, -0.151604,
  -0.152224, -0.152823, -0.153402, -0.153959, -0.154496, -0.155012,
  -0.155507, -0.155981, -0.156433, -0.156865, -0.157274, -0.157663,
  -0.158029, -0.158374, -0.158698, -0.158999, -0.159279, -0.159537,
  -0.159773, -0.159987, -0.160179, -0.160349, -0.160496, -0.160621,
  -0.160725, -0.160805, -0.160864, -0.1609, -0.160914, -0.160905,
  -0.160874, -0.160821, -0.160745, -0.160646, -0.160525, -0.160382,
  -0.160216, -0.160027, -0.159816, -0.159583, -0.159327, -0.159049,
  -0.158748, -0.158425, -0.158079, -0.157711, -0.15732, -0.156908,
  -0.156472, -0.156015, -0.155535, -0.155034, -0.15451, -0.153964,
  -0.153396, -0.152806, -0.152194, -0.15156, -0.150904, -0.150227,
  -0.149528, -0.148808, -0.148066, -0.147302, -0.146517, -0.145711,
  -0.144884, -0.144036, -0.143167, -0.142277, -0.141366, -0.140434,
  -0.139482, -0.13851, -0.137517, -0.136504, -0.135471, -0.134418,
  -0.133345, -0.132253, -0.131141, -0.130009, -0.128858, -0.127689,
  -0.1265, -0.125292, -0.124065, -0.122821, -0.121557, -0.120276,
  -0.118976, -0.117659, -0.116323, -0.114971, -0.1136, -0.112213,
  -0.110809, -0.109388, -0.10795, -0.106495, -0.105025, -0.103538,
  -0.102036, -0.100518, -0.098984, -0.097435, -0.0958711, -0.0942922,
  -0.0926988, -0.0910909, -0.0894688, -0.0878327, -0.0861828,
  -0.0845194, -0.0828426, -0.0811528, -0.0794501, -0.0777348,
  -0.0760071, -0.0742673, -0.0725155, -0.0707521, -0.0689773,
  -0.0671912, -0.0653943, -0.0635867, -0.0617686, -0.0599404,
  -0.0581022, -0.0562544, -0.0543972, -0.0525309, -0.0506557,
  -0.0487719, -0.0468797, -0.0449795, -0.0430715, -0.041156,
  -0.0392332, -0.0373034, -0.0353669, -0.0334241, -0.031475,
  -0.0295202, -0.0275597, -0.025594, -0.0236232, -0.0216478,
  -0.0196679, -0.0176838, -0.015696, -0.0137045, -0.0117098,
  -0.00971212, -0.00771175, -0.00570901, -0.00370418, -0.00169756,
  0.000310557, 0.00231986, 0.00433006, 0.00634085, 0.00835194,
  0.010363, 0.0123738, 0.0143839, 0.0163932, 0.0184012, 0.0204077,
  0.0224123, 0.0244148, 0.0264149, 0.0284123, 0.0304066, 0.0323975,
  0.0343848, 0.0363681, 0.0383472, 0.0403217, 0.0422913, 0.0442557,
  0.0462146, 0.0481677, 0.0501148, 0.0520554, 0.0539893, 0.0559163,
  0.0578359, 0.0597479, 0.061652, 0.0635479, 0.0654352, 0.0673138,
  0.0691832, 0.0710432, 0.0728935, 0.0747338, 0.0765638, 0.0783833,
  0.0801918, 0.0819892, 0.083775, 0.0855492, 0.0873113, 0.089061,
  0.0907981, 0.0925224, 0.0942334, 0.095931, 0.0976148, 0.0992846,
  0.10094, 0.102581, 0.104207, 0.105818, 0.107413, 0.108993, 0.110557,
  0.112105, 0.113636, 0.115151, 0.116649, 0.118129, 0.119592,
  0.121037, 0.122464, 0.123873, 0.125264, 0.126635, 0.127988,
  0.129322, 0.130636, 0.13193, 0.133205, 0.13446, 0.135694, 0.136907,
  0.1381, 0.139272, 0.140423, 0.141552, 0.142659, 0.143745, 0.144809,
  0.14585, 0.146869, 0.147865, 0.148839, 0.149789, 0.150717, 0.151621,
  0.152501, 0.153358, 0.154191, 0.155, 0.155784, 0.156545, 0.15728,
  0.157992, 0.158678, 0.159339, 0.159975, 0.160586, 0.161172,
  0.161732, 0.162266, 0.162775, 0.163258, 0.163715, 0.164145, 0.16455,
  0.164928, 0.16528, 0.165605, 0.165904, 0.166176, 0.166422, 0.16664,
  0.166832, 0.166996, 0.167134, 0.167244, 0.167328, 0.167384,
  0.167413, 0.167414, 0.167389, 0.167335, 0.167255, 0.167147,
  0.167011, 0.166848, 0.166658, 0.16644, 0.166195, 0.165922, 0.165622,
  0.165294, 0.164938, 0.164556, 0.164145, 0.163708, 0.163243, 0.16275,
  0.162231, 0.161684, 0.16111, 0.160509, 0.15988, 0.159225, 0.158543,
  0.157834, 0.157098, 0.156335, 0.155546, 0.15473, 0.153888, 0.153019,
  0.152124, 0.151203, 0.150257, 0.149284, 0.148285, 0.147261,
  0.146211, 0.145136, 0.144036, 0.14291, 0.14176, 0.140585, 0.139385,
  0.138161, 0.136912, 0.13564, 0.134343, 0.133023, 0.131679, 0.130312,
  0.128922, 0.127508, 0.126072, 0.124614, 0.123133, 0.121629,
  0.120104, 0.118558, 0.11699, 0.1154, 0.11379, 0.112159, 0.110507,
  0.108835, 0.107144, 0.105432, 0.103701, 0.101951, 0.100182,
  0.0983941, 0.0965879, 0.0947637, 0.0929217, 0.0910622, 0.0891854,
  0.0872917, 0.0853814, 0.0834548, 0.0815121, 0.0795537, 0.07758,
  0.0755912, 0.0735876, 0.0715696, 0.0695376, 0.0674917, 0.0654324,
  0.06336, 0.0612749, 0.0591774, 0.0570678, 0.0549465, 0.0528138,
  0.0506701, 0.0485157, 0.0463511, 0.0441766, 0.0419925, 0.0397992,
  0.0375971, 0.0353865, 0.0331679, 0.0309416, 0.0287079, 0.0264674,
  0.0242203, 0.021967, 0.019708, 0.0174436, 0.0151742, 0.0129003,
  0.0106221, 0.0083402, 0.00605486, 0.00376654, 0.00147564,
  -0.000817452, -0.00311232, -0.00540855, -0.00770574, -0.0100035,
  -0.0123014, -0.014599, -0.0168959, -0.0191917, -0.021486,
  -0.0237783, -0.0260684, -0.0283556, -0.0306397, -0.0329201,
  -0.0351966, -0.0374686, -0.0397357, -0.0419976, -0.0442538,
  -0.0465038, -0.0487474, -0.0509839, -0.0532131, -0.0554345,
  -0.0576477, -0.0598522, -0.0620477, -0.0642338, -0.0664099,
  -0.0685758, -0.0707309, -0.0728749, -0.0750074, -0.0771279,
  -0.0792361, -0.0813315, -0.0834137, -0.0854823, -0.0875369,
  -0.0895771, -0.0916025, -0.0936127, -0.0956073, -0.0975859,
  -0.0995481, -0.101493, -0.103422, -0.105332, -0.107225, -0.109099,
  -0.110955, -0.112791, -0.114608, -0.116406, -0.118183, -0.119939,
  -0.121674, -0.123388, -0.125081, -0.126751, -0.128399, -0.130024,
  -0.131626, -0.133204, -0.134759, -0.13629, -0.137796, -0.139277,
  -0.140733, -0.142164, -0.143569, -0.144948, -0.146301, -0.147627,
  -0.148926, -0.150197, -0.151441, -0.152657, -0.153845, -0.155005,
  -0.156135, -0.157237, -0.15831, -0.159353, -0.160366, -0.161349,
  -0.162302, -0.163225, -0.164116, -0.164977, -0.165806, -0.166604,
  -0.167371, -0.168105, -0.168808, -0.169478, -0.170116, -0.170721,
  -0.171294, -0.171833, -0.172339, -0.172812, -0.173252, -0.173658,
  -0.17403, -0.174368, -0.174672, -0.174942, -0.175178, -0.175379,
  -0.175546, -0.175678, -0.175775, -0.175838, -0.175866, -0.175859,
  -0.175816, -0.175739, -0.175627, -0.175479, -0.175297, -0.175079,
  -0.174826, -0.174537, -0.174213, -0.173854, -0.17346, -0.17303,
  -0.172565, -0.172065, -0.171529, -0.170958, -0.170353, -0.169712,
  -0.169036, -0.168325, -0.167579, -0.166798, -0.165983, -0.165133,
  -0.164248, -0.163329, -0.162376, -0.161388, -0.160367, -0.159311,
  -0.158222, -0.157099, -0.155943, -0.154754, -0.153531, -0.152275,
  -0.150987, -0.149666, -0.148313, -0.146928, -0.145511, -0.144062,
  -0.142581, -0.14107, -0.139527, -0.137954, -0.136351, -0.134717,
  -0.133053, -0.13136, -0.129637, -0.127886, -0.126106, -0.124297,
  -0.12246, -0.120596, -0.118704, -0.116785, -0.114839, -0.112867,
  -0.110869, -0.108845, -0.106796, -0.104722, -0.102624, -0.100501,
  -0.0983549, -0.0961853, -0.0939928, -0.0917778, -0.0895408,
  -0.0872821, -0.0850022, -0.0827016, -0.0803806, -0.0780398,
  -0.0756796, -0.0733005, -0.0709029, -0.0684873, -0.0660543,
  -0.0636042, -0.0611376, -0.058655, -0.0561568, -0.0536437,
  -0.051116, -0.0485743, -0.0460192, -0.0434512, -0.0408707,
  -0.0382784, -0.0356748, -0.0330604, -0.0304357, -0.0278014,
  -0.0251579, -0.0225059, -0.0198459, -0.0171784, -0.0145041,
  -0.0118235, -0.00913724, -0.00644583, -0.00374989, -0.00105,
  0.00165325, 0.00435926, 0.00706744, 0.00977718, 0.0124879, 0.015199,
  0.0179098, 0.0206197, 0.0233282, 0.0260347, 0.0287384, 0.0314388,
  0.0341353, 0.0368273, 0.0395141, 0.0421952, 0.0448698, 0.0475374,
  0.0501974, 0.052849, 0.0554918, 0.0581251, 0.0607483, 0.0633607,
  0.0659617, 0.0685507, 0.071127, 0.0736901, 0.0762394, 0.0787741,
  0.0812937, 0.0837976, 0.0862852, 0.0887558, 0.0912088, 0.0936436,
  0.0960596, 0.0984562, 0.100833, 0.103189, 0.105524, 0.107837,
  0.110127, 0.112395, 0.114639, 0.116858, 0.119053, 0.121223,
  0.123367, 0.125484, 0.127575, 0.129637, 0.131672, 0.133678,
  0.135654, 0.137601, 0.139517, 0.141403, 0.143257, 0.145079,
  0.146868, 0.148625, 0.150348, 0.152038, 0.153693, 0.155312,
  0.156897, 0.158445, 0.159958, 0.161433, 0.162871, 0.164271,
  0.165633, 0.166957, 0.168242, 0.169487, 0.170692, 0.171857,
  0.172981, 0.174065, 0.175107, 0.176107, 0.177065, 0.177981,
  0.178853, 0.179683, 0.180469, 0.181212, 0.18191, 0.182564, 0.183174,
  0.183738, 0.184257, 0.184731, 0.18516, 0.185542, 0.185878, 0.186168,
  0.186411, 0.186608, 0.186758, 0.18686, 0.186916, 0.186924, 0.186885,
  0.186798, 0.186663, 0.18648, 0.18625, 0.185971, 0.185645, 0.18527,
  0.184848, 0.184377, 0.183858, 0.183291, 0.182675, 0.182012, 0.1813,
  0.18054, 0.179733, 0.178877, 0.177974, 0.177022, 0.176024, 0.174977,
  0.173883, 0.172743, 0.171555, 0.17032, 0.169038, 0.16771, 0.166336,
  0.164915, 0.163449, 0.161938, 0.160381, 0.158779, 0.157132,
  0.155441, 0.153706, 0.151927, 0.150104, 0.148239, 0.146331,
  0.144381, 0.142389, 0.140355, 0.13828, 0.136165, 0.13401, 0.131815,
  0.12958, 0.127307, 0.124996, 0.122647, 0.120261, 0.117838, 0.115379,
  0.112885, 0.110356, 0.107792, 0.105194, 0.102564, 0.0999008,
  0.0972059, 0.0944797, 0.091723, 0.0889364, 0.0861205, 0.0832762,
  0.0804041, 0.0775048, 0.0745793, 0.071628, 0.068652, 0.0656518,
  0.0626283, 0.0595822, 0.0565144, 0.0534256, 0.0503166, 0.0471883,
  0.0440415, 0.0408771, 0.0376958, 0.0344986, 0.0312863, 0.0280597,
  0.0248199, 0.0215676, 0.0183037, 0.0150292, 0.011745, 0.00845203,
  0.00515115, 0.00184333, -0.00147048, -0.00478934, -0.00811229,
  -0.0114384, -0.0147666, -0.0180961, -0.0214257, -0.0247546,
  -0.0280817, -0.0314061, -0.0347268, -0.0380427, -0.0413529,
  -0.0446563, -0.047952, -0.0512389, -0.054516, -0.0577823,
  -0.0610368, -0.0642785, -0.0675063, -0.0707192, -0.0739162,
  -0.0770962, -0.0802583, -0.0834015, -0.0865246, -0.0896266,
  -0.0927067, -0.0957636, -0.0987964, -0.101804, -0.104786, -0.10774,
  -0.110667, -0.113564, -0.116431, -0.119267, -0.12207, -0.124841,
  -0.127577, -0.130278, -0.132944, -0.135572, -0.138162, -0.140713,
  -0.143224, -0.145695, -0.148124, -0.150509, -0.152852, -0.15515,
  -0.157402, -0.159608, -0.161767, -0.163877, -0.165939, -0.167951,
  -0.169913, -0.171823, -0.173681, -0.175485, -0.177236, -0.178932,
  -0.180573, -0.182158, -0.183686, -0.185156, -0.186568, -0.187922,
  -0.189215, -0.190448, -0.191621, -0.192731, -0.19378, -0.194766,
  -0.195688, -0.196547, -0.197341, -0.19807, -0.198734, -0.199331,
  -0.199863, -0.200327, -0.200725, -0.201054, -0.201316, -0.201509,
  -0.201633, -0.201689, -0.201675, -0.201591, -0.201437, -0.201214,
  -0.20092, -0.200555, -0.20012, -0.199614, -0.199037, -0.198389,
  -0.19767, -0.19688, -0.196019, -0.195086, -0.194083, -0.193008,
  -0.191862, -0.190646, -0.189359, -0.188001, -0.186573, -0.185075,
  -0.183507, -0.181869, -0.180162, -0.178386, -0.176541, -0.174628,
  -0.172647, -0.170599, -0.168483, -0.166301, -0.164053, -0.161739,
  -0.159361, -0.156918, -0.154412, -0.151842, -0.14921, -0.146517,
  -0.143762, -0.140948, -0.138074, -0.135141, -0.132151, -0.129103,
  -0.126, -0.122842, -0.11963, -0.116364, -0.113047, -0.109679,
  -0.10626, -0.102793, -0.0992774, -0.0957156, -0.0921082, -0.0884565,
  -0.0847618, -0.0810252, -0.077248, -0.0734315, -0.0695771,
  -0.065686, -0.0617596, -0.0577994, -0.0538067, -0.049783,
  -0.0457297, -0.0416483, -0.0375403, -0.0334072, -0.0292506,
  -0.025072, -0.020873, -0.0166553, -0.0124204, -0.00816997,
  -0.00390571, 0.000370714, 0.00465761, 0.00895327, 0.013256,
  0.0175639, 0.0218754, 0.0261886, 0.0305018, 0.0348132, 0.0391208,
  0.043423, 0.0477178, 0.0520035, 0.0562781, 0.0605397, 0.0647866,
  0.0690167, 0.0732283, 0.0774193, 0.081588, 0.0857323, 0.0898503,
  0.0939402, 0.098, 0.102028, 0.106022, 0.109979, 0.1139, 0.11778,
  0.121618, 0.125413, 0.129163, 0.132865, 0.136518, 0.140119,
  0.143667, 0.14716, 0.150597, 0.153974, 0.157291, 0.160545, 0.163734,
  0.166858, 0.169914, 0.172899, 0.175814, 0.178655, 0.18142, 0.184109,
  0.18672, 0.18925, 0.191699, 0.194064, 0.196344, 0.198538, 0.200643,
  0.202659, 0.204583, 0.206415, 0.208152, 0.209795, 0.21134, 0.212787,
  0.214135, 0.215382, 0.216527, 0.217568, 0.218506, 0.219338,
  0.220064, 0.220682, 0.221192, 0.221592, 0.221882, 0.222062,
  0.222129, 0.222083, 0.221925, 0.221652, 0.221265, 0.220762,
  0.220145, 0.219411, 0.218561, 0.217594, 0.21651, 0.215309, 0.213991,
  0.212556, 0.211003, 0.209333, 0.207546, 0.205642, 0.203621,
  0.201484, 0.19923, 0.196861, 0.194377, 0.191778, 0.189065, 0.186239,
  0.1833, 0.18025, 0.177089, 0.173818, 0.170438, 0.166951, 0.163358,
  0.159659, 0.155857, 0.151952, 0.147947, 0.143842, 0.139639,
  0.135341, 0.130948, 0.126464, 0.121888, 0.117225, 0.112475,
  0.107641, 0.102726, 0.0977302, 0.0926577, 0.0875104, 0.0822909,
  0.0770018, 0.0716458, 0.0662255, 0.0607437, 0.0552035, 0.0496076,
  0.0439592, 0.0382613, 0.032517, 0.0267296, 0.0209024, 0.0150387,
  0.0091419, 0.00321549, -0.00273699, -0.00871196, -0.0147058,
  -0.0207147, -0.026735, -0.0327628, -0.0387942, -0.0448255,
  -0.0508525, -0.0568712, -0.0628777, -0.0688677, -0.0748371,
  -0.0807818, -0.0866975, -0.09258, -0.0984249, -0.104228, -0.109985,
  -0.115691, -0.121342, -0.126934, -0.132462, -0.137921, -0.143308,
  -0.148617, -0.153845, -0.158986, -0.164037, -0.168992, -0.173847,
  -0.178599, -0.183241, -0.187771, -0.192183, -0.196473, -0.200636,
  -0.204669, -0.208567, -0.212326, -0.215941, -0.219408, -0.222724,
  -0.225884, -0.228883, -0.231719, -0.234388, -0.236884, -0.239206,
  -0.241348, -0.243308, -0.245082, -0.246666, -0.248058, -0.249254,
  -0.250251, -0.251046, -0.251636, -0.252019, -0.252192, -0.252152,
  -0.251897, -0.251426, -0.250735, -0.249824, -0.24869, -0.247332,
  -0.245748, -0.243938, -0.2419, -0.239633, -0.237138, -0.234412,
  -0.231457, -0.228272, -0.224857, -0.221212, -0.217339, -0.213238,
  -0.20891, -0.204356, -0.199578, -0.194578, -0.189358, -0.183919,
  -0.178265, -0.172398, -0.166322, -0.160039, -0.153553, -0.146869,
  -0.139989, -0.132919, -0.125664, -0.118228, -0.110617, -0.102836,
  -0.0948908, -0.0867882, -0.0785344, -0.0701362, -0.0616007,
  -0.0529353, -0.0441477, -0.0352459, -0.0262382, -0.0171333,
  -0.00793998, 0.00133242, 0.0106744, 0.0200761, 0.0295274, 0.0390179,
  0.0485368, 0.0580731, 0.0676156, 0.0771525, 0.0866721, 0.0961622,
  0.10561, 0.115004, 0.12433, 0.133576, 0.142727, 0.151771, 0.160693,
  0.169479, 0.178116, 0.186589, 0.194882, 0.202982, 0.210873,
  0.218541, 0.22597, 0.233145, 0.24005, 0.246671, 0.252992, 0.258997,
  0.264672, 0.27, 0.274966, 0.279556, 0.283753, 0.287543, 0.290912,
  0.293844, 0.296324, 0.29834, 0.299877, 0.300921, 0.30146, 0.301481,
  0.30097, 0.299918, 0.298311, 0.296141, 0.293396, 0.290068, 0.286148,
  0.281628, 0.276501, 0.270761, 0.264403, 0.257424, 0.24982, 0.24159,
  0.232732, 0.223249, 0.213142, 0.202415, 0.191073, 0.179123,
  0.166574, 0.153436, 0.139721, 0.125443, 0.110619, 0.0952678,
  0.0794096, 0.0630679, 0.0462684, 0.0290395, 0.0114121, -0.0065796,
  -0.0248988, -0.0435053, -0.0623559, -0.0814039, -0.100599,
  -0.119887, -0.139211, -0.158509, -0.177715, -0.196758, -0.215565,
  -0.234056, -0.252147, -0.269748, -0.286767, -0.303103, -0.31865,
  -0.333299, -0.346932, -0.359425, -0.37065, -0.38047, -0.388743,
  -0.395317, -0.400035, -0.402732, -0.403236, -0.401364, -0.396927,
  -0.389727, -0.379556, -0.366198, -0.349427, -0.329006, -0.304689,
  -0.276219, -0.243329, -0.20574, -0.163161, -0.11529, -0.0618121,
  -0.00239972, 0.0632874, 0.135603, 0.214915, 0.301606, 0.396072,
  0.498724, 0.609992, 0.730317, 0.860161, 1}; const G4double
  G4NeutronHPFastLegendre::i29[6001] = {0, -0.000309734, -0.000574534,
  -0.000797653, -0.000982186, -0.00113108, -0.00124713, -0.001333,
  -0.00139121, -0.00142417, -0.00143413, -0.00142325, -0.00139357,
  -0.00134701, -0.00128537, -0.00121039, -0.00112367, -0.00102673,
  -0.000920997, -0.000807817, -0.000688445, -0.000564058,
  -0.000435756, -0.000304565, -0.000171441, -3.72699e-05, 9.71236e-05,
  0.000230979, 0.000363593, 0.00049432, 0.000622569, 0.000747798,
  0.000869515, 0.000987276, 0.00110068, 0.00120936, 0.00131301,
  0.00141135, 0.00150412, 0.00159111, 0.00167216, 0.00174711,
  0.00181584, 0.00187825, 0.00193429, 0.00198392, 0.0020271,
  0.00206385, 0.00209418, 0.00211813, 0.00213577, 0.00214716,
  0.0021524, 0.00215158, 0.00214483, 0.00213227, 0.00211403,
  0.00209027, 0.00206114, 0.00202682, 0.00198746, 0.00194325,
  0.00189437, 0.00184102, 0.00178339, 0.00172167, 0.00165607,
  0.00158679, 0.00151404, 0.00143803, 0.00135896, 0.00127704,
  0.00119248, 0.00110549, 0.00101628, 0.00092505, 0.000832011,
  0.000737365, 0.000641312, 0.000544051, 0.000445778, 0.000346686,
  0.000246965, 0.000146802, 4.63779e-05, -5.41272e-05, -0.000154539,
  -0.000254686, -0.000354403, -0.000453527, -0.000551902,
  -0.000649374, -0.000745795, -0.000841023, -0.000934919, -0.00102735,
  -0.00111819, -0.00120731, -0.0012946, -0.00137994, -0.00146323,
  -0.00154435, -0.00162323, -0.00169975, -0.00177385, -0.00184542,
  -0.0019144, -0.00198072, -0.00204431, -0.00210509, -0.00216303,
  -0.00221806, -0.00227015, -0.00231923, -0.00236528, -0.00240827,
  -0.00244816, -0.00248493, -0.00251856, -0.00254904, -0.00257634,
  -0.00260047, -0.00262142, -0.00263919, -0.00265378, -0.0026652,
  -0.00267347, -0.00267859, -0.00268059, -0.00267949, -0.00267531,
  -0.00266807, -0.00265782, -0.00264459, -0.0026284, -0.00260931,
  -0.00258735, -0.00256257, -0.00253501, -0.00250473, -0.00247177,
  -0.00243619, -0.00239804, -0.00235739, -0.00231429, -0.0022688,
  -0.00222098, -0.0021709, -0.00211863, -0.00206423, -0.00200777,
  -0.00194932, -0.00188895, -0.00182674, -0.00176274, -0.00169704,
  -0.00162971, -0.00156083, -0.00149046, -0.00141869, -0.0013456,
  -0.00127124, -0.00119572, -0.00111909, -0.00104144, -0.000962838,
  -0.00088337, -0.000803108, -0.000722128, -0.000640508, -0.000558321,
  -0.000475644, -0.000392552, -0.000309119, -0.00022542, -0.000141526,
  -5.75118e-05, 2.65515e-05, 0.000110593, 0.000194541, 0.000278327,
  0.000361883, 0.000445139, 0.00052803, 0.00061049, 0.000692453,
  0.000773857, 0.000854638, 0.000934735, 0.00101409, 0.00109264,
  0.00117033, 0.0012471, 0.0013229, 0.00139767, 0.00147136,
  0.00154393, 0.00161531, 0.00168546, 0.00175434, 0.00182189,
  0.00188808, 0.00195286, 0.00201619, 0.00207803, 0.00213834,
  0.00219708, 0.00225423, 0.00230973, 0.00236357, 0.00241571,
  0.00246613, 0.00251478, 0.00256166, 0.00260672, 0.00264996,
  0.00269134, 0.00273085, 0.00276846, 0.00280416, 0.00283794,
  0.00286977, 0.00289966, 0.00292757, 0.00295351, 0.00297746,
  0.00299942, 0.00301938, 0.00303733, 0.00305328, 0.00306721,
  0.00307914, 0.00308905, 0.00309696, 0.00310287, 0.00310677,
  0.00310868, 0.0031086, 0.00310653, 0.0031025, 0.00309651,
  0.00308857, 0.0030787, 0.0030669, 0.00305319, 0.0030376, 0.00302013,
  0.0030008, 0.00297964, 0.00295666, 0.00293188, 0.00290533,
  0.00287703, 0.002847, 0.00281527, 0.00278185, 0.00274679, 0.0027101,
  0.00267182, 0.00263196, 0.00259057, 0.00254766, 0.00250328,
  0.00245745, 0.0024102, 0.00236156, 0.00231158, 0.00226027,
  0.00220768, 0.00215384, 0.00209879, 0.00204255, 0.00198518,
  0.00192669, 0.00186713, 0.00180653, 0.00174494, 0.00168239,
  0.00161891, 0.00155455, 0.00148934, 0.00142332, 0.00135653,
  0.00128901, 0.0012208, 0.00115193, 0.00108244, 0.00101238,
  0.000941788, 0.000870694, 0.00079914, 0.000727167, 0.000654813,
  0.000582117, 0.000509119, 0.000435856, 0.000362368, 0.000288694,
  0.000214871, 0.000140938, 6.69338e-05, -7.10478e-06, -8.11397e-05,
  -0.000155134, -0.000229049, -0.00030285, -0.000376498, -0.000449959,
  -0.000523196, -0.000596173, -0.000668855, -0.000741207,
  -0.000813195, -0.000884784, -0.00095594, -0.00102663, -0.00109682,
  -0.00116648, -0.00123558, -0.00130408, -0.00137196, -0.00143918,
  -0.00150571, -0.00157153, -0.0016366, -0.00170089, -0.00176439,
  -0.00182705, -0.00188886, -0.00194978, -0.0020098, -0.00206888,
  -0.002127, -0.00218414, -0.00224027, -0.00229537, -0.00234942,
  -0.00240239, -0.00245427, -0.00250503, -0.00255466, -0.00260313,
  -0.00265043, -0.00269654, -0.00274144, -0.00278511, -0.00282754,
  -0.00286872, -0.00290862, -0.00294723, -0.00298455, -0.00302055,
  -0.00305522, -0.00308856, -0.00312055, -0.00315119, -0.00318045,
  -0.00320834, -0.00323484, -0.00325995, -0.00328366, -0.00330596,
  -0.00332684, -0.00334631, -0.00336436, -0.00338098, -0.00339617,
  -0.00340993, -0.00342225, -0.00343314, -0.00344259, -0.0034506,
  -0.00345717, -0.00346231, -0.00346601, -0.00346828, -0.00346911,
  -0.00346853, -0.00346651, -0.00346308, -0.00345823, -0.00345198,
  -0.00344432, -0.00343527, -0.00342482, -0.003413, -0.0033998,
  -0.00338523, -0.00336932, -0.00335205, -0.00333345, -0.00331352,
  -0.00329228, -0.00326973, -0.0032459, -0.00322078, -0.0031944,
  -0.00316677, -0.0031379, -0.0031078, -0.0030765, -0.003044,
  -0.00301032, -0.00297548, -0.00293948, -0.00290236, -0.00286413,
  -0.00282479, -0.00278438, -0.0027429, -0.00270038, -0.00265684,
  -0.00261229, -0.00256675, -0.00252025, -0.00247279, -0.00242441,
  -0.00237512, -0.00232495, -0.0022739, -0.00222201, -0.0021693,
  -0.00211578, -0.00206148, -0.00200642, -0.00195062, -0.0018941,
  -0.00183689, -0.00177901, -0.00172048, -0.00166132, -0.00160156,
  -0.00154122, -0.00148033, -0.00141889, -0.00135695, -0.00129452,
  -0.00123162, -0.00116829, -0.00110453, -0.00104039, -0.00097587,
  -0.000911006, -0.00084582, -0.000780335, -0.000714575, -0.000648563,
  -0.000582323, -0.000515879, -0.000449255, -0.000382473,
  -0.000315559, -0.000248535, -0.000181424, -0.000114251,
  -4.70377e-05, 2.01915e-05, 8.74138e-05, 0.000154606, 0.000221746,
  0.000288809, 0.000355774, 0.000422618, 0.000489318, 0.000555853,
  0.000622199, 0.000688334, 0.000754238, 0.000819888, 0.000885262,
  0.000950339, 0.0010151, 0.00107952, 0.00114358, 0.00120726,
  0.00127054, 0.0013334, 0.00139581, 0.00145777, 0.00151924,
  0.00158022, 0.00164068, 0.0017006, 0.00175996, 0.00181875,
  0.00187694, 0.00193453, 0.00199149, 0.0020478, 0.00210345,
  0.00215842, 0.00221269, 0.00226626, 0.00231909, 0.00237119,
  0.00242252, 0.00247308, 0.00252286, 0.00257183, 0.00261998,
  0.00266731, 0.00271379, 0.00275941, 0.00280416, 0.00284804,
  0.00289101, 0.00293308, 0.00297424, 0.00301446, 0.00305374,
  0.00309208, 0.00312945, 0.00316585, 0.00320127, 0.00323571,
  0.00326914, 0.00330157, 0.00333298, 0.00336337, 0.00339273,
  0.00342105, 0.00344833, 0.00347455, 0.00349972, 0.00352383,
  0.00354687, 0.00356883, 0.00358972, 0.00360952, 0.00362824,
  0.00364586, 0.0036624, 0.00367783, 0.00369217, 0.0037054,
  0.00371753, 0.00372855, 0.00373846, 0.00374727, 0.00375497,
  0.00376155, 0.00376703, 0.0037714, 0.00377466, 0.00377681,
  0.00377785, 0.00377779, 0.00377662, 0.00377435, 0.00377099,
  0.00376653, 0.00376097, 0.00375432, 0.00374659, 0.00373778,
  0.00372789, 0.00371692, 0.00370489, 0.00369179, 0.00367764,
  0.00366244, 0.00364618, 0.00362889, 0.00361057, 0.00359122,
  0.00357085, 0.00354947, 0.00352708, 0.0035037, 0.00347934,
  0.00345399, 0.00342767, 0.00340039, 0.00337215, 0.00334298,
  0.00331287, 0.00328183, 0.00324988, 0.00321703, 0.00318329,
  0.00314866, 0.00311316, 0.0030768, 0.00303959, 0.00300155,
  0.00296268, 0.00292299, 0.00288251, 0.00284123, 0.00279918,
  0.00275637, 0.0027128, 0.00266849, 0.00262346, 0.00257772,
  0.00253128, 0.00248416, 0.00243636, 0.00238791, 0.00233881,
  0.00228908, 0.00223874, 0.0021878, 0.00213628, 0.00208418,
  0.00203153, 0.00197834, 0.00192461, 0.00187038, 0.00181565,
  0.00176044, 0.00170477, 0.00164864, 0.00159208, 0.0015351,
  0.00147772, 0.00141994, 0.0013618, 0.0013033, 0.00124445,
  0.00118529, 0.00112581, 0.00106604, 0.00100599, 0.000945686,
  0.000885133, 0.00082435, 0.000763355, 0.000702162, 0.000640788,
  0.000579249, 0.000517562, 0.000455741, 0.000393804, 0.000331765,
  0.000269642, 0.00020745, 0.000145205, 8.29237e-05, 2.06209e-05,
  -4.16871e-05, -0.000103984, -0.000166256, -0.000228484,
  -0.000290656, -0.000352754, -0.000414763, -0.000476667,
  -0.000538452, -0.000600102, -0.000661601, -0.000722935,
  -0.000784088, -0.000845046, -0.000905793, -0.000966315, -0.0010266,
  -0.00108662, -0.00114638, -0.00120585, -0.00126503, -0.00132389,
  -0.00138243, -0.00144063, -0.00149847, -0.00155594, -0.00161303,
  -0.00166973, -0.00172602, -0.00178189, -0.00183732, -0.00189231,
  -0.00194683, -0.00200088, -0.00205445, -0.00210752, -0.00216008,
  -0.00221211, -0.00226361, -0.00231457, -0.00236497, -0.0024148,
  -0.00246405, -0.00251271, -0.00256076, -0.00260821, -0.00265503,
  -0.00270122, -0.00274676, -0.00279165, -0.00283587, -0.00287943,
  -0.0029223, -0.00296447, -0.00300595, -0.00304672, -0.00308676,
  -0.00312608, -0.00316466, -0.0032025, -0.00323959, -0.00327592,
  -0.00331148, -0.00334627, -0.00338027, -0.00341349, -0.00344591,
  -0.00347752, -0.00350833, -0.00353833, -0.0035675, -0.00359585,
  -0.00362337, -0.00365004, -0.00367588, -0.00370087, -0.003725,
  -0.00374828, -0.0037707, -0.00379226, -0.00381294, -0.00383276,
  -0.00385169, -0.00386975, -0.00388692, -0.00390321, -0.00391861,
  -0.00393313, -0.00394674, -0.00395947, -0.00397129, -0.00398222,
  -0.00399225, -0.00400138, -0.00400961, -0.00401693, -0.00402336,
  -0.00402887, -0.00403349, -0.0040372, -0.00404001, -0.00404191,
  -0.00404291, -0.00404301, -0.00404221, -0.00404051, -0.00403792,
  -0.00403442, -0.00403004, -0.00402475, -0.00401858, -0.00401152,
  -0.00400358, -0.00399475, -0.00398505, -0.00397446, -0.00396301,
  -0.00395068, -0.00393749, -0.00392344, -0.00390852, -0.00389276,
  -0.00387614, -0.00385868, -0.00384038, -0.00382125, -0.00380128,
  -0.00378049, -0.00375888, -0.00373646, -0.00371322, -0.00368919,
  -0.00366436, -0.00363874, -0.00361233, -0.00358515, -0.0035572,
  -0.00352849, -0.00349902, -0.0034688, -0.00343783, -0.00340614,
  -0.00337371, -0.00334057, -0.00330671, -0.00327216, -0.0032369,
  -0.00320096, -0.00316434, -0.00312705, -0.0030891, -0.00305049,
  -0.00301125, -0.00297136, -0.00293085, -0.00288972, -0.00284799,
  -0.00280566, -0.00276274, -0.00271924, -0.00267517, -0.00263054,
  -0.00258536, -0.00253964, -0.00249339, -0.00244662, -0.00239935,
  -0.00235157, -0.00230331, -0.00225457, -0.00220536, -0.0021557,
  -0.00210559, -0.00205504, -0.00200408, -0.00195269, -0.00190091,
  -0.00184873, -0.00179618, -0.00174326, -0.00168998, -0.00163635,
  -0.00158239, -0.0015281, -0.00147351, -0.00141861, -0.00136342,
  -0.00130796, -0.00125223, -0.00119624, -0.00114001, -0.00108355,
  -0.00102688, -0.00096999, -0.000912907, -0.000855641, -0.000798201,
  -0.000740601, -0.000682852, -0.000624965, -0.000566953,
  -0.000508827, -0.000450599, -0.000392281, -0.000333884, -0.00027542,
  -0.000216901, -0.000158339, -9.97457e-05, -4.11322e-05, 1.74895e-05,
  7.61078e-05, 0.000134711, 0.000193287, 0.000251826, 0.000310314,
  0.000368741, 0.000427095, 0.000485365, 0.00054354, 0.000601607,
  0.000659556, 0.000717375, 0.000775053, 0.000832579, 0.000889942,
  0.000947131, 0.00100413, 0.00106094, 0.00111754, 0.00117392,
  0.00123008, 0.00128599, 0.00134165, 0.00139706, 0.00145219,
  0.00150704, 0.0015616, 0.00161585, 0.00166979, 0.00172341,
  0.0017767, 0.00182965, 0.00188224, 0.00193447, 0.00198632,
  0.0020378, 0.00208888, 0.00213957, 0.00218984, 0.0022397,
  0.00228912, 0.00233811, 0.00238665, 0.00243474, 0.00248236,
  0.00252951, 0.00257618, 0.00262236, 0.00266804, 0.00271322,
  0.00275788, 0.00280202, 0.00284563, 0.0028887, 0.00293123,
  0.0029732, 0.00301461, 0.00305545, 0.00309572, 0.00313541,
  0.00317451, 0.00321301, 0.00325091, 0.00328821, 0.00332488,
  0.00336094, 0.00339636, 0.00343116, 0.00346531, 0.00349882,
  0.00353167, 0.00356387, 0.00359541, 0.00362628, 0.00365648,
  0.003686, 0.00371483, 0.00374298, 0.00377044, 0.0037972, 0.00382326,
  0.00384862, 0.00387327, 0.0038972, 0.00392042, 0.00394292,
  0.00396469, 0.00398574, 0.00400605, 0.00402564, 0.00404449,
  0.00406259, 0.00407996, 0.00409658, 0.00411246, 0.00412758,
  0.00414196, 0.00415558, 0.00416845, 0.00418056, 0.00419191,
  0.00420251, 0.00421234, 0.00422141, 0.00422972, 0.00423726,
  0.00424404, 0.00425006, 0.00425531, 0.00425979, 0.00426351,
  0.00426646, 0.00426864, 0.00427006, 0.00427072, 0.00427061,
  0.00426974, 0.0042681, 0.0042657, 0.00426254, 0.00425862,
  0.00425394, 0.0042485, 0.00424231, 0.00423536, 0.00422767,
  0.00421922, 0.00421002, 0.00420008, 0.0041894, 0.00417797,
  0.00416581, 0.00415291, 0.00413927, 0.00412491, 0.00410982,
  0.00409401, 0.00407748, 0.00406023, 0.00404227, 0.0040236,
  0.00400423, 0.00398415, 0.00396338, 0.00394191, 0.00391976,
  0.00389692, 0.0038734, 0.00384921, 0.00382435, 0.00379882,
  0.00377263, 0.00374578, 0.00371829, 0.00369015, 0.00366137,
  0.00363196, 0.00360191, 0.00357125, 0.00353997, 0.00350808,
  0.00347558, 0.00344248, 0.00340879, 0.00337452, 0.00333966,
  0.00330423, 0.00326823, 0.00323168, 0.00319456, 0.00315691,
  0.00311871, 0.00307997, 0.00304072, 0.00300094, 0.00296065,
  0.00291985, 0.00287856, 0.00283678, 0.00279452, 0.00275178,
  0.00270857, 0.00266491, 0.00262079, 0.00257623, 0.00253123,
  0.0024858, 0.00243996, 0.0023937, 0.00234704, 0.00229998,
  0.00225253, 0.00220471, 0.00215651, 0.00210795, 0.00205904,
  0.00200978, 0.00196019, 0.00191026, 0.00186002, 0.00180946,
  0.0017586, 0.00170745, 0.00165602, 0.0016043, 0.00155232,
  0.00150008, 0.00144759, 0.00139486, 0.0013419, 0.00128871,
  0.00123532, 0.00118171, 0.00112791, 0.00107393, 0.00101976,
  0.000965429, 0.000910936, 0.000856293, 0.000801509, 0.000746592,
  0.000691553, 0.0006364, 0.000581142, 0.000525788, 0.000470348,
  0.000414831, 0.000359246, 0.000303602, 0.000247908, 0.000192173,
  0.000136408, 8.06195e-05, 2.48182e-05, -3.09871e-05, -8.67873e-05,
  -0.000142573, -0.000198336, -0.000254067, -0.000309756,
  -0.000365394, -0.000420974, -0.000476485, -0.000531919,
  -0.000587266, -0.000642518, -0.000697667, -0.000752702,
  -0.000807616, -0.000862399, -0.000917043, -0.00097154, -0.00102588,
  -0.00108005, -0.00113405, -0.00118787, -0.0012415, -0.00129493,
  -0.00134815, -0.00140115, -0.00145393, -0.00150647, -0.00155878,
  -0.00161084, -0.00166263, -0.00171417, -0.00176542, -0.0018164,
  -0.00186709, -0.00191748, -0.00196756, -0.00201734, -0.00206679,
  -0.00211591, -0.0021647, -0.00221314, -0.00226123, -0.00230897,
  -0.00235634, -0.00240334, -0.00244995, -0.00249618, -0.00254202,
  -0.00258745, -0.00263248, -0.00267709, -0.00272128, -0.00276504,
  -0.00280837, -0.00285125, -0.00289369, -0.00293567, -0.0029772,
  -0.00301825, -0.00305884, -0.00309894, -0.00313856, -0.00317769,
  -0.00321633, -0.00325446, -0.00329208, -0.00332919, -0.00336579,
  -0.00340185, -0.00343739, -0.0034724, -0.00350686, -0.00354078,
  -0.00357415, -0.00360697, -0.00363923, -0.00367092, -0.00370205,
  -0.0037326, -0.00376258, -0.00379198, -0.00382079, -0.00384901,
  -0.00387664, -0.00390367, -0.0039301, -0.00395592, -0.00398114,
  -0.00400574, -0.00402973, -0.0040531, -0.00407585, -0.00409798,
  -0.00411948, -0.00414034, -0.00416058, -0.00418017, -0.00419913,
  -0.00421745, -0.00423512, -0.00425215, -0.00426853, -0.00428426,
  -0.00429934, -0.00431377, -0.00432754, -0.00434065, -0.0043531,
  -0.00436489, -0.00437602, -0.00438649, -0.00439629, -0.00440543,
  -0.0044139, -0.00442171, -0.00442884, -0.00443531, -0.00444111,
  -0.00444624, -0.0044507, -0.00445449, -0.00445761, -0.00446006,
  -0.00446184, -0.00446295, -0.00446338, -0.00446315, -0.00446225,
  -0.00446068, -0.00445845, -0.00445554, -0.00445197, -0.00444774,
  -0.00444284, -0.00443727, -0.00443105, -0.00442416, -0.00441662,
  -0.00440841, -0.00439955, -0.00439004, -0.00437987, -0.00436906,
  -0.00435759, -0.00434548, -0.00433272, -0.00431933, -0.00430529,
  -0.00429061, -0.0042753, -0.00425936, -0.00424279, -0.00422559,
  -0.00420777, -0.00418933, -0.00417027, -0.00415059, -0.00413031,
  -0.00410942, -0.00408792, -0.00406582, -0.00404312, -0.00401984,
  -0.00399596, -0.00397149, -0.00394645, -0.00392082, -0.00389463,
  -0.00386786, -0.00384053, -0.00381263, -0.00378418, -0.00375518,
  -0.00372563, -0.00369553, -0.0036649, -0.00363374, -0.00360204,
  -0.00356982, -0.00353709, -0.00350384, -0.00347008, -0.00343581,
  -0.00340105, -0.0033658, -0.00333006, -0.00329383, -0.00325713,
  -0.00321996, -0.00318233, -0.00314423, -0.00310568, -0.00306668,
  -0.00302725, -0.00298737, -0.00294706, -0.00290633, -0.00286519,
  -0.00282363, -0.00278166, -0.00273929, -0.00269654, -0.00265339,
  -0.00260986, -0.00256597, -0.0025217, -0.00247707, -0.00243209,
  -0.00238676, -0.00234109, -0.00229508, -0.00224875, -0.0022021,
  -0.00215513, -0.00210786, -0.00206028, -0.00201241, -0.00196426,
  -0.00191583, -0.00186712, -0.00181815, -0.00176892, -0.00171944,
  -0.00166972, -0.00161976, -0.00156957, -0.00151916, -0.00146853,
  -0.0014177, -0.00136666, -0.00131544, -0.00126402, -0.00121243,
  -0.00116067, -0.00110875, -0.00105666, -0.00100443, -0.000952061,
  -0.000899555, -0.000846923, -0.000794172, -0.000741309,
  -0.000688342, -0.000635279, -0.000582126, -0.000528893,
  -0.000475585, -0.00042221, -0.000368777, -0.000315291, -0.000261762,
  -0.000208196, -0.000154602, -0.000100985, -4.73547e-05, 6.28245e-06,
  5.99187e-05, 0.000113547, 0.000167159, 0.000220748, 0.000274306,
  0.000327826, 0.000381301, 0.000434723, 0.000488084, 0.000541378,
  0.000594597, 0.000647734, 0.000700781, 0.000753731, 0.000806577,
  0.000859312, 0.000911928, 0.000964418, 0.00101678, 0.00106899,
  0.00112106, 0.00117298, 0.00122473, 0.00127632, 0.00132773,
  0.00137895, 0.00142999, 0.00148083, 0.00153147, 0.0015819,
  0.00163211, 0.0016821, 0.00173186, 0.00178138, 0.00183066,
  0.00187968, 0.00192845, 0.00197696, 0.00202519, 0.00207316,
  0.00212083, 0.00216822, 0.00221531, 0.00226211, 0.00230859,
  0.00235476, 0.00240061, 0.00244613, 0.00249132, 0.00253617,
  0.00258068, 0.00262484, 0.00266864, 0.00271208, 0.00275516,
  0.00279786, 0.00284018, 0.00288212, 0.00292367, 0.00296482,
  0.00300557, 0.00304592, 0.00308586, 0.00312538, 0.00316448,
  0.00320315, 0.0032414, 0.0032792, 0.00331657, 0.00335349,
  0.00338996, 0.00342597, 0.00346152, 0.00349661, 0.00353123,
  0.00356538, 0.00359905, 0.00363224, 0.00366494, 0.00369715,
  0.00372887, 0.00376009, 0.0037908, 0.00382101, 0.00385071,
  0.0038799, 0.00390857, 0.00393672, 0.00396434, 0.00399144,
  0.00401801, 0.00404404, 0.00406953, 0.00409448, 0.00411889,
  0.00414276, 0.00416607, 0.00418883, 0.00421103, 0.00423268,
  0.00425377, 0.00427429, 0.00429425, 0.00431364, 0.00433246,
  0.00435071, 0.00436838, 0.00438548, 0.004402, 0.00441794,
  0.00443329, 0.00444806, 0.00446225, 0.00447585, 0.00448886,
  0.00450128, 0.0045131, 0.00452434, 0.00453498, 0.00454503,
  0.00455447, 0.00456333, 0.00457158, 0.00457924, 0.00458629,
  0.00459275, 0.0045986, 0.00460385, 0.00460851, 0.00461255, 0.004616,
  0.00461885, 0.00462109, 0.00462273, 0.00462376, 0.0046242,
  0.00462403, 0.00462326, 0.00462189, 0.00461992, 0.00461734,
  0.00461417, 0.0046104, 0.00460603, 0.00460106, 0.0045955,
  0.00458933, 0.00458258, 0.00457523, 0.00456729, 0.00455876,
  0.00454964, 0.00453993, 0.00452963, 0.00451875, 0.00450728,
  0.00449523, 0.00448261, 0.0044694, 0.00445562, 0.00444127,
  0.00442634, 0.00441084, 0.00439478, 0.00437815, 0.00436096,
  0.00434321, 0.0043249, 0.00430603, 0.00428661, 0.00426664,
  0.00424613, 0.00422507, 0.00420347, 0.00418133, 0.00415866,
  0.00413546, 0.00411172, 0.00408746, 0.00406268, 0.00403738,
  0.00401156, 0.00398524, 0.0039584, 0.00393106, 0.00390322,
  0.00387488, 0.00384605, 0.00381673, 0.00378692, 0.00375663,
  0.00372586, 0.00369463, 0.00366292, 0.00363074, 0.00359811,
  0.00356502, 0.00353148, 0.00349749, 0.00346306, 0.00342818,
  0.00339288, 0.00335714, 0.00332099, 0.00328441, 0.00324741,
  0.00321001, 0.0031722, 0.00313399, 0.00309539, 0.00305639,
  0.00301701, 0.00297725, 0.00293712, 0.00289662, 0.00285575,
  0.00281452, 0.00277294, 0.00273101, 0.00268873, 0.00264612,
  0.00260318, 0.00255991, 0.00251632, 0.00247242, 0.0024282,
  0.00238368, 0.00233886, 0.00229375, 0.00224836, 0.00220268,
  0.00215672, 0.0021105, 0.00206401, 0.00201727, 0.00197027,
  0.00192303, 0.00187555, 0.00182783, 0.00177989, 0.00173173,
  0.00168335, 0.00163476, 0.00158596, 0.00153697, 0.00148779,
  0.00143843, 0.00138888, 0.00133916, 0.00128928, 0.00123924,
  0.00118904, 0.0011387, 0.00108821, 0.00103759, 0.000986846,
  0.000935976, 0.00088499, 0.000833895, 0.000782696, 0.000731402,
  0.000680016, 0.000628547, 0.000577, 0.000525382, 0.0004737,
  0.000421959, 0.000370166, 0.000318327, 0.00026645, 0.000214539,
  0.000162602, 0.000110646, 5.86751e-05, 6.69756e-06, -4.52808e-05,
  -9.72537e-05, -0.000149215, -0.000201157, -0.000253075,
  -0.000304962, -0.000356811, -0.000408617, -0.000460373,
  -0.000512072, -0.000563709, -0.000615277, -0.000666769, -0.00071818,
  -0.000769504, -0.000820733, -0.000871862, -0.000922885,
  -0.000973795, -0.00102459, -0.00107525, -0.00112579, -0.00117619,
  -0.00122644, -0.00127655, -0.0013265, -0.00137629, -0.00142591,
  -0.00147536, -0.00152463, -0.00157372, -0.00162261, -0.00167131,
  -0.0017198, -0.00176809, -0.00181616, -0.00186401, -0.00191164,
  -0.00195903, -0.00200619, -0.0020531, -0.00209977, -0.00214618,
  -0.00219234, -0.00223822, -0.00228384, -0.00232919, -0.00237425,
  -0.00241902, -0.00246351, -0.0025077, -0.00255158, -0.00259516,
  -0.00263842, -0.00268137, -0.002724, -0.0027663, -0.00280826,
  -0.00284989, -0.00289118, -0.00293212, -0.0029727, -0.00301293,
  -0.0030528, -0.00309231, -0.00313144, -0.0031702, -0.00320857,
  -0.00324657, -0.00328417, -0.00332139, -0.0033582, -0.00339462,
  -0.00343062, -0.00346622, -0.00350141, -0.00353617, -0.00357052,
  -0.00360444, -0.00363793, -0.00367098, -0.0037036, -0.00373578,
  -0.00376751, -0.00379879, -0.00382963, -0.00386, -0.00388992,
  -0.00391938, -0.00394836, -0.00397689, -0.00400493, -0.00403251,
  -0.0040596, -0.00408622, -0.00411234, -0.00413799, -0.00416314,
  -0.0041878, -0.00421196, -0.00423562, -0.00425879, -0.00428144,
  -0.0043036, -0.00432524, -0.00434638, -0.004367, -0.0043871,
  -0.00440669, -0.00442575, -0.0044443, -0.00446232, -0.00447982,
  -0.00449678, -0.00451322, -0.00452913, -0.0045445, -0.00455934,
  -0.00457364, -0.00458741, -0.00460063, -0.00461332, -0.00462546,
  -0.00463706, -0.00464811, -0.00465863, -0.00466859, -0.00467801,
  -0.00468687, -0.00469519, -0.00470296, -0.00471018, -0.00471685,
  -0.00472296, -0.00472852, -0.00473353, -0.00473799, -0.00474189,
  -0.00474524, -0.00474804, -0.00475028, -0.00475196, -0.00475309,
  -0.00475367, -0.00475369, -0.00475316, -0.00475208, -0.00475044,
  -0.00474825, -0.0047455, -0.00474221, -0.00473836, -0.00473396,
  -0.00472901, -0.00472351, -0.00471747, -0.00471087, -0.00470373,
  -0.00469604, -0.00468781, -0.00467903, -0.00466971, -0.00465985,
  -0.00464945, -0.00463851, -0.00462704, -0.00461503, -0.00460248,
  -0.0045894, -0.0045758, -0.00456166, -0.00454699, -0.00453181,
  -0.00451609, -0.00449986, -0.0044831, -0.00446583, -0.00444805,
  -0.00442975, -0.00441094, -0.00439162, -0.0043718, -0.00435147,
  -0.00433064, -0.00430932, -0.00428749, -0.00426518, -0.00424237,
  -0.00421908, -0.0041953, -0.00417104, -0.0041463, -0.00412109,
  -0.0040954, -0.00406924, -0.00404262, -0.00401553, -0.00398798,
  -0.00395998, -0.00393152, -0.00390261, -0.00387326, -0.00384346,
  -0.00381322, -0.00378255, -0.00375144, -0.0037199, -0.00368794,
  -0.00365556, -0.00362276, -0.00358955, -0.00355593, -0.0035219,
  -0.00348747, -0.00345264, -0.00341742, -0.00338181, -0.00334582,
  -0.00330944, -0.00327269, -0.00323556, -0.00319807, -0.00316021,
  -0.00312199, -0.00308342, -0.0030445, -0.00300523, -0.00296562,
  -0.00292568, -0.0028854, -0.0028448, -0.00280387, -0.00276262,
  -0.00272106, -0.0026792, -0.00263703, -0.00259456, -0.00255179,
  -0.00250874, -0.0024654, -0.00242179, -0.0023779, -0.00233374,
  -0.00228932, -0.00224464, -0.00219971, -0.00215453, -0.0021091,
  -0.00206344, -0.00201754, -0.00197142, -0.00192508, -0.00187851,
  -0.00183174, -0.00178476, -0.00173758, -0.0016902, -0.00164263,
  -0.00159488, -0.00154695, -0.00149884, -0.00145057, -0.00140213,
  -0.00135353, -0.00130479, -0.00125589, -0.00120686, -0.00115769,
  -0.00110839, -0.00105897, -0.00100942, -0.000959767, -0.000910003,
  -0.000860137, -0.000810175, -0.000760123, -0.000709985,
  -0.000659768, -0.000609477, -0.000559118, -0.000508696,
  -0.000458217, -0.000407687, -0.000357112, -0.000306497,
  -0.000255847, -0.000205169, -0.000154468, -0.00010375, -5.30198e-05,
  -2.28407e-06, 4.8452e-05, 9.91826e-05, 0.000149902, 0.000200605,
  0.000251286, 0.000301938, 0.000352558, 0.000403137, 0.000453672,
  0.000504157, 0.000554586, 0.000604953, 0.000655253, 0.00070548,
  0.000755628, 0.000805693, 0.000855669, 0.000905549, 0.000955329,
  0.001005, 0.00105457, 0.00110401, 0.00115334, 0.00120253, 0.0012516,
  0.00130052, 0.0013493, 0.00139793, 0.00144641, 0.00149472,
  0.00154288, 0.00159086, 0.00163866, 0.00168629, 0.00173372,
  0.00178097, 0.00182802, 0.00187487, 0.00192151, 0.00196794,
  0.00201415, 0.00206014, 0.00210591, 0.00215144, 0.00219673,
  0.00224179, 0.00228659, 0.00233115, 0.00237545, 0.00241948,
  0.00246325, 0.00250675, 0.00254998, 0.00259292, 0.00263558,
  0.00267795, 0.00272003, 0.00276181, 0.00280328, 0.00284445,
  0.00288531, 0.00292584, 0.00296606, 0.00300596, 0.00304552,
  0.00308475, 0.00312364, 0.00316219, 0.0032004, 0.00323825,
  0.00327575, 0.0033129, 0.00334968, 0.00338609, 0.00342213,
  0.0034578, 0.0034931, 0.00352801, 0.00356253, 0.00359667,
  0.00363041, 0.00366376, 0.00369671, 0.00372926, 0.0037614,
  0.00379313, 0.00382445, 0.00385535, 0.00388583, 0.00391588,
  0.00394551, 0.00397472, 0.00400349, 0.00403182, 0.00405972,
  0.00408717, 0.00411418, 0.00414074, 0.00416686, 0.00419252,
  0.00421773, 0.00424247, 0.00426676, 0.00429059, 0.00431395,
  0.00433684, 0.00435926, 0.00438121, 0.00440269, 0.00442369,
  0.00444421, 0.00446424, 0.0044838, 0.00450287, 0.00452145,
  0.00453954, 0.00455715, 0.00457426, 0.00459087, 0.00460699,
  0.00462261, 0.00463774, 0.00465236, 0.00466648, 0.00468009,
  0.00469321, 0.00470581, 0.00471791, 0.0047295, 0.00474058,
  0.00475114, 0.0047612, 0.00477074, 0.00477977, 0.00478829,
  0.00479629, 0.00480377, 0.00481074, 0.00481718, 0.00482312,
  0.00482853, 0.00483342, 0.0048378, 0.00484165, 0.00484498,
  0.0048478, 0.00485009, 0.00485186, 0.00485312, 0.00485385,
  0.00485406, 0.00485375, 0.00485292, 0.00485157, 0.0048497,
  0.00484731, 0.0048444, 0.00484097, 0.00483703, 0.00483256,
  0.00482758, 0.00482208, 0.00481607, 0.00480954, 0.0048025,
  0.00479495, 0.00478688, 0.0047783, 0.00476921, 0.00475961,
  0.0047495, 0.00473889, 0.00472777, 0.00471614, 0.00470401,
  0.00469138, 0.00467825, 0.00466463, 0.0046505, 0.00463588,
  0.00462076, 0.00460516, 0.00458906, 0.00457247, 0.0045554,
  0.00453784, 0.0045198, 0.00450128, 0.00448228, 0.00446281,
  0.00444286, 0.00442243, 0.00440154, 0.00438018, 0.00435836,
  0.00433607, 0.00431332, 0.00429011, 0.00426645, 0.00424234,
  0.00421778, 0.00419276, 0.00416731, 0.00414141, 0.00411508,
  0.0040883, 0.0040611, 0.00403346, 0.0040054, 0.00397691, 0.00394801,
  0.00391868, 0.00388894, 0.00385879, 0.00382823, 0.00379727,
  0.00376591, 0.00373414, 0.00370199, 0.00366944, 0.0036365,
  0.00360318, 0.00356948, 0.00353541, 0.00350096, 0.00346614,
  0.00343095, 0.00339541, 0.0033595, 0.00332324, 0.00328663,
  0.00324968, 0.00321238, 0.00317474, 0.00313677, 0.00309847,
  0.00305985, 0.0030209, 0.00298163, 0.00294205, 0.00290216,
  0.00286197, 0.00282148, 0.00278068, 0.0027396, 0.00269823,
  0.00265657, 0.00261464, 0.00257243, 0.00252995, 0.00248721,
  0.0024442, 0.00240094, 0.00235743, 0.00231367, 0.00226966,
  0.00222542, 0.00218095, 0.00213625, 0.00209132, 0.00204617,
  0.00200081, 0.00195524, 0.00190947, 0.0018635, 0.00181733,
  0.00177097, 0.00172443, 0.0016777, 0.0016308, 0.00158373, 0.0015365,
  0.0014891, 0.00144155, 0.00139384, 0.001346, 0.00129801, 0.00124988,
  0.00120163, 0.00115325, 0.00110475, 0.00105613, 0.00100741,
  0.000958578, 0.000909648, 0.000860623, 0.000811508, 0.000762309,
  0.00071303, 0.000663677, 0.000614255, 0.000564769, 0.000515224,
  0.000465626, 0.000415979, 0.000366289, 0.00031656, 0.000266799,
  0.00021701, 0.000167199, 0.00011737, 6.75294e-05, 1.76815e-05,
  -3.21683e-05, -8.20147e-05, -0.000131853, -0.000181677,
  -0.000231482, -0.000281263, -0.000331015, -0.000380733,
  -0.000430411, -0.000480045, -0.000529629, -0.000579158,
  -0.000628626, -0.00067803, -0.000727364, -0.000776622, -0.000825799,
  -0.000874891, -0.000923893, -0.000972799, -0.0010216, -0.0010703,
  -0.00111889, -0.00116737, -0.00121572, -0.00126394, -0.00131204,
  -0.00136, -0.00140782, -0.00145549, -0.00150302, -0.00155039,
  -0.0015976, -0.00164464, -0.00169151, -0.00173821, -0.00178473,
  -0.00183107, -0.00187722, -0.00192317, -0.00196892, -0.00201448,
  -0.00205982, -0.00210495, -0.00214987, -0.00219456, -0.00223903,
  -0.00228327, -0.00232727, -0.00237103, -0.00241455, -0.00245782,
  -0.00250084, -0.0025436, -0.00258609, -0.00262833, -0.00267029,
  -0.00271197, -0.00275338, -0.00279451, -0.00283535, -0.00287589,
  -0.00291615, -0.0029561, -0.00299575, -0.00303509, -0.00307412,
  -0.00311283, -0.00315123, -0.0031893, -0.00322704, -0.00326445,
  -0.00330153, -0.00333827, -0.00337467, -0.00341072, -0.00344642,
  -0.00348177, -0.00351677, -0.0035514, -0.00358567, -0.00361957,
  -0.0036531, -0.00368626, -0.00371904, -0.00375144, -0.00378345,
  -0.00381508, -0.00384632, -0.00387716, -0.00390761, -0.00393766,
  -0.00396731, -0.00399655, -0.00402538, -0.0040538, -0.00408181,
  -0.0041094, -0.00413658, -0.00416332, -0.00418965, -0.00421555,
  -0.00424101, -0.00426605, -0.00429064, -0.00431481, -0.00433853,
  -0.00436181, -0.00438464, -0.00440703, -0.00442897, -0.00445045,
  -0.00447149, -0.00449206, -0.00451219, -0.00453185, -0.00455105,
  -0.00456978, -0.00458805, -0.00460586, -0.0046232, -0.00464006,
  -0.00465646, -0.00467238, -0.00468782, -0.00470279, -0.00471728,
  -0.00473129, -0.00474482, -0.00475787, -0.00477043, -0.00478251,
  -0.00479411, -0.00480522, -0.00481584, -0.00482597, -0.00483561,
  -0.00484476, -0.00485342, -0.00486159, -0.00486926, -0.00487644,
  -0.00488313, -0.00488932, -0.00489501, -0.00490021, -0.00490491,
  -0.00490912, -0.00491283, -0.00491604, -0.00491875, -0.00492096,
  -0.00492268, -0.0049239, -0.00492462, -0.00492484, -0.00492456,
  -0.00492378, -0.00492251, -0.00492074, -0.00491847, -0.0049157,
  -0.00491244, -0.00490868, -0.00490442, -0.00489967, -0.00489442,
  -0.00488868, -0.00488245, -0.00487572, -0.0048685, -0.00486078,
  -0.00485258, -0.00484389, -0.00483471, -0.00482504, -0.00481488,
  -0.00480424, -0.00479311, -0.0047815, -0.00476941, -0.00475684,
  -0.00474379, -0.00473025, -0.00471625, -0.00470176, -0.00468681,
  -0.00467138, -0.00465548, -0.00463911, -0.00462228, -0.00460498,
  -0.00458721, -0.00456899, -0.0045503, -0.00453116, -0.00451156,
  -0.00449151, -0.004471, -0.00445005, -0.00442864, -0.0044068,
  -0.00438451, -0.00436178, -0.00433861, -0.004315, -0.00429096,
  -0.00426649, -0.00424159, -0.00421627, -0.00419052, -0.00416435,
  -0.00413776, -0.00411076, -0.00408335, -0.00405552, -0.00402729,
  -0.00399865, -0.00396962, -0.00394018, -0.00391035, -0.00388013,
  -0.00384952, -0.00381852, -0.00378714, -0.00375538, -0.00372325,
  -0.00369074, -0.00365786, -0.00362461, -0.00359101, -0.00355704,
  -0.00352271, -0.00348804, -0.00345301, -0.00341764, -0.00338193,
  -0.00334588, -0.00330949, -0.00327277, -0.00323573, -0.00319836,
  -0.00316067, -0.00312266, -0.00308435, -0.00304572, -0.00300679,
  -0.00296756, -0.00292803, -0.00288822, -0.00284811, -0.00280771,
  -0.00276704, -0.00272609, -0.00268487, -0.00264338, -0.00260163,
  -0.00255962, -0.00251735, -0.00247483, -0.00243206, -0.00238905,
  -0.0023458, -0.00230232, -0.00225861, -0.00221467, -0.00217052,
  -0.00212614, -0.00208156, -0.00203676, -0.00199177, -0.00194657,
  -0.00190118, -0.00185561, -0.00180984, -0.0017639, -0.00171778,
  -0.00167149, -0.00162503, -0.00157842, -0.00153164, -0.00148471,
  -0.00143764, -0.00139042, -0.00134306, -0.00129557, -0.00124795,
  -0.00120021, -0.00115235, -0.00110437, -0.00105628, -0.00100809,
  -0.000959795, -0.000911407, -0.000862929, -0.000814364,
  -0.000765719, -0.000716997, -0.000668205, -0.000619346,
  -0.000570425, -0.000521448, -0.000472419, -0.000423343,
  -0.000374225, -0.00032507, -0.000275882, -0.000226667, -0.00017743,
  -0.000128175, -7.89075e-05, -2.9632e-05, 1.96465e-05, 6.8923e-05,
  0.000118193, 0.000167451, 0.000216692, 0.000265912, 0.000315106,
  0.000364268, 0.000413394, 0.00046248, 0.000511519, 0.000560508,
  0.000609441, 0.000658314, 0.000707122, 0.00075586, 0.000804523,
  0.000853106, 0.000901605, 0.000950015, 0.000998331, 0.00104655,
  0.00109466, 0.00114267, 0.00119056, 0.00123833, 0.00128598,
  0.00133351, 0.0013809, 0.00142816, 0.00147527, 0.00152224,
  0.00156906, 0.00161572, 0.00166223, 0.00170857, 0.00175474,
  0.00180074, 0.00184656, 0.00189219, 0.00193764, 0.0019829,
  0.00202797, 0.00207283, 0.00211749, 0.00216194, 0.00220617,
  0.00225019, 0.00229399, 0.00233756, 0.0023809, 0.002424, 0.00246687,
  0.00250949, 0.00255186, 0.00259398, 0.00263585, 0.00267746,
  0.0027188, 0.00275988, 0.00280068, 0.0028412, 0.00288145,
  0.00292141, 0.00296109, 0.00300047, 0.00303956, 0.00307835,
  0.00311683, 0.00315501, 0.00319288, 0.00323043, 0.00326767,
  0.00330458, 0.00334117, 0.00337742, 0.00341335, 0.00344894,
  0.00348419, 0.0035191, 0.00355366, 0.00358787, 0.00362173,
  0.00365524, 0.00368838, 0.00372116, 0.00375358, 0.00378562,
  0.00381729, 0.00384859, 0.00387951, 0.00391005, 0.00394021,
  0.00396997, 0.00399935, 0.00402833, 0.00405692, 0.00408511,
  0.0041129, 0.00414028, 0.00416726, 0.00419383, 0.00421998,
  0.00424573, 0.00427105, 0.00429596, 0.00432044, 0.0043445,
  0.00436813, 0.00439134, 0.00441411, 0.00443645, 0.00445836,
  0.00447982, 0.00450085, 0.00452144, 0.00454158, 0.00456128,
  0.00458053, 0.00459933, 0.00461768, 0.00463558, 0.00465302,
  0.00467001, 0.00468654, 0.00470261, 0.00471822, 0.00473336,
  0.00474804, 0.00476226, 0.00477601, 0.00478929, 0.00480211,
  0.00481445, 0.00482632, 0.00483772, 0.00484865, 0.0048591,
  0.00486907, 0.00487857, 0.00488759, 0.00489613, 0.00490419,
  0.00491177, 0.00491887, 0.00492549, 0.00493163, 0.00493729,
  0.00494246, 0.00494715, 0.00495135, 0.00495507, 0.00495831,
  0.00496106, 0.00496332, 0.0049651, 0.0049664, 0.00496721,
  0.00496753, 0.00496737, 0.00496672, 0.00496559, 0.00496397,
  0.00496186, 0.00495927, 0.0049562, 0.00495264, 0.0049486,
  0.00494407, 0.00493907, 0.00493357, 0.0049276, 0.00492115,
  0.00491421, 0.0049068, 0.0048989, 0.00489053, 0.00488168,
  0.00487235, 0.00486255, 0.00485227, 0.00484152, 0.0048303,
  0.0048186, 0.00480644, 0.0047938, 0.0047807, 0.00476713, 0.0047531,
  0.0047386, 0.00472364, 0.00470822, 0.00469234, 0.004676, 0.00465921,
  0.00464196, 0.00462426, 0.00460611, 0.00458751, 0.00456846,
  0.00454896, 0.00452903, 0.00450865, 0.00448783, 0.00446657,
  0.00444488, 0.00442276, 0.0044002, 0.00437722, 0.00435381,
  0.00432997, 0.00430572, 0.00428104, 0.00425595, 0.00423044,
  0.00420452, 0.00417819, 0.00415145, 0.00412431, 0.00409677,
  0.00406883, 0.00404049, 0.00401176, 0.00398264, 0.00395313,
  0.00392323, 0.00389296, 0.0038623, 0.00383127, 0.00379987,
  0.00376809, 0.00373595, 0.00370345, 0.00367058, 0.00363736,
  0.00360378, 0.00356986, 0.00353558, 0.00350097, 0.00346601,
  0.00343071, 0.00339508, 0.00335912, 0.00332284, 0.00328623,
  0.0032493, 0.00321205, 0.0031745, 0.00313663, 0.00309846,
  0.00305999, 0.00302122, 0.00298216, 0.0029428, 0.00290316,
  0.00286324, 0.00282304, 0.00278257, 0.00274182, 0.00270081,
  0.00265954, 0.00261801, 0.00257622, 0.00253419, 0.0024919,
  0.00244938, 0.00240662, 0.00236362, 0.00232039, 0.00227694,
  0.00223327, 0.00218938, 0.00214528, 0.00210097, 0.00205645,
  0.00201174, 0.00196683, 0.00192173, 0.00187644, 0.00183097,
  0.00178533, 0.00173951, 0.00169352, 0.00164736, 0.00160105,
  0.00155458, 0.00150796, 0.00146119, 0.00141429, 0.00136724,
  0.00132006, 0.00127276, 0.00122533, 0.00117778, 0.00113012,
  0.00108235, 0.00103447, 0.000986491, 0.000938418, 0.000890254,
  0.000842003, 0.000793671, 0.000745262, 0.00069678, 0.000648231,
  0.000599619, 0.000550949, 0.000502226, 0.000453453, 0.000404637,
  0.000355782, 0.000306892, 0.000257972, 0.000209028, 0.000160063,
  0.000111083, 6.20914e-05, 1.30943e-05, -3.59041e-05, -8.4899e-05,
  -0.000133886, -0.000182859, -0.000231815, -0.000280749,
  -0.000329655, -0.000378529, -0.000427367, -0.000476163,
  -0.000524913, -0.000573612, -0.000622255, -0.000670839,
  -0.000719357, -0.000767805, -0.000816179, -0.000864474,
  -0.000912686, -0.000960808, -0.00100884, -0.00105677, -0.0011046,
  -0.00115232, -0.00119993, -0.00124743, -0.0012948, -0.00134205,
  -0.00138917, -0.00143615, -0.001483, -0.0015297, -0.00157625,
  -0.00162265, -0.00166889, -0.00171498, -0.00176089, -0.00180664,
  -0.00185221, -0.0018976, -0.0019428, -0.00198782, -0.00203265,
  -0.00207728, -0.00212171, -0.00216593, -0.00220994, -0.00225374,
  -0.00229732, -0.00234068, -0.00238382, -0.00242672, -0.00246938,
  -0.00251181, -0.002554, -0.00259593, -0.00263762, -0.00267905,
  -0.00272022, -0.00276113, -0.00280177, -0.00284214, -0.00288224,
  -0.00292205, -0.00296158, -0.00300083, -0.00303979, -0.00307845,
  -0.00311681, -0.00315488, -0.00319263, -0.00323008, -0.00326722,
  -0.00330404, -0.00334054, -0.00337671, -0.00341256, -0.00344808,
  -0.00348327, -0.00351812, -0.00355263, -0.0035868, -0.00362061,
  -0.00365408, -0.0036872, -0.00371996, -0.00375235, -0.00378439,
  -0.00381606, -0.00384736, -0.00387829, -0.00390884, -0.00393902,
  -0.00396881, -0.00399822, -0.00402724, -0.00405588, -0.00408412,
  -0.00411197, -0.00413942, -0.00416646, -0.00419311, -0.00421935,
  -0.00424518, -0.0042706, -0.00429561, -0.00432021, -0.00434438,
  -0.00436814, -0.00439147, -0.00441438, -0.00443686, -0.00445891,
  -0.00448054, -0.00450172, -0.00452248, -0.00454279, -0.00456267,
  -0.00458211, -0.0046011, -0.00461965, -0.00463775, -0.0046554,
  -0.0046726, -0.00468935, -0.00470565, -0.00472149, -0.00473688,
  -0.00475181, -0.00476627, -0.00478028, -0.00479383, -0.00480691,
  -0.00481953, -0.00483168, -0.00484336, -0.00485458, -0.00486533,
  -0.0048756, -0.00488541, -0.00489474, -0.0049036, -0.00491199,
  -0.0049199, -0.00492733, -0.00493429, -0.00494077, -0.00494678,
  -0.0049523, -0.00495735, -0.00496192, -0.00496601, -0.00496961,
  -0.00497274, -0.00497539, -0.00497756, -0.00497924, -0.00498045,
  -0.00498117, -0.00498141, -0.00498117, -0.00498045, -0.00497924,
  -0.00497756, -0.00497539, -0.00497274, -0.00496961, -0.00496601,
  -0.00496192, -0.00495735, -0.0049523, -0.00494678, -0.00494077,
  -0.00493429, -0.00492733, -0.0049199, -0.00491199, -0.0049036,
  -0.00489474, -0.00488541, -0.0048756, -0.00486533, -0.00485458,
  -0.00484336, -0.00483168, -0.00481953, -0.00480691, -0.00479383,
  -0.00478028, -0.00476627, -0.00475181, -0.00473688, -0.00472149,
  -0.00470565, -0.00468935, -0.0046726, -0.0046554, -0.00463775,
  -0.00461965, -0.0046011, -0.00458211, -0.00456267, -0.00454279,
  -0.00452248, -0.00450172, -0.00448054, -0.00445891, -0.00443686,
  -0.00441438, -0.00439147, -0.00436814, -0.00434438, -0.00432021,
  -0.00429561, -0.0042706, -0.00424518, -0.00421935, -0.00419311,
  -0.00416646, -0.00413942, -0.00411197, -0.00408412, -0.00405588,
  -0.00402724, -0.00399822, -0.00396881, -0.00393902, -0.00390884,
  -0.00387829, -0.00384736, -0.00381606, -0.00378439, -0.00375235,
  -0.00371996, -0.0036872, -0.00365408, -0.00362061, -0.0035868,
  -0.00355263, -0.00351812, -0.00348327, -0.00344808, -0.00341256,
  -0.00337671, -0.00334054, -0.00330404, -0.00326722, -0.00323008,
  -0.00319263, -0.00315488, -0.00311681, -0.00307845, -0.00303979,
  -0.00300083, -0.00296158, -0.00292205, -0.00288224, -0.00284214,
  -0.00280177, -0.00276113, -0.00272022, -0.00267905, -0.00263762,
  -0.00259593, -0.002554, -0.00251181, -0.00246938, -0.00242672,
  -0.00238382, -0.00234068, -0.00229732, -0.00225374, -0.00220994,
  -0.00216593, -0.00212171, -0.00207728, -0.00203265, -0.00198782,
  -0.0019428, -0.0018976, -0.00185221, -0.00180664, -0.00176089,
  -0.00171498, -0.00166889, -0.00162265, -0.00157625, -0.0015297,
  -0.001483, -0.00143615, -0.00138917, -0.00134205, -0.0012948,
  -0.00124743, -0.00119993, -0.00115232, -0.0011046, -0.00105677,
  -0.00100884, -0.000960808, -0.000912686, -0.000864474, -0.000816179,
  -0.000767805, -0.000719357, -0.000670839, -0.000622255,
  -0.000573612, -0.000524913, -0.000476163, -0.000427367,
  -0.000378529, -0.000329655, -0.000280749, -0.000231815,
  -0.000182859, -0.000133886, -8.4899e-05, -3.59041e-05, 1.30943e-05,
  6.20914e-05, 0.000111083, 0.000160063, 0.000209028, 0.000257972,
  0.000306892, 0.000355782, 0.000404637, 0.000453453, 0.000502226,
  0.000550949, 0.000599619, 0.000648231, 0.00069678, 0.000745262,
  0.000793671, 0.000842003, 0.000890254, 0.000938418, 0.000986491,
  0.00103447, 0.00108235, 0.00113012, 0.00117778, 0.00122533,
  0.00127276, 0.00132006, 0.00136724, 0.00141429, 0.00146119,
  0.00150796, 0.00155458, 0.00160105, 0.00164736, 0.00169352,
  0.00173951, 0.00178533, 0.00183097, 0.00187644, 0.00192173,
  0.00196683, 0.00201174, 0.00205645, 0.00210097, 0.00214528,
  0.00218938, 0.00223327, 0.00227694, 0.00232039, 0.00236362,
  0.00240662, 0.00244938, 0.0024919, 0.00253419, 0.00257622,
  0.00261801, 0.00265954, 0.00270081, 0.00274182, 0.00278257,
  0.00282304, 0.00286324, 0.00290316, 0.0029428, 0.00298216,
  0.00302122, 0.00305999, 0.00309846, 0.00313663, 0.0031745,
  0.00321205, 0.0032493, 0.00328623, 0.00332284, 0.00335912,
  0.00339508, 0.00343071, 0.00346601, 0.00350097, 0.00353558,
  0.00356986, 0.00360378, 0.00363736, 0.00367058, 0.00370345,
  0.00373595, 0.00376809, 0.00379987, 0.00383127, 0.0038623,
  0.00389296, 0.00392323, 0.00395313, 0.00398264, 0.00401176,
  0.00404049, 0.00406883, 0.00409677, 0.00412431, 0.00415145,
  0.00417819, 0.00420452, 0.00423044, 0.00425595, 0.00428104,
  0.00430572, 0.00432997, 0.00435381, 0.00437722, 0.0044002,
  0.00442276, 0.00444488, 0.00446657, 0.00448783, 0.00450865,
  0.00452903, 0.00454896, 0.00456846, 0.00458751, 0.00460611,
  0.00462426, 0.00464196, 0.00465921, 0.004676, 0.00469234,
  0.00470822, 0.00472364, 0.0047386, 0.0047531, 0.00476713, 0.0047807,
  0.0047938, 0.00480644, 0.0048186, 0.0048303, 0.00484152, 0.00485227,
  0.00486255, 0.00487235, 0.00488168, 0.00489053, 0.0048989,
  0.0049068, 0.00491421, 0.00492115, 0.0049276, 0.00493357,
  0.00493907, 0.00494407, 0.0049486, 0.00495264, 0.0049562,
  0.00495927, 0.00496186, 0.00496397, 0.00496559, 0.00496672,
  0.00496737, 0.00496753, 0.00496721, 0.0049664, 0.0049651,
  0.00496332, 0.00496106, 0.00495831, 0.00495507, 0.00495135,
  0.00494715, 0.00494246, 0.00493729, 0.00493163, 0.00492549,
  0.00491887, 0.00491177, 0.00490419, 0.00489613, 0.00488759,
  0.00487857, 0.00486907, 0.0048591, 0.00484865, 0.00483772,
  0.00482632, 0.00481445, 0.00480211, 0.00478929, 0.00477601,
  0.00476226, 0.00474804, 0.00473336, 0.00471822, 0.00470261,
  0.00468654, 0.00467001, 0.00465302, 0.00463558, 0.00461768,
  0.00459933, 0.00458053, 0.00456128, 0.00454158, 0.00452144,
  0.00450085, 0.00447982, 0.00445836, 0.00443645, 0.00441411,
  0.00439134, 0.00436813, 0.0043445, 0.00432044, 0.00429596,
  0.00427105, 0.00424573, 0.00421998, 0.00419383, 0.00416726,
  0.00414028, 0.0041129, 0.00408511, 0.00405692, 0.00402833,
  0.00399935, 0.00396997, 0.00394021, 0.00391005, 0.00387951,
  0.00384859, 0.00381729, 0.00378562, 0.00375358, 0.00372116,
  0.00368838, 0.00365524, 0.00362173, 0.00358787, 0.00355366,
  0.0035191, 0.00348419, 0.00344894, 0.00341335, 0.00337742,
  0.00334117, 0.00330458, 0.00326767, 0.00323043, 0.00319288,
  0.00315501, 0.00311683, 0.00307835, 0.00303956, 0.00300047,
  0.00296109, 0.00292141, 0.00288145, 0.0028412, 0.00280068,
  0.00275988, 0.0027188, 0.00267746, 0.00263585, 0.00259398,
  0.00255186, 0.00250949, 0.00246687, 0.002424, 0.0023809, 0.00233756,
  0.00229399, 0.00225019, 0.00220617, 0.00216194, 0.00211749,
  0.00207283, 0.00202797, 0.0019829, 0.00193764, 0.00189219,
  0.00184656, 0.00180074, 0.00175474, 0.00170857, 0.00166223,
  0.00161572, 0.00156906, 0.00152224, 0.00147527, 0.00142816,
  0.0013809, 0.00133351, 0.00128598, 0.00123833, 0.00119056,
  0.00114267, 0.00109466, 0.00104655, 0.000998331, 0.000950015,
  0.000901605, 0.000853106, 0.000804523, 0.00075586, 0.000707122,
  0.000658314, 0.000609441, 0.000560508, 0.000511519, 0.00046248,
  0.000413394, 0.000364268, 0.000315106, 0.000265912, 0.000216692,
  0.000167451, 0.000118193, 6.8923e-05, 1.96465e-05, -2.9632e-05,
  -7.89075e-05, -0.000128175, -0.00017743, -0.000226667, -0.000275882,
  -0.00032507, -0.000374225, -0.000423343, -0.000472419, -0.000521448,
  -0.000570425, -0.000619346, -0.000668205, -0.000716997,
  -0.000765719, -0.000814364, -0.000862929, -0.000911407,
  -0.000959795, -0.00100809, -0.00105628, -0.00110437, -0.00115235,
  -0.00120021, -0.00124795, -0.00129557, -0.00134306, -0.00139042,
  -0.00143764, -0.00148471, -0.00153164, -0.00157842, -0.00162503,
  -0.00167149, -0.00171778, -0.0017639, -0.00180984, -0.00185561,
  -0.00190118, -0.00194657, -0.00199177, -0.00203676, -0.00208156,
  -0.00212614, -0.00217052, -0.00221467, -0.00225861, -0.00230232,
  -0.0023458, -0.00238905, -0.00243206, -0.00247483, -0.00251735,
  -0.00255962, -0.00260163, -0.00264338, -0.00268487, -0.00272609,
  -0.00276704, -0.00280771, -0.00284811, -0.00288822, -0.00292803,
  -0.00296756, -0.00300679, -0.00304572, -0.00308435, -0.00312266,
  -0.00316067, -0.00319836, -0.00323573, -0.00327277, -0.00330949,
  -0.00334588, -0.00338193, -0.00341764, -0.00345301, -0.00348804,
  -0.00352271, -0.00355704, -0.00359101, -0.00362461, -0.00365786,
  -0.00369074, -0.00372325, -0.00375538, -0.00378714, -0.00381852,
  -0.00384952, -0.00388013, -0.00391035, -0.00394018, -0.00396962,
  -0.00399865, -0.00402729, -0.00405552, -0.00408335, -0.00411076,
  -0.00413776, -0.00416435, -0.00419052, -0.00421627, -0.00424159,
  -0.00426649, -0.00429096, -0.004315, -0.00433861, -0.00436178,
  -0.00438451, -0.0044068, -0.00442864, -0.00445005, -0.004471,
  -0.00449151, -0.00451156, -0.00453116, -0.0045503, -0.00456899,
  -0.00458721, -0.00460498, -0.00462228, -0.00463911, -0.00465548,
  -0.00467138, -0.00468681, -0.00470176, -0.00471625, -0.00473025,
  -0.00474379, -0.00475684, -0.00476941, -0.0047815, -0.00479311,
  -0.00480424, -0.00481488, -0.00482504, -0.00483471, -0.00484389,
  -0.00485258, -0.00486078, -0.0048685, -0.00487572, -0.00488245,
  -0.00488868, -0.00489442, -0.00489967, -0.00490442, -0.00490868,
  -0.00491244, -0.0049157, -0.00491847, -0.00492074, -0.00492251,
  -0.00492378, -0.00492456, -0.00492484, -0.00492462, -0.0049239,
  -0.00492268, -0.00492096, -0.00491875, -0.00491604, -0.00491283,
  -0.00490912, -0.00490491, -0.00490021, -0.00489501, -0.00488932,
  -0.00488313, -0.00487644, -0.00486926, -0.00486159, -0.00485342,
  -0.00484476, -0.00483561, -0.00482597, -0.00481584, -0.00480522,
  -0.00479411, -0.00478251, -0.00477043, -0.00475787, -0.00474482,
  -0.00473129, -0.00471728, -0.00470279, -0.00468782, -0.00467238,
  -0.00465646, -0.00464006, -0.0046232, -0.00460586, -0.00458805,
  -0.00456978, -0.00455105, -0.00453185, -0.00451219, -0.00449206,
  -0.00447149, -0.00445045, -0.00442897, -0.00440703, -0.00438464,
  -0.00436181, -0.00433853, -0.00431481, -0.00429064, -0.00426605,
  -0.00424101, -0.00421555, -0.00418965, -0.00416332, -0.00413658,
  -0.0041094, -0.00408181, -0.0040538, -0.00402538, -0.00399655,
  -0.00396731, -0.00393766, -0.00390761, -0.00387716, -0.00384632,
  -0.00381508, -0.00378345, -0.00375144, -0.00371904, -0.00368626,
  -0.0036531, -0.00361957, -0.00358567, -0.0035514, -0.00351677,
  -0.00348177, -0.00344642, -0.00341072, -0.00337467, -0.00333827,
  -0.00330153, -0.00326445, -0.00322704, -0.0031893, -0.00315123,
  -0.00311283, -0.00307412, -0.00303509, -0.00299575, -0.0029561,
  -0.00291615, -0.00287589, -0.00283535, -0.00279451, -0.00275338,
  -0.00271197, -0.00267029, -0.00262833, -0.00258609, -0.0025436,
  -0.00250084, -0.00245782, -0.00241455, -0.00237103, -0.00232727,
  -0.00228327, -0.00223903, -0.00219456, -0.00214987, -0.00210495,
  -0.00205982, -0.00201448, -0.00196892, -0.00192317, -0.00187722,
  -0.00183107, -0.00178473, -0.00173821, -0.00169151, -0.00164464,
  -0.0015976, -0.00155039, -0.00150302, -0.00145549, -0.00140782,
  -0.00136, -0.00131204, -0.00126394, -0.00121572, -0.00116737,
  -0.00111889, -0.0010703, -0.0010216, -0.000972799, -0.000923893,
  -0.000874891, -0.000825799, -0.000776622, -0.000727364, -0.00067803,
  -0.000628626, -0.000579158, -0.000529629, -0.000480045,
  -0.000430411, -0.000380733, -0.000331015, -0.000281263,
  -0.000231482, -0.000181677, -0.000131853, -8.20147e-05,
  -3.21683e-05, 1.76815e-05, 6.75294e-05, 0.00011737, 0.000167199,
  0.00021701, 0.000266799, 0.00031656, 0.000366289, 0.000415979,
  0.000465626, 0.000515224, 0.000564769, 0.000614255, 0.000663677,
  0.00071303, 0.000762309, 0.000811508, 0.000860623, 0.000909648,
  0.000958578, 0.00100741, 0.00105613, 0.00110475, 0.00115325,
  0.00120163, 0.00124988, 0.00129801, 0.001346, 0.00139384,
  0.00144155, 0.0014891, 0.0015365, 0.00158373, 0.0016308, 0.0016777,
  0.00172443, 0.00177097, 0.00181733, 0.0018635, 0.00190947,
  0.00195524, 0.00200081, 0.00204617, 0.00209132, 0.00213625,
  0.00218095, 0.00222542, 0.00226966, 0.00231367, 0.00235743,
  0.00240094, 0.0024442, 0.00248721, 0.00252995, 0.00257243,
  0.00261464, 0.00265657, 0.00269823, 0.0027396, 0.00278068,
  0.00282148, 0.00286197, 0.00290216, 0.00294205, 0.00298163,
  0.0030209, 0.00305985, 0.00309847, 0.00313677, 0.00317474,
  0.00321238, 0.00324968, 0.00328663, 0.00332324, 0.0033595,
  0.00339541, 0.00343095, 0.00346614, 0.00350096, 0.00353541,
  0.00356948, 0.00360318, 0.0036365, 0.00366944, 0.00370199,
  0.00373414, 0.00376591, 0.00379727, 0.00382823, 0.00385879,
  0.00388894, 0.00391868, 0.00394801, 0.00397691, 0.0040054,
  0.00403346, 0.0040611, 0.0040883, 0.00411508, 0.00414141,
  0.00416731, 0.00419276, 0.00421778, 0.00424234, 0.00426645,
  0.00429011, 0.00431332, 0.00433607, 0.00435836, 0.00438018,
  0.00440154, 0.00442243, 0.00444286, 0.00446281, 0.00448228,
  0.00450128, 0.0045198, 0.00453784, 0.0045554, 0.00457247,
  0.00458906, 0.00460516, 0.00462076, 0.00463588, 0.0046505,
  0.00466463, 0.00467825, 0.00469138, 0.00470401, 0.00471614,
  0.00472777, 0.00473889, 0.0047495, 0.00475961, 0.00476921,
  0.0047783, 0.00478688, 0.00479495, 0.0048025, 0.00480954,
  0.00481607, 0.00482208, 0.00482758, 0.00483256, 0.00483703,
  0.00484097, 0.0048444, 0.00484731, 0.0048497, 0.00485157,
  0.00485292, 0.00485375, 0.00485406, 0.00485385, 0.00485312,
  0.00485186, 0.00485009, 0.0048478, 0.00484498, 0.00484165,
  0.0048378, 0.00483342, 0.00482853, 0.00482312, 0.00481718,
  0.00481074, 0.00480377, 0.00479629, 0.00478829, 0.00477977,
  0.00477074, 0.0047612, 0.00475114, 0.00474058, 0.0047295,
  0.00471791, 0.00470581, 0.00469321, 0.00468009, 0.00466648,
  0.00465236, 0.00463774, 0.00462261, 0.00460699, 0.00459087,
  0.00457426, 0.00455715, 0.00453954, 0.00452145, 0.00450287,
  0.0044838, 0.00446424, 0.00444421, 0.00442369, 0.00440269,
  0.00438121, 0.00435926, 0.00433684, 0.00431395, 0.00429059,
  0.00426676, 0.00424247, 0.00421773, 0.00419252, 0.00416686,
  0.00414074, 0.00411418, 0.00408717, 0.00405972, 0.00403182,
  0.00400349, 0.00397472, 0.00394551, 0.00391588, 0.00388583,
  0.00385535, 0.00382445, 0.00379313, 0.0037614, 0.00372926,
  0.00369671, 0.00366376, 0.00363041, 0.00359667, 0.00356253,
  0.00352801, 0.0034931, 0.0034578, 0.00342213, 0.00338609,
  0.00334968, 0.0033129, 0.00327575, 0.00323825, 0.0032004,
  0.00316219, 0.00312364, 0.00308475, 0.00304552, 0.00300596,
  0.00296606, 0.00292584, 0.00288531, 0.00284445, 0.00280328,
  0.00276181, 0.00272003, 0.00267795, 0.00263558, 0.00259292,
  0.00254998, 0.00250675, 0.00246325, 0.00241948, 0.00237545,
  0.00233115, 0.00228659, 0.00224179, 0.00219673, 0.00215144,
  0.00210591, 0.00206014, 0.00201415, 0.00196794, 0.00192151,
  0.00187487, 0.00182802, 0.00178097, 0.00173372, 0.00168629,
  0.00163866, 0.00159086, 0.00154288, 0.00149472, 0.00144641,
  0.00139793, 0.0013493, 0.00130052, 0.0012516, 0.00120253,
  0.00115334, 0.00110401, 0.00105457, 0.001005, 0.000955329,
  0.000905549, 0.000855669, 0.000805693, 0.000755628, 0.00070548,
  0.000655253, 0.000604953, 0.000554586, 0.000504157, 0.000453672,
  0.000403137, 0.000352558, 0.000301938, 0.000251286, 0.000200605,
  0.000149902, 9.91826e-05, 4.8452e-05, -2.28407e-06, -5.30198e-05,
  -0.00010375, -0.000154468, -0.000205169, -0.000255847, -0.000306497,
  -0.000357112, -0.000407687, -0.000458217, -0.000508696,
  -0.000559118, -0.000609477, -0.000659768, -0.000709985,
  -0.000760123, -0.000810175, -0.000860137, -0.000910003,
  -0.000959767, -0.00100942, -0.00105897, -0.00110839, -0.00115769,
  -0.00120686, -0.00125589, -0.00130479, -0.00135353, -0.00140213,
  -0.00145057, -0.00149884, -0.00154695, -0.00159488, -0.00164263,
  -0.0016902, -0.00173758, -0.00178476, -0.00183174, -0.00187851,
  -0.00192508, -0.00197142, -0.00201754, -0.00206344, -0.0021091,
  -0.00215453, -0.00219971, -0.00224464, -0.00228932, -0.00233374,
  -0.0023779, -0.00242179, -0.0024654, -0.00250874, -0.00255179,
  -0.00259456, -0.00263703, -0.0026792, -0.00272106, -0.00276262,
  -0.00280387, -0.0028448, -0.0028854, -0.00292568, -0.00296562,
  -0.00300523, -0.0030445, -0.00308342, -0.00312199, -0.00316021,
  -0.00319807, -0.00323556, -0.00327269, -0.00330944, -0.00334582,
  -0.00338181, -0.00341742, -0.00345264, -0.00348747, -0.0035219,
  -0.00355593, -0.00358955, -0.00362276, -0.00365556, -0.00368794,
  -0.0037199, -0.00375144, -0.00378255, -0.00381322, -0.00384346,
  -0.00387326, -0.00390261, -0.00393152, -0.00395998, -0.00398798,
  -0.00401553, -0.00404262, -0.00406924, -0.0040954, -0.00412109,
  -0.0041463, -0.00417104, -0.0041953, -0.00421908, -0.00424237,
  -0.00426518, -0.00428749, -0.00430932, -0.00433064, -0.00435147,
  -0.0043718, -0.00439162, -0.00441094, -0.00442975, -0.00444805,
  -0.00446583, -0.0044831, -0.00449986, -0.00451609, -0.00453181,
  -0.00454699, -0.00456166, -0.0045758, -0.0045894, -0.00460248,
  -0.00461503, -0.00462704, -0.00463851, -0.00464945, -0.00465985,
  -0.00466971, -0.00467903, -0.00468781, -0.00469604, -0.00470373,
  -0.00471087, -0.00471747, -0.00472351, -0.00472901, -0.00473396,
  -0.00473836, -0.00474221, -0.0047455, -0.00474825, -0.00475044,
  -0.00475208, -0.00475316, -0.00475369, -0.00475367, -0.00475309,
  -0.00475196, -0.00475028, -0.00474804, -0.00474524, -0.00474189,
  -0.00473799, -0.00473353, -0.00472852, -0.00472296, -0.00471685,
  -0.00471018, -0.00470296, -0.00469519, -0.00468687, -0.00467801,
  -0.00466859, -0.00465863, -0.00464811, -0.00463706, -0.00462546,
  -0.00461332, -0.00460063, -0.00458741, -0.00457364, -0.00455934,
  -0.0045445, -0.00452913, -0.00451322, -0.00449678, -0.00447982,
  -0.00446232, -0.0044443, -0.00442575, -0.00440669, -0.0043871,
  -0.004367, -0.00434638, -0.00432524, -0.0043036, -0.00428144,
  -0.00425879, -0.00423562, -0.00421196, -0.0041878, -0.00416314,
  -0.00413799, -0.00411234, -0.00408622, -0.0040596, -0.00403251,
  -0.00400493, -0.00397689, -0.00394836, -0.00391938, -0.00388992,
  -0.00386, -0.00382963, -0.00379879, -0.00376751, -0.00373578,
  -0.0037036, -0.00367098, -0.00363793, -0.00360444, -0.00357052,
  -0.00353617, -0.00350141, -0.00346622, -0.00343062, -0.00339462,
  -0.0033582, -0.00332139, -0.00328417, -0.00324657, -0.00320857,
  -0.0031702, -0.00313144, -0.00309231, -0.0030528, -0.00301293,
  -0.0029727, -0.00293212, -0.00289118, -0.00284989, -0.00280826,
  -0.0027663, -0.002724, -0.00268137, -0.00263842, -0.00259516,
  -0.00255158, -0.0025077, -0.00246351, -0.00241902, -0.00237425,
  -0.00232919, -0.00228384, -0.00223822, -0.00219234, -0.00214618,
  -0.00209977, -0.0020531, -0.00200619, -0.00195903, -0.00191164,
  -0.00186401, -0.00181616, -0.00176809, -0.0017198, -0.00167131,
  -0.00162261, -0.00157372, -0.00152463, -0.00147536, -0.00142591,
  -0.00137629, -0.0013265, -0.00127655, -0.00122644, -0.00117619,
  -0.00112579, -0.00107525, -0.00102459, -0.000973795, -0.000922885,
  -0.000871862, -0.000820733, -0.000769504, -0.00071818, -0.000666769,
  -0.000615277, -0.000563709, -0.000512072, -0.000460373,
  -0.000408617, -0.000356811, -0.000304962, -0.000253075,
  -0.000201157, -0.000149215, -9.72537e-05, -4.52808e-05, 6.69756e-06,
  5.86751e-05, 0.000110646, 0.000162602, 0.000214539, 0.00026645,
  0.000318327, 0.000370166, 0.000421959, 0.0004737, 0.000525382,
  0.000577, 0.000628547, 0.000680016, 0.000731402, 0.000782696,
  0.000833895, 0.00088499, 0.000935976, 0.000986846, 0.00103759,
  0.00108821, 0.0011387, 0.00118904, 0.00123924, 0.00128928,
  0.00133916, 0.00138888, 0.00143843, 0.00148779, 0.00153697,
  0.00158596, 0.00163476, 0.00168335, 0.00173173, 0.00177989,
  0.00182783, 0.00187555, 0.00192303, 0.00197027, 0.00201727,
  0.00206401, 0.0021105, 0.00215672, 0.00220268, 0.00224836,
  0.00229375, 0.00233886, 0.00238368, 0.0024282, 0.00247242,
  0.00251632, 0.00255991, 0.00260318, 0.00264612, 0.00268873,
  0.00273101, 0.00277294, 0.00281452, 0.00285575, 0.00289662,
  0.00293712, 0.00297725, 0.00301701, 0.00305639, 0.00309539,
  0.00313399, 0.0031722, 0.00321001, 0.00324741, 0.00328441,
  0.00332099, 0.00335714, 0.00339288, 0.00342818, 0.00346306,
  0.00349749, 0.00353148, 0.00356502, 0.00359811, 0.00363074,
  0.00366292, 0.00369463, 0.00372586, 0.00375663, 0.00378692,
  0.00381673, 0.00384605, 0.00387488, 0.00390322, 0.00393106,
  0.0039584, 0.00398524, 0.00401156, 0.00403738, 0.00406268,
  0.00408746, 0.00411172, 0.00413546, 0.00415866, 0.00418133,
  0.00420347, 0.00422507, 0.00424613, 0.00426664, 0.00428661,
  0.00430603, 0.0043249, 0.00434321, 0.00436096, 0.00437815,
  0.00439478, 0.00441084, 0.00442634, 0.00444127, 0.00445562,
  0.0044694, 0.00448261, 0.00449523, 0.00450728, 0.00451875,
  0.00452963, 0.00453993, 0.00454964, 0.00455876, 0.00456729,
  0.00457523, 0.00458258, 0.00458933, 0.0045955, 0.00460106,
  0.00460603, 0.0046104, 0.00461417, 0.00461734, 0.00461992,
  0.00462189, 0.00462326, 0.00462403, 0.0046242, 0.00462376,
  0.00462273, 0.00462109, 0.00461885, 0.004616, 0.00461255,
  0.00460851, 0.00460385, 0.0045986, 0.00459275, 0.00458629,
  0.00457924, 0.00457158, 0.00456333, 0.00455447, 0.00454503,
  0.00453498, 0.00452434, 0.0045131, 0.00450128, 0.00448886,
  0.00447585, 0.00446225, 0.00444806, 0.00443329, 0.00441794,
  0.004402, 0.00438548, 0.00436838, 0.00435071, 0.00433246,
  0.00431364, 0.00429425, 0.00427429, 0.00425377, 0.00423268,
  0.00421103, 0.00418883, 0.00416607, 0.00414276, 0.00411889,
  0.00409448, 0.00406953, 0.00404404, 0.00401801, 0.00399144,
  0.00396434, 0.00393672, 0.00390857, 0.0038799, 0.00385071,
  0.00382101, 0.0037908, 0.00376009, 0.00372887, 0.00369715,
  0.00366494, 0.00363224, 0.00359905, 0.00356538, 0.00353123,
  0.00349661, 0.00346152, 0.00342597, 0.00338996, 0.00335349,
  0.00331657, 0.0032792, 0.0032414, 0.00320315, 0.00316448,
  0.00312538, 0.00308586, 0.00304592, 0.00300557, 0.00296482,
  0.00292367, 0.00288212, 0.00284018, 0.00279786, 0.00275516,
  0.00271208, 0.00266864, 0.00262484, 0.00258068, 0.00253617,
  0.00249132, 0.00244613, 0.00240061, 0.00235476, 0.00230859,
  0.00226211, 0.00221531, 0.00216822, 0.00212083, 0.00207316,
  0.00202519, 0.00197696, 0.00192845, 0.00187968, 0.00183066,
  0.00178138, 0.00173186, 0.0016821, 0.00163211, 0.0015819,
  0.00153147, 0.00148083, 0.00142999, 0.00137895, 0.00132773,
  0.00127632, 0.00122473, 0.00117298, 0.00112106, 0.00106899,
  0.00101678, 0.000964418, 0.000911928, 0.000859312, 0.000806577,
  0.000753731, 0.000700781, 0.000647734, 0.000594597, 0.000541378,
  0.000488084, 0.000434723, 0.000381301, 0.000327826, 0.000274306,
  0.000220748, 0.000167159, 0.000113547, 5.99187e-05, 6.28245e-06,
  -4.73547e-05, -0.000100985, -0.000154602, -0.000208196,
  -0.000261762, -0.000315291, -0.000368777, -0.00042221, -0.000475585,
  -0.000528893, -0.000582126, -0.000635279, -0.000688342,
  -0.000741309, -0.000794172, -0.000846923, -0.000899555,
  -0.000952061, -0.00100443, -0.00105666, -0.00110875, -0.00116067,
  -0.00121243, -0.00126402, -0.00131544, -0.00136666, -0.0014177,
  -0.00146853, -0.00151916, -0.00156957, -0.00161976, -0.00166972,
  -0.00171944, -0.00176892, -0.00181815, -0.00186712, -0.00191583,
  -0.00196426, -0.00201241, -0.00206028, -0.00210786, -0.00215513,
  -0.0022021, -0.00224875, -0.00229508, -0.00234109, -0.00238676,
  -0.00243209, -0.00247707, -0.0025217, -0.00256597, -0.00260986,
  -0.00265339, -0.00269654, -0.00273929, -0.00278166, -0.00282363,
  -0.00286519, -0.00290633, -0.00294706, -0.00298737, -0.00302725,
  -0.00306668, -0.00310568, -0.00314423, -0.00318233, -0.00321996,
  -0.00325713, -0.00329383, -0.00333006, -0.0033658, -0.00340105,
  -0.00343581, -0.00347008, -0.00350384, -0.00353709, -0.00356982,
  -0.00360204, -0.00363374, -0.0036649, -0.00369553, -0.00372563,
  -0.00375518, -0.00378418, -0.00381263, -0.00384053, -0.00386786,
  -0.00389463, -0.00392082, -0.00394645, -0.00397149, -0.00399596,
  -0.00401984, -0.00404312, -0.00406582, -0.00408792, -0.00410942,
  -0.00413031, -0.00415059, -0.00417027, -0.00418933, -0.00420777,
  -0.00422559, -0.00424279, -0.00425936, -0.0042753, -0.00429061,
  -0.00430529, -0.00431933, -0.00433272, -0.00434548, -0.00435759,
  -0.00436906, -0.00437987, -0.00439004, -0.00439955, -0.00440841,
  -0.00441662, -0.00442416, -0.00443105, -0.00443727, -0.00444284,
  -0.00444774, -0.00445197, -0.00445554, -0.00445845, -0.00446068,
  -0.00446225, -0.00446315, -0.00446338, -0.00446295, -0.00446184,
  -0.00446006, -0.00445761, -0.00445449, -0.0044507, -0.00444624,
  -0.00444111, -0.00443531, -0.00442884, -0.00442171, -0.0044139,
  -0.00440543, -0.00439629, -0.00438649, -0.00437602, -0.00436489,
  -0.0043531, -0.00434065, -0.00432754, -0.00431377, -0.00429934,
  -0.00428426, -0.00426853, -0.00425215, -0.00423512, -0.00421745,
  -0.00419913, -0.00418017, -0.00416058, -0.00414034, -0.00411948,
  -0.00409798, -0.00407585, -0.0040531, -0.00402973, -0.00400574,
  -0.00398114, -0.00395592, -0.0039301, -0.00390367, -0.00387664,
  -0.00384901, -0.00382079, -0.00379198, -0.00376258, -0.0037326,
  -0.00370205, -0.00367092, -0.00363923, -0.00360697, -0.00357415,
  -0.00354078, -0.00350686, -0.0034724, -0.00343739, -0.00340185,
  -0.00336579, -0.00332919, -0.00329208, -0.00325446, -0.00321633,
  -0.00317769, -0.00313856, -0.00309894, -0.00305884, -0.00301825,
  -0.0029772, -0.00293567, -0.00289369, -0.00285125, -0.00280837,
  -0.00276504, -0.00272128, -0.00267709, -0.00263248, -0.00258745,
  -0.00254202, -0.00249618, -0.00244995, -0.00240334, -0.00235634,
  -0.00230897, -0.00226123, -0.00221314, -0.0021647, -0.00211591,
  -0.00206679, -0.00201734, -0.00196756, -0.00191748, -0.00186709,
  -0.0018164, -0.00176542, -0.00171417, -0.00166263, -0.00161084,
  -0.00155878, -0.00150647, -0.00145393, -0.00140115, -0.00134815,
  -0.00129493, -0.0012415, -0.00118787, -0.00113405, -0.00108005,
  -0.00102588, -0.00097154, -0.000917043, -0.000862399, -0.000807616,
  -0.000752702, -0.000697667, -0.000642518, -0.000587266,
  -0.000531919, -0.000476485, -0.000420974, -0.000365394,
  -0.000309756, -0.000254067, -0.000198336, -0.000142573,
  -8.67873e-05, -3.09871e-05, 2.48182e-05, 8.06195e-05, 0.000136408,
  0.000192173, 0.000247908, 0.000303602, 0.000359246, 0.000414831,
  0.000470348, 0.000525788, 0.000581142, 0.0006364, 0.000691553,
  0.000746592, 0.000801509, 0.000856293, 0.000910936, 0.000965429,
  0.00101976, 0.00107393, 0.00112791, 0.00118171, 0.00123532,
  0.00128871, 0.0013419, 0.00139486, 0.00144759, 0.00150008,
  0.00155232, 0.0016043, 0.00165602, 0.00170745, 0.0017586,
  0.00180946, 0.00186002, 0.00191026, 0.00196019, 0.00200978,
  0.00205904, 0.00210795, 0.00215651, 0.00220471, 0.00225253,
  0.00229998, 0.00234704, 0.0023937, 0.00243996, 0.0024858,
  0.00253123, 0.00257623, 0.00262079, 0.00266491, 0.00270857,
  0.00275178, 0.00279452, 0.00283678, 0.00287856, 0.00291985,
  0.00296065, 0.00300094, 0.00304072, 0.00307997, 0.00311871,
  0.00315691, 0.00319456, 0.00323168, 0.00326823, 0.00330423,
  0.00333966, 0.00337452, 0.00340879, 0.00344248, 0.00347558,
  0.00350808, 0.00353997, 0.00357125, 0.00360191, 0.00363196,
  0.00366137, 0.00369015, 0.00371829, 0.00374578, 0.00377263,
  0.00379882, 0.00382435, 0.00384921, 0.0038734, 0.00389692,
  0.00391976, 0.00394191, 0.00396338, 0.00398415, 0.00400423,
  0.0040236, 0.00404227, 0.00406023, 0.00407748, 0.00409401,
  0.00410982, 0.00412491, 0.00413927, 0.00415291, 0.00416581,
  0.00417797, 0.0041894, 0.00420008, 0.00421002, 0.00421922,
  0.00422767, 0.00423536, 0.00424231, 0.0042485, 0.00425394,
  0.00425862, 0.00426254, 0.0042657, 0.0042681, 0.00426974,
  0.00427061, 0.00427072, 0.00427006, 0.00426864, 0.00426646,
  0.00426351, 0.00425979, 0.00425531, 0.00425006, 0.00424404,
  0.00423726, 0.00422972, 0.00422141, 0.00421234, 0.00420251,
  0.00419191, 0.00418056, 0.00416845, 0.00415558, 0.00414196,
  0.00412758, 0.00411246, 0.00409658, 0.00407996, 0.00406259,
  0.00404449, 0.00402564, 0.00400605, 0.00398574, 0.00396469,
  0.00394292, 0.00392042, 0.0038972, 0.00387327, 0.00384862,
  0.00382326, 0.0037972, 0.00377044, 0.00374298, 0.00371483, 0.003686,
  0.00365648, 0.00362628, 0.00359541, 0.00356387, 0.00353167,
  0.00349882, 0.00346531, 0.00343116, 0.00339636, 0.00336094,
  0.00332488, 0.00328821, 0.00325091, 0.00321301, 0.00317451,
  0.00313541, 0.00309572, 0.00305545, 0.00301461, 0.0029732,
  0.00293123, 0.0028887, 0.00284563, 0.00280202, 0.00275788,
  0.00271322, 0.00266804, 0.00262236, 0.00257618, 0.00252951,
  0.00248236, 0.00243474, 0.00238665, 0.00233811, 0.00228912,
  0.0022397, 0.00218984, 0.00213957, 0.00208888, 0.0020378,
  0.00198632, 0.00193447, 0.00188224, 0.00182965, 0.0017767,
  0.00172341, 0.00166979, 0.00161585, 0.0015616, 0.00150704,
  0.00145219, 0.00139706, 0.00134165, 0.00128599, 0.00123008,
  0.00117392, 0.00111754, 0.00106094, 0.00100413, 0.000947131,
  0.000889942, 0.000832579, 0.000775053, 0.000717375, 0.000659556,
  0.000601607, 0.00054354, 0.000485365, 0.000427095, 0.000368741,
  0.000310314, 0.000251826, 0.000193287, 0.000134711, 7.61078e-05,
  1.74895e-05, -4.11322e-05, -9.97457e-05, -0.000158339, -0.000216901,
  -0.00027542, -0.000333884, -0.000392281, -0.000450599, -0.000508827,
  -0.000566953, -0.000624965, -0.000682852, -0.000740601,
  -0.000798201, -0.000855641, -0.000912907, -0.00096999, -0.00102688,
  -0.00108355, -0.00114001, -0.00119624, -0.00125223, -0.00130796,
  -0.00136342, -0.00141861, -0.00147351, -0.0015281, -0.00158239,
  -0.00163635, -0.00168998, -0.00174326, -0.00179618, -0.00184873,
  -0.00190091, -0.00195269, -0.00200408, -0.00205504, -0.00210559,
  -0.0021557, -0.00220536, -0.00225457, -0.00230331, -0.00235157,
  -0.00239935, -0.00244662, -0.00249339, -0.00253964, -0.00258536,
  -0.00263054, -0.00267517, -0.00271924, -0.00276274, -0.00280566,
  -0.00284799, -0.00288972, -0.00293085, -0.00297136, -0.00301125,
  -0.00305049, -0.0030891, -0.00312705, -0.00316434, -0.00320096,
  -0.0032369, -0.00327216, -0.00330671, -0.00334057, -0.00337371,
  -0.00340614, -0.00343783, -0.0034688, -0.00349902, -0.00352849,
  -0.0035572, -0.00358515, -0.00361233, -0.00363874, -0.00366436,
  -0.00368919, -0.00371322, -0.00373646, -0.00375888, -0.00378049,
  -0.00380128, -0.00382125, -0.00384038, -0.00385868, -0.00387614,
  -0.00389276, -0.00390852, -0.00392344, -0.00393749, -0.00395068,
  -0.00396301, -0.00397446, -0.00398505, -0.00399475, -0.00400358,
  -0.00401152, -0.00401858, -0.00402475, -0.00403004, -0.00403442,
  -0.00403792, -0.00404051, -0.00404221, -0.00404301, -0.00404291,
  -0.00404191, -0.00404001, -0.0040372, -0.00403349, -0.00402887,
  -0.00402336, -0.00401693, -0.00400961, -0.00400138, -0.00399225,
  -0.00398222, -0.00397129, -0.00395947, -0.00394674, -0.00393313,
  -0.00391861, -0.00390321, -0.00388692, -0.00386975, -0.00385169,
  -0.00383276, -0.00381294, -0.00379226, -0.0037707, -0.00374828,
  -0.003725, -0.00370087, -0.00367588, -0.00365004, -0.00362337,
  -0.00359585, -0.0035675, -0.00353833, -0.00350833, -0.00347752,
  -0.00344591, -0.00341349, -0.00338027, -0.00334627, -0.00331148,
  -0.00327592, -0.00323959, -0.0032025, -0.00316466, -0.00312608,
  -0.00308676, -0.00304672, -0.00300595, -0.00296447, -0.0029223,
  -0.00287943, -0.00283587, -0.00279165, -0.00274676, -0.00270122,
  -0.00265503, -0.00260821, -0.00256076, -0.00251271, -0.00246405,
  -0.0024148, -0.00236497, -0.00231457, -0.00226361, -0.00221211,
  -0.00216008, -0.00210752, -0.00205445, -0.00200088, -0.00194683,
  -0.00189231, -0.00183732, -0.00178189, -0.00172602, -0.00166973,
  -0.00161303, -0.00155594, -0.00149847, -0.00144063, -0.00138243,
  -0.00132389, -0.00126503, -0.00120585, -0.00114638, -0.00108662,
  -0.0010266, -0.000966315, -0.000905793, -0.000845046, -0.000784088,
  -0.000722935, -0.000661601, -0.000600102, -0.000538452,
  -0.000476667, -0.000414763, -0.000352754, -0.000290656,
  -0.000228484, -0.000166256, -0.000103984, -4.16871e-05, 2.06209e-05,
  8.29237e-05, 0.000145205, 0.00020745, 0.000269642, 0.000331765,
  0.000393804, 0.000455741, 0.000517562, 0.000579249, 0.000640788,
  0.000702162, 0.000763355, 0.00082435, 0.000885133, 0.000945686,
  0.00100599, 0.00106604, 0.00112581, 0.00118529, 0.00124445,
  0.0013033, 0.0013618, 0.00141994, 0.00147772, 0.0015351, 0.00159208,
  0.00164864, 0.00170477, 0.00176044, 0.00181565, 0.00187038,
  0.00192461, 0.00197834, 0.00203153, 0.00208418, 0.00213628,
  0.0021878, 0.00223874, 0.00228908, 0.00233881, 0.00238791,
  0.00243636, 0.00248416, 0.00253128, 0.00257772, 0.00262346,
  0.00266849, 0.0027128, 0.00275637, 0.00279918, 0.00284123,
  0.00288251, 0.00292299, 0.00296268, 0.00300155, 0.00303959,
  0.0030768, 0.00311316, 0.00314866, 0.00318329, 0.00321703,
  0.00324988, 0.00328183, 0.00331287, 0.00334298, 0.00337215,
  0.00340039, 0.00342767, 0.00345399, 0.00347934, 0.0035037,
  0.00352708, 0.00354947, 0.00357085, 0.00359122, 0.00361057,
  0.00362889, 0.00364618, 0.00366244, 0.00367764, 0.00369179,
  0.00370489, 0.00371692, 0.00372789, 0.00373778, 0.00374659,
  0.00375432, 0.00376097, 0.00376653, 0.00377099, 0.00377435,
  0.00377662, 0.00377779, 0.00377785, 0.00377681, 0.00377466,
  0.0037714, 0.00376703, 0.00376155, 0.00375497, 0.00374727,
  0.00373846, 0.00372855, 0.00371753, 0.0037054, 0.00369217,
  0.00367783, 0.0036624, 0.00364586, 0.00362824, 0.00360952,
  0.00358972, 0.00356883, 0.00354687, 0.00352383, 0.00349972,
  0.00347455, 0.00344833, 0.00342105, 0.00339273, 0.00336337,
  0.00333298, 0.00330157, 0.00326914, 0.00323571, 0.00320127,
  0.00316585, 0.00312945, 0.00309208, 0.00305374, 0.00301446,
  0.00297424, 0.00293308, 0.00289101, 0.00284804, 0.00280416,
  0.00275941, 0.00271379, 0.00266731, 0.00261998, 0.00257183,
  0.00252286, 0.00247308, 0.00242252, 0.00237119, 0.00231909,
  0.00226626, 0.00221269, 0.00215842, 0.00210345, 0.0020478,
  0.00199149, 0.00193453, 0.00187694, 0.00181875, 0.00175996,
  0.0017006, 0.00164068, 0.00158022, 0.00151924, 0.00145777,
  0.00139581, 0.0013334, 0.00127054, 0.00120726, 0.00114358,
  0.00107952, 0.0010151, 0.000950339, 0.000885262, 0.000819888,
  0.000754238, 0.000688334, 0.000622199, 0.000555853, 0.000489318,
  0.000422618, 0.000355774, 0.000288809, 0.000221746, 0.000154606,
  8.74138e-05, 2.01915e-05, -4.70377e-05, -0.000114251, -0.000181424,
  -0.000248535, -0.000315559, -0.000382473, -0.000449255,
  -0.000515879, -0.000582323, -0.000648563, -0.000714575,
  -0.000780335, -0.00084582, -0.000911006, -0.00097587, -0.00104039,
  -0.00110453, -0.00116829, -0.00123162, -0.00129452, -0.00135695,
  -0.00141889, -0.00148033, -0.00154122, -0.00160156, -0.00166132,
  -0.00172048, -0.00177901, -0.00183689, -0.0018941, -0.00195062,
  -0.00200642, -0.00206148, -0.00211578, -0.0021693, -0.00222201,
  -0.0022739, -0.00232495, -0.00237512, -0.00242441, -0.00247279,
  -0.00252025, -0.00256675, -0.00261229, -0.00265684, -0.00270038,
  -0.0027429, -0.00278438, -0.00282479, -0.00286413, -0.00290236,
  -0.00293948, -0.00297548, -0.00301032, -0.003044, -0.0030765,
  -0.0031078, -0.0031379, -0.00316677, -0.0031944, -0.00322078,
  -0.0032459, -0.00326973, -0.00329228, -0.00331352, -0.00333345,
  -0.00335205, -0.00336932, -0.00338523, -0.0033998, -0.003413,
  -0.00342482, -0.00343527, -0.00344432, -0.00345198, -0.00345823,
  -0.00346308, -0.00346651, -0.00346853, -0.00346911, -0.00346828,
  -0.00346601, -0.00346231, -0.00345717, -0.0034506, -0.00344259,
  -0.00343314, -0.00342225, -0.00340993, -0.00339617, -0.00338098,
  -0.00336436, -0.00334631, -0.00332684, -0.00330596, -0.00328366,
  -0.00325995, -0.00323484, -0.00320834, -0.00318045, -0.00315119,
  -0.00312055, -0.00308856, -0.00305522, -0.00302055, -0.00298455,
  -0.00294723, -0.00290862, -0.00286872, -0.00282754, -0.00278511,
  -0.00274144, -0.00269654, -0.00265043, -0.00260313, -0.00255466,
  -0.00250503, -0.00245427, -0.00240239, -0.00234942, -0.00229537,
  -0.00224027, -0.00218414, -0.002127, -0.00206888, -0.0020098,
  -0.00194978, -0.00188886, -0.00182705, -0.00176439, -0.00170089,
  -0.0016366, -0.00157153, -0.00150571, -0.00143918, -0.00137196,
  -0.00130408, -0.00123558, -0.00116648, -0.00109682, -0.00102663,
  -0.00095594, -0.000884784, -0.000813195, -0.000741207, -0.000668855,
  -0.000596173, -0.000523196, -0.000449959, -0.000376498, -0.00030285,
  -0.000229049, -0.000155134, -8.11397e-05, -7.10478e-06, 6.69338e-05,
  0.000140938, 0.000214871, 0.000288694, 0.000362368, 0.000435856,
  0.000509119, 0.000582117, 0.000654813, 0.000727167, 0.00079914,
  0.000870694, 0.000941788, 0.00101238, 0.00108244, 0.00115193,
  0.0012208, 0.00128901, 0.00135653, 0.00142332, 0.00148934,
  0.00155455, 0.00161891, 0.00168239, 0.00174494, 0.00180653,
  0.00186713, 0.00192669, 0.00198518, 0.00204255, 0.00209879,
  0.00215384, 0.00220768, 0.00226027, 0.00231158, 0.00236156,
  0.0024102, 0.00245745, 0.00250328, 0.00254766, 0.00259057,
  0.00263196, 0.00267182, 0.0027101, 0.00274679, 0.00278185,
  0.00281527, 0.002847, 0.00287703, 0.00290533, 0.00293188,
  0.00295666, 0.00297964, 0.0030008, 0.00302013, 0.0030376,
  0.00305319, 0.0030669, 0.0030787, 0.00308857, 0.00309651, 0.0031025,
  0.00310653, 0.0031086, 0.00310868, 0.00310677, 0.00310287,
  0.00309696, 0.00308905, 0.00307914, 0.00306721, 0.00305328,
  0.00303733, 0.00301938, 0.00299942, 0.00297746, 0.00295351,
  0.00292757, 0.00289966, 0.00286977, 0.00283794, 0.00280416,
  0.00276846, 0.00273085, 0.00269134, 0.00264996, 0.00260672,
  0.00256166, 0.00251478, 0.00246613, 0.00241571, 0.00236357,
  0.00230973, 0.00225423, 0.00219708, 0.00213834, 0.00207803,
  0.00201619, 0.00195286, 0.00188808, 0.00182189, 0.00175434,
  0.00168546, 0.00161531, 0.00154393, 0.00147136, 0.00139767,
  0.0013229, 0.0012471, 0.00117033, 0.00109264, 0.00101409,
  0.000934735, 0.000854638, 0.000773857, 0.000692453, 0.00061049,
  0.00052803, 0.000445139, 0.000361883, 0.000278327, 0.000194541,
  0.000110593, 2.65515e-05, -5.75118e-05, -0.000141526, -0.00022542,
  -0.000309119, -0.000392552, -0.000475644, -0.000558321,
  -0.000640508, -0.000722128, -0.000803108, -0.00088337, -0.000962838,
  -0.00104144, -0.00111909, -0.00119572, -0.00127124, -0.0013456,
  -0.00141869, -0.00149046, -0.00156083, -0.00162971, -0.00169704,
  -0.00176274, -0.00182674, -0.00188895, -0.00194932, -0.00200777,
  -0.00206423, -0.00211863, -0.0021709, -0.00222098, -0.0022688,
  -0.00231429, -0.00235739, -0.00239804, -0.00243619, -0.00247177,
  -0.00250473, -0.00253501, -0.00256257, -0.00258735, -0.00260931,
  -0.0026284, -0.00264459, -0.00265782, -0.00266807, -0.00267531,
  -0.00267949, -0.00268059, -0.00267859, -0.00267347, -0.0026652,
  -0.00265378, -0.00263919, -0.00262142, -0.00260047, -0.00257634,
  -0.00254904, -0.00251856, -0.00248493, -0.00244816, -0.00240827,
  -0.00236528, -0.00231923, -0.00227015, -0.00221806, -0.00216303,
  -0.00210509, -0.00204431, -0.00198072, -0.0019144, -0.00184542,
  -0.00177385, -0.00169975, -0.00162323, -0.00154435, -0.00146323,
  -0.00137994, -0.0012946, -0.00120731, -0.00111819, -0.00102735,
  -0.000934919, -0.000841023, -0.000745795, -0.000649374,
  -0.000551902, -0.000453527, -0.000354403, -0.000254686,
  -0.000154539, -5.41272e-05, 4.63779e-05, 0.000146802, 0.000246965,
  0.000346686, 0.000445778, 0.000544051, 0.000641312, 0.000737365,
  0.000832011, 0.00092505, 0.00101628, 0.00110549, 0.00119248,
  0.00127704, 0.00135896, 0.00143803, 0.00151404, 0.00158679,
  0.00165607, 0.00172167, 0.00178339, 0.00184102, 0.00189437,
  0.00194325, 0.00198746, 0.00202682, 0.00206114, 0.00209027,
  0.00211403, 0.00213227, 0.00214483, 0.00215158, 0.0021524,
  0.00214716, 0.00213577, 0.00211813, 0.00209418, 0.00206385,
  0.0020271, 0.00198392, 0.00193429, 0.00187825, 0.00181584,
  0.00174711, 0.00167216, 0.00159111, 0.00150412, 0.00141135,
  0.00131301, 0.00120936, 0.00110068, 0.000987276, 0.000869515,
  0.000747798, 0.000622569, 0.00049432, 0.000363593, 0.000230979,
  9.71236e-05, -3.72699e-05, -0.000171441, -0.000304565, -0.000435756,
  -0.000564058, -0.000688445, -0.000807817, -0.000920997, -0.00102673,
  -0.00112367, -0.00121039, -0.00128537, -0.00134701, -0.00139357,
  -0.00142325, -0.00143413, -0.00142417, -0.00139121, -0.001333,
  -0.00124713, -0.00113108, -0.000982186, -0.000797653, -0.000574534,
  -0.000309734, 1.43413e-16}; 
