/*
 * Decompiled with CFR 0.152.
 */
package GPE;

import GPE.AbstractGPEFrame;
import GPE.ParticleCell;
import GPE.ParticleItem;
import GPE.PhysicsFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class HadParticlesTable
extends AbstractGPEFrame
implements ActionListener {
    private ParticleCell[] parcel;
    PhysicsFrame phyFrame;
    JButton appendButton;
    JButton insertButton;
    JButton closeTableButton;
    private Color buttonColor;

    HadParticlesTable(PhysicsFrame phyFrame) {
        super("Particles Table");
        this.phyFrame = phyFrame;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.buttonColor = new Color(230, 200, 140);
        int[] elemPosX = new int[]{0, 1, 2, 1, 2, 3, 4, 5, 6, 0, 1, 2, 3, 4, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5};
        int[] elemPosY = new int[]{0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5};
        ParticleItem[] pari = this.makeParticle();
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.parcel = new ParticleCell[pari.length];
        JLabel columnLabel = new JLabel("Particle(s) ==>", 0);
        columnLabel.setFont(new Font("Serif", 1, 12));
        JLabel tableLabel = new JLabel("ThisTable ==>", 0);
        tableLabel.setFont(new Font("Serif", 1, 12));
        this.appendButton = new JButton("Append");
        this.appendButton.setBackground(Color.green);
        this.insertButton = new JButton("Insert");
        this.insertButton.setBackground(Color.green);
        this.closeTableButton = new JButton("CloseTable");
        this.closeTableButton.setBackground(Color.yellow);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 5));
        buttonPanel.setBackground(new Color(230, 250, 230));
        buttonPanel.add(columnLabel);
        buttonPanel.add(this.appendButton);
        buttonPanel.add(this.insertButton);
        buttonPanel.add(tableLabel);
        buttonPanel.add(this.closeTableButton);
        JPanel tablePanel = new JPanel();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(1, 1));
        mainPanel.add((Component)buttonPanel, "North");
        mainPanel.add((Component)tablePanel, "Center");
        tablePanel.setLayout(gbl);
        tablePanel.setBackground(new Color(100, 250, 230));
        this.appendButton.addActionListener(this);
        this.insertButton.addActionListener(this);
        this.closeTableButton.addActionListener(this);
        for (int i = 0; i < pari.length; ++i) {
            gbc.gridx = elemPosX[i];
            gbc.gridy = elemPosY[i];
            this.parcel[i] = new ParticleCell(pari[i]);
            gbl.setConstraints(this.parcel[i], gbc);
            tablePanel.add(this.parcel[i]);
            this.add(mainPanel);
        }
        this.setSize(830, 180);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.appendButton) {
            this.phyFrame.appendHadParticle();
        } else if (e.getSource() == this.insertButton) {
            this.phyFrame.insertHadParticle();
        } else if (e.getSource() == this.closeTableButton) {
            this.setVisible(false);
            this.phyFrame.phyHadTable.createMatCloseAct();
            this.getSelectedElements();
        }
    }

    ParticleItem[] getSelectedElements() {
        int k = 0;
        if (ParticleCell.selectedElems == 0) {
            return null;
        }
        ParticleItem[] parItem = new ParticleItem[ParticleCell.selectedElems];
        for (int i = 0; i < this.parcel.length; ++i) {
            if (!this.parcel[i].isSelected()) continue;
            parItem[k] = this.parcel[i].parItem;
            this.parcel[i].clear();
            ++k;
        }
        return parItem;
    }

    ParticleItem[] makeParticle() {
        ParticleItem[] pari = new ParticleItem[]{new ParticleItem("all_mesons", "all mesons"), new ParticleItem("pi+", "\u03c0+"), new ParticleItem("pi-", "\u03c0-"), new ParticleItem("kaon+", "K+"), new ParticleItem("kaon-", "K-"), new ParticleItem("kaon0", "K0"), new ParticleItem("kaon0S", "K0S"), new ParticleItem("kaon0L", "K0L"), new ParticleItem("anti_kaon0", "anti-K0"), new ParticleItem("all_baryons", "all baryons"), new ParticleItem("proton", "p"), new ParticleItem("neutron", "n"), new ParticleItem("anti_proton", "anti-p"), new ParticleItem("anti_neutron", "anti-n"), new ParticleItem("lambda", "\u039b"), new ParticleItem("sigma+", "\u03a3+"), new ParticleItem("sigma0", "\u03a30"), new ParticleItem("sigma-", "\u03a3-"), new ParticleItem("xi0", "\u039e0"), new ParticleItem("xi-", "\u039e-"), new ParticleItem("omega-", "\u03a9-"), new ParticleItem("anti_lambda", "anti-\u039b"), new ParticleItem("anti_sigma+", "anti-\u03a3+"), new ParticleItem("anti_sigma0", "anti-\u03a30"), new ParticleItem("anti_sigma-", "anti-\u03a3-"), new ParticleItem("anti_xi0", "anti-\u039e0"), new ParticleItem("anti_xi-", "anti-\u039e-"), new ParticleItem("anti_omega-", "anti-\u03a9-"), new ParticleItem("all_ions", "all ions"), new ParticleItem("alpha", "\u03b1"), new ParticleItem("deuteron", "d"), new ParticleItem("He3", "He3"), new ParticleItem("triton", "triton"), new ParticleItem("GenericIon", "GenericIon")};
        return pari;
    }
}

