// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef HEPREP_HEPREPDEFINITION_H
#define HEPREP_HEPREPDEFINITION_H 1

// Copyright 2000-2005, FreeHEP.

#include <set>
#include <string>

#include "HEPREP/HepRepAttribute.h"

namespace HEPREP {

class HepRepAttDef;

/**
 * HepRepDefinition interface.
 *
 * @author Mark Donszelmann
 *
 */
class HepRepDefinition : virtual public HepRepAttribute {

public: 
    /// Destructor.
    virtual ~HepRepDefinition() { /* nop */; }

    /**
     * Adds an attdef.
     *
     * @param name name of the definition.
     * @param desc description of the definition.
     * @param category category of the definition.
     * @param extra extra info of the definition.
     */
    virtual void addAttDef(std::string name, std::string desc, std::string category, std::string extra) = 0;

    /**
     * Adds an attdef.
     *
     * @param attDef to be added.
     */
    virtual void addAttDef(HepRepAttDef * attDef) = 0;

    /**
     * Return a named attribute definition searched on this node and any parent nodes.
     *
     * @param name of attribute definition.
     * @return attribute definition.
     */
    virtual HepRepAttDef * getAttDef(std::string name) = 0;

    /**
     * Returns a collection of all attribute definitions defined on this node.
     *
     * @return collection of attributes definitions.
     */
    virtual std::set<HepRepAttDef *>  getAttDefsFromNode() = 0;

    /**
     * Returns a named attribute definition defined on this node.
     *
     * @param lowerCaseName name of the attribute in lower case.
     * @return attribute definition.
     */
    virtual HepRepAttDef * getAttDefFromNode(std::string lowerCaseName) = 0;
}; // class
} // namespace HEPREP
#endif /* ifndef HEPREP_HEPREPDEFINITION_H */
