//$Id: HadronProcessesTable.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
//HadronicProcess table
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//



package GPE;



import java.awt.*;



import java.awt.event.*;



import javax.swing.*;



import javax.swing.table.*;



import javax.swing.event.*;



import java.util.*;







class HadronProcessesTable extends AbstractGPEFrame implements ActionListener {



    private ProcessCell procel[];



    PhysicsFrame phyFrame;







    JButton changeProcessButton, closeTableButton;







    HadronProcessesTable(PhysicsFrame phyFrame){



        super("HadronicProcesses Table");



        this.phyFrame = phyFrame;



        GridBagLayout gbl = new GridBagLayout();



        GridBagConstraints gbc = new GridBagConstraints();



        //getContentPane().setLayout(gbl);



        //getContentPane().setBackground(new Color(230, 250, 230));







        int proPosX[] = {1, 2, 3, 4, 5, 6,



			 1, 2, 3, 4, 5, 6, 7, 8,



                         1, 2, 3, 4, 5, 6, 7, 8,



                         1, 2, 3,



                         1, 2,



                         1,



			 1,2,3,4,5,6,7



                         };







        int proPosY[] = {0, 0, 0, 0, 0, 0,



			 1, 1, 1, 1, 1, 1, 1, 1,



                         2, 2, 2, 2, 2, 2, 2, 2,



                         3, 3, 3,



                         4, 4,



                         5,



                         6, 6, 6, 6, 6, 6, 6,



                         };







        ProcessItem proi[] = makeProcess();



        gbc.insets = new Insets(1, 1, 1, 1);



        gbc.fill = GridBagConstraints.BOTH;



        gbc.weightx = 1.0; gbc.weighty = 1.0;



        procel = new ProcessCell[proi.length];











	//Color buttonColor = new Color(255, 140, 140);



       changeProcessButton = new JButton("Change Process");



         changeProcessButton.setBackground(Color.green);



       closeTableButton = new JButton("CloseTable");



         closeTableButton.setBackground(Color.yellow); 







       JPanel buttonPanel = new JPanel();



         buttonPanel.setLayout(new GridLayout(1, 2));



         buttonPanel.setBackground(new Color(230, 250, 230));



         buttonPanel.add(changeProcessButton);



         buttonPanel.add(closeTableButton);



       JPanel tablePanel = new JPanel();



       JPanel mainPanel = new JPanel();



         mainPanel.setLayout(new BorderLayout(1, 1));



         mainPanel.add(buttonPanel, "North");



         mainPanel.add(tablePanel, "Center");



         tablePanel.setLayout(gbl);



	 //         tablePanel.setBackground(new Color(230, 250, 230));



         tablePanel.setBackground(new Color(225, 235, 100));







       changeProcessButton.addActionListener(this);



       closeTableButton.addActionListener(this);











        for(int i = 0; i<proi.length; i++){



            gbc.gridx = proPosX[i]; gbc.gridy = proPosY[i];



            procel[i] = new ProcessCell(proi[i]);



            gbl.setConstraints(procel[i], gbc); tablePanel.add(procel[i]);



	}







          Color lightred = new Color(255, 200, 200);



          Color brightred = new Color(255, 190, 190);







	/*



        JLabel l00 = new JLabel("Models", JLabel.CENTER);



          gbc.gridx = 0; gbc.gridy = 0;



          gbl.setConstraints(l00, gbc); tablePanel.add(l00);



          l00.setOpaque(true); 



          l00.setBackground(brightred);



          l00.setFont(new Font("Serif", Font.BOLD, 12)); 







        JLabel l10 = new JLabel("low energy", JLabel.CENTER);



          gbc.gridx = 1; gbc.gridy = 0;



          gbl.setConstraints(l10, gbc); tablePanel.add(l10);



          l10.setOpaque(true); 



          l10.setBackground(brightred);



          l10.setFont(new Font("Serif", Font.BOLD, 12)); 







        JLabel l20 = new JLabel("high energy", JLabel.CENTER);



          gbc.gridx = 2; gbc.gridy = 0;



          gbl.setConstraints(l20, gbc); tablePanel.add(l20);



          l20.setOpaque(true); 



          l20.setBackground(brightred);



          l20.setFont(new Font("Serif", Font.BOLD, 12)); 







        JLabel l30 = new JLabel("neutron hp", JLabel.CENTER);



          gbc.gridx = 3; gbc.gridy = 0;



          gbl.setConstraints(l30, gbc); tablePanel.add(l30);



          l30.setOpaque(true); 



          l30.setBackground(brightred);



          l30.setFont(new Font("Serif", Font.BOLD, 12)); 







        JLabel l40 = new JLabel("string", JLabel.CENTER);



          gbc.gridx = 4; gbc.gridy = 0;



          gbl.setConstraints(l40, gbc); tablePanel.add(l40);



          l40.setOpaque(true); 



          l40.setBackground(brightred);



          l40.setFont(new Font("Serif", Font.BOLD, 12)); 















        JLabel l01 = new JLabel("Proc. default", JLabel.CENTER);



          gbc.gridx = 0; gbc.gridy = 1;



          gbl.setConstraints(l01, gbc); tablePanel.add(l01);



          l01.setOpaque(true); 



          l01.setBackground(brightred);



          l01.setFont(new Font("Serif", Font.BOLD, 12)); 



	*/







        JLabel l02 = new JLabel("Inelastic of", JLabel.CENTER);



          gbc.gridx = 0; gbc.gridy = 0;



          gbl.setConstraints(l02, gbc); tablePanel.add(l02);



          l02.setOpaque(true); 



          l02.setBackground(brightred);



          l02.setFont(new Font("Serif", Font.BOLD, 12)); 















        JLabel l06 = new JLabel("neutron-induced", JLabel.CENTER);



          gbc.gridx = 0; gbc.gridy = 4;



          gbl.setConstraints(l06, gbc); tablePanel.add(l06);



          l06.setOpaque(true); 



          l06.setBackground(lightred);



          l06.setFont(new Font("Serif", Font.BOLD, 12)); 











        JLabel l07 = new JLabel("all hadrons/ions", JLabel.CENTER);



          gbc.gridx = 0; gbc.gridy = 5;



          gbl.setConstraints(l07, gbc); tablePanel.add(l07);



          l07.setOpaque(true); 



          l07.setBackground(lightred);



          l07.setFont(new Font("Serif", Font.BOLD, 12)); 







        JLabel l08 = new JLabel("Stopping", JLabel.CENTER);



          gbc.gridx = 0; gbc.gridy = 6;



          gbl.setConstraints(l08, gbc); tablePanel.add(l08);



          l08.setOpaque(true); 



          l08.setBackground(lightred);



          l08.setFont(new Font("Serif", Font.BOLD, 12)); 







        setSize(850, 180);



        //setResizable(false);







        add(mainPanel);



    }







    public void actionPerformed(ActionEvent e) {







        if (e.getSource() == changeProcessButton) {



            phyFrame.changeHadronProcess();







	}else if (e.getSource() == closeTableButton) {



	    this.setVisible(false);



            phyFrame.phyHadTable.openHProcButtonCloseAct();            







            getSelectedProcess();



	}



    }  







    ProcessItem[] getSelectedProcess(){



        int k = 0;



        if(ProcessCell.selectedProc == 0) return null;



            ProcessItem pi[] = new ProcessItem[ProcessCell.selectedProc];



            for(int i=0; i<procel.length; i++){



                if(procel[i].isSelected()){



                     pi[k] = procel[i].pi;



                     procel[i].clear();



                     k++;



		}



	    }



            return pi;



    }







    ProcessItem[] makeProcess(){



      ProcessItem proi[] = new ProcessItem[35];







        //proi[0] = new ProcessItem("", "Null", "Null", "", "", "", "");







	



        proi[0] = new ProcessItem("G4PionMinusInelasticProcess", 



                  "PionMinusInelastic", "\u03C0- inel", "model?", "ordInActive",



                  "ordInActive", "ordDefault");







        proi[1] = new ProcessItem("G4PionPlusInelasticProcess",



                   "PionPlusInelastic", "\u03C0+ inel", "model?", "ordInActive",



                   "ordInActive", "ordDefault");    







        proi[2] = new ProcessItem("G4KaonMinusInelasticProcess", 



                  "KaonMinusInelastic", "K- inel", "model?", "ordInActive", 



                  "ordInActive", "ordDefault");







        proi[3] = new ProcessItem("G4KaonPlusInelasticProcess",



                   "KaonPlusInelastic", "K+ inel", "model?", "ordInActive",



                   "ordInActive", "ordDefault");    







        proi[4] = new ProcessItem("G4KaonZeroLInelasticProcess", 



		      "KaonZeroLInelastic", "K0L inel", "model?", "ordInActive",



                      "ordInActive", "ordDefault");    







        proi[5] = new ProcessItem("G4KaonZeroSInelasticProcess", 



                  "KaonZeroSInelastic", "K0S inel", "model?", "ordInActive", 



                  "ordInActive", "ordDefault");







	//



        proi[6] = new ProcessItem("G4ProtonInelasticProcess",



                  "ProtonInelastic", "p inel", "model?", "ordInActive",



                  "ordInActive", "ordDefault");    







        proi[7] = new ProcessItem("G4NeutronInelasticProcess", 



                  "NeutronInelastic", "n inel", "model?", "ordInActive",



                  "ordInActive", "ordDefault");    







        proi[8] = new ProcessItem("G4LambdaInelasticProcess", 



                   "LambdaInelastic", "\u039B inel", "model?", "ordInActive",



                   "ordInActive", "ordDefault");    







        proi[9] = new ProcessItem("G4SigmaPlusInelasticProcess", 



                   "SigmaPlusInelastic", "\u03A3+ inel", "model?", "ordInActive",



                   "ordInActive", "ordDefault");    







        proi[10] = new ProcessItem("G4SigmaMinusInelasticProcess",



                   "SigmaMinusInelastic", "\u03A3- inel", "model?", 



                   "ordInActive", "ordInActive" ,"ordDefault");    







        proi[11] = new ProcessItem("G4XiZeroInelasticProcess",



                   "XiZeroInelastic", "\u039E0 inel", "model?",



                   "ordInActive", "ordInActive", "ordDefault"); 







        proi[12] = new ProcessItem("G4XiMinusInelasticProcess", 



                   "XiMinusInelastic", "\u039E- inel", "model?", "ordInActive", 



                   "ordInActive", "ordDefault"); 







        proi[13] = new ProcessItem("G4OmegaMinusInelasticProcess", 



                   "OmegaMinusInelastic", "\u03A9- inel", "model?", 



                   "ordInActive", "ordInActive", "ordDefault");    







	//











        proi[14] = new ProcessItem("G4AntiProtonInelasticProcess",



                   "anti_ProtonInelastic", "anti-p inel", "model?",



                   "ordInActive", "ordInActive", "ordDefault");    







        proi[15] = new ProcessItem("G4AntiNeutronInelasticProcess",



                   "anti_NeutronInelastic", "anti-n inel", "model?", 



                   "ordInActive", "ordInActive", "ordDefault");    







        proi[16] = new ProcessItem("G4AntiLambdaInelasticProcess", 



                   "anti_LambdaInelastic", "anti-\u039B inel", "model?", 



                   "ordInActive", "ordInActive", "ordDefault");    







        proi[17] = new ProcessItem("G4AntiSigmaPlusInelasticProcess",



                   "anti_SigmaPlusInelastic", "anti-\u03A3+ inel", "model?", 



                   "ordInActive", "ordInActive", "ordDefault");







        proi[18] = new ProcessItem("G4AntiSigmaMinusInelasticProcess",



                   "anti_SigmaMinusInelastic", "anti-\u03A3- inel", "model?", 



                   "ordInActive", "ordInActive", "ordDefault");    







        proi[19] = new ProcessItem("G4AntiXiZeroInelasticProcess", 



                   "anti_XiZeroInelastic", "anti-\u039E0 inel", "model?", 



                   "ordInActive", "ordInActive", "ordDefault");    







        proi[20] = new ProcessItem("G4AntiXiMinusInelasticProcess", 



                   "anti_XiMinusInelastic", "anti-\u039E- inel", "model?", 



                   "ordInActive", "ordInActive", "ordDefault");    







        proi[21] = new ProcessItem("G4AntiOmegaMinusInelasticProcess", 



                   "anti_OmegaMinusInelastic", "anti-\u03A9- inel", "model?", 



                   "ordInActive", "ordInActive", "ordDefault");    



	//











        proi[22] = new ProcessItem("G4AlphaInelasticProcess", "AlphaInelastic",



                   "\u03B1 inel", "model?", "ordInActive", "ordInActive", 



                   "ordDefault");    







        proi[23] = new ProcessItem("G4DeuteronInelasticProcess", 



                   "DeuteronInelastic", "d inel", "model?", "ordInActive",



                   "ordInActive", "ordDefault");    



	//



        proi[24] = new ProcessItem("G4TritonInelasticProcess", 



                   "TritonInelastic", "triton inel", "model?", "ordInActive", 



                   "ordInActive", "ordDefault");    







	//







        proi[25] = new ProcessItem("G4HadronCaptureProcess", "HadronCapture",



                   "capture", "model?", "ordInActive", 



                  "ordInActive", "ordDefault");    







        proi[26] = new ProcessItem("G4HadronFissionProcess", "HadronFission",



                   "fission", "model?", "ordInActive", "ordInActive", 



                   "ordDefault");    







	//











        proi[27] = new ProcessItem("G4HadronElasticProcess", "HadronElastic",



                   "elastic", "model?", "ordInActive", "ordInActive",



                   "ordDefault");    



	//







	



        proi[28] = new ProcessItem("G4PiMinusAbsorptionAtRest", 



                  "PiMinusAbsorptionAtRest", "\u03C0- absorp", "no model", 



		  "ordDefault", "ordInActive", "ordInActive");



	



        proi[29] = new ProcessItem("G4PionMinusAbsorptionAtRest", 



                  "PionMinusAbsorptionAtRest", "\u03C0- absorp", "no model", 



		  "ordDefault", "ordInActive","ordInActive");



	



        proi[30] = new ProcessItem("G4KaonMinusAbsorptionAtRest", 



                  "KaonMinusAbsorptionAtRest", "K- absorp", "no model", 



		  "ordDefault", "ordInActive","ordInActive");



	



        proi[31] = new ProcessItem("G4MuonMinusCaptureAtRest", 



                  "MuonMinusCaptureAtRest", "muon- capt", "no model", 



		  "ordDefault", "ordInActive","ordInActive");



	



        proi[32] = new ProcessItem("G4AntiProtonAnnihilationAtRest", 



                  "anti-p annih", "anti-p annih", "no model", 



		  "ordDefault", "ordInActive","ordInActive");



	



        proi[33] = new ProcessItem("G4NeutronCaptureAtRest", 



                  "NeutronCaptureAtRest", "n capt", "no model", 



		  "ordDefault", "ordInActive","ordInActive");



	



        proi[34] = new ProcessItem("G4AntiNeutronAnnihilationAtRest", 



                  "AntiNeutronAnnihilationAtRest", "anti-n annih", "no model", 



		  "ordDefault", "ordInActive","ordInActive");



	







        return proi;



    }



} 



